! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RADM2_Function.f90
! Time                 : Thu Oct  8 08:22:27 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RADM2_18938_BOXMOX
! Equation file        : RADM2.kpp
! Output root filename : RADM2
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RADM2_Function

  USE RADM2_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(59)
  A(2) = RCT(2)*V(46)
  A(3) = RCT(3)*V(46)
  A(4) = RCT(4)*V(13)
  A(5) = RCT(5)*V(25)
  A(6) = RCT(6)*V(20)
  A(7) = RCT(7)*V(54)
  A(8) = RCT(8)*V(54)
  A(9) = RCT(9)*V(14)
  A(10) = RCT(10)*V(43)
  A(11) = RCT(11)*V(43)
  A(12) = RCT(12)*V(48)
  A(13) = RCT(13)*V(21)
  A(14) = RCT(14)*V(42)
  A(15) = RCT(15)*V(18)
  A(16) = RCT(16)*V(33)
  A(17) = RCT(17)*V(31)
  A(18) = RCT(18)*V(31)
  A(19) = RCT(19)*V(34)
  A(20) = RCT(20)*V(30)
  A(21) = RCT(21)*V(47)
  A(22) = RCT(22)*V(19)*F(2)
  A(23) = RCT(23)*V(19)*V(59)
  A(24) = RCT(24)*V(7)*F(2)
  A(25) = RCT(25)*V(7)*F(1)
  A(26) = RCT(26)*V(46)*V(58)
  A(27) = RCT(27)*V(46)*V(53)
  A(28) = RCT(28)*V(46)*V(51)
  A(29) = RCT(29)*V(51)*V(58)
  A(30) = RCT(30)*V(51)*V(59)
  A(31) = RCT(31)*V(20)
  A(32) = RCT(32)*V(51)*V(51)
  A(33) = RCT(33)*V(51)*V(51)*F(1)
  A(34) = RCT(34)*V(14)*V(53)
  A(35) = RCT(35)*V(53)*V(58)
  A(36) = RCT(36)*V(58)*V(58)*F(2)
  A(37) = RCT(37)*V(46)*V(59)
  A(38) = RCT(38)*V(54)*V(58)
  A(39) = RCT(39)*V(54)*V(59)
  A(40) = RCT(40)*V(51)*V(54)
  A(41) = RCT(41)*V(54)*V(59)
  A(42) = RCT(42)*V(15)
  A(43) = RCT(43)*V(15)
  A(44) = RCT(44)*V(53)*V(59)
  A(45) = RCT(45)*V(25)*V(53)
  A(46) = RCT(46)*V(20)*V(53)
  A(47) = RCT(47)*V(51)*V(53)
  A(48) = RCT(48)*V(5)*V(53)
  A(49) = RCT(49)*V(26)*V(53)
  A(50) = RCT(50)*V(17)*V(53)
  A(51) = RCT(51)*V(6)*V(53)
  A(52) = RCT(52)*V(16)*V(53)
  A(53) = RCT(53)*V(8)*V(53)
  A(54) = RCT(54)*V(9)*V(53)
  A(55) = RCT(55)*V(24)*V(53)
  A(56) = RCT(56)*V(28)*V(53)
  A(57) = RCT(57)*V(29)*V(53)
  A(58) = RCT(58)*V(10)*V(53)
  A(59) = RCT(59)*V(11)*V(53)
  A(60) = RCT(60)*V(22)*V(53)
  A(61) = RCT(61)*V(43)*V(53)
  A(62) = RCT(62)*V(48)*V(53)
  A(63) = RCT(63)*V(33)*V(53)
  A(64) = RCT(64)*V(31)*V(53)
  A(65) = RCT(65)*V(34)*V(53)
  A(66) = RCT(66)*V(30)*V(53)
  A(67) = RCT(67)*V(21)*V(53)
  A(68) = RCT(68)*V(42)*V(53)
  A(69) = RCT(69)*V(18)*V(53)
  A(70) = RCT(70)*V(23)*V(53)
  A(71) = RCT(71)*V(47)*V(53)
  A(72) = RCT(72)*V(27)*V(53)
  A(73) = RCT(73)*V(55)*V(59)
  A(74) = RCT(74)*V(23)
  A(75) = RCT(75)*V(45)*V(59)
  A(76) = RCT(76)*V(12)
  A(77) = RCT(77)*V(52)*V(58)
  A(78) = RCT(78)*V(56)*V(58)
  A(79) = RCT(79)*V(41)*V(58)
  A(80) = RCT(80)*V(44)*V(58)
  A(81) = RCT(81)*V(40)*V(58)
  A(82) = RCT(82)*V(37)*V(58)
  A(83) = RCT(83)*V(49)*V(58)
  A(84) = RCT(84)*V(55)*V(58)
  A(85) = RCT(85)*V(45)*V(58)
  A(86) = RCT(86)*V(35)*V(58)
  A(87) = RCT(87)*V(36)*V(58)
  A(88) = RCT(88)*V(57)*V(58)
  A(89) = RCT(89)*V(50)*V(58)
  A(90) = RCT(90)*V(38)*V(58)
  A(91) = RCT(91)*V(43)*V(54)
  A(92) = RCT(92)*V(48)*V(54)
  A(93) = RCT(93)*V(31)*V(54)
  A(94) = RCT(94)*V(34)*V(54)
  A(95) = RCT(95)*V(30)*V(54)
  A(96) = RCT(96)*V(22)*V(54)
  A(97) = RCT(97)*V(24)*V(54)
  A(98) = RCT(98)*V(28)*V(54)
  A(99) = RCT(99)*V(29)*V(54)
  A(100) = RCT(100)*V(27)*V(54)
  A(101) = RCT(101)*V(24)*V(46)
  A(102) = RCT(102)*V(28)*V(46)
  A(103) = RCT(103)*V(29)*V(46)
  A(104) = RCT(104)*V(27)*V(46)
  A(105) = RCT(105)*V(51)*V(52)
  A(106) = RCT(106)*V(51)*V(57)
  A(107) = RCT(107)*V(51)*V(56)
  A(108) = RCT(108)*V(41)*V(51)
  A(109) = RCT(109)*V(44)*V(51)
  A(110) = RCT(110)*V(40)*V(51)
  A(111) = RCT(111)*V(37)*V(51)
  A(112) = RCT(112)*V(49)*V(51)
  A(113) = RCT(113)*V(50)*V(51)
  A(114) = RCT(114)*V(51)*V(55)
  A(115) = RCT(115)*V(35)*V(51)
  A(116) = RCT(116)*V(36)*V(51)
  A(117) = RCT(117)*V(45)*V(51)
  A(118) = RCT(118)*V(38)*V(51)
  A(119) = RCT(119)*V(52)*V(52)
  A(120) = RCT(120)*V(52)*V(57)
  A(121) = RCT(121)*V(52)*V(56)
  A(122) = RCT(122)*V(41)*V(52)
  A(123) = RCT(123)*V(44)*V(52)
  A(124) = RCT(124)*V(40)*V(52)
  A(125) = RCT(125)*V(37)*V(52)
  A(126) = RCT(126)*V(49)*V(52)
  A(127) = RCT(127)*V(50)*V(52)
  A(128) = RCT(128)*V(52)*V(55)
  A(129) = RCT(129)*V(35)*V(52)
  A(130) = RCT(130)*V(36)*V(52)
  A(131) = RCT(131)*V(45)*V(52)
  A(132) = RCT(132)*V(55)*V(57)
  A(133) = RCT(133)*V(55)*V(56)
  A(134) = RCT(134)*V(41)*V(55)
  A(135) = RCT(135)*V(44)*V(55)
  A(136) = RCT(136)*V(40)*V(55)
  A(137) = RCT(137)*V(37)*V(55)
  A(138) = RCT(138)*V(49)*V(55)
  A(139) = RCT(139)*V(50)*V(55)
  A(140) = RCT(140)*V(55)*V(55)
  A(141) = RCT(141)*V(35)*V(55)
  A(142) = RCT(142)*V(36)*V(55)
  A(143) = RCT(143)*V(45)*V(55)
  A(144) = RCT(144)*V(39)*V(51)
  A(145) = RCT(145)*V(39)*V(52)
  A(146) = RCT(146)*V(39)*V(55)
  A(147) = RCT(147)*V(39)*V(39)
  A(148) = RCT(148)*V(39)*V(58)
  A(149) = RCT(149)*V(32)*V(59)
  A(150) = RCT(150)*V(32)*V(51)
  A(151) = RCT(151)*V(32)*V(52)
  A(152) = RCT(152)*V(32)*V(55)
  A(153) = RCT(153)*V(32)*V(32)
  A(154) = RCT(154)*V(38)*V(52)
  A(155) = RCT(155)*V(38)*V(55)
  A(156) = RCT(156)*V(38)*V(38)

! Aggregate function
  Vdot(1) = A(48)
  Vdot(2) = 0.4*A(101)+0.2*A(102)+0.06*A(103)+0.2*A(104)
  Vdot(3) = 0.2*A(102)+0.29*A(103)+0.2*A(104)+0.5*A(128)+0.5*A(131)+0.5*A(132)+0.5*A(133)+0.5*A(134)+0.5*A(135)+0.5&
              &*A(136)+0.5*A(137)+0.5*A(138)+0.5*A(139)+0.5*A(155)
  Vdot(4) = A(49)
  Vdot(5) = -A(48)
  Vdot(6) = -A(51)
  Vdot(7) = A(2)-A(24)-A(25)
  Vdot(8) = -A(53)
  Vdot(9) = -A(54)
  Vdot(10) = -A(58)
  Vdot(11) = -A(59)
  Vdot(12) = A(75)-A(76)
  Vdot(13) = -A(4)+A(35)
  Vdot(14) = -A(9)+A(32)+A(33)-A(34)
  Vdot(15) = A(41)-A(42)-A(43)
  Vdot(16) = -A(52)
  Vdot(17) = -A(50)+0.06*A(102)+0.09*A(103)
  Vdot(18) = -A(15)-A(69)+A(114)
  Vdot(19) = A(1)+A(3)+A(8)-A(22)-A(23)+A(24)
  Vdot(20) = -A(6)+A(30)-A(31)-A(46)
  Vdot(21) = -A(13)-A(67)+A(105)
  Vdot(22) = 0.25*A(58)+0.17*A(59)-A(60)-0.5*A(96)
  Vdot(23) = -A(70)+A(73)-A(74)
  Vdot(24) = -A(55)-A(97)-A(101)
  Vdot(25) = -A(5)+A(40)+2*A(43)+A(44)-A(45)+A(91)+A(92)+A(93)+A(94)+A(95)+A(96)
  Vdot(26) = A(10)+A(11)+A(12)+1.87*A(17)+1.55*A(18)+A(19)-A(49)+A(61)+2*A(64)+A(65)+0.95*A(85)+A(91)+2*A(93)+A(94)+0.42&
               &*A(101)+0.33*A(102)+0.23*A(103)+0.33*A(104)+0.475*A(131)+0.95*A(143)
  Vdot(27) = -A(72)-A(100)-A(104)
  Vdot(28) = -A(56)-A(98)-A(102)
  Vdot(29) = -A(57)-A(99)-A(103)
  Vdot(30) = -A(20)-A(66)+0.7*A(86)+0.806*A(87)-A(95)+0.7*A(129)+0.806*A(130)+A(141)+A(142)
  Vdot(31) = -A(17)-A(18)-A(64)+0.89*A(85)+0.16*A(86)-A(93)+0.16*A(129)+0.445*A(131)+0.2*A(141)+0.89*A(143)
  Vdot(32) = A(96)-A(149)-A(150)-A(151)-A(152)-2*A(153)
  Vdot(33) = -A(16)+0.8*A(21)+0.025*A(52)-A(63)+0.25*A(78)+0.69*A(79)+1.06*A(80)+0.1*A(83)+0.1*A(103)+0.6*A(121)+0.75&
               &*A(122)+1.39*A(123)+0.55*A(126)+0.8*A(133)+0.86*A(134)+0.9*A(135)+0.55*A(138)
  Vdot(34) = -A(19)-A(65)+0.11*A(85)+0.17*A(86)+0.45*A(87)+A(89)-A(94)+0.75*A(127)+0.17*A(129)+0.45*A(130)+0.055*A(131)&
               &+A(139)+0.8*A(141)+A(142)+0.11*A(143)
  Vdot(35) = 0.75*A(58)-A(86)-A(115)-A(129)-A(141)
  Vdot(36) = 0.83*A(59)-A(87)-A(116)-A(130)-A(142)
  Vdot(37) = A(56)+A(72)-A(82)-A(111)-A(125)-A(137)
  Vdot(38) = -A(90)+A(97)+A(98)+A(99)+A(100)-A(118)-A(154)-A(155)-2*A(156)
  Vdot(39) = 0.25*A(53)+0.75*A(54)+0.9*A(60)+A(70)+2*A(85)+A(131)+2*A(143)-A(144)-A(145)-A(146)-2*A(147)-A(148)
  Vdot(40) = A(55)-A(81)-A(110)-A(124)-A(136)
  Vdot(41) = A(53)-A(79)-A(108)-A(122)-A(134)
  Vdot(42) = -A(14)-A(68)+A(106)+A(107)+A(108)+A(109)+A(110)+A(111)+A(112)+A(113)+A(115)+A(116)+A(117)+A(144)+A(150)
  Vdot(43) = -A(10)-A(11)+A(13)+0.13*A(17)+0.45*A(18)+0.009*A(52)-A(61)+0.5*A(67)+A(70)+A(77)+0.09*A(78)+0.04*A(80)+1.6&
               &*A(81)+A(82)+0.28*A(83)+A(90)-A(91)+A(101)+0.53*A(102)+0.18*A(103)+0.53*A(104)+1.5*A(119)+0.75*A(120)+0.75&
               &*A(121)+0.77*A(122)+0.8*A(123)+1.55*A(124)+1.25*A(125)+0.89*A(126)+0.75*A(127)+A(128)+A(129)+A(130)+0.5&
               &*A(131)+0.8*A(136)+0.5*A(137)+0.14*A(138)+A(145)+A(151)+1.75*A(154)+A(155)+2*A(156)
  Vdot(44) = A(54)-A(80)-A(109)-A(123)-A(135)
  Vdot(45) = A(20)+0.9*A(60)+A(66)-A(75)+A(76)-A(85)+A(95)-A(117)-A(131)-A(143)
  Vdot(46) = -A(2)-A(3)+A(22)-A(26)-A(27)-A(28)-A(37)-A(101)-A(102)-A(103)-A(104)
  Vdot(47) = -A(21)-A(71)+0.036*A(78)+0.08*A(79)+0.24*A(80)+A(118)+A(149)
  Vdot(48) = -A(12)+A(14)+0.2*A(21)+0.075*A(52)-A(62)+0.5*A(68)+0.75*A(78)+0.38*A(79)+0.35*A(80)+0.2*A(81)+A(82)+1.45&
               &*A(83)+A(88)+A(90)-A(92)+0.5*A(102)+0.72*A(103)+0.5*A(104)+0.75*A(120)+0.15*A(121)+0.41*A(122)+0.46*A(123)&
               &+0.35*A(124)+0.75*A(125)+0.725*A(126)+A(132)+0.2*A(133)+0.14*A(134)+0.1*A(135)+0.6*A(136)+A(137)+0.725&
               &*A(138)+A(154)+A(155)+2*A(156)
  Vdot(49) = A(57)-A(83)-A(112)-A(126)-A(138)
  Vdot(50) = A(63)-A(89)-A(113)-A(127)-A(139)
  Vdot(51) = 0.65*A(6)+2*A(11)+A(12)+A(13)+A(14)+0.8*A(18)+A(19)+A(20)+A(21)+A(27)-A(28)-A(29)-A(30)+A(31)-2*A(32)-2&
               &*A(33)+A(34)-A(40)-A(47)+A(48)+A(49)+0.17*A(52)+0.25*A(58)+0.17*A(59)+0.1*A(60)+A(61)+A(64)+A(77)+0.964&
               &*A(78)+0.92*A(79)+0.76*A(80)+A(81)+A(82)+A(83)+0.92*A(85)+A(86)+A(87)+A(88)+A(89)+A(91)+A(93)+0.12*A(101)&
               &+0.23*A(102)+0.26*A(103)+0.23*A(104)-A(105)-A(106)-A(107)-A(108)-A(109)-A(110)-A(111)-A(112)-A(113)-A(114)&
               &-A(115)-A(116)-A(117)-A(118)+A(119)+A(120)+A(121)+A(122)+A(123)+A(124)+A(125)+A(126)+A(127)+0.5*A(128)+2&
               &*A(129)+2*A(130)+0.46*A(131)+0.5*A(132)+0.5*A(133)+0.5*A(134)+0.5*A(135)+0.5*A(136)+0.5*A(137)+0.5*A(138)&
               &+0.5*A(139)+A(141)+A(142)+0.92*A(143)-A(144)+A(145)-A(150)+A(151)+0.5*A(154)
  Vdot(52) = A(12)+A(15)+A(50)+0.5*A(67)-A(77)+A(84)+0.22*A(102)+0.31*A(103)+0.22*A(104)-A(105)-2*A(119)-A(120)-A(121)&
               &-A(122)-A(123)-A(124)-A(125)-A(126)-A(127)-0.5*A(128)-A(129)-A(130)-A(131)+0.5*A(132)+0.5*A(133)+0.5*A(134)&
               &+0.5*A(135)+0.5*A(136)+0.5*A(137)+0.5*A(138)+0.5*A(139)+2*A(140)+A(141)+A(142)+A(143)-A(145)+A(146)-A(151)&
               &+A(152)-A(154)+0.5*A(155)
  Vdot(53) = A(4)+A(5)+0.35*A(6)+2*A(9)+A(13)+A(14)+A(15)+2*A(25)-A(27)+A(28)+A(29)-A(34)-A(35)-A(44)-A(45)-A(46)-A(47)&
               &-A(48)-A(49)-A(50)-A(51)-A(52)-A(53)-A(54)-A(55)-A(56)-A(57)-A(58)-A(59)-1.9*A(60)-A(61)-A(62)-A(63)-A(64)&
               &-A(65)-A(66)-0.5*A(67)-0.5*A(68)-A(69)-A(70)-A(71)-A(72)+0.1*A(102)+0.14*A(103)+0.1*A(104)
  Vdot(54) = 0.35*A(6)-A(7)-A(8)+A(37)-A(38)-A(39)-A(40)-A(41)+A(42)+A(45)+A(70)-A(91)-A(92)-A(93)-A(94)-A(95)-A(96)&
               &-A(97)-A(98)-A(99)-A(100)
  Vdot(55) = A(16)+A(19)+A(62)+A(65)+A(69)-A(73)+A(74)-A(84)+0.05*A(85)+A(92)+A(94)-A(114)-A(128)+0.025*A(131)-A(132)&
               &-A(133)-A(134)-A(135)-A(136)-A(137)-A(138)-A(139)-2*A(140)-A(141)-A(142)-0.95*A(143)-A(146)-A(152)-A(155)
  Vdot(56) = 0.83*A(52)+0.5*A(68)+A(71)-A(78)-A(107)-A(121)-A(133)
  Vdot(57) = A(16)+A(51)-A(88)-A(106)-A(120)-A(132)
  Vdot(58) = A(1)+A(4)+A(7)+A(23)-A(26)-A(29)-A(35)-2*A(36)-A(38)+A(39)-A(77)-A(78)-A(79)-A(80)-A(81)-A(82)-A(83)-A(84)&
               &-A(85)-A(86)-A(87)-A(88)-A(89)-A(90)-A(148)
  Vdot(59) = -A(1)+A(5)+0.65*A(6)+A(8)+A(21)-A(23)+A(26)+A(29)-A(30)+A(31)+2*A(36)-A(37)+2*A(38)-A(41)+A(42)-A(44)+A(46)&
               &+A(71)-A(73)+A(74)-A(75)+A(76)+A(77)+0.964*A(78)+0.92*A(79)+0.76*A(80)+A(81)+A(82)+A(83)+A(84)+A(85)+A(86)&
               &+A(87)+A(88)+A(89)+2*A(90)+A(148)-A(149)+A(154)+A(155)+2*A(156)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE RADM2_Function

