! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Sparse Stoichiometric Data Structures File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RACM_StoichiomSP.f90
! Time                 : Thu Oct  8 08:22:22 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RACM_22746_BOXMOX
! Equation file        : RACM.kpp
! Output root filename : RACM
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RACM_StoichiomSP

  USE RACM_Precision
  PUBLIC
  SAVE


! Row-compressed sparse data for the Jacobian of reaction products JVRP

  INTEGER, PARAMETER, DIMENSION(251) :: CROW_JVRP = (/ &
       1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, &
      13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, &
      25, 27, 28, 29, 31, 33, 35, 37, 38, 39, 41, 43, &
      45, 47, 49, 51, 53, 55, 56, 58, 60, 62, 64, 66, &
      68, 69, 71, 73, 75, 76, 77, 78, 80, 82, 84, 86, &
      88, 90, 92, 94, 96, 98,100,102,104,106,108,110, &
     112,114,116,118,120,122,124,126,128,130,132,134, &
     136,138,140,142,144,146,148,150,152,154,156,158, &
     160,162,164,166,168,170,172,174,176,178,180,182, &
     184,186,188,190,192,194,196,198,200,202,203,205, &
     207,208,210,212,213,215,217,218,220,221,223,225, &
     227,229,231,233,235,237,239,241,243,245,247,249, &
     251,253,255,257,259,261,263,265,267,269,271,273, &
     275,277,279,281,283,285,287,289,291,293,295,297, &
     299,301,302,304,306,308,310,312,314,316,318,320, &
     322,324,326,328,330,332,334,336,338,340,342,344, &
     346,348,350,352,354,356,358,360,362,364,366,368, &
     369,371,373,375,377,378,380,381,383,385,387,389, &
     391,393,395,397,399,401,403,405,407,409,411,413, &
     415,417,419,421,423,425,426,428,430,431,433,435, &
     437,439,440,442,443,445,447,449,451,453,455 /)

  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_JVRP_0 = (/ &
      82, 72, 72, 23, 32, 19, 79, 79, 27, 58, 58, 66, &
      20, 75, 33, 52, 46, 46, 53, 63, 62, 49, 24, 25, &
      25, 72,  6,  6, 72, 78, 72, 76, 76, 78, 27, 78, &
      76, 76, 25, 81, 25, 82, 25, 82, 78, 81, 78, 82, &
      78, 79, 76, 81, 76, 82, 19, 76, 79, 23, 78, 32, &
      78, 19, 78, 72, 81, 72, 82, 81, 79, 81, 79, 82, &
      79, 82, 11, 79, 78,  5, 78, 38, 78, 16, 78, 22, &
      78, 18, 78, 17, 78, 14, 78,  8, 78, 12, 78, 30, &
      78, 65, 78, 67, 78, 43, 78, 40, 78, 37, 78, 39, &
      78,  9, 78, 10, 78, 42, 78, 58, 78, 66, 78, 52, &
      78, 24, 78, 46, 78, 53, 78, 49, 78, 63, 78, 15, &
      78, 20, 78, 75, 78, 33, 78, 36, 78, 45, 78, 62, &
      78, 58, 79, 66, 79, 46, 79, 53, 79, 13, 78, 63, &
      79, 42, 79, 30, 79, 65, 79, 67, 79, 43, 79, 40, &
      79, 37, 79, 39, 79, 45, 79, 30, 72, 65, 72, 67, &
      72, 43, 72, 40, 72, 37, 72, 39, 72, 49, 72, 63, &
      72, 45, 72, 26, 82, 26, 76, 28, 82, 28, 28, 72, &
      29, 82, 29, 29, 72, 31, 82, 31, 31, 72, 77, 82, &
      36, 71, 82, 45, 74, 81, 70, 81, 73, 81, 57, 81, &
      56, 81, 47, 81, 48, 81, 61, 81, 50, 81, 51, 81, &
      55, 81, 59, 81, 60, 81, 54, 81, 77, 81, 71, 81, &
      80, 81, 69, 81, 68, 81, 74, 76, 70, 76, 73, 76, &
      57, 76, 56, 76, 47, 76, 48, 76, 61, 76, 50, 76, &
      51, 76, 55, 76, 59, 76, 60, 76, 54, 76, 76, 77, &
      76, 77, 71, 76, 71, 76, 76, 80, 69, 76, 68, 76, &
      74, 70, 74, 73, 74, 57, 74, 56, 74, 47, 74, 48, &
      74, 61, 74, 50, 74, 51, 74, 55, 74, 59, 74, 60, &
      74, 54, 74, 74, 77, 74, 77, 71, 74, 71, 74, 74, &
      80, 69, 74, 68, 74, 70, 77, 73, 77, 57, 77, 56, &
      77, 47, 77, 48, 77, 61, 77, 50, 77, 51, 77, 55 /)
  INTEGER, PARAMETER, DIMENSION(94) :: ICOL_JVRP_1 = (/ &
      77, 59, 77, 60, 77, 54, 77, 77, 71, 77, 77, 80, &
      69, 77, 68, 77, 69, 68, 69, 68, 74, 79, 70, 79, &
      73, 79, 57, 79, 56, 79, 47, 79, 48, 79, 61, 79, &
      21, 78, 51, 79, 55, 79, 59, 79, 60, 79, 54, 79, &
      77, 79, 71, 79, 79, 80, 69, 79, 68, 79, 64, 76, &
      64, 74, 64, 77, 64, 64, 81, 64, 79, 50,  7, 78, &
      34, 78, 44, 81, 44, 76, 44, 44, 82, 21, 35, 78, &
      35, 72, 35, 79, 41, 78, 41, 79, 41, 72 /)
  INTEGER, PARAMETER, DIMENSION(454) :: ICOL_JVRP = (/&
    ICOL_JVRP_0, ICOL_JVRP_1 /)

  INTEGER, PARAMETER, DIMENSION(360) :: IROW_JVRP_0 = (/ &
       1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, &
      13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, &
      25, 25, 26, 27, 28, 28, 29, 29, 30, 30, 31, 31, &
      32, 33, 34, 34, 35, 35, 36, 36, 37, 37, 38, 38, &
      39, 39, 40, 40, 41, 41, 42, 43, 43, 44, 44, 45, &
      45, 46, 46, 47, 47, 48, 48, 49, 50, 50, 51, 51, &
      52, 52, 53, 54, 55, 56, 56, 57, 57, 58, 58, 59, &
      59, 60, 60, 61, 61, 62, 62, 63, 63, 64, 64, 65, &
      65, 66, 66, 67, 67, 68, 68, 69, 69, 70, 70, 71, &
      71, 72, 72, 73, 73, 74, 74, 75, 75, 76, 76, 77, &
      77, 78, 78, 79, 79, 80, 80, 81, 81, 82, 82, 83, &
      83, 84, 84, 85, 85, 86, 86, 87, 87, 88, 88, 89, &
      89, 90, 90, 91, 91, 92, 92, 93, 93, 94, 94, 95, &
      95, 96, 96, 97, 97, 98, 98, 99, 99,100,100,101, &
     101,102,102,103,103,104,104,105,105,106,106,107, &
     107,108,108,109,109,110,110,111,111,112,112,113, &
     113,114,114,115,115,116,116,117,117,118,119,119, &
     120,120,121,122,122,123,123,124,125,125,126,126, &
     127,128,128,129,130,130,131,131,132,132,133,133, &
     134,134,135,135,136,136,137,137,138,138,139,139, &
     140,140,141,141,142,142,143,143,144,144,145,145, &
     146,146,147,147,148,148,149,149,150,150,151,151, &
     152,152,153,153,154,154,155,155,156,156,157,157, &
     158,158,159,159,160,160,161,161,162,162,163,163, &
     164,164,165,165,166,166,167,167,168,168,169,169, &
     170,171,171,172,172,173,173,174,174,175,175,176, &
     176,177,177,178,178,179,179,180,180,181,181,182, &
     182,183,183,184,184,185,185,186,186,187,187,188, &
     188,189,189,190,190,191,191,192,192,193,193,194, &
     194,195,195,196,196,197,197,198,198,199,199,200 /)
  INTEGER, PARAMETER, DIMENSION(94) :: IROW_JVRP_1 = (/ &
     200,201,201,202,202,203,203,204,205,205,206,206, &
     207,207,208,208,209,210,210,211,212,212,213,213, &
     214,214,215,215,216,216,217,217,218,218,219,219, &
     220,220,221,221,222,222,223,223,224,224,225,225, &
     226,226,227,227,228,228,229,229,230,230,231,231, &
     232,232,233,233,234,235,235,236,236,237,238,238, &
     239,239,240,240,241,241,242,243,243,244,245,245, &
     246,246,247,247,248,248,249,249,250,250 /)
  INTEGER, PARAMETER, DIMENSION(454) :: IROW_JVRP = (/&
    IROW_JVRP_0, IROW_JVRP_1 /)



!  Stoichiometric Matrix in Compressed Column Sparse Format


  INTEGER, PARAMETER, DIMENSION(251) :: CCOL_STOICM = (/ &
       1,  4,  6,  8, 11, 14, 19, 21, 24, 26, 28, 31, &
      35, 39, 43, 46, 49, 52, 56, 60, 63, 68, 73, 77, &
      79, 81, 83, 85, 88, 91, 93, 96, 98,100,103,106, &
     109,112,115,119,123,126,129,134,137,140,143,146, &
     149,151,154,156,159,162,164,166,170,174,179,183, &
     186,189,198,203,209,212,215,218,221,224,227,230, &
     235,240,246,250,253,256,260,264,268,271,279,284, &
     288,294,300,305,313,317,322,326,331,336,339,350, &
     354,358,362,366,371,374,378,382,389,396,412,427, &
     442,454,464,477,485,497,507,511,514,518,522,526, &
     530,534,538,542,546,550,553,556,559,562,567,572, &
     584,595,604,610,617,623,630,637,645,653,661,667, &
     671,676,684,689,695,698,701,704,707,710,713,716, &
     719,722,725,728,731,734,737,740,744,747,751,754, &
     757,760,763,768,777,785,793,798,804,810,817,823, &
     829,836,843,849,852,856,861,865,874,879,887,893, &
     905,915,924,931,939,946,954,960,967,974,981,987, &
     989,992,1001,1007,1016,1019,1027,1033,1038,1043,1054,1064, &
     1072,1078,1085,1091,1095,1101,1108,1115,1122,1128,1132,1137, &
     1145,1150,1156,1159,1163,1166,1167,1170,1173,1177,1179,1183, &
     1192,1195,1201,1204,1207,1213,1221,1226,1229,1233,1248 /)

  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_0 = (/ &
      25, 81, 82,  6, 72, 25, 72, 23, 78, 81, 32, 78, &
      82, 19, 76, 78, 79, 82, 79, 81, 25, 79, 82, 27, &
      78, 38, 58, 38, 58, 76, 38, 66, 74, 76, 20, 58, &
      76, 78, 66, 75, 76, 78, 33, 74, 78, 52, 70, 77, &
      38, 46, 58, 38, 46, 58, 76, 38, 53, 76, 77, 63, &
      71, 76, 52, 62, 66, 76, 82, 38, 49, 58, 76, 77, &
      24, 58, 76, 77, 25, 72, 25, 72,  6, 25,  6, 78, &
      72, 76, 78, 72, 76, 78, 76, 78, 27, 76, 78, 27, &
      76, 27, 76, 25, 81, 82, 25, 81, 82, 25, 79, 82, &
      23, 78, 81, 32, 78, 82, 76, 78, 79, 82, 76, 78, &
      81, 82, 19, 76, 82, 19, 76, 82, 32, 76, 78, 79, &
      82, 23, 78, 82, 32, 78, 79, 19, 78, 82, 72, 81, &
      82, 72, 79, 82, 81, 82, 79, 81, 82, 79, 81, 11, &
      79, 82, 11, 79, 82, 79, 82, 76, 78,  1,  5, 76, &
      78,  2, 38, 76, 78, 16, 38, 58, 78, 82, 22, 53, &
      76, 78, 18, 74, 78, 17, 70, 78,  3, 14, 38, 46, &
      58, 66, 73, 76, 78,  8, 52, 57, 76, 78, 12, 24, &
      56, 66, 76, 78, 30, 47, 78, 48, 65, 78, 61, 67, &
      78, 43, 50, 78, 40, 50, 78, 37, 51, 78, 39, 55, &
      78,  9, 28, 64, 76, 78, 10, 29, 64, 76, 78, 26, &
      31, 42, 64, 76, 78, 38, 58, 76, 78, 66, 77, 78, &
      52, 78, 80, 24, 53, 76, 78, 38, 46, 76, 78, 38, &
      53, 77, 78, 44, 49, 78, 15, 46, 53, 63, 64, 71, &
      76, 78, 15, 52, 66, 76, 78, 20, 58, 74, 78, 52, &
      64, 66, 73, 75, 78, 33, 58, 64, 76, 77, 78, 36, &
      58, 64, 78, 79, 24, 36, 45, 58, 64, 76, 78, 79, &
      62, 73, 78, 82, 32, 38, 58, 76, 79, 32, 66, 77, &
      79, 32, 38, 46, 76, 79, 32, 38, 53, 77, 79, 13, &
      44, 78, 32, 46, 52, 53, 63, 64, 66, 71, 76, 79, &
      82, 26, 32, 42, 79, 30, 68, 69, 79, 65, 68, 69 /)
  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_1 = (/ &
      79, 67, 68, 69, 79, 43, 49, 68, 69, 79, 34, 40, &
      79, 37, 68, 69, 79, 39, 68, 69, 79, 36, 45, 58, &
      62, 64, 79, 82,  3, 30, 38, 58, 72, 76, 78,  3, &
       4, 17, 18, 27, 38, 52, 58, 65, 66, 70, 72, 74, &
      76, 78, 80,  4, 17, 18, 27, 38, 52, 58, 66, 67, &
      70, 72, 74, 76, 78, 80,  3, 25, 27, 38, 43, 49, &
      58, 64, 65, 72, 74, 76, 77, 78, 80,  3, 27, 38, &
      40, 44, 49, 58, 72, 74, 76, 77, 78, 27, 37, 38, &
      52, 66, 70, 72, 76, 78, 80,  3,  4, 27, 38, 39, &
      49, 58, 65, 70, 72, 76, 78, 80,  3, 38, 49, 53, &
      72, 76, 77, 78,  3,  4, 33, 38, 46, 53, 63, 66, &
      72, 76, 77, 78,  3, 36, 38, 45, 58, 72, 76, 77, &
      78, 82, 26, 42, 62, 82, 26, 42, 76, 23, 28, 42, &
      82, 28, 42, 59, 76, 28, 42, 72, 78, 23, 29, 42, &
      82, 29, 42, 60, 76, 29, 42, 72, 78, 23, 31, 42, &
      82, 31, 42, 54, 76, 31, 42, 72, 78, 36, 77, 82, &
      36, 77, 82, 45, 71, 82, 45, 71, 82, 58, 74, 76, &
      81, 82, 66, 70, 76, 81, 82, 46, 52, 58, 62, 64, &
      66, 70, 73, 74, 76, 81, 82, 52, 57, 58, 62, 64, &
      66, 70, 74, 76, 81, 82, 52, 56, 62, 64, 66, 70, &
      76, 81, 82, 47, 58, 66, 76, 81, 82, 48, 52, 58, &
      66, 76, 81, 82, 52, 61, 66, 76, 81, 82, 34, 49, &
      50, 58, 76, 81, 82, 51, 52, 62, 66, 76, 81, 82, &
      49, 55, 58, 62, 67, 76, 81, 82, 46, 53, 59, 62, &
      63, 76, 81, 82, 46, 53, 60, 62, 63, 76, 81, 82, &
      46, 53, 54, 76, 81, 82, 74, 77, 81, 82, 58, 71, &
      77, 81, 82, 53, 64, 66, 76, 77, 80, 81, 82, 62, &
      69, 76, 81, 82, 52, 58, 66, 68, 81, 82, 20, 74, &
      76, 70, 75, 76, 73, 75, 76, 57, 75, 76, 56, 75, &
      76, 47, 75, 76, 48, 75, 76, 61, 75, 76,  7, 50 /)
  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_2 = (/ &
      76, 51, 75, 76, 55, 75, 76, 59, 75, 76, 60, 75, &
      76, 54, 75, 76, 33, 76, 77,  4, 72, 76, 77, 71, &
      75, 76,  4, 71, 72, 76, 75, 76, 80, 62, 69, 76, &
      62, 68, 76, 58, 74, 76, 58, 66, 70, 74, 76, 46, &
      52, 53, 58, 64, 66, 73, 74, 76, 52, 57, 58, 64, &
      66, 70, 74, 76, 52, 56, 58, 64, 66, 70, 74, 76, &
      47, 58, 66, 74, 76, 48, 52, 58, 66, 74, 76, 52, &
      58, 61, 66, 74, 76, 49, 50, 58, 65, 67, 74, 76, &
      51, 52, 58, 66, 74, 76, 49, 55, 58, 67, 74, 76, &
      46, 53, 58, 59, 63, 74, 76, 46, 53, 58, 60, 63, &
      74, 76, 46, 53, 54, 58, 74, 76, 58, 76, 77,  4, &
      58, 74, 77, 58, 71, 74, 76, 77,  4, 58, 71, 74, &
      24, 53, 58, 64, 66, 74, 76, 77, 80, 58, 62, 69, &
      74, 76, 52, 58, 62, 66, 68, 74, 76, 82,  4, 66, &
      70, 74, 76, 77,  4, 46, 52, 53, 58, 64, 66, 70, &
      73, 74, 76, 77,  4, 52, 57, 58, 64, 66, 70, 74, &
      76, 77,  4, 52, 56, 64, 66, 70, 74, 76, 77,  4, &
      47, 58, 66, 74, 76, 77,  4, 48, 52, 58, 66, 74, &
      76, 77,  4, 52, 61, 66, 74, 76, 77,  4, 49, 50, &
      58, 65, 74, 76, 77, 51, 52, 66, 74, 76, 77, 49, &
      55, 58, 67, 74, 76, 77, 46, 53, 59, 63, 74, 76, &
      77, 46, 53, 60, 63, 74, 76, 77, 46, 53, 54, 74, &
      76, 77, 74, 77, 58, 71, 74,  4, 52, 53, 64, 66, &
      74, 76, 77, 80,  4, 62, 69, 74, 76, 77,  4, 52, &
      58, 62, 66, 68, 74, 77, 82, 62, 69, 76, 52, 58, &
      62, 66, 68, 69, 76, 82, 52, 58, 62, 66, 68, 82, &
      58, 74, 76, 79, 82, 66, 70, 76, 79, 82, 46, 52, &
      58, 64, 66, 70, 73, 74, 76, 79, 82, 52, 57, 58, &
      64, 66, 70, 74, 76, 79, 82, 52, 56, 64, 66, 70, &
      76, 79, 82, 47, 58, 66, 76, 79, 82, 48, 52, 58 /)
  INTEGER, PARAMETER, DIMENSION(167) :: IROW_STOICM_3 = (/ &
      66, 76, 79, 82, 52, 61, 66, 76, 79, 82, 21, 22, &
      78, 82, 51, 52, 66, 76, 79, 82, 49, 55, 58, 67, &
      76, 79, 82, 46, 53, 59, 63, 76, 79, 82, 46, 53, &
      60, 63, 76, 79, 82, 46, 53, 54, 76, 79, 82, 74, &
      77, 79, 82, 58, 71, 77, 79, 82, 53, 64, 66, 76, &
      77, 79, 80, 82, 62, 69, 76, 79, 82, 52, 58, 66, &
      68, 79, 82, 64, 75, 76, 58, 64, 74, 76, 64, 74, &
      77, 64, 64, 81, 82, 64, 79, 82, 49, 50, 58, 76, &
       7, 49, 16, 22, 34, 78, 22, 38, 44, 53, 58, 76, &
      77, 81, 82, 13, 44, 76, 22, 38, 44, 53, 58, 76, &
      21, 44, 82, 21, 44, 82,  3, 35, 52, 58, 61, 78, &
       3,  4, 35, 52, 58, 66, 72, 78, 35, 49, 68, 69, &
      79, 41, 61, 78, 41, 68, 69, 79,  4, 17, 18, 27, &
      38, 41, 52, 58, 66, 70, 72, 74, 76, 78, 80 /)
  INTEGER, PARAMETER, DIMENSION(1247) :: IROW_STOICM = (/&
    IROW_STOICM_0, IROW_STOICM_1, IROW_STOICM_2, IROW_STOICM_3 /)

  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_0 = (/ &
       1,  1,  1,  2,  2,  3,  3,  4,  4,  4,  5,  5, &
       5,  6,  6,  6,  6,  6,  7,  7,  8,  8,  8,  9, &
       9, 10, 10, 11, 11, 11, 12, 12, 12, 12, 13, 13, &
      13, 13, 14, 14, 14, 14, 15, 15, 15, 16, 16, 16, &
      17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, &
      20, 20, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, &
      23, 23, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, &
      28, 28, 28, 29, 29, 29, 30, 30, 31, 31, 31, 32, &
      32, 33, 33, 34, 34, 34, 35, 35, 35, 36, 36, 36, &
      37, 37, 37, 38, 38, 38, 39, 39, 39, 39, 40, 40, &
      40, 40, 41, 41, 41, 42, 42, 42, 43, 43, 43, 43, &
      43, 44, 44, 44, 45, 45, 45, 46, 46, 46, 47, 47, &
      47, 48, 48, 48, 49, 49, 50, 50, 50, 51, 51, 52, &
      52, 52, 53, 53, 53, 54, 54, 55, 55, 56, 56, 56, &
      56, 57, 57, 57, 57, 58, 58, 58, 58, 58, 59, 59, &
      59, 59, 60, 60, 60, 61, 61, 61, 62, 62, 62, 62, &
      62, 62, 62, 62, 62, 63, 63, 63, 63, 63, 64, 64, &
      64, 64, 64, 64, 65, 65, 65, 66, 66, 66, 67, 67, &
      67, 68, 68, 68, 69, 69, 69, 70, 70, 70, 71, 71, &
      71, 72, 72, 72, 72, 72, 73, 73, 73, 73, 73, 74, &
      74, 74, 74, 74, 74, 75, 75, 75, 75, 76, 76, 76, &
      77, 77, 77, 78, 78, 78, 78, 79, 79, 79, 79, 80, &
      80, 80, 80, 81, 81, 81, 82, 82, 82, 82, 82, 82, &
      82, 82, 83, 83, 83, 83, 83, 84, 84, 84, 84, 85, &
      85, 85, 85, 85, 85, 86, 86, 86, 86, 86, 86, 87, &
      87, 87, 87, 87, 88, 88, 88, 88, 88, 88, 88, 88, &
      89, 89, 89, 89, 90, 90, 90, 90, 90, 91, 91, 91, &
      91, 92, 92, 92, 92, 92, 93, 93, 93, 93, 93, 94, &
      94, 94, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, &
      95, 96, 96, 96, 96, 97, 97, 97, 97, 98, 98, 98 /)
  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_1 = (/ &
      98, 99, 99, 99, 99,100,100,100,100,100,101,101, &
     101,102,102,102,102,103,103,103,103,104,104,104, &
     104,104,104,104,105,105,105,105,105,105,105,106, &
     106,106,106,106,106,106,106,106,106,106,106,106, &
     106,106,106,107,107,107,107,107,107,107,107,107, &
     107,107,107,107,107,107,108,108,108,108,108,108, &
     108,108,108,108,108,108,108,108,108,109,109,109, &
     109,109,109,109,109,109,109,109,109,110,110,110, &
     110,110,110,110,110,110,110,111,111,111,111,111, &
     111,111,111,111,111,111,111,111,112,112,112,112, &
     112,112,112,112,113,113,113,113,113,113,113,113, &
     113,113,113,113,114,114,114,114,114,114,114,114, &
     114,114,115,115,115,115,116,116,116,117,117,117, &
     117,118,118,118,118,119,119,119,119,120,120,120, &
     120,121,121,121,121,122,122,122,122,123,123,123, &
     123,124,124,124,124,125,125,125,125,126,126,126, &
     127,127,127,128,128,128,129,129,129,130,130,130, &
     130,130,131,131,131,131,131,132,132,132,132,132, &
     132,132,132,132,132,132,132,133,133,133,133,133, &
     133,133,133,133,133,133,134,134,134,134,134,134, &
     134,134,134,135,135,135,135,135,135,136,136,136, &
     136,136,136,136,137,137,137,137,137,137,138,138, &
     138,138,138,138,138,139,139,139,139,139,139,139, &
     140,140,140,140,140,140,140,140,141,141,141,141, &
     141,141,141,141,142,142,142,142,142,142,142,142, &
     143,143,143,143,143,143,144,144,144,144,145,145, &
     145,145,145,146,146,146,146,146,146,146,146,147, &
     147,147,147,147,148,148,148,148,148,148,149,149, &
     149,150,150,150,151,151,151,152,152,152,153,153, &
     153,154,154,154,155,155,155,156,156,156,157,157 /)
  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_2 = (/ &
     157,158,158,158,159,159,159,160,160,160,161,161, &
     161,162,162,162,163,163,163,164,164,164,164,165, &
     165,165,166,166,166,166,167,167,167,168,168,168, &
     169,169,169,170,170,170,171,171,171,171,171,172, &
     172,172,172,172,172,172,172,172,173,173,173,173, &
     173,173,173,173,174,174,174,174,174,174,174,174, &
     175,175,175,175,175,176,176,176,176,176,176,177, &
     177,177,177,177,177,178,178,178,178,178,178,178, &
     179,179,179,179,179,179,180,180,180,180,180,180, &
     181,181,181,181,181,181,181,182,182,182,182,182, &
     182,182,183,183,183,183,183,183,184,184,184,185, &
     185,185,185,186,186,186,186,186,187,187,187,187, &
     188,188,188,188,188,188,188,188,188,189,189,189, &
     189,189,190,190,190,190,190,190,190,190,191,191, &
     191,191,191,191,192,192,192,192,192,192,192,192, &
     192,192,192,192,193,193,193,193,193,193,193,193, &
     193,193,194,194,194,194,194,194,194,194,194,195, &
     195,195,195,195,195,195,196,196,196,196,196,196, &
     196,196,197,197,197,197,197,197,197,198,198,198, &
     198,198,198,198,198,199,199,199,199,199,199,200, &
     200,200,200,200,200,200,201,201,201,201,201,201, &
     201,202,202,202,202,202,202,202,203,203,203,203, &
     203,203,204,204,205,205,205,206,206,206,206,206, &
     206,206,206,206,207,207,207,207,207,207,208,208, &
     208,208,208,208,208,208,208,209,209,209,210,210, &
     210,210,210,210,210,210,211,211,211,211,211,211, &
     212,212,212,212,212,213,213,213,213,213,214,214, &
     214,214,214,214,214,214,214,214,214,215,215,215, &
     215,215,215,215,215,215,215,216,216,216,216,216, &
     216,216,216,217,217,217,217,217,217,218,218,218 /)
  INTEGER, PARAMETER, DIMENSION(167) :: ICOL_STOICM_3 = (/ &
     218,218,218,218,219,219,219,219,219,219,220,220, &
     220,220,221,221,221,221,221,221,222,222,222,222, &
     222,222,222,223,223,223,223,223,223,223,224,224, &
     224,224,224,224,224,225,225,225,225,225,225,226, &
     226,226,226,227,227,227,227,227,228,228,228,228, &
     228,228,228,228,229,229,229,229,229,230,230,230, &
     230,230,230,231,231,231,232,232,232,232,233,233, &
     233,234,235,235,235,236,236,236,237,237,237,237, &
     238,238,239,239,239,239,240,240,240,240,240,240, &
     240,240,240,241,241,241,242,242,242,242,242,242, &
     243,243,243,244,244,244,245,245,245,245,245,245, &
     246,246,246,246,246,246,246,246,247,247,247,247, &
     247,248,248,248,249,249,249,249,250,250,250,250, &
     250,250,250,250,250,250,250,250,250,250,250 /)
  INTEGER, PARAMETER, DIMENSION(1247) :: ICOL_STOICM = (/&
    ICOL_STOICM_0, ICOL_STOICM_1, ICOL_STOICM_2, ICOL_STOICM_3 /)

  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_0 = (/ &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  6.500000e-01_dp, &
       3.500000e-01_dp,  3.500000e-01_dp,  6.500000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.870000e+00_dp,  -1.000000e+00_dp, &
       1.300000e-01_dp,  1.550000e+00_dp,  -1.000000e+00_dp,  4.500000e-01_dp,  8.000000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  8.000000e-01_dp,  -1.000000e+00_dp,  2.000000e-01_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  3.000000e-01_dp,  -1.000000e+00_dp, &
       7.000000e-01_dp,  -1.000000e+00_dp,  7.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -2.000000e+00_dp,  2.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_1 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -2.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  3.600000e-02_dp,  -1.000000e+00_dp, &
       3.600000e-02_dp,  3.600000e-02_dp,  1.000000e-02_dp,  3.350000e-01_dp,  5.830000e-01_dp, &
       3.810000e-01_dp,  -9.640000e-01_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  7.500000e-01_dp, &
       2.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.400000e-02_dp,  9.511000e-01_dp, &
       2.500000e-02_dp,  4.900000e-02_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       9.000000e-01_dp,  1.000000e-01_dp,  1.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       9.000000e-01_dp,  1.000000e-01_dp,  1.000000e-01_dp,  -1.000000e+00_dp,  1.000000e-01_dp, &
       8.500000e-01_dp,  -1.000000e+00_dp,  5.000000e-02_dp,  5.000000e-02_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       3.500000e-01_dp,  1.500000e-01_dp,  1.500000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.200000e-01_dp, &
       8.800000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  3.500000e-01_dp, &
       6.500000e-01_dp,  -6.500000e-01_dp,  4.100000e-01_dp,  7.000000e-02_dp,  8.000000e-02_dp, &
       4.400000e-01_dp,  -1.000000e+00_dp,  -5.100000e-01_dp,  -1.000000e+00_dp,  3.500000e-01_dp, &
       3.500000e-01_dp,  3.500000e-01_dp,  6.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_2 = (/ &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  6.000000e-01_dp, &
       4.000000e-01_dp,  -1.000000e+00_dp,  4.000000e-01_dp,  1.000000e+00_dp,  4.000000e-01_dp, &
       -1.000000e+00_dp,  6.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  2.500000e-01_dp, &
       3.000000e-02_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  2.500000e-01_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e-01_dp, &
       8.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  5.700000e-01_dp,  4.300000e-01_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  8.900000e-01_dp,  1.100000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  9.000000e-01_dp,  1.000000e-01_dp,  9.000000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  9.000000e-01_dp, &
       1.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  8.700000e-01_dp,  1.300000e-01_dp, &
       -1.000000e+00_dp,  4.000000e-01_dp,  -1.000000e+00_dp,  4.000000e-01_dp,  6.000000e-01_dp, &
       1.000000e+00_dp,  -4.000000e-01_dp,  4.000000e-01_dp,  3.700000e-01_dp,  -1.000000e+00_dp, &
       4.300000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.600000e-01_dp,  1.200000e-01_dp, &
       1.400000e-01_dp,  1.000000e-01_dp,  3.000000e-02_dp,  6.000000e-02_dp,  6.000000e-03_dp, &
       3.700000e-01_dp,  3.000000e-02_dp,  6.400000e-01_dp,  -1.000000e+00_dp,  4.400000e-01_dp, &
       1.000000e-01_dp,  -1.000000e+00_dp,  1.900000e-01_dp,  2.500000e-01_dp,  4.000000e-01_dp, &
       3.000000e-02_dp,  1.400000e-01_dp,  6.000000e-02_dp,  7.000000e-02_dp,  1.100000e-02_dp, &
       3.000000e-01_dp,  1.600000e-01_dp,  2.000000e-02_dp,  9.900000e-01_dp,  -1.000000e+00_dp, &
       1.800000e-01_dp,  -1.000000e+00_dp,  2.300000e-01_dp,  2.200000e-01_dp,  6.300000e-01_dp, &
       1.200000e-01_dp,  1.500000e-01_dp,  9.000000e-02_dp,  1.000000e-03_dp,  3.600000e-01_dp, &
       -1.000000e+00_dp,  3.900000e-01_dp,  9.000000e-01_dp,  1.300000e-01_dp,  3.500000e-01_dp, &
       -1.000000e+00_dp,  3.000000e-02_dp,  3.000000e-01_dp,  1.500000e-01_dp,  2.800000e-01_dp, &
       2.000000e-02_dp,  2.800000e-01_dp,  9.000000e-02_dp,  1.400000e-01_dp,  -1.000000e+00_dp, &
       1.000000e-01_dp,  6.500000e-01_dp,  5.800000e-01_dp,  -1.000000e+00_dp,  8.000000e-02_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_3 = (/ &
       2.500000e-01_dp,  1.000000e-01_dp,  2.500000e-01_dp,  2.000000e-02_dp,  -1.000000e+00_dp, &
       1.400000e-01_dp,  5.300000e-01_dp,  6.500000e-01_dp,  2.000000e-01_dp,  -1.000000e+00_dp, &
       1.000000e-01_dp,  8.500000e-01_dp,  4.200000e-01_dp,  1.000000e-02_dp,  7.000000e-02_dp, &
       2.000000e-02_dp,  1.400000e-01_dp,  -1.000000e+00_dp,  7.900000e-01_dp,  4.000000e-02_dp, &
       4.600000e-01_dp,  1.600000e-01_dp,  -1.000000e+00_dp,  1.000000e-01_dp,  8.500000e-01_dp, &
       4.200000e-01_dp,  4.500000e-01_dp,  2.200000e-01_dp,  -1.000000e+00_dp,  9.000000e-01_dp, &
       -1.000000e+00_dp,  3.200000e-01_dp,  1.000000e-01_dp,  1.900000e-01_dp,  1.100000e-01_dp, &
       2.100000e-01_dp,  1.100000e-01_dp,  6.600000e-01_dp,  5.000000e-01_dp,  6.200000e-01_dp, &
       -1.000000e+00_dp,  1.600000e-01_dp,  -1.000000e+00_dp,  2.900000e-01_dp,  2.800000e-01_dp, &
       2.100000e-01_dp,  1.100000e-01_dp,  3.000000e-01_dp,  1.300000e-01_dp,  -1.000000e+00_dp, &
       7.000000e-01_dp,  -1.000000e+00_dp,  8.000000e-02_dp,  7.000000e-01_dp,  3.600000e-02_dp, &
       7.000000e-01_dp,  -1.000000e+00_dp,  1.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e-02_dp,  9.800000e-01_dp, &
       2.000000e-02_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e-02_dp,  9.800000e-01_dp,  2.000000e-02_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e-02_dp,  9.800000e-01_dp,  2.000000e-02_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  6.300000e-02_dp,  6.230000e-01_dp,  4.700000e-02_dp,  5.900000e-02_dp, &
       4.800000e-02_dp,  2.330000e-01_dp,  4.800000e-02_dp,  -1.000000e+00_dp,  1.500000e-01_dp, &
       7.420000e-01_dp,  -1.000000e+00_dp,  9.410000e-01_dp,  7.220000e-01_dp,  -1.000000e+00_dp, &
       2.100000e-02_dp,  1.240000e-01_dp,  3.340000e-01_dp,  2.110000e-01_dp,  2.450000e-01_dp, &
       3.100000e-02_dp,  5.990000e-01_dp,  -1.000000e+00_dp,  8.760000e-01_dp,  6.420000e-01_dp, &
       -1.000000e+00_dp,  2.610000e-01_dp,  4.160000e-01_dp,  1.500000e-01_dp,  1.330000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_4 = (/ &
       6.060000e-01_dp,  -1.000000e+00_dp,  7.390000e-01_dp,  -1.000000e+00_dp,  1.600000e+00_dp, &
       2.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       6.000000e-02_dp,  1.000000e+00_dp,  9.400000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  2.900000e-01_dp,  -1.000000e+00_dp,  1.710000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  4.600000e-02_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       8.000000e-01_dp,  2.000000e-01_dp,  8.000000e-01_dp,  8.000000e-01_dp,  -1.000000e+00_dp, &
       8.000000e-01_dp,  4.000000e-01_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  3.500000e-01_dp, &
       2.500000e-01_dp,  6.500000e-01_dp,  -1.000000e+00_dp,  6.500000e-01_dp,  1.200000e+00_dp, &
       6.500000e-01_dp,  -1.000000e+00_dp,  5.000000e-02_dp,  5.000000e-01_dp,  9.500000e-01_dp, &
       -1.000000e+00_dp,  9.500000e-01_dp,  3.500000e-01_dp,  6.000000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-02_dp,  9.500000e-01_dp,  9.500000e-01_dp,  -1.000000e+00_dp,  9.500000e-01_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       5.400000e-01_dp,  1.600000e-01_dp,  4.600000e-01_dp,  7.700000e-01_dp,  2.300000e-01_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  4.640000e-01_dp,  2.870000e-01_dp, &
       1.240000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_5 = (/ &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.330000e+00_dp, &
       -2.000000e+00_dp,  6.600000e-01_dp,  7.500000e-01_dp,  7.500000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.190000e-01_dp,  1.800000e-02_dp,  5.000000e-03_dp, &
       8.100000e-01_dp,  8.500000e-02_dp,  5.800000e-01_dp,  -1.000000e+00_dp,  -9.930000e-01_dp, &
       9.920000e-01_dp,  2.400000e-01_dp,  -1.000000e+00_dp,  8.290000e-01_dp,  2.450000e-01_dp, &
       5.230000e-01_dp,  1.400000e-02_dp,  -9.510000e-01_dp,  9.460000e-01_dp,  4.190000e-01_dp, &
       -1.000000e+00_dp,  7.530000e-01_dp,  3.220000e-01_dp,  4.110000e-01_dp,  1.300000e-02_dp, &
       -1.000000e+00_dp,  9.930000e-01_dp,  -1.000000e+00_dp,  1.550000e+00_dp,  3.500000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  8.100000e-02_dp,  1.250000e+00_dp, &
       6.690000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  3.130000e-01_dp,  7.550000e-01_dp, &
       -1.000000e+00_dp,  9.320000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  5.500000e-01_dp, &
       -1.000000e+00_dp,  1.090000e+00_dp,  3.700000e-01_dp,  8.000000e-02_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  6.000000e-01_dp,  -1.000000e+00_dp,  1.400000e+00_dp, &
       4.000000e-01_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  6.500000e-01_dp,  3.500000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       3.700000e-01_dp,  6.300000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  3.000000e-01_dp, &
       4.000000e-01_dp,  7.500000e-01_dp,  8.000000e-02_dp,  3.000000e-01_dp,  -1.000000e+00_dp, &
       8.800000e-01_dp,  1.200000e-01_dp,  -1.000000e+00_dp,  7.500000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.490000e-01_dp,  9.600000e-01_dp, &
       5.000000e-01_dp,  6.400000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  4.990000e-01_dp,  1.000000e-01_dp,  1.270000e-01_dp, &
       4.000000e-03_dp,  9.100000e-02_dp,  7.100000e-02_dp,  7.240000e-01_dp,  6.000000e-03_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_6 = (/ &
       -1.000000e+00_dp,  5.080000e-01_dp,  4.880000e-01_dp,  -1.000000e+00_dp,  4.950000e-01_dp, &
       3.300000e-01_dp,  -1.000000e+00_dp,  7.600000e-02_dp,  2.370000e-01_dp,  6.770000e-01_dp, &
       1.800000e-02_dp,  5.540000e-01_dp,  4.380000e-01_dp,  -1.000000e+00_dp,  4.950000e-01_dp, &
       5.810000e-01_dp,  -1.000000e+00_dp,  3.180000e-01_dp,  4.970000e-01_dp,  1.500000e-02_dp, &
       5.070000e-01_dp,  4.890000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       8.000000e-01_dp,  6.000000e-01_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       4.990000e-01_dp,  -1.000000e+00_dp,  1.410000e-01_dp,  5.010000e-01_dp,  8.590000e-01_dp, &
       5.010000e-01_dp,  5.010000e-01_dp,  -1.000000e+00_dp,  4.900000e-01_dp,  5.690000e-01_dp, &
       -1.000000e+00_dp,  9.410000e-01_dp,  5.100000e-01_dp,  5.100000e-01_dp,  -1.000000e+00_dp, &
       4.940000e-01_dp,  7.710000e-01_dp,  -1.000000e+00_dp,  3.400000e-01_dp,  2.290000e-01_dp, &
       5.060000e-01_dp,  5.060000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  6.000000e-01_dp, &
       -1.000000e+00_dp,  4.000000e-01_dp,  4.000000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  6.500000e-01_dp,  3.500000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  3.700000e-01_dp,  6.300000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  5.000000e-01_dp,  1.100000e-01_dp,  5.400000e-01_dp,  8.000000e-02_dp, &
       3.500000e-01_dp,  5.000000e-01_dp,  3.800000e-01_dp,  -8.800000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp, &
       -1.000000e+00_dp,  4.840000e-01_dp,  1.670000e-01_dp,  2.070000e-01_dp,  4.840000e-01_dp, &
       6.500000e-01_dp,  -1.000000e+00_dp,  5.160000e-01_dp,  -1.000000e+00_dp,  5.160000e-01_dp, &
       2.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  1.490000e-01_dp,  2.020000e-01_dp, &
       1.500000e+00_dp,  6.400000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       5.000000e-01_dp,  2.850000e-01_dp,  5.040000e-01_dp,  1.000000e+00_dp,  1.210000e+00_dp, &
       -2.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  6.300000e-02_dp,  6.700000e-01_dp,  4.800000e-02_dp, &
       5.100000e-02_dp,  2.430000e-01_dp,  5.300000e-02_dp,  -1.000000e+00_dp,  1.550000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_7 = (/ &
       7.920000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  8.280000e-01_dp,  -1.000000e+00_dp, &
       2.100000e-02_dp,  3.910000e-01_dp,  2.390000e-01_dp,  2.620000e-01_dp,  4.000000e-02_dp, &
       6.990000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  8.800000e-01_dp,  -1.000000e+00_dp, &
       5.870000e-01_dp,  1.870000e-01_dp,  1.550000e-01_dp,  8.450000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.600000e+00_dp,  2.000000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  6.000000e-02_dp,  1.000000e+00_dp, &
       9.400000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  2.900000e-01_dp, &
       -1.000000e+00_dp,  1.710000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       6.000000e-01_dp,  -1.000000e+00_dp,  4.000000e-01_dp,  4.000000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.300000e+00_dp,  7.000000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  7.400000e-01_dp, &
       1.260000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  5.400000e-01_dp,  1.600000e-01_dp,  4.600000e-01_dp,  7.700000e-01_dp, &
       2.300000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  4.690000e-01_dp, &
       2.800000e-01_dp,  1.240000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  7.500000e-01_dp,  7.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       5.000000e-01_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(47) :: STOICM_8 = (/ &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  5.000000e-02_dp,  -1.000000e+00_dp,  3.600000e-01_dp,  3.000000e-01_dp, &
       1.900000e-01_dp,  -1.000000e+00_dp,  3.900000e-02_dp,  5.300000e-02_dp,  -1.000000e+00_dp, &
       2.300000e-01_dp,  5.100000e-01_dp,  8.500000e-01_dp,  -1.000000e+00_dp,  6.300000e-01_dp, &
       -1.000000e+00_dp,  9.000000e-01_dp,  1.000000e-01_dp,  9.000000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  8.900000e-01_dp, &
       1.100000e-01_dp,  -1.000000e+00_dp,  1.400000e-01_dp,  6.000000e-02_dp,  7.000000e-02_dp, &
       1.100000e-02_dp,  3.000000e-01_dp,  -1.000000e+00_dp,  1.600000e-01_dp,  2.000000e-02_dp, &
       9.900000e-01_dp,  1.800000e-01_dp,  -1.000000e+00_dp,  2.300000e-01_dp,  2.200000e-01_dp, &
       6.300000e-01_dp,  1.200000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(1247) :: STOICM = (/&
    STOICM_0, STOICM_1, STOICM_2, STOICM_3, STOICM_4, &
    STOICM_5, STOICM_6, STOICM_7, STOICM_8 /)


END MODULE RACM_StoichiomSP

