! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Stoichiometric Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RACM_Stoichiom.f90
! Time                 : Thu Oct  8 08:22:22 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RACM_22746_BOXMOX
! Equation file        : RACM.kpp
! Output root filename : RACM
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RACM_Stoichiom

  USE RACM_Parameters
  USE RACM_StoichiomSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ReactantProd - Reactant Products in each equation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      ARP       - Reactant product in each equation
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ReactantProd ( V, F, ARP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! ARP - Reactant product in each equation
  REAL(kind=dp) :: ARP(NREACT)


! Reactant Products in each equation are useful in the
!     stoichiometric formulation of mass action law
  ARP(1) = V(82)
  ARP(2) = V(72)
  ARP(3) = V(72)
  ARP(4) = V(23)
  ARP(5) = V(32)
  ARP(6) = V(19)
  ARP(7) = V(79)
  ARP(8) = V(79)
  ARP(9) = V(27)
  ARP(10) = V(58)
  ARP(11) = V(58)
  ARP(12) = V(66)
  ARP(13) = V(20)
  ARP(14) = V(75)
  ARP(15) = V(33)
  ARP(16) = V(52)
  ARP(17) = V(46)
  ARP(18) = V(46)
  ARP(19) = V(53)
  ARP(20) = V(63)
  ARP(21) = V(62)
  ARP(22) = V(49)
  ARP(23) = V(24)
  ARP(24) = V(25)*F(2)
  ARP(25) = V(25)*V(72)
  ARP(26) = V(6)*F(2)
  ARP(27) = V(6)*F(1)
  ARP(28) = V(72)*V(78)
  ARP(29) = V(72)*V(76)
  ARP(30) = V(76)*V(78)
  ARP(31) = V(27)*V(78)
  ARP(32) = V(76)*V(76)
  ARP(33) = V(76)*V(76)*F(1)
  ARP(34) = V(25)*V(81)
  ARP(35) = V(25)*V(82)
  ARP(36) = V(25)*V(82)
  ARP(37) = V(78)*V(81)
  ARP(38) = V(78)*V(82)
  ARP(39) = V(78)*V(79)
  ARP(40) = V(76)*V(81)
  ARP(41) = V(76)*V(82)
  ARP(42) = V(19)
  ARP(43) = V(76)*V(79)
  ARP(44) = V(23)*V(78)
  ARP(45) = V(32)*V(78)
  ARP(46) = V(19)*V(78)
  ARP(47) = V(72)*V(81)
  ARP(48) = V(72)*V(82)
  ARP(49) = V(81)*V(81)*F(2)
  ARP(50) = V(79)*V(81)
  ARP(51) = V(79)*V(82)
  ARP(52) = V(79)*V(82)
  ARP(53) = V(11)
  ARP(54) = V(79)*V(79)
  ARP(55) = V(78)*F(2)
  ARP(56) = V(5)*V(78)
  ARP(57) = V(38)*V(78)
  ARP(58) = V(16)*V(78)
  ARP(59) = V(22)*V(78)
  ARP(60) = V(18)*V(78)
  ARP(61) = V(17)*V(78)
  ARP(62) = V(14)*V(78)
  ARP(63) = V(8)*V(78)
  ARP(64) = V(12)*V(78)
  ARP(65) = V(30)*V(78)
  ARP(66) = V(65)*V(78)
  ARP(67) = V(67)*V(78)
  ARP(68) = V(43)*V(78)
  ARP(69) = V(40)*V(78)
  ARP(70) = V(37)*V(78)
  ARP(71) = V(39)*V(78)
  ARP(72) = V(9)*V(78)
  ARP(73) = V(10)*V(78)
  ARP(74) = V(42)*V(78)
  ARP(75) = V(58)*V(78)
  ARP(76) = V(66)*V(78)
  ARP(77) = V(52)*V(78)
  ARP(78) = V(24)*V(78)
  ARP(79) = V(46)*V(78)
  ARP(80) = V(53)*V(78)
  ARP(81) = V(49)*V(78)
  ARP(82) = V(63)*V(78)
  ARP(83) = V(15)*V(78)
  ARP(84) = V(20)*V(78)
  ARP(85) = V(75)*V(78)
  ARP(86) = V(33)*V(78)
  ARP(87) = V(36)*V(78)
  ARP(88) = V(45)*V(78)
  ARP(89) = V(62)*V(78)
  ARP(90) = V(58)*V(79)
  ARP(91) = V(66)*V(79)
  ARP(92) = V(46)*V(79)
  ARP(93) = V(53)*V(79)
  ARP(94) = V(13)*V(78)
  ARP(95) = V(63)*V(79)
  ARP(96) = V(42)*V(79)
  ARP(97) = V(30)*V(79)
  ARP(98) = V(65)*V(79)
  ARP(99) = V(67)*V(79)
  ARP(100) = V(43)*V(79)
  ARP(101) = V(40)*V(79)
  ARP(102) = V(37)*V(79)
  ARP(103) = V(39)*V(79)
  ARP(104) = V(45)*V(79)
  ARP(105) = V(30)*V(72)
  ARP(106) = V(65)*V(72)
  ARP(107) = V(67)*V(72)
  ARP(108) = V(43)*V(72)
  ARP(109) = V(40)*V(72)
  ARP(110) = V(37)*V(72)
  ARP(111) = V(39)*V(72)
  ARP(112) = V(49)*V(72)
  ARP(113) = V(63)*V(72)
  ARP(114) = V(45)*V(72)
  ARP(115) = V(26)*V(82)
  ARP(116) = V(26)*V(76)
  ARP(117) = V(28)*V(82)
  ARP(118) = V(28)*F(2)
  ARP(119) = V(28)*V(72)
  ARP(120) = V(29)*V(82)
  ARP(121) = V(29)*F(2)
  ARP(122) = V(29)*V(72)
  ARP(123) = V(31)*V(82)
  ARP(124) = V(31)*F(2)
  ARP(125) = V(31)*V(72)
  ARP(126) = V(77)*V(82)
  ARP(127) = V(36)
  ARP(128) = V(71)*V(82)
  ARP(129) = V(45)
  ARP(130) = V(74)*V(81)
  ARP(131) = V(70)*V(81)
  ARP(132) = V(73)*V(81)
  ARP(133) = V(57)*V(81)
  ARP(134) = V(56)*V(81)
  ARP(135) = V(47)*V(81)
  ARP(136) = V(48)*V(81)
  ARP(137) = V(61)*V(81)
  ARP(138) = V(50)*V(81)
  ARP(139) = V(51)*V(81)
  ARP(140) = V(55)*V(81)
  ARP(141) = V(59)*V(81)
  ARP(142) = V(60)*V(81)
  ARP(143) = V(54)*V(81)
  ARP(144) = V(77)*V(81)
  ARP(145) = V(71)*V(81)
  ARP(146) = V(80)*V(81)
  ARP(147) = V(69)*V(81)
  ARP(148) = V(68)*V(81)
  ARP(149) = V(74)*V(76)
  ARP(150) = V(70)*V(76)
  ARP(151) = V(73)*V(76)
  ARP(152) = V(57)*V(76)
  ARP(153) = V(56)*V(76)
  ARP(154) = V(47)*V(76)
  ARP(155) = V(48)*V(76)
  ARP(156) = V(61)*V(76)
  ARP(157) = V(50)*V(76)
  ARP(158) = V(51)*V(76)
  ARP(159) = V(55)*V(76)
  ARP(160) = V(59)*V(76)
  ARP(161) = V(60)*V(76)
  ARP(162) = V(54)*V(76)
  ARP(163) = V(76)*V(77)
  ARP(164) = V(76)*V(77)
  ARP(165) = V(71)*V(76)
  ARP(166) = V(71)*V(76)
  ARP(167) = V(76)*V(80)
  ARP(168) = V(69)*V(76)
  ARP(169) = V(68)*V(76)
  ARP(170) = V(74)*V(74)
  ARP(171) = V(70)*V(74)
  ARP(172) = V(73)*V(74)
  ARP(173) = V(57)*V(74)
  ARP(174) = V(56)*V(74)
  ARP(175) = V(47)*V(74)
  ARP(176) = V(48)*V(74)
  ARP(177) = V(61)*V(74)
  ARP(178) = V(50)*V(74)
  ARP(179) = V(51)*V(74)
  ARP(180) = V(55)*V(74)
  ARP(181) = V(59)*V(74)
  ARP(182) = V(60)*V(74)
  ARP(183) = V(54)*V(74)
  ARP(184) = V(74)*V(77)
  ARP(185) = V(74)*V(77)
  ARP(186) = V(71)*V(74)
  ARP(187) = V(71)*V(74)
  ARP(188) = V(74)*V(80)
  ARP(189) = V(69)*V(74)
  ARP(190) = V(68)*V(74)
  ARP(191) = V(70)*V(77)
  ARP(192) = V(73)*V(77)
  ARP(193) = V(57)*V(77)
  ARP(194) = V(56)*V(77)
  ARP(195) = V(47)*V(77)
  ARP(196) = V(48)*V(77)
  ARP(197) = V(61)*V(77)
  ARP(198) = V(50)*V(77)
  ARP(199) = V(51)*V(77)
  ARP(200) = V(55)*V(77)
  ARP(201) = V(59)*V(77)
  ARP(202) = V(60)*V(77)
  ARP(203) = V(54)*V(77)
  ARP(204) = V(77)*V(77)
  ARP(205) = V(71)*V(77)
  ARP(206) = V(77)*V(80)
  ARP(207) = V(69)*V(77)
  ARP(208) = V(68)*V(77)
  ARP(209) = V(69)*V(69)
  ARP(210) = V(68)*V(69)
  ARP(211) = V(68)*V(68)
  ARP(212) = V(74)*V(79)
  ARP(213) = V(70)*V(79)
  ARP(214) = V(73)*V(79)
  ARP(215) = V(57)*V(79)
  ARP(216) = V(56)*V(79)
  ARP(217) = V(47)*V(79)
  ARP(218) = V(48)*V(79)
  ARP(219) = V(61)*V(79)
  ARP(220) = V(21)*V(78)
  ARP(221) = V(51)*V(79)
  ARP(222) = V(55)*V(79)
  ARP(223) = V(59)*V(79)
  ARP(224) = V(60)*V(79)
  ARP(225) = V(54)*V(79)
  ARP(226) = V(77)*V(79)
  ARP(227) = V(71)*V(79)
  ARP(228) = V(79)*V(80)
  ARP(229) = V(69)*V(79)
  ARP(230) = V(68)*V(79)
  ARP(231) = V(64)*V(76)
  ARP(232) = V(64)*V(74)
  ARP(233) = V(64)*V(77)
  ARP(234) = V(64)*V(64)
  ARP(235) = V(64)*V(81)
  ARP(236) = V(64)*V(79)
  ARP(237) = V(50)*V(50)
  ARP(238) = V(7)*V(78)
  ARP(239) = V(34)*V(78)
  ARP(240) = V(44)*V(81)
  ARP(241) = V(44)*V(76)
  ARP(242) = V(44)*V(44)
  ARP(243) = V(44)*V(82)
  ARP(244) = V(21)
  ARP(245) = V(35)*V(78)
  ARP(246) = V(35)*V(72)
  ARP(247) = V(35)*V(79)
  ARP(248) = V(41)*V(78)
  ARP(249) = V(41)*V(79)
  ARP(250) = V(41)*V(72)
      
END SUBROUTINE ReactantProd

! End of ReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacReactantProd - Jacobian of Reactant Products vector
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      JVRP      - d ARP(1:NREACT)/d VAR (1:NVAR)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacReactantProd ( V, F, JVRP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! JVRP - d ARP(1:NREACT)/d VAR (1:NVAR)
  REAL(kind=dp) :: JVRP(NJVRP)


! Reactant Products in each equation are useful in the
!    stoichiometric formulation of mass action law
! Below we compute the Jacobian of the Reactant Products vector
!    w.r.t. variable species: d ARP(1:NREACT) / d Var(1:NVAR)

! JVRP(1) = dARP(1)/dV(82)
  JVRP(1) = 1
! JVRP(2) = dARP(2)/dV(72)
  JVRP(2) = 1
! JVRP(3) = dARP(3)/dV(72)
  JVRP(3) = 1
! JVRP(4) = dARP(4)/dV(23)
  JVRP(4) = 1
! JVRP(5) = dARP(5)/dV(32)
  JVRP(5) = 1
! JVRP(6) = dARP(6)/dV(19)
  JVRP(6) = 1
! JVRP(7) = dARP(7)/dV(79)
  JVRP(7) = 1
! JVRP(8) = dARP(8)/dV(79)
  JVRP(8) = 1
! JVRP(9) = dARP(9)/dV(27)
  JVRP(9) = 1
! JVRP(10) = dARP(10)/dV(58)
  JVRP(10) = 1
! JVRP(11) = dARP(11)/dV(58)
  JVRP(11) = 1
! JVRP(12) = dARP(12)/dV(66)
  JVRP(12) = 1
! JVRP(13) = dARP(13)/dV(20)
  JVRP(13) = 1
! JVRP(14) = dARP(14)/dV(75)
  JVRP(14) = 1
! JVRP(15) = dARP(15)/dV(33)
  JVRP(15) = 1
! JVRP(16) = dARP(16)/dV(52)
  JVRP(16) = 1
! JVRP(17) = dARP(17)/dV(46)
  JVRP(17) = 1
! JVRP(18) = dARP(18)/dV(46)
  JVRP(18) = 1
! JVRP(19) = dARP(19)/dV(53)
  JVRP(19) = 1
! JVRP(20) = dARP(20)/dV(63)
  JVRP(20) = 1
! JVRP(21) = dARP(21)/dV(62)
  JVRP(21) = 1
! JVRP(22) = dARP(22)/dV(49)
  JVRP(22) = 1
! JVRP(23) = dARP(23)/dV(24)
  JVRP(23) = 1
! JVRP(24) = dARP(24)/dV(25)
  JVRP(24) = F(2)
! JVRP(25) = dARP(25)/dV(25)
  JVRP(25) = V(72)
! JVRP(26) = dARP(25)/dV(72)
  JVRP(26) = V(25)
! JVRP(27) = dARP(26)/dV(6)
  JVRP(27) = F(2)
! JVRP(28) = dARP(27)/dV(6)
  JVRP(28) = F(1)
! JVRP(29) = dARP(28)/dV(72)
  JVRP(29) = V(78)
! JVRP(30) = dARP(28)/dV(78)
  JVRP(30) = V(72)
! JVRP(31) = dARP(29)/dV(72)
  JVRP(31) = V(76)
! JVRP(32) = dARP(29)/dV(76)
  JVRP(32) = V(72)
! JVRP(33) = dARP(30)/dV(76)
  JVRP(33) = V(78)
! JVRP(34) = dARP(30)/dV(78)
  JVRP(34) = V(76)
! JVRP(35) = dARP(31)/dV(27)
  JVRP(35) = V(78)
! JVRP(36) = dARP(31)/dV(78)
  JVRP(36) = V(27)
! JVRP(37) = dARP(32)/dV(76)
  JVRP(37) = 2*V(76)
! JVRP(38) = dARP(33)/dV(76)
  JVRP(38) = 2*V(76)*F(1)
! JVRP(39) = dARP(34)/dV(25)
  JVRP(39) = V(81)
! JVRP(40) = dARP(34)/dV(81)
  JVRP(40) = V(25)
! JVRP(41) = dARP(35)/dV(25)
  JVRP(41) = V(82)
! JVRP(42) = dARP(35)/dV(82)
  JVRP(42) = V(25)
! JVRP(43) = dARP(36)/dV(25)
  JVRP(43) = V(82)
! JVRP(44) = dARP(36)/dV(82)
  JVRP(44) = V(25)
! JVRP(45) = dARP(37)/dV(78)
  JVRP(45) = V(81)
! JVRP(46) = dARP(37)/dV(81)
  JVRP(46) = V(78)
! JVRP(47) = dARP(38)/dV(78)
  JVRP(47) = V(82)
! JVRP(48) = dARP(38)/dV(82)
  JVRP(48) = V(78)
! JVRP(49) = dARP(39)/dV(78)
  JVRP(49) = V(79)
! JVRP(50) = dARP(39)/dV(79)
  JVRP(50) = V(78)
! JVRP(51) = dARP(40)/dV(76)
  JVRP(51) = V(81)
! JVRP(52) = dARP(40)/dV(81)
  JVRP(52) = V(76)
! JVRP(53) = dARP(41)/dV(76)
  JVRP(53) = V(82)
! JVRP(54) = dARP(41)/dV(82)
  JVRP(54) = V(76)
! JVRP(55) = dARP(42)/dV(19)
  JVRP(55) = 1
! JVRP(56) = dARP(43)/dV(76)
  JVRP(56) = V(79)
! JVRP(57) = dARP(43)/dV(79)
  JVRP(57) = V(76)
! JVRP(58) = dARP(44)/dV(23)
  JVRP(58) = V(78)
! JVRP(59) = dARP(44)/dV(78)
  JVRP(59) = V(23)
! JVRP(60) = dARP(45)/dV(32)
  JVRP(60) = V(78)
! JVRP(61) = dARP(45)/dV(78)
  JVRP(61) = V(32)
! JVRP(62) = dARP(46)/dV(19)
  JVRP(62) = V(78)
! JVRP(63) = dARP(46)/dV(78)
  JVRP(63) = V(19)
! JVRP(64) = dARP(47)/dV(72)
  JVRP(64) = V(81)
! JVRP(65) = dARP(47)/dV(81)
  JVRP(65) = V(72)
! JVRP(66) = dARP(48)/dV(72)
  JVRP(66) = V(82)
! JVRP(67) = dARP(48)/dV(82)
  JVRP(67) = V(72)
! JVRP(68) = dARP(49)/dV(81)
  JVRP(68) = 2*V(81)*F(2)
! JVRP(69) = dARP(50)/dV(79)
  JVRP(69) = V(81)
! JVRP(70) = dARP(50)/dV(81)
  JVRP(70) = V(79)
! JVRP(71) = dARP(51)/dV(79)
  JVRP(71) = V(82)
! JVRP(72) = dARP(51)/dV(82)
  JVRP(72) = V(79)
! JVRP(73) = dARP(52)/dV(79)
  JVRP(73) = V(82)
! JVRP(74) = dARP(52)/dV(82)
  JVRP(74) = V(79)
! JVRP(75) = dARP(53)/dV(11)
  JVRP(75) = 1
! JVRP(76) = dARP(54)/dV(79)
  JVRP(76) = 2*V(79)
! JVRP(77) = dARP(55)/dV(78)
  JVRP(77) = F(2)
! JVRP(78) = dARP(56)/dV(5)
  JVRP(78) = V(78)
! JVRP(79) = dARP(56)/dV(78)
  JVRP(79) = V(5)
! JVRP(80) = dARP(57)/dV(38)
  JVRP(80) = V(78)
! JVRP(81) = dARP(57)/dV(78)
  JVRP(81) = V(38)
! JVRP(82) = dARP(58)/dV(16)
  JVRP(82) = V(78)
! JVRP(83) = dARP(58)/dV(78)
  JVRP(83) = V(16)
! JVRP(84) = dARP(59)/dV(22)
  JVRP(84) = V(78)
! JVRP(85) = dARP(59)/dV(78)
  JVRP(85) = V(22)
! JVRP(86) = dARP(60)/dV(18)
  JVRP(86) = V(78)
! JVRP(87) = dARP(60)/dV(78)
  JVRP(87) = V(18)
! JVRP(88) = dARP(61)/dV(17)
  JVRP(88) = V(78)
! JVRP(89) = dARP(61)/dV(78)
  JVRP(89) = V(17)
! JVRP(90) = dARP(62)/dV(14)
  JVRP(90) = V(78)
! JVRP(91) = dARP(62)/dV(78)
  JVRP(91) = V(14)
! JVRP(92) = dARP(63)/dV(8)
  JVRP(92) = V(78)
! JVRP(93) = dARP(63)/dV(78)
  JVRP(93) = V(8)
! JVRP(94) = dARP(64)/dV(12)
  JVRP(94) = V(78)
! JVRP(95) = dARP(64)/dV(78)
  JVRP(95) = V(12)
! JVRP(96) = dARP(65)/dV(30)
  JVRP(96) = V(78)
! JVRP(97) = dARP(65)/dV(78)
  JVRP(97) = V(30)
! JVRP(98) = dARP(66)/dV(65)
  JVRP(98) = V(78)
! JVRP(99) = dARP(66)/dV(78)
  JVRP(99) = V(65)
! JVRP(100) = dARP(67)/dV(67)
  JVRP(100) = V(78)
! JVRP(101) = dARP(67)/dV(78)
  JVRP(101) = V(67)
! JVRP(102) = dARP(68)/dV(43)
  JVRP(102) = V(78)
! JVRP(103) = dARP(68)/dV(78)
  JVRP(103) = V(43)
! JVRP(104) = dARP(69)/dV(40)
  JVRP(104) = V(78)
! JVRP(105) = dARP(69)/dV(78)
  JVRP(105) = V(40)
! JVRP(106) = dARP(70)/dV(37)
  JVRP(106) = V(78)
! JVRP(107) = dARP(70)/dV(78)
  JVRP(107) = V(37)
! JVRP(108) = dARP(71)/dV(39)
  JVRP(108) = V(78)
! JVRP(109) = dARP(71)/dV(78)
  JVRP(109) = V(39)
! JVRP(110) = dARP(72)/dV(9)
  JVRP(110) = V(78)
! JVRP(111) = dARP(72)/dV(78)
  JVRP(111) = V(9)
! JVRP(112) = dARP(73)/dV(10)
  JVRP(112) = V(78)
! JVRP(113) = dARP(73)/dV(78)
  JVRP(113) = V(10)
! JVRP(114) = dARP(74)/dV(42)
  JVRP(114) = V(78)
! JVRP(115) = dARP(74)/dV(78)
  JVRP(115) = V(42)
! JVRP(116) = dARP(75)/dV(58)
  JVRP(116) = V(78)
! JVRP(117) = dARP(75)/dV(78)
  JVRP(117) = V(58)
! JVRP(118) = dARP(76)/dV(66)
  JVRP(118) = V(78)
! JVRP(119) = dARP(76)/dV(78)
  JVRP(119) = V(66)
! JVRP(120) = dARP(77)/dV(52)
  JVRP(120) = V(78)
! JVRP(121) = dARP(77)/dV(78)
  JVRP(121) = V(52)
! JVRP(122) = dARP(78)/dV(24)
  JVRP(122) = V(78)
! JVRP(123) = dARP(78)/dV(78)
  JVRP(123) = V(24)
! JVRP(124) = dARP(79)/dV(46)
  JVRP(124) = V(78)
! JVRP(125) = dARP(79)/dV(78)
  JVRP(125) = V(46)
! JVRP(126) = dARP(80)/dV(53)
  JVRP(126) = V(78)
! JVRP(127) = dARP(80)/dV(78)
  JVRP(127) = V(53)
! JVRP(128) = dARP(81)/dV(49)
  JVRP(128) = V(78)
! JVRP(129) = dARP(81)/dV(78)
  JVRP(129) = V(49)
! JVRP(130) = dARP(82)/dV(63)
  JVRP(130) = V(78)
! JVRP(131) = dARP(82)/dV(78)
  JVRP(131) = V(63)
! JVRP(132) = dARP(83)/dV(15)
  JVRP(132) = V(78)
! JVRP(133) = dARP(83)/dV(78)
  JVRP(133) = V(15)
! JVRP(134) = dARP(84)/dV(20)
  JVRP(134) = V(78)
! JVRP(135) = dARP(84)/dV(78)
  JVRP(135) = V(20)
! JVRP(136) = dARP(85)/dV(75)
  JVRP(136) = V(78)
! JVRP(137) = dARP(85)/dV(78)
  JVRP(137) = V(75)
! JVRP(138) = dARP(86)/dV(33)
  JVRP(138) = V(78)
! JVRP(139) = dARP(86)/dV(78)
  JVRP(139) = V(33)
! JVRP(140) = dARP(87)/dV(36)
  JVRP(140) = V(78)
! JVRP(141) = dARP(87)/dV(78)
  JVRP(141) = V(36)
! JVRP(142) = dARP(88)/dV(45)
  JVRP(142) = V(78)
! JVRP(143) = dARP(88)/dV(78)
  JVRP(143) = V(45)
! JVRP(144) = dARP(89)/dV(62)
  JVRP(144) = V(78)
! JVRP(145) = dARP(89)/dV(78)
  JVRP(145) = V(62)
! JVRP(146) = dARP(90)/dV(58)
  JVRP(146) = V(79)
! JVRP(147) = dARP(90)/dV(79)
  JVRP(147) = V(58)
! JVRP(148) = dARP(91)/dV(66)
  JVRP(148) = V(79)
! JVRP(149) = dARP(91)/dV(79)
  JVRP(149) = V(66)
! JVRP(150) = dARP(92)/dV(46)
  JVRP(150) = V(79)
! JVRP(151) = dARP(92)/dV(79)
  JVRP(151) = V(46)
! JVRP(152) = dARP(93)/dV(53)
  JVRP(152) = V(79)
! JVRP(153) = dARP(93)/dV(79)
  JVRP(153) = V(53)
! JVRP(154) = dARP(94)/dV(13)
  JVRP(154) = V(78)
! JVRP(155) = dARP(94)/dV(78)
  JVRP(155) = V(13)
! JVRP(156) = dARP(95)/dV(63)
  JVRP(156) = V(79)
! JVRP(157) = dARP(95)/dV(79)
  JVRP(157) = V(63)
! JVRP(158) = dARP(96)/dV(42)
  JVRP(158) = V(79)
! JVRP(159) = dARP(96)/dV(79)
  JVRP(159) = V(42)
! JVRP(160) = dARP(97)/dV(30)
  JVRP(160) = V(79)
! JVRP(161) = dARP(97)/dV(79)
  JVRP(161) = V(30)
! JVRP(162) = dARP(98)/dV(65)
  JVRP(162) = V(79)
! JVRP(163) = dARP(98)/dV(79)
  JVRP(163) = V(65)
! JVRP(164) = dARP(99)/dV(67)
  JVRP(164) = V(79)
! JVRP(165) = dARP(99)/dV(79)
  JVRP(165) = V(67)
! JVRP(166) = dARP(100)/dV(43)
  JVRP(166) = V(79)
! JVRP(167) = dARP(100)/dV(79)
  JVRP(167) = V(43)
! JVRP(168) = dARP(101)/dV(40)
  JVRP(168) = V(79)
! JVRP(169) = dARP(101)/dV(79)
  JVRP(169) = V(40)
! JVRP(170) = dARP(102)/dV(37)
  JVRP(170) = V(79)
! JVRP(171) = dARP(102)/dV(79)
  JVRP(171) = V(37)
! JVRP(172) = dARP(103)/dV(39)
  JVRP(172) = V(79)
! JVRP(173) = dARP(103)/dV(79)
  JVRP(173) = V(39)
! JVRP(174) = dARP(104)/dV(45)
  JVRP(174) = V(79)
! JVRP(175) = dARP(104)/dV(79)
  JVRP(175) = V(45)
! JVRP(176) = dARP(105)/dV(30)
  JVRP(176) = V(72)
! JVRP(177) = dARP(105)/dV(72)
  JVRP(177) = V(30)
! JVRP(178) = dARP(106)/dV(65)
  JVRP(178) = V(72)
! JVRP(179) = dARP(106)/dV(72)
  JVRP(179) = V(65)
! JVRP(180) = dARP(107)/dV(67)
  JVRP(180) = V(72)
! JVRP(181) = dARP(107)/dV(72)
  JVRP(181) = V(67)
! JVRP(182) = dARP(108)/dV(43)
  JVRP(182) = V(72)
! JVRP(183) = dARP(108)/dV(72)
  JVRP(183) = V(43)
! JVRP(184) = dARP(109)/dV(40)
  JVRP(184) = V(72)
! JVRP(185) = dARP(109)/dV(72)
  JVRP(185) = V(40)
! JVRP(186) = dARP(110)/dV(37)
  JVRP(186) = V(72)
! JVRP(187) = dARP(110)/dV(72)
  JVRP(187) = V(37)
! JVRP(188) = dARP(111)/dV(39)
  JVRP(188) = V(72)
! JVRP(189) = dARP(111)/dV(72)
  JVRP(189) = V(39)
! JVRP(190) = dARP(112)/dV(49)
  JVRP(190) = V(72)
! JVRP(191) = dARP(112)/dV(72)
  JVRP(191) = V(49)
! JVRP(192) = dARP(113)/dV(63)
  JVRP(192) = V(72)
! JVRP(193) = dARP(113)/dV(72)
  JVRP(193) = V(63)
! JVRP(194) = dARP(114)/dV(45)
  JVRP(194) = V(72)
! JVRP(195) = dARP(114)/dV(72)
  JVRP(195) = V(45)
! JVRP(196) = dARP(115)/dV(26)
  JVRP(196) = V(82)
! JVRP(197) = dARP(115)/dV(82)
  JVRP(197) = V(26)
! JVRP(198) = dARP(116)/dV(26)
  JVRP(198) = V(76)
! JVRP(199) = dARP(116)/dV(76)
  JVRP(199) = V(26)
! JVRP(200) = dARP(117)/dV(28)
  JVRP(200) = V(82)
! JVRP(201) = dARP(117)/dV(82)
  JVRP(201) = V(28)
! JVRP(202) = dARP(118)/dV(28)
  JVRP(202) = F(2)
! JVRP(203) = dARP(119)/dV(28)
  JVRP(203) = V(72)
! JVRP(204) = dARP(119)/dV(72)
  JVRP(204) = V(28)
! JVRP(205) = dARP(120)/dV(29)
  JVRP(205) = V(82)
! JVRP(206) = dARP(120)/dV(82)
  JVRP(206) = V(29)
! JVRP(207) = dARP(121)/dV(29)
  JVRP(207) = F(2)
! JVRP(208) = dARP(122)/dV(29)
  JVRP(208) = V(72)
! JVRP(209) = dARP(122)/dV(72)
  JVRP(209) = V(29)
! JVRP(210) = dARP(123)/dV(31)
  JVRP(210) = V(82)
! JVRP(211) = dARP(123)/dV(82)
  JVRP(211) = V(31)
! JVRP(212) = dARP(124)/dV(31)
  JVRP(212) = F(2)
! JVRP(213) = dARP(125)/dV(31)
  JVRP(213) = V(72)
! JVRP(214) = dARP(125)/dV(72)
  JVRP(214) = V(31)
! JVRP(215) = dARP(126)/dV(77)
  JVRP(215) = V(82)
! JVRP(216) = dARP(126)/dV(82)
  JVRP(216) = V(77)
! JVRP(217) = dARP(127)/dV(36)
  JVRP(217) = 1
! JVRP(218) = dARP(128)/dV(71)
  JVRP(218) = V(82)
! JVRP(219) = dARP(128)/dV(82)
  JVRP(219) = V(71)
! JVRP(220) = dARP(129)/dV(45)
  JVRP(220) = 1
! JVRP(221) = dARP(130)/dV(74)
  JVRP(221) = V(81)
! JVRP(222) = dARP(130)/dV(81)
  JVRP(222) = V(74)
! JVRP(223) = dARP(131)/dV(70)
  JVRP(223) = V(81)
! JVRP(224) = dARP(131)/dV(81)
  JVRP(224) = V(70)
! JVRP(225) = dARP(132)/dV(73)
  JVRP(225) = V(81)
! JVRP(226) = dARP(132)/dV(81)
  JVRP(226) = V(73)
! JVRP(227) = dARP(133)/dV(57)
  JVRP(227) = V(81)
! JVRP(228) = dARP(133)/dV(81)
  JVRP(228) = V(57)
! JVRP(229) = dARP(134)/dV(56)
  JVRP(229) = V(81)
! JVRP(230) = dARP(134)/dV(81)
  JVRP(230) = V(56)
! JVRP(231) = dARP(135)/dV(47)
  JVRP(231) = V(81)
! JVRP(232) = dARP(135)/dV(81)
  JVRP(232) = V(47)
! JVRP(233) = dARP(136)/dV(48)
  JVRP(233) = V(81)
! JVRP(234) = dARP(136)/dV(81)
  JVRP(234) = V(48)
! JVRP(235) = dARP(137)/dV(61)
  JVRP(235) = V(81)
! JVRP(236) = dARP(137)/dV(81)
  JVRP(236) = V(61)
! JVRP(237) = dARP(138)/dV(50)
  JVRP(237) = V(81)
! JVRP(238) = dARP(138)/dV(81)
  JVRP(238) = V(50)
! JVRP(239) = dARP(139)/dV(51)
  JVRP(239) = V(81)
! JVRP(240) = dARP(139)/dV(81)
  JVRP(240) = V(51)
! JVRP(241) = dARP(140)/dV(55)
  JVRP(241) = V(81)
! JVRP(242) = dARP(140)/dV(81)
  JVRP(242) = V(55)
! JVRP(243) = dARP(141)/dV(59)
  JVRP(243) = V(81)
! JVRP(244) = dARP(141)/dV(81)
  JVRP(244) = V(59)
! JVRP(245) = dARP(142)/dV(60)
  JVRP(245) = V(81)
! JVRP(246) = dARP(142)/dV(81)
  JVRP(246) = V(60)
! JVRP(247) = dARP(143)/dV(54)
  JVRP(247) = V(81)
! JVRP(248) = dARP(143)/dV(81)
  JVRP(248) = V(54)
! JVRP(249) = dARP(144)/dV(77)
  JVRP(249) = V(81)
! JVRP(250) = dARP(144)/dV(81)
  JVRP(250) = V(77)
! JVRP(251) = dARP(145)/dV(71)
  JVRP(251) = V(81)
! JVRP(252) = dARP(145)/dV(81)
  JVRP(252) = V(71)
! JVRP(253) = dARP(146)/dV(80)
  JVRP(253) = V(81)
! JVRP(254) = dARP(146)/dV(81)
  JVRP(254) = V(80)
! JVRP(255) = dARP(147)/dV(69)
  JVRP(255) = V(81)
! JVRP(256) = dARP(147)/dV(81)
  JVRP(256) = V(69)
! JVRP(257) = dARP(148)/dV(68)
  JVRP(257) = V(81)
! JVRP(258) = dARP(148)/dV(81)
  JVRP(258) = V(68)
! JVRP(259) = dARP(149)/dV(74)
  JVRP(259) = V(76)
! JVRP(260) = dARP(149)/dV(76)
  JVRP(260) = V(74)
! JVRP(261) = dARP(150)/dV(70)
  JVRP(261) = V(76)
! JVRP(262) = dARP(150)/dV(76)
  JVRP(262) = V(70)
! JVRP(263) = dARP(151)/dV(73)
  JVRP(263) = V(76)
! JVRP(264) = dARP(151)/dV(76)
  JVRP(264) = V(73)
! JVRP(265) = dARP(152)/dV(57)
  JVRP(265) = V(76)
! JVRP(266) = dARP(152)/dV(76)
  JVRP(266) = V(57)
! JVRP(267) = dARP(153)/dV(56)
  JVRP(267) = V(76)
! JVRP(268) = dARP(153)/dV(76)
  JVRP(268) = V(56)
! JVRP(269) = dARP(154)/dV(47)
  JVRP(269) = V(76)
! JVRP(270) = dARP(154)/dV(76)
  JVRP(270) = V(47)
! JVRP(271) = dARP(155)/dV(48)
  JVRP(271) = V(76)
! JVRP(272) = dARP(155)/dV(76)
  JVRP(272) = V(48)
! JVRP(273) = dARP(156)/dV(61)
  JVRP(273) = V(76)
! JVRP(274) = dARP(156)/dV(76)
  JVRP(274) = V(61)
! JVRP(275) = dARP(157)/dV(50)
  JVRP(275) = V(76)
! JVRP(276) = dARP(157)/dV(76)
  JVRP(276) = V(50)
! JVRP(277) = dARP(158)/dV(51)
  JVRP(277) = V(76)
! JVRP(278) = dARP(158)/dV(76)
  JVRP(278) = V(51)
! JVRP(279) = dARP(159)/dV(55)
  JVRP(279) = V(76)
! JVRP(280) = dARP(159)/dV(76)
  JVRP(280) = V(55)
! JVRP(281) = dARP(160)/dV(59)
  JVRP(281) = V(76)
! JVRP(282) = dARP(160)/dV(76)
  JVRP(282) = V(59)
! JVRP(283) = dARP(161)/dV(60)
  JVRP(283) = V(76)
! JVRP(284) = dARP(161)/dV(76)
  JVRP(284) = V(60)
! JVRP(285) = dARP(162)/dV(54)
  JVRP(285) = V(76)
! JVRP(286) = dARP(162)/dV(76)
  JVRP(286) = V(54)
! JVRP(287) = dARP(163)/dV(76)
  JVRP(287) = V(77)
! JVRP(288) = dARP(163)/dV(77)
  JVRP(288) = V(76)
! JVRP(289) = dARP(164)/dV(76)
  JVRP(289) = V(77)
! JVRP(290) = dARP(164)/dV(77)
  JVRP(290) = V(76)
! JVRP(291) = dARP(165)/dV(71)
  JVRP(291) = V(76)
! JVRP(292) = dARP(165)/dV(76)
  JVRP(292) = V(71)
! JVRP(293) = dARP(166)/dV(71)
  JVRP(293) = V(76)
! JVRP(294) = dARP(166)/dV(76)
  JVRP(294) = V(71)
! JVRP(295) = dARP(167)/dV(76)
  JVRP(295) = V(80)
! JVRP(296) = dARP(167)/dV(80)
  JVRP(296) = V(76)
! JVRP(297) = dARP(168)/dV(69)
  JVRP(297) = V(76)
! JVRP(298) = dARP(168)/dV(76)
  JVRP(298) = V(69)
! JVRP(299) = dARP(169)/dV(68)
  JVRP(299) = V(76)
! JVRP(300) = dARP(169)/dV(76)
  JVRP(300) = V(68)
! JVRP(301) = dARP(170)/dV(74)
  JVRP(301) = 2*V(74)
! JVRP(302) = dARP(171)/dV(70)
  JVRP(302) = V(74)
! JVRP(303) = dARP(171)/dV(74)
  JVRP(303) = V(70)
! JVRP(304) = dARP(172)/dV(73)
  JVRP(304) = V(74)
! JVRP(305) = dARP(172)/dV(74)
  JVRP(305) = V(73)
! JVRP(306) = dARP(173)/dV(57)
  JVRP(306) = V(74)
! JVRP(307) = dARP(173)/dV(74)
  JVRP(307) = V(57)
! JVRP(308) = dARP(174)/dV(56)
  JVRP(308) = V(74)
! JVRP(309) = dARP(174)/dV(74)
  JVRP(309) = V(56)
! JVRP(310) = dARP(175)/dV(47)
  JVRP(310) = V(74)
! JVRP(311) = dARP(175)/dV(74)
  JVRP(311) = V(47)
! JVRP(312) = dARP(176)/dV(48)
  JVRP(312) = V(74)
! JVRP(313) = dARP(176)/dV(74)
  JVRP(313) = V(48)
! JVRP(314) = dARP(177)/dV(61)
  JVRP(314) = V(74)
! JVRP(315) = dARP(177)/dV(74)
  JVRP(315) = V(61)
! JVRP(316) = dARP(178)/dV(50)
  JVRP(316) = V(74)
! JVRP(317) = dARP(178)/dV(74)
  JVRP(317) = V(50)
! JVRP(318) = dARP(179)/dV(51)
  JVRP(318) = V(74)
! JVRP(319) = dARP(179)/dV(74)
  JVRP(319) = V(51)
! JVRP(320) = dARP(180)/dV(55)
  JVRP(320) = V(74)
! JVRP(321) = dARP(180)/dV(74)
  JVRP(321) = V(55)
! JVRP(322) = dARP(181)/dV(59)
  JVRP(322) = V(74)
! JVRP(323) = dARP(181)/dV(74)
  JVRP(323) = V(59)
! JVRP(324) = dARP(182)/dV(60)
  JVRP(324) = V(74)
! JVRP(325) = dARP(182)/dV(74)
  JVRP(325) = V(60)
! JVRP(326) = dARP(183)/dV(54)
  JVRP(326) = V(74)
! JVRP(327) = dARP(183)/dV(74)
  JVRP(327) = V(54)
! JVRP(328) = dARP(184)/dV(74)
  JVRP(328) = V(77)
! JVRP(329) = dARP(184)/dV(77)
  JVRP(329) = V(74)
! JVRP(330) = dARP(185)/dV(74)
  JVRP(330) = V(77)
! JVRP(331) = dARP(185)/dV(77)
  JVRP(331) = V(74)
! JVRP(332) = dARP(186)/dV(71)
  JVRP(332) = V(74)
! JVRP(333) = dARP(186)/dV(74)
  JVRP(333) = V(71)
! JVRP(334) = dARP(187)/dV(71)
  JVRP(334) = V(74)
! JVRP(335) = dARP(187)/dV(74)
  JVRP(335) = V(71)
! JVRP(336) = dARP(188)/dV(74)
  JVRP(336) = V(80)
! JVRP(337) = dARP(188)/dV(80)
  JVRP(337) = V(74)
! JVRP(338) = dARP(189)/dV(69)
  JVRP(338) = V(74)
! JVRP(339) = dARP(189)/dV(74)
  JVRP(339) = V(69)
! JVRP(340) = dARP(190)/dV(68)
  JVRP(340) = V(74)
! JVRP(341) = dARP(190)/dV(74)
  JVRP(341) = V(68)
! JVRP(342) = dARP(191)/dV(70)
  JVRP(342) = V(77)
! JVRP(343) = dARP(191)/dV(77)
  JVRP(343) = V(70)
! JVRP(344) = dARP(192)/dV(73)
  JVRP(344) = V(77)
! JVRP(345) = dARP(192)/dV(77)
  JVRP(345) = V(73)
! JVRP(346) = dARP(193)/dV(57)
  JVRP(346) = V(77)
! JVRP(347) = dARP(193)/dV(77)
  JVRP(347) = V(57)
! JVRP(348) = dARP(194)/dV(56)
  JVRP(348) = V(77)
! JVRP(349) = dARP(194)/dV(77)
  JVRP(349) = V(56)
! JVRP(350) = dARP(195)/dV(47)
  JVRP(350) = V(77)
! JVRP(351) = dARP(195)/dV(77)
  JVRP(351) = V(47)
! JVRP(352) = dARP(196)/dV(48)
  JVRP(352) = V(77)
! JVRP(353) = dARP(196)/dV(77)
  JVRP(353) = V(48)
! JVRP(354) = dARP(197)/dV(61)
  JVRP(354) = V(77)
! JVRP(355) = dARP(197)/dV(77)
  JVRP(355) = V(61)
! JVRP(356) = dARP(198)/dV(50)
  JVRP(356) = V(77)
! JVRP(357) = dARP(198)/dV(77)
  JVRP(357) = V(50)
! JVRP(358) = dARP(199)/dV(51)
  JVRP(358) = V(77)
! JVRP(359) = dARP(199)/dV(77)
  JVRP(359) = V(51)
! JVRP(360) = dARP(200)/dV(55)
  JVRP(360) = V(77)
! JVRP(361) = dARP(200)/dV(77)
  JVRP(361) = V(55)
! JVRP(362) = dARP(201)/dV(59)
  JVRP(362) = V(77)
! JVRP(363) = dARP(201)/dV(77)
  JVRP(363) = V(59)
! JVRP(364) = dARP(202)/dV(60)
  JVRP(364) = V(77)
! JVRP(365) = dARP(202)/dV(77)
  JVRP(365) = V(60)
! JVRP(366) = dARP(203)/dV(54)
  JVRP(366) = V(77)
! JVRP(367) = dARP(203)/dV(77)
  JVRP(367) = V(54)
! JVRP(368) = dARP(204)/dV(77)
  JVRP(368) = 2*V(77)
! JVRP(369) = dARP(205)/dV(71)
  JVRP(369) = V(77)
! JVRP(370) = dARP(205)/dV(77)
  JVRP(370) = V(71)
! JVRP(371) = dARP(206)/dV(77)
  JVRP(371) = V(80)
! JVRP(372) = dARP(206)/dV(80)
  JVRP(372) = V(77)
! JVRP(373) = dARP(207)/dV(69)
  JVRP(373) = V(77)
! JVRP(374) = dARP(207)/dV(77)
  JVRP(374) = V(69)
! JVRP(375) = dARP(208)/dV(68)
  JVRP(375) = V(77)
! JVRP(376) = dARP(208)/dV(77)
  JVRP(376) = V(68)
! JVRP(377) = dARP(209)/dV(69)
  JVRP(377) = 2*V(69)
! JVRP(378) = dARP(210)/dV(68)
  JVRP(378) = V(69)
! JVRP(379) = dARP(210)/dV(69)
  JVRP(379) = V(68)
! JVRP(380) = dARP(211)/dV(68)
  JVRP(380) = 2*V(68)
! JVRP(381) = dARP(212)/dV(74)
  JVRP(381) = V(79)
! JVRP(382) = dARP(212)/dV(79)
  JVRP(382) = V(74)
! JVRP(383) = dARP(213)/dV(70)
  JVRP(383) = V(79)
! JVRP(384) = dARP(213)/dV(79)
  JVRP(384) = V(70)
! JVRP(385) = dARP(214)/dV(73)
  JVRP(385) = V(79)
! JVRP(386) = dARP(214)/dV(79)
  JVRP(386) = V(73)
! JVRP(387) = dARP(215)/dV(57)
  JVRP(387) = V(79)
! JVRP(388) = dARP(215)/dV(79)
  JVRP(388) = V(57)
! JVRP(389) = dARP(216)/dV(56)
  JVRP(389) = V(79)
! JVRP(390) = dARP(216)/dV(79)
  JVRP(390) = V(56)
! JVRP(391) = dARP(217)/dV(47)
  JVRP(391) = V(79)
! JVRP(392) = dARP(217)/dV(79)
  JVRP(392) = V(47)
! JVRP(393) = dARP(218)/dV(48)
  JVRP(393) = V(79)
! JVRP(394) = dARP(218)/dV(79)
  JVRP(394) = V(48)
! JVRP(395) = dARP(219)/dV(61)
  JVRP(395) = V(79)
! JVRP(396) = dARP(219)/dV(79)
  JVRP(396) = V(61)
! JVRP(397) = dARP(220)/dV(21)
  JVRP(397) = V(78)
! JVRP(398) = dARP(220)/dV(78)
  JVRP(398) = V(21)
! JVRP(399) = dARP(221)/dV(51)
  JVRP(399) = V(79)
! JVRP(400) = dARP(221)/dV(79)
  JVRP(400) = V(51)
! JVRP(401) = dARP(222)/dV(55)
  JVRP(401) = V(79)
! JVRP(402) = dARP(222)/dV(79)
  JVRP(402) = V(55)
! JVRP(403) = dARP(223)/dV(59)
  JVRP(403) = V(79)
! JVRP(404) = dARP(223)/dV(79)
  JVRP(404) = V(59)
! JVRP(405) = dARP(224)/dV(60)
  JVRP(405) = V(79)
! JVRP(406) = dARP(224)/dV(79)
  JVRP(406) = V(60)
! JVRP(407) = dARP(225)/dV(54)
  JVRP(407) = V(79)
! JVRP(408) = dARP(225)/dV(79)
  JVRP(408) = V(54)
! JVRP(409) = dARP(226)/dV(77)
  JVRP(409) = V(79)
! JVRP(410) = dARP(226)/dV(79)
  JVRP(410) = V(77)
! JVRP(411) = dARP(227)/dV(71)
  JVRP(411) = V(79)
! JVRP(412) = dARP(227)/dV(79)
  JVRP(412) = V(71)
! JVRP(413) = dARP(228)/dV(79)
  JVRP(413) = V(80)
! JVRP(414) = dARP(228)/dV(80)
  JVRP(414) = V(79)
! JVRP(415) = dARP(229)/dV(69)
  JVRP(415) = V(79)
! JVRP(416) = dARP(229)/dV(79)
  JVRP(416) = V(69)
! JVRP(417) = dARP(230)/dV(68)
  JVRP(417) = V(79)
! JVRP(418) = dARP(230)/dV(79)
  JVRP(418) = V(68)
! JVRP(419) = dARP(231)/dV(64)
  JVRP(419) = V(76)
! JVRP(420) = dARP(231)/dV(76)
  JVRP(420) = V(64)
! JVRP(421) = dARP(232)/dV(64)
  JVRP(421) = V(74)
! JVRP(422) = dARP(232)/dV(74)
  JVRP(422) = V(64)
! JVRP(423) = dARP(233)/dV(64)
  JVRP(423) = V(77)
! JVRP(424) = dARP(233)/dV(77)
  JVRP(424) = V(64)
! JVRP(425) = dARP(234)/dV(64)
  JVRP(425) = 2*V(64)
! JVRP(426) = dARP(235)/dV(64)
  JVRP(426) = V(81)
! JVRP(427) = dARP(235)/dV(81)
  JVRP(427) = V(64)
! JVRP(428) = dARP(236)/dV(64)
  JVRP(428) = V(79)
! JVRP(429) = dARP(236)/dV(79)
  JVRP(429) = V(64)
! JVRP(430) = dARP(237)/dV(50)
  JVRP(430) = 2*V(50)
! JVRP(431) = dARP(238)/dV(7)
  JVRP(431) = V(78)
! JVRP(432) = dARP(238)/dV(78)
  JVRP(432) = V(7)
! JVRP(433) = dARP(239)/dV(34)
  JVRP(433) = V(78)
! JVRP(434) = dARP(239)/dV(78)
  JVRP(434) = V(34)
! JVRP(435) = dARP(240)/dV(44)
  JVRP(435) = V(81)
! JVRP(436) = dARP(240)/dV(81)
  JVRP(436) = V(44)
! JVRP(437) = dARP(241)/dV(44)
  JVRP(437) = V(76)
! JVRP(438) = dARP(241)/dV(76)
  JVRP(438) = V(44)
! JVRP(439) = dARP(242)/dV(44)
  JVRP(439) = 2*V(44)
! JVRP(440) = dARP(243)/dV(44)
  JVRP(440) = V(82)
! JVRP(441) = dARP(243)/dV(82)
  JVRP(441) = V(44)
! JVRP(442) = dARP(244)/dV(21)
  JVRP(442) = 1
! JVRP(443) = dARP(245)/dV(35)
  JVRP(443) = V(78)
! JVRP(444) = dARP(245)/dV(78)
  JVRP(444) = V(35)
! JVRP(445) = dARP(246)/dV(35)
  JVRP(445) = V(72)
! JVRP(446) = dARP(246)/dV(72)
  JVRP(446) = V(35)
! JVRP(447) = dARP(247)/dV(35)
  JVRP(447) = V(79)
! JVRP(448) = dARP(247)/dV(79)
  JVRP(448) = V(35)
! JVRP(449) = dARP(248)/dV(41)
  JVRP(449) = V(78)
! JVRP(450) = dARP(248)/dV(78)
  JVRP(450) = V(41)
! JVRP(451) = dARP(249)/dV(41)
  JVRP(451) = V(79)
! JVRP(452) = dARP(249)/dV(79)
  JVRP(452) = V(41)
! JVRP(453) = dARP(250)/dV(41)
  JVRP(453) = V(72)
! JVRP(454) = dARP(250)/dV(72)
  JVRP(454) = V(41)
      
END SUBROUTINE JacReactantProd

! End of JacReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



! Begin Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Fun with respect to rate coefficients
! -----------------------------------------------------------------------------

      SUBROUTINE  dFun_dRcoeff( V, F, NCOEFF, JCOEFF, DFDR )
       
      USE RACM_Parameters
      USE RACM_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/radical/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Fun(1:NVAR) / d RCT( JCOEFF(j) )
!         for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DFDR(NVAR*NCOEFF)

! Local vector with reactant products
      REAL(kind=dp) A_RPROD(NREACT)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the reactant products of all reactions     
      CALL ReactantProd ( V, F, A_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_RPROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DFDR(i+NVAR*(j-1)) = 0.0_dp 
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  reactant product  of the JCOEFF(j)-th reaction      
!                  give the j-th column of the derivative matrix   
         aj = A_RPROD(JCOEFF(j))
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DFDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dFun_dRcoeff

! End Derivative w.r.t. Rate Coefficients


! Begin Jacobian Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Jac with respect to rate coefficients
! Times a user vector
! -----------------------------------------------------------------------------

      SUBROUTINE  dJac_dRcoeff( V, F, U, NCOEFF, JCOEFF, DJDR )
       
      USE RACM_Parameters
      USE RACM_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! U - User-supplied Vector           
      REAL(kind=dp) U(NVAR)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Jac(1:NVAR) / d RCT( JCOEFF(j) ) * U
!                     for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DJDR(NVAR*NCOEFF)

! Local vector for Jacobian of reactant products
      REAL(kind=dp) JV_RPROD(NJVRP)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the Jacobian of all reactant products   
      CALL JacReactantProd( V, F, JV_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_PROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DJDR(i+NVAR*(j-1)) = 0.0_dp
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  ( Gradient of reactant product of the JCOEFF(j)-th reaction X user vector )    
!                  give the j-th column of the derivative matrix   
!
!          Row JCOEFF(j) of JV_RPROD times the user vector
         aj = 0.0_dp
         DO k=CROW_JVRP(JCOEFF(j)),CROW_JVRP(JCOEFF(j)+1)-1
             aj = aj + JV_RPROD(k)*U(ICOL_JVRP(k))
         END DO
!          Column JCOEFF(j) of Stoichiom. matrix times aj         
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DJDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dJac_dRcoeff

! End Jacobian Derivative w.r.t. Rate Coefficients


END MODULE RACM_Stoichiom

