! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Linear Algebra Data and Routines File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RACM_LinearAlgebra.f90
! Time                 : Thu Oct  8 08:22:22 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RACM_22746_BOXMOX
! Equation file        : RACM.kpp
! Output root filename : RACM
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RACM_LinearAlgebra

  USE RACM_Parameters
  USE RACM_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! SPARSE_UTIL - SPARSE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecomp( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RACM_Parameters
  USE RACM_JacobianSP

      INTEGER  :: IER
      REAL(kind=dp) :: JVS(LU_NONZERO), W(NVAR), a
      INTEGER  :: k, kk, j, jj

      a = 0. ! mz_rs_20050606
      IER = 0
      DO k=1,NVAR
        ! mz_rs_20050606: don't check if real value == 0
        ! IF ( JVS( LU_DIAG(k) ) .EQ. 0. ) THEN
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(a) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecomp


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplx( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization, complex
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RACM_Parameters
  USE RACM_JacobianSP

      INTEGER        :: IER
      DOUBLE COMPLEX :: JVS(LU_NONZERO), W(NVAR), a
      REAL(kind=dp)  :: b = 0.0
      INTEGER        :: k, kk, j, jj

      IER = 0
      DO k=1,NVAR
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(b) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecompCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplxR( JVSR, JVSI, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!    Sparse LU factorization, complex
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RACM_Parameters
  USE RACM_JacobianSP

      INTEGER       :: IER
      REAL(kind=dp) :: JVSR(LU_NONZERO), JVSI(LU_NONZERO) 
      REAL(kind=dp) :: WR(NVAR), WI(NVAR), ar, ai, den
      INTEGER       :: k, kk, j, jj

      IER = 0
      ar  = 0.0
      DO k=1,NVAR
        IF (  ( ABS(JVSR(LU_DIAG(k))) < TINY(ar) ) .AND. &
              ( ABS(JVSI(LU_DIAG(k))) < TINY(ar) ) )  THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              WR( LU_ICOL(kk) ) = JVSR(kk)
              WI( LU_ICOL(kk) ) = JVSI(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            den = JVSR(LU_DIAG(j))**2 + JVSI(LU_DIAG(j))**2
            ar = -(WR(j)*JVSR(LU_DIAG(j)) + WI(j)*JVSI(LU_DIAG(j)))/den
            ai = -(WI(j)*JVSR(LU_DIAG(j)) - WR(j)*JVSI(LU_DIAG(j)))/den
            WR(j) = -ar
            WI(j) = -ai
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               WR( LU_ICOL(jj) ) = WR( LU_ICOL(jj) ) + ar*JVSR(jj) - ai*JVSI(jj)
               WI( LU_ICOL(jj) ) = WI( LU_ICOL(jj) ) + ar*JVSI(jj) + ai*JVSR(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVSR(kk) = WR( LU_ICOL(kk) )
            JVSI(kk) = WI( LU_ICOL(kk) )
         END DO
      END DO

END SUBROUTINE KppDecompCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RACM_Parameters
  USE RACM_JacobianSP

      INTEGER  :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RACM_Parameters
  USE RACM_JacobianSP

      INTEGER       :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RACM_Parameters
  USE RACM_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveCmplx

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RACM_Parameters
  USE RACM_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), sumr, sumi, den

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             XR(i) = XR(i) - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
             XI(i) = XI(i) - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
         END DO  
      END DO

      DO i=NVAR,1,-1
        sumr = XR(i); sumi = XI(i)
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
            sumr = sumr - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
            sumi = sumi - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
        END DO
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (sumr*JVSR(LU_DIAG(i)) + sumi*JVSI(LU_DIAG(i)))/den
        XI(i) = (sumi*JVSR(LU_DIAG(i)) - sumr*JVSI(LU_DIAG(i)))/den
      END DO
      
END SUBROUTINE KppSolveCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RACM_Parameters
  USE RACM_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve transpose subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE RACM_Parameters
  USE RACM_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), den

      DO i=1,NVAR
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (XR(i)*JVSR(LU_DIAG(i)) + XI(i)*JVSI(LU_DIAG(i)))/den
        XI(i) = (XI(i)*JVSR(LU_DIAG(i)) - XR(i)*JVSI(LU_DIAG(i)))/den
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplxR


!
! Next few commented subroutines perform sparse big linear algebra
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppDecompBig( JVS, IP, IER )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse LU factorization
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE RACM_Parameters
!  USE RACM_JacobianSP
!
!      INTEGER  :: IP3(3), IER, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), W(3,3,NVAR), a(3,3), E(3,3)
!      INTEGER  :: k, kk, j, jj
!
!      a = 0.0d0
!      IER = 0
!      DO k=1,NVAR
!        DO kk = LU_CROW(k), LU_CROW(k+1)-1
!              W( 1:3,1:3,LU_ICOL(kk) ) = JVS(1:3,1:3,kk)
!        END DO
!        DO kk = LU_CROW(k), LU_DIAG(k)-1
!            j = LU_ICOL(kk)
!            E(1:3,1:3) = JVS( 1:3,1:3,LU_DIAG(j) )
!            ! CALL DGETRF(3,3,E,3,IP3,IER) 
!            CALL FAC3(E,IP3,IER)
!            IF ( IER /= 0 )  RETURN
!            ! a = W(j) / JVS( LU_DIAG(j) )
!            a(1:3,1:3) = W( 1:3,1:3,j )
!            ! CALL DGETRS ('N',3,3,E,3,IP3,a,3,IER) 
!            CALL SOL3('N',E,IP3,a(1,1))
!            CALL SOL3('N',E,IP3,a(1,2))
!            CALL SOL3('N',E,IP3,a(1,3))
!            W(1:3,1:3,j) = a(1:3,1:3)
!            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
!               W( 1:3,1:3,LU_ICOL(jj) ) = W( 1:3,1:3,LU_ICOL(jj) ) &
!                        - MATMUL( a(1:3,1:3) , JVS(1:3,1:3,jj) )
!            END DO
!         END DO
!         DO kk = LU_CROW(k), LU_CROW(k+1)-1
!            JVS(1:3,1:3,kk) = W( 1:3,1:3,LU_ICOL(kk) )
!         END DO
!      END DO
!
!      DO k=1,NVAR
!         ! CALL WGEFA(JVS(1,1,LU_DIAG(k)),3,3,IP(1,k),IER)
!         ! CALL DGETRF(3,3,JVS(1,1,LU_DIAG(k)),3,IP(1,k),IER)
!         CALL FAC3(JVS(1,1,LU_DIAG(k)),IP(1,k),IER)
!         IF ( IER /= 0 )  RETURN
!      END DO 
!      
!END SUBROUTINE KppDecompBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBig( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse solve subroutine using indirect addressing
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE RACM_Parameters
!  USE RACM_JacobianSP
!
!      INTEGER  :: i, j, k, m, IP3(3), IP(3,NVAR), IER
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR), sum(3)
!
!      DO i=1,NVAR
!        DO j = LU_CROW(i), LU_DIAG(i)-1 
!          !X(1:3,i) = X(1:3,i) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       X(k,i) = X(k,i) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO  
!      END DO
!
!      DO i=NVAR,1,-1
!        sum(1:3) = X(1:3,i);
!        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
!          !sum(1:3) = sum(1:3) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       sum(k) = sum(k) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO
!        ! X(i) = sum/JVS(LU_DIAG(i));
!        ! CALL DGETRS ('N',3,1,JVS(1:3,1:3,LU_DIAG(i)),3,IP(1,i),sum,3,0) 
!        ! CALL WGESL('N',JVS(1,1,LU_DIAG(i)),3,3,IP(1,i),sum)
!        CALL SOL3('N',JVS(1,1,LU_DIAG(i)),IP(1,i),sum)
!        X(1:3,i) = sum(1:3)
!      END DO
!      
!END SUBROUTINE KppSolveBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBigTR( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Big sparse transpose solve using indirect addressing
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE RACM_Parameters
!  USE RACM_JacobianSP
!
!      INTEGER       :: i, j, k, m, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR)
!
!      DO i=1,NVAR
!        ! X(i) = X(i)/JVS(LU_DIAG(i))
!        CALL SOL3('T',JVS(1,1,LU_DIAG(i)),IP(1,i),X(1,i))
!        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !    - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!
!      DO i=NVAR, 1, -1
!        DO j=LU_CROW(i),LU_DIAG(i)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !   - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!      
!END SUBROUTINE KppSolveBigTR
!
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE FAC3(A,IPVT,INFO)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     FAC3 FACTORS THE MATRIX A (3,3) BY
!!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!!     LINPACK - LIKE 
!!
!!     Remove comments to perform pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!
!      REAL(kind=dp) :: A(3,3)
!      INTEGER       :: IPVT(3),INFO
!!      INTEGER       :: L
!!      REAL(kind=dp) :: t, dmax, da, TMP(3)
!      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0
!
!      info = 0
!!      t = TINY(da)
!!      
!!      da = ABS(A(1,1)); L = 1
!!      IF ( ABS(A(2,1))>da ) THEN
!!        da = ABS(A(2,1)); L = 2
!!        IF ( ABS(A(3,1))>da ) THEN
!!          L = 3
!!        END IF  
!!      END IF  
!!      IPVT(1)  = L
!!      IF (L /=1 ) THEN
!!         TMP(1:3) = A(L,1:3)
!!         A(L,1:3) = A(1,1:3)
!!         A(1,1:3) = TMP(1:3)
!!      END IF
!!      IF (ABS(A(1,1)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!
!      A(2,1) = A(2,1)/A(1,1)
!      A(2,2) = A(2,2) - A(2,1)*A(1,2)
!      A(2,3) = A(2,3) - A(2,1)*A(1,3)
!      A(3,1) = A(3,1)/A(1,1)
!      A(3,2) = A(3,2) - A(3,1)*A(1,2)
!      A(3,3) = A(3,3) - A(3,1)*A(1,3)
!      
!!      IPVT(2)  = 2
!!      IF (ABS(A(3,2))>ABS(A(2,2))) THEN
!!         IPVT(2)  = 3
!!         TMP(2:3) = A(3,2:3)
!!         A(3,2:3) = A(2,2:3)
!!         A(2,2:3) = TMP(2:3)
!!      END IF
!!      IF (ABS(A(2,2)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!      
!      A(3,2)   = A(3,2)/A(2,2)
!      A(3,3)   = A(3,3) - A(3,2)*A(2,3)
!      IPVT(3)  = 3
!      
!END SUBROUTINE FAC3
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE SOL3(Trans,A,IPVT,b)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     SOL3 solves the system 3x3
!!     A * x = b  or  trans(a) * x = b
!!     using the factors computed by WGEFA.
!!
!!     Trans      = 'N'   to solve  A*x = b ,
!!                = 'T'   to solve  transpose(A)*x = b
!!     LINPACK - LIKE 
!!
!!     Remove comments to use pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!      CHARACTER     :: Trans
!      REAL(kind=dp) :: a(3,3),b(3)
!      INTEGER       :: IPVT(3)
!!      INTEGER       :: L
!!      REAL(kind=dp) :: TMP
!      
!      SELECT CASE (Trans)
!
!      CASE ('n','N')  !  Solve  A * x = b
!
!!     Solve  L*y = b
!!         L = IPVT(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!         b(2) = b(2)-A(2,1)*b(1)
!         b(3) = b(3)-A(3,1)*b(1)
!         
!!         L = IPVT(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(3) = b(3)-A(3,2)*b(2)
!
!!     Solve  U*x = y
!         b(3) = b(3)/A(3,3)
!         b(2) = (b(2)-A(2,3)*b(3))/A(2,2)
!         b(1) = (b(1)-A(1,3)*b(3)-A(1,2)*b(2))/A(1,1)
!      
!      
!      CASE ('t','T')  !  Solve transpose(A) * x = b
!
!!      Solve transpose(U)*y = b
!         b(1) = b(1)/A(1,1)
!         b(2) = (b(2)-A(1,2)*b(1))/A(2,2)
!         b(3) = (b(3)-A(1,3)*b(1)-A(2,3)*b(2))/A(3,3)
!
!!      Solve transpose(L)*x = y
!         b(2) = b(2)-A(3,2)*b(3)
!!         L = ipvt(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(1) = b(1)-A(3,1)*b(3)-A(2,1)*b(2)
!!         L = ipvt(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!   
!      END SELECT
!
!END SUBROUTINE SOL3

! End of SPARSE_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolve - sparse back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolve ( JVS, X )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)

  X(22) = X(22)-JVS(98)*X(21)
  X(24) = X(24)-JVS(112)*X(12)
  X(25) = X(25)-JVS(118)*X(6)
  X(28) = X(28)-JVS(142)*X(9)
  X(29) = X(29)-JVS(147)*X(10)
  X(38) = X(38)-JVS(199)*X(14)-JVS(200)*X(16)-JVS(201)*X(30)-JVS(202)*X(34)-JVS(203)*X(37)
  X(42) = X(42)-JVS(236)*X(26)-JVS(237)*X(28)-JVS(238)*X(29)-JVS(239)*X(31)
  X(44) = X(44)-JVS(250)*X(13)-JVS(251)*X(21)-JVS(252)*X(40)
  X(46) = X(46)-JVS(267)*X(14)
  X(47) = X(47)-JVS(280)*X(30)
  X(49) = X(49)-JVS(297)*X(7)-JVS(298)*X(35)-JVS(299)*X(39)-JVS(300)*X(40)-JVS(301)*X(43)
  X(50) = X(50)-JVS(312)*X(40)-JVS(313)*X(43)
  X(51) = X(51)-JVS(322)*X(37)
  X(52) = X(52)-JVS(331)*X(8)-JVS(332)*X(15)-JVS(333)*X(35)-JVS(334)*X(37)-JVS(335)*X(41)-JVS(336)*X(48)-JVS(337)*X(51)
  X(53) = X(53)-JVS(358)*X(22)-JVS(359)*X(24)-JVS(360)*X(34)-JVS(361)*X(40)-JVS(362)*X(44)-JVS(363)*X(45)-JVS(364)*X(49)&
            &-JVS(365)*X(50)
  X(54) = X(54)-JVS(383)*X(31)-JVS(384)*X(42)
  X(55) = X(55)-JVS(394)*X(39)
  X(56) = X(56)-JVS(403)*X(12)
  X(57) = X(57)-JVS(411)*X(8)
  X(58) = X(58)-JVS(419)*X(14)-JVS(420)*X(16)-JVS(421)*X(20)-JVS(422)*X(24)-JVS(423)*X(30)-JVS(424)*X(33)-JVS(425)*X(34)&
            &-JVS(426)*X(35)-JVS(427)*X(36)-JVS(428)*X(39)-JVS(429)*X(40)-JVS(430)*X(41)-JVS(431)*X(43)-JVS(432)*X(44)&
            &-JVS(433)*X(45)-JVS(434)*X(46)-JVS(435)*X(47)-JVS(436)*X(48)-JVS(437)*X(49)-JVS(438)*X(50)-JVS(439)*X(51)&
            &-JVS(440)*X(54)-JVS(441)*X(55)-JVS(442)*X(56)-JVS(443)*X(57)
  X(59) = X(59)-JVS(466)*X(28)
  X(60) = X(60)-JVS(476)*X(29)
  X(61) = X(61)-JVS(486)*X(35)-JVS(487)*X(41)
  X(62) = X(62)-JVS(497)*X(26)-JVS(498)*X(42)-JVS(499)*X(45)-JVS(500)*X(51)-JVS(501)*X(55)-JVS(502)*X(56)-JVS(503)*X(57)&
            &-JVS(504)*X(59)-JVS(505)*X(60)
  X(63) = X(63)-JVS(519)*X(59)-JVS(520)*X(60)
  X(64) = X(64)-JVS(530)*X(9)-JVS(531)*X(10)-JVS(532)*X(33)-JVS(533)*X(36)-JVS(534)*X(42)-JVS(535)*X(43)-JVS(536)*X(45)&
            &-JVS(537)*X(56)-JVS(538)*X(57)-JVS(539)*X(63)
  X(65) = X(65)-JVS(553)*X(39)-JVS(554)*X(43)-JVS(555)*X(50)
  X(66) = X(66)-JVS(564)*X(12)-JVS(565)*X(14)-JVS(566)*X(15)-JVS(567)*X(35)-JVS(568)*X(37)-JVS(569)*X(41)-JVS(570)*X(47)&
            &-JVS(571)*X(48)-JVS(572)*X(51)-JVS(573)*X(56)-JVS(574)*X(57)-JVS(575)*X(61)-JVS(576)*X(62)-JVS(577)*X(63)&
            &-JVS(578)*X(65)
  X(67) = X(67)-JVS(596)*X(50)-JVS(597)*X(55)
  X(68) = X(68)-JVS(606)*X(30)-JVS(607)*X(35)-JVS(608)*X(37)-JVS(609)*X(39)-JVS(610)*X(41)-JVS(611)*X(43)-JVS(612)*X(65)&
            &-JVS(613)*X(67)
  X(69) = X(69)-JVS(623)*X(30)-JVS(624)*X(35)-JVS(625)*X(37)-JVS(626)*X(39)-JVS(627)*X(41)-JVS(628)*X(43)-JVS(629)*X(65)&
            &-JVS(630)*X(67)-JVS(631)*X(68)
  X(70) = X(70)-JVS(640)*X(17)-JVS(641)*X(37)-JVS(642)*X(39)-JVS(643)*X(41)-JVS(644)*X(52)-JVS(645)*X(56)-JVS(646)*X(57)&
            &-JVS(647)*X(61)-JVS(648)*X(62)-JVS(649)*X(63)-JVS(650)*X(65)-JVS(651)*X(67)-JVS(652)*X(68)-JVS(653)*X(69)
  X(71) = X(71)-JVS(667)*X(45)-JVS(668)*X(63)
  X(72) = X(72)-JVS(678)*X(25)-JVS(679)*X(28)-JVS(680)*X(29)-JVS(681)*X(30)-JVS(682)*X(31)-JVS(683)*X(35)-JVS(684)*X(37)&
            &-JVS(685)*X(39)-JVS(686)*X(40)-JVS(687)*X(41)-JVS(688)*X(42)-JVS(689)*X(43)-JVS(690)*X(45)-JVS(691)*X(49)&
            &-JVS(692)*X(50)-JVS(693)*X(55)-JVS(694)*X(63)-JVS(695)*X(65)-JVS(696)*X(67)-JVS(697)*X(71)
  X(73) = X(73)-JVS(706)*X(14)-JVS(707)*X(62)-JVS(708)*X(68)-JVS(709)*X(69)-JVS(710)*X(71)-JVS(711)*X(72)
  X(74) = X(74)-JVS(721)*X(18)-JVS(722)*X(20)-JVS(723)*X(33)-JVS(724)*X(40)-JVS(725)*X(41)-JVS(726)*X(43)-JVS(727)*X(47)&
            &-JVS(728)*X(48)-JVS(729)*X(50)-JVS(730)*X(51)-JVS(731)*X(54)-JVS(732)*X(55)-JVS(733)*X(56)-JVS(734)*X(57)&
            &-JVS(735)*X(59)-JVS(736)*X(60)-JVS(737)*X(61)-JVS(738)*X(63)-JVS(739)*X(64)-JVS(740)*X(65)-JVS(741)*X(66)&
            &-JVS(742)*X(67)-JVS(743)*X(68)-JVS(744)*X(69)-JVS(745)*X(70)-JVS(746)*X(71)-JVS(747)*X(72)-JVS(748)*X(73)
  X(75) = X(75)-JVS(758)*X(47)-JVS(759)*X(48)-JVS(760)*X(51)-JVS(761)*X(54)-JVS(762)*X(55)-JVS(763)*X(56)-JVS(764)*X(57)&
            &-JVS(765)*X(59)-JVS(766)*X(60)-JVS(767)*X(61)-JVS(768)*X(64)-JVS(769)*X(65)-JVS(770)*X(67)-JVS(771)*X(70)&
            &-JVS(772)*X(71)-JVS(773)*X(72)-JVS(774)*X(73)-JVS(775)*X(74)
  X(76) = X(76)-JVS(784)*X(5)-JVS(785)*X(8)-JVS(786)*X(9)-JVS(787)*X(10)-JVS(788)*X(12)-JVS(789)*X(14)-JVS(790)*X(15)&
            &-JVS(791)*X(19)-JVS(792)*X(20)-JVS(793)*X(22)-JVS(794)*X(24)-JVS(795)*X(26)-JVS(796)*X(27)-JVS(797)*X(28)&
            &-JVS(798)*X(29)-JVS(799)*X(30)-JVS(800)*X(31)-JVS(801)*X(33)-JVS(802)*X(34)-JVS(803)*X(37)-JVS(804)*X(38)&
            &-JVS(805)*X(39)-JVS(806)*X(40)-JVS(807)*X(41)-JVS(808)*X(42)-JVS(809)*X(43)-JVS(810)*X(44)-JVS(811)*X(45)&
            &-JVS(812)*X(46)-JVS(813)*X(47)-JVS(814)*X(48)-JVS(815)*X(49)-JVS(816)*X(50)-JVS(817)*X(51)-JVS(818)*X(53)&
            &-JVS(819)*X(54)-JVS(820)*X(55)-JVS(821)*X(56)-JVS(822)*X(57)-JVS(823)*X(58)-JVS(824)*X(59)-JVS(825)*X(60)&
            &-JVS(826)*X(61)-JVS(827)*X(62)-JVS(828)*X(63)-JVS(829)*X(64)-JVS(830)*X(65)-JVS(831)*X(66)-JVS(832)*X(67)&
            &-JVS(833)*X(68)-JVS(834)*X(69)-JVS(835)*X(70)-JVS(836)*X(71)-JVS(837)*X(72)-JVS(838)*X(73)-JVS(839)*X(74)&
            &-JVS(840)*X(75)
  X(77) = X(77)-JVS(848)*X(24)-JVS(849)*X(33)-JVS(850)*X(36)-JVS(851)*X(40)-JVS(852)*X(43)-JVS(853)*X(44)-JVS(854)*X(45)&
            &-JVS(855)*X(47)-JVS(856)*X(48)-JVS(857)*X(49)-JVS(858)*X(50)-JVS(859)*X(51)-JVS(860)*X(52)-JVS(861)*X(53)&
            &-JVS(862)*X(54)-JVS(863)*X(55)-JVS(864)*X(56)-JVS(865)*X(57)-JVS(866)*X(59)-JVS(867)*X(60)-JVS(868)*X(61)&
            &-JVS(869)*X(62)-JVS(870)*X(63)-JVS(871)*X(64)-JVS(872)*X(65)-JVS(873)*X(66)-JVS(874)*X(67)-JVS(875)*X(68)&
            &-JVS(876)*X(69)-JVS(877)*X(70)-JVS(878)*X(71)-JVS(879)*X(72)-JVS(880)*X(73)-JVS(881)*X(74)-JVS(882)*X(75)&
            &-JVS(883)*X(76)
  X(78) = X(78)-JVS(890)*X(5)-JVS(891)*X(6)-JVS(892)*X(8)-JVS(893)*X(9)-JVS(894)*X(10)-JVS(895)*X(12)-JVS(896)*X(13)&
            &-JVS(897)*X(14)-JVS(898)*X(15)-JVS(899)*X(16)-JVS(900)*X(17)-JVS(901)*X(18)-JVS(902)*X(19)-JVS(903)*X(20)&
            &-JVS(904)*X(21)-JVS(905)*X(22)-JVS(906)*X(23)-JVS(907)*X(24)-JVS(908)*X(27)-JVS(909)*X(28)-JVS(910)*X(29)&
            &-JVS(911)*X(30)-JVS(912)*X(31)-JVS(913)*X(32)-JVS(914)*X(33)-JVS(915)*X(34)-JVS(916)*X(35)-JVS(917)*X(36)&
            &-JVS(918)*X(37)-JVS(919)*X(38)-JVS(920)*X(39)-JVS(921)*X(40)-JVS(922)*X(41)-JVS(923)*X(42)-JVS(924)*X(43)&
            &-JVS(925)*X(44)-JVS(926)*X(45)-JVS(927)*X(46)-JVS(928)*X(49)-JVS(929)*X(50)-JVS(930)*X(52)-JVS(931)*X(53)&
            &-JVS(932)*X(54)-JVS(933)*X(55)-JVS(934)*X(56)-JVS(935)*X(57)-JVS(936)*X(58)-JVS(937)*X(59)-JVS(938)*X(60)&
            &-JVS(939)*X(61)-JVS(940)*X(62)-JVS(941)*X(63)-JVS(942)*X(64)-JVS(943)*X(65)-JVS(944)*X(66)-JVS(945)*X(67)&
            &-JVS(946)*X(68)-JVS(947)*X(69)-JVS(948)*X(70)-JVS(949)*X(71)-JVS(950)*X(72)-JVS(951)*X(73)-JVS(952)*X(74)&
            &-JVS(953)*X(75)-JVS(954)*X(76)-JVS(955)*X(77)
  X(79) = X(79)-JVS(961)*X(11)-JVS(962)*X(19)-JVS(963)*X(25)-JVS(964)*X(30)-JVS(965)*X(32)-JVS(966)*X(35)-JVS(967)*X(36)&
            &-JVS(968)*X(37)-JVS(969)*X(39)-JVS(970)*X(40)-JVS(971)*X(41)-JVS(972)*X(42)-JVS(973)*X(43)-JVS(974)*X(45)&
            &-JVS(975)*X(46)-JVS(976)*X(47)-JVS(977)*X(48)-JVS(978)*X(51)-JVS(979)*X(53)-JVS(980)*X(54)-JVS(981)*X(55)&
            &-JVS(982)*X(56)-JVS(983)*X(57)-JVS(984)*X(58)-JVS(985)*X(59)-JVS(986)*X(60)-JVS(987)*X(61)-JVS(988)*X(63)&
            &-JVS(989)*X(64)-JVS(990)*X(65)-JVS(991)*X(66)-JVS(992)*X(67)-JVS(993)*X(68)-JVS(994)*X(69)-JVS(995)*X(70)&
            &-JVS(996)*X(71)-JVS(997)*X(72)-JVS(998)*X(73)-JVS(999)*X(74)-JVS(1000)*X(75)-JVS(1001)*X(76)-JVS(1002)*X(77)&
            &-JVS(1003)*X(78)
  X(80) = X(80)-JVS(1008)*X(37)-JVS(1009)*X(39)-JVS(1010)*X(41)-JVS(1011)*X(43)-JVS(1012)*X(52)-JVS(1013)*X(56)&
            &-JVS(1014)*X(57)-JVS(1015)*X(61)-JVS(1016)*X(62)-JVS(1017)*X(63)-JVS(1018)*X(65)-JVS(1019)*X(67)-JVS(1020)&
            &*X(68)-JVS(1021)*X(69)-JVS(1022)*X(71)-JVS(1023)*X(72)-JVS(1024)*X(73)-JVS(1025)*X(74)-JVS(1026)*X(75)&
            &-JVS(1027)*X(76)-JVS(1028)*X(77)-JVS(1029)*X(78)-JVS(1030)*X(79)
  X(81) = X(81)-JVS(1034)*X(23)-JVS(1035)*X(25)-JVS(1036)*X(28)-JVS(1037)*X(29)-JVS(1038)*X(31)-JVS(1039)*X(42)&
            &-JVS(1040)*X(43)-JVS(1041)*X(44)-JVS(1042)*X(47)-JVS(1043)*X(48)-JVS(1044)*X(49)-JVS(1045)*X(50)-JVS(1046)&
            &*X(51)-JVS(1047)*X(54)-JVS(1048)*X(55)-JVS(1049)*X(56)-JVS(1050)*X(57)-JVS(1051)*X(59)-JVS(1052)*X(60)&
            &-JVS(1053)*X(61)-JVS(1054)*X(64)-JVS(1055)*X(65)-JVS(1056)*X(67)-JVS(1057)*X(68)-JVS(1058)*X(69)-JVS(1059)&
            &*X(70)-JVS(1060)*X(71)-JVS(1061)*X(72)-JVS(1062)*X(73)-JVS(1063)*X(74)-JVS(1064)*X(75)-JVS(1065)*X(76)&
            &-JVS(1066)*X(77)-JVS(1067)*X(78)-JVS(1068)*X(79)-JVS(1069)*X(80)
  X(82) = X(82)-JVS(1072)*X(11)-JVS(1073)*X(16)-JVS(1074)*X(19)-JVS(1075)*X(21)-JVS(1076)*X(23)-JVS(1077)*X(25)&
            &-JVS(1078)*X(26)-JVS(1079)*X(28)-JVS(1080)*X(29)-JVS(1081)*X(31)-JVS(1082)*X(32)-JVS(1083)*X(34)-JVS(1084)&
            &*X(36)-JVS(1085)*X(40)-JVS(1086)*X(42)-JVS(1087)*X(43)-JVS(1088)*X(44)-JVS(1089)*X(45)-JVS(1090)*X(46)&
            &-JVS(1091)*X(47)-JVS(1092)*X(48)-JVS(1093)*X(49)-JVS(1094)*X(50)-JVS(1095)*X(51)-JVS(1096)*X(53)-JVS(1097)&
            &*X(54)-JVS(1098)*X(55)-JVS(1099)*X(56)-JVS(1100)*X(57)-JVS(1101)*X(58)-JVS(1102)*X(59)-JVS(1103)*X(60)&
            &-JVS(1104)*X(61)-JVS(1105)*X(62)-JVS(1106)*X(63)-JVS(1107)*X(64)-JVS(1108)*X(65)-JVS(1109)*X(66)-JVS(1110)&
            &*X(67)-JVS(1111)*X(68)-JVS(1112)*X(69)-JVS(1113)*X(70)-JVS(1114)*X(71)-JVS(1115)*X(72)-JVS(1116)*X(73)&
            &-JVS(1117)*X(74)-JVS(1118)*X(75)-JVS(1119)*X(76)-JVS(1120)*X(77)-JVS(1121)*X(78)-JVS(1122)*X(79)-JVS(1123)&
            &*X(80)-JVS(1124)*X(81)
  X(82) = X(82)/JVS(1125)
  X(81) = (X(81)-JVS(1071)*X(82))/(JVS(1070))
  X(80) = (X(80)-JVS(1032)*X(81)-JVS(1033)*X(82))/(JVS(1031))
  X(79) = (X(79)-JVS(1005)*X(80)-JVS(1006)*X(81)-JVS(1007)*X(82))/(JVS(1004))
  X(78) = (X(78)-JVS(957)*X(79)-JVS(958)*X(80)-JVS(959)*X(81)-JVS(960)*X(82))/(JVS(956))
  X(77) = (X(77)-JVS(885)*X(78)-JVS(886)*X(79)-JVS(887)*X(80)-JVS(888)*X(81)-JVS(889)*X(82))/(JVS(884))
  X(76) = (X(76)-JVS(842)*X(77)-JVS(843)*X(78)-JVS(844)*X(79)-JVS(845)*X(80)-JVS(846)*X(81)-JVS(847)*X(82))/(JVS(841))
  X(75) = (X(75)-JVS(777)*X(76)-JVS(778)*X(77)-JVS(779)*X(78)-JVS(780)*X(79)-JVS(781)*X(80)-JVS(782)*X(81)-JVS(783)&
            &*X(82))/(JVS(776))
  X(74) = (X(74)-JVS(750)*X(75)-JVS(751)*X(76)-JVS(752)*X(77)-JVS(753)*X(78)-JVS(754)*X(79)-JVS(755)*X(80)-JVS(756)&
            &*X(81)-JVS(757)*X(82))/(JVS(749))
  X(73) = (X(73)-JVS(713)*X(74)-JVS(714)*X(75)-JVS(715)*X(76)-JVS(716)*X(77)-JVS(717)*X(78)-JVS(718)*X(79)-JVS(719)&
            &*X(81)-JVS(720)*X(82))/(JVS(712))
  X(72) = (X(72)-JVS(699)*X(74)-JVS(700)*X(76)-JVS(701)*X(77)-JVS(702)*X(78)-JVS(703)*X(79)-JVS(704)*X(81)-JVS(705)&
            &*X(82))/(JVS(698))
  X(71) = (X(71)-JVS(670)*X(72)-JVS(671)*X(74)-JVS(672)*X(76)-JVS(673)*X(77)-JVS(674)*X(78)-JVS(675)*X(79)-JVS(676)&
            &*X(81)-JVS(677)*X(82))/(JVS(669))
  X(70) = (X(70)-JVS(655)*X(71)-JVS(656)*X(72)-JVS(657)*X(73)-JVS(658)*X(74)-JVS(659)*X(75)-JVS(660)*X(76)-JVS(661)&
            &*X(77)-JVS(662)*X(78)-JVS(663)*X(79)-JVS(664)*X(80)-JVS(665)*X(81)-JVS(666)*X(82))/(JVS(654))
  X(69) = (X(69)-JVS(633)*X(72)-JVS(634)*X(74)-JVS(635)*X(76)-JVS(636)*X(77)-JVS(637)*X(78)-JVS(638)*X(79)-JVS(639)&
            &*X(81))/(JVS(632))
  X(68) = (X(68)-JVS(615)*X(69)-JVS(616)*X(72)-JVS(617)*X(74)-JVS(618)*X(76)-JVS(619)*X(77)-JVS(620)*X(78)-JVS(621)&
            &*X(79)-JVS(622)*X(81))/(JVS(614))
  X(67) = (X(67)-JVS(599)*X(72)-JVS(600)*X(74)-JVS(601)*X(76)-JVS(602)*X(77)-JVS(603)*X(78)-JVS(604)*X(79)-JVS(605)&
            &*X(81))/(JVS(598))
  X(66) = (X(66)-JVS(580)*X(67)-JVS(581)*X(68)-JVS(582)*X(69)-JVS(583)*X(70)-JVS(584)*X(71)-JVS(585)*X(72)-JVS(586)&
            &*X(73)-JVS(587)*X(74)-JVS(588)*X(75)-JVS(589)*X(76)-JVS(590)*X(77)-JVS(591)*X(78)-JVS(592)*X(79)-JVS(593)*X(80)&
            &-JVS(594)*X(81)-JVS(595)*X(82))/(JVS(579))
  X(65) = (X(65)-JVS(557)*X(72)-JVS(558)*X(74)-JVS(559)*X(76)-JVS(560)*X(77)-JVS(561)*X(78)-JVS(562)*X(79)-JVS(563)&
            &*X(81))/(JVS(556))
  X(64) = (X(64)-JVS(541)*X(71)-JVS(542)*X(72)-JVS(543)*X(73)-JVS(544)*X(74)-JVS(545)*X(75)-JVS(546)*X(76)-JVS(547)&
            &*X(77)-JVS(548)*X(78)-JVS(549)*X(79)-JVS(550)*X(80)-JVS(551)*X(81)-JVS(552)*X(82))/(JVS(540))
  X(63) = (X(63)-JVS(522)*X(72)-JVS(523)*X(74)-JVS(524)*X(76)-JVS(525)*X(77)-JVS(526)*X(78)-JVS(527)*X(79)-JVS(528)&
            &*X(81)-JVS(529)*X(82))/(JVS(521))
  X(62) = (X(62)-JVS(507)*X(68)-JVS(508)*X(69)-JVS(509)*X(71)-JVS(510)*X(72)-JVS(511)*X(73)-JVS(512)*X(74)-JVS(513)&
            &*X(76)-JVS(514)*X(77)-JVS(515)*X(78)-JVS(516)*X(79)-JVS(517)*X(81)-JVS(518)*X(82))/(JVS(506))
  X(61) = (X(61)-JVS(489)*X(67)-JVS(490)*X(72)-JVS(491)*X(74)-JVS(492)*X(76)-JVS(493)*X(77)-JVS(494)*X(78)-JVS(495)&
            &*X(79)-JVS(496)*X(81))/(JVS(488))
  X(60) = (X(60)-JVS(478)*X(72)-JVS(479)*X(74)-JVS(480)*X(76)-JVS(481)*X(77)-JVS(482)*X(78)-JVS(483)*X(79)-JVS(484)&
            &*X(81)-JVS(485)*X(82))/(JVS(477))
  X(59) = (X(59)-JVS(468)*X(72)-JVS(469)*X(74)-JVS(470)*X(76)-JVS(471)*X(77)-JVS(472)*X(78)-JVS(473)*X(79)-JVS(474)&
            &*X(81)-JVS(475)*X(82))/(JVS(467))
  X(58) = (X(58)-JVS(445)*X(59)-JVS(446)*X(60)-JVS(447)*X(61)-JVS(448)*X(63)-JVS(449)*X(64)-JVS(450)*X(65)-JVS(451)&
            &*X(67)-JVS(452)*X(68)-JVS(453)*X(69)-JVS(454)*X(70)-JVS(455)*X(71)-JVS(456)*X(72)-JVS(457)*X(73)-JVS(458)*X(74)&
            &-JVS(459)*X(76)-JVS(460)*X(77)-JVS(461)*X(78)-JVS(462)*X(79)-JVS(463)*X(80)-JVS(464)*X(81)-JVS(465)*X(82))&
            &/(JVS(444))
  X(57) = (X(57)-JVS(413)*X(74)-JVS(414)*X(76)-JVS(415)*X(77)-JVS(416)*X(78)-JVS(417)*X(79)-JVS(418)*X(81))/(JVS(412))
  X(56) = (X(56)-JVS(405)*X(74)-JVS(406)*X(76)-JVS(407)*X(77)-JVS(408)*X(78)-JVS(409)*X(79)-JVS(410)*X(81))/(JVS(404))
  X(55) = (X(55)-JVS(396)*X(72)-JVS(397)*X(74)-JVS(398)*X(76)-JVS(399)*X(77)-JVS(400)*X(78)-JVS(401)*X(79)-JVS(402)&
            &*X(81))/(JVS(395))
  X(54) = (X(54)-JVS(386)*X(72)-JVS(387)*X(74)-JVS(388)*X(76)-JVS(389)*X(77)-JVS(390)*X(78)-JVS(391)*X(79)-JVS(392)&
            &*X(81)-JVS(393)*X(82))/(JVS(385))
  X(53) = (X(53)-JVS(367)*X(54)-JVS(368)*X(55)-JVS(369)*X(59)-JVS(370)*X(60)-JVS(371)*X(63)-JVS(372)*X(71)-JVS(373)&
            &*X(72)-JVS(374)*X(73)-JVS(375)*X(74)-JVS(376)*X(76)-JVS(377)*X(77)-JVS(378)*X(78)-JVS(379)*X(79)-JVS(380)*X(80)&
            &-JVS(381)*X(81)-JVS(382)*X(82))/(JVS(366))
  X(52) = (X(52)-JVS(339)*X(56)-JVS(340)*X(57)-JVS(341)*X(61)-JVS(342)*X(62)-JVS(343)*X(63)-JVS(344)*X(65)-JVS(345)&
            &*X(67)-JVS(346)*X(68)-JVS(347)*X(69)-JVS(348)*X(72)-JVS(349)*X(73)-JVS(350)*X(74)-JVS(351)*X(75)-JVS(352)*X(76)&
            &-JVS(353)*X(77)-JVS(354)*X(78)-JVS(355)*X(79)-JVS(356)*X(80)-JVS(357)*X(81))/(JVS(338))
  X(51) = (X(51)-JVS(324)*X(72)-JVS(325)*X(74)-JVS(326)*X(76)-JVS(327)*X(77)-JVS(328)*X(78)-JVS(329)*X(79)-JVS(330)&
            &*X(81))/(JVS(323))
  X(50) = (X(50)-JVS(315)*X(72)-JVS(316)*X(74)-JVS(317)*X(76)-JVS(318)*X(77)-JVS(319)*X(78)-JVS(320)*X(79)-JVS(321)&
            &*X(81))/(JVS(314))
  X(49) = (X(49)-JVS(303)*X(50)-JVS(304)*X(55)-JVS(305)*X(72)-JVS(306)*X(74)-JVS(307)*X(76)-JVS(308)*X(77)-JVS(309)&
            &*X(78)-JVS(310)*X(79)-JVS(311)*X(81))/(JVS(302))
  X(48) = (X(48)-JVS(290)*X(65)-JVS(291)*X(74)-JVS(292)*X(76)-JVS(293)*X(77)-JVS(294)*X(78)-JVS(295)*X(79)-JVS(296)&
            &*X(81))/(JVS(289))
  X(47) = (X(47)-JVS(282)*X(72)-JVS(283)*X(74)-JVS(284)*X(76)-JVS(285)*X(77)-JVS(286)*X(78)-JVS(287)*X(79)-JVS(288)&
            &*X(81))/(JVS(281))
  X(46) = (X(46)-JVS(269)*X(54)-JVS(270)*X(59)-JVS(271)*X(60)-JVS(272)*X(63)-JVS(273)*X(72)-JVS(274)*X(73)-JVS(275)&
            &*X(74)-JVS(276)*X(77)-JVS(277)*X(78)-JVS(278)*X(79)-JVS(279)*X(81))/(JVS(268))
  X(45) = (X(45)-JVS(262)*X(71)-JVS(263)*X(72)-JVS(264)*X(78)-JVS(265)*X(79)-JVS(266)*X(82))/(JVS(261))
  X(44) = (X(44)-JVS(254)*X(49)-JVS(255)*X(72)-JVS(256)*X(76)-JVS(257)*X(78)-JVS(258)*X(79)-JVS(259)*X(81)-JVS(260)&
            &*X(82))/(JVS(253))
  X(43) = (X(43)-JVS(247)*X(72)-JVS(248)*X(78)-JVS(249)*X(79))/(JVS(246))
  X(42) = (X(42)-JVS(241)*X(72)-JVS(242)*X(76)-JVS(243)*X(78)-JVS(244)*X(79)-JVS(245)*X(82))/(JVS(240))
  X(41) = (X(41)-JVS(233)*X(72)-JVS(234)*X(78)-JVS(235)*X(79))/(JVS(232))
  X(40) = (X(40)-JVS(229)*X(72)-JVS(230)*X(78)-JVS(231)*X(79))/(JVS(228))
  X(39) = (X(39)-JVS(225)*X(72)-JVS(226)*X(78)-JVS(227)*X(79))/(JVS(224))
  X(38) = (X(38)-JVS(205)*X(39)-JVS(206)*X(40)-JVS(207)*X(41)-JVS(208)*X(43)-JVS(209)*X(44)-JVS(210)*X(45)-JVS(211)&
            &*X(46)-JVS(212)*X(49)-JVS(213)*X(50)-JVS(214)*X(53)-JVS(215)*X(58)-JVS(216)*X(63)-JVS(217)*X(65)-JVS(218)*X(66)&
            &-JVS(219)*X(67)-JVS(220)*X(72)-JVS(221)*X(78)-JVS(222)*X(79)-JVS(223)*X(81))/(JVS(204))
  X(37) = (X(37)-JVS(196)*X(72)-JVS(197)*X(78)-JVS(198)*X(79))/(JVS(195))
  X(36) = (X(36)-JVS(189)*X(45)-JVS(190)*X(72)-JVS(191)*X(77)-JVS(192)*X(78)-JVS(193)*X(79)-JVS(194)*X(82))/(JVS(188))
  X(35) = (X(35)-JVS(185)*X(72)-JVS(186)*X(78)-JVS(187)*X(79))/(JVS(184))
  X(34) = (X(34)-JVS(179)*X(40)-JVS(180)*X(50)-JVS(181)*X(78)-JVS(182)*X(79)-JVS(183)*X(81))/(JVS(178))
  X(33) = (X(33)-JVS(173)*X(63)-JVS(174)*X(72)-JVS(175)*X(76)-JVS(176)*X(77)-JVS(177)*X(78))/(JVS(172))
  X(32) = (X(32)-JVS(162)*X(42)-JVS(163)*X(46)-JVS(164)*X(53)-JVS(165)*X(58)-JVS(166)*X(63)-JVS(167)*X(66)-JVS(168)&
            &*X(76)-JVS(169)*X(78)-JVS(170)*X(79)-JVS(171)*X(82))/(JVS(161))
  X(31) = (X(31)-JVS(157)*X(42)-JVS(158)*X(72)-JVS(159)*X(78)-JVS(160)*X(82))/(JVS(156))
  X(30) = (X(30)-JVS(153)*X(72)-JVS(154)*X(78)-JVS(155)*X(79))/(JVS(152))
  X(29) = (X(29)-JVS(149)*X(72)-JVS(150)*X(78)-JVS(151)*X(82))/(JVS(148))
  X(28) = (X(28)-JVS(144)*X(72)-JVS(145)*X(78)-JVS(146)*X(82))/(JVS(143))
  X(27) = (X(27)-JVS(132)*X(37)-JVS(133)*X(39)-JVS(134)*X(40)-JVS(135)*X(41)-JVS(136)*X(43)-JVS(137)*X(65)-JVS(138)&
            &*X(67)-JVS(139)*X(72)-JVS(140)*X(76)-JVS(141)*X(78))/(JVS(131))
  X(26) = (X(26)-JVS(126)*X(42)-JVS(127)*X(76)-JVS(128)*X(78)-JVS(129)*X(79)-JVS(130)*X(82))/(JVS(125))
  X(25) = (X(25)-JVS(120)*X(43)-JVS(121)*X(72)-JVS(122)*X(79)-JVS(123)*X(81)-JVS(124)*X(82))/(JVS(119))
  X(24) = (X(24)-JVS(114)*X(45)-JVS(115)*X(74)-JVS(116)*X(78)-JVS(117)*X(80))/(JVS(113))
  X(23) = (X(23)-JVS(106)*X(28)-JVS(107)*X(29)-JVS(108)*X(31)-JVS(109)*X(78)-JVS(110)*X(81)-JVS(111)*X(82))/(JVS(105))
  X(22) = (X(22)-JVS(100)*X(34)-JVS(101)*X(44)-JVS(102)*X(78)-JVS(103)*X(81)-JVS(104)*X(82))/(JVS(99))
  X(21) = (X(21)-JVS(95)*X(44)-JVS(96)*X(78)-JVS(97)*X(82))/(JVS(94))
  X(20) = (X(20)-JVS(91)*X(74)-JVS(92)*X(76)-JVS(93)*X(78))/(JVS(90))
  X(19) = (X(19)-JVS(87)*X(76)-JVS(88)*X(78)-JVS(89)*X(82))/(JVS(86))
  X(18) = (X(18)-JVS(81)*X(41)-JVS(82)*X(65)-JVS(83)*X(67)-JVS(84)*X(72)-JVS(85)*X(78))/(JVS(80))
  X(17) = (X(17)-JVS(75)*X(41)-JVS(76)*X(65)-JVS(77)*X(67)-JVS(78)*X(72)-JVS(79)*X(78))/(JVS(74))
  X(16) = (X(16)-JVS(72)*X(34)-JVS(73)*X(78))/(JVS(71))
  X(15) = (X(15)-JVS(69)*X(63)-JVS(70)*X(78))/(JVS(68))
  X(14) = (X(14)-JVS(67)*X(78))/(JVS(66))
  X(13) = (X(13)-JVS(63)*X(44)-JVS(64)*X(76)-JVS(65)*X(78))/(JVS(62))
  X(12) = (X(12)-JVS(61)*X(78))/(JVS(60))
  X(11) = (X(11)-JVS(58)*X(79)-JVS(59)*X(82))/(JVS(57))
  X(10) = (X(10)-JVS(56)*X(78))/(JVS(55))
  X(9) = (X(9)-JVS(54)*X(78))/(JVS(53))
  X(8) = (X(8)-JVS(52)*X(78))/(JVS(51))
  X(7) = (X(7)-JVS(48)*X(50)-JVS(49)*X(76)-JVS(50)*X(78))/(JVS(47))
  X(6) = (X(6)-JVS(46)*X(72))/(JVS(45))
  X(5) = (X(5)-JVS(44)*X(78))/(JVS(43))
  X(4) = (X(4)-JVS(21)*X(35)-JVS(22)*X(39)-JVS(23)*X(41)-JVS(24)*X(47)-JVS(25)*X(48)-JVS(26)*X(50)-JVS(27)*X(56)-JVS(28)&
           &*X(57)-JVS(29)*X(61)-JVS(30)*X(63)-JVS(31)*X(65)-JVS(32)*X(67)-JVS(33)*X(68)-JVS(34)*X(69)-JVS(35)*X(70)-JVS(36)&
           &*X(71)-JVS(37)*X(72)-JVS(38)*X(73)-JVS(39)*X(74)-JVS(40)*X(76)-JVS(41)*X(77)-JVS(42)*X(80))/(JVS(20))
  X(3) = (X(3)-JVS(8)*X(14)-JVS(9)*X(30)-JVS(10)*X(35)-JVS(11)*X(39)-JVS(12)*X(40)-JVS(13)*X(43)-JVS(14)*X(45)-JVS(15)&
           &*X(49)-JVS(16)*X(63)-JVS(17)*X(65)-JVS(18)*X(72)-JVS(19)*X(78))/(JVS(7))
  X(2) = (X(2)-JVS(5)*X(38)-JVS(6)*X(78))/(JVS(4))
  X(1) = (X(1)-JVS(2)*X(5)-JVS(3)*X(78))/(JVS(1))
      
END SUBROUTINE KppSolve

! End of KppSolve function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolveTR - sparse, transposed back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
!      XX        - Vector for output variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolveTR ( JVS, X, XX )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)
! XX - Vector for output variables
  REAL(kind=dp) :: XX(NVAR)

  XX(1) = X(1)/JVS(1)
  XX(2) = X(2)/JVS(4)
  XX(3) = X(3)/JVS(7)
  XX(4) = X(4)/JVS(20)
  XX(5) = (X(5)-JVS(2)*XX(1))/(JVS(43))
  XX(6) = X(6)/JVS(45)
  XX(7) = X(7)/JVS(47)
  XX(8) = X(8)/JVS(51)
  XX(9) = X(9)/JVS(53)
  XX(10) = X(10)/JVS(55)
  XX(11) = X(11)/JVS(57)
  XX(12) = X(12)/JVS(60)
  XX(13) = X(13)/JVS(62)
  XX(14) = (X(14)-JVS(8)*XX(3))/(JVS(66))
  XX(15) = X(15)/JVS(68)
  XX(16) = X(16)/JVS(71)
  XX(17) = X(17)/JVS(74)
  XX(18) = X(18)/JVS(80)
  XX(19) = X(19)/JVS(86)
  XX(20) = X(20)/JVS(90)
  XX(21) = X(21)/JVS(94)
  XX(22) = X(22)/JVS(99)
  XX(23) = X(23)/JVS(105)
  XX(24) = X(24)/JVS(113)
  XX(25) = X(25)/JVS(119)
  XX(26) = X(26)/JVS(125)
  XX(27) = X(27)/JVS(131)
  XX(28) = (X(28)-JVS(106)*XX(23))/(JVS(143))
  XX(29) = (X(29)-JVS(107)*XX(23))/(JVS(148))
  XX(30) = (X(30)-JVS(9)*XX(3))/(JVS(152))
  XX(31) = (X(31)-JVS(108)*XX(23))/(JVS(156))
  XX(32) = X(32)/JVS(161)
  XX(33) = X(33)/JVS(172)
  XX(34) = (X(34)-JVS(72)*XX(16)-JVS(100)*XX(22))/(JVS(178))
  XX(35) = (X(35)-JVS(10)*XX(3)-JVS(21)*XX(4))/(JVS(184))
  XX(36) = X(36)/JVS(188)
  XX(37) = (X(37)-JVS(132)*XX(27))/(JVS(195))
  XX(38) = (X(38)-JVS(5)*XX(2))/(JVS(204))
  XX(39) = (X(39)-JVS(11)*XX(3)-JVS(22)*XX(4)-JVS(133)*XX(27)-JVS(205)*XX(38))/(JVS(224))
  XX(40) = (X(40)-JVS(12)*XX(3)-JVS(134)*XX(27)-JVS(179)*XX(34)-JVS(206)*XX(38))/(JVS(228))
  XX(41) = (X(41)-JVS(23)*XX(4)-JVS(75)*XX(17)-JVS(81)*XX(18)-JVS(135)*XX(27)-JVS(207)*XX(38))/(JVS(232))
  XX(42) = (X(42)-JVS(126)*XX(26)-JVS(157)*XX(31)-JVS(162)*XX(32))/(JVS(240))
  XX(43) = (X(43)-JVS(13)*XX(3)-JVS(120)*XX(25)-JVS(136)*XX(27)-JVS(208)*XX(38))/(JVS(246))
  XX(44) = (X(44)-JVS(63)*XX(13)-JVS(95)*XX(21)-JVS(101)*XX(22)-JVS(209)*XX(38))/(JVS(253))
  XX(45) = (X(45)-JVS(14)*XX(3)-JVS(114)*XX(24)-JVS(189)*XX(36)-JVS(210)*XX(38))/(JVS(261))
  XX(46) = (X(46)-JVS(163)*XX(32)-JVS(211)*XX(38))/(JVS(268))
  XX(47) = (X(47)-JVS(24)*XX(4))/(JVS(281))
  XX(48) = (X(48)-JVS(25)*XX(4))/(JVS(289))
  XX(49) = (X(49)-JVS(15)*XX(3)-JVS(212)*XX(38)-JVS(254)*XX(44))/(JVS(302))
  XX(50) = (X(50)-JVS(26)*XX(4)-JVS(48)*XX(7)-JVS(180)*XX(34)-JVS(213)*XX(38)-JVS(303)*XX(49))/(JVS(314))
  XX(51) = X(51)/JVS(323)
  XX(52) = X(52)/JVS(338)
  XX(53) = (X(53)-JVS(164)*XX(32)-JVS(214)*XX(38))/(JVS(366))
  XX(54) = (X(54)-JVS(269)*XX(46)-JVS(367)*XX(53))/(JVS(385))
  XX(55) = (X(55)-JVS(304)*XX(49)-JVS(368)*XX(53))/(JVS(395))
  XX(56) = (X(56)-JVS(27)*XX(4)-JVS(339)*XX(52))/(JVS(404))
  XX(57) = (X(57)-JVS(28)*XX(4)-JVS(340)*XX(52))/(JVS(412))
  XX(58) = (X(58)-JVS(165)*XX(32)-JVS(215)*XX(38))/(JVS(444))
  XX(59) = (X(59)-JVS(270)*XX(46)-JVS(369)*XX(53)-JVS(445)*XX(58))/(JVS(467))
  XX(60) = (X(60)-JVS(271)*XX(46)-JVS(370)*XX(53)-JVS(446)*XX(58))/(JVS(477))
  XX(61) = (X(61)-JVS(29)*XX(4)-JVS(341)*XX(52)-JVS(447)*XX(58))/(JVS(488))
  XX(62) = (X(62)-JVS(342)*XX(52))/(JVS(506))
  XX(63) = (X(63)-JVS(16)*XX(3)-JVS(30)*XX(4)-JVS(69)*XX(15)-JVS(166)*XX(32)-JVS(173)*XX(33)-JVS(216)*XX(38)-JVS(272)&
             &*XX(46)-JVS(343)*XX(52)-JVS(371)*XX(53)-JVS(448)*XX(58))/(JVS(521))
  XX(64) = (X(64)-JVS(449)*XX(58))/(JVS(540))
  XX(65) = (X(65)-JVS(17)*XX(3)-JVS(31)*XX(4)-JVS(76)*XX(17)-JVS(82)*XX(18)-JVS(137)*XX(27)-JVS(217)*XX(38)-JVS(290)&
             &*XX(48)-JVS(344)*XX(52)-JVS(450)*XX(58))/(JVS(556))
  XX(66) = (X(66)-JVS(167)*XX(32)-JVS(218)*XX(38))/(JVS(579))
  XX(67) = (X(67)-JVS(32)*XX(4)-JVS(77)*XX(17)-JVS(83)*XX(18)-JVS(138)*XX(27)-JVS(219)*XX(38)-JVS(345)*XX(52)-JVS(451)&
             &*XX(58)-JVS(489)*XX(61)-JVS(580)*XX(66))/(JVS(598))
  XX(68) = (X(68)-JVS(33)*XX(4)-JVS(346)*XX(52)-JVS(452)*XX(58)-JVS(507)*XX(62)-JVS(581)*XX(66))/(JVS(614))
  XX(69) = (X(69)-JVS(34)*XX(4)-JVS(347)*XX(52)-JVS(453)*XX(58)-JVS(508)*XX(62)-JVS(582)*XX(66)-JVS(615)*XX(68))&
             &/(JVS(632))
  XX(70) = (X(70)-JVS(35)*XX(4)-JVS(454)*XX(58)-JVS(583)*XX(66))/(JVS(654))
  XX(71) = (X(71)-JVS(36)*XX(4)-JVS(262)*XX(45)-JVS(372)*XX(53)-JVS(455)*XX(58)-JVS(509)*XX(62)-JVS(541)*XX(64)-JVS(584)&
             &*XX(66)-JVS(655)*XX(70))/(JVS(669))
  XX(72) = (X(72)-JVS(18)*XX(3)-JVS(37)*XX(4)-JVS(46)*XX(6)-JVS(78)*XX(17)-JVS(84)*XX(18)-JVS(121)*XX(25)-JVS(139)&
             &*XX(27)-JVS(144)*XX(28)-JVS(149)*XX(29)-JVS(153)*XX(30)-JVS(158)*XX(31)-JVS(174)*XX(33)-JVS(185)*XX(35)&
             &-JVS(190)*XX(36)-JVS(196)*XX(37)-JVS(220)*XX(38)-JVS(225)*XX(39)-JVS(229)*XX(40)-JVS(233)*XX(41)-JVS(241)&
             &*XX(42)-JVS(247)*XX(43)-JVS(255)*XX(44)-JVS(263)*XX(45)-JVS(273)*XX(46)-JVS(282)*XX(47)-JVS(305)*XX(49)&
             &-JVS(315)*XX(50)-JVS(324)*XX(51)-JVS(348)*XX(52)-JVS(373)*XX(53)-JVS(386)*XX(54)-JVS(396)*XX(55)-JVS(456)&
             &*XX(58)-JVS(468)*XX(59)-JVS(478)*XX(60)-JVS(490)*XX(61)-JVS(510)*XX(62)-JVS(522)*XX(63)-JVS(542)*XX(64)&
             &-JVS(557)*XX(65)-JVS(585)*XX(66)-JVS(599)*XX(67)-JVS(616)*XX(68)-JVS(633)*XX(69)-JVS(656)*XX(70)-JVS(670)&
             &*XX(71))/(JVS(698))
  XX(73) = (X(73)-JVS(38)*XX(4)-JVS(274)*XX(46)-JVS(349)*XX(52)-JVS(374)*XX(53)-JVS(457)*XX(58)-JVS(511)*XX(62)-JVS(543)&
             &*XX(64)-JVS(586)*XX(66)-JVS(657)*XX(70))/(JVS(712))
  XX(74) = (X(74)-JVS(39)*XX(4)-JVS(91)*XX(20)-JVS(115)*XX(24)-JVS(275)*XX(46)-JVS(283)*XX(47)-JVS(291)*XX(48)-JVS(306)&
             &*XX(49)-JVS(316)*XX(50)-JVS(325)*XX(51)-JVS(350)*XX(52)-JVS(375)*XX(53)-JVS(387)*XX(54)-JVS(397)*XX(55)&
             &-JVS(405)*XX(56)-JVS(413)*XX(57)-JVS(458)*XX(58)-JVS(469)*XX(59)-JVS(479)*XX(60)-JVS(491)*XX(61)-JVS(512)&
             &*XX(62)-JVS(523)*XX(63)-JVS(544)*XX(64)-JVS(558)*XX(65)-JVS(587)*XX(66)-JVS(600)*XX(67)-JVS(617)*XX(68)&
             &-JVS(634)*XX(69)-JVS(658)*XX(70)-JVS(671)*XX(71)-JVS(699)*XX(72)-JVS(713)*XX(73))/(JVS(749))
  XX(75) = (X(75)-JVS(351)*XX(52)-JVS(545)*XX(64)-JVS(588)*XX(66)-JVS(659)*XX(70)-JVS(714)*XX(73)-JVS(750)*XX(74))&
             &/(JVS(776))
  XX(76) = (X(76)-JVS(40)*XX(4)-JVS(49)*XX(7)-JVS(64)*XX(13)-JVS(87)*XX(19)-JVS(92)*XX(20)-JVS(127)*XX(26)-JVS(140)&
             &*XX(27)-JVS(168)*XX(32)-JVS(175)*XX(33)-JVS(242)*XX(42)-JVS(256)*XX(44)-JVS(284)*XX(47)-JVS(292)*XX(48)&
             &-JVS(307)*XX(49)-JVS(317)*XX(50)-JVS(326)*XX(51)-JVS(352)*XX(52)-JVS(376)*XX(53)-JVS(388)*XX(54)-JVS(398)&
             &*XX(55)-JVS(406)*XX(56)-JVS(414)*XX(57)-JVS(459)*XX(58)-JVS(470)*XX(59)-JVS(480)*XX(60)-JVS(492)*XX(61)&
             &-JVS(513)*XX(62)-JVS(524)*XX(63)-JVS(546)*XX(64)-JVS(559)*XX(65)-JVS(589)*XX(66)-JVS(601)*XX(67)-JVS(618)&
             &*XX(68)-JVS(635)*XX(69)-JVS(660)*XX(70)-JVS(672)*XX(71)-JVS(700)*XX(72)-JVS(715)*XX(73)-JVS(751)*XX(74)&
             &-JVS(777)*XX(75))/(JVS(841))
  XX(77) = (X(77)-JVS(41)*XX(4)-JVS(176)*XX(33)-JVS(191)*XX(36)-JVS(276)*XX(46)-JVS(285)*XX(47)-JVS(293)*XX(48)-JVS(308)&
             &*XX(49)-JVS(318)*XX(50)-JVS(327)*XX(51)-JVS(353)*XX(52)-JVS(377)*XX(53)-JVS(389)*XX(54)-JVS(399)*XX(55)&
             &-JVS(407)*XX(56)-JVS(415)*XX(57)-JVS(460)*XX(58)-JVS(471)*XX(59)-JVS(481)*XX(60)-JVS(493)*XX(61)-JVS(514)&
             &*XX(62)-JVS(525)*XX(63)-JVS(547)*XX(64)-JVS(560)*XX(65)-JVS(590)*XX(66)-JVS(602)*XX(67)-JVS(619)*XX(68)&
             &-JVS(636)*XX(69)-JVS(661)*XX(70)-JVS(673)*XX(71)-JVS(701)*XX(72)-JVS(716)*XX(73)-JVS(752)*XX(74)-JVS(778)&
             &*XX(75)-JVS(842)*XX(76))/(JVS(884))
  XX(78) = (X(78)-JVS(3)*XX(1)-JVS(6)*XX(2)-JVS(19)*XX(3)-JVS(44)*XX(5)-JVS(50)*XX(7)-JVS(52)*XX(8)-JVS(54)*XX(9)&
             &-JVS(56)*XX(10)-JVS(61)*XX(12)-JVS(65)*XX(13)-JVS(67)*XX(14)-JVS(70)*XX(15)-JVS(73)*XX(16)-JVS(79)*XX(17)&
             &-JVS(85)*XX(18)-JVS(88)*XX(19)-JVS(93)*XX(20)-JVS(96)*XX(21)-JVS(102)*XX(22)-JVS(109)*XX(23)-JVS(116)*XX(24)&
             &-JVS(128)*XX(26)-JVS(141)*XX(27)-JVS(145)*XX(28)-JVS(150)*XX(29)-JVS(154)*XX(30)-JVS(159)*XX(31)-JVS(169)&
             &*XX(32)-JVS(177)*XX(33)-JVS(181)*XX(34)-JVS(186)*XX(35)-JVS(192)*XX(36)-JVS(197)*XX(37)-JVS(221)*XX(38)&
             &-JVS(226)*XX(39)-JVS(230)*XX(40)-JVS(234)*XX(41)-JVS(243)*XX(42)-JVS(248)*XX(43)-JVS(257)*XX(44)-JVS(264)&
             &*XX(45)-JVS(277)*XX(46)-JVS(286)*XX(47)-JVS(294)*XX(48)-JVS(309)*XX(49)-JVS(319)*XX(50)-JVS(328)*XX(51)&
             &-JVS(354)*XX(52)-JVS(378)*XX(53)-JVS(390)*XX(54)-JVS(400)*XX(55)-JVS(408)*XX(56)-JVS(416)*XX(57)-JVS(461)&
             &*XX(58)-JVS(472)*XX(59)-JVS(482)*XX(60)-JVS(494)*XX(61)-JVS(515)*XX(62)-JVS(526)*XX(63)-JVS(548)*XX(64)&
             &-JVS(561)*XX(65)-JVS(591)*XX(66)-JVS(603)*XX(67)-JVS(620)*XX(68)-JVS(637)*XX(69)-JVS(662)*XX(70)-JVS(674)&
             &*XX(71)-JVS(702)*XX(72)-JVS(717)*XX(73)-JVS(753)*XX(74)-JVS(779)*XX(75)-JVS(843)*XX(76)-JVS(885)*XX(77))&
             &/(JVS(956))
  XX(79) = (X(79)-JVS(58)*XX(11)-JVS(122)*XX(25)-JVS(129)*XX(26)-JVS(155)*XX(30)-JVS(170)*XX(32)-JVS(182)*XX(34)&
             &-JVS(187)*XX(35)-JVS(193)*XX(36)-JVS(198)*XX(37)-JVS(222)*XX(38)-JVS(227)*XX(39)-JVS(231)*XX(40)-JVS(235)&
             &*XX(41)-JVS(244)*XX(42)-JVS(249)*XX(43)-JVS(258)*XX(44)-JVS(265)*XX(45)-JVS(278)*XX(46)-JVS(287)*XX(47)&
             &-JVS(295)*XX(48)-JVS(310)*XX(49)-JVS(320)*XX(50)-JVS(329)*XX(51)-JVS(355)*XX(52)-JVS(379)*XX(53)-JVS(391)&
             &*XX(54)-JVS(401)*XX(55)-JVS(409)*XX(56)-JVS(417)*XX(57)-JVS(462)*XX(58)-JVS(473)*XX(59)-JVS(483)*XX(60)&
             &-JVS(495)*XX(61)-JVS(516)*XX(62)-JVS(527)*XX(63)-JVS(549)*XX(64)-JVS(562)*XX(65)-JVS(592)*XX(66)-JVS(604)&
             &*XX(67)-JVS(621)*XX(68)-JVS(638)*XX(69)-JVS(663)*XX(70)-JVS(675)*XX(71)-JVS(703)*XX(72)-JVS(718)*XX(73)&
             &-JVS(754)*XX(74)-JVS(780)*XX(75)-JVS(844)*XX(76)-JVS(886)*XX(77)-JVS(957)*XX(78))/(JVS(1004))
  XX(80) = (X(80)-JVS(42)*XX(4)-JVS(117)*XX(24)-JVS(356)*XX(52)-JVS(380)*XX(53)-JVS(463)*XX(58)-JVS(550)*XX(64)-JVS(593)&
             &*XX(66)-JVS(664)*XX(70)-JVS(755)*XX(74)-JVS(781)*XX(75)-JVS(845)*XX(76)-JVS(887)*XX(77)-JVS(958)*XX(78)&
             &-JVS(1005)*XX(79))/(JVS(1031))
  XX(81) = (X(81)-JVS(103)*XX(22)-JVS(110)*XX(23)-JVS(123)*XX(25)-JVS(183)*XX(34)-JVS(223)*XX(38)-JVS(259)*XX(44)&
             &-JVS(279)*XX(46)-JVS(288)*XX(47)-JVS(296)*XX(48)-JVS(311)*XX(49)-JVS(321)*XX(50)-JVS(330)*XX(51)-JVS(357)&
             &*XX(52)-JVS(381)*XX(53)-JVS(392)*XX(54)-JVS(402)*XX(55)-JVS(410)*XX(56)-JVS(418)*XX(57)-JVS(464)*XX(58)&
             &-JVS(474)*XX(59)-JVS(484)*XX(60)-JVS(496)*XX(61)-JVS(517)*XX(62)-JVS(528)*XX(63)-JVS(551)*XX(64)-JVS(563)&
             &*XX(65)-JVS(594)*XX(66)-JVS(605)*XX(67)-JVS(622)*XX(68)-JVS(639)*XX(69)-JVS(665)*XX(70)-JVS(676)*XX(71)&
             &-JVS(704)*XX(72)-JVS(719)*XX(73)-JVS(756)*XX(74)-JVS(782)*XX(75)-JVS(846)*XX(76)-JVS(888)*XX(77)-JVS(959)&
             &*XX(78)-JVS(1006)*XX(79)-JVS(1032)*XX(80))/(JVS(1070))
  XX(82) = (X(82)-JVS(59)*XX(11)-JVS(89)*XX(19)-JVS(97)*XX(21)-JVS(104)*XX(22)-JVS(111)*XX(23)-JVS(124)*XX(25)-JVS(130)&
             &*XX(26)-JVS(146)*XX(28)-JVS(151)*XX(29)-JVS(160)*XX(31)-JVS(171)*XX(32)-JVS(194)*XX(36)-JVS(245)*XX(42)&
             &-JVS(260)*XX(44)-JVS(266)*XX(45)-JVS(382)*XX(53)-JVS(393)*XX(54)-JVS(465)*XX(58)-JVS(475)*XX(59)-JVS(485)&
             &*XX(60)-JVS(518)*XX(62)-JVS(529)*XX(63)-JVS(552)*XX(64)-JVS(595)*XX(66)-JVS(666)*XX(70)-JVS(677)*XX(71)&
             &-JVS(705)*XX(72)-JVS(720)*XX(73)-JVS(757)*XX(74)-JVS(783)*XX(75)-JVS(847)*XX(76)-JVS(889)*XX(77)-JVS(960)&
             &*XX(78)-JVS(1007)*XX(79)-JVS(1033)*XX(80)-JVS(1071)*XX(81))/(JVS(1125))
  XX(82) = XX(82)
  XX(81) = XX(81)-JVS(1124)*XX(82)
  XX(80) = XX(80)-JVS(1069)*XX(81)-JVS(1123)*XX(82)
  XX(79) = XX(79)-JVS(1030)*XX(80)-JVS(1068)*XX(81)-JVS(1122)*XX(82)
  XX(78) = XX(78)-JVS(1003)*XX(79)-JVS(1029)*XX(80)-JVS(1067)*XX(81)-JVS(1121)*XX(82)
  XX(77) = XX(77)-JVS(955)*XX(78)-JVS(1002)*XX(79)-JVS(1028)*XX(80)-JVS(1066)*XX(81)-JVS(1120)*XX(82)
  XX(76) = XX(76)-JVS(883)*XX(77)-JVS(954)*XX(78)-JVS(1001)*XX(79)-JVS(1027)*XX(80)-JVS(1065)*XX(81)-JVS(1119)*XX(82)
  XX(75) = XX(75)-JVS(840)*XX(76)-JVS(882)*XX(77)-JVS(953)*XX(78)-JVS(1000)*XX(79)-JVS(1026)*XX(80)-JVS(1064)*XX(81)&
             &-JVS(1118)*XX(82)
  XX(74) = XX(74)-JVS(775)*XX(75)-JVS(839)*XX(76)-JVS(881)*XX(77)-JVS(952)*XX(78)-JVS(999)*XX(79)-JVS(1025)*XX(80)&
             &-JVS(1063)*XX(81)-JVS(1117)*XX(82)
  XX(73) = XX(73)-JVS(748)*XX(74)-JVS(774)*XX(75)-JVS(838)*XX(76)-JVS(880)*XX(77)-JVS(951)*XX(78)-JVS(998)*XX(79)&
             &-JVS(1024)*XX(80)-JVS(1062)*XX(81)-JVS(1116)*XX(82)
  XX(72) = XX(72)-JVS(711)*XX(73)-JVS(747)*XX(74)-JVS(773)*XX(75)-JVS(837)*XX(76)-JVS(879)*XX(77)-JVS(950)*XX(78)&
             &-JVS(997)*XX(79)-JVS(1023)*XX(80)-JVS(1061)*XX(81)-JVS(1115)*XX(82)
  XX(71) = XX(71)-JVS(697)*XX(72)-JVS(710)*XX(73)-JVS(746)*XX(74)-JVS(772)*XX(75)-JVS(836)*XX(76)-JVS(878)*XX(77)&
             &-JVS(949)*XX(78)-JVS(996)*XX(79)-JVS(1022)*XX(80)-JVS(1060)*XX(81)-JVS(1114)*XX(82)
  XX(70) = XX(70)-JVS(745)*XX(74)-JVS(771)*XX(75)-JVS(835)*XX(76)-JVS(877)*XX(77)-JVS(948)*XX(78)-JVS(995)*XX(79)&
             &-JVS(1059)*XX(81)-JVS(1113)*XX(82)
  XX(69) = XX(69)-JVS(653)*XX(70)-JVS(709)*XX(73)-JVS(744)*XX(74)-JVS(834)*XX(76)-JVS(876)*XX(77)-JVS(947)*XX(78)&
             &-JVS(994)*XX(79)-JVS(1021)*XX(80)-JVS(1058)*XX(81)-JVS(1112)*XX(82)
  XX(68) = XX(68)-JVS(631)*XX(69)-JVS(652)*XX(70)-JVS(708)*XX(73)-JVS(743)*XX(74)-JVS(833)*XX(76)-JVS(875)*XX(77)&
             &-JVS(946)*XX(78)-JVS(993)*XX(79)-JVS(1020)*XX(80)-JVS(1057)*XX(81)-JVS(1111)*XX(82)
  XX(67) = XX(67)-JVS(613)*XX(68)-JVS(630)*XX(69)-JVS(651)*XX(70)-JVS(696)*XX(72)-JVS(742)*XX(74)-JVS(770)*XX(75)&
             &-JVS(832)*XX(76)-JVS(874)*XX(77)-JVS(945)*XX(78)-JVS(992)*XX(79)-JVS(1019)*XX(80)-JVS(1056)*XX(81)-JVS(1110)&
             &*XX(82)
  XX(66) = XX(66)-JVS(741)*XX(74)-JVS(831)*XX(76)-JVS(873)*XX(77)-JVS(944)*XX(78)-JVS(991)*XX(79)-JVS(1109)*XX(82)
  XX(65) = XX(65)-JVS(578)*XX(66)-JVS(612)*XX(68)-JVS(629)*XX(69)-JVS(650)*XX(70)-JVS(695)*XX(72)-JVS(740)*XX(74)&
             &-JVS(769)*XX(75)-JVS(830)*XX(76)-JVS(872)*XX(77)-JVS(943)*XX(78)-JVS(990)*XX(79)-JVS(1018)*XX(80)-JVS(1055)&
             &*XX(81)-JVS(1108)*XX(82)
  XX(64) = XX(64)-JVS(739)*XX(74)-JVS(768)*XX(75)-JVS(829)*XX(76)-JVS(871)*XX(77)-JVS(942)*XX(78)-JVS(989)*XX(79)&
             &-JVS(1054)*XX(81)-JVS(1107)*XX(82)
  XX(63) = XX(63)-JVS(539)*XX(64)-JVS(577)*XX(66)-JVS(649)*XX(70)-JVS(668)*XX(71)-JVS(694)*XX(72)-JVS(738)*XX(74)&
             &-JVS(828)*XX(76)-JVS(870)*XX(77)-JVS(941)*XX(78)-JVS(988)*XX(79)-JVS(1017)*XX(80)-JVS(1106)*XX(82)
  XX(62) = XX(62)-JVS(576)*XX(66)-JVS(648)*XX(70)-JVS(707)*XX(73)-JVS(827)*XX(76)-JVS(869)*XX(77)-JVS(940)*XX(78)&
             &-JVS(1016)*XX(80)-JVS(1105)*XX(82)
  XX(61) = XX(61)-JVS(575)*XX(66)-JVS(647)*XX(70)-JVS(737)*XX(74)-JVS(767)*XX(75)-JVS(826)*XX(76)-JVS(868)*XX(77)&
             &-JVS(939)*XX(78)-JVS(987)*XX(79)-JVS(1015)*XX(80)-JVS(1053)*XX(81)-JVS(1104)*XX(82)
  XX(60) = XX(60)-JVS(505)*XX(62)-JVS(520)*XX(63)-JVS(736)*XX(74)-JVS(766)*XX(75)-JVS(825)*XX(76)-JVS(867)*XX(77)&
             &-JVS(938)*XX(78)-JVS(986)*XX(79)-JVS(1052)*XX(81)-JVS(1103)*XX(82)
  XX(59) = XX(59)-JVS(504)*XX(62)-JVS(519)*XX(63)-JVS(735)*XX(74)-JVS(765)*XX(75)-JVS(824)*XX(76)-JVS(866)*XX(77)&
             &-JVS(937)*XX(78)-JVS(985)*XX(79)-JVS(1051)*XX(81)-JVS(1102)*XX(82)
  XX(58) = XX(58)-JVS(823)*XX(76)-JVS(936)*XX(78)-JVS(984)*XX(79)-JVS(1101)*XX(82)
  XX(57) = XX(57)-JVS(443)*XX(58)-JVS(503)*XX(62)-JVS(538)*XX(64)-JVS(574)*XX(66)-JVS(646)*XX(70)-JVS(734)*XX(74)&
             &-JVS(764)*XX(75)-JVS(822)*XX(76)-JVS(865)*XX(77)-JVS(935)*XX(78)-JVS(983)*XX(79)-JVS(1014)*XX(80)-JVS(1050)&
             &*XX(81)-JVS(1100)*XX(82)
  XX(56) = XX(56)-JVS(442)*XX(58)-JVS(502)*XX(62)-JVS(537)*XX(64)-JVS(573)*XX(66)-JVS(645)*XX(70)-JVS(733)*XX(74)&
             &-JVS(763)*XX(75)-JVS(821)*XX(76)-JVS(864)*XX(77)-JVS(934)*XX(78)-JVS(982)*XX(79)-JVS(1013)*XX(80)-JVS(1049)&
             &*XX(81)-JVS(1099)*XX(82)
  XX(55) = XX(55)-JVS(441)*XX(58)-JVS(501)*XX(62)-JVS(597)*XX(67)-JVS(693)*XX(72)-JVS(732)*XX(74)-JVS(762)*XX(75)&
             &-JVS(820)*XX(76)-JVS(863)*XX(77)-JVS(933)*XX(78)-JVS(981)*XX(79)-JVS(1048)*XX(81)-JVS(1098)*XX(82)
  XX(54) = XX(54)-JVS(440)*XX(58)-JVS(731)*XX(74)-JVS(761)*XX(75)-JVS(819)*XX(76)-JVS(862)*XX(77)-JVS(932)*XX(78)&
             &-JVS(980)*XX(79)-JVS(1047)*XX(81)-JVS(1097)*XX(82)
  XX(53) = XX(53)-JVS(818)*XX(76)-JVS(861)*XX(77)-JVS(931)*XX(78)-JVS(979)*XX(79)-JVS(1096)*XX(82)
  XX(52) = XX(52)-JVS(644)*XX(70)-JVS(860)*XX(77)-JVS(930)*XX(78)-JVS(1012)*XX(80)
  XX(51) = XX(51)-JVS(337)*XX(52)-JVS(439)*XX(58)-JVS(500)*XX(62)-JVS(572)*XX(66)-JVS(730)*XX(74)-JVS(760)*XX(75)&
             &-JVS(817)*XX(76)-JVS(859)*XX(77)-JVS(978)*XX(79)-JVS(1046)*XX(81)-JVS(1095)*XX(82)
  XX(50) = XX(50)-JVS(365)*XX(53)-JVS(438)*XX(58)-JVS(555)*XX(65)-JVS(596)*XX(67)-JVS(692)*XX(72)-JVS(729)*XX(74)&
             &-JVS(816)*XX(76)-JVS(858)*XX(77)-JVS(929)*XX(78)-JVS(1045)*XX(81)-JVS(1094)*XX(82)
  XX(49) = XX(49)-JVS(364)*XX(53)-JVS(437)*XX(58)-JVS(691)*XX(72)-JVS(815)*XX(76)-JVS(857)*XX(77)-JVS(928)*XX(78)&
             &-JVS(1044)*XX(81)-JVS(1093)*XX(82)
  XX(48) = XX(48)-JVS(336)*XX(52)-JVS(436)*XX(58)-JVS(571)*XX(66)-JVS(728)*XX(74)-JVS(759)*XX(75)-JVS(814)*XX(76)&
             &-JVS(856)*XX(77)-JVS(977)*XX(79)-JVS(1043)*XX(81)-JVS(1092)*XX(82)
  XX(47) = XX(47)-JVS(435)*XX(58)-JVS(570)*XX(66)-JVS(727)*XX(74)-JVS(758)*XX(75)-JVS(813)*XX(76)-JVS(855)*XX(77)&
             &-JVS(976)*XX(79)-JVS(1042)*XX(81)-JVS(1091)*XX(82)
  XX(46) = XX(46)-JVS(434)*XX(58)-JVS(812)*XX(76)-JVS(927)*XX(78)-JVS(975)*XX(79)-JVS(1090)*XX(82)
  XX(45) = XX(45)-JVS(363)*XX(53)-JVS(433)*XX(58)-JVS(499)*XX(62)-JVS(536)*XX(64)-JVS(667)*XX(71)-JVS(690)*XX(72)&
             &-JVS(811)*XX(76)-JVS(854)*XX(77)-JVS(926)*XX(78)-JVS(974)*XX(79)-JVS(1089)*XX(82)
  XX(44) = XX(44)-JVS(362)*XX(53)-JVS(432)*XX(58)-JVS(810)*XX(76)-JVS(853)*XX(77)-JVS(925)*XX(78)-JVS(1041)*XX(81)&
             &-JVS(1088)*XX(82)
  XX(43) = XX(43)-JVS(301)*XX(49)-JVS(313)*XX(50)-JVS(431)*XX(58)-JVS(535)*XX(64)-JVS(554)*XX(65)-JVS(611)*XX(68)&
             &-JVS(628)*XX(69)-JVS(689)*XX(72)-JVS(726)*XX(74)-JVS(809)*XX(76)-JVS(852)*XX(77)-JVS(924)*XX(78)-JVS(973)&
             &*XX(79)-JVS(1011)*XX(80)-JVS(1040)*XX(81)-JVS(1087)*XX(82)
  XX(42) = XX(42)-JVS(384)*XX(54)-JVS(498)*XX(62)-JVS(534)*XX(64)-JVS(688)*XX(72)-JVS(808)*XX(76)-JVS(923)*XX(78)&
             &-JVS(972)*XX(79)-JVS(1039)*XX(81)-JVS(1086)*XX(82)
  XX(41) = XX(41)-JVS(335)*XX(52)-JVS(430)*XX(58)-JVS(487)*XX(61)-JVS(569)*XX(66)-JVS(610)*XX(68)-JVS(627)*XX(69)&
             &-JVS(643)*XX(70)-JVS(687)*XX(72)-JVS(725)*XX(74)-JVS(807)*XX(76)-JVS(922)*XX(78)-JVS(971)*XX(79)-JVS(1010)&
             &*XX(80)
  XX(40) = XX(40)-JVS(252)*XX(44)-JVS(300)*XX(49)-JVS(312)*XX(50)-JVS(361)*XX(53)-JVS(429)*XX(58)-JVS(686)*XX(72)&
             &-JVS(724)*XX(74)-JVS(806)*XX(76)-JVS(851)*XX(77)-JVS(921)*XX(78)-JVS(970)*XX(79)-JVS(1085)*XX(82)
  XX(39) = XX(39)-JVS(299)*XX(49)-JVS(394)*XX(55)-JVS(428)*XX(58)-JVS(553)*XX(65)-JVS(609)*XX(68)-JVS(626)*XX(69)&
             &-JVS(642)*XX(70)-JVS(685)*XX(72)-JVS(805)*XX(76)-JVS(920)*XX(78)-JVS(969)*XX(79)-JVS(1009)*XX(80)
  XX(38) = XX(38)-JVS(804)*XX(76)-JVS(919)*XX(78)
  XX(37) = XX(37)-JVS(203)*XX(38)-JVS(322)*XX(51)-JVS(334)*XX(52)-JVS(568)*XX(66)-JVS(608)*XX(68)-JVS(625)*XX(69)&
             &-JVS(641)*XX(70)-JVS(684)*XX(72)-JVS(803)*XX(76)-JVS(918)*XX(78)-JVS(968)*XX(79)-JVS(1008)*XX(80)
  XX(36) = XX(36)-JVS(427)*XX(58)-JVS(533)*XX(64)-JVS(850)*XX(77)-JVS(917)*XX(78)-JVS(967)*XX(79)-JVS(1084)*XX(82)
  XX(35) = XX(35)-JVS(298)*XX(49)-JVS(333)*XX(52)-JVS(426)*XX(58)-JVS(486)*XX(61)-JVS(567)*XX(66)-JVS(607)*XX(68)&
             &-JVS(624)*XX(69)-JVS(683)*XX(72)-JVS(916)*XX(78)-JVS(966)*XX(79)
  XX(34) = XX(34)-JVS(202)*XX(38)-JVS(360)*XX(53)-JVS(425)*XX(58)-JVS(802)*XX(76)-JVS(915)*XX(78)-JVS(1083)*XX(82)
  XX(33) = XX(33)-JVS(424)*XX(58)-JVS(532)*XX(64)-JVS(723)*XX(74)-JVS(801)*XX(76)-JVS(849)*XX(77)-JVS(914)*XX(78)
  XX(32) = XX(32)-JVS(913)*XX(78)-JVS(965)*XX(79)-JVS(1082)*XX(82)
  XX(31) = XX(31)-JVS(239)*XX(42)-JVS(383)*XX(54)-JVS(682)*XX(72)-JVS(800)*XX(76)-JVS(912)*XX(78)-JVS(1038)*XX(81)&
             &-JVS(1081)*XX(82)
  XX(30) = XX(30)-JVS(201)*XX(38)-JVS(280)*XX(47)-JVS(423)*XX(58)-JVS(606)*XX(68)-JVS(623)*XX(69)-JVS(681)*XX(72)&
             &-JVS(799)*XX(76)-JVS(911)*XX(78)-JVS(964)*XX(79)
  XX(29) = XX(29)-JVS(238)*XX(42)-JVS(476)*XX(60)-JVS(680)*XX(72)-JVS(798)*XX(76)-JVS(910)*XX(78)-JVS(1037)*XX(81)&
             &-JVS(1080)*XX(82)
  XX(28) = XX(28)-JVS(237)*XX(42)-JVS(466)*XX(59)-JVS(679)*XX(72)-JVS(797)*XX(76)-JVS(909)*XX(78)-JVS(1036)*XX(81)&
             &-JVS(1079)*XX(82)
  XX(27) = XX(27)-JVS(796)*XX(76)-JVS(908)*XX(78)
  XX(26) = XX(26)-JVS(236)*XX(42)-JVS(497)*XX(62)-JVS(795)*XX(76)-JVS(1078)*XX(82)
  XX(25) = XX(25)-JVS(678)*XX(72)-JVS(963)*XX(79)-JVS(1035)*XX(81)-JVS(1077)*XX(82)
  XX(24) = XX(24)-JVS(359)*XX(53)-JVS(422)*XX(58)-JVS(794)*XX(76)-JVS(848)*XX(77)-JVS(907)*XX(78)
  XX(23) = XX(23)-JVS(906)*XX(78)-JVS(1034)*XX(81)-JVS(1076)*XX(82)
  XX(22) = XX(22)-JVS(358)*XX(53)-JVS(793)*XX(76)-JVS(905)*XX(78)
  XX(21) = XX(21)-JVS(98)*XX(22)-JVS(251)*XX(44)-JVS(904)*XX(78)-JVS(1075)*XX(82)
  XX(20) = XX(20)-JVS(421)*XX(58)-JVS(722)*XX(74)-JVS(792)*XX(76)-JVS(903)*XX(78)
  XX(19) = XX(19)-JVS(791)*XX(76)-JVS(902)*XX(78)-JVS(962)*XX(79)-JVS(1074)*XX(82)
  XX(18) = XX(18)-JVS(721)*XX(74)-JVS(901)*XX(78)
  XX(17) = XX(17)-JVS(640)*XX(70)-JVS(900)*XX(78)
  XX(16) = XX(16)-JVS(200)*XX(38)-JVS(420)*XX(58)-JVS(899)*XX(78)-JVS(1073)*XX(82)
  XX(15) = XX(15)-JVS(332)*XX(52)-JVS(566)*XX(66)-JVS(790)*XX(76)-JVS(898)*XX(78)
  XX(14) = XX(14)-JVS(199)*XX(38)-JVS(267)*XX(46)-JVS(419)*XX(58)-JVS(565)*XX(66)-JVS(706)*XX(73)-JVS(789)*XX(76)&
             &-JVS(897)*XX(78)
  XX(13) = XX(13)-JVS(250)*XX(44)-JVS(896)*XX(78)
  XX(12) = XX(12)-JVS(112)*XX(24)-JVS(403)*XX(56)-JVS(564)*XX(66)-JVS(788)*XX(76)-JVS(895)*XX(78)
  XX(11) = XX(11)-JVS(961)*XX(79)-JVS(1072)*XX(82)
  XX(10) = XX(10)-JVS(147)*XX(29)-JVS(531)*XX(64)-JVS(787)*XX(76)-JVS(894)*XX(78)
  XX(9) = XX(9)-JVS(142)*XX(28)-JVS(530)*XX(64)-JVS(786)*XX(76)-JVS(893)*XX(78)
  XX(8) = XX(8)-JVS(331)*XX(52)-JVS(411)*XX(57)-JVS(785)*XX(76)-JVS(892)*XX(78)
  XX(7) = XX(7)-JVS(297)*XX(49)
  XX(6) = XX(6)-JVS(118)*XX(25)-JVS(891)*XX(78)
  XX(5) = XX(5)-JVS(784)*XX(76)-JVS(890)*XX(78)
  XX(4) = XX(4)
  XX(3) = XX(3)
  XX(2) = XX(2)
  XX(1) = XX(1)
      
END SUBROUTINE KppSolveTR

! End of KppSolveTR function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! BLAS_UTIL - BLAS-LIKE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!--------------------------------------------------------------
!
! BLAS/LAPACK-like subroutines used by the integration algorithms
! It is recommended to replace them by calls to the optimized
!      BLAS/LAPACK library for your machine
!
!  (C) Adrian Sandu, Aug. 2004
!      Virginia Polytechnic Institute and State University
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE WCOPY(N,X,incX,Y,incY)
!--------------------------------------------------------------
!     copies a vector, x, to a vector, y:  y <- x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL  SCOPY(N,X,1,Y,1)   or   CALL  DCOPY(N,X,1,Y,1)
!--------------------------------------------------------------
!     USE RACM_Precision
      
      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N)

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = X(i)
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i) = X(i)
        Y(i + 1) = X(i + 1)
        Y(i + 2) = X(i + 2)
        Y(i + 3) = X(i + 3)
        Y(i + 4) = X(i + 4)
        Y(i + 5) = X(i + 5)
        Y(i + 6) = X(i + 6)
        Y(i + 7) = X(i + 7)
      END DO

      END SUBROUTINE WCOPY


!--------------------------------------------------------------
      SUBROUTINE WAXPY(N,Alpha,X,incX,Y,incY)
!--------------------------------------------------------------
!     constant times a vector plus a vector: y <- y + Alpha*x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SAXPY(N,Alpha,X,1,Y,1) or  CALL DAXPY(N,Alpha,X,1,Y,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N),Alpha
      REAL(kind=dp), PARAMETER :: ZERO = 0.0_dp

      IF (Alpha .EQ. ZERO) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,4)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = Y(i) + Alpha*X(i)
        END DO
        IF( N .LT. 4 ) RETURN
      END IF
      MP1 = M + 1
      DO i = MP1,N,4
        Y(i) = Y(i) + Alpha*X(i)
        Y(i + 1) = Y(i + 1) + Alpha*X(i + 1)
        Y(i + 2) = Y(i + 2) + Alpha*X(i + 2)
        Y(i + 3) = Y(i + 3) + Alpha*X(i + 3)
      END DO
      
      END SUBROUTINE WAXPY



!--------------------------------------------------------------
      SUBROUTINE WSCAL(N,Alpha,X,incX)
!--------------------------------------------------------------
!     constant times a vector: x(1:N) <- Alpha*x(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SSCAL(N,Alpha,X,1) or  CALL DSCAL(N,Alpha,X,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,M,MP1,N
      REAL(kind=dp)  :: X(N),Alpha
      REAL(kind=dp), PARAMETER  :: ZERO=0.0_dp, ONE=1.0_dp

      IF (Alpha .EQ. ONE) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,5)
      IF( M .NE. 0 ) THEN
        IF (Alpha .EQ. (-ONE)) THEN
          DO i = 1,M
            X(i) = -X(i)
          END DO
        ELSEIF (Alpha .EQ. ZERO) THEN
          DO i = 1,M
            X(i) = ZERO
          END DO
        ELSE
          DO i = 1,M
            X(i) = Alpha*X(i)
          END DO
        END IF
        IF( N .LT. 5 ) RETURN
      END IF
      MP1 = M + 1
      IF (Alpha .EQ. (-ONE)) THEN
        DO i = MP1,N,5
          X(i)     = -X(i)
          X(i + 1) = -X(i + 1)
          X(i + 2) = -X(i + 2)
          X(i + 3) = -X(i + 3)
          X(i + 4) = -X(i + 4)
        END DO
      ELSEIF (Alpha .EQ. ZERO) THEN
        DO i = MP1,N,5
          X(i)     = ZERO
          X(i + 1) = ZERO
          X(i + 2) = ZERO
          X(i + 3) = ZERO
          X(i + 4) = ZERO
        END DO
      ELSE
        DO i = MP1,N,5
          X(i)     = Alpha*X(i)
          X(i + 1) = Alpha*X(i + 1)
          X(i + 2) = Alpha*X(i + 2)
          X(i + 3) = Alpha*X(i + 3)
          X(i + 4) = Alpha*X(i + 4)
        END DO
      END IF

      END SUBROUTINE WSCAL

!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WLAMCH( C )
!--------------------------------------------------------------
!     returns epsilon machine
!     after LAPACK
!     replace this by the function from the optimized LAPACK implementation:
!          CALL SLAMCH('E') or CALL DLAMCH('E')
!--------------------------------------------------------------
!      USE RACM_Precision

      CHARACTER ::  C
      INTEGER    :: i
      REAL(kind=dp), SAVE  ::  Eps
      REAL(kind=dp)  ::  Suma
      REAL(kind=dp), PARAMETER  ::  ONE=1.0_dp, HALF=0.5_dp
      LOGICAL, SAVE   ::  First=.TRUE.
      
      IF (First) THEN
        First = .FALSE.
        Eps = HALF**(16)
        DO i = 17, 80
          Eps = Eps*HALF
          CALL WLAMCH_ADD(ONE,Eps,Suma)
          IF (Suma.LE.ONE) GOTO 10
        END DO
        PRINT*,'ERROR IN WLAMCH. EPS < ',Eps
        RETURN
10      Eps = Eps*2
        i = i-1      
      END IF

      WLAMCH = Eps

      END FUNCTION WLAMCH
     
      SUBROUTINE WLAMCH_ADD( A, B, Suma )
!      USE RACM_Precision
      
      REAL(kind=dp) A, B, Suma
      Suma = A + B

      END SUBROUTINE WLAMCH_ADD
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE SET2ZERO(N,Y)
!--------------------------------------------------------------
!     copies zeros into the vector y:  y <- 0
!     after BLAS
!--------------------------------------------------------------
      
      INTEGER ::  i,M,MP1,N
      REAL(kind=dp) ::  Y(N)
      REAL(kind=dp), PARAMETER :: ZERO = 0.0d0

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = ZERO
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i)     = ZERO
        Y(i + 1) = ZERO
        Y(i + 2) = ZERO
        Y(i + 3) = ZERO
        Y(i + 4) = ZERO
        Y(i + 5) = ZERO
        Y(i + 6) = ZERO
        Y(i + 7) = ZERO
      END DO

      END SUBROUTINE SET2ZERO


!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WDOT (N, DX, incX, DY, incY) 
!--------------------------------------------------------------
!     dot produce: wdot = x(1:N)*y(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SDOT(N,X,1,Y,1) or  CALL DDOT(N,X,1,Y,1)
!--------------------------------------------------------------
!      USE messy_mecca_kpp_Precision
!--------------------------------------------------------------
      IMPLICIT NONE
      INTEGER :: N, incX, incY
      REAL(kind=dp) :: DX(N), DY(N) 

      INTEGER :: i, IX, IY, M, MP1, NS
                                 
      WDOT = 0.0D0 
      IF (N .LE. 0) RETURN 
      IF (incX .EQ. incY) IF (incX-1) 5,20,60 
!                                                                       
!     Code for unequal or nonpositive increments.                       
!                                                                       
    5 IX = 1 
      IY = 1 
      IF (incX .LT. 0) IX = (-N+1)*incX + 1 
      IF (incY .LT. 0) IY = (-N+1)*incY + 1 
      DO i = 1,N 
        WDOT = WDOT + DX(IX)*DY(IY) 
        IX = IX + incX 
        IY = IY + incY 
      END DO 
      RETURN 
!                                                                       
!     Code for both increments equal to 1.                              
!                                                                       
!     Clean-up loop so remaining vector length is a multiple of 5.      
!                                                                       
   20 M = MOD(N,5) 
      IF (M .EQ. 0) GO TO 40 
      DO i = 1,M 
         WDOT = WDOT + DX(i)*DY(i) 
      END DO 
      IF (N .LT. 5) RETURN 
   40 MP1 = M + 1 
      DO i = MP1,N,5 
          WDOT = WDOT + DX(i)*DY(i) + DX(i+1)*DY(i+1) + DX(i+2)*DY(i+2) +  &
                   DX(i+3)*DY(i+3) + DX(i+4)*DY(i+4)                   
      END DO 
      RETURN 
!                                                                       
!     Code for equal, positive, non-unit increments.                    
!                                                                       
   60 NS = N*incX 
      DO i = 1,NS,incX 
        WDOT = WDOT + DX(i)*DY(i) 
      END DO 

      END FUNCTION WDOT                                          


!--------------------------------------------------------------
      SUBROUTINE WADD(N,X,Y,Z)
!--------------------------------------------------------------
!     adds two vectors: z <- x + y
!     BLAS - like
!--------------------------------------------------------------
!     USE RACM_Precision
      
      INTEGER :: i, M, MP1, N
      REAL(kind=dp) :: X(N),Y(N),Z(N)

      IF (N.LE.0) RETURN

      M = MOD(N,5)
      IF( M /= 0 ) THEN
         DO i = 1,M
            Z(i) = X(i) + Y(i)
         END DO
         IF( N < 5 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,5
         Z(i)     = X(i)     + Y(i)
         Z(i + 1) = X(i + 1) + Y(i + 1)
         Z(i + 2) = X(i + 2) + Y(i + 2)
         Z(i + 3) = X(i + 3) + Y(i + 3)
         Z(i + 4) = X(i + 4) + Y(i + 4)
      END DO

      END SUBROUTINE WADD
      
      
      
!--------------------------------------------------------------
      SUBROUTINE WGEFA(N,A,Ipvt,info)
!--------------------------------------------------------------
!     WGEFA FACTORS THE MATRIX A (N,N) BY
!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!     LINPACK - LIKE 
!--------------------------------------------------------------
!
      INTEGER       :: N,Ipvt(N),info
      REAL(kind=dp) :: A(N,N)
      REAL(kind=dp) :: t, dmax, da
      INTEGER       :: j,k,l
      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0

      info = 0

size: IF (n > 1) THEN
      
col:  DO k = 1, n-1

!        find l = pivot index
!        l = idamax(n-k+1,A(k,k),1) + k - 1
         l = k; dmax = abs(A(k,k))
         DO j = k+1,n
            da = ABS(A(j,k))
            IF (da > dmax) THEN
              l = j; dmax = da
            END IF
         END DO
         Ipvt(k) = l

!        zero pivot implies this column already triangularized
         IF (ABS(A(l,k)) < TINY(ZERO)) THEN
            info = k
            return
         ELSE   
            IF (l /= k) THEN
               t = A(l,k); A(l,k) = A(k,k); A(k,k) = t
            END IF
            t = -ONE/A(k,k)
            CALL WSCAL(n-k,t,A(k+1,k),1)
            DO j = k+1, n
               t = A(l,j)
               IF (l /= k) THEN
                  A(l,j) = A(k,j); A(k,j) = t
               END IF
               CALL WAXPY(n-k,t,A(k+1,k),1,A(k+1,j),1)
            END DO         
         END IF
         
       END DO col
       
      END IF size
      
      Ipvt(N) = N
      IF (ABS(A(N,N)) == ZERO) info = N
      
      END SUBROUTINE WGEFA


!--------------------------------------------------------------
      SUBROUTINE WGESL(Trans,N,A,Ipvt,b)
!--------------------------------------------------------------
!     WGESL solves the system
!     a * x = b  or  trans(a) * x = b
!     using the factors computed by WGEFA.
!
!     Trans      = 'N'   to solve  A*x = b ,
!                = 'T'   to solve  transpose(A)*x = b
!     LINPACK - LIKE 
!--------------------------------------------------------------

      INTEGER       :: N,Ipvt(N)
      CHARACTER     :: trans
      REAL(kind=dp) :: A(N,N),b(N)
      REAL(kind=dp) :: t
      INTEGER       :: k,kb,l

      
      SELECT CASE (Trans)

      CASE ('n','N')  !  Solve  A * x = b

!        first solve  L*y = b
         IF (n >= 2) THEN
          DO k = 1, n-1
            l = Ipvt(k)
            t = b(l)
            IF (l /= k) THEN
               b(l) = b(k)
               b(k) = t
            END IF
            CALL WAXPY(n-k,t,a(k+1,k),1,b(k+1),1)
          END DO
         END IF
!        now solve  U*x = y
         DO kb = 1, n
            k = n + 1 - kb
            b(k) = b(k)/a(k,k)
            t = -b(k)
            CALL WAXPY(k-1,t,a(1,k),1,b(1),1)
         END DO
      
      CASE ('t','T')  !  Solve transpose(A) * x = b

!        first solve  trans(U)*y = b
         DO k = 1, n
            t = WDOT(k-1,a(1,k),1,b(1),1)
            b(k) = (b(k) - t)/a(k,k)
         END DO
!        now solve trans(L)*x = y
         IF (n >= 2) THEN
         DO kb = 1, n-1
            k = n - kb
            b(k) = b(k) + WDOT(n-k,a(k+1,k),1,b(k+1),1)
            l = Ipvt(k)
            IF (l /= k) THEN
               t = b(l); b(l) = b(k); b(k) = t
            END IF
         END DO
         END IF
   
      END SELECT

      END SUBROUTINE WGESL
! End of BLAS_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE RACM_LinearAlgebra

