! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : RACM_Function.f90
! Time                 : Thu Oct  8 08:22:22 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_RACM_22746_BOXMOX
! Equation file        : RACM.kpp
! Output root filename : RACM
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE RACM_Function

  USE RACM_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(82)
  A(2) = RCT(2)*V(72)
  A(3) = RCT(3)*V(72)
  A(4) = RCT(4)*V(23)
  A(5) = RCT(5)*V(32)
  A(6) = RCT(6)*V(19)
  A(7) = RCT(7)*V(79)
  A(8) = RCT(8)*V(79)
  A(9) = RCT(9)*V(27)
  A(10) = RCT(10)*V(58)
  A(11) = RCT(11)*V(58)
  A(12) = RCT(12)*V(66)
  A(13) = RCT(13)*V(20)
  A(14) = RCT(14)*V(75)
  A(15) = RCT(15)*V(33)
  A(16) = RCT(16)*V(52)
  A(17) = RCT(17)*V(46)
  A(18) = RCT(18)*V(46)
  A(19) = RCT(19)*V(53)
  A(20) = RCT(20)*V(63)
  A(21) = RCT(21)*V(62)
  A(22) = RCT(22)*V(49)
  A(23) = RCT(23)*V(24)
  A(24) = RCT(24)*V(25)*F(2)
  A(25) = RCT(25)*V(25)*V(72)
  A(26) = RCT(26)*V(6)*F(2)
  A(27) = RCT(27)*V(6)*F(1)
  A(28) = RCT(28)*V(72)*V(78)
  A(29) = RCT(29)*V(72)*V(76)
  A(30) = RCT(30)*V(76)*V(78)
  A(31) = RCT(31)*V(27)*V(78)
  A(32) = RCT(32)*V(76)*V(76)
  A(33) = RCT(33)*V(76)*V(76)*F(1)
  A(34) = RCT(34)*V(25)*V(81)
  A(35) = RCT(35)*V(25)*V(82)
  A(36) = RCT(36)*V(25)*V(82)
  A(37) = RCT(37)*V(78)*V(81)
  A(38) = RCT(38)*V(78)*V(82)
  A(39) = RCT(39)*V(78)*V(79)
  A(40) = RCT(40)*V(76)*V(81)
  A(41) = RCT(41)*V(76)*V(82)
  A(42) = RCT(42)*V(19)
  A(43) = RCT(43)*V(76)*V(79)
  A(44) = RCT(44)*V(23)*V(78)
  A(45) = RCT(45)*V(32)*V(78)
  A(46) = RCT(46)*V(19)*V(78)
  A(47) = RCT(47)*V(72)*V(81)
  A(48) = RCT(48)*V(72)*V(82)
  A(49) = RCT(49)*V(81)*V(81)*F(2)
  A(50) = RCT(50)*V(79)*V(81)
  A(51) = RCT(51)*V(79)*V(82)
  A(52) = RCT(52)*V(79)*V(82)
  A(53) = RCT(53)*V(11)
  A(54) = RCT(54)*V(79)*V(79)
  A(55) = RCT(55)*V(78)*F(2)
  A(56) = RCT(56)*V(5)*V(78)
  A(57) = RCT(57)*V(38)*V(78)
  A(58) = RCT(58)*V(16)*V(78)
  A(59) = RCT(59)*V(22)*V(78)
  A(60) = RCT(60)*V(18)*V(78)
  A(61) = RCT(61)*V(17)*V(78)
  A(62) = RCT(62)*V(14)*V(78)
  A(63) = RCT(63)*V(8)*V(78)
  A(64) = RCT(64)*V(12)*V(78)
  A(65) = RCT(65)*V(30)*V(78)
  A(66) = RCT(66)*V(65)*V(78)
  A(67) = RCT(67)*V(67)*V(78)
  A(68) = RCT(68)*V(43)*V(78)
  A(69) = RCT(69)*V(40)*V(78)
  A(70) = RCT(70)*V(37)*V(78)
  A(71) = RCT(71)*V(39)*V(78)
  A(72) = RCT(72)*V(9)*V(78)
  A(73) = RCT(73)*V(10)*V(78)
  A(74) = RCT(74)*V(42)*V(78)
  A(75) = RCT(75)*V(58)*V(78)
  A(76) = RCT(76)*V(66)*V(78)
  A(77) = RCT(77)*V(52)*V(78)
  A(78) = RCT(78)*V(24)*V(78)
  A(79) = RCT(79)*V(46)*V(78)
  A(80) = RCT(80)*V(53)*V(78)
  A(81) = RCT(81)*V(49)*V(78)
  A(82) = RCT(82)*V(63)*V(78)
  A(83) = RCT(83)*V(15)*V(78)
  A(84) = RCT(84)*V(20)*V(78)
  A(85) = RCT(85)*V(75)*V(78)
  A(86) = RCT(86)*V(33)*V(78)
  A(87) = RCT(87)*V(36)*V(78)
  A(88) = RCT(88)*V(45)*V(78)
  A(89) = RCT(89)*V(62)*V(78)
  A(90) = RCT(90)*V(58)*V(79)
  A(91) = RCT(91)*V(66)*V(79)
  A(92) = RCT(92)*V(46)*V(79)
  A(93) = RCT(93)*V(53)*V(79)
  A(94) = RCT(94)*V(13)*V(78)
  A(95) = RCT(95)*V(63)*V(79)
  A(96) = RCT(96)*V(42)*V(79)
  A(97) = RCT(97)*V(30)*V(79)
  A(98) = RCT(98)*V(65)*V(79)
  A(99) = RCT(99)*V(67)*V(79)
  A(100) = RCT(100)*V(43)*V(79)
  A(101) = RCT(101)*V(40)*V(79)
  A(102) = RCT(102)*V(37)*V(79)
  A(103) = RCT(103)*V(39)*V(79)
  A(104) = RCT(104)*V(45)*V(79)
  A(105) = RCT(105)*V(30)*V(72)
  A(106) = RCT(106)*V(65)*V(72)
  A(107) = RCT(107)*V(67)*V(72)
  A(108) = RCT(108)*V(43)*V(72)
  A(109) = RCT(109)*V(40)*V(72)
  A(110) = RCT(110)*V(37)*V(72)
  A(111) = RCT(111)*V(39)*V(72)
  A(112) = RCT(112)*V(49)*V(72)
  A(113) = RCT(113)*V(63)*V(72)
  A(114) = RCT(114)*V(45)*V(72)
  A(115) = RCT(115)*V(26)*V(82)
  A(116) = RCT(116)*V(26)*V(76)
  A(117) = RCT(117)*V(28)*V(82)
  A(118) = RCT(118)*V(28)*F(2)
  A(119) = RCT(119)*V(28)*V(72)
  A(120) = RCT(120)*V(29)*V(82)
  A(121) = RCT(121)*V(29)*F(2)
  A(122) = RCT(122)*V(29)*V(72)
  A(123) = RCT(123)*V(31)*V(82)
  A(124) = RCT(124)*V(31)*F(2)
  A(125) = RCT(125)*V(31)*V(72)
  A(126) = RCT(126)*V(77)*V(82)
  A(127) = RCT(127)*V(36)
  A(128) = RCT(128)*V(71)*V(82)
  A(129) = RCT(129)*V(45)
  A(130) = RCT(130)*V(74)*V(81)
  A(131) = RCT(131)*V(70)*V(81)
  A(132) = RCT(132)*V(73)*V(81)
  A(133) = RCT(133)*V(57)*V(81)
  A(134) = RCT(134)*V(56)*V(81)
  A(135) = RCT(135)*V(47)*V(81)
  A(136) = RCT(136)*V(48)*V(81)
  A(137) = RCT(137)*V(61)*V(81)
  A(138) = RCT(138)*V(50)*V(81)
  A(139) = RCT(139)*V(51)*V(81)
  A(140) = RCT(140)*V(55)*V(81)
  A(141) = RCT(141)*V(59)*V(81)
  A(142) = RCT(142)*V(60)*V(81)
  A(143) = RCT(143)*V(54)*V(81)
  A(144) = RCT(144)*V(77)*V(81)
  A(145) = RCT(145)*V(71)*V(81)
  A(146) = RCT(146)*V(80)*V(81)
  A(147) = RCT(147)*V(69)*V(81)
  A(148) = RCT(148)*V(68)*V(81)
  A(149) = RCT(149)*V(74)*V(76)
  A(150) = RCT(150)*V(70)*V(76)
  A(151) = RCT(151)*V(73)*V(76)
  A(152) = RCT(152)*V(57)*V(76)
  A(153) = RCT(153)*V(56)*V(76)
  A(154) = RCT(154)*V(47)*V(76)
  A(155) = RCT(155)*V(48)*V(76)
  A(156) = RCT(156)*V(61)*V(76)
  A(157) = RCT(157)*V(50)*V(76)
  A(158) = RCT(158)*V(51)*V(76)
  A(159) = RCT(159)*V(55)*V(76)
  A(160) = RCT(160)*V(59)*V(76)
  A(161) = RCT(161)*V(60)*V(76)
  A(162) = RCT(162)*V(54)*V(76)
  A(163) = RCT(163)*V(76)*V(77)
  A(164) = RCT(164)*V(76)*V(77)
  A(165) = RCT(165)*V(71)*V(76)
  A(166) = RCT(166)*V(71)*V(76)
  A(167) = RCT(167)*V(76)*V(80)
  A(168) = RCT(168)*V(69)*V(76)
  A(169) = RCT(169)*V(68)*V(76)
  A(170) = RCT(170)*V(74)*V(74)
  A(171) = RCT(171)*V(70)*V(74)
  A(172) = RCT(172)*V(73)*V(74)
  A(173) = RCT(173)*V(57)*V(74)
  A(174) = RCT(174)*V(56)*V(74)
  A(175) = RCT(175)*V(47)*V(74)
  A(176) = RCT(176)*V(48)*V(74)
  A(177) = RCT(177)*V(61)*V(74)
  A(178) = RCT(178)*V(50)*V(74)
  A(179) = RCT(179)*V(51)*V(74)
  A(180) = RCT(180)*V(55)*V(74)
  A(181) = RCT(181)*V(59)*V(74)
  A(182) = RCT(182)*V(60)*V(74)
  A(183) = RCT(183)*V(54)*V(74)
  A(184) = RCT(184)*V(74)*V(77)
  A(185) = RCT(185)*V(74)*V(77)
  A(186) = RCT(186)*V(71)*V(74)
  A(187) = RCT(187)*V(71)*V(74)
  A(188) = RCT(188)*V(74)*V(80)
  A(189) = RCT(189)*V(69)*V(74)
  A(190) = RCT(190)*V(68)*V(74)
  A(191) = RCT(191)*V(70)*V(77)
  A(192) = RCT(192)*V(73)*V(77)
  A(193) = RCT(193)*V(57)*V(77)
  A(194) = RCT(194)*V(56)*V(77)
  A(195) = RCT(195)*V(47)*V(77)
  A(196) = RCT(196)*V(48)*V(77)
  A(197) = RCT(197)*V(61)*V(77)
  A(198) = RCT(198)*V(50)*V(77)
  A(199) = RCT(199)*V(51)*V(77)
  A(200) = RCT(200)*V(55)*V(77)
  A(201) = RCT(201)*V(59)*V(77)
  A(202) = RCT(202)*V(60)*V(77)
  A(203) = RCT(203)*V(54)*V(77)
  A(204) = RCT(204)*V(77)*V(77)
  A(205) = RCT(205)*V(71)*V(77)
  A(206) = RCT(206)*V(77)*V(80)
  A(207) = RCT(207)*V(69)*V(77)
  A(208) = RCT(208)*V(68)*V(77)
  A(209) = RCT(209)*V(69)*V(69)
  A(210) = RCT(210)*V(68)*V(69)
  A(211) = RCT(211)*V(68)*V(68)
  A(212) = RCT(212)*V(74)*V(79)
  A(213) = RCT(213)*V(70)*V(79)
  A(214) = RCT(214)*V(73)*V(79)
  A(215) = RCT(215)*V(57)*V(79)
  A(216) = RCT(216)*V(56)*V(79)
  A(217) = RCT(217)*V(47)*V(79)
  A(218) = RCT(218)*V(48)*V(79)
  A(219) = RCT(219)*V(61)*V(79)
  A(220) = RCT(220)*V(21)*V(78)
  A(221) = RCT(221)*V(51)*V(79)
  A(222) = RCT(222)*V(55)*V(79)
  A(223) = RCT(223)*V(59)*V(79)
  A(224) = RCT(224)*V(60)*V(79)
  A(225) = RCT(225)*V(54)*V(79)
  A(226) = RCT(226)*V(77)*V(79)
  A(227) = RCT(227)*V(71)*V(79)
  A(228) = RCT(228)*V(79)*V(80)
  A(229) = RCT(229)*V(69)*V(79)
  A(230) = RCT(230)*V(68)*V(79)
  A(231) = RCT(231)*V(64)*V(76)
  A(232) = RCT(232)*V(64)*V(74)
  A(233) = RCT(233)*V(64)*V(77)
  A(234) = RCT(234)*V(64)*V(64)
  A(235) = RCT(235)*V(64)*V(81)
  A(236) = RCT(236)*V(64)*V(79)
  A(237) = RCT(237)*V(50)*V(50)
  A(238) = RCT(238)*V(7)*V(78)
  A(239) = RCT(239)*V(34)*V(78)
  A(240) = RCT(240)*V(44)*V(81)
  A(241) = RCT(241)*V(44)*V(76)
  A(242) = RCT(242)*V(44)*V(44)
  A(243) = RCT(243)*V(44)*V(82)
  A(244) = RCT(244)*V(21)
  A(245) = RCT(245)*V(35)*V(78)
  A(246) = RCT(246)*V(35)*V(72)
  A(247) = RCT(247)*V(35)*V(79)
  A(248) = RCT(248)*V(41)*V(78)
  A(249) = RCT(249)*V(41)*V(79)
  A(250) = RCT(250)*V(41)*V(72)

! Aggregate function
  Vdot(1) = A(56)
  Vdot(2) = A(57)
  Vdot(3) = 0.036*A(62)+0.37*A(105)+0.14*A(106)+0.15*A(108)+0.28*A(109)+0.01*A(111)+0.45*A(112)+0.11*A(113)+0.11*A(114)&
              &+0.05*A(245)+0.039*A(246)
  Vdot(4) = 0.1*A(106)+0.14*A(107)+0.07*A(111)+0.21*A(113)+A(164)+A(166)+A(185)+A(187)+0.5*A(191)+0.499*A(192)+0.495&
              &*A(193)+0.495*A(194)+0.5*A(195)+0.499*A(196)+0.49*A(197)+0.494*A(198)+0.5*A(206)+0.5*A(207)+0.484*A(208)&
              &+0.053*A(246)+0.14*A(250)
  Vdot(5) = -A(56)
  Vdot(6) = A(2)-A(26)-A(27)
  Vdot(7) = A(157)-A(238)
  Vdot(8) = -A(63)
  Vdot(9) = -A(72)
  Vdot(10) = -A(73)
  Vdot(11) = A(52)-A(53)
  Vdot(12) = -A(64)
  Vdot(13) = -A(94)+A(241)
  Vdot(14) = -A(62)
  Vdot(15) = 0.35*A(82)-A(83)
  Vdot(16) = -A(58)+A(239)
  Vdot(17) = -A(61)+0.03*A(106)+0.06*A(107)+0.06*A(250)
  Vdot(18) = -A(60)+0.06*A(106)+0.07*A(107)+0.07*A(250)
  Vdot(19) = -A(6)+A(41)-A(42)-A(46)
  Vdot(20) = -A(13)-A(84)+A(149)
  Vdot(21) = -A(220)+A(243)-A(244)
  Vdot(22) = -A(59)+A(220)+A(239)+0.25*A(240)+A(242)
  Vdot(23) = -A(4)+A(37)-A(44)+A(117)+A(120)+A(123)
  Vdot(24) = -A(23)+0.024*A(64)-A(78)+0.6*A(88)+0.3*A(188)
  Vdot(25) = A(1)+A(3)+A(8)-A(24)-A(25)+A(26)-A(34)-A(35)-A(36)+0.09*A(108)
  Vdot(26) = 0.1*A(74)+A(96)-A(115)-A(116)
  Vdot(27) = -A(9)-A(31)+A(32)+A(33)+0.006*A(106)+0.011*A(107)+0.001*A(108)+0.09*A(109)+0.02*A(110)+0.02*A(111)+0.011&
               &*A(250)
  Vdot(28) = 0.9*A(72)-A(117)-A(118)-A(119)
  Vdot(29) = 0.9*A(73)-A(120)-A(121)-A(122)
  Vdot(30) = -A(65)-A(97)-A(105)
  Vdot(31) = 0.85*A(74)-A(123)-A(124)-A(125)
  Vdot(32) = -A(5)+A(38)+0.3*A(43)-A(45)+A(90)+A(91)+A(92)+A(93)+0.5*A(95)+A(96)
  Vdot(33) = -A(15)-A(86)+0.11*A(113)+A(163)
  Vdot(34) = A(101)+0.046*A(138)-A(239)
  Vdot(35) = -A(245)-A(246)-A(247)
  Vdot(36) = -A(87)+0.4*A(88)+0.4*A(104)+0.3*A(114)+A(126)-A(127)
  Vdot(37) = -A(70)-A(102)-A(110)
  Vdot(38) = A(10)+A(11)+A(12)+1.87*A(17)+1.55*A(18)+A(19)+A(22)-A(57)+A(58)+0.036*A(62)+A(75)+2*A(79)+A(80)+A(90)+2&
               &*A(92)+A(93)+0.43*A(105)+0.37*A(106)+0.3*A(107)+0.36*A(108)+0.14*A(109)+0.14*A(110)+0.14*A(111)+0.22*A(112)&
               &+0.66*A(113)+0.13*A(114)+0.25*A(240)+0.5*A(242)+0.3*A(250)
  Vdot(39) = -A(71)-A(103)-A(111)
  Vdot(40) = -A(69)-A(101)-A(109)
  Vdot(41) = -A(248)-A(249)-A(250)
  Vdot(42) = -A(74)-A(96)+0.1*A(115)+A(116)+A(117)+0.02*A(118)+A(119)+A(120)+0.02*A(121)+A(122)+A(123)+0.02*A(124)&
               &+A(125)
  Vdot(43) = -A(68)-A(100)-A(108)
  Vdot(44) = A(81)+A(94)+0.1*A(109)-A(240)-A(241)-2*A(242)-A(243)+A(244)
  Vdot(45) = -A(88)-A(104)-A(114)+A(128)-A(129)
  Vdot(46) = -A(17)-A(18)+0.036*A(62)-A(79)+0.15*A(82)-A(92)+0.25*A(95)+0.5*A(113)+0.063*A(132)+1.2*A(141)+0.35*A(142)&
               &+A(143)+0.119*A(172)+0.65*A(181)+0.37*A(182)+A(183)+0.1*A(192)+0.65*A(201)+0.37*A(202)+A(203)+0.063*A(214)&
               &+1.3*A(223)+0.74*A(224)+A(225)
  Vdot(47) = A(65)-A(135)-A(154)-A(175)-A(195)-A(217)
  Vdot(48) = A(66)-A(136)-A(155)-A(176)-A(196)-A(218)
  Vdot(49) = -A(22)-A(81)+0.9*A(100)+0.39*A(108)+0.65*A(109)+0.79*A(111)-A(112)+A(138)+0.4*A(140)+0.55*A(178)+0.6*A(180)&
               &+0.771*A(198)+0.6*A(200)+0.6*A(222)+2*A(237)+A(238)+0.9*A(247)
  Vdot(50) = A(68)+A(69)-A(138)-A(157)-A(178)-A(198)-2*A(237)
  Vdot(51) = A(70)-A(139)-A(158)-A(179)-A(199)-A(221)
  Vdot(52) = -A(16)+0.8*A(21)+0.25*A(63)-A(77)+0.12*A(83)+0.41*A(85)+0.03*A(95)+0.03*A(106)+0.16*A(107)+0.53*A(110)&
               &+0.623*A(132)+0.722*A(133)+0.642*A(134)+0.06*A(136)+0.29*A(137)+0.8*A(139)+0.464*A(148)+0.018*A(172)+0.24&
               &*A(173)+0.419*A(174)+0.081*A(176)+0.313*A(177)+A(179)+0.149*A(190)+0.127*A(192)+0.33*A(193)+0.581*A(194)&
               &+0.141*A(196)+0.569*A(197)+A(199)+0.11*A(206)+0.167*A(208)+0.149*A(210)+0.285*A(211)+0.67*A(214)+0.828&
               &*A(215)+0.88*A(216)+0.06*A(218)+0.29*A(219)+A(221)+0.469*A(230)+0.36*A(245)+0.23*A(246)+0.16*A(250)
  Vdot(53) = -A(19)+A(59)+A(78)-A(80)+0.15*A(82)-A(93)+0.25*A(95)+0.9*A(112)+0.62*A(113)+0.65*A(141)+0.6*A(142)+A(143)&
               &+0.54*A(146)+0.005*A(172)+0.35*A(181)+0.63*A(182)+A(183)+0.4*A(188)+0.004*A(192)+0.35*A(201)+0.63*A(202)&
               &+A(203)+0.54*A(206)+0.7*A(223)+1.26*A(224)+A(225)+0.54*A(228)+0.5*A(240)+A(242)
  Vdot(54) = 0.98*A(124)-A(143)-A(162)-A(183)-A(203)-A(225)
  Vdot(55) = A(71)-A(140)-A(159)-A(180)-A(200)-A(222)
  Vdot(56) = 0.9511*A(64)-A(134)-A(153)-A(174)-A(194)-A(216)
  Vdot(57) = 0.75*A(63)-A(133)-A(152)-A(173)-A(193)-A(215)
  Vdot(58) = -A(10)-A(11)+A(13)+0.13*A(17)+0.45*A(18)+A(22)+A(23)+A(58)+0.01*A(62)-A(75)+0.35*A(84)+0.35*A(86)+A(87)+0.4&
               &*A(88)-A(90)+0.4*A(104)+A(105)+0.64*A(106)+0.02*A(107)+0.9*A(108)+0.58*A(109)+0.04*A(111)+0.7*A(114)+A(130)&
               &+0.047*A(132)+0.021*A(133)+1.6*A(135)+A(136)+A(138)+0.25*A(140)+A(145)+0.287*A(148)+1.33*A(170)+0.75*A(171)&
               &+0.81*A(172)+0.829*A(173)+0.753*A(174)+1.55*A(175)+1.25*A(176)+0.755*A(177)+1.09*A(178)+A(179)+1.4*A(180)&
               &+A(181)+A(182)+A(183)+A(184)+A(185)+2*A(186)+A(187)+0.75*A(188)+0.75*A(189)+0.96*A(190)+0.091*A(192)+0.076&
               &*A(193)+0.8*A(195)+0.501*A(196)+0.34*A(198)+0.4*A(200)+A(205)+0.207*A(208)+0.202*A(210)+0.504*A(211)+A(212)&
               &+0.048*A(214)+0.021*A(215)+1.6*A(217)+A(218)+0.4*A(222)+A(227)+0.28*A(230)+A(232)+A(237)+0.75*A(240)+0.5&
               &*A(242)+0.3*A(245)+0.51*A(246)+0.02*A(250)
  Vdot(59) = 0.98*A(118)-A(141)-A(160)-A(181)-A(201)-A(223)
  Vdot(60) = 0.98*A(121)-A(142)-A(161)-A(182)-A(202)-A(224)
  Vdot(61) = A(67)-A(137)-A(156)-A(177)-A(197)-A(219)+0.19*A(245)+A(248)
  Vdot(62) = -A(21)-A(89)+0.6*A(104)+A(115)+0.059*A(132)+0.124*A(133)+0.261*A(134)+0.2*A(139)+0.35*A(140)+0.05*A(141)&
               &+0.05*A(142)+A(147)+A(168)+A(169)+A(189)+0.5*A(190)+A(207)+0.484*A(208)+2*A(209)+1.5*A(210)+A(211)+A(229)
  Vdot(63) = -A(20)-A(82)-A(95)-A(113)+0.5*A(141)+0.95*A(142)+A(181)+A(182)+A(201)+A(202)+0.5*A(223)+A(224)
  Vdot(64) = 0.1*A(72)+0.1*A(73)+0.05*A(74)+0.5*A(82)+0.07*A(85)+0.35*A(86)+A(87)+A(88)+0.5*A(95)+A(104)+0.13*A(108)&
               &+0.048*A(132)+0.334*A(133)+0.416*A(134)+0.16*A(146)+0.085*A(172)+0.245*A(173)+0.322*A(174)+0.08*A(188)+0.071&
               &*A(192)+0.237*A(193)+0.318*A(194)+0.08*A(206)+0.051*A(214)+0.391*A(215)+0.587*A(216)+0.16*A(228)-A(231)&
               &-A(232)-A(233)-2*A(234)-A(235)-A(236)
  Vdot(65) = -A(66)-A(98)-A(106)+0.35*A(108)+0.46*A(111)+0.37*A(178)+0.229*A(198)
  Vdot(66) = -A(12)+A(14)+0.2*A(21)+0.335*A(62)+0.025*A(64)-A(76)+0.88*A(83)+0.08*A(85)-A(91)+0.25*A(95)+0.44*A(106)&
               &+0.99*A(107)+0.65*A(110)+0.16*A(113)+A(131)+0.233*A(132)+0.211*A(133)+0.15*A(134)+0.2*A(135)+0.94*A(136)&
               &+1.71*A(137)+0.8*A(139)+0.46*A(146)+1.24*A(148)+0.75*A(171)+0.58*A(172)+0.523*A(173)+0.411*A(174)+0.35&
               &*A(175)+0.669*A(176)+0.932*A(177)+A(179)+0.3*A(188)+0.64*A(190)+A(191)+0.724*A(192)+0.677*A(193)+0.497&
               &*A(194)+0.6*A(195)+0.859*A(196)+0.941*A(197)+A(199)+0.35*A(206)+0.65*A(208)+0.64*A(210)+1.21*A(211)+A(213)&
               &+0.243*A(214)+0.239*A(215)+0.187*A(216)+0.2*A(217)+0.94*A(218)+1.71*A(219)+A(221)+0.46*A(228)+1.24*A(230)&
               &+0.85*A(246)+0.99*A(250)
  Vdot(67) = -A(67)-A(99)-A(107)+0.25*A(140)+0.08*A(178)+0.4*A(180)+0.4*A(200)+0.4*A(222)
  Vdot(68) = 0.2*A(97)+0.57*A(98)+0.89*A(99)+0.1*A(100)+0.9*A(102)+0.87*A(103)-A(148)-A(169)-A(190)-A(208)-A(210)-2&
               &*A(211)-A(230)+0.1*A(247)+0.89*A(249)
  Vdot(69) = 0.8*A(97)+0.43*A(98)+0.11*A(99)+0.9*A(100)+0.1*A(102)+0.13*A(103)-A(147)-A(168)-A(189)-A(207)-2*A(209)&
               &-A(210)-A(229)+0.9*A(247)+0.11*A(249)
  Vdot(70) = A(16)+A(61)+0.1*A(106)+0.18*A(107)+0.2*A(110)+0.16*A(111)-A(131)+0.048*A(132)+0.245*A(133)+0.133*A(134)&
               &-A(150)-A(171)+0.014*A(173)+0.013*A(174)-A(191)+0.006*A(192)+0.018*A(193)+0.015*A(194)-A(213)+0.053*A(214)&
               &+0.262*A(215)+0.155*A(216)+0.18*A(250)
  Vdot(71) = A(20)+0.5*A(82)+0.5*A(95)-A(128)+A(129)-A(145)-A(165)-A(166)-A(186)-A(187)-A(205)-A(227)
  Vdot(72) = -A(2)-A(3)+A(24)-A(25)-A(28)-A(29)-A(47)-A(48)-A(105)-A(106)-A(107)-A(108)-A(109)-A(110)-A(111)-A(112)&
               &-A(113)-A(114)-A(119)-A(122)-A(125)+A(164)+A(166)-A(246)-A(250)
  Vdot(73) = 0.583*A(62)+0.44*A(85)+A(89)-A(132)-A(151)-A(172)-A(192)-A(214)
  Vdot(74) = A(12)+A(15)+A(60)+0.65*A(84)+0.19*A(106)+0.23*A(107)+0.03*A(108)+0.08*A(109)-A(130)+0.15*A(132)+0.031&
               &*A(133)+A(144)-A(149)-2*A(170)-A(171)-0.993*A(172)-0.951*A(173)-A(174)-A(175)-A(176)-A(177)-A(178)-A(179)&
               &-A(180)-A(181)-A(182)-A(183)-A(185)-A(186)-A(187)-A(188)-A(189)-A(190)+0.5*A(191)+0.508*A(192)+0.554*A(193)&
               &+0.507*A(194)+0.5*A(195)+0.501*A(196)+0.51*A(197)+0.506*A(198)+A(199)+A(200)+A(201)+A(202)+A(203)+2*A(204)&
               &+A(205)+0.5*A(206)+0.5*A(207)+0.516*A(208)-A(212)+0.155*A(214)+0.04*A(215)+A(226)-A(232)+A(233)+0.23*A(250)
  Vdot(75) = -A(14)-A(85)+A(150)+A(151)+A(152)+A(153)+A(154)+A(155)+A(156)+A(158)+A(159)+A(160)+A(161)+A(162)+A(165)&
               &+A(167)+A(231)
  Vdot(76) = 0.65*A(6)+2*A(11)+A(12)+A(13)+A(14)+0.8*A(18)+A(19)+A(20)+A(21)+A(22)+A(23)+A(28)-A(29)-A(30)+A(31)-2*A(32)&
               &-2*A(33)+A(39)-A(40)-A(41)+A(42)-A(43)+A(55)+A(56)+A(57)+A(59)+0.381*A(62)+0.25*A(63)+0.049*A(64)+0.1*A(72)&
               &+0.1*A(73)+0.05*A(74)+A(75)+A(78)+A(79)+0.5*A(82)+A(83)+0.35*A(86)+0.4*A(88)+A(90)+A(92)+0.5*A(95)+0.26&
               &*A(105)+0.25*A(106)+0.22*A(107)+0.3*A(108)+0.25*A(109)+0.1*A(110)+0.1*A(111)+0.32*A(112)+0.29*A(113)+0.08&
               &*A(114)-A(116)+0.02*A(118)+0.02*A(121)+0.02*A(124)+A(130)+A(131)+0.742*A(132)+0.599*A(133)+0.606*A(134)&
               &+A(135)+A(136)+A(137)+A(138)+0.8*A(139)+0.65*A(140)+0.95*A(141)+0.95*A(142)+A(143)+0.77*A(146)+A(147)-A(149)&
               &-A(150)-A(151)-A(152)-A(153)-A(154)-A(155)-A(156)-A(157)-A(158)-A(159)-A(160)-A(161)-A(162)-A(163)-A(164)&
               &-A(165)-A(166)-A(167)-A(168)-A(169)+0.66*A(170)+A(171)+0.992*A(172)+0.946*A(173)+0.993*A(174)+A(175)+A(176)&
               &+A(177)+A(178)+2*A(179)+2*A(180)+A(181)+A(182)+2*A(183)+A(184)+A(186)+0.88*A(188)+A(189)+0.5*A(190)+0.5&
               &*A(191)+0.488*A(192)+0.438*A(193)+0.489*A(194)+0.5*A(195)+0.501*A(196)+0.51*A(197)+0.506*A(198)+A(199)&
               &+A(200)+A(201)+A(202)+A(203)+0.38*A(206)+0.5*A(207)+A(209)+0.5*A(210)+A(212)+A(213)+0.792*A(214)+0.699&
               &*A(215)+0.845*A(216)+A(217)+A(218)+A(219)+A(221)+A(222)+A(223)+A(224)+A(225)+0.77*A(228)+A(229)-A(231)&
               &+A(232)+A(237)+0.75*A(240)-A(241)+A(242)+0.22*A(250)
  Vdot(77) = A(16)+A(19)+A(22)+A(23)+A(76)+A(80)+0.65*A(86)+A(91)+A(93)+0.15*A(108)+0.1*A(109)+0.1*A(112)+0.28*A(113)&
               &+0.7*A(114)-A(126)+A(127)-A(144)+A(145)+0.23*A(146)-A(163)-A(164)-A(184)-A(185)+A(186)+0.12*A(188)-A(191)&
               &-A(192)-A(193)-A(194)-A(195)-A(196)-A(197)-A(198)-A(199)-A(200)-A(201)-A(202)-A(203)-2*A(204)-0.88*A(206)&
               &-A(207)-A(208)-A(226)+A(227)+0.23*A(228)-A(233)+0.25*A(240)
  Vdot(78) = A(4)+A(5)+0.35*A(6)+2*A(9)+A(13)+A(14)+A(15)+2*A(27)-A(28)+A(29)-A(30)-A(31)-A(37)-A(38)-A(39)+A(40)+0.7&
               &*A(43)-A(44)-A(45)-A(46)-A(55)-A(56)-A(57)-A(58)-A(59)-A(60)-A(61)-0.964*A(62)-A(63)-A(64)-A(65)-A(66)-A(67)&
               &-A(68)-A(69)-A(70)-A(71)-A(72)-A(73)-A(74)-A(75)-A(76)-A(77)-A(78)-A(79)-A(80)-A(81)-A(82)-A(83)-0.65*A(84)&
               &-0.51*A(85)-A(86)-A(87)-A(88)-A(89)-A(94)+0.12*A(105)+0.4*A(106)+0.63*A(107)+0.28*A(108)+0.25*A(109)+0.85&
               &*A(110)+0.85*A(111)+0.19*A(112)+0.21*A(113)+0.036*A(114)+A(119)+A(122)+A(125)-A(220)-A(239)-A(245)+0.63&
               &*A(246)-A(248)+0.63*A(250)
  Vdot(79) = 0.35*A(6)-A(7)-A(8)+A(36)-A(39)-A(43)+A(45)+A(48)-A(50)-A(51)-A(52)+A(53)-2*A(54)+A(87)+0.6*A(88)-A(90)&
               &-A(91)-A(92)-A(93)-A(95)-A(96)-A(97)-A(98)-A(99)-A(100)-A(101)-A(102)-A(103)-0.4*A(104)-A(212)-A(213)-A(214)&
               &-A(215)-A(216)-A(217)-A(218)-A(219)-A(221)-A(222)-A(223)-A(224)-A(225)-A(226)-A(227)-A(228)-A(229)-A(230)&
               &-A(236)-A(247)-A(249)
  Vdot(80) = A(77)+0.03*A(106)+0.12*A(107)+0.02*A(108)+0.42*A(110)+0.42*A(111)-A(146)-A(167)-A(188)-A(206)-A(228)+0.12&
               &*A(250)
  Vdot(81) = A(1)+A(4)+A(7)-A(34)+A(35)-A(37)-A(40)-A(47)-2*A(49)-A(50)+A(51)-A(130)-A(131)-A(132)-A(133)-A(134)-A(135)&
               &-A(136)-A(137)-A(138)-A(139)-A(140)-A(141)-A(142)-A(143)-A(144)-A(145)-A(146)-A(147)-A(148)-A(235)-A(240)
  Vdot(82) = -A(1)+A(5)+0.65*A(6)+A(8)+A(21)+A(34)-A(35)-A(36)-A(38)+A(39)+A(40)-A(41)+A(42)+0.7*A(43)+A(44)+A(46)+A(47)&
               &-A(48)+2*A(49)+2*A(50)-A(52)+A(53)+2*A(54)+A(58)+A(89)+0.5*A(95)+0.4*A(104)+0.7*A(114)-A(115)-A(117)-A(120)&
               &-A(123)-A(126)+A(127)-A(128)+A(129)+A(130)+A(131)+0.941*A(132)+0.876*A(133)+0.739*A(134)+A(135)+A(136)&
               &+A(137)+A(138)+0.8*A(139)+0.65*A(140)+0.95*A(141)+0.95*A(142)+A(143)+A(144)+A(145)+A(146)+A(147)+2*A(148)&
               &+0.5*A(190)+0.516*A(208)+0.5*A(210)+A(211)+A(212)+A(213)+A(214)+A(215)+A(216)+A(217)+A(218)+A(219)+A(220)&
               &+A(221)+A(222)+A(223)+A(224)+A(225)+A(226)+A(227)+A(228)+A(229)+2*A(230)+A(235)+A(236)+A(240)-A(243)+A(244)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE RACM_Function

