! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Stoichiometric Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : MOZART_T1_Stoichiom.f90
! Time                 : Wed Jan 27 13:13:50 2021
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_MOZART_T1_20754_BOXMOX
! Equation file        : MOZART_T1.kpp
! Output root filename : MOZART_T1
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE MOZART_T1_Stoichiom

  USE MOZART_T1_Parameters
  USE MOZART_T1_StoichiomSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ReactantProd - Reactant Products in each equation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      ARP       - Reactant product in each equation
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ReactantProd ( V, F, ARP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! ARP - Reactant product in each equation
  REAL(kind=dp) :: ARP(NREACT)


! Reactant Products in each equation are useful in the
!     stoichiometric formulation of mass action law
  ARP(1) = V(39)
  ARP(2) = F(3)
  ARP(3) = V(151)
  ARP(4) = V(151)
  ARP(5) = V(70)
  ARP(6) = V(45)
  ARP(7) = V(18)
  ARP(8) = V(29)
  ARP(9) = V(147)
  ARP(10) = V(150)
  ARP(11) = V(93)
  ARP(12) = V(94)
  ARP(13) = V(67)
  ARP(14) = V(26)
  ARP(15) = V(111)
  ARP(16) = V(69)
  ARP(17) = V(44)
  ARP(18) = V(91)
  ARP(19) = V(57)
  ARP(20) = V(50)
  ARP(21) = V(53)
  ARP(22) = V(56)
  ARP(23) = V(41)
  ARP(24) = V(146)
  ARP(25) = V(146)
  ARP(26) = V(129)
  ARP(27) = V(122)
  ARP(28) = V(138)
  ARP(29) = V(68)
  ARP(30) = V(47)
  ARP(31) = V(20)
  ARP(32) = V(124)
  ARP(33) = V(109)
  ARP(34) = V(113)
  ARP(35) = V(137)
  ARP(36) = V(37)
  ARP(37) = V(136)
  ARP(38) = V(62)
  ARP(39) = V(97)
  ARP(40) = V(143)
  ARP(41) = V(83)
  ARP(42) = V(78)
  ARP(43) = V(49)
  ARP(44) = V(84)
  ARP(45) = V(144)
  ARP(46) = V(110)
  ARP(47) = V(119)
  ARP(48) = V(52)
  ARP(49) = V(22)
  ARP(50) = V(71)
  ARP(51) = V(54)
  ARP(52) = V(74)
  ARP(53) = V(55)
  ARP(54) = V(32)
  ARP(55) = V(88)
  ARP(56) = V(80)
  ARP(57) = V(75)
  ARP(58) = V(133)
  ARP(59) = V(126)
  ARP(60) = V(89)
  ARP(61) = V(33)
  ARP(62) = V(98)
  ARP(63) = V(63)
  ARP(64) = V(87)*V(106)
  ARP(65) = V(82)*V(106)
  ARP(66) = V(106)*F(2)
  ARP(67) = V(106)*F(4)
  ARP(68) = V(106)*F(3)
  ARP(69) = V(106)*V(151)
  ARP(70) = V(135)*V(151)
  ARP(71) = V(135)*V(135)*F(1)
  ARP(72) = V(135)*F(1)*F(3)
  ARP(73) = V(82)*V(135)
  ARP(74) = V(39)*V(135)
  ARP(75) = V(135)*V(149)
  ARP(76) = V(149)*V(151)
  ARP(77) = V(82)*V(148)
  ARP(78) = V(39)*V(148)
  ARP(79) = V(148)*V(149)
  ARP(80) = V(135)*V(148)
  ARP(81) = V(148)*V(151)
  ARP(82) = V(148)*V(148)
  ARP(83) = V(148)*V(148)
  ARP(84) = V(149)*V(149)
  ARP(85) = V(45)*V(148)
  ARP(86) = V(135)*V(147)
  ARP(87) = V(147)*V(151)
  ARP(88) = V(135)*V(147)
  ARP(89) = V(149)*V(150)
  ARP(90) = V(150)*V(153)
  ARP(91) = V(135)*V(150)
  ARP(92) = V(148)*V(150)
  ARP(93) = V(149)*V(153)
  ARP(94) = V(151)*V(153)
  ARP(95) = V(135)*V(153)
  ARP(96) = V(18)*V(106)
  ARP(97) = V(18)*V(106)
  ARP(98) = V(147)*V(149)
  ARP(99) = V(147)*V(150)
  ARP(100) = V(147)*V(148)
  ARP(101) = V(70)*V(148)
  ARP(102) = V(45)*F(1)
  ARP(103) = V(29)*F(1)
  ARP(104) = V(146)*V(149)
  ARP(105) = V(146)*V(150)
  ARP(106) = V(135)*V(146)
  ARP(107) = V(146)*V(148)
  ARP(108) = V(155)*V(155)
  ARP(109) = V(155)*V(155)
  ARP(110) = V(149)*V(155)
  ARP(111) = V(153)*V(155)
  ARP(112) = V(107)*V(148)
  ARP(113) = V(47)*V(148)
  ARP(114) = V(87)*V(148)
  ARP(115) = V(28)*V(148)
  ARP(116) = V(103)*V(148)
  ARP(117) = V(65)*V(149)
  ARP(118) = V(65)
  ARP(119) = V(65)*V(153)
  ARP(120) = V(28)*V(106)
  ARP(121) = V(123)*V(148)
  ARP(122) = V(24)*V(148)
  ARP(123) = V(60)*V(151)
  ARP(124) = V(108)*V(108)
  ARP(125) = V(108)*V(155)
  ARP(126) = V(108)*V(149)
  ARP(127) = V(108)*V(153)
  ARP(128) = V(40)*V(148)
  ARP(129) = V(53)*V(148)
  ARP(130) = V(15)*V(148)
  ARP(131) = V(129)*V(150)
  ARP(132) = V(129)*V(148)
  ARP(133) = V(17)*V(148)
  ARP(134) = V(152)*V(152)
  ARP(135) = V(152)*V(155)
  ARP(136) = V(149)*V(152)
  ARP(137) = V(152)*V(153)
  ARP(138) = V(61)*V(148)
  ARP(139) = V(68)*V(148)
  ARP(140) = V(90)*V(149)
  ARP(141) = V(90)*V(153)
  ARP(142) = V(42)
  ARP(143) = V(42)*F(3)
  ARP(144) = V(124)*V(148)
  ARP(145) = V(109)*V(148)
  ARP(146) = V(71)*V(148)
  ARP(147) = V(60)*V(148)
  ARP(148) = V(147)*V(152)
  ARP(149) = V(71)*F(1)
  ARP(150) = V(128)*V(150)
  ARP(151) = V(128)*V(151)
  ARP(152) = V(105)*V(155)
  ARP(153) = V(105)*V(149)
  ARP(154) = V(105)*V(153)
  ARP(155) = V(56)*V(148)
  ARP(156) = V(16)*V(148)
  ARP(157) = V(138)*V(150)
  ARP(158) = V(138)*V(148)
  ARP(159) = V(136)*V(148)
  ARP(160) = V(119)*V(148)
  ARP(161) = V(96)*V(149)
  ARP(162) = V(96)*V(153)
  ARP(163) = V(74)*V(148)
  ARP(164) = V(134)*V(155)
  ARP(165) = V(134)*V(149)
  ARP(166) = V(134)*V(153)
  ARP(167) = V(55)*V(148)
  ARP(168) = V(128)*V(148)
  ARP(169) = V(122)*V(148)
  ARP(170) = V(59)*V(150)
  ARP(171) = V(59)*V(148)
  ARP(172) = V(86)*V(153)
  ARP(173) = V(86)*V(153)
  ARP(174) = V(137)*V(148)
  ARP(175) = V(145)*V(152)
  ARP(176) = V(145)*V(155)
  ARP(177) = V(145)*V(149)
  ARP(178) = V(145)*V(150)
  ARP(179) = V(145)*V(153)
  ARP(180) = V(145)*V(153)
  ARP(181) = V(143)*V(151)
  ARP(182) = V(143)*V(148)
  ARP(183) = V(48)*V(148)
  ARP(184) = V(152)*V(154)
  ARP(185) = V(154)*V(155)
  ARP(186) = V(149)*V(154)
  ARP(187) = V(154)*V(154)
  ARP(188) = V(153)*V(154)
  ARP(189) = V(150)*V(154)
  ARP(190) = V(95)*V(149)
  ARP(191) = V(95)*V(153)
  ARP(192) = V(78)*V(148)
  ARP(193) = V(49)*V(148)
  ARP(194) = V(84)*V(148)
  ARP(195) = V(144)*V(151)
  ARP(196) = V(144)*V(148)
  ARP(197) = V(147)*V(154)*F(1)
  ARP(198) = V(84)*F(1)
  ARP(199) = V(93)*V(148)
  ARP(200) = V(121)*V(149)
  ARP(201) = V(121)*V(153)
  ARP(202) = V(121)*V(153)
  ARP(203) = V(94)*V(148)
  ARP(204) = V(58)*V(148)
  ARP(205) = V(37)*V(148)
  ARP(206) = V(46)*V(148)
  ARP(207) = V(21)*V(148)
  ARP(208) = V(140)*V(152)
  ARP(209) = V(140)*V(155)
  ARP(210) = V(140)*V(149)
  ARP(211) = V(140)*V(153)
  ARP(212) = V(140)*V(150)
  ARP(213) = V(141)*V(152)
  ARP(214) = V(141)*V(155)
  ARP(215) = V(141)*V(149)
  ARP(216) = V(141)
  ARP(217) = V(141)*V(153)
  ARP(218) = V(141)*V(150)
  ARP(219) = V(85)*V(148)
  ARP(220) = V(72)*V(148)
  ARP(221) = V(114)*V(150)
  ARP(222) = V(142)*V(152)
  ARP(223) = V(142)*V(155)
  ARP(224) = V(142)*V(149)
  ARP(225) = V(142)*V(153)
  ARP(226) = V(142)*V(150)
  ARP(227) = V(62)*V(148)
  ARP(228) = V(114)*V(151)
  ARP(229) = V(114)*V(148)
  ARP(230) = V(97)*V(148)
  ARP(231) = V(51)*V(148)
  ARP(232) = V(110)*V(148)
  ARP(233) = V(139)*V(152)
  ARP(234) = V(139)*V(155)
  ARP(235) = V(139)*V(149)
  ARP(236) = V(139)*V(153)
  ARP(237) = V(139)*V(150)
  ARP(238) = V(33)*V(148)
  ARP(239) = V(79)*V(149)
  ARP(240) = V(79)*V(153)
  ARP(241) = V(113)*V(148)
  ARP(242) = V(104)*V(150)
  ARP(243) = V(112)*V(149)
  ARP(244) = V(112)*V(153)
  ARP(245) = V(112)*V(150)
  ARP(246) = V(125)*V(155)
  ARP(247) = V(125)*V(149)
  ARP(248) = V(125)*V(153)
  ARP(249) = V(104)*V(151)
  ARP(250) = V(104)*V(148)
  ARP(251) = V(83)*V(148)
  ARP(252) = V(81)*V(149)
  ARP(253) = V(81)*V(153)
  ARP(254) = V(43)*V(149)
  ARP(255) = V(43)*V(153)
  ARP(256) = V(25)*V(148)
  ARP(257) = V(76)*V(149)
  ARP(258) = V(76)*V(153)
  ARP(259) = V(67)*V(148)
  ARP(260) = V(38)*V(148)
  ARP(261) = V(64)*V(149)
  ARP(262) = V(50)*V(148)
  ARP(263) = V(64)*V(153)
  ARP(264) = V(92)*V(149)
  ARP(265) = V(92)*V(153)
  ARP(266) = V(41)*V(148)
  ARP(267) = V(31)*V(148)
  ARP(268) = V(102)*V(149)
  ARP(269) = V(102)*V(153)
  ARP(270) = V(102)*V(147)
  ARP(271) = V(100)*V(149)
  ARP(272) = V(100)*V(153)
  ARP(273) = V(100)*V(147)
  ARP(274) = V(130)*V(149)
  ARP(275) = V(130)*V(153)
  ARP(276) = V(130)*V(147)
  ARP(277) = V(66)*V(149)
  ARP(278) = V(66)*V(153)
  ARP(279) = V(27)*V(148)
  ARP(280) = V(73)*V(147)
  ARP(281) = V(73)*V(151)
  ARP(282) = V(54)*V(148)
  ARP(283) = V(81)*V(147)
  ARP(284) = V(99)*V(149)
  ARP(285) = V(99)*V(153)
  ARP(286) = V(89)*V(148)
  ARP(287) = V(30)*V(148)
  ARP(288) = V(23)*F(1)
  ARP(289) = V(34)*V(148)
  ARP(290) = V(101)*V(149)
  ARP(291) = V(101)*V(153)
  ARP(292) = V(98)*V(148)
  ARP(293) = V(77)*V(149)
  ARP(294) = V(77)*V(153)
  ARP(295) = V(35)*V(148)
  ARP(296) = V(63)*V(148)
  ARP(297) = V(116)*V(150)
  ARP(298) = V(116)*V(151)
  ARP(299) = V(116)*V(148)
  ARP(300) = V(117)*V(150)
  ARP(301) = V(117)*V(151)
  ARP(302) = V(117)*V(148)
  ARP(303) = V(118)*V(150)
  ARP(304) = V(118)*V(151)
  ARP(305) = V(118)*V(148)
  ARP(306) = V(115)*V(150)
  ARP(307) = V(115)*V(151)
  ARP(308) = V(115)*V(148)
  ARP(309) = V(120)*V(150)
  ARP(310) = V(120)*V(151)
  ARP(311) = V(120)*V(148)
  ARP(312) = V(132)*V(155)
  ARP(313) = V(132)*V(149)
  ARP(314) = V(132)*V(153)
  ARP(315) = V(132)*V(150)
  ARP(316) = V(52)*V(148)
  ARP(317) = V(127)*V(155)
  ARP(318) = V(127)*V(149)
  ARP(319) = V(127)*V(153)
  ARP(320) = V(88)*V(148)
  ARP(321) = V(80)*V(148)
  ARP(322) = V(131)*V(155)
  ARP(323) = V(131)*V(149)
  ARP(324) = V(131)*V(153)
  ARP(325) = V(75)*V(148)
  ARP(326) = V(133)*V(150)
  ARP(327) = V(133)*V(148)
  ARP(328) = V(126)*V(148)
  ARP(329) = V(36)*V(150)
  ARP(330) = V(36)*V(148)
  ARP(331) = V(14)*V(148)
  ARP(332) = V(36)*V(148)
  ARP(333) = V(149)
  ARP(334) = V(29)
  ARP(335) = V(147)
  ARP(336) = V(150)
  ARP(337) = V(19)*V(148)
  ARP(338) = V(116)*V(150)
  ARP(339) = V(116)*V(151)
  ARP(340) = V(116)*V(148)
  ARP(341) = V(117)*V(150)
  ARP(342) = V(117)*V(151)
  ARP(343) = V(117)*V(148)
  ARP(344) = V(25)*V(148)
  ARP(345) = V(118)*V(150)
  ARP(346) = V(118)*V(151)
  ARP(347) = V(118)*V(148)
  ARP(348) = V(114)*V(150)
  ARP(349) = V(114)*V(151)
  ARP(350) = V(114)*V(148)
  ARP(351) = V(8)*V(148)
  ARP(352) = V(115)*V(150)
  ARP(353) = V(115)*V(151)
  ARP(354) = V(115)*V(148)
  ARP(355) = V(120)*V(150)
  ARP(356) = V(120)*V(151)
  ARP(357) = V(120)*V(148)
  ARP(358) = V(9)*V(148)
  ARP(359) = V(30)*V(148)
  ARP(360) = V(34)*V(148)
      
END SUBROUTINE ReactantProd

! End of ReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacReactantProd - Jacobian of Reactant Products vector
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      JVRP      - d ARP(1:NREACT)/d VAR (1:NVAR)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacReactantProd ( V, F, JVRP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! JVRP - d ARP(1:NREACT)/d VAR (1:NVAR)
  REAL(kind=dp) :: JVRP(NJVRP)


! Reactant Products in each equation are useful in the
!    stoichiometric formulation of mass action law
! Below we compute the Jacobian of the Reactant Products vector
!    w.r.t. variable species: d ARP(1:NREACT) / d Var(1:NVAR)

! JVRP(1) = dARP(1)/dV(39)
  JVRP(1) = 1
! JVRP(2) = dARP(3)/dV(151)
  JVRP(2) = 1
! JVRP(3) = dARP(4)/dV(151)
  JVRP(3) = 1
! JVRP(4) = dARP(5)/dV(70)
  JVRP(4) = 1
! JVRP(5) = dARP(6)/dV(45)
  JVRP(5) = 1
! JVRP(6) = dARP(7)/dV(18)
  JVRP(6) = 1
! JVRP(7) = dARP(8)/dV(29)
  JVRP(7) = 1
! JVRP(8) = dARP(9)/dV(147)
  JVRP(8) = 1
! JVRP(9) = dARP(10)/dV(150)
  JVRP(9) = 1
! JVRP(10) = dARP(11)/dV(93)
  JVRP(10) = 1
! JVRP(11) = dARP(12)/dV(94)
  JVRP(11) = 1
! JVRP(12) = dARP(13)/dV(67)
  JVRP(12) = 1
! JVRP(13) = dARP(14)/dV(26)
  JVRP(13) = 1
! JVRP(14) = dARP(15)/dV(111)
  JVRP(14) = 1
! JVRP(15) = dARP(16)/dV(69)
  JVRP(15) = 1
! JVRP(16) = dARP(17)/dV(44)
  JVRP(16) = 1
! JVRP(17) = dARP(18)/dV(91)
  JVRP(17) = 1
! JVRP(18) = dARP(19)/dV(57)
  JVRP(18) = 1
! JVRP(19) = dARP(20)/dV(50)
  JVRP(19) = 1
! JVRP(20) = dARP(21)/dV(53)
  JVRP(20) = 1
! JVRP(21) = dARP(22)/dV(56)
  JVRP(21) = 1
! JVRP(22) = dARP(23)/dV(41)
  JVRP(22) = 1
! JVRP(23) = dARP(24)/dV(146)
  JVRP(23) = 1
! JVRP(24) = dARP(25)/dV(146)
  JVRP(24) = 1
! JVRP(25) = dARP(26)/dV(129)
  JVRP(25) = 1
! JVRP(26) = dARP(27)/dV(122)
  JVRP(26) = 1
! JVRP(27) = dARP(28)/dV(138)
  JVRP(27) = 1
! JVRP(28) = dARP(29)/dV(68)
  JVRP(28) = 1
! JVRP(29) = dARP(30)/dV(47)
  JVRP(29) = 1
! JVRP(30) = dARP(31)/dV(20)
  JVRP(30) = 1
! JVRP(31) = dARP(32)/dV(124)
  JVRP(31) = 1
! JVRP(32) = dARP(33)/dV(109)
  JVRP(32) = 1
! JVRP(33) = dARP(34)/dV(113)
  JVRP(33) = 1
! JVRP(34) = dARP(35)/dV(137)
  JVRP(34) = 1
! JVRP(35) = dARP(36)/dV(37)
  JVRP(35) = 1
! JVRP(36) = dARP(37)/dV(136)
  JVRP(36) = 1
! JVRP(37) = dARP(38)/dV(62)
  JVRP(37) = 1
! JVRP(38) = dARP(39)/dV(97)
  JVRP(38) = 1
! JVRP(39) = dARP(40)/dV(143)
  JVRP(39) = 1
! JVRP(40) = dARP(41)/dV(83)
  JVRP(40) = 1
! JVRP(41) = dARP(42)/dV(78)
  JVRP(41) = 1
! JVRP(42) = dARP(43)/dV(49)
  JVRP(42) = 1
! JVRP(43) = dARP(44)/dV(84)
  JVRP(43) = 1
! JVRP(44) = dARP(45)/dV(144)
  JVRP(44) = 1
! JVRP(45) = dARP(46)/dV(110)
  JVRP(45) = 1
! JVRP(46) = dARP(47)/dV(119)
  JVRP(46) = 1
! JVRP(47) = dARP(48)/dV(52)
  JVRP(47) = 1
! JVRP(48) = dARP(49)/dV(22)
  JVRP(48) = 1
! JVRP(49) = dARP(50)/dV(71)
  JVRP(49) = 1
! JVRP(50) = dARP(51)/dV(54)
  JVRP(50) = 1
! JVRP(51) = dARP(52)/dV(74)
  JVRP(51) = 1
! JVRP(52) = dARP(53)/dV(55)
  JVRP(52) = 1
! JVRP(53) = dARP(54)/dV(32)
  JVRP(53) = 1
! JVRP(54) = dARP(55)/dV(88)
  JVRP(54) = 1
! JVRP(55) = dARP(56)/dV(80)
  JVRP(55) = 1
! JVRP(56) = dARP(57)/dV(75)
  JVRP(56) = 1
! JVRP(57) = dARP(58)/dV(133)
  JVRP(57) = 1
! JVRP(58) = dARP(59)/dV(126)
  JVRP(58) = 1
! JVRP(59) = dARP(60)/dV(89)
  JVRP(59) = 1
! JVRP(60) = dARP(61)/dV(33)
  JVRP(60) = 1
! JVRP(61) = dARP(62)/dV(98)
  JVRP(61) = 1
! JVRP(62) = dARP(63)/dV(63)
  JVRP(62) = 1
! JVRP(63) = dARP(64)/dV(87)
  JVRP(63) = V(106)
! JVRP(64) = dARP(64)/dV(106)
  JVRP(64) = V(87)
! JVRP(65) = dARP(65)/dV(82)
  JVRP(65) = V(106)
! JVRP(66) = dARP(65)/dV(106)
  JVRP(66) = V(82)
! JVRP(67) = dARP(66)/dV(106)
  JVRP(67) = F(2)
! JVRP(68) = dARP(67)/dV(106)
  JVRP(68) = F(4)
! JVRP(69) = dARP(68)/dV(106)
  JVRP(69) = F(3)
! JVRP(70) = dARP(69)/dV(106)
  JVRP(70) = V(151)
! JVRP(71) = dARP(69)/dV(151)
  JVRP(71) = V(106)
! JVRP(72) = dARP(70)/dV(135)
  JVRP(72) = V(151)
! JVRP(73) = dARP(70)/dV(151)
  JVRP(73) = V(135)
! JVRP(74) = dARP(71)/dV(135)
  JVRP(74) = 2*V(135)*F(1)
! JVRP(75) = dARP(72)/dV(135)
  JVRP(75) = F(1)*F(3)
! JVRP(76) = dARP(73)/dV(82)
  JVRP(76) = V(135)
! JVRP(77) = dARP(73)/dV(135)
  JVRP(77) = V(82)
! JVRP(78) = dARP(74)/dV(39)
  JVRP(78) = V(135)
! JVRP(79) = dARP(74)/dV(135)
  JVRP(79) = V(39)
! JVRP(80) = dARP(75)/dV(135)
  JVRP(80) = V(149)
! JVRP(81) = dARP(75)/dV(149)
  JVRP(81) = V(135)
! JVRP(82) = dARP(76)/dV(149)
  JVRP(82) = V(151)
! JVRP(83) = dARP(76)/dV(151)
  JVRP(83) = V(149)
! JVRP(84) = dARP(77)/dV(82)
  JVRP(84) = V(148)
! JVRP(85) = dARP(77)/dV(148)
  JVRP(85) = V(82)
! JVRP(86) = dARP(78)/dV(39)
  JVRP(86) = V(148)
! JVRP(87) = dARP(78)/dV(148)
  JVRP(87) = V(39)
! JVRP(88) = dARP(79)/dV(148)
  JVRP(88) = V(149)
! JVRP(89) = dARP(79)/dV(149)
  JVRP(89) = V(148)
! JVRP(90) = dARP(80)/dV(135)
  JVRP(90) = V(148)
! JVRP(91) = dARP(80)/dV(148)
  JVRP(91) = V(135)
! JVRP(92) = dARP(81)/dV(148)
  JVRP(92) = V(151)
! JVRP(93) = dARP(81)/dV(151)
  JVRP(93) = V(148)
! JVRP(94) = dARP(82)/dV(148)
  JVRP(94) = 2*V(148)
! JVRP(95) = dARP(83)/dV(148)
  JVRP(95) = 2*V(148)
! JVRP(96) = dARP(84)/dV(149)
  JVRP(96) = 2*V(149)
! JVRP(97) = dARP(85)/dV(45)
  JVRP(97) = V(148)
! JVRP(98) = dARP(85)/dV(148)
  JVRP(98) = V(45)
! JVRP(99) = dARP(86)/dV(135)
  JVRP(99) = V(147)
! JVRP(100) = dARP(86)/dV(147)
  JVRP(100) = V(135)
! JVRP(101) = dARP(87)/dV(147)
  JVRP(101) = V(151)
! JVRP(102) = dARP(87)/dV(151)
  JVRP(102) = V(147)
! JVRP(103) = dARP(88)/dV(135)
  JVRP(103) = V(147)
! JVRP(104) = dARP(88)/dV(147)
  JVRP(104) = V(135)
! JVRP(105) = dARP(89)/dV(149)
  JVRP(105) = V(150)
! JVRP(106) = dARP(89)/dV(150)
  JVRP(106) = V(149)
! JVRP(107) = dARP(90)/dV(150)
  JVRP(107) = V(153)
! JVRP(108) = dARP(90)/dV(153)
  JVRP(108) = V(150)
! JVRP(109) = dARP(91)/dV(135)
  JVRP(109) = V(150)
! JVRP(110) = dARP(91)/dV(150)
  JVRP(110) = V(135)
! JVRP(111) = dARP(92)/dV(148)
  JVRP(111) = V(150)
! JVRP(112) = dARP(92)/dV(150)
  JVRP(112) = V(148)
! JVRP(113) = dARP(93)/dV(149)
  JVRP(113) = V(153)
! JVRP(114) = dARP(93)/dV(153)
  JVRP(114) = V(149)
! JVRP(115) = dARP(94)/dV(151)
  JVRP(115) = V(153)
! JVRP(116) = dARP(94)/dV(153)
  JVRP(116) = V(151)
! JVRP(117) = dARP(95)/dV(135)
  JVRP(117) = V(153)
! JVRP(118) = dARP(95)/dV(153)
  JVRP(118) = V(135)
! JVRP(119) = dARP(96)/dV(18)
  JVRP(119) = V(106)
! JVRP(120) = dARP(96)/dV(106)
  JVRP(120) = V(18)
! JVRP(121) = dARP(97)/dV(18)
  JVRP(121) = V(106)
! JVRP(122) = dARP(97)/dV(106)
  JVRP(122) = V(18)
! JVRP(123) = dARP(98)/dV(147)
  JVRP(123) = V(149)
! JVRP(124) = dARP(98)/dV(149)
  JVRP(124) = V(147)
! JVRP(125) = dARP(99)/dV(147)
  JVRP(125) = V(150)
! JVRP(126) = dARP(99)/dV(150)
  JVRP(126) = V(147)
! JVRP(127) = dARP(100)/dV(147)
  JVRP(127) = V(148)
! JVRP(128) = dARP(100)/dV(148)
  JVRP(128) = V(147)
! JVRP(129) = dARP(101)/dV(70)
  JVRP(129) = V(148)
! JVRP(130) = dARP(101)/dV(148)
  JVRP(130) = V(70)
! JVRP(131) = dARP(102)/dV(45)
  JVRP(131) = F(1)
! JVRP(132) = dARP(103)/dV(29)
  JVRP(132) = F(1)
! JVRP(133) = dARP(104)/dV(146)
  JVRP(133) = V(149)
! JVRP(134) = dARP(104)/dV(149)
  JVRP(134) = V(146)
! JVRP(135) = dARP(105)/dV(146)
  JVRP(135) = V(150)
! JVRP(136) = dARP(105)/dV(150)
  JVRP(136) = V(146)
! JVRP(137) = dARP(106)/dV(135)
  JVRP(137) = V(146)
! JVRP(138) = dARP(106)/dV(146)
  JVRP(138) = V(135)
! JVRP(139) = dARP(107)/dV(146)
  JVRP(139) = V(148)
! JVRP(140) = dARP(107)/dV(148)
  JVRP(140) = V(146)
! JVRP(141) = dARP(108)/dV(155)
  JVRP(141) = 2*V(155)
! JVRP(142) = dARP(109)/dV(155)
  JVRP(142) = 2*V(155)
! JVRP(143) = dARP(110)/dV(149)
  JVRP(143) = V(155)
! JVRP(144) = dARP(110)/dV(155)
  JVRP(144) = V(149)
! JVRP(145) = dARP(111)/dV(153)
  JVRP(145) = V(155)
! JVRP(146) = dARP(111)/dV(155)
  JVRP(146) = V(153)
! JVRP(147) = dARP(112)/dV(107)
  JVRP(147) = V(148)
! JVRP(148) = dARP(112)/dV(148)
  JVRP(148) = V(107)
! JVRP(149) = dARP(113)/dV(47)
  JVRP(149) = V(148)
! JVRP(150) = dARP(113)/dV(148)
  JVRP(150) = V(47)
! JVRP(151) = dARP(114)/dV(87)
  JVRP(151) = V(148)
! JVRP(152) = dARP(114)/dV(148)
  JVRP(152) = V(87)
! JVRP(153) = dARP(115)/dV(28)
  JVRP(153) = V(148)
! JVRP(154) = dARP(115)/dV(148)
  JVRP(154) = V(28)
! JVRP(155) = dARP(116)/dV(103)
  JVRP(155) = V(148)
! JVRP(156) = dARP(116)/dV(148)
  JVRP(156) = V(103)
! JVRP(157) = dARP(117)/dV(65)
  JVRP(157) = V(149)
! JVRP(158) = dARP(117)/dV(149)
  JVRP(158) = V(65)
! JVRP(159) = dARP(118)/dV(65)
  JVRP(159) = 1
! JVRP(160) = dARP(119)/dV(65)
  JVRP(160) = V(153)
! JVRP(161) = dARP(119)/dV(153)
  JVRP(161) = V(65)
! JVRP(162) = dARP(120)/dV(28)
  JVRP(162) = V(106)
! JVRP(163) = dARP(120)/dV(106)
  JVRP(163) = V(28)
! JVRP(164) = dARP(121)/dV(123)
  JVRP(164) = V(148)
! JVRP(165) = dARP(121)/dV(148)
  JVRP(165) = V(123)
! JVRP(166) = dARP(122)/dV(24)
  JVRP(166) = V(148)
! JVRP(167) = dARP(122)/dV(148)
  JVRP(167) = V(24)
! JVRP(168) = dARP(123)/dV(60)
  JVRP(168) = V(151)
! JVRP(169) = dARP(123)/dV(151)
  JVRP(169) = V(60)
! JVRP(170) = dARP(124)/dV(108)
  JVRP(170) = 2*V(108)
! JVRP(171) = dARP(125)/dV(108)
  JVRP(171) = V(155)
! JVRP(172) = dARP(125)/dV(155)
  JVRP(172) = V(108)
! JVRP(173) = dARP(126)/dV(108)
  JVRP(173) = V(149)
! JVRP(174) = dARP(126)/dV(149)
  JVRP(174) = V(108)
! JVRP(175) = dARP(127)/dV(108)
  JVRP(175) = V(153)
! JVRP(176) = dARP(127)/dV(153)
  JVRP(176) = V(108)
! JVRP(177) = dARP(128)/dV(40)
  JVRP(177) = V(148)
! JVRP(178) = dARP(128)/dV(148)
  JVRP(178) = V(40)
! JVRP(179) = dARP(129)/dV(53)
  JVRP(179) = V(148)
! JVRP(180) = dARP(129)/dV(148)
  JVRP(180) = V(53)
! JVRP(181) = dARP(130)/dV(15)
  JVRP(181) = V(148)
! JVRP(182) = dARP(130)/dV(148)
  JVRP(182) = V(15)
! JVRP(183) = dARP(131)/dV(129)
  JVRP(183) = V(150)
! JVRP(184) = dARP(131)/dV(150)
  JVRP(184) = V(129)
! JVRP(185) = dARP(132)/dV(129)
  JVRP(185) = V(148)
! JVRP(186) = dARP(132)/dV(148)
  JVRP(186) = V(129)
! JVRP(187) = dARP(133)/dV(17)
  JVRP(187) = V(148)
! JVRP(188) = dARP(133)/dV(148)
  JVRP(188) = V(17)
! JVRP(189) = dARP(134)/dV(152)
  JVRP(189) = 2*V(152)
! JVRP(190) = dARP(135)/dV(152)
  JVRP(190) = V(155)
! JVRP(191) = dARP(135)/dV(155)
  JVRP(191) = V(152)
! JVRP(192) = dARP(136)/dV(149)
  JVRP(192) = V(152)
! JVRP(193) = dARP(136)/dV(152)
  JVRP(193) = V(149)
! JVRP(194) = dARP(137)/dV(152)
  JVRP(194) = V(153)
! JVRP(195) = dARP(137)/dV(153)
  JVRP(195) = V(152)
! JVRP(196) = dARP(138)/dV(61)
  JVRP(196) = V(148)
! JVRP(197) = dARP(138)/dV(148)
  JVRP(197) = V(61)
! JVRP(198) = dARP(139)/dV(68)
  JVRP(198) = V(148)
! JVRP(199) = dARP(139)/dV(148)
  JVRP(199) = V(68)
! JVRP(200) = dARP(140)/dV(90)
  JVRP(200) = V(149)
! JVRP(201) = dARP(140)/dV(149)
  JVRP(201) = V(90)
! JVRP(202) = dARP(141)/dV(90)
  JVRP(202) = V(153)
! JVRP(203) = dARP(141)/dV(153)
  JVRP(203) = V(90)
! JVRP(204) = dARP(142)/dV(42)
  JVRP(204) = 1
! JVRP(205) = dARP(143)/dV(42)
  JVRP(205) = F(3)
! JVRP(206) = dARP(144)/dV(124)
  JVRP(206) = V(148)
! JVRP(207) = dARP(144)/dV(148)
  JVRP(207) = V(124)
! JVRP(208) = dARP(145)/dV(109)
  JVRP(208) = V(148)
! JVRP(209) = dARP(145)/dV(148)
  JVRP(209) = V(109)
! JVRP(210) = dARP(146)/dV(71)
  JVRP(210) = V(148)
! JVRP(211) = dARP(146)/dV(148)
  JVRP(211) = V(71)
! JVRP(212) = dARP(147)/dV(60)
  JVRP(212) = V(148)
! JVRP(213) = dARP(147)/dV(148)
  JVRP(213) = V(60)
! JVRP(214) = dARP(148)/dV(147)
  JVRP(214) = V(152)
! JVRP(215) = dARP(148)/dV(152)
  JVRP(215) = V(147)
! JVRP(216) = dARP(149)/dV(71)
  JVRP(216) = F(1)
! JVRP(217) = dARP(150)/dV(128)
  JVRP(217) = V(150)
! JVRP(218) = dARP(150)/dV(150)
  JVRP(218) = V(128)
! JVRP(219) = dARP(151)/dV(128)
  JVRP(219) = V(151)
! JVRP(220) = dARP(151)/dV(151)
  JVRP(220) = V(128)
! JVRP(221) = dARP(152)/dV(105)
  JVRP(221) = V(155)
! JVRP(222) = dARP(152)/dV(155)
  JVRP(222) = V(105)
! JVRP(223) = dARP(153)/dV(105)
  JVRP(223) = V(149)
! JVRP(224) = dARP(153)/dV(149)
  JVRP(224) = V(105)
! JVRP(225) = dARP(154)/dV(105)
  JVRP(225) = V(153)
! JVRP(226) = dARP(154)/dV(153)
  JVRP(226) = V(105)
! JVRP(227) = dARP(155)/dV(56)
  JVRP(227) = V(148)
! JVRP(228) = dARP(155)/dV(148)
  JVRP(228) = V(56)
! JVRP(229) = dARP(156)/dV(16)
  JVRP(229) = V(148)
! JVRP(230) = dARP(156)/dV(148)
  JVRP(230) = V(16)
! JVRP(231) = dARP(157)/dV(138)
  JVRP(231) = V(150)
! JVRP(232) = dARP(157)/dV(150)
  JVRP(232) = V(138)
! JVRP(233) = dARP(158)/dV(138)
  JVRP(233) = V(148)
! JVRP(234) = dARP(158)/dV(148)
  JVRP(234) = V(138)
! JVRP(235) = dARP(159)/dV(136)
  JVRP(235) = V(148)
! JVRP(236) = dARP(159)/dV(148)
  JVRP(236) = V(136)
! JVRP(237) = dARP(160)/dV(119)
  JVRP(237) = V(148)
! JVRP(238) = dARP(160)/dV(148)
  JVRP(238) = V(119)
! JVRP(239) = dARP(161)/dV(96)
  JVRP(239) = V(149)
! JVRP(240) = dARP(161)/dV(149)
  JVRP(240) = V(96)
! JVRP(241) = dARP(162)/dV(96)
  JVRP(241) = V(153)
! JVRP(242) = dARP(162)/dV(153)
  JVRP(242) = V(96)
! JVRP(243) = dARP(163)/dV(74)
  JVRP(243) = V(148)
! JVRP(244) = dARP(163)/dV(148)
  JVRP(244) = V(74)
! JVRP(245) = dARP(164)/dV(134)
  JVRP(245) = V(155)
! JVRP(246) = dARP(164)/dV(155)
  JVRP(246) = V(134)
! JVRP(247) = dARP(165)/dV(134)
  JVRP(247) = V(149)
! JVRP(248) = dARP(165)/dV(149)
  JVRP(248) = V(134)
! JVRP(249) = dARP(166)/dV(134)
  JVRP(249) = V(153)
! JVRP(250) = dARP(166)/dV(153)
  JVRP(250) = V(134)
! JVRP(251) = dARP(167)/dV(55)
  JVRP(251) = V(148)
! JVRP(252) = dARP(167)/dV(148)
  JVRP(252) = V(55)
! JVRP(253) = dARP(168)/dV(128)
  JVRP(253) = V(148)
! JVRP(254) = dARP(168)/dV(148)
  JVRP(254) = V(128)
! JVRP(255) = dARP(169)/dV(122)
  JVRP(255) = V(148)
! JVRP(256) = dARP(169)/dV(148)
  JVRP(256) = V(122)
! JVRP(257) = dARP(170)/dV(59)
  JVRP(257) = V(150)
! JVRP(258) = dARP(170)/dV(150)
  JVRP(258) = V(59)
! JVRP(259) = dARP(171)/dV(59)
  JVRP(259) = V(148)
! JVRP(260) = dARP(171)/dV(148)
  JVRP(260) = V(59)
! JVRP(261) = dARP(172)/dV(86)
  JVRP(261) = V(153)
! JVRP(262) = dARP(172)/dV(153)
  JVRP(262) = V(86)
! JVRP(263) = dARP(173)/dV(86)
  JVRP(263) = V(153)
! JVRP(264) = dARP(173)/dV(153)
  JVRP(264) = V(86)
! JVRP(265) = dARP(174)/dV(137)
  JVRP(265) = V(148)
! JVRP(266) = dARP(174)/dV(148)
  JVRP(266) = V(137)
! JVRP(267) = dARP(175)/dV(145)
  JVRP(267) = V(152)
! JVRP(268) = dARP(175)/dV(152)
  JVRP(268) = V(145)
! JVRP(269) = dARP(176)/dV(145)
  JVRP(269) = V(155)
! JVRP(270) = dARP(176)/dV(155)
  JVRP(270) = V(145)
! JVRP(271) = dARP(177)/dV(145)
  JVRP(271) = V(149)
! JVRP(272) = dARP(177)/dV(149)
  JVRP(272) = V(145)
! JVRP(273) = dARP(178)/dV(145)
  JVRP(273) = V(150)
! JVRP(274) = dARP(178)/dV(150)
  JVRP(274) = V(145)
! JVRP(275) = dARP(179)/dV(145)
  JVRP(275) = V(153)
! JVRP(276) = dARP(179)/dV(153)
  JVRP(276) = V(145)
! JVRP(277) = dARP(180)/dV(145)
  JVRP(277) = V(153)
! JVRP(278) = dARP(180)/dV(153)
  JVRP(278) = V(145)
! JVRP(279) = dARP(181)/dV(143)
  JVRP(279) = V(151)
! JVRP(280) = dARP(181)/dV(151)
  JVRP(280) = V(143)
! JVRP(281) = dARP(182)/dV(143)
  JVRP(281) = V(148)
! JVRP(282) = dARP(182)/dV(148)
  JVRP(282) = V(143)
! JVRP(283) = dARP(183)/dV(48)
  JVRP(283) = V(148)
! JVRP(284) = dARP(183)/dV(148)
  JVRP(284) = V(48)
! JVRP(285) = dARP(184)/dV(152)
  JVRP(285) = V(154)
! JVRP(286) = dARP(184)/dV(154)
  JVRP(286) = V(152)
! JVRP(287) = dARP(185)/dV(154)
  JVRP(287) = V(155)
! JVRP(288) = dARP(185)/dV(155)
  JVRP(288) = V(154)
! JVRP(289) = dARP(186)/dV(149)
  JVRP(289) = V(154)
! JVRP(290) = dARP(186)/dV(154)
  JVRP(290) = V(149)
! JVRP(291) = dARP(187)/dV(154)
  JVRP(291) = 2*V(154)
! JVRP(292) = dARP(188)/dV(153)
  JVRP(292) = V(154)
! JVRP(293) = dARP(188)/dV(154)
  JVRP(293) = V(153)
! JVRP(294) = dARP(189)/dV(150)
  JVRP(294) = V(154)
! JVRP(295) = dARP(189)/dV(154)
  JVRP(295) = V(150)
! JVRP(296) = dARP(190)/dV(95)
  JVRP(296) = V(149)
! JVRP(297) = dARP(190)/dV(149)
  JVRP(297) = V(95)
! JVRP(298) = dARP(191)/dV(95)
  JVRP(298) = V(153)
! JVRP(299) = dARP(191)/dV(153)
  JVRP(299) = V(95)
! JVRP(300) = dARP(192)/dV(78)
  JVRP(300) = V(148)
! JVRP(301) = dARP(192)/dV(148)
  JVRP(301) = V(78)
! JVRP(302) = dARP(193)/dV(49)
  JVRP(302) = V(148)
! JVRP(303) = dARP(193)/dV(148)
  JVRP(303) = V(49)
! JVRP(304) = dARP(194)/dV(84)
  JVRP(304) = V(148)
! JVRP(305) = dARP(194)/dV(148)
  JVRP(305) = V(84)
! JVRP(306) = dARP(195)/dV(144)
  JVRP(306) = V(151)
! JVRP(307) = dARP(195)/dV(151)
  JVRP(307) = V(144)
! JVRP(308) = dARP(196)/dV(144)
  JVRP(308) = V(148)
! JVRP(309) = dARP(196)/dV(148)
  JVRP(309) = V(144)
! JVRP(310) = dARP(197)/dV(147)
  JVRP(310) = V(154)*F(1)
! JVRP(311) = dARP(197)/dV(154)
  JVRP(311) = V(147)*F(1)
! JVRP(312) = dARP(198)/dV(84)
  JVRP(312) = F(1)
! JVRP(313) = dARP(199)/dV(93)
  JVRP(313) = V(148)
! JVRP(314) = dARP(199)/dV(148)
  JVRP(314) = V(93)
! JVRP(315) = dARP(200)/dV(121)
  JVRP(315) = V(149)
! JVRP(316) = dARP(200)/dV(149)
  JVRP(316) = V(121)
! JVRP(317) = dARP(201)/dV(121)
  JVRP(317) = V(153)
! JVRP(318) = dARP(201)/dV(153)
  JVRP(318) = V(121)
! JVRP(319) = dARP(202)/dV(121)
  JVRP(319) = V(153)
! JVRP(320) = dARP(202)/dV(153)
  JVRP(320) = V(121)
! JVRP(321) = dARP(203)/dV(94)
  JVRP(321) = V(148)
! JVRP(322) = dARP(203)/dV(148)
  JVRP(322) = V(94)
! JVRP(323) = dARP(204)/dV(58)
  JVRP(323) = V(148)
! JVRP(324) = dARP(204)/dV(148)
  JVRP(324) = V(58)
! JVRP(325) = dARP(205)/dV(37)
  JVRP(325) = V(148)
! JVRP(326) = dARP(205)/dV(148)
  JVRP(326) = V(37)
! JVRP(327) = dARP(206)/dV(46)
  JVRP(327) = V(148)
! JVRP(328) = dARP(206)/dV(148)
  JVRP(328) = V(46)
! JVRP(329) = dARP(207)/dV(21)
  JVRP(329) = V(148)
! JVRP(330) = dARP(207)/dV(148)
  JVRP(330) = V(21)
! JVRP(331) = dARP(208)/dV(140)
  JVRP(331) = V(152)
! JVRP(332) = dARP(208)/dV(152)
  JVRP(332) = V(140)
! JVRP(333) = dARP(209)/dV(140)
  JVRP(333) = V(155)
! JVRP(334) = dARP(209)/dV(155)
  JVRP(334) = V(140)
! JVRP(335) = dARP(210)/dV(140)
  JVRP(335) = V(149)
! JVRP(336) = dARP(210)/dV(149)
  JVRP(336) = V(140)
! JVRP(337) = dARP(211)/dV(140)
  JVRP(337) = V(153)
! JVRP(338) = dARP(211)/dV(153)
  JVRP(338) = V(140)
! JVRP(339) = dARP(212)/dV(140)
  JVRP(339) = V(150)
! JVRP(340) = dARP(212)/dV(150)
  JVRP(340) = V(140)
! JVRP(341) = dARP(213)/dV(141)
  JVRP(341) = V(152)
! JVRP(342) = dARP(213)/dV(152)
  JVRP(342) = V(141)
! JVRP(343) = dARP(214)/dV(141)
  JVRP(343) = V(155)
! JVRP(344) = dARP(214)/dV(155)
  JVRP(344) = V(141)
! JVRP(345) = dARP(215)/dV(141)
  JVRP(345) = V(149)
! JVRP(346) = dARP(215)/dV(149)
  JVRP(346) = V(141)
! JVRP(347) = dARP(216)/dV(141)
  JVRP(347) = 1
! JVRP(348) = dARP(217)/dV(141)
  JVRP(348) = V(153)
! JVRP(349) = dARP(217)/dV(153)
  JVRP(349) = V(141)
! JVRP(350) = dARP(218)/dV(141)
  JVRP(350) = V(150)
! JVRP(351) = dARP(218)/dV(150)
  JVRP(351) = V(141)
! JVRP(352) = dARP(219)/dV(85)
  JVRP(352) = V(148)
! JVRP(353) = dARP(219)/dV(148)
  JVRP(353) = V(85)
! JVRP(354) = dARP(220)/dV(72)
  JVRP(354) = V(148)
! JVRP(355) = dARP(220)/dV(148)
  JVRP(355) = V(72)
! JVRP(356) = dARP(221)/dV(114)
  JVRP(356) = V(150)
! JVRP(357) = dARP(221)/dV(150)
  JVRP(357) = V(114)
! JVRP(358) = dARP(222)/dV(142)
  JVRP(358) = V(152)
! JVRP(359) = dARP(222)/dV(152)
  JVRP(359) = V(142)
! JVRP(360) = dARP(223)/dV(142)
  JVRP(360) = V(155)
! JVRP(361) = dARP(223)/dV(155)
  JVRP(361) = V(142)
! JVRP(362) = dARP(224)/dV(142)
  JVRP(362) = V(149)
! JVRP(363) = dARP(224)/dV(149)
  JVRP(363) = V(142)
! JVRP(364) = dARP(225)/dV(142)
  JVRP(364) = V(153)
! JVRP(365) = dARP(225)/dV(153)
  JVRP(365) = V(142)
! JVRP(366) = dARP(226)/dV(142)
  JVRP(366) = V(150)
! JVRP(367) = dARP(226)/dV(150)
  JVRP(367) = V(142)
! JVRP(368) = dARP(227)/dV(62)
  JVRP(368) = V(148)
! JVRP(369) = dARP(227)/dV(148)
  JVRP(369) = V(62)
! JVRP(370) = dARP(228)/dV(114)
  JVRP(370) = V(151)
! JVRP(371) = dARP(228)/dV(151)
  JVRP(371) = V(114)
! JVRP(372) = dARP(229)/dV(114)
  JVRP(372) = V(148)
! JVRP(373) = dARP(229)/dV(148)
  JVRP(373) = V(114)
! JVRP(374) = dARP(230)/dV(97)
  JVRP(374) = V(148)
! JVRP(375) = dARP(230)/dV(148)
  JVRP(375) = V(97)
! JVRP(376) = dARP(231)/dV(51)
  JVRP(376) = V(148)
! JVRP(377) = dARP(231)/dV(148)
  JVRP(377) = V(51)
! JVRP(378) = dARP(232)/dV(110)
  JVRP(378) = V(148)
! JVRP(379) = dARP(232)/dV(148)
  JVRP(379) = V(110)
! JVRP(380) = dARP(233)/dV(139)
  JVRP(380) = V(152)
! JVRP(381) = dARP(233)/dV(152)
  JVRP(381) = V(139)
! JVRP(382) = dARP(234)/dV(139)
  JVRP(382) = V(155)
! JVRP(383) = dARP(234)/dV(155)
  JVRP(383) = V(139)
! JVRP(384) = dARP(235)/dV(139)
  JVRP(384) = V(149)
! JVRP(385) = dARP(235)/dV(149)
  JVRP(385) = V(139)
! JVRP(386) = dARP(236)/dV(139)
  JVRP(386) = V(153)
! JVRP(387) = dARP(236)/dV(153)
  JVRP(387) = V(139)
! JVRP(388) = dARP(237)/dV(139)
  JVRP(388) = V(150)
! JVRP(389) = dARP(237)/dV(150)
  JVRP(389) = V(139)
! JVRP(390) = dARP(238)/dV(33)
  JVRP(390) = V(148)
! JVRP(391) = dARP(238)/dV(148)
  JVRP(391) = V(33)
! JVRP(392) = dARP(239)/dV(79)
  JVRP(392) = V(149)
! JVRP(393) = dARP(239)/dV(149)
  JVRP(393) = V(79)
! JVRP(394) = dARP(240)/dV(79)
  JVRP(394) = V(153)
! JVRP(395) = dARP(240)/dV(153)
  JVRP(395) = V(79)
! JVRP(396) = dARP(241)/dV(113)
  JVRP(396) = V(148)
! JVRP(397) = dARP(241)/dV(148)
  JVRP(397) = V(113)
! JVRP(398) = dARP(242)/dV(104)
  JVRP(398) = V(150)
! JVRP(399) = dARP(242)/dV(150)
  JVRP(399) = V(104)
! JVRP(400) = dARP(243)/dV(112)
  JVRP(400) = V(149)
! JVRP(401) = dARP(243)/dV(149)
  JVRP(401) = V(112)
! JVRP(402) = dARP(244)/dV(112)
  JVRP(402) = V(153)
! JVRP(403) = dARP(244)/dV(153)
  JVRP(403) = V(112)
! JVRP(404) = dARP(245)/dV(112)
  JVRP(404) = V(150)
! JVRP(405) = dARP(245)/dV(150)
  JVRP(405) = V(112)
! JVRP(406) = dARP(246)/dV(125)
  JVRP(406) = V(155)
! JVRP(407) = dARP(246)/dV(155)
  JVRP(407) = V(125)
! JVRP(408) = dARP(247)/dV(125)
  JVRP(408) = V(149)
! JVRP(409) = dARP(247)/dV(149)
  JVRP(409) = V(125)
! JVRP(410) = dARP(248)/dV(125)
  JVRP(410) = V(153)
! JVRP(411) = dARP(248)/dV(153)
  JVRP(411) = V(125)
! JVRP(412) = dARP(249)/dV(104)
  JVRP(412) = V(151)
! JVRP(413) = dARP(249)/dV(151)
  JVRP(413) = V(104)
! JVRP(414) = dARP(250)/dV(104)
  JVRP(414) = V(148)
! JVRP(415) = dARP(250)/dV(148)
  JVRP(415) = V(104)
! JVRP(416) = dARP(251)/dV(83)
  JVRP(416) = V(148)
! JVRP(417) = dARP(251)/dV(148)
  JVRP(417) = V(83)
! JVRP(418) = dARP(252)/dV(81)
  JVRP(418) = V(149)
! JVRP(419) = dARP(252)/dV(149)
  JVRP(419) = V(81)
! JVRP(420) = dARP(253)/dV(81)
  JVRP(420) = V(153)
! JVRP(421) = dARP(253)/dV(153)
  JVRP(421) = V(81)
! JVRP(422) = dARP(254)/dV(43)
  JVRP(422) = V(149)
! JVRP(423) = dARP(254)/dV(149)
  JVRP(423) = V(43)
! JVRP(424) = dARP(255)/dV(43)
  JVRP(424) = V(153)
! JVRP(425) = dARP(255)/dV(153)
  JVRP(425) = V(43)
! JVRP(426) = dARP(256)/dV(25)
  JVRP(426) = V(148)
! JVRP(427) = dARP(256)/dV(148)
  JVRP(427) = V(25)
! JVRP(428) = dARP(257)/dV(76)
  JVRP(428) = V(149)
! JVRP(429) = dARP(257)/dV(149)
  JVRP(429) = V(76)
! JVRP(430) = dARP(258)/dV(76)
  JVRP(430) = V(153)
! JVRP(431) = dARP(258)/dV(153)
  JVRP(431) = V(76)
! JVRP(432) = dARP(259)/dV(67)
  JVRP(432) = V(148)
! JVRP(433) = dARP(259)/dV(148)
  JVRP(433) = V(67)
! JVRP(434) = dARP(260)/dV(38)
  JVRP(434) = V(148)
! JVRP(435) = dARP(260)/dV(148)
  JVRP(435) = V(38)
! JVRP(436) = dARP(261)/dV(64)
  JVRP(436) = V(149)
! JVRP(437) = dARP(261)/dV(149)
  JVRP(437) = V(64)
! JVRP(438) = dARP(262)/dV(50)
  JVRP(438) = V(148)
! JVRP(439) = dARP(262)/dV(148)
  JVRP(439) = V(50)
! JVRP(440) = dARP(263)/dV(64)
  JVRP(440) = V(153)
! JVRP(441) = dARP(263)/dV(153)
  JVRP(441) = V(64)
! JVRP(442) = dARP(264)/dV(92)
  JVRP(442) = V(149)
! JVRP(443) = dARP(264)/dV(149)
  JVRP(443) = V(92)
! JVRP(444) = dARP(265)/dV(92)
  JVRP(444) = V(153)
! JVRP(445) = dARP(265)/dV(153)
  JVRP(445) = V(92)
! JVRP(446) = dARP(266)/dV(41)
  JVRP(446) = V(148)
! JVRP(447) = dARP(266)/dV(148)
  JVRP(447) = V(41)
! JVRP(448) = dARP(267)/dV(31)
  JVRP(448) = V(148)
! JVRP(449) = dARP(267)/dV(148)
  JVRP(449) = V(31)
! JVRP(450) = dARP(268)/dV(102)
  JVRP(450) = V(149)
! JVRP(451) = dARP(268)/dV(149)
  JVRP(451) = V(102)
! JVRP(452) = dARP(269)/dV(102)
  JVRP(452) = V(153)
! JVRP(453) = dARP(269)/dV(153)
  JVRP(453) = V(102)
! JVRP(454) = dARP(270)/dV(102)
  JVRP(454) = V(147)
! JVRP(455) = dARP(270)/dV(147)
  JVRP(455) = V(102)
! JVRP(456) = dARP(271)/dV(100)
  JVRP(456) = V(149)
! JVRP(457) = dARP(271)/dV(149)
  JVRP(457) = V(100)
! JVRP(458) = dARP(272)/dV(100)
  JVRP(458) = V(153)
! JVRP(459) = dARP(272)/dV(153)
  JVRP(459) = V(100)
! JVRP(460) = dARP(273)/dV(100)
  JVRP(460) = V(147)
! JVRP(461) = dARP(273)/dV(147)
  JVRP(461) = V(100)
! JVRP(462) = dARP(274)/dV(130)
  JVRP(462) = V(149)
! JVRP(463) = dARP(274)/dV(149)
  JVRP(463) = V(130)
! JVRP(464) = dARP(275)/dV(130)
  JVRP(464) = V(153)
! JVRP(465) = dARP(275)/dV(153)
  JVRP(465) = V(130)
! JVRP(466) = dARP(276)/dV(130)
  JVRP(466) = V(147)
! JVRP(467) = dARP(276)/dV(147)
  JVRP(467) = V(130)
! JVRP(468) = dARP(277)/dV(66)
  JVRP(468) = V(149)
! JVRP(469) = dARP(277)/dV(149)
  JVRP(469) = V(66)
! JVRP(470) = dARP(278)/dV(66)
  JVRP(470) = V(153)
! JVRP(471) = dARP(278)/dV(153)
  JVRP(471) = V(66)
! JVRP(472) = dARP(279)/dV(27)
  JVRP(472) = V(148)
! JVRP(473) = dARP(279)/dV(148)
  JVRP(473) = V(27)
! JVRP(474) = dARP(280)/dV(73)
  JVRP(474) = V(147)
! JVRP(475) = dARP(280)/dV(147)
  JVRP(475) = V(73)
! JVRP(476) = dARP(281)/dV(73)
  JVRP(476) = V(151)
! JVRP(477) = dARP(281)/dV(151)
  JVRP(477) = V(73)
! JVRP(478) = dARP(282)/dV(54)
  JVRP(478) = V(148)
! JVRP(479) = dARP(282)/dV(148)
  JVRP(479) = V(54)
! JVRP(480) = dARP(283)/dV(81)
  JVRP(480) = V(147)
! JVRP(481) = dARP(283)/dV(147)
  JVRP(481) = V(81)
! JVRP(482) = dARP(284)/dV(99)
  JVRP(482) = V(149)
! JVRP(483) = dARP(284)/dV(149)
  JVRP(483) = V(99)
! JVRP(484) = dARP(285)/dV(99)
  JVRP(484) = V(153)
! JVRP(485) = dARP(285)/dV(153)
  JVRP(485) = V(99)
! JVRP(486) = dARP(286)/dV(89)
  JVRP(486) = V(148)
! JVRP(487) = dARP(286)/dV(148)
  JVRP(487) = V(89)
! JVRP(488) = dARP(287)/dV(30)
  JVRP(488) = V(148)
! JVRP(489) = dARP(287)/dV(148)
  JVRP(489) = V(30)
! JVRP(490) = dARP(288)/dV(23)
  JVRP(490) = F(1)
! JVRP(491) = dARP(289)/dV(34)
  JVRP(491) = V(148)
! JVRP(492) = dARP(289)/dV(148)
  JVRP(492) = V(34)
! JVRP(493) = dARP(290)/dV(101)
  JVRP(493) = V(149)
! JVRP(494) = dARP(290)/dV(149)
  JVRP(494) = V(101)
! JVRP(495) = dARP(291)/dV(101)
  JVRP(495) = V(153)
! JVRP(496) = dARP(291)/dV(153)
  JVRP(496) = V(101)
! JVRP(497) = dARP(292)/dV(98)
  JVRP(497) = V(148)
! JVRP(498) = dARP(292)/dV(148)
  JVRP(498) = V(98)
! JVRP(499) = dARP(293)/dV(77)
  JVRP(499) = V(149)
! JVRP(500) = dARP(293)/dV(149)
  JVRP(500) = V(77)
! JVRP(501) = dARP(294)/dV(77)
  JVRP(501) = V(153)
! JVRP(502) = dARP(294)/dV(153)
  JVRP(502) = V(77)
! JVRP(503) = dARP(295)/dV(35)
  JVRP(503) = V(148)
! JVRP(504) = dARP(295)/dV(148)
  JVRP(504) = V(35)
! JVRP(505) = dARP(296)/dV(63)
  JVRP(505) = V(148)
! JVRP(506) = dARP(296)/dV(148)
  JVRP(506) = V(63)
! JVRP(507) = dARP(297)/dV(116)
  JVRP(507) = V(150)
! JVRP(508) = dARP(297)/dV(150)
  JVRP(508) = V(116)
! JVRP(509) = dARP(298)/dV(116)
  JVRP(509) = V(151)
! JVRP(510) = dARP(298)/dV(151)
  JVRP(510) = V(116)
! JVRP(511) = dARP(299)/dV(116)
  JVRP(511) = V(148)
! JVRP(512) = dARP(299)/dV(148)
  JVRP(512) = V(116)
! JVRP(513) = dARP(300)/dV(117)
  JVRP(513) = V(150)
! JVRP(514) = dARP(300)/dV(150)
  JVRP(514) = V(117)
! JVRP(515) = dARP(301)/dV(117)
  JVRP(515) = V(151)
! JVRP(516) = dARP(301)/dV(151)
  JVRP(516) = V(117)
! JVRP(517) = dARP(302)/dV(117)
  JVRP(517) = V(148)
! JVRP(518) = dARP(302)/dV(148)
  JVRP(518) = V(117)
! JVRP(519) = dARP(303)/dV(118)
  JVRP(519) = V(150)
! JVRP(520) = dARP(303)/dV(150)
  JVRP(520) = V(118)
! JVRP(521) = dARP(304)/dV(118)
  JVRP(521) = V(151)
! JVRP(522) = dARP(304)/dV(151)
  JVRP(522) = V(118)
! JVRP(523) = dARP(305)/dV(118)
  JVRP(523) = V(148)
! JVRP(524) = dARP(305)/dV(148)
  JVRP(524) = V(118)
! JVRP(525) = dARP(306)/dV(115)
  JVRP(525) = V(150)
! JVRP(526) = dARP(306)/dV(150)
  JVRP(526) = V(115)
! JVRP(527) = dARP(307)/dV(115)
  JVRP(527) = V(151)
! JVRP(528) = dARP(307)/dV(151)
  JVRP(528) = V(115)
! JVRP(529) = dARP(308)/dV(115)
  JVRP(529) = V(148)
! JVRP(530) = dARP(308)/dV(148)
  JVRP(530) = V(115)
! JVRP(531) = dARP(309)/dV(120)
  JVRP(531) = V(150)
! JVRP(532) = dARP(309)/dV(150)
  JVRP(532) = V(120)
! JVRP(533) = dARP(310)/dV(120)
  JVRP(533) = V(151)
! JVRP(534) = dARP(310)/dV(151)
  JVRP(534) = V(120)
! JVRP(535) = dARP(311)/dV(120)
  JVRP(535) = V(148)
! JVRP(536) = dARP(311)/dV(148)
  JVRP(536) = V(120)
! JVRP(537) = dARP(312)/dV(132)
  JVRP(537) = V(155)
! JVRP(538) = dARP(312)/dV(155)
  JVRP(538) = V(132)
! JVRP(539) = dARP(313)/dV(132)
  JVRP(539) = V(149)
! JVRP(540) = dARP(313)/dV(149)
  JVRP(540) = V(132)
! JVRP(541) = dARP(314)/dV(132)
  JVRP(541) = V(153)
! JVRP(542) = dARP(314)/dV(153)
  JVRP(542) = V(132)
! JVRP(543) = dARP(315)/dV(132)
  JVRP(543) = V(150)
! JVRP(544) = dARP(315)/dV(150)
  JVRP(544) = V(132)
! JVRP(545) = dARP(316)/dV(52)
  JVRP(545) = V(148)
! JVRP(546) = dARP(316)/dV(148)
  JVRP(546) = V(52)
! JVRP(547) = dARP(317)/dV(127)
  JVRP(547) = V(155)
! JVRP(548) = dARP(317)/dV(155)
  JVRP(548) = V(127)
! JVRP(549) = dARP(318)/dV(127)
  JVRP(549) = V(149)
! JVRP(550) = dARP(318)/dV(149)
  JVRP(550) = V(127)
! JVRP(551) = dARP(319)/dV(127)
  JVRP(551) = V(153)
! JVRP(552) = dARP(319)/dV(153)
  JVRP(552) = V(127)
! JVRP(553) = dARP(320)/dV(88)
  JVRP(553) = V(148)
! JVRP(554) = dARP(320)/dV(148)
  JVRP(554) = V(88)
! JVRP(555) = dARP(321)/dV(80)
  JVRP(555) = V(148)
! JVRP(556) = dARP(321)/dV(148)
  JVRP(556) = V(80)
! JVRP(557) = dARP(322)/dV(131)
  JVRP(557) = V(155)
! JVRP(558) = dARP(322)/dV(155)
  JVRP(558) = V(131)
! JVRP(559) = dARP(323)/dV(131)
  JVRP(559) = V(149)
! JVRP(560) = dARP(323)/dV(149)
  JVRP(560) = V(131)
! JVRP(561) = dARP(324)/dV(131)
  JVRP(561) = V(153)
! JVRP(562) = dARP(324)/dV(153)
  JVRP(562) = V(131)
! JVRP(563) = dARP(325)/dV(75)
  JVRP(563) = V(148)
! JVRP(564) = dARP(325)/dV(148)
  JVRP(564) = V(75)
! JVRP(565) = dARP(326)/dV(133)
  JVRP(565) = V(150)
! JVRP(566) = dARP(326)/dV(150)
  JVRP(566) = V(133)
! JVRP(567) = dARP(327)/dV(133)
  JVRP(567) = V(148)
! JVRP(568) = dARP(327)/dV(148)
  JVRP(568) = V(133)
! JVRP(569) = dARP(328)/dV(126)
  JVRP(569) = V(148)
! JVRP(570) = dARP(328)/dV(148)
  JVRP(570) = V(126)
! JVRP(571) = dARP(329)/dV(36)
  JVRP(571) = V(150)
! JVRP(572) = dARP(329)/dV(150)
  JVRP(572) = V(36)
! JVRP(573) = dARP(330)/dV(36)
  JVRP(573) = V(148)
! JVRP(574) = dARP(330)/dV(148)
  JVRP(574) = V(36)
! JVRP(575) = dARP(331)/dV(14)
  JVRP(575) = V(148)
! JVRP(576) = dARP(331)/dV(148)
  JVRP(576) = V(14)
! JVRP(577) = dARP(332)/dV(36)
  JVRP(577) = V(148)
! JVRP(578) = dARP(332)/dV(148)
  JVRP(578) = V(36)
! JVRP(579) = dARP(333)/dV(149)
  JVRP(579) = 1
! JVRP(580) = dARP(334)/dV(29)
  JVRP(580) = 1
! JVRP(581) = dARP(335)/dV(147)
  JVRP(581) = 1
! JVRP(582) = dARP(336)/dV(150)
  JVRP(582) = 1
! JVRP(583) = dARP(337)/dV(19)
  JVRP(583) = V(148)
! JVRP(584) = dARP(337)/dV(148)
  JVRP(584) = V(19)
! JVRP(585) = dARP(338)/dV(116)
  JVRP(585) = V(150)
! JVRP(586) = dARP(338)/dV(150)
  JVRP(586) = V(116)
! JVRP(587) = dARP(339)/dV(116)
  JVRP(587) = V(151)
! JVRP(588) = dARP(339)/dV(151)
  JVRP(588) = V(116)
! JVRP(589) = dARP(340)/dV(116)
  JVRP(589) = V(148)
! JVRP(590) = dARP(340)/dV(148)
  JVRP(590) = V(116)
! JVRP(591) = dARP(341)/dV(117)
  JVRP(591) = V(150)
! JVRP(592) = dARP(341)/dV(150)
  JVRP(592) = V(117)
! JVRP(593) = dARP(342)/dV(117)
  JVRP(593) = V(151)
! JVRP(594) = dARP(342)/dV(151)
  JVRP(594) = V(117)
! JVRP(595) = dARP(343)/dV(117)
  JVRP(595) = V(148)
! JVRP(596) = dARP(343)/dV(148)
  JVRP(596) = V(117)
! JVRP(597) = dARP(344)/dV(25)
  JVRP(597) = V(148)
! JVRP(598) = dARP(344)/dV(148)
  JVRP(598) = V(25)
! JVRP(599) = dARP(345)/dV(118)
  JVRP(599) = V(150)
! JVRP(600) = dARP(345)/dV(150)
  JVRP(600) = V(118)
! JVRP(601) = dARP(346)/dV(118)
  JVRP(601) = V(151)
! JVRP(602) = dARP(346)/dV(151)
  JVRP(602) = V(118)
! JVRP(603) = dARP(347)/dV(118)
  JVRP(603) = V(148)
! JVRP(604) = dARP(347)/dV(148)
  JVRP(604) = V(118)
! JVRP(605) = dARP(348)/dV(114)
  JVRP(605) = V(150)
! JVRP(606) = dARP(348)/dV(150)
  JVRP(606) = V(114)
! JVRP(607) = dARP(349)/dV(114)
  JVRP(607) = V(151)
! JVRP(608) = dARP(349)/dV(151)
  JVRP(608) = V(114)
! JVRP(609) = dARP(350)/dV(114)
  JVRP(609) = V(148)
! JVRP(610) = dARP(350)/dV(148)
  JVRP(610) = V(114)
! JVRP(611) = dARP(351)/dV(8)
  JVRP(611) = V(148)
! JVRP(612) = dARP(351)/dV(148)
  JVRP(612) = V(8)
! JVRP(613) = dARP(352)/dV(115)
  JVRP(613) = V(150)
! JVRP(614) = dARP(352)/dV(150)
  JVRP(614) = V(115)
! JVRP(615) = dARP(353)/dV(115)
  JVRP(615) = V(151)
! JVRP(616) = dARP(353)/dV(151)
  JVRP(616) = V(115)
! JVRP(617) = dARP(354)/dV(115)
  JVRP(617) = V(148)
! JVRP(618) = dARP(354)/dV(148)
  JVRP(618) = V(115)
! JVRP(619) = dARP(355)/dV(120)
  JVRP(619) = V(150)
! JVRP(620) = dARP(355)/dV(150)
  JVRP(620) = V(120)
! JVRP(621) = dARP(356)/dV(120)
  JVRP(621) = V(151)
! JVRP(622) = dARP(356)/dV(151)
  JVRP(622) = V(120)
! JVRP(623) = dARP(357)/dV(120)
  JVRP(623) = V(148)
! JVRP(624) = dARP(357)/dV(148)
  JVRP(624) = V(120)
! JVRP(625) = dARP(358)/dV(9)
  JVRP(625) = V(148)
! JVRP(626) = dARP(358)/dV(148)
  JVRP(626) = V(9)
! JVRP(627) = dARP(359)/dV(30)
  JVRP(627) = V(148)
! JVRP(628) = dARP(359)/dV(148)
  JVRP(628) = V(30)
! JVRP(629) = dARP(360)/dV(34)
  JVRP(629) = V(148)
! JVRP(630) = dARP(360)/dV(148)
  JVRP(630) = V(34)
      
END SUBROUTINE JacReactantProd

! End of JacReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



! Begin Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Fun with respect to rate coefficients
! -----------------------------------------------------------------------------

      SUBROUTINE  dFun_dRcoeff( V, F, NCOEFF, JCOEFF, DFDR )
       
      USE MOZART_T1_Parameters
      USE MOZART_T1_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/radical/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Fun(1:NVAR) / d RCT( JCOEFF(j) )
!         for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DFDR(NVAR*NCOEFF)

! Local vector with reactant products
      REAL(kind=dp) A_RPROD(NREACT)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the reactant products of all reactions     
      CALL ReactantProd ( V, F, A_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_RPROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DFDR(i+NVAR*(j-1)) = 0.0_dp 
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  reactant product  of the JCOEFF(j)-th reaction      
!                  give the j-th column of the derivative matrix   
         aj = A_RPROD(JCOEFF(j))
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DFDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dFun_dRcoeff

! End Derivative w.r.t. Rate Coefficients


! Begin Jacobian Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Jac with respect to rate coefficients
! Times a user vector
! -----------------------------------------------------------------------------

      SUBROUTINE  dJac_dRcoeff( V, F, U, NCOEFF, JCOEFF, DJDR )
       
      USE MOZART_T1_Parameters
      USE MOZART_T1_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! U - User-supplied Vector           
      REAL(kind=dp) U(NVAR)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Jac(1:NVAR) / d RCT( JCOEFF(j) ) * U
!                     for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DJDR(NVAR*NCOEFF)

! Local vector for Jacobian of reactant products
      REAL(kind=dp) JV_RPROD(NJVRP)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the Jacobian of all reactant products   
      CALL JacReactantProd( V, F, JV_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_PROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DJDR(i+NVAR*(j-1)) = 0.0_dp
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  ( Gradient of reactant product of the JCOEFF(j)-th reaction X user vector )    
!                  give the j-th column of the derivative matrix   
!
!          Row JCOEFF(j) of JV_RPROD times the user vector
         aj = 0.0_dp
         DO k=CROW_JVRP(JCOEFF(j)),CROW_JVRP(JCOEFF(j)+1)-1
             aj = aj + JV_RPROD(k)*U(ICOL_JVRP(k))
         END DO
!          Column JCOEFF(j) of Stoichiom. matrix times aj         
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DJDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dJac_dRcoeff

! End Jacobian Derivative w.r.t. Rate Coefficients


END MODULE MOZART_T1_Stoichiom

