! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : MOZART_T1_Rates.f90
! Time                 : Wed Jan 27 13:13:50 2021
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_MOZART_T1_20754_BOXMOX
! Equation file        : MOZART_T1.kpp
! Output root filename : MOZART_T1
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE MOZART_T1_Rates

  USE MOZART_T1_Parameters
  USE MOZART_T1_Global
  USE MOZART_T1_Util
  IMPLICIT NONE

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!  Note: the default argument type for rate laws, as read from the equations file, is single precision
!        but all the internal calculations are performed in double precision
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!~~~>  Arrhenius
!   REAL(kind=dp) FUNCTION ARR( A0,B0,C0 )
!      REAL A0,B0,C0
!      ARR =  DBLE(A0) * EXP(-DBLE(B0)/TEMP) * (TEMP/300.0_dp)**DBLE(C0)
!   END FUNCTION ARR

! Arrhenius (added by psaide 15-07-2009)
    REAL(kind=dp) FUNCTION ARR( A0,B0,C0, TEMP )
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) A0,B0,C0
      ARR =  A0 * EXP( -B0 /TEMP ) * (TEMP/300._dp)**C0
    END FUNCTION ARR

!~~~> Simplified Arrhenius, with two arguments
!~~~> Note: The argument B0 has a changed sign when compared to ARR
!   REAL(kind=dp) FUNCTION ARR2( A0,B0 )
!      REAL A0,B0
!      ARR2 =  DBLE(A0) * EXP( DBLE(B0)/TEMP )
!   END FUNCTION ARR2
! CK 20140313 WRF-chem uses different kind of Arrhenius function
!             with TEMP as argument...
   REAL(kind=dp) FUNCTION ARR2( A0,B0, TEMP )
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) A0,B0
      ARR2 = A0 * EXP( -B0 /TEMP )
   END FUNCTION ARR2
! CK 20140313 end

!   REAL(kind=dp) FUNCTION EP2(A0,C0,A2,C2,A3,C3)
!      REAL A0,C0,A2,C2,A3,C3
!      REAL(kind=dp) K0,K2,K3
!      K0 = DBLE(A0) * EXP(-DBLE(C0)/TEMP)
!      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
!      K3 = DBLE(A3) * EXP(-DBLE(C3)/TEMP)
!      K3 = K3*CFACTOR*1.0E6_dp
!      EP2 = K0 + K3/(1.0_dp+K3/K2 )
!   END FUNCTION EP2

!   REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2)
!      REAL A1, C1, A2, C2
!      REAL(kind=dp) K1, K2
!      K1 = DBLE(A1) * EXP(-DBLE(C1)/TEMP)
!      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
!      EP3 = K1 + K2*(1.0E6_dp*CFACTOR)
!   END FUNCTION EP3

! EP2 (added by psaide 22-07-2009)
   REAL(kind=dp) FUNCTION EP2( A0,C0,A2,C2,A3,C3,TEMP,cair)
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) :: cair
      REAL(kind=dp) A0,C0,A2,C2,A3,C3
      REAL(kind=dp) K0,K2,K3

      K0 = A0 * EXP(-C0 /TEMP)
      K2 = A2 * EXP(-C2 /TEMP)
      K3 = A3 * EXP(-C3 /TEMP)
!      K3 = K3 * 2.45E13_dp * 1.0E6_dp
      K3 = K3 * cair
      EP2 = K0 + K3/(1._dp+K3/K2 )
   END FUNCTION EP2

! EP3 (added by psaide 15-07-2009)
    REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2,TEMP,cair)
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) :: cair
      REAL(kind=dp) A1, C1, A2, C2
      REAL(kind=dp) K1, K2

      K1 = A1 * EXP(-C1 /TEMP)
      K2 = A2 * EXP(-C2 /TEMP)
!      EP3 = K1 + K2*(1.0E6_dp * 2.45E13_dp)
      EP3 = K1 + K2*cair
    END FUNCTION EP3


!   REAL(kind=dp) FUNCTION FALL ( A0,B0,C0,A1,B1,C1,CF)
!      REAL A0,B0,C0,A1,B1,C1,CF
!      REAL(kind=dp) K0, K1
!      K0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
!      K1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
!      K0 = K0*CFACTOR*1.0E6_dp
!      K1 = K0/K1
!      FALL = (K0/(1.0_dp+K1))*   &
!           DBLE(CF)**(1.0_dp/(1.0_dp+(LOG10(K1))**2))
!   END FUNCTION FALL

! FALL (added by psaide 15-07-2009)
    REAL(kind=dp) FUNCTION FALL( A0,B0,C0,A1,B1,C1,CF,TEMP,cair)

      INTRINSIC LOG10

      REAL(kind=dp) :: TEMP
      REAL(kind=dp) :: cair
      REAL(kind=dp) A0,B0,C0,A1,B1,C1,CF
      REAL(kind=dp) K0, K1

      K0 = A0 * EXP(-B0 /TEMP)* (TEMP/300._dp)**C0
      K1 = A1 * EXP(-B1 /TEMP)* (TEMP/300._dp)**C1
!      K0 = K0 * 2.45E13_dp * 1.0E6_dp
      K0 = K0 * cair
      K1 = K0/K1
      FALL = (K0/(1._dp+K1))*CF**(1._dp/(1._dp+(LOG10(K1))**2))

    END FUNCTION FALL

! FALL2 (added by psaide 28-10-2009)
    REAL(KIND=dp) FUNCTION F2( A0,B0,C0,A1,B1,C1,CF,CN,TEMP,cair)

      INTRINSIC LOG10

      REAL(KIND=dp) :: TEMP
      REAL(KIND=dp) :: cair
      REAL(KIND=dp) A0,B0,C0,A1,B1,C1,CF,CN
      REAL(KIND=dp) K0, K1

      K0 = A0 * EXP(-B0 /TEMP)* (TEMP/300._dp)**C0
      K1 = A1 * EXP(-B1 /TEMP)* (TEMP/300._dp)**C1
!      K0 = K0 * 2.45E13_dp * 1.0E6_dp
      K0 = K0 * cair
      K1 = K0/K1
      F2 = (K0/(1._dp+K1))*CF**(1._dp/(1._dp+(LOG10(K1)/CN)**2))

    END FUNCTION F2


  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_3rd(temp,cair,k0_300K,n,kinf_300K,m,fc)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL, INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL, INTENT(IN) :: n         ! exponent for low pressure limit
    REAL, INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL, INTENT(IN) :: m         ! exponent for high pressure limit
    REAL, INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(kind=dp) :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    k_3rd   = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))

  END FUNCTION k_3rd

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_arr (k_298,tdep,temp)
    ! Arrhenius function

    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(kind=dp), INTENT(IN) :: temp  ! temperature

    INTRINSIC EXP

    k_arr = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) ! 1/298.15=3.3540e-3

  END FUNCTION k_arr

! CK 20140313 in the following some more rate functions needed by
!             WRF-chem packages

!------------------------------------
! Troe reactions (as in Stockwell et al, 1997)

    REAL(kind=dp) FUNCTION TROE(k0_300K,n,kinf_300K,m,temp,cair)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(kind=dp),          INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(kind=dp),          INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(kind=dp),          INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(kind=dp),          INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(kind=dp)             :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    TROE   = k0_T/(1._dp+k_ratio)*0.6_dp**(1._dp/(1._dp+LOG10(k_ratio)**2))

   END FUNCTION TROE



!-------------------------------------------
! Troe equilibrium reactions (as in Stockwell et al, 1997)

    REAL(kind=dp) FUNCTION TROEE(A, B, k0_300K,n,kinf_300K,m,temp,cair)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(kind=dp),     INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(kind=dp),     INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(kind=dp),     INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(kind=dp),     INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(kind=dp),     INTENT(IN) :: A, B
    REAL(kind=dp)             :: zt_help, k0_T, kinf_T, k_ratio, troe


    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    troe   = k0_T/(1._dp+k_ratio)*0.6_dp**(1._dp/(1._dp+LOG10(k_ratio)**2))

    TROEE = A * EXP( - B / temp) * troe



  END FUNCTION TROEE

!------------------------
! k=T^2 C exp (-D/T) reactions

   REAL(kind=dp) FUNCTION THERMAL_T2(c, d ,temp)
    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp),     INTENT(IN) :: c, d


     THERMAL_T2= temp**2._dp * c * EXP(- d  / temp)

   END FUNCTION THERMAL_T2

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions



! ****************************************************************************
! J - the photolysis rate retrieval function
! ****************************************************************************
      REAL(kind=dp) FUNCTION J(name)

      CHARACTER(LEN=*), INTENT(IN)     :: name

      CHARACTER(LEN=15) :: xname

      INTEGER                          :: i

      xname(:)           = " "
      xname(1:LEN(name)) = name

      J                  = jvalues(hash(xname))

      RETURN

      END FUNCTION J
! ****************************************************************************



REAL(kind=dp) FUNCTION JPL_TROE( k0_300K, n, kinf_300K, m, base, temp, cair )

!------------------------------------------------------------
! ... dummy arguments
!------------------------------------------------------------
    REAL(kind=dp), INTENT(IN) :: base      ! base expononent
    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(kind=dp), INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(kind=dp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(kind=dp), INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(kind=dp), INTENT(IN) :: m         ! exponent for high pressure limit

!------------------------------------------------------------
! ... local variables
!------------------------------------------------------------
    REAL(kind=dp)  :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T

    JPL_TROE = k0_T/(1._dp + k_ratio)*base**(1._dp/(1._dp + LOG10(k_ratio)**2))

END FUNCTION JPL_TROE

REAL(KIND=dp) FUNCTION usr_CO_OH_a( temp, c_m )
! for cesm-consistent reaction labels, equivalent to usr8
! CO+OH -> CO2+HO2

    REAL(KIND=dp), INTENT(IN) :: temp
    REAL(KIND=dp), INTENT(IN) :: c_m

    REAL(KIND=dp), parameter :: boltz = 1.38044e-16_dp

    usr_CO_OH_a = 1.5e-13_dp * (1._dp + 6.e-7_dp*boltz*c_m*temp)

END FUNCTION usr_CO_OH_a

REAL(KIND=dp) FUNCTION usr_O_O2( temp )
! for cesm-consistent reaction labels
! O+O2+M -> O3+M

    REAL(KIND=dp), INTENT(IN) :: temp

    usr_O_O2 = 6.00e-34_dp*(temp/300._dp)**(-2.4_dp)

END FUNCTION usr_O_O2

REAL(KIND=dp) FUNCTION usr_O_O_M( temp )
! for cesm-consistent reaction labels
! O+O+M->O2+M

    REAL(KIND=dp), INTENT(IN) :: temp

    usr_O_O_M = 2.76e-34_dp * exp( 720.0_dp/temp)

END FUNCTION usr_O_O_M

REAL(KIND=dp) FUNCTION usr_HO2_HO2( temp, c_m, c_h2o )
! for cesm-consistent reaction labels, equivalent to usr9
! HO2+HO2 -> H2O2+O2
! H2O included in fc calculation, not as reactant

    REAL(KIND=dp), INTENT(IN) :: temp
    REAL(KIND=dp), INTENT(IN) :: c_m
    REAL(KIND=dp), INTENT(IN) :: c_h2o

    REAL(KIND=dp) :: ko, kinf, fc

    if( c_h2o > 0._dp ) then
       ko   = 2.3e-13_dp * exp( 600._dp/temp )
       kinf = 1.7e-33_dp * c_m * exp( 1000._dp/temp )
       fc = 1._dp + 1.4e-21_dp *c_h2o* exp( 2200._dp/temp )
       usr_HO2_HO2 = (ko + kinf) * fc
    else
       usr_HO2_HO2 = 0._dp
    end if
END FUNCTION usr_HO2_HO2

REAL(KIND=dp) FUNCTION usr_HNO3_OH( temp, c_m )
! for cesm-consistent reaction labels, equivalent to usr5
! HNO3 + OH -> NO3 + H2O

    REAL(KIND=dp), INTENT(IN) :: temp
    REAL(KIND=dp), INTENT(IN) :: c_m

    REAL(KIND=dp) :: k0, k2

   k0 = c_m * 6.5e-34_dp * exp( 1335._dp/temp )
   k2 = exp( 2199._dp/temp )
   k0 = k0 /(1.0_dp + k0/(2.7e-17_dp*k2))
   k2 = exp( 460._dp/temp )

   usr_HNO3_OH = k0 + 2.4e-14_dp * k2

END FUNCTION usr_HNO3_OH


REAL(KIND=dp) FUNCTION usr_HO2NO2_M( temp, c_m )
! for cesm-consistent reaction labels
! HO2NO2 + M -> HO2+NO2+M
! CESM writes this as dependent on the NO2+HO2 rate
! *** if M is included in reactants, must divide TROEE function by [M]

    REAL(KIND=dp), INTENT(IN) :: temp
    REAL(KIND=dp), INTENT(IN) :: c_m

    usr_HO2NO2_M = TROEE( 4.76e26_dp,10900._dp, 1.8e-31_dp , 3.2_dp , &
                          4.7e-12_dp , 1.4_dp , TEMP, C_M ) /c_m

END FUNCTION usr_HO2NO2_M

REAL(KIND=dp) FUNCTION usr_PAN_M( temp, c_m )
! for cesm-consistent reaction labels
! PAN+M -> CH3CO3+NO2
! *** if M is included in reactants, must divide TROEE function by [M]

    REAL(KIND=dp), INTENT(IN) :: temp
    REAL(KIND=dp), INTENT(IN) :: c_m

    usr_PAN_M = TROEE(1.111e28_dp, 14000._dp, 8.5e-29_dp, 6.5_dp, &
                       1.1e-11_dp, 0._dp, TEMP, C_M) /c_m

END FUNCTION usr_PAN_M

REAL(KIND=dp) FUNCTION usr_CH3COCH3_OH( temp )
! for cesm-consistent reaction labels
! CH3COCH3 + OH -> RO2 + H2O

    REAL(KIND=dp), INTENT(IN) :: temp

    usr_CH3COCH3_OH = 3.82e-11_dp*exp( -2000._dp/temp ) + 1.33e-13_dp

END FUNCTION usr_CH3COCH3_OH

REAL(KIND=dp) FUNCTION usr_MCO3_NO2( temp, c_m )
! for cesm-consistent reaction labels
! MCO3+NO2+M -> MPAN+M

    REAL(KIND=dp), INTENT(IN) :: temp
    REAL(KIND=dp), INTENT(IN) :: c_m

    usr_MCO3_NO2 = 1.1e-11_dp*300._dp/(temp*c_m)

END FUNCTION usr_MCO3_NO2


REAL(KIND=dp) FUNCTION usr_MPAN_M( temp, c_m )
! for cesm-consistent reaction labels
! MPAN+M -> MCO3+NO2+M

    REAL(KIND=dp), INTENT(IN) :: temp
    REAL(KIND=dp), INTENT(IN) :: c_m

    usr_MPAN_M = 1.2221e17_dp*300._dp*exp( -14000._dp/temp )/(temp*c_m)

END FUNCTION usr_MPAN_M

REAL(KIND=dp) FUNCTION usr_N2O5_aer( rh, temp )
! for cesm-consistent reaction labels, equivalent to usr16
! heterogeneous uptake on aerosols: N2O5 -> 2 HNO3
! **** needs code for running with WRF-Chem!!! ****

    REAL(KIND=dp), INTENT(IN) :: rh                       ! relative humidity
    REAL(KIND=dp), INTENT(IN) :: temp                     ! temperature (K)

    usr_N2O5_aer = 0._dp

END FUNCTION usr_N2O5_aer

REAL(KIND=dp) FUNCTION usr_NO3_aer( rh, temp )
! for cesm-consistent reaction labels, equivalent to usr17
! heterogeneous uptake on aerosols: NO3 -> HNO3
! **** needs code for running with WRF-Chem!!! ****

    REAL(KIND=dp), INTENT(IN) :: rh                       ! relative humidity
    REAL(KIND=dp), INTENT(IN) :: temp                     ! temperature (K)

    usr_NO3_aer = 0._dp

END FUNCTION usr_NO3_aer


REAL(KIND=dp) FUNCTION usr_NO2_aer( rh, temp )
! for cesm-consistent reaction labels, equivalent to usr17a
! heterogeneous uptake on aerosols: NO2 -> 0.5 OH + 0.5 NO + 0.5 HNO3
! **** needs code for running with WRF-Chem!!! ****

    REAL(KIND=dp), INTENT(IN) :: rh                       ! relative humidity
    REAL(KIND=dp), INTENT(IN) :: temp                     ! temperature (K)

    usr_NO2_aer = 0._dp

END FUNCTION usr_NO2_aer

REAL(KIND=dp) FUNCTION usr_DMS_OH( temp, c_m )
! for cesm-consistent reaction labels, equivalent to usr24
! DMS + OH -> 0.5 SO2 + 0.5 HO2

    REAL(KIND=dp), INTENT(IN) :: temp
    REAL(KIND=dp), INTENT(IN) :: c_m

    REAL(KIND=dp) :: ko, wrk

    wrk   = .21_dp*c_m
    ko    = 1._dp + 5.5e-31_dp*exp( 7460._dp/temp )*wrk
    usr_DMS_OH = 1.7e-42_dp*exp( 7810._dp/temp )*wrk/ko

END FUNCTION usr_DMS_OH


REAL(KIND=dp) FUNCTION usr_HO2_aer( rh, temp )
! for cesm-consistent reaction labels, equivalent to usr26
! heterogeneous uptake on aerosols: HO2 -> 0.5 H2O2
! **** needs code for running with WRF-Chem!!! ****

    REAL(KIND=dp), INTENT(IN) :: rh                       ! relative humidity
    REAL(KIND=dp), INTENT(IN) :: temp                     ! temperature (K)

    usr_HO2_aer = 0._dp

END FUNCTION usr_HO2_aer

REAL(KIND=dp) FUNCTION usr_SO2_OH( temp, c_m )
! for cesm-consistent reaction labels, equivalent to usr23
! SO2 + OH -> SO4

    REAL(KIND=dp), INTENT(IN) :: temp
    REAL(KIND=dp), INTENT(IN) :: c_m

    REAL(KIND=dp) :: fc, k0
    REAL(KIND=dp) :: wrk

    fc    = 3.e-11_dp * (300._dp/temp) ** 3.3_dp
    wrk   = fc * c_m
    k0    = wrk / (1._dp + wrk/1.5e-12_dp)
    usr_SO2_OH = k0 * .6_dp ** (1._dp/(1._dp + &
                 (log10( wrk/1.5e-12_dp ))**2._dp))

END FUNCTION usr_SO2_OH

REAL(KIND=dp) FUNCTION usr_PBZNIT_M( temp, c_m )
! for cesm-consistent reaction labels
! PBZNIT+M=ACBZO2+NO2+M
! *** if M is included in reactants, must divide TROEE function by [M]

    REAL(KIND=dp), INTENT(IN) :: temp
    REAL(KIND=dp), INTENT(IN) :: c_m

    usr_PBZNIT_M = TROEE( 1.111e28_dp,14000._dp, 9.7e-29_dp , 5.6_dp , &
                          9.3e-12_dp , 0._dp , TEMP, C_M) /c_m

END FUNCTION usr_PBZNIT_M

REAL(KIND=dp) FUNCTION usr_N2O5_M( temp, c_m )
! for cesm-consistent reaction labels
! N2O5 + M -> NO2 + NO3 + M
! CESM writes this as dependent on the NO2+NO3 rate
! *** if M is included in reactants, must divide TROEE function by [M]

    REAL(KIND=dp), INTENT(IN) :: temp
    REAL(KIND=dp), INTENT(IN) :: c_m

    usr_N2O5_M = TROEE(3.333e26_dp, 10900._dp, 2.2e-30_dp, 4.4_dp, &
                       1.4e-12_dp , .7_dp , TEMP, C_M ) /c_m

END FUNCTION usr_N2O5_M


!__________________________________________________

    REAL(KIND=dp) FUNCTION Keff ( A0,B0,C0, TEMP,X1,X2,y1,y2 )
    REAL(KIND=dp),INTENT(IN) :: X1,X2,y1,y2
    REAL(KIND=dp),INTENT(IN) :: TEMP
    REAL(KIND=dp),INTENT(IN):: A0,B0,C0
    Keff = A0 * EXP(- B0 /TEMP ) &
      *(TEMP/300._dp)**C0*(y1*X1/(X1 + X2 + 1.0e-35) &
       +y2*(1-X1/(X1 + X2 + 1.0e-35)))
    END FUNCTION Keff
!__________________________________________________

    REAL(KIND=dp) FUNCTION Keff2 ( C0,X1,X2,y1,y2 )
    REAL(KIND=dp),INTENT(IN) :: X1,X2,y1,y2
    REAL(KIND=dp),INTENT(IN):: C0
    Keff2 = C0*(y1*X1/(X1 + X2 + 1.0e-35) &
       +y2*(1-X1/(X1 + X2 + 1.0e-35 )))
    END FUNCTION Keff2

!__________________________________________________


    REAL(KIND=dp) FUNCTION vbs_yield ( nume, den, voc_idx, bin_idx )
    REAL(KIND=dp), INTENT(IN) :: nume, den
    INTEGER, INTENT(IN)       :: voc_idx, bin_idx
    INTEGER, PARAMETER        :: vbs_nbin = 4, vbs_nspec = 9

    ! normalized (1 g/m3 density) yield for condensable vapors
    REAL(KIND=dp)             :: vbs_alphlowN(vbs_nbin,vbs_nspec)
    REAL(KIND=dp)             :: vbs_alphhiN(vbs_nbin,vbs_nspec)
    REAL(KIND=dp)             :: vbs_mw_prec(vbs_nspec)
    ! SOA density (g/m3)
    REAL(KIND=dp), PARAMETER  :: dens_aer = 1.5
    ! SOA molecular weight (g/mol)
    REAL(KIND=dp), PARAMETER  :: mw_aer   = 250.0

    ! ------------------------------------------------------------------------
    ! Yields used in Murphy and Pandis, 2009; Tsimpidi et al., 2010;
    ! Ahmadov et al., 2012

    ! low NOx condition
    DATA vbs_alphlowN /   &
    0.0000, 0.0750, 0.0000, 0.0000,   & ! ALK4
    0.0000, 0.3000, 0.0000, 0.0000,   & ! ALK5
    0.0045, 0.0090, 0.0600, 0.2250,   & ! OLE1
    0.0225, 0.0435, 0.1290, 0.3750,   & ! OLE2
    0.0750, 0.2250, 0.3750, 0.5250,   & ! ARO1
    0.0750, 0.3000, 0.3750, 0.5250,   & ! ARO2
    0.0090, 0.0300, 0.0150, 0.0000,   & ! ISOP
    0.0750, 0.1500, 0.7500, 0.9000,   & ! SESQ
    0.1073, 0.0918, 0.3587, 0.6075/     ! TERP

    ! high NOx condition
    DATA vbs_alphhiN /    &
    0.0000, 0.0375, 0.0000, 0.0000,   & ! ALK4
    0.0000, 0.1500, 0.0000, 0.0000,   & ! ALK5
    0.0008, 0.0045, 0.0375, 0.1500,   & ! OLE1
    0.0030, 0.0255, 0.0825, 0.2700,   & ! OLE2
    0.0030, 0.1650, 0.3000, 0.4350,   & ! ARO1
    0.0015, 0.1950, 0.3000, 0.4350,   & ! ARO2
    0.0003, 0.0225, 0.0150, 0.0000,   & ! ISOP
    0.0750, 0.1500, 0.7500, 0.9000,   & ! SESQ
    0.0120, 0.1215, 0.2010, 0.5070/     ! TERP

    DATA vbs_mw_prec /    &
    120.0, & ! ALK4
    150.0, & ! ALK5
    120.0, & ! OLE1
    120.0, & ! OLE2
    150.0, & ! ARO1
    150.0, & ! ARO2
    136.0, & ! ISOP
    250.0, & ! SESQ
    180.0/   ! TERP

    REAL(KIND=dp), PARAMETER  :: yields_dens_aer = 1.5 ! g/m3

    !
    ! ------------------------------------------------------------------------

    REAL(KIND=dp)             :: B, mw_ratio, dens_ratio

    ! Lane et al., ES&T, 2008
    ! B = (RO2 + NO) / ((RO2 + NO) + (RO2 + RO2) + (RO2 + HO2))
    ! with nume = (RO2 + NO) and den = (RO2 + RO2) + (RO2 + HO2)
    B = nume / (nume + den + 1.0e-35_dp)

    ! we need molar yields, not mass yields
    mw_ratio = vbs_mw_prec(voc_idx)/mw_aer

    ! density correction
    dens_ratio = dens_aer / yields_dens_aer

    vbs_yield = (vbs_alphhiN(bin_idx,voc_idx)  * B +             &
                 vbs_alphlowN(bin_idx,voc_idx) * (1.0_dp - B)) * &
                 dens_ratio * mw_ratio

    END FUNCTION vbs_yield



! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
      !USE MOZART_T1_Parameters
      !USE MOZART_T1_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST



  c_m = C(ind_M)
  c_h2o = C(ind_H2O)


! End INLINED RCONST

  RCONST(1) = (j('h2o2'))
  RCONST(2) = (j('o2'))
  RCONST(3) = (j('o33p'))
  RCONST(4) = (j('o31d'))
  RCONST(5) = (j('hno3'))
  RCONST(6) = (j('hno4'))
  RCONST(7) = (j('n2o'))
  RCONST(8) = (j('n2o5'))
  RCONST(9) = (j('no2'))
  RCONST(10) = (j('no3o'))
  RCONST(11) = (j('ch3o2h'))
  RCONST(12) = (j('ch3o2h'))
  RCONST(13) = (j('ch3o2h'))
  RCONST(14) = (0.1_dp*j('no2'))
  RCONST(15) = (0.2_dp*j('no2'))
  RCONST(16) = (0.14_dp*j('no2'))
  RCONST(17) = (0.2_dp*j('no2'))
  RCONST(18) = (0.2_dp*j('no2'))
  RCONST(19) = (0.006_dp*j('no2'))
  RCONST(20) = (j('ch3o2h'))
  RCONST(21) = (j('ch3o2h'))
  RCONST(22) = (j('ch3o2h'))
  RCONST(23) = (j('ch3o2h'))
  RCONST(24) = (j('ch2or'))
  RCONST(25) = (j('ch2om'))
  RCONST(26) = (j('ch3cho'))
  RCONST(27) = (j('ch3coch3'))
  RCONST(28) = (j('ch3cocho'))
  RCONST(29) = (0.28_dp*j('h2o2'))
  RCONST(30) = (j('ch3o2h'))
  RCONST(31) = (j('ch3o2h'))
  RCONST(32) = (j('glyald'))
  RCONST(33) = (j('gly'))
  RCONST(34) = (j('glyald'))
  RCONST(35) = (j('ch2or'))
  RCONST(36) = (0.006_dp*j('no2'))
  RCONST(37) = (j('hyac'))
  RCONST(38) = (j('ch3o2h'))
  RCONST(39) = (j('ch3o2h'))
  RCONST(40) = (j('macr'))
  RCONST(41) = (j('ch3o2h'))
  RCONST(42) = (j('ch3coch3'))
  RCONST(43) = (j('ch3o2h'))
  RCONST(44) = (j('pan'))
  RCONST(45) = (j('mvk'))
  RCONST(46) = (j('ch2or'))
  RCONST(47) = (j('ch2or'))
  RCONST(48) = (j('ch3o2h'))
  RCONST(49) = (j('ch3cho'))
  RCONST(50) = (j('pan'))
  RCONST(51) = (j('ch3o2h'))
  RCONST(52) = (j('ch3o2h'))
  RCONST(53) = (j('ch3o2h'))
  RCONST(54) = (0.1_dp*j('no2'))
  RCONST(55) = (j('ch3o2h'))
  RCONST(56) = (j('ch3o2h'))
  RCONST(57) = (j('ch3o2h'))
  RCONST(58) = (j('ch3cho'))
  RCONST(59) = (j('ch3cho'))
  RCONST(60) = (j('ch3o2h'))
  RCONST(61) = (j('ch3o2h'))
  RCONST(62) = (j('ch3o2h'))
  RCONST(63) = (j('ch3o2h'))
  RCONST(64) = (1.500000e-10_dp)
  RCONST(65) = (1.200000e-10_dp)
  RCONST(66) = (ARR2(1.630000e-10_dp,-60.00_dp,TEMP))
  RCONST(67) = (ARR2(2.150000e-11_dp,-110.00_dp,TEMP))
  RCONST(68) = (ARR2(3.300000e-11_dp,-55.00_dp,TEMP))
  RCONST(69) = (1.200000e-10_dp)
  RCONST(70) = (ARR2(8.000000e-12_dp,2060.00_dp,TEMP))
  RCONST(71) = (usr_O_O_M(temp))
  RCONST(72) = (usr_O_O2(temp))
  RCONST(73) = (ARR2(1.600000e-11_dp,4570.00_dp,TEMP))
  RCONST(74) = (ARR2(1.400000e-12_dp,2000.00_dp,TEMP))
  RCONST(75) = (ARR2(3.000000e-11_dp,-200.00_dp,TEMP))
  RCONST(76) = (ARR2(1.000000e-14_dp,490.00_dp,TEMP))
  RCONST(77) = (ARR2(2.800000e-12_dp,1800.00_dp,TEMP))
  RCONST(78) = (1.800000e-12_dp)
  RCONST(79) = (ARR2(4.800000e-11_dp,-250.00_dp,TEMP))
  RCONST(80) = (ARR2(1.800000e-11_dp,-180.00_dp,TEMP))
  RCONST(81) = (ARR2(1.700000e-12_dp,940.00_dp,TEMP))
  RCONST(82) = (1.800000e-12_dp)
  RCONST(83) = (JPL_TROE(6.900000e-31_dp,1.00_dp,2.600000e-11_dp,0.00_dp,0.60_dp,TEMP,C_M))
  RCONST(84) = (usr_HO2_HO2(temp,c_m,c_h2o))
  RCONST(85) = (ARR2(1.300000e-12_dp,-380.00_dp,TEMP))
  RCONST(86) = (ARR2(5.100000e-12_dp,-210.00_dp,TEMP))
  RCONST(87) = (ARR2(1.200000e-13_dp,2450.00_dp,TEMP))
  RCONST(88) = (JPL_TROE(2.500000e-31_dp,1.80_dp,2.200000e-11_dp,0.70_dp,0.60_dp,TEMP,C_M))
  RCONST(89) = (3.500000e-12_dp)
  RCONST(90) = (ARR2(1.500000e-11_dp,-170.00_dp,TEMP))
  RCONST(91) = (1.000000e-11_dp)
  RCONST(92) = (2.200000e-11_dp)
  RCONST(93) = (ARR2(3.300000e-12_dp,-270.00_dp,TEMP))
  RCONST(94) = (ARR2(3.000000e-12_dp,1500.00_dp,TEMP))
  RCONST(95) = (JPL_TROE(9.000000e-32_dp,1.50_dp,3.000000e-11_dp,0.00_dp,0.60_dp,TEMP,C_M))
  RCONST(96) = (ARR2(7.260000e-11_dp,-20.00_dp,TEMP))
  RCONST(97) = (ARR2(4.640000e-11_dp,-20.00_dp,TEMP))
  RCONST(98) = (JPL_TROE(1.900000e-31_dp,3.40_dp,4.000000e-12_dp,0.30_dp,0.60_dp,TEMP,C_M))
  RCONST(99) = (JPL_TROE(2.400000e-30_dp,3.00_dp,1.600000e-12_dp,-0.10_dp,0.60_dp,TEMP,C_M))
  RCONST(100) = (JPL_TROE(1.800000e-30_dp,3.00_dp,2.800000e-11_dp,0.00_dp,0.60_dp,TEMP,C_M))
  RCONST(101) = (usr_HNO3_OH(temp,c_m))
  RCONST(102) = (usr_HO2NO2_M(temp,c_m))
  RCONST(103) = (usr_N2O5_M(temp,c_m))
  RCONST(104) = (ARR2(9.700000e-15_dp,-625.00_dp,TEMP))
  RCONST(105) = (ARR2(6.000000e-13_dp,2058.00_dp,TEMP))
  RCONST(106) = (ARR2(3.400000e-11_dp,1600.00_dp,TEMP))
  RCONST(107) = (ARR2(5.500000e-12_dp,-125.00_dp,TEMP))
  RCONST(108) = (ARR2(5.000000e-13_dp,424.00_dp,TEMP))
  RCONST(109) = (ARR2(1.900000e-14_dp,-706.00_dp,TEMP))
  RCONST(110) = (ARR2(4.100000e-13_dp,-750.00_dp,TEMP))
  RCONST(111) = (ARR2(2.800000e-12_dp,-300.00_dp,TEMP))
  RCONST(112) = (ARR2(2.900000e-12_dp,345.00_dp,TEMP))
  RCONST(113) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(114) = (ARR2(2.450000e-12_dp,1775.00_dp,TEMP))
  RCONST(115) = (JPL_TROE(4.280000e-33_dp,0.00_dp,9.300000e-15_dp,-4.42_dp,0.80_dp,TEMP,C_M))
  RCONST(116) = (4.000000e-13_dp)
  RCONST(117) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(118) = (ARR2(2.400000e+12_dp,7000.00_dp,TEMP))
  RCONST(119) = (ARR2(2.600000e-12_dp,-265.00_dp,TEMP))
  RCONST(120) = (ARR2(1.080000e-10_dp,-105.00_dp,TEMP))
  RCONST(121) = (usr_CO_OH_a(temp,c_m))
  RCONST(122) = (JPL_TROE(5.500000e-30_dp,0.00_dp,8.300000e-13_dp,-2.00_dp,0.60_dp,TEMP,C_M))
  RCONST(123) = (ARR2(1.200000e-14_dp,2630.00_dp,TEMP))
  RCONST(124) = (6.800000e-14_dp)
  RCONST(125) = (2.000000e-13_dp)
  RCONST(126) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(127) = (ARR2(2.600000e-12_dp,-365.00_dp,TEMP))
  RCONST(128) = (ARR2(6.900000e-12_dp,230.00_dp,TEMP))
  RCONST(129) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(130) = (ARR2(7.660000e-12_dp,1020.00_dp,TEMP))
  RCONST(131) = (ARR2(1.400000e-12_dp,1900.00_dp,TEMP))
  RCONST(132) = (ARR2(4.630000e-12_dp,-350.00_dp,TEMP))
  RCONST(133) = (ARR2(7.800000e-13_dp,1050.00_dp,TEMP))
  RCONST(134) = (ARR2(2.900000e-12_dp,-500.00_dp,TEMP))
  RCONST(135) = (ARR2(2.000000e-12_dp,-500.00_dp,TEMP))
  RCONST(136) = (ARR2(4.300000e-13_dp,-1040.00_dp,TEMP))
  RCONST(137) = (ARR2(8.100000e-12_dp,-270.00_dp,TEMP))
  RCONST(138) = (7.000000e-13_dp)
  RCONST(139) = (1.000000e-12_dp)
  RCONST(140) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(141) = (ARR2(4.200000e-12_dp,-180.00_dp,TEMP))
  RCONST(142) = (ARR2(1.600000e+11_dp,4150.00_dp,TEMP))
  RCONST(143) = (1.000000e-14_dp)
  RCONST(144) = (1.000000e-11_dp)
  RCONST(145) = (1.150000e-11_dp)
  RCONST(146) = (4.000000e-14_dp)
  RCONST(147) = (JPL_TROE(8.600000e-29_dp,3.10_dp,9.000000e-12_dp,0.85_dp,0.48_dp,TEMP,C_M))
  RCONST(148) = (JPL_TROE(9.700000e-29_dp,5.60_dp,9.300000e-12_dp,1.50_dp,0.60_dp,TEMP,C_M))
  RCONST(149) = (usr_PAN_M(temp,c_m))
  RCONST(150) = (ARR2(4.600000e-13_dp,1156.00_dp,TEMP))
  RCONST(151) = (ARR2(6.500000e-15_dp,1900.00_dp,TEMP))
  RCONST(152) = (ARR2(3.750000e-13_dp,40.00_dp,TEMP))
  RCONST(153) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(154) = (ARR2(4.200000e-12_dp,-180.00_dp,TEMP))
  RCONST(155) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(156) = (ARR2(8.700000e-12_dp,615.00_dp,TEMP))
  RCONST(157) = (ARR2(1.400000e-12_dp,1860.00_dp,TEMP))
  RCONST(158) = (ARR2(8.400000e-13_dp,-830.00_dp,TEMP))
  RCONST(159) = (3.000000e-12_dp)
  RCONST(160) = (6.700000e-13_dp)
  RCONST(161) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(162) = (ARR2(4.200000e-12_dp,-180.00_dp,TEMP))
  RCONST(163) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(164) = (ARR2(7.100000e-13_dp,-500.00_dp,TEMP))
  RCONST(165) = (ARR2(8.600000e-13_dp,-700.00_dp,TEMP))
  RCONST(166) = (ARR2(2.900000e-12_dp,-300.00_dp,TEMP))
  RCONST(167) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(168) = (JPL_TROE(8.000000e-27_dp,3.50_dp,3.000000e-11_dp,0.00_dp,0.50_dp,TEMP,C_M))
  RCONST(169) = (usr_CH3COCH3_OH(temp))
  RCONST(170) = (3.500000e-13_dp)
  RCONST(171) = (5.400000e-11_dp)
  RCONST(172) = (ARR2(4.800000e-12_dp,-120.00_dp,TEMP))
  RCONST(173) = (ARR2(5.100000e-14_dp,-693.00_dp,TEMP))
  RCONST(174) = (2.000000e-12_dp)
  RCONST(175) = (1.400000e-11_dp)
  RCONST(176) = (ARR2(5.000000e-13_dp,-400.00_dp,TEMP))
  RCONST(177) = (ARR2(8.000000e-13_dp,-700.00_dp,TEMP))
  RCONST(178) = (2.400000e-12_dp)
  RCONST(179) = (ARR2(2.700000e-12_dp,-360.00_dp,TEMP))
  RCONST(180) = (ARR2(1.300000e-13_dp,-360.00_dp,TEMP))
  RCONST(181) = (ARR2(1.500000e-15_dp,2100.00_dp,TEMP))
  RCONST(182) = (ARR2(9.600000e-12_dp,-360.00_dp,TEMP))
  RCONST(183) = (ARR2(2.300000e-11_dp,-200.00_dp,TEMP))
  RCONST(184) = (ARR2(4.600000e-12_dp,-530.00_dp,TEMP))
  RCONST(185) = (ARR2(2.000000e-12_dp,-500.00_dp,TEMP))
  RCONST(186) = (ARR2(4.300000e-13_dp,-1040.00_dp,TEMP))
  RCONST(187) = (ARR2(2.300000e-12_dp,-530.00_dp,TEMP))
  RCONST(188) = (ARR2(5.300000e-12_dp,-360.00_dp,TEMP))
  RCONST(189) = (5.000000e-12_dp)
  RCONST(190) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(191) = (ARR2(4.200000e-12_dp,-180.00_dp,TEMP))
  RCONST(192) = (ARR2(2.300000e-12_dp,170.00_dp,TEMP))
  RCONST(193) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(194) = (JPL_TROE(8.000000e-27_dp,3.50_dp,3.000000e-11_dp,0.00_dp,0.50_dp,TEMP,C_M))
  RCONST(195) = (ARR2(8.500000e-16_dp,1520.00_dp,TEMP))
  RCONST(196) = (ARR2(4.130000e-12_dp,-452.00_dp,TEMP))
  RCONST(197) = (usr_MCO3_NO2(temp,c_m))
  RCONST(198) = (usr_MPAN_M(temp,c_m))
  RCONST(199) = (1.600000e-12_dp)
  RCONST(200) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(201) = (6.700000e-12_dp)
  RCONST(202) = (ARR2(5.400000e-14_dp,-870.00_dp,TEMP))
  RCONST(203) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(204) = (3.500000e-12_dp)
  RCONST(205) = (ARR2(1.860000e-11_dp,-175.00_dp,TEMP))
  RCONST(206) = (ARR2(1.860000e-11_dp,-175.00_dp,TEMP))
  RCONST(207) = (1.300000e-11_dp)
  RCONST(208) = (1.400000e-11_dp)
  RCONST(209) = (ARR2(5.000000e-13_dp,-400.00_dp,TEMP))
  RCONST(210) = (ARR2(8.000000e-13_dp,-700.00_dp,TEMP))
  RCONST(211) = (ARR2(4.400000e-12_dp,-180.00_dp,TEMP))
  RCONST(212) = (2.400000e-12_dp)
  RCONST(213) = (1.400000e-11_dp)
  RCONST(214) = (ARR2(5.000000e-13_dp,-400.00_dp,TEMP))
  RCONST(215) = (ARR2(8.000000e-13_dp,-700.00_dp,TEMP))
  RCONST(216) = (ARR2(1.600000e+9_dp,8300.00_dp,TEMP))
  RCONST(217) = (ARR2(4.400000e-12_dp,-180.00_dp,TEMP))
  RCONST(218) = (2.400000e-12_dp)
  RCONST(219) = (4.000000e-11_dp)
  RCONST(220) = (4.000000e-11_dp)
  RCONST(221) = (ARR2(3.030000e-12_dp,446.00_dp,TEMP))
  RCONST(222) = (1.400000e-11_dp)
  RCONST(223) = (ARR2(5.000000e-13_dp,-400.00_dp,TEMP))
  RCONST(224) = (ARR2(8.000000e-13_dp,-700.00_dp,TEMP))
  RCONST(225) = (ARR2(2.700000e-12_dp,-360.00_dp,TEMP))
  RCONST(226) = (2.400000e-12_dp)
  RCONST(227) = (4.000000e-11_dp)
  RCONST(228) = (ARR2(1.050000e-14_dp,2000.00_dp,TEMP))
  RCONST(229) = (ARR2(2.540000e-11_dp,-410.00_dp,TEMP))
  RCONST(230) = (ARR2(1.520000e-11_dp,-200.00_dp,TEMP))
  RCONST(231) = (7.000000e-11_dp)
  RCONST(232) = (1.000000e-10_dp)
  RCONST(233) = (ARR2(1.300000e-12_dp,-640.00_dp,TEMP))
  RCONST(234) = (ARR2(5.000000e-13_dp,-400.00_dp,TEMP))
  RCONST(235) = (ARR2(8.000000e-13_dp,-700.00_dp,TEMP))
  RCONST(236) = (ARR2(2.700000e-12_dp,-360.00_dp,TEMP))
  RCONST(237) = (2.400000e-12_dp)
  RCONST(238) = (ARR2(1.520000e-12_dp,-200.00_dp,TEMP))
  RCONST(239) = (ARR2(4.300000e-13_dp,-1040.00_dp,TEMP))
  RCONST(240) = (ARR2(2.600000e-12_dp,-365.00_dp,TEMP))
  RCONST(241) = (1.400000e-11_dp)
  RCONST(242) = (ARR2(4.600000e-14_dp,400.00_dp,TEMP))
  RCONST(243) = (ARR2(4.300000e-13_dp,-1040.00_dp,TEMP))
  RCONST(244) = (ARR2(2.600000e-12_dp,-365.00_dp,TEMP))
  RCONST(245) = (2.400000e-12_dp)
  RCONST(246) = (ARR2(3.750000e-13_dp,40.00_dp,TEMP))
  RCONST(247) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(248) = (ARR2(2.600000e-12_dp,-365.00_dp,TEMP))
  RCONST(249) = (1.000000e-17_dp)
  RCONST(250) = (ARR2(8.100000e-12_dp,-610.00_dp,TEMP))
  RCONST(251) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(252) = (ARR2(4.300000e-13_dp,-1040.00_dp,TEMP))
  RCONST(253) = (ARR2(7.500000e-12_dp,-290.00_dp,TEMP))
  RCONST(254) = (ARR2(1.400000e-12_dp,-700.00_dp,TEMP))
  RCONST(255) = (ARR2(2.600000e-12_dp,-350.00_dp,TEMP))
  RCONST(256) = (ARR2(2.300000e-12_dp,193.00_dp,TEMP))
  RCONST(257) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(258) = (ARR2(2.600000e-12_dp,-365.00_dp,TEMP))
  RCONST(259) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(260) = (ARR2(5.900000e-12_dp,-225.00_dp,TEMP))
  RCONST(261) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(262) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(263) = (ARR2(2.600000e-12_dp,-365.00_dp,TEMP))
  RCONST(264) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(265) = (ARR2(2.600000e-12_dp,-365.00_dp,TEMP))
  RCONST(266) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(267) = (4.700000e-11_dp)
  RCONST(268) = (ARR2(4.300000e-13_dp,-1040.00_dp,TEMP))
  RCONST(269) = (ARR2(7.500000e-12_dp,-290.00_dp,TEMP))
  RCONST(270) = (JPL_TROE(9.700000e-29_dp,5.60_dp,9.300000e-12_dp,1.50_dp,0.60_dp,TEMP,C_M))
  RCONST(271) = (ARR2(4.300000e-13_dp,-1040.00_dp,TEMP))
  RCONST(272) = (ARR2(7.500000e-12_dp,-290.00_dp,TEMP))
  RCONST(273) = (JPL_TROE(9.700000e-29_dp,5.60_dp,9.300000e-12_dp,1.50_dp,0.60_dp,TEMP,C_M))
  RCONST(274) = (ARR2(4.300000e-13_dp,-1040.00_dp,TEMP))
  RCONST(275) = (ARR2(7.500000e-12_dp,-290.00_dp,TEMP))
  RCONST(276) = (JPL_TROE(9.700000e-29_dp,5.60_dp,9.300000e-12_dp,1.50_dp,0.60_dp,TEMP,C_M))
  RCONST(277) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(278) = (ARR2(2.600000e-12_dp,-365.00_dp,TEMP))
  RCONST(279) = (ARR2(4.700000e-13_dp,-1220.00_dp,TEMP))
  RCONST(280) = (2.100000e-12_dp)
  RCONST(281) = (2.800000e-13_dp)
  RCONST(282) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(283) = (JPL_TROE(9.700000e-29_dp,5.60_dp,9.300000e-12_dp,1.50_dp,0.60_dp,TEMP,C_M))
  RCONST(284) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(285) = (ARR2(2.600000e-12_dp,-365.00_dp,TEMP))
  RCONST(286) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(287) = (ARR2(1.700000e-12_dp,-352.00_dp,TEMP))
  RCONST(288) = (usr_PBZNIT_M(temp,c_m))
  RCONST(289) = (1.700000e-11_dp)
  RCONST(290) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(291) = (ARR2(2.600000e-12_dp,-365.00_dp,TEMP))
  RCONST(292) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(293) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(294) = (ARR2(2.600000e-12_dp,-365.00_dp,TEMP))
  RCONST(295) = (8.400000e-11_dp)
  RCONST(296) = (ARR2(3.800000e-12_dp,-200.00_dp,TEMP))
  RCONST(297) = (ARR2(1.200000e-12_dp,-490.00_dp,TEMP))
  RCONST(298) = (ARR2(6.300000e-16_dp,580.00_dp,TEMP))
  RCONST(299) = (ARR2(1.200000e-11_dp,-440.00_dp,TEMP))
  RCONST(300) = (1.900000e-11_dp)
  RCONST(301) = (1.200000e-14_dp)
  RCONST(302) = (2.000000e-10_dp)
  RCONST(303) = (2.500000e-12_dp)
  RCONST(304) = (ARR2(1.700000e-15_dp,1300.00_dp,TEMP))
  RCONST(305) = (ARR2(1.600000e-11_dp,-470.00_dp,TEMP))
  RCONST(306) = (1.100000e-11_dp)
  RCONST(307) = (ARR2(3.000000e-15_dp,780.00_dp,TEMP))
  RCONST(308) = (ARR2(4.200000e-11_dp,-400.00_dp,TEMP))
  RCONST(309) = (1.200000e-11_dp)
  RCONST(310) = (4.700000e-16_dp)
  RCONST(311) = (2.100000e-10_dp)
  RCONST(312) = (ARR2(2.000000e-12_dp,-500.00_dp,TEMP))
  RCONST(313) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(314) = (ARR2(4.200000e-12_dp,-180.00_dp,TEMP))
  RCONST(315) = (2.400000e-12_dp)
  RCONST(316) = (2.000000e-11_dp)
  RCONST(317) = (ARR2(2.000000e-12_dp,-500.00_dp,TEMP))
  RCONST(318) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(319) = (ARR2(4.200000e-12_dp,-180.00_dp,TEMP))
  RCONST(320) = (2.300000e-11_dp)
  RCONST(321) = (2.000000e-11_dp)
  RCONST(322) = (ARR2(2.000000e-12_dp,-500.00_dp,TEMP))
  RCONST(323) = (ARR2(7.500000e-13_dp,-700.00_dp,TEMP))
  RCONST(324) = (ARR2(4.200000e-12_dp,-180.00_dp,TEMP))
  RCONST(325) = (3.300000e-11_dp)
  RCONST(326) = (1.000000e-12_dp)
  RCONST(327) = (5.700000e-11_dp)
  RCONST(328) = (3.400000e-11_dp)
  RCONST(329) = (ARR2(1.900000e-13_dp,-520.00_dp,TEMP))
  RCONST(330) = (ARR2(9.600000e-12_dp,234.00_dp,TEMP))
  RCONST(331) = (ARR2(1.700000e-12_dp,710.00_dp,TEMP))
  RCONST(332) = (usr_DMS_OH(temp,c_m))
  RCONST(333) = (usr_HO2_aer(rh,temp))
  RCONST(334) = (usr_N2O5_aer(rh,temp))
  RCONST(335) = (usr_NO2_aer(rh,temp))
  RCONST(336) = (usr_NO3_aer(rh,temp))
  RCONST(337) = (usr_SO2_OH(temp,c_m))
  RCONST(338) = (ARR2(1.200000e-12_dp,-490.00_dp,TEMP))
  RCONST(339) = (ARR2(6.300000e-16_dp,580.00_dp,TEMP))
  RCONST(340) = (ARR2(1.200000e-11_dp,-440.00_dp,TEMP))
  RCONST(341) = (1.900000e-11_dp)
  RCONST(342) = (1.200000e-14_dp)
  RCONST(343) = (2.000000e-10_dp)
  RCONST(344) = (ARR2(2.300000e-12_dp,193.00_dp,TEMP))
  RCONST(345) = (ARR2(1.200000e-12_dp,-490.00_dp,TEMP))
  RCONST(346) = (ARR2(6.300000e-16_dp,580.00_dp,TEMP))
  RCONST(347) = (ARR2(1.200000e-11_dp,-440.00_dp,TEMP))
  RCONST(348) = (ARR2(3.030000e-12_dp,446.00_dp,TEMP))
  RCONST(349) = (ARR2(1.050000e-14_dp,2000.00_dp,TEMP))
  RCONST(350) = (ARR2(2.540000e-11_dp,-410.00_dp,TEMP))
  RCONST(351) = (1.340000e-11_dp)
  RCONST(352) = (ARR2(1.200000e-12_dp,-490.00_dp,TEMP))
  RCONST(353) = (ARR2(6.300000e-16_dp,580.00_dp,TEMP))
  RCONST(354) = (ARR2(1.200000e-11_dp,-440.00_dp,TEMP))
  RCONST(355) = (ARR2(1.200000e-12_dp,-490.00_dp,TEMP))
  RCONST(356) = (ARR2(6.300000e-16_dp,580.00_dp,TEMP))
  RCONST(357) = (ARR2(1.200000e-11_dp,-440.00_dp,TEMP))
  RCONST(358) = (1.340000e-11_dp)
  RCONST(359) = (ARR2(1.700000e-12_dp,-352.00_dp,TEMP))
  RCONST(360) = (1.700000e-11_dp)
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )


   USE MOZART_T1_Global

  RCONST(1) = (j('h2o2'))
  RCONST(2) = (j('o2'))
  RCONST(3) = (j('o33p'))
  RCONST(4) = (j('o31d'))
  RCONST(5) = (j('hno3'))
  RCONST(6) = (j('hno4'))
  RCONST(7) = (j('n2o'))
  RCONST(8) = (j('n2o5'))
  RCONST(9) = (j('no2'))
  RCONST(10) = (j('no3o'))
  RCONST(11) = (j('ch3o2h'))
  RCONST(12) = (j('ch3o2h'))
  RCONST(13) = (j('ch3o2h'))
  RCONST(14) = (0.1_dp*j('no2'))
  RCONST(15) = (0.2_dp*j('no2'))
  RCONST(16) = (0.14_dp*j('no2'))
  RCONST(17) = (0.2_dp*j('no2'))
  RCONST(18) = (0.2_dp*j('no2'))
  RCONST(19) = (0.006_dp*j('no2'))
  RCONST(20) = (j('ch3o2h'))
  RCONST(21) = (j('ch3o2h'))
  RCONST(22) = (j('ch3o2h'))
  RCONST(23) = (j('ch3o2h'))
  RCONST(24) = (j('ch2or'))
  RCONST(25) = (j('ch2om'))
  RCONST(26) = (j('ch3cho'))
  RCONST(27) = (j('ch3coch3'))
  RCONST(28) = (j('ch3cocho'))
  RCONST(29) = (0.28_dp*j('h2o2'))
  RCONST(30) = (j('ch3o2h'))
  RCONST(31) = (j('ch3o2h'))
  RCONST(32) = (j('glyald'))
  RCONST(33) = (j('gly'))
  RCONST(34) = (j('glyald'))
  RCONST(35) = (j('ch2or'))
  RCONST(36) = (0.006_dp*j('no2'))
  RCONST(37) = (j('hyac'))
  RCONST(38) = (j('ch3o2h'))
  RCONST(39) = (j('ch3o2h'))
  RCONST(40) = (j('macr'))
  RCONST(41) = (j('ch3o2h'))
  RCONST(42) = (j('ch3coch3'))
  RCONST(43) = (j('ch3o2h'))
  RCONST(44) = (j('pan'))
  RCONST(45) = (j('mvk'))
  RCONST(46) = (j('ch2or'))
  RCONST(47) = (j('ch2or'))
  RCONST(48) = (j('ch3o2h'))
  RCONST(49) = (j('ch3cho'))
  RCONST(50) = (j('pan'))
  RCONST(51) = (j('ch3o2h'))
  RCONST(52) = (j('ch3o2h'))
  RCONST(53) = (j('ch3o2h'))
  RCONST(54) = (0.1_dp*j('no2'))
  RCONST(55) = (j('ch3o2h'))
  RCONST(56) = (j('ch3o2h'))
  RCONST(57) = (j('ch3o2h'))
  RCONST(58) = (j('ch3cho'))
  RCONST(59) = (j('ch3cho'))
  RCONST(60) = (j('ch3o2h'))
  RCONST(61) = (j('ch3o2h'))
  RCONST(62) = (j('ch3o2h'))
  RCONST(63) = (j('ch3o2h'))
      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE MOZART_T1_Rates

