! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Linear Algebra Data and Routines File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : MOZART_T1_LinearAlgebra.f90
! Time                 : Wed Jan 27 13:13:50 2021
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_MOZART_T1_20754_BOXMOX
! Equation file        : MOZART_T1.kpp
! Output root filename : MOZART_T1
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE MOZART_T1_LinearAlgebra

  USE MOZART_T1_Parameters
  USE MOZART_T1_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! SPARSE_UTIL - SPARSE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecomp( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE MOZART_T1_Parameters
  USE MOZART_T1_JacobianSP

      INTEGER  :: IER
      REAL(kind=dp) :: JVS(LU_NONZERO), W(NVAR), a
      INTEGER  :: k, kk, j, jj

      a = 0. ! mz_rs_20050606
      IER = 0
      DO k=1,NVAR
        ! mz_rs_20050606: don't check if real value == 0
        ! IF ( JVS( LU_DIAG(k) ) .EQ. 0. ) THEN
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(a) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecomp


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplx( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization, complex
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE MOZART_T1_Parameters
  USE MOZART_T1_JacobianSP

      INTEGER        :: IER
      DOUBLE COMPLEX :: JVS(LU_NONZERO), W(NVAR), a
      REAL(kind=dp)  :: b = 0.0
      INTEGER        :: k, kk, j, jj

      IER = 0
      DO k=1,NVAR
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(b) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecompCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplxR( JVSR, JVSI, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!    Sparse LU factorization, complex
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE MOZART_T1_Parameters
  USE MOZART_T1_JacobianSP

      INTEGER       :: IER
      REAL(kind=dp) :: JVSR(LU_NONZERO), JVSI(LU_NONZERO) 
      REAL(kind=dp) :: WR(NVAR), WI(NVAR), ar, ai, den
      INTEGER       :: k, kk, j, jj

      IER = 0
      ar  = 0.0
      DO k=1,NVAR
        IF (  ( ABS(JVSR(LU_DIAG(k))) < TINY(ar) ) .AND. &
              ( ABS(JVSI(LU_DIAG(k))) < TINY(ar) ) )  THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              WR( LU_ICOL(kk) ) = JVSR(kk)
              WI( LU_ICOL(kk) ) = JVSI(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            den = JVSR(LU_DIAG(j))**2 + JVSI(LU_DIAG(j))**2
            ar = -(WR(j)*JVSR(LU_DIAG(j)) + WI(j)*JVSI(LU_DIAG(j)))/den
            ai = -(WI(j)*JVSR(LU_DIAG(j)) - WR(j)*JVSI(LU_DIAG(j)))/den
            WR(j) = -ar
            WI(j) = -ai
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               WR( LU_ICOL(jj) ) = WR( LU_ICOL(jj) ) + ar*JVSR(jj) - ai*JVSI(jj)
               WI( LU_ICOL(jj) ) = WI( LU_ICOL(jj) ) + ar*JVSI(jj) + ai*JVSR(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVSR(kk) = WR( LU_ICOL(kk) )
            JVSI(kk) = WI( LU_ICOL(kk) )
         END DO
      END DO

END SUBROUTINE KppDecompCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE MOZART_T1_Parameters
  USE MOZART_T1_JacobianSP

      INTEGER  :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE MOZART_T1_Parameters
  USE MOZART_T1_JacobianSP

      INTEGER       :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE MOZART_T1_Parameters
  USE MOZART_T1_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveCmplx

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE MOZART_T1_Parameters
  USE MOZART_T1_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), sumr, sumi, den

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             XR(i) = XR(i) - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
             XI(i) = XI(i) - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
         END DO  
      END DO

      DO i=NVAR,1,-1
        sumr = XR(i); sumi = XI(i)
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
            sumr = sumr - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
            sumi = sumi - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
        END DO
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (sumr*JVSR(LU_DIAG(i)) + sumi*JVSI(LU_DIAG(i)))/den
        XI(i) = (sumi*JVSR(LU_DIAG(i)) - sumr*JVSI(LU_DIAG(i)))/den
      END DO
      
END SUBROUTINE KppSolveCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE MOZART_T1_Parameters
  USE MOZART_T1_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve transpose subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE MOZART_T1_Parameters
  USE MOZART_T1_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), den

      DO i=1,NVAR
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (XR(i)*JVSR(LU_DIAG(i)) + XI(i)*JVSI(LU_DIAG(i)))/den
        XI(i) = (XI(i)*JVSR(LU_DIAG(i)) - XR(i)*JVSI(LU_DIAG(i)))/den
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplxR


!
! Next few commented subroutines perform sparse big linear algebra
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppDecompBig( JVS, IP, IER )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse LU factorization
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE MOZART_T1_Parameters
!  USE MOZART_T1_JacobianSP
!
!      INTEGER  :: IP3(3), IER, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), W(3,3,NVAR), a(3,3), E(3,3)
!      INTEGER  :: k, kk, j, jj
!
!      a = 0.0d0
!      IER = 0
!      DO k=1,NVAR
!        DO kk = LU_CROW(k), LU_CROW(k+1)-1
!              W( 1:3,1:3,LU_ICOL(kk) ) = JVS(1:3,1:3,kk)
!        END DO
!        DO kk = LU_CROW(k), LU_DIAG(k)-1
!            j = LU_ICOL(kk)
!            E(1:3,1:3) = JVS( 1:3,1:3,LU_DIAG(j) )
!            ! CALL DGETRF(3,3,E,3,IP3,IER) 
!            CALL FAC3(E,IP3,IER)
!            IF ( IER /= 0 )  RETURN
!            ! a = W(j) / JVS( LU_DIAG(j) )
!            a(1:3,1:3) = W( 1:3,1:3,j )
!            ! CALL DGETRS ('N',3,3,E,3,IP3,a,3,IER) 
!            CALL SOL3('N',E,IP3,a(1,1))
!            CALL SOL3('N',E,IP3,a(1,2))
!            CALL SOL3('N',E,IP3,a(1,3))
!            W(1:3,1:3,j) = a(1:3,1:3)
!            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
!               W( 1:3,1:3,LU_ICOL(jj) ) = W( 1:3,1:3,LU_ICOL(jj) ) &
!                        - MATMUL( a(1:3,1:3) , JVS(1:3,1:3,jj) )
!            END DO
!         END DO
!         DO kk = LU_CROW(k), LU_CROW(k+1)-1
!            JVS(1:3,1:3,kk) = W( 1:3,1:3,LU_ICOL(kk) )
!         END DO
!      END DO
!
!      DO k=1,NVAR
!         ! CALL WGEFA(JVS(1,1,LU_DIAG(k)),3,3,IP(1,k),IER)
!         ! CALL DGETRF(3,3,JVS(1,1,LU_DIAG(k)),3,IP(1,k),IER)
!         CALL FAC3(JVS(1,1,LU_DIAG(k)),IP(1,k),IER)
!         IF ( IER /= 0 )  RETURN
!      END DO 
!      
!END SUBROUTINE KppDecompBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBig( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse solve subroutine using indirect addressing
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE MOZART_T1_Parameters
!  USE MOZART_T1_JacobianSP
!
!      INTEGER  :: i, j, k, m, IP3(3), IP(3,NVAR), IER
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR), sum(3)
!
!      DO i=1,NVAR
!        DO j = LU_CROW(i), LU_DIAG(i)-1 
!          !X(1:3,i) = X(1:3,i) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       X(k,i) = X(k,i) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO  
!      END DO
!
!      DO i=NVAR,1,-1
!        sum(1:3) = X(1:3,i);
!        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
!          !sum(1:3) = sum(1:3) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       sum(k) = sum(k) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO
!        ! X(i) = sum/JVS(LU_DIAG(i));
!        ! CALL DGETRS ('N',3,1,JVS(1:3,1:3,LU_DIAG(i)),3,IP(1,i),sum,3,0) 
!        ! CALL WGESL('N',JVS(1,1,LU_DIAG(i)),3,3,IP(1,i),sum)
!        CALL SOL3('N',JVS(1,1,LU_DIAG(i)),IP(1,i),sum)
!        X(1:3,i) = sum(1:3)
!      END DO
!      
!END SUBROUTINE KppSolveBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBigTR( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Big sparse transpose solve using indirect addressing
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE MOZART_T1_Parameters
!  USE MOZART_T1_JacobianSP
!
!      INTEGER       :: i, j, k, m, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR)
!
!      DO i=1,NVAR
!        ! X(i) = X(i)/JVS(LU_DIAG(i))
!        CALL SOL3('T',JVS(1,1,LU_DIAG(i)),IP(1,i),X(1,i))
!        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !    - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!
!      DO i=NVAR, 1, -1
!        DO j=LU_CROW(i),LU_DIAG(i)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !   - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!      
!END SUBROUTINE KppSolveBigTR
!
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE FAC3(A,IPVT,INFO)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     FAC3 FACTORS THE MATRIX A (3,3) BY
!!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!!     LINPACK - LIKE 
!!
!!     Remove comments to perform pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!
!      REAL(kind=dp) :: A(3,3)
!      INTEGER       :: IPVT(3),INFO
!!      INTEGER       :: L
!!      REAL(kind=dp) :: t, dmax, da, TMP(3)
!      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0
!
!      info = 0
!!      t = TINY(da)
!!      
!!      da = ABS(A(1,1)); L = 1
!!      IF ( ABS(A(2,1))>da ) THEN
!!        da = ABS(A(2,1)); L = 2
!!        IF ( ABS(A(3,1))>da ) THEN
!!          L = 3
!!        END IF  
!!      END IF  
!!      IPVT(1)  = L
!!      IF (L /=1 ) THEN
!!         TMP(1:3) = A(L,1:3)
!!         A(L,1:3) = A(1,1:3)
!!         A(1,1:3) = TMP(1:3)
!!      END IF
!!      IF (ABS(A(1,1)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!
!      A(2,1) = A(2,1)/A(1,1)
!      A(2,2) = A(2,2) - A(2,1)*A(1,2)
!      A(2,3) = A(2,3) - A(2,1)*A(1,3)
!      A(3,1) = A(3,1)/A(1,1)
!      A(3,2) = A(3,2) - A(3,1)*A(1,2)
!      A(3,3) = A(3,3) - A(3,1)*A(1,3)
!      
!!      IPVT(2)  = 2
!!      IF (ABS(A(3,2))>ABS(A(2,2))) THEN
!!         IPVT(2)  = 3
!!         TMP(2:3) = A(3,2:3)
!!         A(3,2:3) = A(2,2:3)
!!         A(2,2:3) = TMP(2:3)
!!      END IF
!!      IF (ABS(A(2,2)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!      
!      A(3,2)   = A(3,2)/A(2,2)
!      A(3,3)   = A(3,3) - A(3,2)*A(2,3)
!      IPVT(3)  = 3
!      
!END SUBROUTINE FAC3
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE SOL3(Trans,A,IPVT,b)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     SOL3 solves the system 3x3
!!     A * x = b  or  trans(a) * x = b
!!     using the factors computed by WGEFA.
!!
!!     Trans      = 'N'   to solve  A*x = b ,
!!                = 'T'   to solve  transpose(A)*x = b
!!     LINPACK - LIKE 
!!
!!     Remove comments to use pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!      CHARACTER     :: Trans
!      REAL(kind=dp) :: a(3,3),b(3)
!      INTEGER       :: IPVT(3)
!!      INTEGER       :: L
!!      REAL(kind=dp) :: TMP
!      
!      SELECT CASE (Trans)
!
!      CASE ('n','N')  !  Solve  A * x = b
!
!!     Solve  L*y = b
!!         L = IPVT(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!         b(2) = b(2)-A(2,1)*b(1)
!         b(3) = b(3)-A(3,1)*b(1)
!         
!!         L = IPVT(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(3) = b(3)-A(3,2)*b(2)
!
!!     Solve  U*x = y
!         b(3) = b(3)/A(3,3)
!         b(2) = (b(2)-A(2,3)*b(3))/A(2,2)
!         b(1) = (b(1)-A(1,3)*b(3)-A(1,2)*b(2))/A(1,1)
!      
!      
!      CASE ('t','T')  !  Solve transpose(A) * x = b
!
!!      Solve transpose(U)*y = b
!         b(1) = b(1)/A(1,1)
!         b(2) = (b(2)-A(1,2)*b(1))/A(2,2)
!         b(3) = (b(3)-A(1,3)*b(1)-A(2,3)*b(2))/A(3,3)
!
!!      Solve transpose(L)*x = y
!         b(2) = b(2)-A(3,2)*b(3)
!!         L = ipvt(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(1) = b(1)-A(3,1)*b(3)-A(2,1)*b(2)
!!         L = ipvt(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!   
!      END SELECT
!
!END SUBROUTINE SOL3

! End of SPARSE_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolve - sparse back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolve ( JVS, X )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)

  X(26) = X(26)-JVS(257)*X(25)
  X(27) = X(27)-JVS(260)*X(25)
  X(31) = X(31)-JVS(271)*X(30)
  X(32) = X(32)-JVS(274)*X(30)
  X(35) = X(35)-JVS(284)*X(34)
  X(42) = X(42)-JVS(310)*X(20)
  X(64) = X(64)-JVS(409)*X(30)-JVS(410)*X(34)-JVS(411)*X(50)
  X(66) = X(66)-JVS(420)*X(27)-JVS(421)*X(31)-JVS(422)*X(54)
  X(69) = X(69)-JVS(436)*X(26)-JVS(437)*X(67)
  X(70) = X(70)-JVS(447)*X(29)-JVS(448)*X(36)
  X(73) = X(73)-JVS(464)*X(27)-JVS(465)*X(31)-JVS(466)*X(35)-JVS(467)*X(41)
  X(76) = X(76)-JVS(483)*X(25)-JVS(484)*X(67)
  X(77) = X(77)-JVS(489)*X(35)-JVS(490)*X(63)
  X(81) = X(81)-JVS(512)*X(23)-JVS(513)*X(38)-JVS(514)*X(50)-JVS(515)*X(64)
  X(86) = X(86)-JVS(539)*X(59)
  X(90) = X(90)-JVS(557)*X(60)
  X(91) = X(91)-JVS(563)*X(37)-JVS(564)*X(89)
  X(92) = X(92)-JVS(574)*X(41)-JVS(575)*X(73)-JVS(576)*X(81)
  X(95) = X(95)-JVS(591)*X(49)-JVS(592)*X(78)-JVS(593)*X(93)-JVS(594)*X(94)
  X(96) = X(96)-JVS(600)*X(74)
  X(97) = X(97)-JVS(606)*X(62)
  X(99) = X(99)-JVS(617)*X(30)-JVS(618)*X(89)
  X(100) = X(100)-JVS(623)*X(69)-JVS(624)*X(76)-JVS(625)*X(89)-JVS(626)*X(98)-JVS(627)*X(99)
  X(101) = X(101)-JVS(634)*X(34)-JVS(635)*X(98)
  X(102) = X(102)-JVS(640)*X(44)-JVS(641)*X(89)-JVS(642)*X(98)-JVS(643)*X(99)-JVS(644)*X(101)
  X(103) = X(103)-JVS(650)*X(24)-JVS(651)*X(60)-JVS(652)*X(65)
  X(105) = X(105)-JVS(673)*X(16)-JVS(674)*X(56)
  X(106) = X(106)-JVS(680)*X(18)-JVS(681)*X(28)-JVS(682)*X(82)-JVS(683)*X(87)
  X(108) = X(108)-JVS(704)*X(15)-JVS(705)*X(53)-JVS(706)*X(78)-JVS(707)*X(93)-JVS(708)*X(94)
  X(109) = X(109)-JVS(715)*X(24)-JVS(716)*X(43)-JVS(717)*X(54)-JVS(718)*X(63)-JVS(719)*X(66)-JVS(720)*X(67)-JVS(721)&
             &*X(76)-JVS(722)*X(77)-JVS(723)*X(89)-JVS(724)*X(98)-JVS(725)*X(99)-JVS(726)*X(100)-JVS(727)*X(101)
  X(111) = X(111)-JVS(749)*X(43)
  X(112) = X(112)-JVS(759)*X(104)
  X(113) = X(113)-JVS(766)*X(83)-JVS(767)*X(104)-JVS(768)*X(112)
  X(119) = X(119)-JVS(797)*X(51)-JVS(798)*X(62)-JVS(799)*X(72)-JVS(800)*X(110)
  X(121) = X(121)-JVS(815)*X(58)-JVS(816)*X(94)-JVS(817)*X(115)-JVS(818)*X(116)-JVS(819)*X(117)-JVS(820)*X(118)-JVS(821)&
             &*X(120)
  X(122) = X(122)-JVS(828)*X(56)-JVS(829)*X(59)-JVS(830)*X(75)-JVS(831)*X(79)-JVS(832)*X(83)-JVS(833)*X(86)-JVS(834)&
             &*X(88)-JVS(835)*X(93)-JVS(836)*X(94)-JVS(837)*X(104)-JVS(838)*X(105)-JVS(839)*X(112)-JVS(840)*X(113)-JVS(841)&
             &*X(115)-JVS(842)*X(116)-JVS(843)*X(117)-JVS(844)*X(118)-JVS(845)*X(120)-JVS(846)*X(121)
  X(123) = X(123)-JVS(859)*X(24)-JVS(860)*X(26)-JVS(861)*X(32)-JVS(862)*X(34)-JVS(863)*X(57)-JVS(864)*X(60)-JVS(865)&
             &*X(88)-JVS(866)*X(91)-JVS(867)*X(98)-JVS(868)*X(99)-JVS(869)*X(100)-JVS(870)*X(101)-JVS(871)*X(102)-JVS(872)&
             &*X(104)-JVS(873)*X(109)-JVS(874)*X(110)-JVS(875)*X(111)-JVS(876)*X(113)-JVS(877)*X(114)-JVS(878)*X(115)&
             &-JVS(879)*X(116)-JVS(880)*X(117)-JVS(881)*X(118)-JVS(882)*X(120)
  X(124) = X(124)-JVS(910)*X(42)-JVS(911)*X(51)-JVS(912)*X(72)-JVS(913)*X(83)-JVS(914)*X(85)-JVS(915)*X(88)-JVS(916)&
             &*X(90)
  X(125) = X(125)-JVS(933)*X(83)-JVS(934)*X(104)
  X(126) = X(126)-JVS(942)*X(88)-JVS(943)*X(115)-JVS(944)*X(116)-JVS(945)*X(117)-JVS(946)*X(118)-JVS(947)*X(120)
  X(127) = X(127)-JVS(957)*X(88)
  X(128) = X(128)-JVS(965)*X(114)
  X(129) = X(129)-JVS(971)*X(40)-JVS(972)*X(49)-JVS(973)*X(53)-JVS(974)*X(59)-JVS(975)*X(74)-JVS(976)*X(86)-JVS(977)&
             &*X(93)-JVS(978)*X(94)-JVS(979)*X(95)-JVS(980)*X(96)-JVS(981)*X(105)-JVS(982)*X(108)-JVS(983)*X(121)-JVS(984)&
             &*X(128)
  X(130) = X(130)-JVS(994)*X(91)-JVS(995)*X(98)-JVS(996)*X(99)-JVS(997)*X(101)-JVS(998)*X(110)
  X(131) = X(131)-JVS(1009)*X(75)-JVS(1010)*X(115)-JVS(1011)*X(116)-JVS(1012)*X(117)-JVS(1013)*X(118)-JVS(1014)*X(120)
  X(132) = X(132)-JVS(1022)*X(52)-JVS(1023)*X(115)-JVS(1024)*X(116)-JVS(1025)*X(117)-JVS(1026)*X(118)-JVS(1027)*X(120)
  X(133) = X(133)-JVS(1036)*X(52)-JVS(1037)*X(75)-JVS(1038)*X(80)-JVS(1039)*X(115)-JVS(1040)*X(116)-JVS(1041)*X(117)&
             &-JVS(1042)*X(118)-JVS(1043)*X(120)-JVS(1044)*X(131)-JVS(1045)*X(132)
  X(134) = X(134)-JVS(1053)*X(55)-JVS(1054)*X(115)-JVS(1055)*X(116)-JVS(1056)*X(117)-JVS(1057)*X(118)-JVS(1058)*X(120)&
             &-JVS(1059)*X(122)-JVS(1060)*X(125)-JVS(1061)*X(126)-JVS(1062)*X(127)-JVS(1063)*X(131)-JVS(1064)*X(133)
  X(135) = X(135)-JVS(1073)*X(39)-JVS(1074)*X(82)-JVS(1075)*X(87)-JVS(1076)*X(106)-JVS(1077)*X(128)
  X(136) = X(136)-JVS(1087)*X(72)-JVS(1088)*X(74)-JVS(1089)*X(84)-JVS(1090)*X(85)-JVS(1091)*X(96)-JVS(1092)*X(128)&
             &-JVS(1093)*X(134)
  X(137) = X(137)-JVS(1110)*X(72)-JVS(1111)*X(85)-JVS(1112)*X(86)-JVS(1113)*X(112)
  X(138) = X(138)-JVS(1123)*X(57)-JVS(1124)*X(63)-JVS(1125)*X(77)-JVS(1126)*X(89)-JVS(1127)*X(98)-JVS(1128)*X(99)&
             &-JVS(1129)*X(101)-JVS(1130)*X(102)-JVS(1131)*X(111)-JVS(1132)*X(115)-JVS(1133)*X(116)-JVS(1134)*X(117)&
             &-JVS(1135)*X(118)-JVS(1136)*X(119)-JVS(1137)*X(120)-JVS(1138)*X(128)-JVS(1139)*X(130)-JVS(1140)*X(134)&
             &-JVS(1141)*X(136)-JVS(1142)*X(137)
  X(139) = X(139)-JVS(1160)*X(21)-JVS(1161)*X(33)-JVS(1162)*X(37)-JVS(1163)*X(46)-JVS(1164)*X(97)
  X(140) = X(140)-JVS(1175)*X(114)
  X(141) = X(141)-JVS(1184)*X(114)
  X(142) = X(142)-JVS(1193)*X(114)
  X(143) = X(143)-JVS(1202)*X(97)-JVS(1203)*X(114)-JVS(1204)*X(140)-JVS(1205)*X(141)-JVS(1206)*X(142)
  X(144) = X(144)-JVS(1215)*X(97)-JVS(1216)*X(114)-JVS(1217)*X(140)-JVS(1218)*X(141)-JVS(1219)*X(142)
  X(145) = X(145)-JVS(1228)*X(48)-JVS(1229)*X(143)-JVS(1230)*X(144)
  X(146) = X(146)-JVS(1239)*X(42)-JVS(1240)*X(47)-JVS(1241)*X(55)-JVS(1242)*X(59)-JVS(1243)*X(60)-JVS(1244)*X(65)&
             &-JVS(1245)*X(68)-JVS(1246)*X(71)-JVS(1247)*X(74)-JVS(1248)*X(75)-JVS(1249)*X(83)-JVS(1250)*X(84)-JVS(1251)&
             &*X(85)-JVS(1252)*X(86)-JVS(1253)*X(87)-JVS(1254)*X(88)-JVS(1255)*X(90)-JVS(1256)*X(93)-JVS(1257)*X(94)&
             &-JVS(1258)*X(96)-JVS(1259)*X(97)-JVS(1260)*X(104)-JVS(1261)*X(105)-JVS(1262)*X(106)-JVS(1263)*X(107)-JVS(1264)&
             &*X(108)-JVS(1265)*X(112)-JVS(1266)*X(114)-JVS(1267)*X(115)-JVS(1268)*X(116)-JVS(1269)*X(117)-JVS(1270)*X(118)&
             &-JVS(1271)*X(119)-JVS(1272)*X(120)-JVS(1273)*X(121)-JVS(1274)*X(124)-JVS(1275)*X(125)-JVS(1276)*X(126)&
             &-JVS(1277)*X(127)-JVS(1278)*X(128)-JVS(1279)*X(131)-JVS(1280)*X(132)-JVS(1281)*X(133)-JVS(1282)*X(134)&
             &-JVS(1283)*X(135)-JVS(1284)*X(136)-JVS(1285)*X(137)-JVS(1286)*X(139)-JVS(1287)*X(140)-JVS(1288)*X(141)&
             &-JVS(1289)*X(142)-JVS(1290)*X(143)-JVS(1291)*X(144)-JVS(1292)*X(145)
  X(147) = X(147)-JVS(1303)*X(22)-JVS(1304)*X(23)-JVS(1305)*X(29)-JVS(1306)*X(43)-JVS(1307)*X(45)-JVS(1308)*X(52)&
             &-JVS(1309)*X(59)-JVS(1310)*X(62)-JVS(1311)*X(64)-JVS(1312)*X(65)-JVS(1313)*X(66)-JVS(1314)*X(70)-JVS(1315)&
             &*X(71)-JVS(1316)*X(73)-JVS(1317)*X(76)-JVS(1318)*X(77)-JVS(1319)*X(79)-JVS(1320)*X(80)-JVS(1321)*X(81)&
             &-JVS(1322)*X(84)-JVS(1323)*X(85)-JVS(1324)*X(86)-JVS(1325)*X(90)-JVS(1326)*X(92)-JVS(1327)*X(93)-JVS(1328)&
             &*X(95)-JVS(1329)*X(96)-JVS(1330)*X(99)-JVS(1331)*X(100)-JVS(1332)*X(101)-JVS(1333)*X(102)-JVS(1334)*X(105)&
             &-JVS(1335)*X(108)-JVS(1336)*X(110)-JVS(1337)*X(112)-JVS(1338)*X(113)-JVS(1339)*X(119)-JVS(1340)*X(121)&
             &-JVS(1341)*X(125)-JVS(1342)*X(127)-JVS(1343)*X(128)-JVS(1344)*X(129)-JVS(1345)*X(130)-JVS(1346)*X(131)&
             &-JVS(1347)*X(132)-JVS(1348)*X(133)-JVS(1349)*X(134)-JVS(1350)*X(135)-JVS(1351)*X(137)-JVS(1352)*X(138)&
             &-JVS(1353)*X(139)-JVS(1354)*X(140)-JVS(1355)*X(141)-JVS(1356)*X(142)-JVS(1357)*X(143)-JVS(1358)*X(144)&
             &-JVS(1359)*X(145)-JVS(1360)*X(146)
  X(148) = X(148)-JVS(1370)*X(14)-JVS(1371)*X(15)-JVS(1372)*X(16)-JVS(1373)*X(17)-JVS(1374)*X(19)-JVS(1375)*X(20)&
             &-JVS(1376)*X(21)-JVS(1377)*X(24)-JVS(1378)*X(25)-JVS(1379)*X(27)-JVS(1380)*X(28)-JVS(1381)*X(30)-JVS(1382)&
             &*X(31)-JVS(1383)*X(33)-JVS(1384)*X(34)-JVS(1385)*X(35)-JVS(1386)*X(36)-JVS(1387)*X(37)-JVS(1388)*X(38)&
             &-JVS(1389)*X(39)-JVS(1390)*X(40)-JVS(1391)*X(41)-JVS(1392)*X(45)-JVS(1393)*X(46)-JVS(1394)*X(47)-JVS(1395)&
             &*X(48)-JVS(1396)*X(49)-JVS(1397)*X(50)-JVS(1398)*X(51)-JVS(1399)*X(52)-JVS(1400)*X(53)-JVS(1401)*X(54)&
             &-JVS(1402)*X(55)-JVS(1403)*X(56)-JVS(1404)*X(58)-JVS(1405)*X(59)-JVS(1406)*X(60)-JVS(1407)*X(61)-JVS(1408)&
             &*X(62)-JVS(1409)*X(63)-JVS(1410)*X(64)-JVS(1411)*X(66)-JVS(1412)*X(67)-JVS(1413)*X(68)-JVS(1414)*X(70)&
             &-JVS(1415)*X(71)-JVS(1416)*X(72)-JVS(1417)*X(74)-JVS(1418)*X(75)-JVS(1419)*X(76)-JVS(1420)*X(77)-JVS(1421)&
             &*X(78)-JVS(1422)*X(79)-JVS(1423)*X(80)-JVS(1424)*X(81)-JVS(1425)*X(82)-JVS(1426)*X(83)-JVS(1427)*X(84)&
             &-JVS(1428)*X(85)-JVS(1429)*X(87)-JVS(1430)*X(88)-JVS(1431)*X(89)-JVS(1432)*X(90)-JVS(1433)*X(92)-JVS(1434)&
             &*X(93)-JVS(1435)*X(94)-JVS(1436)*X(95)-JVS(1437)*X(96)-JVS(1438)*X(97)-JVS(1439)*X(98)-JVS(1440)*X(99)&
             &-JVS(1441)*X(101)-JVS(1442)*X(102)-JVS(1443)*X(103)-JVS(1444)*X(104)-JVS(1445)*X(105)-JVS(1446)*X(106)&
             &-JVS(1447)*X(107)-JVS(1448)*X(108)-JVS(1449)*X(109)-JVS(1450)*X(110)-JVS(1451)*X(111)-JVS(1452)*X(113)&
             &-JVS(1453)*X(114)-JVS(1454)*X(115)-JVS(1455)*X(116)-JVS(1456)*X(117)-JVS(1457)*X(118)-JVS(1458)*X(119)&
             &-JVS(1459)*X(120)-JVS(1460)*X(121)-JVS(1461)*X(122)-JVS(1462)*X(123)-JVS(1463)*X(124)-JVS(1464)*X(125)&
             &-JVS(1465)*X(126)-JVS(1466)*X(127)-JVS(1467)*X(128)-JVS(1468)*X(129)-JVS(1469)*X(130)-JVS(1470)*X(131)&
             &-JVS(1471)*X(132)-JVS(1472)*X(133)-JVS(1473)*X(134)-JVS(1474)*X(135)-JVS(1475)*X(136)-JVS(1476)*X(137)&
             &-JVS(1477)*X(138)-JVS(1478)*X(139)-JVS(1479)*X(140)-JVS(1480)*X(141)-JVS(1481)*X(142)-JVS(1482)*X(143)&
             &-JVS(1483)*X(144)-JVS(1484)*X(145)-JVS(1485)*X(146)-JVS(1486)*X(147)
  X(149) = X(149)-JVS(1495)*X(17)-JVS(1496)*X(24)-JVS(1497)*X(25)-JVS(1498)*X(26)-JVS(1499)*X(27)-JVS(1500)*X(28)&
             &-JVS(1501)*X(30)-JVS(1502)*X(31)-JVS(1503)*X(32)-JVS(1504)*X(34)-JVS(1505)*X(35)-JVS(1506)*X(36)-JVS(1507)&
             &*X(37)-JVS(1508)*X(39)-JVS(1509)*X(40)-JVS(1510)*X(42)-JVS(1511)*X(43)-JVS(1512)*X(44)-JVS(1513)*X(45)&
             &-JVS(1514)*X(47)-JVS(1515)*X(48)-JVS(1516)*X(50)-JVS(1517)*X(51)-JVS(1518)*X(53)-JVS(1519)*X(54)-JVS(1520)&
             &*X(56)-JVS(1521)*X(57)-JVS(1522)*X(60)-JVS(1523)*X(62)-JVS(1524)*X(63)-JVS(1525)*X(64)-JVS(1526)*X(65)&
             &-JVS(1527)*X(66)-JVS(1528)*X(67)-JVS(1529)*X(69)-JVS(1530)*X(72)-JVS(1531)*X(74)-JVS(1532)*X(75)-JVS(1533)&
             &*X(76)-JVS(1534)*X(77)-JVS(1535)*X(79)-JVS(1536)*X(80)-JVS(1537)*X(81)-JVS(1538)*X(82)-JVS(1539)*X(83)&
             &-JVS(1540)*X(84)-JVS(1541)*X(85)-JVS(1542)*X(86)-JVS(1543)*X(87)-JVS(1544)*X(88)-JVS(1545)*X(89)-JVS(1546)&
             &*X(90)-JVS(1547)*X(91)-JVS(1548)*X(92)-JVS(1549)*X(93)-JVS(1550)*X(94)-JVS(1551)*X(95)-JVS(1552)*X(96)&
             &-JVS(1553)*X(97)-JVS(1554)*X(98)-JVS(1555)*X(99)-JVS(1556)*X(100)-JVS(1557)*X(101)-JVS(1558)*X(102)-JVS(1559)&
             &*X(103)-JVS(1560)*X(104)-JVS(1561)*X(105)-JVS(1562)*X(106)-JVS(1563)*X(107)-JVS(1564)*X(108)-JVS(1565)*X(109)&
             &-JVS(1566)*X(110)-JVS(1567)*X(111)-JVS(1568)*X(112)-JVS(1569)*X(113)-JVS(1570)*X(114)-JVS(1571)*X(115)&
             &-JVS(1572)*X(116)-JVS(1573)*X(117)-JVS(1574)*X(118)-JVS(1575)*X(120)-JVS(1576)*X(121)-JVS(1577)*X(123)&
             &-JVS(1578)*X(124)-JVS(1579)*X(125)-JVS(1580)*X(126)-JVS(1581)*X(127)-JVS(1582)*X(128)-JVS(1583)*X(129)&
             &-JVS(1584)*X(130)-JVS(1585)*X(131)-JVS(1586)*X(132)-JVS(1587)*X(133)-JVS(1588)*X(134)-JVS(1589)*X(135)&
             &-JVS(1590)*X(136)-JVS(1591)*X(137)-JVS(1592)*X(138)-JVS(1593)*X(139)-JVS(1594)*X(140)-JVS(1595)*X(141)&
             &-JVS(1596)*X(142)-JVS(1597)*X(143)-JVS(1598)*X(144)-JVS(1599)*X(145)-JVS(1600)*X(146)-JVS(1601)*X(147)&
             &-JVS(1602)*X(148)
  X(150) = X(150)-JVS(1610)*X(29)-JVS(1611)*X(36)-JVS(1612)*X(45)-JVS(1613)*X(59)-JVS(1614)*X(70)-JVS(1615)*X(71)&
             &-JVS(1616)*X(84)-JVS(1617)*X(104)-JVS(1618)*X(112)-JVS(1619)*X(114)-JVS(1620)*X(115)-JVS(1621)*X(116)&
             &-JVS(1622)*X(117)-JVS(1623)*X(118)-JVS(1624)*X(120)-JVS(1625)*X(128)-JVS(1626)*X(129)-JVS(1627)*X(132)&
             &-JVS(1628)*X(133)-JVS(1629)*X(135)-JVS(1630)*X(137)-JVS(1631)*X(138)-JVS(1632)*X(139)-JVS(1633)*X(140)&
             &-JVS(1634)*X(141)-JVS(1635)*X(142)-JVS(1636)*X(143)-JVS(1637)*X(144)-JVS(1638)*X(145)-JVS(1639)*X(146)&
             &-JVS(1640)*X(147)-JVS(1641)*X(148)-JVS(1642)*X(149)
  X(151) = X(151)-JVS(1649)*X(60)-JVS(1650)*X(73)-JVS(1651)*X(92)-JVS(1652)*X(104)-JVS(1653)*X(106)-JVS(1654)*X(114)&
             &-JVS(1655)*X(115)-JVS(1656)*X(116)-JVS(1657)*X(117)-JVS(1658)*X(118)-JVS(1659)*X(120)-JVS(1660)*X(128)&
             &-JVS(1661)*X(135)-JVS(1662)*X(143)-JVS(1663)*X(144)-JVS(1664)*X(146)-JVS(1665)*X(147)-JVS(1666)*X(148)&
             &-JVS(1667)*X(149)-JVS(1668)*X(150)
  X(152) = X(152)-JVS(1674)*X(32)-JVS(1675)*X(34)-JVS(1676)*X(49)-JVS(1677)*X(55)-JVS(1678)*X(57)-JVS(1679)*X(68)&
             &-JVS(1680)*X(71)-JVS(1681)*X(78)-JVS(1682)*X(93)-JVS(1683)*X(94)-JVS(1684)*X(95)-JVS(1685)*X(98)-JVS(1686)&
             &*X(101)-JVS(1687)*X(111)-JVS(1688)*X(114)-JVS(1689)*X(115)-JVS(1690)*X(116)-JVS(1691)*X(117)-JVS(1692)*X(118)&
             &-JVS(1693)*X(119)-JVS(1694)*X(120)-JVS(1695)*X(121)-JVS(1696)*X(122)-JVS(1697)*X(125)-JVS(1698)*X(126)&
             &-JVS(1699)*X(127)-JVS(1700)*X(128)-JVS(1701)*X(129)-JVS(1702)*X(131)-JVS(1703)*X(133)-JVS(1704)*X(134)&
             &-JVS(1705)*X(136)-JVS(1706)*X(137)-JVS(1707)*X(138)-JVS(1708)*X(139)-JVS(1709)*X(140)-JVS(1710)*X(141)&
             &-JVS(1711)*X(142)-JVS(1712)*X(143)-JVS(1713)*X(144)-JVS(1714)*X(145)-JVS(1715)*X(147)-JVS(1716)*X(148)&
             &-JVS(1717)*X(149)-JVS(1718)*X(150)-JVS(1719)*X(151)
  X(153) = X(153)-JVS(1724)*X(18)-JVS(1725)*X(43)-JVS(1726)*X(64)-JVS(1727)*X(65)-JVS(1728)*X(66)-JVS(1729)*X(76)&
             &-JVS(1730)*X(77)-JVS(1731)*X(79)-JVS(1732)*X(81)-JVS(1733)*X(86)-JVS(1734)*X(90)-JVS(1735)*X(92)-JVS(1736)&
             &*X(95)-JVS(1737)*X(96)-JVS(1738)*X(99)-JVS(1739)*X(100)-JVS(1740)*X(101)-JVS(1741)*X(102)-JVS(1742)*X(105)&
             &-JVS(1743)*X(106)-JVS(1744)*X(108)-JVS(1745)*X(112)-JVS(1746)*X(113)-JVS(1747)*X(121)-JVS(1748)*X(125)&
             &-JVS(1749)*X(127)-JVS(1750)*X(128)-JVS(1751)*X(130)-JVS(1752)*X(131)-JVS(1753)*X(132)-JVS(1754)*X(133)&
             &-JVS(1755)*X(134)-JVS(1756)*X(135)-JVS(1757)*X(137)-JVS(1758)*X(139)-JVS(1759)*X(140)-JVS(1760)*X(141)&
             &-JVS(1761)*X(142)-JVS(1762)*X(144)-JVS(1763)*X(145)-JVS(1764)*X(146)-JVS(1765)*X(147)-JVS(1766)*X(148)&
             &-JVS(1767)*X(149)-JVS(1768)*X(150)-JVS(1769)*X(151)-JVS(1770)*X(152)
  X(154) = X(154)-JVS(1774)*X(48)-JVS(1775)*X(84)-JVS(1776)*X(143)-JVS(1777)*X(145)-JVS(1778)*X(147)-JVS(1779)*X(148)&
             &-JVS(1780)*X(149)-JVS(1781)*X(150)-JVS(1782)*X(151)-JVS(1783)*X(152)-JVS(1784)*X(153)
  X(155) = X(155)-JVS(1787)*X(47)-JVS(1788)*X(61)-JVS(1789)*X(68)-JVS(1790)*X(71)-JVS(1791)*X(87)-JVS(1792)*X(102)&
             &-JVS(1793)*X(105)-JVS(1794)*X(106)-JVS(1795)*X(108)-JVS(1796)*X(114)-JVS(1797)*X(121)-JVS(1798)*X(122)&
             &-JVS(1799)*X(125)-JVS(1800)*X(126)-JVS(1801)*X(127)-JVS(1802)*X(128)-JVS(1803)*X(129)-JVS(1804)*X(130)&
             &-JVS(1805)*X(131)-JVS(1806)*X(132)-JVS(1807)*X(133)-JVS(1808)*X(134)-JVS(1809)*X(135)-JVS(1810)*X(137)&
             &-JVS(1811)*X(139)-JVS(1812)*X(140)-JVS(1813)*X(141)-JVS(1814)*X(142)-JVS(1815)*X(144)-JVS(1816)*X(145)&
             &-JVS(1817)*X(146)-JVS(1818)*X(147)-JVS(1819)*X(148)-JVS(1820)*X(149)-JVS(1821)*X(150)-JVS(1822)*X(151)&
             &-JVS(1823)*X(152)-JVS(1824)*X(153)-JVS(1825)*X(154)
  X(155) = X(155)/JVS(1826)
  X(154) = (X(154)-JVS(1786)*X(155))/(JVS(1785))
  X(153) = (X(153)-JVS(1772)*X(154)-JVS(1773)*X(155))/(JVS(1771))
  X(152) = (X(152)-JVS(1721)*X(153)-JVS(1722)*X(154)-JVS(1723)*X(155))/(JVS(1720))
  X(151) = (X(151)-JVS(1670)*X(152)-JVS(1671)*X(153)-JVS(1672)*X(154)-JVS(1673)*X(155))/(JVS(1669))
  X(150) = (X(150)-JVS(1644)*X(151)-JVS(1645)*X(152)-JVS(1646)*X(153)-JVS(1647)*X(154)-JVS(1648)*X(155))/(JVS(1643))
  X(149) = (X(149)-JVS(1604)*X(150)-JVS(1605)*X(151)-JVS(1606)*X(152)-JVS(1607)*X(153)-JVS(1608)*X(154)-JVS(1609)&
             &*X(155))/(JVS(1603))
  X(148) = (X(148)-JVS(1488)*X(149)-JVS(1489)*X(150)-JVS(1490)*X(151)-JVS(1491)*X(152)-JVS(1492)*X(153)-JVS(1493)*X(154)&
             &-JVS(1494)*X(155))/(JVS(1487))
  X(147) = (X(147)-JVS(1362)*X(148)-JVS(1363)*X(149)-JVS(1364)*X(150)-JVS(1365)*X(151)-JVS(1366)*X(152)-JVS(1367)*X(153)&
             &-JVS(1368)*X(154)-JVS(1369)*X(155))/(JVS(1361))
  X(146) = (X(146)-JVS(1294)*X(147)-JVS(1295)*X(148)-JVS(1296)*X(149)-JVS(1297)*X(150)-JVS(1298)*X(151)-JVS(1299)*X(152)&
             &-JVS(1300)*X(153)-JVS(1301)*X(154)-JVS(1302)*X(155))/(JVS(1293))
  X(145) = (X(145)-JVS(1232)*X(148)-JVS(1233)*X(149)-JVS(1234)*X(150)-JVS(1235)*X(151)-JVS(1236)*X(152)-JVS(1237)*X(153)&
             &-JVS(1238)*X(155))/(JVS(1231))
  X(144) = (X(144)-JVS(1221)*X(148)-JVS(1222)*X(149)-JVS(1223)*X(150)-JVS(1224)*X(151)-JVS(1225)*X(152)-JVS(1226)*X(153)&
             &-JVS(1227)*X(155))/(JVS(1220))
  X(143) = (X(143)-JVS(1208)*X(148)-JVS(1209)*X(149)-JVS(1210)*X(150)-JVS(1211)*X(151)-JVS(1212)*X(152)-JVS(1213)*X(153)&
             &-JVS(1214)*X(155))/(JVS(1207))
  X(142) = (X(142)-JVS(1195)*X(148)-JVS(1196)*X(149)-JVS(1197)*X(150)-JVS(1198)*X(151)-JVS(1199)*X(152)-JVS(1200)*X(153)&
             &-JVS(1201)*X(155))/(JVS(1194))
  X(141) = (X(141)-JVS(1186)*X(148)-JVS(1187)*X(149)-JVS(1188)*X(150)-JVS(1189)*X(151)-JVS(1190)*X(152)-JVS(1191)*X(153)&
             &-JVS(1192)*X(155))/(JVS(1185))
  X(140) = (X(140)-JVS(1177)*X(148)-JVS(1178)*X(149)-JVS(1179)*X(150)-JVS(1180)*X(151)-JVS(1181)*X(152)-JVS(1182)*X(153)&
             &-JVS(1183)*X(155))/(JVS(1176))
  X(139) = (X(139)-JVS(1166)*X(140)-JVS(1167)*X(141)-JVS(1168)*X(142)-JVS(1169)*X(148)-JVS(1170)*X(149)-JVS(1171)*X(150)&
             &-JVS(1172)*X(152)-JVS(1173)*X(153)-JVS(1174)*X(155))/(JVS(1165))
  X(138) = (X(138)-JVS(1144)*X(139)-JVS(1145)*X(140)-JVS(1146)*X(141)-JVS(1147)*X(142)-JVS(1148)*X(143)-JVS(1149)*X(144)&
             &-JVS(1150)*X(145)-JVS(1151)*X(147)-JVS(1152)*X(148)-JVS(1153)*X(149)-JVS(1154)*X(150)-JVS(1155)*X(151)&
             &-JVS(1156)*X(152)-JVS(1157)*X(153)-JVS(1158)*X(154)-JVS(1159)*X(155))/(JVS(1143))
  X(137) = (X(137)-JVS(1115)*X(140)-JVS(1116)*X(141)-JVS(1117)*X(145)-JVS(1118)*X(148)-JVS(1119)*X(149)-JVS(1120)*X(150)&
             &-JVS(1121)*X(151)-JVS(1122)*X(153))/(JVS(1114))
  X(136) = (X(136)-JVS(1095)*X(137)-JVS(1096)*X(139)-JVS(1097)*X(140)-JVS(1098)*X(141)-JVS(1099)*X(144)-JVS(1100)*X(145)&
             &-JVS(1101)*X(147)-JVS(1102)*X(148)-JVS(1103)*X(149)-JVS(1104)*X(150)-JVS(1105)*X(151)-JVS(1106)*X(152)&
             &-JVS(1107)*X(153)-JVS(1108)*X(154)-JVS(1109)*X(155))/(JVS(1094))
  X(135) = (X(135)-JVS(1079)*X(144)-JVS(1080)*X(146)-JVS(1081)*X(147)-JVS(1082)*X(148)-JVS(1083)*X(149)-JVS(1084)*X(150)&
             &-JVS(1085)*X(151)-JVS(1086)*X(153))/(JVS(1078))
  X(134) = (X(134)-JVS(1066)*X(137)-JVS(1067)*X(148)-JVS(1068)*X(149)-JVS(1069)*X(150)-JVS(1070)*X(151)-JVS(1071)*X(153)&
             &-JVS(1072)*X(155))/(JVS(1065))
  X(133) = (X(133)-JVS(1047)*X(148)-JVS(1048)*X(149)-JVS(1049)*X(150)-JVS(1050)*X(151)-JVS(1051)*X(153)-JVS(1052)&
             &*X(155))/(JVS(1046))
  X(132) = (X(132)-JVS(1029)*X(133)-JVS(1030)*X(148)-JVS(1031)*X(149)-JVS(1032)*X(150)-JVS(1033)*X(151)-JVS(1034)*X(153)&
             &-JVS(1035)*X(155))/(JVS(1028))
  X(131) = (X(131)-JVS(1016)*X(148)-JVS(1017)*X(149)-JVS(1018)*X(150)-JVS(1019)*X(151)-JVS(1020)*X(153)-JVS(1021)&
             &*X(155))/(JVS(1015))
  X(130) = (X(130)-JVS(1000)*X(141)-JVS(1001)*X(142)-JVS(1002)*X(147)-JVS(1003)*X(148)-JVS(1004)*X(149)-JVS(1005)*X(150)&
             &-JVS(1006)*X(152)-JVS(1007)*X(153)-JVS(1008)*X(155))/(JVS(999))
  X(129) = (X(129)-JVS(986)*X(137)-JVS(987)*X(144)-JVS(988)*X(148)-JVS(989)*X(149)-JVS(990)*X(150)-JVS(991)*X(151)&
             &-JVS(992)*X(153)-JVS(993)*X(155))/(JVS(985))
  X(128) = (X(128)-JVS(967)*X(144)-JVS(968)*X(148)-JVS(969)*X(150)-JVS(970)*X(151))/(JVS(966))
  X(127) = (X(127)-JVS(959)*X(133)-JVS(960)*X(148)-JVS(961)*X(149)-JVS(962)*X(150)-JVS(963)*X(153)-JVS(964)*X(155))&
             &/(JVS(958))
  X(126) = (X(126)-JVS(949)*X(127)-JVS(950)*X(133)-JVS(951)*X(148)-JVS(952)*X(149)-JVS(953)*X(150)-JVS(954)*X(151)&
             &-JVS(955)*X(153)-JVS(956)*X(155))/(JVS(948))
  X(125) = (X(125)-JVS(936)*X(148)-JVS(937)*X(149)-JVS(938)*X(150)-JVS(939)*X(151)-JVS(940)*X(153)-JVS(941)*X(155))&
             &/(JVS(935))
  X(124) = (X(124)-JVS(918)*X(125)-JVS(919)*X(127)-JVS(920)*X(137)-JVS(921)*X(139)-JVS(922)*X(140)-JVS(923)*X(141)&
             &-JVS(924)*X(142)-JVS(925)*X(145)-JVS(926)*X(148)-JVS(927)*X(149)-JVS(928)*X(150)-JVS(929)*X(151)-JVS(930)&
             &*X(152)-JVS(931)*X(153)-JVS(932)*X(155))/(JVS(917))
  X(123) = (X(123)-JVS(884)*X(124)-JVS(885)*X(125)-JVS(886)*X(126)-JVS(887)*X(127)-JVS(888)*X(128)-JVS(889)*X(129)&
             &-JVS(890)*X(130)-JVS(891)*X(133)-JVS(892)*X(135)-JVS(893)*X(137)-JVS(894)*X(138)-JVS(895)*X(139)-JVS(896)&
             &*X(141)-JVS(897)*X(142)-JVS(898)*X(143)-JVS(899)*X(144)-JVS(900)*X(145)-JVS(901)*X(146)-JVS(902)*X(147)&
             &-JVS(903)*X(148)-JVS(904)*X(149)-JVS(905)*X(150)-JVS(906)*X(151)-JVS(907)*X(152)-JVS(908)*X(153)-JVS(909)&
             &*X(155))/(JVS(883))
  X(122) = (X(122)-JVS(848)*X(125)-JVS(849)*X(126)-JVS(850)*X(127)-JVS(851)*X(131)-JVS(852)*X(137)-JVS(853)*X(148)&
             &-JVS(854)*X(149)-JVS(855)*X(150)-JVS(856)*X(151)-JVS(857)*X(153)-JVS(858)*X(155))/(JVS(847))
  X(121) = (X(121)-JVS(823)*X(148)-JVS(824)*X(149)-JVS(825)*X(150)-JVS(826)*X(151)-JVS(827)*X(153))/(JVS(822))
  X(120) = (X(120)-JVS(812)*X(148)-JVS(813)*X(150)-JVS(814)*X(151))/(JVS(811))
  X(119) = (X(119)-JVS(802)*X(128)-JVS(803)*X(141)-JVS(804)*X(142)-JVS(805)*X(148)-JVS(806)*X(149)-JVS(807)*X(150)&
             &-JVS(808)*X(152)-JVS(809)*X(153)-JVS(810)*X(155))/(JVS(801))
  X(118) = (X(118)-JVS(794)*X(148)-JVS(795)*X(150)-JVS(796)*X(151))/(JVS(793))
  X(117) = (X(117)-JVS(790)*X(148)-JVS(791)*X(150)-JVS(792)*X(151))/(JVS(789))
  X(116) = (X(116)-JVS(786)*X(148)-JVS(787)*X(150)-JVS(788)*X(151))/(JVS(785))
  X(115) = (X(115)-JVS(782)*X(148)-JVS(783)*X(150)-JVS(784)*X(151))/(JVS(781))
  X(114) = (X(114)-JVS(778)*X(148)-JVS(779)*X(150)-JVS(780)*X(151))/(JVS(777))
  X(113) = (X(113)-JVS(770)*X(125)-JVS(771)*X(148)-JVS(772)*X(149)-JVS(773)*X(150)-JVS(774)*X(151)-JVS(775)*X(153)&
             &-JVS(776)*X(155))/(JVS(769))
  X(112) = (X(112)-JVS(761)*X(148)-JVS(762)*X(149)-JVS(763)*X(150)-JVS(764)*X(151)-JVS(765)*X(153))/(JVS(760))
  X(111) = (X(111)-JVS(751)*X(115)-JVS(752)*X(116)-JVS(753)*X(117)-JVS(754)*X(118)-JVS(755)*X(120)-JVS(756)*X(149)&
             &-JVS(757)*X(151)-JVS(758)*X(153))/(JVS(750))
  X(110) = (X(110)-JVS(743)*X(142)-JVS(744)*X(148)-JVS(745)*X(150)-JVS(746)*X(152)-JVS(747)*X(153)-JVS(748)*X(155))&
             &/(JVS(742))
  X(109) = (X(109)-JVS(729)*X(110)-JVS(730)*X(111)-JVS(731)*X(124)-JVS(732)*X(130)-JVS(733)*X(139)-JVS(734)*X(141)&
             &-JVS(735)*X(147)-JVS(736)*X(148)-JVS(737)*X(149)-JVS(738)*X(150)-JVS(739)*X(152)-JVS(740)*X(153)-JVS(741)&
             &*X(155))/(JVS(728))
  X(108) = (X(108)-JVS(710)*X(121)-JVS(711)*X(148)-JVS(712)*X(149)-JVS(713)*X(153)-JVS(714)*X(155))/(JVS(709))
  X(107) = (X(107)-JVS(691)*X(108)-JVS(692)*X(125)-JVS(693)*X(127)-JVS(694)*X(131)-JVS(695)*X(132)-JVS(696)*X(134)&
             &-JVS(697)*X(139)-JVS(698)*X(140)-JVS(699)*X(141)-JVS(700)*X(142)-JVS(701)*X(145)-JVS(702)*X(148)-JVS(703)&
             &*X(155))/(JVS(690))
  X(106) = (X(106)-JVS(685)*X(128)-JVS(686)*X(135)-JVS(687)*X(146)-JVS(688)*X(148)-JVS(689)*X(151))/(JVS(684))
  X(105) = (X(105)-JVS(676)*X(148)-JVS(677)*X(149)-JVS(678)*X(153)-JVS(679)*X(155))/(JVS(675))
  X(104) = (X(104)-JVS(670)*X(148)-JVS(671)*X(150)-JVS(672)*X(151))/(JVS(669))
  X(103) = (X(103)-JVS(654)*X(104)-JVS(655)*X(114)-JVS(656)*X(115)-JVS(657)*X(116)-JVS(658)*X(117)-JVS(659)*X(118)&
             &-JVS(660)*X(120)-JVS(661)*X(128)-JVS(662)*X(143)-JVS(663)*X(144)-JVS(664)*X(146)-JVS(665)*X(148)-JVS(666)&
             &*X(149)-JVS(667)*X(151)-JVS(668)*X(153))/(JVS(653))
  X(102) = (X(102)-JVS(646)*X(147)-JVS(647)*X(148)-JVS(648)*X(149)-JVS(649)*X(153))/(JVS(645))
  X(101) = (X(101)-JVS(637)*X(148)-JVS(638)*X(149)-JVS(639)*X(153))/(JVS(636))
  X(100) = (X(100)-JVS(629)*X(101)-JVS(630)*X(147)-JVS(631)*X(148)-JVS(632)*X(149)-JVS(633)*X(153))/(JVS(628))
  X(99) = (X(99)-JVS(620)*X(148)-JVS(621)*X(149)-JVS(622)*X(153))/(JVS(619))
  X(98) = (X(98)-JVS(614)*X(101)-JVS(615)*X(148)-JVS(616)*X(149))/(JVS(613))
  X(97) = (X(97)-JVS(608)*X(140)-JVS(609)*X(141)-JVS(610)*X(142)-JVS(611)*X(148)-JVS(612)*X(149))/(JVS(607))
  X(96) = (X(96)-JVS(602)*X(128)-JVS(603)*X(148)-JVS(604)*X(149)-JVS(605)*X(153))/(JVS(601))
  X(95) = (X(95)-JVS(596)*X(121)-JVS(597)*X(148)-JVS(598)*X(149)-JVS(599)*X(153))/(JVS(595))
  X(94) = (X(94)-JVS(588)*X(121)-JVS(589)*X(148)-JVS(590)*X(149))/(JVS(587))
  X(93) = (X(93)-JVS(584)*X(121)-JVS(585)*X(148)-JVS(586)*X(153))/(JVS(583))
  X(92) = (X(92)-JVS(578)*X(147)-JVS(579)*X(148)-JVS(580)*X(149)-JVS(581)*X(151)-JVS(582)*X(153))/(JVS(577))
  X(91) = (X(91)-JVS(566)*X(98)-JVS(567)*X(99)-JVS(568)*X(101)-JVS(569)*X(110)-JVS(570)*X(141)-JVS(571)*X(148)-JVS(572)&
            &*X(149)-JVS(573)*X(153))/(JVS(565))
  X(90) = (X(90)-JVS(559)*X(148)-JVS(560)*X(149)-JVS(561)*X(151)-JVS(562)*X(153))/(JVS(558))
  X(89) = (X(89)-JVS(554)*X(99)-JVS(555)*X(148)-JVS(556)*X(149))/(JVS(553))
  X(88) = (X(88)-JVS(550)*X(127)-JVS(551)*X(148)-JVS(552)*X(149))/(JVS(549))
  X(87) = (X(87)-JVS(545)*X(106)-JVS(546)*X(128)-JVS(547)*X(148)-JVS(548)*X(151))/(JVS(544))
  X(86) = (X(86)-JVS(541)*X(148)-JVS(542)*X(150)-JVS(543)*X(153))/(JVS(540))
  X(85) = (X(85)-JVS(536)*X(140)-JVS(537)*X(148)-JVS(538)*X(153))/(JVS(535))
  X(84) = (X(84)-JVS(532)*X(147)-JVS(533)*X(148)-JVS(534)*X(154))/(JVS(531))
  X(83) = (X(83)-JVS(528)*X(125)-JVS(529)*X(148)-JVS(530)*X(149))/(JVS(527))
  X(82) = (X(82)-JVS(522)*X(87)-JVS(523)*X(106)-JVS(524)*X(135)-JVS(525)*X(146)-JVS(526)*X(148))/(JVS(521))
  X(81) = (X(81)-JVS(517)*X(147)-JVS(518)*X(148)-JVS(519)*X(149)-JVS(520)*X(153))/(JVS(516))
  X(80) = (X(80)-JVS(507)*X(131)-JVS(508)*X(132)-JVS(509)*X(148)-JVS(510)*X(153)-JVS(511)*X(155))/(JVS(506))
  X(79) = (X(79)-JVS(502)*X(113)-JVS(503)*X(148)-JVS(504)*X(149)-JVS(505)*X(153))/(JVS(501))
  X(78) = (X(78)-JVS(496)*X(93)-JVS(497)*X(94)-JVS(498)*X(121)-JVS(499)*X(148)-JVS(500)*X(153))/(JVS(495))
  X(77) = (X(77)-JVS(492)*X(148)-JVS(493)*X(149)-JVS(494)*X(153))/(JVS(491))
  X(76) = (X(76)-JVS(486)*X(148)-JVS(487)*X(149)-JVS(488)*X(153))/(JVS(485))
  X(75) = (X(75)-JVS(480)*X(131)-JVS(481)*X(148)-JVS(482)*X(149))/(JVS(479))
  X(74) = (X(74)-JVS(476)*X(96)-JVS(477)*X(148)-JVS(478)*X(149))/(JVS(475))
  X(73) = (X(73)-JVS(469)*X(92)-JVS(470)*X(147)-JVS(471)*X(148)-JVS(472)*X(149)-JVS(473)*X(151)-JVS(474)*X(153))&
            &/(JVS(468))
  X(72) = (X(72)-JVS(461)*X(141)-JVS(462)*X(148)-JVS(463)*X(153))/(JVS(460))
  X(71) = (X(71)-JVS(457)*X(147)-JVS(458)*X(148)-JVS(459)*X(152))/(JVS(456))
  X(70) = (X(70)-JVS(450)*X(129)-JVS(451)*X(138)-JVS(452)*X(146)-JVS(453)*X(147)-JVS(454)*X(148)-JVS(455)*X(150))&
            &/(JVS(449))
  X(69) = (X(69)-JVS(439)*X(76)-JVS(440)*X(89)-JVS(441)*X(98)-JVS(442)*X(99)-JVS(443)*X(101)-JVS(444)*X(148)-JVS(445)&
            &*X(149)-JVS(446)*X(153))/(JVS(438))
  X(68) = (X(68)-JVS(432)*X(148)-JVS(433)*X(149)-JVS(434)*X(152)-JVS(435)*X(154))/(JVS(431))
  X(67) = (X(67)-JVS(428)*X(76)-JVS(429)*X(148)-JVS(430)*X(149))/(JVS(427))
  X(66) = (X(66)-JVS(424)*X(148)-JVS(425)*X(149)-JVS(426)*X(153))/(JVS(423))
  X(65) = (X(65)-JVS(417)*X(146)-JVS(418)*X(149)-JVS(419)*X(153))/(JVS(416))
  X(64) = (X(64)-JVS(413)*X(148)-JVS(414)*X(149)-JVS(415)*X(153))/(JVS(412))
  X(63) = (X(63)-JVS(406)*X(77)-JVS(407)*X(148)-JVS(408)*X(149))/(JVS(405))
  X(62) = (X(62)-JVS(402)*X(142)-JVS(403)*X(148)-JVS(404)*X(149))/(JVS(401))
  X(61) = (X(61)-JVS(394)*X(128)-JVS(395)*X(148)-JVS(396)*X(149)-JVS(397)*X(151)-JVS(398)*X(152)-JVS(399)*X(154)&
            &-JVS(400)*X(155))/(JVS(393))
  X(60) = (X(60)-JVS(391)*X(148)-JVS(392)*X(151))/(JVS(390))
  X(59) = (X(59)-JVS(388)*X(148)-JVS(389)*X(150))/(JVS(387))
  X(58) = (X(58)-JVS(380)*X(115)-JVS(381)*X(116)-JVS(382)*X(117)-JVS(383)*X(118)-JVS(384)*X(120)-JVS(385)*X(148)&
            &-JVS(386)*X(151))/(JVS(379))
  X(57) = (X(57)-JVS(376)*X(98)-JVS(377)*X(101)-JVS(378)*X(153))/(JVS(375))
  X(56) = (X(56)-JVS(372)*X(105)-JVS(373)*X(148)-JVS(374)*X(149))/(JVS(371))
  X(55) = (X(55)-JVS(368)*X(134)-JVS(369)*X(148)-JVS(370)*X(149))/(JVS(367))
  X(54) = (X(54)-JVS(364)*X(66)-JVS(365)*X(148)-JVS(366)*X(149))/(JVS(363))
  X(53) = (X(53)-JVS(360)*X(108)-JVS(361)*X(148)-JVS(362)*X(149))/(JVS(359))
  X(52) = (X(52)-JVS(356)*X(132)-JVS(357)*X(148)-JVS(358)*X(149))/(JVS(355))
  X(51) = (X(51)-JVS(352)*X(142)-JVS(353)*X(148)-JVS(354)*X(155))/(JVS(351))
  X(50) = (X(50)-JVS(348)*X(64)-JVS(349)*X(148)-JVS(350)*X(149))/(JVS(347))
  X(49) = (X(49)-JVS(344)*X(95)-JVS(345)*X(148)-JVS(346)*X(149))/(JVS(343))
  X(48) = (X(48)-JVS(340)*X(145)-JVS(341)*X(148)-JVS(342)*X(149))/(JVS(339))
  X(47) = (X(47)-JVS(336)*X(148)-JVS(337)*X(149)-JVS(338)*X(155))/(JVS(335))
  X(46) = (X(46)-JVS(329)*X(141)-JVS(330)*X(148)-JVS(331)*X(150)-JVS(332)*X(152)-JVS(333)*X(153)-JVS(334)*X(155))&
            &/(JVS(328))
  X(45) = (X(45)-JVS(325)*X(147)-JVS(326)*X(148)-JVS(327)*X(149))/(JVS(324))
  X(44) = (X(44)-JVS(319)*X(89)-JVS(320)*X(98)-JVS(321)*X(99)-JVS(322)*X(101)-JVS(323)*X(153))/(JVS(318))
  X(43) = (X(43)-JVS(316)*X(149)-JVS(317)*X(153))/(JVS(315))
  X(42) = (X(42)-JVS(312)*X(90)-JVS(313)*X(149)-JVS(314)*X(153))/(JVS(311))
  X(41) = (X(41)-JVS(307)*X(92)-JVS(308)*X(148)-JVS(309)*X(149))/(JVS(306))
  X(40) = (X(40)-JVS(303)*X(108)-JVS(304)*X(148)-JVS(305)*X(155))/(JVS(302))
  X(39) = (X(39)-JVS(299)*X(135)-JVS(300)*X(148)-JVS(301)*X(149))/(JVS(298))
  X(38) = (X(38)-JVS(294)*X(50)-JVS(295)*X(64)-JVS(296)*X(148)-JVS(297)*X(153))/(JVS(293))
  X(37) = (X(37)-JVS(291)*X(141)-JVS(292)*X(148))/(JVS(290))
  X(36) = (X(36)-JVS(288)*X(148)-JVS(289)*X(150))/(JVS(287))
  X(35) = (X(35)-JVS(286)*X(148))/(JVS(285))
  X(34) = (X(34)-JVS(283)*X(148))/(JVS(282))
  X(33) = (X(33)-JVS(279)*X(139)-JVS(280)*X(148)-JVS(281)*X(149))/(JVS(278))
  X(32) = (X(32)-JVS(276)*X(34)-JVS(277)*X(148))/(JVS(275))
  X(31) = (X(31)-JVS(273)*X(148))/(JVS(272))
  X(30) = (X(30)-JVS(270)*X(148))/(JVS(269))
  X(29) = (X(29)-JVS(267)*X(147)-JVS(268)*X(150))/(JVS(266))
  X(28) = (X(28)-JVS(264)*X(106)-JVS(265)*X(148))/(JVS(263))
  X(27) = (X(27)-JVS(262)*X(148))/(JVS(261))
  X(26) = (X(26)-JVS(259)*X(148))/(JVS(258))
  X(25) = (X(25)-JVS(256)*X(148))/(JVS(255))
  X(24) = (X(24)-JVS(254)*X(148))/(JVS(253))
  X(23) = (X(23)-JVS(251)*X(81)-JVS(252)*X(147))/(JVS(250))
  X(22) = (X(22)-JVS(246)*X(127)-JVS(247)*X(137)-JVS(248)*X(148)-JVS(249)*X(153))/(JVS(245))
  X(21) = (X(21)-JVS(243)*X(97)-JVS(244)*X(148))/(JVS(242))
  X(20) = (X(20)-JVS(240)*X(90)-JVS(241)*X(149))/(JVS(239))
  X(19) = (X(19)-JVS(236)*X(36)-JVS(237)*X(148)-JVS(238)*X(150))/(JVS(235))
  X(18) = (X(18)-JVS(234)*X(106))/(JVS(233))
  X(17) = (X(17)-JVS(232)*X(148))/(JVS(231))
  X(16) = (X(16)-JVS(230)*X(148))/(JVS(229))
  X(15) = (X(15)-JVS(228)*X(148))/(JVS(227))
  X(14) = (X(14)-JVS(226)*X(148))/(JVS(225))
  X(13) = (X(13)-JVS(158)*X(15)-JVS(159)*X(16)-JVS(160)*X(17)-JVS(161)*X(21)-JVS(162)*X(24)-JVS(163)*X(25)-JVS(164)&
            &*X(27)-JVS(165)*X(28)-JVS(166)*X(30)-JVS(167)*X(31)-JVS(168)*X(33)-JVS(169)*X(34)-JVS(170)*X(37)-JVS(171)*X(40)&
            &-JVS(172)*X(41)-JVS(173)*X(46)-JVS(174)*X(47)-JVS(175)*X(48)-JVS(176)*X(51)-JVS(177)*X(52)-JVS(178)*X(53)&
            &-JVS(179)*X(54)-JVS(180)*X(56)-JVS(181)*X(58)-JVS(182)*X(59)-JVS(183)*X(60)-JVS(184)*X(61)-JVS(185)*X(62)&
            &-JVS(186)*X(63)-JVS(187)*X(68)-JVS(188)*X(71)-JVS(189)*X(72)-JVS(190)*X(75)-JVS(191)*X(78)-JVS(192)*X(80)&
            &-JVS(193)*X(83)-JVS(194)*X(84)-JVS(195)*X(85)-JVS(196)*X(87)-JVS(197)*X(88)-JVS(198)*X(89)-JVS(199)*X(94)&
            &-JVS(200)*X(97)-JVS(201)*X(98)-JVS(202)*X(103)-JVS(203)*X(104)-JVS(204)*X(107)-JVS(205)*X(109)-JVS(206)*X(110)&
            &-JVS(207)*X(114)-JVS(208)*X(115)-JVS(209)*X(116)-JVS(210)*X(117)-JVS(211)*X(118)-JVS(212)*X(120)-JVS(213)&
            &*X(122)-JVS(214)*X(123)-JVS(215)*X(124)-JVS(216)*X(128)-JVS(217)*X(129)-JVS(218)*X(136)-JVS(219)*X(137)&
            &-JVS(220)*X(138)-JVS(221)*X(143)-JVS(222)*X(144)-JVS(223)*X(146)-JVS(224)*X(148))/(JVS(157))
  X(12) = (X(12)-JVS(127)*X(64)-JVS(128)*X(65)-JVS(129)*X(66)-JVS(130)*X(76)-JVS(131)*X(77)-JVS(132)*X(81)-JVS(133)&
            &*X(86)-JVS(134)*X(90)-JVS(135)*X(92)-JVS(136)*X(95)-JVS(137)*X(96)-JVS(138)*X(99)-JVS(139)*X(100)-JVS(140)&
            &*X(101)-JVS(141)*X(105)-JVS(142)*X(108)-JVS(143)*X(112)-JVS(144)*X(121)-JVS(145)*X(125)-JVS(146)*X(127)&
            &-JVS(147)*X(130)-JVS(148)*X(131)-JVS(149)*X(132)-JVS(150)*X(134)-JVS(151)*X(139)-JVS(152)*X(140)-JVS(153)&
            &*X(141)-JVS(154)*X(152)-JVS(155)*X(153)-JVS(156)*X(155))/(JVS(126))
  X(11) = (X(11)-JVS(97)*X(64)-JVS(98)*X(65)-JVS(99)*X(66)-JVS(100)*X(76)-JVS(101)*X(77)-JVS(102)*X(81)-JVS(103)*X(90)&
            &-JVS(104)*X(92)-JVS(105)*X(95)-JVS(106)*X(96)-JVS(107)*X(99)-JVS(108)*X(100)-JVS(109)*X(101)-JVS(110)*X(105)&
            &-JVS(111)*X(108)-JVS(112)*X(112)-JVS(113)*X(121)-JVS(114)*X(125)-JVS(115)*X(127)-JVS(116)*X(130)-JVS(117)&
            &*X(131)-JVS(118)*X(132)-JVS(119)*X(134)-JVS(120)*X(139)-JVS(121)*X(140)-JVS(122)*X(141)-JVS(123)*X(149)&
            &-JVS(124)*X(152)-JVS(125)*X(155))/(JVS(96))
  X(10) = (X(10)-JVS(84)*X(105)-JVS(85)*X(108)-JVS(86)*X(125)-JVS(87)*X(127)-JVS(88)*X(131)-JVS(89)*X(132)-JVS(90)&
            &*X(134)-JVS(91)*X(139)-JVS(92)*X(140)-JVS(93)*X(141)-JVS(94)*X(152)-JVS(95)*X(155))/(JVS(83))
  X(9) = (X(9)-JVS(82)*X(148))/(JVS(81))
  X(8) = (X(8)-JVS(80)*X(148))/(JVS(79))
  X(7) = (X(7)-JVS(65)*X(8)-JVS(66)*X(9)-JVS(67)*X(25)-JVS(68)*X(30)-JVS(69)*X(34)-JVS(70)*X(114)-JVS(71)*X(115)-JVS(72)&
           &*X(116)-JVS(73)*X(117)-JVS(74)*X(118)-JVS(75)*X(120)-JVS(76)*X(148)-JVS(77)*X(150)-JVS(78)*X(151))/(JVS(64))
  X(6) = (X(6)-JVS(50)*X(8)-JVS(51)*X(9)-JVS(52)*X(25)-JVS(53)*X(30)-JVS(54)*X(34)-JVS(55)*X(114)-JVS(56)*X(115)-JVS(57)&
           &*X(116)-JVS(58)*X(117)-JVS(59)*X(118)-JVS(60)*X(120)-JVS(61)*X(148)-JVS(62)*X(150)-JVS(63)*X(151))/(JVS(49))
  X(5) = (X(5)-JVS(36)*X(8)-JVS(37)*X(9)-JVS(38)*X(25)-JVS(39)*X(30)-JVS(40)*X(34)-JVS(41)*X(114)-JVS(42)*X(115)-JVS(43)&
           &*X(116)-JVS(44)*X(117)-JVS(45)*X(118)-JVS(46)*X(120)-JVS(47)*X(148)-JVS(48)*X(151))/(JVS(35))
  X(4) = (X(4)-JVS(22)*X(8)-JVS(23)*X(9)-JVS(24)*X(25)-JVS(25)*X(30)-JVS(26)*X(34)-JVS(27)*X(114)-JVS(28)*X(115)-JVS(29)&
           &*X(116)-JVS(30)*X(117)-JVS(31)*X(118)-JVS(32)*X(120)-JVS(33)*X(148)-JVS(34)*X(151))/(JVS(21))
  X(3) = (X(3)-JVS(8)*X(8)-JVS(9)*X(9)-JVS(10)*X(25)-JVS(11)*X(30)-JVS(12)*X(34)-JVS(13)*X(114)-JVS(14)*X(115)-JVS(15)&
           &*X(116)-JVS(16)*X(117)-JVS(17)*X(118)-JVS(18)*X(120)-JVS(19)*X(148)-JVS(20)*X(151))/(JVS(7))
  X(2) = (X(2)-JVS(5)*X(19)-JVS(6)*X(148))/(JVS(4))
  X(1) = (X(1)-JVS(2)*X(43)-JVS(3)*X(149))/(JVS(1))
      
END SUBROUTINE KppSolve

! End of KppSolve function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolveTR - sparse, transposed back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
!      XX        - Vector for output variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolveTR ( JVS, X, XX )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)
! XX - Vector for output variables
  REAL(kind=dp) :: XX(NVAR)

  XX(1) = X(1)/JVS(1)
  XX(2) = X(2)/JVS(4)
  XX(3) = X(3)/JVS(7)
  XX(4) = X(4)/JVS(21)
  XX(5) = X(5)/JVS(35)
  XX(6) = X(6)/JVS(49)
  XX(7) = X(7)/JVS(64)
  XX(8) = (X(8)-JVS(8)*XX(3)-JVS(22)*XX(4)-JVS(36)*XX(5)-JVS(50)*XX(6)-JVS(65)*XX(7))/(JVS(79))
  XX(9) = (X(9)-JVS(9)*XX(3)-JVS(23)*XX(4)-JVS(37)*XX(5)-JVS(51)*XX(6)-JVS(66)*XX(7))/(JVS(81))
  XX(10) = X(10)/JVS(83)
  XX(11) = X(11)/JVS(96)
  XX(12) = X(12)/JVS(126)
  XX(13) = X(13)/JVS(157)
  XX(14) = X(14)/JVS(225)
  XX(15) = (X(15)-JVS(158)*XX(13))/(JVS(227))
  XX(16) = (X(16)-JVS(159)*XX(13))/(JVS(229))
  XX(17) = (X(17)-JVS(160)*XX(13))/(JVS(231))
  XX(18) = X(18)/JVS(233)
  XX(19) = (X(19)-JVS(5)*XX(2))/(JVS(235))
  XX(20) = X(20)/JVS(239)
  XX(21) = (X(21)-JVS(161)*XX(13))/(JVS(242))
  XX(22) = X(22)/JVS(245)
  XX(23) = X(23)/JVS(250)
  XX(24) = (X(24)-JVS(162)*XX(13))/(JVS(253))
  XX(25) = (X(25)-JVS(10)*XX(3)-JVS(24)*XX(4)-JVS(38)*XX(5)-JVS(52)*XX(6)-JVS(67)*XX(7)-JVS(163)*XX(13))/(JVS(255))
  XX(26) = X(26)/JVS(258)
  XX(27) = (X(27)-JVS(164)*XX(13))/(JVS(261))
  XX(28) = (X(28)-JVS(165)*XX(13))/(JVS(263))
  XX(29) = X(29)/JVS(266)
  XX(30) = (X(30)-JVS(11)*XX(3)-JVS(25)*XX(4)-JVS(39)*XX(5)-JVS(53)*XX(6)-JVS(68)*XX(7)-JVS(166)*XX(13))/(JVS(269))
  XX(31) = (X(31)-JVS(167)*XX(13))/(JVS(272))
  XX(32) = X(32)/JVS(275)
  XX(33) = (X(33)-JVS(168)*XX(13))/(JVS(278))
  XX(34) = (X(34)-JVS(12)*XX(3)-JVS(26)*XX(4)-JVS(40)*XX(5)-JVS(54)*XX(6)-JVS(69)*XX(7)-JVS(169)*XX(13)-JVS(276)*XX(32))&
             &/(JVS(282))
  XX(35) = X(35)/JVS(285)
  XX(36) = (X(36)-JVS(236)*XX(19))/(JVS(287))
  XX(37) = (X(37)-JVS(170)*XX(13))/(JVS(290))
  XX(38) = X(38)/JVS(293)
  XX(39) = X(39)/JVS(298)
  XX(40) = (X(40)-JVS(171)*XX(13))/(JVS(302))
  XX(41) = (X(41)-JVS(172)*XX(13))/(JVS(306))
  XX(42) = X(42)/JVS(311)
  XX(43) = (X(43)-JVS(2)*XX(1))/(JVS(315))
  XX(44) = X(44)/JVS(318)
  XX(45) = X(45)/JVS(324)
  XX(46) = (X(46)-JVS(173)*XX(13))/(JVS(328))
  XX(47) = (X(47)-JVS(174)*XX(13))/(JVS(335))
  XX(48) = (X(48)-JVS(175)*XX(13))/(JVS(339))
  XX(49) = X(49)/JVS(343)
  XX(50) = (X(50)-JVS(294)*XX(38))/(JVS(347))
  XX(51) = (X(51)-JVS(176)*XX(13))/(JVS(351))
  XX(52) = (X(52)-JVS(177)*XX(13))/(JVS(355))
  XX(53) = (X(53)-JVS(178)*XX(13))/(JVS(359))
  XX(54) = (X(54)-JVS(179)*XX(13))/(JVS(363))
  XX(55) = X(55)/JVS(367)
  XX(56) = (X(56)-JVS(180)*XX(13))/(JVS(371))
  XX(57) = X(57)/JVS(375)
  XX(58) = (X(58)-JVS(181)*XX(13))/(JVS(379))
  XX(59) = (X(59)-JVS(182)*XX(13))/(JVS(387))
  XX(60) = (X(60)-JVS(183)*XX(13))/(JVS(390))
  XX(61) = (X(61)-JVS(184)*XX(13))/(JVS(393))
  XX(62) = (X(62)-JVS(185)*XX(13))/(JVS(401))
  XX(63) = (X(63)-JVS(186)*XX(13))/(JVS(405))
  XX(64) = (X(64)-JVS(97)*XX(11)-JVS(127)*XX(12)-JVS(295)*XX(38)-JVS(348)*XX(50))/(JVS(412))
  XX(65) = (X(65)-JVS(98)*XX(11)-JVS(128)*XX(12))/(JVS(416))
  XX(66) = (X(66)-JVS(99)*XX(11)-JVS(129)*XX(12)-JVS(364)*XX(54))/(JVS(423))
  XX(67) = X(67)/JVS(427)
  XX(68) = (X(68)-JVS(187)*XX(13))/(JVS(431))
  XX(69) = X(69)/JVS(438)
  XX(70) = X(70)/JVS(449)
  XX(71) = (X(71)-JVS(188)*XX(13))/(JVS(456))
  XX(72) = (X(72)-JVS(189)*XX(13))/(JVS(460))
  XX(73) = X(73)/JVS(468)
  XX(74) = X(74)/JVS(475)
  XX(75) = (X(75)-JVS(190)*XX(13))/(JVS(479))
  XX(76) = (X(76)-JVS(100)*XX(11)-JVS(130)*XX(12)-JVS(428)*XX(67)-JVS(439)*XX(69))/(JVS(485))
  XX(77) = (X(77)-JVS(101)*XX(11)-JVS(131)*XX(12)-JVS(406)*XX(63))/(JVS(491))
  XX(78) = (X(78)-JVS(191)*XX(13))/(JVS(495))
  XX(79) = X(79)/JVS(501)
  XX(80) = (X(80)-JVS(192)*XX(13))/(JVS(506))
  XX(81) = (X(81)-JVS(102)*XX(11)-JVS(132)*XX(12)-JVS(251)*XX(23))/(JVS(516))
  XX(82) = X(82)/JVS(521)
  XX(83) = (X(83)-JVS(193)*XX(13))/(JVS(527))
  XX(84) = (X(84)-JVS(194)*XX(13))/(JVS(531))
  XX(85) = (X(85)-JVS(195)*XX(13))/(JVS(535))
  XX(86) = (X(86)-JVS(133)*XX(12))/(JVS(540))
  XX(87) = (X(87)-JVS(196)*XX(13)-JVS(522)*XX(82))/(JVS(544))
  XX(88) = (X(88)-JVS(197)*XX(13))/(JVS(549))
  XX(89) = (X(89)-JVS(198)*XX(13)-JVS(319)*XX(44)-JVS(440)*XX(69))/(JVS(553))
  XX(90) = (X(90)-JVS(103)*XX(11)-JVS(134)*XX(12)-JVS(240)*XX(20)-JVS(312)*XX(42))/(JVS(558))
  XX(91) = X(91)/JVS(565)
  XX(92) = (X(92)-JVS(104)*XX(11)-JVS(135)*XX(12)-JVS(307)*XX(41)-JVS(469)*XX(73))/(JVS(577))
  XX(93) = (X(93)-JVS(496)*XX(78))/(JVS(583))
  XX(94) = (X(94)-JVS(199)*XX(13)-JVS(497)*XX(78))/(JVS(587))
  XX(95) = (X(95)-JVS(105)*XX(11)-JVS(136)*XX(12)-JVS(344)*XX(49))/(JVS(595))
  XX(96) = (X(96)-JVS(106)*XX(11)-JVS(137)*XX(12)-JVS(476)*XX(74))/(JVS(601))
  XX(97) = (X(97)-JVS(200)*XX(13)-JVS(243)*XX(21))/(JVS(607))
  XX(98) = (X(98)-JVS(201)*XX(13)-JVS(320)*XX(44)-JVS(376)*XX(57)-JVS(441)*XX(69)-JVS(566)*XX(91))/(JVS(613))
  XX(99) = (X(99)-JVS(107)*XX(11)-JVS(138)*XX(12)-JVS(321)*XX(44)-JVS(442)*XX(69)-JVS(554)*XX(89)-JVS(567)*XX(91))&
             &/(JVS(619))
  XX(100) = (X(100)-JVS(108)*XX(11)-JVS(139)*XX(12))/(JVS(628))
  XX(101) = (X(101)-JVS(109)*XX(11)-JVS(140)*XX(12)-JVS(322)*XX(44)-JVS(377)*XX(57)-JVS(443)*XX(69)-JVS(568)*XX(91)&
              &-JVS(614)*XX(98)-JVS(629)*XX(100))/(JVS(636))
  XX(102) = X(102)/JVS(645)
  XX(103) = (X(103)-JVS(202)*XX(13))/(JVS(653))
  XX(104) = (X(104)-JVS(203)*XX(13)-JVS(654)*XX(103))/(JVS(669))
  XX(105) = (X(105)-JVS(84)*XX(10)-JVS(110)*XX(11)-JVS(141)*XX(12)-JVS(372)*XX(56))/(JVS(675))
  XX(106) = (X(106)-JVS(234)*XX(18)-JVS(264)*XX(28)-JVS(523)*XX(82)-JVS(545)*XX(87))/(JVS(684))
  XX(107) = (X(107)-JVS(204)*XX(13))/(JVS(690))
  XX(108) = (X(108)-JVS(85)*XX(10)-JVS(111)*XX(11)-JVS(142)*XX(12)-JVS(303)*XX(40)-JVS(360)*XX(53)-JVS(691)*XX(107))&
              &/(JVS(709))
  XX(109) = (X(109)-JVS(205)*XX(13))/(JVS(728))
  XX(110) = (X(110)-JVS(206)*XX(13)-JVS(569)*XX(91)-JVS(729)*XX(109))/(JVS(742))
  XX(111) = (X(111)-JVS(730)*XX(109))/(JVS(750))
  XX(112) = (X(112)-JVS(112)*XX(11)-JVS(143)*XX(12))/(JVS(760))
  XX(113) = (X(113)-JVS(502)*XX(79))/(JVS(769))
  XX(114) = (X(114)-JVS(13)*XX(3)-JVS(27)*XX(4)-JVS(41)*XX(5)-JVS(55)*XX(6)-JVS(70)*XX(7)-JVS(207)*XX(13)-JVS(655)&
              &*XX(103))/(JVS(777))
  XX(115) = (X(115)-JVS(14)*XX(3)-JVS(28)*XX(4)-JVS(42)*XX(5)-JVS(56)*XX(6)-JVS(71)*XX(7)-JVS(208)*XX(13)-JVS(380)&
              &*XX(58)-JVS(656)*XX(103)-JVS(751)*XX(111))/(JVS(781))
  XX(116) = (X(116)-JVS(15)*XX(3)-JVS(29)*XX(4)-JVS(43)*XX(5)-JVS(57)*XX(6)-JVS(72)*XX(7)-JVS(209)*XX(13)-JVS(381)&
              &*XX(58)-JVS(657)*XX(103)-JVS(752)*XX(111))/(JVS(785))
  XX(117) = (X(117)-JVS(16)*XX(3)-JVS(30)*XX(4)-JVS(44)*XX(5)-JVS(58)*XX(6)-JVS(73)*XX(7)-JVS(210)*XX(13)-JVS(382)&
              &*XX(58)-JVS(658)*XX(103)-JVS(753)*XX(111))/(JVS(789))
  XX(118) = (X(118)-JVS(17)*XX(3)-JVS(31)*XX(4)-JVS(45)*XX(5)-JVS(59)*XX(6)-JVS(74)*XX(7)-JVS(211)*XX(13)-JVS(383)&
              &*XX(58)-JVS(659)*XX(103)-JVS(754)*XX(111))/(JVS(793))
  XX(119) = X(119)/JVS(801)
  XX(120) = (X(120)-JVS(18)*XX(3)-JVS(32)*XX(4)-JVS(46)*XX(5)-JVS(60)*XX(6)-JVS(75)*XX(7)-JVS(212)*XX(13)-JVS(384)&
              &*XX(58)-JVS(660)*XX(103)-JVS(755)*XX(111))/(JVS(811))
  XX(121) = (X(121)-JVS(113)*XX(11)-JVS(144)*XX(12)-JVS(498)*XX(78)-JVS(584)*XX(93)-JVS(588)*XX(94)-JVS(596)*XX(95)&
              &-JVS(710)*XX(108))/(JVS(822))
  XX(122) = (X(122)-JVS(213)*XX(13))/(JVS(847))
  XX(123) = (X(123)-JVS(214)*XX(13))/(JVS(883))
  XX(124) = (X(124)-JVS(215)*XX(13)-JVS(731)*XX(109)-JVS(884)*XX(123))/(JVS(917))
  XX(125) = (X(125)-JVS(86)*XX(10)-JVS(114)*XX(11)-JVS(145)*XX(12)-JVS(528)*XX(83)-JVS(692)*XX(107)-JVS(770)*XX(113)&
              &-JVS(848)*XX(122)-JVS(885)*XX(123)-JVS(918)*XX(124))/(JVS(935))
  XX(126) = (X(126)-JVS(849)*XX(122)-JVS(886)*XX(123))/(JVS(948))
  XX(127) = (X(127)-JVS(87)*XX(10)-JVS(115)*XX(11)-JVS(146)*XX(12)-JVS(246)*XX(22)-JVS(550)*XX(88)-JVS(693)*XX(107)&
              &-JVS(850)*XX(122)-JVS(887)*XX(123)-JVS(919)*XX(124)-JVS(949)*XX(126))/(JVS(958))
  XX(128) = (X(128)-JVS(216)*XX(13)-JVS(394)*XX(61)-JVS(546)*XX(87)-JVS(602)*XX(96)-JVS(661)*XX(103)-JVS(685)*XX(106)&
              &-JVS(802)*XX(119)-JVS(888)*XX(123))/(JVS(966))
  XX(129) = (X(129)-JVS(217)*XX(13)-JVS(450)*XX(70)-JVS(889)*XX(123))/(JVS(985))
  XX(130) = (X(130)-JVS(116)*XX(11)-JVS(147)*XX(12)-JVS(732)*XX(109)-JVS(890)*XX(123))/(JVS(999))
  XX(131) = (X(131)-JVS(88)*XX(10)-JVS(117)*XX(11)-JVS(148)*XX(12)-JVS(480)*XX(75)-JVS(507)*XX(80)-JVS(694)*XX(107)&
              &-JVS(851)*XX(122))/(JVS(1015))
  XX(132) = (X(132)-JVS(89)*XX(10)-JVS(118)*XX(11)-JVS(149)*XX(12)-JVS(356)*XX(52)-JVS(508)*XX(80)-JVS(695)*XX(107))&
              &/(JVS(1028))
  XX(133) = (X(133)-JVS(891)*XX(123)-JVS(950)*XX(126)-JVS(959)*XX(127)-JVS(1029)*XX(132))/(JVS(1046))
  XX(134) = (X(134)-JVS(90)*XX(10)-JVS(119)*XX(11)-JVS(150)*XX(12)-JVS(368)*XX(55)-JVS(696)*XX(107))/(JVS(1065))
  XX(135) = (X(135)-JVS(299)*XX(39)-JVS(524)*XX(82)-JVS(686)*XX(106)-JVS(892)*XX(123))/(JVS(1078))
  XX(136) = (X(136)-JVS(218)*XX(13))/(JVS(1094))
  XX(137) = (X(137)-JVS(219)*XX(13)-JVS(247)*XX(22)-JVS(852)*XX(122)-JVS(893)*XX(123)-JVS(920)*XX(124)-JVS(986)*XX(129)&
              &-JVS(1066)*XX(134)-JVS(1095)*XX(136))/(JVS(1114))
  XX(138) = (X(138)-JVS(220)*XX(13)-JVS(451)*XX(70)-JVS(894)*XX(123))/(JVS(1143))
  XX(139) = (X(139)-JVS(91)*XX(10)-JVS(120)*XX(11)-JVS(151)*XX(12)-JVS(279)*XX(33)-JVS(697)*XX(107)-JVS(733)*XX(109)&
              &-JVS(895)*XX(123)-JVS(921)*XX(124)-JVS(1096)*XX(136)-JVS(1144)*XX(138))/(JVS(1165))
  XX(140) = (X(140)-JVS(92)*XX(10)-JVS(121)*XX(11)-JVS(152)*XX(12)-JVS(536)*XX(85)-JVS(608)*XX(97)-JVS(698)*XX(107)&
              &-JVS(922)*XX(124)-JVS(1097)*XX(136)-JVS(1115)*XX(137)-JVS(1145)*XX(138)-JVS(1166)*XX(139))/(JVS(1176))
  XX(141) = (X(141)-JVS(93)*XX(10)-JVS(122)*XX(11)-JVS(153)*XX(12)-JVS(291)*XX(37)-JVS(329)*XX(46)-JVS(461)*XX(72)&
              &-JVS(570)*XX(91)-JVS(609)*XX(97)-JVS(699)*XX(107)-JVS(734)*XX(109)-JVS(803)*XX(119)-JVS(896)*XX(123)-JVS(923)&
              &*XX(124)-JVS(1000)*XX(130)-JVS(1098)*XX(136)-JVS(1116)*XX(137)-JVS(1146)*XX(138)-JVS(1167)*XX(139))&
              &/(JVS(1185))
  XX(142) = (X(142)-JVS(352)*XX(51)-JVS(402)*XX(62)-JVS(610)*XX(97)-JVS(700)*XX(107)-JVS(743)*XX(110)-JVS(804)*XX(119)&
              &-JVS(897)*XX(123)-JVS(924)*XX(124)-JVS(1001)*XX(130)-JVS(1147)*XX(138)-JVS(1168)*XX(139))/(JVS(1194))
  XX(143) = (X(143)-JVS(221)*XX(13)-JVS(662)*XX(103)-JVS(898)*XX(123)-JVS(1148)*XX(138))/(JVS(1207))
  XX(144) = (X(144)-JVS(222)*XX(13)-JVS(663)*XX(103)-JVS(899)*XX(123)-JVS(967)*XX(128)-JVS(987)*XX(129)-JVS(1079)&
              &*XX(135)-JVS(1099)*XX(136)-JVS(1149)*XX(138))/(JVS(1220))
  XX(145) = (X(145)-JVS(340)*XX(48)-JVS(701)*XX(107)-JVS(900)*XX(123)-JVS(925)*XX(124)-JVS(1100)*XX(136)-JVS(1117)&
              &*XX(137)-JVS(1150)*XX(138))/(JVS(1231))
  XX(146) = (X(146)-JVS(223)*XX(13)-JVS(417)*XX(65)-JVS(452)*XX(70)-JVS(525)*XX(82)-JVS(664)*XX(103)-JVS(687)*XX(106)&
              &-JVS(901)*XX(123)-JVS(1080)*XX(135))/(JVS(1293))
  XX(147) = (X(147)-JVS(252)*XX(23)-JVS(267)*XX(29)-JVS(325)*XX(45)-JVS(453)*XX(70)-JVS(457)*XX(71)-JVS(470)*XX(73)&
              &-JVS(517)*XX(81)-JVS(532)*XX(84)-JVS(578)*XX(92)-JVS(630)*XX(100)-JVS(646)*XX(102)-JVS(735)*XX(109)-JVS(902)&
              &*XX(123)-JVS(1002)*XX(130)-JVS(1081)*XX(135)-JVS(1101)*XX(136)-JVS(1151)*XX(138)-JVS(1294)*XX(146))&
              &/(JVS(1361))
  XX(148) = (X(148)-JVS(6)*XX(2)-JVS(19)*XX(3)-JVS(33)*XX(4)-JVS(47)*XX(5)-JVS(61)*XX(6)-JVS(76)*XX(7)-JVS(80)*XX(8)&
              &-JVS(82)*XX(9)-JVS(224)*XX(13)-JVS(226)*XX(14)-JVS(228)*XX(15)-JVS(230)*XX(16)-JVS(232)*XX(17)-JVS(237)&
              &*XX(19)-JVS(244)*XX(21)-JVS(248)*XX(22)-JVS(254)*XX(24)-JVS(256)*XX(25)-JVS(259)*XX(26)-JVS(262)*XX(27)&
              &-JVS(265)*XX(28)-JVS(270)*XX(30)-JVS(273)*XX(31)-JVS(277)*XX(32)-JVS(280)*XX(33)-JVS(283)*XX(34)-JVS(286)&
              &*XX(35)-JVS(288)*XX(36)-JVS(292)*XX(37)-JVS(296)*XX(38)-JVS(300)*XX(39)-JVS(304)*XX(40)-JVS(308)*XX(41)&
              &-JVS(326)*XX(45)-JVS(330)*XX(46)-JVS(336)*XX(47)-JVS(341)*XX(48)-JVS(345)*XX(49)-JVS(349)*XX(50)-JVS(353)&
              &*XX(51)-JVS(357)*XX(52)-JVS(361)*XX(53)-JVS(365)*XX(54)-JVS(369)*XX(55)-JVS(373)*XX(56)-JVS(385)*XX(58)&
              &-JVS(388)*XX(59)-JVS(391)*XX(60)-JVS(395)*XX(61)-JVS(403)*XX(62)-JVS(407)*XX(63)-JVS(413)*XX(64)-JVS(424)&
              &*XX(66)-JVS(429)*XX(67)-JVS(432)*XX(68)-JVS(444)*XX(69)-JVS(454)*XX(70)-JVS(458)*XX(71)-JVS(462)*XX(72)&
              &-JVS(471)*XX(73)-JVS(477)*XX(74)-JVS(481)*XX(75)-JVS(486)*XX(76)-JVS(492)*XX(77)-JVS(499)*XX(78)-JVS(503)&
              &*XX(79)-JVS(509)*XX(80)-JVS(518)*XX(81)-JVS(526)*XX(82)-JVS(529)*XX(83)-JVS(533)*XX(84)-JVS(537)*XX(85)&
              &-JVS(541)*XX(86)-JVS(547)*XX(87)-JVS(551)*XX(88)-JVS(555)*XX(89)-JVS(559)*XX(90)-JVS(571)*XX(91)-JVS(579)&
              &*XX(92)-JVS(585)*XX(93)-JVS(589)*XX(94)-JVS(597)*XX(95)-JVS(603)*XX(96)-JVS(611)*XX(97)-JVS(615)*XX(98)&
              &-JVS(620)*XX(99)-JVS(631)*XX(100)-JVS(637)*XX(101)-JVS(647)*XX(102)-JVS(665)*XX(103)-JVS(670)*XX(104)&
              &-JVS(676)*XX(105)-JVS(688)*XX(106)-JVS(702)*XX(107)-JVS(711)*XX(108)-JVS(736)*XX(109)-JVS(744)*XX(110)&
              &-JVS(761)*XX(112)-JVS(771)*XX(113)-JVS(778)*XX(114)-JVS(782)*XX(115)-JVS(786)*XX(116)-JVS(790)*XX(117)&
              &-JVS(794)*XX(118)-JVS(805)*XX(119)-JVS(812)*XX(120)-JVS(823)*XX(121)-JVS(853)*XX(122)-JVS(903)*XX(123)&
              &-JVS(926)*XX(124)-JVS(936)*XX(125)-JVS(951)*XX(126)-JVS(960)*XX(127)-JVS(968)*XX(128)-JVS(988)*XX(129)&
              &-JVS(1003)*XX(130)-JVS(1016)*XX(131)-JVS(1030)*XX(132)-JVS(1047)*XX(133)-JVS(1067)*XX(134)-JVS(1082)*XX(135)&
              &-JVS(1102)*XX(136)-JVS(1118)*XX(137)-JVS(1152)*XX(138)-JVS(1169)*XX(139)-JVS(1177)*XX(140)-JVS(1186)*XX(141)&
              &-JVS(1195)*XX(142)-JVS(1208)*XX(143)-JVS(1221)*XX(144)-JVS(1232)*XX(145)-JVS(1295)*XX(146)-JVS(1362)*XX(147))&
              &/(JVS(1487))
  XX(149) = (X(149)-JVS(3)*XX(1)-JVS(123)*XX(11)-JVS(241)*XX(20)-JVS(281)*XX(33)-JVS(301)*XX(39)-JVS(309)*XX(41)&
              &-JVS(313)*XX(42)-JVS(316)*XX(43)-JVS(327)*XX(45)-JVS(337)*XX(47)-JVS(342)*XX(48)-JVS(346)*XX(49)-JVS(350)&
              &*XX(50)-JVS(358)*XX(52)-JVS(362)*XX(53)-JVS(366)*XX(54)-JVS(370)*XX(55)-JVS(374)*XX(56)-JVS(396)*XX(61)&
              &-JVS(404)*XX(62)-JVS(408)*XX(63)-JVS(414)*XX(64)-JVS(418)*XX(65)-JVS(425)*XX(66)-JVS(430)*XX(67)-JVS(433)&
              &*XX(68)-JVS(445)*XX(69)-JVS(472)*XX(73)-JVS(478)*XX(74)-JVS(482)*XX(75)-JVS(487)*XX(76)-JVS(493)*XX(77)&
              &-JVS(504)*XX(79)-JVS(519)*XX(81)-JVS(530)*XX(83)-JVS(552)*XX(88)-JVS(556)*XX(89)-JVS(560)*XX(90)-JVS(572)&
              &*XX(91)-JVS(580)*XX(92)-JVS(590)*XX(94)-JVS(598)*XX(95)-JVS(604)*XX(96)-JVS(612)*XX(97)-JVS(616)*XX(98)&
              &-JVS(621)*XX(99)-JVS(632)*XX(100)-JVS(638)*XX(101)-JVS(648)*XX(102)-JVS(666)*XX(103)-JVS(677)*XX(105)&
              &-JVS(712)*XX(108)-JVS(737)*XX(109)-JVS(756)*XX(111)-JVS(762)*XX(112)-JVS(772)*XX(113)-JVS(806)*XX(119)&
              &-JVS(824)*XX(121)-JVS(854)*XX(122)-JVS(904)*XX(123)-JVS(927)*XX(124)-JVS(937)*XX(125)-JVS(952)*XX(126)&
              &-JVS(961)*XX(127)-JVS(989)*XX(129)-JVS(1004)*XX(130)-JVS(1017)*XX(131)-JVS(1031)*XX(132)-JVS(1048)*XX(133)&
              &-JVS(1068)*XX(134)-JVS(1083)*XX(135)-JVS(1103)*XX(136)-JVS(1119)*XX(137)-JVS(1153)*XX(138)-JVS(1170)*XX(139)&
              &-JVS(1178)*XX(140)-JVS(1187)*XX(141)-JVS(1196)*XX(142)-JVS(1209)*XX(143)-JVS(1222)*XX(144)-JVS(1233)*XX(145)&
              &-JVS(1296)*XX(146)-JVS(1363)*XX(147)-JVS(1488)*XX(148))/(JVS(1603))
  XX(150) = (X(150)-JVS(62)*XX(6)-JVS(77)*XX(7)-JVS(238)*XX(19)-JVS(268)*XX(29)-JVS(289)*XX(36)-JVS(331)*XX(46)-JVS(389)&
              &*XX(59)-JVS(455)*XX(70)-JVS(542)*XX(86)-JVS(671)*XX(104)-JVS(738)*XX(109)-JVS(745)*XX(110)-JVS(763)*XX(112)&
              &-JVS(773)*XX(113)-JVS(779)*XX(114)-JVS(783)*XX(115)-JVS(787)*XX(116)-JVS(791)*XX(117)-JVS(795)*XX(118)&
              &-JVS(807)*XX(119)-JVS(813)*XX(120)-JVS(825)*XX(121)-JVS(855)*XX(122)-JVS(905)*XX(123)-JVS(928)*XX(124)&
              &-JVS(938)*XX(125)-JVS(953)*XX(126)-JVS(962)*XX(127)-JVS(969)*XX(128)-JVS(990)*XX(129)-JVS(1005)*XX(130)&
              &-JVS(1018)*XX(131)-JVS(1032)*XX(132)-JVS(1049)*XX(133)-JVS(1069)*XX(134)-JVS(1084)*XX(135)-JVS(1104)*XX(136)&
              &-JVS(1120)*XX(137)-JVS(1154)*XX(138)-JVS(1171)*XX(139)-JVS(1179)*XX(140)-JVS(1188)*XX(141)-JVS(1197)*XX(142)&
              &-JVS(1210)*XX(143)-JVS(1223)*XX(144)-JVS(1234)*XX(145)-JVS(1297)*XX(146)-JVS(1364)*XX(147)-JVS(1489)*XX(148)&
              &-JVS(1604)*XX(149))/(JVS(1643))
  XX(151) = (X(151)-JVS(20)*XX(3)-JVS(34)*XX(4)-JVS(48)*XX(5)-JVS(63)*XX(6)-JVS(78)*XX(7)-JVS(386)*XX(58)-JVS(392)&
              &*XX(60)-JVS(397)*XX(61)-JVS(473)*XX(73)-JVS(548)*XX(87)-JVS(561)*XX(90)-JVS(581)*XX(92)-JVS(667)*XX(103)&
              &-JVS(672)*XX(104)-JVS(689)*XX(106)-JVS(757)*XX(111)-JVS(764)*XX(112)-JVS(774)*XX(113)-JVS(780)*XX(114)&
              &-JVS(784)*XX(115)-JVS(788)*XX(116)-JVS(792)*XX(117)-JVS(796)*XX(118)-JVS(814)*XX(120)-JVS(826)*XX(121)&
              &-JVS(856)*XX(122)-JVS(906)*XX(123)-JVS(929)*XX(124)-JVS(939)*XX(125)-JVS(954)*XX(126)-JVS(970)*XX(128)&
              &-JVS(991)*XX(129)-JVS(1019)*XX(131)-JVS(1033)*XX(132)-JVS(1050)*XX(133)-JVS(1070)*XX(134)-JVS(1085)*XX(135)&
              &-JVS(1105)*XX(136)-JVS(1121)*XX(137)-JVS(1155)*XX(138)-JVS(1180)*XX(140)-JVS(1189)*XX(141)-JVS(1198)*XX(142)&
              &-JVS(1211)*XX(143)-JVS(1224)*XX(144)-JVS(1235)*XX(145)-JVS(1298)*XX(146)-JVS(1365)*XX(147)-JVS(1490)*XX(148)&
              &-JVS(1605)*XX(149)-JVS(1644)*XX(150))/(JVS(1669))
  XX(152) = (X(152)-JVS(94)*XX(10)-JVS(124)*XX(11)-JVS(154)*XX(12)-JVS(332)*XX(46)-JVS(398)*XX(61)-JVS(434)*XX(68)&
              &-JVS(459)*XX(71)-JVS(739)*XX(109)-JVS(746)*XX(110)-JVS(808)*XX(119)-JVS(907)*XX(123)-JVS(930)*XX(124)&
              &-JVS(1006)*XX(130)-JVS(1106)*XX(136)-JVS(1156)*XX(138)-JVS(1172)*XX(139)-JVS(1181)*XX(140)-JVS(1190)*XX(141)&
              &-JVS(1199)*XX(142)-JVS(1212)*XX(143)-JVS(1225)*XX(144)-JVS(1236)*XX(145)-JVS(1299)*XX(146)-JVS(1366)*XX(147)&
              &-JVS(1491)*XX(148)-JVS(1606)*XX(149)-JVS(1645)*XX(150)-JVS(1670)*XX(151))/(JVS(1720))
  XX(153) = (X(153)-JVS(155)*XX(12)-JVS(249)*XX(22)-JVS(297)*XX(38)-JVS(314)*XX(42)-JVS(317)*XX(43)-JVS(323)*XX(44)&
              &-JVS(333)*XX(46)-JVS(378)*XX(57)-JVS(415)*XX(64)-JVS(419)*XX(65)-JVS(426)*XX(66)-JVS(446)*XX(69)-JVS(463)&
              &*XX(72)-JVS(474)*XX(73)-JVS(488)*XX(76)-JVS(494)*XX(77)-JVS(500)*XX(78)-JVS(505)*XX(79)-JVS(510)*XX(80)&
              &-JVS(520)*XX(81)-JVS(538)*XX(85)-JVS(543)*XX(86)-JVS(562)*XX(90)-JVS(573)*XX(91)-JVS(582)*XX(92)-JVS(586)&
              &*XX(93)-JVS(599)*XX(95)-JVS(605)*XX(96)-JVS(622)*XX(99)-JVS(633)*XX(100)-JVS(639)*XX(101)-JVS(649)*XX(102)&
              &-JVS(668)*XX(103)-JVS(678)*XX(105)-JVS(713)*XX(108)-JVS(740)*XX(109)-JVS(747)*XX(110)-JVS(758)*XX(111)&
              &-JVS(765)*XX(112)-JVS(775)*XX(113)-JVS(809)*XX(119)-JVS(827)*XX(121)-JVS(857)*XX(122)-JVS(908)*XX(123)&
              &-JVS(931)*XX(124)-JVS(940)*XX(125)-JVS(955)*XX(126)-JVS(963)*XX(127)-JVS(992)*XX(129)-JVS(1007)*XX(130)&
              &-JVS(1020)*XX(131)-JVS(1034)*XX(132)-JVS(1051)*XX(133)-JVS(1071)*XX(134)-JVS(1086)*XX(135)-JVS(1107)*XX(136)&
              &-JVS(1122)*XX(137)-JVS(1157)*XX(138)-JVS(1173)*XX(139)-JVS(1182)*XX(140)-JVS(1191)*XX(141)-JVS(1200)*XX(142)&
              &-JVS(1213)*XX(143)-JVS(1226)*XX(144)-JVS(1237)*XX(145)-JVS(1300)*XX(146)-JVS(1367)*XX(147)-JVS(1492)*XX(148)&
              &-JVS(1607)*XX(149)-JVS(1646)*XX(150)-JVS(1671)*XX(151)-JVS(1721)*XX(152))/(JVS(1771))
  XX(154) = (X(154)-JVS(399)*XX(61)-JVS(435)*XX(68)-JVS(534)*XX(84)-JVS(1108)*XX(136)-JVS(1158)*XX(138)-JVS(1301)&
              &*XX(146)-JVS(1368)*XX(147)-JVS(1493)*XX(148)-JVS(1608)*XX(149)-JVS(1647)*XX(150)-JVS(1672)*XX(151)-JVS(1722)&
              &*XX(152)-JVS(1772)*XX(153))/(JVS(1785))
  XX(155) = (X(155)-JVS(95)*XX(10)-JVS(125)*XX(11)-JVS(156)*XX(12)-JVS(305)*XX(40)-JVS(334)*XX(46)-JVS(338)*XX(47)&
              &-JVS(354)*XX(51)-JVS(400)*XX(61)-JVS(511)*XX(80)-JVS(679)*XX(105)-JVS(703)*XX(107)-JVS(714)*XX(108)-JVS(741)&
              &*XX(109)-JVS(748)*XX(110)-JVS(776)*XX(113)-JVS(810)*XX(119)-JVS(858)*XX(122)-JVS(909)*XX(123)-JVS(932)&
              &*XX(124)-JVS(941)*XX(125)-JVS(956)*XX(126)-JVS(964)*XX(127)-JVS(993)*XX(129)-JVS(1008)*XX(130)-JVS(1021)&
              &*XX(131)-JVS(1035)*XX(132)-JVS(1052)*XX(133)-JVS(1072)*XX(134)-JVS(1109)*XX(136)-JVS(1159)*XX(138)-JVS(1174)&
              &*XX(139)-JVS(1183)*XX(140)-JVS(1192)*XX(141)-JVS(1201)*XX(142)-JVS(1214)*XX(143)-JVS(1227)*XX(144)-JVS(1238)&
              &*XX(145)-JVS(1302)*XX(146)-JVS(1369)*XX(147)-JVS(1494)*XX(148)-JVS(1609)*XX(149)-JVS(1648)*XX(150)-JVS(1673)&
              &*XX(151)-JVS(1723)*XX(152)-JVS(1773)*XX(153)-JVS(1786)*XX(154))/(JVS(1826))
  XX(155) = XX(155)
  XX(154) = XX(154)-JVS(1825)*XX(155)
  XX(153) = XX(153)-JVS(1784)*XX(154)-JVS(1824)*XX(155)
  XX(152) = XX(152)-JVS(1770)*XX(153)-JVS(1783)*XX(154)-JVS(1823)*XX(155)
  XX(151) = XX(151)-JVS(1719)*XX(152)-JVS(1769)*XX(153)-JVS(1782)*XX(154)-JVS(1822)*XX(155)
  XX(150) = XX(150)-JVS(1668)*XX(151)-JVS(1718)*XX(152)-JVS(1768)*XX(153)-JVS(1781)*XX(154)-JVS(1821)*XX(155)
  XX(149) = XX(149)-JVS(1642)*XX(150)-JVS(1667)*XX(151)-JVS(1717)*XX(152)-JVS(1767)*XX(153)-JVS(1780)*XX(154)-JVS(1820)&
              &*XX(155)
  XX(148) = XX(148)-JVS(1602)*XX(149)-JVS(1641)*XX(150)-JVS(1666)*XX(151)-JVS(1716)*XX(152)-JVS(1766)*XX(153)-JVS(1779)&
              &*XX(154)-JVS(1819)*XX(155)
  XX(147) = XX(147)-JVS(1486)*XX(148)-JVS(1601)*XX(149)-JVS(1640)*XX(150)-JVS(1665)*XX(151)-JVS(1715)*XX(152)-JVS(1765)&
              &*XX(153)-JVS(1778)*XX(154)-JVS(1818)*XX(155)
  XX(146) = XX(146)-JVS(1360)*XX(147)-JVS(1485)*XX(148)-JVS(1600)*XX(149)-JVS(1639)*XX(150)-JVS(1664)*XX(151)-JVS(1764)&
              &*XX(153)-JVS(1817)*XX(155)
  XX(145) = XX(145)-JVS(1292)*XX(146)-JVS(1359)*XX(147)-JVS(1484)*XX(148)-JVS(1599)*XX(149)-JVS(1638)*XX(150)-JVS(1714)&
              &*XX(152)-JVS(1763)*XX(153)-JVS(1777)*XX(154)-JVS(1816)*XX(155)
  XX(144) = XX(144)-JVS(1230)*XX(145)-JVS(1291)*XX(146)-JVS(1358)*XX(147)-JVS(1483)*XX(148)-JVS(1598)*XX(149)-JVS(1637)&
              &*XX(150)-JVS(1663)*XX(151)-JVS(1713)*XX(152)-JVS(1762)*XX(153)-JVS(1815)*XX(155)
  XX(143) = XX(143)-JVS(1229)*XX(145)-JVS(1290)*XX(146)-JVS(1357)*XX(147)-JVS(1482)*XX(148)-JVS(1597)*XX(149)-JVS(1636)&
              &*XX(150)-JVS(1662)*XX(151)-JVS(1712)*XX(152)-JVS(1776)*XX(154)
  XX(142) = XX(142)-JVS(1206)*XX(143)-JVS(1219)*XX(144)-JVS(1289)*XX(146)-JVS(1356)*XX(147)-JVS(1481)*XX(148)-JVS(1596)&
              &*XX(149)-JVS(1635)*XX(150)-JVS(1711)*XX(152)-JVS(1761)*XX(153)-JVS(1814)*XX(155)
  XX(141) = XX(141)-JVS(1205)*XX(143)-JVS(1218)*XX(144)-JVS(1288)*XX(146)-JVS(1355)*XX(147)-JVS(1480)*XX(148)-JVS(1595)&
              &*XX(149)-JVS(1634)*XX(150)-JVS(1710)*XX(152)-JVS(1760)*XX(153)-JVS(1813)*XX(155)
  XX(140) = XX(140)-JVS(1204)*XX(143)-JVS(1217)*XX(144)-JVS(1287)*XX(146)-JVS(1354)*XX(147)-JVS(1479)*XX(148)-JVS(1594)&
              &*XX(149)-JVS(1633)*XX(150)-JVS(1709)*XX(152)-JVS(1759)*XX(153)-JVS(1812)*XX(155)
  XX(139) = XX(139)-JVS(1286)*XX(146)-JVS(1353)*XX(147)-JVS(1478)*XX(148)-JVS(1593)*XX(149)-JVS(1632)*XX(150)-JVS(1708)&
              &*XX(152)-JVS(1758)*XX(153)-JVS(1811)*XX(155)
  XX(138) = XX(138)-JVS(1352)*XX(147)-JVS(1477)*XX(148)-JVS(1592)*XX(149)-JVS(1631)*XX(150)-JVS(1707)*XX(152)
  XX(137) = XX(137)-JVS(1142)*XX(138)-JVS(1285)*XX(146)-JVS(1351)*XX(147)-JVS(1476)*XX(148)-JVS(1591)*XX(149)-JVS(1630)&
              &*XX(150)-JVS(1706)*XX(152)-JVS(1757)*XX(153)-JVS(1810)*XX(155)
  XX(136) = XX(136)-JVS(1141)*XX(138)-JVS(1284)*XX(146)-JVS(1475)*XX(148)-JVS(1590)*XX(149)-JVS(1705)*XX(152)
  XX(135) = XX(135)-JVS(1283)*XX(146)-JVS(1350)*XX(147)-JVS(1474)*XX(148)-JVS(1589)*XX(149)-JVS(1629)*XX(150)-JVS(1661)&
              &*XX(151)-JVS(1756)*XX(153)-JVS(1809)*XX(155)
  XX(134) = XX(134)-JVS(1093)*XX(136)-JVS(1140)*XX(138)-JVS(1282)*XX(146)-JVS(1349)*XX(147)-JVS(1473)*XX(148)-JVS(1588)&
              &*XX(149)-JVS(1704)*XX(152)-JVS(1755)*XX(153)-JVS(1808)*XX(155)
  XX(133) = XX(133)-JVS(1064)*XX(134)-JVS(1281)*XX(146)-JVS(1348)*XX(147)-JVS(1472)*XX(148)-JVS(1587)*XX(149)-JVS(1628)&
              &*XX(150)-JVS(1703)*XX(152)-JVS(1754)*XX(153)-JVS(1807)*XX(155)
  XX(132) = XX(132)-JVS(1045)*XX(133)-JVS(1280)*XX(146)-JVS(1347)*XX(147)-JVS(1471)*XX(148)-JVS(1586)*XX(149)-JVS(1627)&
              &*XX(150)-JVS(1753)*XX(153)-JVS(1806)*XX(155)
  XX(131) = XX(131)-JVS(1044)*XX(133)-JVS(1063)*XX(134)-JVS(1279)*XX(146)-JVS(1346)*XX(147)-JVS(1470)*XX(148)-JVS(1585)&
              &*XX(149)-JVS(1702)*XX(152)-JVS(1752)*XX(153)-JVS(1805)*XX(155)
  XX(130) = XX(130)-JVS(1139)*XX(138)-JVS(1345)*XX(147)-JVS(1469)*XX(148)-JVS(1584)*XX(149)-JVS(1751)*XX(153)-JVS(1804)&
              &*XX(155)
  XX(129) = XX(129)-JVS(1344)*XX(147)-JVS(1468)*XX(148)-JVS(1583)*XX(149)-JVS(1626)*XX(150)-JVS(1701)*XX(152)-JVS(1803)&
              &*XX(155)
  XX(128) = XX(128)-JVS(984)*XX(129)-JVS(1077)*XX(135)-JVS(1092)*XX(136)-JVS(1138)*XX(138)-JVS(1278)*XX(146)-JVS(1343)&
              &*XX(147)-JVS(1467)*XX(148)-JVS(1582)*XX(149)-JVS(1625)*XX(150)-JVS(1660)*XX(151)-JVS(1700)*XX(152)-JVS(1750)&
              &*XX(153)-JVS(1802)*XX(155)
  XX(127) = XX(127)-JVS(1062)*XX(134)-JVS(1277)*XX(146)-JVS(1342)*XX(147)-JVS(1466)*XX(148)-JVS(1581)*XX(149)-JVS(1699)&
              &*XX(152)-JVS(1749)*XX(153)-JVS(1801)*XX(155)
  XX(126) = XX(126)-JVS(1061)*XX(134)-JVS(1276)*XX(146)-JVS(1465)*XX(148)-JVS(1580)*XX(149)-JVS(1698)*XX(152)-JVS(1800)&
              &*XX(155)
  XX(125) = XX(125)-JVS(1060)*XX(134)-JVS(1275)*XX(146)-JVS(1341)*XX(147)-JVS(1464)*XX(148)-JVS(1579)*XX(149)-JVS(1697)&
              &*XX(152)-JVS(1748)*XX(153)-JVS(1799)*XX(155)
  XX(124) = XX(124)-JVS(1274)*XX(146)-JVS(1463)*XX(148)-JVS(1578)*XX(149)
  XX(123) = XX(123)-JVS(1462)*XX(148)-JVS(1577)*XX(149)
  XX(122) = XX(122)-JVS(1059)*XX(134)-JVS(1461)*XX(148)-JVS(1696)*XX(152)-JVS(1798)*XX(155)
  XX(121) = XX(121)-JVS(846)*XX(122)-JVS(983)*XX(129)-JVS(1273)*XX(146)-JVS(1340)*XX(147)-JVS(1460)*XX(148)-JVS(1576)&
              &*XX(149)-JVS(1695)*XX(152)-JVS(1747)*XX(153)-JVS(1797)*XX(155)
  XX(120) = XX(120)-JVS(821)*XX(121)-JVS(845)*XX(122)-JVS(882)*XX(123)-JVS(947)*XX(126)-JVS(1014)*XX(131)-JVS(1027)&
              &*XX(132)-JVS(1043)*XX(133)-JVS(1058)*XX(134)-JVS(1137)*XX(138)-JVS(1272)*XX(146)-JVS(1459)*XX(148)-JVS(1575)&
              &*XX(149)-JVS(1624)*XX(150)-JVS(1659)*XX(151)-JVS(1694)*XX(152)
  XX(119) = XX(119)-JVS(1136)*XX(138)-JVS(1271)*XX(146)-JVS(1339)*XX(147)-JVS(1458)*XX(148)-JVS(1693)*XX(152)
  XX(118) = XX(118)-JVS(820)*XX(121)-JVS(844)*XX(122)-JVS(881)*XX(123)-JVS(946)*XX(126)-JVS(1013)*XX(131)-JVS(1026)&
              &*XX(132)-JVS(1042)*XX(133)-JVS(1057)*XX(134)-JVS(1135)*XX(138)-JVS(1270)*XX(146)-JVS(1457)*XX(148)-JVS(1574)&
              &*XX(149)-JVS(1623)*XX(150)-JVS(1658)*XX(151)-JVS(1692)*XX(152)
  XX(117) = XX(117)-JVS(819)*XX(121)-JVS(843)*XX(122)-JVS(880)*XX(123)-JVS(945)*XX(126)-JVS(1012)*XX(131)-JVS(1025)&
              &*XX(132)-JVS(1041)*XX(133)-JVS(1056)*XX(134)-JVS(1134)*XX(138)-JVS(1269)*XX(146)-JVS(1456)*XX(148)-JVS(1573)&
              &*XX(149)-JVS(1622)*XX(150)-JVS(1657)*XX(151)-JVS(1691)*XX(152)
  XX(116) = XX(116)-JVS(818)*XX(121)-JVS(842)*XX(122)-JVS(879)*XX(123)-JVS(944)*XX(126)-JVS(1011)*XX(131)-JVS(1024)&
              &*XX(132)-JVS(1040)*XX(133)-JVS(1055)*XX(134)-JVS(1133)*XX(138)-JVS(1268)*XX(146)-JVS(1455)*XX(148)-JVS(1572)&
              &*XX(149)-JVS(1621)*XX(150)-JVS(1656)*XX(151)-JVS(1690)*XX(152)
  XX(115) = XX(115)-JVS(817)*XX(121)-JVS(841)*XX(122)-JVS(878)*XX(123)-JVS(943)*XX(126)-JVS(1010)*XX(131)-JVS(1023)&
              &*XX(132)-JVS(1039)*XX(133)-JVS(1054)*XX(134)-JVS(1132)*XX(138)-JVS(1267)*XX(146)-JVS(1454)*XX(148)-JVS(1571)&
              &*XX(149)-JVS(1620)*XX(150)-JVS(1655)*XX(151)-JVS(1689)*XX(152)
  XX(114) = XX(114)-JVS(877)*XX(123)-JVS(965)*XX(128)-JVS(1175)*XX(140)-JVS(1184)*XX(141)-JVS(1193)*XX(142)-JVS(1203)&
              &*XX(143)-JVS(1216)*XX(144)-JVS(1266)*XX(146)-JVS(1453)*XX(148)-JVS(1570)*XX(149)-JVS(1619)*XX(150)-JVS(1654)&
              &*XX(151)-JVS(1688)*XX(152)-JVS(1796)*XX(155)
  XX(113) = XX(113)-JVS(840)*XX(122)-JVS(876)*XX(123)-JVS(1338)*XX(147)-JVS(1452)*XX(148)-JVS(1569)*XX(149)-JVS(1746)&
              &*XX(153)
  XX(112) = XX(112)-JVS(768)*XX(113)-JVS(839)*XX(122)-JVS(1113)*XX(137)-JVS(1265)*XX(146)-JVS(1337)*XX(147)-JVS(1568)&
              &*XX(149)-JVS(1618)*XX(150)-JVS(1745)*XX(153)
  XX(111) = XX(111)-JVS(875)*XX(123)-JVS(1131)*XX(138)-JVS(1451)*XX(148)-JVS(1567)*XX(149)-JVS(1687)*XX(152)
  XX(110) = XX(110)-JVS(800)*XX(119)-JVS(874)*XX(123)-JVS(998)*XX(130)-JVS(1336)*XX(147)-JVS(1450)*XX(148)-JVS(1566)&
              &*XX(149)
  XX(109) = XX(109)-JVS(873)*XX(123)-JVS(1449)*XX(148)-JVS(1565)*XX(149)
  XX(108) = XX(108)-JVS(982)*XX(129)-JVS(1264)*XX(146)-JVS(1335)*XX(147)-JVS(1448)*XX(148)-JVS(1564)*XX(149)-JVS(1744)&
              &*XX(153)-JVS(1795)*XX(155)
  XX(107) = XX(107)-JVS(1263)*XX(146)-JVS(1447)*XX(148)-JVS(1563)*XX(149)
  XX(106) = XX(106)-JVS(1076)*XX(135)-JVS(1262)*XX(146)-JVS(1446)*XX(148)-JVS(1562)*XX(149)-JVS(1653)*XX(151)-JVS(1743)&
              &*XX(153)-JVS(1794)*XX(155)
  XX(105) = XX(105)-JVS(838)*XX(122)-JVS(981)*XX(129)-JVS(1261)*XX(146)-JVS(1334)*XX(147)-JVS(1445)*XX(148)-JVS(1561)&
              &*XX(149)-JVS(1742)*XX(153)-JVS(1793)*XX(155)
  XX(104) = XX(104)-JVS(759)*XX(112)-JVS(767)*XX(113)-JVS(837)*XX(122)-JVS(872)*XX(123)-JVS(934)*XX(125)-JVS(1260)&
              &*XX(146)-JVS(1444)*XX(148)-JVS(1560)*XX(149)-JVS(1617)*XX(150)-JVS(1652)*XX(151)
  XX(103) = XX(103)-JVS(1443)*XX(148)-JVS(1559)*XX(149)
  XX(102) = XX(102)-JVS(871)*XX(123)-JVS(1130)*XX(138)-JVS(1333)*XX(147)-JVS(1442)*XX(148)-JVS(1558)*XX(149)-JVS(1741)&
              &*XX(153)-JVS(1792)*XX(155)
  XX(101) = XX(101)-JVS(644)*XX(102)-JVS(727)*XX(109)-JVS(870)*XX(123)-JVS(997)*XX(130)-JVS(1129)*XX(138)-JVS(1332)&
              &*XX(147)-JVS(1441)*XX(148)-JVS(1557)*XX(149)-JVS(1686)*XX(152)-JVS(1740)*XX(153)
  XX(100) = XX(100)-JVS(726)*XX(109)-JVS(869)*XX(123)-JVS(1331)*XX(147)-JVS(1556)*XX(149)-JVS(1739)*XX(153)
  XX(99) = XX(99)-JVS(627)*XX(100)-JVS(643)*XX(102)-JVS(725)*XX(109)-JVS(868)*XX(123)-JVS(996)*XX(130)-JVS(1128)*XX(138)&
             &-JVS(1330)*XX(147)-JVS(1440)*XX(148)-JVS(1555)*XX(149)-JVS(1738)*XX(153)
  XX(98) = XX(98)-JVS(626)*XX(100)-JVS(635)*XX(101)-JVS(642)*XX(102)-JVS(724)*XX(109)-JVS(867)*XX(123)-JVS(995)*XX(130)&
             &-JVS(1127)*XX(138)-JVS(1439)*XX(148)-JVS(1554)*XX(149)-JVS(1685)*XX(152)
  XX(97) = XX(97)-JVS(1164)*XX(139)-JVS(1202)*XX(143)-JVS(1215)*XX(144)-JVS(1259)*XX(146)-JVS(1438)*XX(148)-JVS(1553)&
             &*XX(149)
  XX(96) = XX(96)-JVS(980)*XX(129)-JVS(1091)*XX(136)-JVS(1258)*XX(146)-JVS(1329)*XX(147)-JVS(1437)*XX(148)-JVS(1552)&
             &*XX(149)-JVS(1737)*XX(153)
  XX(95) = XX(95)-JVS(979)*XX(129)-JVS(1328)*XX(147)-JVS(1436)*XX(148)-JVS(1551)*XX(149)-JVS(1684)*XX(152)-JVS(1736)&
             &*XX(153)
  XX(94) = XX(94)-JVS(594)*XX(95)-JVS(708)*XX(108)-JVS(816)*XX(121)-JVS(836)*XX(122)-JVS(978)*XX(129)-JVS(1257)*XX(146)&
             &-JVS(1435)*XX(148)-JVS(1550)*XX(149)-JVS(1683)*XX(152)
  XX(93) = XX(93)-JVS(593)*XX(95)-JVS(707)*XX(108)-JVS(835)*XX(122)-JVS(977)*XX(129)-JVS(1256)*XX(146)-JVS(1327)*XX(147)&
             &-JVS(1434)*XX(148)-JVS(1549)*XX(149)-JVS(1682)*XX(152)
  XX(92) = XX(92)-JVS(1326)*XX(147)-JVS(1433)*XX(148)-JVS(1548)*XX(149)-JVS(1651)*XX(151)-JVS(1735)*XX(153)
  XX(91) = XX(91)-JVS(866)*XX(123)-JVS(994)*XX(130)-JVS(1547)*XX(149)
  XX(90) = XX(90)-JVS(916)*XX(124)-JVS(1255)*XX(146)-JVS(1325)*XX(147)-JVS(1432)*XX(148)-JVS(1546)*XX(149)-JVS(1734)&
             &*XX(153)
  XX(89) = XX(89)-JVS(564)*XX(91)-JVS(618)*XX(99)-JVS(625)*XX(100)-JVS(641)*XX(102)-JVS(723)*XX(109)-JVS(1126)*XX(138)&
             &-JVS(1431)*XX(148)-JVS(1545)*XX(149)
  XX(88) = XX(88)-JVS(834)*XX(122)-JVS(865)*XX(123)-JVS(915)*XX(124)-JVS(942)*XX(126)-JVS(957)*XX(127)-JVS(1254)*XX(146)&
             &-JVS(1430)*XX(148)-JVS(1544)*XX(149)
  XX(87) = XX(87)-JVS(683)*XX(106)-JVS(1075)*XX(135)-JVS(1253)*XX(146)-JVS(1429)*XX(148)-JVS(1543)*XX(149)-JVS(1791)&
             &*XX(155)
  XX(86) = XX(86)-JVS(833)*XX(122)-JVS(976)*XX(129)-JVS(1112)*XX(137)-JVS(1252)*XX(146)-JVS(1324)*XX(147)-JVS(1542)&
             &*XX(149)-JVS(1733)*XX(153)
  XX(85) = XX(85)-JVS(914)*XX(124)-JVS(1090)*XX(136)-JVS(1111)*XX(137)-JVS(1251)*XX(146)-JVS(1323)*XX(147)-JVS(1428)&
             &*XX(148)-JVS(1541)*XX(149)
  XX(84) = XX(84)-JVS(1089)*XX(136)-JVS(1250)*XX(146)-JVS(1322)*XX(147)-JVS(1427)*XX(148)-JVS(1540)*XX(149)-JVS(1616)&
             &*XX(150)-JVS(1775)*XX(154)
  XX(83) = XX(83)-JVS(766)*XX(113)-JVS(832)*XX(122)-JVS(913)*XX(124)-JVS(933)*XX(125)-JVS(1249)*XX(146)-JVS(1426)&
             &*XX(148)-JVS(1539)*XX(149)
  XX(82) = XX(82)-JVS(682)*XX(106)-JVS(1074)*XX(135)-JVS(1425)*XX(148)-JVS(1538)*XX(149)
  XX(81) = XX(81)-JVS(576)*XX(92)-JVS(1321)*XX(147)-JVS(1424)*XX(148)-JVS(1537)*XX(149)-JVS(1732)*XX(153)
  XX(80) = XX(80)-JVS(1038)*XX(133)-JVS(1320)*XX(147)-JVS(1423)*XX(148)-JVS(1536)*XX(149)
  XX(79) = XX(79)-JVS(831)*XX(122)-JVS(1319)*XX(147)-JVS(1422)*XX(148)-JVS(1535)*XX(149)-JVS(1731)*XX(153)
  XX(78) = XX(78)-JVS(592)*XX(95)-JVS(706)*XX(108)-JVS(1421)*XX(148)-JVS(1681)*XX(152)
  XX(77) = XX(77)-JVS(722)*XX(109)-JVS(1125)*XX(138)-JVS(1318)*XX(147)-JVS(1420)*XX(148)-JVS(1534)*XX(149)-JVS(1730)&
             &*XX(153)
  XX(76) = XX(76)-JVS(624)*XX(100)-JVS(721)*XX(109)-JVS(1317)*XX(147)-JVS(1419)*XX(148)-JVS(1533)*XX(149)-JVS(1729)&
             &*XX(153)
  XX(75) = XX(75)-JVS(830)*XX(122)-JVS(1009)*XX(131)-JVS(1037)*XX(133)-JVS(1248)*XX(146)-JVS(1418)*XX(148)-JVS(1532)&
             &*XX(149)
  XX(74) = XX(74)-JVS(600)*XX(96)-JVS(975)*XX(129)-JVS(1088)*XX(136)-JVS(1247)*XX(146)-JVS(1417)*XX(148)-JVS(1531)&
             &*XX(149)
  XX(73) = XX(73)-JVS(575)*XX(92)-JVS(1316)*XX(147)-JVS(1650)*XX(151)
  XX(72) = XX(72)-JVS(799)*XX(119)-JVS(912)*XX(124)-JVS(1087)*XX(136)-JVS(1110)*XX(137)-JVS(1416)*XX(148)-JVS(1530)&
             &*XX(149)
  XX(71) = XX(71)-JVS(1246)*XX(146)-JVS(1315)*XX(147)-JVS(1415)*XX(148)-JVS(1615)*XX(150)-JVS(1680)*XX(152)-JVS(1790)&
             &*XX(155)
  XX(70) = XX(70)-JVS(1314)*XX(147)-JVS(1414)*XX(148)-JVS(1614)*XX(150)
  XX(69) = XX(69)-JVS(623)*XX(100)-JVS(1529)*XX(149)
  XX(68) = XX(68)-JVS(1245)*XX(146)-JVS(1413)*XX(148)-JVS(1679)*XX(152)-JVS(1789)*XX(155)
  XX(67) = XX(67)-JVS(437)*XX(69)-JVS(484)*XX(76)-JVS(720)*XX(109)-JVS(1412)*XX(148)-JVS(1528)*XX(149)
  XX(66) = XX(66)-JVS(719)*XX(109)-JVS(1313)*XX(147)-JVS(1411)*XX(148)-JVS(1527)*XX(149)-JVS(1728)*XX(153)
  XX(65) = XX(65)-JVS(652)*XX(103)-JVS(1244)*XX(146)-JVS(1312)*XX(147)-JVS(1526)*XX(149)-JVS(1727)*XX(153)
  XX(64) = XX(64)-JVS(515)*XX(81)-JVS(1311)*XX(147)-JVS(1410)*XX(148)-JVS(1525)*XX(149)-JVS(1726)*XX(153)
  XX(63) = XX(63)-JVS(490)*XX(77)-JVS(718)*XX(109)-JVS(1124)*XX(138)-JVS(1409)*XX(148)-JVS(1524)*XX(149)
  XX(62) = XX(62)-JVS(606)*XX(97)-JVS(798)*XX(119)-JVS(1310)*XX(147)-JVS(1408)*XX(148)-JVS(1523)*XX(149)
  XX(61) = XX(61)-JVS(1407)*XX(148)-JVS(1788)*XX(155)
  XX(60) = XX(60)-JVS(557)*XX(90)-JVS(651)*XX(103)-JVS(864)*XX(123)-JVS(1243)*XX(146)-JVS(1406)*XX(148)-JVS(1522)&
             &*XX(149)-JVS(1649)*XX(151)
  XX(59) = XX(59)-JVS(539)*XX(86)-JVS(829)*XX(122)-JVS(974)*XX(129)-JVS(1242)*XX(146)-JVS(1309)*XX(147)-JVS(1405)&
             &*XX(148)-JVS(1613)*XX(150)
  XX(58) = XX(58)-JVS(815)*XX(121)-JVS(1404)*XX(148)
  XX(57) = XX(57)-JVS(863)*XX(123)-JVS(1123)*XX(138)-JVS(1521)*XX(149)-JVS(1678)*XX(152)
  XX(56) = XX(56)-JVS(674)*XX(105)-JVS(828)*XX(122)-JVS(1403)*XX(148)-JVS(1520)*XX(149)
  XX(55) = XX(55)-JVS(1053)*XX(134)-JVS(1241)*XX(146)-JVS(1402)*XX(148)-JVS(1677)*XX(152)
  XX(54) = XX(54)-JVS(422)*XX(66)-JVS(717)*XX(109)-JVS(1401)*XX(148)-JVS(1519)*XX(149)
  XX(53) = XX(53)-JVS(705)*XX(108)-JVS(973)*XX(129)-JVS(1400)*XX(148)-JVS(1518)*XX(149)
  XX(52) = XX(52)-JVS(1022)*XX(132)-JVS(1036)*XX(133)-JVS(1308)*XX(147)-JVS(1399)*XX(148)
  XX(51) = XX(51)-JVS(797)*XX(119)-JVS(911)*XX(124)-JVS(1398)*XX(148)-JVS(1517)*XX(149)
  XX(50) = XX(50)-JVS(411)*XX(64)-JVS(514)*XX(81)-JVS(1397)*XX(148)-JVS(1516)*XX(149)
  XX(49) = XX(49)-JVS(591)*XX(95)-JVS(972)*XX(129)-JVS(1396)*XX(148)-JVS(1676)*XX(152)
  XX(48) = XX(48)-JVS(1228)*XX(145)-JVS(1395)*XX(148)-JVS(1515)*XX(149)-JVS(1774)*XX(154)
  XX(47) = XX(47)-JVS(1240)*XX(146)-JVS(1394)*XX(148)-JVS(1514)*XX(149)-JVS(1787)*XX(155)
  XX(46) = XX(46)-JVS(1163)*XX(139)-JVS(1393)*XX(148)
  XX(45) = XX(45)-JVS(1307)*XX(147)-JVS(1392)*XX(148)-JVS(1513)*XX(149)-JVS(1612)*XX(150)
  XX(44) = XX(44)-JVS(640)*XX(102)-JVS(1512)*XX(149)
  XX(43) = XX(43)-JVS(716)*XX(109)-JVS(749)*XX(111)-JVS(1306)*XX(147)-JVS(1511)*XX(149)-JVS(1725)*XX(153)
  XX(42) = XX(42)-JVS(910)*XX(124)-JVS(1239)*XX(146)-JVS(1510)*XX(149)
  XX(41) = XX(41)-JVS(467)*XX(73)-JVS(574)*XX(92)-JVS(1391)*XX(148)
  XX(40) = XX(40)-JVS(971)*XX(129)-JVS(1390)*XX(148)-JVS(1509)*XX(149)
  XX(39) = XX(39)-JVS(1073)*XX(135)-JVS(1389)*XX(148)-JVS(1508)*XX(149)
  XX(38) = XX(38)-JVS(513)*XX(81)-JVS(1388)*XX(148)
  XX(37) = XX(37)-JVS(563)*XX(91)-JVS(1162)*XX(139)-JVS(1387)*XX(148)-JVS(1507)*XX(149)
  XX(36) = XX(36)-JVS(448)*XX(70)-JVS(1386)*XX(148)-JVS(1506)*XX(149)-JVS(1611)*XX(150)
  XX(35) = XX(35)-JVS(466)*XX(73)-JVS(489)*XX(77)-JVS(1385)*XX(148)-JVS(1505)*XX(149)
  XX(34) = XX(34)-JVS(284)*XX(35)-JVS(410)*XX(64)-JVS(634)*XX(101)-JVS(862)*XX(123)-JVS(1384)*XX(148)-JVS(1504)*XX(149)&
             &-JVS(1675)*XX(152)
  XX(33) = XX(33)-JVS(1161)*XX(139)-JVS(1383)*XX(148)
  XX(32) = XX(32)-JVS(861)*XX(123)-JVS(1503)*XX(149)-JVS(1674)*XX(152)
  XX(31) = XX(31)-JVS(421)*XX(66)-JVS(465)*XX(73)-JVS(1382)*XX(148)-JVS(1502)*XX(149)
  XX(30) = XX(30)-JVS(271)*XX(31)-JVS(274)*XX(32)-JVS(409)*XX(64)-JVS(617)*XX(99)-JVS(1381)*XX(148)-JVS(1501)*XX(149)
  XX(29) = XX(29)-JVS(447)*XX(70)-JVS(1305)*XX(147)-JVS(1610)*XX(150)
  XX(28) = XX(28)-JVS(681)*XX(106)-JVS(1380)*XX(148)-JVS(1500)*XX(149)
  XX(27) = XX(27)-JVS(420)*XX(66)-JVS(464)*XX(73)-JVS(1379)*XX(148)-JVS(1499)*XX(149)
  XX(26) = XX(26)-JVS(436)*XX(69)-JVS(860)*XX(123)-JVS(1498)*XX(149)
  XX(25) = XX(25)-JVS(257)*XX(26)-JVS(260)*XX(27)-JVS(483)*XX(76)-JVS(1378)*XX(148)-JVS(1497)*XX(149)
  XX(24) = XX(24)-JVS(650)*XX(103)-JVS(715)*XX(109)-JVS(859)*XX(123)-JVS(1377)*XX(148)-JVS(1496)*XX(149)
  XX(23) = XX(23)-JVS(512)*XX(81)-JVS(1304)*XX(147)
  XX(22) = XX(22)-JVS(1303)*XX(147)
  XX(21) = XX(21)-JVS(1160)*XX(139)-JVS(1376)*XX(148)
  XX(20) = XX(20)-JVS(310)*XX(42)-JVS(1375)*XX(148)
  XX(19) = XX(19)-JVS(1374)*XX(148)
  XX(18) = XX(18)-JVS(680)*XX(106)-JVS(1724)*XX(153)
  XX(17) = XX(17)-JVS(1373)*XX(148)-JVS(1495)*XX(149)
  XX(16) = XX(16)-JVS(673)*XX(105)-JVS(1372)*XX(148)
  XX(15) = XX(15)-JVS(704)*XX(108)-JVS(1371)*XX(148)
  XX(14) = XX(14)-JVS(1370)*XX(148)
  XX(13) = XX(13)
  XX(12) = XX(12)
  XX(11) = XX(11)
  XX(10) = XX(10)
  XX(9) = XX(9)
  XX(8) = XX(8)
  XX(7) = XX(7)
  XX(6) = XX(6)
  XX(5) = XX(5)
  XX(4) = XX(4)
  XX(3) = XX(3)
  XX(2) = XX(2)
  XX(1) = XX(1)
      
END SUBROUTINE KppSolveTR

! End of KppSolveTR function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! BLAS_UTIL - BLAS-LIKE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!--------------------------------------------------------------
!
! BLAS/LAPACK-like subroutines used by the integration algorithms
! It is recommended to replace them by calls to the optimized
!      BLAS/LAPACK library for your machine
!
!  (C) Adrian Sandu, Aug. 2004
!      Virginia Polytechnic Institute and State University
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE WCOPY(N,X,incX,Y,incY)
!--------------------------------------------------------------
!     copies a vector, x, to a vector, y:  y <- x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL  SCOPY(N,X,1,Y,1)   or   CALL  DCOPY(N,X,1,Y,1)
!--------------------------------------------------------------
!     USE MOZART_T1_Precision
      
      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N)

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = X(i)
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i) = X(i)
        Y(i + 1) = X(i + 1)
        Y(i + 2) = X(i + 2)
        Y(i + 3) = X(i + 3)
        Y(i + 4) = X(i + 4)
        Y(i + 5) = X(i + 5)
        Y(i + 6) = X(i + 6)
        Y(i + 7) = X(i + 7)
      END DO

      END SUBROUTINE WCOPY


!--------------------------------------------------------------
      SUBROUTINE WAXPY(N,Alpha,X,incX,Y,incY)
!--------------------------------------------------------------
!     constant times a vector plus a vector: y <- y + Alpha*x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SAXPY(N,Alpha,X,1,Y,1) or  CALL DAXPY(N,Alpha,X,1,Y,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N),Alpha
      REAL(kind=dp), PARAMETER :: ZERO = 0.0_dp

      IF (Alpha .EQ. ZERO) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,4)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = Y(i) + Alpha*X(i)
        END DO
        IF( N .LT. 4 ) RETURN
      END IF
      MP1 = M + 1
      DO i = MP1,N,4
        Y(i) = Y(i) + Alpha*X(i)
        Y(i + 1) = Y(i + 1) + Alpha*X(i + 1)
        Y(i + 2) = Y(i + 2) + Alpha*X(i + 2)
        Y(i + 3) = Y(i + 3) + Alpha*X(i + 3)
      END DO
      
      END SUBROUTINE WAXPY



!--------------------------------------------------------------
      SUBROUTINE WSCAL(N,Alpha,X,incX)
!--------------------------------------------------------------
!     constant times a vector: x(1:N) <- Alpha*x(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SSCAL(N,Alpha,X,1) or  CALL DSCAL(N,Alpha,X,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,M,MP1,N
      REAL(kind=dp)  :: X(N),Alpha
      REAL(kind=dp), PARAMETER  :: ZERO=0.0_dp, ONE=1.0_dp

      IF (Alpha .EQ. ONE) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,5)
      IF( M .NE. 0 ) THEN
        IF (Alpha .EQ. (-ONE)) THEN
          DO i = 1,M
            X(i) = -X(i)
          END DO
        ELSEIF (Alpha .EQ. ZERO) THEN
          DO i = 1,M
            X(i) = ZERO
          END DO
        ELSE
          DO i = 1,M
            X(i) = Alpha*X(i)
          END DO
        END IF
        IF( N .LT. 5 ) RETURN
      END IF
      MP1 = M + 1
      IF (Alpha .EQ. (-ONE)) THEN
        DO i = MP1,N,5
          X(i)     = -X(i)
          X(i + 1) = -X(i + 1)
          X(i + 2) = -X(i + 2)
          X(i + 3) = -X(i + 3)
          X(i + 4) = -X(i + 4)
        END DO
      ELSEIF (Alpha .EQ. ZERO) THEN
        DO i = MP1,N,5
          X(i)     = ZERO
          X(i + 1) = ZERO
          X(i + 2) = ZERO
          X(i + 3) = ZERO
          X(i + 4) = ZERO
        END DO
      ELSE
        DO i = MP1,N,5
          X(i)     = Alpha*X(i)
          X(i + 1) = Alpha*X(i + 1)
          X(i + 2) = Alpha*X(i + 2)
          X(i + 3) = Alpha*X(i + 3)
          X(i + 4) = Alpha*X(i + 4)
        END DO
      END IF

      END SUBROUTINE WSCAL

!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WLAMCH( C )
!--------------------------------------------------------------
!     returns epsilon machine
!     after LAPACK
!     replace this by the function from the optimized LAPACK implementation:
!          CALL SLAMCH('E') or CALL DLAMCH('E')
!--------------------------------------------------------------
!      USE MOZART_T1_Precision

      CHARACTER ::  C
      INTEGER    :: i
      REAL(kind=dp), SAVE  ::  Eps
      REAL(kind=dp)  ::  Suma
      REAL(kind=dp), PARAMETER  ::  ONE=1.0_dp, HALF=0.5_dp
      LOGICAL, SAVE   ::  First=.TRUE.
      
      IF (First) THEN
        First = .FALSE.
        Eps = HALF**(16)
        DO i = 17, 80
          Eps = Eps*HALF
          CALL WLAMCH_ADD(ONE,Eps,Suma)
          IF (Suma.LE.ONE) GOTO 10
        END DO
        PRINT*,'ERROR IN WLAMCH. EPS < ',Eps
        RETURN
10      Eps = Eps*2
        i = i-1      
      END IF

      WLAMCH = Eps

      END FUNCTION WLAMCH
     
      SUBROUTINE WLAMCH_ADD( A, B, Suma )
!      USE MOZART_T1_Precision
      
      REAL(kind=dp) A, B, Suma
      Suma = A + B

      END SUBROUTINE WLAMCH_ADD
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE SET2ZERO(N,Y)
!--------------------------------------------------------------
!     copies zeros into the vector y:  y <- 0
!     after BLAS
!--------------------------------------------------------------
      
      INTEGER ::  i,M,MP1,N
      REAL(kind=dp) ::  Y(N)
      REAL(kind=dp), PARAMETER :: ZERO = 0.0d0

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = ZERO
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i)     = ZERO
        Y(i + 1) = ZERO
        Y(i + 2) = ZERO
        Y(i + 3) = ZERO
        Y(i + 4) = ZERO
        Y(i + 5) = ZERO
        Y(i + 6) = ZERO
        Y(i + 7) = ZERO
      END DO

      END SUBROUTINE SET2ZERO


!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WDOT (N, DX, incX, DY, incY) 
!--------------------------------------------------------------
!     dot produce: wdot = x(1:N)*y(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SDOT(N,X,1,Y,1) or  CALL DDOT(N,X,1,Y,1)
!--------------------------------------------------------------
!      USE messy_mecca_kpp_Precision
!--------------------------------------------------------------
      IMPLICIT NONE
      INTEGER :: N, incX, incY
      REAL(kind=dp) :: DX(N), DY(N) 

      INTEGER :: i, IX, IY, M, MP1, NS
                                 
      WDOT = 0.0D0 
      IF (N .LE. 0) RETURN 
      IF (incX .EQ. incY) IF (incX-1) 5,20,60 
!                                                                       
!     Code for unequal or nonpositive increments.                       
!                                                                       
    5 IX = 1 
      IY = 1 
      IF (incX .LT. 0) IX = (-N+1)*incX + 1 
      IF (incY .LT. 0) IY = (-N+1)*incY + 1 
      DO i = 1,N 
        WDOT = WDOT + DX(IX)*DY(IY) 
        IX = IX + incX 
        IY = IY + incY 
      END DO 
      RETURN 
!                                                                       
!     Code for both increments equal to 1.                              
!                                                                       
!     Clean-up loop so remaining vector length is a multiple of 5.      
!                                                                       
   20 M = MOD(N,5) 
      IF (M .EQ. 0) GO TO 40 
      DO i = 1,M 
         WDOT = WDOT + DX(i)*DY(i) 
      END DO 
      IF (N .LT. 5) RETURN 
   40 MP1 = M + 1 
      DO i = MP1,N,5 
          WDOT = WDOT + DX(i)*DY(i) + DX(i+1)*DY(i+1) + DX(i+2)*DY(i+2) +  &
                   DX(i+3)*DY(i+3) + DX(i+4)*DY(i+4)                   
      END DO 
      RETURN 
!                                                                       
!     Code for equal, positive, non-unit increments.                    
!                                                                       
   60 NS = N*incX 
      DO i = 1,NS,incX 
        WDOT = WDOT + DX(i)*DY(i) 
      END DO 

      END FUNCTION WDOT                                          


!--------------------------------------------------------------
      SUBROUTINE WADD(N,X,Y,Z)
!--------------------------------------------------------------
!     adds two vectors: z <- x + y
!     BLAS - like
!--------------------------------------------------------------
!     USE MOZART_T1_Precision
      
      INTEGER :: i, M, MP1, N
      REAL(kind=dp) :: X(N),Y(N),Z(N)

      IF (N.LE.0) RETURN

      M = MOD(N,5)
      IF( M /= 0 ) THEN
         DO i = 1,M
            Z(i) = X(i) + Y(i)
         END DO
         IF( N < 5 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,5
         Z(i)     = X(i)     + Y(i)
         Z(i + 1) = X(i + 1) + Y(i + 1)
         Z(i + 2) = X(i + 2) + Y(i + 2)
         Z(i + 3) = X(i + 3) + Y(i + 3)
         Z(i + 4) = X(i + 4) + Y(i + 4)
      END DO

      END SUBROUTINE WADD
      
      
      
!--------------------------------------------------------------
      SUBROUTINE WGEFA(N,A,Ipvt,info)
!--------------------------------------------------------------
!     WGEFA FACTORS THE MATRIX A (N,N) BY
!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!     LINPACK - LIKE 
!--------------------------------------------------------------
!
      INTEGER       :: N,Ipvt(N),info
      REAL(kind=dp) :: A(N,N)
      REAL(kind=dp) :: t, dmax, da
      INTEGER       :: j,k,l
      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0

      info = 0

size: IF (n > 1) THEN
      
col:  DO k = 1, n-1

!        find l = pivot index
!        l = idamax(n-k+1,A(k,k),1) + k - 1
         l = k; dmax = abs(A(k,k))
         DO j = k+1,n
            da = ABS(A(j,k))
            IF (da > dmax) THEN
              l = j; dmax = da
            END IF
         END DO
         Ipvt(k) = l

!        zero pivot implies this column already triangularized
         IF (ABS(A(l,k)) < TINY(ZERO)) THEN
            info = k
            return
         ELSE   
            IF (l /= k) THEN
               t = A(l,k); A(l,k) = A(k,k); A(k,k) = t
            END IF
            t = -ONE/A(k,k)
            CALL WSCAL(n-k,t,A(k+1,k),1)
            DO j = k+1, n
               t = A(l,j)
               IF (l /= k) THEN
                  A(l,j) = A(k,j); A(k,j) = t
               END IF
               CALL WAXPY(n-k,t,A(k+1,k),1,A(k+1,j),1)
            END DO         
         END IF
         
       END DO col
       
      END IF size
      
      Ipvt(N) = N
      IF (ABS(A(N,N)) == ZERO) info = N
      
      END SUBROUTINE WGEFA


!--------------------------------------------------------------
      SUBROUTINE WGESL(Trans,N,A,Ipvt,b)
!--------------------------------------------------------------
!     WGESL solves the system
!     a * x = b  or  trans(a) * x = b
!     using the factors computed by WGEFA.
!
!     Trans      = 'N'   to solve  A*x = b ,
!                = 'T'   to solve  transpose(A)*x = b
!     LINPACK - LIKE 
!--------------------------------------------------------------

      INTEGER       :: N,Ipvt(N)
      CHARACTER     :: trans
      REAL(kind=dp) :: A(N,N),b(N)
      REAL(kind=dp) :: t
      INTEGER       :: k,kb,l

      
      SELECT CASE (Trans)

      CASE ('n','N')  !  Solve  A * x = b

!        first solve  L*y = b
         IF (n >= 2) THEN
          DO k = 1, n-1
            l = Ipvt(k)
            t = b(l)
            IF (l /= k) THEN
               b(l) = b(k)
               b(k) = t
            END IF
            CALL WAXPY(n-k,t,a(k+1,k),1,b(k+1),1)
          END DO
         END IF
!        now solve  U*x = y
         DO kb = 1, n
            k = n + 1 - kb
            b(k) = b(k)/a(k,k)
            t = -b(k)
            CALL WAXPY(k-1,t,a(1,k),1,b(1),1)
         END DO
      
      CASE ('t','T')  !  Solve transpose(A) * x = b

!        first solve  trans(U)*y = b
         DO k = 1, n
            t = WDOT(k-1,a(1,k),1,b(1),1)
            b(k) = (b(k) - t)/a(k,k)
         END DO
!        now solve trans(L)*x = y
         IF (n >= 2) THEN
         DO kb = 1, n-1
            k = n - kb
            b(k) = b(k) + WDOT(n-k,a(k+1,k),1,b(k+1),1)
            l = Ipvt(k)
            IF (l /= k) THEN
               t = b(l); b(l) = b(k); b(k) = t
            END IF
         END DO
         END IF
   
      END SELECT

      END SUBROUTINE WGESL
! End of BLAS_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE MOZART_T1_LinearAlgebra

