! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Initialization File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : MOZART_T1_Initialize.f90
! Time                 : Wed Jan 27 13:13:50 2021
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_MOZART_T1_20754_BOXMOX
! Equation file        : MOZART_T1.kpp
! Output root filename : MOZART_T1
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE MOZART_T1_Initialize

  USE MOZART_T1_Parameters, ONLY: dp, NVAR, NFIX
  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Initialize - function to initialize concentrations
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Initialize ( )


  USE MOZART_T1_Global

  USE MOZART_T1_Util

  INTEGER :: i
  REAL(kind=dp) :: x

  CFACTOR = 1.000000e+00_dp

  x = (1.0E-9)*CFACTOR
  DO i = 1, NVAR
    VAR(i) = x
  END DO

  x = (1.0E-9)*CFACTOR
  DO i = 1, NFIX
    FIX(i) = x
  END DO

! constant rate coefficients
! END constant rate coefficients

! INLINED initializations


  IF (.NOT. llibrary) THEN

    ! Write version number to VERSION file
    CALL writeVersion()

    ! Initialization (time step, run length, etc.) happening
    ! in namelist BOXMOX.nml. Read it!
    CALL readConfig()

  ENDIF

  ! Check configuration values
  CALL checkConfig()



  ! BOXMOX defaults for global variables

  ! Environment.csv
  temp         =         293.15   ! K
  pres         =      101325.0    ! Pa
  dxdydz(:)    =           1.0    ! m

  ! Aerosol.csv
  AER_SAD      =           0.0    ! m^2 m^-3
  AER_R        =           1.0e-6 ! m

  ! Turbulent mixing
  Kturb        =           0.0    ! m2 s-1



  ! relative humidity (not really used...)
  rh = 0.5


! End INLINED initializations

      
END SUBROUTINE Initialize

! End of Initialize function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE MOZART_T1_Initialize

