! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : MOZART_T1_Function.f90
! Time                 : Wed Jan 27 13:13:50 2021
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_MOZART_T1_20754_BOXMOX
! Equation file        : MOZART_T1.kpp
! Output root filename : MOZART_T1
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE MOZART_T1_Function

  USE MOZART_T1_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(39)
  A(2) = RCT(2)*F(3)
  A(3) = RCT(3)*V(151)
  A(4) = RCT(4)*V(151)
  A(5) = RCT(5)*V(70)
  A(6) = RCT(6)*V(45)
  A(7) = RCT(7)*V(18)
  A(8) = RCT(8)*V(29)
  A(9) = RCT(9)*V(147)
  A(10) = RCT(10)*V(150)
  A(11) = RCT(11)*V(93)
  A(12) = RCT(12)*V(94)
  A(13) = RCT(13)*V(67)
  A(14) = RCT(14)*V(26)
  A(15) = RCT(15)*V(111)
  A(16) = RCT(16)*V(69)
  A(17) = RCT(17)*V(44)
  A(18) = RCT(18)*V(91)
  A(19) = RCT(19)*V(57)
  A(20) = RCT(20)*V(50)
  A(21) = RCT(21)*V(53)
  A(22) = RCT(22)*V(56)
  A(23) = RCT(23)*V(41)
  A(24) = RCT(24)*V(146)
  A(25) = RCT(25)*V(146)
  A(26) = RCT(26)*V(129)
  A(27) = RCT(27)*V(122)
  A(28) = RCT(28)*V(138)
  A(29) = RCT(29)*V(68)
  A(30) = RCT(30)*V(47)
  A(31) = RCT(31)*V(20)
  A(32) = RCT(32)*V(124)
  A(33) = RCT(33)*V(109)
  A(34) = RCT(34)*V(113)
  A(35) = RCT(35)*V(137)
  A(36) = RCT(36)*V(37)
  A(37) = RCT(37)*V(136)
  A(38) = RCT(38)*V(62)
  A(39) = RCT(39)*V(97)
  A(40) = RCT(40)*V(143)
  A(41) = RCT(41)*V(83)
  A(42) = RCT(42)*V(78)
  A(43) = RCT(43)*V(49)
  A(44) = RCT(44)*V(84)
  A(45) = RCT(45)*V(144)
  A(46) = RCT(46)*V(110)
  A(47) = RCT(47)*V(119)
  A(48) = RCT(48)*V(52)
  A(49) = RCT(49)*V(22)
  A(50) = RCT(50)*V(71)
  A(51) = RCT(51)*V(54)
  A(52) = RCT(52)*V(74)
  A(53) = RCT(53)*V(55)
  A(54) = RCT(54)*V(32)
  A(55) = RCT(55)*V(88)
  A(56) = RCT(56)*V(80)
  A(57) = RCT(57)*V(75)
  A(58) = RCT(58)*V(133)
  A(59) = RCT(59)*V(126)
  A(60) = RCT(60)*V(89)
  A(61) = RCT(61)*V(33)
  A(62) = RCT(62)*V(98)
  A(63) = RCT(63)*V(63)
  A(64) = RCT(64)*V(87)*V(106)
  A(65) = RCT(65)*V(82)*V(106)
  A(66) = RCT(66)*V(106)*F(2)
  A(67) = RCT(67)*V(106)*F(4)
  A(68) = RCT(68)*V(106)*F(3)
  A(69) = RCT(69)*V(106)*V(151)
  A(70) = RCT(70)*V(135)*V(151)
  A(71) = RCT(71)*V(135)*V(135)*F(1)
  A(72) = RCT(72)*V(135)*F(1)*F(3)
  A(73) = RCT(73)*V(82)*V(135)
  A(74) = RCT(74)*V(39)*V(135)
  A(75) = RCT(75)*V(135)*V(149)
  A(76) = RCT(76)*V(149)*V(151)
  A(77) = RCT(77)*V(82)*V(148)
  A(78) = RCT(78)*V(39)*V(148)
  A(79) = RCT(79)*V(148)*V(149)
  A(80) = RCT(80)*V(135)*V(148)
  A(81) = RCT(81)*V(148)*V(151)
  A(82) = RCT(82)*V(148)*V(148)
  A(83) = RCT(83)*V(148)*V(148)
  A(84) = RCT(84)*V(149)*V(149)
  A(85) = RCT(85)*V(45)*V(148)
  A(86) = RCT(86)*V(135)*V(147)
  A(87) = RCT(87)*V(147)*V(151)
  A(88) = RCT(88)*V(135)*V(147)
  A(89) = RCT(89)*V(149)*V(150)
  A(90) = RCT(90)*V(150)*V(153)
  A(91) = RCT(91)*V(135)*V(150)
  A(92) = RCT(92)*V(148)*V(150)
  A(93) = RCT(93)*V(149)*V(153)
  A(94) = RCT(94)*V(151)*V(153)
  A(95) = RCT(95)*V(135)*V(153)
  A(96) = RCT(96)*V(18)*V(106)
  A(97) = RCT(97)*V(18)*V(106)
  A(98) = RCT(98)*V(147)*V(149)
  A(99) = RCT(99)*V(147)*V(150)
  A(100) = RCT(100)*V(147)*V(148)
  A(101) = RCT(101)*V(70)*V(148)
  A(102) = RCT(102)*V(45)*F(1)
  A(103) = RCT(103)*V(29)*F(1)
  A(104) = RCT(104)*V(146)*V(149)
  A(105) = RCT(105)*V(146)*V(150)
  A(106) = RCT(106)*V(135)*V(146)
  A(107) = RCT(107)*V(146)*V(148)
  A(108) = RCT(108)*V(155)*V(155)
  A(109) = RCT(109)*V(155)*V(155)
  A(110) = RCT(110)*V(149)*V(155)
  A(111) = RCT(111)*V(153)*V(155)
  A(112) = RCT(112)*V(107)*V(148)
  A(113) = RCT(113)*V(47)*V(148)
  A(114) = RCT(114)*V(87)*V(148)
  A(115) = RCT(115)*V(28)*V(148)
  A(116) = RCT(116)*V(103)*V(148)
  A(117) = RCT(117)*V(65)*V(149)
  A(118) = RCT(118)*V(65)
  A(119) = RCT(119)*V(65)*V(153)
  A(120) = RCT(120)*V(28)*V(106)
  A(121) = RCT(121)*V(123)*V(148)
  A(122) = RCT(122)*V(24)*V(148)
  A(123) = RCT(123)*V(60)*V(151)
  A(124) = RCT(124)*V(108)*V(108)
  A(125) = RCT(125)*V(108)*V(155)
  A(126) = RCT(126)*V(108)*V(149)
  A(127) = RCT(127)*V(108)*V(153)
  A(128) = RCT(128)*V(40)*V(148)
  A(129) = RCT(129)*V(53)*V(148)
  A(130) = RCT(130)*V(15)*V(148)
  A(131) = RCT(131)*V(129)*V(150)
  A(132) = RCT(132)*V(129)*V(148)
  A(133) = RCT(133)*V(17)*V(148)
  A(134) = RCT(134)*V(152)*V(152)
  A(135) = RCT(135)*V(152)*V(155)
  A(136) = RCT(136)*V(149)*V(152)
  A(137) = RCT(137)*V(152)*V(153)
  A(138) = RCT(138)*V(61)*V(148)
  A(139) = RCT(139)*V(68)*V(148)
  A(140) = RCT(140)*V(90)*V(149)
  A(141) = RCT(141)*V(90)*V(153)
  A(142) = RCT(142)*V(42)
  A(143) = RCT(143)*V(42)*F(3)
  A(144) = RCT(144)*V(124)*V(148)
  A(145) = RCT(145)*V(109)*V(148)
  A(146) = RCT(146)*V(71)*V(148)
  A(147) = RCT(147)*V(60)*V(148)
  A(148) = RCT(148)*V(147)*V(152)
  A(149) = RCT(149)*V(71)*F(1)
  A(150) = RCT(150)*V(128)*V(150)
  A(151) = RCT(151)*V(128)*V(151)
  A(152) = RCT(152)*V(105)*V(155)
  A(153) = RCT(153)*V(105)*V(149)
  A(154) = RCT(154)*V(105)*V(153)
  A(155) = RCT(155)*V(56)*V(148)
  A(156) = RCT(156)*V(16)*V(148)
  A(157) = RCT(157)*V(138)*V(150)
  A(158) = RCT(158)*V(138)*V(148)
  A(159) = RCT(159)*V(136)*V(148)
  A(160) = RCT(160)*V(119)*V(148)
  A(161) = RCT(161)*V(96)*V(149)
  A(162) = RCT(162)*V(96)*V(153)
  A(163) = RCT(163)*V(74)*V(148)
  A(164) = RCT(164)*V(134)*V(155)
  A(165) = RCT(165)*V(134)*V(149)
  A(166) = RCT(166)*V(134)*V(153)
  A(167) = RCT(167)*V(55)*V(148)
  A(168) = RCT(168)*V(128)*V(148)
  A(169) = RCT(169)*V(122)*V(148)
  A(170) = RCT(170)*V(59)*V(150)
  A(171) = RCT(171)*V(59)*V(148)
  A(172) = RCT(172)*V(86)*V(153)
  A(173) = RCT(173)*V(86)*V(153)
  A(174) = RCT(174)*V(137)*V(148)
  A(175) = RCT(175)*V(145)*V(152)
  A(176) = RCT(176)*V(145)*V(155)
  A(177) = RCT(177)*V(145)*V(149)
  A(178) = RCT(178)*V(145)*V(150)
  A(179) = RCT(179)*V(145)*V(153)
  A(180) = RCT(180)*V(145)*V(153)
  A(181) = RCT(181)*V(143)*V(151)
  A(182) = RCT(182)*V(143)*V(148)
  A(183) = RCT(183)*V(48)*V(148)
  A(184) = RCT(184)*V(152)*V(154)
  A(185) = RCT(185)*V(154)*V(155)
  A(186) = RCT(186)*V(149)*V(154)
  A(187) = RCT(187)*V(154)*V(154)
  A(188) = RCT(188)*V(153)*V(154)
  A(189) = RCT(189)*V(150)*V(154)
  A(190) = RCT(190)*V(95)*V(149)
  A(191) = RCT(191)*V(95)*V(153)
  A(192) = RCT(192)*V(78)*V(148)
  A(193) = RCT(193)*V(49)*V(148)
  A(194) = RCT(194)*V(84)*V(148)
  A(195) = RCT(195)*V(144)*V(151)
  A(196) = RCT(196)*V(144)*V(148)
  A(197) = RCT(197)*V(147)*V(154)*F(1)
  A(198) = RCT(198)*V(84)*F(1)
  A(199) = RCT(199)*V(93)*V(148)
  A(200) = RCT(200)*V(121)*V(149)
  A(201) = RCT(201)*V(121)*V(153)
  A(202) = RCT(202)*V(121)*V(153)
  A(203) = RCT(203)*V(94)*V(148)
  A(204) = RCT(204)*V(58)*V(148)
  A(205) = RCT(205)*V(37)*V(148)
  A(206) = RCT(206)*V(46)*V(148)
  A(207) = RCT(207)*V(21)*V(148)
  A(208) = RCT(208)*V(140)*V(152)
  A(209) = RCT(209)*V(140)*V(155)
  A(210) = RCT(210)*V(140)*V(149)
  A(211) = RCT(211)*V(140)*V(153)
  A(212) = RCT(212)*V(140)*V(150)
  A(213) = RCT(213)*V(141)*V(152)
  A(214) = RCT(214)*V(141)*V(155)
  A(215) = RCT(215)*V(141)*V(149)
  A(216) = RCT(216)*V(141)
  A(217) = RCT(217)*V(141)*V(153)
  A(218) = RCT(218)*V(141)*V(150)
  A(219) = RCT(219)*V(85)*V(148)
  A(220) = RCT(220)*V(72)*V(148)
  A(221) = RCT(221)*V(114)*V(150)
  A(222) = RCT(222)*V(142)*V(152)
  A(223) = RCT(223)*V(142)*V(155)
  A(224) = RCT(224)*V(142)*V(149)
  A(225) = RCT(225)*V(142)*V(153)
  A(226) = RCT(226)*V(142)*V(150)
  A(227) = RCT(227)*V(62)*V(148)
  A(228) = RCT(228)*V(114)*V(151)
  A(229) = RCT(229)*V(114)*V(148)
  A(230) = RCT(230)*V(97)*V(148)
  A(231) = RCT(231)*V(51)*V(148)
  A(232) = RCT(232)*V(110)*V(148)
  A(233) = RCT(233)*V(139)*V(152)
  A(234) = RCT(234)*V(139)*V(155)
  A(235) = RCT(235)*V(139)*V(149)
  A(236) = RCT(236)*V(139)*V(153)
  A(237) = RCT(237)*V(139)*V(150)
  A(238) = RCT(238)*V(33)*V(148)
  A(239) = RCT(239)*V(79)*V(149)
  A(240) = RCT(240)*V(79)*V(153)
  A(241) = RCT(241)*V(113)*V(148)
  A(242) = RCT(242)*V(104)*V(150)
  A(243) = RCT(243)*V(112)*V(149)
  A(244) = RCT(244)*V(112)*V(153)
  A(245) = RCT(245)*V(112)*V(150)
  A(246) = RCT(246)*V(125)*V(155)
  A(247) = RCT(247)*V(125)*V(149)
  A(248) = RCT(248)*V(125)*V(153)
  A(249) = RCT(249)*V(104)*V(151)
  A(250) = RCT(250)*V(104)*V(148)
  A(251) = RCT(251)*V(83)*V(148)
  A(252) = RCT(252)*V(81)*V(149)
  A(253) = RCT(253)*V(81)*V(153)
  A(254) = RCT(254)*V(43)*V(149)
  A(255) = RCT(255)*V(43)*V(153)
  A(256) = RCT(256)*V(25)*V(148)
  A(257) = RCT(257)*V(76)*V(149)
  A(258) = RCT(258)*V(76)*V(153)
  A(259) = RCT(259)*V(67)*V(148)
  A(260) = RCT(260)*V(38)*V(148)
  A(261) = RCT(261)*V(64)*V(149)
  A(262) = RCT(262)*V(50)*V(148)
  A(263) = RCT(263)*V(64)*V(153)
  A(264) = RCT(264)*V(92)*V(149)
  A(265) = RCT(265)*V(92)*V(153)
  A(266) = RCT(266)*V(41)*V(148)
  A(267) = RCT(267)*V(31)*V(148)
  A(268) = RCT(268)*V(102)*V(149)
  A(269) = RCT(269)*V(102)*V(153)
  A(270) = RCT(270)*V(102)*V(147)
  A(271) = RCT(271)*V(100)*V(149)
  A(272) = RCT(272)*V(100)*V(153)
  A(273) = RCT(273)*V(100)*V(147)
  A(274) = RCT(274)*V(130)*V(149)
  A(275) = RCT(275)*V(130)*V(153)
  A(276) = RCT(276)*V(130)*V(147)
  A(277) = RCT(277)*V(66)*V(149)
  A(278) = RCT(278)*V(66)*V(153)
  A(279) = RCT(279)*V(27)*V(148)
  A(280) = RCT(280)*V(73)*V(147)
  A(281) = RCT(281)*V(73)*V(151)
  A(282) = RCT(282)*V(54)*V(148)
  A(283) = RCT(283)*V(81)*V(147)
  A(284) = RCT(284)*V(99)*V(149)
  A(285) = RCT(285)*V(99)*V(153)
  A(286) = RCT(286)*V(89)*V(148)
  A(287) = RCT(287)*V(30)*V(148)
  A(288) = RCT(288)*V(23)*F(1)
  A(289) = RCT(289)*V(34)*V(148)
  A(290) = RCT(290)*V(101)*V(149)
  A(291) = RCT(291)*V(101)*V(153)
  A(292) = RCT(292)*V(98)*V(148)
  A(293) = RCT(293)*V(77)*V(149)
  A(294) = RCT(294)*V(77)*V(153)
  A(295) = RCT(295)*V(35)*V(148)
  A(296) = RCT(296)*V(63)*V(148)
  A(297) = RCT(297)*V(116)*V(150)
  A(298) = RCT(298)*V(116)*V(151)
  A(299) = RCT(299)*V(116)*V(148)
  A(300) = RCT(300)*V(117)*V(150)
  A(301) = RCT(301)*V(117)*V(151)
  A(302) = RCT(302)*V(117)*V(148)
  A(303) = RCT(303)*V(118)*V(150)
  A(304) = RCT(304)*V(118)*V(151)
  A(305) = RCT(305)*V(118)*V(148)
  A(306) = RCT(306)*V(115)*V(150)
  A(307) = RCT(307)*V(115)*V(151)
  A(308) = RCT(308)*V(115)*V(148)
  A(309) = RCT(309)*V(120)*V(150)
  A(310) = RCT(310)*V(120)*V(151)
  A(311) = RCT(311)*V(120)*V(148)
  A(312) = RCT(312)*V(132)*V(155)
  A(313) = RCT(313)*V(132)*V(149)
  A(314) = RCT(314)*V(132)*V(153)
  A(315) = RCT(315)*V(132)*V(150)
  A(316) = RCT(316)*V(52)*V(148)
  A(317) = RCT(317)*V(127)*V(155)
  A(318) = RCT(318)*V(127)*V(149)
  A(319) = RCT(319)*V(127)*V(153)
  A(320) = RCT(320)*V(88)*V(148)
  A(321) = RCT(321)*V(80)*V(148)
  A(322) = RCT(322)*V(131)*V(155)
  A(323) = RCT(323)*V(131)*V(149)
  A(324) = RCT(324)*V(131)*V(153)
  A(325) = RCT(325)*V(75)*V(148)
  A(326) = RCT(326)*V(133)*V(150)
  A(327) = RCT(327)*V(133)*V(148)
  A(328) = RCT(328)*V(126)*V(148)
  A(329) = RCT(329)*V(36)*V(150)
  A(330) = RCT(330)*V(36)*V(148)
  A(331) = RCT(331)*V(14)*V(148)
  A(332) = RCT(332)*V(36)*V(148)
  A(333) = RCT(333)*V(149)
  A(334) = RCT(334)*V(29)
  A(335) = RCT(335)*V(147)
  A(336) = RCT(336)*V(150)
  A(337) = RCT(337)*V(19)*V(148)
  A(338) = RCT(338)*V(116)*V(150)
  A(339) = RCT(339)*V(116)*V(151)
  A(340) = RCT(340)*V(116)*V(148)
  A(341) = RCT(341)*V(117)*V(150)
  A(342) = RCT(342)*V(117)*V(151)
  A(343) = RCT(343)*V(117)*V(148)
  A(344) = RCT(344)*V(25)*V(148)
  A(345) = RCT(345)*V(118)*V(150)
  A(346) = RCT(346)*V(118)*V(151)
  A(347) = RCT(347)*V(118)*V(148)
  A(348) = RCT(348)*V(114)*V(150)
  A(349) = RCT(349)*V(114)*V(151)
  A(350) = RCT(350)*V(114)*V(148)
  A(351) = RCT(351)*V(8)*V(148)
  A(352) = RCT(352)*V(115)*V(150)
  A(353) = RCT(353)*V(115)*V(151)
  A(354) = RCT(354)*V(115)*V(148)
  A(355) = RCT(355)*V(120)*V(150)
  A(356) = RCT(356)*V(120)*V(151)
  A(357) = RCT(357)*V(120)*V(148)
  A(358) = RCT(358)*V(9)*V(148)
  A(359) = RCT(359)*V(30)*V(148)
  A(360) = RCT(360)*V(34)*V(148)

! Aggregate function
  Vdot(1) = A(254)
  Vdot(2) = A(337)
  Vdot(3) = 0.0508*A(339)+0.0508*A(340)+0.2202*A(342)+0.2202*A(343)+0.0023*A(344)+0.0508*A(346)+0.0508*A(347)+0.0031&
              &*A(350)+0.2381*A(351)+0.0508*A(353)+0.0508*A(354)+0.0508*A(356)+0.0508*A(357)+0.5931*A(358)+0.1364*A(359)&
              &+0.1677*A(360)
  Vdot(4) = 0.1149*A(339)+0.1149*A(340)+0.2067*A(342)+0.2067*A(343)+0.0008*A(344)+0.1149*A(346)+0.1149*A(347)+0.0035&
              &*A(350)+0.1308*A(351)+0.1149*A(353)+0.1149*A(354)+0.1149*A(356)+0.1149*A(357)+0.1534*A(358)+0.0101*A(359)&
              &+0.0174*A(360)
  Vdot(5) = 0.0348*A(339)+0.0348*A(340)+0.0653*A(342)+0.0653*A(343)+0.0843*A(344)+0.0348*A(346)+0.0348*A(347)+0.0003&
              &*A(350)+0.0348*A(351)+0.0348*A(353)+0.0348*A(354)+0.0348*A(356)+0.0348*A(357)+0.0459*A(358)+0.0763*A(359)&
              &+0.086*A(360)
  Vdot(6) = 0.17493*A(338)+0.0554*A(339)+0.0554*A(340)+0.17493*A(341)+0.1284*A(342)+0.1284*A(343)+0.0443*A(344)+0.17493&
              &*A(345)+0.0554*A(346)+0.0554*A(347)+0.059024*A(348)+0.0033*A(349)+0.0271*A(350)+0.0076*A(351)+0.17493*A(352)&
              &+0.0554*A(353)+0.0554*A(354)+0.17493*A(355)+0.0554*A(356)+0.0554*A(357)+0.0085*A(358)+0.2157*A(359)+0.0512&
              &*A(360)
  Vdot(7) = 0.59019*A(338)+0.1278*A(339)+0.1278*A(340)+0.59019*A(341)+0.114*A(342)+0.114*A(343)+0.1621*A(344)+0.59019&
              &*A(345)+0.1278*A(346)+0.1278*A(347)+0.025024*A(348)+0.0474*A(350)+0.0113*A(351)+0.59019*A(352)+0.1278*A(353)&
              &+0.1278*A(354)+0.59019*A(355)+0.1278*A(356)+0.1278*A(357)+0.0128*A(358)+0.0232*A(359)+0.1598*A(360)
  Vdot(8) = -A(351)
  Vdot(9) = -A(358)
  Vdot(10) = A(108)+A(109)+A(124)+A(125)+A(134)+A(135)+A(152)+A(164)+A(208)+A(209)+A(213)+A(214)+A(233)+A(234)+A(246)&
               &+A(312)+A(317)+A(322)
  Vdot(11) = A(110)+A(117)+A(126)+A(136)+A(140)+A(153)+A(161)+A(165)+A(190)+A(200)+A(210)+A(215)+A(235)+A(243)+A(247)&
               &+A(252)+A(257)+A(261)+A(264)+A(271)+A(274)+A(277)+A(284)+A(290)+A(293)+A(313)+A(318)+A(323)
  Vdot(12) = A(111)+A(119)+A(127)+A(137)+A(141)+A(154)+A(162)+A(166)+A(172)+A(173)+A(191)+A(201)+A(202)+A(211)+A(217)&
               &+A(236)+A(244)+A(248)+A(253)+A(258)+A(263)+A(265)+A(272)+A(275)+A(278)+A(285)+A(291)+A(294)+A(314)+A(319)&
               &+A(324)
  Vdot(13) = A(107)+A(112)+A(113)+A(114)+A(115)+A(116)+A(121)+A(122)+A(128)+A(129)+A(130)+A(132)+A(133)+A(138)+A(139)&
               &+A(144)+A(145)+A(146)+A(147)+A(155)+A(156)+A(158)+A(159)+A(168)+A(169)+A(171)+A(174)+A(182)+A(183)+A(192)&
               &+A(194)+A(196)+A(203)+A(204)+A(205)+A(206)+A(207)+A(219)+A(220)+A(227)+A(229)+A(230)+A(231)+A(232)+A(238)&
               &+A(250)+A(251)+A(256)+A(266)+A(267)+A(279)+A(282)+A(286)+A(287)+A(289)+A(292)+A(296)+A(299)+A(302)+A(305)&
               &+A(308)+A(311)+A(316)+A(320)+A(321)+A(325)+A(340)+A(343)+A(344)+A(347)+A(350)+A(354)+A(357)+A(359)+A(360)
  Vdot(14) = -A(331)
  Vdot(15) = -A(130)
  Vdot(16) = -A(156)
  Vdot(17) = -A(133)
  Vdot(18) = -A(7)-A(96)-A(97)
  Vdot(19) = A(329)+A(330)+0.5*A(332)-A(337)
  Vdot(20) = -A(31)+A(140)
  Vdot(21) = -A(207)+0.6*A(230)
  Vdot(22) = -A(49)+A(174)+0.1*A(319)
  Vdot(23) = A(283)-A(288)
  Vdot(24) = -A(122)
  Vdot(25) = -A(256)
  Vdot(26) = -A(14)+0.12*A(256)
  Vdot(27) = 0.53*A(256)-A(279)
  Vdot(28) = -A(115)-A(120)
  Vdot(29) = -A(8)+A(99)-A(103)-A(334)
  Vdot(30) = -A(287)
  Vdot(31) = -A(267)+0.18*A(287)
  Vdot(32) = -A(54)+0.1*A(287)+0.23*A(289)
  Vdot(33) = -A(61)+A(235)-A(238)
  Vdot(34) = -A(289)
  Vdot(35) = 0.15*A(289)-A(295)
  Vdot(36) = -A(329)-A(330)-A(332)
  Vdot(37) = -A(36)-A(205)+A(216)
  Vdot(38) = A(20)-A(260)+A(263)
  Vdot(39) = -A(1)-A(74)-A(78)+A(83)+A(84)+0.5*A(333)
  Vdot(40) = 0.4*A(124)+0.2*A(125)-A(128)
  Vdot(41) = -A(23)+A(264)-A(266)
  Vdot(42) = A(31)+0.75*A(141)-A(142)-A(143)
  Vdot(43) = -A(254)-A(255)
  Vdot(44) = -A(17)+0.2*A(60)+0.2*A(62)+0.2*A(285)+0.2*A(291)
  Vdot(45) = -A(6)-A(85)+A(98)-A(102)
  Vdot(46) = -A(206)+A(213)+0.75*A(214)+0.87*A(217)+0.95*A(218)
  Vdot(47) = -A(30)+A(110)-A(113)
  Vdot(48) = A(177)-A(183)
  Vdot(49) = -A(43)+0.8*A(190)-A(193)
  Vdot(50) = -A(20)+A(261)-A(262)
  Vdot(51) = 0.2*A(223)-A(231)
  Vdot(52) = -A(48)+A(313)-A(316)
  Vdot(53) = -A(21)+A(126)-A(129)
  Vdot(54) = -A(51)+A(277)-A(282)
  Vdot(55) = -A(53)+0.85*A(165)-A(167)
  Vdot(56) = -A(22)+A(153)-A(155)
  Vdot(57) = -A(19)+0.21*A(62)+0.21*A(291)
  Vdot(58) = -A(204)+0.05*A(298)+0.05*A(301)+0.05*A(304)+0.05*A(307)+0.05*A(310)
  Vdot(59) = -A(170)-A(171)
  Vdot(60) = -A(123)-A(147)
  Vdot(61) = 0.1*A(135)+0.15*A(136)-A(138)+0.12*A(151)+0.15*A(186)
  Vdot(62) = -A(38)+A(224)-A(227)
  Vdot(63) = -A(63)+A(293)-A(296)
  Vdot(64) = -A(261)+A(262)-A(263)+0.07*A(287)+0.06*A(289)
  Vdot(65) = A(104)-A(117)-A(118)-A(119)
  Vdot(66) = 0.2*A(267)-A(277)-A(278)+0.14*A(279)+A(282)
  Vdot(67) = -A(13)+A(257)-A(259)
  Vdot(68) = -A(29)+0.4*A(136)-A(139)+0.4*A(186)
  Vdot(69) = 0.5*A(13)+A(14)-A(16)+0.2*A(60)+0.06*A(62)+0.5*A(258)+0.2*A(285)+0.06*A(291)
  Vdot(70) = -A(5)+A(100)-A(101)+A(105)+A(131)+A(157)+A(329)+2*A(334)+0.5*A(335)+A(336)
  Vdot(71) = -A(50)-A(146)+A(148)-A(149)
  Vdot(72) = 0.08*A(217)-A(220)
  Vdot(73) = A(23)+A(265)+0.07*A(267)+0.06*A(279)-A(280)-A(281)+0.07*A(295)
  Vdot(74) = -A(52)+A(161)-A(163)
  Vdot(75) = -A(57)+A(323)-A(325)
  Vdot(76) = 0.35*A(256)-A(257)-A(258)+A(259)
  Vdot(77) = -A(293)-A(294)+0.3*A(295)+A(296)
  Vdot(78) = 0.8*A(11)+0.8*A(12)-A(42)-A(192)+0.8*A(201)
  Vdot(79) = -A(239)-A(240)+A(241)
  Vdot(80) = -A(56)+0.5*A(312)+0.2*A(314)-A(321)+0.2*A(324)
  Vdot(81) = -A(252)-A(253)+A(260)-A(283)+A(288)
  Vdot(82) = A(25)+0.05*A(64)-A(65)-A(73)-A(77)
  Vdot(83) = -A(41)+A(247)-A(251)
  Vdot(84) = -A(44)-A(194)+A(197)-A(198)
  Vdot(85) = 0.08*A(211)-A(219)
  Vdot(86) = A(171)-A(172)-A(173)
  Vdot(87) = -A(64)-A(114)+0.1*A(151)
  Vdot(88) = -A(55)+A(318)-A(320)
  Vdot(89) = -A(60)+A(284)-A(286)
  Vdot(90) = -A(140)-A(141)+A(147)
  Vdot(91) = -A(18)+A(36)+A(46)+0.2*A(60)+0.15*A(62)+0.2*A(285)+0.15*A(291)
  Vdot(92) = 0.4*A(252)+A(253)-A(264)-A(265)+A(266)+A(281)
  Vdot(93) = -A(11)-A(199)+A(202)
  Vdot(94) = -A(12)+A(200)-A(203)
  Vdot(95) = -A(190)-A(191)+A(192)+A(193)
  Vdot(96) = -A(161)-A(162)+0.5*A(163)+A(168)
  Vdot(97) = A(38)-A(39)+A(210)+A(215)-A(230)
  Vdot(98) = -A(62)+A(290)-A(292)
  Vdot(99) = -A(284)-A(285)+A(286)+0.65*A(287)
  Vdot(100) = 0.6*A(16)-A(271)-A(272)-A(273)
  Vdot(101) = 0.56*A(289)-A(290)-A(291)+A(292)
  Vdot(102) = 0.6*A(17)-A(268)-A(269)-A(270)
  Vdot(103) = -A(116)+A(117)+A(119)+0.35*A(122)+0.37*A(123)+0.12*A(151)+0.33*A(181)+0.12*A(195)+0.11*A(228)+0.17*A(249)&
                &+0.05*A(298)+0.05*A(301)+0.05*A(304)+0.05*A(307)+0.05*A(310)
  Vdot(104) = -A(242)-A(249)-A(250)
  Vdot(105) = -A(152)-A(153)-A(154)+A(155)+A(156)
  Vdot(106) = A(4)+A(7)-A(64)-A(65)-A(66)-A(67)-A(68)-A(69)-A(96)-A(97)-A(120)
  Vdot(107) = A(109)-A(112)+0.3*A(125)+0.5*A(164)+0.25*A(176)+0.25*A(209)+0.25*A(214)+0.2*A(223)+0.3*A(234)+0.25*A(246)&
                &+0.25*A(312)+0.25*A(317)+0.25*A(322)
  Vdot(108) = A(42)-2*A(124)-A(125)-A(126)-A(127)+0.5*A(129)+A(130)
  Vdot(109) = A(13)+0.13*A(15)-A(33)+0.7*A(51)+0.6*A(60)+0.34*A(62)+0.17*A(63)+0.65*A(122)+0.2*A(144)-A(145)+0.05*A(217)&
                &+0.05*A(218)+A(232)+0.25*A(233)+0.1*A(234)+0.25*A(236)+0.25*A(237)+0.9*A(255)+A(258)+0.16*A(271)+0.4*A(272)&
                &+0.07*A(274)+0.17*A(275)+0.7*A(278)+0.6*A(285)+0.34*A(291)+0.17*A(294)
  Vdot(110) = -A(46)+A(222)+0.8*A(223)+A(225)+A(226)-A(232)
  Vdot(111) = -A(15)+0.9*A(255)+0.1*A(298)+0.1*A(301)+0.1*A(304)+0.1*A(307)+0.1*A(310)
  Vdot(112) = A(242)-A(243)-A(244)-A(245)
  Vdot(113) = -A(34)+0.33*A(41)-A(241)+0.25*A(244)+0.25*A(245)+0.167*A(246)+0.33*A(248)+0.7*A(249)
  Vdot(114) = -A(221)-A(228)-A(229)
  Vdot(115) = -A(306)-A(307)-A(308)
  Vdot(116) = -A(297)-A(298)-A(299)
  Vdot(117) = -A(300)-A(301)-A(302)
  Vdot(118) = -A(303)-A(304)-A(305)
  Vdot(119) = -A(47)+A(150)-A(160)+0.5*A(220)+A(227)+A(231)+A(232)
  Vdot(120) = -A(309)-A(310)-A(311)
  Vdot(121) = -A(200)-A(201)-A(202)+A(203)+A(204)
  Vdot(122) = 0.25*A(11)+0.25*A(12)+0.82*A(22)-A(27)+A(34)+0.17*A(35)+0.67*A(41)+0.3*A(55)+0.05*A(57)+0.5*A(59)+0.82&
                &*A(152)+0.82*A(154)-A(169)+0.5*A(170)+0.5*A(172)+0.8*A(199)+0.25*A(201)+0.4*A(239)+A(240)+0.75*A(244)+0.75&
                &*A(245)+0.333*A(246)+0.67*A(248)+0.23*A(249)+0.52*A(298)+0.52*A(301)+0.52*A(304)+0.52*A(307)+0.52*A(310)&
                &+0.15*A(317)+0.27*A(319)+0.025*A(322)+0.04*A(324)+0.5*A(328)
  Vdot(123) = 1.5*A(14)+0.45*A(15)+0.6*A(18)+A(19)+A(24)+A(25)+A(26)+A(28)+A(32)+2*A(33)+A(34)+0.33*A(35)+0.67*A(40)+0.7&
                &*A(45)+1.5*A(54)+0.25*A(55)+A(58)+1.7*A(59)+A(105)+A(106)+A(107)-A(121)+0.35*A(122)+0.63*A(123)+A(145)+0.56&
                &*A(151)+A(157)+A(158)+0.22*A(175)+0.11*A(176)+0.22*A(178)+0.22*A(179)+0.65*A(181)+0.56*A(195)+0.62*A(228)&
                &+0.25*A(233)+0.2*A(234)+0.25*A(236)+0.5*A(237)+0.64*A(249)+0.07*A(268)+0.17*A(269)+0.16*A(271)+0.4*A(272)&
                &+0.14*A(274)+0.35*A(275)+0.23*A(298)+0.23*A(301)+0.23*A(304)+0.23*A(307)+0.23*A(310)+0.125*A(317)+0.225&
                &*A(319)+0.7*A(328)
  Vdot(124) = -A(32)+0.33*A(35)+0.67*A(41)+0.25*A(55)+A(143)-A(144)+0.53*A(175)+0.26*A(176)+0.53*A(178)+0.53*A(179)+0.05&
                &*A(217)+0.05*A(218)+0.7*A(219)+0.5*A(220)+A(231)+0.25*A(233)+0.1*A(234)+0.25*A(236)+0.25*A(237)+0.333&
                &*A(246)+0.67*A(248)+0.125*A(317)+0.225*A(319)
  Vdot(125) = -A(246)-A(247)-A(248)+A(250)+0.5*A(251)
  Vdot(126) = A(55)+A(58)-A(59)+0.3*A(298)+0.3*A(301)+0.3*A(304)+0.3*A(307)+0.3*A(310)+A(317)+0.9*A(319)-A(328)
  Vdot(127) = -A(317)-A(318)-A(319)+A(320)+0.5*A(326)+A(327)
  Vdot(128) = 0.7*A(45)-A(150)-A(151)-A(168)+0.13*A(228)
  Vdot(129) = 0.4*A(11)+0.4*A(12)+A(21)-A(26)+0.33*A(35)+A(43)+A(52)+1.6*A(124)+0.8*A(125)+A(127)+A(128)+0.5*A(129)&
                &-A(131)-A(132)+0.5*A(151)+0.27*A(154)+A(162)+A(170)+A(172)+0.2*A(190)+A(191)+0.1*A(195)+0.8*A(199)+0.4&
                &*A(201)
  Vdot(130) = 0.6*A(18)-A(274)-A(275)-A(276)
  Vdot(131) = A(299)+A(302)+A(305)+A(308)+A(311)-A(322)-A(323)-A(324)+A(325)
  Vdot(132) = A(297)+A(300)+A(303)+A(306)+A(309)-A(312)-A(313)-A(314)-A(315)+A(316)+0.5*A(326)
  Vdot(133) = A(48)+A(56)+A(57)-A(58)+0.33*A(298)+0.33*A(301)+0.33*A(304)+0.33*A(307)+0.33*A(310)+0.5*A(312)+0.8*A(314)&
                &+A(315)+A(321)+A(322)+0.8*A(324)-A(326)-A(327)
  Vdot(134) = 0.15*A(59)-A(164)-A(165)-A(166)+A(167)+A(169)+0.06*A(298)+0.06*A(301)+0.06*A(304)+0.06*A(307)+0.06*A(310)&
                &+0.15*A(328)
  Vdot(135) = 2*A(2)+A(3)+A(9)+A(67)+A(68)-A(70)-2*A(71)-A(72)-A(73)-A(74)-A(75)-A(80)+A(82)-A(86)-A(88)-A(91)-A(95)&
                &-A(106)
  Vdot(136) = 0.17*A(35)-A(37)-A(159)+0.5*A(163)+0.2*A(164)+0.22*A(175)+0.23*A(176)+0.22*A(178)+0.22*A(179)+0.5*A(194)&
                &+0.05*A(217)+0.05*A(218)+0.7*A(219)+0.5*A(220)+0.25*A(233)+0.1*A(234)+0.25*A(236)+0.25*A(237)
  Vdot(137) = -A(35)+A(173)-A(174)+A(180)+0.3*A(219)+0.5*A(220)+0.75*A(244)+0.75*A(245)
  Vdot(138) = 0.18*A(15)+A(19)-A(28)+0.4*A(60)+0.54*A(62)+0.51*A(63)-A(157)-A(158)+A(159)+A(160)+0.5*A(164)+0.25*A(175)&
                &+0.24*A(176)+0.25*A(178)+0.25*A(179)+0.88*A(181)+0.5*A(195)+0.05*A(217)+0.05*A(218)+0.25*A(233)+0.1*A(234)&
                &+0.25*A(236)+0.25*A(237)+0.07*A(268)+0.17*A(269)+0.07*A(274)+0.17*A(275)+0.4*A(285)+0.54*A(291)+0.51*A(294)
  Vdot(139) = A(205)+A(206)+A(207)+0.4*A(230)-A(233)-A(234)-A(235)-A(236)-A(237)+0.5*A(238)
  Vdot(140) = -A(208)-A(209)-A(210)-A(211)-A(212)+0.6*A(229)
  Vdot(141) = -A(213)-A(214)-A(215)-A(216)-A(217)-A(218)+0.4*A(229)
  Vdot(142) = A(221)-A(222)-A(223)-A(224)-A(225)-A(226)
  Vdot(143) = 0.288*A(39)-A(40)-A(181)-A(182)+0.39*A(208)+0.31*A(209)+0.36*A(211)+0.4*A(212)+0.3*A(228)
  Vdot(144) = 0.402*A(39)-A(45)-A(195)-A(196)+0.61*A(208)+0.44*A(209)+0.56*A(211)+0.6*A(212)+0.2*A(228)
  Vdot(145) = -A(175)-A(176)-A(177)-A(178)-A(179)-A(180)+0.5*A(182)+0.2*A(183)+A(196)
  Vdot(146) = 0.1*A(11)+0.1*A(12)-A(24)-A(25)+A(30)+A(32)+0.33*A(35)+A(37)+0.69*A(39)+0.67*A(40)+0.33*A(41)+A(47)+A(52)&
                &+A(53)+0.375*A(55)+0.4*A(57)+0.68*A(59)+0.25*A(64)-A(104)-A(105)-A(106)-A(107)+2*A(108)+A(109)+A(111)&
                &+A(112)+0.3*A(113)+A(118)+A(123)+0.7*A(125)+A(135)+0.5*A(139)+0.5*A(141)+2*A(142)+0.8*A(144)+A(146)+0.5&
                &*A(151)+A(152)+A(162)+0.8*A(164)+0.15*A(165)+A(166)+0.5*A(170)+0.5*A(172)+0.25*A(175)+0.88*A(176)+0.25&
                &*A(178)+0.25*A(179)+0.12*A(181)+A(184)+2*A(185)+0.45*A(186)+2*A(187)+A(188)+A(189)+0.5*A(194)+0.6*A(195)&
                &+0.4*A(199)+0.1*A(201)+A(208)+1.5*A(209)+0.92*A(211)+A(212)+0.75*A(214)+0.3*A(219)+0.8*A(223)+0.91*A(228)&
                &+0.25*A(233)+0.8*A(234)+0.25*A(236)+0.25*A(244)+0.25*A(245)+0.917*A(246)+0.33*A(248)+0.3*A(249)+0.34*A(298)&
                &+0.34*A(301)+0.34*A(304)+0.34*A(307)+0.34*A(310)+0.75*A(312)+0.93*A(317)+0.34*A(319)+0.95*A(322)+0.32&
                &*A(324)+0.68*A(328)
  Vdot(147) = A(5)+0.66*A(6)+A(8)-A(9)+0.89*A(10)+A(11)+A(35)+A(38)+A(44)+A(46)+A(47)+A(48)+A(49)+0.6*A(50)+A(56)+A(85)&
                &-A(86)-A(87)-A(88)+A(89)+2*A(90)+A(91)+A(92)+A(93)+A(94)+A(95)-A(98)-A(99)-A(100)+A(102)+A(103)+A(111)&
                &+A(119)+A(127)+A(137)+A(141)-A(148)+A(149)+A(154)+A(160)+A(162)+A(166)+A(170)+A(172)+A(178)+A(179)+A(188)&
                &+A(189)+A(191)-A(197)+A(198)+A(199)+A(201)+0.92*A(211)+A(212)+0.92*A(217)+A(218)+0.7*A(219)+A(225)+A(226)&
                &+A(236)+A(237)+A(240)+1.25*A(244)+1.25*A(245)+A(248)+A(253)+0.9*A(255)+A(258)+A(263)+A(265)+A(269)-A(270)&
                &+A(272)-A(273)+A(275)-A(276)+A(278)-A(280)-A(283)+A(285)+A(288)+A(291)+A(294)+0.5*A(312)+1.6*A(314)+2&
                &*A(315)+0.9*A(319)+A(321)+0.8*A(324)-A(335)
  Vdot(148) = 2*A(1)+A(5)+0.33*A(6)+A(12)+A(13)+A(20)+A(21)+A(22)+A(23)+A(29)+A(30)+A(31)+A(36)+0.33*A(40)+A(41)+A(43)&
                &+A(48)+A(51)+A(52)+A(53)+A(55)+A(57)+A(60)+A(61)+A(62)+A(63)+0.75*A(64)+A(65)+2*A(66)+A(73)+A(74)+A(75)&
                &+A(76)-A(77)-A(78)-A(79)-A(80)-A(81)-2*A(82)-2*A(83)-A(85)+A(89)-A(92)+A(93)-A(100)-A(101)+A(106)-A(107)&
                &-A(112)-0.7*A(113)-A(114)-A(115)-A(116)+A(120)-A(121)-0.35*A(122)+0.13*A(123)-A(128)-0.5*A(129)-A(130)&
                &-A(132)-A(133)+0.45*A(136)-A(138)-A(139)-A(144)-A(145)-A(146)-A(147)+0.36*A(151)-A(155)-A(156)-A(158)&
                &-A(159)-A(160)-0.5*A(163)+0.15*A(165)-A(167)-A(168)-A(169)-A(171)-A(174)+0.24*A(181)-A(182)-0.9*A(183)+0.45&
                &*A(186)+0.2*A(190)-A(192)-A(193)-A(194)+0.36*A(195)-A(196)-A(199)-A(203)-A(204)-A(205)-A(206)-A(207)-A(219)&
                &-A(220)-A(227)+0.32*A(228)-A(229)-0.4*A(230)-A(231)-A(232)-0.5*A(238)+0.4*A(239)-A(241)+0.36*A(249)-A(250)&
                &-0.5*A(251)+0.4*A(252)-A(256)-A(259)-A(260)-A(262)-A(266)-A(267)+0.4*A(268)+0.4*A(274)-A(279)-A(282)-A(286)&
                &-A(287)-A(289)-A(292)-A(295)-A(296)+0.63*A(298)-A(299)+0.63*A(301)-A(302)+0.63*A(304)-A(305)+0.63*A(307)&
                &-A(308)+0.63*A(310)-A(311)-A(316)-A(320)-A(321)-A(325)-A(327)-A(328)-A(330)-A(331)-A(332)+0.5*A(335)-A(337)
  Vdot(149) = 0.66*A(6)+A(11)+0.9*A(12)+A(13)+1.5*A(14)+0.56*A(15)+A(16)+0.6*A(17)+0.6*A(18)+A(19)+A(20)+A(21)+A(22)+2&
                &*A(24)+A(26)+A(28)+A(30)+2*A(32)+2*A(33)+2*A(34)+0.67*A(35)+A(36)+A(37)+A(38)+A(39)+0.67*A(40)+A(41)+A(46)&
                &+A(51)+A(52)+A(54)+A(55)+A(56)+A(57)+A(58)+1.2*A(59)+A(60)+A(62)+A(63)+0.4*A(64)+A(65)+A(73)+A(74)-A(75)&
                &-A(76)+A(77)+A(78)-A(79)+A(80)+A(81)-2*A(84)-A(89)+A(92)-A(93)-A(98)+A(102)-A(104)+A(105)+A(106)+A(107)+2&
                &*A(108)-A(110)+A(111)+A(112)+A(115)+A(116)-A(117)+A(118)+A(119)+A(121)+0.35*A(122)+0.13*A(123)+1.2*A(124)&
                &+A(125)-A(126)+A(127)+A(128)+A(133)+0.9*A(135)-A(136)-A(140)+0.25*A(141)+A(142)+A(143)+A(144)+A(145)+0.28&
                &*A(151)+A(152)-A(153)+A(154)+A(159)-A(161)+A(162)+0.3*A(164)-A(165)+A(172)+A(174)+0.47*A(175)+0.73*A(176)&
                &-A(177)+0.47*A(178)+0.47*A(179)+0.14*A(181)+0.2*A(183)+A(185)-A(186)-A(190)+0.5*A(194)+0.28*A(195)-A(200)&
                &+A(201)+A(208)+A(209)-A(210)+0.92*A(211)+A(212)+A(213)+A(214)-A(215)+A(216)+0.92*A(217)+A(218)+0.3*A(219)&
                &+A(220)+A(222)+1.2*A(223)-A(224)+A(225)+A(226)+A(227)+0.37*A(228)+A(231)+A(232)+A(233)+0.8*A(234)-A(235)&
                &+A(236)+A(237)-0.6*A(239)+A(240)-A(243)+0.75*A(244)+0.75*A(245)+A(246)-A(247)+A(248)+0.48*A(249)-A(252)&
                &-A(254)+0.9*A(255)+0.65*A(256)-A(257)+A(258)-A(261)+A(263)-A(264)+0.73*A(267)-0.93*A(268)+0.17*A(269)-0.84&
                &*A(271)+0.4*A(272)-0.67*A(274)+0.83*A(275)-A(277)+A(278)+0.8*A(279)-A(284)+A(285)+0.28*A(287)+0.38*A(289)&
                &-A(290)+A(291)-A(293)+A(294)+0.63*A(295)+0.57*A(298)+0.57*A(301)+0.57*A(304)+0.57*A(307)+0.57*A(310)+0.5&
                &*A(312)-A(313)+A(317)-A(318)+0.9*A(319)+A(322)-A(323)+0.8*A(324)+0.2*A(328)+0.5*A(332)-A(333)
  Vdot(150) = 0.33*A(6)+A(8)-A(10)+0.4*A(50)+A(87)+A(88)-A(89)-A(90)-A(91)-A(92)-A(99)+A(101)+A(103)-A(105)-A(131)&
                &+A(146)-A(150)-A(157)-A(170)-A(178)-A(189)+0.5*A(194)-A(212)-A(218)-A(221)-A(226)-A(237)-A(242)-A(245)&
                &-A(297)-A(300)-A(303)-A(306)-A(309)-A(315)-A(326)-A(329)-A(336)
  Vdot(151) = -A(3)-A(4)+0.89*A(10)-A(69)-A(70)+A(72)-A(76)-A(81)-A(87)-A(94)-A(123)+0.15*A(136)-A(151)-A(181)+0.15&
                &*A(186)-A(195)-A(228)-A(249)-A(281)-A(298)-A(301)-A(304)-A(307)-A(310)
  Vdot(152) = 0.13*A(15)+A(19)+A(27)+A(28)+0.33*A(35)+A(37)+0.67*A(40)+A(42)+A(43)+0.3*A(45)+A(47)+0.6*A(50)+A(53)+0.5&
                &*A(54)+0.65*A(59)+A(131)+A(132)-2*A(134)-A(135)-A(136)-A(137)+0.5*A(139)-A(148)+A(149)+A(157)+A(158)+0.3&
                &*A(164)+0.15*A(165)+A(166)-0.47*A(175)+0.26*A(176)+0.53*A(178)+0.53*A(179)+0.1*A(181)+A(185)+0.45*A(186)+2&
                &*A(187)+A(188)+A(189)+0.2*A(190)+A(191)+0.28*A(195)-A(208)-A(213)-A(222)+0.08*A(228)-A(233)+0.06*A(298)&
                &+0.06*A(301)+0.06*A(304)+0.06*A(307)+0.06*A(310)+0.65*A(328)
  Vdot(153) = A(9)+0.11*A(10)+A(86)-A(90)-A(93)-A(94)-A(95)+2*A(96)-A(111)-A(119)-A(127)-A(137)-A(141)-A(154)-A(162)&
                &-A(166)-A(172)-A(173)-A(179)-A(180)-A(188)-A(191)-A(201)-A(202)-A(211)-A(217)-A(225)-A(236)-A(240)-A(244)&
                &-A(248)-A(253)-A(255)-A(258)-A(263)-A(265)-A(269)-A(272)-A(275)-A(278)-A(285)-A(291)-A(294)-A(314)-A(319)&
                &-A(324)+0.5*A(335)
  Vdot(154) = 0.33*A(40)+A(44)+0.5*A(182)+0.5*A(183)-A(184)-A(185)-A(186)-2*A(187)-A(188)-A(189)-A(197)+A(198)
  Vdot(155) = A(26)+A(27)+A(29)+0.3*A(45)+0.4*A(50)+0.75*A(64)-2*A(108)-2*A(109)-A(110)-A(111)+0.7*A(113)+A(114)-A(125)&
                &+2*A(134)-0.1*A(135)+0.45*A(136)+A(137)+A(138)+0.28*A(151)-A(152)-A(164)+A(175)-A(176)+A(184)-A(185)+A(208)&
                &-A(209)+A(213)-A(214)+A(222)-A(223)+0.05*A(228)+A(233)-A(234)-A(246)+0.33*A(268)+0.83*A(269)+0.07*A(274)&
                &+0.17*A(275)-A(312)-A(317)-A(322)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE MOZART_T1_Function

