! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Sparse Stoichiometric Data Structures File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : MOZART_4_StoichiomSP.f90
! Time                 : Mon Jul 19 09:14:05 2021
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_MOZART_4_11638_BOXMOX
! Equation file        : MOZART_4.kpp
! Output root filename : MOZART_4
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE MOZART_4_StoichiomSP

  USE MOZART_4_Precision
  PUBLIC
  SAVE


! Row-compressed sparse data for the Jacobian of reaction products JVRP

  INTEGER, PARAMETER, DIMENSION(197) :: CROW_JVRP = (/ &
       1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, &
      12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, &
      24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, &
      36, 37, 38, 40, 41, 42, 44, 46, 48, 50, 52, 54, &
      55, 57, 59, 60, 61, 63, 65, 67, 69, 71, 73, 75, &
      77, 78, 80, 82, 84, 86, 88, 89, 90, 91, 92, 94, &
      96, 98, 99,100,102,104,106,108,110,112,114,116, &
     118,120,121,122,124,126,128,130,132,134,136,138, &
     140,142,144,146,148,150,152,154,156,158,159,160, &
     162,164,166,168,170,172,174,176,178,180,182,184, &
     186,188,190,192,194,196,198,200,202,204,206,208, &
     210,212,214,216,218,220,222,224,226,228,230,232, &
     234,236,238,240,242,244,246,248,250,252,254,256, &
     258,260,262,263,265,266,268,270,272,274,276,278, &
     280,282,284,286,288,290,292,294,296,298,300,302, &
     304,306,308,310,312,314,316,318,320,322,324,326, &
     328,330,332,333,334 /)

  INTEGER, PARAMETER, DIMENSION(333) :: ICOL_JVRP = (/ &
      81, 81,  3, 73, 13, 39, 80, 26, 18, 72, 72,  9, &
      62, 35, 32, 36, 43, 66, 69, 21, 22, 23, 51, 67, &
      15, 60, 42, 65, 54, 33, 45, 37, 48, 25, 31, 38, &
      52, 52, 81, 47, 47, 19, 47, 19, 75, 52, 75, 52, &
      79, 75, 81, 79, 81, 79,  9, 75, 75, 79, 75, 75, &
       3, 47,  3, 47, 76, 79, 76, 81, 52, 73, 73, 81, &
      79, 80, 73, 80, 13, 73, 75, 39, 75, 76, 80, 73, &
      79, 26, 75, 26, 13, 80, 73, 40, 75, 40, 47, 76, &
      77, 77, 77, 77, 79, 18, 75, 72, 80, 72, 75, 58, &
      75, 27, 75, 27, 81,  8, 75, 37, 75, 30, 76, 12, &
      12,  4, 75, 56, 76, 56, 79, 56, 77, 21, 75, 61, &
      75, 61, 81, 61, 80, 50, 76, 50, 79, 35, 75, 62, &
      75, 62, 80, 76, 78, 73, 78, 78, 79, 77, 78, 32, &
      75, 36, 78,  5, 75, 57, 76, 57, 79, 57, 77, 22, &
      75, 51, 75, 63, 76, 63, 79, 63, 77, 23, 75,  6, &
      75, 24, 76,  7, 75, 55, 76, 55, 79, 48, 75, 29, &
      75, 33, 75, 49, 76, 49, 79, 25, 75, 10, 75, 11, &
      75, 14, 73, 44, 76, 44, 79, 31, 75, 59, 75, 59, &
      81, 71, 76, 71, 80, 71, 79, 42, 75, 71, 77, 71, &
      78, 69, 75, 69, 81, 66, 75, 66, 81, 70, 76, 70, &
      76, 70, 80, 70, 79, 70, 77, 70, 78, 20, 75, 74, &
      76, 74, 80, 74, 79, 74, 77, 74, 78, 74, 73, 74, &
      43, 46, 75, 46, 81, 46, 80, 64, 76, 64, 79, 38, &
      75, 34, 75, 59, 80, 53, 76, 53, 80, 53, 79, 67, &
      75, 67, 80, 60, 75, 60, 80, 28, 75, 68, 76, 68, &
      80, 68, 79, 68, 77, 68, 78, 15, 75, 15, 75, 41, &
      75, 17, 75, 43, 75, 36, 75, 65, 75, 54, 75, 16, &
      75, 16, 75, 16, 80,  2, 75, 79, 56 /)

  INTEGER, PARAMETER, DIMENSION(333) :: IROW_JVRP = (/ &
       2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, &
      14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, &
      26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, &
      38, 39, 39, 40, 41, 42, 42, 43, 43, 44, 44, 45, &
      45, 46, 46, 47, 47, 48, 49, 49, 50, 50, 51, 52, &
      53, 53, 54, 54, 55, 55, 56, 56, 57, 57, 58, 58, &
      59, 59, 60, 60, 61, 62, 62, 63, 63, 64, 64, 65, &
      65, 66, 66, 67, 68, 69, 70, 71, 71, 72, 72, 73, &
      73, 74, 75, 76, 76, 77, 77, 78, 78, 79, 79, 80, &
      80, 81, 81, 82, 82, 83, 83, 84, 84, 85, 85, 86, &
      87, 88, 88, 89, 89, 90, 90, 91, 91, 92, 92, 93, &
      93, 94, 94, 95, 95, 96, 96, 97, 97, 98, 98, 99, &
      99,100,100,101,101,102,102,103,103,104,104,105, &
     105,106,107,108,108,109,109,110,110,111,111,112, &
     112,113,113,114,114,115,115,116,116,117,117,118, &
     118,119,119,120,120,121,121,122,122,123,123,124, &
     124,125,125,126,126,127,127,128,128,129,129,130, &
     130,131,131,132,132,133,133,134,134,135,135,136, &
     136,137,137,138,138,139,139,140,140,141,141,142, &
     142,143,143,144,144,145,145,146,146,147,147,148, &
     148,149,149,150,150,151,151,152,152,153,153,154, &
     154,155,155,156,156,157,157,158,158,159,160,160, &
     161,162,162,163,163,164,164,165,165,166,166,167, &
     167,168,168,169,169,170,170,171,171,172,172,173, &
     173,174,174,175,175,176,176,177,177,178,178,179, &
     179,180,180,181,181,182,182,183,183,184,184,185, &
     185,186,186,187,187,188,188,189,189,190,190,191, &
     191,192,192,193,193,194,194,195,196 /)



!  Stoichiometric Matrix in Compressed Column Sparse Format


  INTEGER, PARAMETER, DIMENSION(197) :: CCOL_STOICM = (/ &
       1,  2,  4,  6,  8, 11, 14, 17, 21, 26, 30, 33, &
      36, 38, 42, 47, 50, 55, 58, 65, 70, 74, 78, 82, &
      85, 89, 91, 96,101,105,109,112,118,121,128,132, &
     137,143,145,147,149,151,155,158,161,164,167,170, &
     172,175,177,179,181,184,186,190,193,196,199,203, &
     206,209,212,215,218,221,224,227,229,231,235,238, &
     245,250,253,256,259,263,268,272,275,280,287,290, &
     294,298,301,304,307,312,315,322,326,329,339,342, &
     348,351,355,358,362,366,369,374,379,383,386,388, &
     391,397,400,405,408,411,416,419,427,430,433,440, &
     443,452,455,458,462,465,470,473,476,481,484,488, &
     495,498,501,504,515,524,532,535,539,547,555,558, &
     566,570,577,587,590,600,603,613,622,627,632,637, &
     642,647,650,653,656,659,662,668,672,679,682,685, &
     688,691,699,707,714,718,723,728,733,736,744,752, &
     755,764,772,775,776,780,784,790,794,798,803,806, &
     810,814,816,818,822 /)

  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_0 = (/ &
      52, 47, 81, 52, 81,  3, 47, 52, 73, 76, 13, 73, &
      80, 39, 73, 75, 73, 76, 80, 81, 26, 73, 75, 79, &
      80, 18, 72, 75, 79, 58, 72, 79, 19, 58, 72,  9, &
      75, 58, 62, 77, 79, 35, 62, 72, 75, 79, 32, 75, &
      77, 36, 73, 77, 78, 80, 43, 73, 74, 58, 66, 72, &
      74, 75, 78, 79, 58, 61, 69, 77, 78, 21, 62, 75, &
      79, 22, 51, 75, 79, 23, 72, 75, 78, 51, 77, 78, &
      58, 67, 78, 79, 15, 75, 58, 60, 72, 73, 79, 42, &
      66, 69, 72, 79, 65, 72, 78, 79, 54, 58, 72, 79, &
      33, 56, 78, 37, 45, 58, 67, 78, 79, 37, 58, 79, &
      33, 48, 51, 62, 72, 75, 79, 25, 62, 75, 78, 31, &
      37, 45, 67, 75, 38, 51, 66, 69, 75, 79, 52, 81, &
      52, 81, 47, 52, 47, 75, 19, 47, 75, 79, 19, 75, &
      79, 52, 75, 79, 52, 75, 79, 75, 79, 81, 75, 79, &
      81,  9, 79,  9, 75, 79, 75, 79, 52, 75,  9, 75, &
       3, 47, 76,  3, 47, 73, 75, 76, 79, 73, 76, 81, &
      52, 73, 76, 73, 80, 81, 73, 75, 79, 80, 13, 73, &
      80, 13, 73, 80, 39, 73, 75, 39, 75, 80, 73, 76, &
      80, 26, 73, 79, 26, 73, 75, 26, 73, 79, 13, 39, &
      39, 80, 39, 73, 75, 76, 40, 75, 77, 19, 40, 47, &
      72, 75, 77, 79, 72, 73, 76, 77, 79, 72, 77, 79, &
      41, 72, 77, 18, 77, 79, 18, 72, 75, 77, 39, 58, &
      72, 79, 80, 58, 72, 75, 79, 58, 75, 79, 27, 30, &
      72, 75, 79, 27, 34, 58, 72, 75, 79, 81,  1,  8, &
      75, 37, 58, 75, 79, 12, 30, 73, 76, 12, 54, 79, &
      12, 72, 79,  4, 56, 75, 56, 62, 73, 76, 79, 21, &
      56, 79, 17, 41, 56, 62, 72, 77, 79, 21, 56, 62, &
      75, 50, 61, 75, 34, 40, 58, 61, 62, 72, 75, 77, &
      79, 81, 29, 61, 80, 50, 62, 72, 73, 76, 79, 35, &
      50, 79, 35, 50, 65, 75, 62, 75, 78, 39, 62, 78 /)
  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_1 = (/ &
      80, 73, 76, 77, 78, 36, 73, 78, 32, 34, 78, 79, &
      81, 34, 72, 77, 78, 79, 32, 72, 75, 78, 36, 73, &
      78, 77, 78,  5, 57, 75, 51, 57, 62, 73, 76, 79, &
      22, 57, 79, 51, 57, 72, 77, 79, 22, 57, 75, 51, &
      63, 75, 63, 72, 73, 76, 78, 23, 63, 79, 41, 63, &
      65, 67, 72, 77, 78, 79, 23, 63, 75,  6, 24, 75, &
      24, 51, 62, 72, 73, 76, 79,  7, 55, 75, 29, 33, &
      51, 55, 62, 72, 73, 76, 79, 48, 55, 79, 48, 55, &
      75, 29, 67, 73, 75, 33, 49, 75, 49, 62, 73, 76, &
      78, 25, 49, 79, 25, 49, 75, 10, 11, 44, 75, 79, &
      11, 14, 75, 14, 45, 73, 79, 37, 44, 45, 67, 73, &
      76, 79, 31, 44, 79, 31, 44, 75, 59, 71, 75, 34, &
      58, 59, 61, 66, 69, 72, 74, 75, 79, 81, 28, 60, &
      66, 69, 71, 72, 73, 76, 79, 28, 66, 69, 71, 72, &
      73, 79, 80, 42, 71, 79, 42, 68, 71, 75, 28, 41, &
      66, 69, 71, 72, 77, 79, 28, 66, 69, 71, 72, 77, &
      78, 79, 69, 70, 75, 58, 62, 67, 69, 72, 75, 79, &
      81, 66, 70, 74, 75, 58, 66, 67, 72, 75, 79, 81, &
      54, 58, 65, 67, 70, 72, 73, 76, 78, 79, 60, 70, &
      76, 54, 58, 65, 67, 70, 72, 73, 78, 79, 80, 20, &
      70, 79, 41, 54, 58, 65, 67, 70, 72, 77, 78, 79, &
      54, 58, 65, 67, 70, 72, 77, 78, 79, 20, 70, 74, &
      75, 79, 72, 73, 74, 76, 78, 72, 73, 74, 78, 80, &
      32, 34, 74, 79, 81, 72, 74, 77, 78, 79, 72, 74, &
      77, 72, 74, 78, 43, 73, 74, 43, 73, 74, 46, 64, &
      75, 46, 66, 69, 75, 79, 81, 46, 64, 73, 80, 51, &
      64, 66, 69, 73, 76, 79, 38, 64, 79, 38, 64, 75, &
      34, 75, 77, 53, 59, 80, 53, 60, 66, 69, 72, 73, &
      76, 79, 53, 60, 66, 69, 72, 73, 79, 80, 53, 60, &
      66, 69, 72, 73, 79, 58, 67, 75, 78, 39, 58, 67 /)
  INTEGER, PARAMETER, DIMENSION(101) :: IROW_STOICM_2 = (/ &
      78, 80, 28, 60, 73, 75, 79, 28, 60, 73, 79, 80, &
      28, 68, 75, 54, 58, 65, 67, 68, 73, 76, 79, 54, &
      58, 65, 67, 68, 73, 79, 80, 15, 68, 79, 41, 54, &
      58, 65, 67, 68, 72, 77, 79, 54, 58, 65, 67, 68, &
      77, 78, 79, 15, 68, 75, 15, 41, 72, 75, 79, 17, &
      62, 75, 79, 43, 65, 72, 75, 79, 80, 36, 72, 75, &
      80, 65, 67, 75, 79, 37, 54, 72, 75, 79,  8, 16, &
      75,  8, 16, 75, 79,  8, 16, 39, 80,  2, 75,  9, &
      79, 17, 56, 62, 79 /)
  INTEGER, PARAMETER, DIMENSION(821) :: IROW_STOICM = (/&
    IROW_STOICM_0, IROW_STOICM_1, IROW_STOICM_2 /)

  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_0 = (/ &
       1,  2,  2,  3,  3,  4,  4,  5,  5,  5,  6,  6, &
       6,  7,  7,  7,  8,  8,  8,  8,  9,  9,  9,  9, &
       9, 10, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, &
      13, 14, 14, 14, 14, 15, 15, 15, 15, 15, 16, 16, &
      16, 17, 17, 17, 17, 17, 18, 18, 18, 19, 19, 19, &
      19, 19, 19, 19, 20, 20, 20, 20, 20, 21, 21, 21, &
      21, 22, 22, 22, 22, 23, 23, 23, 23, 24, 24, 24, &
      25, 25, 25, 25, 26, 26, 27, 27, 27, 27, 27, 28, &
      28, 28, 28, 28, 29, 29, 29, 29, 30, 30, 30, 30, &
      31, 31, 31, 32, 32, 32, 32, 32, 32, 33, 33, 33, &
      34, 34, 34, 34, 34, 34, 34, 35, 35, 35, 35, 36, &
      36, 36, 36, 36, 37, 37, 37, 37, 37, 37, 38, 38, &
      39, 39, 40, 40, 41, 41, 42, 42, 42, 42, 43, 43, &
      43, 44, 44, 44, 45, 45, 45, 46, 46, 46, 47, 47, &
      47, 48, 48, 49, 49, 49, 50, 50, 51, 51, 52, 52, &
      53, 53, 53, 54, 54, 55, 55, 55, 55, 56, 56, 56, &
      57, 57, 57, 58, 58, 58, 59, 59, 59, 59, 60, 60, &
      60, 61, 61, 61, 62, 62, 62, 63, 63, 63, 64, 64, &
      64, 65, 65, 65, 66, 66, 66, 67, 67, 67, 68, 68, &
      69, 69, 70, 70, 70, 70, 71, 71, 71, 72, 72, 72, &
      72, 72, 72, 72, 73, 73, 73, 73, 73, 74, 74, 74, &
      75, 75, 75, 76, 76, 76, 77, 77, 77, 77, 78, 78, &
      78, 78, 78, 79, 79, 79, 79, 80, 80, 80, 81, 81, &
      81, 81, 81, 82, 82, 82, 82, 82, 82, 82, 83, 83, &
      83, 84, 84, 84, 84, 85, 85, 85, 85, 86, 86, 86, &
      87, 87, 87, 88, 88, 88, 89, 89, 89, 89, 89, 90, &
      90, 90, 91, 91, 91, 91, 91, 91, 91, 92, 92, 92, &
      92, 93, 93, 93, 94, 94, 94, 94, 94, 94, 94, 94, &
      94, 94, 95, 95, 95, 96, 96, 96, 96, 96, 96, 97, &
      97, 97, 98, 98, 98, 98, 99, 99, 99,100,100,100 /)
  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_1 = (/ &
     100,101,101,101,101,102,102,102,103,103,103,103, &
     103,104,104,104,104,104,105,105,105,105,106,106, &
     106,107,107,108,108,108,109,109,109,109,109,109, &
     110,110,110,111,111,111,111,111,112,112,112,113, &
     113,113,114,114,114,114,114,115,115,115,116,116, &
     116,116,116,116,116,116,117,117,117,118,118,118, &
     119,119,119,119,119,119,119,120,120,120,121,121, &
     121,121,121,121,121,121,121,122,122,122,123,123, &
     123,124,124,124,124,125,125,125,126,126,126,126, &
     126,127,127,127,128,128,128,129,129,129,129,129, &
     130,130,130,131,131,131,131,132,132,132,132,132, &
     132,132,133,133,133,134,134,134,135,135,135,136, &
     136,136,136,136,136,136,136,136,136,136,137,137, &
     137,137,137,137,137,137,137,138,138,138,138,138, &
     138,138,138,139,139,139,140,140,140,140,141,141, &
     141,141,141,141,141,141,142,142,142,142,142,142, &
     142,142,143,143,143,144,144,144,144,144,144,144, &
     144,145,145,145,145,146,146,146,146,146,146,146, &
     147,147,147,147,147,147,147,147,147,147,148,148, &
     148,149,149,149,149,149,149,149,149,149,149,150, &
     150,150,151,151,151,151,151,151,151,151,151,151, &
     152,152,152,152,152,152,152,152,152,153,153,153, &
     153,153,154,154,154,154,154,155,155,155,155,155, &
     156,156,156,156,156,157,157,157,157,157,158,158, &
     158,159,159,159,160,160,160,161,161,161,162,162, &
     162,163,163,163,163,163,163,164,164,164,164,165, &
     165,165,165,165,165,165,166,166,166,167,167,167, &
     168,168,168,169,169,169,170,170,170,170,170,170, &
     170,170,171,171,171,171,171,171,171,171,172,172, &
     172,172,172,172,172,173,173,173,173,174,174,174 /)
  INTEGER, PARAMETER, DIMENSION(101) :: ICOL_STOICM_2 = (/ &
     174,174,175,175,175,175,175,176,176,176,176,176, &
     177,177,177,178,178,178,178,178,178,178,178,179, &
     179,179,179,179,179,179,179,180,180,180,181,181, &
     181,181,181,181,181,181,181,182,182,182,182,182, &
     182,182,182,183,183,183,184,185,185,185,185,186, &
     186,186,186,187,187,187,187,187,187,188,188,188, &
     188,189,189,189,189,190,190,190,190,190,191,191, &
     191,192,192,192,192,193,193,193,193,194,194,195, &
     195,196,196,196,196 /)
  INTEGER, PARAMETER, DIMENSION(821) :: ICOL_STOICM = (/&
    ICOL_STOICM_0, ICOL_STOICM_1, ICOL_STOICM_2 /)

  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_0 = (/ &
       2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  8.900000e-01_dp,  1.100000e-01_dp,  -1.000000e+00_dp,  8.900000e-01_dp, &
       -1.000000e+00_dp,  6.600000e-01_dp,  3.300000e-01_dp,  6.600000e-01_dp,  3.300000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       6.000000e-01_dp,  4.000000e-01_dp,  6.000000e-01_dp,  4.000000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  6.700000e-01_dp,  -1.000000e+00_dp,  6.700000e-01_dp, &
       3.300000e-01_dp,  3.300000e-01_dp,  6.700000e-01_dp,  6.700000e-01_dp,  7.000000e-01_dp, &
       7.000000e-01_dp,  -1.000000e+00_dp,  3.000000e-01_dp,  3.000000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  8.200000e-01_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  2.880000e-01_dp,  4.020000e-01_dp,  6.900000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.300000e-01_dp,  -1.000000e+00_dp,  4.500000e-01_dp,  1.800000e-01_dp, &
       1.300000e-01_dp,  5.600000e-01_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  2.000000e+00_dp, &
       8.000000e-01_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  4.000000e-01_dp,  1.000000e-01_dp, &
       1.000000e+00_dp,  9.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  4.500000e-01_dp,  9.000000e-01_dp,  4.500000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_1 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  5.000000e-02_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       2.500000e-01_dp,  7.500000e-01_dp,  7.500000e-01_dp,  4.000000e-01_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp, &
       -2.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  3.000000e-01_dp, &
       -7.000000e-01_dp,  7.000000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       7.500000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  -1.000000e+00_dp, &
       2.500000e-01_dp,  5.000000e-01_dp,  1.000000e+00_dp,  1.200000e-01_dp,  1.200000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_2 = (/ &
       -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e-01_dp, &
       3.000000e-01_dp,  -1.000000e+00_dp,  8.000000e-01_dp,  7.000000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -5.000000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  8.000000e-02_dp, &
       5.600000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  5.400000e-01_dp,  3.300000e-01_dp, &
       3.100000e-01_dp,  1.900000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -5.000000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  7.500000e-01_dp,  2.500000e-01_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  1.000000e-01_dp,  1.000000e+00_dp, &
       -1.000000e-01_dp,  -1.000000e+00_dp,  9.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       -1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       2.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       8.200000e-01_dp,  -1.000000e+00_dp,  2.700000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  8.200000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       2.000000e-01_dp,  5.000000e-01_dp,  8.000000e-01_dp,  -1.000000e+00_dp,  3.000000e-01_dp, &
       3.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp, &
       5.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e-01_dp,  7.500000e-01_dp,  2.500000e-01_dp, &
       -1.000000e+00_dp,  4.000000e-01_dp,  1.000000e-01_dp,  9.000000e-01_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_3 = (/ &
       9.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  2.500000e-01_dp,  7.000000e-01_dp,  -1.000000e+00_dp,  2.500000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  7.000000e-01_dp, &
       -3.000000e-01_dp,  7.000000e-01_dp,  4.500000e-01_dp,  -1.000000e+00_dp,  9.000000e-01_dp, &
       4.500000e-01_dp,  9.000000e-01_dp,  -1.000000e+00_dp,  9.000000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e-01_dp,  3.000000e-01_dp, &
       -1.000000e+00_dp,  7.000000e-02_dp,  4.000000e-01_dp,  2.000000e-01_dp,  6.000000e-01_dp, &
       2.000000e-01_dp,  2.700000e-01_dp,  6.000000e-02_dp,  -9.000000e-01_dp,  3.700000e-01_dp, &
       8.000000e-02_dp,  2.300000e-01_dp,  3.200000e-01_dp,  -1.000000e+00_dp,  5.500000e-01_dp, &
       9.200000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  4.000000e-01_dp,  2.500000e-01_dp, &
       3.500000e-01_dp,  -1.000000e+00_dp,  6.000000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  3.000000e-01_dp,  2.500000e-01_dp, &
       1.900000e-01_dp,  2.600000e-01_dp,  -1.000000e+00_dp,  1.200000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  4.000000e-01_dp,  2.500000e-01_dp,  3.500000e-01_dp,  -1.000000e+00_dp, &
       6.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-02_dp,  4.000000e-02_dp,  9.500000e-01_dp, &
       -1.000000e+00_dp,  8.000000e-01_dp,  8.000000e-02_dp,  6.000000e-02_dp,  -8.000000e-01_dp, &
       -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  2.000000e-01_dp, &
       -1.000000e+00_dp,  8.000000e-01_dp,  7.000000e-01_dp,  2.150000e-01_dp,  2.750000e-01_dp, &
       -8.000000e-01_dp,  5.300000e-01_dp,  2.200000e-01_dp,  2.200000e-01_dp,  2.500000e-01_dp, &
       -1.000000e+00_dp,  2.500000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  5.300000e-01_dp, &
       4.700000e-01_dp,  8.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  5.300000e-01_dp, &
       2.200000e-01_dp,  2.200000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  2.500000e-01_dp, &
       1.000000e+00_dp,  5.300000e-01_dp,  4.700000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_4 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  2.600000e-01_dp,  1.100000e-01_dp, &
       2.300000e-01_dp,  2.400000e-01_dp,  -1.000000e+00_dp,  8.800000e-01_dp,  -1.000000e+00_dp, &
       2.600000e-01_dp,  7.300000e-01_dp,  5.300000e-01_dp,  2.200000e-01_dp,  2.200000e-01_dp, &
       2.500000e-01_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  1.000000e+00_dp,  -4.700000e-01_dp, &
       4.700000e-01_dp,  -1.000000e+00_dp,  2.000000e-01_dp,  5.000000e-01_dp,  -9.000000e-01_dp, &
       2.000000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  7.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       2.500000e-01_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp, &
       -2.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  7.000000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  7.940000e-01_dp,  1.670000e-01_dp,  3.900000e-02_dp,  7.200000e-02_dp, &
       1.206000e+00_dp,  -1.000000e+00_dp,  7.940000e-01_dp,  -1.000000e+00_dp,  7.940000e-01_dp, &
       1.670000e-01_dp,  3.900000e-02_dp,  7.200000e-02_dp,  1.206000e+00_dp,  7.940000e-01_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  7.940000e-01_dp,  1.670000e-01_dp,  3.900000e-02_dp, &
       8.000000e-03_dp,  2.060000e-01_dp,  -2.060000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  4.000000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.500000e-01_dp,  1.000000e+00_dp,  2.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.500000e+00_dp,  2.500000e-01_dp,  1.000000e+00_dp, &
       2.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.500000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(71) :: STOICM_5 = (/ &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  3.000000e-01_dp, &
       1.000000e-01_dp,  4.000000e-01_dp,  1.000000e-01_dp,  1.000000e-01_dp,  -1.000000e+00_dp, &
       7.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  2.500000e-01_dp,  1.000000e+00_dp, &
       2.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.500000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  2.000000e-01_dp,  -1.000000e+00_dp,  8.000000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  4.000000e-01_dp,  -2.000000e+00_dp,  1.600000e+00_dp, &
       1.200000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(821) :: STOICM = (/&
    STOICM_0, STOICM_1, STOICM_2, STOICM_3, STOICM_4, &
    STOICM_5 /)


END MODULE MOZART_4_StoichiomSP

