! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Stoichiometric Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : MOZART_4_Stoichiom.f90
! Time                 : Mon Jul 19 09:14:05 2021
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_MOZART_4_11638_BOXMOX
! Equation file        : MOZART_4.kpp
! Output root filename : MOZART_4
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE MOZART_4_Stoichiom

  USE MOZART_4_Parameters
  USE MOZART_4_StoichiomSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ReactantProd - Reactant Products in each equation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      ARP       - Reactant product in each equation
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ReactantProd ( V, F, ARP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! ARP - Reactant product in each equation
  REAL(kind=dp) :: ARP(NREACT)


! Reactant Products in each equation are useful in the
!     stoichiometric formulation of mass action law
  ARP(1) = F(2)
  ARP(2) = V(81)
  ARP(3) = V(81)
  ARP(4) = V(3)
  ARP(5) = V(73)
  ARP(6) = V(13)
  ARP(7) = V(39)
  ARP(8) = V(80)
  ARP(9) = V(26)
  ARP(10) = V(18)
  ARP(11) = V(72)
  ARP(12) = V(72)
  ARP(13) = V(9)
  ARP(14) = V(62)
  ARP(15) = V(35)
  ARP(16) = V(32)
  ARP(17) = V(36)
  ARP(18) = V(43)
  ARP(19) = V(66)
  ARP(20) = V(69)
  ARP(21) = V(21)
  ARP(22) = V(22)
  ARP(23) = V(23)
  ARP(24) = V(51)
  ARP(25) = V(67)
  ARP(26) = V(15)
  ARP(27) = V(60)
  ARP(28) = V(42)
  ARP(29) = V(65)
  ARP(30) = V(54)
  ARP(31) = V(33)
  ARP(32) = V(45)
  ARP(33) = V(37)
  ARP(34) = V(48)
  ARP(35) = V(25)
  ARP(36) = V(31)
  ARP(37) = V(38)
  ARP(38) = V(52)*F(2)
  ARP(39) = V(52)*V(81)
  ARP(40) = V(47)*F(2)
  ARP(41) = V(47)*F(1)
  ARP(42) = V(19)*V(47)
  ARP(43) = V(19)*V(75)
  ARP(44) = V(52)*V(75)
  ARP(45) = V(52)*V(79)
  ARP(46) = V(75)*V(81)
  ARP(47) = V(79)*V(81)
  ARP(48) = V(79)*V(79)*F(1)
  ARP(49) = V(9)*V(75)
  ARP(50) = V(75)*V(79)
  ARP(51) = V(75)*V(75)
  ARP(52) = V(75)*V(75)
  ARP(53) = V(3)*V(47)
  ARP(54) = V(3)*V(47)
  ARP(55) = V(76)*V(79)
  ARP(56) = V(76)*V(81)
  ARP(57) = V(52)*V(73)
  ARP(58) = V(73)*V(81)
  ARP(59) = V(79)*V(80)
  ARP(60) = V(73)*V(80)
  ARP(61) = V(13)
  ARP(62) = V(73)*V(75)
  ARP(63) = V(39)*V(75)
  ARP(64) = V(76)*V(80)
  ARP(65) = V(73)*V(79)
  ARP(66) = V(26)*V(75)
  ARP(67) = V(26)
  ARP(68) = V(13)*F(2)
  ARP(69) = V(80)
  ARP(70) = V(73)
  ARP(71) = V(40)*V(75)
  ARP(72) = V(40)*V(47)
  ARP(73) = V(76)*V(77)
  ARP(74) = V(77)*V(77)
  ARP(75) = V(77)*V(77)
  ARP(76) = V(77)*V(79)
  ARP(77) = V(18)*V(75)
  ARP(78) = V(72)*V(80)
  ARP(79) = V(72)*V(75)
  ARP(80) = V(58)*V(75)
  ARP(81) = V(27)*V(75)
  ARP(82) = V(27)*V(81)
  ARP(83) = V(8)*V(75)
  ARP(84) = V(37)*V(75)
  ARP(85) = V(30)*V(76)
  ARP(86) = V(12)*F(2)
  ARP(87) = V(12)
  ARP(88) = V(4)*V(75)
  ARP(89) = V(56)*V(76)
  ARP(90) = V(56)*V(79)
  ARP(91) = V(56)*V(77)
  ARP(92) = V(21)*V(75)
  ARP(93) = V(61)*V(75)
  ARP(94) = V(61)*V(81)
  ARP(95) = V(61)*V(80)
  ARP(96) = V(50)*V(76)
  ARP(97) = V(50)*V(79)
  ARP(98) = V(35)*V(75)
  ARP(99) = V(62)*V(75)
  ARP(100) = V(62)*V(80)
  ARP(101) = V(76)*V(78)
  ARP(102) = V(73)*V(78)
  ARP(103) = V(78)*V(79)
  ARP(104) = V(77)*V(78)
  ARP(105) = V(32)*V(75)
  ARP(106) = V(36)
  ARP(107) = V(78)*V(78)
  ARP(108) = V(5)*V(75)
  ARP(109) = V(57)*V(76)
  ARP(110) = V(57)*V(79)
  ARP(111) = V(57)*V(77)
  ARP(112) = V(22)*V(75)
  ARP(113) = V(51)*V(75)
  ARP(114) = V(63)*V(76)
  ARP(115) = V(63)*V(79)
  ARP(116) = V(63)*V(77)
  ARP(117) = V(23)*V(75)
  ARP(118) = V(6)*V(75)
  ARP(119) = V(24)*V(76)
  ARP(120) = V(7)*V(75)
  ARP(121) = V(55)*V(76)
  ARP(122) = V(55)*V(79)
  ARP(123) = V(48)*V(75)
  ARP(124) = V(29)*V(75)
  ARP(125) = V(33)*V(75)
  ARP(126) = V(49)*V(76)
  ARP(127) = V(49)*V(79)
  ARP(128) = V(25)*V(75)
  ARP(129) = V(10)*V(75)
  ARP(130) = V(11)*V(75)
  ARP(131) = V(14)*V(73)
  ARP(132) = V(44)*V(76)
  ARP(133) = V(44)*V(79)
  ARP(134) = V(31)*V(75)
  ARP(135) = V(59)*V(75)
  ARP(136) = V(59)*V(81)
  ARP(137) = V(71)*V(76)
  ARP(138) = V(71)*V(80)
  ARP(139) = V(71)*V(79)
  ARP(140) = V(42)*V(75)
  ARP(141) = V(71)*V(77)
  ARP(142) = V(71)*V(78)
  ARP(143) = V(69)*V(75)
  ARP(144) = V(69)*V(81)
  ARP(145) = V(66)*V(75)
  ARP(146) = V(66)*V(81)
  ARP(147) = V(70)*V(76)
  ARP(148) = V(70)*V(76)
  ARP(149) = V(70)*V(80)
  ARP(150) = V(70)*V(79)
  ARP(151) = V(70)*V(77)
  ARP(152) = V(70)*V(78)
  ARP(153) = V(20)*V(75)
  ARP(154) = V(74)*V(76)
  ARP(155) = V(74)*V(80)
  ARP(156) = V(74)*V(79)
  ARP(157) = V(74)*V(77)
  ARP(158) = V(74)*V(78)
  ARP(159) = V(74)*V(74)
  ARP(160) = V(73)*V(74)*F(2)
  ARP(161) = V(43)*F(2)
  ARP(162) = V(46)*V(75)
  ARP(163) = V(46)*V(81)
  ARP(164) = V(46)*V(80)
  ARP(165) = V(64)*V(76)
  ARP(166) = V(64)*V(79)
  ARP(167) = V(38)*V(75)
  ARP(168) = V(34)*V(75)
  ARP(169) = V(59)*V(80)
  ARP(170) = V(53)*V(76)
  ARP(171) = V(53)*V(80)
  ARP(172) = V(53)*V(79)
  ARP(173) = V(67)*V(75)
  ARP(174) = V(67)*V(80)
  ARP(175) = V(60)*V(75)
  ARP(176) = V(60)*V(80)
  ARP(177) = V(28)*V(75)
  ARP(178) = V(68)*V(76)
  ARP(179) = V(68)*V(80)
  ARP(180) = V(68)*V(79)
  ARP(181) = V(68)*V(77)
  ARP(182) = V(68)*V(78)
  ARP(183) = V(15)*V(75)
  ARP(184) = V(15)*V(75)
  ARP(185) = V(41)*V(75)
  ARP(186) = V(17)*V(75)
  ARP(187) = V(43)*V(75)
  ARP(188) = V(36)*V(75)
  ARP(189) = V(65)*V(75)
  ARP(190) = V(54)*V(75)
  ARP(191) = V(16)*V(75)
  ARP(192) = V(16)*V(75)
  ARP(193) = V(16)*V(80)
  ARP(194) = V(2)*V(75)
  ARP(195) = V(79)
  ARP(196) = V(56)*V(56)
      
END SUBROUTINE ReactantProd

! End of ReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacReactantProd - Jacobian of Reactant Products vector
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      JVRP      - d ARP(1:NREACT)/d VAR (1:NVAR)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacReactantProd ( V, F, JVRP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! JVRP - d ARP(1:NREACT)/d VAR (1:NVAR)
  REAL(kind=dp) :: JVRP(NJVRP)


! Reactant Products in each equation are useful in the
!    stoichiometric formulation of mass action law
! Below we compute the Jacobian of the Reactant Products vector
!    w.r.t. variable species: d ARP(1:NREACT) / d Var(1:NVAR)

! JVRP(1) = dARP(2)/dV(81)
  JVRP(1) = 1
! JVRP(2) = dARP(3)/dV(81)
  JVRP(2) = 1
! JVRP(3) = dARP(4)/dV(3)
  JVRP(3) = 1
! JVRP(4) = dARP(5)/dV(73)
  JVRP(4) = 1
! JVRP(5) = dARP(6)/dV(13)
  JVRP(5) = 1
! JVRP(6) = dARP(7)/dV(39)
  JVRP(6) = 1
! JVRP(7) = dARP(8)/dV(80)
  JVRP(7) = 1
! JVRP(8) = dARP(9)/dV(26)
  JVRP(8) = 1
! JVRP(9) = dARP(10)/dV(18)
  JVRP(9) = 1
! JVRP(10) = dARP(11)/dV(72)
  JVRP(10) = 1
! JVRP(11) = dARP(12)/dV(72)
  JVRP(11) = 1
! JVRP(12) = dARP(13)/dV(9)
  JVRP(12) = 1
! JVRP(13) = dARP(14)/dV(62)
  JVRP(13) = 1
! JVRP(14) = dARP(15)/dV(35)
  JVRP(14) = 1
! JVRP(15) = dARP(16)/dV(32)
  JVRP(15) = 1
! JVRP(16) = dARP(17)/dV(36)
  JVRP(16) = 1
! JVRP(17) = dARP(18)/dV(43)
  JVRP(17) = 1
! JVRP(18) = dARP(19)/dV(66)
  JVRP(18) = 1
! JVRP(19) = dARP(20)/dV(69)
  JVRP(19) = 1
! JVRP(20) = dARP(21)/dV(21)
  JVRP(20) = 1
! JVRP(21) = dARP(22)/dV(22)
  JVRP(21) = 1
! JVRP(22) = dARP(23)/dV(23)
  JVRP(22) = 1
! JVRP(23) = dARP(24)/dV(51)
  JVRP(23) = 1
! JVRP(24) = dARP(25)/dV(67)
  JVRP(24) = 1
! JVRP(25) = dARP(26)/dV(15)
  JVRP(25) = 1
! JVRP(26) = dARP(27)/dV(60)
  JVRP(26) = 1
! JVRP(27) = dARP(28)/dV(42)
  JVRP(27) = 1
! JVRP(28) = dARP(29)/dV(65)
  JVRP(28) = 1
! JVRP(29) = dARP(30)/dV(54)
  JVRP(29) = 1
! JVRP(30) = dARP(31)/dV(33)
  JVRP(30) = 1
! JVRP(31) = dARP(32)/dV(45)
  JVRP(31) = 1
! JVRP(32) = dARP(33)/dV(37)
  JVRP(32) = 1
! JVRP(33) = dARP(34)/dV(48)
  JVRP(33) = 1
! JVRP(34) = dARP(35)/dV(25)
  JVRP(34) = 1
! JVRP(35) = dARP(36)/dV(31)
  JVRP(35) = 1
! JVRP(36) = dARP(37)/dV(38)
  JVRP(36) = 1
! JVRP(37) = dARP(38)/dV(52)
  JVRP(37) = F(2)
! JVRP(38) = dARP(39)/dV(52)
  JVRP(38) = V(81)
! JVRP(39) = dARP(39)/dV(81)
  JVRP(39) = V(52)
! JVRP(40) = dARP(40)/dV(47)
  JVRP(40) = F(2)
! JVRP(41) = dARP(41)/dV(47)
  JVRP(41) = F(1)
! JVRP(42) = dARP(42)/dV(19)
  JVRP(42) = V(47)
! JVRP(43) = dARP(42)/dV(47)
  JVRP(43) = V(19)
! JVRP(44) = dARP(43)/dV(19)
  JVRP(44) = V(75)
! JVRP(45) = dARP(43)/dV(75)
  JVRP(45) = V(19)
! JVRP(46) = dARP(44)/dV(52)
  JVRP(46) = V(75)
! JVRP(47) = dARP(44)/dV(75)
  JVRP(47) = V(52)
! JVRP(48) = dARP(45)/dV(52)
  JVRP(48) = V(79)
! JVRP(49) = dARP(45)/dV(79)
  JVRP(49) = V(52)
! JVRP(50) = dARP(46)/dV(75)
  JVRP(50) = V(81)
! JVRP(51) = dARP(46)/dV(81)
  JVRP(51) = V(75)
! JVRP(52) = dARP(47)/dV(79)
  JVRP(52) = V(81)
! JVRP(53) = dARP(47)/dV(81)
  JVRP(53) = V(79)
! JVRP(54) = dARP(48)/dV(79)
  JVRP(54) = 2*V(79)*F(1)
! JVRP(55) = dARP(49)/dV(9)
  JVRP(55) = V(75)
! JVRP(56) = dARP(49)/dV(75)
  JVRP(56) = V(9)
! JVRP(57) = dARP(50)/dV(75)
  JVRP(57) = V(79)
! JVRP(58) = dARP(50)/dV(79)
  JVRP(58) = V(75)
! JVRP(59) = dARP(51)/dV(75)
  JVRP(59) = 2*V(75)
! JVRP(60) = dARP(52)/dV(75)
  JVRP(60) = 2*V(75)
! JVRP(61) = dARP(53)/dV(3)
  JVRP(61) = V(47)
! JVRP(62) = dARP(53)/dV(47)
  JVRP(62) = V(3)
! JVRP(63) = dARP(54)/dV(3)
  JVRP(63) = V(47)
! JVRP(64) = dARP(54)/dV(47)
  JVRP(64) = V(3)
! JVRP(65) = dARP(55)/dV(76)
  JVRP(65) = V(79)
! JVRP(66) = dARP(55)/dV(79)
  JVRP(66) = V(76)
! JVRP(67) = dARP(56)/dV(76)
  JVRP(67) = V(81)
! JVRP(68) = dARP(56)/dV(81)
  JVRP(68) = V(76)
! JVRP(69) = dARP(57)/dV(52)
  JVRP(69) = V(73)
! JVRP(70) = dARP(57)/dV(73)
  JVRP(70) = V(52)
! JVRP(71) = dARP(58)/dV(73)
  JVRP(71) = V(81)
! JVRP(72) = dARP(58)/dV(81)
  JVRP(72) = V(73)
! JVRP(73) = dARP(59)/dV(79)
  JVRP(73) = V(80)
! JVRP(74) = dARP(59)/dV(80)
  JVRP(74) = V(79)
! JVRP(75) = dARP(60)/dV(73)
  JVRP(75) = V(80)
! JVRP(76) = dARP(60)/dV(80)
  JVRP(76) = V(73)
! JVRP(77) = dARP(61)/dV(13)
  JVRP(77) = 1
! JVRP(78) = dARP(62)/dV(73)
  JVRP(78) = V(75)
! JVRP(79) = dARP(62)/dV(75)
  JVRP(79) = V(73)
! JVRP(80) = dARP(63)/dV(39)
  JVRP(80) = V(75)
! JVRP(81) = dARP(63)/dV(75)
  JVRP(81) = V(39)
! JVRP(82) = dARP(64)/dV(76)
  JVRP(82) = V(80)
! JVRP(83) = dARP(64)/dV(80)
  JVRP(83) = V(76)
! JVRP(84) = dARP(65)/dV(73)
  JVRP(84) = V(79)
! JVRP(85) = dARP(65)/dV(79)
  JVRP(85) = V(73)
! JVRP(86) = dARP(66)/dV(26)
  JVRP(86) = V(75)
! JVRP(87) = dARP(66)/dV(75)
  JVRP(87) = V(26)
! JVRP(88) = dARP(67)/dV(26)
  JVRP(88) = 1
! JVRP(89) = dARP(68)/dV(13)
  JVRP(89) = F(2)
! JVRP(90) = dARP(69)/dV(80)
  JVRP(90) = 1
! JVRP(91) = dARP(70)/dV(73)
  JVRP(91) = 1
! JVRP(92) = dARP(71)/dV(40)
  JVRP(92) = V(75)
! JVRP(93) = dARP(71)/dV(75)
  JVRP(93) = V(40)
! JVRP(94) = dARP(72)/dV(40)
  JVRP(94) = V(47)
! JVRP(95) = dARP(72)/dV(47)
  JVRP(95) = V(40)
! JVRP(96) = dARP(73)/dV(76)
  JVRP(96) = V(77)
! JVRP(97) = dARP(73)/dV(77)
  JVRP(97) = V(76)
! JVRP(98) = dARP(74)/dV(77)
  JVRP(98) = 2*V(77)
! JVRP(99) = dARP(75)/dV(77)
  JVRP(99) = 2*V(77)
! JVRP(100) = dARP(76)/dV(77)
  JVRP(100) = V(79)
! JVRP(101) = dARP(76)/dV(79)
  JVRP(101) = V(77)
! JVRP(102) = dARP(77)/dV(18)
  JVRP(102) = V(75)
! JVRP(103) = dARP(77)/dV(75)
  JVRP(103) = V(18)
! JVRP(104) = dARP(78)/dV(72)
  JVRP(104) = V(80)
! JVRP(105) = dARP(78)/dV(80)
  JVRP(105) = V(72)
! JVRP(106) = dARP(79)/dV(72)
  JVRP(106) = V(75)
! JVRP(107) = dARP(79)/dV(75)
  JVRP(107) = V(72)
! JVRP(108) = dARP(80)/dV(58)
  JVRP(108) = V(75)
! JVRP(109) = dARP(80)/dV(75)
  JVRP(109) = V(58)
! JVRP(110) = dARP(81)/dV(27)
  JVRP(110) = V(75)
! JVRP(111) = dARP(81)/dV(75)
  JVRP(111) = V(27)
! JVRP(112) = dARP(82)/dV(27)
  JVRP(112) = V(81)
! JVRP(113) = dARP(82)/dV(81)
  JVRP(113) = V(27)
! JVRP(114) = dARP(83)/dV(8)
  JVRP(114) = V(75)
! JVRP(115) = dARP(83)/dV(75)
  JVRP(115) = V(8)
! JVRP(116) = dARP(84)/dV(37)
  JVRP(116) = V(75)
! JVRP(117) = dARP(84)/dV(75)
  JVRP(117) = V(37)
! JVRP(118) = dARP(85)/dV(30)
  JVRP(118) = V(76)
! JVRP(119) = dARP(85)/dV(76)
  JVRP(119) = V(30)
! JVRP(120) = dARP(86)/dV(12)
  JVRP(120) = F(2)
! JVRP(121) = dARP(87)/dV(12)
  JVRP(121) = 1
! JVRP(122) = dARP(88)/dV(4)
  JVRP(122) = V(75)
! JVRP(123) = dARP(88)/dV(75)
  JVRP(123) = V(4)
! JVRP(124) = dARP(89)/dV(56)
  JVRP(124) = V(76)
! JVRP(125) = dARP(89)/dV(76)
  JVRP(125) = V(56)
! JVRP(126) = dARP(90)/dV(56)
  JVRP(126) = V(79)
! JVRP(127) = dARP(90)/dV(79)
  JVRP(127) = V(56)
! JVRP(128) = dARP(91)/dV(56)
  JVRP(128) = V(77)
! JVRP(129) = dARP(91)/dV(77)
  JVRP(129) = V(56)
! JVRP(130) = dARP(92)/dV(21)
  JVRP(130) = V(75)
! JVRP(131) = dARP(92)/dV(75)
  JVRP(131) = V(21)
! JVRP(132) = dARP(93)/dV(61)
  JVRP(132) = V(75)
! JVRP(133) = dARP(93)/dV(75)
  JVRP(133) = V(61)
! JVRP(134) = dARP(94)/dV(61)
  JVRP(134) = V(81)
! JVRP(135) = dARP(94)/dV(81)
  JVRP(135) = V(61)
! JVRP(136) = dARP(95)/dV(61)
  JVRP(136) = V(80)
! JVRP(137) = dARP(95)/dV(80)
  JVRP(137) = V(61)
! JVRP(138) = dARP(96)/dV(50)
  JVRP(138) = V(76)
! JVRP(139) = dARP(96)/dV(76)
  JVRP(139) = V(50)
! JVRP(140) = dARP(97)/dV(50)
  JVRP(140) = V(79)
! JVRP(141) = dARP(97)/dV(79)
  JVRP(141) = V(50)
! JVRP(142) = dARP(98)/dV(35)
  JVRP(142) = V(75)
! JVRP(143) = dARP(98)/dV(75)
  JVRP(143) = V(35)
! JVRP(144) = dARP(99)/dV(62)
  JVRP(144) = V(75)
! JVRP(145) = dARP(99)/dV(75)
  JVRP(145) = V(62)
! JVRP(146) = dARP(100)/dV(62)
  JVRP(146) = V(80)
! JVRP(147) = dARP(100)/dV(80)
  JVRP(147) = V(62)
! JVRP(148) = dARP(101)/dV(76)
  JVRP(148) = V(78)
! JVRP(149) = dARP(101)/dV(78)
  JVRP(149) = V(76)
! JVRP(150) = dARP(102)/dV(73)
  JVRP(150) = V(78)
! JVRP(151) = dARP(102)/dV(78)
  JVRP(151) = V(73)
! JVRP(152) = dARP(103)/dV(78)
  JVRP(152) = V(79)
! JVRP(153) = dARP(103)/dV(79)
  JVRP(153) = V(78)
! JVRP(154) = dARP(104)/dV(77)
  JVRP(154) = V(78)
! JVRP(155) = dARP(104)/dV(78)
  JVRP(155) = V(77)
! JVRP(156) = dARP(105)/dV(32)
  JVRP(156) = V(75)
! JVRP(157) = dARP(105)/dV(75)
  JVRP(157) = V(32)
! JVRP(158) = dARP(106)/dV(36)
  JVRP(158) = 1
! JVRP(159) = dARP(107)/dV(78)
  JVRP(159) = 2*V(78)
! JVRP(160) = dARP(108)/dV(5)
  JVRP(160) = V(75)
! JVRP(161) = dARP(108)/dV(75)
  JVRP(161) = V(5)
! JVRP(162) = dARP(109)/dV(57)
  JVRP(162) = V(76)
! JVRP(163) = dARP(109)/dV(76)
  JVRP(163) = V(57)
! JVRP(164) = dARP(110)/dV(57)
  JVRP(164) = V(79)
! JVRP(165) = dARP(110)/dV(79)
  JVRP(165) = V(57)
! JVRP(166) = dARP(111)/dV(57)
  JVRP(166) = V(77)
! JVRP(167) = dARP(111)/dV(77)
  JVRP(167) = V(57)
! JVRP(168) = dARP(112)/dV(22)
  JVRP(168) = V(75)
! JVRP(169) = dARP(112)/dV(75)
  JVRP(169) = V(22)
! JVRP(170) = dARP(113)/dV(51)
  JVRP(170) = V(75)
! JVRP(171) = dARP(113)/dV(75)
  JVRP(171) = V(51)
! JVRP(172) = dARP(114)/dV(63)
  JVRP(172) = V(76)
! JVRP(173) = dARP(114)/dV(76)
  JVRP(173) = V(63)
! JVRP(174) = dARP(115)/dV(63)
  JVRP(174) = V(79)
! JVRP(175) = dARP(115)/dV(79)
  JVRP(175) = V(63)
! JVRP(176) = dARP(116)/dV(63)
  JVRP(176) = V(77)
! JVRP(177) = dARP(116)/dV(77)
  JVRP(177) = V(63)
! JVRP(178) = dARP(117)/dV(23)
  JVRP(178) = V(75)
! JVRP(179) = dARP(117)/dV(75)
  JVRP(179) = V(23)
! JVRP(180) = dARP(118)/dV(6)
  JVRP(180) = V(75)
! JVRP(181) = dARP(118)/dV(75)
  JVRP(181) = V(6)
! JVRP(182) = dARP(119)/dV(24)
  JVRP(182) = V(76)
! JVRP(183) = dARP(119)/dV(76)
  JVRP(183) = V(24)
! JVRP(184) = dARP(120)/dV(7)
  JVRP(184) = V(75)
! JVRP(185) = dARP(120)/dV(75)
  JVRP(185) = V(7)
! JVRP(186) = dARP(121)/dV(55)
  JVRP(186) = V(76)
! JVRP(187) = dARP(121)/dV(76)
  JVRP(187) = V(55)
! JVRP(188) = dARP(122)/dV(55)
  JVRP(188) = V(79)
! JVRP(189) = dARP(122)/dV(79)
  JVRP(189) = V(55)
! JVRP(190) = dARP(123)/dV(48)
  JVRP(190) = V(75)
! JVRP(191) = dARP(123)/dV(75)
  JVRP(191) = V(48)
! JVRP(192) = dARP(124)/dV(29)
  JVRP(192) = V(75)
! JVRP(193) = dARP(124)/dV(75)
  JVRP(193) = V(29)
! JVRP(194) = dARP(125)/dV(33)
  JVRP(194) = V(75)
! JVRP(195) = dARP(125)/dV(75)
  JVRP(195) = V(33)
! JVRP(196) = dARP(126)/dV(49)
  JVRP(196) = V(76)
! JVRP(197) = dARP(126)/dV(76)
  JVRP(197) = V(49)
! JVRP(198) = dARP(127)/dV(49)
  JVRP(198) = V(79)
! JVRP(199) = dARP(127)/dV(79)
  JVRP(199) = V(49)
! JVRP(200) = dARP(128)/dV(25)
  JVRP(200) = V(75)
! JVRP(201) = dARP(128)/dV(75)
  JVRP(201) = V(25)
! JVRP(202) = dARP(129)/dV(10)
  JVRP(202) = V(75)
! JVRP(203) = dARP(129)/dV(75)
  JVRP(203) = V(10)
! JVRP(204) = dARP(130)/dV(11)
  JVRP(204) = V(75)
! JVRP(205) = dARP(130)/dV(75)
  JVRP(205) = V(11)
! JVRP(206) = dARP(131)/dV(14)
  JVRP(206) = V(73)
! JVRP(207) = dARP(131)/dV(73)
  JVRP(207) = V(14)
! JVRP(208) = dARP(132)/dV(44)
  JVRP(208) = V(76)
! JVRP(209) = dARP(132)/dV(76)
  JVRP(209) = V(44)
! JVRP(210) = dARP(133)/dV(44)
  JVRP(210) = V(79)
! JVRP(211) = dARP(133)/dV(79)
  JVRP(211) = V(44)
! JVRP(212) = dARP(134)/dV(31)
  JVRP(212) = V(75)
! JVRP(213) = dARP(134)/dV(75)
  JVRP(213) = V(31)
! JVRP(214) = dARP(135)/dV(59)
  JVRP(214) = V(75)
! JVRP(215) = dARP(135)/dV(75)
  JVRP(215) = V(59)
! JVRP(216) = dARP(136)/dV(59)
  JVRP(216) = V(81)
! JVRP(217) = dARP(136)/dV(81)
  JVRP(217) = V(59)
! JVRP(218) = dARP(137)/dV(71)
  JVRP(218) = V(76)
! JVRP(219) = dARP(137)/dV(76)
  JVRP(219) = V(71)
! JVRP(220) = dARP(138)/dV(71)
  JVRP(220) = V(80)
! JVRP(221) = dARP(138)/dV(80)
  JVRP(221) = V(71)
! JVRP(222) = dARP(139)/dV(71)
  JVRP(222) = V(79)
! JVRP(223) = dARP(139)/dV(79)
  JVRP(223) = V(71)
! JVRP(224) = dARP(140)/dV(42)
  JVRP(224) = V(75)
! JVRP(225) = dARP(140)/dV(75)
  JVRP(225) = V(42)
! JVRP(226) = dARP(141)/dV(71)
  JVRP(226) = V(77)
! JVRP(227) = dARP(141)/dV(77)
  JVRP(227) = V(71)
! JVRP(228) = dARP(142)/dV(71)
  JVRP(228) = V(78)
! JVRP(229) = dARP(142)/dV(78)
  JVRP(229) = V(71)
! JVRP(230) = dARP(143)/dV(69)
  JVRP(230) = V(75)
! JVRP(231) = dARP(143)/dV(75)
  JVRP(231) = V(69)
! JVRP(232) = dARP(144)/dV(69)
  JVRP(232) = V(81)
! JVRP(233) = dARP(144)/dV(81)
  JVRP(233) = V(69)
! JVRP(234) = dARP(145)/dV(66)
  JVRP(234) = V(75)
! JVRP(235) = dARP(145)/dV(75)
  JVRP(235) = V(66)
! JVRP(236) = dARP(146)/dV(66)
  JVRP(236) = V(81)
! JVRP(237) = dARP(146)/dV(81)
  JVRP(237) = V(66)
! JVRP(238) = dARP(147)/dV(70)
  JVRP(238) = V(76)
! JVRP(239) = dARP(147)/dV(76)
  JVRP(239) = V(70)
! JVRP(240) = dARP(148)/dV(70)
  JVRP(240) = V(76)
! JVRP(241) = dARP(148)/dV(76)
  JVRP(241) = V(70)
! JVRP(242) = dARP(149)/dV(70)
  JVRP(242) = V(80)
! JVRP(243) = dARP(149)/dV(80)
  JVRP(243) = V(70)
! JVRP(244) = dARP(150)/dV(70)
  JVRP(244) = V(79)
! JVRP(245) = dARP(150)/dV(79)
  JVRP(245) = V(70)
! JVRP(246) = dARP(151)/dV(70)
  JVRP(246) = V(77)
! JVRP(247) = dARP(151)/dV(77)
  JVRP(247) = V(70)
! JVRP(248) = dARP(152)/dV(70)
  JVRP(248) = V(78)
! JVRP(249) = dARP(152)/dV(78)
  JVRP(249) = V(70)
! JVRP(250) = dARP(153)/dV(20)
  JVRP(250) = V(75)
! JVRP(251) = dARP(153)/dV(75)
  JVRP(251) = V(20)
! JVRP(252) = dARP(154)/dV(74)
  JVRP(252) = V(76)
! JVRP(253) = dARP(154)/dV(76)
  JVRP(253) = V(74)
! JVRP(254) = dARP(155)/dV(74)
  JVRP(254) = V(80)
! JVRP(255) = dARP(155)/dV(80)
  JVRP(255) = V(74)
! JVRP(256) = dARP(156)/dV(74)
  JVRP(256) = V(79)
! JVRP(257) = dARP(156)/dV(79)
  JVRP(257) = V(74)
! JVRP(258) = dARP(157)/dV(74)
  JVRP(258) = V(77)
! JVRP(259) = dARP(157)/dV(77)
  JVRP(259) = V(74)
! JVRP(260) = dARP(158)/dV(74)
  JVRP(260) = V(78)
! JVRP(261) = dARP(158)/dV(78)
  JVRP(261) = V(74)
! JVRP(262) = dARP(159)/dV(74)
  JVRP(262) = 2*V(74)
! JVRP(263) = dARP(160)/dV(73)
  JVRP(263) = V(74)*F(2)
! JVRP(264) = dARP(160)/dV(74)
  JVRP(264) = V(73)*F(2)
! JVRP(265) = dARP(161)/dV(43)
  JVRP(265) = F(2)
! JVRP(266) = dARP(162)/dV(46)
  JVRP(266) = V(75)
! JVRP(267) = dARP(162)/dV(75)
  JVRP(267) = V(46)
! JVRP(268) = dARP(163)/dV(46)
  JVRP(268) = V(81)
! JVRP(269) = dARP(163)/dV(81)
  JVRP(269) = V(46)
! JVRP(270) = dARP(164)/dV(46)
  JVRP(270) = V(80)
! JVRP(271) = dARP(164)/dV(80)
  JVRP(271) = V(46)
! JVRP(272) = dARP(165)/dV(64)
  JVRP(272) = V(76)
! JVRP(273) = dARP(165)/dV(76)
  JVRP(273) = V(64)
! JVRP(274) = dARP(166)/dV(64)
  JVRP(274) = V(79)
! JVRP(275) = dARP(166)/dV(79)
  JVRP(275) = V(64)
! JVRP(276) = dARP(167)/dV(38)
  JVRP(276) = V(75)
! JVRP(277) = dARP(167)/dV(75)
  JVRP(277) = V(38)
! JVRP(278) = dARP(168)/dV(34)
  JVRP(278) = V(75)
! JVRP(279) = dARP(168)/dV(75)
  JVRP(279) = V(34)
! JVRP(280) = dARP(169)/dV(59)
  JVRP(280) = V(80)
! JVRP(281) = dARP(169)/dV(80)
  JVRP(281) = V(59)
! JVRP(282) = dARP(170)/dV(53)
  JVRP(282) = V(76)
! JVRP(283) = dARP(170)/dV(76)
  JVRP(283) = V(53)
! JVRP(284) = dARP(171)/dV(53)
  JVRP(284) = V(80)
! JVRP(285) = dARP(171)/dV(80)
  JVRP(285) = V(53)
! JVRP(286) = dARP(172)/dV(53)
  JVRP(286) = V(79)
! JVRP(287) = dARP(172)/dV(79)
  JVRP(287) = V(53)
! JVRP(288) = dARP(173)/dV(67)
  JVRP(288) = V(75)
! JVRP(289) = dARP(173)/dV(75)
  JVRP(289) = V(67)
! JVRP(290) = dARP(174)/dV(67)
  JVRP(290) = V(80)
! JVRP(291) = dARP(174)/dV(80)
  JVRP(291) = V(67)
! JVRP(292) = dARP(175)/dV(60)
  JVRP(292) = V(75)
! JVRP(293) = dARP(175)/dV(75)
  JVRP(293) = V(60)
! JVRP(294) = dARP(176)/dV(60)
  JVRP(294) = V(80)
! JVRP(295) = dARP(176)/dV(80)
  JVRP(295) = V(60)
! JVRP(296) = dARP(177)/dV(28)
  JVRP(296) = V(75)
! JVRP(297) = dARP(177)/dV(75)
  JVRP(297) = V(28)
! JVRP(298) = dARP(178)/dV(68)
  JVRP(298) = V(76)
! JVRP(299) = dARP(178)/dV(76)
  JVRP(299) = V(68)
! JVRP(300) = dARP(179)/dV(68)
  JVRP(300) = V(80)
! JVRP(301) = dARP(179)/dV(80)
  JVRP(301) = V(68)
! JVRP(302) = dARP(180)/dV(68)
  JVRP(302) = V(79)
! JVRP(303) = dARP(180)/dV(79)
  JVRP(303) = V(68)
! JVRP(304) = dARP(181)/dV(68)
  JVRP(304) = V(77)
! JVRP(305) = dARP(181)/dV(77)
  JVRP(305) = V(68)
! JVRP(306) = dARP(182)/dV(68)
  JVRP(306) = V(78)
! JVRP(307) = dARP(182)/dV(78)
  JVRP(307) = V(68)
! JVRP(308) = dARP(183)/dV(15)
  JVRP(308) = V(75)
! JVRP(309) = dARP(183)/dV(75)
  JVRP(309) = V(15)
! JVRP(310) = dARP(184)/dV(15)
  JVRP(310) = V(75)
! JVRP(311) = dARP(184)/dV(75)
  JVRP(311) = V(15)
! JVRP(312) = dARP(185)/dV(41)
  JVRP(312) = V(75)
! JVRP(313) = dARP(185)/dV(75)
  JVRP(313) = V(41)
! JVRP(314) = dARP(186)/dV(17)
  JVRP(314) = V(75)
! JVRP(315) = dARP(186)/dV(75)
  JVRP(315) = V(17)
! JVRP(316) = dARP(187)/dV(43)
  JVRP(316) = V(75)
! JVRP(317) = dARP(187)/dV(75)
  JVRP(317) = V(43)
! JVRP(318) = dARP(188)/dV(36)
  JVRP(318) = V(75)
! JVRP(319) = dARP(188)/dV(75)
  JVRP(319) = V(36)
! JVRP(320) = dARP(189)/dV(65)
  JVRP(320) = V(75)
! JVRP(321) = dARP(189)/dV(75)
  JVRP(321) = V(65)
! JVRP(322) = dARP(190)/dV(54)
  JVRP(322) = V(75)
! JVRP(323) = dARP(190)/dV(75)
  JVRP(323) = V(54)
! JVRP(324) = dARP(191)/dV(16)
  JVRP(324) = V(75)
! JVRP(325) = dARP(191)/dV(75)
  JVRP(325) = V(16)
! JVRP(326) = dARP(192)/dV(16)
  JVRP(326) = V(75)
! JVRP(327) = dARP(192)/dV(75)
  JVRP(327) = V(16)
! JVRP(328) = dARP(193)/dV(16)
  JVRP(328) = V(80)
! JVRP(329) = dARP(193)/dV(80)
  JVRP(329) = V(16)
! JVRP(330) = dARP(194)/dV(2)
  JVRP(330) = V(75)
! JVRP(331) = dARP(194)/dV(75)
  JVRP(331) = V(2)
! JVRP(332) = dARP(195)/dV(79)
  JVRP(332) = 1
! JVRP(333) = dARP(196)/dV(56)
  JVRP(333) = 2*V(56)
      
END SUBROUTINE JacReactantProd

! End of JacReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



! Begin Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Fun with respect to rate coefficients
! -----------------------------------------------------------------------------

      SUBROUTINE  dFun_dRcoeff( V, F, NCOEFF, JCOEFF, DFDR )
       
      USE MOZART_4_Parameters
      USE MOZART_4_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/radical/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Fun(1:NVAR) / d RCT( JCOEFF(j) )
!         for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DFDR(NVAR*NCOEFF)

! Local vector with reactant products
      REAL(kind=dp) A_RPROD(NREACT)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the reactant products of all reactions     
      CALL ReactantProd ( V, F, A_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_RPROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DFDR(i+NVAR*(j-1)) = 0.0_dp 
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  reactant product  of the JCOEFF(j)-th reaction      
!                  give the j-th column of the derivative matrix   
         aj = A_RPROD(JCOEFF(j))
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DFDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dFun_dRcoeff

! End Derivative w.r.t. Rate Coefficients


! Begin Jacobian Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Jac with respect to rate coefficients
! Times a user vector
! -----------------------------------------------------------------------------

      SUBROUTINE  dJac_dRcoeff( V, F, U, NCOEFF, JCOEFF, DJDR )
       
      USE MOZART_4_Parameters
      USE MOZART_4_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! U - User-supplied Vector           
      REAL(kind=dp) U(NVAR)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Jac(1:NVAR) / d RCT( JCOEFF(j) ) * U
!                     for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DJDR(NVAR*NCOEFF)

! Local vector for Jacobian of reactant products
      REAL(kind=dp) JV_RPROD(NJVRP)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the Jacobian of all reactant products   
      CALL JacReactantProd( V, F, JV_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_PROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DJDR(i+NVAR*(j-1)) = 0.0_dp
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  ( Gradient of reactant product of the JCOEFF(j)-th reaction X user vector )    
!                  give the j-th column of the derivative matrix   
!
!          Row JCOEFF(j) of JV_RPROD times the user vector
         aj = 0.0_dp
         DO k=CROW_JVRP(JCOEFF(j)),CROW_JVRP(JCOEFF(j)+1)-1
             aj = aj + JV_RPROD(k)*U(ICOL_JVRP(k))
         END DO
!          Column JCOEFF(j) of Stoichiom. matrix times aj         
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DJDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dJac_dRcoeff

! End Jacobian Derivative w.r.t. Rate Coefficients


END MODULE MOZART_4_Stoichiom

