! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : MOZART_4_Function.f90
! Time                 : Mon Jul 19 09:14:05 2021
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_MOZART_4_11638_BOXMOX
! Equation file        : MOZART_4.kpp
! Output root filename : MOZART_4
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE MOZART_4_Function

  USE MOZART_4_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*F(2)
  A(2) = RCT(2)*V(81)
  A(3) = RCT(3)*V(81)
  A(4) = RCT(4)*V(3)
  A(5) = RCT(5)*V(73)
  A(6) = RCT(6)*V(13)
  A(7) = RCT(7)*V(39)
  A(8) = RCT(8)*V(80)
  A(9) = RCT(9)*V(26)
  A(10) = RCT(10)*V(18)
  A(11) = RCT(11)*V(72)
  A(12) = RCT(12)*V(72)
  A(13) = RCT(13)*V(9)
  A(14) = RCT(14)*V(62)
  A(15) = RCT(15)*V(35)
  A(16) = RCT(16)*V(32)
  A(17) = RCT(17)*V(36)
  A(18) = RCT(18)*V(43)
  A(19) = RCT(19)*V(66)
  A(20) = RCT(20)*V(69)
  A(21) = RCT(21)*V(21)
  A(22) = RCT(22)*V(22)
  A(23) = RCT(23)*V(23)
  A(24) = RCT(24)*V(51)
  A(25) = RCT(25)*V(67)
  A(26) = RCT(26)*V(15)
  A(27) = RCT(27)*V(60)
  A(28) = RCT(28)*V(42)
  A(29) = RCT(29)*V(65)
  A(30) = RCT(30)*V(54)
  A(31) = RCT(31)*V(33)
  A(32) = RCT(32)*V(45)
  A(33) = RCT(33)*V(37)
  A(34) = RCT(34)*V(48)
  A(35) = RCT(35)*V(25)
  A(36) = RCT(36)*V(31)
  A(37) = RCT(37)*V(38)
  A(38) = RCT(38)*V(52)*F(2)
  A(39) = RCT(39)*V(52)*V(81)
  A(40) = RCT(40)*V(47)*F(2)
  A(41) = RCT(41)*V(47)*F(1)
  A(42) = RCT(42)*V(19)*V(47)
  A(43) = RCT(43)*V(19)*V(75)
  A(44) = RCT(44)*V(52)*V(75)
  A(45) = RCT(45)*V(52)*V(79)
  A(46) = RCT(46)*V(75)*V(81)
  A(47) = RCT(47)*V(79)*V(81)
  A(48) = RCT(48)*V(79)*V(79)*F(1)
  A(49) = RCT(49)*V(9)*V(75)
  A(50) = RCT(50)*V(75)*V(79)
  A(51) = RCT(51)*V(75)*V(75)
  A(52) = RCT(52)*V(75)*V(75)
  A(53) = RCT(53)*V(3)*V(47)
  A(54) = RCT(54)*V(3)*V(47)
  A(55) = RCT(55)*V(76)*V(79)
  A(56) = RCT(56)*V(76)*V(81)
  A(57) = RCT(57)*V(52)*V(73)
  A(58) = RCT(58)*V(73)*V(81)
  A(59) = RCT(59)*V(79)*V(80)
  A(60) = RCT(60)*V(73)*V(80)
  A(61) = RCT(61)*V(13)
  A(62) = RCT(62)*V(73)*V(75)
  A(63) = RCT(63)*V(39)*V(75)
  A(64) = RCT(64)*V(76)*V(80)
  A(65) = RCT(65)*V(73)*V(79)
  A(66) = RCT(66)*V(26)*V(75)
  A(67) = RCT(67)*V(26)
  A(68) = RCT(68)*V(13)*F(2)
  A(69) = RCT(69)*V(80)
  A(70) = RCT(70)*V(73)
  A(71) = RCT(71)*V(40)*V(75)
  A(72) = RCT(72)*V(40)*V(47)
  A(73) = RCT(73)*V(76)*V(77)
  A(74) = RCT(74)*V(77)*V(77)
  A(75) = RCT(75)*V(77)*V(77)
  A(76) = RCT(76)*V(77)*V(79)
  A(77) = RCT(77)*V(18)*V(75)
  A(78) = RCT(78)*V(72)*V(80)
  A(79) = RCT(79)*V(72)*V(75)
  A(80) = RCT(80)*V(58)*V(75)
  A(81) = RCT(81)*V(27)*V(75)
  A(82) = RCT(82)*V(27)*V(81)
  A(83) = RCT(83)*V(8)*V(75)
  A(84) = RCT(84)*V(37)*V(75)
  A(85) = RCT(85)*V(30)*V(76)
  A(86) = RCT(86)*V(12)*F(2)
  A(87) = RCT(87)*V(12)
  A(88) = RCT(88)*V(4)*V(75)
  A(89) = RCT(89)*V(56)*V(76)
  A(90) = RCT(90)*V(56)*V(79)
  A(91) = RCT(91)*V(56)*V(77)
  A(92) = RCT(92)*V(21)*V(75)
  A(93) = RCT(93)*V(61)*V(75)
  A(94) = RCT(94)*V(61)*V(81)
  A(95) = RCT(95)*V(61)*V(80)
  A(96) = RCT(96)*V(50)*V(76)
  A(97) = RCT(97)*V(50)*V(79)
  A(98) = RCT(98)*V(35)*V(75)
  A(99) = RCT(99)*V(62)*V(75)
  A(100) = RCT(100)*V(62)*V(80)
  A(101) = RCT(101)*V(76)*V(78)
  A(102) = RCT(102)*V(73)*V(78)
  A(103) = RCT(103)*V(78)*V(79)
  A(104) = RCT(104)*V(77)*V(78)
  A(105) = RCT(105)*V(32)*V(75)
  A(106) = RCT(106)*V(36)
  A(107) = RCT(107)*V(78)*V(78)
  A(108) = RCT(108)*V(5)*V(75)
  A(109) = RCT(109)*V(57)*V(76)
  A(110) = RCT(110)*V(57)*V(79)
  A(111) = RCT(111)*V(57)*V(77)
  A(112) = RCT(112)*V(22)*V(75)
  A(113) = RCT(113)*V(51)*V(75)
  A(114) = RCT(114)*V(63)*V(76)
  A(115) = RCT(115)*V(63)*V(79)
  A(116) = RCT(116)*V(63)*V(77)
  A(117) = RCT(117)*V(23)*V(75)
  A(118) = RCT(118)*V(6)*V(75)
  A(119) = RCT(119)*V(24)*V(76)
  A(120) = RCT(120)*V(7)*V(75)
  A(121) = RCT(121)*V(55)*V(76)
  A(122) = RCT(122)*V(55)*V(79)
  A(123) = RCT(123)*V(48)*V(75)
  A(124) = RCT(124)*V(29)*V(75)
  A(125) = RCT(125)*V(33)*V(75)
  A(126) = RCT(126)*V(49)*V(76)
  A(127) = RCT(127)*V(49)*V(79)
  A(128) = RCT(128)*V(25)*V(75)
  A(129) = RCT(129)*V(10)*V(75)
  A(130) = RCT(130)*V(11)*V(75)
  A(131) = RCT(131)*V(14)*V(73)
  A(132) = RCT(132)*V(44)*V(76)
  A(133) = RCT(133)*V(44)*V(79)
  A(134) = RCT(134)*V(31)*V(75)
  A(135) = RCT(135)*V(59)*V(75)
  A(136) = RCT(136)*V(59)*V(81)
  A(137) = RCT(137)*V(71)*V(76)
  A(138) = RCT(138)*V(71)*V(80)
  A(139) = RCT(139)*V(71)*V(79)
  A(140) = RCT(140)*V(42)*V(75)
  A(141) = RCT(141)*V(71)*V(77)
  A(142) = RCT(142)*V(71)*V(78)
  A(143) = RCT(143)*V(69)*V(75)
  A(144) = RCT(144)*V(69)*V(81)
  A(145) = RCT(145)*V(66)*V(75)
  A(146) = RCT(146)*V(66)*V(81)
  A(147) = RCT(147)*V(70)*V(76)
  A(148) = RCT(148)*V(70)*V(76)
  A(149) = RCT(149)*V(70)*V(80)
  A(150) = RCT(150)*V(70)*V(79)
  A(151) = RCT(151)*V(70)*V(77)
  A(152) = RCT(152)*V(70)*V(78)
  A(153) = RCT(153)*V(20)*V(75)
  A(154) = RCT(154)*V(74)*V(76)
  A(155) = RCT(155)*V(74)*V(80)
  A(156) = RCT(156)*V(74)*V(79)
  A(157) = RCT(157)*V(74)*V(77)
  A(158) = RCT(158)*V(74)*V(78)
  A(159) = RCT(159)*V(74)*V(74)
  A(160) = RCT(160)*V(73)*V(74)*F(2)
  A(161) = RCT(161)*V(43)*F(2)
  A(162) = RCT(162)*V(46)*V(75)
  A(163) = RCT(163)*V(46)*V(81)
  A(164) = RCT(164)*V(46)*V(80)
  A(165) = RCT(165)*V(64)*V(76)
  A(166) = RCT(166)*V(64)*V(79)
  A(167) = RCT(167)*V(38)*V(75)
  A(168) = RCT(168)*V(34)*V(75)
  A(169) = RCT(169)*V(59)*V(80)
  A(170) = RCT(170)*V(53)*V(76)
  A(171) = RCT(171)*V(53)*V(80)
  A(172) = RCT(172)*V(53)*V(79)
  A(173) = RCT(173)*V(67)*V(75)
  A(174) = RCT(174)*V(67)*V(80)
  A(175) = RCT(175)*V(60)*V(75)
  A(176) = RCT(176)*V(60)*V(80)
  A(177) = RCT(177)*V(28)*V(75)
  A(178) = RCT(178)*V(68)*V(76)
  A(179) = RCT(179)*V(68)*V(80)
  A(180) = RCT(180)*V(68)*V(79)
  A(181) = RCT(181)*V(68)*V(77)
  A(182) = RCT(182)*V(68)*V(78)
  A(183) = RCT(183)*V(15)*V(75)
  A(184) = RCT(184)*V(15)*V(75)
  A(185) = RCT(185)*V(41)*V(75)
  A(186) = RCT(186)*V(17)*V(75)
  A(187) = RCT(187)*V(43)*V(75)
  A(188) = RCT(188)*V(36)*V(75)
  A(189) = RCT(189)*V(65)*V(75)
  A(190) = RCT(190)*V(54)*V(75)
  A(191) = RCT(191)*V(16)*V(75)
  A(192) = RCT(192)*V(16)*V(75)
  A(193) = RCT(193)*V(16)*V(80)
  A(194) = RCT(194)*V(2)*V(75)
  A(195) = RCT(195)*V(79)
  A(196) = RCT(196)*V(56)*V(56)

! Aggregate function
  Vdot(1) = A(83)
  Vdot(2) = -A(194)
  Vdot(3) = -A(4)-A(53)-A(54)
  Vdot(4) = -A(88)
  Vdot(5) = -A(108)
  Vdot(6) = -A(118)
  Vdot(7) = -A(120)
  Vdot(8) = -A(83)+A(191)+0.5*A(192)+A(193)
  Vdot(9) = -A(13)+A(48)-A(49)+A(52)+0.5*A(195)
  Vdot(10) = -A(129)
  Vdot(11) = 0.25*A(129)-A(130)
  Vdot(12) = A(85)-A(86)-A(87)
  Vdot(13) = -A(6)+A(60)-A(61)-A(68)
  Vdot(14) = A(130)-A(131)
  Vdot(15) = -A(26)+A(180)-A(183)-A(184)
  Vdot(16) = -A(191)-A(192)-A(193)
  Vdot(17) = 0.2*A(91)-A(186)+0.4*A(196)
  Vdot(18) = -A(10)+A(76)-A(77)
  Vdot(19) = A(12)-A(42)-A(43)+0.05*A(72)
  Vdot(20) = A(150)-A(153)
  Vdot(21) = -A(21)+A(90)-A(92)
  Vdot(22) = -A(22)+A(110)-A(112)
  Vdot(23) = -A(23)+A(115)-A(117)
  Vdot(24) = A(118)-A(119)
  Vdot(25) = -A(35)+A(127)-A(128)
  Vdot(26) = -A(9)+A(65)-A(66)-A(67)
  Vdot(27) = -A(81)-A(82)
  Vdot(28) = 0.37*A(137)+0.4*A(138)+0.3*A(141)+0.4*A(142)+A(175)+A(176)-A(177)
  Vdot(29) = A(95)+0.1*A(121)-A(124)
  Vdot(30) = 0.75*A(81)-A(85)
  Vdot(31) = -A(36)+A(133)-A(134)
  Vdot(32) = -A(16)+0.75*A(103)-A(105)+0.75*A(156)
  Vdot(33) = -A(31)+0.8*A(34)+0.75*A(121)-A(125)
  Vdot(34) = 0.25*A(82)+0.25*A(94)+0.25*A(103)+0.1*A(104)+0.2*A(136)+0.25*A(156)-A(168)
  Vdot(35) = -A(15)+A(97)-A(98)
  Vdot(36) = -A(17)+A(102)-A(106)-A(188)
  Vdot(37) = 0.13*A(32)-A(33)+0.45*A(36)-A(84)+0.45*A(132)+0.2*A(190)
  Vdot(38) = -A(37)+A(166)-A(167)
  Vdot(39) = -A(7)+A(62)-A(63)+2*A(68)+A(69)+0.5*A(70)+A(78)+A(100)+A(174)+A(193)
  Vdot(40) = -A(71)-A(72)+0.08*A(94)
  Vdot(41) = A(75)+0.3*A(91)+0.5*A(116)+0.25*A(141)+0.25*A(151)+0.3*A(181)-A(185)
  Vdot(42) = -A(28)+A(139)-A(140)
  Vdot(43) = -A(18)+A(160)-A(161)-A(187)
  Vdot(44) = 0.7*A(129)-A(132)-A(133)+A(134)
  Vdot(45) = -A(32)+0.9*A(36)+0.7*A(131)+0.9*A(132)
  Vdot(46) = -A(162)-A(163)-A(164)
  Vdot(47) = A(2)+A(4)-A(40)-A(41)-A(42)-A(53)-A(54)-A(72)
  Vdot(48) = -A(34)+A(122)-A(123)
  Vdot(49) = A(125)-A(126)-A(127)+A(128)
  Vdot(50) = A(93)-A(96)-A(97)+0.5*A(98)
  Vdot(51) = 0.82*A(22)-A(24)+0.25*A(34)+0.1*A(37)+0.82*A(109)+0.82*A(111)-A(113)+0.5*A(119)+0.25*A(121)+0.1*A(165)
  Vdot(52) = 2*A(1)+A(3)+A(5)-A(38)-A(39)+A(40)-A(44)-A(45)+A(51)-A(57)
  Vdot(53) = A(169)-A(170)-A(171)-A(172)
  Vdot(54) = -A(30)+A(86)+0.53*A(147)+0.53*A(149)+0.26*A(151)+0.53*A(152)+0.25*A(178)+0.25*A(179)+0.1*A(181)+0.25*A(182)&
               &-A(190)
  Vdot(55) = A(120)-A(121)-A(122)+A(123)
  Vdot(56) = A(31)+A(88)-A(89)-A(90)-A(91)+0.5*A(92)-2*A(196)
  Vdot(57) = A(108)-A(109)-A(110)-A(111)+A(112)
  Vdot(58) = A(11)+A(12)+A(14)+0.67*A(19)+0.7*A(20)+A(25)+A(27)+A(30)+0.45*A(32)+2*A(33)+A(78)+A(79)-A(80)+0.5*A(82)&
               &+A(84)+0.56*A(94)+0.3*A(136)+0.05*A(144)+0.2*A(146)+0.22*A(147)+0.22*A(149)+0.11*A(151)+0.22*A(152)+A(173)&
               &+A(174)+A(178)+A(179)+0.4*A(181)+A(182)
  Vdot(59) = -A(135)-A(136)-A(169)
  Vdot(60) = -A(27)+0.08*A(137)+0.8*A(148)+0.794*A(170)+0.794*A(171)+0.794*A(172)-A(175)-A(176)
  Vdot(61) = 0.7*A(20)-A(93)-A(94)-A(95)+0.07*A(136)
  Vdot(62) = -A(14)+A(15)+A(21)+0.4*A(34)+A(35)+A(89)+0.8*A(91)+0.5*A(92)+0.5*A(94)+A(96)-A(99)-A(100)+0.27*A(109)&
               &+A(119)+0.4*A(121)+A(126)+0.04*A(144)+A(186)+1.6*A(196)
  Vdot(63) = A(113)-A(114)-A(115)-A(116)+A(117)
  Vdot(64) = A(162)+A(164)-A(165)-A(166)+A(167)
  Vdot(65) = -A(29)+0.5*A(98)+0.2*A(116)+0.22*A(147)+0.22*A(149)+0.23*A(151)+0.22*A(152)+0.25*A(178)+0.25*A(179)+0.1&
               &*A(181)+0.25*A(182)+0.5*A(187)-A(189)
  Vdot(66) = -A(19)+0.288*A(28)+A(37)+0.4*A(136)+0.23*A(137)+0.25*A(138)+0.19*A(141)+0.25*A(142)-A(145)-A(146)+A(163)&
               &+A(165)+0.167*A(170)+0.167*A(171)+0.167*A(172)
  Vdot(67) = -A(25)+0.18*A(32)+0.45*A(36)+0.5*A(116)+A(124)+0.45*A(132)+0.95*A(144)+0.8*A(146)+0.25*A(147)+0.25*A(149)&
               &+0.24*A(151)+0.25*A(152)-A(173)-A(174)+0.25*A(178)+0.25*A(179)+0.1*A(181)+0.25*A(182)+A(189)
  Vdot(68) = 0.5*A(140)+A(177)-A(178)-A(179)-A(180)-A(181)-A(182)+A(183)
  Vdot(69) = -A(20)+0.402*A(28)+A(37)+0.2*A(136)+0.32*A(137)+0.35*A(138)+0.26*A(141)+0.35*A(142)-A(143)-A(144)+A(163)&
               &+A(165)+0.039*A(170)+0.039*A(171)+0.039*A(172)
  Vdot(70) = A(143)+0.5*A(145)-A(147)-A(148)-A(149)-A(150)-A(151)-A(152)+0.2*A(153)
  Vdot(71) = A(135)-A(137)-A(138)-A(139)+0.5*A(140)-A(141)-A(142)
  Vdot(72) = A(10)-A(11)-A(12)+A(15)+0.67*A(19)+A(23)+A(27)+0.69*A(28)+A(29)+A(30)+0.1*A(34)+0.25*A(72)+A(73)+2*A(74)&
               &+A(75)+0.3*A(77)-A(78)-A(79)+0.5*A(81)+A(82)+2*A(87)+0.7*A(91)+0.54*A(94)+A(96)+A(104)+0.5*A(105)+A(111)&
               &+A(114)+0.8*A(116)+0.5*A(119)+0.1*A(121)+0.6*A(136)+0.55*A(137)+0.6*A(138)+1.2*A(141)+0.6*A(142)+0.8*A(144)&
               &+0.7*A(146)+0.25*A(147)+0.25*A(149)+0.88*A(151)+0.25*A(152)+A(154)+A(155)+2*A(157)+A(158)+2*A(159)+0.072&
               &*A(170)+0.072*A(171)+0.008*A(172)+0.7*A(181)+A(185)+0.5*A(187)+A(188)+0.8*A(190)
  Vdot(73) = -A(5)+A(6)+A(7)+0.89*A(8)+0.66*A(9)+0.6*A(17)+A(18)+A(27)+A(55)+A(56)-A(57)-A(58)+A(59)-A(60)+A(61)-A(62)+2&
               &*A(64)-A(65)+A(66)+A(67)-A(70)+A(73)+A(85)+A(89)+A(96)+A(101)-A(102)+A(106)+A(109)+A(114)+A(119)+0.9*A(121)&
               &+A(124)+A(126)-0.3*A(131)+0.9*A(132)+0.92*A(137)+A(138)+A(147)+A(149)+A(154)+A(155)-A(160)+A(161)+A(164)&
               &+A(165)+1.206*A(170)+1.206*A(171)+0.206*A(172)+0.4*A(175)+A(176)+A(178)+A(179)
  Vdot(74) = A(18)+0.33*A(19)+0.2*A(136)+0.5*A(145)+0.5*A(153)-A(154)-A(155)-A(156)-A(157)-A(158)-2*A(159)-A(160)+A(161)
  Vdot(75) = A(7)+0.33*A(9)+A(10)+2*A(13)+A(15)+A(16)+0.33*A(19)+A(21)+A(22)+A(23)+A(26)+A(34)+A(35)+A(36)+A(37)+2*A(41)&
               &+A(42)-A(43)-A(44)+A(45)-A(46)+A(47)-A(49)-A(50)-2*A(51)-2*A(52)+A(55)+A(59)-A(62)-A(63)-A(66)+0.5*A(70)&
               &-A(71)+0.75*A(72)-0.7*A(77)-A(79)-A(80)-A(81)+0.12*A(82)-A(83)-A(84)-A(88)-0.5*A(92)-A(93)+0.33*A(94)-0.5&
               &*A(98)-A(99)-A(105)-A(108)-A(112)-A(113)-A(117)-A(118)-A(120)-A(123)-A(124)-A(125)-A(128)-A(129)-A(130)&
               &-A(134)-A(135)+0.27*A(136)-A(140)-A(143)+0.08*A(144)-A(145)+0.215*A(146)-0.9*A(153)-A(162)+0.7*A(163)-A(167)&
               &-A(168)-A(173)-A(175)-A(177)-A(183)-A(185)-A(186)-A(187)-A(188)-A(189)-A(190)-A(191)-A(192)-A(194)
  Vdot(76) = A(5)+0.11*A(8)+2*A(53)-A(55)-A(56)+A(57)-A(64)+0.5*A(70)-A(73)-A(85)-A(89)-A(96)-A(101)-A(109)-A(114)&
               &-A(119)-A(121)-A(126)-A(132)-A(137)-A(147)-A(148)-A(154)-A(165)-A(170)-A(178)
  Vdot(77) = A(14)+A(16)+0.4*A(17)+0.3*A(20)+A(24)+A(71)+0.75*A(72)-A(73)-2*A(74)-2*A(75)-A(76)+0.7*A(77)-A(91)+0.31&
               &*A(94)+A(101)-0.1*A(104)+2*A(107)-A(111)-A(116)-A(141)+A(142)-A(151)+A(152)-A(157)+A(158)+A(168)-A(181)&
               &+A(182)
  Vdot(78) = 0.6*A(17)+0.67*A(19)+0.3*A(20)+A(23)+A(24)+A(25)+A(29)+A(31)+0.13*A(32)+A(35)+A(99)+A(100)-A(101)-A(102)&
               &-A(103)-A(104)+0.5*A(105)+A(106)-2*A(107)+A(114)+0.3*A(116)+A(126)-A(142)+0.53*A(147)+0.53*A(149)+0.26&
               &*A(151)-0.47*A(152)+A(154)+A(155)+A(157)+2*A(159)+A(173)+A(174)-A(182)
  Vdot(79) = 0.66*A(9)+A(10)+2*A(11)+A(14)+A(15)+0.67*A(19)+A(21)+A(22)+A(25)+A(27)+A(28)+A(29)+2*A(30)+0.56*A(32)+2&
               &*A(33)+0.9*A(34)+A(37)+A(42)+A(43)+A(44)-A(45)+A(46)-A(47)-2*A(48)+A(49)-A(50)-A(55)-A(59)-A(65)+A(67)+0.4&
               &*A(72)+A(73)+2*A(74)-A(76)+A(78)+A(79)+A(80)+0.25*A(81)+0.12*A(82)+A(84)+A(86)+A(87)+A(89)-A(90)+A(91)+0.19&
               &*A(94)+A(96)-A(97)-A(103)+0.9*A(104)+A(109)-A(110)+A(111)-A(115)+0.3*A(116)+A(119)+0.9*A(121)-A(122)-A(127)&
               &+0.25*A(129)+0.7*A(131)+0.9*A(132)-A(133)+0.06*A(136)+A(137)+A(138)-A(139)+A(141)+A(142)+0.06*A(144)+0.275&
               &*A(146)+0.47*A(147)+0.47*A(149)-A(150)+0.73*A(151)+0.47*A(152)+0.2*A(153)-A(156)+A(157)+A(163)+A(165)-A(166)&
               &+0.794*A(170)+0.794*A(171)-0.206*A(172)+A(175)+A(176)+1.5*A(178)+1.5*A(179)-A(180)+A(181)+1.5*A(182)+A(185)&
               &+A(186)+0.5*A(187)+A(189)+A(190)+0.5*A(192)-A(195)+1.2*A(196)
  Vdot(80) = A(6)-A(8)+0.33*A(9)+0.4*A(17)+A(58)-A(59)-A(60)+A(61)+A(63)-A(64)-A(69)-A(78)-A(95)-A(100)-A(138)-A(149)&
               &-A(155)-A(164)-A(169)-A(171)-A(174)-A(176)-A(179)+0.5*A(187)+A(188)-A(193)
  Vdot(81) = -A(2)-A(3)+0.89*A(8)+A(38)-A(39)-A(46)-A(47)-A(56)-A(58)-A(82)-A(94)+0.25*A(103)-0.9*A(136)-0.8*A(144)-0.8&
               &*A(146)+0.25*A(156)-A(163)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE MOZART_4_Function

