! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : MCMv3_3_Rates.f90
! Time                 : Mon Jul 19 14:16:06 2021
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_MCMv3_3_3654_BOXMOX
! Equation file        : MCMv3_3.kpp
! Output root filename : MCMv3_3
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE MCMv3_3_Rates

  USE MCMv3_3_Parameters
  USE MCMv3_3_Global
  USE MCMv3_3_Util
  IMPLICIT NONE

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!  Note: the default argument type for rate laws, as read from the equations file, is single precision
!        but all the internal calculations are performed in double precision
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!~~~>  Arrhenius
!   REAL(kind=dp) FUNCTION ARR( A0,B0,C0 )
!      REAL A0,B0,C0
!      ARR =  DBLE(A0) * EXP(-DBLE(B0)/TEMP) * (TEMP/300.0_dp)**DBLE(C0)
!   END FUNCTION ARR

! Arrhenius (added by psaide 15-07-2009)
    REAL(kind=dp) FUNCTION ARR( A0,B0,C0, TEMP )
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) A0,B0,C0
      ARR =  A0 * EXP( -B0 /TEMP ) * (TEMP/300._dp)**C0
    END FUNCTION ARR

!~~~> Simplified Arrhenius, with two arguments
!~~~> Note: The argument B0 has a changed sign when compared to ARR
!   REAL(kind=dp) FUNCTION ARR2( A0,B0 )
!      REAL A0,B0
!      ARR2 =  DBLE(A0) * EXP( DBLE(B0)/TEMP )
!   END FUNCTION ARR2
! CK 20140313 WRF-chem uses different kind of Arrhenius function
!             with TEMP as argument...
   REAL(kind=dp) FUNCTION ARR2( A0,B0, TEMP )
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) A0,B0
      ARR2 = A0 * EXP( -B0 /TEMP )
   END FUNCTION ARR2
! CK 20140313 end

!   REAL(kind=dp) FUNCTION EP2(A0,C0,A2,C2,A3,C3)
!      REAL A0,C0,A2,C2,A3,C3
!      REAL(kind=dp) K0,K2,K3
!      K0 = DBLE(A0) * EXP(-DBLE(C0)/TEMP)
!      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
!      K3 = DBLE(A3) * EXP(-DBLE(C3)/TEMP)
!      K3 = K3*CFACTOR*1.0E6_dp
!      EP2 = K0 + K3/(1.0_dp+K3/K2 )
!   END FUNCTION EP2

!   REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2)
!      REAL A1, C1, A2, C2
!      REAL(kind=dp) K1, K2
!      K1 = DBLE(A1) * EXP(-DBLE(C1)/TEMP)
!      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
!      EP3 = K1 + K2*(1.0E6_dp*CFACTOR)
!   END FUNCTION EP3

! EP2 (added by psaide 22-07-2009)
   REAL(kind=dp) FUNCTION EP2( A0,C0,A2,C2,A3,C3,TEMP,cair)
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) :: cair
      REAL(kind=dp) A0,C0,A2,C2,A3,C3
      REAL(kind=dp) K0,K2,K3

      K0 = A0 * EXP(-C0 /TEMP)
      K2 = A2 * EXP(-C2 /TEMP)
      K3 = A3 * EXP(-C3 /TEMP)
!      K3 = K3 * 2.45E13_dp * 1.0E6_dp
      K3 = K3 * cair
      EP2 = K0 + K3/(1._dp+K3/K2 )
   END FUNCTION EP2

! EP3 (added by psaide 15-07-2009)
    REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2,TEMP,cair)
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) :: cair
      REAL(kind=dp) A1, C1, A2, C2
      REAL(kind=dp) K1, K2

      K1 = A1 * EXP(-C1 /TEMP)
      K2 = A2 * EXP(-C2 /TEMP)
!      EP3 = K1 + K2*(1.0E6_dp * 2.45E13_dp)
      EP3 = K1 + K2*cair
    END FUNCTION EP3


!   REAL(kind=dp) FUNCTION FALL ( A0,B0,C0,A1,B1,C1,CF)
!      REAL A0,B0,C0,A1,B1,C1,CF
!      REAL(kind=dp) K0, K1
!      K0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
!      K1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
!      K0 = K0*CFACTOR*1.0E6_dp
!      K1 = K0/K1
!      FALL = (K0/(1.0_dp+K1))*   &
!           DBLE(CF)**(1.0_dp/(1.0_dp+(LOG10(K1))**2))
!   END FUNCTION FALL

! FALL (added by psaide 15-07-2009)
    REAL(kind=dp) FUNCTION FALL( A0,B0,C0,A1,B1,C1,CF,TEMP,cair)

      INTRINSIC LOG10

      REAL(kind=dp) :: TEMP
      REAL(kind=dp) :: cair
      REAL(kind=dp) A0,B0,C0,A1,B1,C1,CF
      REAL(kind=dp) K0, K1

      K0 = A0 * EXP(-B0 /TEMP)* (TEMP/300._dp)**C0
      K1 = A1 * EXP(-B1 /TEMP)* (TEMP/300._dp)**C1
!      K0 = K0 * 2.45E13_dp * 1.0E6_dp
      K0 = K0 * cair
      K1 = K0/K1
      FALL = (K0/(1._dp+K1))*CF**(1._dp/(1._dp+(LOG10(K1))**2))

    END FUNCTION FALL

! FALL2 (added by psaide 28-10-2009)
    REAL(KIND=dp) FUNCTION F2( A0,B0,C0,A1,B1,C1,CF,CN,TEMP,cair)

      INTRINSIC LOG10

      REAL(KIND=dp) :: TEMP
      REAL(KIND=dp) :: cair
      REAL(KIND=dp) A0,B0,C0,A1,B1,C1,CF,CN
      REAL(KIND=dp) K0, K1

      K0 = A0 * EXP(-B0 /TEMP)* (TEMP/300._dp)**C0
      K1 = A1 * EXP(-B1 /TEMP)* (TEMP/300._dp)**C1
!      K0 = K0 * 2.45E13_dp * 1.0E6_dp
      K0 = K0 * cair
      K1 = K0/K1
      F2 = (K0/(1._dp+K1))*CF**(1._dp/(1._dp+(LOG10(K1)/CN)**2))

    END FUNCTION F2


  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_3rd(temp,cair,k0_300K,n,kinf_300K,m,fc)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL, INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL, INTENT(IN) :: n         ! exponent for low pressure limit
    REAL, INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL, INTENT(IN) :: m         ! exponent for high pressure limit
    REAL, INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(kind=dp) :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    k_3rd   = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))

  END FUNCTION k_3rd

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_arr (k_298,tdep,temp)
    ! Arrhenius function

    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(kind=dp), INTENT(IN) :: temp  ! temperature

    INTRINSIC EXP

    k_arr = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) ! 1/298.15=3.3540e-3

  END FUNCTION k_arr

! CK 20140313 in the following some more rate functions needed by
!             WRF-chem packages

!------------------------------------
! Troe reactions (as in Stockwell et al, 1997)

    REAL(kind=dp) FUNCTION TROE(k0_300K,n,kinf_300K,m,temp,cair)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(kind=dp),          INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(kind=dp),          INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(kind=dp),          INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(kind=dp),          INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(kind=dp)             :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    TROE   = k0_T/(1._dp+k_ratio)*0.6_dp**(1._dp/(1._dp+LOG10(k_ratio)**2))

   END FUNCTION TROE



!-------------------------------------------
! Troe equilibrium reactions (as in Stockwell et al, 1997)

    REAL(kind=dp) FUNCTION TROEE(A, B, k0_300K,n,kinf_300K,m,temp,cair)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(kind=dp),     INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(kind=dp),     INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(kind=dp),     INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(kind=dp),     INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(kind=dp),     INTENT(IN) :: A, B
    REAL(kind=dp)             :: zt_help, k0_T, kinf_T, k_ratio, troe


    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    troe   = k0_T/(1._dp+k_ratio)*0.6_dp**(1._dp/(1._dp+LOG10(k_ratio)**2))

    TROEE = A * EXP( - B / temp) * troe



  END FUNCTION TROEE

!------------------------
! k=T^2 C exp (-D/T) reactions

   REAL(kind=dp) FUNCTION THERMAL_T2(c, d ,temp)
    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp),     INTENT(IN) :: c, d


     THERMAL_T2= temp**2._dp * c * EXP(- d  / temp)

   END FUNCTION THERMAL_T2

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions



! ****************************************************************************
! J - the photolysis rate retrieval function
! ****************************************************************************
      REAL(kind=dp) FUNCTION J(name)

      CHARACTER(LEN=*), INTENT(IN)     :: name

      CHARACTER(LEN=15) :: xname

      INTEGER                          :: i

      xname(:)           = " "
      xname(1:LEN(name)) = name

      J                  = jvalues(hash(xname))

      RETURN

      END FUNCTION J
! ****************************************************************************


! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
      !USE MCMv3_3_Parameters
      !USE MCMv3_3_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST


 ! start of executable statements

 M = C(ind_M)
 O2 = 0.20946 * M
 N2 = 0.78084 * M
! H2O = 0.01   * M
 H2O = C(ind_H2O)

 RO2 = &
 C(ind_HOCH2CH2O2) + C(ind_HO1C3O2) + C(ind_HYPROPO2) + C(ind_IPROPOLO2) + &
   C(ind_NBUTOLAO2) + C(ind_NBUTOLBO2) + C(ind_BUT2OLO2) + &
   C(ind_IBUTOLBO2) + C(ind_IBUTOLCO2) + C(ind_TBUTOLO2) + C(ind_HO3C5O2) &
   + C(ind_PE2ENEBO2) + C(ind_HM2C43O2) + C(ind_M2BUOL2O2) + &
   C(ind_HM33C3O2) + C(ind_ME3BUOLO2) + C(ind_HO2M2C4O2) + &
   C(ind_ME2BU2OLO2) + C(ind_PROL11MO2) + C(ind_H2M3C4O2) + &
   C(ind_ME2BUOLO2) + C(ind_CYHEXOLAO2) + C(ind_MIBKAOHAO2) + &
   C(ind_MIBKAOHBO2) + C(ind_MIBKHO4O2) + C(ind_CH3CO3) + C(ind_NMBOAO2) &
   + C(ind_NMBOBO2) + C(ind_MBOAO2) + C(ind_MBOBO2) + C(ind_CH3O2) + &
   C(ind_HCOCH2O2) + C(ind_C2H5CO3) + C(ind_C2H5O2) + C(ind_C3H7CO3) + &
   C(ind_BUTALO2) + C(ind_NC3H7O2) + C(ind_IPRCO3) + C(ind_IBUTALBO2) + &
   C(ind_IBUTALCO2) + C(ind_IC3H7O2) + C(ind_C4H9CO3) + C(ind_C4CHOBO2) + &
   C(ind_NC4H9O2) + C(ind_ACO3) + C(ind_ACRO2) + C(ind_OCCOHCO2) + &
   C(ind_CH3C2H2O2) + C(ind_MACO3) + C(ind_MACRO2) + C(ind_MACROHO2) + &
   C(ind_C3DBCO3) + C(ind_C4CONO3O2) + C(ind_C4NO3COO2) + &
   C(ind_C4OCCOHCO2) + C(ind_COCCOH2CO2) + C(ind_SC4H9O2) + &
   C(ind_IC4H9O2) + C(ind_TC4H9O2) + C(ind_PEAO2) + C(ind_PEBO2) + &
   C(ind_PECO2) + C(ind_IPEAO2) + C(ind_IPEBO2) + C(ind_IPECO2) + &
   C(ind_NEOPO2) + C(ind_HEXAO2) + C(ind_HEXBO2) + C(ind_HEXCO2) + &
   C(ind_M2PEAO2) + C(ind_M2PEBO2) + C(ind_M2PECO2) + C(ind_M2PEDO2) + &
   C(ind_M3PEAO2) + C(ind_M3PEBO2) + C(ind_M3PECO2) + C(ind_M22C43O2) + &
   C(ind_M22C4O2) + C(ind_M33C4O2) + C(ind_M23C43O2) + C(ind_M23C4O2) + &
   C(ind_HEPTO2) + C(ind_M2HEXAO2) + C(ind_M2HEXBO2) + C(ind_M3HEXAO2) + &
   C(ind_M3HEXBO2) + C(ind_OCTO2) + C(ind_NONO2) + C(ind_DECO2) + &
   C(ind_UDECO2) + C(ind_DDECO2) + C(ind_CHEXO2) + C(ind_ETHENO3O2) + &
   C(ind_PRONO3AO2) + C(ind_PRONO3BO2) + C(ind_BU1ENO3O2) + &
   C(ind_C43NO34O2) + C(ind_HO3C4O2) + C(ind_C42NO33O2) + &
   C(ind_MPRANO3O2) + C(ind_MPRBNO3O2) + C(ind_C51NO32O2) + &
   C(ind_C52NO31O2) + C(ind_PE1ENEAO2) + C(ind_PE1ENEBO2) + &
   C(ind_C52NO33O2) + C(ind_C53NO32O2) + C(ind_PE2ENEAO2) + &
   C(ind_C4NO32M1O2) + C(ind_C4NO32M2O2) + C(ind_C4M3NO31O2) + &
   C(ind_C4M3NO32O2) + C(ind_IPRCHOOA) + C(ind_ME3BU2OLO2) + &
   C(ind_C4M2NO32O2) + C(ind_C4M2NO33O2) + C(ind_C65NO36O2) + &
   C(ind_C66NO35O2) + C(ind_C6OH5O2) + C(ind_HO5C6O2) + C(ind_C62NO33O2) &
   + C(ind_C63NO32O2) + C(ind_C64OH5O2) + C(ind_C65OH4O2) + &
   C(ind_C4ME2NO3O2) + C(ind_C4ME2OHO2) + C(ind_BZBIPERO2) + &
   C(ind_C6H5CH2O2) + C(ind_TLBIPERO2) + C(ind_OXYLO2) + &
   C(ind_OXYBIPERO2) + C(ind_MXYLO2) + C(ind_MXYBIPERO2) + C(ind_PXYLO2) &
   + C(ind_PXYBIPERO2) + C(ind_C6H5C2H4O2) + C(ind_EBZBIPERO2) + &
   C(ind_PHC3O2) + C(ind_PBZBIPERO2) + C(ind_PHIC3O2) + C(ind_IPBZBIPRO2) &
   + C(ind_TM123BO2) + C(ind_TM123BPRO2) + C(ind_TM124BO2) + &
   C(ind_TM124BPRO2) + C(ind_TMBO2) + C(ind_TM135BPRO2) + C(ind_ETOLO2) + &
   C(ind_OETLBIPRO2) + C(ind_METLBIPRO2) + C(ind_PETLBIPRO2) + &
   C(ind_DM35EBO2) + C(ind_DMEBIPRO2) + C(ind_DE35TO2) + &
   C(ind_DETLBIPRO2) + C(ind_NSTYRENO2) + C(ind_STYRENO2) + &
   C(ind_C6H5CO3) + C(ind_C6H5O2) + C(ind_NBUTDAO2) + C(ind_NBUTDBO2) + &
   C(ind_BUTDAO2) + C(ind_BUTDBO2) + C(ind_BUTDCO2) + C(ind_NISOPO2) + &
   C(ind_ISOP34O2) + C(ind_CH3OCH2O2) + C(ind_DIETETO2) + C(ind_ETOC2O2) &
   + C(ind_CH3COCH2O2) + C(ind_MEKAO2) + C(ind_MEKBO2) + C(ind_MEKCO2) + &
   C(ind_CO2C54O2) + C(ind_MPRKAO2) + C(ind_DIEKAO2) + C(ind_DIEKBO2) + &
   C(ind_MIPKAO2) + C(ind_MIPKBO2) + C(ind_HEX2ONAO2) + C(ind_HEX2ONBO2) &
   + C(ind_HEX2ONCO2) + C(ind_HEX3ONAO2) + C(ind_HEX3ONBO2) + &
   C(ind_HEX3ONCO2) + C(ind_HEX3ONDO2) + C(ind_MIBKAO2) + C(ind_MIBKBO2) &
   + C(ind_MTBKO2) + C(ind_CYHXONAO2) + C(ind_NAPINAO2) + C(ind_NAPINBO2) &
   + C(ind_APINAO2) + C(ind_APINBO2) + C(ind_APINCO2) + C(ind_NBPINAO2) + &
   C(ind_NBPINBO2) + C(ind_BPINAO2) + C(ind_BPINBO2) + C(ind_BPINCO2) + &
   C(ind_NLIMO2) + C(ind_LIMAO2) + C(ind_LIMBO2) + C(ind_LIMCO2) + &
   C(ind_NBCO2) + C(ind_BCAO2) + C(ind_BCBO2) + C(ind_BCCO2) + &
   C(ind_BUT2CO3) + C(ind_C3ME3CO3) + C(ind_C3ME3CHOO2) + C(ind_HOCH2CO3) &
   + C(ind_CH3CHOHCO3) + C(ind_IPRHOCO3) + C(ind_IPRCHOO) + &
   C(ind_BZEMUCCO3) + C(ind_BZEMUCO2) + C(ind_C5DIALO2) + C(ind_NPHENO2) &
   + C(ind_PHENO2) + C(ind_CRESO2) + C(ind_NCRESO2) + C(ind_TLEMUCCO3) + &
   C(ind_TLEMUCO2) + C(ind_C615CO2O2) + C(ind_OXYMUCCO3) + &
   C(ind_OXYMUCO2) + C(ind_MC6CO2O2) + C(ind_NOXYOLO2) + C(ind_OXYOLO2) + &
   C(ind_MXYMUCCO3) + C(ind_MXYMUCO2) + C(ind_C726CO5O2) + C(ind_MXYOLO2) &
   + C(ind_NMXYOLO2) + C(ind_PXYMUCCO3) + C(ind_PXYMUCO2) + &
   C(ind_C6M5CO2O2) + C(ind_NPXYOLO2) + C(ind_PXYOLO2) + C(ind_EBENZOLO2) &
   + C(ind_NEBNZOLO2) + C(ind_EBZMUCCO3) + C(ind_EBZMUCO2) + &
   C(ind_C715CO2O2) + C(ind_NPBNZOLO2) + C(ind_PBENZOLO2) + &
   C(ind_PBZMUCCO3) + C(ind_PBZMUCO2) + C(ind_C815CO2O2) + &
   C(ind_IPBENZOLO2) + C(ind_NIPBNZOLO2) + C(ind_IPBZMUCCO3) + &
   C(ind_IPGLOOB) + C(ind_IPBZMUCO2) + C(ind_C7M15CO2O2) + &
   C(ind_NTM123OLO2) + C(ind_TM123OLO2) + C(ind_TM123MUCO2) + &
   C(ind_NTM124OLO2) + C(ind_TM124OLO2) + C(ind_TM124MUCO3) + &
   C(ind_TM124MUCO2) + C(ind_C7CO2M5O2) + C(ind_NTM135OLO2) + &
   C(ind_TM135OLO2) + C(ind_TM135MUCO3) + C(ind_TM135MUCO2) + &
   C(ind_C7M2CO5O2) + C(ind_OETLMUCCO3) + C(ind_OETLMUCO2) + &
   C(ind_MC7CO2O2) + C(ind_NOETOLO2) + C(ind_OETOLO2) + C(ind_METLMUCCO3) &
   + C(ind_METLMUCO2) + C(ind_C826CO3O2) + C(ind_METOLO2) + &
   C(ind_NMETOLO2) + C(ind_PETLMUCCO3) + C(ind_PETLMUCO2) + &
   C(ind_C7M6CO2O2) + C(ind_NPETOLO2) + C(ind_PETOLO2) + C(ind_DMEBMUCO3) &
   + C(ind_DMEBMUCO2) + C(ind_C8M2CO6O2) + C(ind_NDMEPHOLO2) + &
   C(ind_DMEPHOLO2) + C(ind_NDEMPHOLO2) + C(ind_DEMPHOLO2) + &
   C(ind_DETLMUCO3) + C(ind_DETLMUCO2) + C(ind_C9M2CO6O2) + &
   C(ind_HMVKAO2) + C(ind_HMVKBO2) + C(ind_MVKO2) + C(ind_CISOPAO2) + &
   C(ind_ISOPBO2) + C(ind_CISOPCO2) + C(ind_ISOPDO2) + C(ind_NC526O2) + &
   C(ind_C530O2) + C(ind_M3BU3ECO3) + C(ind_C45O2) + C(ind_NC51O2) + &
   C(ind_C51O2) + C(ind_CH2CHCH2O2) + C(ind_ISOPAO2) + C(ind_ISOPCO2) + &
   C(ind_C107O2) + C(ind_C109O2) + C(ind_C96O2) + C(ind_NOPINAO2) + &
   C(ind_NOPINBO2) + C(ind_NOPINCO2) + C(ind_NOPINDO2) + C(ind_LIMALAO2) &
   + C(ind_LIMALBO2) + C(ind_C923O2) + C(ind_BCALAO2) + C(ind_BCALBO2) + &
   C(ind_C136O2) + C(ind_BCALCO2) + C(ind_C141O2) + C(ind_HOC2H4CO3) + &
   C(ind_HOIPRCO3) + C(ind_HO13C5O2) + C(ind_HO3C4CO3) + C(ind_C54O2) + &
   C(ind_H2M2C3CO3) + C(ind_PROL1MCO3) + C(ind_C56O2) + C(ind_HO2C43CO3) &
   + C(ind_MIBKCOOHO2) + C(ind_NC4OHCO3) + C(ind_C4OH2CO3) + &
   C(ind_CO2C3CO3) + C(ind_HO2C3CO3) + C(ind_IBUDIALCO3) + &
   C(ind_PROPALO2) + C(ind_CO3C4CO3) + C(ind_HO1C4O2) + C(ind_A2PANOO) + &
   C(ind_HCOCOHCO3) + C(ind_HCOCO3) + C(ind_MACRNCO3) + C(ind_MACRNBCO3) &
   + C(ind_CHOMOHCO3) + C(ind_CO2H3CO3) + C(ind_HO1C5O2) + C(ind_HO2C5O2) &
   + C(ind_C52O2) + C(ind_TBUTCO3) + C(ind_HO1C6O2) + C(ind_C5H11CO3) + &
   C(ind_HO2C6O2) + C(ind_HO3C6O2) + C(ind_HO1MC5O2) + C(ind_C54CO3) + &
   C(ind_HO2MC5O2) + C(ind_EIPKAO2) + C(ind_EIPKBO2) + C(ind_HO2M2C5O2) + &
   C(ind_H1MC5O2) + C(ind_M3C4CO3) + C(ind_H2MC5O2) + C(ind_M2BKAO2) + &
   C(ind_M2BKBO2) + C(ind_HM33C4O2) + C(ind_M22C3CO3) + C(ind_HM22C4O2) + &
   C(ind_M33C3CO3) + C(ind_HM23C4O2) + C(ind_M2C43CO3) + C(ind_HO3C76O2) &
   + C(ind_CO3C75O2) + C(ind_H2M5C65O2) + C(ind_C75O2) + C(ind_H2M2C65O2) &
   + C(ind_H2M4C65O2) + C(ind_C710O2) + C(ind_H3M3C6O2) + C(ind_HO3C86O2) &
   + C(ind_CO3C85O2) + C(ind_HO3C96O2) + C(ind_C91O2) + C(ind_HO3C106O2) &
   + C(ind_C101O2) + C(ind_HO3C116O2) + C(ind_C111O2) + C(ind_HO3C126O2) &
   + C(ind_C121O2) + C(ind_CO1C6O2) + C(ind_NO3CH2CO3) + C(ind_PRNO3CO3) &
   + C(ind_CO3C4NO3O2) + C(ind_HO3C3CO3) + C(ind_MPRBNO3CO3) + &
   C(ind_C5NO3COAO2) + C(ind_C4NO3CO3) + C(ind_C5OH2CO4O2) + &
   C(ind_C4OHCO3) + C(ind_C5NO3CO4O2) + C(ind_C5CONO34O2) + &
   C(ind_C43NO3CO3) + C(ind_C4MCONO3O2) + C(ind_C3MNO3CO3) + &
   C(ind_C3M3OH2CO3) + C(ind_MC4CONO3O2) + C(ind_C65NO36CO3) + &
   C(ind_MNO3COC4O2) + C(ind_C4COMOH3O2) + C(ind_HO5C5CO3) + &
   C(ind_C6NO3CO5O2) + C(ind_C6CONO34O2) + C(ind_MALDIALCO3) + &
   C(ind_EPXDLCO3) + C(ind_C3DIALO2) + C(ind_MALDIALO2) + C(ind_OXYL1O2) &
   + C(ind_C5CO14O2) + C(ind_OXYLCO3) + C(ind_EPXM2DLCO3) + &
   C(ind_C4MCO2O2) + C(ind_DM123O2) + C(ind_MXYLCO3) + C(ind_MXYL1O2) + &
   C(ind_C3MCODBCO3) + C(ind_EPXMDLCO3) + C(ind_C3MDIALO2) + &
   C(ind_MXY1O2) + C(ind_PXYLCO3) + C(ind_PXYL1O2) + C(ind_PXY1O2) + &
   C(ind_C6H5CH2CO3) + C(ind_EBENZO2) + C(ind_C6DCARBBO2) + &
   C(ind_PHCOETO2) + C(ind_PBENZO2) + C(ind_C7DCCO3) + C(ind_IPBENZO2) + &
   C(ind_IC7DCCO3) + C(ind_IPGLOO) + C(ind_TM123BCO3) + C(ind_TM123O2) + &
   C(ind_EPXKTMCO3) + C(ind_C4CO2O2) + C(ind_TM124BCO3) + C(ind_DM124O2) &
   + C(ind_TM124O2) + C(ind_TMBCO3) + C(ind_DMPHO2) + C(ind_C4MCODBCO3) + &
   C(ind_EPXMKTCO3) + C(ind_CO24C53O2) + C(ind_MPHCOMEO2) + &
   C(ind_EPXMEDLCO3) + C(ind_C4ECO2O2) + C(ind_OET1O2) + C(ind_MET1O2) + &
   C(ind_PET1O2) + C(ind_DMPHCOMO2) + C(ind_EMPHCOMO2) + C(ind_EMPHCO3) + &
   C(ind_C7CODBCO3) + C(ind_EPXEKTCO3) + C(ind_C3EDIALO2) + &
   C(ind_CO24C63O2) + C(ind_HNMVKO2) + C(ind_NC3CO3) + C(ind_C42O2) + &
   C(ind_HC3CO3) + C(ind_C41O2) + C(ind_MVKOHAO2) + C(ind_MVKOHBO2) + &
   C(ind_HC3CCO3) + C(ind_INCO2) + C(ind_NC4CO3) + C(ind_C510O2) + &
   C(ind_C536O2) + C(ind_C537O2) + C(ind_INAO2) + C(ind_C58O2) + &
   C(ind_HC4CO3) + C(ind_CHOOCH2O2) + C(ind_ACETC2H4O2) + &
   C(ind_EOCOCH2O2) + C(ind_ETHACETO2) + C(ind_ETOMEO2) + &
   C(ind_EOX2EOLAO2) + C(ind_EOX2EOLBO2) + C(ind_EOX2MECO3) + &
   C(ind_HO1CO3C4O2) + C(ind_BIACETO2) + C(ind_HO2CO4C5O2) + &
   C(ind_CO23C54O2) + C(ind_HOCO3C54O2) + C(ind_C53O2) + C(ind_C41CO3) + &
   C(ind_CO2HOC61O2) + C(ind_CO24C6O2) + C(ind_CO25C6O2) + C(ind_HO2C4O2) &
   + C(ind_C61O2) + C(ind_CO23C65O2) + C(ind_C6CO3OH5O2) + &
   C(ind_C6CO34O2) + C(ind_C6HO1CO3O2) + C(ind_C3COCCO3) + &
   C(ind_PEN2ONE1O2) + C(ind_MIBK3COO2) + C(ind_C612O2) + &
   C(ind_CO2M33CO3) + C(ind_C6COCHOO2) + C(ind_CY6DIONO2) + &
   C(ind_NC101O2) + C(ind_C96CO3) + C(ind_C720O2) + C(ind_NC91CO3) + &
   C(ind_C8BCO2) + C(ind_C918CO3) + C(ind_C923CO3) + C(ind_C141CO3) + &
   C(ind_NBCALO2) + C(ind_BCALO2) + C(ind_BCSOZO2) + C(ind_C151O2) + &
   C(ind_C152O2) + C(ind_CHOC4CO3) + C(ind_C6DIALO2) + C(ind_CHOC4O2) + &
   C(ind_CYC6DIONO2) + C(ind_CONM2CO3) + C(ind_NBZFUO2) + C(ind_BZFUO2) + &
   C(ind_CATEC1O2) + C(ind_MCATEC1O2) + C(ind_MC3CODBCO3) + &
   C(ind_C4M2ALOHO2) + C(ind_C5DICARBO2) + C(ind_NTLFUO2) + C(ind_TLFUO2) &
   + C(ind_MC4CODBCO3) + C(ind_MC5CO2OHO2) + C(ind_NOXYFUO2) + &
   C(ind_C6OTKETO2) + C(ind_OXYFUO2) + C(ind_OXCATEC1O2) + &
   C(ind_C5MCO2OHO2) + C(ind_NMXYFUO2) + C(ind_C23O3MO2) + C(ind_MXYFUO2) &
   + C(ind_NPXYFUO2) + C(ind_MCOCOMOXO2) + C(ind_PXYFUO2) + &
   C(ind_MXCATEC1O2) + C(ind_DMKOHO2) + C(ind_PXCATEC1O2) + &
   C(ind_ECATEC1O2) + C(ind_C6DICARBO2) + C(ind_NEBFUO2) + &
   C(ind_BUTALAO2) + C(ind_EBFUO2) + C(ind_C7CO3OHO2) + C(ind_PCATEC1O2) &
   + C(ind_C7DCO2) + C(ind_NPBFUO2) + C(ind_C4CHOAO2) + C(ind_PBFUO2) + &
   C(ind_C8CO3OHO2) + C(ind_PHCOMEO2) + C(ind_IPCATEC1O2) + &
   C(ind_IC7DCO2) + C(ind_NIPBFUO2) + C(ind_IC4CHOAO2) + C(ind_IPBFUO2) + &
   C(ind_C7MCO3OHO2) + C(ind_T123CAT1O2) + C(ind_C7ADCCO3) + &
   C(ind_C7ADCO2) + C(ind_NTMB1FUO2) + C(ind_TMB1FUO2) + C(ind_NTMB2FUO2) &
   + C(ind_MC6OTKETO2) + C(ind_TMB2FUO2) + C(ind_C7BDCO2) + &
   C(ind_T124CAT1O2) + C(ind_OTCATEC1O2) + C(ind_MTCATEC1O2) + &
   C(ind_C7EDCO2) + C(ind_PTCATEC1O2) + C(ind_C7DDCCO3) + C(ind_C7DDCO2) &
   + C(ind_NMEBFUO2) + C(ind_C23O3EO2) + C(ind_MEBFUO2) + C(ind_EMPHO2) + &
   C(ind_C526O2) + C(ind_HC4ACO3) + C(ind_C58AO2) + C(ind_INB1O2) + &
   C(ind_INB2O2) + C(ind_C527O2) + C(ind_HPC52O2) + C(ind_HC4CCO3) + &
   C(ind_C57AO2) + C(ind_C57O2) + C(ind_INDO2) + C(ind_C59O2) + &
   C(ind_C524O2) + C(ind_ETHFORMO2) + C(ind_PINALO2) + C(ind_C108O2) + &
   C(ind_C89CO3) + C(ind_C920CO3) + C(ind_C920O2) + C(ind_C97O2) + &
   C(ind_C85CO3) + C(ind_C85O2) + C(ind_C719O2) + C(ind_C918O2) + &
   C(ind_C9DCO2) + C(ind_C915O2) + C(ind_C917O2) + C(ind_NLIMALO2) + &
   C(ind_LIMALO2) + C(ind_C729CO3) + C(ind_C822CO3) + C(ind_C924O2) + &
   C(ind_C816CO3) + C(ind_NORLIMO2) + C(ind_C816O2) + C(ind_NLMKAO2) + &
   C(ind_LMKAO2) + C(ind_LMKBO2) + C(ind_C146O2) + C(ind_C131CO3) + &
   C(ind_BCLKAO2) + C(ind_BCLKBO2) + C(ind_BCLKCO2) + C(ind_C131O2) + &
   C(ind_C147O2) + C(ind_C126CO3) + C(ind_C136CO3) + C(ind_C148O2) + &
   C(ind_C1311O2) + C(ind_NC1313O2) + C(ind_C1313O2) + C(ind_C126O2) + &
   C(ind_C144O2) + C(ind_C142O2) + C(ind_NBCKO2) + C(ind_BCKAO2) + &
   C(ind_BCKBO2) + C(ind_H13C43CO3) + C(ind_C42CO3) + C(ind_HOC3H6CO3) + &
   C(ind_C3DIOLO2) + C(ind_HO2C4CO3) + C(ind_HOIBUTCO3) + C(ind_C63O2) + &
   C(ind_HO3C5CO3) + C(ind_C64O2) + C(ind_HO2C54O2) + C(ind_HO2C54CO3) + &
   C(ind_C66O2) + C(ind_CO3C54CO3) + C(ind_H2M2C4CO3) + C(ind_C67O2) + &
   C(ind_C610O2) + C(ind_H2M3C4CO3) + C(ind_C68O2) + C(ind_C69O2) + &
   C(ind_C611O2) + C(ind_HM33C3CO3) + C(ind_HM22C3O2) + C(ind_HM22C3CO3) &
   + C(ind_HM2C43CO3) + C(ind_C71O2) + C(ind_C76O2) + C(ind_C77O2) + &
   C(ind_C78O2) + C(ind_C711O2) + C(ind_H3M3C5O2) + C(ind_H3M3C5CO3) + &
   C(ind_C82O2) + C(ind_C81O2) + C(ind_C93O2) + C(ind_C92O2) + &
   C(ind_HO6C7O2) + C(ind_C103O2) + C(ind_C102O2) + C(ind_HO7C8O2) + &
   C(ind_C113O2) + C(ind_C112O2) + C(ind_HO8C9O2) + C(ind_C123O2) + &
   C(ind_C122O2) + C(ind_CO1H63O2) + C(ind_C3NO3COO2) + C(ind_NPHEN1O2) + &
   C(ind_NNCATECO2) + C(ind_NCATECO2) + C(ind_NBZQO2) + C(ind_PBZQO2) + &
   C(ind_NPTLQO2) + C(ind_PTLQO2) + C(ind_NCRES1O2) + C(ind_MNNCATECO2) + &
   C(ind_MNCATECO2) + C(ind_MECOACETO2) + C(ind_NOXYOL1O2) + &
   C(ind_NOXYQO2) + C(ind_OXYQO2) + C(ind_OXNNCATCO2) + C(ind_OXNCATECO2) &
   + C(ind_NMXYOL1O2) + C(ind_NMXYQO2) + C(ind_MXYQO2) + &
   C(ind_MXNNCATCO2) + C(ind_MXNCATECO2) + C(ind_NPXYOL1O2) + &
   C(ind_NPXYQO2) + C(ind_PXYQO2) + C(ind_PXNNCATCO2) + C(ind_PXNCATECO2) &
   + C(ind_NEBNZ1O2) + C(ind_NPEBQO2) + C(ind_PEBQO2) + C(ind_ENNCATECO2) &
   + C(ind_ENCATECO2) + C(ind_CO3H4CO3) + C(ind_PHCOCOCO2) + &
   C(ind_NPBNZ1O2) + C(ind_NPPRBQO2) + C(ind_PPRBQO2) + C(ind_PNNCATECO2) &
   + C(ind_PNCATECO2) + C(ind_C5O45OHCO3) + C(ind_NIPBNZ1O2) + &
   C(ind_NIPRBQO2) + C(ind_IPRBQO2) + C(ind_IPNNCATCO2) + &
   C(ind_IPNCATECO2) + C(ind_C4MOHOCO3) + C(ind_NT123L1O2) + &
   C(ind_T123NNCTO2) + C(ind_T123NCATO2) + C(ind_NT124L1O2) + &
   C(ind_NTM124QO2) + C(ind_TM124QO2) + C(ind_T124NNCTO2) + &
   C(ind_T124NCATO2) + C(ind_C5CO234O2) + C(ind_NOETOL1O2) + &
   C(ind_NOETLQO2) + C(ind_OETLQO2) + C(ind_OTNNCATCO2) + &
   C(ind_OTNCATECO2) + C(ind_NMETOL1O2) + C(ind_NMETLQO2) + &
   C(ind_METLQO2) + C(ind_MTNNCATCO2) + C(ind_MTNCATECO2) + &
   C(ind_NPETOL1O2) + C(ind_NPETLQO2) + C(ind_PETLQO2) + &
   C(ind_PTNNCATCO2) + C(ind_PTNCATECO2) + C(ind_CO234C65O2) + &
   C(ind_H13CO2CO3) + C(ind_CO2N3CO3) + C(ind_C534O2) + C(ind_C535O2) + &
   C(ind_C58NO3CO3) + C(ind_ACETMECO3) + C(ind_METHACETO2) + &
   C(ind_HOACETETO2) + C(ind_C62O2) + C(ind_HO13C4O2) + C(ind_HM22CO3) + &
   C(ind_C6COCHOCO3) + C(ind_C5COCHOO2) + C(ind_CHOC2H4O2) + &
   C(ind_HCOCH2CO3) + C(ind_CY6TRIONO2) + C(ind_C6CYTONO2) + &
   C(ind_NC102O2) + C(ind_C512CO3) + C(ind_C89O2) + C(ind_C926O2) + &
   C(ind_C817CO3) + C(ind_C817O2) + C(ind_NC826O2) + C(ind_C826O2) + &
   C(ind_C729O2) + C(ind_LMLKAO2) + C(ind_LMLKBO2) + C(ind_C116CO3) + &
   C(ind_C116O2) + C(ind_C129O2) + C(ind_C1210O2) + C(ind_C1H4C5CO3) + &
   C(ind_CHOC4OHO2) + C(ind_HOC4CHOO2) + C(ind_C6145COO2) + &
   C(ind_COHM2CO3) + C(ind_CO2C4CO3) + C(ind_HOBUT2CO3) + C(ind_CO3C5CO3) &
   + C(ind_CO2C54CO3) + C(ind_C65O2) + C(ind_CO2M3C4CO3) + C(ind_C72O2) + &
   C(ind_CO25C73O2) + C(ind_CO25C74O2) + C(ind_C712O2) + C(ind_C713O2) + &
   C(ind_C714O2) + C(ind_C84O2) + C(ind_C94O2) + C(ind_C104O2) + &
   C(ind_C114O2) + C(ind_C6H13CO3) + C(ind_C124O2) + C(ind_MALANHYO2) + &
   C(ind_NDNPHENO2) + C(ind_DNPHENO2) + C(ind_NDNCRESO2) + &
   C(ind_DNCRESO2) + C(ind_C6O4KETO2) + C(ind_NDNOXYOLO2) + &
   C(ind_DNOXYOLO2) + C(ind_ACCOCOMEO2) + C(ind_MMALANHYO2) + &
   C(ind_NDNMXYOLO2) + C(ind_DNMXYOLO2) + C(ind_TL4OHNO2O2) + &
   C(ind_NDNPXYOLO2) + C(ind_DNPXYOLO2) + C(ind_NDNEBNZLO2) + &
   C(ind_DNEBNZLO2) + C(ind_NDNPBNZLO2) + C(ind_DNPBNZLO2) + &
   C(ind_C61CO3) + C(ind_NDNIPBZLO2) + C(ind_DNIPBNZLO2) + C(ind_C62CO3) &
   + C(ind_NDNT123LO2) + C(ind_DNT123LO2) + C(ind_TM124NO2O2) + &
   C(ind_NDNT124LO2) + C(ind_DNT124LO2) + C(ind_MXYOHNO2O2) + &
   C(ind_NDNOETOLO2) + C(ind_DNOETOLO2) + C(ind_NDNMETOLO2) + &
   C(ind_DNMETOLO2) + C(ind_NDNPETOLO2) + C(ind_DNPETOLO2) + &
   C(ind_CO356OCO2) + C(ind_INCNCO3) + C(ind_IEACO3) + C(ind_C531O2) + &
   C(ind_CH3COCO3) + C(ind_IECCO3) + C(ind_HPC52CO3) + C(ind_INDHCO3) + &
   C(ind_C57NO3CO3) + C(ind_INAHPCO3) + C(ind_INANCO3) + C(ind_INAHCO3) + &
   C(ind_NC524O2) + C(ind_C525O2) + C(ind_HMACO3) + C(ind_HMACRO2) + &
   C(ind_CO23C4CO3) + C(ind_C5CO34CO3) + C(ind_C106O2) + C(ind_C717O2) + &
   C(ind_C811CO3) + C(ind_C921O2) + C(ind_C98O2) + C(ind_C86O2) + &
   C(ind_C919O2) + C(ind_C914O2) + C(ind_C916O2) + C(ind_C88CO3) + &
   C(ind_C88O2) + C(ind_C512O2) + C(ind_C619O2) + C(ind_C626CO3) + &
   C(ind_C626O2) + C(ind_C735O2) + C(ind_C822O2) + C(ind_C823CO3) + &
   C(ind_C925O2) + C(ind_C622CO3) + C(ind_C1011CO3) + C(ind_C1210CO3) + &
   C(ind_C132O2) + C(ind_C137CO3) + C(ind_C1013CO3) + C(ind_C1312O2) + &
   C(ind_C127O2) + C(ind_C143O2) + C(ind_HO24C5O2) + C(ind_C55O2) + &
   C(ind_C67CO3) + C(ind_H3M2C4CO3) + C(ind_C79O2) + C(ind_H3M3C4CO3) + &
   C(ind_H13M3C5O2) + C(ind_HO4C5CO3) + C(ind_HO5C6CO3) + C(ind_HO6C7CO3) &
   + C(ind_HO7C8CO3) + C(ind_HO8C9CO3) + C(ind_C5CO2OHCO3) + &
   C(ind_C6CO2OHCO3) + C(ind_ACCOMECO3) + C(ind_C5M2OHOCO3) + &
   C(ind_C4COMOHCO3) + C(ind_C23O3MCO3) + C(ind_C23O3CCO3) + &
   C(ind_C7CO2OHCO3) + C(ind_C6MOHCOCO3) + C(ind_C7OHCO2CO3) + &
   C(ind_ECO3CO3) + C(ind_C8OHCO2CO3) + C(ind_C8CO2OHCO3) + &
   C(ind_NDMMALYO2) + C(ind_DMMALYO2) + C(ind_C7MOHCOCO3) + &
   C(ind_C5MEJCO3) + C(ind_C6EO2OHCO3) + C(ind_C7MJPCO3) + &
   C(ind_C23O3ECO3) + C(ind_EMPOHNO2O2) + C(ind_C47CO3) + &
   C(ind_INB1HPCO3) + C(ind_INB1NACO3) + C(ind_INB1NBCO3) + &
   C(ind_MMALNACO3) + C(ind_MMALNBCO3) + C(ind_INDHPCO3) + &
   C(ind_INANCOCO3) + C(ind_HIEB1O2) + C(ind_HIEB2O2) + C(ind_CHOOMCO3) + &
   C(ind_HO13C3CO3) + C(ind_C5CO23O2) + C(ind_CHOC2CO3) + &
   C(ind_CHOC3COCO3) + C(ind_C5124COCO3) + C(ind_CO235C6CO3) + &
   C(ind_NC71O2) + C(ind_C811O2) + C(ind_CHOC3COO2) + C(ind_H3C25C6CO3) + &
   C(ind_H3C25C6O2) + C(ind_C810O2) + C(ind_C818O2) + C(ind_C727CO3) + &
   C(ind_NC728O2) + C(ind_C728O2) + C(ind_C622O2) + C(ind_C823O2) + &
   C(ind_C819O2) + C(ind_C731CO3) + C(ind_C1011O2) + C(ind_C137O2) + &
   C(ind_C1013O2) + C(ind_C1010O2) + C(ind_C117O2) + C(ind_C830CO3) + &
   C(ind_C145O2) + C(ind_C927O2) + C(ind_C1214O2) + C(ind_CHOC4DOLO2) + &
   C(ind_C6TRONOHO2) + C(ind_C23C54CO3) + C(ind_C73O2) + C(ind_C74O2) + &
   C(ind_C715O2) + C(ind_C83O2) + C(ind_C95O2) + C(ind_C105O2) + &
   C(ind_C115O2) + C(ind_C125O2) + C(ind_C4CO2DBCO3) + C(ind_C5CO2DBCO3) &
   + C(ind_C4DBM2CO3) + C(ind_C5DBCO2CO3) + C(ind_C7CO2DBCO3) + &
   C(ind_C8CO2DBCO3) + C(ind_C8DBCO2CO3) + C(ind_C4DBMECO3) + &
   C(ind_C5DBECO3) + C(ind_C5EDBCO3) + C(ind_C31CO3) + C(ind_C533O2) + &
   C(ind_C5124COO2) + C(ind_CO235C6O2) + C(ind_C716O2) + C(ind_C922O2) + &
   C(ind_C614O2) + C(ind_C511O2) + C(ind_C620O2) + C(ind_C87CO3) + &
   C(ind_C616O2) + C(ind_C718CO3) + C(ind_C513O2) + C(ind_CO25C6CO3) + &
   C(ind_C627O2) + C(ind_C727O2) + C(ind_C511CO3) + C(ind_C517CO3) + &
   C(ind_C517O2) + C(ind_C628O2) + C(ind_C824O2) + C(ind_C1211CO3) + &
   C(ind_C133O2) + C(ind_C830O2) + C(ind_C128O2) + C(ind_HO24C4CO3) + &
   C(ind_C613O2) + C(ind_CO2OH3MCO3) + C(ind_C812O2) + C(ind_C721CO3) + &
   C(ind_C721O2) + C(ind_H3C2C4CO3) + C(ind_C87O2) + C(ind_C718O2) + &
   C(ind_C514O2) + C(ind_C820O2) + C(ind_C518CO3) + C(ind_NC623O2) + &
   C(ind_C623O2) + C(ind_C825O2) + C(ind_C731O2) + C(ind_C732CO3) + &
   C(ind_C1012O2) + C(ind_C1211O2) + C(ind_C139O2) + C(ind_C1014O2) + &
   C(ind_C736O2) + C(ind_C118O2) + C(ind_C928CO3) + C(ind_C630O2) + &
   C(ind_C1215O2) + C(ind_EMALANHYO2) + C(ind_PMALANHYO2) + &
   C(ind_IPMALNHYO2) + C(ind_C312COCO3) + C(ind_CHOCOCH2O2) + &
   C(ind_NC72O2) + C(ind_C621O2) + C(ind_C515CO3) + C(ind_C515O2) + &
   C(ind_C821O2) + C(ind_HMVKBCO3) + C(ind_C520O2) + C(ind_C624CO3) + &
   C(ind_C732O2) + C(ind_C829O2) + C(ind_C134O2) + C(ind_C827CO3) + &
   C(ind_C522CO3) + C(ind_C831O2) + C(ind_C928O2) + C(ind_C46CO3) + &
   C(ind_C930O2) + C(ind_C813O2) + C(ind_C722O2) + C(ind_C615CO3) + &
   C(ind_C617CO3) + C(ind_C618CO3) + C(ind_C617O2) + C(ind_C618O2) + &
   C(ind_NC730O2) + C(ind_C730O2) + C(ind_C624O2) + C(ind_C733O2) + &
   C(ind_C1212O2) + C(ind_C827O2) + C(ind_C1310O2) + C(ind_NC61CO3) + &
   C(ind_C615O2) + C(ind_C519CO3) + C(ind_C629O2) + C(ind_C734O2) + &
   C(ind_C521O2) + C(ind_C135O2) + C(ind_COO2C4CO3) + C(ind_COO2C4O2) + &
   C(ind_C929O2) + C(ind_C516O2) + C(ind_C44O2) + C(ind_H1C23C4CO3) + &
   C(ind_H1C23C4O2) + C(ind_CO1M22CO3) + C(ind_C519O2) + C(ind_C625O2) + &
   C(ind_C1213O2) + C(ind_COO2C3CO3) + C(ind_MOCOCH2O2) + C(ind_C828CO3) &
   + C(ind_C828O2) + C(ind_CHOCOMOXO2 )
! ### FROM HERE ###
KRO2NO = 2.7D-12*EXP(360/TEMP)
KRO2HO2 = 2.91D-13*EXP(1300/TEMP)
KAPHO2 = 5.2D-13*EXP(980/TEMP)
KAPNO = 7.5D-12*EXP(290/TEMP)
KRO2NO3 = 2.3D-12
KNO3AL = 1.4D-12*EXP(-1860/TEMP)
KDEC = 1.00D+06
KROPRIM = 2.50D-14*EXP(-300/TEMP)
KROSEC = 2.50D-14*EXP(-300/TEMP)
KCH3O2 = 1.03D-13*EXP(365/TEMP)
K298CH3O2 = 3.5D-13
K16ISOM1 = 4.60D9*EXP(-8380/TEMP)*EXP(1.00D8/TEMP**3)
K15ISOM1 = 1.50D11*EXP(-9750/TEMP)
K14ISOM1 = 3.00D7*EXP(-5300/TEMP)
KD0 = 1.10D-05*M*EXP(-10100/TEMP)
KDI = 1.90D17*EXP(-14100/TEMP)
KRD = KD0/KDI
FCD = 0.30
NCD = 0.75-1.27*(LOG10(FCD))
FD = 10**(LOG10(FCD)/(1+(LOG10(KRD)/NCD)**2))
KBPAN = (KD0*KDI)*FD/(KD0+KDI)
KC0 = 3.28D-28*M*(TEMP/300)**-6.87
KCI = 1.125D-11*(TEMP/300)**-1.105
KRC = KC0/KCI
FCC = 0.30
NC = 0.75-1.27*(LOG10(FCC))
FC = 10**(LOG10(FCC)/(1+(LOG10(KRC)/NC)**2))
KFPAN = (KC0*KCI)*FC/(KC0+KCI)
K10 = 1.0D-31*M*(TEMP/300)**-1.6
K1I = 3.00D-11*(TEMP/300)**0.3
KR1 = K10/K1I
FC1 = 0.85
NC1 = 0.75-1.27*(LOG10(FC1))
F1 = 10**(LOG10(FC1)/(1+(LOG10(KR1)/NC1)**2))
KMT01 = (K10*K1I)*F1/(K10+K1I)
K20 = 1.3D-31*M*(TEMP/300)**-1.5
K2I = 2.3D-11*(TEMP/300)**0.24
KR2 = K20/K2I
FC2 = 0.6
NC2 = 0.75-1.27*(LOG10(FC2))
F2xx = 10**(LOG10(FC2)/(1+(LOG10(KR2)/NC2)**2))
KMT02 = (K20*K2I)*F2xx/(K20+K2I)
K30 = 3.6D-30*M*(TEMP/300)**-4.1
K3I = 1.9D-12*(TEMP/300)**0.2
KR3 = K30/K3I
FC3 = 0.35
NC3 = 0.75-1.27*(LOG10(FC3))
F3 = 10**(LOG10(FC3)/(1+(LOG10(KR3)/NC3)**2))
KMT03 = (K30*K3I)*F3/(K30+K3I)
K40 = 1.3D-3*M*(TEMP/300)**-3.5*EXP(-11000/TEMP)
K4I = 9.7D+14*(TEMP/300)**0.1*EXP(-11080/TEMP)
KR4 = K40/K4I
FC4 = 0.35
NC4 = 0.75-1.27*(LOG10(FC4))
F4 = 10**(LOG10(FC4)/(1+(LOG10(KR4)/NC4)**2))
KMT04 = (K40*K4I)*F4/(K40+K4I)
KMT05 = 1.44D-13*(1+(M/4.2D+19))
KMT06 = 1 + (1.40D-21*EXP(2200/TEMP)*H2O)
K70 = 7.4D-31*M*(TEMP/300)**-2.4
K7I = 3.3D-11*(TEMP/300)**-0.3
KR7 = K70/K7I
FC7 = EXP(-TEMP/1420)
NC7 = 0.75-1.27*(LOG10(FC7))
F7 = 10**(LOG10(FC7)/(1+(LOG10(KR7)/NC7)**2))
KMT07 = (K70*K7I)*F7/(K70+K7I)
K80 = 3.3D-30*M*(TEMP/300)**-3.0
K8I = 4.1D-11
KR8 = K80/K8I
FC8 = 0.4
NC8 = 0.75-1.27*(LOG10(FC8))
F8 = 10**(LOG10(FC8)/(1+(LOG10(KR8)/NC8)**2))
KMT08 = (K80*K8I)*F8/(K80+K8I)
K90 = 1.8D-31*M*(TEMP/300)**-3.2
K9I = 4.7D-12
KR9 = K90/K9I
FC9 = 0.6
NC9 = 0.75-1.27*(LOG10(FC9))
F9 = 10**(LOG10(FC9)/(1+(LOG10(KR9)/NC9)**2))
KMT09 = (K90*K9I)*F9/(K90+K9I)
K100 = 4.10D-05*M*EXP(-10650/TEMP)
K10I = 4.8D+15*EXP(-11170/TEMP)
KR10 = K100/K10I
FC10 = 0.6
NC10 = 0.75-1.27*(LOG10(FC10))
F10 = 10**(LOG10(FC10)/(1+(LOG10(KR10)/NC10)**2))
KMT10 = (K100*K10I)*F10/(K100+K10I)
K1 = 2.40D-14*EXP(460/TEMP)
K3 = 6.50D-34*EXP(1335/TEMP)
K4 = 2.70D-17*EXP(2199/TEMP)
K2 = (K3*M)/(1+(K3*M/K4))
KMT11 = K1 + K2
K120 = 4.5D-31*M*(TEMP/300)**-3.9
K12I = 1.3D-12*(TEMP/300)**-0.7
KR12 = K120/K12I
FC12 = 0.525
NC12 = 0.75-1.27*(LOG10(FC12))
F12 = 10**(LOG10(FC12)/(1.0+(LOG10(KR12)/NC12)**2))
KMT12 = (K120*K12I*F12)/(K120+K12I)
K130 = 2.5D-30*M*(TEMP/300)**-5.5
K13I = 1.8D-11
KR13 = K130/K13I
FC13 = 0.36
NC13 = 0.75-1.27*(LOG10(FC13))
F13 = 10**(LOG10(FC13)/(1+(LOG10(KR13)/NC13)**2))
KMT13 = (K130*K13I)*F13/(K130+K13I)
K140 = 9.0D-5*EXP(-9690/TEMP)*M
K14I = 1.1D+16*EXP(-10560/TEMP)
KR14 = K140/K14I
FC14 = 0.4
NC14 = 0.75-1.27*(LOG10(FC14))
F14 = 10**(LOG10(FC14)/(1+(LOG10(KR14)/NC14)**2))
KMT14 = (K140*K14I)*F14/(K140+K14I)
K150 = 8.6D-29*M*(TEMP/300)**-3.1
K15I = 9.0D-12*(TEMP/300)**-0.85
KR15 = K150/K15I
FC15 = 0.48
NC15 = 0.75-1.27*(LOG10(FC15))
F15 = 10**(LOG10(FC15)/(1+(LOG10(KR15)/NC15)**2))
KMT15 = (K150*K15I)*F15/(K150+K15I)
K160 = 8D-27*M*(TEMP/300)**-3.5
K16I = 3.0D-11*(TEMP/300)**-1
KR16 = K160/K16I
FC16 = 0.5
NC16 = 0.75-1.27*(LOG10(FC16))
F16 = 10**(LOG10(FC16)/(1+(LOG10(KR16)/NC16)**2))
KMT16 = (K160*K16I)*F16/(K160+K16I)
K170 = 5.0D-30*M*(TEMP/300)**-1.5
K17I = 1.0D-12
KR17 = K170/K17I
FC17 = 0.17*EXP(-51/TEMP)+EXP(-TEMP/204)
NC17 = 0.75-1.27*(LOG10(FC17))
F17 = 10**(LOG10(FC17)/(1.0+(LOG10(KR17)/NC17)**2))
KMT17 = (K170*K17I*F17)/(K170+K17I)
KMT18 = 9.5D-39*O2*EXP(5270/TEMP)/(1+7.5D-29*O2*EXP(5610/TEMP))
KPPN0 = 1.7D-03*EXP(-11280/TEMP)*M
KPPNI = 8.3D+16*EXP(-13940/TEMP)
KRPPN = KPPN0/KPPNI
FCPPN = 0.36
NCPPN = 0.75-1.27*(LOG10(FCPPN))
FPPN = 10**(LOG10(FCPPN)/(1+(LOG10(KRPPN)/NCPPN)**2))
KBPPN = (KPPN0*KPPNI)*FCPPN/(KPPN0+KPPNI)

! End INLINED RCONST

! RCONST(1) = constant rate coefficient
  RCONST(2) = (5.6D-34*N2*(TEMP/300)**-2.6*O2+6.0D-34*O2*(TEMP/300)**-2.6*O2)
  RCONST(3) = (8.0D-12*EXP(-2060/TEMP))
  RCONST(4) = (KMT01)
  RCONST(5) = (5.5D-12*EXP(188/TEMP))
  RCONST(6) = (KMT02)
  RCONST(7) = (3.2D-11*EXP(67/TEMP)*O2+2.0D-11*EXP(130/TEMP)*N2)
  RCONST(8) = (1.4D-12*EXP(-1310/TEMP))
  RCONST(9) = (1.4D-13*EXP(-2470/TEMP))
  RCONST(10) = (3.3D-39*EXP(530/TEMP)*O2)
  RCONST(11) = (1.8D-11*EXP(110/TEMP))
  RCONST(12) = (4.50D-14*EXP(-1260/TEMP))
  RCONST(13) = (KMT03)
  RCONST(14) = (2.14D-10*H2O)
  RCONST(15) = (1.70D-12*EXP(-940/TEMP))
  RCONST(16) = (7.7D-12*EXP(-2100/TEMP))
  RCONST(17) = (KMT05)
  RCONST(18) = (2.9D-12*EXP(-160/TEMP))
  RCONST(19) = (2.03D-16*(TEMP/300)**4.57*EXP(693/TEMP))
  RCONST(20) = (4.8D-11*EXP(250/TEMP))
  RCONST(21) = (2.20D-13*KMT06*EXP(600/TEMP)+1.90D-33*M*KMT06*EXP(980/TEMP))
  RCONST(22) = (KMT07)
  RCONST(23) = (KMT08)
  RCONST(24) = (2.0D-11)
  RCONST(25) = (3.45D-12*EXP(270/TEMP))
  RCONST(26) = (KMT09)
  RCONST(27) = (3.2D-13*EXP(690/TEMP)*1.0)
  RCONST(28) = (4.0D-12)
  RCONST(29) = (2.5D-12*EXP(260/TEMP))
  RCONST(30) = (KMT11)
  RCONST(31) = (4.0D-32*EXP(-1000/TEMP)*M)
  RCONST(32) = (KMT12)
  RCONST(33) = (1.3D-12*EXP(-330/TEMP)*O2)
  RCONST(34) = (6.00D-06)
  RCONST(35) = (4.00D-04)
  RCONST(36) = (1.20D-15*H2O)
  RCONST(37) = (j('o31d'))
  RCONST(38) = (j('o33p'))
  RCONST(39) = (j('h2o2'))
  RCONST(40) = (j('no2'))
  RCONST(41) = (j('no3o2'))
  RCONST(42) = (j('no3o'))
  RCONST(43) = (j('hno2'))
  RCONST(44) = (j('hno3'))
  RCONST(45) = (KMT04)
  RCONST(46) = (KMT10)
  RCONST(47) = (2.85D-12*EXP(-345/TEMP))
  RCONST(48) = (3.0D-12*EXP(20/TEMP)*0.05)
  RCONST(49) = (3.0D-12*EXP(20/TEMP)*0.9)
  RCONST(50) = (3.0D-12*EXP(20/TEMP)*0.05)
  RCONST(51) = (4.6D-12*EXP(70/TEMP)*0.494)
  RCONST(52) = (4.6D-12*EXP(70/TEMP)*0.063)
  RCONST(53) = (4.6D-12*EXP(70/TEMP)*0.443)
  RCONST(54) = (2.6D-12*EXP(200/TEMP)*0.861)
  RCONST(55) = (2.6D-12*EXP(200/TEMP)*0.139)
  RCONST(56) = (5.3D-12*EXP(140/TEMP)*0.358)
  RCONST(57) = (5.3D-12*EXP(140/TEMP)*0.321)
  RCONST(58) = (5.3D-12*EXP(140/TEMP)*0.321)
  RCONST(59) = (8.7D-12*0.361)
  RCONST(60) = (8.7D-12*0.639)
  RCONST(61) = (2.73D-12*EXP(352/TEMP)*0.558)
  RCONST(62) = (2.73D-12*EXP(352/TEMP)*0.090)
  RCONST(63) = (2.73D-12*EXP(352/TEMP)*0.352)
  RCONST(64) = (1.6D-12*EXP(-121/TEMP)*0.888)
  RCONST(65) = (1.6D-12*EXP(-121/TEMP)*0.112)
  RCONST(66) = (1.22D-11*0.436)
  RCONST(67) = (1.22D-11*0.070)
  RCONST(68) = (1.22D-11*0.493)
  RCONST(69) = (1.12D-11*0.288)
  RCONST(70) = (1.12D-11*0.258)
  RCONST(71) = (1.12D-11*0.454)
  RCONST(72) = (1.31D-11*0.288)
  RCONST(73) = (1.31D-11*0.454)
  RCONST(74) = (1.31D-11*0.258)
  RCONST(75) = (3.85D-12*0.100)
  RCONST(76) = (3.85D-12*0.701)
  RCONST(77) = (3.85D-12*0.199)
  RCONST(78) = (1.24D-11*0.074)
  RCONST(79) = (1.24D-11*0.463)
  RCONST(80) = (1.24D-11*0.463)
  RCONST(81) = (1.77D-11*0.739)
  RCONST(82) = (1.77D-11*0.261)
  RCONST(83) = (2.88D-12*0.693)
  RCONST(84) = (2.88D-12*0.270)
  RCONST(85) = (2.88D-12*0.037)
  RCONST(86) = (j('mek'))
  RCONST(87) = (1.45D-11)
  RCONST(88) = (1.20D-11*0.613)
  RCONST(89) = (1.20D-11*0.387)
  RCONST(90) = (4.6D-14*EXP(-400/TEMP)*0.65)
  RCONST(91) = (4.6D-14*EXP(-400/TEMP)*0.35)
  RCONST(92) = (1.0D-17*0.3)
  RCONST(93) = (1.0D-17*0.7)
  RCONST(94) = (8.1D-12*EXP(610/TEMP)*0.67)
  RCONST(95) = (8.1D-12*EXP(610/TEMP)*0.33)
  RCONST(96) = (j('ch2or'))
  RCONST(97) = (j('ch2om'))
  RCONST(98) = (5.5D-16)
  RCONST(99) = (5.4D-12*EXP(135/TEMP))
  RCONST(100) = (j('ch3cho'))
  RCONST(101) = (1.4D-12*EXP(-1860/TEMP))
  RCONST(102) = (4.7D-12*EXP(345/TEMP)*0.95)
  RCONST(103) = (4.7D-12*EXP(345/TEMP)*0.05)
  RCONST(104) = (3.24D-12*EXP(-1860/TEMP))
  RCONST(105) = (4.9D-12*EXP(405/TEMP))
  RCONST(106) = (j('c2h5cho'))
  RCONST(107) = (1.7D-12*EXP(-1500/TEMP))
  RCONST(108) = (6.0D-12*EXP(410/TEMP)*0.151)
  RCONST(109) = (6.0D-12*EXP(410/TEMP)*0.849)
  RCONST(110) = (j('n_c3h7cho_ch3cho'))
  RCONST(111) = (j('n_c3h7cho_hco'))
  RCONST(112) = (1.67D-12*EXP(-1460/TEMP))
  RCONST(113) = (6.8D-12*EXP(410/TEMP)*0.054)
  RCONST(114) = (6.8D-12*EXP(410/TEMP)*0.059)
  RCONST(115) = (6.8D-12*EXP(410/TEMP)*0.887)
  RCONST(116) = (j('i_c3h7cho'))
  RCONST(117) = (KNO3AL*5.5)
  RCONST(118) = (6.34D-12*EXP(448/TEMP)*0.19)
  RCONST(119) = (6.34D-12*EXP(448/TEMP)*0.81)
  RCONST(120) = (j('n_c3h7cho_hco'))
  RCONST(121) = (1.72D-13*EXP(-1190/TEMP))
  RCONST(122) = (0.68*2.00E-11)
  RCONST(123) = (0.255*2.00E-11)
  RCONST(124) = (0.065*2.00E-11)
  RCONST(125) = (0.3*j('ch2cch3cho_hco'))
  RCONST(126) = (0.4*j('ch2cch3cho_hco'))
  RCONST(127) = (0.3*j('ch2cch3cho_hco'))
  RCONST(128) = (0.5*2.9E-19)
  RCONST(129) = (0.5*2.9E-19)
  RCONST(130) = (j('ch2cch3cho_hco'))
  RCONST(131) = (j('ch2cch3cho_h'))
  RCONST(132) = (3.4D-15)
  RCONST(133) = (1.4D-15*EXP(-2100/TEMP)*0.12)
  RCONST(134) = (1.4D-15*EXP(-2100/TEMP)*0.88)
  RCONST(135) = (8.0D-12*EXP(380/TEMP)*0.45)
  RCONST(136) = (8.0D-12*EXP(380/TEMP)*0.47)
  RCONST(137) = (8.0D-12*EXP(380/TEMP)*0.08)
  RCONST(138) = (6D-15*0.65)
  RCONST(139) = (6D-15*0.175)
  RCONST(140) = (6D-15*0.175)
  RCONST(141) = (1.58E-18*0.5)
  RCONST(142) = (1.58E-18*0.5)
  RCONST(143) = (0.5*3.4E-11)
  RCONST(144) = (0.25*3.4E-11)
  RCONST(145) = (0.25*3.4E-11)
  RCONST(146) = (j('ch2cch3cho_hco')*1.44)
  RCONST(147) = (6.6D-12*EXP(-1240/TEMP))
  RCONST(148) = (1.85D-12*EXP(-1690/TEMP))
  RCONST(149) = (8.3D-11*EXP(-100/TEMP))
  RCONST(150) = (6.9D-12*EXP(-1000/TEMP))
  RCONST(151) = (1.4D-10*0.43*EXP(75/TEMP))
  RCONST(152) = (1.4D-10*0.59*EXP(-90/TEMP))
  RCONST(153) = (7.6D-12*EXP(-585/TEMP)*0.736)
  RCONST(154) = (7.6D-12*EXP(-585/TEMP)*0.264)
  RCONST(155) = (2.05D-10*0.44*EXP(-120/TEMP))
  RCONST(156) = (2.05D-10*0.59*EXP(55/TEMP))
  RCONST(157) = (9.8D-12*EXP(-425/TEMP)*0.127)
  RCONST(158) = (9.8D-12*EXP(-425/TEMP)*0.873)
  RCONST(159) = (1.43D-10*0.564)
  RCONST(160) = (1.43D-10*0.436)
  RCONST(161) = (1.16D-17*TEMP**2*EXP(225/TEMP)*0.206)
  RCONST(162) = (1.16D-17*TEMP**2*EXP(225/TEMP)*0.794)
  RCONST(163) = (2.80D-10*0.222)
  RCONST(164) = (2.80D-10*0.558)
  RCONST(165) = (2.80D-10*0.220)
  RCONST(166) = (2.44D-17*TEMP**2*EXP(183/TEMP)*0.083)
  RCONST(167) = (2.44D-17*TEMP**2*EXP(183/TEMP)*0.568)
  RCONST(168) = (2.44D-17*TEMP**2*EXP(183/TEMP)*0.349)
  RCONST(169) = (2.20D-10*0.408)
  RCONST(170) = (2.20D-10*0.342)
  RCONST(171) = (2.20D-10*0.250)
  RCONST(172) = (3.70D-12*0.087)
  RCONST(173) = (3.70D-12*0.297)
  RCONST(174) = (3.70D-12*0.616)
  RCONST(175) = (1.11D-10)
  RCONST(176) = (1.80D-17*TEMP**2*EXP(-189/TEMP))
  RCONST(177) = (3.40D-10*0.182)
  RCONST(178) = (3.40D-10*0.457)
  RCONST(179) = (3.40D-10*0.361)
  RCONST(180) = (1.53D-17*TEMP**2*EXP(414/TEMP)*0.061)
  RCONST(181) = (1.53D-17*TEMP**2*EXP(414/TEMP)*0.421)
  RCONST(182) = (1.53D-17*TEMP**2*EXP(414/TEMP)*0.518)
  RCONST(183) = (2.90D-10*0.321)
  RCONST(184) = (2.90D-10*0.269)
  RCONST(185) = (2.90D-10*0.213)
  RCONST(186) = (2.90D-10*0.197)
  RCONST(187) = (5.30D-12*0.063)
  RCONST(188) = (5.30D-12*0.218)
  RCONST(189) = (5.30D-12*0.267)
  RCONST(190) = (5.30D-12*0.452)
  RCONST(191) = (2.80D-10*0.317)
  RCONST(192) = (2.80D-10*0.530)
  RCONST(193) = (2.80D-10*0.153)
  RCONST(194) = (5.40D-12*0.060)
  RCONST(195) = (5.40D-12*0.413)
  RCONST(196) = (5.40D-12*0.527)
  RCONST(197) = (1.71D-10*0.461)
  RCONST(198) = (1.71D-10*0.154)
  RCONST(199) = (1.71D-10*0.386)
  RCONST(200) = (3.22D-11*EXP(-781/TEMP)*0.632)
  RCONST(201) = (3.22D-11*EXP(-781/TEMP)*0.092)
  RCONST(202) = (3.22D-11*EXP(-781/TEMP)*0.276)
  RCONST(203) = (2.30D-10*0.478)
  RCONST(204) = (2.30D-10*0.522)
  RCONST(205) = (1.24D-17*TEMP**2*EXP(494/TEMP)*0.877)
  RCONST(206) = (1.24D-17*TEMP**2*EXP(494/TEMP)*0.123)
  RCONST(207) = (3.90D-10)
  RCONST(208) = (1.59D-17*TEMP**2*EXP(478/TEMP))
  RCONST(209) = (3.50D-10*0.779)
  RCONST(210) = (3.50D-10*0.221)
  RCONST(211) = (6.86D-12*0.625)
  RCONST(212) = (6.86D-12*0.375)
  RCONST(213) = (3.11D-10*0.793)
  RCONST(214) = (3.11D-10*0.207)
  RCONST(215) = (7.15D-12*0.558)
  RCONST(216) = (7.15D-12*0.442)
  RCONST(217) = (4.60D-10)
  RCONST(218) = (2.76D-17*TEMP**2*EXP(378/TEMP))
  RCONST(219) = (4.80D-10)
  RCONST(220) = (2.51D-17*TEMP**2*EXP(447/TEMP))
  RCONST(221) = (5.55D-10)
  RCONST(222) = (3.13D-17*TEMP**2*EXP(416/TEMP))
  RCONST(223) = (6.17D-10)
  RCONST(224) = (1.29D-11)
  RCONST(225) = (6.74D-10)
  RCONST(226) = (1.39D-11)
  RCONST(227) = (3.50D-10)
  RCONST(228) = (2.88D-17*TEMP**2*EXP(309/TEMP))
  RCONST(229) = (3.3D-12*EXP(-2880/TEMP))
  RCONST(230) = (9.1D-15*EXP(-2580/TEMP))
  RCONST(231) = (KMT15)
  RCONST(232) = (4.6D-13*EXP(-1155/TEMP)*0.35)
  RCONST(233) = (4.6D-13*EXP(-1155/TEMP)*0.65)
  RCONST(234) = (5.5D-15*EXP(-1880/TEMP)*0.5)
  RCONST(235) = (5.5D-15*EXP(-1880/TEMP)*0.5)
  RCONST(236) = (KMT16*0.87)
  RCONST(237) = (KMT16*0.13)
  RCONST(238) = (3.2D-13*EXP(-950/TEMP)*0.65)
  RCONST(239) = (3.2D-13*EXP(-950/TEMP)*0.35)
  RCONST(240) = (3.55D-15*EXP(-1745/TEMP)*0.5)
  RCONST(241) = (3.55D-15*EXP(-1745/TEMP)*0.5)
  RCONST(242) = (6.6D-12*EXP(465/TEMP)*0.13)
  RCONST(243) = (6.6D-12*EXP(465/TEMP)*0.87)
  RCONST(244) = (3.50D-13)
  RCONST(245) = (3.22D-15*EXP(-968/TEMP))
  RCONST(246) = (1.10D-11*EXP(487/TEMP))
  RCONST(247) = (3.90D-13)
  RCONST(248) = (6.64D-15*EXP(-1059/TEMP))
  RCONST(249) = (1.01D-11*EXP(550/TEMP))
  RCONST(250) = (3.4D-13*0.8)
  RCONST(251) = (3.4D-13*0.2)
  RCONST(252) = (2.7D-15*EXP(-1630/TEMP)*0.5)
  RCONST(253) = (2.7D-15*EXP(-1630/TEMP)*0.5)
  RCONST(254) = (9.4D-12*EXP(505/TEMP)*0.924)
  RCONST(255) = (9.4D-12*EXP(505/TEMP)*0.076)
  RCONST(256) = (1.20D-14*0.65)
  RCONST(257) = (1.20D-14*0.35)
  RCONST(258) = (1.00D-17*0.5)
  RCONST(259) = (1.00D-17*0.5)
  RCONST(260) = (5.86D-12*EXP(500/TEMP)*0.87)
  RCONST(261) = (5.86D-12*EXP(500/TEMP)*0.13)
  RCONST(262) = (3.70D-13*0.5)
  RCONST(263) = (3.70D-13*0.5)
  RCONST(264) = (1.60D-16*0.5)
  RCONST(265) = (1.60D-16*0.5)
  RCONST(266) = (6.54D-11*0.5)
  RCONST(267) = (6.54D-11*0.5)
  RCONST(268) = (3.70D-13*0.5)
  RCONST(269) = (3.70D-13*0.5)
  RCONST(270) = (1.60D-16*0.5)
  RCONST(271) = (1.60D-16*0.5)
  RCONST(272) = (6.69D-11*0.5)
  RCONST(273) = (6.69D-11*0.5)
  RCONST(274) = (3.30D-13*0.2)
  RCONST(275) = (3.30D-13*0.8)
  RCONST(276) = (1.60D-17*0.5)
  RCONST(277) = (1.60D-17*0.5)
  RCONST(278) = (6.07D-11*0.924)
  RCONST(279) = (6.07D-11*0.076)
  RCONST(280) = (1.20D-14*0.65)
  RCONST(281) = (1.20D-14*0.35)
  RCONST(282) = (1.10D-17*0.5)
  RCONST(283) = (1.10D-17*0.5)
  RCONST(284) = (5.32D-12*EXP(533/TEMP)*0.130)
  RCONST(285) = (5.32D-12*EXP(533/TEMP)*0.870)
  RCONST(286) = (9.37D-12*0.35)
  RCONST(287) = (9.37D-12*0.65)
  RCONST(288) = (6.51D-15*EXP(-829/TEMP)*0.50)
  RCONST(289) = (6.51D-15*EXP(-829/TEMP)*0.50)
  RCONST(290) = (1.92D-11*EXP(450/TEMP)*0.353)
  RCONST(291) = (1.92D-11*EXP(450/TEMP)*0.647)
  RCONST(292) = (1.20D-14*0.35)
  RCONST(293) = (1.20D-14*0.65)
  RCONST(294) = (1.10D-17*0.5)
  RCONST(295) = (1.10D-17*0.5)
  RCONST(296) = (3.70D-11*0.870)
  RCONST(297) = (3.70D-11*0.130)
  RCONST(298) = (3.70D-13*0.5)
  RCONST(299) = (3.70D-13*0.5)
  RCONST(300) = (1.60D-16*0.5)
  RCONST(301) = (1.60D-16*0.5)
  RCONST(302) = (6.00D-11*0.5)
  RCONST(303) = (6.00D-11*0.5)
  RCONST(304) = (3.70D-13*0.5)
  RCONST(305) = (3.70D-13*0.5)
  RCONST(306) = (1.60D-16*0.5)
  RCONST(307) = (1.60D-16*0.5)
  RCONST(308) = (6.00D-11*0.5)
  RCONST(309) = (6.00D-11*0.5)
  RCONST(310) = (5.72D-11)
  RCONST(311) = (3.03D-15*EXP(-294/TEMP))
  RCONST(312) = (1.10D-10)
  RCONST(313) = (KMT17*0.636)
  RCONST(314) = (KMT17*0.364)
  RCONST(315) = (2.3D-12*EXP(-190/TEMP)*0.352)
  RCONST(316) = (2.3D-12*EXP(-190/TEMP)*0.118)
  RCONST(317) = (2.3D-12*EXP(-190/TEMP)*0.53)
  RCONST(318) = (1.8D-12*EXP(340/TEMP)*0.07)
  RCONST(319) = (1.8D-12*EXP(340/TEMP)*0.18)
  RCONST(320) = (1.8D-12*EXP(340/TEMP)*0.65)
  RCONST(321) = (1.8D-12*EXP(340/TEMP)*0.10)
  RCONST(322) = (4.10D-16)
  RCONST(323) = (1.36D-11*0.55)
  RCONST(324) = (1.36D-11*0.24)
  RCONST(325) = (1.36D-11*0.05)
  RCONST(326) = (1.36D-11*0.16)
  RCONST(327) = (2.60D-16)
  RCONST(328) = (2.31D-11*0.50)
  RCONST(329) = (2.31D-11*0.29)
  RCONST(330) = (2.31D-11*0.04)
  RCONST(331) = (2.31D-11*0.17)
  RCONST(332) = (5.00D-16)
  RCONST(333) = (1.43D-11*0.625)
  RCONST(334) = (1.43D-11*0.155)
  RCONST(335) = (1.43D-11*0.10)
  RCONST(336) = (1.43D-11*0.12)
  RCONST(337) = (1.20D-16)
  RCONST(338) = (7.00D-12*0.07)
  RCONST(339) = (7.00D-12*0.18)
  RCONST(340) = (7.00D-12*0.65)
  RCONST(341) = (7.00D-12*0.10)
  RCONST(342) = (1.40D-16)
  RCONST(343) = (5.80D-12*0.18)
  RCONST(344) = (5.80D-12*0.65)
  RCONST(345) = (5.80D-12*0.10)
  RCONST(346) = (5.80D-12*0.07)
  RCONST(347) = (1.40D-16)
  RCONST(348) = (6.30D-12*0.18)
  RCONST(349) = (6.30D-12*0.65)
  RCONST(350) = (6.30D-12*0.10)
  RCONST(351) = (6.30D-12*0.07)
  RCONST(352) = (1.90D-15)
  RCONST(353) = (3.27D-11*0.06)
  RCONST(354) = (3.27D-11*0.03)
  RCONST(355) = (3.27D-11*0.70)
  RCONST(356) = (3.27D-11*0.21)
  RCONST(357) = (1.80D-15)
  RCONST(358) = (3.25D-11*0.06)
  RCONST(359) = (3.25D-11*0.61)
  RCONST(360) = (3.25D-11*0.03)
  RCONST(361) = (3.25D-11*0.30)
  RCONST(362) = (8.80D-16)
  RCONST(363) = (5.67D-11*0.79)
  RCONST(364) = (5.67D-11*0.04)
  RCONST(365) = (5.67D-11*0.14)
  RCONST(366) = (5.67D-11*0.03)
  RCONST(367) = (7.10D-16)
  RCONST(368) = (1.19D-11*0.05)
  RCONST(369) = (1.19D-11*0.55)
  RCONST(370) = (1.19D-11*0.24)
  RCONST(371) = (1.19D-11*0.16)
  RCONST(372) = (4.50D-16)
  RCONST(373) = (1.86D-11*0.04)
  RCONST(374) = (1.86D-11*0.50)
  RCONST(375) = (1.86D-11*0.29)
  RCONST(376) = (1.86D-11*0.17)
  RCONST(377) = (8.60D-16)
  RCONST(378) = (1.18D-11*0.10)
  RCONST(379) = (1.18D-11*0.625)
  RCONST(380) = (1.18D-11*0.155)
  RCONST(381) = (1.18D-11*0.12)
  RCONST(382) = (1.50D-15)
  RCONST(383) = (5.67D-11*0.03)
  RCONST(384) = (5.67D-11*0.79)
  RCONST(385) = (5.67D-11*0.14)
  RCONST(386) = (5.67D-11*0.04)
  RCONST(387) = (2.60D-15)
  RCONST(388) = (5.67D-11*0.03)
  RCONST(389) = (5.67D-11*0.04)
  RCONST(390) = (5.67D-11*0.79)
  RCONST(391) = (5.67D-11*0.14)
  RCONST(392) = (1.50D-12)
  RCONST(393) = (1.70D-17*0.5)
  RCONST(394) = (1.70D-17*0.5)
  RCONST(395) = (5.80D-11)
  RCONST(396) = (j('ch2cch3cho_h'))
  RCONST(397) = (j('ch2cch3cho_hco'))
  RCONST(398) = (2.40D-15)
  RCONST(399) = (5.9D-12*EXP(225/TEMP))
  RCONST(400) = (1.03D-13*0.5)
  RCONST(401) = (1.03D-13*0.5)
  RCONST(402) = (1.34D-14*EXP(-2283/TEMP)*0.5)
  RCONST(403) = (1.34D-14*EXP(-2283/TEMP)*0.5)
  RCONST(404) = (1.48D-11*EXP(448/TEMP)*0.217)
  RCONST(405) = (1.48D-11*EXP(448/TEMP)*0.649)
  RCONST(406) = (1.48D-11*EXP(448/TEMP)*0.134)
  RCONST(407) = (3.15D-12*EXP(-450/TEMP))
  RCONST(408) = (1.03D-14*EXP(-1995/TEMP)*0.3)
  RCONST(409) = (1.03D-14*EXP(-1995/TEMP)*0.2)
  RCONST(410) = (1.03D-14*EXP(-1995/TEMP)*0.3)
  RCONST(411) = (1.03D-14*EXP(-1995/TEMP)*0.2)
  RCONST(412) = (2.70D-11*EXP(390/TEMP)*0.280)
  RCONST(413) = (2.70D-11*EXP(390/TEMP)*0.178)
  RCONST(414) = (2.70D-11*EXP(390/TEMP)*0.022)
  RCONST(415) = (2.70D-11*EXP(390/TEMP)*0.020)
  RCONST(416) = (2.70D-11*EXP(390/TEMP)*0.042)
  RCONST(417) = (2.70D-11*EXP(390/TEMP)*0.280)
  RCONST(418) = (2.70D-11*EXP(390/TEMP)*0.178)
  RCONST(419) = (2.60D-16)
  RCONST(420) = (5.7D-12*EXP(-215/TEMP))
  RCONST(421) = (2.80D-15)
  RCONST(422) = (8.91D-18*TEMP**2*EXP(837/TEMP)*0.928)
  RCONST(423) = (8.91D-18*TEMP**2*EXP(837/TEMP)*0.072)
  RCONST(424) = (8.8D-12*EXP(-1320/TEMP)+1.7D-14*EXP(423/TEMP))
  RCONST(425) = (j('ch3coch3'))
  RCONST(426) = (1.5D-12*EXP(-90/TEMP)*0.459)
  RCONST(427) = (1.5D-12*EXP(-90/TEMP)*0.462)
  RCONST(428) = (1.5D-12*EXP(-90/TEMP)*0.079)
  RCONST(429) = (j('mek'))
  RCONST(430) = (4.90D-12*0.818)
  RCONST(431) = (4.90D-12*0.182)
  RCONST(432) = (j('mek'))
  RCONST(433) = (2.00D-12*0.501)
  RCONST(434) = (2.00D-12*0.499)
  RCONST(435) = (j('mek'))
  RCONST(436) = (j('mek'))
  RCONST(437) = (2.77D-12*0.523)
  RCONST(438) = (2.77D-12*0.477)
  RCONST(439) = (9.10D-12*0.715)
  RCONST(440) = (9.10D-12*0.162)
  RCONST(441) = (9.10D-12*0.123)
  RCONST(442) = (j('mek'))
  RCONST(443) = (6.90D-12*0.638)
  RCONST(444) = (6.90D-12*0.142)
  RCONST(445) = (6.90D-12*0.110)
  RCONST(446) = (6.90D-12*0.110)
  RCONST(447) = (j('mek'))
  RCONST(448) = (1.41D-11*0.91)
  RCONST(449) = (1.41D-11*0.09)
  RCONST(450) = (j('mek'))
  RCONST(451) = (j('mek'))
  RCONST(452) = (1.21D-12)
  RCONST(453) = (5.40D-12)
  RCONST(454) = (j('mek')*0.5)
  RCONST(455) = (j('mek')*0.5)
  RCONST(456) = (1.2D-12*EXP(490/TEMP)*0.65)
  RCONST(457) = (1.2D-12*EXP(490/TEMP)*0.35)
  RCONST(458) = (6.3D-16*EXP(-580/TEMP)*0.6)
  RCONST(459) = (6.3D-16*EXP(-580/TEMP)*0.4)
  RCONST(460) = (1.2D-11*EXP(440/TEMP)*0.572)
  RCONST(461) = (1.2D-11*EXP(440/TEMP)*0.353)
  RCONST(462) = (1.2D-11*EXP(440/TEMP)*0.075)
  RCONST(463) = (2.51D-12*0.8)
  RCONST(464) = (2.51D-12*0.2)
  RCONST(465) = (1.50D-17*0.4)
  RCONST(466) = (1.50D-17*0.6)
  RCONST(467) = (2.38D-11*EXP(357/TEMP)*0.849)
  RCONST(468) = (2.38D-11*EXP(357/TEMP)*0.076)
  RCONST(469) = (2.38D-11*EXP(357/TEMP)*0.075)
  RCONST(470) = (1.22D-11)
  RCONST(471) = (2.95D-15*EXP(-783/TEMP)*0.730)
  RCONST(472) = (2.95D-15*EXP(-783/TEMP)*0.270)
  RCONST(473) = (4.28D-11*EXP(401/TEMP)*0.408)
  RCONST(474) = (4.28D-11*EXP(401/TEMP)*0.222)
  RCONST(475) = (4.28D-11*EXP(401/TEMP)*0.370)
  RCONST(476) = (1.90D-11)
  RCONST(477) = (1.16D-14*0.435)
  RCONST(478) = (1.16D-14*0.435)
  RCONST(479) = (1.16D-14*0.100)
  RCONST(480) = (1.16D-14*0.030)
  RCONST(481) = (1.97D-10*0.408)
  RCONST(482) = (1.97D-10*0.222)
  RCONST(483) = (1.97D-10*0.370)
  RCONST(484) = (2.4D-14*EXP(-325/TEMP)*O2)
  RCONST(485) = (1.53D-13*EXP(1300/TEMP))
  RCONST(486) = (KRO2NO*0.005)
  RCONST(487) = (KRO2NO*0.995)
  RCONST(488) = (KRO2NO3)
  RCONST(489) = (2*(KCH3O2*7.8D-14*EXP(1000/TEMP))**0.5*RO2*0.2)
  RCONST(490) = (2*(KCH3O2*7.8D-14*EXP(1000/TEMP))**0.5*RO2*0.6)
  RCONST(491) = (2*(KCH3O2*7.8D-14*EXP(1000/TEMP))**0.5*RO2*0.2)
  RCONST(492) = (KRO2HO2*0.520)
  RCONST(493) = (KRO2NO*0.019)
  RCONST(494) = (KRO2NO*0.981)
  RCONST(495) = (KRO2NO3)
  RCONST(496) = (6.00D-13*0.6*RO2)
  RCONST(497) = (6.00D-13*0.2*RO2)
  RCONST(498) = (6.00D-13*0.2*RO2)
  RCONST(499) = (KRO2HO2*0.520)
  RCONST(500) = (KRO2NO3)
  RCONST(501) = (8.80D-13*0.2*RO2)
  RCONST(502) = (8.80D-13*0.6*RO2)
  RCONST(503) = (8.80D-13*0.2*RO2)
  RCONST(504) = (KRO2NO*0.977)
  RCONST(505) = (KRO2NO*0.023)
  RCONST(506) = (KRO2HO2*0.520)
  RCONST(507) = (KRO2NO*0.991)
  RCONST(508) = (KRO2NO*0.009)
  RCONST(509) = (KRO2NO3)
  RCONST(510) = (2.00D-12*0.2*RO2)
  RCONST(511) = (2.00D-12*0.6*RO2)
  RCONST(512) = (2.00D-12*0.2*RO2)
  RCONST(513) = (KRO2HO2*0.625)
  RCONST(514) = (KRO2NO*0.042)
  RCONST(515) = (KRO2NO*0.958)
  RCONST(516) = (KRO2NO3)
  RCONST(517) = (8.80D-13*0.2*RO2)
  RCONST(518) = (8.80D-13*0.6*RO2)
  RCONST(519) = (8.80D-13*0.2*RO2)
  RCONST(520) = (KRO2HO2*0.625)
  RCONST(521) = (KRO2NO*0.083)
  RCONST(522) = (KRO2NO*0.917)
  RCONST(523) = (KRO2NO3)
  RCONST(524) = (8.80D-13*0.2*RO2)
  RCONST(525) = (8.80D-13*0.2*RO2)
  RCONST(526) = (8.80D-13*0.6*RO2)
  RCONST(527) = (KRO2HO2*0.625)
  RCONST(528) = (KRO2NO*0.959)
  RCONST(529) = (KRO2NO*0.041)
  RCONST(530) = (KRO2NO3)
  RCONST(531) = (8.80D-13*0.6*RO2)
  RCONST(532) = (8.80D-13*0.2*RO2)
  RCONST(533) = (8.80D-13*0.2*RO2)
  RCONST(534) = (KRO2HO2*0.625)
  RCONST(535) = (KRO2NO*0.012)
  RCONST(536) = (KRO2NO*0.988)
  RCONST(537) = (KRO2NO3)
  RCONST(538) = (9.20D-14*0.7*RO2)
  RCONST(539) = (9.20D-14*0.3*RO2)
  RCONST(540) = (KRO2HO2*0.625)
  RCONST(541) = (KRO2NO*0.041)
  RCONST(542) = (KRO2NO*0.959)
  RCONST(543) = (KRO2NO3)
  RCONST(544) = (1.30D-12*0.2*RO2)
  RCONST(545) = (1.30D-12*0.6*RO2)
  RCONST(546) = (1.30D-12*0.2*RO2)
  RCONST(547) = (5.60D-14*EXP(1650/TEMP))
  RCONST(548) = (KRO2NO*0.017)
  RCONST(549) = (KRO2NO*0.983)
  RCONST(550) = (KRO2NO3)
  RCONST(551) = (2.00D-13*0.2*RO2)
  RCONST(552) = (2.00D-13*0.2*RO2)
  RCONST(553) = (2.00D-13*0.6*RO2)
  RCONST(554) = (6.00D+14*EXP(-8153/TEMP))
  RCONST(555) = (KRO2HO2*0.706)
  RCONST(556) = (KRO2NO*0.052)
  RCONST(557) = (KRO2NO*0.948)
  RCONST(558) = (KRO2NO3)
  RCONST(559) = (1.30D-12*0.2*RO2)
  RCONST(560) = (1.30D-12*0.2*RO2)
  RCONST(561) = (1.30D-12*0.6*RO2)
  RCONST(562) = (KRO2HO2*0.706)
  RCONST(563) = (KRO2NO*0.064)
  RCONST(564) = (KRO2NO*0.936)
  RCONST(565) = (KRO2NO3)
  RCONST(566) = (8.80D-13*0.2*RO2)
  RCONST(567) = (8.80D-13*0.2*RO2)
  RCONST(568) = (8.80D-13*0.6*RO2)
  RCONST(569) = (j('n_c3h7cho_ch3cho'))
  RCONST(570) = (j('i_c3h7cho'))
  RCONST(571) = (KNO3AL*8.5)
  RCONST(572) = (2.69D-11)
  RCONST(573) = (KRO2HO2*0.706)
  RCONST(574) = (KRO2NO*0.129)
  RCONST(575) = (KRO2NO*0.871)
  RCONST(576) = (KRO2NO3)
  RCONST(577) = (1.30D-12*0.6*RO2)
  RCONST(578) = (1.30D-12*0.2*RO2)
  RCONST(579) = (1.30D-12*0.2*RO2)
  RCONST(580) = (KRO2HO2*0.706)
  RCONST(581) = (KRO2NO*0.019)
  RCONST(582) = (KRO2NO*0.981)
  RCONST(583) = (KRO2NO3)
  RCONST(584) = (9.20D-14*0.7*RO2)
  RCONST(585) = (9.20D-14*0.3*RO2)
  RCONST(586) = (KNO3AL*8.5)
  RCONST(587) = (2.95D-11*0.267)
  RCONST(588) = (2.95D-11*0.733)
  RCONST(589) = (KRO2HO2*0.706)
  RCONST(590) = (KRO2NO*0.039)
  RCONST(591) = (KRO2NO*0.961)
  RCONST(592) = (KRO2NO3)
  RCONST(593) = (6.70D-15*0.7*RO2)
  RCONST(594) = (6.70D-15*0.3*RO2)
  RCONST(595) = (KRO2HO2*0.706)
  RCONST(596) = (KRO2NO*0.064)
  RCONST(597) = (KRO2NO*0.936)
  RCONST(598) = (KRO2NO3)
  RCONST(599) = (8.80D-13*0.2*RO2)
  RCONST(600) = (8.80D-13*0.6*RO2)
  RCONST(601) = (8.80D-13*0.2*RO2)
  RCONST(602) = (KRO2HO2*0.706)
  RCONST(603) = (KRO2NO*0.052)
  RCONST(604) = (KRO2NO*0.948)
  RCONST(605) = (KRO2NO3)
  RCONST(606) = (1.30D-12*0.2*RO2)
  RCONST(607) = (1.30D-12*0.6*RO2)
  RCONST(608) = (1.30D-12*0.2*RO2)
  RCONST(609) = (KRO2HO2*0.706)
  RCONST(610) = (KRO2NO*0.062)
  RCONST(611) = (KRO2NO*0.938)
  RCONST(612) = (KRO2NO3)
  RCONST(613) = (8.80D-13*0.20*RO2)
  RCONST(614) = (8.80D-13*0.60*RO2)
  RCONST(615) = (8.80D-13*0.20*RO2)
  RCONST(616) = (KRO2HO2*0.706)
  RCONST(617) = (KRO2NO*0.024)
  RCONST(618) = (KRO2NO*0.976)
  RCONST(619) = (KRO2NO3)
  RCONST(620) = (2.00D-12*0.2*RO2)
  RCONST(621) = (2.00D-12*0.6*RO2)
  RCONST(622) = (2.00D-12*0.2*RO2)
  RCONST(623) = (KRO2HO2*0.706)
  RCONST(624) = (KRO2NO*0.033)
  RCONST(625) = (KRO2NO*0.967)
  RCONST(626) = (KRO2NO3)
  RCONST(627) = (1.30D-12*0.6*RO2)
  RCONST(628) = (1.30D-12*0.2*RO2)
  RCONST(629) = (1.30D-12*0.2*RO2)
  RCONST(630) = (KRO2HO2*0.706)
  RCONST(631) = (KRO2NO*0.019)
  RCONST(632) = (KRO2NO*0.981)
  RCONST(633) = (KRO2NO3)
  RCONST(634) = (9.20D-14*0.3*RO2)
  RCONST(635) = (9.20D-14*0.7*RO2)
  RCONST(636) = (KRO2HO2*0.770)
  RCONST(637) = (KRO2NO*0.938)
  RCONST(638) = (KRO2NO*0.062)
  RCONST(639) = (KRO2NO3)
  RCONST(640) = (8.80D-13*0.6*RO2)
  RCONST(641) = (8.80D-13*0.2*RO2)
  RCONST(642) = (8.80D-13*0.2*RO2)
  RCONST(643) = (KRO2HO2*0.770)
  RCONST(644) = (KRO2NO)
  RCONST(645) = (KRO2NO3)
  RCONST(646) = (8.80D-13*0.2*RO2)
  RCONST(647) = (8.80D-13*0.6*RO2)
  RCONST(648) = (8.80D-13*0.2*RO2)
  RCONST(649) = (KRO2HO2*0.770)
  RCONST(650) = (KRO2NO*0.961)
  RCONST(651) = (KRO2NO*0.039)
  RCONST(652) = (KRO2NO3)
  RCONST(653) = (2.00D-12*0.2*RO2)
  RCONST(654) = (2.00D-12*0.2*RO2)
  RCONST(655) = (2.00D-12*0.6*RO2)
  RCONST(656) = (KRO2HO2*0.770)
  RCONST(657) = (KRO2NO)
  RCONST(658) = (KRO2NO3)
  RCONST(659) = (2.00D-12*0.2*RO2)
  RCONST(660) = (2.00D-12*0.2*RO2)
  RCONST(661) = (2.00D-12*0.6*RO2)
  RCONST(662) = (KAPHO2*0.15)
  RCONST(663) = (KAPHO2*0.41)
  RCONST(664) = (KAPHO2*0.44)
  RCONST(665) = (7.5D-12*EXP(290/TEMP))
  RCONST(666) = (KFPAN)
  RCONST(667) = (4.0D-12)
  RCONST(668) = (2*(K298CH3O2*2.9D-12*EXP(500/TEMP))**0.5*RO2*0.3)
  RCONST(669) = (2*(K298CH3O2*2.9D-12*EXP(500/TEMP))**0.5*RO2*0.7)
  RCONST(670) = (KNO3AL)
  RCONST(671) = (1.00D-11*0.200)
  RCONST(672) = (1.00D-11*0.800)
  RCONST(673) = (j('n_c3h7cho_hco'))
  RCONST(674) = (1.6D-12*EXP(305/TEMP))
  RCONST(675) = (j('mek'))
  RCONST(676) = (KNO3AL*2.4)
  RCONST(677) = (1.7D-11)
  RCONST(678) = (j('i_c3h7cho'))
  RCONST(679) = (KRO2HO2*0.706)
  RCONST(680) = (KRO2NO)
  RCONST(681) = (KRO2NO3)
  RCONST(682) = (8.8D-13*RO2*0.2)
  RCONST(683) = (8.8D-13*RO2*0.2)
  RCONST(684) = (8.8D-13*RO2*0.6)
  RCONST(685) = (KRO2HO2*0.706)
  RCONST(686) = (KRO2NO)
  RCONST(687) = (KRO2NO3)
  RCONST(688) = (1.3D-12*RO2*0.2)
  RCONST(689) = (1.3D-12*RO2*0.2)
  RCONST(690) = (1.3D-12*RO2*0.6)
  RCONST(691) = (KDEC*0.36)
  RCONST(692) = (KDEC*0.20)
  RCONST(693) = (KDEC*0.20)
  RCONST(694) = (KDEC*0.24)
  RCONST(695) = (1.4D-11)
  RCONST(696) = (j('i_c3h7cho'))
  RCONST(697) = (KDEC*0.24)
  RCONST(698) = (KDEC*0.40)
  RCONST(699) = (KDEC*0.36)
  RCONST(700) = (KRO2HO2*0.706)
  RCONST(701) = (KRO2NO*0.064)
  RCONST(702) = (KRO2NO*0.936)
  RCONST(703) = (KRO2NO3)
  RCONST(704) = (8.8D-13*RO2*0.2)
  RCONST(705) = (8.8D-13*RO2*0.6)
  RCONST(706) = (8.8D-13*RO2*0.2)
  RCONST(707) = (KRO2HO2*0.706)
  RCONST(708) = (KRO2NO*0.026)
  RCONST(709) = (KRO2NO*0.974)
  RCONST(710) = (KRO2NO3)
  RCONST(711) = (2.0D-12*RO2*0.2)
  RCONST(712) = (2.0D-12*RO2*0.2)
  RCONST(713) = (2.0D-12*RO2*0.6)
  RCONST(714) = (3.8D-13*EXP(780/TEMP)*(1-1/(1+498*EXP(-1160/TEMP))))
  RCONST(715) = (3.8D-13*EXP(780/TEMP)*(1/(1+498*EXP(-1160/TEMP))))
  RCONST(716) = (2.3D-12*EXP(360/TEMP)*0.001)
  RCONST(717) = (2.3D-12*EXP(360/TEMP)*0.999)
  RCONST(718) = (KMT13)
  RCONST(719) = (1.2D-12)
  RCONST(720) = (2*KCH3O2*RO2*7.18*EXP(-885/TEMP))
  RCONST(721) = (2*KCH3O2*RO2*0.5*(1-7.18*EXP(-885/TEMP)))
  RCONST(722) = (2*KCH3O2*RO2*0.5*(1-7.18*EXP(-885/TEMP)))
  RCONST(723) = (KRO2HO2*0.387)
  RCONST(724) = (KRO2NO)
  RCONST(725) = (KRO2NO3)
  RCONST(726) = (2.00D-12*0.2*RO2)
  RCONST(727) = (2.00D-12*0.6*RO2)
  RCONST(728) = (2.00D-12*0.2*RO2)
  RCONST(729) = (KAPHO2*0.44)
  RCONST(730) = (KAPHO2*0.41)
  RCONST(731) = (KAPHO2*0.15)
  RCONST(732) = (6.7D-12*EXP(340/TEMP))
  RCONST(733) = (KFPAN)
  RCONST(734) = (KRO2NO3*1.74)
  RCONST(735) = (1.00D-11*0.7*RO2)
  RCONST(736) = (1.00D-11*0.3*RO2)
  RCONST(737) = (4.3D-13*EXP(870/TEMP))
  RCONST(738) = (2.55D-12*EXP(380/TEMP)*0.009)
  RCONST(739) = (2.55D-12*EXP(380/TEMP)*0.991)
  RCONST(740) = (KRO2NO3)
  RCONST(741) = (2*(KCH3O2*6.4D-14*(TEMP/300)**0*EXP(0/TEMP))**0.5*RO2*0.6)
  RCONST(742) = (2*(KCH3O2*6.4D-14*(TEMP/300)**0*EXP(0/TEMP))**0.5*RO2*0.2)
  RCONST(743) = (2*(KCH3O2*6.4D-14*(TEMP/300)**0*EXP(0/TEMP))**0.5*RO2*0.2)
  RCONST(744) = (KAPHO2*0.15)
  RCONST(745) = (KAPHO2*0.44)
  RCONST(746) = (KAPHO2*0.41)
  RCONST(747) = (KAPNO)
  RCONST(748) = (KFPAN)
  RCONST(749) = (KRO2NO3*1.74)
  RCONST(750) = (1.00D-11*0.3*RO2)
  RCONST(751) = (1.00D-11*0.7*RO2)
  RCONST(752) = (KRO2HO2*0.625)
  RCONST(753) = (KRO2NO*0.083)
  RCONST(754) = (KRO2NO*0.917)
  RCONST(755) = (KRO2NO3)
  RCONST(756) = (2.50D-13*0.6*RO2)
  RCONST(757) = (2.50D-13*0.2*RO2)
  RCONST(758) = (2.50D-13*0.2*RO2)
  RCONST(759) = (KRO2HO2*0.520)
  RCONST(760) = (2.9D-12*EXP(350/TEMP)*0.020)
  RCONST(761) = (2.9D-12*EXP(350/TEMP)*0.980)
  RCONST(762) = (KRO2NO3)
  RCONST(763) = (2*(K298CH3O2*3D-13)**0.5*RO2*0.2)
  RCONST(764) = (2*(K298CH3O2*3D-13)**0.5*RO2*0.6)
  RCONST(765) = (2*(K298CH3O2*3D-13)**0.5*RO2*0.2)
  RCONST(766) = (KAPHO2*0.15)
  RCONST(767) = (KAPHO2*0.44)
  RCONST(768) = (KAPHO2*0.41)
  RCONST(769) = (KAPNO)
  RCONST(770) = (KFPAN)
  RCONST(771) = (KRO2NO3*1.74)
  RCONST(772) = (1.00D-11*0.3*RO2)
  RCONST(773) = (1.00D-11*0.7*RO2)
  RCONST(774) = (KRO2HO2*0.625)
  RCONST(775) = (KRO2NO*0.033)
  RCONST(776) = (KRO2NO*0.967)
  RCONST(777) = (KRO2NO3)
  RCONST(778) = (1.30D-12*0.2*RO2)
  RCONST(779) = (1.30D-12*0.6*RO2)
  RCONST(780) = (1.30D-12*0.2*RO2)
  RCONST(781) = (KRO2HO2*0.625)
  RCONST(782) = (KRO2NO)
  RCONST(783) = (KRO2NO3)
  RCONST(784) = (9.20D-14*0.3*RO2)
  RCONST(785) = (9.20D-14*0.7*RO2)
  RCONST(786) = (KRO2HO2*0.520)
  RCONST(787) = (2.7D-12*EXP(360/TEMP)*0.042)
  RCONST(788) = (2.7D-12*EXP(360/TEMP)*0.958)
  RCONST(789) = (KRO2NO3)
  RCONST(790) = (2*(KCH3O2*1.6D-12*EXP(-2200/TEMP))**0.5*RO2*0.2)
  RCONST(791) = (2*(KCH3O2*1.6D-12*EXP(-2200/TEMP))**0.5*RO2*0.6)
  RCONST(792) = (2*(KCH3O2*1.6D-12*EXP(-2200/TEMP))**0.5*RO2*0.2)
  RCONST(793) = (KAPHO2*0.44)
  RCONST(794) = (KAPHO2*0.15)
  RCONST(795) = (KAPHO2*0.41)
  RCONST(796) = (KAPNO)
  RCONST(797) = (KFPAN)
  RCONST(798) = (KRO2NO3*1.74)
  RCONST(799) = (1.00D-11*0.7*RO2)
  RCONST(800) = (1.00D-11*0.3*RO2)
  RCONST(801) = (KRO2HO2*0.706)
  RCONST(802) = (KRO2NO*0.129)
  RCONST(803) = (KRO2NO*0.871)
  RCONST(804) = (KRO2NO3)
  RCONST(805) = (2.00D-12*0.6*RO2)
  RCONST(806) = (2.00D-12*0.2*RO2)
  RCONST(807) = (2.00D-12*0.2*RO2)
  RCONST(808) = (KRO2HO2*0.625)
  RCONST(809) = (KRO2NO*0.033)
  RCONST(810) = (KRO2NO*0.967)
  RCONST(811) = (KRO2NO3)
  RCONST(812) = (1.30D-12*0.2*RO2)
  RCONST(813) = (1.30D-12*0.2*RO2)
  RCONST(814) = (1.30D-12*0.6*RO2)
  RCONST(815) = (KAPHO2*0.15)
  RCONST(816) = (KAPHO2*0.41)
  RCONST(817) = (KAPHO2*0.44)
  RCONST(818) = (KAPNO)
  RCONST(819) = (KFPAN)
  RCONST(820) = (KRO2NO3*1.74)
  RCONST(821) = (1.00D-11*0.3*RO2)
  RCONST(822) = (1.00D-11*0.7*RO2)
  RCONST(823) = (KRO2HO2*0.52)
  RCONST(824) = (KRO2NO)
  RCONST(825) = (KRO2NO3)
  RCONST(826) = (8.8D-13*RO2*0.6)
  RCONST(827) = (K14ISOM1)
  RCONST(828) = (8.8D-13*RO2*0.2)
  RCONST(829) = (8.8D-13*RO2*0.2)
  RCONST(830) = (0.4*0.52*KRO2HO2)
  RCONST(831) = (0.6*0.52*KRO2HO2)
  RCONST(832) = (0.05*KRO2NO)
  RCONST(833) = (0.95*KRO2NO)
  RCONST(834) = (KRO2NO3)
  RCONST(835) = (2.0D-12*RO2*0.2)
  RCONST(836) = (2.0D-12*RO2*0.6)
  RCONST(837) = (2.0D-12*RO2*0.2)
  RCONST(838) = (0.3333*j('gly'))
  RCONST(839) = (0.3333*j('gly'))
  RCONST(840) = (0.3333*j('gly'))
  RCONST(841) = (KNO3AL)
  RCONST(842) = (3.1D-12*EXP(340/TEMP))
  RCONST(843) = (KDEC*0.24)
  RCONST(844) = (KDEC*0.20)
  RCONST(845) = (KDEC*0.20)
  RCONST(846) = (KDEC*0.36)
  RCONST(847) = (KDEC*0.35)
  RCONST(848) = (KDEC*0.65)
  RCONST(849) = (KAPHO2*0.44)
  RCONST(850) = (KAPHO2*0.15)
  RCONST(851) = (KAPHO2*0.41)
  RCONST(852) = (8.70D-12*EXP(290/TEMP))
  RCONST(853) = (KFPAN)
  RCONST(854) = (KRO2NO3*1.74)
  RCONST(855) = (1.00D-11*0.7*RO2)
  RCONST(856) = (1.00D-11*0.3*RO2)
  RCONST(857) = (KDEC*0.18)
  RCONST(858) = (KDEC*0.82)
  RCONST(859) = (j('ch3cocho'))
  RCONST(860) = (KNO3AL*2.4)
  RCONST(861) = (1.9D-12*EXP(575/TEMP))
  RCONST(862) = (KDEC*0.37)
  RCONST(863) = (KDEC*0.47)
  RCONST(864) = (KDEC*0.16)
  RCONST(865) = (KRO2HO2*0.625)
  RCONST(866) = (KRO2NO*0.013)
  RCONST(867) = (KRO2NO*0.987)
  RCONST(868) = (KRO2NO3)
  RCONST(869) = (K14ISOM1)
  RCONST(870) = (9.20D-14*0.7*RO2)
  RCONST(871) = (9.20D-14*0.3*RO2)
  RCONST(872) = (KRO2HO2*0.625)
  RCONST(873) = (KRO2NO*0.017)
  RCONST(874) = (KRO2NO*0.983)
  RCONST(875) = (KRO2NO3)
  RCONST(876) = (1.4D-12*0.2*RO2)
  RCONST(877) = (1.4D-12*0.2*RO2)
  RCONST(878) = (1.4D-12*0.6*RO2)
  RCONST(879) = (KAPHO2*0.41)
  RCONST(880) = (KAPHO2*0.15)
  RCONST(881) = (KAPHO2*0.44)
  RCONST(882) = (KAPNO)
  RCONST(883) = (KFPAN)
  RCONST(884) = (KRO2NO3*1.74)
  RCONST(885) = (1.00D-11*RO2*0.3)
  RCONST(886) = (1.00D-11*RO2*0.7)
  RCONST(887) = (KRO2HO2*0.625)
  RCONST(888) = (KRO2NO)
  RCONST(889) = (KRO2NO3)
  RCONST(890) = (8.80D-13*RO2*0.2)
  RCONST(891) = (8.80D-13*RO2*0.6)
  RCONST(892) = (8.80D-13*RO2*0.2)
  RCONST(893) = (KRO2HO2*0.625)
  RCONST(894) = (KRO2NO)
  RCONST(895) = (KRO2NO3)
  RCONST(896) = (8.80D-13*RO2*0.2)
  RCONST(897) = (8.80D-13*RO2*0.6)
  RCONST(898) = (8.80D-13*RO2*0.2)
  RCONST(899) = (KDEC*0.18)
  RCONST(900) = (KDEC*0.57)
  RCONST(901) = (KDEC*0.125)
  RCONST(902) = (KDEC*0.125)
  RCONST(903) = (KRO2HO2*0.625)
  RCONST(904) = (KRO2NO*0.957)
  RCONST(905) = (KRO2NO*0.043)
  RCONST(906) = (KRO2NO3)
  RCONST(907) = (8.80D-13*RO2*0.60)
  RCONST(908) = (8.80D-13*RO2*0.20)
  RCONST(909) = (8.80D-13*RO2*0.20)
  RCONST(910) = (KRO2HO2*0.625)
  RCONST(911) = (KRO2NO)
  RCONST(912) = (KRO2NO3)
  RCONST(913) = (0.2*8.8E-13*RO2)
  RCONST(914) = (0.2*8.8E-13*RO2)
  RCONST(915) = (0.6*8.8E-13*RO2)
  RCONST(916) = (KRO2HO2*0.625)
  RCONST(917) = (KRO2NO*0.090)
  RCONST(918) = (KRO2NO*0.910)
  RCONST(919) = (KRO2NO3)
  RCONST(920) = (2.50D-13*0.2*RO2)
  RCONST(921) = (2.50D-13*0.2*RO2)
  RCONST(922) = (2.50D-13*0.6*RO2)
  RCONST(923) = (KRO2HO2*0.625)
  RCONST(924) = (KRO2NO*0.033)
  RCONST(925) = (KRO2NO*0.967)
  RCONST(926) = (KRO2NO3)
  RCONST(927) = (1.30D-12*0.2*RO2)
  RCONST(928) = (1.30D-12*0.6*RO2)
  RCONST(929) = (1.30D-12*0.2*RO2)
  RCONST(930) = (KRO2HO2*0.625)
  RCONST(931) = (KRO2NO*0.025)
  RCONST(932) = (KRO2NO*0.975)
  RCONST(933) = (KRO2NO3)
  RCONST(934) = (6.70D-15*0.3*RO2)
  RCONST(935) = (6.70D-15*0.7*RO2)
  RCONST(936) = (KRO2HO2*0.706)
  RCONST(937) = (KRO2NO*0.052)
  RCONST(938) = (KRO2NO*0.948)
  RCONST(939) = (KRO2NO3)
  RCONST(940) = (1.30D-12*0.2*RO2)
  RCONST(941) = (1.30D-12*0.6*RO2)
  RCONST(942) = (1.30D-12*0.2*RO2)
  RCONST(943) = (KRO2HO2*0.706)
  RCONST(944) = (KRO2NO*0.129)
  RCONST(945) = (KRO2NO*0.871)
  RCONST(946) = (KRO2NO3)
  RCONST(947) = (2.50D-13*0.2*RO2)
  RCONST(948) = (2.50D-13*0.6*RO2)
  RCONST(949) = (2.50D-13*0.2*RO2)
  RCONST(950) = (KRO2HO2*0.706)
  RCONST(951) = (KRO2NO*0.131)
  RCONST(952) = (KRO2NO*0.869)
  RCONST(953) = (KRO2NO3)
  RCONST(954) = (2.50D-13*0.2*RO2)
  RCONST(955) = (2.50D-13*0.6*RO2)
  RCONST(956) = (2.50D-13*0.2*RO2)
  RCONST(957) = (KRO2HO2*0.706)
  RCONST(958) = (KRO2NO*0.052)
  RCONST(959) = (KRO2NO*0.948)
  RCONST(960) = (KRO2NO3)
  RCONST(961) = (1.30D-12*0.2*RO2)
  RCONST(962) = (1.30D-12*0.6*RO2)
  RCONST(963) = (1.30D-12*0.2*RO2)
  RCONST(964) = (KRO2HO2*0.706)
  RCONST(965) = (KRO2NO*0.141)
  RCONST(966) = (KRO2NO*0.859)
  RCONST(967) = (KRO2NO3)
  RCONST(968) = (2.50D-13*0.6*RO2)
  RCONST(969) = (2.50D-13*0.2*RO2)
  RCONST(970) = (2.50D-13*0.2*RO2)
  RCONST(971) = (KRO2HO2*0.706)
  RCONST(972) = (KRO2NO*0.047)
  RCONST(973) = (KRO2NO*0.953)
  RCONST(974) = (KRO2NO3)
  RCONST(975) = (6.70D-15*0.7*RO2)
  RCONST(976) = (6.70D-15*0.3*RO2)
  RCONST(977) = (1.43D-13*EXP(1380/TEMP))
  RCONST(978) = (KRO2NO*0.051)
  RCONST(979) = (KRO2NO*0.949)
  RCONST(980) = (KRO2NO3)
  RCONST(981) = (1.3D-12*0.6*RO2)
  RCONST(982) = (1.3D-12*0.2*RO2)
  RCONST(983) = (1.3D-12*0.2*RO2)
  RCONST(984) = (KRO2HO2*0.770)
  RCONST(985) = (KRO2NO*0.078)
  RCONST(986) = (KRO2NO*0.922)
  RCONST(987) = (KRO2NO3)
  RCONST(988) = (1.30D-12*0.2*RO2)
  RCONST(989) = (1.30D-12*0.6*RO2)
  RCONST(990) = (1.30D-12*0.2*RO2)
  RCONST(991) = (KRO2HO2*0.770)
  RCONST(992) = (KRO2NO*0.209)
  RCONST(993) = (KRO2NO*0.791)
  RCONST(994) = (KRO2NO3)
  RCONST(995) = (2.50D-13*0.2*RO2)
  RCONST(996) = (2.50D-13*0.6*RO2)
  RCONST(997) = (2.50D-13*0.2*RO2)
  RCONST(998) = (KRO2HO2*0.770)
  RCONST(999) = (KRO2NO*0.230)
  RCONST(1000) = (KRO2NO*0.770)
  RCONST(1001) = (KRO2NO3)
  RCONST(1002) = (2.50D-13*0.2*RO2)
  RCONST(1003) = (2.50D-13*0.6*RO2)
  RCONST(1004) = (2.50D-13*0.2*RO2)
  RCONST(1005) = (KRO2HO2*0.770)
  RCONST(1006) = (KRO2NO*0.078)
  RCONST(1007) = (KRO2NO*0.922)
  RCONST(1008) = (KRO2NO3)
  RCONST(1009) = (1.30D-12*0.2*RO2)
  RCONST(1010) = (1.30D-12*0.6*RO2)
  RCONST(1011) = (1.30D-12*0.2*RO2)
  RCONST(1012) = (KRO2HO2*0.770)
  RCONST(1013) = (KRO2NO*0.190)
  RCONST(1014) = (KRO2NO*0.810)
  RCONST(1015) = (KRO2NO3)
  RCONST(1016) = (2.50D-13*0.6*RO2)
  RCONST(1017) = (2.50D-13*0.2*RO2)
  RCONST(1018) = (2.50D-13*0.2*RO2)
  RCONST(1019) = (KRO2HO2*0.770)
  RCONST(1020) = (KRO2NO*0.190)
  RCONST(1021) = (KRO2NO*0.810)
  RCONST(1022) = (KRO2NO3)
  RCONST(1023) = (2.50D-13*0.2*RO2)
  RCONST(1024) = (2.50D-13*0.6*RO2)
  RCONST(1025) = (2.50D-13*0.2*RO2)
  RCONST(1026) = (KRO2HO2*0.770)
  RCONST(1027) = (KRO2NO*0.031)
  RCONST(1028) = (KRO2NO*0.969)
  RCONST(1029) = (KRO2NO3)
  RCONST(1030) = (6.70D-15*0.7*RO2)
  RCONST(1031) = (6.70D-15*0.3*RO2)
  RCONST(1032) = (KRO2HO2*0.770)
  RCONST(1033) = (KRO2NO*0.078)
  RCONST(1034) = (KRO2NO*0.922)
  RCONST(1035) = (KRO2NO3)
  RCONST(1036) = (1.30D-12*0.2*RO2)
  RCONST(1037) = (1.30D-12*0.6*RO2)
  RCONST(1038) = (1.30D-12*0.2*RO2)
  RCONST(1039) = (KRO2HO2*0.770)
  RCONST(1040) = (KRO2NO*0.178)
  RCONST(1041) = (KRO2NO*0.822)
  RCONST(1042) = (KRO2NO3)
  RCONST(1043) = (2.50D-13*0.2*RO2)
  RCONST(1044) = (2.50D-13*0.6*RO2)
  RCONST(1045) = (2.50D-13*0.2*RO2)
  RCONST(1046) = (KRO2HO2*0.770)
  RCONST(1047) = (KRO2NO*0.059)
  RCONST(1048) = (KRO2NO*0.941)
  RCONST(1049) = (KRO2NO3)
  RCONST(1050) = (6.70D-15*0.7*RO2)
  RCONST(1051) = (6.70D-15*0.3*RO2)
  RCONST(1052) = (KRO2HO2*0.770)
  RCONST(1053) = (KRO2NO*0.195)
  RCONST(1054) = (KRO2NO*0.805)
  RCONST(1055) = (KRO2NO3)
  RCONST(1056) = (2.50D-13*0.6*RO2)
  RCONST(1057) = (2.50D-13*0.2*RO2)
  RCONST(1058) = (2.50D-13*0.2*RO2)
  RCONST(1059) = (KRO2HO2*0.770)
  RCONST(1060) = (KRO2NO*0.078)
  RCONST(1061) = (KRO2NO*0.922)
  RCONST(1062) = (KRO2NO3)
  RCONST(1063) = (1.30D-12*0.2*RO2)
  RCONST(1064) = (1.30D-12*0.6*RO2)
  RCONST(1065) = (1.30D-12*0.2*RO2)
  RCONST(1066) = (KRO2HO2*0.770)
  RCONST(1067) = (KRO2NO*0.078)
  RCONST(1068) = (KRO2NO*0.922)
  RCONST(1069) = (KRO2NO3)
  RCONST(1070) = (1.30D-12*0.2*RO2)
  RCONST(1071) = (1.30D-12*0.6*RO2)
  RCONST(1072) = (1.30D-12*0.2*RO2)
  RCONST(1073) = (KRO2HO2*0.770)
  RCONST(1074) = (KRO2NO*0.059)
  RCONST(1075) = (KRO2NO*0.941)
  RCONST(1076) = (KRO2NO3)
  RCONST(1077) = (6.70D-15*0.7*RO2)
  RCONST(1078) = (6.70D-15*0.3*RO2)
  RCONST(1079) = (KRO2HO2*0.770)
  RCONST(1080) = (KRO2NO*0.078)
  RCONST(1081) = (KRO2NO*0.922)
  RCONST(1082) = (KRO2NO3)
  RCONST(1083) = (1.30D-12*0.6*RO2)
  RCONST(1084) = (1.30D-12*0.2*RO2)
  RCONST(1085) = (1.30D-12*0.2*RO2)
  RCONST(1086) = (KRO2HO2*0.820)
  RCONST(1087) = (KRO2NO*0.278)
  RCONST(1088) = (KRO2NO*0.722)
  RCONST(1089) = (KRO2NO3)
  RCONST(1090) = (2.50D-13*0.2*RO2)
  RCONST(1091) = (2.50D-13*0.6*RO2)
  RCONST(1092) = (2.50D-13*0.2*RO2)
  RCONST(1093) = (KRO2HO2*0.820)
  RCONST(1094) = (KRO2NO*0.278)
  RCONST(1095) = (KRO2NO*0.722)
  RCONST(1096) = (KRO2NO3)
  RCONST(1097) = (2.50D-13*0.2*RO2)
  RCONST(1098) = (2.50D-13*0.6*RO2)
  RCONST(1099) = (2.50D-13*0.2*RO2)
  RCONST(1100) = (KRO2HO2*0.820)
  RCONST(1101) = (KRO2NO*0.083)
  RCONST(1102) = (KRO2NO*0.917)
  RCONST(1103) = (KRO2NO3)
  RCONST(1104) = (6.70D-15*0.7*RO2)
  RCONST(1105) = (6.70D-15*0.3*RO2)
  RCONST(1106) = (KRO2HO2*0.820)
  RCONST(1107) = (KRO2NO*0.278)
  RCONST(1108) = (KRO2NO*0.722)
  RCONST(1109) = (KRO2NO3)
  RCONST(1110) = (2.50D-13*0.2*RO2)
  RCONST(1111) = (2.50D-13*0.6*RO2)
  RCONST(1112) = (2.50D-13*0.2*RO2)
  RCONST(1113) = (KRO2HO2*0.820)
  RCONST(1114) = (KRO2NO*0.083)
  RCONST(1115) = (KRO2NO*0.917)
  RCONST(1116) = (KRO2NO3)
  RCONST(1117) = (6.70D-15*0.7*RO2)
  RCONST(1118) = (6.70D-15*0.3*RO2)
  RCONST(1119) = (KRO2HO2*0.859)
  RCONST(1120) = (KRO2NO*0.346)
  RCONST(1121) = (KRO2NO*0.654)
  RCONST(1122) = (KRO2NO3)
  RCONST(1123) = (2.50D-13*0.2*RO2)
  RCONST(1124) = (2.50D-13*0.6*RO2)
  RCONST(1125) = (2.50D-13*0.2*RO2)
  RCONST(1126) = (KRO2HO2*0.890)
  RCONST(1127) = (KRO2NO*0.393)
  RCONST(1128) = (KRO2NO*0.607)
  RCONST(1129) = (KRO2NO3)
  RCONST(1130) = (2.50D-13*0.2*RO2)
  RCONST(1131) = (2.50D-13*0.6*RO2)
  RCONST(1132) = (2.50D-13*0.2*RO2)
  RCONST(1133) = (KRO2HO2*0.914)
  RCONST(1134) = (KRO2NO*0.417)
  RCONST(1135) = (KRO2NO*0.583)
  RCONST(1136) = (KRO2NO3)
  RCONST(1137) = (2.50D-13*0.2*RO2)
  RCONST(1138) = (2.50D-13*0.6*RO2)
  RCONST(1139) = (2.50D-13*0.2*RO2)
  RCONST(1140) = (KRO2HO2*0.932)
  RCONST(1141) = (KRO2NO*0.431)
  RCONST(1142) = (KRO2NO*0.569)
  RCONST(1143) = (KRO2NO3)
  RCONST(1144) = (2.50D-13*0.2*RO2)
  RCONST(1145) = (2.50D-13*0.6*RO2)
  RCONST(1146) = (2.50D-13*0.2*RO2)
  RCONST(1147) = (KRO2HO2*0.947)
  RCONST(1148) = (KRO2NO*0.440)
  RCONST(1149) = (KRO2NO*0.560)
  RCONST(1150) = (KRO2NO3)
  RCONST(1151) = (2.50D-13*0.2*RO2)
  RCONST(1152) = (2.50D-13*0.6*RO2)
  RCONST(1153) = (2.50D-13*0.2*RO2)
  RCONST(1154) = (KRO2HO2*0.770)
  RCONST(1155) = (KRO2NO*0.078)
  RCONST(1156) = (KRO2NO*0.922)
  RCONST(1157) = (KRO2NO3)
  RCONST(1158) = (2.50D-13*0.6*RO2)
  RCONST(1159) = (2.50D-13*0.2*RO2)
  RCONST(1160) = (2.50D-13*0.2*RO2)
  RCONST(1161) = (KRO2HO2*0.387)
  RCONST(1162) = (KRO2NO)
  RCONST(1163) = (KRO2NO3)
  RCONST(1164) = (6.00D-13*0.6*RO2)
  RCONST(1165) = (6.00D-13*0.2*RO2)
  RCONST(1166) = (6.00D-13*0.2*RO2)
  RCONST(1167) = (KDEC*0.37)
  RCONST(1168) = (KDEC*0.50)
  RCONST(1169) = (KDEC*0.13)
  RCONST(1170) = (KRO2HO2*0.520)
  RCONST(1171) = (KRO2NO)
  RCONST(1172) = (KRO2NO3)
  RCONST(1173) = (6.00D-13*0.2*RO2)
  RCONST(1174) = (6.00D-13*0.6*RO2)
  RCONST(1175) = (6.00D-13*0.2*RO2)
  RCONST(1176) = (KRO2HO2*0.520)
  RCONST(1177) = (KRO2NO)
  RCONST(1178) = (KRO2NO3)
  RCONST(1179) = (4.00D-14*0.2*RO2)
  RCONST(1180) = (4.00D-14*0.2*RO2)
  RCONST(1181) = (4.00D-14*0.6*RO2)
  RCONST(1182) = (KDEC*0.24)
  RCONST(1183) = (KDEC*0.36)
  RCONST(1184) = (KDEC*0.20)
  RCONST(1185) = (KDEC*0.20)
  RCONST(1186) = (KRO2HO2*0.625)
  RCONST(1187) = (KRO2NO)
  RCONST(1188) = (KRO2NO3)
  RCONST(1189) = (2.50D-13*0.6*RO2)
  RCONST(1190) = (2.50D-13*0.2*RO2)
  RCONST(1191) = (2.50D-13*0.2*RO2)
  RCONST(1192) = (KRO2HO2*0.625)
  RCONST(1193) = (KRO2NO)
  RCONST(1194) = (KRO2NO3)
  RCONST(1195) = (2.00D-12*0.2*RO2)
  RCONST(1196) = (2.00D-12*0.6*RO2)
  RCONST(1197) = (2.00D-12*0.2*RO2)
  RCONST(1198) = (KDEC*0.24)
  RCONST(1199) = (KDEC*0.36)
  RCONST(1200) = (KDEC*0.20)
  RCONST(1201) = (KDEC*0.20)
  RCONST(1202) = (KRO2HO2*0.625)
  RCONST(1203) = (KRO2NO*0.017)
  RCONST(1204) = (KRO2NO*0.983)
  RCONST(1205) = (KRO2NO3)
  RCONST(1206) = (2.00D-12*0.2*RO2)
  RCONST(1207) = (2.00D-12*0.6*RO2)
  RCONST(1208) = (2.00D-12*0.2*RO2)
  RCONST(1209) = (KRO2HO2*0.625)
  RCONST(1210) = (KRO2NO)
  RCONST(1211) = (KRO2NO3)
  RCONST(1212) = (2.50D-13*0.2*RO2)
  RCONST(1213) = (2.50D-13*0.2*RO2)
  RCONST(1214) = (2.50D-13*0.6*RO2)
  RCONST(1215) = (KRO2HO2*0.625)
  RCONST(1216) = (KRO2NO)
  RCONST(1217) = (KRO2NO3)
  RCONST(1218) = (6.70D-15*0.7*RO2)
  RCONST(1219) = (6.70D-15*0.3*RO2)
  RCONST(1220) = (KRO2HO2*0.625)
  RCONST(1221) = (KRO2NO)
  RCONST(1222) = (KRO2NO3)
  RCONST(1223) = (1.30D-12*0.2*RO2)
  RCONST(1224) = (1.30D-12*0.2*RO2)
  RCONST(1225) = (1.30D-12*0.6*RO2)
  RCONST(1226) = (KDEC*0.18)
  RCONST(1227) = (KDEC*0.82)
  RCONST(1228) = (KDEC*0.18)
  RCONST(1229) = (KDEC*0.82)
  RCONST(1230) = (KRO2HO2*0.706)
  RCONST(1231) = (KRO2NO)
  RCONST(1232) = (KRO2NO3)
  RCONST(1233) = (2.50D-13*0.2*RO2)
  RCONST(1234) = (2.50D-13*0.6*RO2)
  RCONST(1235) = (2.50D-13*0.2*RO2)
  RCONST(1236) = (KRO2HO2*0.706)
  RCONST(1237) = (KRO2NO)
  RCONST(1238) = (KRO2NO3)
  RCONST(1239) = (1.30D-12*0.2*RO2)
  RCONST(1240) = (1.30D-12*0.6*RO2)
  RCONST(1241) = (1.30D-12*0.2*RO2)
  RCONST(1242) = (KDEC*0.24)
  RCONST(1243) = (KDEC*0.20)
  RCONST(1244) = (KDEC*0.36)
  RCONST(1245) = (KDEC*0.20)
  RCONST(1246) = (KRO2HO2*0.706)
  RCONST(1247) = (KRO2NO*0.064)
  RCONST(1248) = (KRO2NO*0.936)
  RCONST(1249) = (KRO2NO3)
  RCONST(1250) = (8.80D-13*0.2*RO2)
  RCONST(1251) = (8.80D-13*0.2*RO2)
  RCONST(1252) = (8.80D-13*0.6*RO2)
  RCONST(1253) = (KRO2HO2*0.706)
  RCONST(1254) = (KRO2NO*0.026)
  RCONST(1255) = (KRO2NO*0.974)
  RCONST(1256) = (KRO2NO3)
  RCONST(1257) = (2.00D-12*0.2*RO2)
  RCONST(1258) = (2.00D-12*0.2*RO2)
  RCONST(1259) = (2.00D-12*0.6*RO2)
  RCONST(1260) = (KRO2HO2*0.706)
  RCONST(1261) = (KRO2NO)
  RCONST(1262) = (KRO2NO3)
  RCONST(1263) = (2.50D-13*0.2*RO2)
  RCONST(1264) = (2.50D-13*0.6*RO2)
  RCONST(1265) = (2.50D-13*0.2*RO2)
  RCONST(1266) = (KRO2HO2*0.706)
  RCONST(1267) = (KRO2NO)
  RCONST(1268) = (KRO2NO3)
  RCONST(1269) = (2.50D-13*0.2*RO2)
  RCONST(1270) = (2.50D-13*0.6*RO2)
  RCONST(1271) = (2.50D-13*0.2*RO2)
  RCONST(1272) = (KDEC*0.18)
  RCONST(1273) = (KDEC*0.57)
  RCONST(1274) = (KDEC*0.125)
  RCONST(1275) = (KDEC*0.125)
  RCONST(1276) = (KRO2HO2*0.706)
  RCONST(1277) = (KRO2NO*0.064)
  RCONST(1278) = (KRO2NO*0.936)
  RCONST(1279) = (KRO2NO3)
  RCONST(1280) = (8.80D-13*0.2*RO2)
  RCONST(1281) = (8.80D-13*0.2*RO2)
  RCONST(1282) = (8.80D-13*0.6*RO2)
  RCONST(1283) = (KRO2HO2*0.706)
  RCONST(1284) = (KRO2NO)
  RCONST(1285) = (KRO2NO3)
  RCONST(1286) = (1.30D-12*0.6*RO2)
  RCONST(1287) = (1.30D-12*0.2*RO2)
  RCONST(1288) = (1.30D-12*0.2*RO2)
  RCONST(1289) = (KRO2HO2*0.706)
  RCONST(1290) = (KRO2NO)
  RCONST(1291) = (KRO2NO3)
  RCONST(1292) = (6.70D-15*0.7*RO2)
  RCONST(1293) = (6.70D-15*0.3*RO2)
  RCONST(1294) = (KDEC*0.18)
  RCONST(1295) = (KDEC*0.82)
  RCONST(1296) = (KRO2HO2*0.706)
  RCONST(1297) = (KRO2NO)
  RCONST(1298) = (KRO2NO3)
  RCONST(1299) = (9.20D-14*0.6*RO2)
  RCONST(1300) = (9.20D-14*0.2*RO2)
  RCONST(1301) = (9.20D-14*0.2*RO2)
  RCONST(1302) = (KRO2HO2*0.706)
  RCONST(1303) = (KRO2NO)
  RCONST(1304) = (KRO2NO3)
  RCONST(1305) = (2.00D-12*0.2*RO2)
  RCONST(1306) = (2.00D-12*0.6*RO2)
  RCONST(1307) = (2.00D-12*0.2*RO2)
  RCONST(1308) = (KDEC*0.20)
  RCONST(1309) = (KDEC*0.36)
  RCONST(1310) = (KDEC*0.20)
  RCONST(1311) = (KDEC*0.24)
  RCONST(1312) = (KRO2HO2*0.706)
  RCONST(1313) = (KRO2NO*0.026)
  RCONST(1314) = (KRO2NO*0.974)
  RCONST(1315) = (KRO2NO3)
  RCONST(1316) = (2.00D-12*0.2*RO2)
  RCONST(1317) = (2.00D-12*0.2*RO2)
  RCONST(1318) = (2.00D-12*0.6*RO2)
  RCONST(1319) = (KRO2HO2*0.706)
  RCONST(1320) = (KRO2NO)
  RCONST(1321) = (KRO2NO3)
  RCONST(1322) = (8.80D-13*0.6*RO2)
  RCONST(1323) = (8.80D-13*0.2*RO2)
  RCONST(1324) = (8.80D-13*0.2*RO2)
  RCONST(1325) = (KRO2HO2*0.706)
  RCONST(1326) = (KRO2NO)
  RCONST(1327) = (KRO2NO3)
  RCONST(1328) = (6.70D-15*0.7*RO2)
  RCONST(1329) = (6.70D-15*0.3*RO2)
  RCONST(1330) = (KDEC*0.11)
  RCONST(1331) = (KDEC*0.89)
  RCONST(1332) = (KDEC*0.11)
  RCONST(1333) = (KDEC*0.89)
  RCONST(1334) = (KRO2HO2*0.770)
  RCONST(1335) = (KRO2NO)
  RCONST(1336) = (KRO2NO3)
  RCONST(1337) = (2.00D-12*0.2*RO2)
  RCONST(1338) = (2.00D-12*0.6*RO2)
  RCONST(1339) = (2.00D-12*0.2*RO2)
  RCONST(1340) = (KRO2HO2*0.770)
  RCONST(1341) = (KRO2NO)
  RCONST(1342) = (KRO2NO3)
  RCONST(1343) = (8.80D-13*0.2*RO2)
  RCONST(1344) = (8.80D-13*0.6*RO2)
  RCONST(1345) = (8.80D-13*0.2*RO2)
  RCONST(1346) = (KDEC*0.20)
  RCONST(1347) = (KDEC*0.24)
  RCONST(1348) = (KDEC*0.36)
  RCONST(1349) = (KDEC*0.20)
  RCONST(1350) = (KRO2HO2*0.770)
  RCONST(1351) = (KRO2NO*0.097)
  RCONST(1352) = (KRO2NO*0.903)
  RCONST(1353) = (KRO2NO3)
  RCONST(1354) = (8.80D-13*0.2*RO2)
  RCONST(1355) = (8.80D-13*0.2*RO2)
  RCONST(1356) = (8.80D-13*0.6*RO2)
  RCONST(1357) = (KRO2HO2*0.770)
  RCONST(1358) = (KRO2NO*0.039)
  RCONST(1359) = (KRO2NO*0.961)
  RCONST(1360) = (KRO2NO3)
  RCONST(1361) = (2.00D-12*0.2*RO2)
  RCONST(1362) = (2.00D-12*0.2*RO2)
  RCONST(1363) = (2.00D-12*0.6*RO2)
  RCONST(1364) = (KRO2HO2*0.770)
  RCONST(1365) = (KRO2NO)
  RCONST(1366) = (KRO2NO3)
  RCONST(1367) = (8.80D-13*0.2*RO2)
  RCONST(1368) = (8.80D-13*0.6*RO2)
  RCONST(1369) = (8.80D-13*0.2*RO2)
  RCONST(1370) = (KRO2HO2*0.770)
  RCONST(1371) = (KRO2NO)
  RCONST(1372) = (KRO2NO3)
  RCONST(1373) = (8.80D-13*0.2*RO2)
  RCONST(1374) = (8.80D-13*0.6*RO2)
  RCONST(1375) = (8.80D-13*0.2*RO2)
  RCONST(1376) = (KDEC*0.18)
  RCONST(1377) = (KDEC*0.125)
  RCONST(1378) = (KDEC*0.57)
  RCONST(1379) = (KDEC*0.125)
  RCONST(1380) = (KRO2HO2*0.770)
  RCONST(1381) = (KRO2NO*0.097)
  RCONST(1382) = (KRO2NO*0.903)
  RCONST(1383) = (KRO2NO3)
  RCONST(1384) = (8.80D-13*0.2*RO2)
  RCONST(1385) = (8.80D-13*0.6*RO2)
  RCONST(1386) = (8.80D-13*0.2*RO2)
  RCONST(1387) = (KRO2HO2*0.770)
  RCONST(1388) = (KRO2NO*0.097)
  RCONST(1389) = (KRO2NO*0.903)
  RCONST(1390) = (KRO2NO3)
  RCONST(1391) = (8.80D-13*0.2*RO2)
  RCONST(1392) = (8.80D-13*0.6*RO2)
  RCONST(1393) = (8.80D-13*0.2*RO2)
  RCONST(1394) = (KRO2HO2*0.770)
  RCONST(1395) = (KRO2NO)
  RCONST(1396) = (KRO2NO3)
  RCONST(1397) = (9.20D-14*RO2*0.70)
  RCONST(1398) = (9.20D-14*RO2*0.30)
  RCONST(1399) = (KDEC)
  RCONST(1400) = (KRO2HO2*0.770)
  RCONST(1401) = (KRO2NO*0.031)
  RCONST(1402) = (KRO2NO*0.969)
  RCONST(1403) = (KRO2NO3)
  RCONST(1404) = (9.20D-14*RO2*0.30)
  RCONST(1405) = (9.20D-14*RO2*0.70)
  RCONST(1406) = (4.5D-13)
  RCONST(1407) = (KRO2HO2*0.770)
  RCONST(1408) = (KRO2NO*0.082)
  RCONST(1409) = (KRO2NO*0.918)
  RCONST(1410) = (KRO2NO3)
  RCONST(1411) = (8.80D-13*RO2*0.2)
  RCONST(1412) = (8.80D-13*RO2*0.6)
  RCONST(1413) = (8.80D-13*RO2*0.2)
  RCONST(1414) = (2*KNO3AL*2.75)
  RCONST(1415) = (2.00D-18)
  RCONST(1416) = (6.08D-11*0.31)
  RCONST(1417) = (6.08D-11*0.69)
  RCONST(1418) = (j('no2')*0.1*0.5)
  RCONST(1419) = (j('no2')*0.1*0.5)
  RCONST(1420) = (3.8D-12*0.742)
  RCONST(1421) = (3.8D-12*0.258)
  RCONST(1422) = (4.7D-13*EXP(1220/TEMP)*0.06)
  RCONST(1423) = (4.7D-13*EXP(1220/TEMP)*0.8)
  RCONST(1424) = (4.7D-13*EXP(1220/TEMP)*0.14)
  RCONST(1425) = (1.5D-13*EXP(1310/TEMP))
  RCONST(1426) = (KRO2NO*0.105)
  RCONST(1427) = (KRO2NO*0.895)
  RCONST(1428) = (KRO2NO3)
  RCONST(1429) = (2*(KCH3O2*2.4D-14*EXP(1620/TEMP))**0.5*RO2*0.2)
  RCONST(1430) = (2*(KCH3O2*2.4D-14*EXP(1620/TEMP))**0.5*RO2*0.6)
  RCONST(1431) = (2*(KCH3O2*2.4D-14*EXP(1620/TEMP))**0.5*RO2*0.2)
  RCONST(1432) = (1.4D-11*0.103)
  RCONST(1433) = (1.4D-11*0.506)
  RCONST(1434) = (1.4D-11*0.391)
  RCONST(1435) = (4.65D-11*0.200)
  RCONST(1436) = (4.65D-11*0.727)
  RCONST(1437) = (4.65D-11*0.073)
  RCONST(1438) = (KRO2HO2*0.820)
  RCONST(1439) = (KRO2NO*0.889)
  RCONST(1440) = (KRO2NO*0.111)
  RCONST(1441) = (KRO2NO3)
  RCONST(1442) = (8.80D-13*RO2*0.20)
  RCONST(1443) = (8.80D-13*RO2*0.60)
  RCONST(1444) = (8.80D-13*RO2*0.20)
  RCONST(1445) = (KNO3AL*2.75)
  RCONST(1446) = (5.00D-18)
  RCONST(1447) = (7.99D-11*0.31)
  RCONST(1448) = (7.99D-11*0.69)
  RCONST(1449) = (j('no2')*0.1*0.5)
  RCONST(1450) = (j('no2')*0.1*0.5)
  RCONST(1451) = (KRO2HO2*0.859)
  RCONST(1452) = (KRO2NO*0.105)
  RCONST(1453) = (KRO2NO*0.895)
  RCONST(1454) = (KRO2NO3)
  RCONST(1455) = (1.30D-12*0.20*RO2)
  RCONST(1456) = (1.30D-12*0.60*RO2)
  RCONST(1457) = (1.30D-12*0.20*RO2)
  RCONST(1458) = (KRO2HO2*0.859)
  RCONST(1459) = (KRO2NO*0.138)
  RCONST(1460) = (KRO2NO*0.862)
  RCONST(1461) = (KRO2NO3)
  RCONST(1462) = (9.20D-14*RO2*0.70)
  RCONST(1463) = (9.20D-14*RO2*0.30)
  RCONST(1464) = (2*KNO3AL*4.25)
  RCONST(1465) = (2.00D-18)
  RCONST(1466) = (5.99D-11*0.632)
  RCONST(1467) = (5.99D-11*0.368)
  RCONST(1468) = (j('no2')*0.05*0.5)
  RCONST(1469) = (j('no2')*0.05*0.5)
  RCONST(1470) = (3.20D-11*0.51)
  RCONST(1471) = (3.20D-11*0.39)
  RCONST(1472) = (3.20D-11*0.10)
  RCONST(1473) = (8.00D-11*0.07)
  RCONST(1474) = (8.00D-11*0.73)
  RCONST(1475) = (8.00D-11*0.20)
  RCONST(1476) = (KRO2HO2*0.859)
  RCONST(1477) = (KRO2NO*0.105)
  RCONST(1478) = (KRO2NO*0.895)
  RCONST(1479) = (KRO2NO3)
  RCONST(1480) = (1.30D-12*0.20*RO2)
  RCONST(1481) = (1.30D-12*0.60*RO2)
  RCONST(1482) = (1.30D-12*0.20*RO2)
  RCONST(1483) = (KRO2HO2*0.859)
  RCONST(1484) = (KRO2NO*0.138)
  RCONST(1485) = (KRO2NO*0.862)
  RCONST(1486) = (KRO2NO3)
  RCONST(1487) = (8.80D-13*RO2*0.6)
  RCONST(1488) = (8.80D-13*RO2*0.2)
  RCONST(1489) = (8.80D-13*RO2*0.2)
  RCONST(1490) = (KNO3AL*4.25)
  RCONST(1491) = (2.00D-18)
  RCONST(1492) = (8.02D-11*0.26)
  RCONST(1493) = (8.02D-11*0.74)
  RCONST(1494) = (j('no2')*0.028*0.5)
  RCONST(1495) = (j('no2')*0.028*0.5)
  RCONST(1496) = (4.50D-11*0.39)
  RCONST(1497) = (4.50D-11*0.10)
  RCONST(1498) = (4.50D-11*0.51)
  RCONST(1499) = (9.10D-11*0.07)
  RCONST(1500) = (9.10D-11*0.42)
  RCONST(1501) = (9.10D-11*0.51)
  RCONST(1502) = (KRO2HO2*0.820)
  RCONST(1503) = (KRO2NO*0.105)
  RCONST(1504) = (KRO2NO*0.895)
  RCONST(1505) = (KRO2NO3)
  RCONST(1506) = (1.30D-12*0.20*RO2)
  RCONST(1507) = (1.30D-12*0.60*RO2)
  RCONST(1508) = (1.30D-12*0.20*RO2)
  RCONST(1509) = (KRO2HO2*0.859)
  RCONST(1510) = (KRO2NO*0.138)
  RCONST(1511) = (KRO2NO*0.862)
  RCONST(1512) = (KRO2NO3)
  RCONST(1513) = (9.20D-14*RO2*0.70)
  RCONST(1514) = (9.20D-14*RO2*0.30)
  RCONST(1515) = (KNO3AL*4.25)
  RCONST(1516) = (5.00D-18)
  RCONST(1517) = (7.88D-11*0.26)
  RCONST(1518) = (7.88D-11*0.74)
  RCONST(1519) = (j('no2')*0.1*0.5)
  RCONST(1520) = (j('no2')*0.1*0.5)
  RCONST(1521) = (3.48D-11*0.51)
  RCONST(1522) = (3.48D-11*0.39)
  RCONST(1523) = (3.48D-11*0.10)
  RCONST(1524) = (8.00D-11*0.07)
  RCONST(1525) = (8.00D-11*0.73)
  RCONST(1526) = (8.00D-11*0.2)
  RCONST(1527) = (KRO2HO2*0.859)
  RCONST(1528) = (KRO2NO*0.900)
  RCONST(1529) = (KRO2NO*0.100)
  RCONST(1530) = (KRO2NO3)
  RCONST(1531) = (1.30D-12*0.60*RO2)
  RCONST(1532) = (1.30D-12*0.20*RO2)
  RCONST(1533) = (1.30D-12*0.20*RO2)
  RCONST(1534) = (1.25D-11*0.391)
  RCONST(1535) = (1.25D-11*0.103)
  RCONST(1536) = (1.25D-11*0.506)
  RCONST(1537) = (5.10D-11*0.073)
  RCONST(1538) = (5.10D-11*0.200)
  RCONST(1539) = (5.10D-11*0.727)
  RCONST(1540) = (KRO2HO2*0.859)
  RCONST(1541) = (KRO2NO*0.90)
  RCONST(1542) = (KRO2NO*0.10)
  RCONST(1543) = (KRO2NO3)
  RCONST(1544) = (8.80D-13*RO2*0.60)
  RCONST(1545) = (8.80D-13*RO2*0.20)
  RCONST(1546) = (8.80D-13*RO2*0.20)
  RCONST(1547) = (KNO3AL*2.75)
  RCONST(1548) = (5.00D-18)
  RCONST(1549) = (8.10D-11*0.26)
  RCONST(1550) = (8.10D-11*0.76)
  RCONST(1551) = (j('no2')*0.028*0.5)
  RCONST(1552) = (j('no2')*0.028*0.5)
  RCONST(1553) = (KRO2HO2*0.890)
  RCONST(1554) = (KRO2NO*0.393)
  RCONST(1555) = (KRO2NO*0.607)
  RCONST(1556) = (KRO2NO3)
  RCONST(1557) = (2.50D-13*RO2*0.6)
  RCONST(1558) = (2.50D-13*RO2*0.2)
  RCONST(1559) = (2.50D-13*RO2*0.2)
  RCONST(1560) = (1.25D-11*0.506)
  RCONST(1561) = (1.25D-11*0.391)
  RCONST(1562) = (1.25D-11*0.103)
  RCONST(1563) = (5.10D-11*0.073)
  RCONST(1564) = (5.10D-11*0.200)
  RCONST(1565) = (5.10D-11*0.727)
  RCONST(1566) = (KRO2HO2*0.890)
  RCONST(1567) = (KRO2NO*0.90)
  RCONST(1568) = (KRO2NO*0.10)
  RCONST(1569) = (KRO2NO3)
  RCONST(1570) = (8.80D-13*RO2*0.60)
  RCONST(1571) = (8.80D-13*RO2*0.20)
  RCONST(1572) = (8.80D-13*RO2*0.20)
  RCONST(1573) = (KNO3AL*2.75)
  RCONST(1574) = (5.00D-18)
  RCONST(1575) = (8.45D-11*0.74)
  RCONST(1576) = (8.45D-11*0.26)
  RCONST(1577) = (j('no2')*0.028*0.5)
  RCONST(1578) = (j('no2')*0.028*0.5)
  RCONST(1579) = (KRO2HO2*0.890)
  RCONST(1580) = (KRO2NO*0.118)
  RCONST(1581) = (KRO2NO*0.882)
  RCONST(1582) = (KRO2NO3)
  RCONST(1583) = (6.70D-15*RO2*0.7)
  RCONST(1584) = (6.70D-15*RO2*0.3)
  RCONST(1585) = (1.25D-11*0.391)
  RCONST(1586) = (1.25D-11*0.103)
  RCONST(1587) = (1.25D-11*0.506)
  RCONST(1588) = (5.10D-11*0.073)
  RCONST(1589) = (5.10D-11*0.200)
  RCONST(1590) = (5.10D-11*0.727)
  RCONST(1591) = (KRO2HO2*0.890)
  RCONST(1592) = (KRO2NO*0.90)
  RCONST(1593) = (KRO2NO*0.10)
  RCONST(1594) = (KRO2NO3)
  RCONST(1595) = (8.80D-13*RO2*0.60)
  RCONST(1596) = (8.80D-13*RO2*0.20)
  RCONST(1597) = (8.80D-13*RO2*0.20)
  RCONST(1598) = (KNO3AL*4.25)
  RCONST(1599) = (5.00D-18)
  RCONST(1600) = (8.23D-11*0.26)
  RCONST(1601) = (8.23D-11*0.74)
  RCONST(1602) = (j('no2')*0.028*0.5)
  RCONST(1603) = (j('no2')*0.028*0.5)
  RCONST(1604) = (KRO2HO2*0.890)
  RCONST(1605) = (KRO2NO*0.157)
  RCONST(1606) = (KRO2NO*0.843)
  RCONST(1607) = (KRO2NO3)
  RCONST(1608) = (1.30D-12*RO2*0.20)
  RCONST(1609) = (1.30D-12*RO2*0.60)
  RCONST(1610) = (1.30D-12*RO2*0.20)
  RCONST(1611) = (3.20D-11*0.51)
  RCONST(1612) = (3.20D-11*0.39)
  RCONST(1613) = (3.20D-11*0.10)
  RCONST(1614) = (8.20D-11*0.73)
  RCONST(1615) = (8.20D-11*0.07)
  RCONST(1616) = (8.20D-11*0.20)
  RCONST(1617) = (KRO2HO2*0.890)
  RCONST(1618) = (KRO2NO*0.157)
  RCONST(1619) = (KRO2NO*0.843)
  RCONST(1620) = (KRO2NO3)
  RCONST(1621) = (8.80D-13*RO2*0.20)
  RCONST(1622) = (8.80D-13*RO2*0.60)
  RCONST(1623) = (8.80D-13*RO2*0.20)
  RCONST(1624) = (5.00D-18)
  RCONST(1625) = (5.96D-11)
  RCONST(1626) = (j('mek'))
  RCONST(1627) = (j('mvk_mcm_ch2ch'))
  RCONST(1628) = (KRO2HO2*0.890)
  RCONST(1629) = (KRO2NO*0.157)
  RCONST(1630) = (KRO2NO*0.843)
  RCONST(1631) = (KRO2NO3)
  RCONST(1632) = (1.30D-12*RO2*0.20)
  RCONST(1633) = (1.30D-12*RO2*0.60)
  RCONST(1634) = (1.30D-12*RO2*0.20)
  RCONST(1635) = (KRO2HO2*0.890)
  RCONST(1636) = (KRO2NO*0.157)
  RCONST(1637) = (KRO2NO*0.843)
  RCONST(1638) = (KRO2NO3)
  RCONST(1639) = (9.20D-14*RO2*0.30)
  RCONST(1640) = (9.20D-14*RO2*0.70)
  RCONST(1641) = (3.20D-11*0.51)
  RCONST(1642) = (3.20D-11*0.39)
  RCONST(1643) = (3.20D-11*0.10)
  RCONST(1644) = (8.20D-11*0.26)
  RCONST(1645) = (8.20D-11*0.07)
  RCONST(1646) = (8.20D-11*0.67)
  RCONST(1647) = (KNO3AL*4.25)
  RCONST(1648) = (5.00D-18)
  RCONST(1649) = (7.91D-11*0.736)
  RCONST(1650) = (7.91D-11*0.264)
  RCONST(1651) = (j('no2')*0.028*0.5)
  RCONST(1652) = (j('no2')*0.028*0.5)
  RCONST(1653) = (KRO2HO2*0.890)
  RCONST(1654) = (KRO2NO*0.105)
  RCONST(1655) = (KRO2NO*0.895)
  RCONST(1656) = (KRO2NO3)
  RCONST(1657) = (1.30D-12*0.20*RO2)
  RCONST(1658) = (1.30D-12*0.60*RO2)
  RCONST(1659) = (1.30D-12*0.20*RO2)
  RCONST(1660) = (KRO2HO2*0.890)
  RCONST(1661) = (KRO2NO*0.157)
  RCONST(1662) = (KRO2NO*0.843)
  RCONST(1663) = (KRO2NO3)
  RCONST(1664) = (8.80D-13*RO2*0.2)
  RCONST(1665) = (8.80D-13*RO2*0.6)
  RCONST(1666) = (8.80D-13*RO2*0.2)
  RCONST(1667) = (1.30D-11*0.787)
  RCONST(1668) = (1.30D-11*0.213)
  RCONST(1669) = (8.20D-11*0.054)
  RCONST(1670) = (8.20D-11*0.946)
  RCONST(1671) = (KNO3AL*4.25)
  RCONST(1672) = (1.25D-17)
  RCONST(1673) = (1.01D-10*0.79)
  RCONST(1674) = (1.01D-10*0.21)
  RCONST(1675) = (j('no2')*0.1*0.5)
  RCONST(1676) = (j('no2')*0.1*0.5)
  RCONST(1677) = (KRO2HO2*0.890)
  RCONST(1678) = (KRO2NO*0.393)
  RCONST(1679) = (KRO2NO*0.607)
  RCONST(1680) = (KRO2NO3)
  RCONST(1681) = (2.50D-13*RO2*0.6)
  RCONST(1682) = (2.50D-13*RO2*0.2)
  RCONST(1683) = (2.50D-13*RO2*0.2)
  RCONST(1684) = (KRO2HO2*0.890)
  RCONST(1685) = (KRO2NO*0.157)
  RCONST(1686) = (KRO2NO*0.843)
  RCONST(1687) = (KRO2NO3)
  RCONST(1688) = (9.20D-14*RO2*0.70)
  RCONST(1689) = (9.20D-14*RO2*0.30)
  RCONST(1690) = (2*KNO3AL*4.25)
  RCONST(1691) = (2.00D-18)
  RCONST(1692) = (6.32D-11*0.49)
  RCONST(1693) = (6.32D-11*0.51)
  RCONST(1694) = (j('no2')*0.05*0.5)
  RCONST(1695) = (j('no2')*0.05*0.5)
  RCONST(1696) = (3.20D-11*0.51)
  RCONST(1697) = (3.20D-11*0.39)
  RCONST(1698) = (3.20D-11*0.10)
  RCONST(1699) = (8.20D-11*0.07)
  RCONST(1700) = (8.20D-11*0.73)
  RCONST(1701) = (8.20D-11*0.20)
  RCONST(1702) = (KRO2HO2*0.890)
  RCONST(1703) = (KRO2NO*0.157)
  RCONST(1704) = (KRO2NO*0.843)
  RCONST(1705) = (KRO2NO3)
  RCONST(1706) = (8.80D-13*RO2*0.6)
  RCONST(1707) = (8.80D-13*RO2*0.2)
  RCONST(1708) = (8.80D-13*RO2*0.2)
  RCONST(1709) = (KNO3AL*4.25)
  RCONST(1710) = (5.00D-18)
  RCONST(1711) = (8.13D-11*0.26)
  RCONST(1712) = (8.13D-11*0.74)
  RCONST(1713) = (j('no2')*0.028*0.5)
  RCONST(1714) = (j('no2')*0.028*0.5)
  RCONST(1715) = (4.50D-11*0.39)
  RCONST(1716) = (4.50D-11*0.10)
  RCONST(1717) = (4.50D-11*0.51)
  RCONST(1718) = (8.20D-11*0.07)
  RCONST(1719) = (8.20D-11*0.42)
  RCONST(1720) = (8.20D-11*0.51)
  RCONST(1721) = (KRO2HO2*0.890)
  RCONST(1722) = (KRO2NO*0.157)
  RCONST(1723) = (KRO2NO*0.843)
  RCONST(1724) = (KRO2NO3)
  RCONST(1725) = (9.20D-14*RO2*0.7)
  RCONST(1726) = (9.20D-14*RO2*0.3)
  RCONST(1727) = (KNO3AL*4.25)
  RCONST(1728) = (5.00D-18)
  RCONST(1729) = (8.00D-11*0.26)
  RCONST(1730) = (8.00D-11*0.74)
  RCONST(1731) = (j('no2')*0.028*0.5)
  RCONST(1732) = (j('no2')*0.028*0.5)
  RCONST(1733) = (3.48D-11*0.51)
  RCONST(1734) = (3.48D-11*0.39)
  RCONST(1735) = (3.48D-11*0.10)
  RCONST(1736) = (8.20D-11*0.07)
  RCONST(1737) = (8.20D-11*0.73)
  RCONST(1738) = (8.20D-11*0.20)
  RCONST(1739) = (KRO2HO2*0.914)
  RCONST(1740) = (KRO2NO*0.417)
  RCONST(1741) = (KRO2NO*0.583)
  RCONST(1742) = (KRO2NO3)
  RCONST(1743) = (2.50D-13*RO2*0.6)
  RCONST(1744) = (2.50D-13*RO2*0.2)
  RCONST(1745) = (2.50D-13*RO2*0.2)
  RCONST(1746) = (KRO2HO2*0.914)
  RCONST(1747) = (KRO2NO*0.167)
  RCONST(1748) = (KRO2NO*0.833)
  RCONST(1749) = (KRO2NO3)
  RCONST(1750) = (8.80D-13*RO2*0.6)
  RCONST(1751) = (8.80D-13*RO2*0.2)
  RCONST(1752) = (8.80D-13*RO2*0.2)
  RCONST(1753) = (KNO3AL*4.25)
  RCONST(1754) = (1.25D-17)
  RCONST(1755) = (1.02D-10*0.79)
  RCONST(1756) = (1.02D-10*0.21)
  RCONST(1757) = (j('no2')*0.028*0.5)
  RCONST(1758) = (j('no2')*0.028*0.5)
  RCONST(1759) = (1.30D-11*0.213)
  RCONST(1760) = (1.30D-11*0.787)
  RCONST(1761) = (8.20D-11*0.054)
  RCONST(1762) = (8.20D-11*0.946)
  RCONST(1763) = (KRO2HO2*0.932)
  RCONST(1764) = (KRO2NO*0.431)
  RCONST(1765) = (KRO2NO*0.569)
  RCONST(1766) = (KRO2NO3)
  RCONST(1767) = (2.50D-13*RO2*0.6)
  RCONST(1768) = (2.50D-13*RO2*0.2)
  RCONST(1769) = (2.50D-13*RO2*0.2)
  RCONST(1770) = (1.30D-11*0.213)
  RCONST(1771) = (1.30D-11*0.787)
  RCONST(1772) = (8.20D-11*0.946)
  RCONST(1773) = (8.20D-11*0.054)
  RCONST(1774) = (KRO2HO2*0.932)
  RCONST(1775) = (KRO2NO*0.172)
  RCONST(1776) = (KRO2NO*0.828)
  RCONST(1777) = (KRO2NO3)
  RCONST(1778) = (8.80D-13*RO2*0.6)
  RCONST(1779) = (8.80D-13*RO2*0.2)
  RCONST(1780) = (8.80D-13*RO2*0.2)
  RCONST(1781) = (KNO3AL*4.25)
  RCONST(1782) = (1.25D-17)
  RCONST(1783) = (1.05D-10*0.79)
  RCONST(1784) = (1.05D-10*0.21)
  RCONST(1785) = (j('no2')*0.028*0.5)
  RCONST(1786) = (j('no2')*0.028*0.5)
  RCONST(1787) = (KRO2HO2*0.859)
  RCONST(1788) = (KRO2NO)
  RCONST(1789) = (KRO2NO3)
  RCONST(1790) = (2.50D-13*RO2)
  RCONST(1791) = (KDEC*0.20)
  RCONST(1792) = (KDEC*0.36)
  RCONST(1793) = (KDEC*0.20)
  RCONST(1794) = (KDEC*0.24)
  RCONST(1795) = (KRO2HO2*0.859)
  RCONST(1796) = (KRO2NO)
  RCONST(1797) = (KRO2NO3)
  RCONST(1798) = (2.50D-13*RO2)
  RCONST(1799) = (KAPHO2*0.41)
  RCONST(1800) = (KAPHO2*0.44)
  RCONST(1801) = (KAPHO2*0.15)
  RCONST(1802) = (KAPNO)
  RCONST(1803) = (KFPAN)
  RCONST(1804) = (KRO2NO3*1.74)
  RCONST(1805) = (1.00D-11*RO2*0.7)
  RCONST(1806) = (1.00D-11*RO2*0.3)
  RCONST(1807) = (KRO2HO2*0.770)
  RCONST(1808) = (KRO2NO)
  RCONST(1809) = (KRO2NO3)
  RCONST(1810) = (2.50D-13*RO2)
  RCONST(1811) = (KRO2HO2*0.625)
  RCONST(1812) = (KRO2NO)
  RCONST(1813) = (KRO2NO3)
  RCONST(1814) = (2.50D-13*0.6*RO2)
  RCONST(1815) = (2.50D-13*0.2*RO2)
  RCONST(1816) = (2.50D-13*0.2*RO2)
  RCONST(1817) = (KRO2HO2*0.625)
  RCONST(1818) = (KRO2NO*0.033)
  RCONST(1819) = (KRO2NO*0.967)
  RCONST(1820) = (KRO2NO3)
  RCONST(1821) = (1.30D-12*0.2*RO2)
  RCONST(1822) = (1.30D-12*0.6*RO2)
  RCONST(1823) = (1.30D-12*0.2*RO2)
  RCONST(1824) = (KDEC*0.24)
  RCONST(1825) = (KDEC*0.68)
  RCONST(1826) = (KDEC*0.08)
  RCONST(1827) = (KDEC*0.24)
  RCONST(1828) = (KDEC*0.34)
  RCONST(1829) = (KDEC*0.08)
  RCONST(1830) = (KDEC*0.34)
  RCONST(1831) = (KRO2HO2*0.625)
  RCONST(1832) = (KRO2NO*0.053)
  RCONST(1833) = (KRO2NO*0.947)
  RCONST(1834) = (KRO2NO3)
  RCONST(1835) = (2.00D-12*0.8*RO2)
  RCONST(1836) = (2.00D-12*0.1*RO2)
  RCONST(1837) = (2.00D-12*0.1*RO2)
  RCONST(1838) = (KRO2HO2*0.625)
  RCONST(1839) = (KRO2NO*0.071)
  RCONST(1840) = (KRO2NO*0.929)
  RCONST(1841) = (KRO2NO3)
  RCONST(1842) = (2.90D-12*0.8*RO2)
  RCONST(1843) = (2.90D-12*0.1*RO2)
  RCONST(1844) = (2.90D-12*0.1*RO2)
  RCONST(1845) = (KRO2HO2*0.625)
  RCONST(1846) = (KRO2NO*0.947)
  RCONST(1847) = (KRO2NO*0.053)
  RCONST(1848) = (KRO2NO3)
  RCONST(1849) = (2.65D-12*0.1*RO2)
  RCONST(1850) = (2.65D-12*0.8*RO2)
  RCONST(1851) = (2.65D-12*0.1*RO2)
  RCONST(1852) = (KRO2HO2*0.706)
  RCONST(1853) = (KRO2NO*0.052)
  RCONST(1854) = (KRO2NO*0.948)
  RCONST(1855) = (KRO2NO3)
  RCONST(1856) = (1.30D-12*0.2*RO2)
  RCONST(1857) = (1.30D-12*0.2*RO2)
  RCONST(1858) = (1.30D-12*0.6*RO2)
  RCONST(1859) = (KDEC*0.22)
  RCONST(1860) = (KDEC*0.51)
  RCONST(1861) = (KDEC*0.27)
  RCONST(1862) = (j('mvk_mcm_co'))
  RCONST(1863) = (j('mvk_mcm_ch2ch'))
  RCONST(1864) = (8.5D-16*EXP(-1520/TEMP)*0.5)
  RCONST(1865) = (8.5D-16*EXP(-1520/TEMP)*0.5)
  RCONST(1866) = (2.6D-12*EXP(610/TEMP)*0.3)
  RCONST(1867) = (2.6D-12*EXP(610/TEMP)*0.7)
  RCONST(1868) = (KDEC*0.255)
  RCONST(1869) = (KDEC*0.255)
  RCONST(1870) = (KDEC*0.22)
  RCONST(1871) = (KDEC*0.27)
  RCONST(1872) = (KDEC*0.255)
  RCONST(1873) = (KDEC*0.255)
  RCONST(1874) = (KDEC*0.22)
  RCONST(1875) = (KDEC*0.27)
  RCONST(1876) = (5.50D-13*O2)
  RCONST(1877) = (6.50D-13*O2)
  RCONST(1878) = (5.50D-13*O2)
  RCONST(1879) = (6.50D-13*O2)
  RCONST(1880) = (KRO2HO2*0.706)
  RCONST(1881) = (KRO2NO*0.070)
  RCONST(1882) = (KRO2NO*0.930)
  RCONST(1883) = (KRO2NO3)
  RCONST(1884) = (2.65D-12*RO2*0.1)
  RCONST(1885) = (2.65D-12*RO2*0.8)
  RCONST(1886) = (2.65D-12*RO2*0.1)
  RCONST(1887) = (3.30D-13)
  RCONST(1888) = (1.60D-17*0.33)
  RCONST(1889) = (1.60D-17*0.67)
  RCONST(1890) = (7.30D-11*0.712)
  RCONST(1891) = (7.30D-11*0.288)
  RCONST(1892) = (j('n_c3h7cho_hco'))
  RCONST(1893) = (1.20D-14)
  RCONST(1894) = (1.00D-17*0.43)
  RCONST(1895) = (1.00D-17*0.57)
  RCONST(1896) = (2.71D-11)
  RCONST(1897) = (j('mek'))
  RCONST(1898) = (1.00D-13*O2)
  RCONST(1899) = (6.50D-13*O2)
  RCONST(1900) = (1.00D-13*O2)
  RCONST(1901) = (6.50D-13*O2)
  RCONST(1902) = (KRO2HO2*0.387*0.6)
  RCONST(1903) = (KRO2HO2*0.387*0.4)
  RCONST(1904) = (KRO2NO*0.009)
  RCONST(1905) = (KRO2NO*0.991)
  RCONST(1906) = (KRO2NO3)
  RCONST(1907) = (2*(K298CH3O2*2.1D-12)**0.5*RO2*0.6)
  RCONST(1908) = (2*(K298CH3O2*2.1D-12)**0.5*RO2*0.2)
  RCONST(1909) = (2*(K298CH3O2*2.1D-12)**0.5*RO2*0.2)
  RCONST(1910) = (KRO2HO2*0.625*0.6)
  RCONST(1911) = (KRO2HO2*0.625*0.4)
  RCONST(1912) = (KRO2NO*0.083)
  RCONST(1913) = (KRO2NO*0.917)
  RCONST(1914) = (KRO2NO3)
  RCONST(1915) = (8.80D-13*0.6*RO2)
  RCONST(1916) = (8.80D-13*0.2*RO2)
  RCONST(1917) = (8.80D-13*0.2*RO2)
  RCONST(1918) = (KRO2HO2*0.625)
  RCONST(1919) = (KRO2NO*0.033)
  RCONST(1920) = (KRO2NO*0.967)
  RCONST(1921) = (KRO2NO3)
  RCONST(1922) = (2.00D-12*0.2*RO2)
  RCONST(1923) = (2.00D-12*0.2*RO2)
  RCONST(1924) = (2.00D-12*0.6*RO2)
  RCONST(1925) = (1.36D-13*EXP(1250/TEMP)*0.15)
  RCONST(1926) = (1.36D-13*EXP(1250/TEMP)*0.85)
  RCONST(1927) = (KRO2NO)
  RCONST(1928) = (KRO2NO3)
  RCONST(1929) = (2*(K298CH3O2*8.0D-12)**0.5*RO2*0.2)
  RCONST(1930) = (2*(K298CH3O2*8.0D-12)**0.5*RO2*0.6)
  RCONST(1931) = (2*(K298CH3O2*8.0D-12)**0.5*RO2*0.2)
  RCONST(1932) = (KRO2HO2*0.625)
  RCONST(1933) = (KRO2NO*0.033)
  RCONST(1934) = (KRO2NO*0.967)
  RCONST(1935) = (KRO2NO3)
  RCONST(1936) = (2.00D-12*0.2*RO2)
  RCONST(1937) = (2.00D-12*0.6*RO2)
  RCONST(1938) = (2.00D-12*0.2*RO2)
  RCONST(1939) = (KRO2HO2*0.625)
  RCONST(1940) = (KRO2NO)
  RCONST(1941) = (KRO2NO3)
  RCONST(1942) = (8.80D-13*0.2*RO2)
  RCONST(1943) = (8.80D-13*0.2*RO2)
  RCONST(1944) = (8.80D-13*0.6*RO2)
  RCONST(1945) = (KRO2HO2*0.625)
  RCONST(1946) = (KRO2NO)
  RCONST(1947) = (KRO2NO3)
  RCONST(1948) = (2.00D-12*0.2*RO2)
  RCONST(1949) = (2.00D-12*0.6*RO2)
  RCONST(1950) = (2.00D-12*0.2*RO2)
  RCONST(1951) = (KRO2HO2*0.706)
  RCONST(1952) = (KRO2NO*0.871)
  RCONST(1953) = (KRO2NO*0.129)
  RCONST(1954) = (KRO2NO3)
  RCONST(1955) = (8.80D-13*0.2*RO2)
  RCONST(1956) = (8.80D-13*0.6*RO2)
  RCONST(1957) = (8.80D-13*0.2*RO2)
  RCONST(1958) = (KRO2HO2*0.706)
  RCONST(1959) = (KRO2NO)
  RCONST(1960) = (KRO2NO3)
  RCONST(1961) = (8.80D-13*0.2*RO2)
  RCONST(1962) = (8.80D-13*0.6*RO2)
  RCONST(1963) = (8.80D-13*0.2*RO2)
  RCONST(1964) = (KRO2HO2*0.706)
  RCONST(1965) = (KRO2NO)
  RCONST(1966) = (KRO2NO3)
  RCONST(1967) = (8.80D-13*0.2*RO2)
  RCONST(1968) = (8.80D-13*0.6*RO2)
  RCONST(1969) = (8.80D-13*0.2*RO2)
  RCONST(1970) = (KRO2HO2*0.706)
  RCONST(1971) = (KRO2NO*0.052)
  RCONST(1972) = (KRO2NO*0.948)
  RCONST(1973) = (KRO2NO3)
  RCONST(1974) = (2.00D-12*0.2*RO2)
  RCONST(1975) = (2.00D-12*0.6*RO2)
  RCONST(1976) = (2.00D-12*0.2*RO2)
  RCONST(1977) = (KRO2HO2*0.706)
  RCONST(1978) = (KRO2NO)
  RCONST(1979) = (KRO2NO3)
  RCONST(1980) = (9.20D-14*0.7*RO2)
  RCONST(1981) = (9.20D-14*0.3*RO2)
  RCONST(1982) = (KRO2HO2*0.706)
  RCONST(1983) = (KRO2NO*0.052)
  RCONST(1984) = (KRO2NO*0.948)
  RCONST(1985) = (KRO2NO3)
  RCONST(1986) = (1.30D-12*0.2*RO2)
  RCONST(1987) = (1.30D-12*0.6*RO2)
  RCONST(1988) = (1.30D-12*0.2*RO2)
  RCONST(1989) = (KRO2HO2*0.770)
  RCONST(1990) = (KRO2NO*0.195)
  RCONST(1991) = (KRO2NO*0.805)
  RCONST(1992) = (KRO2NO3)
  RCONST(1993) = (8.80D-13*0.2*RO2)
  RCONST(1994) = (8.80D-13*0.2*RO2)
  RCONST(1995) = (8.80D-13*0.6*RO2)
  RCONST(1996) = (KRO2HO2*0.770)
  RCONST(1997) = (KRO2NO*0.195)
  RCONST(1998) = (KRO2NO*0.805)
  RCONST(1999) = (KRO2NO3)
  RCONST(2000) = (2.50D-13*0.2*RO2)
  RCONST(2001) = (2.50D-13*0.6*RO2)
  RCONST(2002) = (2.50D-13*0.2*RO2)
  RCONST(2003) = (KRO2HO2*0.770)
  RCONST(2004) = (KRO2NO)
  RCONST(2005) = (KRO2NO3)
  RCONST(2006) = (8.80D-13*0.2*RO2)
  RCONST(2007) = (8.80D-13*0.2*RO2)
  RCONST(2008) = (8.80D-13*0.6*RO2)
  RCONST(2009) = (KRO2HO2*0.770)
  RCONST(2010) = (KRO2NO*0.195)
  RCONST(2011) = (KRO2NO*0.805)
  RCONST(2012) = (KRO2NO3)
  RCONST(2013) = (2.50D-13*0.2*RO2)
  RCONST(2014) = (2.50D-13*0.6*RO2)
  RCONST(2015) = (2.50D-13*0.2*RO2)
  RCONST(2016) = (KRO2HO2*0.770)
  RCONST(2017) = (KRO2NO)
  RCONST(2018) = (KRO2NO3)
  RCONST(2019) = (2.50D-13*0.2*RO2)
  RCONST(2020) = (2.50D-13*0.2*RO2)
  RCONST(2021) = (2.50D-13*0.6*RO2)
  RCONST(2022) = (KRO2HO2*0.770)
  RCONST(2023) = (KRO2NO)
  RCONST(2024) = (KRO2NO3)
  RCONST(2025) = (2.50D-13*0.2*RO2)
  RCONST(2026) = (2.50D-13*0.6*RO2)
  RCONST(2027) = (2.50D-13*0.2*RO2)
  RCONST(2028) = (KRO2HO2*0.770)
  RCONST(2029) = (KRO2NO*0.078)
  RCONST(2030) = (KRO2NO*0.922)
  RCONST(2031) = (KRO2NO3)
  RCONST(2032) = (2.50D-13*0.2*RO2)
  RCONST(2033) = (2.50D-13*0.6*RO2)
  RCONST(2034) = (2.50D-13*0.2*RO2)
  RCONST(2035) = (KRO2HO2*0.770)
  RCONST(2036) = (KRO2NO*0.058)
  RCONST(2037) = (KRO2NO*0.942)
  RCONST(2038) = (KRO2NO3)
  RCONST(2039) = (6.70D-15*0.7*RO2)
  RCONST(2040) = (6.70D-15*0.3*RO2)
  RCONST(2041) = (KRO2HO2*0.770)
  RCONST(2042) = (KRO2NO)
  RCONST(2043) = (KRO2NO3)
  RCONST(2044) = (8.80D-13*0.2*RO2)
  RCONST(2045) = (8.80D-13*0.6*RO2)
  RCONST(2046) = (8.80D-13*0.2*RO2)
  RCONST(2047) = (KRO2HO2*0.770)
  RCONST(2048) = (KRO2NO*0.078)
  RCONST(2049) = (KRO2NO*0.922)
  RCONST(2050) = (KRO2NO3)
  RCONST(2051) = (1.30D-12*0.2*RO2)
  RCONST(2052) = (1.30D-12*0.6*RO2)
  RCONST(2053) = (1.30D-12*0.2*RO2)
  RCONST(2054) = (KRO2HO2*0.770)
  RCONST(2055) = (KRO2NO*0.068)
  RCONST(2056) = (KRO2NO*0.932)
  RCONST(2057) = (KRO2NO3)
  RCONST(2058) = (2.50D-13*0.2*RO2)
  RCONST(2059) = (2.50D-13*0.6*RO2)
  RCONST(2060) = (2.50D-13*0.2*RO2)
  RCONST(2061) = (KRO2HO2*0.914)
  RCONST(2062) = (KRO2NO)
  RCONST(2063) = (KRO2NO3)
  RCONST(2064) = (6.70D-15*0.1*RO2)
  RCONST(2065) = (6.70D-15*0.9*RO2)
  RCONST(2066) = (KRO2HO2*0.914)
  RCONST(2067) = (KRO2NO)
  RCONST(2068) = (KRO2NO3)
  RCONST(2069) = (2.50D-13*0.1*RO2)
  RCONST(2070) = (2.50D-13*0.8*RO2)
  RCONST(2071) = (2.50D-13*0.1*RO2)
  RCONST(2072) = (KDEC*0.55)
  RCONST(2073) = (KDEC*0.45)
  RCONST(2074) = (KDEC*0.50)
  RCONST(2075) = (KDEC*0.50)
  RCONST(2076) = (KRO2HO2*0.914)
  RCONST(2077) = (KRO2NO*0.230)
  RCONST(2078) = (KRO2NO*0.770)
  RCONST(2079) = (KRO2NO3)
  RCONST(2080) = (9.20D-14*RO2*0.7)
  RCONST(2081) = (9.20D-14*RO2*0.3)
  RCONST(2082) = (KRO2HO2*0.914)
  RCONST(2083) = (KRO2NO*0.230)
  RCONST(2084) = (KRO2NO*0.770)
  RCONST(2085) = (KRO2NO3)
  RCONST(2086) = (8.80D-13*RO2*0.2)
  RCONST(2087) = (8.80D-13*RO2*0.6)
  RCONST(2088) = (8.80D-13*RO2*0.2)
  RCONST(2089) = (KRO2HO2*0.914)
  RCONST(2090) = (KRO2NO*0.125)
  RCONST(2091) = (KRO2NO*0.875)
  RCONST(2092) = (KRO2NO3)
  RCONST(2093) = (6.70D-15*RO2*0.7)
  RCONST(2094) = (6.70D-15*RO2*0.3)
  RCONST(2095) = (KRO2HO2*0.914)
  RCONST(2096) = (KRO2NO)
  RCONST(2097) = (KRO2NO3)
  RCONST(2098) = (9.20D-14*RO2*0.3)
  RCONST(2099) = (9.20D-14*RO2*0.7)
  RCONST(2100) = (KRO2HO2*0.914)
  RCONST(2101) = (KRO2NO)
  RCONST(2102) = (KRO2NO3)
  RCONST(2103) = (2.00D-12*RO2*0.2)
  RCONST(2104) = (2.00D-12*RO2*0.6)
  RCONST(2105) = (2.00D-12*RO2*0.6)
  RCONST(2106) = (1.55D-11*0.535)
  RCONST(2107) = (1.55D-11*0.199)
  RCONST(2108) = (1.55D-11*0.130)
  RCONST(2109) = (1.55D-11*0.136)
  RCONST(2110) = (KDEC*0.370)
  RCONST(2111) = (KDEC*0.500)
  RCONST(2112) = (KDEC*0.130)
  RCONST(2113) = (KDEC*0.330)
  RCONST(2114) = (KDEC*0.500)
  RCONST(2115) = (KDEC*0.170)
  RCONST(2116) = (KRO2HO2*0.914)
  RCONST(2117) = (KRO2NO*0.240)
  RCONST(2118) = (KRO2NO*0.760)
  RCONST(2119) = (KRO2NO3)
  RCONST(2120) = (9.20D-14*RO2*0.7)
  RCONST(2121) = (9.20D-14*RO2*0.3)
  RCONST(2122) = (KRO2HO2*0.914)
  RCONST(2123) = (KRO2NO*0.240)
  RCONST(2124) = (KRO2NO*0.760)
  RCONST(2125) = (KRO2NO3)
  RCONST(2126) = (2.00D-12*RO2*0.2)
  RCONST(2127) = (2.00D-12*RO2*0.6)
  RCONST(2128) = (2.00D-12*RO2*0.2)
  RCONST(2129) = (KRO2HO2*0.914)
  RCONST(2130) = (KRO2NO*0.125)
  RCONST(2131) = (KRO2NO*0.875)
  RCONST(2132) = (KRO2NO3)
  RCONST(2133) = (6.70D-15*RO2*0.7)
  RCONST(2134) = (6.70D-15*RO2*0.3)
  RCONST(2135) = (KRO2HO2*0.914)
  RCONST(2136) = (KRO2NO)
  RCONST(2137) = (KRO2NO3)
  RCONST(2138) = (9.20D-14*RO2*0.3)
  RCONST(2139) = (9.20D-14*RO2*0.7)
  RCONST(2140) = (KDEC*0.5)
  RCONST(2141) = (KDEC*0.5)
  RCONST(2142) = (KDEC*0.5)
  RCONST(2143) = (KDEC*0.5)
  RCONST(2144) = (KRO2HO2*0.914)
  RCONST(2145) = (KRO2NO*0.228)
  RCONST(2146) = (KRO2NO*0.772)
  RCONST(2147) = (KRO2NO3)
  RCONST(2148) = (9.20D-14*RO2*0.7)
  RCONST(2149) = (9.20D-14*RO2*0.3)
  RCONST(2150) = (KRO2HO2*0.914)
  RCONST(2151) = (KRO2NO*0.228)
  RCONST(2152) = (KRO2NO*0.772)
  RCONST(2153) = (KRO2NO3)
  RCONST(2154) = (8.80D-13*RO2*0.2)
  RCONST(2155) = (8.80D-13*RO2*0.2)
  RCONST(2156) = (8.80D-13*RO2*0.6)
  RCONST(2157) = (KRO2HO2*0.914)
  RCONST(2158) = (KRO2NO*0.228)
  RCONST(2159) = (KRO2NO*0.772)
  RCONST(2160) = (KRO2NO3)
  RCONST(2161) = (9.20D-14*RO2*0.7)
  RCONST(2162) = (9.20D-14*RO2*0.3)
  RCONST(2163) = (KRO2HO2*0.975)
  RCONST(2164) = (KRO2NO)
  RCONST(2165) = (KRO2NO3)
  RCONST(2166) = (9.20D-14*RO2*0.3)
  RCONST(2167) = (9.20D-14*RO2*0.7)
  RCONST(2168) = (1.20D-15)
  RCONST(2169) = (1.00D-14)
  RCONST(2170) = (1.00D-15)
  RCONST(2171) = (7.00D-14)
  RCONST(2172) = (2.00D-16*H2O)
  RCONST(2173) = (8.00D+01)
  RCONST(2174) = (1.20D-15)
  RCONST(2175) = (1.00D-14)
  RCONST(2176) = (1.00D-15)
  RCONST(2177) = (7.00D-14)
  RCONST(2178) = (1.20D+02)
  RCONST(2179) = (2.00D-16*H2O)
  RCONST(2180) = (KDEC*0.13)
  RCONST(2181) = (KDEC*0.67)
  RCONST(2182) = (KDEC*0.15)
  RCONST(2183) = (KDEC*0.05)
  RCONST(2184) = (KDEC*0.66)
  RCONST(2185) = (KDEC*0.17)
  RCONST(2186) = (KDEC*0.17)
  RCONST(2187) = (KRO2HO2*0.975)
  RCONST(2188) = (KRO2NO*0.247)
  RCONST(2189) = (KRO2NO*0.753)
  RCONST(2190) = (KRO2NO3)
  RCONST(2191) = (9.20D-14*RO2*0.7)
  RCONST(2192) = (9.20D-14*RO2*0.3)
  RCONST(2193) = (KRO2HO2*0.975)
  RCONST(2194) = (KRO2NO*0.247)
  RCONST(2195) = (KRO2NO*0.753)
  RCONST(2196) = (KRO2NO3)
  RCONST(2197) = (8.80D-13*RO2*0.2)
  RCONST(2198) = (8.80D-13*RO2*0.2)
  RCONST(2199) = (8.80D-13*RO2*0.6)
  RCONST(2200) = (KRO2HO2*0.975)
  RCONST(2201) = (KRO2NO*0.247)
  RCONST(2202) = (KRO2NO*0.753)
  RCONST(2203) = (KRO2NO3)
  RCONST(2204) = (9.20D-14*RO2*0.7)
  RCONST(2205) = (9.20D-14*RO2*0.3)
  RCONST(2206) = (1.90D-12*EXP(190/TEMP))
  RCONST(2207) = (1.38D-11)
  RCONST(2208) = (j('ch3o2h'))
  RCONST(2209) = (8.40D-13)
  RCONST(2210) = (9.50D+13*EXP(-5988/TEMP))
  RCONST(2211) = (KROPRIM*O2)
  RCONST(2212) = (j('ch3o2h'))
  RCONST(2213) = (1.90D-12*EXP(190/TEMP))
  RCONST(2214) = (1.52D-11)
  RCONST(2215) = (j('n_c3h7ono2'))
  RCONST(2216) = (4.44D-12)
  RCONST(2217) = (KROPRIM*O2)
  RCONST(2218) = (j('n_c3h7cho_hco'))
  RCONST(2219) = (KNO3AL*2.4)
  RCONST(2220) = (3.06D-11)
  RCONST(2221) = (9.73D-12)
  RCONST(2222) = (2.44D-11)
  RCONST(2223) = (1.90D-12*EXP(190/TEMP))
  RCONST(2224) = (j('ch3o2h'))
  RCONST(2225) = (2.00D+14*EXP(-6410/TEMP))
  RCONST(2226) = (9.16D-13)
  RCONST(2227) = (1.83D-11)
  RCONST(2228) = (1.90D-12*EXP(190/TEMP))
  RCONST(2229) = (j('ch3o2h'))
  RCONST(2230) = (2.00D+14*EXP(-5505/TEMP))
  RCONST(2231) = (1.71D-12)
  RCONST(2232) = (3.01D-11)
  RCONST(2233) = (1.90D-12*EXP(190/TEMP))
  RCONST(2234) = (j('ch3o2h'))
  RCONST(2235) = (1.27D-12)
  RCONST(2236) = (2.00D+14*EXP(-6354/TEMP))
  RCONST(2237) = (3.44D-12)
  RCONST(2238) = (j('mek'))
  RCONST(2239) = (1.59D-11)
  RCONST(2240) = (2.58D-11)
  RCONST(2241) = (1.90D-12*EXP(190/TEMP))
  RCONST(2242) = (j('ch3o2h'))
  RCONST(2243) = (4.51D-12)
  RCONST(2244) = (j('1_c4h9ono2'))
  RCONST(2245) = (2.70D+14*EXP(-7398/TEMP))
  RCONST(2246) = (KROSEC*O2)
  RCONST(2247) = (1.42D-11)
  RCONST(2248) = (1.35D-11)
  RCONST(2249) = (j('mek'))
  RCONST(2250) = (2.89D-11)
  RCONST(2251) = (1.90D-12*EXP(190/TEMP))
  RCONST(2252) = (j('ch3o2h'))
  RCONST(2253) = (2.00D+14*EXP(-4714/TEMP))
  RCONST(2254) = (1.79D-12)
  RCONST(2255) = (5.86D-12)
  RCONST(2256) = (j('mek'))
  RCONST(2257) = (1.73D-11)
  RCONST(2258) = (8.10D-12)
  RCONST(2259) = (j('ch3o2h'))
  RCONST(2260) = (8.48D-13)
  RCONST(2261) = (2.00D+14*EXP(-5902/TEMP))
  RCONST(2262) = (4.64D-12)
  RCONST(2263) = (1.69D-11)
  RCONST(2264) = (1.90D-12*EXP(190/TEMP))
  RCONST(2265) = (j('ch3o2h'))
  RCONST(2266) = (4.85D-12)
  RCONST(2267) = (j('n_c3h7ono2'))
  RCONST(2268) = (KROPRIM*O2)
  RCONST(2269) = (j('i_c3h7cho'))
  RCONST(2270) = (KNO3AL*4.0)
  RCONST(2271) = (3.60D-11)
  RCONST(2272) = (1.14D-11)
  RCONST(2273) = (9.98D-12)
  RCONST(2274) = (1.90D-12*EXP(190/TEMP))
  RCONST(2275) = (j('ch3o2h'))
  RCONST(2276) = (5.21D-13)
  RCONST(2277) = (2.00D+14*EXP(-4909/TEMP))
  RCONST(2278) = (j('ch3o2h'))
  RCONST(2279) = (2.28D-11)
  RCONST(2280) = (1.90D-12*EXP(190/TEMP))
  RCONST(2281) = (j('n_c3h7ono2'))
  RCONST(2282) = (1.20D-11)
  RCONST(2283) = (2.03D+11*EXP(-3430/TEMP))
  RCONST(2284) = (1.61D-11)
  RCONST(2285) = (j('n_c3h7cho_hco'))
  RCONST(2286) = (KNO3AL*5.5)
  RCONST(2287) = (5.56D-11*0.611)
  RCONST(2288) = (5.56D-11*0.389)
  RCONST(2289) = (3.19D-11)
  RCONST(2290) = (1.90D-12*EXP(190/TEMP))
  RCONST(2291) = (j('ch3o2h'))
  RCONST(2292) = (3.25D-12)
  RCONST(2293) = (2.00D+14*EXP(-4714/TEMP))
  RCONST(2294) = (2.14D-11)
  RCONST(2295) = (1.00D-11)
  RCONST(2296) = (j('mek'))
  RCONST(2297) = (KAPHO2*0.15)
  RCONST(2298) = (KAPHO2*0.41)
  RCONST(2299) = (KAPHO2*0.44)
  RCONST(2300) = (KAPNO)
  RCONST(2301) = (KFPAN)
  RCONST(2302) = (KRO2NO3*1.74)
  RCONST(2303) = (1.00D-11*0.3*RO2)
  RCONST(2304) = (1.00D-11*0.7*RO2)
  RCONST(2305) = (j('ch3o2h'))
  RCONST(2306) = (3.11D-11)
  RCONST(2307) = (j('1_c4h9ono2'))
  RCONST(2308) = (4.93D-12)
  RCONST(2309) = (KROSEC*O2)
  RCONST(2310) = (1.59D-11)
  RCONST(2311) = (j('mek'))
  RCONST(2312) = (1.51D-11)
  RCONST(2313) = (9.24D-12)
  RCONST(2314) = (j('ch3o2h'))
  RCONST(2315) = (1.18D-12)
  RCONST(2316) = (2.00D+14*EXP(-5902/TEMP))
  RCONST(2317) = (5.78D-12)
  RCONST(2318) = (KAPHO2*0.15)
  RCONST(2319) = (KAPHO2*0.41)
  RCONST(2320) = (KAPHO2*0.44)
  RCONST(2321) = (KAPNO)
  RCONST(2322) = (KFPAN)
  RCONST(2323) = (KRO2NO3*1.74)
  RCONST(2324) = (1.00D-11*0.3*RO2)
  RCONST(2325) = (1.00D-11*0.7*RO2)
  RCONST(2326) = (KRO2HO2*0.706)
  RCONST(2327) = (KRO2NO*0.039)
  RCONST(2328) = (KRO2NO*0.961)
  RCONST(2329) = (KRO2NO3)
  RCONST(2330) = (6.70D-15*0.7*RO2)
  RCONST(2331) = (6.70D-15*0.3*RO2)
  RCONST(2332) = (j('ch3o2h'))
  RCONST(2333) = (9.51D-12)
  RCONST(2334) = (j('2_c4h9ono2'))
  RCONST(2335) = (4.45D-12)
  RCONST(2336) = (2.70D+14*EXP(-6542/TEMP))
  RCONST(2337) = (5.91D-12)
  RCONST(2338) = (1.90D-12*EXP(190/TEMP))
  RCONST(2339) = (3.15D-11)
  RCONST(2340) = (j('ch3o2h'))
  RCONST(2341) = (1.63D-12)
  RCONST(2342) = (KDEC)
  RCONST(2343) = (1.73D-11)
  RCONST(2344) = (5.11D-12)
  RCONST(2345) = (j('mek'))
  RCONST(2346) = (j('ch3o2h'))
  RCONST(2347) = (1.15D-11)
  RCONST(2348) = (1.90D-12*EXP(190/TEMP))
  RCONST(2349) = (j('n_c3h7ono2'))
  RCONST(2350) = (7.50D-13)
  RCONST(2351) = (6.10D+11*EXP(-4240/TEMP))
  RCONST(2352) = (KROPRIM*O2)
  RCONST(2353) = (j('n_c3h7cho_hco'))
  RCONST(2354) = (KNO3AL*8.5)
  RCONST(2355) = (2.21D-11)
  RCONST(2356) = (1.90D-12*EXP(190/TEMP))
  RCONST(2357) = (2.07D-11)
  RCONST(2358) = (j('ch3o2h'))
  RCONST(2359) = (5.97D-13)
  RCONST(2360) = (2.70D+14*EXP(-6643/TEMP))
  RCONST(2361) = (KROSEC*O2)
  RCONST(2362) = (8.63D-12)
  RCONST(2363) = (1.38D-12)
  RCONST(2364) = (1.90D-12*EXP(190/TEMP))
  RCONST(2365) = (1.13D-11)
  RCONST(2366) = (j('ch3o2h'))
  RCONST(2367) = (1.67D-12)
  RCONST(2368) = (2.00D+14*EXP(-4909/TEMP))
  RCONST(2369) = (KNO3AL*8.5)
  RCONST(2370) = (2.52D-11)
  RCONST(2371) = (j('i_c3h7cho'))
  RCONST(2372) = (j('ch3o2h'))
  RCONST(2373) = (1.90D-12*EXP(190/TEMP))
  RCONST(2374) = (2.14D-11)
  RCONST(2375) = (j('n_c3h7ono2'))
  RCONST(2376) = (9.35D-12)
  RCONST(2377) = (2.03D+11*EXP(-4240/TEMP))
  RCONST(2378) = (KROPRIM*O2)
  RCONST(2379) = (j('i_c3h7cho'))
  RCONST(2380) = (KNO3AL*8.5)
  RCONST(2381) = (4.99D-11*0.561)
  RCONST(2382) = (4.99D-11*0.439)
  RCONST(2383) = (1.90D-12*EXP(190/TEMP))
  RCONST(2384) = (8.85D-12)
  RCONST(2385) = (j('ch3o2h'))
  RCONST(2386) = (1.72D-12)
  RCONST(2387) = (KDEC)
  RCONST(2388) = (1.90D-12*EXP(190/TEMP))
  RCONST(2389) = (4.07D-11)
  RCONST(2390) = (j('ch3o2h'))
  RCONST(2391) = (KDEC)
  RCONST(2392) = (6.08D-12)
  RCONST(2393) = (2.65D-11)
  RCONST(2394) = (1.76D-11)
  RCONST(2395) = (j('mek'))
  RCONST(2396) = (1.56D-11)
  RCONST(2397) = (1.90D-12*EXP(190/TEMP))
  RCONST(2398) = (j('mek'))
  RCONST(2399) = (j('ch3o2h'))
  RCONST(2400) = (KDEC)
  RCONST(2401) = (1.30D-12)
  RCONST(2402) = (j('biacet'))
  RCONST(2403) = (6.98D-12)
  RCONST(2404) = (j('mek'))
  RCONST(2405) = (1.08D-11)
  RCONST(2406) = (1.90D-12*EXP(190/TEMP))
  RCONST(2407) = (j('ch3o2h')+j('mek'))
  RCONST(2408) = (KDEC)
  RCONST(2409) = (1.18D-12)
  RCONST(2410) = (j('mek'))
  RCONST(2411) = (5.43D-12)
  RCONST(2412) = (j('i_c3h7cho'))
  RCONST(2413) = (2.43D-11)
  RCONST(2414) = (1.31D-11)
  RCONST(2415) = (j('ch3o2h'))
  RCONST(2416) = (j('mek'))
  RCONST(2417) = (KDEC)
  RCONST(2418) = (3.44D-12)
  RCONST(2419) = (j('mek'))
  RCONST(2420) = (KNO3AL*8.5)
  RCONST(2421) = (1.34D-11)
  RCONST(2422) = (j('ch3cocho'))
  RCONST(2423) = (8.00D-13)
  RCONST(2424) = (3.70D-12)
  RCONST(2425) = (j('ch3o2h'))
  RCONST(2426) = (3D-14)
  RCONST(2427) = (KBPAN)
  RCONST(2428) = (KAPHO2*0.44)
  RCONST(2429) = (KAPHO2*0.15)
  RCONST(2430) = (KAPHO2*0.41)
  RCONST(2431) = (KAPNO)
  RCONST(2432) = (KFPAN)
  RCONST(2433) = (KRO2NO3*1.74)
  RCONST(2434) = (1.00D-11*0.7*RO2)
  RCONST(2435) = (1.00D-11*0.3*RO2)
  RCONST(2436) = (KAPHO2*0.44)
  RCONST(2437) = (KAPHO2*0.56)
  RCONST(2438) = (KAPNO)
  RCONST(2439) = (KFPAN)
  RCONST(2440) = (KRO2NO3*1.74)
  RCONST(2441) = (1.00D-11*RO2)
  RCONST(2442) = (4.89D-12)
  RCONST(2443) = (1.90D-12*EXP(190/TEMP))
  RCONST(2444) = (j('ch3o2h'))
  RCONST(2445) = (KDEC)
  RCONST(2446) = (1.23D-12)
  RCONST(2447) = (2.69D-12)
  RCONST(2448) = (2.52D-12)
  RCONST(2449) = (1.90D-12*EXP(190/TEMP))
  RCONST(2450) = (j('ch3o2h'))
  RCONST(2451) = (KDEC)
  RCONST(2452) = (1.75D-12)
  RCONST(2453) = (4.26D-12)
  RCONST(2454) = (1.20D-15)
  RCONST(2455) = (1.00D-14)
  RCONST(2456) = (1.00D-15)
  RCONST(2457) = (7.00D-14)
  RCONST(2458) = (6.00D-18*H2O)
  RCONST(2459) = (1.00D-17*H2O)
  RCONST(2460) = (KAPHO2*0.44)
  RCONST(2461) = (KAPHO2*0.15)
  RCONST(2462) = (KAPHO2*0.41)
  RCONST(2463) = (KAPNO)
  RCONST(2464) = (KFPAN)
  RCONST(2465) = (KRO2NO3*1.74)
  RCONST(2466) = (1.00D-11*RO2*0.7)
  RCONST(2467) = (1.00D-11*RO2*0.3)
  RCONST(2468) = (1.20D-15)
  RCONST(2469) = (1.00D-14)
  RCONST(2470) = (1.00D-15)
  RCONST(2471) = (7.00D-14)
  RCONST(2472) = (6.00D-18*H2O)
  RCONST(2473) = (1.00D-17*H2O)
  RCONST(2474) = (2.93D-11)
  RCONST(2475) = (1.90D-12*EXP(190/TEMP))
  RCONST(2476) = (j('ch3o2h'))
  RCONST(2477) = (KDEC)
  RCONST(2478) = (3.79D-12)
  RCONST(2479) = (j('mek'))
  RCONST(2480) = (1.51D-11)
  RCONST(2481) = (2.05D-12)
  RCONST(2482) = (1.90D-12*EXP(190/TEMP))
  RCONST(2483) = (j('ch3o2h'))
  RCONST(2484) = (KDEC)
  RCONST(2485) = (2.75D-11)
  RCONST(2486) = (j('i_c3h7cho'))
  RCONST(2487) = (j('ch3o2h'))
  RCONST(2488) = (5.3D-12*EXP(190/TEMP)*0.6)
  RCONST(2489) = (5.3D-12*EXP(190/TEMP)*0.4)
  RCONST(2490) = (j('ch3ono2'))
  RCONST(2491) = (4.0D-13*EXP(-845/TEMP))
  RCONST(2492) = (7.2D-14*EXP(-1080/TEMP)*O2)
  RCONST(2493) = (KMT14)
  RCONST(2494) = (2.91D-11)
  RCONST(2495) = (1.90D-12*EXP(190/TEMP))
  RCONST(2496) = (j('ch3o2h'))
  RCONST(2497) = (j('n_c3h7cho_hco'))
  RCONST(2498) = (KDEC)
  RCONST(2499) = (4.42D-12)
  RCONST(2500) = (j('ch3o2h'))
  RCONST(2501) = (1.2D-12)
  RCONST(2502) = (1.27D-12)
  RCONST(2503) = (1.7D-3*EXP(-11280/TEMP))
  RCONST(2504) = (j('ch3o2h'))
  RCONST(2505) = (1.90D-12*EXP(190/TEMP))
  RCONST(2506) = (8.01D-12)
  RCONST(2507) = (j('c2h5ono2'))
  RCONST(2508) = (6.7D-13*EXP(-395/TEMP))
  RCONST(2509) = (1.8D-12)
  RCONST(2510) = (8.29D-12)
  RCONST(2511) = (j('ch3o2h'))
  RCONST(2512) = (4.70D-12)
  RCONST(2513) = (KBPAN)
  RCONST(2514) = (1.90D-12*EXP(190/TEMP))
  RCONST(2515) = (1.27D-10)
  RCONST(2516) = (j('ch3o2h'))
  RCONST(2517) = (j('n_c3h7cho_hco'))
  RCONST(2518) = (2.25D-11)
  RCONST(2519) = (j('1_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(2520) = (2.70D+14*EXP(-7398/TEMP))
  RCONST(2521) = (KROSEC*O2)
  RCONST(2522) = (KNO3AL*4.0)
  RCONST(2523) = (7.15D-11)
  RCONST(2524) = (j('n_c3h7cho_hco'))
  RCONST(2525) = (j('n_c3h7cho_hco'))
  RCONST(2526) = (KNO3AL*4.0)
  RCONST(2527) = (4.88D-11*0.561)
  RCONST(2528) = (4.88D-11*0.439)
  RCONST(2529) = (j('ch3o2h'))
  RCONST(2530) = (1.10D-11)
  RCONST(2531) = (1.90D-12*EXP(190/TEMP))
  RCONST(2532) = (j('n_c3h7ono2'))
  RCONST(2533) = (5.8D-13)
  RCONST(2534) = (2.6D-14*EXP(-255/TEMP)*O2)
  RCONST(2535) = (2.00D-12)
  RCONST(2536) = (6.26D-12)
  RCONST(2537) = (j('ch3o2h'))
  RCONST(2538) = (2.66D-12)
  RCONST(2539) = (KBPAN)
  RCONST(2540) = (1.90D-12*EXP(190/TEMP))
  RCONST(2541) = (7.11D-11)
  RCONST(2542) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(2543) = (2.25D-11)
  RCONST(2544) = (j('n_c3h7ono2')+j('i_c3h7cho'))
  RCONST(2545) = (KROPRIM*O2)
  RCONST(2546) = (2*KNO3AL*4.0)
  RCONST(2547) = (1.44D-10)
  RCONST(2548) = (j('i_c3h7cho')*2.0)
  RCONST(2549) = (2.57D-11)
  RCONST(2550) = (j('i_c3h7cho'))
  RCONST(2551) = (j('ch3o2h'))
  RCONST(2552) = (KDEC)
  RCONST(2553) = (j('ch3o2h'))
  RCONST(2554) = (1.66D-11)
  RCONST(2555) = (1.90D-12*EXP(190/TEMP))
  RCONST(2556) = (j('1_c4h9ono2'))
  RCONST(2557) = (6.2D-13*EXP(-230/TEMP))
  RCONST(2558) = (1.5D-14*EXP(-230/TEMP)*O2)
  RCONST(2559) = (6.88D-12)
  RCONST(2560) = (1.04D-11)
  RCONST(2561) = (j('ch3o2h'))
  RCONST(2562) = (6.85D-12)
  RCONST(2563) = (KBPAN)
  RCONST(2564) = (1.90D-12*EXP(190/TEMP))
  RCONST(2565) = (1.57D-10)
  RCONST(2566) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(2567) = (2.33D-11)
  RCONST(2568) = (j('1_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(2569) = (KROPRIM*O2)
  RCONST(2570) = (j('n_c3h7cho_hco'))
  RCONST(2571) = (KNO3AL*5.5)
  RCONST(2572) = (6.76D-11)
  RCONST(2573) = (j('ch3o2h'))
  RCONST(2574) = (1.24D-11)
  RCONST(2575) = (1.90D-12*EXP(190/TEMP))
  RCONST(2576) = (j('n_c3h7ono2'))
  RCONST(2577) = (1.6D-12)
  RCONST(2578) = (8.9D-14*EXP(-550/TEMP)*O2)
  RCONST(2579) = (4.6D10*EXP(-3570/TEMP))
  RCONST(2580) = (8.66D-12)
  RCONST(2581) = (j('ch3o2h'))
  RCONST(2582) = (3.60D-12)
  RCONST(2583) = (6.58D-12)
  RCONST(2584) = (KBPAN)
  RCONST(2585) = (1.47D-11)
  RCONST(2586) = (4.77D-11)
  RCONST(2587) = (j('ch3o2h'))
  RCONST(2588) = (KDEC)
  RCONST(2589) = (j('ch3cocho'))
  RCONST(2590) = (KNO3AL*2.4)
  RCONST(2591) = (1.44D-11)
  RCONST(2592) = (6.22D-11)
  RCONST(2593) = (1.36D-10)
  RCONST(2594) = (j('n_c3h7cho_hco')*2)
! RCONST(2595) = constant rate coefficient
  RCONST(2596) = (j('ch3o2h'))
  RCONST(2597) = (j('n_c3h7cho_hco'))
  RCONST(2598) = (2.92D-11)
  RCONST(2599) = (KDEC)
  RCONST(2600) = (1.40D12*EXP(-3160/TEMP)+5.00D-12*O2)
  RCONST(2601) = (5.00D-12*0.76*O2)
  RCONST(2602) = (5.00D-12*0.24*O2)
  RCONST(2603) = (1.2D-15)
  RCONST(2604) = (1.0D-14)
  RCONST(2605) = (1.0D-15)
  RCONST(2606) = (7.0D-14)
  RCONST(2607) = (6.0D-18*H2O)
  RCONST(2608) = (1.0D-17*H2O)
  RCONST(2609) = (1.51D-11)
  RCONST(2610) = (j('ch3o2h'))
  RCONST(2611) = (1.30D-11*0.83)
  RCONST(2612) = (1.30D-11*0.17)
  RCONST(2613) = (3.60D-12)
  RCONST(2614) = (1.6D+16*EXP(-13500/TEMP))
  RCONST(2615) = (8.2D-18)
  RCONST(2616) = (2.9D-11*0.22)
  RCONST(2617) = (2.90D-11*0.57)
  RCONST(2618) = (2.90D-11*0.21)
  RCONST(2619) = (1.2D-15)
  RCONST(2620) = (1.0D-14)
  RCONST(2621) = (1.0D-15)
  RCONST(2622) = (7.0D-14)
  RCONST(2623) = (6.0D-18*H2O)
  RCONST(2624) = (j('i_c3h7cho'))
  RCONST(2625) = (j('ch3o2h'))
  RCONST(2626) = (3.77D-11)
  RCONST(2627) = (4.34D-12*0.16)
  RCONST(2628) = (4.34D-12*0.84)
  RCONST(2629) = (j('ch3coch2ono2')*10)
  RCONST(2630) = (KDEC)
  RCONST(2631) = (j('i_c3h7cho'))
  RCONST(2632) = (3.42D-11)
  RCONST(2633) = (5.55D-11)
  RCONST(2634) = (j('i_c3h7cho'))
  RCONST(2635) = (j('ch3o2h'))
  RCONST(2636) = (j('ch3coch2ono2')*1.6)
  RCONST(2637) = (2.15D-11)
  RCONST(2638) = (KDEC)
  RCONST(2639) = (4.18D-11)
  RCONST(2640) = (j('i_c3h7cho')*2)
  RCONST(2641) = (1.97D-11)
  RCONST(2642) = (j('ch3o2h'))
  RCONST(2643) = (6.48D-11)
  RCONST(2644) = (1.65D-11)
  RCONST(2645) = (KBPAN)
  RCONST(2646) = (KNO3AL*4.0)
  RCONST(2647) = (3.45D-12)
  RCONST(2648) = (j('i_c3h7cho')+j('ch3o2h'))
  RCONST(2649) = (KDEC)
  RCONST(2650) = (KNO3AL*4.0)
  RCONST(2651) = (4.27D-12)
  RCONST(2652) = (j('ch3cocho'))
  RCONST(2653) = (j('2_c4h9ono2'))
  RCONST(2654) = (5.51D-12)
  RCONST(2655) = (j('i_c3h7cho')+j('2_c4h9ono2'))
  RCONST(2656) = (KNO3AL*4.0)
  RCONST(2657) = (2.74D-11)
  RCONST(2658) = (j('i_c3h7cho')+j('ch3o2h'))
  RCONST(2659) = (KDEC)
  RCONST(2660) = (4.55D-11)
  RCONST(2661) = (j('i_c3h7cho'))
  RCONST(2662) = (1.20D-15)
  RCONST(2663) = (1.00D-14)
  RCONST(2664) = (1.00D-15)
  RCONST(2665) = (7.00D-14)
  RCONST(2666) = (6.00D-18*H2O)
  RCONST(2667) = (1.00D-17*H2O)
  RCONST(2668) = (9.53D-11)
  RCONST(2669) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(2670) = (KDEC)
  RCONST(2671) = (7.01D-11)
  RCONST(2672) = (j('i_c3h7cho'))
  RCONST(2673) = (j('n_c3h7cho_hco'))
  RCONST(2674) = (KNO3AL*4.0)
  RCONST(2675) = (2.45D-11)
  RCONST(2676) = (6.35D-11)
  RCONST(2677) = (j('i_c3h7cho'))
  RCONST(2678) = (j('ch3o2h'))
  RCONST(2679) = (KDEC)
  RCONST(2680) = (5.39D-11)
  RCONST(2681) = (j('ch3cocho'))
  RCONST(2682) = (2.15D-11)
  RCONST(2683) = (1.90D-12*EXP(190/TEMP))
  RCONST(2684) = (j('ch3o2h'))
  RCONST(2685) = (8.6D-13)
  RCONST(2686) = (j('1_c4h9ono2'))
  RCONST(2687) = (5.6D12*EXP(-5780/TEMP))
  RCONST(2688) = (1.5D-14*EXP(-200/TEMP)*O2)
  RCONST(2689) = (j('ch3o2h'))
  RCONST(2690) = (1.90D-12*EXP(190/TEMP))
  RCONST(2691) = (1.24D-11)
  RCONST(2692) = (j('n_c3h7ono2'))
  RCONST(2693) = (7.69D-13)
  RCONST(2694) = (KROPRIM*O2)
  RCONST(2695) = (2.17D-12*EXP(190/TEMP))
  RCONST(2696) = (j('ch3o2h'))
  RCONST(2697) = (8.16D-14)
  RCONST(2698) = (j('2_c4h9ono2'))
  RCONST(2699) = (1.41D-11)
  RCONST(2700) = (1.90D-12*EXP(190/TEMP))
  RCONST(2701) = (j('ch3o2h'))
  RCONST(2702) = (3.00D-12)
  RCONST(2703) = (j('n_c3h7ono2'))
  RCONST(2704) = (2.03D+11*EXP(-3430/TEMP))
  RCONST(2705) = (8.57D-12)
  RCONST(2706) = (2.30D-11)
  RCONST(2707) = (1.90D-12*EXP(190/TEMP))
  RCONST(2708) = (j('ch3o2h'))
  RCONST(2709) = (1.85D-12)
  RCONST(2710) = (j('1_c4h9ono2'))
  RCONST(2711) = (3.05D+11*EXP(-4240/TEMP))
  RCONST(2712) = (KROSEC*O2)
  RCONST(2713) = (1.14D-11)
  RCONST(2714) = (2.73D-11)
  RCONST(2715) = (j('ch3o2h'))
  RCONST(2716) = (1.12D-12)
  RCONST(2717) = (j('1_c4h9ono2'))
  RCONST(2718) = (4.00D+14*EXP(-6990/TEMP))
  RCONST(2719) = (KROSEC*O2)
  RCONST(2720) = (j('ch3o2h'))
  RCONST(2721) = (1.41D-11)
  RCONST(2722) = (1.90D-12*EXP(190/TEMP))
  RCONST(2723) = (j('n_c3h7ono2'))
  RCONST(2724) = (2.01D-12)
  RCONST(2725) = (KROPRIM*O2)
  RCONST(2726) = (3.05D+11*EXP(-4240/TEMP))
  RCONST(2727) = (j('ch3o2h'))
  RCONST(2728) = (1.90D-12*EXP(190/TEMP))
  RCONST(2729) = (2.29D-11)
  RCONST(2730) = (j('1_c4h9ono2'))
  RCONST(2731) = (1.82D-12)
  RCONST(2732) = (2.70D+14*EXP(-7398/TEMP))
  RCONST(2733) = (KROSEC*O2)
  RCONST(2734) = (j('ch3o2h'))
  RCONST(2735) = (5.25D-12)
  RCONST(2736) = (j('2_c4h9ono2'))
  RCONST(2737) = (4.08D-13)
  RCONST(2738) = (2.00D+14*EXP(-6995/TEMP))
  RCONST(2739) = (j('ch3o2h'))
  RCONST(2740) = (1.90D-12*EXP(190/TEMP))
  RCONST(2741) = (1.02D-11)
  RCONST(2742) = (j('n_c3h7ono2'))
  RCONST(2743) = (8.50D-13)
  RCONST(2744) = (2.00D+14*EXP(-5505/TEMP))
  RCONST(2745) = (4.66D-12)
  RCONST(2746) = (KNO3AL*8.5)
  RCONST(2747) = (6.82D-12*EXP(405/TEMP))
  RCONST(2748) = (j('i_c3h7cho'))
  RCONST(2749) = (j('ch3o2h'))
  RCONST(2750) = (1.52D-11)
  RCONST(2751) = (1.90D-12*EXP(190/TEMP))
  RCONST(2752) = (j('n_c3h7ono2'))
  RCONST(2753) = (4.68D-12)
  RCONST(2754) = (2.58D+11*EXP(-3430/TEMP))
  RCONST(2755) = (j('n_c3h7cho_ch3cho'))
  RCONST(2756) = (j('n_c3h7cho_hco'))
  RCONST(2757) = (KNO3AL*5.5)
  RCONST(2758) = (2.88D-11)
  RCONST(2759) = (9.72D-12)
  RCONST(2760) = (j('ch3o2h'))
  RCONST(2761) = (2.80D-11)
  RCONST(2762) = (1.90D-12*EXP(190/TEMP))
  RCONST(2763) = (j('1_c4h9ono2'))
  RCONST(2764) = (3.17D-12)
  RCONST(2765) = (2.03D+11*EXP(-3430/TEMP))
  RCONST(2766) = (1.28D-11)
  RCONST(2767) = (j('ch3o2h'))
  RCONST(2768) = (3.23D-11)
  RCONST(2769) = (j('1_c4h9ono2'))
  RCONST(2770) = (2.70D-12)
  RCONST(2771) = (KROSEC*O2)
  RCONST(2772) = (3.05D+11*EXP(-4240/TEMP))
  RCONST(2773) = (1.45D-11)
  RCONST(2774) = (j('ch3o2h'))
  RCONST(2775) = (1.79D-11)
  RCONST(2776) = (1.90D-12*EXP(190/TEMP))
  RCONST(2777) = (j('n_c3h7ono2'))
  RCONST(2778) = (3.53D-12)
  RCONST(2779) = (2.03D+11*EXP(-3430/TEMP))
  RCONST(2780) = (j('i_c3h7cho'))
  RCONST(2781) = (KNO3AL*8.5)
  RCONST(2782) = (2.89D-11)
  RCONST(2783) = (8.83D-12)
  RCONST(2784) = (j('ch3o2h'))
  RCONST(2785) = (1.90D-12*EXP(190/TEMP))
  RCONST(2786) = (2.44D-11)
  RCONST(2787) = (j('1_c4h9ono2'))
  RCONST(2788) = (3.07D-12)
  RCONST(2789) = (6.10D+11*EXP(-4240/TEMP))
  RCONST(2790) = (KROSEC*O2)
  RCONST(2791) = (1.28D-11)
  RCONST(2792) = (j('ch3o2h'))
  RCONST(2793) = (2.87D-11)
  RCONST(2794) = (1.90D-12*EXP(190/TEMP))
  RCONST(2795) = (j('1_c4h9ono2'))
  RCONST(2796) = (3.02D-12)
  RCONST(2797) = (2.00D+14*EXP(-6975/TEMP))
  RCONST(2798) = (KROSEC*O2)
  RCONST(2799) = (2.00D+14*EXP(-6773/TEMP))
  RCONST(2800) = (j('mek'))
  RCONST(2801) = (j('mek'))
  RCONST(2802) = (3.75D-12*0.578)
  RCONST(2803) = (3.75D-12*0.422)
  RCONST(2804) = (1.44D-11)
  RCONST(2805) = (j('ch3o2h'))
  RCONST(2806) = (6.66D-12)
  RCONST(2807) = (j('2_c4h9ono2'))
  RCONST(2808) = (1.72D-12)
  RCONST(2809) = (2.70D+14*EXP(-6542/TEMP))
  RCONST(2810) = (3.05D+11*EXP(-4240/TEMP))
  RCONST(2811) = (3.20D-12)
  RCONST(2812) = (j('ch3o2h'))
  RCONST(2813) = (1.57D-11)
  RCONST(2814) = (1.90D-12*EXP(190/TEMP))
  RCONST(2815) = (j('n_c3h7ono2'))
  RCONST(2816) = (4.96D-12)
  RCONST(2817) = (2.03D+11*EXP(-3430/TEMP))
  RCONST(2818) = (j('n_c3h7cho_hco'))
  RCONST(2819) = (KNO3AL*8.5)
  RCONST(2820) = (3.27D-11)
  RCONST(2821) = (1.03D-11)
  RCONST(2822) = (j('ch3o2h'))
  RCONST(2823) = (2.46D-11)
  RCONST(2824) = (1.90D-12*EXP(190/TEMP))
  RCONST(2825) = (j('1_c4h9ono2'))
  RCONST(2826) = (3.02D-12)
  RCONST(2827) = (2.03D+11*EXP(-4240/TEMP))
  RCONST(2828) = (KROSEC*O2)
  RCONST(2829) = (j('mek'))
  RCONST(2830) = (6.23D-12*0.671)
  RCONST(2831) = (6.23D-12*0.329)
  RCONST(2832) = (1.31D-11)
  RCONST(2833) = (j('ch3o2h'))
  RCONST(2834) = (6.40D-12)
  RCONST(2835) = (j('2_c4h9ono2'))
  RCONST(2836) = (7.35D-13)
  RCONST(2837) = (2.70D+14*EXP(-7196/TEMP)*2.0)
  RCONST(2838) = (2.94D-12)
  RCONST(2839) = (j('ch3o2h'))
  RCONST(2840) = (1.90D-12*EXP(190/TEMP))
  RCONST(2841) = (9.51D-12)
  RCONST(2842) = (j('1_c4h9ono2'))
  RCONST(2843) = (6.24D-13)
  RCONST(2844) = (KROSEC*O2)
  RCONST(2845) = (2.70D+14*EXP(-6643/TEMP))
  RCONST(2846) = (9.16D-12)
  RCONST(2847) = (j('ch3o2h'))
  RCONST(2848) = (1.16D-11)
  RCONST(2849) = (1.90D-12*EXP(190/TEMP))
  RCONST(2850) = (j('n_c3h7ono2'))
  RCONST(2851) = (7.78D-13)
  RCONST(2852) = (9.14D+11*EXP(-4240/TEMP))
  RCONST(2853) = (j('n_c3h7cho_hco'))
  RCONST(2854) = (KNO3AL*8.5)
  RCONST(2855) = (2.21D-11)
  RCONST(2856) = (6.08D-12)
  RCONST(2857) = (j('ch3o2h'))
  RCONST(2858) = (1.13D-11)
  RCONST(2859) = (1.90D-12*EXP(190/TEMP))
  RCONST(2860) = (j('n_c3h7ono2'))
  RCONST(2861) = (1.96D-12)
  RCONST(2862) = (3.05D+11*EXP(-4240/TEMP))
  RCONST(2863) = (KROPRIM*O2)
  RCONST(2864) = (j('i_c3h7cho'))
  RCONST(2865) = (KNO3AL*8.5)
  RCONST(2866) = (2.56D-11)
  RCONST(2867) = (5.81D-12)
  RCONST(2868) = (j('ch3o2h'))
  RCONST(2869) = (6.66D-12)
  RCONST(2870) = (j('2_c4h9ono2'))
  RCONST(2871) = (7.77D-13)
  RCONST(2872) = (2.70D+14*EXP(-6391/TEMP))
  RCONST(2873) = (3.20D-12)
  RCONST(2874) = (j('ch3o2h'))
  RCONST(2875) = (1.90D-12*EXP(190/TEMP))
  RCONST(2876) = (1.55D-11)
  RCONST(2877) = (j('n_c3h7ono2'))
  RCONST(2878) = (3.41D-12)
  RCONST(2879) = (6.10D+11*EXP(-4240/TEMP))
  RCONST(2880) = (KROPRIM*O2)
  RCONST(2881) = (1.05D-11)
  RCONST(2882) = (j('i_c3h7cho'))
  RCONST(2883) = (KNO3AL*8.5)
  RCONST(2884) = (3.01D-11)
  RCONST(2885) = (j('ch3o2h'))
  RCONST(2886) = (3.37D-11)
  RCONST(2887) = (j('1_c4h9ono2'))
  RCONST(2888) = (3.69D-12)
  RCONST(2889) = (2.58D+11*EXP(-3430/TEMP))
  RCONST(2890) = (j('mek'))
  RCONST(2891) = (7.89D-12)
  RCONST(2892) = (1.59D-11)
  RCONST(2893) = (j('ch3o2h'))
  RCONST(2894) = (2.94D-11)
  RCONST(2895) = (j('1_c4h9ono2'))
  RCONST(2896) = (4.49D-12)
  RCONST(2897) = (1.02D+11*EXP(-2945/TEMP))
  RCONST(2898) = (j('mek'))
  RCONST(2899) = (8.16D-12)
  RCONST(2900) = (1.42D-11)
  RCONST(2901) = (j('ch3o2h'))
  RCONST(2902) = (8.08D-12)
  RCONST(2903) = (j('2_c4h9ono2'))
  RCONST(2904) = (3.01D-12)
  RCONST(2905) = (2.03D+11*EXP(-3430/TEMP))
  RCONST(2906) = (4.62D-12)
  RCONST(2907) = (j('ch3o2h'))
  RCONST(2908) = (2.96D-11)
  RCONST(2909) = (j('1_c4h9ono2'))
  RCONST(2910) = (4.60D-12)
  RCONST(2911) = (2.58D+11*EXP(-3430/TEMP))
  RCONST(2912) = (j('mek'))
  RCONST(2913) = (1.18D-11)
  RCONST(2914) = (1.45D-11)
  RCONST(2915) = (j('ch3o2h'))
  RCONST(2916) = (7.81D-12)
  RCONST(2917) = (j('2_c4h9ono2'))
  RCONST(2918) = (1.93D-12)
  RCONST(2919) = (3.05D+11*EXP(-4240/TEMP))
  RCONST(2920) = (4.35D-12)
  RCONST(2921) = (j('ch3o2h'))
  RCONST(2922) = (3.51D-11)
  RCONST(2923) = (j('1_c4h9ono2'))
  RCONST(2924) = (3.88D-12)
  RCONST(2925) = (2.58D+11*EXP(-3430/TEMP))
  RCONST(2926) = (j('mek'))
  RCONST(2927) = (9.30D-12)
  RCONST(2928) = (1.73D-11)
  RCONST(2929) = (j('ch3o2h'))
  RCONST(2930) = (3.65D-11)
  RCONST(2931) = (j('1_c4h9ono2'))
  RCONST(2932) = (6.26D-12)
  RCONST(2933) = (2.58D+11*EXP(-3430/TEMP))
  RCONST(2934) = (j('mek'))
  RCONST(2935) = (1.07D-11)
  RCONST(2936) = (1.87D-11)
  RCONST(2937) = (j('ch3o2h'))
  RCONST(2938) = (3.79D-11)
  RCONST(2939) = (j('1_c4h9ono2'))
  RCONST(2940) = (7.67D-12)
  RCONST(2941) = (2.58D+11*EXP(-3430/TEMP))
  RCONST(2942) = (j('mek'))
  RCONST(2943) = (1.21D-11)
  RCONST(2944) = (2.01D-11)
  RCONST(2945) = (3.93D-11)
  RCONST(2946) = (j('ch3o2h'))
  RCONST(2947) = (9.08D-12)
  RCONST(2948) = (j('1_c4h9ono2'))
  RCONST(2949) = (2.58D+11*EXP(-3430/TEMP))
  RCONST(2950) = (1.35D-11)
  RCONST(2951) = (j('mek'))
  RCONST(2952) = (2.15D-11)
  RCONST(2953) = (j('ch3o2h'))
  RCONST(2954) = (4.07D-11)
  RCONST(2955) = (j('1_c4h9ono2'))
  RCONST(2956) = (1.05D-11)
  RCONST(2957) = (2.58D+11*EXP(-3430/TEMP))
  RCONST(2958) = (j('mek'))
  RCONST(2959) = (1.49D-11)
  RCONST(2960) = (2.29D-11)
  RCONST(2961) = (j('ch3o2h'))
  RCONST(2962) = (3.53D-11)
  RCONST(2963) = (j('1_c4h9ono2'))
  RCONST(2964) = (3.30D-12)
  RCONST(2965) = (3.80D+13*EXP(-6026/TEMP))
  RCONST(2966) = (KROSEC*O2)
  RCONST(2967) = (1.90D-12*EXP(190/TEMP))
  RCONST(2968) = (1.62D-12)
  RCONST(2969) = (j('ch3o2h'))
  RCONST(2970) = (7.00D+03)
  RCONST(2971) = (KROPRIM*O2)
  RCONST(2972) = (KNO3AL)
  RCONST(2973) = (3.40D-12)
  RCONST(2974) = (j('ch3coch2ono2')*4.3)
  RCONST(2975) = (1.69D-12)
  RCONST(2976) = (1.90D-12*EXP(190/TEMP))
  RCONST(2977) = (j('ch3o2h'))
  RCONST(2978) = (KROPRIM*O2)
  RCONST(2979) = (7.00D+03)
  RCONST(2980) = (KNO3AL*2.4)
  RCONST(2981) = (3.55D-12)
  RCONST(2982) = (j('ch3coch2ono2')*10)
  RCONST(2983) = (3.47D-12)
  RCONST(2984) = (1.90D-12*EXP(190/TEMP))
  RCONST(2985) = (j('ch3o2h'))
  RCONST(2986) = (7.00D+03)
  RCONST(2987) = (KROSEC*O2)
  RCONST(2988) = (6.70D-13)
  RCONST(2989) = (j('ch3coch2ono2'))
  RCONST(2990) = (8.97D-12)
  RCONST(2991) = (j('ch3o2h'))
  RCONST(2992) = (7.00D+03)
  RCONST(2993) = (KROSEC*O2)
  RCONST(2994) = (8.2D-13)
  RCONST(2995) = (j('ch3coch2ono2'))
  RCONST(2996) = (3.03D-12)
  RCONST(2997) = (5.64D-12)
  RCONST(2998) = (j('ch3o2h'))
  RCONST(2999) = (KROPRIM*O2)
  RCONST(3000) = (7.00D+03)
  RCONST(3001) = (4.44D-12)
  RCONST(3002) = (j('1_c4h9ono2'))
  RCONST(3003) = (j('i_c3h7cho'))
  RCONST(3004) = (1.20D-15)
  RCONST(3005) = (1.00D-14)
  RCONST(3006) = (1.00D-15)
  RCONST(3007) = (7.00D-14)
  RCONST(3008) = (6.00D-18*H2O)
  RCONST(3009) = (1.00D-17*H2O)
  RCONST(3010) = (2.14D-11)
  RCONST(3011) = (1.90D-12*EXP(190/TEMP))
  RCONST(3012) = (j('ch3o2h'))
  RCONST(3013) = (2.00D+14*EXP(-5538/TEMP))
  RCONST(3014) = (KNO3AL*4.0)
  RCONST(3015) = (3.08D-11)
  RCONST(3016) = (j('n_c3h7cho_hco'))
  RCONST(3017) = (7.15D-12)
  RCONST(3018) = (j('ch3o2h'))
  RCONST(3019) = (KROSEC*O2)
  RCONST(3020) = (4.00D+04)
  RCONST(3021) = (1.2D-12)
  RCONST(3022) = (j('ch3coch2ono2')*1.6)
  RCONST(3023) = (3.98D-12)
  RCONST(3024) = (j('ch3o2h'))
  RCONST(3025) = (KDEC)
  RCONST(3026) = (5.22D-12)
  RCONST(3027) = (j('ch3o2h'))
  RCONST(3028) = (7.00D+03)
  RCONST(3029) = (KROPRIM*O2)
  RCONST(3030) = (KNO3AL*4.0)
  RCONST(3031) = (3.61D-12)
  RCONST(3032) = (j('n_c3h7cho_hco'))
  RCONST(3033) = (j('ch3coch2ono2')*10)
  RCONST(3034) = (1.20D-15)
  RCONST(3035) = (1.00D-14)
  RCONST(3036) = (1.00D-15)
  RCONST(3037) = (7.00D-14)
  RCONST(3038) = (6.00D-18*H2O)
  RCONST(3039) = (1.06D-11)
  RCONST(3040) = (1.90D-12*EXP(190/TEMP))
  RCONST(3041) = (j('ch3o2h'))
  RCONST(3042) = (7.00D+03)
  RCONST(3043) = (KROSEC*O2)
  RCONST(3044) = (4.70D-12)
  RCONST(3045) = (j('ch3coch2ono2')*1.6)
  RCONST(3046) = (3.43D-12)
  RCONST(3047) = (3.23D-12)
  RCONST(3048) = (1.90D-12*EXP(190/TEMP))
  RCONST(3049) = (j('ch3o2h'))
  RCONST(3050) = (7.00D+03)
  RCONST(3051) = (KROPRIM*O2)
  RCONST(3052) = (KNO3AL*5.5)
  RCONST(3053) = (5.77D-12)
  RCONST(3054) = (j('ch3coch2ono2')*10)
  RCONST(3055) = (2.46D-12)
  RCONST(3056) = (1.20D-15)
  RCONST(3057) = (1.00D-14)
  RCONST(3058) = (1.00D-15)
  RCONST(3059) = (7.00D-14)
  RCONST(3060) = (1.00D-17*H2O)
  RCONST(3061) = (6.00D-18*H2O)
  RCONST(3062) = (3.15D-11)
  RCONST(3063) = (1.90D-12*EXP(190/TEMP))
  RCONST(3064) = (j('ch3o2h'))
  RCONST(3065) = (2.00D+14*EXP(-6382/TEMP))
  RCONST(3066) = (7.26D-12)
  RCONST(3067) = (j('mek'))
  RCONST(3068) = (1.73D-11)
  RCONST(3069) = (2.16D-11)
  RCONST(3070) = (1.90D-12*EXP(190/TEMP))
  RCONST(3071) = (j('ch3o2h'))
  RCONST(3072) = (2.00D+14*EXP(-5489/TEMP))
  RCONST(3073) = (KNO3AL*5.5)
  RCONST(3074) = (3.30D-11)
  RCONST(3075) = (j('n_c3h7cho_hco'))
  RCONST(3076) = (5.45D-12)
  RCONST(3077) = (1.90D-12*EXP(190/TEMP))
  RCONST(3078) = (j('ch3o2h'))
  RCONST(3079) = (4.00D+04)
  RCONST(3080) = (KROSEC*O2)
  RCONST(3081) = (1.41D-12)
  RCONST(3082) = (j('ch3coch2ono2')*1.6)
  RCONST(3083) = (3.90D-12)
  RCONST(3084) = (1.90D-12*EXP(190/TEMP))
  RCONST(3085) = (j('ch3o2h'))
  RCONST(3086) = (KROSEC*O2)
  RCONST(3087) = (4.00D+04)
  RCONST(3088) = (1.16D-12)
  RCONST(3089) = (j('ch3coch2ono2')*1.6)
  RCONST(3090) = (2.14D-12)
  RCONST(3091) = (3.56D-11)
  RCONST(3092) = (1.90D-12*EXP(190/TEMP))
  RCONST(3093) = (j('ch3o2h'))
  RCONST(3094) = (2.00D+14*EXP(-4714/TEMP))
  RCONST(3095) = (1.02D-11)
  RCONST(3096) = (j('mek'))
  RCONST(3097) = (1.90D-12*EXP(190/TEMP))
  RCONST(3098) = (1.95D-12)
  RCONST(3099) = (j('ch3o2h'))
  RCONST(3100) = (KROPRIM*O2)
  RCONST(3101) = (7.00D+03)
  RCONST(3102) = (KNO3AL*8.5)
  RCONST(3103) = (4.48D-12)
  RCONST(3104) = (j('ch3coch2ono2')*10)
  RCONST(3105) = (j('n_c3h7cho_hco'))
  RCONST(3106) = (5.13D-12)
  RCONST(3107) = (j('ch3o2h'))
  RCONST(3108) = (KDEC)
  RCONST(3109) = (1.20D-15)
  RCONST(3110) = (1.00D-14)
  RCONST(3111) = (1.00D-15)
  RCONST(3112) = (7.00D-14)
  RCONST(3113) = (6.00D-18*H2O)
  RCONST(3114) = (1.90D-12*EXP(190/TEMP))
  RCONST(3115) = (6.78D-12)
  RCONST(3116) = (j('ch3o2h'))
  RCONST(3117) = (KROSEC*O2)
  RCONST(3118) = (7.00D+03)
  RCONST(3119) = (1.73D-12)
  RCONST(3120) = (j('ch3coch2ono2'))
  RCONST(3121) = (4.58D-12)
  RCONST(3122) = (j('n_c3h7ono2'))
  RCONST(3123) = (2.41D-12)
  RCONST(3124) = (1.90D-12*EXP(190/TEMP))
  RCONST(3125) = (j('ch3o2h'))
  RCONST(3126) = (KROPRIM*O2)
  RCONST(3127) = (7.00D+03)
  RCONST(3128) = (KNO3AL*8.5)
  RCONST(3129) = (5.49D-12)
  RCONST(3130) = (j('ch3coch2ono2')*10)
  RCONST(3131) = (1.20D-15)
  RCONST(3132) = (1.00D-14)
  RCONST(3133) = (1.00D-15)
  RCONST(3134) = (7.00D-14)
  RCONST(3135) = (1.00D-17*H2O)
  RCONST(3136) = (6.00D-18*H2O)
  RCONST(3137) = (2.28D-11)
  RCONST(3138) = (1.90D-12*EXP(190/TEMP))
  RCONST(3139) = (j('ch3o2h'))
  RCONST(3140) = (KDEC)
  RCONST(3141) = (KNO3AL*8.5)
  RCONST(3142) = (3.51D-11)
  RCONST(3143) = (j('i_c3h7cho'))
  RCONST(3144) = (1.90D-12*EXP(190/TEMP))
  RCONST(3145) = (7.08D-12)
  RCONST(3146) = (j('ch3o2h'))
  RCONST(3147) = (KROSEC*O2)
  RCONST(3148) = (4.00D+04)
  RCONST(3149) = (3.41D-13)
  RCONST(3150) = (j('ch3coch2ono2')*1.6)
  RCONST(3151) = (4.06D-12)
  RCONST(3152) = (j('ch3o2h'))
  RCONST(3153) = (KDEC)
  RCONST(3154) = (4.65D-12)
  RCONST(3155) = (1.90D-12*EXP(190/TEMP))
  RCONST(3156) = (7.00D+03)
  RCONST(3157) = (KROPRIM*O2)
  RCONST(3158) = (KNO3AL*5.5)
  RCONST(3159) = (7.19D-12)
  RCONST(3160) = (j('ch3coch2ono2')*10+j('n_c3h7cho_hco'))
  RCONST(3161) = (3.87D-12)
  RCONST(3162) = (8.20D-12)
  RCONST(3163) = (1.90D-12*EXP(190/TEMP))
  RCONST(3164) = (j('ch3o2h'))
  RCONST(3165) = (7.00D+03)
  RCONST(3166) = (KROSEC*O2)
  RCONST(3167) = (6.69D-12)
  RCONST(3168) = (j('ch3coch2ono2'))
  RCONST(3169) = (6.00D-12)
  RCONST(3170) = (1.20D-15)
  RCONST(3171) = (1.00D-14)
  RCONST(3172) = (1.00D-15)
  RCONST(3173) = (7.00D-14)
  RCONST(3174) = (6.00D-18*H2O)
  RCONST(3175) = (1.00D-17*H2O)
  RCONST(3176) = (3.30D-11)
  RCONST(3177) = (1.90D-12*EXP(190/TEMP))
  RCONST(3178) = (j('ch3o2h'))
  RCONST(3179) = (KDEC)
  RCONST(3180) = (8.09D-12)
  RCONST(3181) = (j('mek'))
  RCONST(3182) = (1.86D-11)
  RCONST(3183) = (j('ch3o2h'))
  RCONST(3184) = (2.42D-11)
  RCONST(3185) = (1.90D-12*EXP(190/TEMP))
  RCONST(3186) = (KDEC)
  RCONST(3187) = (j('n_c3h7cho_hco'))
  RCONST(3188) = (KNO3AL*5.5)
  RCONST(3189) = (3.44D-11)
  RCONST(3190) = (7.24D-12)
  RCONST(3191) = (1.90D-12*EXP(190/TEMP))
  RCONST(3192) = (j('ch3o2h'))
  RCONST(3193) = (4.00D+04)
  RCONST(3194) = (KROSEC*O2)
  RCONST(3195) = (4.85D-12)
  RCONST(3196) = (j('ch3coch2ono2')*1.6)
  RCONST(3197) = (2.06D-12)
  RCONST(3198) = (5.09D-12)
  RCONST(3199) = (1.90D-12*EXP(190/TEMP))
  RCONST(3200) = (j('ch3o2h'))
  RCONST(3201) = (4.00D+04)
  RCONST(3202) = (KROSEC*O2)
  RCONST(3203) = (2.49D-12)
  RCONST(3204) = (j('ch3coch2ono2')*1.6)
  RCONST(3205) = (3.33D-12)
  RCONST(3206) = (1.90D-12*EXP(190/TEMP))
  RCONST(3207) = (3.34D-11)
  RCONST(3208) = (j('ch3o2h'))
  RCONST(3209) = (KDEC)
  RCONST(3210) = (2.18D-11)
  RCONST(3211) = (1.23D-11)
  RCONST(3212) = (j('mek'))
  RCONST(3213) = (1.90D-12*EXP(190/TEMP))
  RCONST(3214) = (3.60D-11)
  RCONST(3215) = (j('ch3o2h'))
  RCONST(3216) = (KDEC)
  RCONST(3217) = (1.01D-11)
  RCONST(3218) = (j('mek'))
  RCONST(3219) = (4.34D-12)
  RCONST(3220) = (j('ch3o2h'))
  RCONST(3221) = (KDEC)
  RCONST(3222) = (8.89D-13)
  RCONST(3223) = (4.40D-12)
  RCONST(3224) = (j('ch3o2h'))
  RCONST(3225) = (KDEC)
  RCONST(3226) = (9.49D-13)
  RCONST(3227) = (9.77D-11)
  RCONST(3228) = (j('ch3o2h'))
  RCONST(3229) = (7.30D-11)
  RCONST(3230) = (j('1_c4h9ono2'))
  RCONST(3231) = (KDEC*0.50)
  RCONST(3232) = (KDEC*0.50)
  RCONST(3233) = (1.21D-10)
  RCONST(3234) = (8.16D-11)
  RCONST(3235) = (j('mek'))
  RCONST(3236) = (KAPHO2*0.15)
  RCONST(3237) = (KAPHO2*0.41)
  RCONST(3238) = (KAPHO2*0.44)
  RCONST(3239) = (KAPNO)
  RCONST(3240) = (KFPAN)
  RCONST(3241) = (KRO2NO3*1.74)
  RCONST(3242) = (1.00D-11*RO2*0.3)
  RCONST(3243) = (1.00D-11*RO2*0.7)
  RCONST(3244) = (2*KNO3AL*4.0)
  RCONST(3245) = (4.32D-11)
  RCONST(3246) = (j('i_c3h7cho')*2)
  RCONST(3247) = (KDEC*0.18)
  RCONST(3248) = (KDEC*0.125)
  RCONST(3249) = (KDEC*0.125)
  RCONST(3250) = (KDEC*0.57)
  RCONST(3251) = (KRO2HO2*0.77)
  RCONST(3252) = (KRO2NO*0.105)
  RCONST(3253) = (KRO2NO*0.895)
  RCONST(3254) = (KRO2NO3)
  RCONST(3255) = (8.80D-13*0.2*RO2)
  RCONST(3256) = (8.80D-13*0.6*RO2)
  RCONST(3257) = (8.80D-13*0.2*RO2)
  RCONST(3258) = (KRO2HO2*0.706)
  RCONST(3259) = (KRO2NO)
  RCONST(3260) = (KRO2NO3)
  RCONST(3261) = (8.80D-13*RO2*0.2)
  RCONST(3262) = (8.80D-13*RO2*0.6)
  RCONST(3263) = (8.80D-13*RO2*0.2)
  RCONST(3264) = (2*KNO3AL*2.0)
  RCONST(3265) = (2.00D-18)
  RCONST(3266) = (5.20D-11*0.83)
  RCONST(3267) = (5.20D-11*0.17)
  RCONST(3268) = (j('no2')*0.14*0.4)
  RCONST(3269) = (j('no2')*0.14*0.6)
  RCONST(3270) = (2.08D-12)
  RCONST(3271) = (2.86D-13)
  RCONST(3272) = (KRO2HO2*0.770)
  RCONST(3273) = (KRO2NO)
  RCONST(3274) = (KRO2NO3)
  RCONST(3275) = (8.00D-13*RO2*0.7)
  RCONST(3276) = (8.00D-13*RO2*0.3)
  RCONST(3277) = (9.9D-11)
  RCONST(3278) = (9.2D-18)
  RCONST(3279) = (1.0D-10)
  RCONST(3280) = (KRO2HO2*0.770)
  RCONST(3281) = (KRO2NO)
  RCONST(3282) = (KRO2NO3)
  RCONST(3283) = (8.00D-13*RO2*0.7)
  RCONST(3284) = (8.00D-13*RO2*0.3)
  RCONST(3285) = (2.05D-11)
  RCONST(3286) = (j('ch3o2h'))
  RCONST(3287) = (6.03D-12)
  RCONST(3288) = (j('n_c3h7ono2'))
  RCONST(3289) = (KROPRIM*O2)
  RCONST(3290) = (2.7D-11)
  RCONST(3291) = (KRO2HO2*0.820)
  RCONST(3292) = (KRO2NO)
  RCONST(3293) = (KRO2NO3)
  RCONST(3294) = (8.00D-13*RO2*0.70)
  RCONST(3295) = (8.00D-13*RO2*0.30)
  RCONST(3296) = (KRO2HO2*0.820)
  RCONST(3297) = (KRO2NO)
  RCONST(3298) = (KRO2NO3)
  RCONST(3299) = (8.00D-13*RO2*0.70)
  RCONST(3300) = (8.00D-13*RO2*0.30)
  RCONST(3301) = (2.08D-12)
  RCONST(3302) = (2.86D-13)
  RCONST(3303) = (1.7D-10*1.0)
  RCONST(3304) = (2.8D-17)
  RCONST(3305) = (2.0D-10*1.0)
  RCONST(3306) = (9.64D-11)
  RCONST(3307) = (j('ch3o2h'))
  RCONST(3308) = (KDEC*0.2)
  RCONST(3309) = (KDEC*0.2)
  RCONST(3310) = (KDEC*0.2)
  RCONST(3311) = (KDEC*0.2)
  RCONST(3312) = (KDEC*0.2)
  RCONST(3313) = (7.16D-11)
  RCONST(3314) = (j('1_c4h9ono2'))
  RCONST(3315) = (1.20D-10)
  RCONST(3316) = (7.99D-11)
  RCONST(3317) = (j('mek'))
  RCONST(3318) = (KAPHO2*0.44)
  RCONST(3319) = (KAPHO2*0.15)
  RCONST(3320) = (KAPHO2*0.41)
  RCONST(3321) = (KAPNO)
  RCONST(3322) = (KFPAN)
  RCONST(3323) = (KRO2NO3*1.74)
  RCONST(3324) = (1.00D-11*RO2*0.7)
  RCONST(3325) = (1.00D-11*RO2*0.3)
  RCONST(3326) = (KDEC*0.125)
  RCONST(3327) = (KDEC*0.57)
  RCONST(3328) = (KDEC*0.125)
  RCONST(3329) = (KDEC*0.18)
  RCONST(3330) = (KRO2HO2*0.820)
  RCONST(3331) = (KRO2NO*0.105)
  RCONST(3332) = (KRO2NO*0.895)
  RCONST(3333) = (KRO2NO3)
  RCONST(3334) = (8.80D-13*RO2*0.20)
  RCONST(3335) = (8.80D-13*RO2*0.60)
  RCONST(3336) = (8.80D-13*RO2*0.20)
  RCONST(3337) = (KRO2HO2*0.770)
  RCONST(3338) = (KRO2NO)
  RCONST(3339) = (KRO2NO3)
  RCONST(3340) = (8.80D-13*RO2*0.2)
  RCONST(3341) = (8.80D-13*RO2*0.6)
  RCONST(3342) = (8.80D-13*RO2*0.2)
  RCONST(3343) = (2.75D-11)
  RCONST(3344) = (j('ch3o2h'))
  RCONST(3345) = (1.31D-11)
  RCONST(3346) = (j('n_c3h7ono2'))
  RCONST(3347) = (KROPRIM*O2)
  RCONST(3348) = (KNO3AL)
  RCONST(3349) = (1.29D-11)
  RCONST(3350) = (j('ch2cch3cho_h'))
  RCONST(3351) = (j('ch2cch3cho_hco'))
  RCONST(3352) = (1.60D-11)
  RCONST(3353) = (7.62D-11)
  RCONST(3354) = (j('ch3o2h'))
  RCONST(3355) = (7.28D-11)
  RCONST(3356) = (j('2_c4h9ono2'))
  RCONST(3357) = (KDEC*0.175)
  RCONST(3358) = (KDEC*0.245)
  RCONST(3359) = (KDEC*0.175)
  RCONST(3360) = (KDEC*0.08)
  RCONST(3361) = (KDEC*0.08)
  RCONST(3362) = (KDEC*0.245)
  RCONST(3363) = (1.11D-10)
  RCONST(3364) = (KAPHO2*0.44)
  RCONST(3365) = (KAPHO2*0.15)
  RCONST(3366) = (KAPHO2*0.41)
  RCONST(3367) = (KAPNO)
  RCONST(3368) = (KFPAN)
  RCONST(3369) = (KRO2NO3*1.74)
  RCONST(3370) = (1.00D-11*RO2*0.70)
  RCONST(3371) = (1.00D-11*RO2*0.30)
  RCONST(3372) = (2*KNO3AL*8.5)
  RCONST(3373) = (4.24D-11)
  RCONST(3374) = (j('i_c3h7cho')*2)
  RCONST(3375) = (KRO2HO2*0.859)
  RCONST(3376) = (KRO2NO*0.173)
  RCONST(3377) = (KRO2NO*0.827)
  RCONST(3378) = (KRO2NO3)
  RCONST(3379) = (8.80D-12*RO2*0.20)
  RCONST(3380) = (8.80D-12*RO2*0.60)
  RCONST(3381) = (8.80D-12*RO2*0.20)
  RCONST(3382) = (KRO2HO2*0.820)
  RCONST(3383) = (KRO2NO)
  RCONST(3384) = (KRO2NO3)
  RCONST(3385) = (9.20D-14*RO2*0.70)
  RCONST(3386) = (9.20D-14*RO2*0.30)
  RCONST(3387) = (KRO2HO2*0.859)
  RCONST(3388) = (KRO2NO)
  RCONST(3389) = (KRO2NO3)
  RCONST(3390) = (8.00D-13*RO2*0.70)
  RCONST(3391) = (8.00D-13*RO2*0.30)
  RCONST(3392) = (2.08D-12)
  RCONST(3393) = (2.86D-13)
  RCONST(3394) = (KRO2HO2*0.859)
  RCONST(3395) = (KRO2NO)
  RCONST(3396) = (KRO2NO3)
  RCONST(3397) = (8.00D-13*RO2*0.70)
  RCONST(3398) = (8.00D-13*RO2*0.30)
  RCONST(3399) = (2.01D-10)
  RCONST(3400) = (2.81D-17)
  RCONST(3401) = (2.05D-10)
  RCONST(3402) = (2.05D-11)
  RCONST(3403) = (j('ch3o2h'))
  RCONST(3404) = (6.03D-12)
  RCONST(3405) = (j('n_c3h7ono2'))
  RCONST(3406) = (KROPRIM*O2)
  RCONST(3407) = (KNO3AL)
  RCONST(3408) = (1.29D-11)
  RCONST(3409) = (j('ch2cch3cho_h'))
  RCONST(3410) = (j('ch2cch3cho_hco'))
  RCONST(3411) = (8.93D-12)
  RCONST(3412) = (1.17D-10)
  RCONST(3413) = (j('ch3o2h'))
  RCONST(3414) = (7.15D-11)
  RCONST(3415) = (j('1_c4h9ono2'))
  RCONST(3416) = (KDEC*0.11)
  RCONST(3417) = (KDEC*0.11)
  RCONST(3418) = (KDEC*0.26)
  RCONST(3419) = (KDEC*0.26)
  RCONST(3420) = (KDEC*0.26)
  RCONST(3421) = (2.50D-10)
  RCONST(3422) = (7.93D-11*0.5)
  RCONST(3423) = (7.93D-11*0.5)
  RCONST(3424) = (j('mek')*0.5)
  RCONST(3425) = (j('mek')*0.5)
  RCONST(3426) = (KAPHO2*0.44)
  RCONST(3427) = (KAPHO2*0.15)
  RCONST(3428) = (KAPHO2*0.41)
  RCONST(3429) = (KAPNO)
  RCONST(3430) = (KFPAN)
  RCONST(3431) = (KRO2NO3*1.74)
  RCONST(3432) = (1.00D-11*RO2*0.70)
  RCONST(3433) = (1.00D-11*RO2*0.30)
  RCONST(3434) = (2*KNO3AL*8.5)
  RCONST(3435) = (4.28D-11)
  RCONST(3436) = (j('i_c3h7cho')*2)
  RCONST(3437) = (KRO2HO2*0.859)
  RCONST(3438) = (KRO2NO*0.173)
  RCONST(3439) = (KRO2NO*0.827)
  RCONST(3440) = (KRO2NO3)
  RCONST(3441) = (8.80D-13*RO2*0.2)
  RCONST(3442) = (8.80D-13*RO2*0.6)
  RCONST(3443) = (8.80D-13*RO2*0.2)
  RCONST(3444) = (KRO2HO2*0.820)
  RCONST(3445) = (KRO2NO)
  RCONST(3446) = (KRO2NO3)
  RCONST(3447) = (8.80D-13*RO2*0.2)
  RCONST(3448) = (8.80D-13*RO2*0.2)
  RCONST(3449) = (8.80D-13*RO2*0.6)
  RCONST(3450) = (2.08D-12)
  RCONST(3451) = (2.86D-13)
  RCONST(3452) = (KRO2HO2*0.859)
  RCONST(3453) = (KRO2NO)
  RCONST(3454) = (KRO2NO3)
  RCONST(3455) = (8.00D-13*RO2*0.70)
  RCONST(3456) = (8.00D-13*RO2*0.30)
  RCONST(3457) = (KRO2HO2*0.859)
  RCONST(3458) = (KRO2NO)
  RCONST(3459) = (KRO2NO3)
  RCONST(3460) = (8.00D-13*RO2*0.70)
  RCONST(3461) = (8.00D-13*RO2*0.30)
  RCONST(3462) = (2.01D-10)
  RCONST(3463) = (2.81D-17)
  RCONST(3464) = (2.05D-10)
  RCONST(3465) = (2.05D-11)
  RCONST(3466) = (j('ch3o2h'))
  RCONST(3467) = (6.03D-12)
  RCONST(3468) = (j('n_c3h7ono2'))
  RCONST(3469) = (KROPRIM*O2)
  RCONST(3470) = (KNO3AL)
  RCONST(3471) = (1.29D-11)
  RCONST(3472) = (j('ch2cch3cho_h'))
  RCONST(3473) = (j('ch2cch3cho_hco'))
  RCONST(3474) = (8.93D-12)
  RCONST(3475) = (7.65D-11)
  RCONST(3476) = (j('ch3o2h'))
  RCONST(3477) = (7.16D-11)
  RCONST(3478) = (j('2_c4h9ono2'))
  RCONST(3479) = (KDEC*0.64)
  RCONST(3480) = (KDEC*0.18)
  RCONST(3481) = (KDEC*0.18)
  RCONST(3482) = (1.12D-10)
  RCONST(3483) = (KAPHO2*0.44)
  RCONST(3484) = (KAPHO2*0.15)
  RCONST(3485) = (KAPHO2*0.41)
  RCONST(3486) = (KAPNO)
  RCONST(3487) = (KFPAN)
  RCONST(3488) = (KRO2NO3*1.74)
  RCONST(3489) = (1.00D-11*RO2*0.70)
  RCONST(3490) = (1.00D-11*RO2*0.30)
  RCONST(3491) = (KRO2HO2*0.859)
  RCONST(3492) = (KRO2NO*0.173)
  RCONST(3493) = (KRO2NO*0.827)
  RCONST(3494) = (KRO2NO3)
  RCONST(3495) = (8.80D-12*RO2*0.2)
  RCONST(3496) = (8.80D-12*RO2*0.6)
  RCONST(3497) = (8.80D-12*RO2*0.2)
  RCONST(3498) = (KRO2HO2*0.820)
  RCONST(3499) = (KRO2NO)
  RCONST(3500) = (KRO2NO3)
  RCONST(3501) = (9.20D-14*RO2*0.70)
  RCONST(3502) = (9.20D-14*RO2*0.30)
  RCONST(3503) = (KRO2HO2*0.859)
  RCONST(3504) = (KRO2NO)
  RCONST(3505) = (KRO2NO3)
  RCONST(3506) = (8.00D-13*RO2*0.70)
  RCONST(3507) = (8.00D-13*RO2*0.30)
  RCONST(3508) = (2.08D-12)
  RCONST(3509) = (2.86D-13)
  RCONST(3510) = (KRO2HO2*0.859)
  RCONST(3511) = (KRO2NO)
  RCONST(3512) = (KRO2NO3)
  RCONST(3513) = (8.00D-13*RO2*0.70)
  RCONST(3514) = (8.00D-13*RO2*0.30)
  RCONST(3515) = (2.01D-10)
  RCONST(3516) = (2.81D-17)
  RCONST(3517) = (2.05D-10)
  RCONST(3518) = (2.17D-11)
  RCONST(3519) = (j('ch3o2h'))
  RCONST(3520) = (KROPRIM*O2)
  RCONST(3521) = (7.18D-12)
  RCONST(3522) = (j('n_c3h7ono2'))
  RCONST(3523) = (1.01D-11)
  RCONST(3524) = (KNO3AL)
  RCONST(3525) = (2.08D-11)
  RCONST(3526) = (j('i_c3h7cho'))
  RCONST(3527) = (2.08D-12)
  RCONST(3528) = (2.86D-13)
  RCONST(3529) = (KRO2HO2*0.859)
  RCONST(3530) = (KRO2NO)
  RCONST(3531) = (KRO2NO3)
  RCONST(3532) = (8.00D-13*RO2*0.70)
  RCONST(3533) = (8.00D-13*RO2*0.30)
  RCONST(3534) = (KRO2HO2*0.859)
  RCONST(3535) = (KRO2NO)
  RCONST(3536) = (KRO2NO3)
  RCONST(3537) = (8.00D-13*RO2*0.70)
  RCONST(3538) = (8.00D-13*RO2*0.30)
  RCONST(3539) = (2.01D-10*1.0)
  RCONST(3540) = (2.81D-17)
  RCONST(3541) = (2.05D-10*1.0)
  RCONST(3542) = (9.75D-11)
  RCONST(3543) = (j('ch3o2h'))
  RCONST(3544) = (KDEC*0.2)
  RCONST(3545) = (KDEC*0.3)
  RCONST(3546) = (KDEC*0.3)
  RCONST(3547) = (KDEC*0.2)
  RCONST(3548) = (7.28D-11)
  RCONST(3549) = (j('1_c4h9ono2'))
  RCONST(3550) = (1.21D-10)
  RCONST(3551) = (8.11D-11)
  RCONST(3552) = (j('mek'))
  RCONST(3553) = (KAPHO2*0.44)
  RCONST(3554) = (KAPHO2*0.15)
  RCONST(3555) = (KAPHO2*0.41)
  RCONST(3556) = (KAPNO)
  RCONST(3557) = (KFPAN)
  RCONST(3558) = (KRO2NO3*1.74)
  RCONST(3559) = (1.00D-11*RO2*0.70)
  RCONST(3560) = (1.00D-11*RO2*0.30)
  RCONST(3561) = (KDEC*0.125)
  RCONST(3562) = (KDEC*0.57)
  RCONST(3563) = (KDEC*0.125)
  RCONST(3564) = (KDEC*0.18)
  RCONST(3565) = (KRO2HO2*0.859)
  RCONST(3566) = (KRO2NO*0.173)
  RCONST(3567) = (KRO2NO*0.827)
  RCONST(3568) = (KRO2NO3)
  RCONST(3569) = (8.80D-13*RO2*0.20)
  RCONST(3570) = (8.80D-13*RO2*0.60)
  RCONST(3571) = (8.80D-13*RO2*0.20)
  RCONST(3572) = (KRO2HO2*0.820)
  RCONST(3573) = (KRO2NO)
  RCONST(3574) = (KRO2NO3)
  RCONST(3575) = (8.80D-13*RO2*0.60)
  RCONST(3576) = (8.80D-13*RO2*0.20)
  RCONST(3577) = (8.80D-13*RO2*0.20)
  RCONST(3578) = (2.05D-11)
  RCONST(3579) = (j('ch3o2h'))
  RCONST(3580) = (6.03D-12)
  RCONST(3581) = (j('1_c4h9ono2'))
  RCONST(3582) = (KROSEC*O2)
  RCONST(3583) = (8.93D-12)
  RCONST(3584) = (6.00D-12)
  RCONST(3585) = (j('mek'))
  RCONST(3586) = (KRO2HO2*0.90)
  RCONST(3587) = (KRO2NO)
  RCONST(3588) = (KRO2NO3)
  RCONST(3589) = (8.00D-13*RO2*0.70)
  RCONST(3590) = (8.00D-13*RO2*0.30)
  RCONST(3591) = (2.08D-12)
  RCONST(3592) = (2.86D-13)
  RCONST(3593) = (KRO2HO2*0.90)
  RCONST(3594) = (KRO2NO)
  RCONST(3595) = (KRO2NO3)
  RCONST(3596) = (8.00D-13*RO2*0.70)
  RCONST(3597) = (8.00D-13*RO2*0.30)
  RCONST(3598) = (2.01D-10*1.0)
  RCONST(3599) = (2.81D-17)
  RCONST(3600) = (2.05D-10*1.0)
  RCONST(3601) = (9.90D-11)
  RCONST(3602) = (j('ch3o2h'))
  RCONST(3603) = (KDEC*0.2)
  RCONST(3604) = (KDEC*0.3)
  RCONST(3605) = (KDEC*0.2)
  RCONST(3606) = (KDEC*0.3)
  RCONST(3607) = (7.42D-11)
  RCONST(3608) = (j('1_c4h9ono2'))
  RCONST(3609) = (1.22D-10)
  RCONST(3610) = (8.25D-11)
  RCONST(3611) = (j('mek'))
  RCONST(3612) = (KAPHO2*0.44)
  RCONST(3613) = (KAPHO2*0.15)
  RCONST(3614) = (KAPHO2*0.41)
  RCONST(3615) = (KAPNO)
  RCONST(3616) = (KFPAN)
  RCONST(3617) = (KRO2NO3*1.74)
  RCONST(3618) = (1.00D-11*RO2*0.70)
  RCONST(3619) = (1.00D-11*RO2*0.30)
  RCONST(3620) = (KDEC*0.34)
  RCONST(3621) = (KDEC*0.08)
  RCONST(3622) = (KDEC*0.34)
  RCONST(3623) = (KDEC*0.24)
  RCONST(3624) = (KRO2HO2*0.890)
  RCONST(3625) = (KRO2NO*0.197)
  RCONST(3626) = (KRO2NO*0.803)
  RCONST(3627) = (KRO2NO3)
  RCONST(3628) = (8.80D-13*RO2*0.20)
  RCONST(3629) = (8.80D-13*RO2*0.60)
  RCONST(3630) = (8.80D-13*RO2*0.20)
  RCONST(3631) = (KRO2HO2*0.859)
  RCONST(3632) = (KRO2NO)
  RCONST(3633) = (KRO2NO3)
  RCONST(3634) = (8.80D-13*RO2*0.60)
  RCONST(3635) = (8.80D-13*RO2*0.20)
  RCONST(3636) = (8.80D-13*RO2*0.20)
  RCONST(3637) = (2.05D-11)
  RCONST(3638) = (j('ch3o2h'))
  RCONST(3639) = (6.03D-12)
  RCONST(3640) = (j('2_c4h9ono2'))
  RCONST(3641) = (KDEC)
  RCONST(3642) = (8.93D-12)
  RCONST(3643) = (2.08D-12)
  RCONST(3644) = (2.86D-13)
  RCONST(3645) = (KRO2HO2*0.90)
  RCONST(3646) = (KRO2NO)
  RCONST(3647) = (KRO2NO3)
  RCONST(3648) = (8.00D-13*RO2*0.70)
  RCONST(3649) = (8.00D-13*RO2*0.30)
  RCONST(3650) = (KRO2HO2*0.90)
  RCONST(3651) = (KRO2NO)
  RCONST(3652) = (KRO2NO3)
  RCONST(3653) = (8.00D-13*RO2*0.70)
  RCONST(3654) = (8.00D-13*RO2*0.30)
  RCONST(3655) = (2.01D-10*1.0)
  RCONST(3656) = (2.81D-17)
  RCONST(3657) = (2.05D-10*1.0)
  RCONST(3658) = (9.90D-11)
  RCONST(3659) = (j('ch3o2h'))
  RCONST(3660) = (KDEC*0.2)
  RCONST(3661) = (KDEC*0.3)
  RCONST(3662) = (KDEC*0.3)
  RCONST(3663) = (KDEC*0.2)
  RCONST(3664) = (7.42D-11)
  RCONST(3665) = (j('1_c4h9ono2'))
  RCONST(3666) = (1.22D-10)
  RCONST(3667) = (8.25D-11)
  RCONST(3668) = (j('mek'))
  RCONST(3669) = (KAPHO2*0.44)
  RCONST(3670) = (KAPHO2*0.15)
  RCONST(3671) = (KAPHO2*0.41)
  RCONST(3672) = (KAPNO)
  RCONST(3673) = (KFPAN)
  RCONST(3674) = (KRO2NO3*1.74)
  RCONST(3675) = (1.00D-11*RO2*0.70)
  RCONST(3676) = (1.00D-11*RO2*0.30)
  RCONST(3677) = (KDEC*0.18)
  RCONST(3678) = (KDEC*0.125)
  RCONST(3679) = (KDEC*0.57)
  RCONST(3680) = (KDEC*0.125)
  RCONST(3681) = (KRO2HO2*0.890)
  RCONST(3682) = (KRO2NO*0.197)
  RCONST(3683) = (KRO2NO*0.803)
  RCONST(3684) = (KRO2NO3)
  RCONST(3685) = (8.80D-13*RO2*0.20)
  RCONST(3686) = (8.80D-13*RO2*0.60)
  RCONST(3687) = (8.80D-13*RO2*0.20)
  RCONST(3688) = (KRO2HO2*0.859)
  RCONST(3689) = (KRO2NO)
  RCONST(3690) = (KRO2NO3)
  RCONST(3691) = (8.80D-13*RO2*0.60)
  RCONST(3692) = (8.80D-13*RO2*0.20)
  RCONST(3693) = (8.80D-13*RO2*0.20)
  RCONST(3694) = (1.17D-11)
  RCONST(3695) = (j('ch3o2h'))
  RCONST(3696) = (6.03D-12)
  RCONST(3697) = (j('n_c3h7ono2'))
  RCONST(3698) = (KROPRIM*O2)
  RCONST(3699) = (KNO3AL)
  RCONST(3700) = (1.29D-11)
  RCONST(3701) = (j('ch2cch3cho_h'))
  RCONST(3702) = (j('ch2cch3cho_hco'))
  RCONST(3703) = (3.68D-12)
  RCONST(3704) = (KRO2HO2*0.90)
  RCONST(3705) = (KRO2NO)
  RCONST(3706) = (KRO2NO3)
  RCONST(3707) = (8.00D-13*RO2*0.70)
  RCONST(3708) = (8.00D-13*RO2*0.30)
  RCONST(3709) = (2.08D-12)
  RCONST(3710) = (2.86D-13)
  RCONST(3711) = (KRO2HO2*0.90)
  RCONST(3712) = (KRO2NO)
  RCONST(3713) = (KRO2NO3)
  RCONST(3714) = (8.00D-13*RO2*0.70)
  RCONST(3715) = (8.00D-13*RO2*0.30)
  RCONST(3716) = (2.01D-10)
  RCONST(3717) = (2.81D-17)
  RCONST(3718) = (2.05D-10)
  RCONST(3719) = (8.83D-11)
  RCONST(3720) = (j('ch3o2h'))
  RCONST(3721) = (6.51D-11)
  RCONST(3722) = (j('1_c4h9ono2'))
  RCONST(3723) = (KDEC*0.32)
  RCONST(3724) = (KDEC*0.05)
  RCONST(3725) = (KDEC*0.13)
  RCONST(3726) = (KDEC*0.32)
  RCONST(3727) = (KDEC*0.13)
  RCONST(3728) = (KDEC*0.05)
  RCONST(3729) = (1.12D-10)
  RCONST(3730) = (5.86D-11)
  RCONST(3731) = (j('mek'))
  RCONST(3732) = (KNO3AL*8.5)
  RCONST(3733) = (2.22D-11)
  RCONST(3734) = (j('mek'))
  RCONST(3735) = (j('i_c3h7cho'))
  RCONST(3736) = (KRO2HO2*0.890)
  RCONST(3737) = (KRO2NO*0.941)
  RCONST(3738) = (KRO2NO*0.059)
  RCONST(3739) = (KRO2NO3)
  RCONST(3740) = (8.80D-13*RO2*0.20)
  RCONST(3741) = (8.80D-13*RO2*0.60)
  RCONST(3742) = (8.80D-13*RO2*0.20)
  RCONST(3743) = (1.17D-11)
  RCONST(3744) = (j('ch3o2h'))
  RCONST(3745) = (6.03D-12)
  RCONST(3746) = (j('n_c3h7ono2'))
  RCONST(3747) = (KROPRIM*O2)
  RCONST(3748) = (KNO3AL)
  RCONST(3749) = (1.29D-11)
  RCONST(3750) = (j('ch2cch3cho_h'))
  RCONST(3751) = (j('ch2cch3cho_hco'))
  RCONST(3752) = (3.68D-12)
  RCONST(3753) = (7.48D-11)
  RCONST(3754) = (j('ch3o2h'))
  RCONST(3755) = (7.14D-11)
  RCONST(3756) = (j('2_c4h9ono2'))
  RCONST(3757) = (KDEC*0.292)
  RCONST(3758) = (KDEC*0.084)
  RCONST(3759) = (KDEC*0.118)
  RCONST(3760) = (KDEC*0.211)
  RCONST(3761) = (KDEC*0.084)
  RCONST(3762) = (KDEC*0.211)
  RCONST(3763) = (1.10D-10)
  RCONST(3764) = (KRO2HO2*0.90)
  RCONST(3765) = (KRO2NO)
  RCONST(3766) = (KRO2NO3)
  RCONST(3767) = (8.00D-13*RO2*0.70)
  RCONST(3768) = (8.00D-13*RO2*0.30)
  RCONST(3769) = (2.08D-12)
  RCONST(3770) = (2.86D-13)
  RCONST(3771) = (KRO2HO2*0.90)
  RCONST(3772) = (KRO2NO)
  RCONST(3773) = (KRO2NO3)
  RCONST(3774) = (8.00D-13*RO2*0.70)
  RCONST(3775) = (8.00D-13*RO2*0.30)
  RCONST(3776) = (2.01D-10)
  RCONST(3777) = (2.81D-17)
  RCONST(3778) = (2.05D-10)
  RCONST(3779) = (KAPHO2*0.44)
  RCONST(3780) = (KAPHO2*0.15)
  RCONST(3781) = (KAPHO2*0.41)
  RCONST(3782) = (KAPNO)
  RCONST(3783) = (KFPAN)
  RCONST(3784) = (KRO2NO3*1.74)
  RCONST(3785) = (1.00D-11*RO2*0.70)
  RCONST(3786) = (1.00D-11*RO2*0.30)
  RCONST(3787) = (KRO2HO2*0.890)
  RCONST(3788) = (KRO2NO*0.941)
  RCONST(3789) = (KRO2NO*0.059)
  RCONST(3790) = (KRO2NO3)
  RCONST(3791) = (8.80D-13*RO2*0.20)
  RCONST(3792) = (8.80D-13*RO2*0.60)
  RCONST(3793) = (8.80D-13*RO2*0.20)
  RCONST(3794) = (KRO2HO2*0.859)
  RCONST(3795) = (KRO2NO)
  RCONST(3796) = (KRO2NO3)
  RCONST(3797) = (9.20D-14*RO2*0.70)
  RCONST(3798) = (9.20D-14*RO2*0.30)
  RCONST(3799) = (2.05D-11)
  RCONST(3800) = (j('ch3o2h'))
  RCONST(3801) = (6.03D-12)
  RCONST(3802) = (j('n_c3h7ono2'))
  RCONST(3803) = (KROPRIM*O2)
  RCONST(3804) = (KNO3AL)
  RCONST(3805) = (1.29D-11)
  RCONST(3806) = (j('ch2cch3cho_h'))
  RCONST(3807) = (j('ch2cch3cho_hco'))
  RCONST(3808) = (8.93D-12)
  RCONST(3809) = (1.28D-10)
  RCONST(3810) = (j('ch3o2h'))
  RCONST(3811) = (9.45D-11)
  RCONST(3812) = (j('1_c4h9ono2'))
  RCONST(3813) = (KDEC*0.50)
  RCONST(3814) = (KDEC*0.50)
  RCONST(3815) = (1.55D-10)
  RCONST(3816) = (1.00D-10)
  RCONST(3817) = (j('mek'))
  RCONST(3818) = (KRO2HO2*0.890)
  RCONST(3819) = (KRO2NO)
  RCONST(3820) = (KRO2NO3)
  RCONST(3821) = (8.00D-13*RO2*0.70)
  RCONST(3822) = (8.00D-13*RO2*0.30)
  RCONST(3823) = (1.00D-13)
  RCONST(3824) = (KRO2HO2*0.890)
  RCONST(3825) = (KRO2NO)
  RCONST(3826) = (KRO2NO3)
  RCONST(3827) = (8.00D-13*RO2*0.70)
  RCONST(3828) = (8.00D-13*RO2*0.30)
  RCONST(3829) = (KAPHO2*0.44)
  RCONST(3830) = (KAPHO2*0.15)
  RCONST(3831) = (KAPHO2*0.41)
  RCONST(3832) = (KAPNO)
  RCONST(3833) = (KFPAN)
  RCONST(3834) = (KRO2NO3*1.74)
  RCONST(3835) = (1.00D-11*RO2*0.70)
  RCONST(3836) = (1.00D-11*RO2*0.30)
  RCONST(3837) = (KNO3AL*8.5)
  RCONST(3838) = (2.22D-11)
  RCONST(3839) = (j('mek'))
  RCONST(3840) = (j('i_c3h7cho'))
  RCONST(3841) = (KDEC*0.89)
  RCONST(3842) = (KDEC*0.11)
  RCONST(3843) = (KRO2HO2*0.890)
  RCONST(3844) = (KRO2NO*0.941)
  RCONST(3845) = (KRO2NO*0.059)
  RCONST(3846) = (KRO2NO3)
  RCONST(3847) = (9.20D-14*RO2*0.70)
  RCONST(3848) = (9.20D-14*RO2*0.30)
  RCONST(3849) = (KRO2HO2*0.859)
  RCONST(3850) = (KRO2NO)
  RCONST(3851) = (KRO2NO3)
  RCONST(3852) = (8.80D-11*RO2*0.60)
  RCONST(3853) = (8.80D-11*RO2*0.20)
  RCONST(3854) = (8.80D-11*RO2*0.20)
  RCONST(3855) = (2.05D-11)
  RCONST(3856) = (j('ch3o2h'))
  RCONST(3857) = (6.03D-12)
  RCONST(3858) = (j('1_c4h9ono2'))
  RCONST(3859) = (KROSEC*O2)
  RCONST(3860) = (8.93D-12)
  RCONST(3861) = (6.00D-12)
  RCONST(3862) = (j('mek'))
  RCONST(3863) = (7.73D-11)
  RCONST(3864) = (j('ch3o2h'))
  RCONST(3865) = (7.31D-11)
  RCONST(3866) = (j('2_c4h9ono2'))
  RCONST(3867) = (KDEC*0.167)
  RCONST(3868) = (KDEC*0.166)
  RCONST(3869) = (KDEC*0.167)
  RCONST(3870) = (KDEC*0.166)
  RCONST(3871) = (KDEC*0.167)
  RCONST(3872) = (KDEC*0.167)
  RCONST(3873) = (1.12D-10)
  RCONST(3874) = (KAPHO2*0.44)
  RCONST(3875) = (KAPHO2*0.15)
  RCONST(3876) = (KAPHO2*0.41)
  RCONST(3877) = (KAPNO)
  RCONST(3878) = (KFPAN)
  RCONST(3879) = (KRO2NO3*1.74)
  RCONST(3880) = (1.00D-11*RO2*0.70)
  RCONST(3881) = (1.00D-11*RO2*0.30)
  RCONST(3882) = (2*KNO3AL*8.5)
  RCONST(3883) = (4.57D-11)
  RCONST(3884) = (j('i_c3h7cho')*2)
  RCONST(3885) = (KRO2HO2*0.890)
  RCONST(3886) = (KRO2NO*0.196)
  RCONST(3887) = (KRO2NO*0.804)
  RCONST(3888) = (KRO2NO3)
  RCONST(3889) = (8.80D-12*RO2*0.20)
  RCONST(3890) = (8.80D-12*RO2*0.60)
  RCONST(3891) = (8.80D-12*RO2*0.20)
  RCONST(3892) = (KRO2HO2*0.859)
  RCONST(3893) = (KRO2NO)
  RCONST(3894) = (KRO2NO3)
  RCONST(3895) = (9.20D-14*RO2*0.70)
  RCONST(3896) = (9.20D-14*RO2*0.30)
  RCONST(3897) = (KRO2HO2*0.90)
  RCONST(3898) = (KRO2NO)
  RCONST(3899) = (KRO2NO3)
  RCONST(3900) = (8.00D-13*RO2*0.70)
  RCONST(3901) = (8.00D-13*RO2*0.30)
  RCONST(3902) = (2.08D-12)
  RCONST(3903) = (2.86D-13)
  RCONST(3904) = (KRO2HO2*0.90)
  RCONST(3905) = (KRO2NO)
  RCONST(3906) = (KRO2NO3)
  RCONST(3907) = (8.00D-13*RO2*0.70)
  RCONST(3908) = (8.00D-13*RO2*0.30)
  RCONST(3909) = (2.01D-10)
  RCONST(3910) = (2.81D-17)
  RCONST(3911) = (2.05D-10)
  RCONST(3912) = (9.58D-11)
  RCONST(3913) = (j('ch3o2h'))
  RCONST(3914) = (7.27D-11)
  RCONST(3915) = (j('2_c4h9ono2'))
  RCONST(3916) = (KDEC*0.167)
  RCONST(3917) = (KDEC*0.166)
  RCONST(3918) = (KDEC*0.25)
  RCONST(3919) = (KDEC*0.25)
  RCONST(3920) = (KDEC*0.167)
  RCONST(3921) = (1.19D-10)
  RCONST(3922) = (8.27D-11)
  RCONST(3923) = (j('mek'))
  RCONST(3924) = (KAPHO2*0.44)
  RCONST(3925) = (KAPHO2*0.15)
  RCONST(3926) = (KAPHO2*0.41)
  RCONST(3927) = (KAPNO)
  RCONST(3928) = (KFPAN)
  RCONST(3929) = (KRO2NO3*1.74)
  RCONST(3930) = (1.00D-11*RO2*0.70)
  RCONST(3931) = (1.00D-11*RO2*0.30)
  RCONST(3932) = (KRO2HO2*0.890)
  RCONST(3933) = (KRO2NO*0.196)
  RCONST(3934) = (KRO2NO*0.804)
  RCONST(3935) = (KRO2NO3)
  RCONST(3936) = (8.80D-12*RO2*0.20)
  RCONST(3937) = (8.80D-12*RO2*0.60)
  RCONST(3938) = (8.80D-12*RO2*0.20)
  RCONST(3939) = (KRO2HO2*0.859)
  RCONST(3940) = (KRO2NO)
  RCONST(3941) = (KRO2NO3)
  RCONST(3942) = (8.80D-12*RO2*0.20)
  RCONST(3943) = (8.80D-12*RO2*0.60)
  RCONST(3944) = (8.80D-12*RO2*0.20)
  RCONST(3945) = (2.08D-12)
  RCONST(3946) = (2.86D-13)
  RCONST(3947) = (KRO2HO2*0.90)
  RCONST(3948) = (KRO2NO)
  RCONST(3949) = (KRO2NO3)
  RCONST(3950) = (8.00D-13*RO2*0.70)
  RCONST(3951) = (8.00D-13*RO2*0.30)
  RCONST(3952) = (KRO2HO2*0.90)
  RCONST(3953) = (KRO2NO)
  RCONST(3954) = (KRO2NO3)
  RCONST(3955) = (8.00D-13*RO2*0.70)
  RCONST(3956) = (8.00D-13*RO2*0.30)
  RCONST(3957) = (2.01D-10)
  RCONST(3958) = (2.81D-17)
  RCONST(3959) = (2.05D-10)
  RCONST(3960) = (7.77D-11)
  RCONST(3961) = (j('ch3o2h'))
  RCONST(3962) = (7.27D-11)
  RCONST(3963) = (j('2_c4h9ono2'))
  RCONST(3964) = (KDEC*0.18)
  RCONST(3965) = (KDEC*0.64)
  RCONST(3966) = (KDEC*0.09)
  RCONST(3967) = (KDEC*0.09)
  RCONST(3968) = (1.13D-10)
  RCONST(3969) = (KAPHO2*0.44)
  RCONST(3970) = (KAPHO2*0.15)
  RCONST(3971) = (KAPHO2*0.41)
  RCONST(3972) = (KAPNO)
  RCONST(3973) = (KFPAN)
  RCONST(3974) = (KRO2NO3*1.74)
  RCONST(3975) = (1.00D-11*RO2*0.70)
  RCONST(3976) = (1.00D-11*RO2*0.30)
  RCONST(3977) = (KRO2HO2*0.890)
  RCONST(3978) = (KRO2NO*0.173)
  RCONST(3979) = (KRO2NO*0.827)
  RCONST(3980) = (KRO2NO3)
  RCONST(3981) = (8.80D-12*RO2*0.2)
  RCONST(3982) = (8.80D-12*RO2*0.6)
  RCONST(3983) = (8.80D-12*RO2*0.2)
  RCONST(3984) = (KRO2HO2*0.859)
  RCONST(3985) = (KRO2NO)
  RCONST(3986) = (KRO2NO3)
  RCONST(3987) = (9.20D-14*RO2*0.70)
  RCONST(3988) = (9.20D-14*RO2*0.30)
  RCONST(3989) = (KRO2HO2*0.90)
  RCONST(3990) = (KRO2NO)
  RCONST(3991) = (KRO2NO3)
  RCONST(3992) = (8.00D-13*RO2*0.70)
  RCONST(3993) = (8.00D-13*RO2*0.30)
  RCONST(3994) = (2.08D-12)
  RCONST(3995) = (2.86D-13)
  RCONST(3996) = (KRO2HO2*0.90)
  RCONST(3997) = (KRO2NO)
  RCONST(3998) = (KRO2NO3)
  RCONST(3999) = (8.00D-13*RO2*0.70)
  RCONST(4000) = (8.00D-13*RO2*0.30)
  RCONST(4001) = (2.01D-10)
  RCONST(4002) = (2.81D-17)
  RCONST(4003) = (2.05D-10)
  RCONST(4004) = (2.05D-11)
  RCONST(4005) = (j('ch3o2h'))
  RCONST(4006) = (6.03D-12)
  RCONST(4007) = (j('1_c4h9ono2'))
  RCONST(4008) = (KROSEC*O2)
  RCONST(4009) = (8.93D-12)
  RCONST(4010) = (6.00D-12)
  RCONST(4011) = (j('mek'))
  RCONST(4012) = (1.19D-10)
  RCONST(4013) = (j('ch3o2h'))
  RCONST(4014) = (9.57D-11)
  RCONST(4015) = (j('1_c4h9ono2'))
  RCONST(4016) = (KDEC*0.25)
  RCONST(4017) = (KDEC*0.25)
  RCONST(4018) = (KDEC*0.25)
  RCONST(4019) = (KDEC*0.25)
  RCONST(4020) = (1.56D-10)
  RCONST(4021) = (1.01D-10)
  RCONST(4022) = (j('mek'))
  RCONST(4023) = (KAPHO2*0.44)
  RCONST(4024) = (KAPHO2*0.15)
  RCONST(4025) = (KAPHO2*0.41)
  RCONST(4026) = (KAPNO)
  RCONST(4027) = (KFPAN)
  RCONST(4028) = (KRO2NO3*1.74)
  RCONST(4029) = (1.00D-11*RO2*0.70)
  RCONST(4030) = (1.00D-11*RO2*0.30)
  RCONST(4031) = (KDEC*0.89)
  RCONST(4032) = (KDEC*0.11)
  RCONST(4033) = (KRO2HO2*0.914)
  RCONST(4034) = (KRO2NO*0.937)
  RCONST(4035) = (KRO2NO*0.063)
  RCONST(4036) = (KRO2NO3)
  RCONST(4037) = (9.20D-14*RO2*0.70)
  RCONST(4038) = (9.20D-14*RO2*0.30)
  RCONST(4039) = (KRO2HO2*0.890)
  RCONST(4040) = (KRO2NO)
  RCONST(4041) = (KRO2NO3)
  RCONST(4042) = (8.80D-11*RO2*0.60)
  RCONST(4043) = (8.80D-11*RO2*0.20)
  RCONST(4044) = (8.80D-11*RO2*0.20)
  RCONST(4045) = (1.00D-13)
  RCONST(4046) = (KRO2HO2*0.914)
  RCONST(4047) = (KRO2NO)
  RCONST(4048) = (KRO2NO3)
  RCONST(4049) = (8.00D-13*RO2*0.70)
  RCONST(4050) = (8.00D-13*RO2*0.30)
  RCONST(4051) = (KRO2HO2*0.914)
  RCONST(4052) = (KRO2NO)
  RCONST(4053) = (KRO2NO3)
  RCONST(4054) = (8.00D-13*RO2*0.70)
  RCONST(4055) = (8.00D-13*RO2*0.30)
  RCONST(4056) = (2.05D-11)
  RCONST(4057) = (j('ch3o2h'))
  RCONST(4058) = (6.03D-12)
  RCONST(4059) = (j('1_c4h9ono2'))
  RCONST(4060) = (KROSEC*O2)
  RCONST(4061) = (8.93D-12)
  RCONST(4062) = (6.00D-12)
  RCONST(4063) = (j('mek'))
  RCONST(4064) = (1.00D-13)
  RCONST(4065) = (KRO2HO2*0.932)
  RCONST(4066) = (KRO2NO)
  RCONST(4067) = (KRO2NO3)
  RCONST(4068) = (8.00D-13*RO2*0.70)
  RCONST(4069) = (8.00D-13*RO2*0.30)
  RCONST(4070) = (KRO2HO2*0.932)
  RCONST(4071) = (KRO2NO)
  RCONST(4072) = (KRO2NO3)
  RCONST(4073) = (8.00D-13*RO2*0.70)
  RCONST(4074) = (8.00D-13*RO2*0.30)
  RCONST(4075) = (1.20D-10)
  RCONST(4076) = (j('ch3o2h'))
  RCONST(4077) = (9.67D-11)
  RCONST(4078) = (j('1_c4h9ono2'))
  RCONST(4079) = (KDEC*0.50)
  RCONST(4080) = (KDEC*0.50)
  RCONST(4081) = (1.57D-10)
  RCONST(4082) = (1.03D-10)
  RCONST(4083) = (j('mek'))
  RCONST(4084) = (KAPHO2*0.44)
  RCONST(4085) = (KAPHO2*0.15)
  RCONST(4086) = (KAPHO2*0.41)
  RCONST(4087) = (KAPNO)
  RCONST(4088) = (KFPAN)
  RCONST(4089) = (KRO2NO3*1.74)
  RCONST(4090) = (1.00D-11*RO2*0.70)
  RCONST(4091) = (1.00D-11*RO2*0.30)
  RCONST(4092) = (KNO3AL*8.5)
  RCONST(4093) = (2.55D-11)
  RCONST(4094) = (j('mek'))
  RCONST(4095) = (j('i_c3h7cho'))
  RCONST(4096) = (KRO2HO2*0.932)
  RCONST(4097) = (KRO2NO*0.934)
  RCONST(4098) = (KRO2NO*0.066)
  RCONST(4099) = (KRO2NO3)
  RCONST(4100) = (9.20D-14*RO2*0.70)
  RCONST(4101) = (9.20D-14*RO2*0.30)
  RCONST(4102) = (KRO2HO2*0.914)
  RCONST(4103) = (KRO2NO)
  RCONST(4104) = (KRO2NO3)
  RCONST(4105) = (8.80D-11*RO2*0.60)
  RCONST(4106) = (8.80D-11*RO2*0.20)
  RCONST(4107) = (8.80D-11*RO2*0.20)
  RCONST(4108) = (6.16D-11)
  RCONST(4109) = (KDEC)
  RCONST(4110) = (1.20D-15)
  RCONST(4111) = (1.00D-14)
  RCONST(4112) = (1.00D-15)
  RCONST(4113) = (7.00D-14)
  RCONST(4114) = (6.00D-18*H2O)
  RCONST(4115) = (1.00D-17*H2O)
  RCONST(4116) = (6.16D-11)
  RCONST(4117) = (j('ch3o2h'))
  RCONST(4118) = (KDEC)
  RCONST(4119) = (4.66D-12)
  RCONST(4120) = (j('ch3o2h'))
  RCONST(4121) = (1.10D-12)
  RCONST(4122) = (1.06D-12)
  RCONST(4123) = (KBPAN*0.67)
  RCONST(4124) = (3.60D-12)
  RCONST(4125) = (j('ch3o2h'))
  RCONST(4126) = (j('ch3o2h'))
  RCONST(4127) = (4.87D-11)
  RCONST(4128) = (KROSEC*O2)
  RCONST(4129) = (3.71D-11)
  RCONST(4130) = (j('mvk_mcm_ch2ch'))
  RCONST(4131) = (2.08D-11)
  RCONST(4132) = (j('ch3o2h'))
  RCONST(4133) = (7.78D-11)
  RCONST(4134) = (j('n_c3h7ono2')*2.0)
  RCONST(4135) = (6.04D-11)
  RCONST(4136) = (KROPRIM*O2)
  RCONST(4137) = (j('n_c3h7ono2'))
  RCONST(4138) = (6.39D-11)
  RCONST(4139) = (j('n_c3h7cho_hco'))
  RCONST(4140) = (KNO3AL*2.0)
  RCONST(4141) = (9.60D-18*0.5)
  RCONST(4142) = (9.60D-18*0.5)
  RCONST(4143) = (3.52D-11*0.43)
  RCONST(4144) = (3.52D-11*0.57)
  RCONST(4145) = (1.20D-15)
  RCONST(4146) = (1.00D-14)
  RCONST(4147) = (1.00D-15)
  RCONST(4148) = (7.00D-14)
  RCONST(4149) = (1.00D-17*H2O)
  RCONST(4150) = (6.00D-18*H2O)
  RCONST(4151) = (j('ch3o2h'))
  RCONST(4152) = (8.14D-11)
  RCONST(4153) = (8.40D+10*EXP(-3523/TEMP))
  RCONST(4154) = (7.10D-11)
  RCONST(4155) = (j('ch2cch3cho_h'))
  RCONST(4156) = (j('ch2cch3cho_hco'))
  RCONST(4157) = (KNO3AL*2.4)
  RCONST(4158) = (9.60D-18*0.5)
  RCONST(4159) = (9.60D-18*0.5)
  RCONST(4160) = (3.87D-11*0.43)
  RCONST(4161) = (3.87D-11*0.57)
  RCONST(4162) = (j('ch3o2h'))
  RCONST(4163) = (8.14D-11)
  RCONST(4164) = (3.59D-11)
  RCONST(4165) = (KDEC)
  RCONST(4166) = (4.86D-11)
  RCONST(4167) = (7.51D-16*EXP(-1521/TEMP)*0.5)
  RCONST(4168) = (7.51D-16*EXP(-1521/TEMP)*0.5)
  RCONST(4169) = (4.60D-12*EXP(452/TEMP)*0.3)
  RCONST(4170) = (4.60D-12*EXP(452/TEMP)*0.7)
  RCONST(4171) = (j('mvk_mcm_co'))
  RCONST(4172) = (j('mvk_mcm_ch2ch'))
  RCONST(4173) = (j('ch3o2h'))
  RCONST(4174) = (6.25D-11)
  RCONST(4175) = (KDEC)
  RCONST(4176) = (j('n_c3h7cho_hco'))
  RCONST(4177) = (KNO3AL*4.0)
  RCONST(4178) = (6.14D-11)
  RCONST(4179) = (j('ch3o2h'))
  RCONST(4180) = (1.03D-10)
  RCONST(4181) = (j('n_c3h7ono2')*2.0)
  RCONST(4182) = (8.55D-11)
  RCONST(4183) = (KROPRIM*O2)
  RCONST(4184) = (j('n_c3h7ono2'))
  RCONST(4185) = (4.10D-17*0.50)
  RCONST(4186) = (4.10D-17*0.50)
  RCONST(4187) = (1.12D-10)
  RCONST(4188) = (j('ch3coch2ono2')*16)
  RCONST(4189) = (KNO3AL*4.25)
  RCONST(4190) = (2.40D-17*0.5)
  RCONST(4191) = (2.40D-17*0.5)
  RCONST(4192) = (4.16D-11*0.52)
  RCONST(4193) = (4.16D-11*0.48)
  RCONST(4194) = (KDEC*0.20)
  RCONST(4195) = (KDEC*0.20)
  RCONST(4196) = (KDEC*0.24)
  RCONST(4197) = (KDEC*0.36)
  RCONST(4198) = (KRO2HO2*0.625)
  RCONST(4199) = (KRO2NO*0.017)
  RCONST(4200) = (KRO2NO*0.983)
  RCONST(4201) = (KRO2NO3)
  RCONST(4202) = (2.00D-12*0.2*RO2)
  RCONST(4203) = (2.00D-12*0.6*RO2)
  RCONST(4204) = (2.00D-12*0.2*RO2)
  RCONST(4205) = (KRO2NO*0.043)
  RCONST(4206) = (KRO2HO2*0.625)
  RCONST(4207) = (KRO2NO*0.957)
  RCONST(4208) = (KRO2NO3)
  RCONST(4209) = (8.80D-13*0.2*RO2)
  RCONST(4210) = (8.80D-13*0.6*RO2)
  RCONST(4211) = (8.80D-13*0.2*RO2)
  RCONST(4212) = (1.2D-15)
  RCONST(4213) = (1.0D-14)
  RCONST(4214) = (1.0D-15)
  RCONST(4215) = (7.0D-14)
  RCONST(4216) = (1.0D-17*H2O)
  RCONST(4217) = (6.0D-18*H2O)
  RCONST(4218) = (1.2D-15)
  RCONST(4219) = (1.0D-14)
  RCONST(4220) = (1.0D-15)
  RCONST(4221) = (7.0D-14)
  RCONST(4222) = (6.0D-18*H2O)
  RCONST(4223) = (KRO2HO2*0.625)
  RCONST(4224) = (KRO2NO)
  RCONST(4225) = (KRO2NO3)
  RCONST(4226) = (2.00D-12*0.6*RO2)
  RCONST(4227) = (2.00D-12*0.2*RO2)
  RCONST(4228) = (2.00D-12*0.2*RO2)
  RCONST(4229) = (KRO2HO2*0.706)
  RCONST(4230) = (KRO2NO*0.894)
  RCONST(4231) = (KRO2NO*0.106)
  RCONST(4232) = (KRO2NO3)
  RCONST(4233) = (K16ISOM1*0.5)
  RCONST(4234) = (K16ISOM1*0.5)
  RCONST(4235) = (8.00D14*EXP(-10050/TEMP))
  RCONST(4236) = (2.40D-12*0.8*RO2)
  RCONST(4237) = (2.40D-12*0.1*RO2)
  RCONST(4238) = (2.40D-12*0.1*RO2)
  RCONST(4239) = (KRO2HO2*0.706)
  RCONST(4240) = (KRO2NO*0.070)
  RCONST(4241) = (KRO2NO*0.930)
  RCONST(4242) = (KRO2NO3)
  RCONST(4243) = (1.70D15*EXP(-11030/TEMP))
  RCONST(4244) = (8.00D-13*0.8*RO2)
  RCONST(4245) = (8.00D-13*0.2*RO2)
  RCONST(4246) = (K15ISOM1)
  RCONST(4247) = (1.70D15*EXP(-11030/TEMP))
  RCONST(4248) = (KRO2HO2*0.706)
  RCONST(4249) = (KRO2NO*0.894)
  RCONST(4250) = (KRO2NO*0.106)
  RCONST(4251) = (KRO2NO3)
  RCONST(4252) = (K16ISOM1*0.5)
  RCONST(4253) = (K16ISOM1*0.5)
  RCONST(4254) = (8.00D14*EXP(-10050/TEMP))
  RCONST(4255) = (2.40D-12*0.8*RO2)
  RCONST(4256) = (2.40D-12*0.1*RO2)
  RCONST(4257) = (2.40D-12*0.1*RO2)
  RCONST(4258) = (KRO2HO2*0.706)
  RCONST(4259) = (KRO2NO*0.140)
  RCONST(4260) = (KRO2NO*0.860)
  RCONST(4261) = (KRO2NO3)
  RCONST(4262) = (2.10D15*EXP(-11640/TEMP))
  RCONST(4263) = (2.90D-12*0.1*RO2)
  RCONST(4264) = (2.90D-12*0.8*RO2)
  RCONST(4265) = (2.90D-12*0.1*RO2)
  RCONST(4266) = (K15ISOM1)
  RCONST(4267) = (2.10D15*EXP(-11640/TEMP))
  RCONST(4268) = (9.73D-11)
  RCONST(4269) = (j('ch3o2h'))
  RCONST(4270) = (8.77D-11)
  RCONST(4271) = (2.52D-17*0.50)
  RCONST(4272) = (2.52D-17*0.50)
  RCONST(4273) = (KDEC)
  RCONST(4274) = (1.04D-10*0.829)
  RCONST(4275) = (1.04D-10*0.171)
  RCONST(4276) = (j('n_c3h7cho_hco'))
  RCONST(4277) = (7.38D-11)
  RCONST(4278) = (KRO2HO2*0.706)
  RCONST(4279) = (KRO2NO)
  RCONST(4280) = (KRO2NO3)
  RCONST(4281) = (9.20D-14*RO2)
  RCONST(4282) = (KDEC*0.82)
  RCONST(4283) = (KDEC*0.18)
  RCONST(4284) = (KRO2HO2*0.706)
  RCONST(4285) = (KRO2NO*0.020)
  RCONST(4286) = (KRO2NO*0.980)
  RCONST(4287) = (KRO2NO3)
  RCONST(4288) = (9.20D-14*RO2)
  RCONST(4289) = (KAPHO2*0.44)
  RCONST(4290) = (KAPHO2*0.56)
  RCONST(4291) = (KAPNO)
  RCONST(4292) = (KFPAN)
  RCONST(4293) = (KRO2NO3*1.6)
  RCONST(4294) = (1.00D-11*RO2)
  RCONST(4295) = (KRO2HO2*0.625)
  RCONST(4296) = (KRO2NO*0.024)
  RCONST(4297) = (KRO2NO*0.976)
  RCONST(4298) = (KRO2NO3)
  RCONST(4299) = (1.30D-12*RO2)
  RCONST(4300) = (KRO2HO2*0.706)
  RCONST(4301) = (KRO2NO)
  RCONST(4302) = (KRO2NO3)
  RCONST(4303) = (8.80D-13*RO2)
  RCONST(4304) = (KDEC*0.36)
  RCONST(4305) = (KDEC*0.2)
  RCONST(4306) = (KDEC*0.2)
  RCONST(4307) = (KDEC*0.24)
  RCONST(4308) = (KRO2HO2*0.706)
  RCONST(4309) = (KRO2NO*0.065)
  RCONST(4310) = (KRO2NO*0.935)
  RCONST(4311) = (KRO2NO3)
  RCONST(4312) = (8.40D-13*0.6*RO2)
  RCONST(4313) = (8.40D-13*0.2*RO2)
  RCONST(4314) = (8.40D-13*0.2*RO2)
  RCONST(4315) = (KRO2HO2*0.520)
  RCONST(4316) = (KRO2NO*0.024)
  RCONST(4317) = (KRO2NO*0.976)
  RCONST(4318) = (KRO2NO3)
  RCONST(4319) = (1.30D-12*0.2*RO2)
  RCONST(4320) = (1.30D-12*0.2*RO2)
  RCONST(4321) = (1.30D-12*0.6*RO2)
  RCONST(4322) = (KRO2HO2*0.706)
  RCONST(4323) = (KRO2NO*0.106)
  RCONST(4324) = (KRO2NO*0.894)
  RCONST(4325) = (KRO2NO3)
  RCONST(4326) = (2.40D-12*0.1*RO2)
  RCONST(4327) = (2.40D-12*0.8*RO2)
  RCONST(4328) = (2.40D-12*0.1*RO2)
  RCONST(4329) = (5.00D13*EXP(-9510/TEMP))
  RCONST(4330) = (KRO2HO2*0.706)
  RCONST(4331) = (KRO2NO*0.106)
  RCONST(4332) = (KRO2NO*0.894)
  RCONST(4333) = (KRO2NO3)
  RCONST(4334) = (2.00D-12*0.1*RO2)
  RCONST(4335) = (2.00D-12*0.1*RO2)
  RCONST(4336) = (2.00D-12*0.8*RO2)
  RCONST(4337) = (5.00D13*EXP(-9510/TEMP))
  RCONST(4338) = (7.10D-11)
  RCONST(4339) = (j('ch3o2h'))
  RCONST(4340) = (9.39D-13*EXP(-461/TEMP)*0.450)
  RCONST(4341) = (9.39D-13*EXP(-461/TEMP)*0.550)
  RCONST(4342) = (1.80D-12)
  RCONST(4343) = (j('n_c3h7ono2'))
  RCONST(4344) = (KROPRIM*O2)
  RCONST(4345) = (1.83D-11)
  RCONST(4346) = (1.54D-10)
  RCONST(4347) = (j('ch3o2h'))
  RCONST(4348) = (6.92D-19*TEMP**2*EXP(986/TEMP)*0.095)
  RCONST(4349) = (6.92D-19*TEMP**2*EXP(986/TEMP)*0.057)
  RCONST(4350) = (6.92D-19*TEMP**2*EXP(986/TEMP)*0.848)
  RCONST(4351) = (7.74D-12)
  RCONST(4352) = (j('1_c4h9ono2'))
  RCONST(4353) = (KDEC)
  RCONST(4354) = (6.35D-11)
  RCONST(4355) = (3.48D-11)
  RCONST(4356) = (j('ch3o2h'))
  RCONST(4357) = (8.20D-12)
  RCONST(4358) = (j('n_c3h7ono2'))
  RCONST(4359) = (KDEC)
  RCONST(4360) = (2.80D-15*0.5)
  RCONST(4361) = (2.80D-15*0.5)
  RCONST(4362) = (1.80D-11*0.399)
  RCONST(4363) = (1.80D-11*0.333)
  RCONST(4364) = (1.80D-11*0.268)
  RCONST(4365) = (KNO3AL*4.0)
  RCONST(4366) = (3.00D-11)
  RCONST(4367) = (j('n_c3h7cho_hco'))
  RCONST(4368) = (KDEC)
  RCONST(4369) = (1.90D-12*EXP(190/TEMP))
  RCONST(4370) = (8.39D-12)
  RCONST(4371) = (j('mek'))
  RCONST(4372) = (j('ch3o2h'))
  RCONST(4373) = (4.88D-11)
  RCONST(4374) = (1.90D-12*EXP(190/TEMP))
  RCONST(4375) = (j('ch3o2h')+j('mek'))
  RCONST(4376) = (9.64D-13)
  RCONST(4377) = (j('n_c3h7ono2')+j('mek'))
  RCONST(4378) = (KROPRIM*O2)
  RCONST(4379) = (1.30D+11*EXP(-4127/TEMP))
  RCONST(4380) = (1.88D-11)
  RCONST(4381) = (1.90D-12*EXP(190/TEMP))
  RCONST(4382) = (j('mek'))
  RCONST(4383) = (j('ch3o2h'))
  RCONST(4384) = (KDEC)
  RCONST(4385) = (j('biacet'))
  RCONST(4386) = (1.40D-18*TEMP**2*EXP(194/TEMP))
  RCONST(4387) = (9.55D-12)
  RCONST(4388) = (1.90D-12*EXP(190/TEMP))
  RCONST(4389) = (j('mek'))
  RCONST(4390) = (j('ch3o2h'))
  RCONST(4391) = (KDEC)
  RCONST(4392) = (j('ch3cocho'))
  RCONST(4393) = (KNO3AL*4.0)
  RCONST(4394) = (1.39D-11)
  RCONST(4395) = (1.06D-10)
  RCONST(4396) = (1.90D-12*EXP(190/TEMP))
  RCONST(4397) = (j('ch3o2h'))
  RCONST(4398) = (j('mek'))
  RCONST(4399) = (1.30D+11*EXP(-4127/TEMP))
  RCONST(4400) = (1.79D-12)
  RCONST(4401) = (j('1_c4h9ono2')+j('mek'))
  RCONST(4402) = (7.02D-13)
  RCONST(4403) = (j('mek'))
  RCONST(4404) = (2.99D-11)
  RCONST(4405) = (j('mek'))
  RCONST(4406) = (1.06D-10)
  RCONST(4407) = (1.90D-12*EXP(190/TEMP))
  RCONST(4408) = (j('mek'))
  RCONST(4409) = (j('ch3o2h'))
  RCONST(4410) = (KDEC)
  RCONST(4411) = (1.38D-12)
  RCONST(4412) = (j('biacet'))
  RCONST(4413) = (2.00D-11)
  RCONST(4414) = (1.90D-12*EXP(190/TEMP))
  RCONST(4415) = (j('mek'))
  RCONST(4416) = (j('ch3o2h'))
  RCONST(4417) = (KDEC)
  RCONST(4418) = (5.36D-11)
  RCONST(4419) = (1.90D-12*EXP(190/TEMP))
  RCONST(4420) = (j('ch3o2h')+j('mek'))
  RCONST(4421) = (2.13D-12)
  RCONST(4422) = (j('mek')+j('n_c3h7ono2'))
  RCONST(4423) = (8.40D+10*EXP(-2567/TEMP))
  RCONST(4424) = (1.46D-11)
  RCONST(4425) = (j('mek'))
  RCONST(4426) = (j('ch3o2h')+j('mek'))
  RCONST(4427) = (4.98D-12)
  RCONST(4428) = (KDEC)
  RCONST(4429) = (j('ch3o2h')+j('mek'))
  RCONST(4430) = (5.41D-11)
  RCONST(4431) = (j('n_c3h7ono2')+j('mek'))
  RCONST(4432) = (1.71D-12)
  RCONST(4433) = (1.30D+11*EXP(-4127/TEMP))
  RCONST(4434) = (KROPRIM*O2)
  RCONST(4435) = (j('i_c3h7cho'))
  RCONST(4436) = (KNO3AL*8.5)
  RCONST(4437) = (2.26D-11)
  RCONST(4438) = (1.37D-10)
  RCONST(4439) = (1.90D-12*EXP(190/TEMP))
  RCONST(4440) = (j('mek')+j('ch3o2h'))
  RCONST(4441) = (2.61D-12)
  RCONST(4442) = (j('mek')+j('1_c4h9ono2'))
  RCONST(4443) = (1.30D+11*EXP(-4127/TEMP))
  RCONST(4444) = (1.86D-12)
  RCONST(4445) = (j('mek'))
  RCONST(4446) = (j('mek'))
  RCONST(4447) = (3.75D-11)
  RCONST(4448) = (j('mek'))
  RCONST(4449) = (3.66D-11)
  RCONST(4450) = (1.90D-12*EXP(190/TEMP))
  RCONST(4451) = (j('mek')+j('ch3o2h'))
  RCONST(4452) = (2.51D-12)
  RCONST(4453) = (j('mek')+j('1_c4h9ono2'))
  RCONST(4454) = (2.70D+14*EXP(-7398/TEMP))
  RCONST(4455) = (KROSEC*O2)
  RCONST(4456) = (j('mek')*2)
  RCONST(4457) = (5.67D-12)
  RCONST(4458) = (j('mek'))
  RCONST(4459) = (1.39D-11*0.349)
  RCONST(4460) = (1.39D-11*0.651)
  RCONST(4461) = (2.94D-11)
  RCONST(4462) = (1.90D-12*EXP(190/TEMP))
  RCONST(4463) = (j('mek'))
  RCONST(4464) = (j('ch3o2h'))
  RCONST(4465) = (KDEC)
  RCONST(4466) = (4.81D-12)
  RCONST(4467) = (j('biacet'))
  RCONST(4468) = (1.07D-10)
  RCONST(4469) = (1.90D-12*EXP(190/TEMP))
  RCONST(4470) = (j('ch3o2h'))
  RCONST(4471) = (j('mek'))
  RCONST(4472) = (2.96D-12)
  RCONST(4473) = (j('n_c3h7ono2')+j('mek'))
  RCONST(4474) = (8.40D+10*EXP(-2567/TEMP))
  RCONST(4475) = (2.97D-11)
  RCONST(4476) = (j('mek'))
  RCONST(4477) = (2.84D-11)
  RCONST(4478) = (1.90D-12*EXP(190/TEMP))
  RCONST(4479) = (j('mek'))
  RCONST(4480) = (j('ch3o2h'))
  RCONST(4481) = (KDEC)
  RCONST(4482) = (2.54D-12)
  RCONST(4483) = (j('biacet'))
  RCONST(4484) = (1.13D-11)
  RCONST(4485) = (j('mek'))
  RCONST(4486) = (2.34D-11)
  RCONST(4487) = (1.90D-12*EXP(190/TEMP))
  RCONST(4488) = (j('mek'))
  RCONST(4489) = (j('ch3o2h'))
  RCONST(4490) = (KDEC)
  RCONST(4491) = (5.34D-11)
  RCONST(4492) = (1.90D-12*EXP(190/TEMP))
  RCONST(4493) = (j('ch3o2h')+j('mek'))
  RCONST(4494) = (3.40D-12)
  RCONST(4495) = (j('n_c3h7ono2')+j('mek'))
  RCONST(4496) = (8.40D+10*EXP(-2567/TEMP))
  RCONST(4497) = (KNO3AL*5.5)
  RCONST(4498) = (7.61D-11)
  RCONST(4499) = (j('mek'))
  RCONST(4500) = (j('n_c3h7cho_hco'))
  RCONST(4501) = (1.81D-11)
  RCONST(4502) = (j('mek'))
  RCONST(4503) = (4.89D-12)
  RCONST(4504) = (j('ch3o2h')+j('mek'))
  RCONST(4505) = (3.86D-13)
  RCONST(4506) = (j('2_c4h9ono2')+j('mek'))
  RCONST(4507) = (2.70D+14*EXP(-6543/TEMP))
  RCONST(4508) = (1.30D+11*EXP(-4127/TEMP))
  RCONST(4509) = (3.18D-11)
  RCONST(4510) = (1.90D-12*EXP(190/TEMP))
  RCONST(4511) = (j('mek'))
  RCONST(4512) = (j('ch3o2h'))
  RCONST(4513) = (KDEC)
  RCONST(4514) = (2.77D-12)
  RCONST(4515) = (j('biacet'))
  RCONST(4516) = (1.45D-11)
  RCONST(4517) = (j('mek'))
  RCONST(4518) = (j('ch3o2h')+j('mek'))
  RCONST(4519) = (5.29D-11)
  RCONST(4520) = (j('n_c3h7ono2')+j('mek'))
  RCONST(4521) = (1.57D-12)
  RCONST(4522) = (1.30D+11*EXP(-4127/TEMP))
  RCONST(4523) = (KROPRIM*O2)
  RCONST(4524) = (j('i_c3h7cho'))
  RCONST(4525) = (KNO3AL*8.5)
  RCONST(4526) = (7.22D-11)
  RCONST(4527) = (j('mek'))
  RCONST(4528) = (1.39D-11)
  RCONST(4529) = (1.43D-10)
  RCONST(4530) = (j('ch3o2h')+j('mek'))
  RCONST(4531) = (6.28D-12)
  RCONST(4532) = (j('1_c4h9ono2'))
  RCONST(4533) = (2.70D+14*EXP(-7398/TEMP))
  RCONST(4534) = (KROSEC*O2)
  RCONST(4535) = (1.83D-11)
  RCONST(4536) = (j('mek')*2)
  RCONST(4537) = (4.31D-11)
  RCONST(4538) = (j('mek'))
  RCONST(4539) = (6.87D-12)
  RCONST(4540) = (j('ch3o2h'))
  RCONST(4541) = (KDEC)
  RCONST(4542) = (3.64D-12)
  RCONST(4543) = (1.90D-12*EXP(190/TEMP))
  RCONST(4544) = (1.23D-11)
  RCONST(4545) = (j('ch3o2h'))
  RCONST(4546) = (KROSEC*O2)
  RCONST(4547) = (4.00D+05)
  RCONST(4548) = (5.50D-12)
  RCONST(4549) = (5.55D-12)
  RCONST(4550) = (j('2_c4h9ono2'))
  RCONST(4551) = (KRO2HO2*0.914)
  RCONST(4552) = (KRO2NO)
  RCONST(4553) = (KRO2NO3)
  RCONST(4554) = (9.20D-14*0.7*RO2)
  RCONST(4555) = (9.20D-14*0.3*RO2)
  RCONST(4556) = (KRO2HO2*0.914)
  RCONST(4557) = (KRO2NO)
  RCONST(4558) = (KRO2NO3)
  RCONST(4559) = (2.00D-12*RO2*0.05)
  RCONST(4560) = (2.00D-12*RO2*0.90)
  RCONST(4561) = (2.00D-12*RO2*0.05)
  RCONST(4562) = (1.20D-15)
  RCONST(4563) = (1.00D-14)
  RCONST(4564) = (1.00D-15)
  RCONST(4565) = (7.00D-14)
  RCONST(4566) = (1.40D-17*H2O)
  RCONST(4567) = (2.00D-18*H2O)
  RCONST(4568) = (KRO2HO2*0.890)
  RCONST(4569) = (KRO2NO*0.157)
  RCONST(4570) = (KRO2NO*0.843)
  RCONST(4571) = (KRO2NO3)
  RCONST(4572) = (1.30D-12*0.6*RO2)
  RCONST(4573) = (1.30D-12*0.2*RO2)
  RCONST(4574) = (1.30D-12*0.2*RO2)
  RCONST(4575) = (1.83D-11)
  RCONST(4576) = (j('ch3o2h'))
  RCONST(4577) = (KDEC)
  RCONST(4578) = (1.49D-11)
  RCONST(4579) = (3.28D-11)
  RCONST(4580) = (j('ch3o2h'))
  RCONST(4581) = (KDEC)
  RCONST(4582) = (8.18D-12)
  RCONST(4583) = (1.03D-10)
  RCONST(4584) = (j('ch3o2h'))
  RCONST(4585) = (9.87D-11)
  RCONST(4586) = (j('2_c4h9ono2'))
  RCONST(4587) = (KDEC)
  RCONST(4588) = (9.91D-11)
  RCONST(4589) = (9.58D-12)
  RCONST(4590) = (j('ch3o2h'))
  RCONST(4591) = (KDEC)
  RCONST(4592) = (6.12D-12)
  RCONST(4593) = (9.08D-12)
  RCONST(4594) = (j('ch3o2h'))
  RCONST(4595) = (7.00D+03)
  RCONST(4596) = (4.70D-12)
  RCONST(4597) = (KNO3AL*8.5)
  RCONST(4598) = (8.63D-12)
  RCONST(4599) = (j('n_c3h7cho_hco'))
  RCONST(4600) = (KRO2HO2*0.890)
  RCONST(4601) = (KRO2NO*0.157)
  RCONST(4602) = (KRO2NO*0.843)
  RCONST(4603) = (KRO2NO3)
  RCONST(4604) = (2.50D-13*RO2*0.2)
  RCONST(4605) = (2.50D-13*RO2*0.6)
  RCONST(4606) = (2.50D-13*RO2*0.2)
  RCONST(4607) = (KRO2HO2*0.890)
  RCONST(4608) = (KRO2NO*0.157)
  RCONST(4609) = (KRO2NO*0.843)
  RCONST(4610) = (KRO2NO3)
  RCONST(4611) = (2.50D-13*RO2*0.2)
  RCONST(4612) = (2.50D-13*RO2*0.6)
  RCONST(4613) = (2.50D-13*RO2*0.2)
  RCONST(4614) = (KRO2HO2*0.890)
  RCONST(4615) = (KRO2NO*0.118)
  RCONST(4616) = (KRO2NO*0.882)
  RCONST(4617) = (KRO2NO3)
  RCONST(4618) = (6.70D-15*RO2*0.7)
  RCONST(4619) = (6.70D-15*RO2*0.3)
  RCONST(4620) = (KRO2HO2*0.890)
  RCONST(4621) = (KRO2NO)
  RCONST(4622) = (KRO2NO3)
  RCONST(4623) = (2.00D-12*RO2*0.05)
  RCONST(4624) = (2.00D-12*RO2*0.9)
  RCONST(4625) = (2.00D-12*RO2*0.05)
  RCONST(4626) = (3.04D-12)
  RCONST(4627) = (1.20D-15)
  RCONST(4628) = (1.00D-14)
  RCONST(4629) = (1.00D-15)
  RCONST(4630) = (7.00D-14)
  RCONST(4631) = (6.00D-18*H2O)
  RCONST(4632) = (1.33D-11)
  RCONST(4633) = (j('ch3o2h'))
  RCONST(4634) = (KDEC)
  RCONST(4635) = (9.88D-12)
  RCONST(4636) = (1.90D-11)
  RCONST(4637) = (j('ch3o2h'))
  RCONST(4638) = (KDEC)
  RCONST(4639) = (KNO3AL*8.5)
  RCONST(4640) = (3.17D-11)
  RCONST(4641) = (j('i_c3h7cho'))
  RCONST(4642) = (9.72D-11)
  RCONST(4643) = (j('ch3o2h'))
  RCONST(4644) = (9.38D-11)
  RCONST(4645) = (j('2_c4h9ono2'))
  RCONST(4646) = (KDEC)
  RCONST(4647) = (9.37D-11)
  RCONST(4648) = (4.28D-11)
  RCONST(4649) = (j('ch3o2h'))
  RCONST(4650) = (KDEC)
  RCONST(4651) = (5.91D-11)
  RCONST(4652) = (KRO2HO2*0.914)
  RCONST(4653) = (KRO2NO)
  RCONST(4654) = (KRO2NO3)
  RCONST(4655) = (8.80D-13*RO2*0.2)
  RCONST(4656) = (8.80D-13*RO2*0.6)
  RCONST(4657) = (8.80D-13*RO2*0.2)
  RCONST(4658) = (KRO2HO2*0.914)
  RCONST(4659) = (KRO2NO)
  RCONST(4660) = (KRO2NO3)
  RCONST(4661) = (8.80D-13*RO2*0.05)
  RCONST(4662) = (8.80D-13*RO2*0.9)
  RCONST(4663) = (8.80D-13*RO2*0.05)
  RCONST(4664) = (KRO2HO2*0.890)
  RCONST(4665) = (KRO2NO*0.157)
  RCONST(4666) = (KRO2NO*0.843)
  RCONST(4667) = (KRO2NO3)
  RCONST(4668) = (1.32D-12*RO2*0.6)
  RCONST(4669) = (1.32D-12*RO2*0.2)
  RCONST(4670) = (1.32D-12*RO2*0.2)
  RCONST(4671) = (1.20D-15)
  RCONST(4672) = (1.00D-14)
  RCONST(4673) = (1.00D-15)
  RCONST(4674) = (7.00D-14)
  RCONST(4675) = (1.40D-17*H2O)
  RCONST(4676) = (2.00D-18*H2O)
  RCONST(4677) = (7.36D-11)
  RCONST(4678) = (j('ch3o2h'))
  RCONST(4679) = (6.20D-11)
  RCONST(4680) = (KDEC)
  RCONST(4681) = (7.02D-11)
  RCONST(4682) = (1.04D-10)
  RCONST(4683) = (j('ch3o2h'))
  RCONST(4684) = (KDEC)
  RCONST(4685) = (6.70D-11)
  RCONST(4686) = (1.03D-10)
  RCONST(4687) = (j('ch3o2h'))
  RCONST(4688) = (9.31D-11)
  RCONST(4689) = (KDEC)
  RCONST(4690) = (9.94D-11)
  RCONST(4691) = (6.25D-11)
  RCONST(4692) = (j('ch3o2h'))
  RCONST(4693) = (KDEC)
  RCONST(4694) = (5.91D-11)
  RCONST(4695) = (KNO3AL*8.5)
  RCONST(4696) = (3.30D-13)
  RCONST(4697) = (1.10D-16*0.670)
  RCONST(4698) = (1.10D-16*0.330)
  RCONST(4699) = (8.55D-11*0.012)
  RCONST(4700) = (8.55D-11*0.001)
  RCONST(4701) = (8.55D-11*0.012)
  RCONST(4702) = (8.55D-11*0.695)
  RCONST(4703) = (8.55D-11*0.281)
  RCONST(4704) = (j('n_c3h7cho_hco'))
  RCONST(4705) = (1.10D-16*0.4)
  RCONST(4706) = (1.10D-16*0.6)
  RCONST(4707) = (7.29D-11)
  RCONST(4708) = (1.10D-16*0.330)
  RCONST(4709) = (1.10D-16*0.670)
  RCONST(4710) = (6.98D-11)
  RCONST(4711) = (KRO2HO2*0.975)
  RCONST(4712) = (KRO2NO)
  RCONST(4713) = (KRO2NO3)
  RCONST(4714) = (2.00D-12*RO2*0.2)
  RCONST(4715) = (2.00D-12*RO2*0.6)
  RCONST(4716) = (2.00D-12*RO2*0.2)
  RCONST(4717) = (KRO2HO2*0.975)
  RCONST(4718) = (KRO2NO)
  RCONST(4719) = (KRO2NO3)
  RCONST(4720) = (2.00D-12*RO2*0.2)
  RCONST(4721) = (2.00D-12*RO2*0.6)
  RCONST(4722) = (2.00D-12*RO2*0.2)
  RCONST(4723) = (1.10D-16*0.670)
  RCONST(4724) = (1.10D-16*0.330)
  RCONST(4725) = (6.98D-11)
  RCONST(4726) = (KRO2HO2*0.959)
  RCONST(4727) = (KRO2NO*0.178)
  RCONST(4728) = (KRO2NO*0.822)
  RCONST(4729) = (KRO2NO3)
  RCONST(4730) = (1.30D-12*RO2*0.2)
  RCONST(4731) = (1.30D-12*RO2*0.6)
  RCONST(4732) = (1.30D-12*RO2*0.2)
  RCONST(4733) = (KRO2HO2*0.975)
  RCONST(4734) = (KRO2NO)
  RCONST(4735) = (KRO2NO3)
  RCONST(4736) = (2.00D-12*RO2*0.2)
  RCONST(4737) = (2.00D-12*RO2*0.6)
  RCONST(4738) = (2.00D-12*RO2*0.2)
  RCONST(4739) = (KRO2HO2*0.968)
  RCONST(4740) = (KRO2NO*0.180)
  RCONST(4741) = (KRO2NO*0.820)
  RCONST(4742) = (KRO2NO3)
  RCONST(4743) = (1.32D-12*RO2*0.2)
  RCONST(4744) = (1.32D-12*RO2*0.6)
  RCONST(4745) = (1.32D-12*RO2*0.2)
  RCONST(4746) = (7.36D-11)
  RCONST(4747) = (j('ch3o2h'))
  RCONST(4748) = (6.20D-11)
  RCONST(4749) = (KDEC)
  RCONST(4750) = (7.02D-11)
  RCONST(4751) = (1.04D-10)
  RCONST(4752) = (j('ch3o2h'))
  RCONST(4753) = (KDEC)
  RCONST(4754) = (6.70D-11)
  RCONST(4755) = (1.03D-10)
  RCONST(4756) = (j('ch3o2h'))
  RCONST(4757) = (9.31D-11)
  RCONST(4758) = (KDEC)
  RCONST(4759) = (9.94D-11)
  RCONST(4760) = (KAPHO2*0.15)
  RCONST(4761) = (KAPHO2*0.41)
  RCONST(4762) = (KAPHO2*0.44)
  RCONST(4763) = (KAPNO)
  RCONST(4764) = (KFPAN)
  RCONST(4765) = (KRO2NO3*1.74)
  RCONST(4766) = (1.00D-11*0.3*RO2)
  RCONST(4767) = (1.00D-11*0.7*RO2)
  RCONST(4768) = (KAPHO2*0.15)
  RCONST(4769) = (KAPHO2*0.41)
  RCONST(4770) = (KAPHO2*0.44)
  RCONST(4771) = (KAPNO)
  RCONST(4772) = (KFPAN)
  RCONST(4773) = (KRO2NO3*1.74)
  RCONST(4774) = (1.00D-11*0.3*RO2)
  RCONST(4775) = (1.00D-11*0.7*RO2)
  RCONST(4776) = (KRO2HO2*0.706)
  RCONST(4777) = (KRO2NO*0.026)
  RCONST(4778) = (KRO2NO*0.974)
  RCONST(4779) = (KRO2NO3)
  RCONST(4780) = (8.40D-13*0.2*RO2)
  RCONST(4781) = (8.40D-13*0.6*RO2)
  RCONST(4782) = (8.40D-13*0.2*RO2)
  RCONST(4783) = (KAPHO2*0.56)
  RCONST(4784) = (KAPHO2*0.44)
  RCONST(4785) = (KAPNO)
  RCONST(4786) = (KFPAN)
  RCONST(4787) = (KRO2NO3*1.74)
  RCONST(4788) = (1.00D-11*RO2)
  RCONST(4789) = (6.26D-12)
  RCONST(4790) = (j('ch3o2h'))
  RCONST(4791) = (9.72D-12)
  RCONST(4792) = (KBPAN)
  RCONST(4793) = (2.20D-12)
  RCONST(4794) = (8.88D-12)
  RCONST(4795) = (1.23D-11)
  RCONST(4796) = (j('ch3o2h'))
  RCONST(4797) = (3.07D-12)
  RCONST(4798) = (KBPAN)
  RCONST(4799) = (2.56D-11)
  RCONST(4800) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(4801) = (2.10D-11)
  RCONST(4802) = (j('2_c4h9ono2'))
  RCONST(4803) = (j('i_c3h7cho'))
  RCONST(4804) = (KDEC)
  RCONST(4805) = (KNO3AL*8.5)
  RCONST(4806) = (1.52D-11)
  RCONST(4807) = (j('ch3cocho'))
  RCONST(4808) = (KRO2HO2*0.706)
  RCONST(4809) = (KRO2NO*0.010)
  RCONST(4810) = (KRO2NO*0.990)
  RCONST(4811) = (KRO2NO3)
  RCONST(4812) = (2.00D-12*0.6*RO2)
  RCONST(4813) = (2.00D-12*0.2*RO2)
  RCONST(4814) = (2.00D-12*0.2*RO2)
  RCONST(4815) = (KAPHO2*0.56)
  RCONST(4816) = (KAPHO2*0.44)
  RCONST(4817) = (KAPNO)
  RCONST(4818) = (KFPAN)
  RCONST(4819) = (KRO2NO3*1.74)
  RCONST(4820) = (1.00D-11*RO2)
  RCONST(4821) = (KAPHO2*0.44)
  RCONST(4822) = (KAPHO2*0.56)
  RCONST(4823) = (KAPNO)
  RCONST(4824) = (KFPAN)
  RCONST(4825) = (KRO2NO3*1.74)
  RCONST(4826) = (1.00D-11*RO2)
  RCONST(4827) = (KRO2HO2*0.706)
  RCONST(4828) = (KRO2NO*0.010)
  RCONST(4829) = (KRO2NO*0.990)
  RCONST(4830) = (KRO2NO3)
  RCONST(4831) = (2.00D-12*0.2*RO2)
  RCONST(4832) = (2.00D-12*0.6*RO2)
  RCONST(4833) = (2.00D-12*0.2*RO2)
  RCONST(4834) = (KAPHO2*0.44)
  RCONST(4835) = (KAPHO2*0.15)
  RCONST(4836) = (KAPHO2*0.41)
  RCONST(4837) = (KAPNO)
  RCONST(4838) = (KFPAN)
  RCONST(4839) = (KRO2NO3*1.74)
  RCONST(4840) = (1.00D-11*0.7*RO2)
  RCONST(4841) = (1.00D-11*0.3*RO2)
  RCONST(4842) = (2*KNO3AL*5.5)
  RCONST(4843) = (5.22D-11*0.178)
  RCONST(4844) = (5.22D-11*0.822)
  RCONST(4845) = (j('n_c3h7cho_hco'))
  RCONST(4846) = (1.07D-11)
  RCONST(4847) = (j('mek'))
  RCONST(4848) = (2.59D-11)
  RCONST(4849) = (KRO2HO2*0.770)
  RCONST(4850) = (KRO2NO)
  RCONST(4851) = (KRO2NO3)
  RCONST(4852) = (2.00D-12*RO2)
  RCONST(4853) = (2.00D+14*EXP(-5902/TEMP))
  RCONST(4854) = (KDEC)
  RCONST(4855) = (2.73D-12)
  RCONST(4856) = (6.19D-12)
  RCONST(4857) = (j('ch3o2h'))
  RCONST(4858) = (1.12D-12)
  RCONST(4859) = (KBPAN)
  RCONST(4860) = (9.34D-12)
  RCONST(4861) = (j('ch3o2h'))
  RCONST(4862) = (2.34D-12)
  RCONST(4863) = (KBPAN)
  RCONST(4864) = (KDEC)
  RCONST(4865) = (KAPHO2*0.44)
  RCONST(4866) = (KAPHO2*0.56)
  RCONST(4867) = (KAPNO)
  RCONST(4868) = (KFPAN)
  RCONST(4869) = (KRO2NO3*1.74)
  RCONST(4870) = (1.00D-11*RO2)
  RCONST(4871) = (1.72D-12)
  RCONST(4872) = (j('ch3o2h'))
  RCONST(4873) = (4.80D-12)
  RCONST(4874) = (KBPAN)
  RCONST(4875) = (4.75D-13)
  RCONST(4876) = (1.38D-11)
  RCONST(4877) = (j('ch3cocho'))
  RCONST(4878) = (KAPHO2*0.56)
  RCONST(4879) = (KAPHO2*0.44)
  RCONST(4880) = (KAPNO)
  RCONST(4881) = (KFPAN)
  RCONST(4882) = (KRO2NO3*1.74)
  RCONST(4883) = (1.00D-11*RO2)
  RCONST(4884) = (KAPHO2*0.44)
  RCONST(4885) = (KAPHO2*0.56)
  RCONST(4886) = (KAPNO)
  RCONST(4887) = (KFPAN)
  RCONST(4888) = (KRO2NO3*1.74)
  RCONST(4889) = (1.00D-11*RO2)
  RCONST(4890) = (KAPHO2*0.15)
  RCONST(4891) = (KAPHO2*0.41)
  RCONST(4892) = (KAPHO2*0.44)
  RCONST(4893) = (KAPNO)
  RCONST(4894) = (KFPAN)
  RCONST(4895) = (KRO2NO3*1.74)
  RCONST(4896) = (1.00D-11*0.3*RO2)
  RCONST(4897) = (1.00D-11*0.7*RO2)
  RCONST(4898) = (KAPHO2*0.44)
  RCONST(4899) = (KAPHO2*0.15)
  RCONST(4900) = (KAPHO2*0.41)
  RCONST(4901) = (KAPNO)
  RCONST(4902) = (KFPAN)
  RCONST(4903) = (KRO2NO3*1.74)
  RCONST(4904) = (1.00D-11*0.7*RO2)
  RCONST(4905) = (1.00D-11*0.3*RO2)
  RCONST(4906) = (KRO2HO2*0.520)
  RCONST(4907) = (KRO2NO)
  RCONST(4908) = (KRO2NO3)
  RCONST(4909) = (2.00D-12*0.2*RO2)
  RCONST(4910) = (2.00D-12*0.2*RO2)
  RCONST(4911) = (2.00D-12*0.6*RO2)
  RCONST(4912) = (KAPHO2*0.15)
  RCONST(4913) = (KAPHO2*0.41)
  RCONST(4914) = (KAPHO2*0.44)
  RCONST(4915) = (KAPNO)
  RCONST(4916) = (KFPAN)
  RCONST(4917) = (KRO2NO3*1.74)
  RCONST(4918) = (1.00D-11*0.3*RO2)
  RCONST(4919) = (1.00D-11*0.7*RO2)
  RCONST(4920) = (KRO2HO2*0.625)
  RCONST(4921) = (KRO2NO*0.013)
  RCONST(4922) = (KRO2NO*0.987)
  RCONST(4923) = (KRO2NO3)
  RCONST(4924) = (1.30D-12*0.6*RO2)
  RCONST(4925) = (1.30D-12*0.2*RO2)
  RCONST(4926) = (1.30D-12*0.2*RO2)
  RCONST(4927) = (KAPHO2*0.44)
  RCONST(4928) = (KAPHO2*0.15)
  RCONST(4929) = (KAPHO2*0.41)
  RCONST(4930) = (KAPNO)
  RCONST(4931) = (KFPAN)
  RCONST(4932) = (KRO2NO3*1.74)
  RCONST(4933) = (1.00E-11*0.7*RO2)
  RCONST(4934) = (1.00E-11*0.3*RO2)
  RCONST(4935) = (KAPHO2*0.44)
  RCONST(4936) = (KAPHO2*0.56)
  RCONST(4937) = (KAPNO)
  RCONST(4938) = (KFPAN)
  RCONST(4939) = (KRO2NO3*1.74)
  RCONST(4940) = (1.00D-11*RO2)
  RCONST(4941) = (j('n_c3h7ono2'))
  RCONST(4942) = (j('ch3cocho'))
  RCONST(4943) = (KNO3AL*2.4)
  RCONST(4944) = (1.24D-11)
  RCONST(4945) = (KAPHO2*0.15)
  RCONST(4946) = (KAPHO2*0.41)
  RCONST(4947) = (KAPHO2*0.44)
  RCONST(4948) = (KAPNO)
  RCONST(4949) = (KFPAN)
  RCONST(4950) = (KRO2NO3*1.74)
  RCONST(4951) = (1.00D-11*0.7*RO2)
  RCONST(4952) = (1.00D-11*0.3*RO2)
  RCONST(4953) = (j('ch3cocho'))
  RCONST(4954) = (1.23D-11)
  RCONST(4955) = (4.33D-12)
  RCONST(4956) = (8.83D-13)
  RCONST(4957) = (6.78D-12)
  RCONST(4958) = (j('ch3coch2ono2')*10)
  RCONST(4959) = (KAPHO2*0.44)
  RCONST(4960) = (KAPHO2*0.15)
  RCONST(4961) = (KAPHO2*0.41)
  RCONST(4962) = (KAPNO)
  RCONST(4963) = (KFPAN)
  RCONST(4964) = (KRO2NO3*1.74)
  RCONST(4965) = (1.00D-11*0.7*RO2)
  RCONST(4966) = (1.00D-11*0.3*RO2)
  RCONST(4967) = (KAPHO2*0.15)
  RCONST(4968) = (KAPHO2*0.41)
  RCONST(4969) = (KAPHO2*0.44)
  RCONST(4970) = (KAPNO)
  RCONST(4971) = (KFPAN)
  RCONST(4972) = (KRO2NO3*1.74)
  RCONST(4973) = (1.00D-11*0.3*RO2)
  RCONST(4974) = (1.00D-11*0.7*RO2)
  RCONST(4975) = (KAPHO2*0.56)
  RCONST(4976) = (KAPHO2*0.44)
  RCONST(4977) = (KAPNO)
  RCONST(4978) = (KFPAN)
  RCONST(4979) = (KRO2NO3*1.74)
  RCONST(4980) = (1.00D-11*RO2)
  RCONST(4981) = (KDEC*0.5)
  RCONST(4982) = (KDEC*0.5)
  RCONST(4983) = (KAPHO2*0.56)
  RCONST(4984) = (KAPHO2*0.44)
  RCONST(4985) = (KAPNO)
  RCONST(4986) = (KFPAN)
  RCONST(4987) = (KRO2NO3*1.74)
  RCONST(4988) = (1.00D-11*RO2)
  RCONST(4989) = (KRO2HO2*0.706)
  RCONST(4990) = (KRO2NO*0.052)
  RCONST(4991) = (KRO2NO*0.948)
  RCONST(4992) = (KRO2NO3)
  RCONST(4993) = (2.50D-13*0.2*RO2)
  RCONST(4994) = (2.50D-13*0.6*RO2)
  RCONST(4995) = (2.50D-13*0.2*RO2)
  RCONST(4996) = (KRO2HO2*0.706)
  RCONST(4997) = (KRO2NO*0.021)
  RCONST(4998) = (KRO2NO*0.979)
  RCONST(4999) = (KRO2NO3)
  RCONST(5000) = (1.30D-12*0.2*RO2)
  RCONST(5001) = (1.30D-12*0.6*RO2)
  RCONST(5002) = (1.30D-12*0.2*RO2)
  RCONST(5003) = (KRO2HO2*0.706)
  RCONST(5004) = (KRO2NO*0.021)
  RCONST(5005) = (KRO2NO*0.979)
  RCONST(5006) = (KRO2NO3)
  RCONST(5007) = (1.30D-12*0.6*RO2)
  RCONST(5008) = (1.30D-12*0.2*RO2)
  RCONST(5009) = (1.30D-12*0.2*RO2)
  RCONST(5010) = (KAPHO2*0.56)
  RCONST(5011) = (KAPHO2*0.44)
  RCONST(5012) = (KAPNO)
  RCONST(5013) = (KFPAN)
  RCONST(5014) = (KRO2NO3*1.74)
  RCONST(5015) = (1.00D-11*RO2)
  RCONST(5016) = (KRO2HO2*0.770)
  RCONST(5017) = (KRO2NO*0.078)
  RCONST(5018) = (KRO2NO*0.922)
  RCONST(5019) = (KRO2NO3)
  RCONST(5020) = (2.50D-13*0.2*RO2)
  RCONST(5021) = (2.50D-13*0.6*RO2)
  RCONST(5022) = (2.50D-13*0.2*RO2)
  RCONST(5023) = (KAPHO2*0.56)
  RCONST(5024) = (KAPHO2*0.44)
  RCONST(5025) = (KAPNO)
  RCONST(5026) = (KFPAN)
  RCONST(5027) = (KRO2NO3*1.74)
  RCONST(5028) = (1.00D-11*RO2)
  RCONST(5029) = (KRO2HO2*0.770)
  RCONST(5030) = (KRO2NO*0.078)
  RCONST(5031) = (KRO2NO*0.922)
  RCONST(5032) = (KRO2NO3)
  RCONST(5033) = (2.50D-13*0.2*RO2)
  RCONST(5034) = (2.50D-13*0.6*RO2)
  RCONST(5035) = (2.50D-13*0.2*RO2)
  RCONST(5036) = (KRO2HO2*0.770)
  RCONST(5037) = (KRO2NO*0.031)
  RCONST(5038) = (KRO2NO*0.969)
  RCONST(5039) = (KRO2NO3)
  RCONST(5040) = (1.30D-12*0.2*RO2)
  RCONST(5041) = (1.30D-12*0.2*RO2)
  RCONST(5042) = (1.30D-12*0.6*RO2)
  RCONST(5043) = (KRO2HO2*0.770)
  RCONST(5044) = (KRO2NO*0.078)
  RCONST(5045) = (KRO2NO*0.922)
  RCONST(5046) = (KRO2NO3)
  RCONST(5047) = (2.50D-13*0.2*RO2)
  RCONST(5048) = (2.50D-13*0.2*RO2)
  RCONST(5049) = (2.50D-13*0.6*RO2)
  RCONST(5050) = (KAPHO2*0.56)
  RCONST(5051) = (KAPHO2*0.44)
  RCONST(5052) = (KAPNO)
  RCONST(5053) = (KFPAN)
  RCONST(5054) = (KRO2NO3*1.74)
  RCONST(5055) = (1.00D-11*RO2)
  RCONST(5056) = (KRO2HO2*0.770)
  RCONST(5057) = (KRO2NO*0.031)
  RCONST(5058) = (KRO2NO*0.969)
  RCONST(5059) = (KRO2NO3)
  RCONST(5060) = (1.30D-12*0.2*RO2)
  RCONST(5061) = (1.30D-12*0.2*RO2)
  RCONST(5062) = (1.30D-12*0.6*RO2)
  RCONST(5063) = (KRO2HO2*0.770)
  RCONST(5064) = (KRO2NO)
  RCONST(5065) = (KRO2NO3)
  RCONST(5066) = (9.20D-14*0.7*RO2)
  RCONST(5067) = (9.20D-14*0.3*RO2)
  RCONST(5068) = (KRO2HO2*0.770)
  RCONST(5069) = (KRO2NO*0.078)
  RCONST(5070) = (KRO2NO*0.922)
  RCONST(5071) = (KRO2NO3)
  RCONST(5072) = (1.30D-12*0.2*RO2)
  RCONST(5073) = (1.30D-12*0.6*RO2)
  RCONST(5074) = (1.30D-12*0.2*RO2)
  RCONST(5075) = (KRO2HO2*0.770)
  RCONST(5076) = (KRO2NO*0.031)
  RCONST(5077) = (KRO2NO*0.969)
  RCONST(5078) = (KRO2NO3)
  RCONST(5079) = (1.30D-12*0.2*RO2)
  RCONST(5080) = (1.30D-12*0.6*RO2)
  RCONST(5081) = (1.30D-12*0.2*RO2)
  RCONST(5082) = (KRO2HO2*0.770)
  RCONST(5083) = (KRO2NO*0.078)
  RCONST(5084) = (KRO2NO*0.922)
  RCONST(5085) = (KRO2NO3)
  RCONST(5086) = (2.50D-13*0.2*RO2)
  RCONST(5087) = (2.50D-13*0.6*RO2)
  RCONST(5088) = (2.50D-13*0.2*RO2)
  RCONST(5089) = (KAPHO2*0.44)
  RCONST(5090) = (KAPHO2*0.56)
  RCONST(5091) = (KAPNO)
  RCONST(5092) = (KFPAN)
  RCONST(5093) = (KRO2NO3*1.74)
  RCONST(5094) = (1.00D-11*RO2)
  RCONST(5095) = (KRO2HO2*0.770)
  RCONST(5096) = (KRO2NO*0.031)
  RCONST(5097) = (KRO2NO*0.969)
  RCONST(5098) = (KRO2NO3)
  RCONST(5099) = (1.30D-12*0.2*RO2)
  RCONST(5100) = (1.30D-12*0.6*RO2)
  RCONST(5101) = (1.30D-12*0.2*RO2)
  RCONST(5102) = (KRO2HO2*0.770)
  RCONST(5103) = (KRO2NO*0.195)
  RCONST(5104) = (KRO2NO*0.805)
  RCONST(5105) = (KRO2NO3)
  RCONST(5106) = (2.50D-13*0.2*RO2)
  RCONST(5107) = (2.50D-13*0.6*RO2)
  RCONST(5108) = (2.50D-13*0.2*RO2)
  RCONST(5109) = (KRO2HO2*0.770)
  RCONST(5110) = (KRO2NO)
  RCONST(5111) = (KRO2NO3)
  RCONST(5112) = (9.20D-14*0.7*RO2)
  RCONST(5113) = (9.20D-14*0.3*RO2)
  RCONST(5114) = (KRO2HO2*0.770)
  RCONST(5115) = (KRO2NO*0.031)
  RCONST(5116) = (KRO2NO*0.969)
  RCONST(5117) = (KRO2NO3)
  RCONST(5118) = (1.30D-12*0.2*RO2)
  RCONST(5119) = (1.30D-12*0.6*RO2)
  RCONST(5120) = (1.30D-12*0.2*RO2)
  RCONST(5121) = (KAPHO2*0.56)
  RCONST(5122) = (KAPHO2*0.44)
  RCONST(5123) = (KAPNO)
  RCONST(5124) = (KFPAN)
  RCONST(5125) = (KRO2NO3*1.74)
  RCONST(5126) = (1.00D-11*RO2)
  RCONST(5127) = (KRO2HO2*0.770)
  RCONST(5128) = (KRO2NO*0.031)
  RCONST(5129) = (KRO2NO*0.969)
  RCONST(5130) = (KRO2NO3)
  RCONST(5131) = (1.30D-12*0.2*RO2)
  RCONST(5132) = (1.30D-12*0.6*RO2)
  RCONST(5133) = (1.30D-12*0.2*RO2)
  RCONST(5134) = (KAPHO2*0.44)
  RCONST(5135) = (KAPHO2*0.15)
  RCONST(5136) = (KAPHO2*0.41)
  RCONST(5137) = (KAPNO)
  RCONST(5138) = (KFPAN)
  RCONST(5139) = (KRO2NO3*1.74)
  RCONST(5140) = (1.00D-11*0.7*RO2)
  RCONST(5141) = (1.00D-11*0.3*RO2)
  RCONST(5142) = (KRO2HO2*0.770)
  RCONST(5143) = (KRO2NO*0.031)
  RCONST(5144) = (KRO2NO*0.969)
  RCONST(5145) = (KRO2NO3)
  RCONST(5146) = (1.30D-12*0.6*RO2)
  RCONST(5147) = (1.30D-12*0.2*RO2)
  RCONST(5148) = (1.30D-12*0.2*RO2)
  RCONST(5149) = (KAPHO2*0.44)
  RCONST(5150) = (KAPHO2*0.15)
  RCONST(5151) = (KAPHO2*0.41)
  RCONST(5152) = (KAPNO)
  RCONST(5153) = (KFPAN)
  RCONST(5154) = (KRO2NO3*1.74)
  RCONST(5155) = (1.00D-11*0.7*RO2)
  RCONST(5156) = (1.00D-11*0.3*RO2)
  RCONST(5157) = (KRO2HO2*0.820)
  RCONST(5158) = (KRO2NO*0.111)
  RCONST(5159) = (KRO2NO*0.889)
  RCONST(5160) = (KRO2NO3)
  RCONST(5161) = (2.50D-13*0.2*RO2)
  RCONST(5162) = (2.50D-13*0.6*RO2)
  RCONST(5163) = (2.50D-13*0.2*RO2)
  RCONST(5164) = (KRO2HO2*0.820)
  RCONST(5165) = (KRO2NO)
  RCONST(5166) = (KRO2NO3)
  RCONST(5167) = (2.50D-13*RO2)
  RCONST(5168) = (KRO2HO2*0.820)
  RCONST(5169) = (KRO2NO*0.033)
  RCONST(5170) = (KRO2NO*0.967)
  RCONST(5171) = (KRO2NO3)
  RCONST(5172) = (6.70D-15*0.3*RO2)
  RCONST(5173) = (6.70D-15*0.7*RO2)
  RCONST(5174) = (KRO2HO2*0.820)
  RCONST(5175) = (KRO2NO)
  RCONST(5176) = (KRO2NO3)
  RCONST(5177) = (8.80D-13*RO2)
  RCONST(5178) = (KRO2HO2*0.820)
  RCONST(5179) = (KRO2NO*0.111)
  RCONST(5180) = (KRO2NO*0.889)
  RCONST(5181) = (KRO2NO3)
  RCONST(5182) = (2.50D-13*0.2*RO2)
  RCONST(5183) = (2.50D-13*0.6*RO2)
  RCONST(5184) = (2.50D-13*0.2*RO2)
  RCONST(5185) = (KRO2HO2*0.820)
  RCONST(5186) = (KRO2NO*0.111)
  RCONST(5187) = (KRO2NO*0.889)
  RCONST(5188) = (KRO2NO3)
  RCONST(5189) = (2.50D-13*0.2*RO2)
  RCONST(5190) = (2.50D-13*0.6*RO2)
  RCONST(5191) = (2.50D-13*0.2*RO2)
  RCONST(5192) = (KRO2HO2*0.820)
  RCONST(5193) = (KRO2NO)
  RCONST(5194) = (KRO2NO3)
  RCONST(5195) = (6.70D-15*RO2)
  RCONST(5196) = (KRO2HO2*0.820)
  RCONST(5197) = (KRO2NO*0.044)
  RCONST(5198) = (KRO2NO*0.956)
  RCONST(5199) = (KRO2NO3)
  RCONST(5200) = (1.30D-12*0.2*RO2)
  RCONST(5201) = (1.30D-12*0.2*RO2)
  RCONST(5202) = (1.30D-12*0.6*RO2)
  RCONST(5203) = (KRO2HO2*0.859)
  RCONST(5204) = (KRO2NO*0.138)
  RCONST(5205) = (KRO2NO*0.862)
  RCONST(5206) = (KRO2NO3)
  RCONST(5207) = (2.50D-13*0.2*RO2)
  RCONST(5208) = (2.50D-13*0.6*RO2)
  RCONST(5209) = (2.50D-13*0.2*RO2)
  RCONST(5210) = (KRO2HO2*0.859)
  RCONST(5211) = (KRO2NO)
  RCONST(5212) = (KRO2NO3)
  RCONST(5213) = (2.50D-13*RO2)
  RCONST(5214) = (KRO2HO2*0.890)
  RCONST(5215) = (KRO2NO*0.157)
  RCONST(5216) = (KRO2NO*0.843)
  RCONST(5217) = (KRO2NO3)
  RCONST(5218) = (2.50D-13*0.2*RO2)
  RCONST(5219) = (2.50D-13*0.6*RO2)
  RCONST(5220) = (2.50D-13*0.2*RO2)
  RCONST(5221) = (KRO2HO2*0.890)
  RCONST(5222) = (KRO2NO)
  RCONST(5223) = (KRO2NO3)
  RCONST(5224) = (2.50D-13*RO2)
  RCONST(5225) = (KRO2HO2*0.914)
  RCONST(5226) = (KRO2NO*0.167)
  RCONST(5227) = (KRO2NO*0.833)
  RCONST(5228) = (KRO2NO3)
  RCONST(5229) = (2.50D-13*0.2*RO2)
  RCONST(5230) = (2.50D-13*0.6*RO2)
  RCONST(5231) = (2.50D-13*0.2*RO2)
  RCONST(5232) = (KRO2HO2*0.914)
  RCONST(5233) = (KRO2NO)
  RCONST(5234) = (KRO2NO3)
  RCONST(5235) = (2.50D-13*RO2)
  RCONST(5236) = (KRO2HO2*0.932)
  RCONST(5237) = (KRO2NO*0.172)
  RCONST(5238) = (KRO2NO*0.828)
  RCONST(5239) = (KRO2NO3)
  RCONST(5240) = (2.50D-13*0.2*RO2)
  RCONST(5241) = (2.50D-13*0.6*RO2)
  RCONST(5242) = (2.50D-13*0.2*RO2)
  RCONST(5243) = (KRO2HO2*0.932)
  RCONST(5244) = (KRO2NO)
  RCONST(5245) = (KRO2NO3)
  RCONST(5246) = (2.50D-13*RO2)
  RCONST(5247) = (KRO2HO2*0.947)
  RCONST(5248) = (KRO2NO*0.176)
  RCONST(5249) = (KRO2NO*0.824)
  RCONST(5250) = (KRO2NO3)
  RCONST(5251) = (2.50D-13*0.2*RO2)
  RCONST(5252) = (2.50D-13*0.6*RO2)
  RCONST(5253) = (2.50D-13*0.2*RO2)
  RCONST(5254) = (KRO2HO2*0.947)
  RCONST(5255) = (KRO2NO)
  RCONST(5256) = (KRO2NO3)
  RCONST(5257) = (2.50D-13*RO2)
  RCONST(5258) = (KRO2HO2*0.770)
  RCONST(5259) = (KRO2NO*0.078)
  RCONST(5260) = (KRO2NO*0.922)
  RCONST(5261) = (KRO2NO3)
  RCONST(5262) = (1.30D-12*RO2*0.2)
  RCONST(5263) = (1.30D-12*RO2*0.6)
  RCONST(5264) = (1.30D-12*RO2*0.2)
  RCONST(5265) = (KAPHO2*0.44)
  RCONST(5266) = (KAPHO2*0.15)
  RCONST(5267) = (KAPHO2*0.41)
  RCONST(5268) = (KAPNO)
  RCONST(5269) = (KFPAN)
  RCONST(5270) = (KRO2NO3*1.74)
  RCONST(5271) = (1.00D-11*0.7*RO2)
  RCONST(5272) = (1.00D-11*0.3*RO2)
  RCONST(5273) = (KAPHO2*0.44)
  RCONST(5274) = (KAPHO2*0.15)
  RCONST(5275) = (KAPHO2*0.41)
  RCONST(5276) = (KAPNO)
  RCONST(5277) = (KFPAN)
  RCONST(5278) = (KRO2NO3*1.74)
  RCONST(5279) = (1.00D-11*0.7*RO2)
  RCONST(5280) = (1.00D-11*0.3*RO2)
  RCONST(5281) = (KDEC)
  RCONST(5282) = (KRO2HO2*0.625)
  RCONST(5283) = (KRO2NO)
  RCONST(5284) = (KRO2NO3)
  RCONST(5285) = (2.50D-13*0.2*RO2)
  RCONST(5286) = (2.50D-13*0.6*RO2)
  RCONST(5287) = (2.50D-13*0.2*RO2)
  RCONST(5288) = (KDEC)
  RCONST(5289) = (KAPHO2*0.44)
  RCONST(5290) = (KAPHO2*0.56)
  RCONST(5291) = (KAPNO)
  RCONST(5292) = (KFPAN)
  RCONST(5293) = (KRO2NO3*1.74)
  RCONST(5294) = (1.00D-11*RO2)
  RCONST(5295) = (KAPHO2*0.44)
  RCONST(5296) = (KAPHO2*0.15)
  RCONST(5297) = (KAPHO2*0.41)
  RCONST(5298) = (KAPNO)
  RCONST(5299) = (KFPAN)
  RCONST(5300) = (KRO2NO3*1.74)
  RCONST(5301) = (1.00D-11*0.7*RO2)
  RCONST(5302) = (1.00D-11*0.3*RO2)
  RCONST(5303) = (KRO2HO2*0.706)
  RCONST(5304) = (KRO2NO)
  RCONST(5305) = (KRO2NO3)
  RCONST(5306) = (8.80D-13*0.2*RO2)
  RCONST(5307) = (8.80D-13*0.2*RO2)
  RCONST(5308) = (8.80D-13*0.6*RO2)
  RCONST(5309) = (KDEC)
  RCONST(5310) = (KAPHO2*0.44)
  RCONST(5311) = (KAPHO2*0.15)
  RCONST(5312) = (KAPHO2*0.41)
  RCONST(5313) = (KAPNO)
  RCONST(5314) = (KFPAN)
  RCONST(5315) = (KRO2NO3*1.74)
  RCONST(5316) = (1.00D-11*0.7*RO2)
  RCONST(5317) = (1.00D-11*0.3*RO2)
  RCONST(5318) = (KDEC)
  RCONST(5319) = (KRO2HO2*0.706)
  RCONST(5320) = (KRO2NO)
  RCONST(5321) = (KRO2NO3)
  RCONST(5322) = (8.80D-13*RO2)
  RCONST(5323) = (KAPHO2*0.44)
  RCONST(5324) = (KAPHO2*0.56)
  RCONST(5325) = (KAPNO)
  RCONST(5326) = (KFPAN)
  RCONST(5327) = (KRO2NO3*1.74)
  RCONST(5328) = (1.00D-11*RO2)
  RCONST(5329) = (KRO2HO2*0.706)
  RCONST(5330) = (KRO2NO)
  RCONST(5331) = (KRO2NO3)
  RCONST(5332) = (8.80D-13*RO2)
  RCONST(5333) = (KRO2HO2*0.706)
  RCONST(5334) = (KRO2NO)
  RCONST(5335) = (KRO2NO3)
  RCONST(5336) = (8.80D-13*RO2)
  RCONST(5337) = (KAPHO2*0.15)
  RCONST(5338) = (KAPHO2*0.41)
  RCONST(5339) = (KAPHO2*0.44)
  RCONST(5340) = (KAPNO)
  RCONST(5341) = (KFPAN)
  RCONST(5342) = (KRO2NO3*1.74)
  RCONST(5343) = (1.00D-11*0.3*RO2)
  RCONST(5344) = (1.00D-11*0.7*RO2)
  RCONST(5345) = (KDEC)
  RCONST(5346) = (KRO2HO2*0.706)
  RCONST(5347) = (KRO2NO)
  RCONST(5348) = (KRO2NO3)
  RCONST(5349) = (9.20D-14*0.7*RO2)
  RCONST(5350) = (9.20D-14*0.3*RO2)
  RCONST(5351) = (KDEC)
  RCONST(5352) = (KAPHO2*0.15)
  RCONST(5353) = (KAPHO2*0.41)
  RCONST(5354) = (KAPHO2*0.44)
  RCONST(5355) = (KAPNO)
  RCONST(5356) = (KFPAN)
  RCONST(5357) = (KRO2NO3*1.74)
  RCONST(5358) = (1.00D-11*0.3*RO2)
  RCONST(5359) = (1.00D-11*0.7*RO2)
  RCONST(5360) = (KDEC)
  RCONST(5361) = (KAPHO2*0.56)
  RCONST(5362) = (KAPHO2*0.44)
  RCONST(5363) = (KAPNO)
  RCONST(5364) = (KFPAN)
  RCONST(5365) = (KRO2NO3*1.74)
  RCONST(5366) = (1.00D-11*RO2)
  RCONST(5367) = (KRO2HO2*0.706)
  RCONST(5368) = (KRO2NO)
  RCONST(5369) = (KRO2NO3)
  RCONST(5370) = (2.00D-12*RO2)
  RCONST(5371) = (KAPHO2*0.44)
  RCONST(5372) = (KAPHO2*0.15)
  RCONST(5373) = (KAPHO2*0.41)
  RCONST(5374) = (KAPNO)
  RCONST(5375) = (KFPAN)
  RCONST(5376) = (KRO2NO3*1.74)
  RCONST(5377) = (1.00D-11*0.7*RO2)
  RCONST(5378) = (1.00D-11*0.3*RO2)
  RCONST(5379) = (KRO2HO2*0.770)
  RCONST(5380) = (KRO2NO)
  RCONST(5381) = (KRO2NO3)
  RCONST(5382) = (2.50D-13*0.2*RO2)
  RCONST(5383) = (2.50D-13*0.2*RO2)
  RCONST(5384) = (2.50D-13*0.6*RO2)
  RCONST(5385) = (KRO2HO2*0.770)
  RCONST(5386) = (KRO2NO)
  RCONST(5387) = (KRO2NO3)
  RCONST(5388) = (2.50D-13*0.6*RO2)
  RCONST(5389) = (2.50D-13*0.2*RO2)
  RCONST(5390) = (2.50D-13*0.2*RO2)
  RCONST(5391) = (KAPHO2*0.44)
  RCONST(5392) = (KAPHO2*0.56)
  RCONST(5393) = (KAPNO)
  RCONST(5394) = (KFPAN)
  RCONST(5395) = (KRO2NO3*1.74)
  RCONST(5396) = (1.00D-11*RO2)
  RCONST(5397) = (KRO2HO2*0.770)
  RCONST(5398) = (KRO2NO)
  RCONST(5399) = (KRO2NO3)
  RCONST(5400) = (2.50D-13*0.2*RO2)
  RCONST(5401) = (2.50D-13*0.6*RO2)
  RCONST(5402) = (2.50D-13*0.2*RO2)
  RCONST(5403) = (KRO2HO2*0.770)
  RCONST(5404) = (KRO2NO)
  RCONST(5405) = (KRO2NO3)
  RCONST(5406) = (8.80D-13*0.2*RO2)
  RCONST(5407) = (8.80D-13*0.6*RO2)
  RCONST(5408) = (8.80D-13*0.2*RO2)
  RCONST(5409) = (3.00D-13)
  RCONST(5410) = (2.20D-19)
  RCONST(5411) = (4.45D-11)
  RCONST(5412) = (KAPHO2*0.15)
  RCONST(5413) = (KAPHO2*0.41)
  RCONST(5414) = (KAPHO2*0.44)
  RCONST(5415) = (KAPNO)
  RCONST(5416) = (KFPAN)
  RCONST(5417) = (KRO2NO3*1.74)
  RCONST(5418) = (1.00D-11*0.30*RO2)
  RCONST(5419) = (1.00D-11*0.70*RO2)
  RCONST(5420) = (4.06D-11)
  RCONST(5421) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5422) = (4.37D-11)
  RCONST(5423) = (j('ch3o2h')+j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5424) = (4.05D-11)
  RCONST(5425) = (KBPAN)
  RCONST(5426) = (KAPHO2*0.44)
  RCONST(5427) = (KAPHO2*0.15)
  RCONST(5428) = (KAPHO2*0.41)
  RCONST(5429) = (KAPNO)
  RCONST(5430) = (KFPAN)
  RCONST(5431) = (KRO2NO3*1.74)
  RCONST(5432) = (1.00D-11*RO2*0.7)
  RCONST(5433) = (1.00D-11*RO2*0.3)
  RCONST(5434) = (KRO2HO2*0.520)
  RCONST(5435) = (KRO2NO)
  RCONST(5436) = (KRO2NO3)
  RCONST(5437) = (8.80D-13*RO2*0.2)
  RCONST(5438) = (8.80D-13*RO2*0.2)
  RCONST(5439) = (8.80D-13*RO2*0.6)
  RCONST(5440) = (1.31D-10)
  RCONST(5441) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(5442) = (4.38D-11)
  RCONST(5443) = (j('i_c3h7cho'))
  RCONST(5444) = (KDEC*0.5)
  RCONST(5445) = (KDEC*0.5)
  RCONST(5446) = (9.20D-11)
  RCONST(5447) = (j('n_c3h7cho_hco')*2+j('mek'))
  RCONST(5448) = (8.23D-11)
  RCONST(5449) = (j('n_c3h7cho_hco')*2)
  RCONST(5450) = (7.52D-11)
  RCONST(5451) = (j('ch3o2h'))
  RCONST(5452) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5453) = (KDEC)
  RCONST(5454) = (4.90D-11)
  RCONST(5455) = (j('ch3cocho')+j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5456) = (7.75D-11)
  RCONST(5457) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5458) = (KRO2HO2*0.625)
  RCONST(5459) = (KRO2NO)
  RCONST(5460) = (KRO2NO3)
  RCONST(5461) = (8.80D-13*0.20*RO2)
  RCONST(5462) = (8.80D-13*0.20*RO2)
  RCONST(5463) = (8.80D-13*0.60*RO2)
  RCONST(5464) = (9.00D-14)
  RCONST(5465) = (9.00D-13)
  RCONST(5466) = (1.07D-10)
  RCONST(5467) = (j('1_c4h9ono2'))
  RCONST(5468) = (j('ch3o2h'))
  RCONST(5469) = (KDEC)
  RCONST(5470) = (1.04D-10)
  RCONST(5471) = (j('1_c4h9ono2'))
  RCONST(5472) = (2.08D-12)
  RCONST(5473) = (2.86D-13)
  RCONST(5474) = (KDEC)
  RCONST(5475) = (1.16D-10)
  RCONST(5476) = (j('ch3o2h'))
  RCONST(5477) = (KDEC*0.71)
  RCONST(5478) = (KDEC*0.29)
  RCONST(5479) = (1.13D-10)
  RCONST(5480) = (1.15D-10)
  RCONST(5481) = (j('ch3o2h'))
  RCONST(5482) = (KDEC*0.68)
  RCONST(5483) = (KDEC*0.32)
  RCONST(5484) = (1.11D-10)
  RCONST(5485) = (1.07D-10)
  RCONST(5486) = (j('1_c4h9ono2'))
  RCONST(5487) = (j('ch3o2h'))
  RCONST(5488) = (KDEC)
  RCONST(5489) = (1.04D-10)
  RCONST(5490) = (j('1_c4h9ono2'))
  RCONST(5491) = (3.13D-13*1.0)
  RCONST(5492) = (2.8D-12)
  RCONST(5493) = (KRO2HO2*0.820)
  RCONST(5494) = (KRO2NO)
  RCONST(5495) = (KRO2NO3)
  RCONST(5496) = (2.50D-13*RO2)
  RCONST(5497) = (2.08D-12)
  RCONST(5498) = (2.86D-13)
  RCONST(5499) = (KDEC*1.0)
  RCONST(5500) = (KNO3AL*4.25)
  RCONST(5501) = (KNO3AL*4.25)
  RCONST(5502) = (5.00D-18*0.50)
  RCONST(5503) = (5.00D-18*0.50)
  RCONST(5504) = (4.41D-11*0.385)
  RCONST(5505) = (4.41D-11*0.23)
  RCONST(5506) = (4.41D-11*0.385)
  RCONST(5507) = (j('no2')*0.2*0.3)
  RCONST(5508) = (j('no2')*0.2*0.3)
  RCONST(5509) = (j('no2')*0.2*0.4)
  RCONST(5510) = (KNO3AL*2.75)
  RCONST(5511) = (2.00D-18*0.5)
  RCONST(5512) = (2.00D-18*0.5)
  RCONST(5513) = (6.2D-11*0.48)
  RCONST(5514) = (6.2D-11*0.52)
  RCONST(5515) = (j('no2')*0.2*0.6)
  RCONST(5516) = (j('no2')*0.2*0.4)
  RCONST(5517) = (1.00D-12)
  RCONST(5518) = (8.00D-19)
  RCONST(5519) = (6.90D-11)
  RCONST(5520) = (KAPHO2*0.44)
  RCONST(5521) = (KAPHO2*0.15)
  RCONST(5522) = (KAPHO2*0.41)
  RCONST(5523) = (KAPNO)
  RCONST(5524) = (KFPAN)
  RCONST(5525) = (KRO2NO3*1.74)
  RCONST(5526) = (1.00D-11*0.70*RO2)
  RCONST(5527) = (1.00D-11*0.30*RO2)
  RCONST(5528) = (5.98D-11)
  RCONST(5529) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5530) = (6.29D-11)
  RCONST(5531) = (j('ch3o2h')+j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5532) = (5.96D-11)
  RCONST(5533) = (KBPAN)
  RCONST(5534) = (1.2D-15)
  RCONST(5535) = (1.0D-14)
  RCONST(5536) = (1.0D-15)
  RCONST(5537) = (7.0D-14)
  RCONST(5538) = (1.0D-17*H2O)
  RCONST(5539) = (6.0D-18*H2O)
  RCONST(5540) = (7.04D-11)
  RCONST(5541) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(5542) = (3.06D-11)
  RCONST(5543) = (j('i_c3h7cho')+j('mek'))
  RCONST(5544) = (KDEC*0.50)
  RCONST(5545) = (KDEC*0.50)
  RCONST(5546) = (4.06D-11)
  RCONST(5547) = (j('i_c3h7cho')+j('biacet'))
  RCONST(5548) = (6.17D-11)
  RCONST(5549) = (j('i_c3h7cho')+j('mek'))
  RCONST(5550) = (9.42D-11)
  RCONST(5551) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5552) = (j('ch3o2h'))
  RCONST(5553) = (KDEC)
  RCONST(5554) = (6.45D-11)
  RCONST(5555) = (j('ch3cocho')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5556) = (1.18D-10)
  RCONST(5557) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5558) = (KAPHO2*0.44)
  RCONST(5559) = (KAPHO2*0.15)
  RCONST(5560) = (KAPHO2*0.41)
  RCONST(5561) = (KAPNO)
  RCONST(5562) = (KFPAN)
  RCONST(5563) = (KRO2NO3*1.74)
  RCONST(5564) = (1.00D-11*0.70*RO2)
  RCONST(5565) = (1.00D-11*0.30*RO2)
  RCONST(5566) = (8.06D-11)
  RCONST(5567) = (j('mek'))
  RCONST(5568) = (KNO3AL*4.25)
  RCONST(5569) = (5.00D-18*0.5)
  RCONST(5570) = (5.00D-18*0.5)
  RCONST(5571) = (7.10D-11*0.28)
  RCONST(5572) = (7.10D-11*0.72)
  RCONST(5573) = (j('no2')*0.2*0.6)
  RCONST(5574) = (j('no2')*0.2*0.4)
  RCONST(5575) = (1.00D-12)
  RCONST(5576) = (1.40D-18)
  RCONST(5577) = (3.01D-11)
  RCONST(5578) = (3.98D-11)
  RCONST(5579) = (j('ch2cch3cho_h')+j('ch2cch3cho_hco'))
  RCONST(5580) = (4.28D-11)
  RCONST(5581) = (j('ch3o2h')+j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5582) = (3.96D-11)
  RCONST(5583) = (KBPAN)
  RCONST(5584) = (KAPHO2*0.44)
  RCONST(5585) = (KAPHO2*0.15)
  RCONST(5586) = (KAPHO2*0.41)
  RCONST(5587) = (KAPNO)
  RCONST(5588) = (KFPAN)
  RCONST(5589) = (KRO2NO3*1.74)
  RCONST(5590) = (1.00D-11*RO2*0.70)
  RCONST(5591) = (1.00D-11*RO2*0.30)
  RCONST(5592) = (KRO2HO2*0.706)
  RCONST(5593) = (KRO2NO)
  RCONST(5594) = (KRO2NO3)
  RCONST(5595) = (9.20D-14*RO2)
  RCONST(5596) = (9.33D-11)
  RCONST(5597) = (j('ch3o2h')+j('i_c3h7cho')*2)
  RCONST(5598) = (3.27D-11)
  RCONST(5599) = (j('i_c3h7cho')*2)
  RCONST(5600) = (KDEC*0.5)
  RCONST(5601) = (KDEC*0.5)
  RCONST(5602) = (4.84D-11)
  RCONST(5603) = (j('i_c3h7cho')+j('ch3cocho'))
  RCONST(5604) = (8.11D-11)
  RCONST(5605) = (j('i_c3h7cho')*2)
  RCONST(5606) = (4.28D-11)
  RCONST(5607) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5608) = (j('mek'))
  RCONST(5609) = (j('ch3o2h'))
  RCONST(5610) = (KDEC)
  RCONST(5611) = (5.24D-11)
  RCONST(5612) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5613) = (j('mek'))
  RCONST(5614) = (1.43D-10)
  RCONST(5615) = (j('ch3o2h'))
  RCONST(5616) = (j('1_c4h9ono2'))
  RCONST(5617) = (KDEC)
  RCONST(5618) = (1.40D-10)
  RCONST(5619) = (j('1_c4h9ono2'))
  RCONST(5620) = (3.13D-13)
  RCONST(5621) = (1.53D-12)
  RCONST(5622) = (KRO2HO2*0.859)
  RCONST(5623) = (KRO2NO)
  RCONST(5624) = (KRO2NO3)
  RCONST(5625) = (2.50D-13*RO2)
  RCONST(5626) = (1.51D-10)
  RCONST(5627) = (j('ch3o2h'))
  RCONST(5628) = (KDEC*0.52)
  RCONST(5629) = (KDEC*0.48)
  RCONST(5630) = (1.48D-10)
  RCONST(5631) = (2.08D-12)
  RCONST(5632) = (2.86D-13)
  RCONST(5633) = (KDEC)
  RCONST(5634) = (KAPHO2*0.44)
  RCONST(5635) = (KAPHO2*0.15)
  RCONST(5636) = (KAPHO2*0.41)
  RCONST(5637) = (KAPNO)
  RCONST(5638) = (KFPAN)
  RCONST(5639) = (KRO2NO3*1.74)
  RCONST(5640) = (1.00D-11*0.70*RO2)
  RCONST(5641) = (1.00D-11*0.30*RO2)
  RCONST(5642) = (KRO2HO2*0.820)
  RCONST(5643) = (KRO2NO)
  RCONST(5644) = (KRO2NO3)
  RCONST(5645) = (2.50D-13*RO2)
  RCONST(5646) = (KNO3AL*4.25)
  RCONST(5647) = (2.0D-18*0.5)
  RCONST(5648) = (2.0D-18*0.5)
  RCONST(5649) = (7.00D-11*0.5)
  RCONST(5650) = (7.00D-11*0.5)
  RCONST(5651) = (j('no2')*0.2*0.6)
  RCONST(5652) = (j('no2')*0.2*0.4)
  RCONST(5653) = (1.00D-12)
  RCONST(5654) = (8.00D-19)
  RCONST(5655) = (2.67D-11)
  RCONST(5656) = (1.00D-12)
  RCONST(5657) = (8.00D-19)
  RCONST(5658) = (2.42D-11)
  RCONST(5659) = (KAPHO2*0.44)
  RCONST(5660) = (KAPHO2*0.56)
  RCONST(5661) = (KAPNO)
  RCONST(5662) = (KFPAN)
  RCONST(5663) = (KRO2NO3*1.74)
  RCONST(5664) = (1.00D-11*RO2)
  RCONST(5665) = (6.00D-11)
  RCONST(5666) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5667) = (6.31D-11)
  RCONST(5668) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5669) = (5.99D-11)
  RCONST(5670) = (KBPAN)
  RCONST(5671) = (KAPHO2*0.44)
  RCONST(5672) = (KAPHO2*0.15)
  RCONST(5673) = (KAPHO2*0.41)
  RCONST(5674) = (KAPNO)
  RCONST(5675) = (KFPAN)
  RCONST(5676) = (KRO2NO3*1.74)
  RCONST(5677) = (1.00D-11*RO2*0.70)
  RCONST(5678) = (1.00D-11*RO2*0.30)
  RCONST(5679) = (KRO2HO2*0.625)
  RCONST(5680) = (KRO2NO)
  RCONST(5681) = (KRO2NO3)
  RCONST(5682) = (9.20D-14*RO2*0.7)
  RCONST(5683) = (9.20D-14*RO2*0.3)
  RCONST(5684) = (7.41D-11)
  RCONST(5685) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(5686) = (3.08D-11)
  RCONST(5687) = (j('i_c3h7cho')+j('mek'))
  RCONST(5688) = (KDEC*0.5)
  RCONST(5689) = (KDEC*0.5)
  RCONST(5690) = (4.08D-11)
  RCONST(5691) = (j('i_c3h7cho')+j('biacet'))
  RCONST(5692) = (6.20D-11)
  RCONST(5693) = (j('i_c3h7cho')+j('mek'))
  RCONST(5694) = (7.36D-11)
  RCONST(5695) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5696) = (KDEC)
  RCONST(5697) = (5.22D-11)
  RCONST(5698) = (j('biacet')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5699) = (9.76D-11)
  RCONST(5700) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5701) = (3.13D-13)
  RCONST(5702) = (1.53D-12)
  RCONST(5703) = (KRO2HO2*0.859)
  RCONST(5704) = (KRO2NO)
  RCONST(5705) = (KRO2NO3)
  RCONST(5706) = (2.50D-13*RO2)
  RCONST(5707) = (1.13D-10)
  RCONST(5708) = (j('ch3o2h'))
  RCONST(5709) = (KDEC*0.85)
  RCONST(5710) = (KDEC*0.15)
  RCONST(5711) = (1.10D-10)
  RCONST(5712) = (1.07D-10)
  RCONST(5713) = (j('1_c4h9ono2'))
  RCONST(5714) = (j('ch3o2h'))
  RCONST(5715) = (KDEC)
  RCONST(5716) = (1.03D-10)
  RCONST(5717) = (j('1_c4h9ono2'))
  RCONST(5718) = (2.08D-12)
  RCONST(5719) = (2.86D-13)
  RCONST(5720) = (KDEC)
  RCONST(5721) = (KAPHO2*0.44)
  RCONST(5722) = (KAPHO2*0.15)
  RCONST(5723) = (KAPHO2*0.41)
  RCONST(5724) = (KAPNO)
  RCONST(5725) = (KFPAN)
  RCONST(5726) = (KRO2NO3*1.74)
  RCONST(5727) = (1.00D-11*0.70*RO2)
  RCONST(5728) = (1.00D-11*0.30*RO2)
  RCONST(5729) = (KRO2HO2*0.820)
  RCONST(5730) = (KRO2NO)
  RCONST(5731) = (KRO2NO3)
  RCONST(5732) = (2.50D-13*RO2)
  RCONST(5733) = (5.00D-18)
  RCONST(5734) = (4.90D-11)
  RCONST(5735) = (j('no2')*0.0057)
  RCONST(5736) = (5.87D-11)
  RCONST(5737) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5738) = (6.18D-11)
  RCONST(5739) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5740) = (5.85D-11)
  RCONST(5741) = (KBPAN)
  RCONST(5742) = (7.26D-11)
  RCONST(5743) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(5744) = (2.92D-11)
  RCONST(5745) = (j('i_c3h7cho')+j('mek'))
  RCONST(5746) = (KDEC*0.5)
  RCONST(5747) = (KDEC*0.5)
  RCONST(5748) = (3.58D-11)
  RCONST(5749) = (j('i_c3h7cho')+j('biacet'))
  RCONST(5750) = (6.03D-11)
  RCONST(5751) = (j('i_c3h7cho')+j('mek'))
  RCONST(5752) = (8.25D-11)
  RCONST(5753) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5754) = (j('ch3o2h'))
  RCONST(5755) = (j('i_c3h7cho'))
  RCONST(5756) = (KDEC)
  RCONST(5757) = (1.14D-10)
  RCONST(5758) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5759) = (j('i_c3h7cho'))
  RCONST(5760) = (1.43D-10)
  RCONST(5761) = (j('ch3o2h'))
  RCONST(5762) = (j('1_c4h9ono2'))
  RCONST(5763) = (KDEC)
  RCONST(5764) = (1.40D-10)
  RCONST(5765) = (j('1_c4h9ono2'))
  RCONST(5766) = (3.13D-13)
  RCONST(5767) = (1.53D-12)
  RCONST(5768) = (KRO2HO2*0.859)
  RCONST(5769) = (KRO2NO)
  RCONST(5770) = (KRO2NO3)
  RCONST(5771) = (2.50D-13*RO2)
  RCONST(5772) = (1.51D-10)
  RCONST(5773) = (j('ch3o2h'))
  RCONST(5774) = (KDEC*0.68)
  RCONST(5775) = (KDEC*0.32)
  RCONST(5776) = (1.48D-10)
  RCONST(5777) = (2.08D-12)
  RCONST(5778) = (2.86D-13)
  RCONST(5779) = (KDEC)
  RCONST(5780) = (KAPHO2*0.15)
  RCONST(5781) = (KAPHO2*0.41)
  RCONST(5782) = (KAPHO2*0.44)
  RCONST(5783) = (KAPNO)
  RCONST(5784) = (KFPAN)
  RCONST(5785) = (KRO2NO3*1.74)
  RCONST(5786) = (1.00D-11*0.30*RO2)
  RCONST(5787) = (1.00D-11*0.70*RO2)
  RCONST(5788) = (3.13D-13*1.0)
  RCONST(5789) = (1.53D-12)
  RCONST(5790) = (KRO2HO2*0.859)
  RCONST(5791) = (KRO2NO)
  RCONST(5792) = (KRO2NO3)
  RCONST(5793) = (2.50D-13*RO2)
  RCONST(5794) = (1.15D-10)
  RCONST(5795) = (j('ch3o2h'))
  RCONST(5796) = (KDEC*0.68)
  RCONST(5797) = (KDEC*0.32)
  RCONST(5798) = (1.11D-10)
  RCONST(5799) = (1.07D-10)
  RCONST(5800) = (j('1_c4h9ono2'))
  RCONST(5801) = (j('ch3o2h'))
  RCONST(5802) = (KDEC)
  RCONST(5803) = (1.04D-10)
  RCONST(5804) = (j('1_c4h9ono2'))
  RCONST(5805) = (2.08D-12)
  RCONST(5806) = (2.86D-13)
  RCONST(5807) = (KDEC*1.0)
  RCONST(5808) = (KNO3AL*2.75)
  RCONST(5809) = (2.00D-18*0.5)
  RCONST(5810) = (2.00D-18*0.5)
  RCONST(5811) = (5.58D-11*0.5)
  RCONST(5812) = (5.58D-11*0.5)
  RCONST(5813) = (j('no2')*0.2*0.6)
  RCONST(5814) = (j('no2')*0.2*0.4)
  RCONST(5815) = (1.00D-12)
  RCONST(5816) = (8.00D-19)
  RCONST(5817) = (2.29D-11)
  RCONST(5818) = (KAPHO2*0.44)
  RCONST(5819) = (KAPHO2*0.15)
  RCONST(5820) = (KAPHO2*0.41)
  RCONST(5821) = (KAPNO)
  RCONST(5822) = (KFPAN)
  RCONST(5823) = (KRO2NO3*1.74)
  RCONST(5824) = (1.00D-11*0.70*RO2)
  RCONST(5825) = (1.00D-11*0.30*RO2)
  RCONST(5826) = (6.09D-11)
  RCONST(5827) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5828) = (6.40D-11)
  RCONST(5829) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5830) = (6.08D-11)
  RCONST(5831) = (KBPAN)
  RCONST(5832) = (1.20D-15)
  RCONST(5833) = (1.00D-14)
  RCONST(5834) = (1.00D-15)
  RCONST(5835) = (7.00D-14)
  RCONST(5836) = (1.00D-17*H2O)
  RCONST(5837) = (6.00D-18*H2O)
  RCONST(5838) = (7.51D-11)
  RCONST(5839) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(5840) = (3.17D-11)
  RCONST(5841) = (j('i_c3h7cho')+j('mek'))
  RCONST(5842) = (KDEC*0.5)
  RCONST(5843) = (KDEC*0.5)
  RCONST(5844) = (4.25D-11)
  RCONST(5845) = (j('i_c3h7cho')+j('biacet'))
  RCONST(5846) = (6.29D-11)
  RCONST(5847) = (j('i_c3h7cho')+j('mek'))
  RCONST(5848) = (9.53D-11)
  RCONST(5849) = (j('i_c3h7cho')+j('mvk_mcm_co'))
  RCONST(5850) = (j('ch3o2h')+j('mvk_mcm_ch2ch'))
  RCONST(5851) = (KDEC)
  RCONST(5852) = (1.19D-11)
  RCONST(5853) = (j('i_c3h7cho')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5854) = (6.78D-11)
  RCONST(5855) = (j('ch3cocho'))
  RCONST(5856) = (KRO2HO2*0.890)
  RCONST(5857) = (KRO2NO)
  RCONST(5858) = (KRO2NO3)
  RCONST(5859) = (8.80D-13*RO2*0.2)
  RCONST(5860) = (8.80D-13*RO2*0.6)
  RCONST(5861) = (8.80D-13*RO2*0.2)
  RCONST(5862) = (1.07D-10)
  RCONST(5863) = (j('ch3o2h'))
  RCONST(5864) = (j('1_c4h9ono2'))
  RCONST(5865) = (KDEC)
  RCONST(5866) = (1.04D-10)
  RCONST(5867) = (j('1_c4h9ono2'))
  RCONST(5868) = (3.13D-13*1.0)
  RCONST(5869) = (1.53D-12)
  RCONST(5870) = (KRO2HO2*0.90)
  RCONST(5871) = (KRO2NO)
  RCONST(5872) = (KRO2NO3)
  RCONST(5873) = (2.50D-13*RO2)
  RCONST(5874) = (1.15D-10)
  RCONST(5875) = (j('ch3o2h'))
  RCONST(5876) = (KDEC*0.68)
  RCONST(5877) = (KDEC*0.32)
  RCONST(5878) = (1.11D-10)
  RCONST(5879) = (2.08D-12)
  RCONST(5880) = (2.86D-13)
  RCONST(5881) = (KDEC*1.0)
  RCONST(5882) = (KNO3AL*5.5)
  RCONST(5883) = (1.67D-11)
  RCONST(5884) = (j('ch3cocho'))
  RCONST(5885) = (KNO3AL*2.75)
  RCONST(5886) = (2.00D-18*0.5)
  RCONST(5887) = (2.00D-18*0.5)
  RCONST(5888) = (5.58D-11*0.50)
  RCONST(5889) = (5.58D-11*0.50)
  RCONST(5890) = (j('no2')*0.2*0.6)
  RCONST(5891) = (j('no2')*0.2*0.4)
  RCONST(5892) = (1.00D-12)
  RCONST(5893) = (8.00D-19)
  RCONST(5894) = (2.43D-11)
  RCONST(5895) = (KAPHO2*0.44)
  RCONST(5896) = (KAPHO2*0.15)
  RCONST(5897) = (KAPHO2*0.41)
  RCONST(5898) = (KAPNO)
  RCONST(5899) = (KFPAN)
  RCONST(5900) = (KRO2NO3*1.74)
  RCONST(5901) = (1.00D-11*RO2*0.7)
  RCONST(5902) = (1.00D-11*RO2*0.3)
  RCONST(5903) = (6.44D-11)
  RCONST(5904) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5905) = (6.74D-11)
  RCONST(5906) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5907) = (6.42D-11)
  RCONST(5908) = (KBPAN)
  RCONST(5909) = (1.20D-15)
  RCONST(5910) = (1.00D-14)
  RCONST(5911) = (1.00D-15)
  RCONST(5912) = (7.00D-14)
  RCONST(5913) = (6.00D-18*H2O)
  RCONST(5914) = (1.00D-17*H2O)
  RCONST(5915) = (7.85D-11)
  RCONST(5916) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(5917) = (3.51D-11)
  RCONST(5918) = (j('i_c3h7cho')+j('mek'))
  RCONST(5919) = (KDEC*0.5)
  RCONST(5920) = (KDEC*0.5)
  RCONST(5921) = (4.61D-11)
  RCONST(5922) = (j('i_c3h7cho')+j('biacet'))
  RCONST(5923) = (6.63D-11)
  RCONST(5924) = (j('i_c3h7cho')+j('mek'))
  RCONST(5925) = (9.87D-11)
  RCONST(5926) = (j('i_c3h7cho')+j('mvk_mcm_co'))
  RCONST(5927) = (j('ch3o2h')+j('mvk_mcm_ch2ch'))
  RCONST(5928) = (KDEC)
  RCONST(5929) = (1.23D-10)
  RCONST(5930) = (j('i_c3h7cho')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5931) = (6.91D-11)
  RCONST(5932) = (j('ch3cocho'))
  RCONST(5933) = (6.00D-12)
  RCONST(5934) = (j('mek'))
  RCONST(5935) = (3.13D-13*1.0)
  RCONST(5936) = (1.53D-12)
  RCONST(5937) = (KRO2HO2*0.90)
  RCONST(5938) = (KRO2NO)
  RCONST(5939) = (KRO2NO3)
  RCONST(5940) = (2.50D-13*RO2)
  RCONST(5941) = (1.15D-10)
  RCONST(5942) = (j('ch3o2h'))
  RCONST(5943) = (KDEC*0.68)
  RCONST(5944) = (KDEC*0.32)
  RCONST(5945) = (1.11D-10)
  RCONST(5946) = (1.07D-10)
  RCONST(5947) = (j('1_c4h9ono2'))
  RCONST(5948) = (j('ch3o2h'))
  RCONST(5949) = (KDEC)
  RCONST(5950) = (1.04D-10)
  RCONST(5951) = (j('1_c4h9ono2'))
  RCONST(5952) = (2.08D-12)
  RCONST(5953) = (2.86D-13)
  RCONST(5954) = (KDEC*1.0)
  RCONST(5955) = (KNO3AL*4.25)
  RCONST(5956) = (2.00D-18*0.5)
  RCONST(5957) = (2.00D-18*0.5)
  RCONST(5958) = (5.58D-11*0.50)
  RCONST(5959) = (5.58D-11*0.50)
  RCONST(5960) = (j('no2')*0.2*0.6)
  RCONST(5961) = (j('no2')*0.2*0.4)
  RCONST(5962) = (j('no2')*0.05*0.34)
  RCONST(5963) = (1.00D-12)
  RCONST(5964) = (8.00D-19)
  RCONST(5965) = (2.43D-11)
  RCONST(5966) = (KAPHO2*0.44)
  RCONST(5967) = (KAPHO2*0.15)
  RCONST(5968) = (KAPHO2*0.41)
  RCONST(5969) = (KAPNO)
  RCONST(5970) = (KFPAN)
  RCONST(5971) = (KRO2NO3*1.74)
  RCONST(5972) = (1.00D-11*RO2*0.7)
  RCONST(5973) = (1.00D-11*RO2*0.3)
  RCONST(5974) = (6.22D-11)
  RCONST(5975) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5976) = (6.53D-11)
  RCONST(5977) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5978) = (6.21D-11)
  RCONST(5979) = (KBPAN)
  RCONST(5980) = (1.20D-15)
  RCONST(5981) = (1.00D-14)
  RCONST(5982) = (1.00D-15)
  RCONST(5983) = (7.00D-14)
  RCONST(5984) = (1.00D-17*H2O)
  RCONST(5985) = (6.00D-18*H2O)
  RCONST(5986) = (7.64D-11)
  RCONST(5987) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(5988) = (3.30D-11)
  RCONST(5989) = (j('i_c3h7cho')+j('mek'))
  RCONST(5990) = (KDEC*0.5)
  RCONST(5991) = (KDEC*0.5)
  RCONST(5992) = (4.47D-11)
  RCONST(5993) = (j('i_c3h7cho')+j('biacet'))
  RCONST(5994) = (6.42D-11)
  RCONST(5995) = (j('i_c3h7cho')+j('mek'))
  RCONST(5996) = (9.66D-11)
  RCONST(5997) = (j('ch3o2h')+j('mvk_mcm_ch2ch'))
  RCONST(5998) = (j('i_c3h7cho')+j('mvk_mcm_co'))
  RCONST(5999) = (KDEC)
  RCONST(6000) = (1.21D-10)
  RCONST(6001) = (j('i_c3h7cho')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6002) = (6.70D-11)
  RCONST(6003) = (j('ch3cocho'))
  RCONST(6004) = (KAPHO2*0.44)
  RCONST(6005) = (KAPHO2*0.15)
  RCONST(6006) = (KAPHO2*0.41)
  RCONST(6007) = (KAPNO)
  RCONST(6008) = (KFPAN)
  RCONST(6009) = (KRO2NO3*1.74)
  RCONST(6010) = (1.00D-11*RO2*0.70)
  RCONST(6011) = (1.00D-11*RO2*0.30)
  RCONST(6012) = (1.85D-10)
  RCONST(6013) = (j('ch3o2h'))
  RCONST(6014) = (j('1_c4h9ono2'))
  RCONST(6015) = (KDEC)
  RCONST(6016) = (1.81D-10)
  RCONST(6017) = (j('1_c4h9ono2'))
  RCONST(6018) = (3.13D-13)
  RCONST(6019) = (1.53D-12)
  RCONST(6020) = (KRO2HO2*0.90)
  RCONST(6021) = (KRO2NO)
  RCONST(6022) = (KRO2NO3)
  RCONST(6023) = (2.50D-13*RO2)
  RCONST(6024) = (1.89D-10)
  RCONST(6025) = (j('ch3o2h'))
  RCONST(6026) = (KDEC)
  RCONST(6027) = (1.85D-10)
  RCONST(6028) = (2.08D-12)
  RCONST(6029) = (2.86D-13)
  RCONST(6030) = (KDEC)
  RCONST(6031) = (KNO3AL*4.25)
  RCONST(6032) = (5.58D-11*0.50)
  RCONST(6033) = (5.58D-11*0.50)
  RCONST(6034) = (j('no2')*0.2*0.6)
  RCONST(6035) = (j('no2')*0.2*0.4)
  RCONST(6036) = (1.00D-12)
  RCONST(6037) = (8.00D-17)
  RCONST(6038) = (2.66D-11)
  RCONST(6039) = (1.00D-12)
  RCONST(6040) = (1.40D-18)
  RCONST(6041) = (3.26D-11)
  RCONST(6042) = (KAPHO2*0.44)
  RCONST(6043) = (KAPHO2*0.15)
  RCONST(6044) = (KAPHO2*0.41)
  RCONST(6045) = (KAPNO)
  RCONST(6046) = (KFPAN)
  RCONST(6047) = (KRO2NO3*1.74)
  RCONST(6048) = (1.00D-11*RO2*0.70)
  RCONST(6049) = (1.00D-11*RO2*0.30)
  RCONST(6050) = (KRO2HO2*0.625)
  RCONST(6051) = (KRO2NO)
  RCONST(6052) = (KRO2NO3)
  RCONST(6053) = (8.80D-12*RO2)
  RCONST(6054) = (9.05D-11)
  RCONST(6055) = (j('ch3o2h')+j('mek')*2)
  RCONST(6056) = (KDEC*0.5)
  RCONST(6057) = (KDEC*0.5)
  RCONST(6058) = (2.88D-12)
  RCONST(6059) = (j('mek')*2)
  RCONST(6060) = (5.65D-12)
  RCONST(6061) = (j('mek'))
  RCONST(6062) = (j('mek')*2)
  RCONST(6063) = (4.14D-11)
  RCONST(6064) = (j('mek')*2)
  RCONST(6065) = (KAPHO2*0.44)
  RCONST(6066) = (KAPHO2*0.15)
  RCONST(6067) = (KAPHO2*0.41)
  RCONST(6068) = (KAPNO)
  RCONST(6069) = (KFPAN)
  RCONST(6070) = (KRO2NO3*1.74)
  RCONST(6071) = (1.00D-11*RO2*0.70)
  RCONST(6072) = (1.00D-11*RO2*0.30)
  RCONST(6073) = (KRO2HO2*0.859)
  RCONST(6074) = (KRO2NO)
  RCONST(6075) = (KRO2NO3)
  RCONST(6076) = (2.50D-13*RO2)
  RCONST(6077) = (1.25D-17*0.5)
  RCONST(6078) = (1.25D-17*0.5)
  RCONST(6079) = (6.90D-11)
  RCONST(6080) = (j('no2')*0.0057*0.5)
  RCONST(6081) = (j('no2')*0.0057*0.5)
  RCONST(6082) = (1.43D-10)
  RCONST(6083) = (j('ch3o2h'))
  RCONST(6084) = (j('1_c4h9ono2'))
  RCONST(6085) = (KDEC)
  RCONST(6086) = (1.40D-10)
  RCONST(6087) = (j('1_c4h9ono2'))
  RCONST(6088) = (3.13D-13)
  RCONST(6089) = (1.53D-12)
  RCONST(6090) = (KRO2HO2*0.90)
  RCONST(6091) = (KRO2NO)
  RCONST(6092) = (KRO2NO3)
  RCONST(6093) = (2.50D-13*RO2)
  RCONST(6094) = (1.51D-10)
  RCONST(6095) = (j('ch3o2h'))
  RCONST(6096) = (KDEC*0.78)
  RCONST(6097) = (KDEC*0.22)
  RCONST(6098) = (1.48D-10)
  RCONST(6099) = (2.08D-12)
  RCONST(6100) = (2.86D-13)
  RCONST(6101) = (KDEC)
  RCONST(6102) = (5.89D-11)
  RCONST(6103) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6104) = (6.20D-11)
  RCONST(6105) = (j('ch3o2h'))
  RCONST(6106) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6107) = (5.88D-11)
  RCONST(6108) = (KBPAN)
  RCONST(6109) = (1.10D-10)
  RCONST(6110) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(6111) = (KDEC*0.5)
  RCONST(6112) = (KDEC*0.5)
  RCONST(6113) = (2.33D-11)
  RCONST(6114) = (j('i_c3h7cho')+j('mek'))
  RCONST(6115) = (2.58D-11)
  RCONST(6116) = (j('i_c3h7cho')+j('mek')*2)
  RCONST(6117) = (6.06D-11)
  RCONST(6118) = (j('i_c3h7cho')+j('mek'))
  RCONST(6119) = (6.19D-11)
  RCONST(6120) = (j('mvk_mcm_ch2ch'))
  RCONST(6121) = (j('ch3o2h'))
  RCONST(6122) = (j('mek'))
  RCONST(6123) = (KDEC)
  RCONST(6124) = (9.30D-11)
  RCONST(6125) = (j('mvk_mcm_ch2ch'))
  RCONST(6126) = (j('mek'))
  RCONST(6127) = (KAPHO2*0.44)
  RCONST(6128) = (KAPHO2*0.15)
  RCONST(6129) = (KAPHO2*0.41)
  RCONST(6130) = (KAPNO)
  RCONST(6131) = (KFPAN)
  RCONST(6132) = (KRO2NO3*1.74)
  RCONST(6133) = (1.00D-11*0.70*RO2)
  RCONST(6134) = (1.00D-11*0.30*RO2)
  RCONST(6135) = (KRO2HO2*0.890)
  RCONST(6136) = (KRO2NO)
  RCONST(6137) = (KRO2NO3)
  RCONST(6138) = (2.50D-13*RO2)
  RCONST(6139) = (KAPHO2*0.44)
  RCONST(6140) = (KAPHO2*0.56)
  RCONST(6141) = (KAPNO)
  RCONST(6142) = (KFPAN)
  RCONST(6143) = (KRO2NO3*1.74)
  RCONST(6144) = (1.00D-11*0.70*RO2)
  RCONST(6145) = (1.00D-11*0.30*RO2)
  RCONST(6146) = (1.44D-10)
  RCONST(6147) = (j('ch3o2h'))
  RCONST(6148) = (j('1_c4h9ono2'))
  RCONST(6149) = (KDEC)
  RCONST(6150) = (1.40D-10)
  RCONST(6151) = (j('1_c4h9ono2'))
  RCONST(6152) = (1.50D-10)
  RCONST(6153) = (j('ch3o2h'))
  RCONST(6154) = (KDEC)
  RCONST(6155) = (1.47D-10)
  RCONST(6156) = (8.08D-11)
  RCONST(6157) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6158) = (8.38D-11)
  RCONST(6159) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6160) = (8.06D-11)
  RCONST(6161) = (KBPAN)
  RCONST(6162) = (KAPHO2*0.44)
  RCONST(6163) = (KAPHO2*0.15)
  RCONST(6164) = (KAPHO2*0.41)
  RCONST(6165) = (KAPNO)
  RCONST(6166) = (KFPAN)
  RCONST(6167) = (KRO2NO3*1.74)
  RCONST(6168) = (1.00D-11*RO2*0.70)
  RCONST(6169) = (1.00D-11*RO2*0.30)
  RCONST(6170) = (KRO2HO2*0.706)
  RCONST(6171) = (KRO2NO)
  RCONST(6172) = (KRO2NO3)
  RCONST(6173) = (8.80D-13*RO2)
  RCONST(6174) = (3.30D-11)
  RCONST(6175) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(6176) = (KDEC*0.5)
  RCONST(6177) = (KDEC*0.5)
  RCONST(6178) = (2.31D-11)
  RCONST(6179) = (j('i_c3h7cho')+j('mek'))
  RCONST(6180) = (2.96D-11)
  RCONST(6181) = (j('i_c3h7cho')+j('mek'))
  RCONST(6182) = (9.44D-11)
  RCONST(6183) = (j('mek'))
  RCONST(6184) = (j('ch3o2h'))
  RCONST(6185) = (j('mvk_mcm_co'))
  RCONST(6186) = (KDEC)
  RCONST(6187) = (1.31D-10)
  RCONST(6188) = (j('mvk_mcm_co')+j('mek'))
  RCONST(6189) = (7.10D-11)
  RCONST(6190) = (j('mvk_mcm_co'))
  RCONST(6191) = (j('biacet'))
  RCONST(6192) = (KRO2HO2*0.890)
  RCONST(6193) = (KRO2NO)
  RCONST(6194) = (KRO2NO3)
  RCONST(6195) = (8.80D-13*RO2*0.6)
  RCONST(6196) = (8.80D-13*RO2*0.2)
  RCONST(6197) = (8.80D-13*RO2*0.2)
  RCONST(6198) = (4.31D-11)
  RCONST(6199) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(6200) = (4.61D-11)
  RCONST(6201) = (j('ch3o2h')+j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(6202) = (4.29D-11)
  RCONST(6203) = (KBPAN)
  RCONST(6204) = (KAPHO2*0.44)
  RCONST(6205) = (KAPHO2*0.15)
  RCONST(6206) = (KAPHO2*0.41)
  RCONST(6207) = (KAPNO)
  RCONST(6208) = (KFPAN)
  RCONST(6209) = (KRO2NO3*1.74)
  RCONST(6210) = (1.00D-11*RO2*0.70)
  RCONST(6211) = (1.00D-11*RO2*0.30)
  RCONST(6212) = (KRO2HO2*0.770)
  RCONST(6213) = (KRO2NO)
  RCONST(6214) = (KRO2NO3)
  RCONST(6215) = (9.20D-14*RO2)
  RCONST(6216) = (9.66D-11)
  RCONST(6217) = (j('ch3o2h')+j('i_c3h7cho')*2)
  RCONST(6218) = (3.59D-11)
  RCONST(6219) = (j('i_c3h7cho')*2)
  RCONST(6220) = (KDEC*0.5)
  RCONST(6221) = (KDEC*0.5)
  RCONST(6222) = (5.17D-11)
  RCONST(6223) = (j('i_c3h7cho')+j('ch3cocho'))
  RCONST(6224) = (8.44D-11)
  RCONST(6225) = (j('i_c3h7cho')*2)
  RCONST(6226) = (4.39D-11)
  RCONST(6227) = (j('mek'))
  RCONST(6228) = (j('ch3o2h')+j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(6229) = (KDEC)
  RCONST(6230) = (5.35D-11)
  RCONST(6231) = (j('mek'))
  RCONST(6232) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(6233) = (1.82D-10)
  RCONST(6234) = (j('ch3o2h'))
  RCONST(6235) = (j('1_c4h9ono2'))
  RCONST(6236) = (KDEC)
  RCONST(6237) = (1.79D-10)
  RCONST(6238) = (j('1_c4h9ono2'))
  RCONST(6239) = (3.13D-13)
  RCONST(6240) = (1.53D-12)
  RCONST(6241) = (KRO2HO2*0.90)
  RCONST(6242) = (KRO2NO)
  RCONST(6243) = (KRO2NO3)
  RCONST(6244) = (2.50D-13*RO2)
  RCONST(6245) = (1.51D-10)
  RCONST(6246) = (j('ch3o2h'))
  RCONST(6247) = (KDEC*0.52)
  RCONST(6248) = (KDEC*0.48)
  RCONST(6249) = (1.48D-10)
  RCONST(6250) = (2.08D-12)
  RCONST(6251) = (2.86D-13)
  RCONST(6252) = (KDEC)
  RCONST(6253) = (6.12D-11)
  RCONST(6254) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6255) = (6.42D-11)
  RCONST(6256) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6257) = (6.10D-11)
  RCONST(6258) = (KBPAN)
  RCONST(6259) = (7.53D-11)
  RCONST(6260) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(6261) = (3.19D-11)
  RCONST(6262) = (j('i_c3h7cho')+j('mek'))
  RCONST(6263) = (KDEC*0.5)
  RCONST(6264) = (KDEC*0.5)
  RCONST(6265) = (4.27D-11)
  RCONST(6266) = (j('i_c3h7cho')+j('biacet'))
  RCONST(6267) = (6.31D-11)
  RCONST(6268) = (j('i_c3h7cho')+j('mek'))
  RCONST(6269) = (7.47D-11)
  RCONST(6270) = (j('mek'))
  RCONST(6271) = (j('ch3o2h')+j('mvk_mcm_co')*2)
  RCONST(6272) = (KDEC)
  RCONST(6273) = (5.33D-11)
  RCONST(6274) = (j('ch3cocho'))
  RCONST(6275) = (j('mvk_mcm_co')*2)
  RCONST(6276) = (9.87D-11)
  RCONST(6277) = (j('mek'))
  RCONST(6278) = (j('mvk_mcm_co')*2)
  RCONST(6279) = (3.13D-13)
  RCONST(6280) = (1.53D-12)
  RCONST(6281) = (KRO2HO2*0.90)
  RCONST(6282) = (KRO2NO)
  RCONST(6283) = (KRO2NO3)
  RCONST(6284) = (2.50D-13*RO2)
  RCONST(6285) = (1.14D-10)
  RCONST(6286) = (j('ch3o2h'))
  RCONST(6287) = (KDEC*0.85)
  RCONST(6288) = (KDEC*0.15)
  RCONST(6289) = (1.11D-10)
  RCONST(6290) = (1.08D-10)
  RCONST(6291) = (j('1_c4h9ono2'))
  RCONST(6292) = (j('ch3o2h'))
  RCONST(6293) = (KDEC)
  RCONST(6294) = (1.05D-10)
  RCONST(6295) = (j('1_c4h9ono2'))
  RCONST(6296) = (2.08D-12)
  RCONST(6297) = (2.86D-13)
  RCONST(6298) = (KDEC)
  RCONST(6299) = (5.00D-18*0.5)
  RCONST(6300) = (5.00D-18*0.5)
  RCONST(6301) = (6.90D-11)
  RCONST(6302) = (j('no2')*0.0057*0.5)
  RCONST(6303) = (j('no2')*0.0057*0.5)
  RCONST(6304) = (5.98D-11)
  RCONST(6305) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6306) = (6.29D-11)
  RCONST(6307) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6308) = (5.97D-11)
  RCONST(6309) = (KBPAN)
  RCONST(6310) = (7.37D-11)
  RCONST(6311) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(6312) = (3.03D-11)
  RCONST(6313) = (j('i_c3h7cho')+j('mek'))
  RCONST(6314) = (KDEC*0.5)
  RCONST(6315) = (KDEC*0.5)
  RCONST(6316) = (3.77D-11)
  RCONST(6317) = (j('i_c3h7cho')+j('biacet'))
  RCONST(6318) = (6.15D-11)
  RCONST(6319) = (j('i_c3h7cho')+j('mek'))
  RCONST(6320) = (8.36D-11)
  RCONST(6321) = (j('mvk_mcm_co')*2)
  RCONST(6322) = (j('i_c3h7cho'))
  RCONST(6323) = (j('ch3o2h'))
  RCONST(6324) = (KDEC)
  RCONST(6325) = (1.15D-10)
  RCONST(6326) = (j('mvk_mcm_co')*2)
  RCONST(6327) = (j('i_c3h7cho'))
  RCONST(6328) = (1.43D-10)
  RCONST(6329) = (j('ch3o2h'))
  RCONST(6330) = (j('1_c4h9ono2'))
  RCONST(6331) = (KDEC)
  RCONST(6332) = (1.40D-10)
  RCONST(6333) = (j('1_c4h9ono2'))
  RCONST(6334) = (3.13D-13)
  RCONST(6335) = (1.53D-12)
  RCONST(6336) = (KRO2HO2*0.90)
  RCONST(6337) = (KRO2NO)
  RCONST(6338) = (KRO2NO3)
  RCONST(6339) = (2.50D-13*RO2)
  RCONST(6340) = (1.51D-10)
  RCONST(6341) = (j('ch3o2h'))
  RCONST(6342) = (KDEC*0.68)
  RCONST(6343) = (KDEC*0.32)
  RCONST(6344) = (1.48D-10)
  RCONST(6345) = (2.08D-12)
  RCONST(6346) = (2.86D-13)
  RCONST(6347) = (KDEC)
  RCONST(6348) = (KRO2HO2*0.914)
  RCONST(6349) = (KRO2NO)
  RCONST(6350) = (KRO2NO3)
  RCONST(6351) = (8.80D-13*RO2*0.6)
  RCONST(6352) = (8.80D-13*RO2*0.2)
  RCONST(6353) = (8.80D-13*RO2*0.2)
  RCONST(6354) = (KNO3AL*4.25)
  RCONST(6355) = (5.00D-18*0.5)
  RCONST(6356) = (5.00D-18*0.5)
  RCONST(6357) = (5.58D-11*0.50)
  RCONST(6358) = (5.58D-11*0.50)
  RCONST(6359) = (j('no2')*0.2*0.6)
  RCONST(6360) = (j('no2')*0.2*0.4)
  RCONST(6361) = (1.00D-12)
  RCONST(6362) = (8.00D-19)
  RCONST(6363) = (2.89D-11)
  RCONST(6364) = (8.19D-11)
  RCONST(6365) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6366) = (8.50D-11)
  RCONST(6367) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6368) = (8.17D-11)
  RCONST(6369) = (KBPAN)
  RCONST(6370) = (3.41D-11)
  RCONST(6371) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(6372) = (KDEC*0.5)
  RCONST(6373) = (KDEC*0.5)
  RCONST(6374) = (2.42D-11)
  RCONST(6375) = (j('i_c3h7cho')+j('mek'))
  RCONST(6376) = (3.07D-11)
  RCONST(6377) = (j('i_c3h7cho')+j('mek'))
  RCONST(6378) = (9.55D-11)
  RCONST(6379) = (j('mek'))
  RCONST(6380) = (j('ch3o2h'))
  RCONST(6381) = (j('mvk_mcm_co'))
  RCONST(6382) = (KDEC)
  RCONST(6383) = (1.32D-10)
  RCONST(6384) = (j('mvk_mcm_co')+j('mek'))
  RCONST(6385) = (7.21D-11)
  RCONST(6386) = (j('biacet')+j('mvk_mcm_co'))
  RCONST(6387) = (1.45D-10)
  RCONST(6388) = (j('1_c4h9ono2'))
  RCONST(6389) = (j('ch3o2h'))
  RCONST(6390) = (KDEC)
  RCONST(6391) = (1.41D-10)
  RCONST(6392) = (j('1_c4h9ono2'))
  RCONST(6393) = (1.51D-10)
  RCONST(6394) = (j('ch3o2h'))
  RCONST(6395) = (KDEC)
  RCONST(6396) = (1.48D-10)
  RCONST(6397) = (KRO2HO2*0.932)
  RCONST(6398) = (KRO2NO)
  RCONST(6399) = (KRO2NO3)
  RCONST(6400) = (8.80D-13*RO2*0.6)
  RCONST(6401) = (8.80D-13*RO2*0.2)
  RCONST(6402) = (8.80D-13*RO2*0.2)
  RCONST(6403) = (KAPHO2*0.56)
  RCONST(6404) = (KAPHO2*0.44)
  RCONST(6405) = (KAPNO)
  RCONST(6406) = (KFPAN)
  RCONST(6407) = (KRO2NO3*1.74)
  RCONST(6408) = (1.00D-11*RO2)
  RCONST(6409) = (1.46D-10)
  RCONST(6410) = (j('1_c4h9ono2'))
  RCONST(6411) = (j('ch3o2h'))
  RCONST(6412) = (KDEC)
  RCONST(6413) = (1.43D-10)
  RCONST(6414) = (j('1_c4h9ono2'))
  RCONST(6415) = (1.52D-10)
  RCONST(6416) = (j('ch3o2h'))
  RCONST(6417) = (KDEC)
  RCONST(6418) = (1.49D-10)
  RCONST(6419) = (KAPHO2*0.56)
  RCONST(6420) = (KAPHO2*0.44)
  RCONST(6421) = (KAPNO)
  RCONST(6422) = (KFPAN)
  RCONST(6423) = (KRO2NO3*1.74)
  RCONST(6424) = (1.00D-11*RO2)
  RCONST(6425) = (8.52D-11)
  RCONST(6426) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6427) = (8.83D-11)
  RCONST(6428) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6429) = (8.50D-11)
  RCONST(6430) = (KBPAN)
  RCONST(6431) = (KAPHO2*0.44)
  RCONST(6432) = (KAPHO2*0.15)
  RCONST(6433) = (KAPHO2*0.41)
  RCONST(6434) = (KAPNO)
  RCONST(6435) = (KFPAN)
  RCONST(6436) = (KRO2NO3*1.74)
  RCONST(6437) = (1.00D-11*RO2*0.70)
  RCONST(6438) = (1.00D-11*RO2*0.30)
  RCONST(6439) = (KRO2HO2*0.706)
  RCONST(6440) = (KRO2NO)
  RCONST(6441) = (KRO2NO3)
  RCONST(6442) = (9.20D-14*RO2*0.7)
  RCONST(6443) = (9.20D-14*RO2*0.3)
  RCONST(6444) = (KRO2HO2*0.770)
  RCONST(6445) = (KRO2NO)
  RCONST(6446) = (KRO2NO3)
  RCONST(6447) = (8.80D-13*RO2*0.20)
  RCONST(6448) = (8.80D-13*RO2*0.20)
  RCONST(6449) = (8.80D-13*RO2*0.60)
  RCONST(6450) = (3.74D-11)
  RCONST(6451) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(6452) = (KDEC*0.5)
  RCONST(6453) = (KDEC*0.5)
  RCONST(6454) = (2.75D-11)
  RCONST(6455) = (j('i_c3h7cho')+j('mek'))
  RCONST(6456) = (3.40D-11)
  RCONST(6457) = (j('i_c3h7cho')+j('mek'))
  RCONST(6458) = (9.66D-11)
  RCONST(6459) = (j('mek'))
  RCONST(6460) = (j('ch3o2h')+j('mvk_mcm_co'))
  RCONST(6461) = (KDEC)
  RCONST(6462) = (1.33D-10)
  RCONST(6463) = (j('mvk_mcm_co')+j('mek'))
  RCONST(6464) = (7.40D-11)
  RCONST(6465) = (j('biacet')+j('mvk_mcm_co'))
  RCONST(6466) = (KRO2HO2*0.625)
  RCONST(6467) = (KRO2NO)
  RCONST(6468) = (KRO2NO3)
  RCONST(6469) = (8.80D-13*0.2*RO2)
  RCONST(6470) = (8.80D-13*0.6*RO2)
  RCONST(6471) = (8.80D-13*0.2*RO2)
  RCONST(6472) = (KAPHO2*0.15)
  RCONST(6473) = (KAPHO2*0.41)
  RCONST(6474) = (KAPHO2*0.44)
  RCONST(6475) = (KAPNO)
  RCONST(6476) = (KFPAN)
  RCONST(6477) = (KRO2NO3*1.74)
  RCONST(6478) = (1.00D-11*0.3*RO2)
  RCONST(6479) = (1.00D-11*0.7*RO2)
  RCONST(6480) = (KDEC*0.125)
  RCONST(6481) = (KDEC*0.125)
  RCONST(6482) = (KDEC*0.18)
  RCONST(6483) = (KDEC*0.57)
  RCONST(6484) = (KRO2HO2*0.625)
  RCONST(6485) = (KRO2NO)
  RCONST(6486) = (KRO2NO3)
  RCONST(6487) = (8.80D-13*0.6*RO2)
  RCONST(6488) = (8.80D-13*0.2*RO2)
  RCONST(6489) = (8.80D-13*0.2*RO2)
  RCONST(6490) = (KAPHO2*0.15)
  RCONST(6491) = (KAPHO2*0.41)
  RCONST(6492) = (KAPHO2*0.44)
  RCONST(6493) = (KAPNO)
  RCONST(6494) = (KFPAN)
  RCONST(6495) = (KRO2NO3*1.74)
  RCONST(6496) = (1.00D-11*0.3*RO2)
  RCONST(6497) = (1.00D-11*0.7*RO2)
  RCONST(6498) = (KDEC*0.125)
  RCONST(6499) = (KDEC*0.18)
  RCONST(6500) = (KDEC*0.125)
  RCONST(6501) = (KDEC*0.57)
  RCONST(6502) = (KRO2HO2*0.625)
  RCONST(6503) = (KRO2NO*0.021)
  RCONST(6504) = (KRO2NO*0.979)
  RCONST(6505) = (KRO2NO3)
  RCONST(6506) = (8.80D-13*0.6*RO2)
  RCONST(6507) = (8.80D-13*0.2*RO2)
  RCONST(6508) = (8.80D-13*0.2*RO2)
  RCONST(6509) = (KDEC*0.24)
  RCONST(6510) = (KDEC*0.20)
  RCONST(6511) = (KDEC*0.20)
  RCONST(6512) = (KDEC*0.36)
  RCONST(6513) = (KRO2HO2*0.625)
  RCONST(6514) = (KRO2NO*0.017)
  RCONST(6515) = (KRO2NO*0.983)
  RCONST(6516) = (KRO2NO3)
  RCONST(6517) = (2.00D-12*RO2*0.2)
  RCONST(6518) = (2.00D-12*RO2*0.6)
  RCONST(6519) = (2.00D-12*RO2*0.2)
  RCONST(6520) = (KRO2HO2*0.625)
  RCONST(6521) = (KRO2NO)
  RCONST(6522) = (KRO2NO3)
  RCONST(6523) = (8.80D-13*RO2*0.2)
  RCONST(6524) = (8.80D-13*RO2*0.2)
  RCONST(6525) = (8.80D-13*RO2*0.6)
  RCONST(6526) = (KAPHO2*0.44)
  RCONST(6527) = (KAPHO2*0.56)
  RCONST(6528) = (KAPNO)
  RCONST(6529) = (KFPAN)
  RCONST(6530) = (KRO2NO3*1.74)
  RCONST(6531) = (1.00D-11*RO2)
  RCONST(6532) = (KROPRIM*O2)
  RCONST(6533) = (KDEC*0.11)
  RCONST(6534) = (KDEC*0.89)
  RCONST(6535) = (KDEC*0.11)
  RCONST(6536) = (KDEC*0.89)
  RCONST(6537) = (KRO2HO2*0.706)
  RCONST(6538) = (KRO2NO*0.145)
  RCONST(6539) = (KRO2NO*0.855)
  RCONST(6540) = (KRO2NO3)
  RCONST(6541) = (2.90D-12*0.1*RO2)
  RCONST(6542) = (2.90D-12*0.8*RO2)
  RCONST(6543) = (2.90D-12*0.1*RO2)
  RCONST(6544) = (KAPHO2*0.15)
  RCONST(6545) = (KAPHO2*0.41)
  RCONST(6546) = (KAPHO2*0.44)
  RCONST(6547) = (KAPNO)
  RCONST(6548) = (KFPAN)
  RCONST(6549) = (KRO2NO3*1.74)
  RCONST(6550) = (1.00D-11*0.3*RO2)
  RCONST(6551) = (1.00D-11*0.7*RO2)
  RCONST(6552) = (KDEC*0.11)
  RCONST(6553) = (KDEC*0.89)
  RCONST(6554) = (KDEC*0.11)
  RCONST(6555) = (KDEC*0.89)
  RCONST(6556) = (KRO2HO2*0.706)
  RCONST(6557) = (KRO2NO)
  RCONST(6558) = (KRO2NO3)
  RCONST(6559) = (9.20D-14*0.7*RO2)
  RCONST(6560) = (9.20D-14*0.3*RO2)
  RCONST(6561) = (j('ch3o2h'))
  RCONST(6562) = (5.77D-11)
  RCONST(6563) = (j('ch3coch2ono2')*0.91)
  RCONST(6564) = (2.23D-12)
  RCONST(6565) = (KDEC)
  RCONST(6566) = (j('mek'))
  RCONST(6567) = (1.88D-11)
  RCONST(6568) = (1.33D-12*0.33)
  RCONST(6569) = (1.33D-12*0.67)
  RCONST(6570) = (j('ch3coch2ono2')*1.6)
  RCONST(6571) = (j('ch3o2h'))
  RCONST(6572) = (3.95D-11)
  RCONST(6573) = (KDEC)
  RCONST(6574) = (j('biacet'))
  RCONST(6575) = (2.69D-12)
  RCONST(6576) = (j('mvk_mcm_ch2ch'))
  RCONST(6577) = (j('ch3o2h'))
  RCONST(6578) = (1.90D-12*EXP(190/TEMP))
  RCONST(6579) = (2.55D-11)
  RCONST(6580) = (KDEC)
  RCONST(6581) = (KNO3AL*2.0)
  RCONST(6582) = (2.95D-11)
  RCONST(6583) = (j('ch3cocho'))
  RCONST(6584) = (j('ch3o2h'))
  RCONST(6585) = (1.54D-10*0.05)
  RCONST(6586) = (1.54D-10*0.93)
  RCONST(6587) = (1.54D-10*0.02)
  RCONST(6588) = (KDEC*0.23)
  RCONST(6589) = (KDEC*0.55)
  RCONST(6590) = (KDEC*0.22)
  RCONST(6591) = (j('n_c3h7ono2'))
  RCONST(6592) = (4.10D-17*0.50)
  RCONST(6593) = (4.10D-17*0.50)
  RCONST(6594) = (1.12D-10)
  RCONST(6595) = (KRO2HO2*0.706)
  RCONST(6596) = (KRO2NO)
  RCONST(6597) = (KRO2NO3)
  RCONST(6598) = (9.20D-14*RO2)
  RCONST(6599) = (K14ISOM1)
  RCONST(6600) = (KNO3AL*4.25)
  RCONST(6601) = (2.40D-17*0.73)
  RCONST(6602) = (2.40D-17*0.27)
  RCONST(6603) = (5.20D-11*0.359)
  RCONST(6604) = (5.20D-11*0.256)
  RCONST(6605) = (5.20D-11*0.385)
  RCONST(6606) = (j('c5hpald')*0.5)
  RCONST(6607) = (j('c5hpald')*0.5)
  RCONST(6608) = (j('ch2cch3cho_hco'))
  RCONST(6609) = (j('ch2cch3cho_h'))
  RCONST(6610) = (KNO3AL*4.25)
  RCONST(6611) = (2.40D-17*0.5)
  RCONST(6612) = (2.40D-17*0.5)
  RCONST(6613) = (6.42D-11*0.051)
  RCONST(6614) = (6.42D-11*0.247)
  RCONST(6615) = (6.42D-11*0.452)
  RCONST(6616) = (6.42D-11*0.250)
  RCONST(6617) = (9.30D-11*0.5)
  RCONST(6618) = (9.30D-11*0.5)
  RCONST(6619) = (j('ch3o2h'))
  RCONST(6620) = (5.00D-11*0.92)
  RCONST(6621) = (5.00D-11*0.08)
  RCONST(6622) = (j('2_c4h9ono2'))
  RCONST(6623) = (5.00D-19*0.50)
  RCONST(6624) = (5.00D-19*0.50)
  RCONST(6625) = (2.17D-11*0.84)
  RCONST(6626) = (2.17D-11*0.16)
  RCONST(6627) = (KDEC)
  RCONST(6628) = (3.85D-11)
  RCONST(6629) = (j('ch3o2h'))
  RCONST(6630) = (1.54D-10*0.05)
  RCONST(6631) = (1.54D-10*0.93)
  RCONST(6632) = (1.54D-10*0.02)
  RCONST(6633) = (KDEC*0.38)
  RCONST(6634) = (KDEC*0.40)
  RCONST(6635) = (KDEC*0.22)
  RCONST(6636) = (KRO2HO2*0.706)
  RCONST(6637) = (KRO2NO)
  RCONST(6638) = (KRO2NO3)
  RCONST(6639) = (8.80D-13*RO2)
  RCONST(6640) = (K14ISOM1)
  RCONST(6641) = (KNO3AL*4.25)
  RCONST(6642) = (2.40D-17*0.27)
  RCONST(6643) = (2.40D-17*0.73)
  RCONST(6644) = (5.20D-11*0.256)
  RCONST(6645) = (5.20D-11*0.385)
  RCONST(6646) = (5.20D-11*0.359)
  RCONST(6647) = (j('c5hpald')*0.5)
  RCONST(6648) = (j('c5hpald')*0.5)
  RCONST(6649) = (j('ch2cch3cho_hco'))
  RCONST(6650) = (j('ch2cch3cho_h'))
  RCONST(6651) = (KNO3AL*4.25)
  RCONST(6652) = (2.40D-17*0.5)
  RCONST(6653) = (2.40D-17*0.5)
  RCONST(6654) = (6.42D-11*0.051)
  RCONST(6655) = (6.42D-11*0.247)
  RCONST(6656) = (6.42D-11*0.452)
  RCONST(6657) = (6.42D-11*0.250)
  RCONST(6658) = (j('ch3o2h'))
  RCONST(6659) = (1.15D-10*0.22)
  RCONST(6660) = (1.15D-10*0.75)
  RCONST(6661) = (1.15D-10*0.03)
  RCONST(6662) = (j('1_c4h9ono2'))
  RCONST(6663) = (7.00D-19*0.50)
  RCONST(6664) = (7.00D-19*0.50)
  RCONST(6665) = (4.15D-11)
  RCONST(6666) = (KDEC)
  RCONST(6667) = (j('mvk_mcm_ch2ch'))
  RCONST(6668) = (3.81D-11)
  RCONST(6669) = (KRO2HO2*0.706)
  RCONST(6670) = (KRO2NO*0.072)
  RCONST(6671) = (KRO2NO*0.928)
  RCONST(6672) = (KRO2NO3)
  RCONST(6673) = (8.00D-13*0.8*RO2)
  RCONST(6674) = (8.00D-13*0.2*RO2)
  RCONST(6675) = (KDEC*0.82)
  RCONST(6676) = (KDEC*0.18)
  RCONST(6677) = (KRO2HO2*0.706)
  RCONST(6678) = (KRO2NO*0.019)
  RCONST(6679) = (KRO2NO*0.981)
  RCONST(6680) = (KRO2NO3)
  RCONST(6681) = (9.20D-14*0.7*RO2)
  RCONST(6682) = (9.20D-14*0.3*RO2)
  RCONST(6683) = (KAPHO2*0.56)
  RCONST(6684) = (KAPHO2*0.44)
  RCONST(6685) = (KAPNO)
  RCONST(6686) = (KFPAN)
  RCONST(6687) = (KRO2NO3*1.6)
  RCONST(6688) = (1.00D-11*RO2)
  RCONST(6689) = (2.22D-11)
  RCONST(6690) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(6691) = (KDEC*0.27)
  RCONST(6692) = (KDEC*0.73)
  RCONST(6693) = (1.20D-15)
  RCONST(6694) = (1.00D-14)
  RCONST(6695) = (1.00D-15)
  RCONST(6696) = (7.00D-14)
  RCONST(6697) = (6.00D-18*H2O)
  RCONST(6698) = (1.00D-17*H2O)
  RCONST(6699) = (2.55D-11)
  RCONST(6700) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(6701) = (1.81D-11)
  RCONST(6702) = (j('ch3coch2ono2')*0.91)
  RCONST(6703) = (KDEC)
  RCONST(6704) = (5.56D-11)
  RCONST(6705) = (j('ch3o2h'))
  RCONST(6706) = (5.20D-11)
  RCONST(6707) = (KBPAN)
  RCONST(6708) = (6.30D-11)
  RCONST(6709) = (j('ch3o2h'))
  RCONST(6710) = (2.47D-11)
  RCONST(6711) = (j('n_c3h7ono2'))
  RCONST(6712) = (KROPRIM*O2)
  RCONST(6713) = (8.98D-12)
  RCONST(6714) = (j('ch3o2h')+j('mek'))
  RCONST(6715) = (KDEC)
  RCONST(6716) = (j('ch3o2h')+j('mek'))
  RCONST(6717) = (8.69D-11)
  RCONST(6718) = (j('mek'))
  RCONST(6719) = (1.55D-12)
  RCONST(6720) = (2.00D+14*EXP(-6382/TEMP))
  RCONST(6721) = (3.78D-11)
  RCONST(6722) = (j('mek')*2)
  RCONST(6723) = (3.22D-12)
  RCONST(6724) = (5.35D-11)
  RCONST(6725) = (j('ch3o2h'))
  RCONST(6726) = (1.28D-11)
  RCONST(6727) = (j('n_c3h7ono2'))
  RCONST(6728) = (KROPRIM*O2)
  RCONST(6729) = (KDEC)
  RCONST(6730) = (KRO2HO2*0.387)
  RCONST(6731) = (KRO2NO*0.009)
  RCONST(6732) = (KRO2NO*0.991)
  RCONST(6733) = (KRO2NO3)
  RCONST(6734) = (2.00D-12*0.6*RO2)
  RCONST(6735) = (2.00D-12*0.2*RO2)
  RCONST(6736) = (2.00D-12*0.2*RO2)
  RCONST(6737) = (KRO2HO2*0.625)
  RCONST(6738) = (KRO2NO*0.033)
  RCONST(6739) = (KRO2NO*0.967)
  RCONST(6740) = (KRO2NO3)
  RCONST(6741) = (1.30D-12*0.6*RO2)
  RCONST(6742) = (1.30D-12*0.2*RO2)
  RCONST(6743) = (1.30D-12*0.2*RO2)
  RCONST(6744) = (KRO2HO2*0.625)
  RCONST(6745) = (KRO2NO)
  RCONST(6746) = (KRO2NO3)
  RCONST(6747) = (2.00D-12*0.60*RO2)
  RCONST(6748) = (2.00D-12*0.20*RO2)
  RCONST(6749) = (2.00D-12*0.20*RO2)
  RCONST(6750) = (KRO2HO2*0.625*0.6)
  RCONST(6751) = (KRO2HO2*0.625*0.4)
  RCONST(6752) = (KRO2NO*0.083)
  RCONST(6753) = (KRO2NO*0.917)
  RCONST(6754) = (KRO2NO3)
  RCONST(6755) = (2.00D-12*0.6*RO2)
  RCONST(6756) = (2.00D-12*0.2*RO2)
  RCONST(6757) = (2.00D-12*0.2*RO2)
  RCONST(6758) = (5.97D-13*EXP(134/TEMP)*0.096)
  RCONST(6759) = (5.97D-13*EXP(134/TEMP)*0.904)
  RCONST(6760) = (KRO2HO2*0.520*0.4)
  RCONST(6761) = (KRO2HO2*0.520*0.6)
  RCONST(6762) = (KRO2NO*0.019)
  RCONST(6763) = (KRO2NO*0.981)
  RCONST(6764) = (KRO2NO3)
  RCONST(6765) = (2.00D-12*0.2*RO2)
  RCONST(6766) = (2.00D-12*0.6*RO2)
  RCONST(6767) = (2.00D-12*0.2*RO2)
  RCONST(6768) = (KRO2HO2*0.625*0.4)
  RCONST(6769) = (KRO2HO2*0.625*0.6)
  RCONST(6770) = (KRO2NO*0.959)
  RCONST(6771) = (KRO2NO*0.041)
  RCONST(6772) = (KRO2NO3)
  RCONST(6773) = (8.80D-13*0.2*RO2)
  RCONST(6774) = (8.80D-13*0.6*RO2)
  RCONST(6775) = (8.80D-13*0.2*RO2)
  RCONST(6776) = (KRO2HO2*0.625*0.6)
  RCONST(6777) = (KRO2HO2*0.625*0.4)
  RCONST(6778) = (KRO2NO*0.917)
  RCONST(6779) = (KRO2NO*0.083)
  RCONST(6780) = (KRO2NO3)
  RCONST(6781) = (8.80D-13*0.6*RO2)
  RCONST(6782) = (8.80D-13*0.2*RO2)
  RCONST(6783) = (8.80D-13*0.2*RO2)
  RCONST(6784) = (KAPHO2*0.15)
  RCONST(6785) = (KAPHO2*0.41)
  RCONST(6786) = (KAPHO2*0.44)
  RCONST(6787) = (KAPNO)
  RCONST(6788) = (KFPAN)
  RCONST(6789) = (KRO2NO3*1.74)
  RCONST(6790) = (1.00D-11*0.3*RO2)
  RCONST(6791) = (1.00D-11*0.7*RO2)
  RCONST(6792) = (KRO2HO2*0.625)
  RCONST(6793) = (KRO2NO)
  RCONST(6794) = (KRO2NO3)
  RCONST(6795) = (2.00D-12*0.2*RO2)
  RCONST(6796) = (2.00D-12*0.6*RO2)
  RCONST(6797) = (2.00D-12*0.2*RO2)
  RCONST(6798) = (KRO2HO2*0.625)
  RCONST(6799) = (KRO2NO)
  RCONST(6800) = (KRO2NO3)
  RCONST(6801) = (2.00D-12*0.6*RO2)
  RCONST(6802) = (2.00D-12*0.2*RO2)
  RCONST(6803) = (2.00D-12*0.2*RO2)
  RCONST(6804) = (KRO2HO2*0.706)
  RCONST(6805) = (KRO2NO)
  RCONST(6806) = (KRO2NO3)
  RCONST(6807) = (2.00D-12*0.2*RO2)
  RCONST(6808) = (2.00D-12*0.6*RO2)
  RCONST(6809) = (2.00D-12*0.2*RO2)
  RCONST(6810) = (KRO2HO2*0.706)
  RCONST(6811) = (KRO2NO)
  RCONST(6812) = (KRO2NO3)
  RCONST(6813) = (8.80D-13*RO2)
  RCONST(6814) = (KRO2HO2*0.706)
  RCONST(6815) = (KRO2NO)
  RCONST(6816) = (KRO2NO3)
  RCONST(6817) = (8.80D-13*0.2*RO2)
  RCONST(6818) = (8.80D-13*0.2*RO2)
  RCONST(6819) = (8.80D-13*0.6*RO2)
  RCONST(6820) = (KRO2HO2*0.706)
  RCONST(6821) = (KRO2NO)
  RCONST(6822) = (KRO2NO3)
  RCONST(6823) = (2.00D-12*0.6*RO2)
  RCONST(6824) = (2.00D-12*0.2*RO2)
  RCONST(6825) = (2.00D-12*0.2*RO2)
  RCONST(6826) = (KAPHO2*0.15)
  RCONST(6827) = (KAPHO2*0.41)
  RCONST(6828) = (KAPHO2*0.44)
  RCONST(6829) = (KAPNO)
  RCONST(6830) = (KFPAN)
  RCONST(6831) = (KRO2NO3*1.74)
  RCONST(6832) = (1.00D-11*0.3*RO2)
  RCONST(6833) = (1.00D-11*0.7*RO2)
  RCONST(6834) = (KRO2HO2*0.770)
  RCONST(6835) = (KRO2NO)
  RCONST(6836) = (KRO2NO3)
  RCONST(6837) = (2.00D-12*RO2)
  RCONST(6838) = (KRO2HO2*0.770)
  RCONST(6839) = (KRO2NO)
  RCONST(6840) = (KRO2NO3)
  RCONST(6841) = (8.80D-13*RO2)
  RCONST(6842) = (KRO2HO2*0.770)
  RCONST(6843) = (KRO2NO)
  RCONST(6844) = (KRO2NO3)
  RCONST(6845) = (8.40D-13*0.2*RO2)
  RCONST(6846) = (8.40D-13*0.6*RO2)
  RCONST(6847) = (8.40D-13*0.2*RO2)
  RCONST(6848) = (KRO2HO2*0.625)
  RCONST(6849) = (KRO2NO*0.033)
  RCONST(6850) = (KRO2NO*0.967)
  RCONST(6851) = (KRO2NO3)
  RCONST(6852) = (1.30D-12*0.2*RO2)
  RCONST(6853) = (1.30D-12*0.6*RO2)
  RCONST(6854) = (1.30D-12*0.2*RO2)
  RCONST(6855) = (KRO2HO2*0.770)
  RCONST(6856) = (KRO2NO*0.098)
  RCONST(6857) = (KRO2NO*0.902)
  RCONST(6858) = (KRO2NO3)
  RCONST(6859) = (8.40D-13*0.2*RO2)
  RCONST(6860) = (8.40D-13*0.6*RO2)
  RCONST(6861) = (8.40D-13*0.2*RO2)
  RCONST(6862) = (KRO2HO2*0.770)
  RCONST(6863) = (KRO2NO)
  RCONST(6864) = (KRO2NO3)
  RCONST(6865) = (8.80D-13*RO2)
  RCONST(6866) = (KRO2HO2*0.770)
  RCONST(6867) = (KRO2NO)
  RCONST(6868) = (KRO2NO3)
  RCONST(6869) = (8.80D-13*0.2*RO2)
  RCONST(6870) = (8.80D-13*0.2*RO2)
  RCONST(6871) = (8.80D-13*0.6*RO2)
  RCONST(6872) = (KRO2HO2*0.770)
  RCONST(6873) = (KRO2NO)
  RCONST(6874) = (KRO2NO3)
  RCONST(6875) = (8.80D-13*RO2)
  RCONST(6876) = (KRO2HO2*0.770)
  RCONST(6877) = (KRO2NO)
  RCONST(6878) = (KRO2NO3)
  RCONST(6879) = (8.80D-13*0.2*RO2)
  RCONST(6880) = (8.80D-13*0.2*RO2)
  RCONST(6881) = (8.80D-13*0.6*RO2)
  RCONST(6882) = (KAPHO2*0.56)
  RCONST(6883) = (KAPHO2*0.44)
  RCONST(6884) = (KAPNO)
  RCONST(6885) = (KFPAN)
  RCONST(6886) = (KRO2NO3*1.74)
  RCONST(6887) = (1.00D-11*RO2)
  RCONST(6888) = (KRO2HO2*0.706)
  RCONST(6889) = (KRO2NO)
  RCONST(6890) = (KRO2NO3)
  RCONST(6891) = (2.00D-12*RO2)
  RCONST(6892) = (KRO2HO2*0.770)
  RCONST(6893) = (KRO2NO)
  RCONST(6894) = (KRO2NO3)
  RCONST(6895) = (2.00D-12*RO2)
  RCONST(6896) = (KRO2HO2*0.770)
  RCONST(6897) = (KRO2NO)
  RCONST(6898) = (KRO2NO3)
  RCONST(6899) = (2.00D-12*0.6*RO2)
  RCONST(6900) = (2.00D-12*0.2*RO2)
  RCONST(6901) = (2.00D-12*0.2*RO2)
  RCONST(6902) = (KAPHO2*0.15)
  RCONST(6903) = (KAPHO2*0.41)
  RCONST(6904) = (KAPHO2*0.44)
  RCONST(6905) = (KAPNO)
  RCONST(6906) = (KFPAN)
  RCONST(6907) = (KRO2NO3*1.74)
  RCONST(6908) = (1.00D-11*0.3*RO2)
  RCONST(6909) = (1.00D-11*0.7*RO2)
  RCONST(6910) = (KRO2HO2*0.770)
  RCONST(6911) = (KRO2NO)
  RCONST(6912) = (KRO2NO3)
  RCONST(6913) = (1.30D-12*0.6*RO2)
  RCONST(6914) = (1.30D-12*0.2*RO2)
  RCONST(6915) = (1.30D-12*0.2*RO2)
  RCONST(6916) = (KRO2HO2*0.770)
  RCONST(6917) = (KRO2NO)
  RCONST(6918) = (KRO2NO3)
  RCONST(6919) = (2.50D-13*0.6*RO2)
  RCONST(6920) = (2.50D-13*0.2*RO2)
  RCONST(6921) = (2.50D-13*0.2*RO2)
  RCONST(6922) = (9.00D-12)
  RCONST(6923) = (2.0D-14)
  RCONST(6924) = (5.2D-12*EXP(600/TEMP)*0.772)
  RCONST(6925) = (5.2D-12*EXP(600/TEMP)*0.228)
  RCONST(6926) = (j('n_c3h7cho_hco'))
  RCONST(6927) = (KRO2HO2*0.914)
  RCONST(6928) = (KRO2NO)
  RCONST(6929) = (KRO2NO3)
  RCONST(6930) = (6.70D-15*RO2)
  RCONST(6931) = (KAPHO2*0.44)
  RCONST(6932) = (KAPHO2*0.41)
  RCONST(6933) = (KAPHO2*0.15)
  RCONST(6934) = (KAPNO)
  RCONST(6935) = (KFPAN)
  RCONST(6936) = (KRO2NO3*1.74)
  RCONST(6937) = (1.00D-11*0.7*RO2)
  RCONST(6938) = (1.00D-11*0.3*RO2)
  RCONST(6939) = (3.01D-11)
  RCONST(6940) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(6941) = (KDEC)
  RCONST(6942) = (2.66D-11)
  RCONST(6943) = (j('n_c3h7cho_hco'))
  RCONST(6944) = (5.47D-11)
  RCONST(6945) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(6946) = (j('mek'))
  RCONST(6947) = (KDEC*0.80)
  RCONST(6948) = (KDEC*0.20)
  RCONST(6949) = (5.47D-11)
  RCONST(6950) = (j('ch3cocho')+j('n_c3h7cho_hco'))
  RCONST(6951) = (4.45D-11)
  RCONST(6952) = (j('mek'))
  RCONST(6953) = (j('n_c3h7cho_hco'))
  RCONST(6954) = (6.65D-12)
  RCONST(6955) = (j('mek'))
  RCONST(6956) = (1.90D-12*EXP(190/TEMP))
  RCONST(6957) = (1.30D-11)
  RCONST(6958) = (j('ch3o2h')+j('mek'))
  RCONST(6959) = (2.88D-12)
  RCONST(6960) = (j('n_c3h7ono2')+j('mek'))
  RCONST(6961) = (4.20D+10*EXP(-3523/TEMP))
  RCONST(6962) = (7.67D-12)
  RCONST(6963) = (j('mek'))
  RCONST(6964) = (KNO3AL*8.5)
  RCONST(6965) = (2.64D-11)
  RCONST(6966) = (j('n_c3h7cho_hco'))
  RCONST(6967) = (1.19D-10)
  RCONST(6968) = (KRO2HO2*0.820)
  RCONST(6969) = (KRO2NO*0.278)
  RCONST(6970) = (KRO2NO*0.722)
  RCONST(6971) = (KRO2NO3)
  RCONST(6972) = (2.50D-13*RO2*0.6)
  RCONST(6973) = (2.50D-13*RO2*0.2)
  RCONST(6974) = (2.50D-13*RO2*0.2)
  RCONST(6975) = (KAPHO2*0.56)
  RCONST(6976) = (KAPHO2*0.44)
  RCONST(6977) = (KAPNO)
  RCONST(6978) = (KFPAN)
  RCONST(6979) = (KRO2NO3*1.74)
  RCONST(6980) = (1.00D-11*RO2)
  RCONST(6981) = (8.59D-11)
  RCONST(6982) = (j('ch3o2h'))
  RCONST(6983) = (3.24D-12)
  RCONST(6984) = (j('1_c4h9ono2'))
  RCONST(6985) = (2.70D+14*EXP(-6643/TEMP))
  RCONST(6986) = (KROSEC*O2)
  RCONST(6987) = (6.07D-12)
  RCONST(6988) = (3.68D-11)
  RCONST(6989) = (3.44D-11)
  RCONST(6990) = (j('ch3o2h'))
  RCONST(6991) = (6.05D-12)
  RCONST(6992) = (j('1_c4h9ono2'))
  RCONST(6993) = (KDEC)
  RCONST(6994) = (1.64D-11)
  RCONST(6995) = (1.81D-11)
  RCONST(6996) = (1.11D-11)
  RCONST(6997) = (j('ch3o2h'))
  RCONST(6998) = (6.37D-12)
  RCONST(6999) = (j('2_c4h9ono2'))
  RCONST(7000) = (KDEC)
  RCONST(7001) = (7.69D-12)
  RCONST(7002) = (2.63D-11)
  RCONST(7003) = (j('ch3o2h'))
  RCONST(7004) = (KDEC)
  RCONST(7005) = (3.07D-12)
  RCONST(7006) = (1.41D-11)
  RCONST(7007) = (KRO2HO2*0.859)
  RCONST(7008) = (KRO2NO*0.138)
  RCONST(7009) = (KRO2NO*0.862)
  RCONST(7010) = (KRO2NO3)
  RCONST(7011) = (2.50D-13*RO2*0.2)
  RCONST(7012) = (2.50D-13*RO2*0.6)
  RCONST(7013) = (2.50D-13*RO2*0.2)
  RCONST(7014) = (KAPHO2*0.56)
  RCONST(7015) = (KAPHO2*0.44)
  RCONST(7016) = (KAPNO)
  RCONST(7017) = (KFPAN)
  RCONST(7018) = (KRO2NO3*1.74)
  RCONST(7019) = (1.00D-11*RO2)
  RCONST(7020) = (2.60D-13*0.092)
  RCONST(7021) = (2.60D-13*0.988)
  RCONST(7022) = (8.30D-18*0.670)
  RCONST(7023) = (8.30D-18*0.330)
  RCONST(7024) = (1.10D-10*0.288)
  RCONST(7025) = (1.10D-10*0.712)
  RCONST(7026) = (j('n_c3h7cho_hco'))
  RCONST(7027) = (1.06D-10)
  RCONST(7028) = (j('mek'))
  RCONST(7029) = (j('ch3o2h'))
  RCONST(7030) = (KDEC)
  RCONST(7031) = (8.34D-11)
  RCONST(7032) = (j('biacet'))
  RCONST(7033) = (9.34D-11)
  RCONST(7034) = (j('mek'))
  RCONST(7035) = (9.73D-11)
  RCONST(7036) = (j('mek'))
  RCONST(7037) = (j('ch3o2h'))
  RCONST(7038) = (KDEC)
  RCONST(7039) = (1.01D-10)
  RCONST(7040) = (j('ch3cocho'))
  RCONST(7041) = (9.04D-11)
  RCONST(7042) = (j('mek'))
  RCONST(7043) = (7.39D-11)
  RCONST(7044) = (j('ch3o2h'))
  RCONST(7045) = (5.82D-11)
  RCONST(7046) = (j('n_c3h7ono2'))
  RCONST(7047) = (KDEC)
  RCONST(7048) = (6.91D-11)
  RCONST(7049) = (8.00D-11*0.288)
  RCONST(7050) = (8.00D-11*0.712)
  RCONST(7051) = (j('n_c3h7cho_hco'))
  RCONST(7052) = (6.98D-11)
  RCONST(7053) = (KAPHO2*0.41)
  RCONST(7054) = (KAPHO2*0.44)
  RCONST(7055) = (KAPHO2*0.15)
  RCONST(7056) = (KAPNO)
  RCONST(7057) = (KFPAN)
  RCONST(7058) = (KRO2NO3*1.74)
  RCONST(7059) = (1.00D-11*RO2*0.7)
  RCONST(7060) = (1.00D-11*RO2*0.3)
  RCONST(7061) = (9.40D-12)
  RCONST(7062) = (1.50D-16*0.730)
  RCONST(7063) = (1.50D-16*0.270)
  RCONST(7064) = (9.97D-11*0.647)
  RCONST(7065) = (9.97D-11*0.353)
  RCONST(7066) = (KAPHO2*0.15)
  RCONST(7067) = (KAPHO2*0.41)
  RCONST(7068) = (KAPHO2*0.44)
  RCONST(7069) = (KAPNO)
  RCONST(7070) = (KFPAN)
  RCONST(7071) = (KRO2NO3*1.74)
  RCONST(7072) = (1.00D-11*RO2*0.3)
  RCONST(7073) = (1.00D-11*RO2*0.7)
  RCONST(7074) = (KRO2HO2*0.975)
  RCONST(7075) = (KRO2NO)
  RCONST(7076) = (KRO2NO3)
  RCONST(7077) = (9.20D-14*RO2*0.7)
  RCONST(7078) = (9.20D-14*RO2*0.3)
  RCONST(7079) = (KDEC*0.5)
  RCONST(7080) = (KDEC*0.5)
  RCONST(7081) = (KNO3AL*8.5)
  RCONST(7082) = (3.79D-11*0.032)
  RCONST(7083) = (3.79D-11*0.004)
  RCONST(7084) = (3.79D-11*0.100)
  RCONST(7085) = (3.79D-11*0.764)
  RCONST(7086) = (3.79D-11*0.100)
  RCONST(7087) = (j('n_c3h7cho_hco'))
  RCONST(7088) = (KRO2HO2*0.975)
  RCONST(7089) = (KRO2NO*0.068)
  RCONST(7090) = (KRO2NO*0.932)
  RCONST(7091) = (KRO2NO3)
  RCONST(7092) = (9.20D-14*RO2*0.7)
  RCONST(7093) = (9.20D-14*RO2*0.3)
  RCONST(7094) = (3.65D-11)
  RCONST(7095) = (1.20D-15)
  RCONST(7096) = (1.00D-14)
  RCONST(7097) = (1.00D-15)
  RCONST(7098) = (7.00D-14)
  RCONST(7099) = (1.40D-17*H2O)
  RCONST(7100) = (KRO2HO2*0.975)
  RCONST(7101) = (KRO2NO*0.247)
  RCONST(7102) = (KRO2NO*0.753)
  RCONST(7103) = (KRO2NO3)
  RCONST(7104) = (9.20D-14*RO2*0.7)
  RCONST(7105) = (9.20D-14*RO2*0.3)
  RCONST(7106) = (1.21D-11)
  RCONST(7107) = (KDEC*0.5)
  RCONST(7108) = (KDEC*0.5)
  RCONST(7109) = (KRO2HO2*0.975)
  RCONST(7110) = (KRO2NO*0.136)
  RCONST(7111) = (KRO2NO*0.864)
  RCONST(7112) = (KRO2NO3)
  RCONST(7113) = (9.20D-14*RO2*0.7)
  RCONST(7114) = (9.20D-14*RO2*0.3)
  RCONST(7115) = (1.06D-10)
  RCONST(7116) = (j('ch3o2h'))
  RCONST(7117) = (j('mek'))
  RCONST(7118) = (KDEC)
  RCONST(7119) = (8.34D-11)
  RCONST(7120) = (j('biacet'))
  RCONST(7121) = (9.34D-11)
  RCONST(7122) = (j('mek'))
  RCONST(7123) = (9.73D-11)
  RCONST(7124) = (j('ch3o2h'))
  RCONST(7125) = (j('mek'))
  RCONST(7126) = (KDEC)
  RCONST(7127) = (1.01D-10)
  RCONST(7128) = (j('ch3cocho'))
  RCONST(7129) = (9.04D-11)
  RCONST(7130) = (j('mek'))
  RCONST(7131) = (KDEC*0.5)
  RCONST(7132) = (KDEC*0.5)
  RCONST(7133) = (3.78D-11)
  RCONST(7134) = (KRO2HO2*0.975)
  RCONST(7135) = (KRO2NO*0.136)
  RCONST(7136) = (KRO2NO*0.864)
  RCONST(7137) = (KRO2NO3)
  RCONST(7138) = (9.20D-14*RO2*0.7)
  RCONST(7139) = (9.20D-14*RO2*0.3)
  RCONST(7140) = (9.71D-11)
  RCONST(7141) = (j('ch3o2h'))
  RCONST(7142) = (8.31D-11)
  RCONST(7143) = (j('n_c3h7ono2'))
  RCONST(7144) = (KDEC)
  RCONST(7145) = (KNO3AL*17)
  RCONST(7146) = (3.30D-13)
  RCONST(7147) = (1.10D-16*0.330)
  RCONST(7148) = (1.10D-16*0.670)
  RCONST(7149) = (1.10D-10*0.447)
  RCONST(7150) = (1.10D-10*0.553)
  RCONST(7151) = (j('n_c3h7cho_hco')*2)
  RCONST(7152) = (8.80D-11)
  RCONST(7153) = (1.02D-10)
  RCONST(7154) = (j('ch3o2h'))
  RCONST(7155) = (j('n_c3h7cho_hco'))
  RCONST(7156) = (KDEC)
  RCONST(7157) = (7.59D-11)
  RCONST(7158) = (j('ch3cocho'))
  RCONST(7159) = (9.02D-11)
  RCONST(7160) = (j('n_c3h7cho_hco'))
  RCONST(7161) = (7.39D-11)
  RCONST(7162) = (j('ch3o2h'))
  RCONST(7163) = (5.82D-11)
  RCONST(7164) = (j('n_c3h7ono2'))
  RCONST(7165) = (KDEC)
  RCONST(7166) = (8.00D-11)
  RCONST(7167) = (j('n_c3h7cho_hco'))
  RCONST(7168) = (6.91D-11)
  RCONST(7169) = (9.40D-12)
  RCONST(7170) = (1.16D-14*0.435)
  RCONST(7171) = (1.16D-14*0.435)
  RCONST(7172) = (1.16D-14*0.100)
  RCONST(7173) = (1.16D-14*0.030)
  RCONST(7174) = (9.95D-11*0.647)
  RCONST(7175) = (9.95D-11*0.353)
  RCONST(7176) = (1.39D-11)
  RCONST(7177) = (j('ch3o2h'))
  RCONST(7178) = (1.73D-11)
  RCONST(7179) = (KBPAN)
  RCONST(7180) = (4.51D-12)
  RCONST(7181) = (1.46D-11)
  RCONST(7182) = (j('ch3o2h'))
  RCONST(7183) = (1.82D-11)
  RCONST(7184) = (KBPAN)
  RCONST(7185) = (1.45D-11)
  RCONST(7186) = (j('ch3o2h'))
  RCONST(7187) = (3.98D-11)
  RCONST(7188) = (j('n_c3h7ono2'))
  RCONST(7189) = (7.51D-12)
  RCONST(7190) = (2.00D+14*EXP(-4714/TEMP))
  RCONST(7191) = (2.46D-11)
  RCONST(7192) = (j('mek'))
  RCONST(7193) = (1.51D-11)
  RCONST(7194) = (j('ch3o2h'))
  RCONST(7195) = (3.84D-11)
  RCONST(7196) = (KBPAN)
  RCONST(7197) = (1.20D-11)
  RCONST(7198) = (j('ch3o2h'))
  RCONST(7199) = (1.90D-12*EXP(190/TEMP))
  RCONST(7200) = (1.54D-11)
  RCONST(7201) = (5.93D-12)
  RCONST(7202) = (2.00D+14*EXP(-4909/TEMP))
  RCONST(7203) = (9.90D-12)
  RCONST(7204) = (j('i_c3h7cho'))
  RCONST(7205) = (KNO3AL*8.5)
  RCONST(7206) = (3.00D-11)
  RCONST(7207) = (j('ch3o2h'))
  RCONST(7208) = (4.83D-12)
  RCONST(7209) = (KBPAN)
  RCONST(7210) = (1.23D-12)
  RCONST(7211) = (8.08D-12)
  RCONST(7212) = (j('ch3o2h'))
  RCONST(7213) = (1.62D-12)
  RCONST(7214) = (KBPAN)
  RCONST(7215) = (j('ch3o2h'))
  RCONST(7216) = (2.72D-11)
  RCONST(7217) = (1.90D-12*EXP(190/TEMP))
  RCONST(7218) = (5.22D-12)
  RCONST(7219) = (2.00D+14*EXP(-5489/TEMP))
  RCONST(7220) = (j('n_c3h7cho_hco'))
  RCONST(7221) = (KNO3AL*8.5)
  RCONST(7222) = (4.08D-11)
  RCONST(7223) = (2.17D-11)
  RCONST(7224) = (2.93D-11)
  RCONST(7225) = (j('ch3o2h'))
  RCONST(7226) = (3.27D-11)
  RCONST(7227) = (KBPAN)
  RCONST(7228) = (9.54D-12)
  RCONST(7229) = (KAPHO2*0.56)
  RCONST(7230) = (KAPHO2*0.44)
  RCONST(7231) = (KAPNO)
  RCONST(7232) = (KFPAN)
  RCONST(7233) = (KRO2NO3)
  RCONST(7234) = (1.00D-11*RO2)
  RCONST(7235) = (KRO2HO2*0.770)
  RCONST(7236) = (KRO2NO)
  RCONST(7237) = (KRO2NO3)
  RCONST(7238) = (2.50D-13*0.2*RO2)
  RCONST(7239) = (2.50D-13*0.6*RO2)
  RCONST(7240) = (2.50D-13*0.2*RO2)
  RCONST(7241) = (KRO2HO2*0.706)
  RCONST(7242) = (KRO2NO)
  RCONST(7243) = (KRO2NO3)
  RCONST(7244) = (1.30D-12*RO2)
  RCONST(7245) = (KRO2HO2*0.770)
  RCONST(7246) = (KRO2NO)
  RCONST(7247) = (KRO2NO3)
  RCONST(7248) = (2.50D-13*RO2)
  RCONST(7249) = (3.50D-11)
  RCONST(7250) = (j('ch3o2h')+j('biacet'))
  RCONST(7251) = (KDEC)
  RCONST(7252) = (4.50D-12)
  RCONST(7253) = (j('ch3o2h'))
  RCONST(7254) = (1.27D-12)
  RCONST(7255) = (KBPAN)
  RCONST(7256) = (1.05D-11)
  RCONST(7257) = (j('ch3o2h'))
  RCONST(7258) = (7.24D-12)
  RCONST(7259) = (KBPAN)
  RCONST(7260) = (4.18D-12)
  RCONST(7261) = (j('ch3o2h')+j('mek'))
  RCONST(7262) = (5.93D-13)
  RCONST(7263) = (KBPAN)
  RCONST(7264) = (2.78D-11)
  RCONST(7265) = (j('ch3o2h'))
  RCONST(7266) = (3.12D-11)
  RCONST(7267) = (KBPAN)
  RCONST(7268) = (9.00D-12)
  RCONST(7269) = (7.29D-11)
  RCONST(7270) = (j('i_c3h7cho'))
  RCONST(7271) = (7.65D-11)
  RCONST(7272) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(7273) = (7.29D-11)
  RCONST(7274) = (KBPAN)
  RCONST(7275) = (4.31D-11)
  RCONST(7276) = (j('n_c3h7cho_hco'))
  RCONST(7277) = (j('ch3o2h'))
  RCONST(7278) = (j('mek'))
  RCONST(7279) = (1.90D-12)
  RCONST(7280) = (j('ch3o2h')+j('mek'))
  RCONST(7281) = (5.36D-12)
  RCONST(7282) = (KBPAN)
  RCONST(7283) = (1.44D-12)
  RCONST(7284) = (j('ch3o2h'))
  RCONST(7285) = (1.90D-12*EXP(190/TEMP))
  RCONST(7286) = (1.66D-11)
  RCONST(7287) = (j('n_c3h7ono2'))
  RCONST(7288) = (5.85D-12)
  RCONST(7289) = (8.74D+11*EXP(-3430/TEMP))
  RCONST(7290) = (j('n_c3h7cho_hco'))
  RCONST(7291) = (KNO3AL*4.0)
  RCONST(7292) = (2.64D-11)
  RCONST(7293) = (1.11D-11)
  RCONST(7294) = (KDEC)
! RCONST(7295) = constant rate coefficient
! RCONST(7296) = constant rate coefficient
  RCONST(7297) = (j('ch3o2h'))
! RCONST(7298) = constant rate coefficient
  RCONST(7299) = (KBPAN)
  RCONST(7300) = (7.33D-11)
  RCONST(7301) = (j('ch3o2h'))
  RCONST(7302) = (6.97D-11)
  RCONST(7303) = (KBPAN)
  RCONST(7304) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(7305) = (1.58D-11)
  RCONST(7306) = (KAPHO2*0.15)
  RCONST(7307) = (KAPHO2*0.41)
  RCONST(7308) = (KAPHO2*0.44)
  RCONST(7309) = (KAPNO)
  RCONST(7310) = (KFPAN)
  RCONST(7311) = (KRO2NO3*1.74)
  RCONST(7312) = (1.00D-11*0.3*RO2)
  RCONST(7313) = (1.00D-11*0.7*RO2)
  RCONST(7314) = (1.34D-12*0.44)
  RCONST(7315) = (1.34D-12*0.15)
  RCONST(7316) = (4.42D-12*0.15)
  RCONST(7317) = (4.42D-12*0.85)
  RCONST(7318) = (j('ch3o2h'))
  RCONST(7319) = (8.21D-13)
  RCONST(7320) = (KBPAN)
  RCONST(7321) = (1.23D-12*0.32)
  RCONST(7322) = (1.23D-12*0.68)
  RCONST(7323) = (4.31D-12*0.09)
  RCONST(7324) = (4.31D-12*0.91)
  RCONST(7325) = (j('ch3o2h'))
  RCONST(7326) = (7.10D-13)
  RCONST(7327) = (KBPAN)
  RCONST(7328) = (6.99D-11)
  RCONST(7329) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(7330) = (6.64D-11)
  RCONST(7331) = (KBPAN)
  RCONST(7332) = (j('mek'))
  RCONST(7333) = (j('ch3o2h'))
  RCONST(7334) = (7.34D-12)
  RCONST(7335) = (KBPAN)
  RCONST(7336) = (3.74D-12)
  RCONST(7337) = (j('ch3o2h'))
  RCONST(7338) = (3.08D-11)
  RCONST(7339) = (j('n_c3h7ono2'))
  RCONST(7340) = (5.93D-12)
  RCONST(7341) = (8.74D+11*EXP(-3430/TEMP))
  RCONST(7342) = (j('mek'))
  RCONST(7343) = (9.70D-12*0.517)
  RCONST(7344) = (9.60D-12*0.483)
  RCONST(7345) = (1.54D-11)
  RCONST(7346) = (j('ch3o2h'))
  RCONST(7347) = (2.09D-11)
  RCONST(7348) = (1.90D-12*EXP(190/TEMP))
  RCONST(7349) = (j('1_c4h9ono2'))
  RCONST(7350) = (1.03D-11)
  RCONST(7351) = (4.37D+11*EXP(-2945/TEMP))
  RCONST(7352) = (j('n_c3h7cho_hco'))
  RCONST(7353) = (KNO3AL*5.5)
  RCONST(7354) = (3.09D-11)
  RCONST(7355) = (j('ch3o2h'))
  RCONST(7356) = (1.90D-12*EXP(190/TEMP))
  RCONST(7357) = (1.81D-11)
  RCONST(7358) = (j('n_c3h7ono2'))
  RCONST(7359) = (6.00D-12)
  RCONST(7360) = (8.74D+11*EXP(-3430/TEMP))
  RCONST(7361) = (1.26D-11*0.5)
  RCONST(7362) = (1.26D-11*0.5)
  RCONST(7363) = (j('n_c3h7cho_hco'))
  RCONST(7364) = (KNO3AL*8.5)
  RCONST(7365) = (3.51D-11)
  RCONST(7366) = (5.19D-12)
  RCONST(7367) = (j('ch3o2h'))
  RCONST(7368) = (KBPAN)
  RCONST(7369) = (5.02D-13)
  RCONST(7370) = (j('ch3o2h'))
  RCONST(7371) = (3.68D-11)
  RCONST(7372) = (j('1_c4h9ono2'))
  RCONST(7373) = (6.28D-12)
  RCONST(7374) = (8.74D+11*EXP(-3430/TEMP))
  RCONST(7375) = (1.87D-11)
  RCONST(7376) = (j('mek')*0.5)
  RCONST(7377) = (j('mek')*0.5)
  RCONST(7378) = (1.07D-11*0.527)
  RCONST(7379) = (1.07D-11*0.473)
  RCONST(7380) = (j('ch3o2h'))
  RCONST(7381) = (1.16D-11)
  RCONST(7382) = (5.00D-12)
  RCONST(7383) = (KBPAN)
  RCONST(7384) = (j('ch3o2h'))
  RCONST(7385) = (3.53D-11)
  RCONST(7386) = (j('1_c4h9ono2'))
  RCONST(7387) = (1.03D-11)
  RCONST(7388) = (4.37D+11*EXP(-2945/TEMP))
  RCONST(7389) = (2.01D-11)
  RCONST(7390) = (j('ch3o2h'))
  RCONST(7391) = (2.42D-11)
  RCONST(7392) = (1.90D-12*EXP(190/TEMP))
  RCONST(7393) = (j('1_c4h9ono2'))
  RCONST(7394) = (1.34D-11)
  RCONST(7395) = (5.55D+11*EXP(-2945/TEMP))
  RCONST(7396) = (j('n_c3h7cho_hco'))
  RCONST(7397) = (KNO3AL*5.5)
  RCONST(7398) = (3.78D-11*0.331)
  RCONST(7399) = (3.78D-11*0.669)
  RCONST(7400) = (j('ch3o2h'))
  RCONST(7401) = (3.23D-11)
  RCONST(7402) = (j('1_c4h9ono2'))
  RCONST(7403) = (7.62D-12)
  RCONST(7404) = (8.74D+11*EXP(-3430/TEMP))
  RCONST(7405) = (j('mek'))
  RCONST(7406) = (1.46D-11*0.698)
  RCONST(7407) = (1.46D-11*0.302)
  RCONST(7408) = (1.72D-11)
  RCONST(7409) = (j('ch3o2h'))
  RCONST(7410) = (1.21D-11)
  RCONST(7411) = (KBPAN)
  RCONST(7412) = (3.61D-12)
  RCONST(7413) = (j('ch3o2h'))
  RCONST(7414) = (2.28D-11)
  RCONST(7415) = (1.90D-12*EXP(190/TEMP))
  RCONST(7416) = (j('n_c3h7ono2'))
  RCONST(7417) = (1.06D-11)
  RCONST(7418) = (4.37D+11*EXP(-2945/TEMP))
  RCONST(7419) = (j('i_c3h7cho'))
  RCONST(7420) = (KNO3AL*8.5)
  RCONST(7421) = (3.61D-11*0.287)
  RCONST(7422) = (3.61D-11*0.713)
  RCONST(7423) = (j('mek'))
  RCONST(7424) = (j('ch3o2h'))
  RCONST(7425) = (5.89D-12)
  RCONST(7426) = (KDEC)
  RCONST(7427) = (j('mek'))
  RCONST(7428) = (2.43D-12)
  RCONST(7429) = (j('ch3o2h')+j('mek'))
  RCONST(7430) = (3.77D-11)
  RCONST(7431) = (j('n_c3h7ono2')+j('mek'))
  RCONST(7432) = (2.20D-12)
  RCONST(7433) = (1.15D+11*EXP(-3430/TEMP))
  RCONST(7434) = (j('i_c3h7cho'))
  RCONST(7435) = (KNO3AL*8.5)
  RCONST(7436) = (6.87D-11)
  RCONST(7437) = (j('mek'))
  RCONST(7438) = (1.64D-11)
  RCONST(7439) = (j('ch3o2h'))
  RCONST(7440) = (1.30D-11)
  RCONST(7441) = (1.90D-12*EXP(190/TEMP))
  RCONST(7442) = (j('n_c3h7ono2'))
  RCONST(7443) = (2.16D-12)
  RCONST(7444) = (KROPRIM*O2)
  RCONST(7445) = (j('n_c3h7cho_hco'))
  RCONST(7446) = (KNO3AL*8.5)
  RCONST(7447) = (2.66D-11*0.177)
  RCONST(7448) = (2.66D-11*0.823)
  RCONST(7449) = (7.46D-12)
  RCONST(7450) = (j('ch3o2h'))
  RCONST(7451) = (3.23D-11)
  RCONST(7452) = (j('1_c4h9ono2'))
  RCONST(7453) = (6.34D-12)
  RCONST(7454) = (8.74D+11*EXP(-3430/TEMP))
  RCONST(7455) = (j('mek'))
  RCONST(7456) = (1.11D-11*0.527)
  RCONST(7457) = (1.11D-11*0.473)
  RCONST(7458) = (1.73D-11)
  RCONST(7459) = (j('ch3o2h'))
  RCONST(7460) = (1.55D-11)
  RCONST(7461) = (KBPAN)
  RCONST(7462) = (5.03D-12)
  RCONST(7463) = (j('ch3o2h'))
  RCONST(7464) = (2.28D-11)
  RCONST(7465) = (1.90D-12*EXP(190/TEMP))
  RCONST(7466) = (j('1_c4h9ono2'))
  RCONST(7467) = (1.20D-11)
  RCONST(7468) = (4.37D+11*EXP(-2945/TEMP))
  RCONST(7469) = (j('n_c3h7cho_hco'))
  RCONST(7470) = (KNO3AL*8.5)
  RCONST(7471) = (3.98D-11*0.287)
  RCONST(7472) = (3.98D-11*0.713)
  RCONST(7473) = (j('ch3o2h')+j('mek'))
  RCONST(7474) = (6.97D-11)
  RCONST(7475) = (j('1_c4h9ono2')+j('mek'))
  RCONST(7476) = (1.25D-12)
  RCONST(7477) = (1.72D+11*EXP(-4240/TEMP))
  RCONST(7478) = (KROSEC*O2)
  RCONST(7479) = (j('mek'))
  RCONST(7480) = (1.83D-12)
  RCONST(7481) = (2.92D-11)
  RCONST(7482) = (j('ch3o2h')+j('mek'))
  RCONST(7483) = (8.04D-12)
  RCONST(7484) = (KDEC)
  RCONST(7485) = (j('mek'))
  RCONST(7486) = (4.58D-12)
  RCONST(7487) = (j('ch3o2h'))
  RCONST(7488) = (1.56D-11)
  RCONST(7489) = (1.90D-12*EXP(190/TEMP))
  RCONST(7490) = (j('n_c3h7ono2'))
  RCONST(7491) = (5.95D-12)
  RCONST(7492) = (8.74D+11*EXP(-3430/TEMP))
  RCONST(7493) = (j('i_c3h7cho'))
  RCONST(7494) = (KNO3AL*8.5)
  RCONST(7495) = (2.96D-11)
  RCONST(7496) = (1.01D-11*0.5)
  RCONST(7497) = (1.01D-11*0.5)
  RCONST(7498) = (j('ch3o2h'))
  RCONST(7499) = (4.96D-12)
  RCONST(7500) = (KBPAN)
  RCONST(7501) = (8.46D-13)
  RCONST(7502) = (j('ch3o2h'))
  RCONST(7503) = (1.56D-11)
  RCONST(7504) = (1.90D-12*EXP(190/TEMP))
  RCONST(7505) = (j('n_c3h7ono2'))
  RCONST(7506) = (4.77D-12)
  RCONST(7507) = (8.74D+11*EXP(-3430/TEMP))
  RCONST(7508) = (j('n_c3h7cho_hco'))
  RCONST(7509) = (KNO3AL*8.5)
  RCONST(7510) = (2.60D-11)
  RCONST(7511) = (4.87D-12)
  RCONST(7512) = (j('ch3o2h'))
  RCONST(7513) = (8.47D-12)
  RCONST(7514) = (KBPAN)
  RCONST(7515) = (1.65D-12)
  RCONST(7516) = (j('ch3o2h'))
  RCONST(7517) = (1.90D-12*EXP(190/TEMP))
  RCONST(7518) = (1.95D-11)
  RCONST(7519) = (j('n_c3h7ono2'))
  RCONST(7520) = (7.40D-12)
  RCONST(7521) = (8.74D+11*EXP(-3430/TEMP))
  RCONST(7522) = (1.45D-11)
  RCONST(7523) = (j('i_c3h7cho'))
  RCONST(7524) = (KNO3AL*8.5)
  RCONST(7525) = (3.40D-11)
  RCONST(7526) = (9.48D-12)
  RCONST(7527) = (j('ch3o2h'))
  RCONST(7528) = (1.29D-11)
  RCONST(7529) = (KBPAN)
  RCONST(7530) = (3.60D-12)
  RCONST(7531) = (j('ch3o2h'))
  RCONST(7532) = (3.84D-11)
  RCONST(7533) = (j('1_c4h9ono2'))
  RCONST(7534) = (1.23D-11)
  RCONST(7535) = (5.55D+11*EXP(-2945/TEMP))
  RCONST(7536) = (2.32D-11)
  RCONST(7537) = (j('mek'))
  RCONST(7538) = (1.72D-11)
  RCONST(7539) = (j('ch3o2h')+j('mek'))
  RCONST(7540) = (1.42D-10)
  RCONST(7541) = (1.45D+11*EXP(-3430/TEMP))
  RCONST(7542) = (j('ch3o2h'))
  RCONST(7543) = (1.54D-11)
  RCONST(7544) = (j('2_c4h9ono2'))
  RCONST(7545) = (1.04D-11)
  RCONST(7546) = (5.55D+11*EXP(-2945/TEMP))
  RCONST(7547) = (1.20D-11)
  RCONST(7548) = (j('ch3o2h')+j('mek'))
  RCONST(7549) = (8.55D-11)
  RCONST(7550) = (1.72D+11*EXP(-4240/TEMP))
  RCONST(7551) = (j('ch3o2h'))
  RCONST(7552) = (2.71D-11)
  RCONST(7553) = (j('1_c4h9ono2'))
  RCONST(7554) = (2.24D-12)
  RCONST(7555) = (KROSEC*O2)
  RCONST(7556) = (2.70D+14*EXP(-7398/TEMP))
  RCONST(7557) = (j('mek'))
  RCONST(7558) = (5.92D-12*0.834)
  RCONST(7559) = (5.92D-12*0.166)
  RCONST(7560) = (j('ch3o2h'))
  RCONST(7561) = (3.70D-11)
  RCONST(7562) = (j('1_c4h9ono2'))
  RCONST(7563) = (1.08D-11)
  RCONST(7564) = (5.55D+11*EXP(-2945/TEMP))
  RCONST(7565) = (2.18D-11*0.500)
  RCONST(7566) = (2.18D-11*0.500)
  RCONST(7567) = (1.56D-11)
  RCONST(7568) = (j('mek'))
  RCONST(7569) = (j('ch3o2h')+j('mek'))
  RCONST(7570) = (6.05D-12)
  RCONST(7571) = (1.72D+11*EXP(-4240/TEMP))
  RCONST(7572) = (1.38D-11)
  RCONST(7573) = (1.90D-12*EXP(190/TEMP))
  RCONST(7574) = (j('n_c3h7ono2'))
  RCONST(7575) = (3.31D-12)
  RCONST(7576) = (KROPRIM*O2)
  RCONST(7577) = (8.35D-12)
  RCONST(7578) = (j('n_c3h7cho_hco'))
  RCONST(7579) = (KNO3AL*8.5)
  RCONST(7580) = (2.77D-11)
  RCONST(7581) = (j('ch3o2h'))
  RCONST(7582) = (4.41D-11)
  RCONST(7583) = (j('1_c4h9ono2'))
  RCONST(7584) = (1.38D-11)
  RCONST(7585) = (5.55D+11*EXP(-2945/TEMP))
  RCONST(7586) = (2.63D-11)
  RCONST(7587) = (j('mek'))
  RCONST(7588) = (1.85D-11*0.304)
  RCONST(7589) = (1.85D-11*0.696)
  RCONST(7590) = (j('ch3o2h')+j('mek'))
  RCONST(7591) = (8.66D-11)
  RCONST(7592) = (1.15D+11*EXP(-3430/TEMP))
  RCONST(7593) = (j('ch3o2h'))
  RCONST(7594) = (4.55D-11)
  RCONST(7595) = (j('1_c4h9ono2'))
  RCONST(7596) = (1.50D-11)
  RCONST(7597) = (5.55D+11*EXP(-2945/TEMP))
  RCONST(7598) = (2.43D-11)
  RCONST(7599) = (j('mek'))
  RCONST(7600) = (1.99D-11*0.304)
  RCONST(7601) = (1.99D-11*0.696)
  RCONST(7602) = (j('ch3o2h')+j('mek'))
  RCONST(7603) = (8.80D-11)
  RCONST(7604) = (1.15D+11*EXP(-3430/TEMP))
  RCONST(7605) = (j('ch3o2h'))
  RCONST(7606) = (4.69D-11)
  RCONST(7607) = (j('1_c4h9ono2'))
  RCONST(7608) = (1.64D-11)
  RCONST(7609) = (5.55D+11*EXP(-2945/TEMP))
  RCONST(7610) = (2.57D-11)
  RCONST(7611) = (j('mek'))
  RCONST(7612) = (2.13D-11*0.304)
  RCONST(7613) = (2.13D-11*0.696)
  RCONST(7614) = (j('ch3o2h')+j('mek'))
  RCONST(7615) = (8.94D-11)
  RCONST(7616) = (1.15D+11*EXP(-3430/TEMP))
  RCONST(7617) = (j('ch3o2h'))
  RCONST(7618) = (4.83D-11)
  RCONST(7619) = (j('1_c4h9ono2'))
  RCONST(7620) = (1.78D-11)
  RCONST(7621) = (5.55D+11*EXP(-2945/TEMP))
  RCONST(7622) = (2.71D-11)
  RCONST(7623) = (j('mek'))
  RCONST(7624) = (2.27D-11*0.304)
  RCONST(7625) = (2.27D-11*0.696)
  RCONST(7626) = (j('ch3o2h')+j('mek'))
  RCONST(7627) = (9.08D-11)
  RCONST(7628) = (1.15D+11*EXP(-3430/TEMP))
  RCONST(7629) = (j('ch3o2h'))
  RCONST(7630) = (4.97D-11)
  RCONST(7631) = (j('1_c4h9ono2'))
  RCONST(7632) = (1.92D-11)
  RCONST(7633) = (5.55D+11*EXP(-2945/TEMP))
  RCONST(7634) = (2.85D-11)
  RCONST(7635) = (j('mek'))
  RCONST(7636) = (2.41D-11*0.304)
  RCONST(7637) = (2.41D-11*0.696)
  RCONST(7638) = (j('ch3o2h')+j('mek'))
  RCONST(7639) = (9.10D-11)
  RCONST(7640) = (1.15D+11*EXP(-3430/TEMP))
  RCONST(7641) = (4.22D-11)
  RCONST(7642) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(7643) = (2.82D-11)
  RCONST(7644) = (j('n_c3h7cho_hco')+j('n_c3h7ono2'))
  RCONST(7645) = (KDEC)
  RCONST(7646) = (3.31D-11)
  RCONST(7647) = (1.68D-13)
  RCONST(7648) = (3.63D-12)
  RCONST(7649) = (j('ch3o2h'))
  RCONST(7650) = (1.12D-14)
  RCONST(7651) = (KBPAN)
  RCONST(7652) = (3.14D-13)
  RCONST(7653) = (3.77D-12)
  RCONST(7654) = (j('ch3o2h'))
  RCONST(7655) = (1.43D-13)
  RCONST(7656) = (KBPAN)
  RCONST(7657) = (1.64D-11)
  RCONST(7658) = (j('ch3o2h')+j('n_c3h7ono2'))
  RCONST(7659) = (KDEC)
  RCONST(7660) = (1.30D-13)
  RCONST(7661) = (j('biacet'))
  RCONST(7662) = (5.65D-12)
  RCONST(7663) = (j('ch3coch2ono2'))
  RCONST(7664) = (1.38D-11)
  RCONST(7665) = (j('ch3o2h'))
  RCONST(7666) = (3.82D-12)
  RCONST(7667) = (KBPAN)
  RCONST(7668) = (3.79D-13)
  RCONST(7669) = (4.08D-12)
  RCONST(7670) = (j('ch3o2h'))
  RCONST(7671) = (5.44D-14)
  RCONST(7672) = (KBPAN)
  RCONST(7673) = (6.82D-11)
  RCONST(7674) = (j('ch3o2h')+j('ch3coch2ono2'))
  RCONST(7675) = (2.74D+09*EXP(-3430/TEMP))
  RCONST(7676) = (6.55D-13)
  RCONST(7677) = (j('ch3coch2ono2'))
  RCONST(7678) = (j('mek'))
  RCONST(7679) = (2.77D-11)
  RCONST(7680) = (j('ch3coch2ono2'))
  RCONST(7681) = (2.65D-12)
  RCONST(7682) = (6.11D-12)
  RCONST(7683) = (j('ch3o2h'))
  RCONST(7684) = (1.57D-12)
  RCONST(7685) = (KBPAN)
  RCONST(7686) = (7.08D-11)
  RCONST(7687) = (j('ch3o2h'))
  RCONST(7688) = (j('mek'))
  RCONST(7689) = (KROSEC*O2)
  RCONST(7690) = (1.58D-11)
  RCONST(7691) = (j('ch3o2h'))
  RCONST(7692) = (5.37D-12)
  RCONST(7693) = (KBPAN)
  RCONST(7694) = (1.62D-11)
  RCONST(7695) = (j('ch3o2h')+j('ch3coch2ono2')*1.6)
  RCONST(7696) = (KDEC)
  RCONST(7697) = (8.92D-12)
  RCONST(7698) = (j('ch3o2h')+j('mek'))
  RCONST(7699) = (KROSEC*O2)
  RCONST(7700) = (4.00D+04)
  RCONST(7701) = (1.25D-12)
  RCONST(7702) = (4.71D-12)
  RCONST(7703) = (j('ch3o2h'))
  RCONST(7704) = (3.81D-13)
  RCONST(7705) = (KBPAN)
  RCONST(7706) = (4.69D-12)
  RCONST(7707) = (j('ch3o2h'))
  RCONST(7708) = (2.25D-12)
  RCONST(7709) = (5.71D-12)
  RCONST(7710) = (j('ch3o2h')+j('1_c4h9ono2'))
  RCONST(7711) = (7.51D-13)
  RCONST(7712) = (KBPAN)
  RCONST(7713) = (1.79D-11)
  RCONST(7714) = (j('ch3o2h'))
  RCONST(7715) = (2.84D-12)
  RCONST(7716) = (KBPAN)
  RCONST(7717) = (7.13D-12)
  RCONST(7718) = (1.90D-12*EXP(190/TEMP))
  RCONST(7719) = (j('ch3o2h'))
  RCONST(7720) = (4.00D+04)
  RCONST(7721) = (KROPRIM*O2)
  RCONST(7722) = (3.95D-12)
  RCONST(7723) = (7.41D-12)
  RCONST(7724) = (j('ch3o2h'))
  RCONST(7725) = (2.99D-12)
  RCONST(7726) = (KBPAN)
  RCONST(7727) = (8.27D-11)
  RCONST(7728) = (j('ch3o2h')+j('ch3coch2ono2'))
  RCONST(7729) = (8.40D+10*EXP(-3523/TEMP))
  RCONST(7730) = (1.78D-12)
  RCONST(7731) = (j('mek'))
  RCONST(7732) = (j('ch3coch2ono2'))
  RCONST(7733) = (3.36D-11)
  RCONST(7734) = (j('ch3coch2ono2'))
  RCONST(7735) = (8.65D-11)
  RCONST(7736) = (j('ch3o2h')+j('mek'))
  RCONST(7737) = (8.40D+10*EXP(-3523/TEMP))
  RCONST(7738) = (3.75D-11)
  RCONST(7739) = (j('mek'))
  RCONST(7740) = (j('mek')*2)
  RCONST(7741) = (4.35D-12)
  RCONST(7742) = (j('ch3o2h'))
  RCONST(7743) = (1.72D-11)
  RCONST(7744) = (KBPAN)
  RCONST(7745) = (6.79D-12)
  RCONST(7746) = (6.84D-11)
  RCONST(7747) = (j('ch3o2h')+j('ch3coch2ono2')*1.6)
  RCONST(7748) = (4.20D+10*EXP(-1962/TEMP))
  RCONST(7749) = (8.05D-13)
  RCONST(7750) = (j('ch3coch2ono2')*1.6+j('mek'))
  RCONST(7751) = (2.78D-11)
  RCONST(7752) = (j('ch3coch2ono2')*1.6)
  RCONST(7753) = (1.91D-11)
  RCONST(7754) = (1.90D-12*EXP(190/TEMP))
  RCONST(7755) = (j('ch3o2h')+j('ch3coch2ono2')*1.6)
  RCONST(7756) = (4.00D+04)
  RCONST(7757) = (KROSEC*O2)
  RCONST(7758) = (1.38D-12)
  RCONST(7759) = (j('ch3coch2ono2')*1.6)
  RCONST(7760) = (8.98D-12)
  RCONST(7761) = (j('mek'))
  RCONST(7762) = (KRO2HO2*0.625)
  RCONST(7763) = (KRO2NO)
  RCONST(7764) = (KRO2NO3)
  RCONST(7765) = (8.80D-13*RO2)
  RCONST(7766) = (KDEC*0.5)
  RCONST(7767) = (KDEC*0.5)
  RCONST(7768) = (KRO2HO2*0.706)
  RCONST(7769) = (KRO2NO)
  RCONST(7770) = (KRO2NO3)
  RCONST(7771) = (8.80D-13*RO2*0.2)
  RCONST(7772) = (8.80D-13*RO2*0.6)
  RCONST(7773) = (8.80D-13*RO2*0.2)
  RCONST(7774) = (3.70D-11)
  RCONST(7775) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(7776) = (4.00D-11)
  RCONST(7777) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(7778) = (j('ch3o2h'))
  RCONST(7779) = (KDEC*0.40)
  RCONST(7780) = (KDEC*0.60)
  RCONST(7781) = (3.70D-11)
  RCONST(7782) = (KBPAN)
  RCONST(7783) = (2.31D-11)
  RCONST(7784) = (j('i_c3h7cho'))
  RCONST(7785) = (2.62D-11)
  RCONST(7786) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(7787) = (2.29D-11)
  RCONST(7788) = (KBPAN)
  RCONST(7789) = (1.44D-10)
  RCONST(7790) = (j('ch3o2h'))
  RCONST(7791) = (j('n_c3h7cho_hco')*2)
  RCONST(7792) = (KDEC)
  RCONST(7793) = (5.77D-11)
  RCONST(7794) = (j('n_c3h7cho_hco')*2)
  RCONST(7795) = (1.22D-10)
  RCONST(7796) = (1.90D-12*EXP(190/TEMP))
  RCONST(7797) = (j('n_c3h7cho_hco')*2)
  RCONST(7798) = (j('ch3o2h'))
  RCONST(7799) = (KDEC)
  RCONST(7800) = (3.67D-11)
  RCONST(7801) = (j('ch3cocho')+j('n_c3h7cho_hco'))
  RCONST(7802) = (8.13D-11)
  RCONST(7803) = (j('n_c3h7cho_hco')*2)
  RCONST(7804) = (2.08D-12)
  RCONST(7805) = (2.86D-13)
  RCONST(7806) = (2.60D-12)
  RCONST(7807) = (3.47D-12)
  RCONST(7808) = (KRO2HO2*0.770)
  RCONST(7809) = (KRO2NO)
  RCONST(7810) = (KRO2NO3)
  RCONST(7811) = (8.80D-13*RO2)
  RCONST(7812) = (3.00D-13)
  RCONST(7813) = (4.6D-12)
  RCONST(7814) = (5.44D-11)
  RCONST(7815) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(7816) = (1.00D-12)
  RCONST(7817) = (2.3D-11)
  RCONST(7818) = (2.08D-12)
  RCONST(7819) = (2.86D-13)
  RCONST(7820) = (4.65D-11)
  RCONST(7821) = (j('ch3o2h'))
  RCONST(7822) = (5.03D-12)
  RCONST(7823) = (6.83D-12)
  RCONST(7824) = (KRO2HO2*0.820)
  RCONST(7825) = (KRO2NO)
  RCONST(7826) = (KRO2NO3)
  RCONST(7827) = (8.80D-13*RO2)
  RCONST(7828) = (4.38D-11)
  RCONST(7829) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(7830) = (KAPHO2*0.44)
  RCONST(7831) = (KAPHO2*0.15)
  RCONST(7832) = (KAPHO2*0.41)
  RCONST(7833) = (KAPNO)
  RCONST(7834) = (KFPAN)
  RCONST(7835) = (KRO2NO3*1.74)
  RCONST(7836) = (1.00D-11*0.70*RO2)
  RCONST(7837) = (1.00D-11*0.30*RO2)
  RCONST(7838) = (KDEC*0.11)
  RCONST(7839) = (KDEC*0.89)
  RCONST(7840) = (KRO2HO2*0.706)
  RCONST(7841) = (KRO2NO)
  RCONST(7842) = (KRO2NO3)
  RCONST(7843) = (9.20D-14*RO2*0.30)
  RCONST(7844) = (9.20D-14*RO2*0.70)
  RCONST(7845) = (KRO2HO2*0.706)
  RCONST(7846) = (KRO2NO)
  RCONST(7847) = (KRO2NO3)
  RCONST(7848) = (1.40D-12*0.20*RO2)
  RCONST(7849) = (1.40D-12*0.20*RO2)
  RCONST(7850) = (1.40D-12*0.60*RO2)
  RCONST(7851) = (KRO2HO2*0.706)
  RCONST(7852) = (KRO2NO)
  RCONST(7853) = (KRO2NO3)
  RCONST(7854) = (9.20D-14*RO2)
  RCONST(7855) = (KDEC*0.5)
  RCONST(7856) = (KDEC*0.5)
  RCONST(7857) = (KRO2HO2*0.706)
  RCONST(7858) = (KRO2NO)
  RCONST(7859) = (KRO2NO3)
  RCONST(7860) = (9.20D-14*RO2*0.7)
  RCONST(7861) = (9.20D-14*RO2*0.3)
  RCONST(7862) = (KDEC*0.83)
  RCONST(7863) = (KDEC*0.17)
  RCONST(7864) = (3.59D-12)
  RCONST(7865) = (j('ch3o2h'))
  RCONST(7866) = (5.43D-11)
  RCONST(7867) = (KBPAN)
  RCONST(7868) = (j('ch3cocho'))
  RCONST(7869) = (8.0D-13)
  RCONST(7870) = (1.10D-12)
  RCONST(7871) = (4.66D-12)
  RCONST(7872) = (j('ch3o2h'))
  RCONST(7873) = (1.06D-12)
  RCONST(7874) = (KBPAN*0.67)
  RCONST(7875) = (KAPHO2*0.15)
  RCONST(7876) = (KAPHO2*0.41)
  RCONST(7877) = (KAPHO2*0.44)
  RCONST(7878) = (KAPNO)
  RCONST(7879) = (KFPAN)
  RCONST(7880) = (KRO2NO3*1.74)
  RCONST(7881) = (1.00D-11*0.30*RO2)
  RCONST(7882) = (1.00D-11*0.70*RO2)
  RCONST(7883) = (KDEC*0.27)
  RCONST(7884) = (KDEC*0.255)
  RCONST(7885) = (KDEC*0.255)
  RCONST(7886) = (KDEC*0.22)
  RCONST(7887) = (KRO2HO2*0.770)
  RCONST(7888) = (KRO2NO)
  RCONST(7889) = (KRO2NO3)
  RCONST(7890) = (9.20D-14*0.3*RO2)
  RCONST(7891) = (9.20D-14*0.7*RO2)
  RCONST(7892) = (KRO2HO2*0.770)
  RCONST(7893) = (KRO2NO)
  RCONST(7894) = (KRO2NO3)
  RCONST(7895) = (9.20D-14*RO2)
  RCONST(7896) = (KRO2HO2*0.770)
  RCONST(7897) = (KRO2NO)
  RCONST(7898) = (KRO2NO3*1.74)
  RCONST(7899) = (8.80D-13*RO2*0.2)
  RCONST(7900) = (8.80D-13*RO2*0.6)
  RCONST(7901) = (8.80D-13*RO2*0.2)
  RCONST(7902) = (KRO2HO2*0.770)
  RCONST(7903) = (KRO2NO)
  RCONST(7904) = (KRO2NO3)
  RCONST(7905) = (9.20D-14*RO2*0.70)
  RCONST(7906) = (9.20D-14*RO2*0.30)
  RCONST(7907) = (2.22D-11)
  RCONST(7908) = (j('i_c3h7cho'))
  RCONST(7909) = (2.53D-11)
  RCONST(7910) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(7911) = (2.21D-11)
  RCONST(7912) = (KBPAN)
  RCONST(7913) = (6.97D-11)
  RCONST(7914) = (j('i_c3h7cho'))
  RCONST(7915) = (j('ch3o2h'))
  RCONST(7916) = (j('mek'))
  RCONST(7917) = (KDEC*0.5)
  RCONST(7918) = (KDEC*0.5)
  RCONST(7919) = (6.63D-11)
  RCONST(7920) = (j('i_c3h7cho'))
  RCONST(7921) = (j('mek'))
  RCONST(7922) = (5.08D-11)
  RCONST(7923) = (j('mvk_mcm_ch2ch'))
  RCONST(7924) = (2.08D-12)
  RCONST(7925) = (2.86D-13)
  RCONST(7926) = (4.65D-11)
  RCONST(7927) = (j('ch3o2h'))
  RCONST(7928) = (1.00D-12)
  RCONST(7929) = (2.35D-10)
  RCONST(7930) = (5.03D-12)
  RCONST(7931) = (6.83D-12)
  RCONST(7932) = (KRO2HO2*0.859)
  RCONST(7933) = (KRO2NO)
  RCONST(7934) = (KRO2NO3)
  RCONST(7935) = (8.80D-13*RO2)
  RCONST(7936) = (1.10D-12)
  RCONST(7937) = (4.66D-12)
  RCONST(7938) = (j('ch3o2h'))
  RCONST(7939) = (1.06D-12)
  RCONST(7940) = (KBPAN*0.67)
  RCONST(7941) = (1.90D-12*EXP(190/TEMP))
  RCONST(7942) = (j('ch3o2h'))
  RCONST(7943) = (3.90D-13)
  RCONST(7944) = (KRO2HO2*0.770)
  RCONST(7945) = (KRO2NO)
  RCONST(7946) = (KRO2NO3)
  RCONST(7947) = (9.20D-14*0.70*RO2)
  RCONST(7948) = (9.20D-14*0.30*RO2)
  RCONST(7949) = (KRO2HO2*0.770)
  RCONST(7950) = (KRO2NO)
  RCONST(7951) = (KRO2NO3)
  RCONST(7952) = (9.20D-14*RO2)
  RCONST(7953) = (KRO2HO2*0.706)
  RCONST(7954) = (KRO2NO)
  RCONST(7955) = (KRO2NO3)
  RCONST(7956) = (8.80D-13*RO2*0.2)
  RCONST(7957) = (8.80D-13*RO2*0.6)
  RCONST(7958) = (8.80D-13*RO2*0.2)
  RCONST(7959) = (KRO2HO2*0.770)
  RCONST(7960) = (KRO2NO)
  RCONST(7961) = (KRO2NO3)
  RCONST(7962) = (9.20D-14*RO2*0.70)
  RCONST(7963) = (9.20D-14*RO2*0.30)
  RCONST(7964) = (KRO2HO2*0.706)
  RCONST(7965) = (KRO2NO)
  RCONST(7966) = (KRO2NO3)
  RCONST(7967) = (9.20D-14*RO2)
  RCONST(7968) = (KRO2HO2*0.625)
  RCONST(7969) = (KRO2NO)
  RCONST(7970) = (KRO2NO3)
  RCONST(7971) = (2.00D-12*RO2)
  RCONST(7972) = (KRO2HO2*0.706)
  RCONST(7973) = (KRO2NO)
  RCONST(7974) = (KRO2NO3)
  RCONST(7975) = (9.20D-14*RO2*0.70)
  RCONST(7976) = (9.20D-14*RO2*0.30)
  RCONST(7977) = (KDEC*0.35)
  RCONST(7978) = (KDEC*0.65)
  RCONST(7979) = (4.73D-11)
  RCONST(7980) = (j('ch3o2h'))
  RCONST(7981) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(7982) = (4.37D-11)
  RCONST(7983) = (KBPAN)
  RCONST(7984) = (2.27D-11)
  RCONST(7985) = (j('i_c3h7cho'))
  RCONST(7986) = (2.57D-11)
  RCONST(7987) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(7988) = (2.25D-11)
  RCONST(7989) = (KBPAN)
  RCONST(7990) = (1.35D-10)
  RCONST(7991) = (j('ch3o2h'))
  RCONST(7992) = (j('i_c3h7cho')*2)
  RCONST(7993) = (KDEC)
  RCONST(7994) = (2.08D-12)
  RCONST(7995) = (2.86D-13)
  RCONST(7996) = (4.65D-11)
  RCONST(7997) = (j('ch3o2h'))
  RCONST(7998) = (1.00D-12)
  RCONST(7999) = (2.35D-11)
  RCONST(8000) = (5.03D-12)
  RCONST(8001) = (6.83D-12)
  RCONST(8002) = (KRO2HO2*0.859)
  RCONST(8003) = (KRO2NO)
  RCONST(8004) = (KRO2NO3)
  RCONST(8005) = (8.80D-13*RO2)
  RCONST(8006) = (4.66D-11)
  RCONST(8007) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(8008) = (1.10D-12)
  RCONST(8009) = (4.66D-12)
  RCONST(8010) = (j('ch3o2h'))
  RCONST(8011) = (1.06D-12)
  RCONST(8012) = (KBPAN*0.67)
  RCONST(8013) = (1.90D-12*EXP(190/TEMP))
  RCONST(8014) = (j('ch3o2h'))
  RCONST(8015) = (3.90D-13)
  RCONST(8016) = (KRO2HO2*0.770)
  RCONST(8017) = (KRO2NO)
  RCONST(8018) = (KRO2NO3)
  RCONST(8019) = (8.80D-13*0.20*RO2)
  RCONST(8020) = (8.80D-13*0.20*RO2)
  RCONST(8021) = (8.80D-13*0.60*RO2)
  RCONST(8022) = (2.08D-12)
  RCONST(8023) = (2.86D-13)
  RCONST(8024) = (4.65D-11)
  RCONST(8025) = (j('ch3o2h'))
  RCONST(8026) = (1.00D-12)
  RCONST(8027) = (2.35D-11)
  RCONST(8028) = (5.03D-12)
  RCONST(8029) = (6.83D-12)
  RCONST(8030) = (KRO2HO2*0.859)
  RCONST(8031) = (KRO2NO)
  RCONST(8032) = (KRO2NO3)
  RCONST(8033) = (8.80D-13*RO2)
  RCONST(8034) = (1.10D-12)
  RCONST(8035) = (4.66D-12)
  RCONST(8036) = (j('ch3o2h'))
  RCONST(8037) = (1.06D-12)
  RCONST(8038) = (KBPAN*0.67)
  RCONST(8039) = (2.08D-12)
  RCONST(8040) = (2.86D-13)
  RCONST(8041) = (4.65D-11)
  RCONST(8042) = (j('ch3o2h'))
  RCONST(8043) = (3.73D-11)
  RCONST(8044) = (j('mvk_mcm_ch2ch'))
  RCONST(8045) = (1.00D-12)
  RCONST(8046) = (2.35D-11)
  RCONST(8047) = (5.03D-12)
  RCONST(8048) = (6.83D-12)
  RCONST(8049) = (KRO2HO2*0.859)
  RCONST(8050) = (KRO2NO)
  RCONST(8051) = (KRO2NO3)
  RCONST(8052) = (8.80D-13*RO2)
  RCONST(8053) = (4.89D-11)
  RCONST(8054) = (j('mvk_mcm_ch2ch'))
  RCONST(8055) = (KRO2HO2*0.770)
  RCONST(8056) = (KRO2NO)
  RCONST(8057) = (KRO2NO3)
  RCONST(8058) = (8.80D-13*0.20*RO2)
  RCONST(8059) = (8.80D-13*0.20*RO2)
  RCONST(8060) = (8.80D-13*0.60*RO2)
  RCONST(8061) = (KRO2HO2*0.770)
  RCONST(8062) = (KRO2NO)
  RCONST(8063) = (KRO2NO3)
  RCONST(8064) = (8.80D-13*RO2)
  RCONST(8065) = (KRO2HO2*0.625)
  RCONST(8066) = (KRO2NO)
  RCONST(8067) = (KRO2NO3)
  RCONST(8068) = (8.80D-13*0.6*RO2)
  RCONST(8069) = (8.80D-13*0.2*RO2)
  RCONST(8070) = (8.80D-13*0.2*RO2)
  RCONST(8071) = (KRO2HO2*0.770)
  RCONST(8072) = (KRO2NO)
  RCONST(8073) = (KRO2NO3)
  RCONST(8074) = (8.80D-13*RO2*0.20)
  RCONST(8075) = (8.80D-13*RO2*0.60)
  RCONST(8076) = (8.80D-13*RO2*0.20)
  RCONST(8077) = (KDEC*0.35)
  RCONST(8078) = (KDEC*0.65)
  RCONST(8079) = (4.09D-11)
  RCONST(8080) = (j('ch3o2h'))
  RCONST(8081) = (j('mvk_mcm_ch2ch'))
  RCONST(8082) = (3.73D-11)
  RCONST(8083) = (KBPAN)
  RCONST(8084) = (2.53D-12)
  RCONST(8085) = (j('ch3cocho'))
  RCONST(8086) = (7.09D-11)
  RCONST(8087) = (j('mek'))
  RCONST(8088) = (j('i_c3h7cho'))
  RCONST(8089) = (KRO2HO2*0.820)
  RCONST(8090) = (KRO2NO)
  RCONST(8091) = (KRO2NO3)
  RCONST(8092) = (8.80D-13*RO2)
  RCONST(8093) = (5.15D-11)
  RCONST(8094) = (j('ch3o2h'))
  RCONST(8095) = (KDEC)
  RCONST(8096) = (6.00D-12)
  RCONST(8097) = (j('biacet'))
  RCONST(8098) = (1.29D-11)
  RCONST(8099) = (3.62D-11)
  RCONST(8100) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(8101) = (2.08D-12)
  RCONST(8102) = (2.86D-13)
  RCONST(8103) = (4.65D-11)
  RCONST(8104) = (j('ch3o2h'))
  RCONST(8105) = (1.00D-12)
  RCONST(8106) = (2.35D-11)
  RCONST(8107) = (5.03D-12)
  RCONST(8108) = (6.83D-12)
  RCONST(8109) = (KRO2HO2*0.90)
  RCONST(8110) = (KRO2NO)
  RCONST(8111) = (KRO2NO3)
  RCONST(8112) = (8.80D-13*RO2)
  RCONST(8113) = (5.00D-11)
  RCONST(8114) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(8115) = (KDEC*0.125)
  RCONST(8116) = (KDEC*0.57)
  RCONST(8117) = (KDEC*0.125)
  RCONST(8118) = (KDEC*0.18)
  RCONST(8119) = (KRO2HO2*0.820)
  RCONST(8120) = (KRO2NO)
  RCONST(8121) = (KRO2NO3)
  RCONST(8122) = (8.80D-13*RO2*0.2)
  RCONST(8123) = (8.80D-13*RO2*0.6)
  RCONST(8124) = (8.80D-13*RO2*0.2)
  RCONST(8125) = (KRO2HO2*0.820)
  RCONST(8126) = (KRO2NO)
  RCONST(8127) = (KRO2NO3)
  RCONST(8128) = (8.80D-13*RO2)
  RCONST(8129) = (KRO2HO2*0.706)
  RCONST(8130) = (KRO2NO)
  RCONST(8131) = (KRO2NO3)
  RCONST(8132) = (8.80D-13*0.6*RO2)
  RCONST(8133) = (8.80D-13*0.2*RO2)
  RCONST(8134) = (8.80D-13*0.2*RO2)
  RCONST(8135) = (KRO2HO2*0.820)
  RCONST(8136) = (KRO2NO)
  RCONST(8137) = (KRO2NO3)
  RCONST(8138) = (8.80D-13*RO2*0.20)
  RCONST(8139) = (8.80D-13*RO2*0.60)
  RCONST(8140) = (8.80D-13*RO2*0.20)
  RCONST(8141) = (KDEC*0.65)
  RCONST(8142) = (KDEC*0.35)
  RCONST(8143) = (3.94D-11)
  RCONST(8144) = (j('ch3o2h'))
  RCONST(8145) = (j('mvk_mcm_ch2ch'))
  RCONST(8146) = (3.58D-11)
  RCONST(8147) = (KBPAN)
  RCONST(8148) = (5.05D-12)
  RCONST(8149) = (j('mek'))
  RCONST(8150) = (7.41D-11)
  RCONST(8151) = (j('mek'))
  RCONST(8152) = (j('i_c3h7cho'))
  RCONST(8153) = (KRO2HO2*0.859)
  RCONST(8154) = (KRO2NO)
  RCONST(8155) = (KRO2NO3)
  RCONST(8156) = (8.80D-13*RO2)
  RCONST(8157) = (KRO2HO2*0.859)
  RCONST(8158) = (KRO2NO)
  RCONST(8159) = (KRO2NO3)
  RCONST(8160) = (1.30D-12*RO2*0.6)
  RCONST(8161) = (1.30D-12*RO2*0.2)
  RCONST(8162) = (1.30D-12*RO2*0.2)
  RCONST(8163) = (2.08D-12)
  RCONST(8164) = (2.86D-13)
  RCONST(8165) = (4.65D-11)
  RCONST(8166) = (j('ch3o2h'))
  RCONST(8167) = (3.42D-11)
  RCONST(8168) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(8169) = (1.00D-12)
  RCONST(8170) = (2.35D-11)
  RCONST(8171) = (5.03D-12)
  RCONST(8172) = (6.83D-12)
  RCONST(8173) = (KRO2HO2*0.90)
  RCONST(8174) = (KRO2NO)
  RCONST(8175) = (KRO2NO3)
  RCONST(8176) = (8.80D-13*RO2)
  RCONST(8177) = (5.00D-11)
  RCONST(8178) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(8179) = (KRO2HO2*0.820)
  RCONST(8180) = (KRO2NO)
  RCONST(8181) = (KRO2NO3)
  RCONST(8182) = (8.80D-13*RO2*0.2)
  RCONST(8183) = (8.80D-13*RO2*0.6)
  RCONST(8184) = (8.80D-13*RO2*0.2)
  RCONST(8185) = (KRO2HO2*0.820)
  RCONST(8186) = (KRO2NO)
  RCONST(8187) = (KRO2NO3)
  RCONST(8188) = (8.80D-13*RO2)
  RCONST(8189) = (KRO2HO2*0.706)
  RCONST(8190) = (KRO2NO)
  RCONST(8191) = (KRO2NO3)
  RCONST(8192) = (8.80D-13*0.2*RO2)
  RCONST(8193) = (8.80D-13*0.2*RO2)
  RCONST(8194) = (8.80D-13*0.6*RO2)
  RCONST(8195) = (KRO2HO2*0.820)
  RCONST(8196) = (KRO2NO)
  RCONST(8197) = (KRO2NO3)
  RCONST(8198) = (8.80D-13*RO2*0.20)
  RCONST(8199) = (8.80D-13*RO2*0.60)
  RCONST(8200) = (8.80D-13*RO2*0.20)
  RCONST(8201) = (KDEC*0.35)
  RCONST(8202) = (KDEC*0.65)
  RCONST(8203) = (3.74D-11)
  RCONST(8204) = (j('ch3o2h'))
  RCONST(8205) = (j('mvk_mcm_ch2ch'))
  RCONST(8206) = (3.38D-11)
  RCONST(8207) = (KBPAN)
  RCONST(8208) = (3.05D-12)
  RCONST(8209) = (j('mek'))
  RCONST(8210) = (7.20D-11)
  RCONST(8211) = (j('mek'))
  RCONST(8212) = (j('i_c3h7cho'))
  RCONST(8213) = (KRO2HO2*0.859)
  RCONST(8214) = (KRO2NO)
  RCONST(8215) = (KRO2NO3)
  RCONST(8216) = (8.80D-13*RO2)
  RCONST(8217) = (7.92D-13)
  RCONST(8218) = (3.86D-12)
  RCONST(8219) = (j('ch3o2h'))
  RCONST(8220) = (1.06D-12)
  RCONST(8221) = (KBPAN)
  RCONST(8222) = (4.52D-11)
  RCONST(8223) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(8224) = (2.08D-12)
  RCONST(8225) = (2.86D-13)
  RCONST(8226) = (4.65D-11)
  RCONST(8227) = (j('ch3o2h'))
  RCONST(8228) = (5.03D-12)
  RCONST(8229) = (6.83D-12)
  RCONST(8230) = (KRO2HO2*0.90)
  RCONST(8231) = (KRO2NO)
  RCONST(8232) = (KRO2NO3)
  RCONST(8233) = (8.80D-13*RO2)
  RCONST(8234) = (KAPHO2*0.44)
  RCONST(8235) = (KAPHO2*0.15)
  RCONST(8236) = (KAPHO2*0.41)
  RCONST(8237) = (KAPNO)
  RCONST(8238) = (KFPAN)
  RCONST(8239) = (KRO2NO3*1.74)
  RCONST(8240) = (1.00D-11*RO2*0.7)
  RCONST(8241) = (1.00D-11*RO2*0.3)
  RCONST(8242) = (KRO2HO2*0.820)
  RCONST(8243) = (KRO2NO)
  RCONST(8244) = (KRO2NO3)
  RCONST(8245) = (9.20D-14*RO2*0.7)
  RCONST(8246) = (9.20D-14*RO2*0.3)
  RCONST(8247) = (KRO2HO2*0.706)
  RCONST(8248) = (KRO2NO)
  RCONST(8249) = (KRO2NO3)
  RCONST(8250) = (9.20D-14*RO2)
  RCONST(8251) = (1.85D-11)
  RCONST(8252) = (j('mek')+j('ch3cocho'))
  RCONST(8253) = (KRO2HO2*0.770)
  RCONST(8254) = (KRO2NO)
  RCONST(8255) = (KRO2NO3)
  RCONST(8256) = (9.20D-14*RO2*0.70)
  RCONST(8257) = (9.20D-14*RO2*0.30)
  RCONST(8258) = (KRO2HO2*0.770)
  RCONST(8259) = (KRO2NO)
  RCONST(8260) = (KRO2NO3)
  RCONST(8261) = (9.20D-14*RO2)
  RCONST(8262) = (KRO2HO2*0.820)
  RCONST(8263) = (KRO2NO)
  RCONST(8264) = (KRO2NO3*1.74)
  RCONST(8265) = (9.20D-14*RO2*0.7)
  RCONST(8266) = (9.20D-14*RO2*0.3)
  RCONST(8267) = (KRO2HO2*0.820)
  RCONST(8268) = (KRO2NO)
  RCONST(8269) = (KRO2NO3)
  RCONST(8270) = (9.20D-14*RO2*0.70)
  RCONST(8271) = (9.20D-14*RO2*0.30)
  RCONST(8272) = (2.10D-12)
  RCONST(8273) = (j('mek'))
  RCONST(8274) = (5.18D-12)
  RCONST(8275) = (j('ch3o2h')+j('mek'))
  RCONST(8276) = (1.95D-12)
  RCONST(8277) = (KBPAN)
  RCONST(8278) = (7.83D-11)
  RCONST(8279) = (j('ch3o2h'))
  RCONST(8280) = (j('mek'))
  RCONST(8281) = (j('i_c3h7cho'))
  RCONST(8282) = (1.10D-12)
  RCONST(8283) = (4.66D-12)
  RCONST(8284) = (j('ch3o2h'))
  RCONST(8285) = (1.06D-12)
  RCONST(8286) = (KBPAN)
  RCONST(8287) = (1.90D-12*EXP(190/TEMP))
  RCONST(8288) = (j('ch3o2h'))
  RCONST(8289) = (3.90D-13)
  RCONST(8290) = (KDEC*0.89)
  RCONST(8291) = (KDEC*0.11)
  RCONST(8292) = (KRO2HO2*0.820)
  RCONST(8293) = (KRO2NO)
  RCONST(8294) = (KRO2NO3)
  RCONST(8295) = (9.20D-14*RO2*0.7)
  RCONST(8296) = (9.20D-14*RO2*0.3)
  RCONST(8297) = (5.52D-11)
  RCONST(8298) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(8299) = (2.08D-12)
  RCONST(8300) = (2.86D-13)
  RCONST(8301) = (4.65D-11)
  RCONST(8302) = (j('ch3o2h'))
  RCONST(8303) = (1.00D-12)
  RCONST(8304) = (2.35D-11)
  RCONST(8305) = (5.03D-12)
  RCONST(8306) = (6.83D-12)
  RCONST(8307) = (KRO2HO2*0.90)
  RCONST(8308) = (KRO2NO)
  RCONST(8309) = (KRO2NO3)
  RCONST(8310) = (8.80D-13*RO2)
  RCONST(8311) = (3.54D-11)
  RCONST(8312) = (j('mvk_mcm_ch2ch'))
  RCONST(8313) = (1.10D-12)
  RCONST(8314) = (4.66D-12)
  RCONST(8315) = (j('ch3o2h'))
  RCONST(8316) = (1.06D-12)
  RCONST(8317) = (KBPAN*0.67)
  RCONST(8318) = (3.60D-12)
  RCONST(8319) = (j('ch3o2h'))
  RCONST(8320) = (3.90D-13)
  RCONST(8321) = (KDEC*0.35)
  RCONST(8322) = (KDEC*0.65)
  RCONST(8323) = (3.90D-11)
  RCONST(8324) = (j('ch3o2h'))
  RCONST(8325) = (j('mvk_mcm_ch2ch'))
  RCONST(8326) = (3.54D-11)
  RCONST(8327) = (KBPAN)
  RCONST(8328) = (2.11D-12)
  RCONST(8329) = (j('mek'))
  RCONST(8330) = (5.17D-12)
  RCONST(8331) = (j('ch3o2h')+j('mek'))
  RCONST(8332) = (1.95D-12)
  RCONST(8333) = (KBPAN)
  RCONST(8334) = (1.75D-11)
  RCONST(8335) = (j('ch3o2h'))
  RCONST(8336) = (j('mek'))
  RCONST(8337) = (KDEC)
  RCONST(8338) = (4.06D-12)
  RCONST(8339) = (j('mek')*2)
  RCONST(8340) = (2.04D-13)
  RCONST(8341) = (j('biacet'))
  RCONST(8342) = (2.05D-11)
  RCONST(8343) = (j('ch3o2h'))
  RCONST(8344) = (j('mek'))
  RCONST(8345) = (KDEC)
  RCONST(8346) = (8.93D-12)
  RCONST(8347) = (j('mek'))
  RCONST(8348) = (1.29D-11)
  RCONST(8349) = (j('ch3cocho'))
  RCONST(8350) = (2.55D-11)
  RCONST(8351) = (j('i_c3h7cho'))
  RCONST(8352) = (2.85D-11)
  RCONST(8353) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(8354) = (2.54D-11)
  RCONST(8355) = (KBPAN)
  RCONST(8356) = (7.30D-11)
  RCONST(8357) = (j('ch3o2h'))
  RCONST(8358) = (j('mek'))
  RCONST(8359) = (j('i_c3h7cho'))
  RCONST(8360) = (KDEC*0.5)
  RCONST(8361) = (KDEC*0.5)
  RCONST(8362) = (4.56D-11)
  RCONST(8363) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(8364) = (2.08D-12)
  RCONST(8365) = (2.86D-13)
  RCONST(8366) = (4.65D-11)
  RCONST(8367) = (j('ch3o2h'))
  RCONST(8368) = (1.00D-12)
  RCONST(8369) = (2.35D-11)
  RCONST(8370) = (5.03D-12)
  RCONST(8371) = (6.83D-12)
  RCONST(8372) = (KRO2HO2*0.90)
  RCONST(8373) = (KRO2NO)
  RCONST(8374) = (KRO2NO3)
  RCONST(8375) = (8.80D-13*RO2)
  RCONST(8376) = (j('ch3cocho'))
  RCONST(8377) = (j('biacet'))
  RCONST(8378) = (KNO3AL*4.0)
  RCONST(8379) = (1.23D-11)
  RCONST(8380) = (2.08D-12)
  RCONST(8381) = (2.86D-13)
  RCONST(8382) = (4.65D-11)
  RCONST(8383) = (j('ch3o2h'))
  RCONST(8384) = (1.00D-12)
  RCONST(8385) = (2.35D-11)
  RCONST(8386) = (5.03D-12)
  RCONST(8387) = (6.83D-12)
  RCONST(8388) = (KRO2HO2*0.90)
  RCONST(8389) = (KRO2NO)
  RCONST(8390) = (KRO2NO3)
  RCONST(8391) = (8.80D-13*RO2)
  RCONST(8392) = (KRO2HO2*0.820)
  RCONST(8393) = (KRO2NO)
  RCONST(8394) = (KRO2NO3)
  RCONST(8395) = (8.80D-13*RO2*0.2)
  RCONST(8396) = (8.80D-13*RO2*0.6)
  RCONST(8397) = (8.80D-13*RO2*0.2)
  RCONST(8398) = (2.08D-12)
  RCONST(8399) = (2.86D-13)
  RCONST(8400) = (4.65D-11)
  RCONST(8401) = (j('ch3o2h'))
  RCONST(8402) = (1.00D-12)
  RCONST(8403) = (2.35D-11)
  RCONST(8404) = (5.03D-12)
  RCONST(8405) = (6.83D-12)
  RCONST(8406) = (KRO2HO2*0.90)
  RCONST(8407) = (KRO2NO)
  RCONST(8408) = (KRO2NO3)
  RCONST(8409) = (8.80D-13*RO2)
  RCONST(8410) = (2.05D-11)
  RCONST(8411) = (j('ch3o2h'))
  RCONST(8412) = (j('mek'))
  RCONST(8413) = (KDEC)
  RCONST(8414) = (8.93D-12)
  RCONST(8415) = (j('mek'))
  RCONST(8416) = (1.29D-11)
  RCONST(8417) = (j('ch3cocho'))
  RCONST(8418) = (KAPHO2*0.44)
  RCONST(8419) = (KAPHO2*0.15)
  RCONST(8420) = (KAPHO2*0.41)
  RCONST(8421) = (KAPNO)
  RCONST(8422) = (KFPAN)
  RCONST(8423) = (KRO2NO3*1.74)
  RCONST(8424) = (1.00D-11*RO2*0.7)
  RCONST(8425) = (1.00D-11*RO2*0.3)
  RCONST(8426) = (KRO2HO2*0.820)
  RCONST(8427) = (KRO2NO)
  RCONST(8428) = (KRO2NO3)
  RCONST(8429) = (9.20D-14*RO2*0.7)
  RCONST(8430) = (9.20D-14*RO2*0.3)
  RCONST(8431) = (KRO2HO2*0.820)
  RCONST(8432) = (KRO2NO)
  RCONST(8433) = (KRO2NO3)
  RCONST(8434) = (9.20D-14*RO2)
  RCONST(8435) = (KRO2HO2*0.770)
  RCONST(8436) = (KRO2NO)
  RCONST(8437) = (KRO2NO3)
  RCONST(8438) = (8.80D-13*RO2*0.2)
  RCONST(8439) = (8.80D-13*RO2*0.6)
  RCONST(8440) = (8.80D-13*RO2*0.2)
  RCONST(8441) = (KRO2HO2*0.820)
  RCONST(8442) = (KRO2NO)
  RCONST(8443) = (KRO2NO3)
  RCONST(8444) = (9.20D-14*RO2*0.70)
  RCONST(8445) = (9.20D-14*RO2*0.30)
  RCONST(8446) = (5.29D-12)
  RCONST(8447) = (j('mek'))
  RCONST(8448) = (j('mek'))
  RCONST(8449) = (2.05D-11)
  RCONST(8450) = (j('mek'))
  RCONST(8451) = (j('ch3o2h'))
  RCONST(8452) = (KDEC)
  RCONST(8453) = (8.93D-12)
  RCONST(8454) = (j('mek'))
  RCONST(8455) = (1.29D-11)
  RCONST(8456) = (j('ch3cocho'))
  RCONST(8457) = (4.66D-12)
  RCONST(8458) = (j('ch3o2h'))
  RCONST(8459) = (KRO2HO2*0.890)
  RCONST(8460) = (KRO2NO)
  RCONST(8461) = (KRO2NO3)
  RCONST(8462) = (2.50D-13*RO2)
  RCONST(8463) = (1.06D-12)
  RCONST(8464) = (KBPAN)
  RCONST(8465) = (4.56D-11)
  RCONST(8466) = (4.56D-11)
  RCONST(8467) = (j('mek'))
  RCONST(8468) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(8469) = (2.64D-11)
  RCONST(8470) = (j('ch3o2h'))
  RCONST(8471) = (2.32D-11)
  RCONST(8472) = (KBPAN)
  RCONST(8473) = (5.39D-12)
  RCONST(8474) = (j('mek'))
  RCONST(8475) = (8.46D-12)
  RCONST(8476) = (j('ch3o2h')+j('mek'))
  RCONST(8477) = (5.23D-12)
  RCONST(8478) = (KBPAN)
  RCONST(8479) = (1.38D-10)
  RCONST(8480) = (j('ch3o2h'))
  RCONST(8481) = (j('i_c3h7cho')*2)
  RCONST(8482) = (KDEC)
  RCONST(8483) = (1.35D-10)
  RCONST(8484) = (j('i_c3h7cho')*2)
  RCONST(8485) = (1.41D-11)
  RCONST(8486) = (j('ch3o2h'))
  RCONST(8487) = (j('mek')*2)
  RCONST(8488) = (KDEC)
  RCONST(8489) = (1.33D-12)
  RCONST(8490) = (j('biacet')*2)
  RCONST(8491) = (j('ch3o2h'))
  RCONST(8492) = (j('mek'))
  RCONST(8493) = (3.96D-11)
  RCONST(8494) = (KDEC)
  RCONST(8495) = (j('biacet'))
  RCONST(8496) = (2.32D-12)
  RCONST(8497) = (j('mek'))
  RCONST(8498) = (1.88D-11)
  RCONST(8499) = (1.52D-11)
  RCONST(8500) = (j('ch3o2h'))
  RCONST(8501) = (1.88D-11)
  RCONST(8502) = (KBPAN)
  RCONST(8503) = (1.52D-11)
  RCONST(8504) = (1.2D-15)
  RCONST(8505) = (1.0D-14)
  RCONST(8506) = (1.0D-15)
  RCONST(8507) = (7.0D-14)
  RCONST(8508) = (6.0D-18*H2O)
  RCONST(8509) = (1.0D-17*H2O)
  RCONST(8510) = (j('ch3o2h'))
  RCONST(8511) = (j('n_c3h7cho_hco'))
  RCONST(8512) = (6.21D-11)
  RCONST(8513) = (KDEC)
  RCONST(8514) = (j('n_c3h7cho_hco'))
  RCONST(8515) = (3.53D-11)
  RCONST(8516) = (j('n_c3h7cho_hco'))
  RCONST(8517) = (KNO3AL)
  RCONST(8518) = (2.46D-11)
  RCONST(8519) = (1.88D-11)
  RCONST(8520) = (j('ch3o2h'))
  RCONST(8521) = (2.23D-11)
  RCONST(8522) = (KBPAN)
  RCONST(8523) = (1.87D-11)
  RCONST(8524) = (1.2D-15)
  RCONST(8525) = (1.0D-14)
  RCONST(8526) = (1.0D-15)
  RCONST(8527) = (7.0D-14)
  RCONST(8528) = (6.0D-18*H2O)
  RCONST(8529) = (1.0D-17*H2O)
  RCONST(8530) = (j('ch3o2h'))
  RCONST(8531) = (1.39D-10)
  RCONST(8532) = (2.50D-11)
  RCONST(8533) = (KDEC)
  RCONST(8534) = (j('n_c3h7cho_hco'))
  RCONST(8535) = (6.59D-11)
  RCONST(8536) = (j('n_c3h7cho_hco'))
  RCONST(8537) = (KNO3AL*4.0)
  RCONST(8538) = (2.66D-11)
  RCONST(8539) = (1.20D-15)
  RCONST(8540) = (1.00D-14)
  RCONST(8541) = (1.00D-15)
  RCONST(8542) = (7.00D-14)
  RCONST(8543) = (6.00D-18*H2O)
  RCONST(8544) = (1.00D-17*H2O)
  RCONST(8545) = (5.98D-11)
  RCONST(8546) = (j('ch3o2h')+j('mek'))
  RCONST(8547) = (4.37D-12)
  RCONST(8548) = (KDEC)
  RCONST(8549) = (2.10D-11)
  RCONST(8550) = (j('mek'))
  RCONST(8551) = (4.39D-12)
  RCONST(8552) = (j('mek'))
  RCONST(8553) = (j('ch3o2h'))
  RCONST(8554) = (KDEC)
  RCONST(8555) = (4.44D-12)
  RCONST(8556) = (j('biacet'))
  RCONST(8557) = (j('ch3o2h'))
  RCONST(8558) = (4.42D-11)
  RCONST(8559) = (KBPAN)
  RCONST(8560) = (4.06D-11)
  RCONST(8561) = (1.2D-15)
  RCONST(8562) = (1.0D-14)
  RCONST(8563) = (1.0D-15)
  RCONST(8564) = (7.0D-14)
  RCONST(8565) = (6.0D-18*H2O)
  RCONST(8566) = (j('ch3o2h'))
  RCONST(8567) = (3.31D-11*0.89)
  RCONST(8568) = (3.31D-11*0.11)
  RCONST(8569) = (1.98D-12*0.445)
  RCONST(8570) = (1.98D-12*0.414)
  RCONST(8571) = (1.98D-12*0.141)
  RCONST(8572) = (KDEC)
  RCONST(8573) = (j('ch3coch2ono2')*0.91)
  RCONST(8574) = (3.30D-12)
  RCONST(8575) = (1.53D-11)
  RCONST(8576) = (2.16D-11)
  RCONST(8577) = (j('ch3o2h'))
  RCONST(8578) = (2.52D-11)
  RCONST(8579) = (KBPAN)
  RCONST(8580) = (2.16D-11)
  RCONST(8581) = (1.2D-15)
  RCONST(8582) = (1.0D-14)
  RCONST(8583) = (1.0D-15)
  RCONST(8584) = (7.0D-14)
  RCONST(8585) = (6.0D-18*H2O)
  RCONST(8586) = (j('ch3o2h'))
  RCONST(8587) = (2.81D-11)
  RCONST(8588) = (KDEC)
  RCONST(8589) = (2.69D-11)
  RCONST(8590) = (7.20D-12)
  RCONST(8591) = (j('ch3coch2ono2')*10)
  RCONST(8592) = (8.40D-12)
  RCONST(8593) = (KRO2HO2*0.706)
  RCONST(8594) = (KRO2NO*0.019)
  RCONST(8595) = (KRO2NO*0.981)
  RCONST(8596) = (KRO2NO3)
  RCONST(8597) = (9.20D-14*RO2)
  RCONST(8598) = (K14ISOM1)
  RCONST(8599) = (1.90D-11)
  RCONST(8600) = (2.00D-17)
  RCONST(8601) = (9.00D-11)
  RCONST(8602) = (KDEC*0.11)
  RCONST(8603) = (KDEC*0.89)
  RCONST(8604) = (KDEC*0.11)
  RCONST(8605) = (KDEC*0.89)
  RCONST(8606) = (6.60D-11)
  RCONST(8607) = (j('ch3o2h'))
  RCONST(8608) = (j('i_c3h7cho'))
  RCONST(8609) = (j('ch3o2h')*2)
  RCONST(8610) = (KDEC)
  RCONST(8611) = (2.92D-11*0.56)
  RCONST(8612) = (2.92D-11*0.44)
  RCONST(8613) = (j('ch3o2h')+j('mek'))
  RCONST(8614) = (j('ch3o2h'))
  RCONST(8615) = (2.40D-17*0.27)
  RCONST(8616) = (2.40D-17*0.73)
  RCONST(8617) = (4.72D-11)
  RCONST(8618) = (j('c5hpald')*2)
  RCONST(8619) = (KDEC)
  RCONST(8620) = (4.58D-11)
  RCONST(8621) = (j('ch3o2h'))
  RCONST(8622) = (j('i_c3h7cho')*2)
  RCONST(8623) = (7.04D-11)
  RCONST(8624) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(8625) = (KAPHO2*0.44)
  RCONST(8626) = (KAPHO2*0.15)
  RCONST(8627) = (KAPHO2*0.41)
  RCONST(8628) = (KAPNO)
  RCONST(8629) = (KFPAN)
  RCONST(8630) = (KRO2NO3*1.74)
  RCONST(8631) = (1.00D-11*0.7*RO2)
  RCONST(8632) = (K16ISOM1)
  RCONST(8633) = (1.00D-11*0.3*RO2)
  RCONST(8634) = (KRO2HO2*0.706)
  RCONST(8635) = (KRO2NO*0.065)
  RCONST(8636) = (KRO2NO*0.935)
  RCONST(8637) = (KRO2NO3)
  RCONST(8638) = (8.80D-13*RO2)
  RCONST(8639) = (K14ISOM1)
  RCONST(8640) = (1.16D-11*0.370)
  RCONST(8641) = (1.16D-11*0.370)
  RCONST(8642) = (1.16D-11*0.150)
  RCONST(8643) = (1.16D-11*0.055)
  RCONST(8644) = (1.16D-11*0.055)
  RCONST(8645) = (KDEC*0.36)
  RCONST(8646) = (KDEC*0.20)
  RCONST(8647) = (KDEC*0.24)
  RCONST(8648) = (KDEC*0.20)
  RCONST(8649) = (KRO2HO2*0.706)
  RCONST(8650) = (KRO2NO*0.145)
  RCONST(8651) = (KRO2NO*0.855)
  RCONST(8652) = (KRO2NO3)
  RCONST(8653) = (2.90D-12*0.1*RO2)
  RCONST(8654) = (2.90D-12*0.8*RO2)
  RCONST(8655) = (2.90D-12*0.1*RO2)
  RCONST(8656) = (KRO2HO2*0.706)
  RCONST(8657) = (KRO2NO*0.064)
  RCONST(8658) = (KRO2NO*0.936)
  RCONST(8659) = (8.80D-13*0.2*RO2)
  RCONST(8660) = (8.80D-13*0.2*RO2)
  RCONST(8661) = (8.80D-13*0.6*RO2)
  RCONST(8662) = (1.50D-11*0.719)
  RCONST(8663) = (1.50D-11*0.281)
  RCONST(8664) = (KRO2HO2*0.706)
  RCONST(8665) = (KRO2NO*0.065)
  RCONST(8666) = (KRO2NO*0.935)
  RCONST(8667) = (KRO2NO3)
  RCONST(8668) = (8.80D-13*RO2)
  RCONST(8669) = (K14ISOM1)
  RCONST(8670) = (5.64D-11)
  RCONST(8671) = (j('ch3o2h'))
  RCONST(8672) = (j('i_c3h7cho'))
  RCONST(8673) = (j('ch3o2h')*2)
  RCONST(8674) = (KDEC)
  RCONST(8675) = (3.77D-11*0.32)
  RCONST(8676) = (3.77D-11*0.68)
  RCONST(8677) = (j('ch3o2h'))
  RCONST(8678) = (j('n_c3h7cho_hco'))
  RCONST(8679) = (j('ch3o2h'))
  RCONST(8680) = (2.40D-17*0.73)
  RCONST(8681) = (2.40D-17*0.27)
  RCONST(8682) = (4.72D-11)
  RCONST(8683) = (j('c5hpald')*2)
  RCONST(8684) = (KDEC)
  RCONST(8685) = (KRO2HO2*0.706)
  RCONST(8686) = (KRO2NO)
  RCONST(8687) = (KRO2NO3)
  RCONST(8688) = (9.20D-14*RO2)
  RCONST(8689) = (5.56D-11)
  RCONST(8690) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(8691) = (KAPHO2*0.44)
  RCONST(8692) = (KAPHO2*0.15)
  RCONST(8693) = (KAPHO2*0.41)
  RCONST(8694) = (KAPNO)
  RCONST(8695) = (KFPAN)
  RCONST(8696) = (KRO2NO3*1.74)
  RCONST(8697) = (K16ISOM1)
  RCONST(8698) = (1.00D-11*0.7*RO2)
  RCONST(8699) = (1.00D-11*0.3*RO2)
  RCONST(8700) = (KRO2HO2*0.706)
  RCONST(8701) = (KRO2NO*0.935)
  RCONST(8702) = (KRO2NO*0.065)
  RCONST(8703) = (KRO2NO3)
  RCONST(8704) = (8.80D-13*RO2)
  RCONST(8705) = (KRO2HO2*0.706)
  RCONST(8706) = (KRO2NO*0.019)
  RCONST(8707) = (KRO2NO*0.981)
  RCONST(8708) = (KRO2NO3)
  RCONST(8709) = (9.20D-14*0.7*RO2)
  RCONST(8710) = (9.20D-14*0.3*RO2)
  RCONST(8711) = (K14ISOM1)
  RCONST(8712) = (KDEC*0.18)
  RCONST(8713) = (KDEC*0.82)
  RCONST(8714) = (KRO2HO2*0.706)
  RCONST(8715) = (KRO2NO*0.072)
  RCONST(8716) = (KRO2NO*0.928)
  RCONST(8717) = (KRO2NO3)
  RCONST(8718) = (8.00D-13*0.8*RO2)
  RCONST(8719) = (8.00D-13*0.2*RO2)
  RCONST(8720) = (KRO2HO2*0.706)
  RCONST(8721) = (KRO2NO)
  RCONST(8722) = (KRO2NO3)
  RCONST(8723) = (9.20D-14*RO2)
  RCONST(8724) = (j('ch3o2h'))
  RCONST(8725) = (1.01D-11*0.65)
  RCONST(8726) = (1.01D-11*0.35)
  RCONST(8727) = (2.00D-12*0.07)
  RCONST(8728) = (2.00D-12*0.39)
  RCONST(8729) = (2.00D-12*0.07)
  RCONST(8730) = (2.00D-12*0.33)
  RCONST(8731) = (2.00D-12*0.14)
  RCONST(8732) = (KDEC)
  RCONST(8733) = (6.68D-12)
  RCONST(8734) = (1.20D-15)
  RCONST(8735) = (1.00D-14)
  RCONST(8736) = (1.00D-15)
  RCONST(8737) = (7.00D-14)
  RCONST(8738) = (6.00D-18*H2O)
  RCONST(8739) = (j('ch3o2h'))
  RCONST(8740) = (3.16D-11)
  RCONST(8741) = (j('ch3coch2ono2')*0.91)
  RCONST(8742) = (2.32D-11)
  RCONST(8743) = (KDEC)
  RCONST(8744) = (3.04D-11)
  RCONST(8745) = (9.11D-11)
  RCONST(8746) = (j('ch3o2h'))
  RCONST(8747) = (8.75D-11)
  RCONST(8748) = (KBPAN)
  RCONST(8749) = (1.14D-12)
  RCONST(8750) = (j('ch3cocho'))
  RCONST(8751) = (KNO3AL*5.5)
  RCONST(8752) = (1.33D-11)
  RCONST(8753) = (KRO2HO2*0.706)
  RCONST(8754) = (KRO2NO*0.140)
  RCONST(8755) = (KRO2NO*0.860)
  RCONST(8756) = (KRO2NO3)
  RCONST(8757) = (2.90D-12*RO2*0.1)
  RCONST(8758) = (2.90D-12*RO2*0.8)
  RCONST(8759) = (2.90D-12*RO2*0.1)
  RCONST(8760) = (K15ISOM1)
  RCONST(8761) = (1.90D-12*EXP(190/TEMP))
  RCONST(8762) = (1.63D-11)
  RCONST(8763) = (j('ch3o2h'))
  RCONST(8764) = (2.26D-13)
  RCONST(8765) = (j('n_c3h7ono2'))
  RCONST(8766) = (KROPRIM*O2)
  RCONST(8767) = (2.00D+14*EXP(-6850/TEMP))
  RCONST(8768) = (4.31D-12)
  RCONST(8769) = (1.80D-13)
  RCONST(8770) = (1.90D-12*EXP(190/TEMP))
  RCONST(8771) = (1.57D-11)
  RCONST(8772) = (j('ch3o2h'))
  RCONST(8773) = (5.72D-13)
  RCONST(8774) = (j('n_c3h7ono2'))
  RCONST(8775) = (KROPRIM*O2)
  RCONST(8776) = (KNO3AL*4.0)
  RCONST(8777) = (2.18D-11)
  RCONST(8778) = (j('n_c3h7cho_hco'))
  RCONST(8779) = (5.34D-12)
  RCONST(8780) = (1.90D-12*EXP(190/TEMP))
  RCONST(8781) = (1.07D-11)
  RCONST(8782) = (j('ch3o2h'))
  RCONST(8783) = (KDEC)
  RCONST(8784) = (KNO3AL*4.0)
  RCONST(8785) = (1.42D-11)
  RCONST(8786) = (j('ch3cocho'))
  RCONST(8787) = (1.48D-12)
  RCONST(8788) = (1.90D-12*EXP(190/TEMP))
  RCONST(8789) = (3.59D-11)
  RCONST(8790) = (j('ch3o2h'))
  RCONST(8791) = (1.00D-14)
  RCONST(8792) = (5.37D-13)
  RCONST(8793) = (j('1_c4h9ono2'))
  RCONST(8794) = (KDEC)
  RCONST(8795) = (9.55D-12)
  RCONST(8796) = (KRO2HO2*0.520*0.6)
  RCONST(8797) = (KRO2HO2*0.520*0.4)
  RCONST(8798) = (KRO2NO*0.047)
  RCONST(8799) = (KRO2NO*0.953)
  RCONST(8800) = (KRO2NO3)
  RCONST(8801) = (8.80D-13*0.6*RO2)
  RCONST(8802) = (8.80D-13*0.2*RO2)
  RCONST(8803) = (8.80D-13*0.2*RO2)
  RCONST(8804) = (7.54D-11)
  RCONST(8805) = (j('ch3o2h'))
  RCONST(8806) = (6.22D-12)
  RCONST(8807) = (j('n_c3h7ono2'))
  RCONST(8808) = (KROPRIM*O2)
  RCONST(8809) = (2.27D-11)
  RCONST(8810) = (2.00D-10)
  RCONST(8811) = (j('ch3o2h'))
  RCONST(8812) = (KDEC)
  RCONST(8813) = (8.78D-12)
  RCONST(8814) = (j('1_c4h9ono2'))
  RCONST(8815) = (5.80D-11)
  RCONST(8816) = (1.59D-10)
  RCONST(8817) = (j('ch3o2h'))
  RCONST(8818) = (KDEC)
  RCONST(8819) = (1.24D-11)
  RCONST(8820) = (j('1_c4h9ono2'))
  RCONST(8821) = (4.85D-11)
  RCONST(8822) = (9.22D-12)
  RCONST(8823) = (1.28D-11)
  RCONST(8824) = (j('ch3o2h'))
  RCONST(8825) = (9.18D-12)
  RCONST(8826) = (KBPAN)
  RCONST(8827) = (1.90D-12*EXP(190/TEMP))
  RCONST(8828) = (2.16D-11)
  RCONST(8829) = (j('ch3o2h')+j('mek'))
  RCONST(8830) = (KDEC)
  RCONST(8831) = (1.57D-11)
  RCONST(8832) = (j('mek'))
  RCONST(8833) = (KNO3AL*4.0)
  RCONST(8834) = (2.56D-11)
  RCONST(8835) = (j('ch3cocho'))
  RCONST(8836) = (j('ch3o2h')+j('biacet'))
  RCONST(8837) = (1.90D-12*EXP(190/TEMP))
  RCONST(8838) = (5.99D-12)
  RCONST(8839) = (KDEC)
  RCONST(8840) = (1.90D-12*EXP(190/TEMP))
  RCONST(8841) = (3.67D-11)
  RCONST(8842) = (j('ch3o2h')+j('mek'))
  RCONST(8843) = (KDEC)
  RCONST(8844) = (3.06D-11)
  RCONST(8845) = (j('mek'))
  RCONST(8846) = (3.02D-11)
  RCONST(8847) = (j('ch3cocho'))
  RCONST(8848) = (2.24D-11)
  RCONST(8849) = (j('ch3o2h')+j('biacet'))
  RCONST(8850) = (KDEC)
  RCONST(8851) = (3.57D-11)
  RCONST(8852) = (j('mek'))
  RCONST(8853) = (j('ch3o2h'))
  RCONST(8854) = (KDEC)
  RCONST(8855) = (1.88D-11)
  RCONST(8856) = (j('mek'))
  RCONST(8857) = (j('biacet'))
  RCONST(8858) = (1.39D-11)
  RCONST(8859) = (j('ch3o2h'))
  RCONST(8860) = (j('mek'))
  RCONST(8861) = (1.90D-12*EXP(190/TEMP))
  RCONST(8862) = (3.26D-11)
  RCONST(8863) = (KDEC)
  RCONST(8864) = (j('mek'))
  RCONST(8865) = (1.72D-11)
  RCONST(8866) = (j('ch3cocho'))
  RCONST(8867) = (2.72D-11)
  RCONST(8868) = (j('mek'))
  RCONST(8869) = (4.00D-12)
  RCONST(8870) = (j('mek'))
  RCONST(8871) = (j('ch3o2h'))
  RCONST(8872) = (7.56D-12)
  RCONST(8873) = (KBPAN)
  RCONST(8874) = (3.96D-12)
  RCONST(8875) = (4.93D-11)
  RCONST(8876) = (j('ch3o2h')+j('mek'))
  RCONST(8877) = (KDEC)
  RCONST(8878) = (1.93D-11)
  RCONST(8879) = (1.90D-12*EXP(190/TEMP))
  RCONST(8880) = (j('mek'))
  RCONST(8881) = (j('mek')+j('ch3o2h'))
  RCONST(8882) = (KDEC)
  RCONST(8883) = (j('mek')*2)
  RCONST(8884) = (j('ch3o2h'))
  RCONST(8885) = (5.42D-11)
  RCONST(8886) = (KDEC)
  RCONST(8887) = (j('mek'))
  RCONST(8888) = (j('biacet'))
  RCONST(8889) = (7.29D-13)
  RCONST(8890) = (j('mek')*2)
  RCONST(8891) = (2.29D-11)
  RCONST(8892) = (j('ch3o2h'))
  RCONST(8893) = (1.97D-11)
  RCONST(8894) = (1.90D-12*EXP(190/TEMP))
  RCONST(8895) = (j('n_c3h7ono2'))
  RCONST(8896) = (8.93D-12)
  RCONST(8897) = (3.05D+11*EXP(-4240/TEMP))
  RCONST(8898) = (KROPRIM*O2)
  RCONST(8899) = (j('ch3o2h')+j('mek'))
  RCONST(8900) = (9.12D-11)
  RCONST(8901) = (j('1_c4h9ono2')+j('mek'))
  RCONST(8902) = (2.04D-12)
  RCONST(8903) = (2.00D+14*EXP(-4714/TEMP))
  RCONST(8904) = (j('mek')*2)
  RCONST(8905) = (6.03D-12)
  RCONST(8906) = (j('mek'))
  RCONST(8907) = (4.22D-11)
  RCONST(8908) = (1.06D-10)
  RCONST(8909) = (j('biacet')+j('ch3o2h'))
  RCONST(8910) = (2.70D+14*EXP(-7398/TEMP))
  RCONST(8911) = (KROSEC*O2)
  RCONST(8912) = (4.67D-11)
  RCONST(8913) = (1.90D-12*EXP(190/TEMP))
  RCONST(8914) = (j('ch3o2h')+j('mek'))
  RCONST(8915) = (KDEC)
  RCONST(8916) = (2.86D-11)
  RCONST(8917) = (j('biacet'))
  RCONST(8918) = (3.38D-11)
  RCONST(8919) = (j('mek'))
  RCONST(8920) = (2.36D-11)
  RCONST(8921) = (j('ch3o2h')+j('biacet'))
  RCONST(8922) = (KDEC)
  RCONST(8923) = (4.05D-11)
  RCONST(8924) = (1.90D-12*EXP(190/TEMP))
  RCONST(8925) = (j('mek'))
  RCONST(8926) = (j('ch3o2h'))
  RCONST(8927) = (KDEC)
  RCONST(8928) = (1.46D-11)
  RCONST(8929) = (j('biacet'))
  RCONST(8930) = (2.34D-11)
  RCONST(8931) = (j('mek'))
  RCONST(8932) = (8.77D-12)
  RCONST(8933) = (j('ch3o2h'))
  RCONST(8934) = (5.18D-12)
  RCONST(8935) = (KBPAN)
  RCONST(8936) = (1.66D-11)
  RCONST(8937) = (j('ch3o2h'))
  RCONST(8938) = (4.97D-12)
  RCONST(8939) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(8940) = (KDEC)
  RCONST(8941) = (j('ch3o2h')+j('mek'))
  RCONST(8942) = (1.90D-12*EXP(190/TEMP))
  RCONST(8943) = (2.21D-11)
  RCONST(8944) = (KDEC)
  RCONST(8945) = (j('mek'))
  RCONST(8946) = (1.60D-11)
  RCONST(8947) = (j('ch3cocho'))
  RCONST(8948) = (1.41D-11)
  RCONST(8949) = (1.41D-12)
  RCONST(8950) = (j('ch3o2h'))
  RCONST(8951) = (4.98D-12)
  RCONST(8952) = (KBPAN)
  RCONST(8953) = (1.38D-12)
  RCONST(8954) = (9.13D-11)
  RCONST(8955) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('mek'))
  RCONST(8956) = (KROPRIM*O2)
  RCONST(8957) = (2*KNO3AL*5.5)
  RCONST(8958) = (9.78D-11)
  RCONST(8959) = (j('n_c3h7cho_hco')*2)
  RCONST(8960) = (j('mek'))
  RCONST(8961) = (8.07D-11)
  RCONST(8962) = (j('mek')+j('n_c3h7cho_hco'))
  RCONST(8963) = (1.90D-12*EXP(190/TEMP))
  RCONST(8964) = (4.63D-10)
  RCONST(8965) = (j('ch3o2h'))
  RCONST(8966) = (KROSEC*O2)
  RCONST(8967) = (2.70D+14*EXP(-7398/TEMP))
  RCONST(8968) = (1.22D-10)
  RCONST(8969) = (j('mek'))
  RCONST(8970) = (1.45D-12)
  RCONST(8971) = (j('mek')*3)
  RCONST(8972) = (KRO2HO2*0.914)
  RCONST(8973) = (KRO2NO*0.050)
  RCONST(8974) = (KRO2NO*0.950)
  RCONST(8975) = (KRO2NO3)
  RCONST(8976) = (6.70D-15*0.7*RO2)
  RCONST(8977) = (6.70D-15*0.3*RO2)
  RCONST(8978) = (5.94D-12)
  RCONST(8979) = (j('ch3o2h'))
  RCONST(8980) = (KDEC)
  RCONST(8981) = (9.73D-12)
  RCONST(8982) = (j('ch3o2h')+j('mek'))
  RCONST(8983) = (3.66D-12)
  RCONST(8984) = (KBPAN)
  RCONST(8985) = (KRO2HO2*0.914)
  RCONST(8986) = (KRO2NO*0.125)
  RCONST(8987) = (KRO2NO*0.875)
  RCONST(8988) = (KRO2NO3)
  RCONST(8989) = (6.70D-15*0.7*RO2)
  RCONST(8990) = (6.70D-15*0.3*RO2)
  RCONST(8991) = (KAPHO2*0.44)
  RCONST(8992) = (KAPHO2*0.15)
  RCONST(8993) = (KAPHO2*0.41)
  RCONST(8994) = (KAPNO)
  RCONST(8995) = (KFPAN)
  RCONST(8996) = (KRO2NO3*1.74)
  RCONST(8997) = (1.00D-11*RO2*0.7)
  RCONST(8998) = (1.00D-11*RO2*0.3)
  RCONST(8999) = (KAPHO2*0.41)
  RCONST(9000) = (KAPHO2*0.44)
  RCONST(9001) = (KAPHO2*0.15)
  RCONST(9002) = (KAPNO)
  RCONST(9003) = (KFPAN)
  RCONST(9004) = (KRO2NO3*1.74)
  RCONST(9005) = (1.00D-11*RO2*0.7)
  RCONST(9006) = (1.00D-11*RO2*0.3)
  RCONST(9007) = (KRO2HO2*0.890)
  RCONST(9008) = (KRO2NO)
  RCONST(9009) = (KRO2NO3)
  RCONST(9010) = (1.30D-12*RO2)
  RCONST(9011) = (KRO2HO2*0.890)
  RCONST(9012) = (KRO2NO)
  RCONST(9013) = (KRO2NO3)
  RCONST(9014) = (6.70D-15*0.7*RO2)
  RCONST(9015) = (6.70D-15*0.3*RO2)
  RCONST(9016) = (KAPHO2*0.56)
  RCONST(9017) = (KAPHO2*0.44)
  RCONST(9018) = (KAPNO)
  RCONST(9019) = (KFPAN)
  RCONST(9020) = (KRO2NO3*1.74)
  RCONST(9021) = (1.00D-11*RO2)
  RCONST(9022) = (KRO2HO2*0.859)
  RCONST(9023) = (KRO2NO)
  RCONST(9024) = (KRO2NO3)
  RCONST(9025) = (6.70D-15*RO2)
  RCONST(9026) = (KRO2HO2*0.820)
  RCONST(9027) = (KRO2NO*0.042)
  RCONST(9028) = (KRO2NO*0.958)
  RCONST(9029) = (KRO2NO3)
  RCONST(9030) = (9.20D-14*RO2*0.7)
  RCONST(9031) = (9.20D-14*RO2*0.3)
  RCONST(9032) = (1.27D-10)
  RCONST(9033) = (j('ch3o2h'))
  RCONST(9034) = (9.60D-11)
  RCONST(9035) = (j('1_c4h9ono2'))
  RCONST(9036) = (KROSEC*O2)
  RCONST(9037) = (1.09D-10)
  RCONST(9038) = (8.85D-12)
  RCONST(9039) = (j('ch3o2h'))
  RCONST(9040) = (4.90D-12)
  RCONST(9041) = (KBPAN)
  RCONST(9042) = (KRO2HO2*0.890)
  RCONST(9043) = (KRO2NO*0.047)
  RCONST(9044) = (KRO2NO*0.953)
  RCONST(9045) = (KRO2NO3)
  RCONST(9046) = (6.70D-15*RO2*0.7)
  RCONST(9047) = (6.70D-15*RO2*0.3)
  RCONST(9048) = (KRO2HO2*0.890)
  RCONST(9049) = (KRO2NO*0.157)
  RCONST(9050) = (KRO2NO*0.843)
  RCONST(9051) = (KRO2NO3)
  RCONST(9052) = (2.50D-13*RO2*0.2)
  RCONST(9053) = (2.50D-13*RO2*0.6)
  RCONST(9054) = (2.50D-13*RO2*0.2)
  RCONST(9055) = (KRO2HO2*0.890)
  RCONST(9056) = (KRO2NO*0.157)
  RCONST(9057) = (KRO2NO*0.843)
  RCONST(9058) = (KRO2NO3)
  RCONST(9059) = (8.80D-13*RO2*0.2)
  RCONST(9060) = (8.80D-13*RO2*0.6)
  RCONST(9061) = (8.80D-13*RO2*0.2)
  RCONST(9062) = (5.99D-12)
  RCONST(9063) = (KRO2HO2*0.890)
  RCONST(9064) = (KRO2NO*0.118)
  RCONST(9065) = (KRO2NO*0.882)
  RCONST(9066) = (KRO2NO3)
  RCONST(9067) = (6.70D-15*RO2*0.7)
  RCONST(9068) = (6.70D-15*RO2*0.3)
  RCONST(9069) = (1.62D-11)
  RCONST(9070) = (j('ch3o2h'))
  RCONST(9071) = (1.84D-12)
  RCONST(9072) = (j('1_c4h9ono2'))
  RCONST(9073) = (KDEC)
  RCONST(9074) = (3.94D-12)
  RCONST(9075) = (6.81D-12)
  RCONST(9076) = (1.46D-11)
  RCONST(9077) = (j('ch3o2h'))
  RCONST(9078) = (5.71D-12)
  RCONST(9079) = (KBPAN)
  RCONST(9080) = (KRO2HO2*0.914)
  RCONST(9081) = (KRO2NO)
  RCONST(9082) = (KRO2NO3)
  RCONST(9083) = (9.20D-14*RO2*0.7)
  RCONST(9084) = (9.20D-14*RO2*0.3)
  RCONST(9085) = (KDEC)
  RCONST(9086) = (KNO3AL*8.5)
  RCONST(9087) = (3.60D-11*0.748)
  RCONST(9088) = (3.60D-11*0.252)
  RCONST(9089) = (j('n_c3h7cho_hco'))
  RCONST(9090) = (KRO2HO2*0.914)
  RCONST(9091) = (KRO2NO*0.059)
  RCONST(9092) = (KRO2NO*0.941)
  RCONST(9093) = (KRO2NO3)
  RCONST(9094) = (9.20D-14*RO2*0.7)
  RCONST(9095) = (9.20D-14*RO2*0.3)
  RCONST(9096) = (KNO3AL*17.0)
  RCONST(9097) = (3.30D-13)
  RCONST(9098) = (1.30D-17*0.330)
  RCONST(9099) = (1.30D-17*0.670)
  RCONST(9100) = (1.06D-10*0.447)
  RCONST(9101) = (1.06D-10*0.553)
  RCONST(9102) = (j('n_c3h7cho_hco')*2)
  RCONST(9103) = (KAPHO2*0.15)
  RCONST(9104) = (KAPHO2*0.41)
  RCONST(9105) = (KAPHO2*0.44)
  RCONST(9106) = (KAPNO)
  RCONST(9107) = (KFPAN)
  RCONST(9108) = (KRO2NO3*1.74)
  RCONST(9109) = (1.00D-11*RO2*0.3)
  RCONST(9110) = (1.00D-11*RO2*0.7)
  RCONST(9111) = (KAPHO2*0.44)
  RCONST(9112) = (KAPHO2*0.15)
  RCONST(9113) = (KAPHO2*0.41)
  RCONST(9114) = (KAPNO)
  RCONST(9115) = (KFPAN)
  RCONST(9116) = (KRO2NO3*1.74)
  RCONST(9117) = (1.00D-11*RO2*0.7)
  RCONST(9118) = (1.00D-11*RO2*0.3)
  RCONST(9119) = (KRO2HO2*0.890)
  RCONST(9120) = (KRO2NO)
  RCONST(9121) = (KRO2NO3)
  RCONST(9122) = (8.80D-13*RO2*0.2)
  RCONST(9123) = (8.80D-13*RO2*0.6)
  RCONST(9124) = (8.80D-13*RO2*0.2)
  RCONST(9125) = (KAPHO2*0.56)
  RCONST(9126) = (KAPHO2*0.44)
  RCONST(9127) = (KAPNO)
  RCONST(9128) = (KFPAN)
  RCONST(9129) = (KRO2NO3*1.74)
  RCONST(9130) = (1.00D-11*RO2)
  RCONST(9131) = (KRO2HO2*0.890)
  RCONST(9132) = (KRO2NO)
  RCONST(9133) = (KRO2NO3)
  RCONST(9134) = (9.20D-14*RO2)
  RCONST(9135) = (KRO2HO2*0.859)
  RCONST(9136) = (KRO2NO)
  RCONST(9137) = (KRO2NO3)
  RCONST(9138) = (2.50D-13*RO2)
  RCONST(9139) = (7.29D-11)
  RCONST(9140) = (j('ch3o2h'))
  RCONST(9141) = (6.93D-11)
  RCONST(9142) = (KBPAN)
  RCONST(9143) = (KRO2HO2*0.914)
  RCONST(9144) = (KRO2NO*0.760)
  RCONST(9145) = (KRO2NO3)
  RCONST(9146) = (9.20D-14*RO2*0.3)
  RCONST(9147) = (9.20D-14*RO2*0.7)
  RCONST(9148) = (KDEC*0.5)
  RCONST(9149) = (KDEC*0.5)
  RCONST(9150) = (KDEC*0.5)
  RCONST(9151) = (KDEC*0.5)
  RCONST(9152) = (KRO2HO2*0.914)
  RCONST(9153) = (KRO2NO*0.240)
  RCONST(9154) = (KRO2NO*0.760)
  RCONST(9155) = (KRO2NO3)
  RCONST(9156) = (9.20D-14*RO2*0.7)
  RCONST(9157) = (9.20D-14*RO2*0.3)
  RCONST(9158) = (KRO2HO2*0.914)
  RCONST(9159) = (KRO2NO*0.240)
  RCONST(9160) = (KRO2NO*0.760)
  RCONST(9161) = (KRO2NO3)
  RCONST(9162) = (8.80D-13*RO2*0.2)
  RCONST(9163) = (8.80D-13*RO2*0.2)
  RCONST(9164) = (8.80D-13*RO2*0.6)
  RCONST(9165) = (7.29D-11)
  RCONST(9166) = (j('ch3o2h'))
  RCONST(9167) = (6.93D-11)
  RCONST(9168) = (KBPAN)
  RCONST(9169) = (4.27D-11)
  RCONST(9170) = (j('ch3o2h'))
  RCONST(9171) = (KDEC)
  RCONST(9172) = (3.93D-11)
  RCONST(9173) = (1.20D-15)
  RCONST(9174) = (1.00D-14)
  RCONST(9175) = (1.00D-15)
  RCONST(9176) = (7.00D-14)
  RCONST(9177) = (1.40D-17*H2O)
  RCONST(9178) = (KRO2HO2*0.968)
  RCONST(9179) = (KRO2NO)
  RCONST(9180) = (KRO2NO3)
  RCONST(9181) = (8.80D-13*RO2*0.2)
  RCONST(9182) = (8.80D-13*RO2*0.6)
  RCONST(9183) = (8.80D-13*RO2*0.2)
  RCONST(9184) = (KAPHO2*0.15)
  RCONST(9185) = (KAPHO2*0.41)
  RCONST(9186) = (KAPHO2*0.44)
  RCONST(9187) = (KAPNO)
  RCONST(9188) = (KFPAN)
  RCONST(9189) = (KRO2NO3*1.74)
  RCONST(9190) = (1.00D-11*RO2*0.3)
  RCONST(9191) = (1.00D-11*RO2*0.7)
  RCONST(9192) = (KRO2HO2*0.975)
  RCONST(9193) = (KRO2NO)
  RCONST(9194) = (KRO2NO3)
  RCONST(9195) = (2.00D-12*RO2*0.2)
  RCONST(9196) = (2.00D-12*RO2*0.6)
  RCONST(9197) = (2.00D-12*RO2*0.2)
  RCONST(9198) = (KRO2HO2*0.968)
  RCONST(9199) = (KRO2NO)
  RCONST(9200) = (KRO2NO3)
  RCONST(9201) = (2.00D-12*RO2*0.2)
  RCONST(9202) = (2.00D-12*RO2*0.6)
  RCONST(9203) = (2.00D-12*RO2*0.2)
  RCONST(9204) = (KRO2HO2*0.975)
  RCONST(9205) = (KRO2NO)
  RCONST(9206) = (KRO2NO3)
  RCONST(9207) = (2.00D-12*RO2*0.2)
  RCONST(9208) = (2.00D-12*RO2*0.6)
  RCONST(9209) = (2.00D-12*RO2*0.2)
  RCONST(9210) = (KRO2HO2*0.959)
  RCONST(9211) = (KRO2NO*0.178)
  RCONST(9212) = (KRO2NO*0.822)
  RCONST(9213) = (KRO2NO3)
  RCONST(9214) = (1.32D-12*RO2*0.2)
  RCONST(9215) = (1.32D-12*RO2*0.6)
  RCONST(9216) = (1.32D-12*RO2*0.2)
  RCONST(9217) = (4.65D-11)
  RCONST(9218) = (j('ch3o2h'))
  RCONST(9219) = (3.01D-11)
  RCONST(9220) = (KDEC)
  RCONST(9221) = (4.31D-11)
  RCONST(9222) = (2.57D-11)
  RCONST(9223) = (j('ch3o2h'))
  RCONST(9224) = (1.58D-11)
  RCONST(9225) = (KDEC)
  RCONST(9226) = (2.21D-11)
  RCONST(9227) = (KRO2HO2*0.968)
  RCONST(9228) = (KRO2NO)
  RCONST(9229) = (KRO2NO3)
  RCONST(9230) = (8.80D-13*RO2*0.2)
  RCONST(9231) = (8.80D-13*RO2*0.6)
  RCONST(9232) = (8.80D-13*RO2*0.2)
  RCONST(9233) = (1.20D-15)
  RCONST(9234) = (1.00D-14)
  RCONST(9235) = (1.00D-15)
  RCONST(9236) = (7.00D-14)
  RCONST(9237) = (1.40D-17*H2O)
  RCONST(9238) = (2.57D-11)
  RCONST(9239) = (j('ch3o2h'))
  RCONST(9240) = (1.58D-11)
  RCONST(9241) = (KDEC)
  RCONST(9242) = (2.21D-11)
  RCONST(9243) = (KAPHO2*0.15)
  RCONST(9244) = (KAPHO2*0.41)
  RCONST(9245) = (KAPHO2*0.44)
  RCONST(9246) = (KAPNO)
  RCONST(9247) = (KFPAN)
  RCONST(9248) = (KRO2NO3*1.74)
  RCONST(9249) = (1.00D-11*RO2*0.3)
  RCONST(9250) = (1.00D-11*RO2*0.7)
  RCONST(9251) = (KAPHO2*0.44)
  RCONST(9252) = (KAPHO2*0.15)
  RCONST(9253) = (KAPHO2*0.41)
  RCONST(9254) = (KAPNO)
  RCONST(9255) = (KFPAN)
  RCONST(9256) = (KRO2NO3*1.74)
  RCONST(9257) = (1.00D-11*RO2*0.7)
  RCONST(9258) = (1.00D-11*RO2*0.3)
  RCONST(9259) = (1.20D-15)
  RCONST(9260) = (1.00D-14)
  RCONST(9261) = (1.00D-15)
  RCONST(9262) = (7.00D-14)
  RCONST(9263) = (1.40D-17*H2O)
  RCONST(9264) = (KRO2HO2*0.968)
  RCONST(9265) = (KRO2NO)
  RCONST(9266) = (KRO2NO3)
  RCONST(9267) = (8.80D-13*RO2*0.2)
  RCONST(9268) = (8.80D-13*RO2*0.6)
  RCONST(9269) = (8.80D-13*RO2*0.2)
  RCONST(9270) = (2.57D-11)
  RCONST(9271) = (j('ch3o2h'))
  RCONST(9272) = (1.58D-11)
  RCONST(9273) = (KDEC)
  RCONST(9274) = (2.21D-11)
  RCONST(9275) = (KRO2HO2*0.959)
  RCONST(9276) = (KRO2NO*0.134)
  RCONST(9277) = (KRO2NO*0.866)
  RCONST(9278) = (KRO2NO3)
  RCONST(9279) = (6.70D-15*RO2*0.7)
  RCONST(9280) = (6.70D-15*RO2*0.3)
  RCONST(9281) = (KRO2HO2*0.959)
  RCONST(9282) = (KRO2NO)
  RCONST(9283) = (KRO2NO3)
  RCONST(9284) = (9.20D-14*RO2*0.7)
  RCONST(9285) = (9.20D-14*RO2*0.3)
  RCONST(9286) = (KNO3AL*8.5)
  RCONST(9287) = (5.65D-11)
  RCONST(9288) = (j('n_c3h7cho_hco')*2)
  RCONST(9289) = (KDEC*0.5)
  RCONST(9290) = (KDEC*0.5)
  RCONST(9291) = (KRO2HO2*0.957)
  RCONST(9292) = (KRO2NO*0.134)
  RCONST(9293) = (KRO2NO*0.866)
  RCONST(9294) = (KRO2NO3)
  RCONST(9295) = (9.20D-14*RO2*0.7)
  RCONST(9296) = (9.20D-14*RO2*0.3)
  RCONST(9297) = (KRO2HO2*0.947)
  RCONST(9298) = (KRO2NO*0.176)
  RCONST(9299) = (KRO2NO*0.824)
  RCONST(9300) = (KRO2NO3)
  RCONST(9301) = (1.32D-12*RO2*0.2)
  RCONST(9302) = (1.32D-12*RO2*0.6)
  RCONST(9303) = (1.32D-12*RO2*0.2)
  RCONST(9304) = (KRO2HO2*0.968)
  RCONST(9305) = (KRO2NO)
  RCONST(9306) = (KRO2NO3)
  RCONST(9307) = (9.20D-14*RO2)
  RCONST(9308) = (KRO2HO2*0.968)
  RCONST(9309) = (KRO2NO*0.054)
  RCONST(9310) = (KRO2NO*0.946)
  RCONST(9311) = (KRO2NO3)
  RCONST(9312) = (6.70D-15*RO2*0.7)
  RCONST(9313) = (6.70D-15*RO2*0.3)
  RCONST(9314) = (KDEC)
  RCONST(9315) = (KRO2HO2*0.968)
  RCONST(9316) = (KRO2NO)
  RCONST(9317) = (KRO2NO3)
  RCONST(9318) = (9.20D-14*RO2*0.3)
  RCONST(9319) = (9.20D-14*RO2*0.7)
  RCONST(9320) = (1.20D-15)
  RCONST(9321) = (1.00D-14)
  RCONST(9322) = (1.00D-15)
  RCONST(9323) = (7.00D-14)
  RCONST(9324) = (8.00D+01)
  RCONST(9325) = (2.00D-16*H2O)
  RCONST(9326) = (1.20D-15)
  RCONST(9327) = (1.00D-14)
  RCONST(9328) = (1.00D-15)
  RCONST(9329) = (7.00D-14)
  RCONST(9330) = (1.20D+02)
  RCONST(9331) = (2.00D-16*H2O)
  RCONST(9332) = (KDEC*0.13)
  RCONST(9333) = (KDEC*0.67)
  RCONST(9334) = (KDEC*0.15)
  RCONST(9335) = (KDEC*0.05)
  RCONST(9336) = (KDEC*0.66)
  RCONST(9337) = (KDEC*0.17)
  RCONST(9338) = (KDEC*0.17)
  RCONST(9339) = (KRO2HO2*0.968)
  RCONST(9340) = (KRO2NO*0.245)
  RCONST(9341) = (KRO2NO*0.755)
  RCONST(9342) = (KRO2NO3)
  RCONST(9343) = (9.20D-14*RO2*0.7)
  RCONST(9344) = (9.20D-14*RO2*0.3)
  RCONST(9345) = (KRO2HO2*0.968)
  RCONST(9346) = (KRO2NO*0.245)
  RCONST(9347) = (KRO2NO*0.755)
  RCONST(9348) = (KRO2NO3)
  RCONST(9349) = (8.80D-13*RO2*0.2)
  RCONST(9350) = (8.80D-13*RO2*0.2)
  RCONST(9351) = (8.80D-13*RO2*0.6)
  RCONST(9352) = (KAPHO2*0.56)
  RCONST(9353) = (KAPHO2*0.44)
  RCONST(9354) = (KAPNO)
  RCONST(9355) = (KFPAN)
  RCONST(9356) = (KRO2NO3*1.74)
  RCONST(9357) = (1.00D-11*RO2)
  RCONST(9358) = (KAPHO2*0.56)
  RCONST(9359) = (KAPHO2*0.44)
  RCONST(9360) = (KAPNO)
  RCONST(9361) = (KFPAN)
  RCONST(9362) = (KRO2NO3*1.74)
  RCONST(9363) = (1.00D-11*RO2)
  RCONST(9364) = (3.50D-11)
  RCONST(9365) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(9366) = (2.79D-11)
  RCONST(9367) = (KBPAN)
  RCONST(9368) = (1.29D-10)
  RCONST(9369) = (1.90D-12*EXP(190/TEMP))
  RCONST(9370) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(9371) = (KROSEC*O2)
  RCONST(9372) = (2.70D+14*EXP(-7398/TEMP))
  RCONST(9373) = (8.03D-11*0.560)
  RCONST(9374) = (8.03D-11*0.440)
  RCONST(9375) = (j('n_c3h7cho_hco'))
  RCONST(9376) = (4.08D-11)
  RCONST(9377) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(9378) = (8.40D+10*EXP(-2567/TEMP))
  RCONST(9379) = (8.80D-11)
  RCONST(9380) = (j('ch3o2h')+j('biacet'))
  RCONST(9381) = (KDEC)
  RCONST(9382) = (KAPHO2*0.44)
  RCONST(9383) = (KAPHO2*0.15)
  RCONST(9384) = (KAPHO2*0.41)
  RCONST(9385) = (KAPNO*4.0)
  RCONST(9386) = (KFPAN)
  RCONST(9387) = (KRO2NO3*1.74)
  RCONST(9388) = (1.00D-11*0.7*RO2)
  RCONST(9389) = (1.00D-11*0.3*RO2)
  RCONST(9390) = (KRO2HO2*0.520)
  RCONST(9391) = (KRO2NO)
  RCONST(9392) = (KRO2NO3)
  RCONST(9393) = (2.00D-12*RO2)
  RCONST(9394) = (3.70D-12)
  RCONST(9395) = (j('ch3coch2ono2')*10)
  RCONST(9396) = (6.78D-12)
  RCONST(9397) = (j('ch3coch2ono2')*10)
  RCONST(9398) = (3.18D-12)
  RCONST(9399) = (KBPAN+j('ch3coch2ono2')*10)
  RCONST(9400) = (2.16D-11)
  RCONST(9401) = (j('i_c3h7cho'))
  RCONST(9402) = (2.47D-11)
  RCONST(9403) = (j('ch3o2h'))
  RCONST(9404) = (j('i_c3h7cho'))
  RCONST(9405) = (2.11D-11)
  RCONST(9406) = (KBPAN+j('i_c3h7cho'))
  RCONST(9407) = (j('n_c3h7cho_hco'))
  RCONST(9408) = (KNO3AL*5.5)
  RCONST(9409) = (2.63D-11)
  RCONST(9410) = (KAPHO2*0.15)
  RCONST(9411) = (KAPHO2*0.41)
  RCONST(9412) = (KAPHO2*0.44)
  RCONST(9413) = (KAPNO)
  RCONST(9414) = (KFPAN)
  RCONST(9415) = (KRO2NO3*1.74)
  RCONST(9416) = (1.00D-11*0.3*RO2)
  RCONST(9417) = (1.00D-11*0.7*RO2)
  RCONST(9418) = (j('i_c3h7cho'))
  RCONST(9419) = (KNO3AL*8.5)
  RCONST(9420) = (3.09D-11)
  RCONST(9421) = (KAPHO2*0.56)
  RCONST(9422) = (KAPHO2*0.44)
  RCONST(9423) = (KAPNO)
  RCONST(9424) = (KFPAN)
  RCONST(9425) = (KRO2NO3*1.74)
  RCONST(9426) = (1.00D-11*RO2)
  RCONST(9427) = (KRO2HO2*0.770)
  RCONST(9428) = (KRO2NO*0.039)
  RCONST(9429) = (KRO2NO*0.961)
  RCONST(9430) = (KRO2NO3)
  RCONST(9431) = (8.40D-13*0.6*RO2)
  RCONST(9432) = (8.40D-13*0.2*RO2)
  RCONST(9433) = (8.40D-13*0.2*RO2)
  RCONST(9434) = (j('n_c3h7cho_hco'))
  RCONST(9435) = (KNO3AL*5.5)
  RCONST(9436) = (2.75D-11)
  RCONST(9437) = (KAPHO2*0.15)
  RCONST(9438) = (KAPHO2*0.41)
  RCONST(9439) = (KAPHO2*0.44)
  RCONST(9440) = (KAPNO)
  RCONST(9441) = (KFPAN)
  RCONST(9442) = (KRO2NO3*1.74)
  RCONST(9443) = (1.00D-11*0.3*RO2)
  RCONST(9444) = (1.00D-11*0.7*RO2)
  RCONST(9445) = (KRO2HO2*0.770)
  RCONST(9446) = (KRO2NO*0.029)
  RCONST(9447) = (KRO2NO*0.971)
  RCONST(9448) = (KRO2NO3)
  RCONST(9449) = (9.20D-14*0.7*RO2)
  RCONST(9450) = (9.20D-14*0.3*RO2)
  RCONST(9451) = (j('i_c3h7cho'))
  RCONST(9452) = (KNO3AL*8.5)
  RCONST(9453) = (2.98D-11*0.215)
  RCONST(9454) = (2.98D-11*0.785)
  RCONST(9455) = (KRO2HO2*0.706)
  RCONST(9456) = (KRO2NO*0.129)
  RCONST(9457) = (KRO2NO*0.971)
  RCONST(9458) = (KRO2NO3)
  RCONST(9459) = (2.50D-13*0.2*RO2)
  RCONST(9460) = (2.50D-13*0.6*RO2)
  RCONST(9461) = (2.50D-13*0.2*RO2)
  RCONST(9462) = (KAPHO2*0.15)
  RCONST(9463) = (KAPHO2*0.41)
  RCONST(9464) = (KAPHO2*0.44)
  RCONST(9465) = (KAPNO)
  RCONST(9466) = (KFPAN)
  RCONST(9467) = (KRO2NO3*1.74)
  RCONST(9468) = (1.00D-11*0.3*RO2)
  RCONST(9469) = (1.00D-11*0.7*RO2)
  RCONST(9470) = (KRO2HO2*0.770)
  RCONST(9471) = (KRO2NO)
  RCONST(9472) = (KRO2NO3)
  RCONST(9473) = (8.40D-13*0.2*RO2)
  RCONST(9474) = (8.40D-13*0.6*RO2)
  RCONST(9475) = (8.40D-13*0.2*RO2)
  RCONST(9476) = (KAPHO2*0.56)
  RCONST(9477) = (KAPHO2*0.44)
  RCONST(9478) = (KAPNO)
  RCONST(9479) = (KFPAN)
  RCONST(9480) = (KRO2NO3*1.74)
  RCONST(9481) = (1.00D-11*RO2)
  RCONST(9482) = (KAPHO2*0.15)
  RCONST(9483) = (KAPHO2*0.41)
  RCONST(9484) = (KAPHO2*0.44)
  RCONST(9485) = (KAPNO)
  RCONST(9486) = (KFPAN)
  RCONST(9487) = (KRO2NO3*1.74)
  RCONST(9488) = (1.00D-11*0.3*RO2)
  RCONST(9489) = (1.00D-11*0.7*RO2)
  RCONST(9490) = (KRO2HO2*0.770)
  RCONST(9491) = (KRO2NO*0.098)
  RCONST(9492) = (KRO2NO*0.902)
  RCONST(9493) = (KRO2NO3)
  RCONST(9494) = (8.40D-13*0.2*RO2)
  RCONST(9495) = (8.40D-13*0.6*RO2)
  RCONST(9496) = (8.40D-13*0.2*RO2)
  RCONST(9497) = (KRO2HO2*0.770)
  RCONST(9498) = (KRO2NO*0.098)
  RCONST(9499) = (KRO2NO*0.902)
  RCONST(9500) = (KRO2NO3)
  RCONST(9501) = (8.80D-13*0.6*RO2)
  RCONST(9502) = (8.80D-13*0.2*RO2)
  RCONST(9503) = (8.80D-13*0.2*RO2)
  RCONST(9504) = (j('n_c3h7cho_hco'))
  RCONST(9505) = (KNO3AL*8.5)
  RCONST(9506) = (2.98D-11)
  RCONST(9507) = (KAPHO2*0.15)
  RCONST(9508) = (KAPHO2*0.41)
  RCONST(9509) = (KAPHO2*0.44)
  RCONST(9510) = (KAPNO)
  RCONST(9511) = (KFPAN)
  RCONST(9512) = (KRO2NO3*1.74)
  RCONST(9513) = (1.00D-11*0.3*RO2)
  RCONST(9514) = (1.00D-11*0.7*RO2)
  RCONST(9515) = (KRO2HO2*0.770)
  RCONST(9516) = (KRO2NO*0.029)
  RCONST(9517) = (KRO2NO*0.971)
  RCONST(9518) = (KRO2NO3)
  RCONST(9519) = (9.20D-14*0.7*RO2)
  RCONST(9520) = (9.20D-14*0.3*RO2)
  RCONST(9521) = (KRO2HO2*0.770)
  RCONST(9522) = (KRO2NO)
  RCONST(9523) = (KRO2NO3)
  RCONST(9524) = (2.00D-12*0.6*RO2)
  RCONST(9525) = (2.00D-12*0.2*RO2)
  RCONST(9526) = (2.00D-12*0.2*RO2)
  RCONST(9527) = (KRO2HO2*0.770)
  RCONST(9528) = (KRO2NO)
  RCONST(9529) = (KRO2NO3)
  RCONST(9530) = (9.20D-14*0.7*RO2)
  RCONST(9531) = (9.20D-14*0.3*RO2)
  RCONST(9532) = (KAPHO2*0.15)
  RCONST(9533) = (KAPHO2*0.41)
  RCONST(9534) = (KAPHO2*0.44)
  RCONST(9535) = (KAPNO)
  RCONST(9536) = (KFPAN)
  RCONST(9537) = (KRO2NO3*1.74)
  RCONST(9538) = (1.00D-11*0.3*RO2)
  RCONST(9539) = (1.00D-11*0.7*RO2)
  RCONST(9540) = (KRO2HO2*0.706)
  RCONST(9541) = (KRO2NO*0.052)
  RCONST(9542) = (KRO2NO*0.948)
  RCONST(9543) = (KRO2NO3)
  RCONST(9544) = (1.30D-12*0.6*RO2)
  RCONST(9545) = (1.30D-12*0.2*RO2)
  RCONST(9546) = (1.30D-12*0.2*RO2)
  RCONST(9547) = (KAPHO2*0.15)
  RCONST(9548) = (KAPHO2*0.41)
  RCONST(9549) = (KAPHO2*0.44)
  RCONST(9550) = (KAPNO)
  RCONST(9551) = (KFPAN)
  RCONST(9552) = (KRO2NO3*1.74)
  RCONST(9553) = (1.00D-11*0.3*RO2)
  RCONST(9554) = (1.00D-11*0.7*RO2)
  RCONST(9555) = (KAPHO2*0.15)
  RCONST(9556) = (KAPHO2*0.41)
  RCONST(9557) = (KAPHO2*0.44)
  RCONST(9558) = (KAPNO)
  RCONST(9559) = (KFPAN)
  RCONST(9560) = (KRO2NO3*1.74)
  RCONST(9561) = (1.00D-11*0.3*RO2)
  RCONST(9562) = (1.00D-11*0.7*RO2)
  RCONST(9563) = (j('mek'))
  RCONST(9564) = (1.52D-11*0.349)
  RCONST(9565) = (1.52D-11*0.651)
  RCONST(9566) = (j('mek'))
  RCONST(9567) = (j('mek'))
  RCONST(9568) = (6.60D-12*0.500)
  RCONST(9569) = (6.60D-12*0.500)
  RCONST(9570) = (KRO2HO2*0.820)
  RCONST(9571) = (KRO2NO)
  RCONST(9572) = (KRO2NO3)
  RCONST(9573) = (8.80D-13*RO2)
  RCONST(9574) = (KRO2HO2*0.820)
  RCONST(9575) = (KRO2NO)
  RCONST(9576) = (KRO2NO3)
  RCONST(9577) = (2.00D-12*RO2)
  RCONST(9578) = (KRO2HO2*0.820)
  RCONST(9579) = (KRO2NO*0.139)
  RCONST(9580) = (KRO2NO*0.861)
  RCONST(9581) = (KRO2NO3)
  RCONST(9582) = (8.80D-13*0.2*RO2)
  RCONST(9583) = (8.80D-13*0.6*RO2)
  RCONST(9584) = (8.80D-13*0.2*RO2)
  RCONST(9585) = (KRO2HO2*0.820)
  RCONST(9586) = (KRO2NO)
  RCONST(9587) = (KRO2NO3)
  RCONST(9588) = (8.80D-13*0.2*RO2)
  RCONST(9589) = (8.80D-13*0.6*RO2)
  RCONST(9590) = (8.80D-13*0.2*RO2)
  RCONST(9591) = (j('mek'))
  RCONST(9592) = (1.91D-11*0.534)
  RCONST(9593) = (1.91D-11*0.466)
  RCONST(9594) = (j('mek'))
  RCONST(9595) = (j('mek'))
  RCONST(9596) = (9.14D-12*0.675)
  RCONST(9597) = (9.14D-12*0.325)
  RCONST(9598) = (KRO2HO2*0.820)
  RCONST(9599) = (KRO2NO)
  RCONST(9600) = (KRO2NO3)
  RCONST(9601) = (2.00D-12*RO2)
  RCONST(9602) = (KRO2HO2*0.706)
  RCONST(9603) = (KRO2NO*0.052)
  RCONST(9604) = (KRO2NO*0.948)
  RCONST(9605) = (KRO2NO3)
  RCONST(9606) = (1.30D-12*0.2*RO2)
  RCONST(9607) = (1.30D-12*0.2*RO2)
  RCONST(9608) = (1.30D-12*0.6*RO2)
  RCONST(9609) = (KAPHO2*0.15)
  RCONST(9610) = (KAPHO2*0.41)
  RCONST(9611) = (KAPHO2*0.44)
  RCONST(9612) = (KAPNO)
  RCONST(9613) = (KFPAN)
  RCONST(9614) = (KRO2NO3*1.74)
  RCONST(9615) = (1.00D-11*0.3*RO2)
  RCONST(9616) = (1.00D-11*0.7*RO2)
  RCONST(9617) = (KRO2HO2*0.859)
  RCONST(9618) = (KRO2NO*0.173)
  RCONST(9619) = (KRO2NO*0.827)
  RCONST(9620) = (KRO2NO3)
  RCONST(9621) = (8.80D-13*0.6*RO2)
  RCONST(9622) = (8.80D-13*0.2*RO2)
  RCONST(9623) = (8.80D-13*0.2*RO2)
  RCONST(9624) = (j('mek')*2)
  RCONST(9625) = (7.93D-12)
  RCONST(9626) = (KRO2HO2*0.859)
  RCONST(9627) = (KRO2NO)
  RCONST(9628) = (KRO2NO3)
  RCONST(9629) = (8.80D-13*RO2)
  RCONST(9630) = (KRO2HO2*0.890)
  RCONST(9631) = (KRO2NO*0.197)
  RCONST(9632) = (KRO2NO*0.803)
  RCONST(9633) = (KRO2NO3)
  RCONST(9634) = (8.80D-13*0.2*RO2)
  RCONST(9635) = (8.80D-13*0.6*RO2)
  RCONST(9636) = (8.80D-13*0.2*RO2)
  RCONST(9637) = (j('mek')*2)
  RCONST(9638) = (1.14D-11)
  RCONST(9639) = (KRO2HO2*0.890)
  RCONST(9640) = (KRO2NO)
  RCONST(9641) = (KRO2NO3)
  RCONST(9642) = (8.80D-13*RO2)
  RCONST(9643) = (KRO2HO2*0.820)
  RCONST(9644) = (KRO2NO)
  RCONST(9645) = (KRO2NO3)
  RCONST(9646) = (2.00D-12*RO2)
  RCONST(9647) = (KRO2HO2*0.914)
  RCONST(9648) = (KRO2NO*0.208)
  RCONST(9649) = (KRO2NO*0.792)
  RCONST(9650) = (KRO2NO3)
  RCONST(9651) = (8.80D-13*0.2*RO2)
  RCONST(9652) = (8.80D-13*0.6*RO2)
  RCONST(9653) = (8.80D-13*0.2*RO2)
  RCONST(9654) = (j('mek')*2)
  RCONST(9655) = (1.28D-11)
  RCONST(9656) = (KRO2HO2*0.914)
  RCONST(9657) = (KRO2NO)
  RCONST(9658) = (KRO2NO3)
  RCONST(9659) = (8.80D-13*RO2)
  RCONST(9660) = (KRO2HO2*0.859)
  RCONST(9661) = (KRO2NO)
  RCONST(9662) = (KRO2NO3)
  RCONST(9663) = (2.00D-12*RO2)
  RCONST(9664) = (KRO2HO2*0.932)
  RCONST(9665) = (KRO2NO*0.215)
  RCONST(9666) = (KRO2NO*0.785)
  RCONST(9667) = (KRO2NO3)
  RCONST(9668) = (8.80D-13*0.2*RO2)
  RCONST(9669) = (8.80D-13*0.6*RO2)
  RCONST(9670) = (8.80D-13*0.2*RO2)
  RCONST(9671) = (j('mek')*2)
  RCONST(9672) = (1.42D-11)
  RCONST(9673) = (KRO2HO2*0.932)
  RCONST(9674) = (KRO2NO)
  RCONST(9675) = (KRO2NO3)
  RCONST(9676) = (8.80D-13*RO2)
  RCONST(9677) = (KRO2HO2*0.890)
  RCONST(9678) = (KRO2NO)
  RCONST(9679) = (KRO2NO3)
  RCONST(9680) = (2.00D-12*RO2)
  RCONST(9681) = (KRO2HO2*0.947)
  RCONST(9682) = (KRO2NO*0.220)
  RCONST(9683) = (KRO2NO*0.780)
  RCONST(9684) = (KRO2NO3)
  RCONST(9685) = (8.80D-13*0.2*RO2)
  RCONST(9686) = (8.80D-13*0.6*RO2)
  RCONST(9687) = (8.80D-13*0.2*RO2)
  RCONST(9688) = (j('mek')*2)
  RCONST(9689) = (1.56D-11)
  RCONST(9690) = (KRO2HO2*0.947)
  RCONST(9691) = (KRO2NO)
  RCONST(9692) = (KRO2NO3)
  RCONST(9693) = (8.80D-13*RO2)
  RCONST(9694) = (KRO2HO2*0.770)
  RCONST(9695) = (KRO2NO*0.078)
  RCONST(9696) = (KRO2NO*0.922)
  RCONST(9697) = (KRO2NO3)
  RCONST(9698) = (2.50D-13*RO2*0.2)
  RCONST(9699) = (2.50D-13*RO2*0.6)
  RCONST(9700) = (2.50D-13*RO2*0.2)
  RCONST(9701) = (KDEC)
  RCONST(9702) = (KDEC)
  RCONST(9703) = (KRO2HO2*0.520)
  RCONST(9704) = (KRO2NO)
  RCONST(9705) = (KRO2NO3)
  RCONST(9706) = (2.00D-12*RO2)
  RCONST(9707) = (2.48D-13)
  RCONST(9708) = (j('ch3coch2ono2')*1.6)
  RCONST(9709) = (1.51D-11)
  RCONST(9710) = (j('ch3coch2ono2')*10)
  RCONST(9711) = (4.74D-11)
  RCONST(9712) = (j('ch3cocho'))
  RCONST(9713) = (j('mek'))
  RCONST(9714) = (j('ch3cocho'))
  RCONST(9715) = (1.44D-11)
  RCONST(9716) = (6.18D-12)
  RCONST(9717) = (j('ch3o2h'))
  RCONST(9718) = (KDEC*0.5)
  RCONST(9719) = (KDEC*0.5)
  RCONST(9720) = (1.20D-15)
  RCONST(9721) = (1.00D-14)
  RCONST(9722) = (1.00D-15)
  RCONST(9723) = (7.00D-14)
  RCONST(9724) = (6.00D-18*H2O)
  RCONST(9725) = (1.00D-17*H2O)
  RCONST(9726) = (3.68D-11)
  RCONST(9727) = (j('ch3o2h'))
  RCONST(9728) = (KDEC)
  RCONST(9729) = (1.78D-11)
  RCONST(9730) = (2.78D-11)
  RCONST(9731) = (1.4D-12)
  RCONST(9732) = (2.45D-11)
  RCONST(9733) = (j('ch3cocho')*2)
  RCONST(9734) = (2.25D-15)
  RCONST(9735) = (3.00D-14)
  RCONST(9736) = (KRO2HO2*0.770)
  RCONST(9737) = (KRO2NO)
  RCONST(9738) = (KRO2NO3)
  RCONST(9739) = (2.50D-13*RO2)
  RCONST(9740) = (KRO2HO2*0.770)
  RCONST(9741) = (KRO2NO)
  RCONST(9742) = (KRO2NO3)
  RCONST(9743) = (8.00D-13*RO2)
  RCONST(9744) = (KRO2HO2*0.770)
  RCONST(9745) = (KRO2NO)
  RCONST(9746) = (KRO2NO3)
  RCONST(9747) = (8.00D-13*RO2)
  RCONST(9748) = (1.90D-12*EXP(190/TEMP))
  RCONST(9749) = (j('ch3o2h'))
  RCONST(9750) = (KRO2HO2*0.770)
  RCONST(9751) = (KRO2NO)
  RCONST(9752) = (KRO2NO3)
  RCONST(9753) = (8.80D-13*RO2)
  RCONST(9754) = (KRO2HO2*0.770)
  RCONST(9755) = (KRO2NO)
  RCONST(9756) = (KRO2NO3)
  RCONST(9757) = (8.80D-13*RO2*0.2)
  RCONST(9758) = (8.80D-13*RO2*0.6)
  RCONST(9759) = (8.80D-13*RO2*0.2)
  RCONST(9760) = (KRO2HO2*0.820)
  RCONST(9761) = (KRO2NO)
  RCONST(9762) = (KRO2NO3)
  RCONST(9763) = (8.80D-13*RO2)
  RCONST(9764) = (KRO2HO2*0.820)
  RCONST(9765) = (KRO2NO)
  RCONST(9766) = (KRO2NO3)
  RCONST(9767) = (8.80D-13*RO2*0.2)
  RCONST(9768) = (8.80D-13*RO2*0.6)
  RCONST(9769) = (8.80D-13*RO2*0.2)
  RCONST(9770) = (7.83D-15)
  RCONST(9771) = (5.10D-14)
  RCONST(9772) = (KRO2HO2*0.820)
  RCONST(9773) = (KRO2NO)
  RCONST(9774) = (KRO2NO3)
  RCONST(9775) = (2.50D-13*RO2)
  RCONST(9776) = (KRO2HO2*0.820)
  RCONST(9777) = (KRO2NO)
  RCONST(9778) = (KRO2NO3)
  RCONST(9779) = (8.00D-13*RO2)
  RCONST(9780) = (KRO2HO2*0.820)
  RCONST(9781) = (KRO2NO)
  RCONST(9782) = (KRO2NO3)
  RCONST(9783) = (8.00D-13*RO2)
  RCONST(9784) = (2.05D-10)
  RCONST(9785) = (j('ch3o2h'))
  RCONST(9786) = (KDEC*0.35)
  RCONST(9787) = (KDEC*0.65)
  RCONST(9788) = (4.73D-11)
  RCONST(9789) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(9790) = (j('ch3o2h'))
  RCONST(9791) = (4.37D-11)
  RCONST(9792) = (KBPAN)
  RCONST(9793) = (KDEC)
  RCONST(9794) = (5.70D-11)
  RCONST(9795) = (j('i_c3h7cho')*2)
  RCONST(9796) = (1.21D-10)
  RCONST(9797) = (1.90D-12*EXP(190/TEMP))
  RCONST(9798) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('mek'))
  RCONST(9799) = (KDEC)
  RCONST(9800) = (7.48D-11)
  RCONST(9801) = (j('n_c3h7cho_hco')+j('biacet'))
  RCONST(9802) = (6.26D-11)
  RCONST(9803) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(9804) = (4.44D-12)
  RCONST(9805) = (j('ch3o2h'))
  RCONST(9806) = (KDEC)
  RCONST(9807) = (KRO2HO2*0.625)
  RCONST(9808) = (KRO2NO)
  RCONST(9809) = (KRO2NO3)
  RCONST(9810) = (2.00D-12*RO2)
  RCONST(9811) = (1.20D-15)
  RCONST(9812) = (1.00D-14)
  RCONST(9813) = (1.00D-15)
  RCONST(9814) = (7.00D-14)
  RCONST(9815) = (6.00D-18*H2O)
  RCONST(9816) = (1.00D-17*H2O)
  RCONST(9817) = (2.53D-11)
  RCONST(9818) = (j('ch3o2h'))
  RCONST(9819) = (KDEC)
  RCONST(9820) = (2.19D-11)
  RCONST(9821) = (5.44D-11)
  RCONST(9822) = (j('mvk_mcm_ch2ch'))
  RCONST(9823) = (j('ch3o2h'))
  RCONST(9824) = (KDEC*0.35)
  RCONST(9825) = (KDEC*0.65)
  RCONST(9826) = (5.08D-11)
  RCONST(9827) = (KBPAN)
  RCONST(9828) = (1.20D-15)
  RCONST(9829) = (1.00D-14)
  RCONST(9830) = (1.00D-15)
  RCONST(9831) = (7.00D-14)
  RCONST(9832) = (6.00D-18*H2O)
  RCONST(9833) = (3.12D-11)
  RCONST(9834) = (j('mek')+j('i_c3h7cho'))
  RCONST(9835) = (j('ch3o2h'))
  RCONST(9836) = (KDEC)
  RCONST(9837) = (2.77D-11)
  RCONST(9838) = (j('mek')+j('i_c3h7cho'))
  RCONST(9839) = (4.95D-12)
  RCONST(9840) = (j('ch3o2h'))
  RCONST(9841) = (KDEC)
  RCONST(9842) = (4.42D-11)
  RCONST(9843) = (1.90D-12*EXP(190/TEMP))
  RCONST(9844) = (j('ch3o2h'))
  RCONST(9845) = (KDEC)
  RCONST(9846) = (4.65D-13)
  RCONST(9847) = (j('mek'))
  RCONST(9848) = (1.91D-11)
  RCONST(9849) = (7.12D-12)
  RCONST(9850) = (j('ch3o2h'))
  RCONST(9851) = (KDEC)
  RCONST(9852) = (3.76D-12)
  RCONST(9853) = (7.83D-15)
  RCONST(9854) = (5.10D-14)
  RCONST(9855) = (KRO2HO2*0.859)
  RCONST(9856) = (KRO2NO)
  RCONST(9857) = (KRO2NO3)
  RCONST(9858) = (2.50D-13*RO2)
  RCONST(9859) = (KRO2HO2*0.859)
  RCONST(9860) = (KRO2NO)
  RCONST(9861) = (KRO2NO3)
  RCONST(9862) = (8.80D-13*RO2)
  RCONST(9863) = (KRO2HO2*0.859)
  RCONST(9864) = (KRO2NO)
  RCONST(9865) = (KRO2NO3)
  RCONST(9866) = (8.80D-13*RO2*0.2)
  RCONST(9867) = (8.80D-13*RO2*0.6)
  RCONST(9868) = (8.80D-13*RO2*0.2)
  RCONST(9869) = (KRO2HO2*0.859)
  RCONST(9870) = (KRO2NO)
  RCONST(9871) = (KRO2NO3)
  RCONST(9872) = (8.00D-13*RO2)
  RCONST(9873) = (KRO2HO2*0.859)
  RCONST(9874) = (KRO2NO)
  RCONST(9875) = (KRO2NO3)
  RCONST(9876) = (8.00D-13*RO2)
  RCONST(9877) = (2.05D-10)
  RCONST(9878) = (j('ch3o2h'))
  RCONST(9879) = (4.46D-11)
  RCONST(9880) = (j('i_c3h7cho'))
  RCONST(9881) = (j('ch3o2h')+j('mek'))
  RCONST(9882) = (KDEC)
  RCONST(9883) = (4.13D-11)
  RCONST(9884) = (j('mek')+j('i_c3h7cho'))
  RCONST(9885) = (5.80D-12)
  RCONST(9886) = (j('ch3o2h'))
  RCONST(9887) = (KDEC)
  RCONST(9888) = (6.01D-11)
  RCONST(9889) = (1.90D-12*EXP(190/TEMP))
  RCONST(9890) = (j('ch3o2h'))
  RCONST(9891) = (KDEC)
  RCONST(9892) = (1.09D-13)
  RCONST(9893) = (j('mek'))
  RCONST(9894) = (2.54D-11)
  RCONST(9895) = (3.09D-11)
  RCONST(9896) = (j('ch3o2h'))
  RCONST(9897) = (KDEC)
  RCONST(9898) = (2.74D-11)
  RCONST(9899) = (5.16D-12)
  RCONST(9900) = (j('ch3o2h'))
  RCONST(9901) = (KDEC)
  RCONST(9902) = (2.00D-11)
  RCONST(9903) = (j('mek'))
  RCONST(9904) = (j('ch3o2h'))
  RCONST(9905) = (KDEC)
  RCONST(9906) = (2.78D-11)
  RCONST(9907) = (j('ch3o2h'))
  RCONST(9908) = (KDEC)
  RCONST(9909) = (2.44D-11)
  RCONST(9910) = (1.50D-12)
  RCONST(9911) = (7.83D-15)
  RCONST(9912) = (5.10D-14)
  RCONST(9913) = (KRO2HO2*0.859)
  RCONST(9914) = (KRO2NO)
  RCONST(9915) = (KRO2NO3)
  RCONST(9916) = (2.50D-13*RO2)
  RCONST(9917) = (KRO2HO2*0.859)
  RCONST(9918) = (KRO2NO)
  RCONST(9919) = (KRO2NO3)
  RCONST(9920) = (9.20D-14*RO2)
  RCONST(9921) = (KRO2HO2*0.859)
  RCONST(9922) = (KRO2NO)
  RCONST(9923) = (KRO2NO3)
  RCONST(9924) = (9.20D-14*RO2*0.7)
  RCONST(9925) = (9.20D-14*RO2*0.3)
  RCONST(9926) = (KRO2HO2*0.859)
  RCONST(9927) = (KRO2NO)
  RCONST(9928) = (KRO2NO3)
  RCONST(9929) = (8.00D-13*RO2)
  RCONST(9930) = (KRO2HO2*0.859)
  RCONST(9931) = (KRO2NO)
  RCONST(9932) = (KRO2NO3)
  RCONST(9933) = (8.00D-13*RO2)
  RCONST(9934) = (2.05D-10)
  RCONST(9935) = (j('ch3o2h'))
  RCONST(9936) = (3.6D-12)
  RCONST(9937) = (9.75D-11)
  RCONST(9938) = (1.90D-12*EXP(190/TEMP))
  RCONST(9939) = (j('mek')*2)
  RCONST(9940) = (j('ch3o2h'))
  RCONST(9941) = (KDEC*0.7)
  RCONST(9942) = (KDEC*0.3)
  RCONST(9943) = (4.00D-11)
  RCONST(9944) = (j('mek')*2)
  RCONST(9945) = (9.04D-12)
  RCONST(9946) = (j('mek'))
  RCONST(9947) = (j('biacet'))
  RCONST(9948) = (7.83D-15)
  RCONST(9949) = (5.10D-14)
  RCONST(9950) = (KRO2HO2*0.859)
  RCONST(9951) = (KRO2NO)
  RCONST(9952) = (KRO2NO3)
  RCONST(9953) = (2.50D-13*RO2)
  RCONST(9954) = (KRO2HO2*0.859)
  RCONST(9955) = (KRO2NO)
  RCONST(9956) = (KRO2NO3)
  RCONST(9957) = (9.20D-14*RO2)
  RCONST(9958) = (KRO2HO2*0.859)
  RCONST(9959) = (KRO2NO)
  RCONST(9960) = (KRO2NO3)
  RCONST(9961) = (9.20D-14*RO2*0.70)
  RCONST(9962) = (9.20D-14*RO2*0.30)
  RCONST(9963) = (KRO2HO2*0.859)
  RCONST(9964) = (KRO2NO)
  RCONST(9965) = (KRO2NO3)
  RCONST(9966) = (8.00D-13*RO2)
  RCONST(9967) = (KRO2HO2*0.859)
  RCONST(9968) = (KRO2NO)
  RCONST(9969) = (KRO2NO3)
  RCONST(9970) = (8.00D-13*RO2)
  RCONST(9971) = (2.05D-10)
  RCONST(9972) = (j('ch3o2h'))
  RCONST(9973) = (7.83D-15)
  RCONST(9974) = (5.10D-14)
  RCONST(9975) = (KRO2HO2*0.859)
  RCONST(9976) = (KRO2NO)
  RCONST(9977) = (KRO2NO3)
  RCONST(9978) = (2.50D-13*RO2)
  RCONST(9979) = (KRO2HO2*0.859)
  RCONST(9980) = (KRO2NO)
  RCONST(9981) = (KRO2NO3)
  RCONST(9982) = (8.80D-13*RO2)
  RCONST(9983) = (KRO2HO2*0.859)
  RCONST(9984) = (KRO2NO)
  RCONST(9985) = (KRO2NO3)
  RCONST(9986) = (8.80D-13*RO2*0.20)
  RCONST(9987) = (8.80D-13*RO2*0.60)
  RCONST(9988) = (8.80D-13*RO2*0.20)
  RCONST(9989) = (KRO2HO2*0.859)
  RCONST(9990) = (KRO2NO)
  RCONST(9991) = (KRO2NO3)
  RCONST(9992) = (8.00D-13*RO2)
  RCONST(9993) = (KRO2HO2*0.859)
  RCONST(9994) = (KRO2NO)
  RCONST(9995) = (KRO2NO3)
  RCONST(9996) = (8.00D-13*RO2)
  RCONST(9997) = (2.05D-10)
  RCONST(9998) = (j('ch3o2h'))
  RCONST(9999) = (1.16D-10)
  RCONST(10000) = (j('mek'))
  RCONST(10001) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(10002) = (KDEC)
  RCONST(10003) = (7.71D-11)
  RCONST(10004) = (j('biacet'))
  RCONST(10005) = (6.21D-11)
  RCONST(10006) = (j('mek'))
  RCONST(10007) = (j('n_c3h7cho_hco'))
  RCONST(10008) = (8.18D-11)
  RCONST(10009) = (j('ch3o2h'))
  RCONST(10010) = (KDEC*0.5)
  RCONST(10011) = (KDEC*0.5)
  RCONST(10012) = (1.90D-12*EXP(190/TEMP))
  RCONST(10013) = (3.95D-11)
  RCONST(10014) = (j('ch3o2h'))
  RCONST(10015) = (4.23D-11)
  RCONST(10016) = (j('ch3o2h'))
  RCONST(10017) = (KDEC)
  RCONST(10018) = (3.24D-11)
  RCONST(10019) = (3.33D-11)
  RCONST(10020) = (KAPHO2*0.56)
  RCONST(10021) = (KAPHO2*0.44)
  RCONST(10022) = (KAPNO)
  RCONST(10023) = (KFPAN)
  RCONST(10024) = (KRO2NO3*1.74)
  RCONST(10025) = (1.00D-11*RO2)
  RCONST(10026) = (5.73D-11)
  RCONST(10027) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(10028) = (KDEC)
  RCONST(10029) = (KRO2HO2*0.890)
  RCONST(10030) = (KRO2NO)
  RCONST(10031) = (KRO2NO3)
  RCONST(10032) = (2.00D-12*RO2)
  RCONST(10033) = (7.83D-15)
  RCONST(10034) = (5.10D-14)
  RCONST(10035) = (KRO2HO2*0.90)
  RCONST(10036) = (KRO2NO)
  RCONST(10037) = (KRO2NO3)
  RCONST(10038) = (2.50D-13*RO2)
  RCONST(10039) = (KRO2HO2*0.890)
  RCONST(10040) = (KRO2NO)
  RCONST(10041) = (KRO2NO3)
  RCONST(10042) = (8.80D-13*RO2)
  RCONST(10043) = (KRO2HO2*0.890)
  RCONST(10044) = (KRO2NO)
  RCONST(10045) = (KRO2NO3)
  RCONST(10046) = (8.80D-13*RO2*0.20)
  RCONST(10047) = (8.80D-13*RO2*0.60)
  RCONST(10048) = (8.80D-13*RO2*0.20)
  RCONST(10049) = (KRO2HO2*0.90)
  RCONST(10050) = (KRO2NO)
  RCONST(10051) = (KRO2NO3)
  RCONST(10052) = (8.00D-13*RO2)
  RCONST(10053) = (KRO2HO2*0.90)
  RCONST(10054) = (KRO2NO)
  RCONST(10055) = (KRO2NO3)
  RCONST(10056) = (8.00D-13*RO2)
  RCONST(10057) = (2.05D-10)
  RCONST(10058) = (j('ch3o2h'))
  RCONST(10059) = (6.50D-11)
  RCONST(10060) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('mek'))
  RCONST(10061) = (KDEC)
  RCONST(10062) = (KNO3AL*5.5)
  RCONST(10063) = (7.09D-11)
  RCONST(10064) = (j('mek'))
  RCONST(10065) = (j('biacet'))
  RCONST(10066) = (j('n_c3h7cho_hco'))
  RCONST(10067) = (4.43D-11)
  RCONST(10068) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(10069) = (9.59D-11)
  RCONST(10070) = (j('ch3o2h'))
  RCONST(10071) = (KDEC*0.5)
  RCONST(10072) = (KDEC*0.5)
  RCONST(10073) = (1.90D-12*EXP(190/TEMP))
  RCONST(10074) = (4.15D-11)
  RCONST(10075) = (j('ch3o2h'))
  RCONST(10076) = (4.38D-11)
  RCONST(10077) = (j('ch3o2h'))
  RCONST(10078) = (KDEC)
  RCONST(10079) = (3.39D-11)
  RCONST(10080) = (3.47D-11)
  RCONST(10081) = (KAPHO2*0.56)
  RCONST(10082) = (KAPHO2*0.44)
  RCONST(10083) = (KAPNO)
  RCONST(10084) = (KFPAN)
  RCONST(10085) = (KRO2NO3*1.74)
  RCONST(10086) = (1.00D-11*RO2)
  RCONST(10087) = (5.73D-11)
  RCONST(10088) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(10089) = (KDEC)
  RCONST(10090) = (2.05D-11)
  RCONST(10091) = (j('ch3o2h'))
  RCONST(10092) = (KDEC)
  RCONST(10093) = (8.93D-12)
  RCONST(10094) = (KNO3AL)
  RCONST(10095) = (1.29D-11)
  RCONST(10096) = (j('ch3cocho'))
  RCONST(10097) = (7.83D-15)
  RCONST(10098) = (5.10D-14)
  RCONST(10099) = (KRO2HO2*0.90)
  RCONST(10100) = (KRO2NO)
  RCONST(10101) = (KRO2NO3)
  RCONST(10102) = (2.50D-13*RO2)
  RCONST(10103) = (KRO2HO2*0.890)
  RCONST(10104) = (KRO2NO)
  RCONST(10105) = (KRO2NO3)
  RCONST(10106) = (8.80D-13*RO2)
  RCONST(10107) = (KRO2HO2*0.890)
  RCONST(10108) = (KRO2NO)
  RCONST(10109) = (KRO2NO3)
  RCONST(10110) = (8.80D-13*RO2*0.20)
  RCONST(10111) = (8.80D-13*RO2*0.60)
  RCONST(10112) = (8.80D-13*RO2*0.20)
  RCONST(10113) = (KRO2HO2*0.90)
  RCONST(10114) = (KRO2NO)
  RCONST(10115) = (KRO2NO3)
  RCONST(10116) = (8.00D-13*RO2)
  RCONST(10117) = (KRO2HO2*0.90)
  RCONST(10118) = (KRO2NO)
  RCONST(10119) = (KRO2NO3)
  RCONST(10120) = (8.00D-13*RO2)
  RCONST(10121) = (2.05D-10)
  RCONST(10122) = (j('ch3o2h'))
  RCONST(10123) = (6.30D-11)
  RCONST(10124) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('mek'))
  RCONST(10125) = (KDEC)
  RCONST(10126) = (KNO3AL*8.5)
  RCONST(10127) = (6.89D-11)
  RCONST(10128) = (j('n_c3h7cho_hco'))
  RCONST(10129) = (j('mek'))
  RCONST(10130) = (j('biacet'))
  RCONST(10131) = (4.23D-11)
  RCONST(10132) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(10133) = (9.59D-12)
  RCONST(10134) = (j('ch3o2h'))
  RCONST(10135) = (KDEC*0.5)
  RCONST(10136) = (KDEC*0.5)
  RCONST(10137) = (1.90D-12*EXP(190/TEMP))
  RCONST(10138) = (4.31D-11)
  RCONST(10139) = (j('ch3o2h'))
  RCONST(10140) = (4.37D-11)
  RCONST(10141) = (j('ch3o2h'))
  RCONST(10142) = (KDEC)
  RCONST(10143) = (3.38D-11)
  RCONST(10144) = (3.47D-11)
  RCONST(10145) = (KAPHO2*0.56)
  RCONST(10146) = (KAPHO2*0.44)
  RCONST(10147) = (KAPNO)
  RCONST(10148) = (KFPAN)
  RCONST(10149) = (KRO2NO3*1.74)
  RCONST(10150) = (1.00D-11*RO2)
  RCONST(10151) = (5.73D-11)
  RCONST(10152) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(10153) = (KDEC)
  RCONST(10154) = (KDEC*0.35)
  RCONST(10155) = (KDEC*0.65)
  RCONST(10156) = (7.83D-15)
  RCONST(10157) = (5.10D-14)
  RCONST(10158) = (KRO2HO2*0.90)
  RCONST(10159) = (KRO2NO)
  RCONST(10160) = (KRO2NO3)
  RCONST(10161) = (2.50D-13*RO2)
  RCONST(10162) = (KRO2HO2*0.90)
  RCONST(10163) = (KRO2NO)
  RCONST(10164) = (KRO2NO3)
  RCONST(10165) = (8.00D-13*RO2)
  RCONST(10166) = (KRO2HO2*0.90)
  RCONST(10167) = (KRO2NO)
  RCONST(10168) = (KRO2NO3)
  RCONST(10169) = (8.00D-13*RO2)
  RCONST(10170) = (2.05D-10)
  RCONST(10171) = (j('ch3o2h'))
  RCONST(10172) = (4.84D-11)
  RCONST(10173) = (j('mvk_mcm_ch2ch'))
  RCONST(10174) = (j('ch3o2h'))
  RCONST(10175) = (4.48D-11)
  RCONST(10176) = (KBPAN)
  RCONST(10177) = (7.40D-11)
  RCONST(10178) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('mek'))
  RCONST(10179) = (KDEC)
  RCONST(10180) = (5.33D-11)
  RCONST(10181) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(10182) = (9.93D-11)
  RCONST(10183) = (j('ch3o2h'))
  RCONST(10184) = (KDEC)
  RCONST(10185) = (1.37D-11)
  RCONST(10186) = (j('ch3o2h'))
  RCONST(10187) = (KDEC)
  RCONST(10188) = (1.02D-11)
  RCONST(10189) = (5.59D-12)
  RCONST(10190) = (j('ch3o2h'))
  RCONST(10191) = (KDEC)
  RCONST(10192) = (4.46D-12)
  RCONST(10193) = (j('ch3o2h'))
  RCONST(10194) = (KDEC)
  RCONST(10195) = (1.01D-12)
  RCONST(10196) = (1.02D-11)
  RCONST(10197) = (j('ch3o2h'))
  RCONST(10198) = (KDEC)
  RCONST(10199) = (6.75D-12)
  RCONST(10200) = (1.53D-12)
  RCONST(10201) = (2.59D-11)
  RCONST(10202) = (j('mek')*2)
  RCONST(10203) = (j('ch3o2h'))
  RCONST(10204) = (KDEC*0.7)
  RCONST(10205) = (KDEC*0.3)
  RCONST(10206) = (2.24D-11)
  RCONST(10207) = (j('mek')*2)
  RCONST(10208) = (7.83D-15)
  RCONST(10209) = (5.10D-14)
  RCONST(10210) = (KRO2HO2*0.90)
  RCONST(10211) = (KRO2NO)
  RCONST(10212) = (KRO2NO3)
  RCONST(10213) = (2.50D-13*RO2)
  RCONST(10214) = (KRO2HO2*0.890)
  RCONST(10215) = (KRO2NO)
  RCONST(10216) = (KRO2NO3)
  RCONST(10217) = (9.20D-14*RO2)
  RCONST(10218) = (KRO2HO2*0.890)
  RCONST(10219) = (KRO2NO)
  RCONST(10220) = (KRO2NO3)
  RCONST(10221) = (9.20D-14*RO2*0.70)
  RCONST(10222) = (9.20D-14*RO2*0.30)
  RCONST(10223) = (KRO2HO2*0.90)
  RCONST(10224) = (KRO2NO)
  RCONST(10225) = (KRO2NO3)
  RCONST(10226) = (8.00D-13*RO2)
  RCONST(10227) = (KRO2HO2*0.90)
  RCONST(10228) = (KRO2NO)
  RCONST(10229) = (KRO2NO3)
  RCONST(10230) = (8.00D-13*RO2)
  RCONST(10231) = (2.05D-10)
  RCONST(10232) = (j('ch3o2h'))
  RCONST(10233) = (1.53D-12)
  RCONST(10234) = (KRO2HO2*0.706)
  RCONST(10235) = (KRO2NO)
  RCONST(10236) = (KRO2NO3)
  RCONST(10237) = (2.00D-12*RO2)
  RCONST(10238) = (7.83D-15)
  RCONST(10239) = (5.10D-14)
  RCONST(10240) = (KRO2HO2*0.90)
  RCONST(10241) = (KRO2NO)
  RCONST(10242) = (KRO2NO3)
  RCONST(10243) = (2.50D-13*RO2)
  RCONST(10244) = (KRO2HO2*0.890)
  RCONST(10245) = (KRO2NO)
  RCONST(10246) = (KRO2NO3)
  RCONST(10247) = (8.80D-13*RO2)
  RCONST(10248) = (KRO2HO2*0.890)
  RCONST(10249) = (KRO2NO)
  RCONST(10250) = (KRO2NO3)
  RCONST(10251) = (8.80D-13*RO2*0.2)
  RCONST(10252) = (8.80D-13*RO2*0.6)
  RCONST(10253) = (8.80D-13*RO2*0.2)
  RCONST(10254) = (KRO2HO2*0.90)
  RCONST(10255) = (KRO2NO)
  RCONST(10256) = (KRO2NO3)
  RCONST(10257) = (8.00D-13*RO2)
  RCONST(10258) = (KRO2HO2*0.90)
  RCONST(10259) = (KRO2NO)
  RCONST(10260) = (KRO2NO3)
  RCONST(10261) = (8.00D-13*RO2)
  RCONST(10262) = (2.05D-10)
  RCONST(10263) = (j('ch3o2h'))
  RCONST(10264) = (7.83D-15)
  RCONST(10265) = (5.10D-14)
  RCONST(10266) = (KRO2HO2*0.90)
  RCONST(10267) = (KRO2NO)
  RCONST(10268) = (KRO2NO3)
  RCONST(10269) = (2.50D-13*RO2)
  RCONST(10270) = (KRO2HO2*0.890)
  RCONST(10271) = (KRO2NO)
  RCONST(10272) = (KRO2NO3)
  RCONST(10273) = (9.20D-14*RO2)
  RCONST(10274) = (KRO2HO2*0.890)
  RCONST(10275) = (KRO2NO)
  RCONST(10276) = (KRO2NO3)
  RCONST(10277) = (9.20D-14*RO2*0.7)
  RCONST(10278) = (9.20D-14*RO2*0.3)
  RCONST(10279) = (KRO2HO2*0.90)
  RCONST(10280) = (KRO2NO)
  RCONST(10281) = (KRO2NO3)
  RCONST(10282) = (8.00D-13*RO2)
  RCONST(10283) = (KRO2HO2*0.90)
  RCONST(10284) = (KRO2NO)
  RCONST(10285) = (KRO2NO3)
  RCONST(10286) = (8.00D-13*RO2)
  RCONST(10287) = (2.05D-10)
  RCONST(10288) = (j('ch3o2h'))
  RCONST(10289) = (2.79D-11)
  RCONST(10290) = (j('ch3o2h')+j('mek')*2)
  RCONST(10291) = (KDEC*0.7)
  RCONST(10292) = (KDEC*0.3)
  RCONST(10293) = (5.04D-12)
  RCONST(10294) = (j('mek'))
  RCONST(10295) = (j('mek')*2)
  RCONST(10296) = (1.80D-11)
  RCONST(10297) = (j('mek')*2)
  RCONST(10298) = (7.83D-15)
  RCONST(10299) = (5.10D-14)
  RCONST(10300) = (KRO2HO2*0.90)
  RCONST(10301) = (KRO2NO)
  RCONST(10302) = (KRO2NO3)
  RCONST(10303) = (2.50D-13*RO2)
  RCONST(10304) = (KRO2HO2*0.890)
  RCONST(10305) = (KRO2NO)
  RCONST(10306) = (KRO2NO3)
  RCONST(10307) = (9.20D-14*RO2)
  RCONST(10308) = (KRO2HO2*0.890)
  RCONST(10309) = (KRO2NO)
  RCONST(10310) = (KRO2NO3)
  RCONST(10311) = (9.20D-14*RO2*0.7)
  RCONST(10312) = (9.20D-14*RO2*0.3)
  RCONST(10313) = (KRO2HO2*0.90)
  RCONST(10314) = (KRO2NO)
  RCONST(10315) = (KRO2NO3)
  RCONST(10316) = (8.00D-13*RO2)
  RCONST(10317) = (KRO2HO2*0.90)
  RCONST(10318) = (KRO2NO)
  RCONST(10319) = (KRO2NO3)
  RCONST(10320) = (8.00D-13*RO2)
  RCONST(10321) = (2.05D-10)
  RCONST(10322) = (j('ch3o2h'))
  RCONST(10323) = (KDEC*0.65)
  RCONST(10324) = (KDEC*0.35)
  RCONST(10325) = (4.88D-11)
  RCONST(10326) = (j('ch3o2h'))
  RCONST(10327) = (j('mvk_mcm_ch2ch'))
  RCONST(10328) = (4.48D-11)
  RCONST(10329) = (KBPAN)
  RCONST(10330) = (7.44D-11)
  RCONST(10331) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('mek'))
  RCONST(10332) = (KDEC)
  RCONST(10333) = (5.37D-11)
  RCONST(10334) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(10335) = (7.15D-12)
  RCONST(10336) = (j('ch3o2h'))
  RCONST(10337) = (KDEC)
  RCONST(10338) = (7.32D-11)
  RCONST(10339) = (1.90D-12*EXP(190/TEMP))
  RCONST(10340) = (j('ch3o2h'))
  RCONST(10341) = (KDEC)
  RCONST(10342) = (1.46D-12)
  RCONST(10343) = (j('mek'))
  RCONST(10344) = (3.23D-11)
  RCONST(10345) = (3.33D-11)
  RCONST(10346) = (j('ch3o2h'))
  RCONST(10347) = (KDEC)
  RCONST(10348) = (2.99D-11)
  RCONST(10349) = (3.60D-12)
  RCONST(10350) = (j('ch3o2h'))
  RCONST(10351) = (3.90D-13)
  RCONST(10352) = (KRO2HO2*0.770)
  RCONST(10353) = (KRO2NO)
  RCONST(10354) = (KRO2NO3)
  RCONST(10355) = (8.80D-13*RO2)
  RCONST(10356) = (j('ch3cocho'))
  RCONST(10357) = (KNO3AL*4.0)
  RCONST(10358) = (1.23D-11)
  RCONST(10359) = (KAPHO2*0.56)
  RCONST(10360) = (KAPHO2*0.44)
  RCONST(10361) = (KAPNO)
  RCONST(10362) = (KFPAN)
  RCONST(10363) = (KRO2NO3*1.74)
  RCONST(10364) = (1.00D-11*RO2)
  RCONST(10365) = (2.89D-12)
  RCONST(10366) = (j('ch3cocho'))
  RCONST(10367) = (1.44D-11)
  RCONST(10368) = (j('ch3cocho')+j('biacet'))
  RCONST(10369) = (4.52D-12*0.19)
  RCONST(10370) = (4.52D-12*0.81)
  RCONST(10371) = (j('ch3coch2ono2')*10)
  RCONST(10372) = (KDEC)
  RCONST(10373) = (j('ch3cocho'))
  RCONST(10374) = (1.34D-11)
  RCONST(10375) = (KAPHO2*0.56)
  RCONST(10376) = (KAPHO2*0.44)
  RCONST(10377) = (KAPNO)
  RCONST(10378) = (KFPAN)
  RCONST(10379) = (KRO2NO3*1.74)
  RCONST(10380) = (1.00D-11*RO2)
  RCONST(10381) = (j('i_c3h7cho'))
  RCONST(10382) = (KNO3AL*7.5)
  RCONST(10383) = (2.20D-11)
  RCONST(10384) = (5.70D-11*0.46)
  RCONST(10385) = (5.70D-11*0.54)
  RCONST(10386) = (j('i_c3h7cho'))
  RCONST(10387) = (j('ch3o2h')*2)
  RCONST(10388) = (1.56D-11)
  RCONST(10389) = (j('ch3coch2ono2')*10)
  RCONST(10390) = (KDEC)
  RCONST(10391) = (KDEC*0.6)
  RCONST(10392) = (KDEC*0.4)
  RCONST(10393) = (1.2D-15)
  RCONST(10394) = (1.0D-14)
  RCONST(10395) = (1.0D-15)
  RCONST(10396) = (7.0D-14)
  RCONST(10397) = (6.0D-18*H2O)
  RCONST(10398) = (1.0D-17*H2O)
  RCONST(10399) = (1.2D-15)
  RCONST(10400) = (1.0D-14)
  RCONST(10401) = (1.0D-15)
  RCONST(10402) = (7.0D-14)
  RCONST(10403) = (6.0D-18*H2O)
  RCONST(10404) = (3.69D-12)
  RCONST(10405) = (j('ch3o2h')+j('biacet'))
  RCONST(10406) = (KDEC)
  RCONST(10407) = (KRO2HO2*0.706)
  RCONST(10408) = (KRO2NO)
  RCONST(10409) = (KRO2NO3)
  RCONST(10410) = (9.20D-14*RO2)
  RCONST(10411) = (2.52D-11)
  RCONST(10412) = (j('ch3o2h'))
  RCONST(10413) = (3.84D-11)
  RCONST(10414) = (KBPAN)
  RCONST(10415) = (7.79D-11)
  RCONST(10416) = (3.70D-11)
  RCONST(10417) = (j('ch3o2h'))
  RCONST(10418) = (8.14D-12)
  RCONST(10419) = (j('ch3coch2ono2')*10)
  RCONST(10420) = (KDEC)
  RCONST(10421) = (2.01D-11)
  RCONST(10422) = (2.01D-11)
  RCONST(10423) = (1.2D-15)
  RCONST(10424) = (1.0D-14)
  RCONST(10425) = (1.0D-15)
  RCONST(10426) = (7.0D-14)
  RCONST(10427) = (1.0D-17*H2O)
  RCONST(10428) = (6.0D-18*H2O)
  RCONST(10429) = (1.27D-11*0.35)
  RCONST(10430) = (1.27D-11*0.34)
  RCONST(10431) = (1.27D-11*0.31)
  RCONST(10432) = (j('ch3o2h'))
  RCONST(10433) = (1.63D-12*0.50)
  RCONST(10434) = (1.63D-12*0.50)
  RCONST(10435) = (KDEC)
  RCONST(10436) = (3.27D-12)
  RCONST(10437) = (j('ch3coch2ono2')*1.6)
  RCONST(10438) = (6.65D-12*0.71)
  RCONST(10439) = (6.65D-12*0.29)
  RCONST(10440) = (1.59D-11*0.73)
  RCONST(10441) = (1.59D-11*0.27)
  RCONST(10442) = (j('ch3o2h'))
  RCONST(10443) = (KDEC)
  RCONST(10444) = (j('n_c3h7cho_hco'))
  RCONST(10445) = (KNO3AL*7.5)
  RCONST(10446) = (2.76D-11)
  RCONST(10447) = (4.74D-11)
  RCONST(10448) = (j('ch3o2h')*2)
  RCONST(10449) = (j('i_c3h7cho'))
  RCONST(10450) = (1.18D-11)
  RCONST(10451) = (j('ch3coch2ono2')*10)
  RCONST(10452) = (KDEC)
  RCONST(10453) = (KDEC)
  RCONST(10454) = (KRO2HO2*0.706)
  RCONST(10455) = (KRO2NO)
  RCONST(10456) = (KRO2NO3)
  RCONST(10457) = (9.20D-14*RO2)
  RCONST(10458) = (4.40D-11)
  RCONST(10459) = (j('n_c3h7cho_hco'))
  RCONST(10460) = (j('ch3o2h')*2)
  RCONST(10461) = (KDEC)
  RCONST(10462) = (2.52D-11)
  RCONST(10463) = (j('ch3o2h'))
  RCONST(10464) = (3.84D-11)
  RCONST(10465) = (KBPAN)
  RCONST(10466) = (7.79D-11)
  RCONST(10467) = (4.50D-11)
  RCONST(10468) = (j('ch3o2h'))
  RCONST(10469) = (KDEC)
  RCONST(10470) = (2.27D-11)
  RCONST(10471) = (j('ch3coch2ono2')*0.91)
  RCONST(10472) = (j('ch3o2h'))
  RCONST(10473) = (3.16D-11)
  RCONST(10474) = (9.37D-12*0.54)
  RCONST(10475) = (9.37D-12*0.46)
  RCONST(10476) = (j('ch3coch2ono2')*10)
  RCONST(10477) = (KDEC)
  RCONST(10478) = (3.04D-11)
  RCONST(10479) = (1.2D-15)
  RCONST(10480) = (1.0D-14)
  RCONST(10481) = (1.0D-15)
  RCONST(10482) = (7.0D-14)
  RCONST(10483) = (6.0D-18*H2O)
  RCONST(10484) = (9.20D-12*0.61)
  RCONST(10485) = (9.20D-12*0.39)
  RCONST(10486) = (j('ch3o2h'))
  RCONST(10487) = (1.80D+13*(TEMP/298)**1.7*EXP(-4733/TEMP))
  RCONST(10488) = (1.80D+13*(TEMP/298)**1.7*EXP(-4079/TEMP))
  RCONST(10489) = (5.60D-12)
  RCONST(10490) = (j('ch3o2h'))
  RCONST(10491) = (j('mek'))
  RCONST(10492) = (3.60D-12)
  RCONST(10493) = (1.57D-11)
  RCONST(10494) = (j('i_c3h7cho')+j('ch3o2h'))
  RCONST(10495) = (2.67D-11)
  RCONST(10496) = (j('ch3coch2ono2')*10)
  RCONST(10497) = (4.22D-12)
  RCONST(10498) = (j('ch3coch2ono2')*1.6)
  RCONST(10499) = (1.21D-12*0.56)
  RCONST(10500) = (1.21D-12*0.44)
  RCONST(10501) = (j('i_c3h7cho'))
  RCONST(10502) = (2.29D-11)
  RCONST(10503) = (KAPHO2*0.15)
  RCONST(10504) = (KAPHO2*0.41)
  RCONST(10505) = (KAPHO2*0.44)
  RCONST(10506) = (KAPNO)
  RCONST(10507) = (KFPAN)
  RCONST(10508) = (1.00D-11*0.3*RO2)
  RCONST(10509) = (1.00D-11*0.7*RO2)
  RCONST(10510) = (1.18D-10*0.22)
  RCONST(10511) = (1.18D-10*0.03)
  RCONST(10512) = (1.18D-10*0.75)
  RCONST(10513) = (j('ch3o2h'))
  RCONST(10514) = (2.94D-11)
  RCONST(10515) = (j('1_c4h9ono2'))
  RCONST(10516) = (KDEC)
  RCONST(10517) = (4.21D-11)
  RCONST(10518) = (j('mvk_mcm_ch2ch'))
  RCONST(10519) = (7.78D-11)
  RCONST(10520) = (3.40D-15)
  RCONST(10521) = (7.80D-19*0.5)
  RCONST(10522) = (7.80D-19*0.5)
  RCONST(10523) = (4.83D-11*0.376)
  RCONST(10524) = (4.83D-11*0.624)
  RCONST(10525) = (KAPHO2*0.56)
  RCONST(10526) = (KAPHO2*0.44)
  RCONST(10527) = (KAPNO)
  RCONST(10528) = (KFPAN)
  RCONST(10529) = (KRO2NO3*1.74)
  RCONST(10530) = (1.00D-11*RO2)
  RCONST(10531) = (KRO2HO2*0.520*0.4)
  RCONST(10532) = (KRO2HO2*0.520*0.6)
  RCONST(10533) = (KRO2NO*0.019)
  RCONST(10534) = (KRO2NO*0.981)
  RCONST(10535) = (KRO2NO3)
  RCONST(10536) = (2.00D-12*0.2*RO2)
  RCONST(10537) = (2.00D-12*0.2*RO2)
  RCONST(10538) = (2.00D-12*0.6*RO2)
  RCONST(10539) = (KRO2HO2*0.625)
  RCONST(10540) = (KRO2NO)
  RCONST(10541) = (KRO2NO3)
  RCONST(10542) = (8.80D-13*RO2)
  RCONST(10543) = (1.90D-12*EXP(190/TEMP))
  RCONST(10544) = (3.59D-11)
  RCONST(10545) = (j('ch3o2h'))
  RCONST(10546) = (9.82D-11)
  RCONST(10547) = (5.37D-13)
  RCONST(10548) = (j('1_c4h9ono2'))
  RCONST(10549) = (KDEC)
  RCONST(10550) = (9.55D-12)
  RCONST(10551) = (5.34D-12)
  RCONST(10552) = (j('n_c3h7cho_hco'))
  RCONST(10553) = (j('biacet'))
  RCONST(10554) = (KNO3AL*5.5)
  RCONST(10555) = (6.65D-11)
  RCONST(10556) = (KRO2HO2*0.770)
  RCONST(10557) = (KRO2NO)
  RCONST(10558) = (KRO2NO3)
  RCONST(10559) = (8.40D-13*RO2)
  RCONST(10560) = (KRO2HO2*0.625)
  RCONST(10561) = (KRO2NO*0.007)
  RCONST(10562) = (KRO2NO*0.993)
  RCONST(10563) = (KRO2NO3)
  RCONST(10564) = (2.00D-12*0.2*RO2)
  RCONST(10565) = (2.00D-12*0.6*RO2)
  RCONST(10566) = (2.00D-12*0.2*RO2)
  RCONST(10567) = (7.27D-11)
  RCONST(10568) = (KAPHO2*0.15)
  RCONST(10569) = (KAPHO2*0.41)
  RCONST(10570) = (KAPHO2*0.44)
  RCONST(10571) = (KAPNO)
  RCONST(10572) = (KFPAN)
  RCONST(10573) = (KRO2NO3*1.74)
  RCONST(10574) = (1.00D-11*0.3*RO2)
  RCONST(10575) = (1.00D-11*0.7*RO2)
  RCONST(10576) = (KAPHO2*0.44)
  RCONST(10577) = (KAPHO2*0.15)
  RCONST(10578) = (KAPHO2*0.41)
  RCONST(10579) = (KAPNO)
  RCONST(10580) = (KFPAN)
  RCONST(10581) = (KRO2NO3*1.74)
  RCONST(10582) = (1.00D-11*0.7*RO2)
  RCONST(10583) = (1.00D-11*0.3*RO2)
  RCONST(10584) = (KRO2HO2*0.706)
  RCONST(10585) = (KRO2NO)
  RCONST(10586) = (KRO2NO3)
  RCONST(10587) = (2.00D-12*RO2)
  RCONST(10588) = (KRO2HO2*0.520)
  RCONST(10589) = (KRO2NO)
  RCONST(10590) = (KRO2NO3)
  RCONST(10591) = (6.00D-13*RO2)
  RCONST(10592) = (KAPHO2*0.15)
  RCONST(10593) = (KAPHO2*0.41)
  RCONST(10594) = (KAPHO2*0.44)
  RCONST(10595) = (KAPNO)
  RCONST(10596) = (KFPAN)
  RCONST(10597) = (KRO2NO3*1.74)
  RCONST(10598) = (1.00D-11*0.3*RO2)
  RCONST(10599) = (1.00D-11*0.7*RO2)
  RCONST(10600) = (KRO2HO2*0.77)
  RCONST(10601) = (KRO2NO)
  RCONST(10602) = (KRO2NO3)
  RCONST(10603) = (2.00D-12*RO2)
  RCONST(10604) = (KRO2HO2*0.770)
  RCONST(10605) = (KRO2NO)
  RCONST(10606) = (KRO2NO3)
  RCONST(10607) = (8.80D-13*RO2)
  RCONST(10608) = (2.75D-11)
  RCONST(10609) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(10610) = (2.25D-11)
  RCONST(10611) = (j('2_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(10612) = (KDEC)
  RCONST(10613) = (2.41D-11)
  RCONST(10614) = (j('mek'))
  RCONST(10615) = (KRO2HO2*0.914)
  RCONST(10616) = (KRO2NO)
  RCONST(10617) = (KRO2NO3)
  RCONST(10618) = (6.70D-15*RO2)
  RCONST(10619) = (6.28D-11)
  RCONST(10620) = (j('ch3o2h')+j('biacet'))
  RCONST(10621) = (2.85D-11)
  RCONST(10622) = (j('2_c4h9ono2')+j('biacet'))
  RCONST(10623) = (KDEC)
  RCONST(10624) = (5.93D-11)
  RCONST(10625) = (j('biacet'))
  RCONST(10626) = (KDEC*0.80)
  RCONST(10627) = (KDEC*0.20)
  RCONST(10628) = (2.69D-11)
  RCONST(10629) = (j('n_c3h7cho_hco'))
  RCONST(10630) = (3.00D-11)
  RCONST(10631) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(10632) = (2.52D-11)
  RCONST(10633) = (KBPAN)
  RCONST(10634) = (9.16D-12)
  RCONST(10635) = (j('ch3o2h')+j('mek'))
  RCONST(10636) = (5.70D-12)
  RCONST(10637) = (j('mek'))
  RCONST(10638) = (5.56D-12)
  RCONST(10639) = (KBPAN)
  RCONST(10640) = (2.36D-11)
  RCONST(10641) = (j('ch3o2h')+j('mek'))
  RCONST(10642) = (4.20D+10*EXP(-3523/TEMP))
  RCONST(10643) = (1.05D-11)
  RCONST(10644) = (j('ch3o2h')+j('mek'))
  RCONST(10645) = (KDEC)
  RCONST(10646) = (7.20D-12)
  RCONST(10647) = (j('mek'))
  RCONST(10648) = (1.02D-11)
  RCONST(10649) = (j('ch3o2h')+j('mek'))
  RCONST(10650) = (6.60D-12)
  RCONST(10651) = (KBPAN)
  RCONST(10652) = (1.29D-11)
  RCONST(10653) = (j('ch3o2h')+j('mek'))
  RCONST(10654) = (KDEC)
  RCONST(10655) = (7.06D-11)
  RCONST(10656) = (j('ch3o2h'))
  RCONST(10657) = (1.26D-11)
  RCONST(10658) = (KDEC)
  RCONST(10659) = (6.72D-11)
  RCONST(10660) = (7.91D-11)
  RCONST(10661) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(10662) = (6.79D-11)
  RCONST(10663) = (j('2_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(10664) = (KDEC)
  RCONST(10665) = (7.16D-11)
  RCONST(10666) = (j('n_c3h7cho_hco'))
  RCONST(10667) = (7.50D-11)
  RCONST(10668) = (j('ch3o2h'))
  RCONST(10669) = (1.58D-12)
  RCONST(10670) = (j('1_c4h9ono2'))
  RCONST(10671) = (KDEC)
  RCONST(10672) = (1.32D-12)
  RCONST(10673) = (3.11D-11)
  RCONST(10674) = (1.01D-10)
  RCONST(10675) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(10676) = (6.96D-11)
  RCONST(10677) = (j('1_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(10678) = (KROSEC*O2)
  RCONST(10679) = (2.70D+14*EXP(-6643/TEMP))
  RCONST(10680) = (KNO3AL*8.5)
  RCONST(10681) = (7.30D-11)
  RCONST(10682) = (j('n_c3h7cho_hco'))
  RCONST(10683) = (8.33D-11)
  RCONST(10684) = (KAPHO2*0.15)
  RCONST(10685) = (KAPHO2*0.41)
  RCONST(10686) = (KAPHO2*0.44)
  RCONST(10687) = (KAPNO)
  RCONST(10688) = (KFPAN)
  RCONST(10689) = (KRO2NO3*1.74)
  RCONST(10690) = (1.00D-11*RO2*0.3)
  RCONST(10691) = (1.00D-11*RO2*0.7)
  RCONST(10692) = (1.91D-11)
  RCONST(10693) = (j('ch3o2h'))
  RCONST(10694) = (9.97D-12)
  RCONST(10695) = (j('2_c4h9ono2'))
  RCONST(10696) = (KDEC)
  RCONST(10697) = (1.56D-11)
  RCONST(10698) = (KRO2HO2*0.859)
  RCONST(10699) = (KRO2NO*0.104)
  RCONST(10700) = (KRO2NO*0.896)
  RCONST(10701) = (KRO2NO3)
  RCONST(10702) = (6.70D-15*RO2*0.7)
  RCONST(10703) = (6.70D-15*RO2*0.3)
  RCONST(10704) = (4.28D-11)
  RCONST(10705) = (j('ch3o2h'))
  RCONST(10706) = (KDEC)
  RCONST(10707) = (3.93D-11)
  RCONST(10708) = (KRO2HO2*0.890)
  RCONST(10709) = (KRO2NO)
  RCONST(10710) = (KRO2NO3)
  RCONST(10711) = (9.20D-14*RO2*0.7)
  RCONST(10712) = (9.20D-14*RO2*0.3)
  RCONST(10713) = (KAPHO2*0.41)
  RCONST(10714) = (KAPHO2*0.44)
  RCONST(10715) = (KAPHO2*0.15)
  RCONST(10716) = (KAPNO)
  RCONST(10717) = (KFPAN)
  RCONST(10718) = (KRO2NO3*1.74)
  RCONST(10719) = (1.00D-11*RO2*0.7)
  RCONST(10720) = (1.00D-11*RO2*0.3)
  RCONST(10721) = (KRO2HO2*0.859)
  RCONST(10722) = (KRO2NO*0.138)
  RCONST(10723) = (KRO2NO*0.862)
  RCONST(10724) = (KRO2NO3)
  RCONST(10725) = (1.30D-12*RO2*0.2)
  RCONST(10726) = (1.30D-12*RO2*0.6)
  RCONST(10727) = (1.30D-12*RO2*0.2)
  RCONST(10728) = (4.65D-11)
  RCONST(10729) = (j('ch3o2h'))
  RCONST(10730) = (3.01D-11)
  RCONST(10731) = (KDEC)
  RCONST(10732) = (4.31D-11)
  RCONST(10733) = (KRO2HO2*0.859)
  RCONST(10734) = (KRO2NO)
  RCONST(10735) = (KRO2NO3)
  RCONST(10736) = (9.20D-14*RO2*0.7)
  RCONST(10737) = (9.20D-14*RO2*0.3)
  RCONST(10738) = (KNO3AL*8.5)
  RCONST(10739) = (5.41D-11)
  RCONST(10740) = (j('n_c3h7cho_hco')*2)
  RCONST(10741) = (KDEC)
  RCONST(10742) = (KRO2HO2*0.859)
  RCONST(10743) = (KRO2NO*0.069)
  RCONST(10744) = (KRO2NO*0.931)
  RCONST(10745) = (KRO2NO3)
  RCONST(10746) = (9.20D-14*RO2*0.7)
  RCONST(10747) = (9.20D-14*RO2*0.3)
  RCONST(10748) = (KRO2HO2*0.820)
  RCONST(10749) = (KRO2NO*0.111)
  RCONST(10750) = (KRO2NO*0.889)
  RCONST(10751) = (KRO2NO3)
  RCONST(10752) = (1.30D-12*RO2*0.4)
  RCONST(10753) = (1.30D-12*RO2*0.6)
  RCONST(10754) = (8.38D-11)
  RCONST(10755) = (j('n_c3h7cho_hco'))
  RCONST(10756) = (8.69D-11)
  RCONST(10757) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(10758) = (8.33D-11)
  RCONST(10759) = (KBPAN)
  RCONST(10760) = (KDEC*0.2)
  RCONST(10761) = (KDEC*0.8)
  RCONST(10762) = (8.47D-11)
  RCONST(10763) = (8.82D-11)
  RCONST(10764) = (j('ch3o2h'))
  RCONST(10765) = (8.46D-11)
  RCONST(10766) = (KBPAN)
  RCONST(10767) = (8.69D-11)
  RCONST(10768) = (j('ch3o2h'))
  RCONST(10769) = (KDEC)
  RCONST(10770) = (6.67D-11)
  RCONST(10771) = (j('biacet'))
  RCONST(10772) = (7.47D-11)
  RCONST(10773) = (6.28D-11)
  RCONST(10774) = (j('ch3o2h'))
  RCONST(10775) = (5.92D-11)
  RCONST(10776) = (KBPAN)
  RCONST(10777) = (3.64D-11)
  RCONST(10778) = (j('ch3o2h'))
  RCONST(10779) = (KDEC)
  RCONST(10780) = (8.06D-11)
  RCONST(10781) = (j('mek')+j('ch3o2h'))
  RCONST(10782) = (KROSEC*O2)
  RCONST(10783) = (2.00D+14*EXP(-6824/TEMP))
  RCONST(10784) = (1.01D-11)
  RCONST(10785) = (j('ch3o2h'))
  RCONST(10786) = (KDEC)
  RCONST(10787) = (6.30D-12)
  RCONST(10788) = (KRO2HO2*0.914)
  RCONST(10789) = (KRO2NO)
  RCONST(10790) = (KRO2NO3)
  RCONST(10791) = (8.80D-13*RO2*0.2)
  RCONST(10792) = (8.80D-13*RO2*0.6)
  RCONST(10793) = (8.80D-13*RO2*0.2)
  RCONST(10794) = (KRO2HO2*0.914)
  RCONST(10795) = (KRO2NO)
  RCONST(10796) = (KRO2NO3)
  RCONST(10797) = (8.80D-13*RO2*0.05)
  RCONST(10798) = (8.80D-13*RO2*0.9)
  RCONST(10799) = (8.80D-13*RO2*0.05)
  RCONST(10800) = (1.20D-15)
  RCONST(10801) = (1.00D-14)
  RCONST(10802) = (1.00D-15)
  RCONST(10803) = (7.00D-14)
  RCONST(10804) = (2.00D-18*H2O)
  RCONST(10805) = (1.40D-17*H2O)
  RCONST(10806) = (2.08D-11)
  RCONST(10807) = (j('ch3o2h'))
  RCONST(10808) = (9.20D-12)
  RCONST(10809) = (KDEC)
  RCONST(10810) = (1.74D-11)
  RCONST(10811) = (4.76D-11)
  RCONST(10812) = (j('ch3o2h'))
  RCONST(10813) = (KDEC)
  RCONST(10814) = (1.60D-11)
  RCONST(10815) = (5.02D-11)
  RCONST(10816) = (j('ch3o2h'))
  RCONST(10817) = (KDEC)
  RCONST(10818) = (3.21D-11)
  RCONST(10819) = (j('biacet'))
  RCONST(10820) = (3.96D-11)
  RCONST(10821) = (1.55D-11)
  RCONST(10822) = (j('ch3o2h'))
  RCONST(10823) = (1.19D-11)
  RCONST(10824) = (KBPAN)
  RCONST(10825) = (1.06D-10)
  RCONST(10826) = (j('ch3o2h'))
  RCONST(10827) = (j('mek'))
  RCONST(10828) = (KDEC)
  RCONST(10829) = (8.34D-11)
  RCONST(10830) = (j('biacet'))
  RCONST(10831) = (9.34D-11)
  RCONST(10832) = (j('mek'))
  RCONST(10833) = (4.73D-11)
  RCONST(10834) = (j('ch3o2h'))
  RCONST(10835) = (j('mek'))
  RCONST(10836) = (KDEC)
  RCONST(10837) = (5.05D-11)
  RCONST(10838) = (j('ch3cocho'))
  RCONST(10839) = (4.04D-11)
  RCONST(10840) = (j('mek'))
  RCONST(10841) = (5.41D-11)
  RCONST(10842) = (j('ch3o2h'))
  RCONST(10843) = (j('n_c3h7cho_hco'))
  RCONST(10844) = (KDEC)
  RCONST(10845) = (2.52D-11)
  RCONST(10846) = (j('ch3cocho'))
  RCONST(10847) = (4.19D-11)
  RCONST(10848) = (j('n_c3h7cho_hco'))
  RCONST(10849) = (2.06D-11)
  RCONST(10850) = (j('ch3o2h'))
  RCONST(10851) = (7.10D-12)
  RCONST(10852) = (j('n_c3h7ono2'))
  RCONST(10853) = (KDEC)
  RCONST(10854) = (3.21D-11)
  RCONST(10855) = (1.15D-11)
  RCONST(10856) = (3.41D-11)
  RCONST(10857) = (j('ch3o2h'))
  RCONST(10858) = (KDEC)
  RCONST(10859) = (1.55D-11)
  RCONST(10860) = (2.19D-11)
  RCONST(10861) = (6.98D-11)
  RCONST(10862) = (7.29D-11)
  RCONST(10863) = (j('ch3o2h'))
  RCONST(10864) = (6.93D-11)
  RCONST(10865) = (KBPAN)
  RCONST(10866) = (KDEC*0.1)
  RCONST(10867) = (KDEC*0.9)
  RCONST(10868) = (8.47D-11)
  RCONST(10869) = (8.82D-11)
  RCONST(10870) = (j('ch3o2h'))
  RCONST(10871) = (8.46D-11)
  RCONST(10872) = (KBPAN)
  RCONST(10873) = (5.01D-11)
  RCONST(10874) = (j('ch3o2h'))
  RCONST(10875) = (KDEC)
  RCONST(10876) = (3.20D-11)
  RCONST(10877) = (j('biacet'))
  RCONST(10878) = (3.95D-11)
  RCONST(10879) = (8.68D-11)
  RCONST(10880) = (j('ch3o2h'))
  RCONST(10881) = (7.92D-11)
  RCONST(10882) = (j('2_c4h9ono2'))
  RCONST(10883) = (KDEC)
  RCONST(10884) = (8.32D-11)
  RCONST(10885) = (6.26D-11)
  RCONST(10886) = (j('ch3o2h'))
  RCONST(10887) = (KDEC)
  RCONST(10888) = (5.91D-11)
  RCONST(10889) = (KAPHO2*0.15)
  RCONST(10890) = (KAPHO2*0.41)
  RCONST(10891) = (KAPHO2*0.44)
  RCONST(10892) = (KAPNO)
  RCONST(10893) = (KFPAN)
  RCONST(10894) = (KRO2NO3*1.74)
  RCONST(10895) = (1.00D-11*RO2*0.3)
  RCONST(10896) = (1.00D-11*RO2*0.7)
  RCONST(10897) = (KRO2HO2*0.932)
  RCONST(10898) = (KRO2NO*0.173)
  RCONST(10899) = (KRO2NO*0.827)
  RCONST(10900) = (KRO2NO3)
  RCONST(10901) = (1.30D-12*RO2*0.2)
  RCONST(10902) = (1.30D-12*RO2*0.6)
  RCONST(10903) = (1.30D-12*RO2*0.2)
  RCONST(10904) = (1.20D-15)
  RCONST(10905) = (1.00D-14)
  RCONST(10906) = (1.00D-15)
  RCONST(10907) = (7.00D-14)
  RCONST(10908) = (1.40D-17*H2O)
  RCONST(10909) = (KRO2HO2*0.968)
  RCONST(10910) = (KRO2NO)
  RCONST(10911) = (KRO2NO3)
  RCONST(10912) = (8.80D-13*RO2*0.2)
  RCONST(10913) = (8.80D-13*RO2*0.6)
  RCONST(10914) = (8.80D-13*RO2*0.2)
  RCONST(10915) = (6.64D-11)
  RCONST(10916) = (j('ch3o2h'))
  RCONST(10917) = (5.59D-11)
  RCONST(10918) = (KDEC)
  RCONST(10919) = (6.29D-11)
  RCONST(10920) = (7.39D-11)
  RCONST(10921) = (j('ch3o2h'))
  RCONST(10922) = (5.82D-11)
  RCONST(10923) = (j('n_c3h7ono2'))
  RCONST(10924) = (KDEC)
  RCONST(10925) = (6.85D-11)
  RCONST(10926) = (6.91D-11)
  RCONST(10927) = (3.64D-11)
  RCONST(10928) = (j('ch3o2h'))
  RCONST(10929) = (8.69D-11)
  RCONST(10930) = (j('ch3o2h'))
  RCONST(10931) = (5.82D-11)
  RCONST(10932) = (j('2_c4h9ono2'))
  RCONST(10933) = (KDEC)
  RCONST(10934) = (7.47D-11)
  RCONST(10935) = (9.73D-12)
  RCONST(10936) = (j('ch3o2h'))
  RCONST(10937) = (KDEC)
  RCONST(10938) = (6.30D-12)
  RCONST(10939) = (KRO2HO2*0.947)
  RCONST(10940) = (KRO2NO*0.176)
  RCONST(10941) = (KRO2NO*0.824)
  RCONST(10942) = (KRO2NO3)
  RCONST(10943) = (1.30D-12*RO2*0.2)
  RCONST(10944) = (1.30D-12*RO2*0.6)
  RCONST(10945) = (1.30D-12*RO2*0.2)
  RCONST(10946) = (2.08D-11)
  RCONST(10947) = (j('ch3o2h'))
  RCONST(10948) = (9.20D-12)
  RCONST(10949) = (KDEC)
  RCONST(10950) = (1.74D-11)
  RCONST(10951) = (4.76D-11)
  RCONST(10952) = (j('ch3o2h'))
  RCONST(10953) = (KDEC)
  RCONST(10954) = (1.73D-11)
  RCONST(10955) = (j('ch3o2h'))
  RCONST(10956) = (1.27D-11)
  RCONST(10957) = (KBPAN)
  RCONST(10958) = (9.14D-12)
  RCONST(10959) = (j('ch3o2h'))
  RCONST(10960) = (2.36D-11)
  RCONST(10961) = (KBPAN)
  RCONST(10962) = (9.91D-12)
  RCONST(10963) = (j('n_c3h7cho_hco')*2)
  RCONST(10964) = (2*KNO3AL*2.4)
  RCONST(10965) = (4.29D-11)
  RCONST(10966) = (KAPHO2*0.15)
  RCONST(10967) = (KAPHO2*0.41)
  RCONST(10968) = (KAPHO2*0.44)
  RCONST(10969) = (KAPNO)
  RCONST(10970) = (KFPAN)
  RCONST(10971) = (KRO2NO3*1.74)
  RCONST(10972) = (1.00D-11*RO2*0.3)
  RCONST(10973) = (1.00D-11*RO2*0.7)
  RCONST(10974) = (KRO2HO2*0.706)
  RCONST(10975) = (KRO2NO)
  RCONST(10976) = (KRO2NO3)
  RCONST(10977) = (1.30D-12*RO2)
  RCONST(10978) = (KRO2HO2*0.706)
  RCONST(10979) = (KRO2NO)
  RCONST(10980) = (KRO2NO3)
  RCONST(10981) = (8.80D-13*RO2)
  RCONST(10982) = (KRO2HO2*0.770)
  RCONST(10983) = (KRO2NO)
  RCONST(10984) = (KRO2NO3)
  RCONST(10985) = (2.00D-12*RO2)
  RCONST(10986) = (9.64D-12)
  RCONST(10987) = (j('ch3o2h'))
  RCONST(10988) = (1.31D-11)
  RCONST(10989) = (KBPAN)
  RCONST(10990) = (5.92D-12)
  RCONST(10991) = (2.78D-11)
  RCONST(10992) = (j('ch3o2h'))
  RCONST(10993) = (KDEC)
  RCONST(10994) = (1.02D-13)
  RCONST(10995) = (KBPAN)
  RCONST(10996) = (KAPHO2*0.15)
  RCONST(10997) = (KAPHO2*0.41)
  RCONST(10998) = (KAPHO2*0.44)
  RCONST(10999) = (KAPNO)
  RCONST(11000) = (KFPAN)
  RCONST(11001) = (KRO2NO3*1.74)
  RCONST(11002) = (1.00D-11*0.3*RO2)
  RCONST(11003) = (1.00D-11*0.7*RO2)
  RCONST(11004) = (KAPHO2*0.15)
  RCONST(11005) = (KAPHO2*0.41)
  RCONST(11006) = (KAPHO2*0.44)
  RCONST(11007) = (KAPNO)
  RCONST(11008) = (KFPAN)
  RCONST(11009) = (KRO2NO3*1.74)
  RCONST(11010) = (1.00D-11*0.3*RO2)
  RCONST(11011) = (1.00D-11*0.7*RO2)
  RCONST(11012) = (1.11D-11)
  RCONST(11013) = (j('ch3o2h'))
  RCONST(11014) = (1.45D-11)
  RCONST(11015) = (KBPAN)
  RCONST(11016) = (1.04D-11)
  RCONST(11017) = (KAPHO2*0.15)
  RCONST(11018) = (KAPHO2*0.41)
  RCONST(11019) = (KAPHO2*0.44)
  RCONST(11020) = (KAPNO)
  RCONST(11021) = (KFPAN)
  RCONST(11022) = (KRO2NO3*1.74)
  RCONST(11023) = (1.00D-11*0.3*RO2)
  RCONST(11024) = (1.00D-11*0.7*RO2)
  RCONST(11025) = (j('ch3o2h'))
  RCONST(11026) = (1.79D-11)
  RCONST(11027) = (KBPAN)
  RCONST(11028) = (7.61D-12)
  RCONST(11029) = (j('ch3o2h')+j('mek'))
  RCONST(11030) = (8.80D-11)
  RCONST(11031) = (j('mek'))
  RCONST(11032) = (2.54D-12)
  RCONST(11033) = (2.00D+14*EXP(-6261/TEMP))
  RCONST(11034) = (j('mek'))
  RCONST(11035) = (3.90D-11)
  RCONST(11036) = (KAPHO2*0.15)
  RCONST(11037) = (KAPHO2*0.41)
  RCONST(11038) = (KAPHO2*0.44)
  RCONST(11039) = (KAPNO)
  RCONST(11040) = (KFPAN)
  RCONST(11041) = (KRO2NO3*1.74)
  RCONST(11042) = (1.00D-11*0.3*RO2)
  RCONST(11043) = (1.00D-11*0.7*RO2)
  RCONST(11044) = (1.72D-11)
  RCONST(11045) = (j('ch3o2h'))
  RCONST(11046) = (2.07D-11)
  RCONST(11047) = (KBPAN)
  RCONST(11048) = (1.35D-11)
  RCONST(11049) = (j('ch3o2h')+j('mek'))
  RCONST(11050) = (1.90D-12*EXP(190/TEMP))
  RCONST(11051) = (5.29D-12)
  RCONST(11052) = (j('mek'))
  RCONST(11053) = (1.06D-12)
  RCONST(11054) = (KAPHO2*0.15)
  RCONST(11055) = (KAPHO2*0.41)
  RCONST(11056) = (KAPHO2*0.44)
  RCONST(11057) = (KAPNO)
  RCONST(11058) = (KFPAN)
  RCONST(11059) = (KRO2NO3*1.74)
  RCONST(11060) = (1.00D-11*0.3*RO2)
  RCONST(11061) = (1.00D-11*0.7*RO2)
  RCONST(11062) = (KRO2HO2*0.770)
  RCONST(11063) = (KRO2NO)
  RCONST(11064) = (KRO2NO3)
  RCONST(11065) = (9.20D-14*0.7*RO2)
  RCONST(11066) = (9.20D-14*0.3*RO2)
  RCONST(11067) = (j('ch3o2h'))
  RCONST(11068) = (3.39D-11)
  RCONST(11069) = (j('1_c4h9ono2'))
  RCONST(11070) = (8.83D-12)
  RCONST(11071) = (3.05D+11*EXP(-4240/TEMP))
  RCONST(11072) = (KROSEC*O2)
  RCONST(11073) = (1.87D-11)
  RCONST(11074) = (1.52D-11)
  RCONST(11075) = (j('ch3o2h'))
  RCONST(11076) = (1.87D-11)
  RCONST(11077) = (KBPAN)
  RCONST(11078) = (1.08D-11)
  RCONST(11079) = (j('ch3o2h'))
  RCONST(11080) = (j('mek'))
  RCONST(11081) = (2.80D-11)
  RCONST(11082) = (1.90D-12*EXP(190/TEMP))
  RCONST(11083) = (KDEC)
  RCONST(11084) = (j('biacet'))
  RCONST(11085) = (1.53D-11)
  RCONST(11086) = (j('mek'))
  RCONST(11087) = (2.10D-11)
  RCONST(11088) = (j('ch3o2h')+j('mek'))
  RCONST(11089) = (6.48D-12)
  RCONST(11090) = (KBPAN)
  RCONST(11091) = (2.20D-12)
  RCONST(11092) = (5.82D-12)
  RCONST(11093) = (j('ch3o2h'))
  RCONST(11094) = (9.42D-12)
  RCONST(11095) = (KBPAN)
  RCONST(11096) = (2.09D-12)
  RCONST(11097) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(11098) = (1.04D-10)
  RCONST(11099) = (j('n_c3h7cho_hco'))
  RCONST(11100) = (2.17D-11)
  RCONST(11101) = (2.00D+14*EXP(-4909/TEMP))
  RCONST(11102) = (j('n_c3h7cho_hco'))
  RCONST(11103) = (KNO3AL*8.5)
  RCONST(11104) = (6.76D-11)
  RCONST(11105) = (j('n_c3h7cho_hco'))
  RCONST(11106) = (5.50D-11)
  RCONST(11107) = (j('ch3o2h')+j('mek'))
  RCONST(11108) = (8.84D-11)
  RCONST(11109) = (j('mek'))
  RCONST(11110) = (2.09D-12)
  RCONST(11111) = (2.00D+14*EXP(-6382/TEMP))
  RCONST(11112) = (j('mek'))
  RCONST(11113) = (3.93D-11)
  RCONST(11114) = (j('mek')*2)
  RCONST(11115) = (4.32D-12)
  RCONST(11116) = (KAPHO2*0.15)
  RCONST(11117) = (KAPHO2*0.41)
  RCONST(11118) = (KAPHO2*0.44)
  RCONST(11119) = (KAPNO)
  RCONST(11120) = (KFPAN)
  RCONST(11121) = (KRO2NO3*1.74)
  RCONST(11122) = (1.00D-11*0.3*RO2)
  RCONST(11123) = (1.00D-11*0.7*RO2)
  RCONST(11124) = (1.90D-11)
  RCONST(11125) = (j('ch3o2h'))
  RCONST(11126) = (2.26D-11)
  RCONST(11127) = (KBPAN)
  RCONST(11128) = (1.20D-11)
  RCONST(11129) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(11130) = (3.40D-11)
  RCONST(11131) = (j('n_c3h7cho_hco'))
  RCONST(11132) = (2.26D-11)
  RCONST(11133) = (2.00D+14*EXP(-4909/TEMP))
  RCONST(11134) = (j('n_c3h7cho_hco'))
  RCONST(11135) = (3.06D-11)
  RCONST(11136) = (j('ch3o2h')+j('mek'))
  RCONST(11137) = (3.86D-11)
  RCONST(11138) = (KDEC)
  RCONST(11139) = (j('mek'))
  RCONST(11140) = (3.17D-11)
  RCONST(11141) = (j('ch3cocho'))
  RCONST(11142) = (4.18D-11)
  RCONST(11143) = (j('ch3o2h'))
  RCONST(11144) = (j('mek')*2.0)
  RCONST(11145) = (4.33D-12)
  RCONST(11146) = (KDEC)
  RCONST(11147) = (j('mek')*2.0)
  RCONST(11148) = (8.74D-13)
  RCONST(11149) = (9.84D-12)
  RCONST(11150) = (j('ch3o2h'))
  RCONST(11151) = (1.33D-11)
  RCONST(11152) = (KBPAN)
  RCONST(11153) = (5.91D-12)
  RCONST(11154) = (j('ch3o2h'))
  RCONST(11155) = (1.90D-12*EXP(190/TEMP))
  RCONST(11156) = (1.41D-11)
  RCONST(11157) = (j('n_c3h7ono2'))
  RCONST(11158) = (4.54D-12)
  RCONST(11159) = (KROPRIM*O2)
  RCONST(11160) = (8.65D-12)
  RCONST(11161) = (j('i_c3h7cho'))
  RCONST(11162) = (KNO3AL*8.5)
  RCONST(11163) = (3.47D-11)
  RCONST(11164) = (5.50D-12)
  RCONST(11165) = (j('ch3o2h'))
  RCONST(11166) = (8.96D-12)
  RCONST(11167) = (KBPAN)
  RCONST(11168) = (4.67D-12)
  RCONST(11169) = (1.35D-11)
  RCONST(11170) = (j('ch3o2h'))
  RCONST(11171) = (1.69D-11)
  RCONST(11172) = (KBPAN)
  RCONST(11173) = (7.60D-12)
  RCONST(11174) = (KRO2HO2*0.820)
  RCONST(11175) = (KRO2NO*0.139)
  RCONST(11176) = (KRO2NO*0.861)
  RCONST(11177) = (KRO2NO3)
  RCONST(11178) = (8.80D-13*0.6*RO2)
  RCONST(11179) = (8.80D-13*0.2*RO2)
  RCONST(11180) = (8.80D-13*0.2*RO2)
  RCONST(11181) = (KRO2HO2*0.820)
  RCONST(11182) = (KRO2NO)
  RCONST(11183) = (KRO2NO3)
  RCONST(11184) = (8.80D-13*0.2*RO2)
  RCONST(11185) = (8.80D-13*0.6*RO2)
  RCONST(11186) = (8.80D-13*0.2*RO2)
  RCONST(11187) = (KRO2HO2*0.820)
  RCONST(11188) = (KRO2NO)
  RCONST(11189) = (KRO2NO3)
  RCONST(11190) = (8.80D-13*0.2*RO2)
  RCONST(11191) = (8.80D-13*0.6*RO2)
  RCONST(11192) = (8.80D-13*0.2*RO2)
  RCONST(11193) = (j('ch3o2h'))
  RCONST(11194) = (j('mek'))
  RCONST(11195) = (5.12D-11)
  RCONST(11196) = (KDEC)
  RCONST(11197) = (j('ch3o2h')+j('mek'))
  RCONST(11198) = (4.56D-11)
  RCONST(11199) = (KDEC)
  RCONST(11200) = (j('ch3o2h')+j('mek'))
  RCONST(11201) = (8.31D-11)
  RCONST(11202) = (j('1_c4h9ono2')+j('mek'))
  RCONST(11203) = (1.09D-12)
  RCONST(11204) = (KDEC)
  RCONST(11205) = (j('mek')*2)
  RCONST(11206) = (1.83D-12)
  RCONST(11207) = (j('mek'))
  RCONST(11208) = (3.40D-11)
  RCONST(11209) = (j('ch3o2h'))
  RCONST(11210) = (j('mek'))
  RCONST(11211) = (2.00D-11)
  RCONST(11212) = (1.90D-12*EXP(190/TEMP))
  RCONST(11213) = (KDEC)
  RCONST(11214) = (j('biacet'))
  RCONST(11215) = (1.30D-12)
  RCONST(11216) = (j('mek'))
  RCONST(11217) = (1.13D-11)
  RCONST(11218) = (KRO2HO2*0.820)
  RCONST(11219) = (KRO2NO*0.042)
  RCONST(11220) = (KRO2NO*0.958)
  RCONST(11221) = (KRO2NO3)
  RCONST(11222) = (9.20D-14*0.7*RO2)
  RCONST(11223) = (9.20D-14*0.3*RO2)
  RCONST(11224) = (KRO2HO2*0.820)
  RCONST(11225) = (KRO2NO)
  RCONST(11226) = (KRO2NO3)
  RCONST(11227) = (9.20D-14*0.7*RO2)
  RCONST(11228) = (9.20D-14*0.3*RO2)
  RCONST(11229) = (KRO2HO2*0.820)
  RCONST(11230) = (KRO2NO)
  RCONST(11231) = (KRO2NO3)
  RCONST(11232) = (8.80D-13*0.6*RO2)
  RCONST(11233) = (8.80D-13*0.2*RO2)
  RCONST(11234) = (8.80D-13*0.2*RO2)
  RCONST(11235) = (j('ch3o2h')+j('mek'))
  RCONST(11236) = (1.18D-11)
  RCONST(11237) = (KDEC)
  RCONST(11238) = (j('ch3o2h'))
  RCONST(11239) = (1.25D-11)
  RCONST(11240) = (1.90D-12*EXP(190/TEMP))
  RCONST(11241) = (j('n_c3h7ono2'))
  RCONST(11242) = (1.90D-12)
  RCONST(11243) = (2.58D+11*EXP(-3430/TEMP))
  RCONST(11244) = (7.06D-12)
  RCONST(11245) = (j('n_c3h7cho_hco'))
  RCONST(11246) = (KNO3AL*8.5)
  RCONST(11247) = (2.31D-11)
  RCONST(11248) = (7.08D-12)
  RCONST(11249) = (j('ch3o2h'))
  RCONST(11250) = (1.05D-11)
  RCONST(11251) = (KBPAN)
  RCONST(11252) = (3.38D-12)
  RCONST(11253) = (j('ch3o2h')+j('mek'))
  RCONST(11254) = (9.56D-11)
  RCONST(11255) = (j('mek'))
  RCONST(11256) = (5.86D-12)
  RCONST(11257) = (KDEC)
  RCONST(11258) = (j('mek'))
  RCONST(11259) = (4.65D-11)
  RCONST(11260) = (j('mek')*2)
  RCONST(11261) = (1.20D-11)
  RCONST(11262) = (KRO2HO2*0.859)
  RCONST(11263) = (KRO2NO)
  RCONST(11264) = (KRO2NO3)
  RCONST(11265) = (8.80D-13*0.6*RO2)
  RCONST(11266) = (8.80D-13*0.2*RO2)
  RCONST(11267) = (8.80D-13*0.2*RO2)
  RCONST(11268) = (j('ch3o2h')+j('mek'))
  RCONST(11269) = (5.27D-11)
  RCONST(11270) = (KDEC)
  RCONST(11271) = (j('ch3o2h')+j('mek'))
  RCONST(11272) = (9.70D-11)
  RCONST(11273) = (j('mek'))
  RCONST(11274) = (7.27D-12)
  RCONST(11275) = (2.00D+14*EXP(-4714/TEMP))
  RCONST(11276) = (j('mek')*2)
  RCONST(11277) = (1.34D-11)
  RCONST(11278) = (j('mek'))
  RCONST(11279) = (4.79D-11)
  RCONST(11280) = (KRO2HO2*0.890)
  RCONST(11281) = (KRO2NO)
  RCONST(11282) = (KRO2NO3)
  RCONST(11283) = (8.80D-13*0.6*RO2)
  RCONST(11284) = (8.80D-13*0.2*RO2)
  RCONST(11285) = (8.80D-13*0.2*RO2)
  RCONST(11286) = (j('ch3o2h')+j('mek'))
  RCONST(11287) = (5.41D-11)
  RCONST(11288) = (KDEC)
  RCONST(11289) = (j('ch3o2h'))
  RCONST(11290) = (2.92D-11)
  RCONST(11291) = (KDEC)
  RCONST(11292) = (j('ch3o2h')+j('mek'))
  RCONST(11293) = (9.84D-11)
  RCONST(11294) = (j('mek'))
  RCONST(11295) = (8.68D-12)
  RCONST(11296) = (2.00D+14*EXP(-4714/TEMP))
  RCONST(11297) = (j('mek')*2)
  RCONST(11298) = (1.54D-11)
  RCONST(11299) = (j('mek'))
  RCONST(11300) = (4.93D-11)
  RCONST(11301) = (KRO2HO2*0.914)
  RCONST(11302) = (KRO2NO)
  RCONST(11303) = (KRO2NO3)
  RCONST(11304) = (8.80D-13*0.6*RO2)
  RCONST(11305) = (8.80D-13*0.2*RO2)
  RCONST(11306) = (8.80D-13*0.2*RO2)
  RCONST(11307) = (j('ch3o2h')+j('mek'))
  RCONST(11308) = (5.55D-11)
  RCONST(11309) = (KDEC)
  RCONST(11310) = (j('ch3o2h'))
  RCONST(11311) = (3.06D-11)
  RCONST(11312) = (KDEC)
  RCONST(11313) = (j('ch3o2h')+j('mek'))
  RCONST(11314) = (9.85D-11)
  RCONST(11315) = (j('mek'))
  RCONST(11316) = (1.01D-11)
  RCONST(11317) = (2.00D+14*EXP(-4714/TEMP))
  RCONST(11318) = (j('mek')*2)
  RCONST(11319) = (1.55D-11)
  RCONST(11320) = (j('mek'))
  RCONST(11321) = (4.94D-11)
  RCONST(11322) = (KRO2HO2*0.932)
  RCONST(11323) = (KRO2NO)
  RCONST(11324) = (KRO2NO3)
  RCONST(11325) = (8.80D-13*0.6*RO2)
  RCONST(11326) = (8.80D-13*0.2*RO2)
  RCONST(11327) = (8.80D-13*0.2*RO2)
  RCONST(11328) = (j('ch3o2h')+j('mek'))
  RCONST(11329) = (5.69D-11)
  RCONST(11330) = (KDEC)
  RCONST(11331) = (j('ch3o2h'))
  RCONST(11332) = (3.20D-11)
  RCONST(11333) = (KDEC)
  RCONST(11334) = (j('ch3o2h')+j('mek'))
  RCONST(11335) = (9.99D-11)
  RCONST(11336) = (j('mek'))
  RCONST(11337) = (1.15D-11)
  RCONST(11338) = (2.00D+14*EXP(-4714/TEMP))
  RCONST(11339) = (j('mek')*2)
  RCONST(11340) = (1.69D-11)
  RCONST(11341) = (j('mek'))
  RCONST(11342) = (5.08D-11)
  RCONST(11343) = (KAPHO2*0.15)
  RCONST(11344) = (KAPHO2*0.41)
  RCONST(11345) = (KAPHO2*0.44)
  RCONST(11346) = (KAPNO)
  RCONST(11347) = (KFPAN)
  RCONST(11348) = (KRO2NO3*1.74)
  RCONST(11349) = (1.00D-11*0.3*RO2)
  RCONST(11350) = (1.00D-11*0.7*RO2)
  RCONST(11351) = (KRO2HO2*0.947)
  RCONST(11352) = (KRO2NO)
  RCONST(11353) = (KRO2NO3)
  RCONST(11354) = (8.80D-13*0.6*RO2)
  RCONST(11355) = (8.80D-13*0.2*RO2)
  RCONST(11356) = (8.80D-13*0.2*RO2)
  RCONST(11357) = (j('ch3o2h')+j('mek'))
  RCONST(11358) = (5.83D-11)
  RCONST(11359) = (KDEC)
  RCONST(11360) = (4.80D-11)
  RCONST(11361) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(11362) = (2.71D-11)
  RCONST(11363) = (j('1_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(11364) = (KDEC)
  RCONST(11365) = (3.89D-11)
  RCONST(11366) = (9.51D-11)
  RCONST(11367) = (j('ch3o2h')+j('ch3coch2ono2'))
  RCONST(11368) = (KDEC)
  RCONST(11369) = (KNO3AL*8.0)
  RCONST(11370) = (3.44D-11)
  RCONST(11371) = (j('ch3cocho'))
  RCONST(11372) = (1.16D-12)
  RCONST(11373) = (2.19D-11)
  RCONST(11374) = (KRO2HO2*0.625)
  RCONST(11375) = (KRO2NO)
  RCONST(11376) = (KRO2NO3)
  RCONST(11377) = (8.80D-13*0.2*RO2)
  RCONST(11378) = (8.80D-13*0.6*RO2)
  RCONST(11379) = (8.80D-13*0.2*RO2)
  RCONST(11380) = (KRO2HO2*0.770)
  RCONST(11381) = (KRO2NO)
  RCONST(11382) = (KRO2NO3)
  RCONST(11383) = (8.00D-13*RO2)
  RCONST(11384) = (KRO2HO2*0.770)
  RCONST(11385) = (KRO2NO)
  RCONST(11386) = (KRO2NO3)
  RCONST(11387) = (8.00D-13*RO2)
  RCONST(11388) = (9.00D-13)
  RCONST(11389) = (j('ch3o2h'))
  RCONST(11390) = (1.90D-12*EXP(190/TEMP))
  RCONST(11391) = (j('ch3o2h'))
  RCONST(11392) = (KDEC)
  RCONST(11393) = (1.90D-12*EXP(190/TEMP))
  RCONST(11394) = (j('ch3o2h'))
  RCONST(11395) = (KDEC)
  RCONST(11396) = (6.68D-11)
  RCONST(11397) = (j('ch3o2h'))
  RCONST(11398) = (KDEC)
  RCONST(11399) = (1.23D-10)
  RCONST(11400) = (j('ch3o2h'))
  RCONST(11401) = (KDEC)
  RCONST(11402) = (6.07D-11)
  RCONST(11403) = (9.18D-11)
  RCONST(11404) = (8.56D-11)
  RCONST(11405) = (j('ch3o2h'))
  RCONST(11406) = (KDEC)
  RCONST(11407) = (1.42D-10)
  RCONST(11408) = (j('ch3o2h'))
  RCONST(11409) = (KDEC)
  RCONST(11410) = (7.95D-11)
  RCONST(11411) = (1.11D-10)
  RCONST(11412) = (KRO2HO2*0.820)
  RCONST(11413) = (KRO2NO)
  RCONST(11414) = (KRO2NO3)
  RCONST(11415) = (8.00D-13*RO2)
  RCONST(11416) = (KRO2HO2*0.820)
  RCONST(11417) = (KRO2NO)
  RCONST(11418) = (KRO2NO3)
  RCONST(11419) = (8.00D-13*RO2)
  RCONST(11420) = (1.53D-12)
  RCONST(11421) = (j('ch3o2h'))
  RCONST(11422) = (1.90D-12*EXP(190/TEMP))
  RCONST(11423) = (j('ch3o2h'))
  RCONST(11424) = (KDEC)
  RCONST(11425) = (1.90D-12*EXP(190/TEMP))
  RCONST(11426) = (j('ch3o2h'))
  RCONST(11427) = (KDEC)
  RCONST(11428) = (KNO3AL*5.5)
  RCONST(11429) = (1.72D-11)
  RCONST(11430) = (j('ch3cocho')+j('biacet')*2)
  RCONST(11431) = (KNO3AL*5.5)
  RCONST(11432) = (7.09D-11)
  RCONST(11433) = (j('n_c3h7cho_hco'))
  RCONST(11434) = (3.59D-12)
  RCONST(11435) = (j('ch3o2h'))
  RCONST(11436) = (KDEC)
  RCONST(11437) = (8.76D-13)
  RCONST(11438) = (2.90D-12)
  RCONST(11439) = (j('mek'))
  RCONST(11440) = (KRO2HO2)
  RCONST(11441) = (KRO2NO)
  RCONST(11442) = (KRO2NO3)
  RCONST(11443) = (2.00D-12*RO2)
  RCONST(11444) = (KRO2HO2*0.859)
  RCONST(11445) = (KRO2NO)
  RCONST(11446) = (KRO2NO3)
  RCONST(11447) = (8.00D-13*RO2)
  RCONST(11448) = (KRO2HO2*0.859)
  RCONST(11449) = (KRO2NO)
  RCONST(11450) = (KRO2NO3)
  RCONST(11451) = (8.00D-13*RO2)
  RCONST(11452) = (1.53D-12)
  RCONST(11453) = (j('ch3o2h'))
  RCONST(11454) = (1.05D-10)
  RCONST(11455) = (j('ch3o2h'))
  RCONST(11456) = (KDEC)
  RCONST(11457) = (1.61D-10)
  RCONST(11458) = (j('ch3o2h'))
  RCONST(11459) = (KDEC)
  RCONST(11460) = (9.85D-11)
  RCONST(11461) = (1.30D-10)
  RCONST(11462) = (1.90D-12*EXP(190/TEMP))
  RCONST(11463) = (j('ch3o2h'))
  RCONST(11464) = (KDEC)
  RCONST(11465) = (1.90D-12*EXP(190/TEMP))
  RCONST(11466) = (j('ch3o2h'))
  RCONST(11467) = (KDEC)
  RCONST(11468) = (6.66D-11)
  RCONST(11469) = (j('biacet'))
  RCONST(11470) = (KNO3AL*8.5)
  RCONST(11471) = (2.68D-11)
  RCONST(11472) = (j('n_c3h7cho_hco'))
  RCONST(11473) = (KRO2HO2*0.706)
  RCONST(11474) = (KRO2NO)
  RCONST(11475) = (KRO2NO3)
  RCONST(11476) = (6.00D-13*RO2)
  RCONST(11477) = (KNO3AL*5.5)
  RCONST(11478) = (2.15D-11)
  RCONST(11479) = (j('n_c3h7cho_hco'))
  RCONST(11480) = (KRO2HO2*0.706)
  RCONST(11481) = (KRO2NO)
  RCONST(11482) = (KRO2NO3)
  RCONST(11483) = (9.20D-14*RO2*0.70)
  RCONST(11484) = (9.20D-14*RO2*0.30)
  RCONST(11485) = (KRO2HO2*0.859)
  RCONST(11486) = (KRO2NO)
  RCONST(11487) = (KRO2NO3)
  RCONST(11488) = (8.00D-13*RO2)
  RCONST(11489) = (KRO2HO2*0.859)
  RCONST(11490) = (KRO2NO)
  RCONST(11491) = (KRO2NO3)
  RCONST(11492) = (8.00D-13*RO2)
  RCONST(11493) = (1.53D-12)
  RCONST(11494) = (j('ch3o2h'))
  RCONST(11495) = (7.54D-11)
  RCONST(11496) = (j('ch3o2h'))
  RCONST(11497) = (KDEC)
  RCONST(11498) = (9.48D-11)
  RCONST(11499) = (j('ch3o2h'))
  RCONST(11500) = (KDEC)
  RCONST(11501) = (9.13D-11)
  RCONST(11502) = (1.90D-12*EXP(190/TEMP))
  RCONST(11503) = (j('ch3o2h'))
  RCONST(11504) = (KDEC)
  RCONST(11505) = (1.90D-12*EXP(190/TEMP))
  RCONST(11506) = (j('ch3o2h'))
  RCONST(11507) = (KDEC)
  RCONST(11508) = (KRO2HO2*0.820)
  RCONST(11509) = (KRO2NO)
  RCONST(11510) = (KRO2NO3)
  RCONST(11511) = (9.20D-14*RO2)
  RCONST(11512) = (KDEC)
  RCONST(11513) = (KRO2HO2*0.859)
  RCONST(11514) = (KRO2NO)
  RCONST(11515) = (KRO2NO3)
  RCONST(11516) = (8.00D-13*RO2)
  RCONST(11517) = (KRO2HO2*0.859)
  RCONST(11518) = (KRO2NO)
  RCONST(11519) = (KRO2NO3)
  RCONST(11520) = (8.00D-13*RO2)
  RCONST(11521) = (1.53D-12)
  RCONST(11522) = (j('ch3o2h'))
  RCONST(11523) = (7.54D-11)
  RCONST(11524) = (j('ch3o2h'))
  RCONST(11525) = (KDEC)
  RCONST(11526) = (9.48D-11)
  RCONST(11527) = (j('ch3o2h'))
  RCONST(11528) = (KDEC)
  RCONST(11529) = (9.13D-11)
  RCONST(11530) = (1.90D-12*EXP(190/TEMP))
  RCONST(11531) = (j('ch3o2h'))
  RCONST(11532) = (KDEC)
  RCONST(11533) = (1.90D-12*EXP(190/TEMP))
  RCONST(11534) = (j('ch3o2h'))
  RCONST(11535) = (KDEC)
  RCONST(11536) = (KRO2HO2*0.859)
  RCONST(11537) = (KRO2NO)
  RCONST(11538) = (KRO2NO3)
  RCONST(11539) = (8.00D-13*RO2)
  RCONST(11540) = (KRO2HO2*0.859)
  RCONST(11541) = (KRO2NO)
  RCONST(11542) = (KRO2NO3)
  RCONST(11543) = (8.00D-13*RO2)
  RCONST(11544) = (1.53D-12)
  RCONST(11545) = (j('ch3o2h'))
  RCONST(11546) = (8.74D-11)
  RCONST(11547) = (j('ch3o2h'))
  RCONST(11548) = (KDEC)
  RCONST(11549) = (1.46D-10)
  RCONST(11550) = (j('ch3o2h'))
  RCONST(11551) = (KDEC)
  RCONST(11552) = (8.32D-11)
  RCONST(11553) = (1.15D-10)
  RCONST(11554) = (1.90D-12*EXP(190/TEMP))
  RCONST(11555) = (j('ch3o2h'))
  RCONST(11556) = (KDEC)
  RCONST(11557) = (1.90D-12*EXP(190/TEMP))
  RCONST(11558) = (j('ch3o2h'))
  RCONST(11559) = (KDEC)
  RCONST(11560) = (3.14D-11)
  RCONST(11561) = (j('biacet'))
  RCONST(11562) = (j('biacet')*2)
  RCONST(11563) = (KNO3AL*8.5)
  RCONST(11564) = (4.35D-11)
  RCONST(11565) = (j('ch3cocho'))
  RCONST(11566) = (6.73D-12)
  RCONST(11567) = (8.68D-12)
  RCONST(11568) = (j('mek'))
  RCONST(11569) = (j('ch3o2h'))
  RCONST(11570) = (2.79D-12)
  RCONST(11571) = (KBPAN)
  RCONST(11572) = (4.66D-12)
  RCONST(11573) = (j('ch3o2h'))
  RCONST(11574) = (KDEC)
  RCONST(11575) = (KRO2HO2*0.90)
  RCONST(11576) = (KRO2NO)
  RCONST(11577) = (KRO2NO3)
  RCONST(11578) = (8.00D-13*RO2)
  RCONST(11579) = (KRO2HO2*0.90)
  RCONST(11580) = (KRO2NO)
  RCONST(11581) = (KRO2NO3)
  RCONST(11582) = (8.00D-13*RO2)
  RCONST(11583) = (1.53D-12)
  RCONST(11584) = (j('ch3o2h'))
  RCONST(11585) = (8.89D-11)
  RCONST(11586) = (j('ch3o2h'))
  RCONST(11587) = (KDEC)
  RCONST(11588) = (1.43D-10)
  RCONST(11589) = (j('ch3o2h'))
  RCONST(11590) = (KDEC)
  RCONST(11591) = (8.44D-11)
  RCONST(11592) = (1.15D-10)
  RCONST(11593) = (1.90D-12*EXP(190/TEMP))
  RCONST(11594) = (j('ch3o2h'))
  RCONST(11595) = (KDEC)
  RCONST(11596) = (1.90D-12*EXP(190/TEMP))
  RCONST(11597) = (j('ch3o2h'))
  RCONST(11598) = (KDEC)
  RCONST(11599) = (KAPHO2*0.56)
  RCONST(11600) = (KAPHO2*0.44)
  RCONST(11601) = (KAPNO)
  RCONST(11602) = (KFPAN)
  RCONST(11603) = (KRO2NO3*1.74)
  RCONST(11604) = (1.00D-11*RO2)
  RCONST(11605) = (KNO3AL*5.5)
  RCONST(11606) = (1.67D-11)
  RCONST(11607) = (j('biacet')+j('ch3cocho'))
  RCONST(11608) = (KNO3AL*8.5)
  RCONST(11609) = (4.55D-11)
  RCONST(11610) = (j('ch3cocho'))
  RCONST(11611) = (8.14D-12)
  RCONST(11612) = (1.22D-11)
  RCONST(11613) = (j('mek'))
  RCONST(11614) = (j('ch3o2h'))
  RCONST(11615) = (8.99D-12)
  RCONST(11616) = (KBPAN)
  RCONST(11617) = (KRO2HO2*0.90)
  RCONST(11618) = (KRO2NO)
  RCONST(11619) = (KRO2NO3)
  RCONST(11620) = (8.00D-13*RO2)
  RCONST(11621) = (KRO2HO2*0.90)
  RCONST(11622) = (KRO2NO)
  RCONST(11623) = (KRO2NO3)
  RCONST(11624) = (8.00D-13*RO2)
  RCONST(11625) = (1.53D-12)
  RCONST(11626) = (j('ch3o2h'))
  RCONST(11627) = (8.95D-11)
  RCONST(11628) = (j('ch3o2h'))
  RCONST(11629) = (KDEC)
  RCONST(11630) = (1.46D-10)
  RCONST(11631) = (j('ch3o2h'))
  RCONST(11632) = (KDEC)
  RCONST(11633) = (8.34D-11)
  RCONST(11634) = (1.14D-10)
  RCONST(11635) = (1.90D-12*EXP(190/TEMP))
  RCONST(11636) = (j('ch3o2h'))
  RCONST(11637) = (KDEC)
  RCONST(11638) = (1.90D-12*EXP(190/TEMP))
  RCONST(11639) = (j('ch3o2h'))
  RCONST(11640) = (KDEC)
  RCONST(11641) = (KAPHO2*0.44)
  RCONST(11642) = (KAPHO2*0.56)
  RCONST(11643) = (KAPNO)
  RCONST(11644) = (KFPAN)
  RCONST(11645) = (KRO2NO3*1.74)
  RCONST(11646) = (1.00D-11*RO2)
  RCONST(11647) = (KNO3AL*8.5)
  RCONST(11648) = (1.47D-11)
  RCONST(11649) = (j('biacet')+j('ch3cocho'))
  RCONST(11650) = (KNO3AL*8.5)
  RCONST(11651) = (4.76D-11)
  RCONST(11652) = (j('ch3cocho'))
  RCONST(11653) = (8.13D-12)
  RCONST(11654) = (1.01D-11)
  RCONST(11655) = (j('mek'))
  RCONST(11656) = (j('ch3o2h'))
  RCONST(11657) = (6.84D-12)
  RCONST(11658) = (KBPAN)
  RCONST(11659) = (1.00D-12)
  RCONST(11660) = (7.42D-12)
  RCONST(11661) = (KRO2HO2*0.90)
  RCONST(11662) = (KRO2NO)
  RCONST(11663) = (KRO2NO3)
  RCONST(11664) = (8.00D-13*RO2)
  RCONST(11665) = (KRO2HO2*0.90)
  RCONST(11666) = (KRO2NO)
  RCONST(11667) = (KRO2NO3)
  RCONST(11668) = (8.00D-13*RO2)
  RCONST(11669) = (1.53D-12)
  RCONST(11670) = (j('ch3o2h'))
  RCONST(11671) = (1.90D-12*EXP(190/TEMP))
  RCONST(11672) = (j('ch3o2h'))
  RCONST(11673) = (KDEC)
  RCONST(11674) = (1.90D-12*EXP(190/TEMP))
  RCONST(11675) = (j('ch3o2h'))
  RCONST(11676) = (KDEC)
  RCONST(11677) = (6.20D-12)
  RCONST(11678) = (j('mek'))
  RCONST(11679) = (KRO2HO2*0.859)
  RCONST(11680) = (KRO2NO)
  RCONST(11681) = (KRO2NO3)
  RCONST(11682) = (9.20D-14*RO2)
  RCONST(11683) = (KRO2HO2*0.90)
  RCONST(11684) = (KRO2NO)
  RCONST(11685) = (KRO2NO3)
  RCONST(11686) = (8.00D-13*RO2)
  RCONST(11687) = (KRO2HO2*0.90)
  RCONST(11688) = (KRO2NO)
  RCONST(11689) = (KRO2NO3)
  RCONST(11690) = (8.00D-13*RO2)
  RCONST(11691) = (1.53D-12)
  RCONST(11692) = (j('ch3o2h'))
  RCONST(11693) = (9.43D-11)
  RCONST(11694) = (j('ch3o2h'))
  RCONST(11695) = (KDEC)
  RCONST(11696) = (1.14D-10)
  RCONST(11697) = (j('ch3o2h'))
  RCONST(11698) = (KDEC)
  RCONST(11699) = (1.10D-10)
  RCONST(11700) = (1.90D-12*EXP(190/TEMP))
  RCONST(11701) = (j('ch3o2h'))
  RCONST(11702) = (KDEC)
  RCONST(11703) = (1.90D-12*EXP(190/TEMP))
  RCONST(11704) = (j('ch3o2h'))
  RCONST(11705) = (KDEC)
  RCONST(11706) = (KRO2HO2*0.859)
  RCONST(11707) = (KRO2NO)
  RCONST(11708) = (KRO2NO3)
  RCONST(11709) = (9.20D-14*RO2)
  RCONST(11710) = (9.59D-12)
  RCONST(11711) = (j('ch3o2h')+j('biacet'))
  RCONST(11712) = (KDEC)
  RCONST(11713) = (KRO2HO2*0.90)
  RCONST(11714) = (KRO2NO)
  RCONST(11715) = (KRO2NO3)
  RCONST(11716) = (8.00D-13*RO2)
  RCONST(11717) = (KRO2HO2*0.90)
  RCONST(11718) = (KRO2NO)
  RCONST(11719) = (KRO2NO3)
  RCONST(11720) = (8.00D-13*RO2)
  RCONST(11721) = (1.53D-12)
  RCONST(11722) = (j('ch3o2h'))
  RCONST(11723) = (1.06D-10)
  RCONST(11724) = (j('ch3o2h'))
  RCONST(11725) = (KDEC)
  RCONST(11726) = (1.63D-10)
  RCONST(11727) = (j('ch3o2h'))
  RCONST(11728) = (KDEC)
  RCONST(11729) = (1.00D-10)
  RCONST(11730) = (1.31D-10)
  RCONST(11731) = (1.90D-12*EXP(190/TEMP))
  RCONST(11732) = (j('ch3o2h'))
  RCONST(11733) = (KDEC)
  RCONST(11734) = (1.90D-12*EXP(190/TEMP))
  RCONST(11735) = (j('ch3o2h'))
  RCONST(11736) = (KDEC)
  RCONST(11737) = (KRO2HO2*0.90)
  RCONST(11738) = (KRO2NO)
  RCONST(11739) = (KRO2NO3)
  RCONST(11740) = (8.00D-13*RO2)
  RCONST(11741) = (KRO2HO2*0.90)
  RCONST(11742) = (KRO2NO)
  RCONST(11743) = (KRO2NO3)
  RCONST(11744) = (8.00D-13*RO2)
  RCONST(11745) = (1.53D-12)
  RCONST(11746) = (j('ch3o2h'))
  RCONST(11747) = (7.71D-11)
  RCONST(11748) = (j('ch3o2h'))
  RCONST(11749) = (KDEC)
  RCONST(11750) = (9.65D-11)
  RCONST(11751) = (j('ch3o2h'))
  RCONST(11752) = (KDEC)
  RCONST(11753) = (9.31D-11)
  RCONST(11754) = (1.90D-12*EXP(190/TEMP))
  RCONST(11755) = (j('ch3o2h'))
  RCONST(11756) = (KDEC)
  RCONST(11757) = (1.90D-12*EXP(190/TEMP))
  RCONST(11758) = (j('ch3o2h'))
  RCONST(11759) = (KDEC)
  RCONST(11760) = (KRO2HO2*0.90)
  RCONST(11761) = (KRO2NO)
  RCONST(11762) = (KRO2NO3)
  RCONST(11763) = (8.00D-13*RO2)
  RCONST(11764) = (KRO2HO2*0.90)
  RCONST(11765) = (KRO2NO)
  RCONST(11766) = (KRO2NO3)
  RCONST(11767) = (8.00D-13*RO2)
  RCONST(11768) = (1.53D-12)
  RCONST(11769) = (j('ch3o2h'))
  RCONST(11770) = (7.71D-11)
  RCONST(11771) = (j('ch3o2h'))
  RCONST(11772) = (KDEC)
  RCONST(11773) = (9.81D-11)
  RCONST(11774) = (j('ch3o2h'))
  RCONST(11775) = (KDEC)
  RCONST(11776) = (9.46D-11)
  RCONST(11777) = (1.90D-12*EXP(190/TEMP))
  RCONST(11778) = (j('ch3o2h'))
  RCONST(11779) = (KDEC)
  RCONST(11780) = (1.90D-12*EXP(190/TEMP))
  RCONST(11781) = (j('ch3o2h'))
  RCONST(11782) = (KDEC)
  RCONST(11783) = (KNO3AL*8.5)
  RCONST(11784) = (3.13D-11)
  RCONST(11785) = (j('n_c3h7cho_hco'))
  RCONST(11786) = (KRO2HO2*0.770)
  RCONST(11787) = (KRO2NO)
  RCONST(11788) = (KRO2NO3)
  RCONST(11789) = (2.00D-12*RO2)
  RCONST(11790) = (1.53D-12)
  RCONST(11791) = (1.65D-11)
  RCONST(11792) = (j('ch3o2h')+j('biacet'))
  RCONST(11793) = (KDEC)
  RCONST(11794) = (j('ch3o2h'))
  RCONST(11795) = (9.43D-12)
  RCONST(11796) = (KBPAN)
  RCONST(11797) = (5.83D-12)
  RCONST(11798) = (KAPHO2*0.15)
  RCONST(11799) = (KAPHO2*0.41)
  RCONST(11800) = (KAPHO2*0.44)
  RCONST(11801) = (KAPNO)
  RCONST(11802) = (KFPAN)
  RCONST(11803) = (KRO2NO3*1.74)
  RCONST(11804) = (1.00D-11*0.3*RO2)
  RCONST(11805) = (1.00D-11*0.7*RO2)
  RCONST(11806) = (4.11D-12)
  RCONST(11807) = (j('ch3o2h'))
  RCONST(11808) = (5.10D-13)
  RCONST(11809) = (KBPAN+j('ch3coch2ono2')*10)
  RCONST(11810) = (KAPHO2*0.44)
  RCONST(11811) = (KAPHO2*0.56)
  RCONST(11812) = (KAPNO)
  RCONST(11813) = (KFPAN)
  RCONST(11814) = (KRO2NO3*1.74)
  RCONST(11815) = (1.00D-11*RO2)
  RCONST(11816) = (j('i_c3h7cho'))
  RCONST(11817) = (j('mek'))
  RCONST(11818) = (2.73D-11)
  RCONST(11819) = (KRO2HO2*0.706)
  RCONST(11820) = (KRO2NO)
  RCONST(11821) = (KRO2NO3)
  RCONST(11822) = (2.00D-12*RO2)
  RCONST(11823) = (1.20D-15)
  RCONST(11824) = (1.00D-14)
  RCONST(11825) = (1.00D-15)
  RCONST(11826) = (7.00D-14)
  RCONST(11827) = (6.00D-18*H2O)
  RCONST(11828) = (KAPHO2*0.44)
  RCONST(11829) = (KAPHO2*0.56)
  RCONST(11830) = (KAPNO)
  RCONST(11831) = (KFPAN)
  RCONST(11832) = (KRO2NO3*1.74)
  RCONST(11833) = (1.00D-11*RO2)
  RCONST(11834) = (3.42D-11)
  RCONST(11835) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(11836) = (j('ch3o2h'))
  RCONST(11837) = (KDEC)
  RCONST(11838) = (2.49D-11)
  RCONST(11839) = (j('ch3coch2ono2')*10)
  RCONST(11840) = (j('ch3coch2ono2')*0.91)
  RCONST(11841) = (2.41D-11)
  RCONST(11842) = (j('ch3coch2ono2')*10)
  RCONST(11843) = (1.85D-11)
  RCONST(11844) = (j('ch3coch2ono2')*10)
  RCONST(11845) = (1.85D-11)
  RCONST(11846) = (1.35D-11)
  RCONST(11847) = (j('ch3cocho'))
  RCONST(11848) = (KAPHO2*0.56)
  RCONST(11849) = (KAPHO2*0.44)
  RCONST(11850) = (KAPNO)
  RCONST(11851) = (KFPAN)
  RCONST(11852) = (KRO2NO3*1.74)
  RCONST(11853) = (1.00D-11*RO2)
  RCONST(11854) = (3.42D-11)
  RCONST(11855) = (j('ch3o2h'))
  RCONST(11856) = (j('ch3o2h'))
  RCONST(11857) = (j('n_c3h7cho_hco'))
  RCONST(11858) = (KDEC)
  RCONST(11859) = (KAPHO2*0.44)
  RCONST(11860) = (KAPHO2*0.56)
  RCONST(11861) = (KAPNO)
  RCONST(11862) = (KFPAN)
  RCONST(11863) = (KRO2NO3*1.6)
  RCONST(11864) = (1.00D-11*RO2)
  RCONST(11865) = (KAPHO2*0.56)
  RCONST(11866) = (KAPHO2*0.44)
  RCONST(11867) = (KAPNO)
  RCONST(11868) = (KFPAN)
  RCONST(11869) = (KRO2NO3*1.74)
  RCONST(11870) = (1.00D-11*RO2)
  RCONST(11871) = (2.53D-11*0.86)
  RCONST(11872) = (2.53D-11*0.14)
  RCONST(11873) = (j('ch3coch2ono2')*10)
  RCONST(11874) = (KAPHO2*0.15)
  RCONST(11875) = (KAPHO2*0.41)
  RCONST(11876) = (KAPHO2*0.44)
  RCONST(11877) = (KAPNO)
  RCONST(11878) = (KFPAN)
  RCONST(11879) = (KRO2NO3*1.74)
  RCONST(11880) = (KRO2NO3*1.74)
  RCONST(11881) = (1.00D-11*0.3*RO2)
  RCONST(11882) = (1.00D-11*0.7*RO2)
  RCONST(11883) = (2.58D-11)
  RCONST(11884) = (j('ch3coch2ono2')*0.91)
  RCONST(11885) = (KAPHO2*0.44)
  RCONST(11886) = (KAPHO2*0.15)
  RCONST(11887) = (KAPHO2*0.41)
  RCONST(11888) = (KAPNO)
  RCONST(11889) = (KFPAN)
  RCONST(11890) = (KRO2NO3*1.74)
  RCONST(11891) = (1.00D-11*0.7*RO2)
  RCONST(11892) = (1.00D-11*0.3*RO2)
  RCONST(11893) = (KAPHO2*0.44)
  RCONST(11894) = (KAPHO2*0.15)
  RCONST(11895) = (KAPHO2*0.41)
  RCONST(11896) = (KAPNO)
  RCONST(11897) = (KFPAN)
  RCONST(11898) = (KRO2NO3*1.74)
  RCONST(11899) = (1.00D-11*0.7*RO2)
  RCONST(11900) = (1.00D-11*0.3*RO2)
  RCONST(11901) = (3.79D-12)
  RCONST(11902) = (KAPHO2*0.44)
  RCONST(11903) = (KAPHO2*0.15)
  RCONST(11904) = (KAPHO2*0.41)
  RCONST(11905) = (KAPNO)
  RCONST(11906) = (KFPAN)
  RCONST(11907) = (KRO2NO3*1.74)
  RCONST(11908) = (1.00D-11*0.7*RO2)
  RCONST(11909) = (1.00D-11*0.3*RO2)
  RCONST(11910) = (2.49D-12)
  RCONST(11911) = (j('ch3o2h'))
  RCONST(11912) = (5.57D-12*0.68)
  RCONST(11913) = (5.57D-12*0.32)
  RCONST(11914) = (KBPAN)
  RCONST(11915) = (1.97D-12)
  RCONST(11916) = (1.31D-11*0.667)
  RCONST(11917) = (1.31D-11*0.333)
  RCONST(11918) = (KRO2HO2*0.706)
  RCONST(11919) = (KRO2NO*0.072)
  RCONST(11920) = (KRO2NO*0.928)
  RCONST(11921) = (KRO2NO3)
  RCONST(11922) = (8.00D-13*RO2*0.8)
  RCONST(11923) = (8.00D-13*RO2*0.2)
  RCONST(11924) = (KRO2HO2*0.706)
  RCONST(11925) = (KRO2NO)
  RCONST(11926) = (KRO2NO3)
  RCONST(11927) = (9.20D-14*RO2)
  RCONST(11928) = (KAPHO2*0.15)
  RCONST(11929) = (KAPHO2*0.41)
  RCONST(11930) = (KAPHO2*0.44)
  RCONST(11931) = (KAPNO)
  RCONST(11932) = (KFPAN)
  RCONST(11933) = (KRO2NO3*1.74)
  RCONST(11934) = (1.00D-11*RO2*0.3)
  RCONST(11935) = (1.00D-11*RO2*0.7)
  RCONST(11936) = (KDEC*0.18)
  RCONST(11937) = (KDEC*0.82)
  RCONST(11938) = (KRO2HO2*0.625)
  RCONST(11939) = (KRO2NO)
  RCONST(11940) = (KRO2NO3)
  RCONST(11941) = (K14ISOM1)
  RCONST(11942) = (9.20D-14*RO2*0.7)
  RCONST(11943) = (9.20D-14*RO2*0.3)
  RCONST(11944) = (4.55D-12)
  RCONST(11945) = (j('ch3o2h'))
  RCONST(11946) = (9.55D-13)
  RCONST(11947) = (KBPAN)
  RCONST(11948) = (6.65D-11)
  RCONST(11949) = (1.90D-12*EXP(190/TEMP))
  RCONST(11950) = (j('ch3o2h'))
  RCONST(11951) = (2.26D-13)
  RCONST(11952) = (j('n_c3h7ono2'))
  RCONST(11953) = (KDEC)
  RCONST(11954) = (1.74D-11)
  RCONST(11955) = (3.95D-11)
  RCONST(11956) = (j('ch3o2h'))
  RCONST(11957) = (KDEC)
  RCONST(11958) = (KNO3AL*2.4)
  RCONST(11959) = (2.10D-11)
  RCONST(11960) = (j('n_c3h7cho_hco'))
  RCONST(11961) = (KAPHO2*0.44)
  RCONST(11962) = (KAPHO2*0.56)
  RCONST(11963) = (KAPNO)
  RCONST(11964) = (KFPAN)
  RCONST(11965) = (KRO2NO3*1.74)
  RCONST(11966) = (1.00D-11*RO2)
  RCONST(11967) = (j('ch3o2h')+j('mek'))
  RCONST(11968) = (j('biacet'))
  RCONST(11969) = (1.30D-11)
  RCONST(11970) = (j('ch3o2h'))
  RCONST(11971) = (2.56D-11)
  RCONST(11972) = (1.90D-12*EXP(190/TEMP))
  RCONST(11973) = (7.29D-12)
  RCONST(11974) = (2.00D+14*EXP(-5538/TEMP))
  RCONST(11975) = (j('n_c3h7cho_hco'))
  RCONST(11976) = (KNO3AL*4.0)
  RCONST(11977) = (3.19D-11)
  RCONST(11978) = (2.01D-11)
  RCONST(11979) = (KAPHO2*0.44)
  RCONST(11980) = (KAPHO2*0.56)
  RCONST(11981) = (KAPNO)
  RCONST(11982) = (KFPAN)
  RCONST(11983) = (KRO2NO3*1.74)
  RCONST(11984) = (1.00D-11*RO2)
  RCONST(11985) = (1.41D-11)
  RCONST(11986) = (j('ch3o2h'))
  RCONST(11987) = (1.75D-11)
  RCONST(11988) = (KBPAN)
  RCONST(11989) = (4.50D-12)
  RCONST(11990) = (2.69D-11)
  RCONST(11991) = (j('mek')+j('n_c3h7cho_hco'))
  RCONST(11992) = (3.05D-11)
  RCONST(11993) = (j('ch3o2h')+j('mek'))
  RCONST(11994) = (2.69D-11)
  RCONST(11995) = (KBPAN)
  RCONST(11996) = (3.83D-11)
  RCONST(11997) = (j('ch3o2h')+j('mek')+j('n_c3h7cho_hco'))
  RCONST(11998) = (KDEC)
  RCONST(11999) = (7.31D-11)
  RCONST(12000) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12001) = (KROPRIM*O2)
  RCONST(12002) = (j('n_c3h7cho_hco'))
  RCONST(12003) = (2.14D-11)
  RCONST(12004) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12005) = (2.49D-11)
  RCONST(12006) = (KBPAN)
  RCONST(12007) = (2.10D-11)
  RCONST(12008) = (8.37D-11)
  RCONST(12009) = (j('ch3o2h')+j('mek')*2+j('n_c3h7cho_hco'))
  RCONST(12010) = (KDEC)
  RCONST(12011) = (1.83D-11)
  RCONST(12012) = (j('ch3o2h')+j('mek'))
  RCONST(12013) = (KDEC)
  RCONST(12014) = (KNO3AL*5.5)
  RCONST(12015) = (6.70D-11)
  RCONST(12016) = (j('biacet'))
  RCONST(12017) = (KRO2HO2*0.914)
  RCONST(12018) = (KRO2NO*0.125)
  RCONST(12019) = (KRO2NO*0.875)
  RCONST(12020) = (KRO2NO3)
  RCONST(12021) = (6.70D-15*0.7*RO2)
  RCONST(12022) = (6.70D-15*0.3*RO2)
  RCONST(12023) = (8.03D-12)
  RCONST(12024) = (j('ch3o2h'))
  RCONST(12025) = (KDEC)
  RCONST(12026) = (KRO2HO2*0.820)
  RCONST(12027) = (KRO2NO*0.278)
  RCONST(12028) = (KRO2NO*0.722)
  RCONST(12029) = (KRO2NO3)
  RCONST(12030) = (2.50D-13*0.6*RO2)
  RCONST(12031) = (2.50D-13*0.2*RO2)
  RCONST(12032) = (2.50D-13*0.2*RO2)
  RCONST(12033) = (KAPHO2*0.41)
  RCONST(12034) = (KAPHO2*0.44)
  RCONST(12035) = (KAPHO2*0.15)
  RCONST(12036) = (KAPNO)
  RCONST(12037) = (KFPAN)
  RCONST(12038) = (KRO2NO3*1.74)
  RCONST(12039) = (1.00D-11*RO2*0.7)
  RCONST(12040) = (1.00D-11*RO2*0.3)
  RCONST(12041) = (2*KNO3AL*5.5)
  RCONST(12042) = (1.33D-10)
  RCONST(12043) = (j('n_c3h7cho_hco')*2)
  RCONST(12044) = (KRO2HO2*0.890)
  RCONST(12045) = (KRO2NO)
  RCONST(12046) = (KRO2NO3)
  RCONST(12047) = (6.70D-15*RO2)
  RCONST(12048) = (KRO2HO2*0.890)
  RCONST(12049) = (KRO2NO*0.118)
  RCONST(12050) = (KRO2NO*0.882)
  RCONST(12051) = (KRO2NO3)
  RCONST(12052) = (6.70D-15*0.7*RO2)
  RCONST(12053) = (6.70D-15*0.3*RO2)
  RCONST(12054) = (KRO2HO2*0.859)
  RCONST(12055) = (KRO2NO)
  RCONST(12056) = (KRO2NO3)
  RCONST(12057) = (6.70D-15*RO2)
  RCONST(12058) = (KNO3AL*5.5)
  RCONST(12059) = (8.92D-11*0.232)
  RCONST(12060) = (8.92D-11*0.768)
  RCONST(12061) = (j('n_c3h7cho_hco'))
  RCONST(12062) = (KRO2HO2*0.890)
  RCONST(12063) = (KRO2NO*0.118)
  RCONST(12064) = (KRO2NO*0.882)
  RCONST(12065) = (KRO2NO3)
  RCONST(12066) = (6.70D-15*RO2*0.7)
  RCONST(12067) = (6.70D-15*RO2*0.3)
  RCONST(12068) = (KRO2HO2*0.890)
  RCONST(12069) = (KRO2NO)
  RCONST(12070) = (KRO2NO3)
  RCONST(12071) = (8.80D-13*RO2*0.2)
  RCONST(12072) = (8.80D-13*RO2*0.6)
  RCONST(12073) = (8.80D-13*RO2*0.2)
  RCONST(12074) = (KRO2HO2*0.890)
  RCONST(12075) = (KRO2NO*0.118)
  RCONST(12076) = (KRO2NO*0.882)
  RCONST(12077) = (KRO2NO3)
  RCONST(12078) = (6.70D-15*RO2*0.7)
  RCONST(12079) = (6.70D-15*RO2*0.3)
  RCONST(12080) = (KAPHO2*0.15)
  RCONST(12081) = (KAPHO2*0.41)
  RCONST(12082) = (KAPHO2*0.44)
  RCONST(12083) = (KAPNO)
  RCONST(12084) = (KFPAN)
  RCONST(12085) = (KRO2NO3*1.74)
  RCONST(12086) = (1.00D-11*0.3*RO2)
  RCONST(12087) = (1.00D-11*0.7*RO2)
  RCONST(12088) = (KRO2HO2*0.859)
  RCONST(12089) = (KRO2NO)
  RCONST(12090) = (KRO2NO3)
  RCONST(12091) = (8.80D-13*RO2*0.2)
  RCONST(12092) = (8.80D-13*RO2*0.6)
  RCONST(12093) = (8.80D-13*RO2*0.2)
  RCONST(12094) = (7.23D-11)
  RCONST(12095) = (j('n_c3h7cho_hco'))
  RCONST(12096) = (7.54D-11)
  RCONST(12097) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12098) = (KRO2HO2*0.706)
  RCONST(12099) = (KRO2NO*0.052)
  RCONST(12100) = (KRO2NO*0.948)
  RCONST(12101) = (KRO2NO3)
  RCONST(12102) = (1.30D-12*RO2*0.6)
  RCONST(12103) = (1.30D-12*RO2*0.2)
  RCONST(12104) = (1.30D-12*RO2*0.2)
  RCONST(12105) = (6.76D-11)
  RCONST(12106) = (KBPAN)
  RCONST(12107) = (KRO2HO2*0.770)
  RCONST(12108) = (KRO2NO)
  RCONST(12109) = (KRO2NO3)
  RCONST(12110) = (8.80D-13*RO2*0.2)
  RCONST(12111) = (8.80D-13*RO2*0.6)
  RCONST(12112) = (8.80D-13*RO2*0.2)
  RCONST(12113) = (3.61D-11)
  RCONST(12114) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12115) = (2.56D-11)
  RCONST(12116) = (j('2_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(12117) = (2.70D+14*EXP(-6643/TEMP))
  RCONST(12118) = (2.86D-11)
  RCONST(12119) = (j('n_c3h7cho_hco'))
  RCONST(12120) = (3.08D-11)
  RCONST(12121) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(12122) = (KDEC)
  RCONST(12123) = (2.73D-11)
  RCONST(12124) = (j('n_c3h7cho_hco')*2)
  RCONST(12125) = (2.28D-11)
  RCONST(12126) = (j('mek')*2+j('ch3o2h'))
  RCONST(12127) = (1.97D-11)
  RCONST(12128) = (j('mek')*2)
  RCONST(12129) = (1.92D-11)
  RCONST(12130) = (KBPAN)
  RCONST(12131) = (3.21D-11)
  RCONST(12132) = (j('mek')*2+j('ch3o2h'))
  RCONST(12133) = (1.62D-11)
  RCONST(12134) = (j('mek')*2+j('n_c3h7ono2'))
  RCONST(12135) = (KDEC)
  RCONST(12136) = (2.72D-11)
  RCONST(12137) = (2.31D-11)
  RCONST(12138) = (j('mek')*2)
  RCONST(12139) = (5.89D-11)
  RCONST(12140) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(12141) = (KDEC)
  RCONST(12142) = (5.54D-11)
  RCONST(12143) = (j('n_c3h7cho_hco')*2)
  RCONST(12144) = (KAPHO2*0.15)
  RCONST(12145) = (KAPHO2*0.41)
  RCONST(12146) = (KAPHO2*0.44)
  RCONST(12147) = (KAPNO)
  RCONST(12148) = (KFPAN)
  RCONST(12149) = (KRO2NO3*1.74)
  RCONST(12150) = (1.00D-11*RO2*0.3)
  RCONST(12151) = (1.00D-11*RO2*0.7)
  RCONST(12152) = (KRO2HO2*0.770)
  RCONST(12153) = (KRO2NO*0.078)
  RCONST(12154) = (KRO2NO*0.922)
  RCONST(12155) = (KRO2NO3)
  RCONST(12156) = (1.30D-12*0.2)
  RCONST(12157) = (1.30D-12*0.2)
  RCONST(12158) = (1.30D-12*0.6)
  RCONST(12159) = (KRO2HO2*0.820)
  RCONST(12160) = (KRO2NO)
  RCONST(12161) = (KRO2NO3)
  RCONST(12162) = (9.20D-14*RO2*0.7)
  RCONST(12163) = (9.20D-14*RO2*0.3)
  RCONST(12164) = (6.05D-11)
  RCONST(12165) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(12166) = (4.59D-11)
  RCONST(12167) = (KDEC)
  RCONST(12168) = (5.70D-11)
  RCONST(12169) = (j('n_c3h7cho_hco')*2)
  RCONST(12170) = (9.57D-11)
  RCONST(12171) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12172) = (7.51D-11)
  RCONST(12173) = (j('n_c3h7ono2'))
  RCONST(12174) = (KDEC)
  RCONST(12175) = (KNO3AL*8.5)
  RCONST(12176) = (3.30D-13)
  RCONST(12177) = (1.30D-17*0.330)
  RCONST(12178) = (1.30D-17*0.670)
  RCONST(12179) = (8.67D-11*0.288)
  RCONST(12180) = (8.67D-11*0.712)
  RCONST(12181) = (j('n_c3h7cho_hco'))
  RCONST(12182) = (KRO2HO2*0.859)
  RCONST(12183) = (KRO2NO*0.138)
  RCONST(12184) = (KRO2NO*0.862)
  RCONST(12185) = (KRO2NO3)
  RCONST(12186) = (1.30D-12*RO2*0.2)
  RCONST(12187) = (1.30D-12*RO2*0.6)
  RCONST(12188) = (1.30D-12*RO2*0.2)
  RCONST(12189) = (KAPHO2*0.41)
  RCONST(12190) = (KAPHO2*0.44)
  RCONST(12191) = (KAPHO2*0.15)
  RCONST(12192) = (KAPNO)
  RCONST(12193) = (KFPAN)
  RCONST(12194) = (KRO2NO3*1.74)
  RCONST(12195) = (1.00D-11*RO2*0.7)
  RCONST(12196) = (1.00D-11*RO2*0.3)
  RCONST(12197) = (KRO2HO2*0.890)
  RCONST(12198) = (KRO2NO)
  RCONST(12199) = (KRO2NO3)
  RCONST(12200) = (9.20D-14*RO2)
  RCONST(12201) = (KAPHO2*0.15)
  RCONST(12202) = (KAPHO2*0.41)
  RCONST(12203) = (KAPHO2*0.44)
  RCONST(12204) = (KAPNO)
  RCONST(12205) = (KFPAN)
  RCONST(12206) = (KRO2NO3*1.74)
  RCONST(12207) = (1.00D-11*RO2*0.3)
  RCONST(12208) = (1.00D-11*RO2*0.7)
  RCONST(12209) = (5.20D-11)
  RCONST(12210) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(12211) = (5.79D-11)
  RCONST(12212) = (j('mek'))
  RCONST(12213) = (j('ch3o2h'))
  RCONST(12214) = (KDEC)
  RCONST(12215) = (3.58D-11)
  RCONST(12216) = (j('biacet'))
  RCONST(12217) = (4.57D-11)
  RCONST(12218) = (j('mek'))
  RCONST(12219) = (4.77D-11)
  RCONST(12220) = (j('mek'))
  RCONST(12221) = (j('ch3o2h'))
  RCONST(12222) = (KDEC)
  RCONST(12223) = (5.09D-11)
  RCONST(12224) = (j('ch3cocho'))
  RCONST(12225) = (4.09D-11)
  RCONST(12226) = (j('mek'))
  RCONST(12227) = (KAPHO2*0.15)
  RCONST(12228) = (KAPHO2*0.41)
  RCONST(12229) = (KAPHO2*0.44)
  RCONST(12230) = (KAPNO)
  RCONST(12231) = (KFPAN)
  RCONST(12232) = (KRO2NO3*1.74)
  RCONST(12233) = (1.00D-11*RO2*0.3)
  RCONST(12234) = (1.00D-11*RO2*0.7)
  RCONST(12235) = (KAPHO2*0.44)
  RCONST(12236) = (KAPHO2*0.15)
  RCONST(12237) = (KAPHO2*0.41)
  RCONST(12238) = (KAPNO)
  RCONST(12239) = (KFPAN)
  RCONST(12240) = (KRO2NO3*1.74)
  RCONST(12241) = (1.00D-11*RO2*0.7)
  RCONST(12242) = (1.00D-11*RO2*0.3)
  RCONST(12243) = (KRO2HO2*0.959)
  RCONST(12244) = (KRO2NO)
  RCONST(12245) = (KRO2NO3)
  RCONST(12246) = (6.70D-15*RO2*0.7)
  RCONST(12247) = (6.70D-15*RO2*0.3)
  RCONST(12248) = (KAPHO2*0.15)
  RCONST(12249) = (KAPHO2*0.41)
  RCONST(12250) = (KAPHO2*0.44)
  RCONST(12251) = (KAPNO)
  RCONST(12252) = (KFPAN)
  RCONST(12253) = (KRO2NO3*1.74)
  RCONST(12254) = (1.00D-11*RO2*0.3)
  RCONST(12255) = (1.00D-11*RO2*0.7)
  RCONST(12256) = (KAPHO2*0.15)
  RCONST(12257) = (KAPHO2*0.41)
  RCONST(12258) = (KAPHO2*0.44)
  RCONST(12259) = (KAPNO)
  RCONST(12260) = (KFPAN)
  RCONST(12261) = (KRO2NO3*1.74)
  RCONST(12262) = (1.00D-11*RO2*0.3)
  RCONST(12263) = (1.00D-11*RO2*0.7)
  RCONST(12264) = (8.74D-11)
  RCONST(12265) = (KRO2HO2*0.959)
  RCONST(12266) = (KRO2NO*0.178)
  RCONST(12267) = (KRO2NO*0.822)
  RCONST(12268) = (KRO2NO3)
  RCONST(12269) = (2.50D-13*RO2*0.2)
  RCONST(12270) = (2.50D-13*RO2*0.6)
  RCONST(12271) = (2.50D-13*RO2*0.2)
  RCONST(12272) = (3.64D-11)
  RCONST(12273) = (3.93D-11)
  RCONST(12274) = (j('ch3o2h'))
  RCONST(12275) = (3.57D-11)
  RCONST(12276) = (KBPAN)
  RCONST(12277) = (4.11D-11)
  RCONST(12278) = (j('ch3o2h'))
  RCONST(12279) = (2.76D-11)
  RCONST(12280) = (j('n_c3h7ono2'))
  RCONST(12281) = (KDEC)
  RCONST(12282) = (4.83D-11)
  RCONST(12283) = (3.21D-11)
  RCONST(12284) = (7.07D-11)
  RCONST(12285) = (j('ch3o2h'))
  RCONST(12286) = (KDEC)
  RCONST(12287) = (4.99D-11)
  RCONST(12288) = (j('biacet'))
  RCONST(12289) = (5.85D-11)
  RCONST(12290) = (KRO2HO2*0.947)
  RCONST(12291) = (KRO2NO*0.132)
  RCONST(12292) = (KRO2NO*0.868)
  RCONST(12293) = (KRO2NO3)
  RCONST(12294) = (6.70D-15*RO2*0.7)
  RCONST(12295) = (6.70D-15*RO2*0.3)
  RCONST(12296) = (6.87D-11)
  RCONST(12297) = (j('mek')*3)
  RCONST(12298) = (KRO2HO2*0.968)
  RCONST(12299) = (KRO2NO*0.245)
  RCONST(12300) = (KRO2NO*0.755)
  RCONST(12301) = (KRO2NO3)
  RCONST(12302) = (2.50D-13*RO2*0.2)
  RCONST(12303) = (2.50D-13*RO2*0.6)
  RCONST(12304) = (2.50D-13*RO2*0.2)
  RCONST(12305) = (4.63D-11)
  RCONST(12306) = (j('ch3o2h'))
  RCONST(12307) = (3.23D-11)
  RCONST(12308) = (j('n_c3h7ono2'))
  RCONST(12309) = (KDEC)
  RCONST(12310) = (3.72D-11)
  RCONST(12311) = (3.77D-11)
  RCONST(12312) = (4.08D-11)
  RCONST(12313) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12314) = (3.72D-11)
  RCONST(12315) = (KBPAN)
  RCONST(12316) = (4.98D-11)
  RCONST(12317) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12318) = (8.40D+10*EXP(-2567/TEMP))
  RCONST(12319) = (4.58D-11)
  RCONST(12320) = (j('i_c3h7cho'))
  RCONST(12321) = (j('ch3o2h'))
  RCONST(12322) = (KDEC)
  RCONST(12323) = (3.57D-11)
  RCONST(12324) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('biacet'))
  RCONST(12325) = (8.40D+10*EXP(-2567/TEMP))
  RCONST(12326) = (5.71D-12)
  RCONST(12327) = (j('ch3o2h')+j('mek'))
  RCONST(12328) = (9.17D-12)
  RCONST(12329) = (KBPAN)
  RCONST(12330) = (1.90D-12)
  RCONST(12331) = (1.11D-11)
  RCONST(12332) = (j('ch3o2h'))
  RCONST(12333) = (1.46D-11)
  RCONST(12334) = (KBPAN)
  RCONST(12335) = (1.55D-11)
  RCONST(12336) = (j('mek'))
  RCONST(12337) = (6.88D-12)
  RCONST(12338) = (j('ch3o2h')+j('mek'))
  RCONST(12339) = (1.03D-11)
  RCONST(12340) = (KBPAN)
  RCONST(12341) = (3.19D-12)
  RCONST(12342) = (j('ch3o2h'))
  RCONST(12343) = (j('i_c3h7cho'))
  RCONST(12344) = (2.77D-11)
  RCONST(12345) = (9.18D-12)
  RCONST(12346) = (j('ch3o2h'))
  RCONST(12347) = (1.26D-11)
  RCONST(12348) = (KBPAN)
  RCONST(12349) = (3.24D-12)
  RCONST(12350) = (KRO2HO2*0.706)
  RCONST(12351) = (KRO2NO*0.010)
  RCONST(12352) = (KRO2NO*0.990)
  RCONST(12353) = (KRO2NO3)
  RCONST(12354) = (2.00D-12*0.2*RO2)
  RCONST(12355) = (2.00D-12*0.2*RO2)
  RCONST(12356) = (2.00D-12*0.6*RO2)
  RCONST(12357) = (j('biacet'))
  RCONST(12358) = (KNO3AL*8.5)
  RCONST(12359) = (6.75D-11)
  RCONST(12360) = (KRO2HO2*0.706)
  RCONST(12361) = (KRO2NO)
  RCONST(12362) = (KRO2NO3)
  RCONST(12363) = (2.00D-12*RO2)
  RCONST(12364) = (KAPHO2*0.44)
  RCONST(12365) = (KAPHO2*0.56)
  RCONST(12366) = (KAPNO)
  RCONST(12367) = (KFPAN)
  RCONST(12368) = (KRO2NO3*1.74)
  RCONST(12369) = (1.00D-11*RO2)
  RCONST(12370) = (j('ch3cocho'))
  RCONST(12371) = (1.44D-11)
  RCONST(12372) = (9.18D-12)
  RCONST(12373) = (j('ch3o2h')+j('mek'))
  RCONST(12374) = (1.26D-11)
  RCONST(12375) = (KBPAN)
  RCONST(12376) = (3.51D-12)
  RCONST(12377) = (j('ch3o2h')+j('mek'))
  RCONST(12378) = (9.25D-11)
  RCONST(12379) = (j('1_c4h9ono2')+j('mek'))
  RCONST(12380) = (3.41D-12)
  RCONST(12381) = (2.00D+14*EXP(-4714/TEMP))
  RCONST(12382) = (j('mek'))
  RCONST(12383) = (4.35D-11)
  RCONST(12384) = (j('mek')*2)
  RCONST(12385) = (5.76D-12)
  RCONST(12386) = (j('mek')*2)
  RCONST(12387) = (j('ch3o2h'))
  RCONST(12388) = (5.53D-11)
  RCONST(12389) = (KDEC)
  RCONST(12390) = (j('biacet'))
  RCONST(12391) = (1.86D-12)
  RCONST(12392) = (j('mek')*2)
  RCONST(12393) = (2.41D-11)
  RCONST(12394) = (j('mek')*2)
  RCONST(12395) = (j('ch3o2h'))
  RCONST(12396) = (5.53D-11)
  RCONST(12397) = (KDEC)
  RCONST(12398) = (j('biacet'))
  RCONST(12399) = (1.86D-12)
  RCONST(12400) = (j('mek')*2)
  RCONST(12401) = (2.41D-11)
  RCONST(12402) = (KAPHO2*0.56)
  RCONST(12403) = (KAPHO2*0.44)
  RCONST(12404) = (KAPNO)
  RCONST(12405) = (KFPAN)
  RCONST(12406) = (KRO2NO3*1.74)
  RCONST(12407) = (1.00D-11*RO2)
  RCONST(12408) = (KRO2HO2*0.820)
  RCONST(12409) = (KRO2NO)
  RCONST(12410) = (KRO2NO3)
  RCONST(12411) = (2.00D-12*RO2)
  RCONST(12412) = (j('ch3o2h'))
  RCONST(12413) = (j('mek'))
  RCONST(12414) = (1.25D-11)
  RCONST(12415) = (j('mek'))
  RCONST(12416) = (1.93D-12)
  RCONST(12417) = (KDEC)
  RCONST(12418) = (j('mek'))
  RCONST(12419) = (9.07D-12)
  RCONST(12420) = (j('ch3o2h'))
  RCONST(12421) = (j('mek')*2)
  RCONST(12422) = (7.07D-12)
  RCONST(12423) = (KDEC)
  RCONST(12424) = (j('mek')*2)
  RCONST(12425) = (3.61D-12)
  RCONST(12426) = (j('ch3o2h'))
  RCONST(12427) = (j('mek')*2)
  RCONST(12428) = (1.90D-12*EXP(190/TEMP))
  RCONST(12429) = (5.41D-11)
  RCONST(12430) = (KDEC)
  RCONST(12431) = (j('mek')*2)
  RCONST(12432) = (2.64D-11)
  RCONST(12433) = (j('biacet'))
  RCONST(12434) = (j('mek'))
  RCONST(12435) = (1.83D-12)
  RCONST(12436) = (KAPHO2*0.56)
  RCONST(12437) = (KAPHO2*0.44)
  RCONST(12438) = (KAPNO)
  RCONST(12439) = (KFPAN)
  RCONST(12440) = (KRO2NO3*1.74)
  RCONST(12441) = (1.00D-11*RO2)
  RCONST(12442) = (KRO2HO2*0.706)
  RCONST(12443) = (KRO2NO*0.026)
  RCONST(12444) = (KRO2NO*0.974)
  RCONST(12445) = (KRO2NO3)
  RCONST(12446) = (8.80D-13*0.2*RO2)
  RCONST(12447) = (8.80D-13*0.6*RO2)
  RCONST(12448) = (8.80D-13*0.2*RO2)
  RCONST(12449) = (j('biacet')+j('mek'))
  RCONST(12450) = (2.99D-12)
  RCONST(12451) = (j('mek')*2)
  RCONST(12452) = (j('ch3o2h'))
  RCONST(12453) = (5.65D-11)
  RCONST(12454) = (KDEC)
  RCONST(12455) = (j('mek')*2)
  RCONST(12456) = (2.52D-11)
  RCONST(12457) = (KAPHO2*0.56)
  RCONST(12458) = (KAPHO2*0.44)
  RCONST(12459) = (KAPNO)
  RCONST(12460) = (KFPAN)
  RCONST(12461) = (KRO2NO3*1.74)
  RCONST(12462) = (1.00D-11*RO2)
  RCONST(12463) = (j('biacet')+j('mek'))
  RCONST(12464) = (6.43D-12)
  RCONST(12465) = (j('mek')*2)
  RCONST(12466) = (j('ch3o2h'))
  RCONST(12467) = (5.40D-11)
  RCONST(12468) = (KDEC)
  RCONST(12469) = (j('mek')*2)
  RCONST(12470) = (2.28D-11)
  RCONST(12471) = (KAPHO2*0.56)
  RCONST(12472) = (KAPHO2*0.44)
  RCONST(12473) = (KAPNO)
  RCONST(12474) = (KFPAN)
  RCONST(12475) = (KRO2NO3*1.74)
  RCONST(12476) = (1.00D-11*RO2)
  RCONST(12477) = (j('biacet')+j('mek'))
  RCONST(12478) = (7.84D-12)
  RCONST(12479) = (j('ch3o2h'))
  RCONST(12480) = (j('mek')*2)
  RCONST(12481) = (5.54D-11)
  RCONST(12482) = (KDEC)
  RCONST(12483) = (j('mek')*2)
  RCONST(12484) = (2.42D-11)
  RCONST(12485) = (KAPHO2*0.56)
  RCONST(12486) = (KAPHO2*0.44)
  RCONST(12487) = (KAPNO)
  RCONST(12488) = (KFPAN)
  RCONST(12489) = (KRO2NO3*1.74)
  RCONST(12490) = (1.00D-11*RO2)
  RCONST(12491) = (j('n_c3h7cho_hco'))
  RCONST(12492) = (KNO3AL*5.5)
  RCONST(12493) = (3.05D-11)
  RCONST(12494) = (j('biacet')+j('mek'))
  RCONST(12495) = (9.25D-12)
  RCONST(12496) = (j('ch3o2h'))
  RCONST(12497) = (j('mek')*2)
  RCONST(12498) = (5.68D-11)
  RCONST(12499) = (KDEC)
  RCONST(12500) = (j('mek')*2)
  RCONST(12501) = (2.56D-11)
  RCONST(12502) = (KAPHO2*0.56)
  RCONST(12503) = (KAPHO2*0.44)
  RCONST(12504) = (KAPNO)
  RCONST(12505) = (KFPAN)
  RCONST(12506) = (KRO2NO3*1.74)
  RCONST(12507) = (1.00D-11*RO2)
  RCONST(12508) = (j('biacet')+j('mek'))
  RCONST(12509) = (1.07D-11)
  RCONST(12510) = (9.89D-12)
  RCONST(12511) = (j('ch3o2h'))
  RCONST(12512) = (1.33D-11)
  RCONST(12513) = (6.16D-12)
  RCONST(12514) = (KBPAN)
  RCONST(12515) = (j('ch3o2h'))
  RCONST(12516) = (j('mek')*2)
  RCONST(12517) = (5.82D-11)
  RCONST(12518) = (KDEC)
  RCONST(12519) = (j('mek')*2)
  RCONST(12520) = (2.70D-11)
  RCONST(12521) = (KAPHO2*0.56)
  RCONST(12522) = (KAPHO2*0.44)
  RCONST(12523) = (KAPNO)
  RCONST(12524) = (KFPAN)
  RCONST(12525) = (KRO2NO3*1.74)
  RCONST(12526) = (1.00D-11*RO2)
  RCONST(12527) = (4.66D-11)
  RCONST(12528) = (j('ch3o2h'))
  RCONST(12529) = (KDEC)
  RCONST(12530) = (2.55D-11)
  RCONST(12531) = (5.68D-12)
  RCONST(12532) = (1.90D-12*EXP(190/TEMP))
  RCONST(12533) = (j('ch3o2h'))
  RCONST(12534) = (KDEC)
  RCONST(12535) = (1.90D-12*EXP(190/TEMP))
  RCONST(12536) = (j('ch3o2h'))
  RCONST(12537) = (KDEC)
  RCONST(12538) = (1.90D-12*EXP(190/TEMP))
  RCONST(12539) = (7.70D-11)
  RCONST(12540) = (j('ch3cocho')*2)
  RCONST(12541) = (KAPHO2*0.56)
  RCONST(12542) = (KAPHO2*0.44)
  RCONST(12543) = (KAPNO)
  RCONST(12544) = (KFPAN)
  RCONST(12545) = (KRO2NO3*1.74)
  RCONST(12546) = (1.00D-11*RO2)
  RCONST(12547) = (9.58D-11)
  RCONST(12548) = (j('ch3cocho')*2)
  RCONST(12549) = (KAPHO2*0.44)
  RCONST(12550) = (KAPHO2*0.56)
  RCONST(12551) = (KAPNO)
  RCONST(12552) = (KFPAN)
  RCONST(12553) = (KRO2NO3*1.74)
  RCONST(12554) = (1.00D-11*RO2)
  RCONST(12555) = (1.90D-12*EXP(190/TEMP))
  RCONST(12556) = (j('ch3o2h'))
  RCONST(12557) = (KDEC)
  RCONST(12558) = (1.90D-12*EXP(190/TEMP))
  RCONST(12559) = (j('ch3o2h'))
  RCONST(12560) = (KDEC)
  RCONST(12561) = (1.90D-12*EXP(190/TEMP))
  RCONST(12562) = (KAPHO2*0.56)
  RCONST(12563) = (KAPHO2*0.44)
  RCONST(12564) = (KAPNO)
  RCONST(12565) = (KFPAN)
  RCONST(12566) = (KRO2NO3*1.74)
  RCONST(12567) = (1.00D-11*RO2)
  RCONST(12568) = (1.72D-11)
  RCONST(12569) = (j('ch3o2h'))
  RCONST(12570) = (KDEC)
  RCONST(12571) = (1.90D-12*EXP(190/TEMP))
  RCONST(12572) = (j('ch3o2h'))
  RCONST(12573) = (KDEC)
  RCONST(12574) = (1.90D-12*EXP(190/TEMP))
  RCONST(12575) = (j('ch3o2h'))
  RCONST(12576) = (KDEC)
  RCONST(12577) = (1.15D-10)
  RCONST(12578) = (j('ch3cocho')*2)
  RCONST(12579) = (KAPHO2*0.44)
  RCONST(12580) = (KAPHO2*0.56)
  RCONST(12581) = (KAPNO)
  RCONST(12582) = (KFPAN)
  RCONST(12583) = (KRO2NO3*1.74)
  RCONST(12584) = (1.00D-11*RO2)
  RCONST(12585) = (KAPHO2*0.44)
  RCONST(12586) = (KAPHO2*0.56)
  RCONST(12587) = (KAPNO)
  RCONST(12588) = (KFPAN)
  RCONST(12589) = (KRO2NO3*1.74)
  RCONST(12590) = (1.00D-11*RO2)
  RCONST(12591) = (KAPHO2*0.15)
  RCONST(12592) = (KAPHO2*0.41)
  RCONST(12593) = (KAPHO2*0.44)
  RCONST(12594) = (KAPNO)
  RCONST(12595) = (KFPAN)
  RCONST(12596) = (KRO2NO3*1.74)
  RCONST(12597) = (1.00D-11*RO2*0.3)
  RCONST(12598) = (1.00D-11*RO2*0.7)
  RCONST(12599) = (1.19D-11)
  RCONST(12600) = (j('ch3o2h'))
  RCONST(12601) = (j('mek'))
  RCONST(12602) = (KDEC)
  RCONST(12603) = (KAPHO2*0.15)
  RCONST(12604) = (KAPHO2*0.41)
  RCONST(12605) = (KAPHO2*0.44)
  RCONST(12606) = (KAPNO)
  RCONST(12607) = (KFPAN)
  RCONST(12608) = (KRO2NO3*1.74)
  RCONST(12609) = (1.00D-11*RO2*0.3)
  RCONST(12610) = (1.00D-11*RO2*0.7)
  RCONST(12611) = (1.69D-11)
  RCONST(12612) = (j('ch3o2h'))
  RCONST(12613) = (KDEC)
  RCONST(12614) = (1.34D-11)
  RCONST(12615) = (1.90D-12*EXP(190/TEMP))
  RCONST(12616) = (j('ch3o2h'))
  RCONST(12617) = (KDEC)
  RCONST(12618) = (1.90D-12*EXP(190/TEMP))
  RCONST(12619) = (j('ch3o2h'))
  RCONST(12620) = (KDEC)
  RCONST(12621) = (7.04D-11)
  RCONST(12622) = (j('ch3cocho')+j('biacet'))
  RCONST(12623) = (KAPHO2*0.44)
  RCONST(12624) = (KAPHO2*0.56)
  RCONST(12625) = (KAPNO)
  RCONST(12626) = (KFPAN)
  RCONST(12627) = (KRO2NO3*1.74)
  RCONST(12628) = (1.00D-11*RO2)
  RCONST(12629) = (1.52D-10)
  RCONST(12630) = (j('ch3o2h'))
  RCONST(12631) = (KDEC)
  RCONST(12632) = (1.90D-12*EXP(190/TEMP))
  RCONST(12633) = (j('ch3o2h'))
  RCONST(12634) = (KDEC)
  RCONST(12635) = (1.90D-12*EXP(190/TEMP))
  RCONST(12636) = (j('ch3o2h'))
  RCONST(12637) = (KDEC)
  RCONST(12638) = (8.35D-11)
  RCONST(12639) = (j('ch3cocho')+j('biacet'))
  RCONST(12640) = (KAPHO2*0.56)
  RCONST(12641) = (KAPHO2*0.44)
  RCONST(12642) = (KAPNO)
  RCONST(12643) = (KFPAN)
  RCONST(12644) = (KRO2NO3*1.74)
  RCONST(12645) = (1.0D-11*RO2)
  RCONST(12646) = (1.90D-12*EXP(190/TEMP))
  RCONST(12647) = (j('ch3o2h'))
  RCONST(12648) = (KDEC)
  RCONST(12649) = (1.90D-12*EXP(190/TEMP))
  RCONST(12650) = (j('ch3o2h'))
  RCONST(12651) = (KDEC)
  RCONST(12652) = (9.76D-11)
  RCONST(12653) = (j('ch3cocho')*2)
  RCONST(12654) = (KAPHO2*0.44)
  RCONST(12655) = (KAPHO2*0.56)
  RCONST(12656) = (KAPNO)
  RCONST(12657) = (KFPAN)
  RCONST(12658) = (KRO2NO3*1.74)
  RCONST(12659) = (1.00D-11*RO2)
  RCONST(12660) = (1.90D-12*EXP(190/TEMP))
  RCONST(12661) = (KAPHO2*0.44)
  RCONST(12662) = (KAPHO2*0.56)
  RCONST(12663) = (KAPNO)
  RCONST(12664) = (KFPAN)
  RCONST(12665) = (KRO2NO3*1.74)
  RCONST(12666) = (1.00D-11*RO2)
  RCONST(12667) = (1.90D-12*EXP(190/TEMP))
  RCONST(12668) = (j('ch3o2h'))
  RCONST(12669) = (KDEC)
  RCONST(12670) = (1.90D-12*EXP(190/TEMP))
  RCONST(12671) = (j('ch3o2h'))
  RCONST(12672) = (KDEC)
  RCONST(12673) = (9.92D-11)
  RCONST(12674) = (j('ch3cocho')*2)
  RCONST(12675) = (KAPHO2*0.44)
  RCONST(12676) = (KAPHO2*0.56)
  RCONST(12677) = (KAPNO)
  RCONST(12678) = (KFPAN)
  RCONST(12679) = (KRO2NO3*1.74)
  RCONST(12680) = (1.00D-11*RO2)
  RCONST(12681) = (1.90D-12*EXP(190/TEMP))
  RCONST(12682) = (1.18D-11)
  RCONST(12683) = (j('ch3o2h')+j('biacet')+j('mek'))
  RCONST(12684) = (8.21D-12)
  RCONST(12685) = (KBPAN)
  RCONST(12686) = (1.90D-12*EXP(190/TEMP))
  RCONST(12687) = (j('ch3o2h'))
  RCONST(12688) = (KDEC)
  RCONST(12689) = (1.90D-12*EXP(190/TEMP))
  RCONST(12690) = (j('ch3o2h'))
  RCONST(12691) = (KDEC)
  RCONST(12692) = (9.97D-11)
  RCONST(12693) = (j('ch3cocho')*2)
  RCONST(12694) = (KAPHO2*0.44)
  RCONST(12695) = (KAPHO2*0.56)
  RCONST(12696) = (KAPNO)
  RCONST(12697) = (KFPAN)
  RCONST(12698) = (KRO2NO3*1.74)
  RCONST(12699) = (1.00D-11*RO2)
  RCONST(12700) = (1.90D-12*EXP(190/TEMP))
  RCONST(12701) = (9.80D-12)
  RCONST(12702) = (j('ch3o2h')+j('biacet')+j('mek'))
  RCONST(12703) = (6.21D-12)
  RCONST(12704) = (KBPAN)
  RCONST(12705) = (KRO2HO2*0.770)
  RCONST(12706) = (KRO2NO)
  RCONST(12707) = (KRO2NO3)
  RCONST(12708) = (9.20D-14*RO2)
  RCONST(12709) = (KRO2HO2*0.770)
  RCONST(12710) = (KRO2NO)
  RCONST(12711) = (KRO2NO3)
  RCONST(12712) = (9.20D-14*RO2*0.70)
  RCONST(12713) = (9.20D-14*RO2*0.30)
  RCONST(12714) = (1.90D-12*EXP(190/TEMP))
  RCONST(12715) = (j('ch3o2h'))
  RCONST(12716) = (KDEC)
  RCONST(12717) = (1.90D-12*EXP(190/TEMP))
  RCONST(12718) = (j('ch3o2h'))
  RCONST(12719) = (KDEC)
  RCONST(12720) = (1.90D-12*EXP(190/TEMP))
  RCONST(12721) = (1.50D-10)
  RCONST(12722) = (j('ch3o2h'))
  RCONST(12723) = (KDEC)
  RCONST(12724) = (1.90D-12*EXP(190/TEMP))
  RCONST(12725) = (j('ch3o2h'))
  RCONST(12726) = (KDEC)
  RCONST(12727) = (1.90D-12*EXP(190/TEMP))
  RCONST(12728) = (j('ch3o2h'))
  RCONST(12729) = (KDEC)
  RCONST(12730) = (1.03D-10)
  RCONST(12731) = (j('ch3cocho')+j('biacet'))
  RCONST(12732) = (KAPHO2*0.56)
  RCONST(12733) = (KAPHO2*0.44)
  RCONST(12734) = (KAPNO)
  RCONST(12735) = (KFPAN)
  RCONST(12736) = (KRO2NO3*1.74)
  RCONST(12737) = (1.00D-11*RO2)
  RCONST(12738) = (1.50D-10)
  RCONST(12739) = (j('ch3o2h'))
  RCONST(12740) = (KDEC)
  RCONST(12741) = (1.90D-12*EXP(190/TEMP))
  RCONST(12742) = (j('ch3o2h'))
  RCONST(12743) = (KDEC)
  RCONST(12744) = (1.90D-12*EXP(190/TEMP))
  RCONST(12745) = (j('ch3o2h'))
  RCONST(12746) = (KDEC)
  RCONST(12747) = (1.17D-10)
  RCONST(12748) = (j('ch3cocho')*2)
  RCONST(12749) = (KAPHO2*0.56)
  RCONST(12750) = (KAPHO2*0.44)
  RCONST(12751) = (KAPNO)
  RCONST(12752) = (KFPAN)
  RCONST(12753) = (KRO2NO3*1.74)
  RCONST(12754) = (1.00D-11*RO2)
  RCONST(12755) = (1.90D-12*EXP(190/TEMP))
  RCONST(12756) = (j('ch3o2h'))
  RCONST(12757) = (KDEC)
  RCONST(12758) = (1.90D-12*EXP(190/TEMP))
  RCONST(12759) = (j('ch3o2h'))
  RCONST(12760) = (KDEC)
  RCONST(12761) = (8.52D-11)
  RCONST(12762) = (j('ch3cocho')+j('biacet'))
  RCONST(12763) = (KAPHO2*0.44)
  RCONST(12764) = (KAPHO2*0.56)
  RCONST(12765) = (KAPNO)
  RCONST(12766) = (KFPAN)
  RCONST(12767) = (KRO2NO3*1.74)
  RCONST(12768) = (1.00D-11*RO2)
  RCONST(12769) = (1.90D-12*EXP(190/TEMP))
  RCONST(12770) = (j('ch3o2h'))
  RCONST(12771) = (KDEC)
  RCONST(12772) = (1.90D-12*EXP(190/TEMP))
  RCONST(12773) = (j('ch3o2h'))
  RCONST(12774) = (KDEC)
  RCONST(12775) = (8.52D-11)
  RCONST(12776) = (j('ch3cocho')+j('biacet'))
  RCONST(12777) = (KAPHO2*0.44)
  RCONST(12778) = (KAPHO2*0.56)
  RCONST(12779) = (KAPNO)
  RCONST(12780) = (KFPAN)
  RCONST(12781) = (KRO2NO3*1.74)
  RCONST(12782) = (1.00D-11*RO2)
  RCONST(12783) = (KAPHO2*0.15)
  RCONST(12784) = (KAPHO2*0.41)
  RCONST(12785) = (KAPHO2*0.44)
  RCONST(12786) = (KAPNO)
  RCONST(12787) = (KFPAN)
  RCONST(12788) = (KRO2NO3*1.74)
  RCONST(12789) = (1.00D-11*RO2*0.3)
  RCONST(12790) = (1.00D-11*RO2*0.7)
  RCONST(12791) = (1.65D-11)
  RCONST(12792) = (j('ch3o2h'))
  RCONST(12793) = (KDEC)
  RCONST(12794) = (KRO2HO2*0.859)
  RCONST(12795) = (KRO2NO)
  RCONST(12796) = (KRO2NO3)
  RCONST(12797) = (9.20D-14*RO2)
  RCONST(12798) = (1.66D-12)
  RCONST(12799) = (j('ch3o2h'))
  RCONST(12800) = (4.74D-12)
  RCONST(12801) = (KBPAN)
  RCONST(12802) = (1.14D-12)
  RCONST(12803) = (j('ch3o2h'))
  RCONST(12804) = (4.81D-12)
  RCONST(12805) = (KBPAN)
  RCONST(12806) = (1.21D-12)
  RCONST(12807) = (2.31D-11)
  RCONST(12808) = (j('ch3o2h')+j('mek'))
  RCONST(12809) = (KDEC)
  RCONST(12810) = (1.37D-11)
  RCONST(12811) = (j('mek'))
  RCONST(12812) = (KAPHO2*0.56)
  RCONST(12813) = (KAPHO2*0.44)
  RCONST(12814) = (KAPNO)
  RCONST(12815) = (KFPAN)
  RCONST(12816) = (KRO2NO3*1.6)
  RCONST(12817) = (1.00D-11*RO2)
  RCONST(12818) = (KAPHO2*0.15)
  RCONST(12819) = (KAPHO2*0.41)
  RCONST(12820) = (KAPHO2*0.44)
  RCONST(12821) = (KAPNO)
  RCONST(12822) = (KFPAN)
  RCONST(12823) = (KRO2NO3*1.74)
  RCONST(12824) = (1.00D-11*0.3*RO2)
  RCONST(12825) = (1.00D-11*0.7*RO2)
  RCONST(12826) = (KAPHO2*0.15)
  RCONST(12827) = (KAPHO2*0.41)
  RCONST(12828) = (KAPHO2*0.44)
  RCONST(12829) = (KAPNO)
  RCONST(12830) = (KFPAN)
  RCONST(12831) = (KRO2NO3*1.74)
  RCONST(12832) = (1.00D-11*0.3*RO2)
  RCONST(12833) = (1.00D-11*0.7*RO2)
  RCONST(12834) = (KAPHO2*0.15)
  RCONST(12835) = (KAPHO2*0.41)
  RCONST(12836) = (KAPHO2*0.44)
  RCONST(12837) = (KAPNO)
  RCONST(12838) = (KFPAN)
  RCONST(12839) = (KRO2NO3*1.74)
  RCONST(12840) = (1.00D-11*0.3*RO2)
  RCONST(12841) = (1.00D-11*0.7*RO2)
  RCONST(12842) = (j('ch3o2h'))
  RCONST(12843) = (1.04D-11)
  RCONST(12844) = (KBPAN)
  RCONST(12845) = (6.80D-12)
  RCONST(12846) = (2.69D-11)
  RCONST(12847) = (j('ch3o2h')*3)
  RCONST(12848) = (2.33D-11)
  RCONST(12849) = (KBPAN)
  RCONST(12850) = (5.66D-12)
  RCONST(12851) = (j('ch3o2h'))
  RCONST(12852) = (1.96D-12)
  RCONST(12853) = (KBPAN)
  RCONST(12854) = (KAPHO2*0.44)
  RCONST(12855) = (KAPHO2*0.15)
  RCONST(12856) = (KAPHO2*0.41)
  RCONST(12857) = (KAPNO)
  RCONST(12858) = (KFPAN)
  RCONST(12859) = (KRO2NO3*1.74)
  RCONST(12860) = (1.00D-11*0.7*RO2)
  RCONST(12861) = (1.00D-11*0.3*RO2)
  RCONST(12862) = (KAPHO2*0.44)
  RCONST(12863) = (KAPHO2*0.15)
  RCONST(12864) = (KAPHO2*0.41)
  RCONST(12865) = (KAPNO)
  RCONST(12866) = (KFPAN)
  RCONST(12867) = (KRO2NO3*1.74)
  RCONST(12868) = (1.00D-11*0.7*RO2)
  RCONST(12869) = (1.00D-11*0.3*RO2)
  RCONST(12870) = (6.52D-12)
  RCONST(12871) = (6.52D-12*0.39)
  RCONST(12872) = (6.52D-12*0.61)
  RCONST(12873) = (j('ch3o2h'))
  RCONST(12874) = (6.00D-12)
  RCONST(12875) = (KBPAN)
  RCONST(12876) = (KAPHO2*0.56)
  RCONST(12877) = (KAPHO2*0.44)
  RCONST(12878) = (KAPNO)
  RCONST(12879) = (KFPAN)
  RCONST(12880) = (KRO2NO3*1.74)
  RCONST(12881) = (1.00D-11*RO2)
  RCONST(12882) = (j('ch3o2h'))
  RCONST(12883) = (6.50D-12)
  RCONST(12884) = (j('ch3o2h')*2)
  RCONST(12885) = (9.58D-12)
  RCONST(12886) = (KBPAN+j('ch3o2h'))
  RCONST(12887) = (5.98D-12)
  RCONST(12888) = (1.36D-12)
  RCONST(12889) = (j('ch3o2h'))
  RCONST(12890) = (4.08D-12)
  RCONST(12891) = (KBPAN)
  RCONST(12892) = (4.85D-13)
  RCONST(12893) = (KAPHO2*0.15)
  RCONST(12894) = (KAPHO2*0.41)
  RCONST(12895) = (KAPHO2*0.44)
  RCONST(12896) = (KAPNO)
  RCONST(12897) = (KFPAN)
  RCONST(12898) = (KRO2NO3*1.74)
  RCONST(12899) = (1.00D-11*0.3*RO2)
  RCONST(12900) = (1.00D-11*0.7*RO2)
  RCONST(12901) = (3.04D-12)
  RCONST(12902) = (j('ch3o2h'))
  RCONST(12903) = (6.12D-12)
  RCONST(12904) = (KBPAN)
  RCONST(12905) = (2.52D-12)
  RCONST(12906) = (4.93D-12)
  RCONST(12907) = (j('ch3coch2ono2')*10)
  RCONST(12908) = (8.01D-12)
  RCONST(12909) = (j('ch3coch2ono2')*10)
  RCONST(12910) = (4.41D-12)
  RCONST(12911) = (KBPAN+j('ch3coch2ono2')*10)
  RCONST(12912) = (KRO2HO2*0.706)
  RCONST(12913) = (KRO2NO)
  RCONST(12914) = (KRO2NO3)
  RCONST(12915) = (9.20D-14*RO2)
  RCONST(12916) = (KRO2HO2*0.706)
  RCONST(12917) = (KRO2NO)
  RCONST(12918) = (KRO2NO3)
  RCONST(12919) = (8.80D-13*RO2)
  RCONST(12920) = (1.32D-11*0.728)
  RCONST(12921) = (1.32D-11*0.272)
  RCONST(12922) = (j('ch3o2h'))
  RCONST(12923) = (2.43D-12)
  RCONST(12924) = (1.80D+13*(TEMP/298)**1.7*EXP(-4079/TEMP))
  RCONST(12925) = (1.80D+13*(TEMP/298)**1.7*EXP(-4733/TEMP))
  RCONST(12926) = (9.60D-12)
  RCONST(12927) = (1.37D-11)
  RCONST(12928) = (j('ch3o2h'))
  RCONST(12929) = (KDEC)
  RCONST(12930) = (1.84D-11)
  RCONST(12931) = (1.63D-11)
  RCONST(12932) = (3.60D-12)
  RCONST(12933) = (j('ch3o2h'))
  RCONST(12934) = (2.90D-11)
  RCONST(12935) = (KBPAN)
  RCONST(12936) = (1.20D-15)
  RCONST(12937) = (1.00D-14)
  RCONST(12938) = (1.00D-15)
  RCONST(12939) = (7.00D-14)
  RCONST(12940) = (6.00D-18*H2O)
  RCONST(12941) = (4.17D-11)
  RCONST(12942) = (j('i_c3h7cho'))
  RCONST(12943) = (j('ch3o2h'))
  RCONST(12944) = (KDEC)
  RCONST(12945) = (5.25D-12)
  RCONST(12946) = (j('mek'))
  RCONST(12947) = (3.82D-11)
  RCONST(12948) = (j('i_c3h7cho'))
  RCONST(12949) = (KAPHO2*0.44)
  RCONST(12950) = (KAPHO2*0.15)
  RCONST(12951) = (KAPHO2*0.41)
  RCONST(12952) = (KAPNO)
  RCONST(12953) = (KFPAN)
  RCONST(12954) = (KRO2NO3*1.74)
  RCONST(12955) = (1.00D-11*0.7*RO2)
  RCONST(12956) = (1.00D-11*0.3*RO2)
  RCONST(12957) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12958) = (4.23D-12)
  RCONST(12959) = (KBPAN)
  RCONST(12960) = (3.12D-13)
  RCONST(12961) = (KAPHO2*0.56)
  RCONST(12962) = (KAPHO2*0.44)
  RCONST(12963) = (KAPNO)
  RCONST(12964) = (KFPAN)
  RCONST(12965) = (KRO2NO3*1.74)
  RCONST(12966) = (1.00D-11*RO2)
  RCONST(12967) = (KRO2HO2*0.706)
  RCONST(12968) = (KRO2NO)
  RCONST(12969) = (KRO2NO3)
  RCONST(12970) = (2.00D-12*RO2)
  RCONST(12971) = (5.35D-12)
  RCONST(12972) = (j('ch3o2h'))
  RCONST(12973) = (1.76D-12)
  RCONST(12974) = (KBPAN)
  RCONST(12975) = (KAPHO2*0.15)
  RCONST(12976) = (KAPHO2*0.41)
  RCONST(12977) = (KAPHO2*0.44)
  RCONST(12978) = (KAPNO)
  RCONST(12979) = (KFPAN)
  RCONST(12980) = (KRO2NO3*1.74)
  RCONST(12981) = (1.00D-11*RO2*0.3)
  RCONST(12982) = (1.00D-11*RO2*0.7)
  RCONST(12983) = (KAPHO2*0.44)
  RCONST(12984) = (KAPHO2*0.56)
  RCONST(12985) = (KAPNO)
  RCONST(12986) = (KFPAN)
  RCONST(12987) = (KRO2NO3*1.74)
  RCONST(12988) = (1.00D-11*RO2)
  RCONST(12989) = (KAPHO2*0.44)
  RCONST(12990) = (KAPHO2*0.56)
  RCONST(12991) = (KAPNO)
  RCONST(12992) = (KFPAN)
  RCONST(12993) = (KRO2NO3*1.74)
  RCONST(12994) = (1.00D-11*RO2)
  RCONST(12995) = (KAPHO2*0.56)
  RCONST(12996) = (KAPHO2*0.44)
  RCONST(12997) = (KAPNO)
  RCONST(12998) = (KFPAN)
  RCONST(12999) = (KRO2NO3*1.74)
  RCONST(13000) = (1.00D-11*RO2)
  RCONST(13001) = (8.01D-11)
  RCONST(13002) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13003) = (7.03D-11)
  RCONST(13004) = (j('2_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(13005) = (KDEC)
  RCONST(13006) = (7.66D-11)
  RCONST(13007) = (j('n_c3h7cho_hco'))
  RCONST(13008) = (KRO2HO2*0.820)
  RCONST(13009) = (KRO2NO)
  RCONST(13010) = (KRO2NO3)
  RCONST(13011) = (2.50D-13*RO2)
  RCONST(13012) = (2.00D-10)
  RCONST(13013) = (j('ch3o2h')+j('biacet'))
  RCONST(13014) = (2.23D-11)
  RCONST(13015) = (j('1_c4h9ono2')+j('biacet'))
  RCONST(13016) = (KROSEC*O2)
  RCONST(13017) = (1.26D-10)
  RCONST(13018) = (j('biacet'))
  RCONST(13019) = (1.04D-11)
  RCONST(13020) = (j('ch3o2h'))
  RCONST(13021) = (KRO2HO2*0.859)
  RCONST(13022) = (KRO2NO*0.138)
  RCONST(13023) = (KRO2NO*0.862)
  RCONST(13024) = (KRO2NO3)
  RCONST(13025) = (1.30D-12*RO2*0.2)
  RCONST(13026) = (1.30D-12*RO2*0.6)
  RCONST(13027) = (1.30D-12*RO2*0.2)
  RCONST(13028) = (7.29D-12)
  RCONST(13029) = (6.77D-12)
  RCONST(13030) = (KBPAN)
  RCONST(13031) = (KRO2HO2*0.625)
  RCONST(13032) = (KRO2NO)
  RCONST(13033) = (KRO2NO3)
  RCONST(13034) = (2.00D-12*RO2)
  RCONST(13035) = (1.29D-11)
  RCONST(13036) = (j('ch3o2h')+j('mek'))
  RCONST(13037) = (KDEC)
  RCONST(13038) = (2.05D-11)
  RCONST(13039) = (j('ch3o2h')+j('biacet'))
  RCONST(13040) = (5.37D-12)
  RCONST(13041) = (j('2_c4h9ono2')+j('biacet'))
  RCONST(13042) = (KDEC)
  RCONST(13043) = (1.69D-11)
  RCONST(13044) = (j('biacet'))
  RCONST(13045) = (3.45D-11)
  RCONST(13046) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13047) = (KDEC)
  RCONST(13048) = (KAPHO2*0.44)
  RCONST(13049) = (KAPHO2*0.15)
  RCONST(13050) = (KAPHO2*0.41)
  RCONST(13051) = (KAPNO)
  RCONST(13052) = (KFPAN)
  RCONST(13053) = (KRO2NO3*1.74)
  RCONST(13054) = (1.00D-11*RO2*0.7)
  RCONST(13055) = (1.00D-11*RO2*0.3)
  RCONST(13056) = (KRO2HO2*0.770)
  RCONST(13057) = (KRO2NO)
  RCONST(13058) = (KRO2NO3)
  RCONST(13059) = (2.00D-12*RO2*0.2)
  RCONST(13060) = (2.00D-12*RO2*0.6)
  RCONST(13061) = (2.00D-12*RO2*0.2)
  RCONST(13062) = (1.01D-10)
  RCONST(13063) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(13064) = (9.14D-11)
  RCONST(13065) = (j('2_c4h9ono2')+j('n_c3h7cho_hco')*2)
  RCONST(13066) = (KDEC)
  RCONST(13067) = (9.73D-11)
  RCONST(13068) = (j('n_c3h7cho_hco'))
  RCONST(13069) = (8.67D-11)
  RCONST(13070) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13071) = (KDEC)
  RCONST(13072) = (7.09D-11)
  RCONST(13073) = (j('n_c3h7cho_hco'))
  RCONST(13074) = (7.44D-11)
  RCONST(13075) = (9.73D-11)
  RCONST(13076) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(13077) = (9.23D-11)
  RCONST(13078) = (j('1_c4h9ono2')+j('n_c3h7cho_hco')*2)
  RCONST(13079) = (KDEC)
  RCONST(13080) = (9.03D-11)
  RCONST(13081) = (j('n_c3h7cho_hco')*2)
  RCONST(13082) = (1.02D-11)
  RCONST(13083) = (1.37D-11)
  RCONST(13084) = (j('ch3o2h'))
  RCONST(13085) = (7.50D-12)
  RCONST(13086) = (KBPAN)
  RCONST(13087) = (5.71D-11)
  RCONST(13088) = (j('ch3o2h'))
  RCONST(13089) = (KDEC)
  RCONST(13090) = (5.80D-12)
  RCONST(13091) = (2.58D-11)
  RCONST(13092) = (1.01D-10)
  RCONST(13093) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13094) = (6.65D-11)
  RCONST(13095) = (j('n_c3h7ono2')+j('n_c3h7cho_hco'))
  RCONST(13096) = (8.40D+10*EXP(-2567/TEMP))
  RCONST(13097) = (KDEC)
  RCONST(13098) = (7.96D-11)
  RCONST(13099) = (j('n_c3h7cho_hco'))
  RCONST(13100) = (5.95D-11)
  RCONST(13101) = (j('ch3o2h'))
  RCONST(13102) = (KDEC)
  RCONST(13103) = (2.82D-11)
  RCONST(13104) = (KRO2HO2*0.914)
  RCONST(13105) = (KRO2NO*0.104)
  RCONST(13106) = (KRO2NO*0.896)
  RCONST(13107) = (KRO2NO3)
  RCONST(13108) = (6.70D-15*RO2*0.7)
  RCONST(13109) = (6.70D-15*RO2*0.3)
  RCONST(13110) = (KNO3AL*5.5)
  RCONST(13111) = (2.69D-11)
  RCONST(13112) = (j('n_c3h7cho_hco'))
  RCONST(13113) = (KRO2HO2*0.859)
  RCONST(13114) = (KRO2NO)
  RCONST(13115) = (KRO2NO3)
  RCONST(13116) = (1.30D-12*0.2)
  RCONST(13117) = (1.30D-12*0.6)
  RCONST(13118) = (1.30D-12*0.2)
  RCONST(13119) = (KAPHO2*0.56)
  RCONST(13120) = (KAPHO2*0.44)
  RCONST(13121) = (KAPNO)
  RCONST(13122) = (KFPAN)
  RCONST(13123) = (KRO2NO3*1.74)
  RCONST(13124) = (1.00D-11*RO2)
  RCONST(13125) = (3.19D-11)
  RCONST(13126) = (j('n_c3h7cho_hco'))
  RCONST(13127) = (3.50D-11)
  RCONST(13128) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13129) = (3.14D-11)
  RCONST(13130) = (KBPAN)
  RCONST(13131) = (4.38D-11)
  RCONST(13132) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13133) = (2.84D-11)
  RCONST(13134) = (j('n_c3h7ono2'))
  RCONST(13135) = (KDEC)
  RCONST(13136) = (5.13D-11)
  RCONST(13137) = (KNO3AL*8.5)
  RCONST(13138) = (4.35D-11)
  RCONST(13139) = (j('n_c3h7cho_hco'))
  RCONST(13140) = (5.07D-11)
  RCONST(13141) = (j('ch3o2h'))
  RCONST(13142) = (j('mek')+j('n_c3h7cho_hco')*2)
  RCONST(13143) = (KDEC)
  RCONST(13144) = (4.73D-11)
  RCONST(13145) = (j('mek')+j('n_c3h7cho_hco')*2)
  RCONST(13146) = (KRO2HO2*0.770)
  RCONST(13147) = (KRO2NO)
  RCONST(13148) = (KRO2NO3)
  RCONST(13149) = (9.20D-14*RO2*0.7)
  RCONST(13150) = (9.20D-14*RO2*0.3)
  RCONST(13151) = (KDEC)
  RCONST(13152) = (KRO2HO2*0.770)
  RCONST(13153) = (KRO2NO*0.031)
  RCONST(13154) = (KRO2NO*0.969)
  RCONST(13155) = (KRO2NO3)
  RCONST(13156) = (9.20D-14*RO2*0.7)
  RCONST(13157) = (9.20D-14*RO2*0.3)
  RCONST(13158) = (KRO2HO2*0.770)
  RCONST(13159) = (KRO2NO*0.078)
  RCONST(13160) = (KRO2NO*0.922)
  RCONST(13161) = (KRO2NO3)
  RCONST(13162) = (1.30D-12*RO2*0.2)
  RCONST(13163) = (1.30D-12*RO2*0.6)
  RCONST(13164) = (1.30D-12*RO2*0.2)
  RCONST(13165) = (9.71D-11)
  RCONST(13166) = (j('ch3o2h'))
  RCONST(13167) = (8.31D-11)
  RCONST(13168) = (j('n_c3h7ono2'))
  RCONST(13169) = (KDEC)
  RCONST(13170) = (8.80D-11)
  RCONST(13171) = (6.18D-11)
  RCONST(13172) = (j('ch3o2h'))
  RCONST(13173) = (KRO2HO2*0.859)
  RCONST(13174) = (KRO2NO*0.138)
  RCONST(13175) = (KRO2NO*0.862)
  RCONST(13176) = (KRO2NO3)
  RCONST(13177) = (1.30D-12*RO2*0.2)
  RCONST(13178) = (1.30D-12*RO2*0.6)
  RCONST(13179) = (1.30D-12*RO2*0.2)
  RCONST(13180) = (5.89D-11)
  RCONST(13181) = (5.82D-11)
  RCONST(13182) = (KBPAN)
  RCONST(13183) = (2.45D-11)
  RCONST(13184) = (j('ch3o2h'))
  RCONST(13185) = (KDEC)
  RCONST(13186) = (6.00D-11)
  RCONST(13187) = (6.31D-11)
  RCONST(13188) = (j('ch3o2h'))
  RCONST(13189) = (5.95D-11)
  RCONST(13190) = (KBPAN)
  RCONST(13191) = (KRO2HO2)
  RCONST(13192) = (KRO2NO)
  RCONST(13193) = (KRO2NO3)
  RCONST(13194) = (9.20D-14*RO2)
  RCONST(13195) = (KAPHO2*0.44)
  RCONST(13196) = (KAPHO2*0.15)
  RCONST(13197) = (KAPHO2*0.41)
  RCONST(13198) = (KAPNO)
  RCONST(13199) = (KFPAN)
  RCONST(13200) = (KRO2NO3*1.74)
  RCONST(13201) = (1.00D-11*RO2*0.7)
  RCONST(13202) = (1.00D-11*RO2*0.3)
  RCONST(13203) = (1.14D-11)
  RCONST(13204) = (1.45D-11)
  RCONST(13205) = (j('ch3o2h'))
  RCONST(13206) = (KRO2HO2*0.914)
  RCONST(13207) = (KRO2NO*0.228)
  RCONST(13208) = (KRO2NO*0.772)
  RCONST(13209) = (KRO2NO3)
  RCONST(13210) = (2.50D-13*RO2*0.2)
  RCONST(13211) = (2.50D-13*RO2*0.6)
  RCONST(13212) = (2.50D-13*RO2*0.2)
  RCONST(13213) = (1.09D-11)
  RCONST(13214) = (KBPAN)
  RCONST(13215) = (KDEC*0.1)
  RCONST(13216) = (KDEC*0.9)
  RCONST(13217) = (3.85D-11)
  RCONST(13218) = (4.14D-11)
  RCONST(13219) = (j('ch3o2h'))
  RCONST(13220) = (3.78D-11)
  RCONST(13221) = (KBPAN)
  RCONST(13222) = (1.90D-11)
  RCONST(13223) = (j('ch3o2h'))
  RCONST(13224) = (KDEC)
  RCONST(13225) = (1.55D-11)
  RCONST(13226) = (5.89D-11)
  RCONST(13227) = (6.18D-11)
  RCONST(13228) = (j('ch3o2h'))
  RCONST(13229) = (KRO2HO2*0.959)
  RCONST(13230) = (KRO2NO*0.178)
  RCONST(13231) = (KRO2NO*0.822)
  RCONST(13232) = (KRO2NO3)
  RCONST(13233) = (1.30D-12*RO2*0.2)
  RCONST(13234) = (1.30D-12*RO2*0.6)
  RCONST(13235) = (1.30D-12*RO2*0.2)
  RCONST(13236) = (5.82D-11)
  RCONST(13237) = (KBPAN)
  RCONST(13238) = (1.13D-11)
  RCONST(13239) = (1.44D-11)
  RCONST(13240) = (j('ch3o2h'))
  RCONST(13241) = (KRO2HO2*0.914)
  RCONST(13242) = (KRO2NO*0.228)
  RCONST(13243) = (KRO2NO*0.772)
  RCONST(13244) = (KRO2NO3)
  RCONST(13245) = (2.50D-13*RO2*0.2)
  RCONST(13246) = (2.50D-13*RO2*0.6)
  RCONST(13247) = (2.50D-13*RO2*0.2)
  RCONST(13248) = (1.08D-11)
  RCONST(13249) = (KBPAN)
  RCONST(13250) = (KRO2HO2*0.914)
  RCONST(13251) = (KRO2NO*0.125)
  RCONST(13252) = (KRO2NO*0.875)
  RCONST(13253) = (KRO2NO3)
  RCONST(13254) = (6.70D-15*RO2*0.7)
  RCONST(13255) = (6.70D-15*RO2*0.3)
  RCONST(13256) = (1.02D-10)
  RCONST(13257) = (j('ch3o2h'))
  RCONST(13258) = (8.34D-11)
  RCONST(13259) = (j('1_c4h9ono2'))
  RCONST(13260) = (KDEC)
  RCONST(13261) = (9.34D-11)
  RCONST(13262) = (KRO2HO2*0.932)
  RCONST(13263) = (KRO2NO*0.129)
  RCONST(13264) = (KRO2NO*0.871)
  RCONST(13265) = (KRO2NO3)
  RCONST(13266) = (9.20D-14*RO2*0.7)
  RCONST(13267) = (9.20D-14*RO2*0.3)
  RCONST(13268) = (KAPHO2*0.15)
  RCONST(13269) = (KAPHO2*0.41)
  RCONST(13270) = (KAPHO2*0.44)
  RCONST(13271) = (KAPNO)
  RCONST(13272) = (KFPAN)
  RCONST(13273) = (KRO2NO3*1.74)
  RCONST(13274) = (1.00D-11*RO2*0.3)
  RCONST(13275) = (1.00D-11*RO2*0.7)
  RCONST(13276) = (8.69D-11)
  RCONST(13277) = (j('ch3o2h'))
  RCONST(13278) = (5.82D-11)
  RCONST(13279) = (j('2_c4h9ono2'))
  RCONST(13280) = (KDEC)
  RCONST(13281) = (7.47D-11)
  RCONST(13282) = (KRO2HO2*0.968)
  RCONST(13283) = (KRO2NO)
  RCONST(13284) = (KRO2NO3)
  RCONST(13285) = (9.20D-14*RO2*0.7)
  RCONST(13286) = (9.20D-14*RO2*0.3)
  RCONST(13287) = (KRO2HO2*0.890)
  RCONST(13288) = (KRO2NO*0.118)
  RCONST(13289) = (KRO2NO*0.872)
  RCONST(13290) = (KRO2NO3)
  RCONST(13291) = (6.70D-15*RO2*0.7)
  RCONST(13292) = (6.70D-15*RO2*0.3)
  RCONST(13293) = (8.69D-11)
  RCONST(13294) = (j('ch3o2h'))
  RCONST(13295) = (5.82D-11)
  RCONST(13296) = (j('1_c4h9ono2'))
  RCONST(13297) = (KROSEC*O2)
  RCONST(13298) = (2.70D+14*EXP(-6643/TEMP))
  RCONST(13299) = (7.47D-11)
  RCONST(13300) = (KRO2HO2*0.947)
  RCONST(13301) = (KRO2NO)
  RCONST(13302) = (KRO2NO3)
  RCONST(13303) = (9.20D-14*RO2*0.7)
  RCONST(13304) = (9.20D-14*RO2*0.3)
  RCONST(13305) = (KRO2HO2*0.706)
  RCONST(13306) = (KRO2NO)
  RCONST(13307) = (KRO2NO3)
  RCONST(13308) = (8.80D-13*RO2)
  RCONST(13309) = (KRO2HO2*0.770)
  RCONST(13310) = (KRO2NO)
  RCONST(13311) = (KRO2NO3)
  RCONST(13312) = (8.80D-13*RO2)
  RCONST(13313) = (j('ch3o2h'))
  RCONST(13314) = (3.01D-11)
  RCONST(13315) = (1.90D-12*EXP(190/TEMP))
  RCONST(13316) = (1.19D-11)
  RCONST(13317) = (2.00D+14*EXP(-5556/TEMP))
  RCONST(13318) = (2.46D-11)
  RCONST(13319) = (j('n_c3h7cho_hco'))
  RCONST(13320) = (KNO3AL*5.5)
  RCONST(13321) = (4.03D-11)
  RCONST(13322) = (KAPHO2*0.56)
  RCONST(13323) = (KAPHO2*0.44)
  RCONST(13324) = (KAPNO)
  RCONST(13325) = (KFPAN)
  RCONST(13326) = (KRO2NO3)
  RCONST(13327) = (1.00D-11*RO2)
  RCONST(13328) = (j('ch3o2h')+j('mek'))
  RCONST(13329) = (1.32D-11)
  RCONST(13330) = (KDEC)
  RCONST(13331) = (j('ch3o2h')+j('mek'))
  RCONST(13332) = (5.33D-12)
  RCONST(13333) = (KBPAN)
  RCONST(13334) = (1.41D-12)
  RCONST(13335) = (KRO2HO2*0.820)
  RCONST(13336) = (KRO2NO)
  RCONST(13337) = (KRO2NO3)
  RCONST(13338) = (8.80D-13*RO2)
  RCONST(13339) = (KRO2HO2*0.820)
  RCONST(13340) = (KRO2NO)
  RCONST(13341) = (KRO2NO3)
  RCONST(13342) = (8.80D-13*RO2)
  RCONST(13343) = (j('ch3o2h'))
  RCONST(13344) = (3.99D-11)
  RCONST(13345) = (KBPAN)
  RCONST(13346) = (1.35D-11)
  RCONST(13347) = (j('ch3o2h'))
  RCONST(13348) = (j('mek')*2)
  RCONST(13349) = (3.55D-11)
  RCONST(13350) = (2.00D+14*EXP(-5489/TEMP))
  RCONST(13351) = (KRO2HO2*0.820)
  RCONST(13352) = (KRO2NO)
  RCONST(13353) = (KRO2NO3)
  RCONST(13354) = (9.20D-14*RO2)
  RCONST(13355) = (j('ch3o2h'))
  RCONST(13356) = (6.08D-12)
  RCONST(13357) = (KBPAN)
  RCONST(13358) = (1.97D-12)
  RCONST(13359) = (j('ch3o2h'))
  RCONST(13360) = (2.97D-11)
  RCONST(13361) = (6.00D-12)
  RCONST(13362) = (2.00D+14*EXP(-4909/TEMP))
  RCONST(13363) = (1.45D-11)
  RCONST(13364) = (j('mek'))
  RCONST(13365) = (9.41D-12)
  RCONST(13366) = (KRO2HO2*0.859)
  RCONST(13367) = (KRO2NO)
  RCONST(13368) = (KRO2NO3)
  RCONST(13369) = (8.80D-13*RO2)
  RCONST(13370) = (j('ch3o2h'))
  RCONST(13371) = (3.99D-11)
  RCONST(13372) = (KBPAN)
  RCONST(13373) = (1.33D-11)
  RCONST(13374) = (KRO2HO2*0.890)
  RCONST(13375) = (KRO2NO)
  RCONST(13376) = (KRO2NO3)
  RCONST(13377) = (8.80D-13*RO2)
  RCONST(13378) = (j('ch3o2h'))
  RCONST(13379) = (4.13D-11)
  RCONST(13380) = (KBPAN)
  RCONST(13381) = (1.49D-11)
  RCONST(13382) = (KRO2HO2*0.914)
  RCONST(13383) = (KRO2NO)
  RCONST(13384) = (KRO2NO3)
  RCONST(13385) = (8.80D-13*RO2)
  RCONST(13386) = (j('ch3o2h'))
  RCONST(13387) = (4.27D-11)
  RCONST(13388) = (KBPAN)
  RCONST(13389) = (1.63D-11)
  RCONST(13390) = (KRO2HO2*0.932)
  RCONST(13391) = (KRO2NO)
  RCONST(13392) = (KRO2NO3)
  RCONST(13393) = (8.80D-13*RO2)
  RCONST(13394) = (j('ch3o2h'))
  RCONST(13395) = (4.41D-11)
  RCONST(13396) = (KBPAN)
  RCONST(13397) = (1.77D-11)
  RCONST(13398) = (KRO2HO2*0.947)
  RCONST(13399) = (KRO2NO)
  RCONST(13400) = (KRO2NO3)
  RCONST(13401) = (8.80D-13*RO2)
  RCONST(13402) = (j('ch3o2h'))
  RCONST(13403) = (4.55D-11)
  RCONST(13404) = (KBPAN)
  RCONST(13405) = (1.91D-11)
  RCONST(13406) = (KDEC)
  RCONST(13407) = (KAPHO2*0.56)
  RCONST(13408) = (KAPHO2*0.44)
  RCONST(13409) = (KAPNO)
  RCONST(13410) = (KFPAN)
  RCONST(13411) = (KRO2NO3*1.74)
  RCONST(13412) = (1.00D-11*RO2)
  RCONST(13413) = (8.01D-11)
  RCONST(13414) = (j('ch3o2h'))
  RCONST(13415) = (7.66D-11)
  RCONST(13416) = (KBPAN)
  RCONST(13417) = (KAPHO2*0.56)
  RCONST(13418) = (KAPHO2*0.44)
  RCONST(13419) = (KAPNO)
  RCONST(13420) = (KFPAN)
  RCONST(13421) = (KRO2NO3*1.74)
  RCONST(13422) = (1.00D-11*RO2)
  RCONST(13423) = (9.29D-11)
  RCONST(13424) = (j('ch3o2h'))
  RCONST(13425) = (8.96D-11)
  RCONST(13426) = (KBPAN)
  RCONST(13427) = (KDEC)
  RCONST(13428) = (3.59D-12)
  RCONST(13429) = (j('ch3o2h'))
  RCONST(13430) = (1.00D-14)
  RCONST(13431) = (KBPAN)
  RCONST(13432) = (KAPHO2*0.56)
  RCONST(13433) = (KAPHO2*0.44)
  RCONST(13434) = (KAPNO)
  RCONST(13435) = (KFPAN)
  RCONST(13436) = (KRO2NO3*1.74)
  RCONST(13437) = (1.00D-11*RO2)
  RCONST(13438) = (9.83D-11)
  RCONST(13439) = (j('ch3o2h'))
  RCONST(13440) = (9.51D-11)
  RCONST(13441) = (KBPAN)
  RCONST(13442) = (4.16D-12)
  RCONST(13443) = (j('ch3o2h')+j('biacet'))
  RCONST(13444) = (5.66D-13)
  RCONST(13445) = (KBPAN)
  RCONST(13446) = (6.58D-12)
  RCONST(13447) = (9.69D-12)
  RCONST(13448) = (j('ch3o2h'))
  RCONST(13449) = (6.46D-12)
  RCONST(13450) = (KBPAN)
  RCONST(13451) = (8.76D-13)
  RCONST(13452) = (4.34D-12)
  RCONST(13453) = (j('ch3o2h'))
  RCONST(13454) = (7.36D-13)
  RCONST(13455) = (KBPAN)
  RCONST(13456) = (2.15D-11)
  RCONST(13457) = (j('mek')+j('ch3cocho'))
  RCONST(13458) = (2.75D-11)
  RCONST(13459) = (j('ch3o2h'))
  RCONST(13460) = (2.42D-11)
  RCONST(13461) = (KBPAN)
  RCONST(13462) = (KAPHO2*0.56)
  RCONST(13463) = (KAPHO2*0.44)
  RCONST(13464) = (KAPNO)
  RCONST(13465) = (KFPAN)
  RCONST(13466) = (KRO2NO3*1.74)
  RCONST(13467) = (1.00D-11*RO2)
  RCONST(13468) = (2.75D-11)
  RCONST(13469) = (j('ch3o2h'))
  RCONST(13470) = (2.42D-11)
  RCONST(13471) = (KBPAN)
  RCONST(13472) = (KAPHO2*0.44)
  RCONST(13473) = (KAPHO2*0.56)
  RCONST(13474) = (KAPNO)
  RCONST(13475) = (KFPAN)
  RCONST(13476) = (KRO2NO3*1.74)
  RCONST(13477) = (1.00D-11*RO2)
  RCONST(13478) = (9.46D-11)
  RCONST(13479) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(13480) = (9.14D-11)
  RCONST(13481) = (KBPAN)
  RCONST(13482) = (KDEC)
  RCONST(13483) = (6.09D-12)
  RCONST(13484) = (j('ch3o2h')+j('biacet')*2)
  RCONST(13485) = (2.49D-12)
  RCONST(13486) = (KBPAN)
  RCONST(13487) = (KAPHO2*0.44)
  RCONST(13488) = (KAPHO2*0.56)
  RCONST(13489) = (KAPNO)
  RCONST(13490) = (KFPAN)
  RCONST(13491) = (KRO2NO3*1.74)
  RCONST(13492) = (1.00D-11*RO2)
  RCONST(13493) = (9.62D-11)
  RCONST(13494) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(13495) = (9.29D-11)
  RCONST(13496) = (KBPAN)
  RCONST(13497) = (KDEC)
  RCONST(13498) = (KAPHO2*0.56)
  RCONST(13499) = (KAPHO2*0.44)
  RCONST(13500) = (KAPNO)
  RCONST(13501) = (KFPAN)
  RCONST(13502) = (KRO2NO3*1.74)
  RCONST(13503) = (1.00D-11*RO2)
  RCONST(13504) = (9.68D-11)
  RCONST(13505) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(13506) = (9.35D-11)
  RCONST(13507) = (KBPAN)
  RCONST(13508) = (KDEC)
  RCONST(13509) = (4.60D-12)
  RCONST(13510) = (j('ch3o2h'))
  RCONST(13511) = (KDEC)
  RCONST(13512) = (4.79D-12)
  RCONST(13513) = (j('ch3o2h'))
  RCONST(13514) = (KDEC)
  RCONST(13515) = (1.34D-12)
  RCONST(13516) = (3.30D-11)
  RCONST(13517) = (j('ch3o2h'))
  RCONST(13518) = (2.97D-11)
  RCONST(13519) = (KBPAN)
  RCONST(13520) = (1.48D-11)
  RCONST(13521) = (j('biacet'))
  RCONST(13522) = (j('ch3cocho'))
  RCONST(13523) = (KAPHO2*0.56)
  RCONST(13524) = (KAPHO2*0.44)
  RCONST(13525) = (KAPNO)
  RCONST(13526) = (KFPAN)
  RCONST(13527) = (KRO2NO3*1.74)
  RCONST(13528) = (1.00D-11*RO2)
  RCONST(13529) = (1.00D-10)
  RCONST(13530) = (j('ch3o2h'))
  RCONST(13531) = (9.68D-11)
  RCONST(13532) = (KBPAN)
  RCONST(13533) = (KAPHO2*0.56)
  RCONST(13534) = (KAPHO2*0.44)
  RCONST(13535) = (KAPNO)
  RCONST(13536) = (KFPAN)
  RCONST(13537) = (KRO2NO3*1.74)
  RCONST(13538) = (1.00D-11*RO2)
  RCONST(13539) = (2.92D-11)
  RCONST(13540) = (j('ch3o2h'))
  RCONST(13541) = (2.56D-11)
  RCONST(13542) = (KBPAN)
  RCONST(13543) = (KAPHO2*0.56)
  RCONST(13544) = (KAPHO2*0.44)
  RCONST(13545) = (KAPNO)
  RCONST(13546) = (KFPAN)
  RCONST(13547) = (KRO2NO3*1.74)
  RCONST(13548) = (1.00D-11*RO2)
  RCONST(13549) = (2.86D-11)
  RCONST(13550) = (j('ch3o2h'))
  RCONST(13551) = (2.54D-11)
  RCONST(13552) = (KBPAN)
  RCONST(13553) = (1.11D-11)
  RCONST(13554) = (1.42D-11)
  RCONST(13555) = (j('ch3o2h'))
  RCONST(13556) = (1.10D-11)
  RCONST(13557) = (KBPAN)
  RCONST(13558) = (1.46D-10)
  RCONST(13559) = (j('ch3o2h'))
  RCONST(13560) = (KDEC)
  RCONST(13561) = (2.62D-11)
  RCONST(13562) = (j('ch3cocho'))
  RCONST(13563) = (KAPHO2*0.56)
  RCONST(13564) = (KAPHO2*0.44)
  RCONST(13565) = (KAPNO)
  RCONST(13566) = (KFPAN)
  RCONST(13567) = (KRO2NO3*1.6)
  RCONST(13568) = (1.00D-11*RO2)
  RCONST(13569) = (KRO2HO2*0.706)
  RCONST(13570) = (KRO2NO)
  RCONST(13571) = (KRO2NO3)
  RCONST(13572) = (8.80D-13*RO2)
  RCONST(13573) = (7.71D-12)
  RCONST(13574) = (j('ch3coch2ono2')*10)
  RCONST(13575) = (4.11D-12)
  RCONST(13576) = (KBPAN+j('ch3coch2ono2')*10)
  RCONST(13577) = (7.40D-12)
  RCONST(13578) = (1.09D-11)
  RCONST(13579) = (j('ch3o2h'))
  RCONST(13580) = (7.26D-12)
  RCONST(13581) = (KBPAN)
  RCONST(13582) = (1.72D-12)
  RCONST(13583) = (5.18D-12)
  RCONST(13584) = (j('ch3o2h'))
  RCONST(13585) = (1.58D-12)
  RCONST(13586) = (KBPAN)
  RCONST(13587) = (1.73D-12)
  RCONST(13588) = (5.19D-12)
  RCONST(13589) = (j('ch3o2h'))
  RCONST(13590) = (1.59D-12)
  RCONST(13591) = (KBPAN)
  RCONST(13592) = (2.23D-11)
  RCONST(13593) = (j('ch3coch2ono2')*0.91)
  RCONST(13594) = (2.59D-11)
  RCONST(13595) = (j('ch3coch2ono2')*0.91)
  RCONST(13596) = (2.18D-11)
  RCONST(13597) = (KBPAN+j('ch3coch2ono2')*0.91)
  RCONST(13598) = (8.64D-12)
  RCONST(13599) = (j('ch3o2h')*2)
  RCONST(13600) = (5.04D-12)
  RCONST(13601) = (KBPAN+j('ch3o2h'))
  RCONST(13602) = (j('ch3coch2ono2')*1.6)
  RCONST(13603) = (9.35D-13)
  RCONST(13604) = (j('ch3coch2ono2')*1.6)
  RCONST(13605) = (4.02D-12)
  RCONST(13606) = (j('ch3coch2ono2')*1.6+KBPAN)
  RCONST(13607) = (4.15D-13)
  RCONST(13608) = (4.30D-11)
  RCONST(13609) = (j('ch3o2h'))
  RCONST(13610) = (j('i_c3h7cho'))
  RCONST(13611) = (KDEC)
  RCONST(13612) = (5.74D-11)
  RCONST(13613) = (j('ch3o2h'))
  RCONST(13614) = (j('n_c3h7cho_hco'))
  RCONST(13615) = (KDEC)
  RCONST(13616) = (2.98D-11)
  RCONST(13617) = (j('ch3coch2ono2')*0.91)
  RCONST(13618) = (1.93D-11)
  RCONST(13619) = (j('ch3coch2ono2')*0.91)
  RCONST(13620) = (3.85D-12)
  RCONST(13621) = (j('ch3coch2ono2')*1.6)
  RCONST(13622) = (2.67D-11)
  RCONST(13623) = (j('ch3coch2ono2')*0.91)
  RCONST(13624) = (9.90D-13)
  RCONST(13625) = (4.55D-12)
  RCONST(13626) = (j('ch3o2h'))
  RCONST(13627) = (9.55D-13)
  RCONST(13628) = (KBPAN)
  RCONST(13629) = (j('ch3o2h'))
  RCONST(13630) = (1.86D-11)
  RCONST(13631) = (KBPAN)
  RCONST(13632) = (8.22D-12)
  RCONST(13633) = (1.31D-11)
  RCONST(13634) = (j('ch3o2h'))
  RCONST(13635) = (KDEC)
  RCONST(13636) = (2.64D-11)
  RCONST(13637) = (3.00D-11)
  RCONST(13638) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13639) = (2.64D-11)
  RCONST(13640) = (KBPAN)
  RCONST(13641) = (7.55D-11)
  RCONST(13642) = (j('ch3o2h')+j('mek')+j('n_c3h7cho_hco'))
  RCONST(13643) = (7.19D-11)
  RCONST(13644) = (KBPAN)
  RCONST(13645) = (KRO2HO2*0.706)
  RCONST(13646) = (KRO2NO)
  RCONST(13647) = (KRO2NO3)
  RCONST(13648) = (2.00D-12*RO2)
  RCONST(13649) = (1.68D-11)
  RCONST(13650) = (j('ch3o2h')+j('mek')+j('ch3cocho'))
  RCONST(13651) = (1.32D-11)
  RCONST(13652) = (KBPAN)
  RCONST(13653) = (4.75D-12)
  RCONST(13654) = (j('ch3o2h')+j('biacet'))
  RCONST(13655) = (KRO2HO2*0.770)
  RCONST(13656) = (KRO2NO)
  RCONST(13657) = (KRO2NO3)
  RCONST(13658) = (2.00D-12*RO2)
  RCONST(13659) = (8.83D-13)
  RCONST(13660) = (KBPAN)
  RCONST(13661) = (KRO2HO2*0.820)
  RCONST(13662) = (KRO2NO)
  RCONST(13663) = (KRO2NO3)
  RCONST(13664) = (8.80D-13*0.6*RO2)
  RCONST(13665) = (8.80D-13*0.2*RO2)
  RCONST(13666) = (8.80D-13*0.2*RO2)
  RCONST(13667) = (3.25D-11)
  RCONST(13668) = (j('ch3o2h'))
  RCONST(13669) = (4.00D+04)
  RCONST(13670) = (KROSEC*O2)
  RCONST(13671) = (1.70D-11)
  RCONST(13672) = (j('ch3o2h'))
  RCONST(13673) = (3.29D-12)
  RCONST(13674) = (j('n_c3h7ono2'))
  RCONST(13675) = (KDEC)
  RCONST(13676) = (KNO3AL*8.5)
  RCONST(13677) = (2.63D-11)
  RCONST(13678) = (j('n_c3h7cho_hco'))
  RCONST(13679) = (7.89D-12)
  RCONST(13680) = (8.33D-11)
  RCONST(13681) = (j('ch3o2h')+j('mek')+j('n_c3h7cho_hco'))
  RCONST(13682) = (KDEC)
  RCONST(13683) = (KRO2HO2*0.890)
  RCONST(13684) = (KRO2NO)
  RCONST(13685) = (KRO2NO3)
  RCONST(13686) = (6.70D-15*RO2)
  RCONST(13687) = (3.22D-12)
  RCONST(13688) = (j('mek'))
  RCONST(13689) = (KRO2HO2*0.770)
  RCONST(13690) = (KRO2NO*0.098)
  RCONST(13691) = (KRO2NO*0.902)
  RCONST(13692) = (KRO2NO3)
  RCONST(13693) = (8.80D-13*0.2*RO2)
  RCONST(13694) = (8.80D-13*0.6*RO2)
  RCONST(13695) = (8.80D-13*0.2*RO2)
  RCONST(13696) = (KRO2HO2*0.706)
  RCONST(13697) = (KRO2NO)
  RCONST(13698) = (KRO2NO3)
  RCONST(13699) = (8.80D-13*RO2)
  RCONST(13700) = (2.39D-11)
  RCONST(13701) = (j('mek')*2)
  RCONST(13702) = (2.70D-11)
  RCONST(13703) = (j('ch3o2h')+j('mek')*2)
  RCONST(13704) = (2.29D-11)
  RCONST(13705) = (KBPAN)
  RCONST(13706) = (3.23D-11)
  RCONST(13707) = (j('ch3o2h')+j('mek')*2)
  RCONST(13708) = (KDEC)
  RCONST(13709) = (3.55D-11)
  RCONST(13710) = (j('ch3cocho'))
  RCONST(13711) = (2.54D-11*0.890)
  RCONST(13712) = (2.54D-11*0.110)
  RCONST(13713) = (j('mek')*2)
  RCONST(13714) = (KRO2HO2*0.770)
  RCONST(13715) = (KRO2NO)
  RCONST(13716) = (KRO2NO3)
  RCONST(13717) = (8.80D-13*RO2*0.2)
  RCONST(13718) = (8.80D-13*RO2*0.6)
  RCONST(13719) = (8.80D-13*RO2*0.2)
  RCONST(13720) = (KAPHO2*0.15)
  RCONST(13721) = (KAPHO2*0.41)
  RCONST(13722) = (KAPHO2*0.44)
  RCONST(13723) = (KAPNO)
  RCONST(13724) = (KFPAN)
  RCONST(13725) = (KRO2NO3*1.74)
  RCONST(13726) = (1.00D-11*RO2*0.3)
  RCONST(13727) = (1.00D-11*RO2*0.7)
  RCONST(13728) = (2*KNO3AL*5.5)
  RCONST(13729) = (3.89D-11)
  RCONST(13730) = (j('ch3cocho')+j('n_c3h7cho_hco')+j('biacet'))
  RCONST(13731) = (KRO2HO2*0.770)
  RCONST(13732) = (KRO2NO)
  RCONST(13733) = (KRO2NO3)
  RCONST(13734) = (8.80D-13*RO2*0.6)
  RCONST(13735) = (8.80D-13*RO2*0.2)
  RCONST(13736) = (8.80D-13*RO2*0.2)
  RCONST(13737) = (KAPHO2*0.15)
  RCONST(13738) = (KAPHO2*0.41)
  RCONST(13739) = (KAPHO2*0.44)
  RCONST(13740) = (KAPNO)
  RCONST(13741) = (KFPAN)
  RCONST(13742) = (KRO2NO3*1.74)
  RCONST(13743) = (1.00D-11*0.3*RO2)
  RCONST(13744) = (1.00D-11*0.7*RO2)
  RCONST(13745) = (KRO2HO2*0.706)
  RCONST(13746) = (KRO2NO)
  RCONST(13747) = (KRO2NO3)
  RCONST(13748) = (8.80D-13*RO2*0.2)
  RCONST(13749) = (8.80D-13*RO2*0.6)
  RCONST(13750) = (8.80D-13*RO2*0.2)
  RCONST(13751) = (6.69D-11)
  RCONST(13752) = (j('ch3cocho')+j('n_c3h7cho_hco'))
  RCONST(13753) = (8.35D-11)
  RCONST(13754) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13755) = (4.96D-11)
  RCONST(13756) = (j('2_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(13757) = (2.70D+14*EXP(-6643/TEMP))
  RCONST(13758) = (8.00D-11)
  RCONST(13759) = (j('n_c3h7cho_hco'))
  RCONST(13760) = (KAPHO2*0.44)
  RCONST(13761) = (KAPHO2*0.15)
  RCONST(13762) = (KAPHO2*0.41)
  RCONST(13763) = (KAPNO)
  RCONST(13764) = (KFPAN)
  RCONST(13765) = (KRO2NO3*1.74)
  RCONST(13766) = (1.00D-11*RO2*0.7)
  RCONST(13767) = (KRO2HO2*0.770)
  RCONST(13768) = (KRO2NO)
  RCONST(13769) = (KRO2NO3)
  RCONST(13770) = (2.50D-12*RO2*0.6)
  RCONST(13771) = (2.50D-12*RO2*0.2)
  RCONST(13772) = (2.50D-12*RO2*0.2)
  RCONST(13773) = (3.94D-11)
  RCONST(13774) = (j('mek')*2)
  RCONST(13775) = (j('ch3o2h'))
  RCONST(13776) = (KDEC)
  RCONST(13777) = (1.41D-11)
  RCONST(13778) = (2.72D-11)
  RCONST(13779) = (j('mek')*2)
  RCONST(13780) = (1.05D-11)
  RCONST(13781) = (j('mek')*2+j('ch3o2h'))
  RCONST(13782) = (KRO2HO2*0.820)
  RCONST(13783) = (KRO2NO)
  RCONST(13784) = (KRO2NO3)
  RCONST(13785) = (8.80D-13*RO2)
  RCONST(13786) = (6.89D-12)
  RCONST(13787) = (KBPAN)
  RCONST(13788) = (KAPHO2*0.56)
  RCONST(13789) = (KAPHO2*0.44)
  RCONST(13790) = (KAPNO)
  RCONST(13791) = (KFPAN)
  RCONST(13792) = (KRO2NO3*1.74)
  RCONST(13793) = (1.00D-11*RO2)
  RCONST(13794) = (KAPHO2*0.15)
  RCONST(13795) = (KAPHO2*0.41)
  RCONST(13796) = (KAPHO2*0.44)
  RCONST(13797) = (KAPNO)
  RCONST(13798) = (KFPAN)
  RCONST(13799) = (KRO2NO3*1.74)
  RCONST(13800) = (1.00D-11*RO2*0.3)
  RCONST(13801) = (1.00D-11*RO2*0.7)
  RCONST(13802) = (KRO2HO2*0.706)
  RCONST(13803) = (KRO2NO*0.052)
  RCONST(13804) = (KRO2NO*0.948)
  RCONST(13805) = (KRO2NO3)
  RCONST(13806) = (1.30D-12*RO2*0.6)
  RCONST(13807) = (1.30D-12*RO2*0.2)
  RCONST(13808) = (1.30D-12*RO2*0.2)
  RCONST(13809) = (3.94D-11)
  RCONST(13810) = (j('ch3o2h'))
  RCONST(13811) = (KDEC)
  RCONST(13812) = (3.59D-11)
  RCONST(13813) = (KRO2HO2*0.770)
  RCONST(13814) = (KRO2NO)
  RCONST(13815) = (KRO2NO3)
  RCONST(13816) = (9.20D-14*RO2*0.7)
  RCONST(13817) = (9.20D-14*RO2*0.3)
  RCONST(13818) = (4.52D-11)
  RCONST(13819) = (j('ch3o2h'))
  RCONST(13820) = (3.28D-11)
  RCONST(13821) = (KDEC)
  RCONST(13822) = (4.18D-11)
  RCONST(13823) = (7.17D-11)
  RCONST(13824) = (j('ch3o2h'))
  RCONST(13825) = (5.64D-11)
  RCONST(13826) = (j('n_c3h7ono2'))
  RCONST(13827) = (KROPRIM*O2)
  RCONST(13828) = (KNO3AL*8.5)
  RCONST(13829) = (3.30D-13)
  RCONST(13830) = (1.30D-17*0.670)
  RCONST(13831) = (1.30D-17*0.330)
  RCONST(13832) = (8.70D-11*0.288)
  RCONST(13833) = (8.70D-11*0.712)
  RCONST(13834) = (j('n_c3h7cho_hco'))
  RCONST(13835) = (6.29D-11)
  RCONST(13836) = (KRO2HO2*0.859)
  RCONST(13837) = (KRO2NO)
  RCONST(13838) = (KRO2NO3)
  RCONST(13839) = (8.80D-12*RO2*0.2)
  RCONST(13840) = (8.80D-12*RO2*0.6)
  RCONST(13841) = (8.80D-12*RO2*0.2)
  RCONST(13842) = (7.06D-11)
  RCONST(13843) = (j('ch3o2h'))
  RCONST(13844) = (5.53D-11)
  RCONST(13845) = (j('n_c3h7ono2'))
  RCONST(13846) = (KDEC)
  RCONST(13847) = (7.70D-11)
  RCONST(13848) = (j('n_c3h7cho_hco'))
  RCONST(13849) = (6.16D-11)
  RCONST(13850) = (1.35D-11)
  RCONST(13851) = (j('mek')*2+j('ch3o2h'))
  RCONST(13852) = (KDEC)
  RCONST(13853) = (KDEC*0.2)
  RCONST(13854) = (KDEC*0.8)
  RCONST(13855) = (3.88D-11)
  RCONST(13856) = (4.18D-11)
  RCONST(13857) = (j('ch3o2h'))
  RCONST(13858) = (3.82D-11)
  RCONST(13859) = (KBPAN)
  RCONST(13860) = (1.41D-11)
  RCONST(13861) = (j('ch3o2h'))
  RCONST(13862) = (6.04D-12)
  RCONST(13863) = (j('1_c4h9ono2'))
  RCONST(13864) = (KDEC)
  RCONST(13865) = (7.01D-12)
  RCONST(13866) = (9.07D-12)
  RCONST(13867) = (KAPHO2*0.15)
  RCONST(13868) = (KAPHO2*0.41)
  RCONST(13869) = (KAPHO2*0.44)
  RCONST(13870) = (KAPNO)
  RCONST(13871) = (KFPAN)
  RCONST(13872) = (KRO2NO3*1.74)
  RCONST(13873) = (1.00D-11*RO2*0.3)
  RCONST(13874) = (1.00D-11*RO2*0.7)
  RCONST(13875) = (KRO2HO2*0.959)
  RCONST(13876) = (KRO2NO*0.243)
  RCONST(13877) = (KRO2NO*0.757)
  RCONST(13878) = (KRO2NO3)
  RCONST(13879) = (2.50D-13*RO2*0.2)
  RCONST(13880) = (2.50D-13*RO2*0.6)
  RCONST(13881) = (2.50D-13*RO2*0.2)
  RCONST(13882) = (7.06D-11)
  RCONST(13883) = (j('ch3o2h'))
  RCONST(13884) = (5.53D-11)
  RCONST(13885) = (j('n_c3h7ono2'))
  RCONST(13886) = (KDEC)
  RCONST(13887) = (7.70D-11)
  RCONST(13888) = (j('n_c3h7cho_hco'))
  RCONST(13889) = (6.16D-11)
  RCONST(13890) = (1.40D-11)
  RCONST(13891) = (j('ch3o2h'))
  RCONST(13892) = (5.94D-11)
  RCONST(13893) = (j('1_c4h9ono2'))
  RCONST(13894) = (KDEC)
  RCONST(13895) = (6.91D-12)
  RCONST(13896) = (9.00D-12)
  RCONST(13897) = (8.18D-11)
  RCONST(13898) = (j('ch3o2h'))
  RCONST(13899) = (7.42D-11)
  RCONST(13900) = (j('2_c4h9ono2'))
  RCONST(13901) = (KDEC)
  RCONST(13902) = (7.82D-11)
  RCONST(13903) = (3.51D-11)
  RCONST(13904) = (j('ch3o2h'))
  RCONST(13905) = (2.80D-11)
  RCONST(13906) = (j('2_c4h9ono2'))
  RCONST(13907) = (KDEC)
  RCONST(13908) = (3.16D-11)
  RCONST(13909) = (3.14D-11)
  RCONST(13910) = (3.45D-11)
  RCONST(13911) = (j('ch3o2h'))
  RCONST(13912) = (KRO2HO2*0.914)
  RCONST(13913) = (KRO2NO*0.192)
  RCONST(13914) = (KRO2NO*0.808)
  RCONST(13915) = (KRO2NO3)
  RCONST(13916) = (2.50D-13*RO2*0.2)
  RCONST(13917) = (2.50D-13*RO2*0.6)
  RCONST(13918) = (2.50D-13*RO2*0.2)
  RCONST(13919) = (3.09D-11)
  RCONST(13920) = (KBPAN)
  RCONST(13921) = (7.41D-11)
  RCONST(13922) = (j('mek'))
  RCONST(13923) = (KRO2HO2*0.947)
  RCONST(13924) = (KRO2NO*0.245)
  RCONST(13925) = (KRO2NO*0.755)
  RCONST(13926) = (KRO2NO3)
  RCONST(13927) = (2.50D-13*RO2*0.2)
  RCONST(13928) = (2.50D-13*RO2*0.6)
  RCONST(13929) = (2.50D-13*RO2*0.2)
  RCONST(13930) = (2.72D-11)
  RCONST(13931) = (j('ch3o2h'))
  RCONST(13932) = (KDEC)
  RCONST(13933) = (2.37D-11)
  RCONST(13934) = (8.69D-11)
  RCONST(13935) = (j('ch3o2h'))
  RCONST(13936) = (5.82D-11)
  RCONST(13937) = (j('2_c4h9ono2'))
  RCONST(13938) = (KDEC)
  RCONST(13939) = (7.47D-11)
  RCONST(13940) = (4.59D-11)
  RCONST(13941) = (j('ch3o2h'))
  RCONST(13942) = (KDEC)
  RCONST(13943) = (3.68D-11)
  RCONST(13944) = (5.84D-11)
  RCONST(13945) = (j('i_c3h7cho'))
  RCONST(13946) = (j('ch3o2h'))
  RCONST(13947) = (KDEC)
  RCONST(13948) = (7.37D-11)
  RCONST(13949) = (j('n_c3h7cho_hco')+j('biacet')+j('ch3o2h'))
  RCONST(13950) = (KDEC)
  RCONST(13951) = (KAPHO2*0.56)
  RCONST(13952) = (KAPHO2*0.44)
  RCONST(13953) = (KAPNO)
  RCONST(13954) = (KFPAN)
  RCONST(13955) = (KRO2NO3*1.74)
  RCONST(13956) = (1.00D-11*RO2)
  RCONST(13957) = (j('ch3o2h'))
  RCONST(13958) = (5.32D-12)
  RCONST(13959) = (KBPAN)
  RCONST(13960) = (1.07D-12)
  RCONST(13961) = (j('ch3o2h')+j('biacet'))
  RCONST(13962) = (j('mek'))
  RCONST(13963) = (1.70D-11)
  RCONST(13964) = (KDEC)
  RCONST(13965) = (j('ch3o2h'))
  RCONST(13966) = (j('biacet'))
  RCONST(13967) = (1.70D-11)
  RCONST(13968) = (KDEC)
  RCONST(13969) = (j('ch3o2h'))
  RCONST(13970) = (j('mek')*2)
  RCONST(13971) = (5.46D-12)
  RCONST(13972) = (KDEC)
  RCONST(13973) = (KRO2HO2*0.820)
  RCONST(13974) = (KRO2NO)
  RCONST(13975) = (KRO2NO3)
  RCONST(13976) = (8.80D-13*RO2)
  RCONST(13977) = (j('ch3o2h')+j('mek')+j('biacet'))
  RCONST(13978) = (1.52D-11)
  RCONST(13979) = (KDEC)
  RCONST(13980) = (j('ch3o2h')+j('mek')+j('biacet'))
  RCONST(13981) = (1.87D-11)
  RCONST(13982) = (KDEC)
  RCONST(13983) = (j('ch3o2h')+j('mek')+j('biacet'))
  RCONST(13984) = (2.01D-11)
  RCONST(13985) = (KDEC)
  RCONST(13986) = (j('ch3o2h')+j('mek')+j('biacet'))
  RCONST(13987) = (2.15D-11)
  RCONST(13988) = (KDEC)
  RCONST(13989) = (j('ch3o2h')+j('mek')+j('biacet'))
  RCONST(13990) = (2.29D-11)
  RCONST(13991) = (KDEC)
  RCONST(13992) = (3.06D-11)
  RCONST(13993) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(13994) = (2.74D-11)
  RCONST(13995) = (KBPAN)
  RCONST(13996) = (3.60D-11)
  RCONST(13997) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(13998) = (3.28D-11)
  RCONST(13999) = (KBPAN)
  RCONST(14000) = (4.15D-11)
  RCONST(14001) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14002) = (3.82D-11)
  RCONST(14003) = (KBPAN)
  RCONST(14004) = (KNO3AL*4.0)
  RCONST(14005) = (1.27D-11)
  RCONST(14006) = (j('mek'))
  RCONST(14007) = (3.60D-11)
  RCONST(14008) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14009) = (3.28D-11)
  RCONST(14010) = (KBPAN)
  RCONST(14011) = (3.78D-11)
  RCONST(14012) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14013) = (3.45D-11)
  RCONST(14014) = (KBPAN)
  RCONST(14015) = (1.50D-12)
  RCONST(14016) = (3.93D-11)
  RCONST(14017) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14018) = (3.61D-11)
  RCONST(14019) = (KBPAN)
  RCONST(14020) = (1.50D-12)
  RCONST(14021) = (3.99D-11)
  RCONST(14022) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14023) = (3.68D-11)
  RCONST(14024) = (KBPAN)
  RCONST(14025) = (1.50D-12)
  RCONST(14026) = (KAPHO2*0.44)
  RCONST(14027) = (KAPHO2*0.56)
  RCONST(14028) = (KAPNO)
  RCONST(14029) = (KFPAN)
  RCONST(14030) = (KRO2NO3*1.74)
  RCONST(14031) = (1.00D-11*RO2)
  RCONST(14032) = (4.32D-11)
  RCONST(14033) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14034) = (4.00D-11)
  RCONST(14035) = (KBPAN)
  RCONST(14036) = (2.54D-11)
  RCONST(14037) = (j('ch3o2h'))
  RCONST(14038) = (2.22D-11)
  RCONST(14039) = (KBPAN)
  RCONST(14040) = (2.54D-11)
  RCONST(14041) = (j('ch3o2h'))
  RCONST(14042) = (2.22D-11)
  RCONST(14043) = (KBPAN)
  RCONST(14044) = (4.89D-11)
  RCONST(14045) = (j('mvk_mcm_ch2ch'))
  RCONST(14046) = (1.72D-11)
  RCONST(14047) = (j('ch3o2h'))
  RCONST(14048) = (1.36D-11)
  RCONST(14049) = (KBPAN)
  RCONST(14050) = (2.20D-11)
  RCONST(14051) = (j('ch3o2h')+j('mek'))
  RCONST(14052) = (KDEC)
  RCONST(14053) = (1.36D-11)
  RCONST(14054) = (j('ch3cocho'))
  RCONST(14055) = (2*KNO3AL*4.0)
  RCONST(14056) = (3.39D-11)
  RCONST(14057) = (j('n_c3h7cho_hco'))
  RCONST(14058) = (j('ch3cocho'))
  RCONST(14059) = (2.46D-11)
  RCONST(14060) = (j('ch3o2h')+j('mek')+j('ch3cocho'))
  RCONST(14061) = (KDEC)
  RCONST(14062) = (1.01D-11)
  RCONST(14063) = (j('ch3o2h')+j('biacet'))
  RCONST(14064) = (KDEC)
  RCONST(14065) = (KNO3AL*5.5)
  RCONST(14066) = (1.33D-11)
  RCONST(14067) = (j('ch3cocho'))
  RCONST(14068) = (1.20D-10)
  RCONST(14069) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14070) = (KDEC)
  RCONST(14071) = (1.25D-12)
  RCONST(14072) = (j('2_c4h9ono2'))
  RCONST(14073) = (KRO2HO2*0.859)
  RCONST(14074) = (KRO2NO)
  RCONST(14075) = (KRO2NO3)
  RCONST(14076) = (9.20D-14*RO2*0.7)
  RCONST(14077) = (9.20D-14*RO2*0.3)
  RCONST(14078) = (KAPHO2*0.41)
  RCONST(14079) = (KAPHO2*0.44)
  RCONST(14080) = (KAPHO2*0.15)
  RCONST(14081) = (KAPNO)
  RCONST(14082) = (KFPAN)
  RCONST(14083) = (KRO2NO3*1.74)
  RCONST(14084) = (1.00D-11*RO2*0.7)
  RCONST(14085) = (1.00D-11*RO2*0.3)
  RCONST(14086) = (KRO2HO2*0.820)
  RCONST(14087) = (KRO2NO)
  RCONST(14088) = (KRO2NO3)
  RCONST(14089) = (1.30D-12*RO2)
  RCONST(14090) = (1.51D-11)
  RCONST(14091) = (j('ch3o2h')+j('mek'))
  RCONST(14092) = (KDEC)
  RCONST(14093) = (8.69D-11)
  RCONST(14094) = (j('ch3o2h')+j('biacet'))
  RCONST(14095) = (71.11D-12)
  RCONST(14096) = (j('biacet'))
  RCONST(14097) = (KDEC)
  RCONST(14098) = (3.78D-11)
  RCONST(14099) = (j('biacet'))
  RCONST(14100) = (7.49D-11)
  RCONST(14101) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14102) = (KDEC)
  RCONST(14103) = (KAPHO2*0.15)
  RCONST(14104) = (KAPHO2*0.41)
  RCONST(14105) = (KAPHO2*0.44)
  RCONST(14106) = (KAPNO)
  RCONST(14107) = (KFPAN)
  RCONST(14108) = (KRO2NO3*1.74)
  RCONST(14109) = (1.00D-11*RO2*0.3)
  RCONST(14110) = (1.00D-11*RO2*0.7)
  RCONST(14111) = (1.15D-10)
  RCONST(14112) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(14113) = (KDEC)
  RCONST(14114) = (1.33D-10)
  RCONST(14115) = (j('n_c3h7cho_hco')*2)
  RCONST(14116) = (j('biacet'))
  RCONST(14117) = (9.44D-11)
  RCONST(14118) = (j('n_c3h7cho_hco')*2)
  RCONST(14119) = (9.19D-11)
  RCONST(14120) = (j('n_c3h7cho_hco')*2)
  RCONST(14121) = (9.50D-11)
  RCONST(14122) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(14123) = (KRO2HO2*0.859)
  RCONST(14124) = (KRO2NO)
  RCONST(14125) = (KRO2NO3)
  RCONST(14126) = (2.00D-12*RO2*0.2)
  RCONST(14127) = (2.00D-12*RO2*0.6)
  RCONST(14128) = (2.00D-12*RO2*0.2)
  RCONST(14129) = (9.11D-11)
  RCONST(14130) = (KBPAN)
  RCONST(14131) = (1.02D-10)
  RCONST(14132) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(14133) = (KDEC*0.5)
  RCONST(14134) = (KDEC*0.5)
  RCONST(14135) = (9.27D-11)
  RCONST(14136) = (j('n_c3h7cho_hco')*2)
  RCONST(14137) = (7.21D-11)
  RCONST(14138) = (j('n_c3h7cho_hco'))
  RCONST(14139) = (7.52D-11)
  RCONST(14140) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14141) = (KRO2HO2*0.820)
  RCONST(14142) = (KRO2NO*0.138)
  RCONST(14143) = (KRO2NO*0.862)
  RCONST(14144) = (KRO2NO3)
  RCONST(14145) = (1.30D-12*RO2*0.2)
  RCONST(14146) = (1.30D-12*RO2*0.6)
  RCONST(14147) = (1.30D-12*RO2*0.2)
  RCONST(14148) = (6.81D-11)
  RCONST(14149) = (KBPAN)
  RCONST(14150) = (9.23D-11)
  RCONST(14151) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14152) = (KDEC)
  RCONST(14153) = (2.64D-11)
  RCONST(14154) = (j('ch3cocho')+j('biacet'))
  RCONST(14155) = (8.35D-11)
  RCONST(14156) = (j('n_c3h7cho_hco'))
  RCONST(14157) = (KRO2HO2*0.706)
  RCONST(14158) = (KRO2NO*0.129)
  RCONST(14159) = (KRO2NO*0.871)
  RCONST(14160) = (KRO2NO3)
  RCONST(14161) = (2.50D-13*RO2*0.6)
  RCONST(14162) = (2.50D-13*RO2*0.2)
  RCONST(14163) = (2.50D-13*RO2*0.2)
  RCONST(14164) = (6.67D-12)
  RCONST(14165) = (j('mek')*2)
  RCONST(14166) = (9.75D-11)
  RCONST(14167) = (j('ch3o2h')+j('mek')*2)
  RCONST(14168) = (6.15D-12)
  RCONST(14169) = (KBPAN)
  RCONST(14170) = (1.51D-11)
  RCONST(14171) = (j('ch3o2h'))
  RCONST(14172) = (j('mek')*2)
  RCONST(14173) = (KDEC)
  RCONST(14174) = (8.25D-12)
  RCONST(14175) = (j('mek')*2)
  RCONST(14176) = (1.83D-11)
  RCONST(14177) = (j('ch3cocho'))
  RCONST(14178) = (KRO2HO2*0.859)
  RCONST(14179) = (KRO2NO)
  RCONST(14180) = (KRO2NO3)
  RCONST(14181) = (9.20D-14*RO2)
  RCONST(14182) = (2.42D-11)
  RCONST(14183) = (j('ch3o2h'))
  RCONST(14184) = (KDEC)
  RCONST(14185) = (5.67D-12)
  RCONST(14186) = (j('biacet'))
  RCONST(14187) = (3.14D-11)
  RCONST(14188) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14189) = (2.78D-11)
  RCONST(14190) = (KBPAN)
  RCONST(14191) = (1.84D-11)
  RCONST(14192) = (2.15D-11)
  RCONST(14193) = (j('ch3o2h'))
  RCONST(14194) = (1.79D-11)
  RCONST(14195) = (KBPAN)
  RCONST(14196) = (4.93D-11)
  RCONST(14197) = (j('ch3o2h'))
  RCONST(14198) = (1.38D-11)
  RCONST(14199) = (j('n_c3h7ono2'))
  RCONST(14200) = (KROPRIM*O2)
  RCONST(14201) = (2.81D-11)
  RCONST(14202) = (KNO3AL*8.5)
  RCONST(14203) = (3.51D-11)
  RCONST(14204) = (j('n_c3h7cho_hco'))
  RCONST(14205) = (3.14D-11)
  RCONST(14206) = (j('ch3o2h'))
  RCONST(14207) = (j('mek')+j('n_c3h7cho_hco'))
  RCONST(14208) = (KDEC)
  RCONST(14209) = (2.80D-11)
  RCONST(14210) = (j('mek')+j('n_c3h7cho_hco'))
  RCONST(14211) = (KAPHO2*0.15)
  RCONST(14212) = (KAPHO2*0.41)
  RCONST(14213) = (KAPHO2*0.44)
  RCONST(14214) = (KAPNO)
  RCONST(14215) = (KFPAN)
  RCONST(14216) = (KRO2NO3*1.74)
  RCONST(14217) = (1.00D-11*RO2*0.3)
  RCONST(14218) = (1.00D-11*RO2*0.7)
  RCONST(14219) = (KRO2HO2*0.770)
  RCONST(14220) = (KRO2NO)
  RCONST(14221) = (KRO2NO3)
  RCONST(14222) = (8.00D-13*RO2*0.7)
  RCONST(14223) = (8.00D-13*RO2*0.3)
  RCONST(14224) = (KDEC)
  RCONST(14225) = (KRO2HO2*0.770)
  RCONST(14226) = (KRO2NO*0.030)
  RCONST(14227) = (KRO2NO*0.970)
  RCONST(14228) = (KRO2NO3)
  RCONST(14229) = (8.00D-13*RO2*0.7)
  RCONST(14230) = (8.00D-13*RO2*0.3)
  RCONST(14231) = (1.02D-10)
  RCONST(14232) = (j('ch3o2h'))
  RCONST(14233) = (KDEC)
  RCONST(14234) = (7.46D-11)
  RCONST(14235) = (j('ch3cocho'))
  RCONST(14236) = (9.34D-11)
  RCONST(14237) = (KRO2HO2*0.859)
  RCONST(14238) = (KRO2NO)
  RCONST(14239) = (KRO2NO3)
  RCONST(14240) = (8.80D-12*RO2*0.2)
  RCONST(14241) = (8.80D-12*RO2*0.6)
  RCONST(14242) = (8.80D-12*RO2*0.2)
  RCONST(14243) = (KRO2HO2*0.859)
  RCONST(14244) = (KRO2NO*0.138)
  RCONST(14245) = (KRO2NO*0.862)
  RCONST(14246) = (KRO2NO3)
  RCONST(14247) = (1.30D-12*RO2*0.2)
  RCONST(14248) = (1.30D-12*RO2*0.6)
  RCONST(14249) = (1.30D-12*RO2*0.2)
  RCONST(14250) = (KAPHO2*0.41)
  RCONST(14251) = (KAPHO2*0.44)
  RCONST(14252) = (KAPHO2*0.15)
  RCONST(14253) = (KAPNO)
  RCONST(14254) = (KFPAN)
  RCONST(14255) = (KRO2NO3*1.74)
  RCONST(14256) = (1.00D-11*RO2*0.7)
  RCONST(14257) = (1.00D-11*RO2*0.3)
  RCONST(14258) = (KRO2HO2*0.914)
  RCONST(14259) = (KRO2NO*0.228)
  RCONST(14260) = (KRO2NO*0.772)
  RCONST(14261) = (KRO2NO3)
  RCONST(14262) = (2.50D-13*RO2*0.2)
  RCONST(14263) = (2.50D-13*RO2*0.6)
  RCONST(14264) = (2.50D-13*RO2*0.2)
  RCONST(14265) = (1.23D-11)
  RCONST(14266) = (1.48D-11)
  RCONST(14267) = (j('ch3o2h'))
  RCONST(14268) = (KRO2HO2*0.947)
  RCONST(14269) = (KRO2NO*0.176)
  RCONST(14270) = (KRO2NO*0.824)
  RCONST(14271) = (KRO2NO3)
  RCONST(14272) = (1.30D-12*RO2*0.2)
  RCONST(14273) = (1.30D-12*RO2*0.6)
  RCONST(14274) = (1.30D-12*RO2*0.2)
  RCONST(14275) = (1.12D-11)
  RCONST(14276) = (KBPAN)
  RCONST(14277) = (4.00D-11)
  RCONST(14278) = (j('ch3o2h')+j('biacet'))
  RCONST(14279) = (8.47D-12)
  RCONST(14280) = (j('1_c4h9ono2')+j('biacet'))
  RCONST(14281) = (KROSEC*O2)
  RCONST(14282) = (2.70D+14*EXP(-6643/TEMP))
  RCONST(14283) = (2.08D-11)
  RCONST(14284) = (j('biacet'))
  RCONST(14285) = (2.22D-11)
  RCONST(14286) = (j('biacet'))
  RCONST(14287) = (KRO2HO2*0.959)
  RCONST(14288) = (KRO2NO*0.134)
  RCONST(14289) = (KRO2NO*0.866)
  RCONST(14290) = (KRO2NO3)
  RCONST(14291) = (6.70D-15*RO2*0.7)
  RCONST(14292) = (6.70D-15*RO2*0.3)
  RCONST(14293) = (KRO2HO2*0.914)
  RCONST(14294) = (KRO2NO*0.228)
  RCONST(14295) = (KRO2NO*0.772)
  RCONST(14296) = (KRO2NO3)
  RCONST(14297) = (2.50D-13*RO2*0.2)
  RCONST(14298) = (2.50D-13*RO2*0.6)
  RCONST(14299) = (2.50D-13*RO2*0.2)
  RCONST(14300) = (8.52D-11)
  RCONST(14301) = (j('ch3cocho'))
  RCONST(14302) = (KRO2HO2*0.820)
  RCONST(14303) = (KRO2NO)
  RCONST(14304) = (KRO2NO3)
  RCONST(14305) = (2.00D-13*RO2*0.2)
  RCONST(14306) = (2.00D-13*RO2*0.6)
  RCONST(14307) = (2.00D-13*RO2*0.2)
  RCONST(14308) = (2.99D-11)
  RCONST(14309) = (j('biacet'))
  RCONST(14310) = (KRO2HO2*0.932)
  RCONST(14311) = (KRO2NO*0.235)
  RCONST(14312) = (KRO2NO*0.765)
  RCONST(14313) = (KRO2NO3)
  RCONST(14314) = (2.50D-13*RO2*0.2)
  RCONST(14315) = (2.50D-13*RO2*0.6)
  RCONST(14316) = (2.50D-13*RO2*0.2)
  RCONST(14317) = (3.41D-11)
  RCONST(14318) = (j('ch3o2h'))
  RCONST(14319) = (2.60D-11)
  RCONST(14320) = (j('1_c4h9ono2'))
  RCONST(14321) = (KDEC)
  RCONST(14322) = (2.70D-11)
  RCONST(14323) = (2.91D-11)
  RCONST(14324) = (8.69D-11)
  RCONST(14325) = (j('ch3o2h'))
  RCONST(14326) = (5.82D-11)
  RCONST(14327) = (j('1_c4h9ono2'))
  RCONST(14328) = (KDEC)
  RCONST(14329) = (7.47D-11)
  RCONST(14330) = (KAPHO2*0.15)
  RCONST(14331) = (KAPHO2*0.41)
  RCONST(14332) = (KAPHO2*0.44)
  RCONST(14333) = (KAPNO)
  RCONST(14334) = (KFPAN)
  RCONST(14335) = (KRO2NO3*1.74)
  RCONST(14336) = (1.00D-11*RO2*0.3)
  RCONST(14337) = (1.00D-11*RO2*0.7)
  RCONST(14338) = (8.00D-11)
  RCONST(14339) = (j('ch3cocho'))
  RCONST(14340) = (KRO2HO2*0.770)
  RCONST(14341) = (KRO2NO)
  RCONST(14342) = (KRO2NO3)
  RCONST(14343) = (2.00D-12*RO2*0.2)
  RCONST(14344) = (2.00D-12*RO2*0.6)
  RCONST(14345) = (2.00D-12*RO2*0.2)
  RCONST(14346) = (3.43D-11)
  RCONST(14347) = (KRO2HO2*0.947)
  RCONST(14348) = (KRO2NO*0.176)
  RCONST(14349) = (KRO2NO*0.824)
  RCONST(14350) = (KRO2NO3)
  RCONST(14351) = (2.50D-13*RO2*0.2)
  RCONST(14352) = (2.50D-13*RO2*0.6)
  RCONST(14353) = (2.50D-13*RO2*0.2)
  RCONST(14354) = (5.85D-11)
  RCONST(14355) = (j('n_c3h7cho_hco'))
  RCONST(14356) = (j('ch3o2h'))
  RCONST(14357) = (2.31D-11)
  RCONST(14358) = (KBPAN)
  RCONST(14359) = (1.65D-11)
  RCONST(14360) = (j('mek'))
  RCONST(14361) = (j('ch3o2h'))
  RCONST(14362) = (8.65D-11)
  RCONST(14363) = (2.00D+14*EXP(-4909/TEMP))
  RCONST(14364) = (KRO2HO2*0.770)
  RCONST(14365) = (KRO2NO)
  RCONST(14366) = (KRO2NO3)
  RCONST(14367) = (9.20D-14*RO2*0.70)
  RCONST(14368) = (9.20D-14*RO2*0.30)
  RCONST(14369) = (KRO2HO2*0.820)
  RCONST(14370) = (KRO2NO)
  RCONST(14371) = (KRO2NO3)
  RCONST(14372) = (9.20D-14*RO2*0.70)
  RCONST(14373) = (9.20D-14*RO2*0.30)
  RCONST(14374) = (KRO2HO2*0.820)
  RCONST(14375) = (KRO2NO)
  RCONST(14376) = (KRO2NO3)
  RCONST(14377) = (9.20D-14*RO2*0.70)
  RCONST(14378) = (9.20D-14*RO2*0.30)
  RCONST(14379) = (4.36D-12)
  RCONST(14380) = (j('ch3o2h'))
  RCONST(14381) = (1.13D-12)
  RCONST(14382) = (KBPAN)
  RCONST(14383) = (KAPHO2*0.56)
  RCONST(14384) = (KAPHO2*0.44)
  RCONST(14385) = (KAPNO)
  RCONST(14386) = (KFPAN)
  RCONST(14387) = (KRO2NO3*1.74)
  RCONST(14388) = (1.00D-11*RO2)
  RCONST(14389) = (KRO2HO2*0.520)
  RCONST(14390) = (KRO2NO)
  RCONST(14391) = (KRO2NO3)
  RCONST(14392) = (2.00D-12*RO2)
  RCONST(14393) = (KRO2HO2*0.820)
  RCONST(14394) = (KRO2NO)
  RCONST(14395) = (KRO2NO3)
  RCONST(14396) = (8.80D-13*RO2)
  RCONST(14397) = (1.09D-11)
  RCONST(14398) = (j('ch3o2h'))
  RCONST(14399) = (KDEC)
  RCONST(14400) = (7.42D-12)
  RCONST(14401) = (9.65D-12)
  RCONST(14402) = (j('ch3o2h'))
  RCONST(14403) = (6.57D-12)
  RCONST(14404) = (2.96D-12)
  RCONST(14405) = (KBPAN)
  RCONST(14406) = (1.27D-11)
  RCONST(14407) = (j('ch3o2h'))
  RCONST(14408) = (KDEC)
  RCONST(14409) = (KRO2HO2*0.770)
  RCONST(14410) = (KRO2NO)
  RCONST(14411) = (KRO2NO3)
  RCONST(14412) = (8.80D-13*RO2)
  RCONST(14413) = (2.34D-11)
  RCONST(14414) = (j('mek'))
  RCONST(14415) = (2.65D-11)
  RCONST(14416) = (j('ch3o2h')+j('mek'))
  RCONST(14417) = (7.60D-12)
  RCONST(14418) = (KBPAN)
  RCONST(14419) = (KAPHO2*0.56)
  RCONST(14420) = (KAPHO2*0.44)
  RCONST(14421) = (KAPNO)
  RCONST(14422) = (KFPAN)
  RCONST(14423) = (KRO2NO3*1.74)
  RCONST(14424) = (1.00D-11*RO2)
  RCONST(14425) = (KRO2HO2*0.706)
  RCONST(14426) = (KRO2NO)
  RCONST(14427) = (KRO2NO3)
  RCONST(14428) = (2.00D-12*RO2)
  RCONST(14429) = (1.00D-10)
  RCONST(14430) = (j('ch3o2h'))
  RCONST(14431) = (KDEC)
  RCONST(14432) = (1.03D-10)
  RCONST(14433) = (j('ch3cocho')+j('n_c3h7cho_hco')*2)
  RCONST(14434) = (9.34D-11)
  RCONST(14435) = (2*KNO3AL*5.5)
  RCONST(14436) = (3.89D-11)
  RCONST(14437) = (j('ch3cocho')+j('n_c3h7cho_hco'))
  RCONST(14438) = (1.01D-10)
  RCONST(14439) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14440) = (6.65D-11)
  RCONST(14441) = (j('n_c3h7ono2')+j('n_c3h7cho_hco'))
  RCONST(14442) = (KDEC)
  RCONST(14443) = (KNO3AL*8.5)
  RCONST(14444) = (KNO3AL*8.5)
  RCONST(14445) = (1.33D-10*0.5)
  RCONST(14446) = (1.33D-10*0.5)
  RCONST(14447) = (j('n_c3h7cho_hco'))
  RCONST(14448) = (j('n_c3h7cho_hco'))
  RCONST(14449) = (7.96D-11)
  RCONST(14450) = (j('n_c3h7cho_hco'))
  RCONST(14451) = (1.10D-10)
  RCONST(14452) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(14453) = (4.33D-11)
  RCONST(14454) = (j('1_c4h9ono2')+j('n_c3h7cho_hco')*2)
  RCONST(14455) = (1.80D-14*EXP(-260/TEMP)*O2)
  RCONST(14456) = (6.99D-11)
  RCONST(14457) = (j('n_c3h7cho_hco')*2)
  RCONST(14458) = (1.76D-11)
  RCONST(14459) = (j('mek')+j('biacet')+j('ch3o2h'))
  RCONST(14460) = (KDEC)
  RCONST(14461) = (KRO2HO2*0.859)
  RCONST(14462) = (KRO2NO)
  RCONST(14463) = (KRO2NO3)
  RCONST(14464) = (8.80D-13*RO2)
  RCONST(14465) = (KAPHO2*0.15)
  RCONST(14466) = (KAPHO2*0.41)
  RCONST(14467) = (KAPHO2*0.44)
  RCONST(14468) = (KAPNO)
  RCONST(14469) = (KFPAN)
  RCONST(14470) = (KRO2NO3*1.74)
  RCONST(14471) = (1.00D-11*RO2*0.3)
  RCONST(14472) = (1.00D-11*RO2*0.7)
  RCONST(14473) = (2.39D-11)
  RCONST(14474) = (j('mek'))
  RCONST(14475) = (j('n_c3h7cho_hco'))
  RCONST(14476) = (5.80D-11)
  RCONST(14477) = (6.11D-11)
  RCONST(14478) = (j('ch3o2h'))
  RCONST(14479) = (5.75D-11)
  RCONST(14480) = (KBPAN)
  RCONST(14481) = (3.96D-11)
  RCONST(14482) = (j('ch3o2h'))
  RCONST(14483) = (KDEC)
  RCONST(14484) = (3.62D-11)
  RCONST(14485) = (KRO2HO2*0.706)
  RCONST(14486) = (KRO2NO)
  RCONST(14487) = (KRO2NO3)
  RCONST(14488) = (9.20D-14*RO2*0.7)
  RCONST(14489) = (9.20D-14*RO2*0.3)
  RCONST(14490) = (5.26D-11)
  RCONST(14491) = (j('ch3o2h'))
  RCONST(14492) = (3.51D-11)
  RCONST(14493) = (KDEC)
  RCONST(14494) = (4.91D-11)
  RCONST(14495) = (KNO3AL*8.5)
  RCONST(14496) = (3.30D-13)
  RCONST(14497) = (1.30D-17*0.330)
  RCONST(14498) = (1.30D-17*0.670)
  RCONST(14499) = (8.26D-11*0.288)
  RCONST(14500) = (8.26D-11*0.712)
  RCONST(14501) = (KAPHO2*0.15)
  RCONST(14502) = (KAPHO2*0.41)
  RCONST(14503) = (KAPHO2*0.44)
  RCONST(14504) = (KAPNO)
  RCONST(14505) = (KFPAN)
  RCONST(14506) = (KRO2NO3*1.74)
  RCONST(14507) = (1.00D-11*RO2*0.3)
  RCONST(14508) = (1.00D-11*RO2*0.7)
  RCONST(14509) = (7.90D-11)
  RCONST(14510) = (j('ch3o2h'))
  RCONST(14511) = (KDEC)
  RCONST(14512) = (6.64D-11)
  RCONST(14513) = (j('mek'))
  RCONST(14514) = (6.69D-11)
  RCONST(14515) = (4.83D-11)
  RCONST(14516) = (j('ch3o2h'))
  RCONST(14517) = (3.17D-11)
  RCONST(14518) = (j('n_c3h7ono2'))
  RCONST(14519) = (KDEC)
  RCONST(14520) = (3.92D-11)
  RCONST(14521) = (2.16D-11)
  RCONST(14522) = (j('ch3o2h'))
  RCONST(14523) = (KRO2HO2*0.859)
  RCONST(14524) = (KRO2NO*0.138)
  RCONST(14525) = (KRO2NO*0.862)
  RCONST(14526) = (KRO2NO3)
  RCONST(14527) = (1.30D-12*RO2*0.2)
  RCONST(14528) = (1.30D-12*RO2*0.6)
  RCONST(14529) = (1.30D-12*RO2*0.2)
  RCONST(14530) = (1.85D-11)
  RCONST(14531) = (1.80D-11)
  RCONST(14532) = (KBPAN)
  RCONST(14533) = (5.57D-11)
  RCONST(14534) = (j('ch3o2h'))
  RCONST(14535) = (2.38D-11)
  RCONST(14536) = (j('1_c4h9ono2'))
  RCONST(14537) = (KROSEC*O2)
  RCONST(14538) = (2.70D+14*EXP(-6643/TEMP))
  RCONST(14539) = (2.94D-11)
  RCONST(14540) = (3.78D-11)
  RCONST(14541) = (2.18D-11)
  RCONST(14542) = (j('ch3o2h'))
  RCONST(14543) = (8.22D-12)
  RCONST(14544) = (j('n_c3h7ono2'))
  RCONST(14545) = (KDEC)
  RCONST(14546) = (2.90D-11)
  RCONST(14547) = (j('n_c3h7cho_hco'))
  RCONST(14548) = (1.27D-11)
  RCONST(14549) = (KRO2HO2*0.859)
  RCONST(14550) = (KRO2NO*0.106)
  RCONST(14551) = (KRO2NO*0.894)
  RCONST(14552) = (KRO2NO3)
  RCONST(14553) = (6.70D-15*RO2*0.7)
  RCONST(14554) = (6.70D-15*RO2*0.3)
  RCONST(14555) = (KRO2HO2*0.959)
  RCONST(14556) = (KRO2NO)
  RCONST(14557) = (KRO2NO3)
  RCONST(14558) = (8.80D-13*RO2*0.2)
  RCONST(14559) = (8.80D-13*RO2*0.6)
  RCONST(14560) = (8.80D-13*RO2*0.2)
  RCONST(14561) = (KAPHO2*0.15)
  RCONST(14562) = (KAPHO2*0.41)
  RCONST(14563) = (KAPHO2*0.44)
  RCONST(14564) = (KAPNO)
  RCONST(14565) = (KFPAN)
  RCONST(14566) = (KRO2NO3*1.74)
  RCONST(14567) = (1.00D-11*RO2*0.3)
  RCONST(14568) = (1.00D-11*RO2*0.7)
  RCONST(14569) = (7.90D-11)
  RCONST(14570) = (j('ch3o2h'))
  RCONST(14571) = (5.87D-11)
  RCONST(14572) = (j('2_c4h9ono2'))
  RCONST(14573) = (KDEC)
  RCONST(14574) = (6.69D-11)
  RCONST(14575) = (5.56D-11)
  RCONST(14576) = (j('ch3o2h'))
  RCONST(14577) = (2.37D-11)
  RCONST(14578) = (j('1_c4h9ono2'))
  RCONST(14579) = (KROSEC*O2)
  RCONST(14580) = (2.70D+14*EXP(-6643/TEMP))
  RCONST(14581) = (2.93D-11)
  RCONST(14582) = (3.77D-11)
  RCONST(14583) = (KAPHO2*0.15)
  RCONST(14584) = (KAPHO2*0.41)
  RCONST(14585) = (KAPHO2*0.44)
  RCONST(14586) = (KAPNO)
  RCONST(14587) = (KFPAN)
  RCONST(14588) = (KRO2NO3*1.74)
  RCONST(14589) = (1.00D-11*RO2*0.3)
  RCONST(14590) = (1.00D-11*RO2*0.7)
  RCONST(14591) = (8.38D-11)
  RCONST(14592) = (j('ch3o2h'))
  RCONST(14593) = (KDEC)
  RCONST(14594) = (7.92D-11)
  RCONST(14595) = (5.61D-11)
  RCONST(14596) = (j('ch3o2h'))
  RCONST(14597) = (2.94D-11)
  RCONST(14598) = (j('1_c4h9ono2'))
  RCONST(14599) = (KDEC)
  RCONST(14600) = (4.17D-11)
  RCONST(14601) = (KRO2HO2*0.914)
  RCONST(14602) = (KRO2NO*0.192)
  RCONST(14603) = (KRO2NO*0.808)
  RCONST(14604) = (KRO2NO3)
  RCONST(14605) = (2.50D-13*RO2*0.2)
  RCONST(14606) = (2.50D-13*RO2*0.6)
  RCONST(14607) = (2.50D-13*RO2*0.2)
  RCONST(14608) = (9.40D-12)
  RCONST(14609) = (1.29D-11)
  RCONST(14610) = (j('ch3o2h'))
  RCONST(14611) = (KRO2HO2*0.890)
  RCONST(14612) = (KRO2NO*0.157)
  RCONST(14613) = (KRO2NO*0.843)
  RCONST(14614) = (KRO2NO3)
  RCONST(14615) = (1.32D-12*RO2*0.2)
  RCONST(14616) = (1.32D-12*RO2*0.6)
  RCONST(14617) = (1.32D-12*RO2*0.2)
  RCONST(14618) = (9.26D-12)
  RCONST(14619) = (KBPAN)
  RCONST(14620) = (KAPHO2*0.15)
  RCONST(14621) = (KAPHO2*0.41)
  RCONST(14622) = (KAPHO2*0.44)
  RCONST(14623) = (KAPNO)
  RCONST(14624) = (KFPAN)
  RCONST(14625) = (KRO2NO3*1.74)
  RCONST(14626) = (1.00D-11*RO2*0.3)
  RCONST(14627) = (1.00D-11*RO2*0.7)
  RCONST(14628) = (8.69D-11)
  RCONST(14629) = (j('ch3o2h'))
  RCONST(14630) = (KDEC)
  RCONST(14631) = (7.47D-11)
  RCONST(14632) = (KRO2HO2*0.890)
  RCONST(14633) = (KRO2NO*0.118)
  RCONST(14634) = (KRO2NO*0.882)
  RCONST(14635) = (KRO2NO3)
  RCONST(14636) = (6.70D-15*RO2*0.7)
  RCONST(14637) = (6.70D-15*RO2*0.3)
  RCONST(14638) = (6.13D-11)
  RCONST(14639) = (j('ch3o2h'))
  RCONST(14640) = (3.23D-11)
  RCONST(14641) = (j('1_c4h9ono2'))
  RCONST(14642) = (KDEC)
  RCONST(14643) = (4.35D-11)
  RCONST(14644) = (1.69D-11)
  RCONST(14645) = (j('ch3o2h'))
  RCONST(14646) = (KDEC)
  RCONST(14647) = (1.34D-11)
  RCONST(14648) = (1.69D-11)
  RCONST(14649) = (j('ch3o2h'))
  RCONST(14650) = (KDEC)
  RCONST(14651) = (1.34D-11)
  RCONST(14652) = (1.69D-11)
  RCONST(14653) = (j('ch3o2h'))
  RCONST(14654) = (KDEC)
  RCONST(14655) = (1.34D-11)
  RCONST(14656) = (1.63D-11)
  RCONST(14657) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14658) = (1.27D-11)
  RCONST(14659) = (KBPAN)
  RCONST(14660) = (2.41D-11)
  RCONST(14661) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14662) = (KDEC)
  RCONST(14663) = (1.85D-11)
  RCONST(14664) = (j('ch3o2h'))
  RCONST(14665) = (KDEC)
  RCONST(14666) = (KRO2HO2*0.859)
  RCONST(14667) = (KRO2NO*0.104)
  RCONST(14668) = (KRO2NO*0.896)
  RCONST(14669) = (KRO2NO3)
  RCONST(14670) = (6.70D-15*RO2*0.7)
  RCONST(14671) = (6.70D-15*RO2*0.3)
  RCONST(14672) = (KRO2HO2*0.820)
  RCONST(14673) = (KRO2NO)
  RCONST(14674) = (KRO2NO3)
  RCONST(14675) = (6.70D-15*RO2)
  RCONST(14676) = (1.00D-10)
  RCONST(14677) = (j('ch3o2h')+j('mek'))
  RCONST(14678) = (KDEC)
  RCONST(14679) = (7.05D-11)
  RCONST(14680) = (j('ch3o2h')+j('biacet'))
  RCONST(14681) = (6.69D-11)
  RCONST(14682) = (KBPAN)
  RCONST(14683) = (7.91D-11)
  RCONST(14684) = (j('ch3o2h')+j('biacet'))
  RCONST(14685) = (KDEC)
  RCONST(14686) = (KAPHO2*0.15)
  RCONST(14687) = (KAPHO2*0.41)
  RCONST(14688) = (KAPHO2*0.44)
  RCONST(14689) = (KAPNO)
  RCONST(14690) = (KFPAN)
  RCONST(14691) = (KRO2NO3*1.74)
  RCONST(14692) = (1.00D-11*RO2*0.3)
  RCONST(14693) = (1.00D-11*RO2*0.7)
  RCONST(14694) = (KAPHO2*0.15)
  RCONST(14695) = (KAPHO2*0.41)
  RCONST(14696) = (KAPHO2*0.44)
  RCONST(14697) = (KAPNO)
  RCONST(14698) = (KFPAN)
  RCONST(14699) = (KRO2NO3*1.74)
  RCONST(14700) = (1.00D-11*RO2*0.3)
  RCONST(14701) = (1.00D-11*RO2*0.7)
  RCONST(14702) = (KAPHO2*0.15)
  RCONST(14703) = (KAPHO2*0.41)
  RCONST(14704) = (KAPHO2*0.44)
  RCONST(14705) = (KAPNO)
  RCONST(14706) = (KFPAN)
  RCONST(14707) = (KRO2NO3*1.74)
  RCONST(14708) = (1.00D-11*RO2*0.3)
  RCONST(14709) = (1.00D-11*RO2*0.7)
  RCONST(14710) = (KRO2HO2*0.770)
  RCONST(14711) = (KRO2NO)
  RCONST(14712) = (KRO2NO3)
  RCONST(14713) = (2.00D-12*RO2*0.2)
  RCONST(14714) = (2.00D-12*RO2*0.6)
  RCONST(14715) = (2.00D-12*RO2*0.2)
  RCONST(14716) = (KRO2HO2*0.770)
  RCONST(14717) = (KRO2NO)
  RCONST(14718) = (KRO2NO3)
  RCONST(14719) = (9.20D-14*RO2*0.7)
  RCONST(14720) = (9.20D-14*RO2*0.3)
  RCONST(14721) = (5.42D-11)
  RCONST(14722) = (j('biacet')+j('ch3o2h'))
  RCONST(14723) = (KDEC)
  RCONST(14724) = (1.48D-11)
  RCONST(14725) = (1.79D-11)
  RCONST(14726) = (j('ch3o2h'))
  RCONST(14727) = (1.43D-11)
  RCONST(14728) = (KBPAN)
  RCONST(14729) = (3.74D-11)
  RCONST(14730) = (j('n_c3h7cho_hco'))
  RCONST(14731) = (j('ch3o2h'))
  RCONST(14732) = (j('mek'))
  RCONST(14733) = (KDEC*0.5)
  RCONST(14734) = (KDEC*0.5)
  RCONST(14735) = (3.40D-11)
  RCONST(14736) = (j('n_c3h7cho_hco'))
  RCONST(14737) = (j('mek'))
  RCONST(14738) = (KRO2HO2*0.820)
  RCONST(14739) = (KRO2NO)
  RCONST(14740) = (KRO2NO3)
  RCONST(14741) = (9.20D-14*RO2*0.7)
  RCONST(14742) = (9.20D-14*RO2*0.3)
  RCONST(14743) = (KNO3AL*8.5)
  RCONST(14744) = (3.50D-11)
  RCONST(14745) = (KDEC)
  RCONST(14746) = (KRO2HO2*0.820)
  RCONST(14747) = (KRO2NO*0.056)
  RCONST(14748) = (KRO2NO*0.944)
  RCONST(14749) = (KRO2NO3)
  RCONST(14750) = (9.20D-14*RO2*0.7)
  RCONST(14751) = (9.20D-14*RO2*0.3)
  RCONST(14752) = (5.94D-11)
  RCONST(14753) = (6.25D-11)
  RCONST(14754) = (j('ch3o2h'))
  RCONST(14755) = (KRO2HO2*0.770)
  RCONST(14756) = (KRO2NO*0.209)
  RCONST(14757) = (KRO2NO*0.791)
  RCONST(14758) = (KRO2NO3)
  RCONST(14759) = (2.50D-13*RO2*0.2)
  RCONST(14760) = (2.50D-13*RO2*0.6)
  RCONST(14761) = (2.50D-13*RO2*0.2)
  RCONST(14762) = (5.89D-11)
  RCONST(14763) = (KBPAN)
  RCONST(14764) = (KRO2HO2*0.859)
  RCONST(14765) = (KRO2NO)
  RCONST(14766) = (KRO2NO3)
  RCONST(14767) = (8.80D-12*RO2*0.2)
  RCONST(14768) = (8.80D-12*RO2*0.6)
  RCONST(14769) = (8.80D-12*RO2*0.2)
  RCONST(14770) = (4.95D-11)
  RCONST(14771) = (j('ch3o2h'))
  RCONST(14772) = (7.97D-12)
  RCONST(14773) = (j('n_c3h7ono2'))
  RCONST(14774) = (KDEC)
  RCONST(14775) = (2.81D-11)
  RCONST(14776) = (j('n_c3h7cho_hco'))
  RCONST(14777) = (2.82D-11)
  RCONST(14778) = (KRO2HO2*0.947)
  RCONST(14779) = (KRO2NO*0.132)
  RCONST(14780) = (KRO2NO*0.868)
  RCONST(14781) = (KRO2NO3)
  RCONST(14782) = (9.20D-14*RO2*0.7)
  RCONST(14783) = (9.20D-14*RO2*0.3)
  RCONST(14784) = (1.43D-11)
  RCONST(14785) = (j('ch3o2h')+j('biacet'))
  RCONST(14786) = (1.01D-11)
  RCONST(14787) = (j('2_c4h9ono2')+j('biacet'))
  RCONST(14788) = (KDEC)
  RCONST(14789) = (1.08D-11)
  RCONST(14790) = (j('biacet'))
  RCONST(14791) = (3.49D-11)
  RCONST(14792) = (j('ch3o2h')+j('biacet'))
  RCONST(14793) = (KDEC)
  RCONST(14794) = (1.63D-11)
  RCONST(14795) = (j('biacet'))
  RCONST(14796) = (2.27D-11)
  RCONST(14797) = (j('biacet'))
  RCONST(14798) = (9.84D-12)
  RCONST(14799) = (1.32D-11)
  RCONST(14800) = (j('ch3o2h'))
  RCONST(14801) = (KRO2HO2*0.859)
  RCONST(14802) = (KRO2NO)
  RCONST(14803) = (KRO2NO3)
  RCONST(14804) = (6.70D-15*RO2*0.7)
  RCONST(14805) = (6.70D-15*RO2*0.3)
  RCONST(14806) = (9.60D-12)
  RCONST(14807) = (KBPAN)
  RCONST(14808) = (7.74D-11)
  RCONST(14809) = (KRO2HO2*0.959)
  RCONST(14810) = (KRO2NO*0.245)
  RCONST(14811) = (KRO2NO*0.755)
  RCONST(14812) = (KRO2NO3)
  RCONST(14813) = (2.50D-13*RO2*0.2)
  RCONST(14814) = (2.50D-13*RO2*0.6)
  RCONST(14815) = (2.50D-13*RO2*0.2)
  RCONST(14816) = (2.43D-11)
  RCONST(14817) = (j('n_c3h7cho_hco'))
  RCONST(14818) = (7.32D-11)
  RCONST(14819) = (j('ch3o2h'))
  RCONST(14820) = (7.68D-11)
  RCONST(14821) = (7.32D-11)
  RCONST(14822) = (KBPAN)
  RCONST(14823) = (7.57D-11)
  RCONST(14824) = (j('ch3o2h'))
  RCONST(14825) = (4.38D-11)
  RCONST(14826) = (j('1_c4h9ono2'))
  RCONST(14827) = (KROSEC*O2)
  RCONST(14828) = (2.70D+14*EXP(-6643/TEMP))
  RCONST(14829) = (4.94D-11)
  RCONST(14830) = (5.78D-11)
  RCONST(14831) = (1.99D-11)
  RCONST(14832) = (j('ch3o2h'))
  RCONST(14833) = (7.03D-12)
  RCONST(14834) = (j('n_c3h7ono2'))
  RCONST(14835) = (KDEC)
  RCONST(14836) = (KNO3AL*8.5)
  RCONST(14837) = (2.76D-11)
  RCONST(14838) = (j('n_c3h7cho_hco'))
  RCONST(14839) = (1.08D-11)
  RCONST(14840) = (6.98D-11)
  RCONST(14841) = (7.29D-11)
  RCONST(14842) = (j('ch3o2h'))
  RCONST(14843) = (6.93D-11)
  RCONST(14844) = (KBPAN)
  RCONST(14845) = (3.46D-11)
  RCONST(14846) = (j('ch3o2h'))
  RCONST(14847) = (2.76D-11)
  RCONST(14848) = (j('2_c4h9ono2'))
  RCONST(14849) = (KDEC)
  RCONST(14850) = (3.12D-11)
  RCONST(14851) = (KAPHO2*0.44)
  RCONST(14852) = (KAPHO2*0.56)
  RCONST(14853) = (KAPNO)
  RCONST(14854) = (KFPAN)
  RCONST(14855) = (KRO2NO3*1.74)
  RCONST(14856) = (1.00D-11*RO2)
  RCONST(14857) = (1.86D-11)
  RCONST(14858) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14859) = (7.82D-12)
  RCONST(14860) = (j('2_c4h9ono2')+j('ch3cocho'))
  RCONST(14861) = (KDEC)
  RCONST(14862) = (1.75D-11)
  RCONST(14863) = (j('ch3cocho'))
  RCONST(14864) = (3.31D-11)
  RCONST(14865) = (j('ch3o2h'))
  RCONST(14866) = (KDEC)
  RCONST(14867) = (KNO3AL*5.5)
  RCONST(14868) = (2.37D-11)
  RCONST(14869) = (j('n_c3h7cho_hco'))
  RCONST(14870) = (j('biacet'))
  RCONST(14871) = (7.90D-11)
  RCONST(14872) = (j('ch3cocho')+j('biacet'))
  RCONST(14873) = (9.13D-11)
  RCONST(14874) = (j('n_c3h7cho_hco')*2)
  RCONST(14875) = (9.44D-11)
  RCONST(14876) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(14877) = (KRO2HO2*0.770)
  RCONST(14878) = (KRO2NO)
  RCONST(14879) = (KRO2NO3)
  RCONST(14880) = (8.80D-13*RO2*0.2)
  RCONST(14881) = (8.80D-13*RO2*0.6)
  RCONST(14882) = (8.80D-13*RO2*0.2)
  RCONST(14883) = (8.47D-11)
  RCONST(14884) = (KBPAN)
  RCONST(14885) = (6.72D-11)
  RCONST(14886) = (j('n_c3h7cho_hco'))
  RCONST(14887) = (7.03D-11)
  RCONST(14888) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14889) = (6.74D-11)
  RCONST(14890) = (KBPAN)
  RCONST(14891) = (6.72D-11)
  RCONST(14892) = (j('n_c3h7cho_hco'))
  RCONST(14893) = (7.03D-11)
  RCONST(14894) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14895) = (6.67D-11)
  RCONST(14896) = (KBPAN)
  RCONST(14897) = (7.56D-11)
  RCONST(14898) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14899) = (KDEC)
  RCONST(14900) = (7.88D-11)
  RCONST(14901) = (j('ch3cocho')+j('n_c3h7cho_hco'))
  RCONST(14902) = (6.89D-11)
  RCONST(14903) = (j('n_c3h7cho_hco'))
  RCONST(14904) = (7.03D-11)
  RCONST(14905) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14906) = (KDEC)
  RCONST(14907) = (3.58D-11)
  RCONST(14908) = (j('ch3o2h'))
  RCONST(14909) = (KDEC)
  RCONST(14910) = (3.34D-11)
  RCONST(14911) = (KAPHO2*0.15)
  RCONST(14912) = (KAPHO2*0.41)
  RCONST(14913) = (KAPHO2*0.44)
  RCONST(14914) = (KAPNO)
  RCONST(14915) = (KFPAN)
  RCONST(14916) = (KRO2NO3*1.74)
  RCONST(14917) = (1.00D-11*RO2*0.3)
  RCONST(14918) = (1.00D-11*RO2*0.7)
  RCONST(14919) = (KRO2HO2*0.770)
  RCONST(14920) = (KRO2NO)
  RCONST(14921) = (KRO2NO3)
  RCONST(14922) = (9.20D-14*RO2*0.7)
  RCONST(14923) = (9.20D-14*RO2*0.3)
  RCONST(14924) = (4.00D-11)
  RCONST(14925) = (j('ch3o2h'))
  RCONST(14926) = (3.09D-11)
  RCONST(14927) = (KDEC)
  RCONST(14928) = (3.66D-11)
  RCONST(14929) = (1.10D-10)
  RCONST(14930) = (j('ch3o2h'))
  RCONST(14931) = (2.92D-11)
  RCONST(14932) = (j('1_c4h9ono2'))
  RCONST(14933) = (KROSEC*O2)
  RCONST(14934) = (4.00D+14*EXP(-6990/TEMP))
  RCONST(14935) = (6.04D-11)
  RCONST(14936) = (j('mek'))
  RCONST(14937) = (9.53D-11)
  RCONST(14938) = (5.51D-11)
  RCONST(14939) = (j('ch3o2h'))
  RCONST(14940) = (KDEC)
  RCONST(14941) = (2.28D-11)
  RCONST(14942) = (j('ch3cocho'))
  RCONST(14943) = (4.30D-11)
  RCONST(14944) = (KRO2HO2*0.859)
  RCONST(14945) = (KRO2NO)
  RCONST(14946) = (KRO2NO3)
  RCONST(14947) = (8.80D-12*RO2*0.2)
  RCONST(14948) = (8.80D-12*RO2*0.6)
  RCONST(14949) = (8.80D-12*RO2*0.2)
  RCONST(14950) = (1.57D-11)
  RCONST(14951) = (j('ch3o2h'))
  RCONST(14952) = (8.60D-12)
  RCONST(14953) = (j('2_c4h9ono2'))
  RCONST(14954) = (KDEC)
  RCONST(14955) = (1.23D-11)
  RCONST(14956) = (KRO2HO2*0.706)
  RCONST(14957) = (KRO2NO)
  RCONST(14958) = (KRO2NO3)
  RCONST(14959) = (2.00D-12*RO2*0.2)
  RCONST(14960) = (2.00D-12*RO2*0.6)
  RCONST(14961) = (2.00D-12*RO2*0.2)
  RCONST(14962) = (KRO2HO2*0.959)
  RCONST(14963) = (KRO2NO)
  RCONST(14964) = (KRO2NO3)
  RCONST(14965) = (8.80D-13*RO2)
  RCONST(14966) = (1.05D-11)
  RCONST(14967) = (j('ch3o2h'))
  RCONST(14968) = (KDEC)
  RCONST(14969) = (7.04D-12)
  RCONST(14970) = (7.10D-11)
  RCONST(14971) = (j('ch3o2h'))
  RCONST(14972) = (5.57D-11)
  RCONST(14973) = (j('2_c4h9ono2'))
  RCONST(14974) = (KDEC)
  RCONST(14975) = (6.20D-11)
  RCONST(14976) = (KAPHO2*0.56)
  RCONST(14977) = (KAPHO2*0.44)
  RCONST(14978) = (KAPNO)
  RCONST(14979) = (KFPAN)
  RCONST(14980) = (KRO2NO3*1.74)
  RCONST(14981) = (1.00D-11*RO2)
  RCONST(14982) = (KRO2HO2*0.625)
  RCONST(14983) = (KRO2NO)
  RCONST(14984) = (KRO2NO3)
  RCONST(14985) = (2.00D-12*RO2)
  RCONST(14986) = (KRO2HO2*0.890)
  RCONST(14987) = (KRO2NO)
  RCONST(14988) = (KRO2NO3)
  RCONST(14989) = (8.80D-13*RO2*0.2)
  RCONST(14990) = (8.80D-13*RO2*0.6)
  RCONST(14991) = (8.80D-13*RO2*0.2)
  RCONST(14992) = (1.68D-11)
  RCONST(14993) = (j('ch3o2h'))
  RCONST(14994) = (1.32D-11)
  RCONST(14995) = (KBPAN)
  RCONST(14996) = (KRO2HO2*0.706)
  RCONST(14997) = (KRO2NO)
  RCONST(14998) = (KRO2NO3)
  RCONST(14999) = (8.8D-13*RO2)
  RCONST(15000) = (KRO2HO2*0.625)
  RCONST(15001) = (KRO2NO)
  RCONST(15002) = (KRO2NO3)
  RCONST(15003) = (8.80D-13*RO2)
  RCONST(15004) = (KAPHO2*0.44)
  RCONST(15005) = (KAPHO2*0.56)
  RCONST(15006) = (KAPNO)
  RCONST(15007) = (KFPAN)
  RCONST(15008) = (KRO2NO3*1.74)
  RCONST(15009) = (1.00D-11*RO2)
  RCONST(15010) = (KRO2HO2*0.625)
  RCONST(15011) = (KRO2NO)
  RCONST(15012) = (KRO2NO3)
  RCONST(15013) = (2.00D-12*RO2)
  RCONST(15014) = (9.31D-11)
  RCONST(15015) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(15016) = (KDEC)
  RCONST(15017) = (6.15D-11)
  RCONST(15018) = (j('n_c3h7cho_hco')*2)
  RCONST(15019) = (KAPHO2*0.15)
  RCONST(15020) = (KAPHO2*0.41)
  RCONST(15021) = (KAPHO2*0.44)
  RCONST(15022) = (KAPNO)
  RCONST(15023) = (KFPAN)
  RCONST(15024) = (KRO2NO3*1.74)
  RCONST(15025) = (1.00D-11*RO2*0.3)
  RCONST(15026) = (1.00D-11*RO2*0.7)
  RCONST(15027) = (1.06D-11)
  RCONST(15028) = (1.37D-11)
  RCONST(15029) = (j('ch3o2h')+j('mek'))
  RCONST(15030) = (KRO2HO2*0.706)
  RCONST(15031) = (KRO2NO)
  RCONST(15032) = (KRO2NO3)
  RCONST(15033) = (8.80D-13*RO2*0.6)
  RCONST(15034) = (8.80D-13*RO2*0.2)
  RCONST(15035) = (8.80D-13*RO2*0.2)
  RCONST(15036) = (1.01D-11)
  RCONST(15037) = (KBPAN)
  RCONST(15038) = (3.31D-11)
  RCONST(15039) = (j('ch3o2h'))
  RCONST(15040) = (j('n_c3h7cho_hco'))
  RCONST(15041) = (j('mek'))
  RCONST(15042) = (KDEC*0.5)
  RCONST(15043) = (KDEC*0.5)
  RCONST(15044) = (2.97D-11)
  RCONST(15045) = (j('n_c3h7cho_hco'))
  RCONST(15046) = (j('mek'))
  RCONST(15047) = (KRO2HO2*0.770)
  RCONST(15048) = (KRO2NO)
  RCONST(15049) = (KRO2NO3)
  RCONST(15050) = (9.20D-14*RO2*0.7)
  RCONST(15051) = (9.20D-14*RO2*0.3)
  RCONST(15052) = (4.16D-11)
  RCONST(15053) = (j('ch3o2h'))
  RCONST(15054) = (KDEC)
  RCONST(15055) = (2.43D-11)
  RCONST(15056) = (j('mek'))
  RCONST(15057) = (2.95D-11)
  RCONST(15058) = (7.96D-12)
  RCONST(15059) = (KRO2HO2*0.947)
  RCONST(15060) = (KRO2NO*0.240)
  RCONST(15061) = (KRO2NO*0.760)
  RCONST(15062) = (KRO2NO3)
  RCONST(15063) = (2.50D-13*RO2*0.2)
  RCONST(15064) = (2.50D-13*RO2*0.6)
  RCONST(15065) = (2.50D-13*RO2*0.2)
  RCONST(15066) = (1.45D-11)
  RCONST(15067) = (j('ch3o2h')+j('biacet'))
  RCONST(15068) = (KDEC)
  RCONST(15069) = (7.61D-12)
  RCONST(15070) = (j('biacet'))
  RCONST(15071) = (3.09D-11)
  RCONST(15072) = (j('ch3o2h')+j('biacet'))
  RCONST(15073) = (KDEC)
  RCONST(15074) = (7.18D-12)
  RCONST(15075) = (j('ch3o2h'))
  RCONST(15076) = (3.58D-12)
  RCONST(15077) = (KBPAN)
  RCONST(15078) = (1.05D-11)
  RCONST(15079) = (1.90D-12*EXP(190/TEMP))
  RCONST(15080) = (j('ch3o2h'))
  RCONST(15081) = (KROPRIM*O2)
  RCONST(15082) = (2.65D-11)
  RCONST(15083) = (j('ch3o2h'))
  RCONST(15084) = (KDEC)
  RCONST(15085) = (1.48D-11)
  RCONST(15086) = (j('biacet'))
  RCONST(15087) = (1.43D-11)
  RCONST(15088) = (j('mek')+j('ch3o2h'))
  RCONST(15089) = (3.38D-11)
  RCONST(15090) = (KDEC)
  RCONST(15091) = (7.46D-11)
  RCONST(15092) = (j('ch3o2h'))
  RCONST(15093) = (KDEC)
  RCONST(15094) = (6.55D-12)
  RCONST(15095) = (j('ch3o2h')+j('biacet'))
  RCONST(15096) = (2.92D-12)
  RCONST(15097) = (KBPAN)
  RCONST(15098) = (9.61D-12)
  RCONST(15099) = (j('ch3o2h')+j('biacet'))
  RCONST(15100) = (KDEC)
  RCONST(15101) = (2*KNO3AL*8.5)
  RCONST(15102) = (1.32D-10)
  RCONST(15103) = (j('n_c3h7cho_hco')*2)
  RCONST(15104) = (6.67D-11)
  RCONST(15105) = (j('n_c3h7cho_hco'))
  RCONST(15106) = (6.98D-11)
  RCONST(15107) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(15108) = (2.11D-11)
  RCONST(15109) = (KBPAN)
  RCONST(15110) = (2.74D-11)
  RCONST(15111) = (j('ch3o2h'))
  RCONST(15112) = (j('mek'))
  RCONST(15113) = (KDEC)
  RCONST(15114) = (3.04D-11)
  RCONST(15115) = (j('ch3o2h'))
  RCONST(15116) = (j('mek'))
  RCONST(15117) = (KDEC)
  RCONST(15118) = (2.70D-11)
  RCONST(15119) = (j('mek'))
  RCONST(15120) = (3.68D-11)
  RCONST(15121) = (j('ch3o2h'))
  RCONST(15122) = (7.81D-12)
  RCONST(15123) = (j('2_c4h9ono2'))
  RCONST(15124) = (KDEC)
  RCONST(15125) = (1.90D-11)
  RCONST(15126) = (2.13D-11)
  RCONST(15127) = (j('n_c3h7cho_hco'))
  RCONST(15128) = (KNO3AL*8.5)
  RCONST(15129) = (2.27D-11)
  RCONST(15130) = (j('n_c3h7cho_hco'))
  RCONST(15131) = (KAPHO2*0.56)
  RCONST(15132) = (KAPHO2*0.44)
  RCONST(15133) = (KAPNO)
  RCONST(15134) = (KFPAN)
  RCONST(15135) = (KRO2NO3*1.74)
  RCONST(15136) = (1.00D-11*RO2)
  RCONST(15137) = (KRO2HO2*0.520)
  RCONST(15138) = (KRO2NO)
  RCONST(15139) = (KRO2NO3)
  RCONST(15140) = (2.00D-12*0.6*RO2)
  RCONST(15141) = (2.00D-12*0.2*RO2)
  RCONST(15142) = (2.00D-12*0.2*RO2)
  RCONST(15143) = (KAPHO2*0.56)
  RCONST(15144) = (KAPHO2*0.44)
  RCONST(15145) = (KAPNO)
  RCONST(15146) = (KFPAN)
  RCONST(15147) = (KRO2NO3*1.74)
  RCONST(15148) = (1.00D-11*RO2)
  RCONST(15149) = (KRO2HO2*0.859)
  RCONST(15150) = (KRO2NO)
  RCONST(15151) = (KRO2NO3)
  RCONST(15152) = (6.70D-15*RO2)
  RCONST(15153) = (4.14D-12)
  RCONST(15154) = (j('ch3o2h'))
  RCONST(15155) = (5.40D-13)
  RCONST(15156) = (KBPAN)
  RCONST(15157) = (1.90D-12*EXP(190/TEMP))
  RCONST(15158) = (9.22D-12)
  RCONST(15159) = (j('ch3o2h'))
  RCONST(15160) = (KDEC)
  RCONST(15161) = (2.52D-13)
  RCONST(15162) = (2.16D-13)
  RCONST(15163) = (j('ch3cocho'))
  RCONST(15164) = (8.26D-12)
  RCONST(15165) = (j('ch3o2h'))
  RCONST(15166) = (4.66D-12)
  RCONST(15167) = (KBPAN)
  RCONST(15168) = (8.26D-12)
  RCONST(15169) = (j('ch3o2h'))
  RCONST(15170) = (KDEC)
  RCONST(15171) = (KRO2HO2*0.520)
  RCONST(15172) = (KRO2NO)
  RCONST(15173) = (KRO2NO3)
  RCONST(15174) = (2.00D-12*RO2)
  RCONST(15175) = (1.99D-11)
  RCONST(15176) = (j('ch3o2h'))
  RCONST(15177) = (KDEC)
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )


   USE MCMv3_3_Global

  RCONST(37) = (j('o31d'))
  RCONST(38) = (j('o33p'))
  RCONST(39) = (j('h2o2'))
  RCONST(40) = (j('no2'))
  RCONST(41) = (j('no3o2'))
  RCONST(42) = (j('no3o'))
  RCONST(43) = (j('hno2'))
  RCONST(44) = (j('hno3'))
  RCONST(86) = (j('mek'))
  RCONST(96) = (j('ch2or'))
  RCONST(97) = (j('ch2om'))
  RCONST(100) = (j('ch3cho'))
  RCONST(106) = (j('c2h5cho'))
  RCONST(110) = (j('n_c3h7cho_ch3cho'))
  RCONST(111) = (j('n_c3h7cho_hco'))
  RCONST(116) = (j('i_c3h7cho'))
  RCONST(120) = (j('n_c3h7cho_hco'))
  RCONST(125) = (0.3*j('ch2cch3cho_hco'))
  RCONST(126) = (0.4*j('ch2cch3cho_hco'))
  RCONST(127) = (0.3*j('ch2cch3cho_hco'))
  RCONST(130) = (j('ch2cch3cho_hco'))
  RCONST(131) = (j('ch2cch3cho_h'))
  RCONST(146) = (j('ch2cch3cho_hco')*1.44)
  RCONST(396) = (j('ch2cch3cho_h'))
  RCONST(397) = (j('ch2cch3cho_hco'))
  RCONST(425) = (j('ch3coch3'))
  RCONST(429) = (j('mek'))
  RCONST(432) = (j('mek'))
  RCONST(435) = (j('mek'))
  RCONST(436) = (j('mek'))
  RCONST(442) = (j('mek'))
  RCONST(447) = (j('mek'))
  RCONST(450) = (j('mek'))
  RCONST(451) = (j('mek'))
  RCONST(454) = (j('mek')*0.5)
  RCONST(455) = (j('mek')*0.5)
  RCONST(569) = (j('n_c3h7cho_ch3cho'))
  RCONST(570) = (j('i_c3h7cho'))
  RCONST(673) = (j('n_c3h7cho_hco'))
  RCONST(675) = (j('mek'))
  RCONST(678) = (j('i_c3h7cho'))
  RCONST(696) = (j('i_c3h7cho'))
  RCONST(838) = (0.3333*j('gly'))
  RCONST(839) = (0.3333*j('gly'))
  RCONST(840) = (0.3333*j('gly'))
  RCONST(859) = (j('ch3cocho'))
  RCONST(1418) = (j('no2')*0.1*0.5)
  RCONST(1419) = (j('no2')*0.1*0.5)
  RCONST(1449) = (j('no2')*0.1*0.5)
  RCONST(1450) = (j('no2')*0.1*0.5)
  RCONST(1468) = (j('no2')*0.05*0.5)
  RCONST(1469) = (j('no2')*0.05*0.5)
  RCONST(1494) = (j('no2')*0.028*0.5)
  RCONST(1495) = (j('no2')*0.028*0.5)
  RCONST(1519) = (j('no2')*0.1*0.5)
  RCONST(1520) = (j('no2')*0.1*0.5)
  RCONST(1551) = (j('no2')*0.028*0.5)
  RCONST(1552) = (j('no2')*0.028*0.5)
  RCONST(1577) = (j('no2')*0.028*0.5)
  RCONST(1578) = (j('no2')*0.028*0.5)
  RCONST(1602) = (j('no2')*0.028*0.5)
  RCONST(1603) = (j('no2')*0.028*0.5)
  RCONST(1626) = (j('mek'))
  RCONST(1627) = (j('mvk_mcm_ch2ch'))
  RCONST(1651) = (j('no2')*0.028*0.5)
  RCONST(1652) = (j('no2')*0.028*0.5)
  RCONST(1675) = (j('no2')*0.1*0.5)
  RCONST(1676) = (j('no2')*0.1*0.5)
  RCONST(1694) = (j('no2')*0.05*0.5)
  RCONST(1695) = (j('no2')*0.05*0.5)
  RCONST(1713) = (j('no2')*0.028*0.5)
  RCONST(1714) = (j('no2')*0.028*0.5)
  RCONST(1731) = (j('no2')*0.028*0.5)
  RCONST(1732) = (j('no2')*0.028*0.5)
  RCONST(1757) = (j('no2')*0.028*0.5)
  RCONST(1758) = (j('no2')*0.028*0.5)
  RCONST(1785) = (j('no2')*0.028*0.5)
  RCONST(1786) = (j('no2')*0.028*0.5)
  RCONST(1862) = (j('mvk_mcm_co'))
  RCONST(1863) = (j('mvk_mcm_ch2ch'))
  RCONST(1892) = (j('n_c3h7cho_hco'))
  RCONST(1897) = (j('mek'))
  RCONST(2208) = (j('ch3o2h'))
  RCONST(2212) = (j('ch3o2h'))
  RCONST(2215) = (j('n_c3h7ono2'))
  RCONST(2218) = (j('n_c3h7cho_hco'))
  RCONST(2224) = (j('ch3o2h'))
  RCONST(2229) = (j('ch3o2h'))
  RCONST(2234) = (j('ch3o2h'))
  RCONST(2238) = (j('mek'))
  RCONST(2242) = (j('ch3o2h'))
  RCONST(2244) = (j('1_c4h9ono2'))
  RCONST(2249) = (j('mek'))
  RCONST(2252) = (j('ch3o2h'))
  RCONST(2256) = (j('mek'))
  RCONST(2259) = (j('ch3o2h'))
  RCONST(2265) = (j('ch3o2h'))
  RCONST(2267) = (j('n_c3h7ono2'))
  RCONST(2269) = (j('i_c3h7cho'))
  RCONST(2275) = (j('ch3o2h'))
  RCONST(2278) = (j('ch3o2h'))
  RCONST(2281) = (j('n_c3h7ono2'))
  RCONST(2285) = (j('n_c3h7cho_hco'))
  RCONST(2291) = (j('ch3o2h'))
  RCONST(2296) = (j('mek'))
  RCONST(2305) = (j('ch3o2h'))
  RCONST(2307) = (j('1_c4h9ono2'))
  RCONST(2311) = (j('mek'))
  RCONST(2314) = (j('ch3o2h'))
  RCONST(2332) = (j('ch3o2h'))
  RCONST(2334) = (j('2_c4h9ono2'))
  RCONST(2340) = (j('ch3o2h'))
  RCONST(2345) = (j('mek'))
  RCONST(2346) = (j('ch3o2h'))
  RCONST(2349) = (j('n_c3h7ono2'))
  RCONST(2353) = (j('n_c3h7cho_hco'))
  RCONST(2358) = (j('ch3o2h'))
  RCONST(2366) = (j('ch3o2h'))
  RCONST(2371) = (j('i_c3h7cho'))
  RCONST(2372) = (j('ch3o2h'))
  RCONST(2375) = (j('n_c3h7ono2'))
  RCONST(2379) = (j('i_c3h7cho'))
  RCONST(2385) = (j('ch3o2h'))
  RCONST(2390) = (j('ch3o2h'))
  RCONST(2395) = (j('mek'))
  RCONST(2398) = (j('mek'))
  RCONST(2399) = (j('ch3o2h'))
  RCONST(2402) = (j('biacet'))
  RCONST(2404) = (j('mek'))
  RCONST(2407) = (j('ch3o2h')+j('mek'))
  RCONST(2410) = (j('mek'))
  RCONST(2412) = (j('i_c3h7cho'))
  RCONST(2415) = (j('ch3o2h'))
  RCONST(2416) = (j('mek'))
  RCONST(2419) = (j('mek'))
  RCONST(2422) = (j('ch3cocho'))
  RCONST(2425) = (j('ch3o2h'))
  RCONST(2444) = (j('ch3o2h'))
  RCONST(2450) = (j('ch3o2h'))
  RCONST(2476) = (j('ch3o2h'))
  RCONST(2479) = (j('mek'))
  RCONST(2483) = (j('ch3o2h'))
  RCONST(2486) = (j('i_c3h7cho'))
  RCONST(2487) = (j('ch3o2h'))
  RCONST(2490) = (j('ch3ono2'))
  RCONST(2496) = (j('ch3o2h'))
  RCONST(2497) = (j('n_c3h7cho_hco'))
  RCONST(2500) = (j('ch3o2h'))
  RCONST(2504) = (j('ch3o2h'))
  RCONST(2507) = (j('c2h5ono2'))
  RCONST(2511) = (j('ch3o2h'))
  RCONST(2516) = (j('ch3o2h'))
  RCONST(2517) = (j('n_c3h7cho_hco'))
  RCONST(2519) = (j('1_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(2524) = (j('n_c3h7cho_hco'))
  RCONST(2525) = (j('n_c3h7cho_hco'))
  RCONST(2529) = (j('ch3o2h'))
  RCONST(2532) = (j('n_c3h7ono2'))
  RCONST(2537) = (j('ch3o2h'))
  RCONST(2542) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(2544) = (j('n_c3h7ono2')+j('i_c3h7cho'))
  RCONST(2548) = (j('i_c3h7cho')*2.0)
  RCONST(2550) = (j('i_c3h7cho'))
  RCONST(2551) = (j('ch3o2h'))
  RCONST(2553) = (j('ch3o2h'))
  RCONST(2556) = (j('1_c4h9ono2'))
  RCONST(2561) = (j('ch3o2h'))
  RCONST(2566) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(2568) = (j('1_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(2570) = (j('n_c3h7cho_hco'))
  RCONST(2573) = (j('ch3o2h'))
  RCONST(2576) = (j('n_c3h7ono2'))
  RCONST(2581) = (j('ch3o2h'))
  RCONST(2587) = (j('ch3o2h'))
  RCONST(2589) = (j('ch3cocho'))
  RCONST(2594) = (j('n_c3h7cho_hco')*2)
  RCONST(2596) = (j('ch3o2h'))
  RCONST(2597) = (j('n_c3h7cho_hco'))
  RCONST(2610) = (j('ch3o2h'))
  RCONST(2624) = (j('i_c3h7cho'))
  RCONST(2625) = (j('ch3o2h'))
  RCONST(2629) = (j('ch3coch2ono2')*10)
  RCONST(2631) = (j('i_c3h7cho'))
  RCONST(2634) = (j('i_c3h7cho'))
  RCONST(2635) = (j('ch3o2h'))
  RCONST(2636) = (j('ch3coch2ono2')*1.6)
  RCONST(2640) = (j('i_c3h7cho')*2)
  RCONST(2642) = (j('ch3o2h'))
  RCONST(2648) = (j('i_c3h7cho')+j('ch3o2h'))
  RCONST(2652) = (j('ch3cocho'))
  RCONST(2653) = (j('2_c4h9ono2'))
  RCONST(2655) = (j('i_c3h7cho')+j('2_c4h9ono2'))
  RCONST(2658) = (j('i_c3h7cho')+j('ch3o2h'))
  RCONST(2661) = (j('i_c3h7cho'))
  RCONST(2669) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(2672) = (j('i_c3h7cho'))
  RCONST(2673) = (j('n_c3h7cho_hco'))
  RCONST(2677) = (j('i_c3h7cho'))
  RCONST(2678) = (j('ch3o2h'))
  RCONST(2681) = (j('ch3cocho'))
  RCONST(2684) = (j('ch3o2h'))
  RCONST(2686) = (j('1_c4h9ono2'))
  RCONST(2689) = (j('ch3o2h'))
  RCONST(2692) = (j('n_c3h7ono2'))
  RCONST(2696) = (j('ch3o2h'))
  RCONST(2698) = (j('2_c4h9ono2'))
  RCONST(2701) = (j('ch3o2h'))
  RCONST(2703) = (j('n_c3h7ono2'))
  RCONST(2708) = (j('ch3o2h'))
  RCONST(2710) = (j('1_c4h9ono2'))
  RCONST(2715) = (j('ch3o2h'))
  RCONST(2717) = (j('1_c4h9ono2'))
  RCONST(2720) = (j('ch3o2h'))
  RCONST(2723) = (j('n_c3h7ono2'))
  RCONST(2727) = (j('ch3o2h'))
  RCONST(2730) = (j('1_c4h9ono2'))
  RCONST(2734) = (j('ch3o2h'))
  RCONST(2736) = (j('2_c4h9ono2'))
  RCONST(2739) = (j('ch3o2h'))
  RCONST(2742) = (j('n_c3h7ono2'))
  RCONST(2748) = (j('i_c3h7cho'))
  RCONST(2749) = (j('ch3o2h'))
  RCONST(2752) = (j('n_c3h7ono2'))
  RCONST(2755) = (j('n_c3h7cho_ch3cho'))
  RCONST(2756) = (j('n_c3h7cho_hco'))
  RCONST(2760) = (j('ch3o2h'))
  RCONST(2763) = (j('1_c4h9ono2'))
  RCONST(2767) = (j('ch3o2h'))
  RCONST(2769) = (j('1_c4h9ono2'))
  RCONST(2774) = (j('ch3o2h'))
  RCONST(2777) = (j('n_c3h7ono2'))
  RCONST(2780) = (j('i_c3h7cho'))
  RCONST(2784) = (j('ch3o2h'))
  RCONST(2787) = (j('1_c4h9ono2'))
  RCONST(2792) = (j('ch3o2h'))
  RCONST(2795) = (j('1_c4h9ono2'))
  RCONST(2800) = (j('mek'))
  RCONST(2801) = (j('mek'))
  RCONST(2805) = (j('ch3o2h'))
  RCONST(2807) = (j('2_c4h9ono2'))
  RCONST(2812) = (j('ch3o2h'))
  RCONST(2815) = (j('n_c3h7ono2'))
  RCONST(2818) = (j('n_c3h7cho_hco'))
  RCONST(2822) = (j('ch3o2h'))
  RCONST(2825) = (j('1_c4h9ono2'))
  RCONST(2829) = (j('mek'))
  RCONST(2833) = (j('ch3o2h'))
  RCONST(2835) = (j('2_c4h9ono2'))
  RCONST(2839) = (j('ch3o2h'))
  RCONST(2842) = (j('1_c4h9ono2'))
  RCONST(2847) = (j('ch3o2h'))
  RCONST(2850) = (j('n_c3h7ono2'))
  RCONST(2853) = (j('n_c3h7cho_hco'))
  RCONST(2857) = (j('ch3o2h'))
  RCONST(2860) = (j('n_c3h7ono2'))
  RCONST(2864) = (j('i_c3h7cho'))
  RCONST(2868) = (j('ch3o2h'))
  RCONST(2870) = (j('2_c4h9ono2'))
  RCONST(2874) = (j('ch3o2h'))
  RCONST(2877) = (j('n_c3h7ono2'))
  RCONST(2882) = (j('i_c3h7cho'))
  RCONST(2885) = (j('ch3o2h'))
  RCONST(2887) = (j('1_c4h9ono2'))
  RCONST(2890) = (j('mek'))
  RCONST(2893) = (j('ch3o2h'))
  RCONST(2895) = (j('1_c4h9ono2'))
  RCONST(2898) = (j('mek'))
  RCONST(2901) = (j('ch3o2h'))
  RCONST(2903) = (j('2_c4h9ono2'))
  RCONST(2907) = (j('ch3o2h'))
  RCONST(2909) = (j('1_c4h9ono2'))
  RCONST(2912) = (j('mek'))
  RCONST(2915) = (j('ch3o2h'))
  RCONST(2917) = (j('2_c4h9ono2'))
  RCONST(2921) = (j('ch3o2h'))
  RCONST(2923) = (j('1_c4h9ono2'))
  RCONST(2926) = (j('mek'))
  RCONST(2929) = (j('ch3o2h'))
  RCONST(2931) = (j('1_c4h9ono2'))
  RCONST(2934) = (j('mek'))
  RCONST(2937) = (j('ch3o2h'))
  RCONST(2939) = (j('1_c4h9ono2'))
  RCONST(2942) = (j('mek'))
  RCONST(2946) = (j('ch3o2h'))
  RCONST(2948) = (j('1_c4h9ono2'))
  RCONST(2951) = (j('mek'))
  RCONST(2953) = (j('ch3o2h'))
  RCONST(2955) = (j('1_c4h9ono2'))
  RCONST(2958) = (j('mek'))
  RCONST(2961) = (j('ch3o2h'))
  RCONST(2963) = (j('1_c4h9ono2'))
  RCONST(2969) = (j('ch3o2h'))
  RCONST(2974) = (j('ch3coch2ono2')*4.3)
  RCONST(2977) = (j('ch3o2h'))
  RCONST(2982) = (j('ch3coch2ono2')*10)
  RCONST(2985) = (j('ch3o2h'))
  RCONST(2989) = (j('ch3coch2ono2'))
  RCONST(2991) = (j('ch3o2h'))
  RCONST(2995) = (j('ch3coch2ono2'))
  RCONST(2998) = (j('ch3o2h'))
  RCONST(3002) = (j('1_c4h9ono2'))
  RCONST(3003) = (j('i_c3h7cho'))
  RCONST(3012) = (j('ch3o2h'))
  RCONST(3016) = (j('n_c3h7cho_hco'))
  RCONST(3018) = (j('ch3o2h'))
  RCONST(3022) = (j('ch3coch2ono2')*1.6)
  RCONST(3024) = (j('ch3o2h'))
  RCONST(3027) = (j('ch3o2h'))
  RCONST(3032) = (j('n_c3h7cho_hco'))
  RCONST(3033) = (j('ch3coch2ono2')*10)
  RCONST(3041) = (j('ch3o2h'))
  RCONST(3045) = (j('ch3coch2ono2')*1.6)
  RCONST(3049) = (j('ch3o2h'))
  RCONST(3054) = (j('ch3coch2ono2')*10)
  RCONST(3064) = (j('ch3o2h'))
  RCONST(3067) = (j('mek'))
  RCONST(3071) = (j('ch3o2h'))
  RCONST(3075) = (j('n_c3h7cho_hco'))
  RCONST(3078) = (j('ch3o2h'))
  RCONST(3082) = (j('ch3coch2ono2')*1.6)
  RCONST(3085) = (j('ch3o2h'))
  RCONST(3089) = (j('ch3coch2ono2')*1.6)
  RCONST(3093) = (j('ch3o2h'))
  RCONST(3096) = (j('mek'))
  RCONST(3099) = (j('ch3o2h'))
  RCONST(3104) = (j('ch3coch2ono2')*10)
  RCONST(3105) = (j('n_c3h7cho_hco'))
  RCONST(3107) = (j('ch3o2h'))
  RCONST(3116) = (j('ch3o2h'))
  RCONST(3120) = (j('ch3coch2ono2'))
  RCONST(3122) = (j('n_c3h7ono2'))
  RCONST(3125) = (j('ch3o2h'))
  RCONST(3130) = (j('ch3coch2ono2')*10)
  RCONST(3139) = (j('ch3o2h'))
  RCONST(3143) = (j('i_c3h7cho'))
  RCONST(3146) = (j('ch3o2h'))
  RCONST(3150) = (j('ch3coch2ono2')*1.6)
  RCONST(3152) = (j('ch3o2h'))
  RCONST(3160) = (j('ch3coch2ono2')*10+j('n_c3h7cho_hco'))
  RCONST(3164) = (j('ch3o2h'))
  RCONST(3168) = (j('ch3coch2ono2'))
  RCONST(3178) = (j('ch3o2h'))
  RCONST(3181) = (j('mek'))
  RCONST(3183) = (j('ch3o2h'))
  RCONST(3187) = (j('n_c3h7cho_hco'))
  RCONST(3192) = (j('ch3o2h'))
  RCONST(3196) = (j('ch3coch2ono2')*1.6)
  RCONST(3200) = (j('ch3o2h'))
  RCONST(3204) = (j('ch3coch2ono2')*1.6)
  RCONST(3208) = (j('ch3o2h'))
  RCONST(3212) = (j('mek'))
  RCONST(3215) = (j('ch3o2h'))
  RCONST(3218) = (j('mek'))
  RCONST(3220) = (j('ch3o2h'))
  RCONST(3224) = (j('ch3o2h'))
  RCONST(3228) = (j('ch3o2h'))
  RCONST(3230) = (j('1_c4h9ono2'))
  RCONST(3235) = (j('mek'))
  RCONST(3246) = (j('i_c3h7cho')*2)
  RCONST(3268) = (j('no2')*0.14*0.4)
  RCONST(3269) = (j('no2')*0.14*0.6)
  RCONST(3286) = (j('ch3o2h'))
  RCONST(3288) = (j('n_c3h7ono2'))
  RCONST(3307) = (j('ch3o2h'))
  RCONST(3314) = (j('1_c4h9ono2'))
  RCONST(3317) = (j('mek'))
  RCONST(3344) = (j('ch3o2h'))
  RCONST(3346) = (j('n_c3h7ono2'))
  RCONST(3350) = (j('ch2cch3cho_h'))
  RCONST(3351) = (j('ch2cch3cho_hco'))
  RCONST(3354) = (j('ch3o2h'))
  RCONST(3356) = (j('2_c4h9ono2'))
  RCONST(3374) = (j('i_c3h7cho')*2)
  RCONST(3403) = (j('ch3o2h'))
  RCONST(3405) = (j('n_c3h7ono2'))
  RCONST(3409) = (j('ch2cch3cho_h'))
  RCONST(3410) = (j('ch2cch3cho_hco'))
  RCONST(3413) = (j('ch3o2h'))
  RCONST(3415) = (j('1_c4h9ono2'))
  RCONST(3424) = (j('mek')*0.5)
  RCONST(3425) = (j('mek')*0.5)
  RCONST(3436) = (j('i_c3h7cho')*2)
  RCONST(3466) = (j('ch3o2h'))
  RCONST(3468) = (j('n_c3h7ono2'))
  RCONST(3472) = (j('ch2cch3cho_h'))
  RCONST(3473) = (j('ch2cch3cho_hco'))
  RCONST(3476) = (j('ch3o2h'))
  RCONST(3478) = (j('2_c4h9ono2'))
  RCONST(3519) = (j('ch3o2h'))
  RCONST(3522) = (j('n_c3h7ono2'))
  RCONST(3526) = (j('i_c3h7cho'))
  RCONST(3543) = (j('ch3o2h'))
  RCONST(3549) = (j('1_c4h9ono2'))
  RCONST(3552) = (j('mek'))
  RCONST(3579) = (j('ch3o2h'))
  RCONST(3581) = (j('1_c4h9ono2'))
  RCONST(3585) = (j('mek'))
  RCONST(3602) = (j('ch3o2h'))
  RCONST(3608) = (j('1_c4h9ono2'))
  RCONST(3611) = (j('mek'))
  RCONST(3638) = (j('ch3o2h'))
  RCONST(3640) = (j('2_c4h9ono2'))
  RCONST(3659) = (j('ch3o2h'))
  RCONST(3665) = (j('1_c4h9ono2'))
  RCONST(3668) = (j('mek'))
  RCONST(3695) = (j('ch3o2h'))
  RCONST(3697) = (j('n_c3h7ono2'))
  RCONST(3701) = (j('ch2cch3cho_h'))
  RCONST(3702) = (j('ch2cch3cho_hco'))
  RCONST(3720) = (j('ch3o2h'))
  RCONST(3722) = (j('1_c4h9ono2'))
  RCONST(3731) = (j('mek'))
  RCONST(3734) = (j('mek'))
  RCONST(3735) = (j('i_c3h7cho'))
  RCONST(3744) = (j('ch3o2h'))
  RCONST(3746) = (j('n_c3h7ono2'))
  RCONST(3750) = (j('ch2cch3cho_h'))
  RCONST(3751) = (j('ch2cch3cho_hco'))
  RCONST(3754) = (j('ch3o2h'))
  RCONST(3756) = (j('2_c4h9ono2'))
  RCONST(3800) = (j('ch3o2h'))
  RCONST(3802) = (j('n_c3h7ono2'))
  RCONST(3806) = (j('ch2cch3cho_h'))
  RCONST(3807) = (j('ch2cch3cho_hco'))
  RCONST(3810) = (j('ch3o2h'))
  RCONST(3812) = (j('1_c4h9ono2'))
  RCONST(3817) = (j('mek'))
  RCONST(3839) = (j('mek'))
  RCONST(3840) = (j('i_c3h7cho'))
  RCONST(3856) = (j('ch3o2h'))
  RCONST(3858) = (j('1_c4h9ono2'))
  RCONST(3862) = (j('mek'))
  RCONST(3864) = (j('ch3o2h'))
  RCONST(3866) = (j('2_c4h9ono2'))
  RCONST(3884) = (j('i_c3h7cho')*2)
  RCONST(3913) = (j('ch3o2h'))
  RCONST(3915) = (j('2_c4h9ono2'))
  RCONST(3923) = (j('mek'))
  RCONST(3961) = (j('ch3o2h'))
  RCONST(3963) = (j('2_c4h9ono2'))
  RCONST(4005) = (j('ch3o2h'))
  RCONST(4007) = (j('1_c4h9ono2'))
  RCONST(4011) = (j('mek'))
  RCONST(4013) = (j('ch3o2h'))
  RCONST(4015) = (j('1_c4h9ono2'))
  RCONST(4022) = (j('mek'))
  RCONST(4057) = (j('ch3o2h'))
  RCONST(4059) = (j('1_c4h9ono2'))
  RCONST(4063) = (j('mek'))
  RCONST(4076) = (j('ch3o2h'))
  RCONST(4078) = (j('1_c4h9ono2'))
  RCONST(4083) = (j('mek'))
  RCONST(4094) = (j('mek'))
  RCONST(4095) = (j('i_c3h7cho'))
  RCONST(4117) = (j('ch3o2h'))
  RCONST(4120) = (j('ch3o2h'))
  RCONST(4125) = (j('ch3o2h'))
  RCONST(4126) = (j('ch3o2h'))
  RCONST(4130) = (j('mvk_mcm_ch2ch'))
  RCONST(4132) = (j('ch3o2h'))
  RCONST(4134) = (j('n_c3h7ono2')*2.0)
  RCONST(4137) = (j('n_c3h7ono2'))
  RCONST(4139) = (j('n_c3h7cho_hco'))
  RCONST(4151) = (j('ch3o2h'))
  RCONST(4155) = (j('ch2cch3cho_h'))
  RCONST(4156) = (j('ch2cch3cho_hco'))
  RCONST(4162) = (j('ch3o2h'))
  RCONST(4171) = (j('mvk_mcm_co'))
  RCONST(4172) = (j('mvk_mcm_ch2ch'))
  RCONST(4173) = (j('ch3o2h'))
  RCONST(4176) = (j('n_c3h7cho_hco'))
  RCONST(4179) = (j('ch3o2h'))
  RCONST(4181) = (j('n_c3h7ono2')*2.0)
  RCONST(4184) = (j('n_c3h7ono2'))
  RCONST(4188) = (j('ch3coch2ono2')*16)
  RCONST(4269) = (j('ch3o2h'))
  RCONST(4276) = (j('n_c3h7cho_hco'))
  RCONST(4339) = (j('ch3o2h'))
  RCONST(4343) = (j('n_c3h7ono2'))
  RCONST(4347) = (j('ch3o2h'))
  RCONST(4352) = (j('1_c4h9ono2'))
  RCONST(4356) = (j('ch3o2h'))
  RCONST(4358) = (j('n_c3h7ono2'))
  RCONST(4367) = (j('n_c3h7cho_hco'))
  RCONST(4371) = (j('mek'))
  RCONST(4372) = (j('ch3o2h'))
  RCONST(4375) = (j('ch3o2h')+j('mek'))
  RCONST(4377) = (j('n_c3h7ono2')+j('mek'))
  RCONST(4382) = (j('mek'))
  RCONST(4383) = (j('ch3o2h'))
  RCONST(4385) = (j('biacet'))
  RCONST(4389) = (j('mek'))
  RCONST(4390) = (j('ch3o2h'))
  RCONST(4392) = (j('ch3cocho'))
  RCONST(4397) = (j('ch3o2h'))
  RCONST(4398) = (j('mek'))
  RCONST(4401) = (j('1_c4h9ono2')+j('mek'))
  RCONST(4403) = (j('mek'))
  RCONST(4405) = (j('mek'))
  RCONST(4408) = (j('mek'))
  RCONST(4409) = (j('ch3o2h'))
  RCONST(4412) = (j('biacet'))
  RCONST(4415) = (j('mek'))
  RCONST(4416) = (j('ch3o2h'))
  RCONST(4420) = (j('ch3o2h')+j('mek'))
  RCONST(4422) = (j('mek')+j('n_c3h7ono2'))
  RCONST(4425) = (j('mek'))
  RCONST(4426) = (j('ch3o2h')+j('mek'))
  RCONST(4429) = (j('ch3o2h')+j('mek'))
  RCONST(4431) = (j('n_c3h7ono2')+j('mek'))
  RCONST(4435) = (j('i_c3h7cho'))
  RCONST(4440) = (j('mek')+j('ch3o2h'))
  RCONST(4442) = (j('mek')+j('1_c4h9ono2'))
  RCONST(4445) = (j('mek'))
  RCONST(4446) = (j('mek'))
  RCONST(4448) = (j('mek'))
  RCONST(4451) = (j('mek')+j('ch3o2h'))
  RCONST(4453) = (j('mek')+j('1_c4h9ono2'))
  RCONST(4456) = (j('mek')*2)
  RCONST(4458) = (j('mek'))
  RCONST(4463) = (j('mek'))
  RCONST(4464) = (j('ch3o2h'))
  RCONST(4467) = (j('biacet'))
  RCONST(4470) = (j('ch3o2h'))
  RCONST(4471) = (j('mek'))
  RCONST(4473) = (j('n_c3h7ono2')+j('mek'))
  RCONST(4476) = (j('mek'))
  RCONST(4479) = (j('mek'))
  RCONST(4480) = (j('ch3o2h'))
  RCONST(4483) = (j('biacet'))
  RCONST(4485) = (j('mek'))
  RCONST(4488) = (j('mek'))
  RCONST(4489) = (j('ch3o2h'))
  RCONST(4493) = (j('ch3o2h')+j('mek'))
  RCONST(4495) = (j('n_c3h7ono2')+j('mek'))
  RCONST(4499) = (j('mek'))
  RCONST(4500) = (j('n_c3h7cho_hco'))
  RCONST(4502) = (j('mek'))
  RCONST(4504) = (j('ch3o2h')+j('mek'))
  RCONST(4506) = (j('2_c4h9ono2')+j('mek'))
  RCONST(4511) = (j('mek'))
  RCONST(4512) = (j('ch3o2h'))
  RCONST(4515) = (j('biacet'))
  RCONST(4517) = (j('mek'))
  RCONST(4518) = (j('ch3o2h')+j('mek'))
  RCONST(4520) = (j('n_c3h7ono2')+j('mek'))
  RCONST(4524) = (j('i_c3h7cho'))
  RCONST(4527) = (j('mek'))
  RCONST(4530) = (j('ch3o2h')+j('mek'))
  RCONST(4532) = (j('1_c4h9ono2'))
  RCONST(4536) = (j('mek')*2)
  RCONST(4538) = (j('mek'))
  RCONST(4540) = (j('ch3o2h'))
  RCONST(4545) = (j('ch3o2h'))
  RCONST(4550) = (j('2_c4h9ono2'))
  RCONST(4576) = (j('ch3o2h'))
  RCONST(4580) = (j('ch3o2h'))
  RCONST(4584) = (j('ch3o2h'))
  RCONST(4586) = (j('2_c4h9ono2'))
  RCONST(4590) = (j('ch3o2h'))
  RCONST(4594) = (j('ch3o2h'))
  RCONST(4599) = (j('n_c3h7cho_hco'))
  RCONST(4633) = (j('ch3o2h'))
  RCONST(4637) = (j('ch3o2h'))
  RCONST(4641) = (j('i_c3h7cho'))
  RCONST(4643) = (j('ch3o2h'))
  RCONST(4645) = (j('2_c4h9ono2'))
  RCONST(4649) = (j('ch3o2h'))
  RCONST(4678) = (j('ch3o2h'))
  RCONST(4683) = (j('ch3o2h'))
  RCONST(4687) = (j('ch3o2h'))
  RCONST(4692) = (j('ch3o2h'))
  RCONST(4704) = (j('n_c3h7cho_hco'))
  RCONST(4747) = (j('ch3o2h'))
  RCONST(4752) = (j('ch3o2h'))
  RCONST(4756) = (j('ch3o2h'))
  RCONST(4790) = (j('ch3o2h'))
  RCONST(4796) = (j('ch3o2h'))
  RCONST(4800) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(4802) = (j('2_c4h9ono2'))
  RCONST(4803) = (j('i_c3h7cho'))
  RCONST(4807) = (j('ch3cocho'))
  RCONST(4845) = (j('n_c3h7cho_hco'))
  RCONST(4847) = (j('mek'))
  RCONST(4857) = (j('ch3o2h'))
  RCONST(4861) = (j('ch3o2h'))
  RCONST(4872) = (j('ch3o2h'))
  RCONST(4877) = (j('ch3cocho'))
  RCONST(4941) = (j('n_c3h7ono2'))
  RCONST(4942) = (j('ch3cocho'))
  RCONST(4953) = (j('ch3cocho'))
  RCONST(4958) = (j('ch3coch2ono2')*10)
  RCONST(5421) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5423) = (j('ch3o2h')+j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5441) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(5443) = (j('i_c3h7cho'))
  RCONST(5447) = (j('n_c3h7cho_hco')*2+j('mek'))
  RCONST(5449) = (j('n_c3h7cho_hco')*2)
  RCONST(5451) = (j('ch3o2h'))
  RCONST(5452) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5455) = (j('ch3cocho')+j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5457) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5467) = (j('1_c4h9ono2'))
  RCONST(5468) = (j('ch3o2h'))
  RCONST(5471) = (j('1_c4h9ono2'))
  RCONST(5476) = (j('ch3o2h'))
  RCONST(5481) = (j('ch3o2h'))
  RCONST(5486) = (j('1_c4h9ono2'))
  RCONST(5487) = (j('ch3o2h'))
  RCONST(5490) = (j('1_c4h9ono2'))
  RCONST(5507) = (j('no2')*0.2*0.3)
  RCONST(5508) = (j('no2')*0.2*0.3)
  RCONST(5509) = (j('no2')*0.2*0.4)
  RCONST(5515) = (j('no2')*0.2*0.6)
  RCONST(5516) = (j('no2')*0.2*0.4)
  RCONST(5529) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5531) = (j('ch3o2h')+j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5541) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(5543) = (j('i_c3h7cho')+j('mek'))
  RCONST(5547) = (j('i_c3h7cho')+j('biacet'))
  RCONST(5549) = (j('i_c3h7cho')+j('mek'))
  RCONST(5551) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5552) = (j('ch3o2h'))
  RCONST(5555) = (j('ch3cocho')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5557) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5567) = (j('mek'))
  RCONST(5573) = (j('no2')*0.2*0.6)
  RCONST(5574) = (j('no2')*0.2*0.4)
  RCONST(5579) = (j('ch2cch3cho_h')+j('ch2cch3cho_hco'))
  RCONST(5581) = (j('ch3o2h')+j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5597) = (j('ch3o2h')+j('i_c3h7cho')*2)
  RCONST(5599) = (j('i_c3h7cho')*2)
  RCONST(5603) = (j('i_c3h7cho')+j('ch3cocho'))
  RCONST(5605) = (j('i_c3h7cho')*2)
  RCONST(5607) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5608) = (j('mek'))
  RCONST(5609) = (j('ch3o2h'))
  RCONST(5612) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(5613) = (j('mek'))
  RCONST(5615) = (j('ch3o2h'))
  RCONST(5616) = (j('1_c4h9ono2'))
  RCONST(5619) = (j('1_c4h9ono2'))
  RCONST(5627) = (j('ch3o2h'))
  RCONST(5651) = (j('no2')*0.2*0.6)
  RCONST(5652) = (j('no2')*0.2*0.4)
  RCONST(5666) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5668) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5685) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(5687) = (j('i_c3h7cho')+j('mek'))
  RCONST(5691) = (j('i_c3h7cho')+j('biacet'))
  RCONST(5693) = (j('i_c3h7cho')+j('mek'))
  RCONST(5695) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5698) = (j('biacet')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5700) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5708) = (j('ch3o2h'))
  RCONST(5713) = (j('1_c4h9ono2'))
  RCONST(5714) = (j('ch3o2h'))
  RCONST(5717) = (j('1_c4h9ono2'))
  RCONST(5735) = (j('no2')*0.0057)
  RCONST(5737) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5739) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5743) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(5745) = (j('i_c3h7cho')+j('mek'))
  RCONST(5749) = (j('i_c3h7cho')+j('biacet'))
  RCONST(5751) = (j('i_c3h7cho')+j('mek'))
  RCONST(5753) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5754) = (j('ch3o2h'))
  RCONST(5755) = (j('i_c3h7cho'))
  RCONST(5758) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5759) = (j('i_c3h7cho'))
  RCONST(5761) = (j('ch3o2h'))
  RCONST(5762) = (j('1_c4h9ono2'))
  RCONST(5765) = (j('1_c4h9ono2'))
  RCONST(5773) = (j('ch3o2h'))
  RCONST(5795) = (j('ch3o2h'))
  RCONST(5800) = (j('1_c4h9ono2'))
  RCONST(5801) = (j('ch3o2h'))
  RCONST(5804) = (j('1_c4h9ono2'))
  RCONST(5813) = (j('no2')*0.2*0.6)
  RCONST(5814) = (j('no2')*0.2*0.4)
  RCONST(5827) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5829) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5839) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(5841) = (j('i_c3h7cho')+j('mek'))
  RCONST(5845) = (j('i_c3h7cho')+j('biacet'))
  RCONST(5847) = (j('i_c3h7cho')+j('mek'))
  RCONST(5849) = (j('i_c3h7cho')+j('mvk_mcm_co'))
  RCONST(5850) = (j('ch3o2h')+j('mvk_mcm_ch2ch'))
  RCONST(5853) = (j('i_c3h7cho')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5855) = (j('ch3cocho'))
  RCONST(5863) = (j('ch3o2h'))
  RCONST(5864) = (j('1_c4h9ono2'))
  RCONST(5867) = (j('1_c4h9ono2'))
  RCONST(5875) = (j('ch3o2h'))
  RCONST(5884) = (j('ch3cocho'))
  RCONST(5890) = (j('no2')*0.2*0.6)
  RCONST(5891) = (j('no2')*0.2*0.4)
  RCONST(5904) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5906) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5916) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(5918) = (j('i_c3h7cho')+j('mek'))
  RCONST(5922) = (j('i_c3h7cho')+j('biacet'))
  RCONST(5924) = (j('i_c3h7cho')+j('mek'))
  RCONST(5926) = (j('i_c3h7cho')+j('mvk_mcm_co'))
  RCONST(5927) = (j('ch3o2h')+j('mvk_mcm_ch2ch'))
  RCONST(5930) = (j('i_c3h7cho')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5932) = (j('ch3cocho'))
  RCONST(5934) = (j('mek'))
  RCONST(5942) = (j('ch3o2h'))
  RCONST(5947) = (j('1_c4h9ono2'))
  RCONST(5948) = (j('ch3o2h'))
  RCONST(5951) = (j('1_c4h9ono2'))
  RCONST(5960) = (j('no2')*0.2*0.6)
  RCONST(5961) = (j('no2')*0.2*0.4)
  RCONST(5962) = (j('no2')*0.05*0.34)
  RCONST(5975) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5977) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(5987) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(5989) = (j('i_c3h7cho')+j('mek'))
  RCONST(5993) = (j('i_c3h7cho')+j('biacet'))
  RCONST(5995) = (j('i_c3h7cho')+j('mek'))
  RCONST(5997) = (j('ch3o2h')+j('mvk_mcm_ch2ch'))
  RCONST(5998) = (j('i_c3h7cho')+j('mvk_mcm_co'))
  RCONST(6001) = (j('i_c3h7cho')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6003) = (j('ch3cocho'))
  RCONST(6013) = (j('ch3o2h'))
  RCONST(6014) = (j('1_c4h9ono2'))
  RCONST(6017) = (j('1_c4h9ono2'))
  RCONST(6025) = (j('ch3o2h'))
  RCONST(6034) = (j('no2')*0.2*0.6)
  RCONST(6035) = (j('no2')*0.2*0.4)
  RCONST(6055) = (j('ch3o2h')+j('mek')*2)
  RCONST(6059) = (j('mek')*2)
  RCONST(6061) = (j('mek'))
  RCONST(6062) = (j('mek')*2)
  RCONST(6064) = (j('mek')*2)
  RCONST(6080) = (j('no2')*0.0057*0.5)
  RCONST(6081) = (j('no2')*0.0057*0.5)
  RCONST(6083) = (j('ch3o2h'))
  RCONST(6084) = (j('1_c4h9ono2'))
  RCONST(6087) = (j('1_c4h9ono2'))
  RCONST(6095) = (j('ch3o2h'))
  RCONST(6103) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6105) = (j('ch3o2h'))
  RCONST(6106) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6110) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(6114) = (j('i_c3h7cho')+j('mek'))
  RCONST(6116) = (j('i_c3h7cho')+j('mek')*2)
  RCONST(6118) = (j('i_c3h7cho')+j('mek'))
  RCONST(6120) = (j('mvk_mcm_ch2ch'))
  RCONST(6121) = (j('ch3o2h'))
  RCONST(6122) = (j('mek'))
  RCONST(6125) = (j('mvk_mcm_ch2ch'))
  RCONST(6126) = (j('mek'))
  RCONST(6147) = (j('ch3o2h'))
  RCONST(6148) = (j('1_c4h9ono2'))
  RCONST(6151) = (j('1_c4h9ono2'))
  RCONST(6153) = (j('ch3o2h'))
  RCONST(6157) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6159) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6175) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(6179) = (j('i_c3h7cho')+j('mek'))
  RCONST(6181) = (j('i_c3h7cho')+j('mek'))
  RCONST(6183) = (j('mek'))
  RCONST(6184) = (j('ch3o2h'))
  RCONST(6185) = (j('mvk_mcm_co'))
  RCONST(6188) = (j('mvk_mcm_co')+j('mek'))
  RCONST(6190) = (j('mvk_mcm_co'))
  RCONST(6191) = (j('biacet'))
  RCONST(6199) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(6201) = (j('ch3o2h')+j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(6217) = (j('ch3o2h')+j('i_c3h7cho')*2)
  RCONST(6219) = (j('i_c3h7cho')*2)
  RCONST(6223) = (j('i_c3h7cho')+j('ch3cocho'))
  RCONST(6225) = (j('i_c3h7cho')*2)
  RCONST(6227) = (j('mek'))
  RCONST(6228) = (j('ch3o2h')+j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(6231) = (j('mek'))
  RCONST(6232) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(6234) = (j('ch3o2h'))
  RCONST(6235) = (j('1_c4h9ono2'))
  RCONST(6238) = (j('1_c4h9ono2'))
  RCONST(6246) = (j('ch3o2h'))
  RCONST(6254) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6256) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6260) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(6262) = (j('i_c3h7cho')+j('mek'))
  RCONST(6266) = (j('i_c3h7cho')+j('biacet'))
  RCONST(6268) = (j('i_c3h7cho')+j('mek'))
  RCONST(6270) = (j('mek'))
  RCONST(6271) = (j('ch3o2h')+j('mvk_mcm_co')*2)
  RCONST(6274) = (j('ch3cocho'))
  RCONST(6275) = (j('mvk_mcm_co')*2)
  RCONST(6277) = (j('mek'))
  RCONST(6278) = (j('mvk_mcm_co')*2)
  RCONST(6286) = (j('ch3o2h'))
  RCONST(6291) = (j('1_c4h9ono2'))
  RCONST(6292) = (j('ch3o2h'))
  RCONST(6295) = (j('1_c4h9ono2'))
  RCONST(6302) = (j('no2')*0.0057*0.5)
  RCONST(6303) = (j('no2')*0.0057*0.5)
  RCONST(6305) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6307) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6311) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(6313) = (j('i_c3h7cho')+j('mek'))
  RCONST(6317) = (j('i_c3h7cho')+j('biacet'))
  RCONST(6319) = (j('i_c3h7cho')+j('mek'))
  RCONST(6321) = (j('mvk_mcm_co')*2)
  RCONST(6322) = (j('i_c3h7cho'))
  RCONST(6323) = (j('ch3o2h'))
  RCONST(6326) = (j('mvk_mcm_co')*2)
  RCONST(6327) = (j('i_c3h7cho'))
  RCONST(6329) = (j('ch3o2h'))
  RCONST(6330) = (j('1_c4h9ono2'))
  RCONST(6333) = (j('1_c4h9ono2'))
  RCONST(6341) = (j('ch3o2h'))
  RCONST(6359) = (j('no2')*0.2*0.6)
  RCONST(6360) = (j('no2')*0.2*0.4)
  RCONST(6365) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6367) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6371) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(6375) = (j('i_c3h7cho')+j('mek'))
  RCONST(6377) = (j('i_c3h7cho')+j('mek'))
  RCONST(6379) = (j('mek'))
  RCONST(6380) = (j('ch3o2h'))
  RCONST(6381) = (j('mvk_mcm_co'))
  RCONST(6384) = (j('mvk_mcm_co')+j('mek'))
  RCONST(6386) = (j('biacet')+j('mvk_mcm_co'))
  RCONST(6388) = (j('1_c4h9ono2'))
  RCONST(6389) = (j('ch3o2h'))
  RCONST(6392) = (j('1_c4h9ono2'))
  RCONST(6394) = (j('ch3o2h'))
  RCONST(6410) = (j('1_c4h9ono2'))
  RCONST(6411) = (j('ch3o2h'))
  RCONST(6414) = (j('1_c4h9ono2'))
  RCONST(6416) = (j('ch3o2h'))
  RCONST(6426) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6428) = (j('ch3o2h')+j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(6451) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(6455) = (j('i_c3h7cho')+j('mek'))
  RCONST(6457) = (j('i_c3h7cho')+j('mek'))
  RCONST(6459) = (j('mek'))
  RCONST(6460) = (j('ch3o2h')+j('mvk_mcm_co'))
  RCONST(6463) = (j('mvk_mcm_co')+j('mek'))
  RCONST(6465) = (j('biacet')+j('mvk_mcm_co'))
  RCONST(6561) = (j('ch3o2h'))
  RCONST(6563) = (j('ch3coch2ono2')*0.91)
  RCONST(6566) = (j('mek'))
  RCONST(6570) = (j('ch3coch2ono2')*1.6)
  RCONST(6571) = (j('ch3o2h'))
  RCONST(6574) = (j('biacet'))
  RCONST(6576) = (j('mvk_mcm_ch2ch'))
  RCONST(6577) = (j('ch3o2h'))
  RCONST(6583) = (j('ch3cocho'))
  RCONST(6584) = (j('ch3o2h'))
  RCONST(6591) = (j('n_c3h7ono2'))
  RCONST(6606) = (j('c5hpald')*0.5)
  RCONST(6607) = (j('c5hpald')*0.5)
  RCONST(6608) = (j('ch2cch3cho_hco'))
  RCONST(6609) = (j('ch2cch3cho_h'))
  RCONST(6619) = (j('ch3o2h'))
  RCONST(6622) = (j('2_c4h9ono2'))
  RCONST(6629) = (j('ch3o2h'))
  RCONST(6647) = (j('c5hpald')*0.5)
  RCONST(6648) = (j('c5hpald')*0.5)
  RCONST(6649) = (j('ch2cch3cho_hco'))
  RCONST(6650) = (j('ch2cch3cho_h'))
  RCONST(6658) = (j('ch3o2h'))
  RCONST(6662) = (j('1_c4h9ono2'))
  RCONST(6667) = (j('mvk_mcm_ch2ch'))
  RCONST(6690) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(6700) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(6702) = (j('ch3coch2ono2')*0.91)
  RCONST(6705) = (j('ch3o2h'))
  RCONST(6709) = (j('ch3o2h'))
  RCONST(6711) = (j('n_c3h7ono2'))
  RCONST(6714) = (j('ch3o2h')+j('mek'))
  RCONST(6716) = (j('ch3o2h')+j('mek'))
  RCONST(6718) = (j('mek'))
  RCONST(6722) = (j('mek')*2)
  RCONST(6725) = (j('ch3o2h'))
  RCONST(6727) = (j('n_c3h7ono2'))
  RCONST(6926) = (j('n_c3h7cho_hco'))
  RCONST(6940) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(6943) = (j('n_c3h7cho_hco'))
  RCONST(6945) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(6946) = (j('mek'))
  RCONST(6950) = (j('ch3cocho')+j('n_c3h7cho_hco'))
  RCONST(6952) = (j('mek'))
  RCONST(6953) = (j('n_c3h7cho_hco'))
  RCONST(6955) = (j('mek'))
  RCONST(6958) = (j('ch3o2h')+j('mek'))
  RCONST(6960) = (j('n_c3h7ono2')+j('mek'))
  RCONST(6963) = (j('mek'))
  RCONST(6966) = (j('n_c3h7cho_hco'))
  RCONST(6982) = (j('ch3o2h'))
  RCONST(6984) = (j('1_c4h9ono2'))
  RCONST(6990) = (j('ch3o2h'))
  RCONST(6992) = (j('1_c4h9ono2'))
  RCONST(6997) = (j('ch3o2h'))
  RCONST(6999) = (j('2_c4h9ono2'))
  RCONST(7003) = (j('ch3o2h'))
  RCONST(7026) = (j('n_c3h7cho_hco'))
  RCONST(7028) = (j('mek'))
  RCONST(7029) = (j('ch3o2h'))
  RCONST(7032) = (j('biacet'))
  RCONST(7034) = (j('mek'))
  RCONST(7036) = (j('mek'))
  RCONST(7037) = (j('ch3o2h'))
  RCONST(7040) = (j('ch3cocho'))
  RCONST(7042) = (j('mek'))
  RCONST(7044) = (j('ch3o2h'))
  RCONST(7046) = (j('n_c3h7ono2'))
  RCONST(7051) = (j('n_c3h7cho_hco'))
  RCONST(7087) = (j('n_c3h7cho_hco'))
  RCONST(7116) = (j('ch3o2h'))
  RCONST(7117) = (j('mek'))
  RCONST(7120) = (j('biacet'))
  RCONST(7122) = (j('mek'))
  RCONST(7124) = (j('ch3o2h'))
  RCONST(7125) = (j('mek'))
  RCONST(7128) = (j('ch3cocho'))
  RCONST(7130) = (j('mek'))
  RCONST(7141) = (j('ch3o2h'))
  RCONST(7143) = (j('n_c3h7ono2'))
  RCONST(7151) = (j('n_c3h7cho_hco')*2)
  RCONST(7154) = (j('ch3o2h'))
  RCONST(7155) = (j('n_c3h7cho_hco'))
  RCONST(7158) = (j('ch3cocho'))
  RCONST(7160) = (j('n_c3h7cho_hco'))
  RCONST(7162) = (j('ch3o2h'))
  RCONST(7164) = (j('n_c3h7ono2'))
  RCONST(7167) = (j('n_c3h7cho_hco'))
  RCONST(7177) = (j('ch3o2h'))
  RCONST(7182) = (j('ch3o2h'))
  RCONST(7186) = (j('ch3o2h'))
  RCONST(7188) = (j('n_c3h7ono2'))
  RCONST(7192) = (j('mek'))
  RCONST(7194) = (j('ch3o2h'))
  RCONST(7198) = (j('ch3o2h'))
  RCONST(7204) = (j('i_c3h7cho'))
  RCONST(7207) = (j('ch3o2h'))
  RCONST(7212) = (j('ch3o2h'))
  RCONST(7215) = (j('ch3o2h'))
  RCONST(7220) = (j('n_c3h7cho_hco'))
  RCONST(7225) = (j('ch3o2h'))
  RCONST(7250) = (j('ch3o2h')+j('biacet'))
  RCONST(7253) = (j('ch3o2h'))
  RCONST(7257) = (j('ch3o2h'))
  RCONST(7261) = (j('ch3o2h')+j('mek'))
  RCONST(7265) = (j('ch3o2h'))
  RCONST(7270) = (j('i_c3h7cho'))
  RCONST(7272) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(7276) = (j('n_c3h7cho_hco'))
  RCONST(7277) = (j('ch3o2h'))
  RCONST(7278) = (j('mek'))
  RCONST(7280) = (j('ch3o2h')+j('mek'))
  RCONST(7284) = (j('ch3o2h'))
  RCONST(7287) = (j('n_c3h7ono2'))
  RCONST(7290) = (j('n_c3h7cho_hco'))
  RCONST(7297) = (j('ch3o2h'))
  RCONST(7301) = (j('ch3o2h'))
  RCONST(7304) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(7318) = (j('ch3o2h'))
  RCONST(7325) = (j('ch3o2h'))
  RCONST(7329) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(7332) = (j('mek'))
  RCONST(7333) = (j('ch3o2h'))
  RCONST(7337) = (j('ch3o2h'))
  RCONST(7339) = (j('n_c3h7ono2'))
  RCONST(7342) = (j('mek'))
  RCONST(7346) = (j('ch3o2h'))
  RCONST(7349) = (j('1_c4h9ono2'))
  RCONST(7352) = (j('n_c3h7cho_hco'))
  RCONST(7355) = (j('ch3o2h'))
  RCONST(7358) = (j('n_c3h7ono2'))
  RCONST(7363) = (j('n_c3h7cho_hco'))
  RCONST(7367) = (j('ch3o2h'))
  RCONST(7370) = (j('ch3o2h'))
  RCONST(7372) = (j('1_c4h9ono2'))
  RCONST(7376) = (j('mek')*0.5)
  RCONST(7377) = (j('mek')*0.5)
  RCONST(7380) = (j('ch3o2h'))
  RCONST(7384) = (j('ch3o2h'))
  RCONST(7386) = (j('1_c4h9ono2'))
  RCONST(7390) = (j('ch3o2h'))
  RCONST(7393) = (j('1_c4h9ono2'))
  RCONST(7396) = (j('n_c3h7cho_hco'))
  RCONST(7400) = (j('ch3o2h'))
  RCONST(7402) = (j('1_c4h9ono2'))
  RCONST(7405) = (j('mek'))
  RCONST(7409) = (j('ch3o2h'))
  RCONST(7413) = (j('ch3o2h'))
  RCONST(7416) = (j('n_c3h7ono2'))
  RCONST(7419) = (j('i_c3h7cho'))
  RCONST(7423) = (j('mek'))
  RCONST(7424) = (j('ch3o2h'))
  RCONST(7427) = (j('mek'))
  RCONST(7429) = (j('ch3o2h')+j('mek'))
  RCONST(7431) = (j('n_c3h7ono2')+j('mek'))
  RCONST(7434) = (j('i_c3h7cho'))
  RCONST(7437) = (j('mek'))
  RCONST(7439) = (j('ch3o2h'))
  RCONST(7442) = (j('n_c3h7ono2'))
  RCONST(7445) = (j('n_c3h7cho_hco'))
  RCONST(7450) = (j('ch3o2h'))
  RCONST(7452) = (j('1_c4h9ono2'))
  RCONST(7455) = (j('mek'))
  RCONST(7459) = (j('ch3o2h'))
  RCONST(7463) = (j('ch3o2h'))
  RCONST(7466) = (j('1_c4h9ono2'))
  RCONST(7469) = (j('n_c3h7cho_hco'))
  RCONST(7473) = (j('ch3o2h')+j('mek'))
  RCONST(7475) = (j('1_c4h9ono2')+j('mek'))
  RCONST(7479) = (j('mek'))
  RCONST(7482) = (j('ch3o2h')+j('mek'))
  RCONST(7485) = (j('mek'))
  RCONST(7487) = (j('ch3o2h'))
  RCONST(7490) = (j('n_c3h7ono2'))
  RCONST(7493) = (j('i_c3h7cho'))
  RCONST(7498) = (j('ch3o2h'))
  RCONST(7502) = (j('ch3o2h'))
  RCONST(7505) = (j('n_c3h7ono2'))
  RCONST(7508) = (j('n_c3h7cho_hco'))
  RCONST(7512) = (j('ch3o2h'))
  RCONST(7516) = (j('ch3o2h'))
  RCONST(7519) = (j('n_c3h7ono2'))
  RCONST(7523) = (j('i_c3h7cho'))
  RCONST(7527) = (j('ch3o2h'))
  RCONST(7531) = (j('ch3o2h'))
  RCONST(7533) = (j('1_c4h9ono2'))
  RCONST(7537) = (j('mek'))
  RCONST(7539) = (j('ch3o2h')+j('mek'))
  RCONST(7542) = (j('ch3o2h'))
  RCONST(7544) = (j('2_c4h9ono2'))
  RCONST(7548) = (j('ch3o2h')+j('mek'))
  RCONST(7551) = (j('ch3o2h'))
  RCONST(7553) = (j('1_c4h9ono2'))
  RCONST(7557) = (j('mek'))
  RCONST(7560) = (j('ch3o2h'))
  RCONST(7562) = (j('1_c4h9ono2'))
  RCONST(7568) = (j('mek'))
  RCONST(7569) = (j('ch3o2h')+j('mek'))
  RCONST(7574) = (j('n_c3h7ono2'))
  RCONST(7578) = (j('n_c3h7cho_hco'))
  RCONST(7581) = (j('ch3o2h'))
  RCONST(7583) = (j('1_c4h9ono2'))
  RCONST(7587) = (j('mek'))
  RCONST(7590) = (j('ch3o2h')+j('mek'))
  RCONST(7593) = (j('ch3o2h'))
  RCONST(7595) = (j('1_c4h9ono2'))
  RCONST(7599) = (j('mek'))
  RCONST(7602) = (j('ch3o2h')+j('mek'))
  RCONST(7605) = (j('ch3o2h'))
  RCONST(7607) = (j('1_c4h9ono2'))
  RCONST(7611) = (j('mek'))
  RCONST(7614) = (j('ch3o2h')+j('mek'))
  RCONST(7617) = (j('ch3o2h'))
  RCONST(7619) = (j('1_c4h9ono2'))
  RCONST(7623) = (j('mek'))
  RCONST(7626) = (j('ch3o2h')+j('mek'))
  RCONST(7629) = (j('ch3o2h'))
  RCONST(7631) = (j('1_c4h9ono2'))
  RCONST(7635) = (j('mek'))
  RCONST(7638) = (j('ch3o2h')+j('mek'))
  RCONST(7642) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(7644) = (j('n_c3h7cho_hco')+j('n_c3h7ono2'))
  RCONST(7649) = (j('ch3o2h'))
  RCONST(7654) = (j('ch3o2h'))
  RCONST(7658) = (j('ch3o2h')+j('n_c3h7ono2'))
  RCONST(7661) = (j('biacet'))
  RCONST(7663) = (j('ch3coch2ono2'))
  RCONST(7665) = (j('ch3o2h'))
  RCONST(7670) = (j('ch3o2h'))
  RCONST(7674) = (j('ch3o2h')+j('ch3coch2ono2'))
  RCONST(7677) = (j('ch3coch2ono2'))
  RCONST(7678) = (j('mek'))
  RCONST(7680) = (j('ch3coch2ono2'))
  RCONST(7683) = (j('ch3o2h'))
  RCONST(7687) = (j('ch3o2h'))
  RCONST(7688) = (j('mek'))
  RCONST(7691) = (j('ch3o2h'))
  RCONST(7695) = (j('ch3o2h')+j('ch3coch2ono2')*1.6)
  RCONST(7698) = (j('ch3o2h')+j('mek'))
  RCONST(7703) = (j('ch3o2h'))
  RCONST(7707) = (j('ch3o2h'))
  RCONST(7710) = (j('ch3o2h')+j('1_c4h9ono2'))
  RCONST(7714) = (j('ch3o2h'))
  RCONST(7719) = (j('ch3o2h'))
  RCONST(7724) = (j('ch3o2h'))
  RCONST(7728) = (j('ch3o2h')+j('ch3coch2ono2'))
  RCONST(7731) = (j('mek'))
  RCONST(7732) = (j('ch3coch2ono2'))
  RCONST(7734) = (j('ch3coch2ono2'))
  RCONST(7736) = (j('ch3o2h')+j('mek'))
  RCONST(7739) = (j('mek'))
  RCONST(7740) = (j('mek')*2)
  RCONST(7742) = (j('ch3o2h'))
  RCONST(7747) = (j('ch3o2h')+j('ch3coch2ono2')*1.6)
  RCONST(7750) = (j('ch3coch2ono2')*1.6+j('mek'))
  RCONST(7752) = (j('ch3coch2ono2')*1.6)
  RCONST(7755) = (j('ch3o2h')+j('ch3coch2ono2')*1.6)
  RCONST(7759) = (j('ch3coch2ono2')*1.6)
  RCONST(7761) = (j('mek'))
  RCONST(7775) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(7777) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(7778) = (j('ch3o2h'))
  RCONST(7784) = (j('i_c3h7cho'))
  RCONST(7786) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(7790) = (j('ch3o2h'))
  RCONST(7791) = (j('n_c3h7cho_hco')*2)
  RCONST(7794) = (j('n_c3h7cho_hco')*2)
  RCONST(7797) = (j('n_c3h7cho_hco')*2)
  RCONST(7798) = (j('ch3o2h'))
  RCONST(7801) = (j('ch3cocho')+j('n_c3h7cho_hco'))
  RCONST(7803) = (j('n_c3h7cho_hco')*2)
  RCONST(7815) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(7821) = (j('ch3o2h'))
  RCONST(7829) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(7865) = (j('ch3o2h'))
  RCONST(7868) = (j('ch3cocho'))
  RCONST(7872) = (j('ch3o2h'))
  RCONST(7908) = (j('i_c3h7cho'))
  RCONST(7910) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(7914) = (j('i_c3h7cho'))
  RCONST(7915) = (j('ch3o2h'))
  RCONST(7916) = (j('mek'))
  RCONST(7920) = (j('i_c3h7cho'))
  RCONST(7921) = (j('mek'))
  RCONST(7923) = (j('mvk_mcm_ch2ch'))
  RCONST(7927) = (j('ch3o2h'))
  RCONST(7938) = (j('ch3o2h'))
  RCONST(7942) = (j('ch3o2h'))
  RCONST(7980) = (j('ch3o2h'))
  RCONST(7981) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(7985) = (j('i_c3h7cho'))
  RCONST(7987) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(7991) = (j('ch3o2h'))
  RCONST(7992) = (j('i_c3h7cho')*2)
  RCONST(7997) = (j('ch3o2h'))
  RCONST(8007) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(8010) = (j('ch3o2h'))
  RCONST(8014) = (j('ch3o2h'))
  RCONST(8025) = (j('ch3o2h'))
  RCONST(8036) = (j('ch3o2h'))
  RCONST(8042) = (j('ch3o2h'))
  RCONST(8044) = (j('mvk_mcm_ch2ch'))
  RCONST(8054) = (j('mvk_mcm_ch2ch'))
  RCONST(8080) = (j('ch3o2h'))
  RCONST(8081) = (j('mvk_mcm_ch2ch'))
  RCONST(8085) = (j('ch3cocho'))
  RCONST(8087) = (j('mek'))
  RCONST(8088) = (j('i_c3h7cho'))
  RCONST(8094) = (j('ch3o2h'))
  RCONST(8097) = (j('biacet'))
  RCONST(8100) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(8104) = (j('ch3o2h'))
  RCONST(8114) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(8144) = (j('ch3o2h'))
  RCONST(8145) = (j('mvk_mcm_ch2ch'))
  RCONST(8149) = (j('mek'))
  RCONST(8151) = (j('mek'))
  RCONST(8152) = (j('i_c3h7cho'))
  RCONST(8166) = (j('ch3o2h'))
  RCONST(8168) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(8178) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(8204) = (j('ch3o2h'))
  RCONST(8205) = (j('mvk_mcm_ch2ch'))
  RCONST(8209) = (j('mek'))
  RCONST(8211) = (j('mek'))
  RCONST(8212) = (j('i_c3h7cho'))
  RCONST(8219) = (j('ch3o2h'))
  RCONST(8223) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(8227) = (j('ch3o2h'))
  RCONST(8252) = (j('mek')+j('ch3cocho'))
  RCONST(8273) = (j('mek'))
  RCONST(8275) = (j('ch3o2h')+j('mek'))
  RCONST(8279) = (j('ch3o2h'))
  RCONST(8280) = (j('mek'))
  RCONST(8281) = (j('i_c3h7cho'))
  RCONST(8284) = (j('ch3o2h'))
  RCONST(8288) = (j('ch3o2h'))
  RCONST(8298) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(8302) = (j('ch3o2h'))
  RCONST(8312) = (j('mvk_mcm_ch2ch'))
  RCONST(8315) = (j('ch3o2h'))
  RCONST(8319) = (j('ch3o2h'))
  RCONST(8324) = (j('ch3o2h'))
  RCONST(8325) = (j('mvk_mcm_ch2ch'))
  RCONST(8329) = (j('mek'))
  RCONST(8331) = (j('ch3o2h')+j('mek'))
  RCONST(8335) = (j('ch3o2h'))
  RCONST(8336) = (j('mek'))
  RCONST(8339) = (j('mek')*2)
  RCONST(8341) = (j('biacet'))
  RCONST(8343) = (j('ch3o2h'))
  RCONST(8344) = (j('mek'))
  RCONST(8347) = (j('mek'))
  RCONST(8349) = (j('ch3cocho'))
  RCONST(8351) = (j('i_c3h7cho'))
  RCONST(8353) = (j('ch3o2h')+j('i_c3h7cho'))
  RCONST(8357) = (j('ch3o2h'))
  RCONST(8358) = (j('mek'))
  RCONST(8359) = (j('i_c3h7cho'))
  RCONST(8363) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(8367) = (j('ch3o2h'))
  RCONST(8376) = (j('ch3cocho'))
  RCONST(8377) = (j('biacet'))
  RCONST(8383) = (j('ch3o2h'))
  RCONST(8401) = (j('ch3o2h'))
  RCONST(8411) = (j('ch3o2h'))
  RCONST(8412) = (j('mek'))
  RCONST(8415) = (j('mek'))
  RCONST(8417) = (j('ch3cocho'))
  RCONST(8447) = (j('mek'))
  RCONST(8448) = (j('mek'))
  RCONST(8450) = (j('mek'))
  RCONST(8451) = (j('ch3o2h'))
  RCONST(8454) = (j('mek'))
  RCONST(8456) = (j('ch3cocho'))
  RCONST(8458) = (j('ch3o2h'))
  RCONST(8467) = (j('mek'))
  RCONST(8468) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(8470) = (j('ch3o2h'))
  RCONST(8474) = (j('mek'))
  RCONST(8476) = (j('ch3o2h')+j('mek'))
  RCONST(8480) = (j('ch3o2h'))
  RCONST(8481) = (j('i_c3h7cho')*2)
  RCONST(8484) = (j('i_c3h7cho')*2)
  RCONST(8486) = (j('ch3o2h'))
  RCONST(8487) = (j('mek')*2)
  RCONST(8490) = (j('biacet')*2)
  RCONST(8491) = (j('ch3o2h'))
  RCONST(8492) = (j('mek'))
  RCONST(8495) = (j('biacet'))
  RCONST(8497) = (j('mek'))
  RCONST(8500) = (j('ch3o2h'))
  RCONST(8510) = (j('ch3o2h'))
  RCONST(8511) = (j('n_c3h7cho_hco'))
  RCONST(8514) = (j('n_c3h7cho_hco'))
  RCONST(8516) = (j('n_c3h7cho_hco'))
  RCONST(8520) = (j('ch3o2h'))
  RCONST(8530) = (j('ch3o2h'))
  RCONST(8534) = (j('n_c3h7cho_hco'))
  RCONST(8536) = (j('n_c3h7cho_hco'))
  RCONST(8546) = (j('ch3o2h')+j('mek'))
  RCONST(8550) = (j('mek'))
  RCONST(8552) = (j('mek'))
  RCONST(8553) = (j('ch3o2h'))
  RCONST(8556) = (j('biacet'))
  RCONST(8557) = (j('ch3o2h'))
  RCONST(8566) = (j('ch3o2h'))
  RCONST(8573) = (j('ch3coch2ono2')*0.91)
  RCONST(8577) = (j('ch3o2h'))
  RCONST(8586) = (j('ch3o2h'))
  RCONST(8591) = (j('ch3coch2ono2')*10)
  RCONST(8607) = (j('ch3o2h'))
  RCONST(8608) = (j('i_c3h7cho'))
  RCONST(8609) = (j('ch3o2h')*2)
  RCONST(8613) = (j('ch3o2h')+j('mek'))
  RCONST(8614) = (j('ch3o2h'))
  RCONST(8618) = (j('c5hpald')*2)
  RCONST(8621) = (j('ch3o2h'))
  RCONST(8622) = (j('i_c3h7cho')*2)
  RCONST(8624) = (j('mvk_mcm_co')+j('mvk_mcm_ch2ch'))
  RCONST(8671) = (j('ch3o2h'))
  RCONST(8672) = (j('i_c3h7cho'))
  RCONST(8673) = (j('ch3o2h')*2)
  RCONST(8677) = (j('ch3o2h'))
  RCONST(8678) = (j('n_c3h7cho_hco'))
  RCONST(8679) = (j('ch3o2h'))
  RCONST(8683) = (j('c5hpald')*2)
  RCONST(8690) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(8724) = (j('ch3o2h'))
  RCONST(8739) = (j('ch3o2h'))
  RCONST(8741) = (j('ch3coch2ono2')*0.91)
  RCONST(8746) = (j('ch3o2h'))
  RCONST(8750) = (j('ch3cocho'))
  RCONST(8763) = (j('ch3o2h'))
  RCONST(8765) = (j('n_c3h7ono2'))
  RCONST(8772) = (j('ch3o2h'))
  RCONST(8774) = (j('n_c3h7ono2'))
  RCONST(8778) = (j('n_c3h7cho_hco'))
  RCONST(8782) = (j('ch3o2h'))
  RCONST(8786) = (j('ch3cocho'))
  RCONST(8790) = (j('ch3o2h'))
  RCONST(8793) = (j('1_c4h9ono2'))
  RCONST(8805) = (j('ch3o2h'))
  RCONST(8807) = (j('n_c3h7ono2'))
  RCONST(8811) = (j('ch3o2h'))
  RCONST(8814) = (j('1_c4h9ono2'))
  RCONST(8817) = (j('ch3o2h'))
  RCONST(8820) = (j('1_c4h9ono2'))
  RCONST(8824) = (j('ch3o2h'))
  RCONST(8829) = (j('ch3o2h')+j('mek'))
  RCONST(8832) = (j('mek'))
  RCONST(8835) = (j('ch3cocho'))
  RCONST(8836) = (j('ch3o2h')+j('biacet'))
  RCONST(8842) = (j('ch3o2h')+j('mek'))
  RCONST(8845) = (j('mek'))
  RCONST(8847) = (j('ch3cocho'))
  RCONST(8849) = (j('ch3o2h')+j('biacet'))
  RCONST(8852) = (j('mek'))
  RCONST(8853) = (j('ch3o2h'))
  RCONST(8856) = (j('mek'))
  RCONST(8857) = (j('biacet'))
  RCONST(8859) = (j('ch3o2h'))
  RCONST(8860) = (j('mek'))
  RCONST(8864) = (j('mek'))
  RCONST(8866) = (j('ch3cocho'))
  RCONST(8868) = (j('mek'))
  RCONST(8870) = (j('mek'))
  RCONST(8871) = (j('ch3o2h'))
  RCONST(8876) = (j('ch3o2h')+j('mek'))
  RCONST(8880) = (j('mek'))
  RCONST(8881) = (j('mek')+j('ch3o2h'))
  RCONST(8883) = (j('mek')*2)
  RCONST(8884) = (j('ch3o2h'))
  RCONST(8887) = (j('mek'))
  RCONST(8888) = (j('biacet'))
  RCONST(8890) = (j('mek')*2)
  RCONST(8892) = (j('ch3o2h'))
  RCONST(8895) = (j('n_c3h7ono2'))
  RCONST(8899) = (j('ch3o2h')+j('mek'))
  RCONST(8901) = (j('1_c4h9ono2')+j('mek'))
  RCONST(8904) = (j('mek')*2)
  RCONST(8906) = (j('mek'))
  RCONST(8909) = (j('biacet')+j('ch3o2h'))
  RCONST(8914) = (j('ch3o2h')+j('mek'))
  RCONST(8917) = (j('biacet'))
  RCONST(8919) = (j('mek'))
  RCONST(8921) = (j('ch3o2h')+j('biacet'))
  RCONST(8925) = (j('mek'))
  RCONST(8926) = (j('ch3o2h'))
  RCONST(8929) = (j('biacet'))
  RCONST(8931) = (j('mek'))
  RCONST(8933) = (j('ch3o2h'))
  RCONST(8937) = (j('ch3o2h'))
  RCONST(8939) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(8941) = (j('ch3o2h')+j('mek'))
  RCONST(8945) = (j('mek'))
  RCONST(8947) = (j('ch3cocho'))
  RCONST(8950) = (j('ch3o2h'))
  RCONST(8955) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('mek'))
  RCONST(8959) = (j('n_c3h7cho_hco')*2)
  RCONST(8960) = (j('mek'))
  RCONST(8962) = (j('mek')+j('n_c3h7cho_hco'))
  RCONST(8965) = (j('ch3o2h'))
  RCONST(8969) = (j('mek'))
  RCONST(8971) = (j('mek')*3)
  RCONST(8979) = (j('ch3o2h'))
  RCONST(8982) = (j('ch3o2h')+j('mek'))
  RCONST(9033) = (j('ch3o2h'))
  RCONST(9035) = (j('1_c4h9ono2'))
  RCONST(9039) = (j('ch3o2h'))
  RCONST(9070) = (j('ch3o2h'))
  RCONST(9072) = (j('1_c4h9ono2'))
  RCONST(9077) = (j('ch3o2h'))
  RCONST(9089) = (j('n_c3h7cho_hco'))
  RCONST(9102) = (j('n_c3h7cho_hco')*2)
  RCONST(9140) = (j('ch3o2h'))
  RCONST(9166) = (j('ch3o2h'))
  RCONST(9170) = (j('ch3o2h'))
  RCONST(9218) = (j('ch3o2h'))
  RCONST(9223) = (j('ch3o2h'))
  RCONST(9239) = (j('ch3o2h'))
  RCONST(9271) = (j('ch3o2h'))
  RCONST(9288) = (j('n_c3h7cho_hco')*2)
  RCONST(9365) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(9370) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(9375) = (j('n_c3h7cho_hco'))
  RCONST(9377) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(9380) = (j('ch3o2h')+j('biacet'))
  RCONST(9395) = (j('ch3coch2ono2')*10)
  RCONST(9397) = (j('ch3coch2ono2')*10)
  RCONST(9399) = (KBPAN+j('ch3coch2ono2')*10)
  RCONST(9401) = (j('i_c3h7cho'))
  RCONST(9403) = (j('ch3o2h'))
  RCONST(9404) = (j('i_c3h7cho'))
  RCONST(9406) = (KBPAN+j('i_c3h7cho'))
  RCONST(9407) = (j('n_c3h7cho_hco'))
  RCONST(9418) = (j('i_c3h7cho'))
  RCONST(9434) = (j('n_c3h7cho_hco'))
  RCONST(9451) = (j('i_c3h7cho'))
  RCONST(9504) = (j('n_c3h7cho_hco'))
  RCONST(9563) = (j('mek'))
  RCONST(9566) = (j('mek'))
  RCONST(9567) = (j('mek'))
  RCONST(9591) = (j('mek'))
  RCONST(9594) = (j('mek'))
  RCONST(9595) = (j('mek'))
  RCONST(9624) = (j('mek')*2)
  RCONST(9637) = (j('mek')*2)
  RCONST(9654) = (j('mek')*2)
  RCONST(9671) = (j('mek')*2)
  RCONST(9688) = (j('mek')*2)
  RCONST(9708) = (j('ch3coch2ono2')*1.6)
  RCONST(9710) = (j('ch3coch2ono2')*10)
  RCONST(9712) = (j('ch3cocho'))
  RCONST(9713) = (j('mek'))
  RCONST(9714) = (j('ch3cocho'))
  RCONST(9717) = (j('ch3o2h'))
  RCONST(9727) = (j('ch3o2h'))
  RCONST(9733) = (j('ch3cocho')*2)
  RCONST(9749) = (j('ch3o2h'))
  RCONST(9785) = (j('ch3o2h'))
  RCONST(9789) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(9790) = (j('ch3o2h'))
  RCONST(9795) = (j('i_c3h7cho')*2)
  RCONST(9798) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('mek'))
  RCONST(9801) = (j('n_c3h7cho_hco')+j('biacet'))
  RCONST(9803) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(9805) = (j('ch3o2h'))
  RCONST(9818) = (j('ch3o2h'))
  RCONST(9822) = (j('mvk_mcm_ch2ch'))
  RCONST(9823) = (j('ch3o2h'))
  RCONST(9834) = (j('mek')+j('i_c3h7cho'))
  RCONST(9835) = (j('ch3o2h'))
  RCONST(9838) = (j('mek')+j('i_c3h7cho'))
  RCONST(9840) = (j('ch3o2h'))
  RCONST(9844) = (j('ch3o2h'))
  RCONST(9847) = (j('mek'))
  RCONST(9850) = (j('ch3o2h'))
  RCONST(9878) = (j('ch3o2h'))
  RCONST(9880) = (j('i_c3h7cho'))
  RCONST(9881) = (j('ch3o2h')+j('mek'))
  RCONST(9884) = (j('mek')+j('i_c3h7cho'))
  RCONST(9886) = (j('ch3o2h'))
  RCONST(9890) = (j('ch3o2h'))
  RCONST(9893) = (j('mek'))
  RCONST(9896) = (j('ch3o2h'))
  RCONST(9900) = (j('ch3o2h'))
  RCONST(9903) = (j('mek'))
  RCONST(9904) = (j('ch3o2h'))
  RCONST(9907) = (j('ch3o2h'))
  RCONST(9935) = (j('ch3o2h'))
  RCONST(9939) = (j('mek')*2)
  RCONST(9940) = (j('ch3o2h'))
  RCONST(9944) = (j('mek')*2)
  RCONST(9946) = (j('mek'))
  RCONST(9947) = (j('biacet'))
  RCONST(9972) = (j('ch3o2h'))
  RCONST(9998) = (j('ch3o2h'))
  RCONST(10000) = (j('mek'))
  RCONST(10001) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(10004) = (j('biacet'))
  RCONST(10006) = (j('mek'))
  RCONST(10007) = (j('n_c3h7cho_hco'))
  RCONST(10009) = (j('ch3o2h'))
  RCONST(10014) = (j('ch3o2h'))
  RCONST(10016) = (j('ch3o2h'))
  RCONST(10027) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(10058) = (j('ch3o2h'))
  RCONST(10060) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('mek'))
  RCONST(10064) = (j('mek'))
  RCONST(10065) = (j('biacet'))
  RCONST(10066) = (j('n_c3h7cho_hco'))
  RCONST(10068) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(10070) = (j('ch3o2h'))
  RCONST(10075) = (j('ch3o2h'))
  RCONST(10077) = (j('ch3o2h'))
  RCONST(10088) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(10091) = (j('ch3o2h'))
  RCONST(10096) = (j('ch3cocho'))
  RCONST(10122) = (j('ch3o2h'))
  RCONST(10124) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('mek'))
  RCONST(10128) = (j('n_c3h7cho_hco'))
  RCONST(10129) = (j('mek'))
  RCONST(10130) = (j('biacet'))
  RCONST(10132) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(10134) = (j('ch3o2h'))
  RCONST(10139) = (j('ch3o2h'))
  RCONST(10141) = (j('ch3o2h'))
  RCONST(10152) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(10171) = (j('ch3o2h'))
  RCONST(10173) = (j('mvk_mcm_ch2ch'))
  RCONST(10174) = (j('ch3o2h'))
  RCONST(10178) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('mek'))
  RCONST(10181) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(10183) = (j('ch3o2h'))
  RCONST(10186) = (j('ch3o2h'))
  RCONST(10190) = (j('ch3o2h'))
  RCONST(10193) = (j('ch3o2h'))
  RCONST(10197) = (j('ch3o2h'))
  RCONST(10202) = (j('mek')*2)
  RCONST(10203) = (j('ch3o2h'))
  RCONST(10207) = (j('mek')*2)
  RCONST(10232) = (j('ch3o2h'))
  RCONST(10263) = (j('ch3o2h'))
  RCONST(10288) = (j('ch3o2h'))
  RCONST(10290) = (j('ch3o2h')+j('mek')*2)
  RCONST(10294) = (j('mek'))
  RCONST(10295) = (j('mek')*2)
  RCONST(10297) = (j('mek')*2)
  RCONST(10322) = (j('ch3o2h'))
  RCONST(10326) = (j('ch3o2h'))
  RCONST(10327) = (j('mvk_mcm_ch2ch'))
  RCONST(10331) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('mek'))
  RCONST(10334) = (j('n_c3h7cho_hco')+j('mek'))
  RCONST(10336) = (j('ch3o2h'))
  RCONST(10340) = (j('ch3o2h'))
  RCONST(10343) = (j('mek'))
  RCONST(10346) = (j('ch3o2h'))
  RCONST(10350) = (j('ch3o2h'))
  RCONST(10356) = (j('ch3cocho'))
  RCONST(10366) = (j('ch3cocho'))
  RCONST(10368) = (j('ch3cocho')+j('biacet'))
  RCONST(10371) = (j('ch3coch2ono2')*10)
  RCONST(10373) = (j('ch3cocho'))
  RCONST(10381) = (j('i_c3h7cho'))
  RCONST(10386) = (j('i_c3h7cho'))
  RCONST(10387) = (j('ch3o2h')*2)
  RCONST(10389) = (j('ch3coch2ono2')*10)
  RCONST(10405) = (j('ch3o2h')+j('biacet'))
  RCONST(10412) = (j('ch3o2h'))
  RCONST(10417) = (j('ch3o2h'))
  RCONST(10419) = (j('ch3coch2ono2')*10)
  RCONST(10432) = (j('ch3o2h'))
  RCONST(10437) = (j('ch3coch2ono2')*1.6)
  RCONST(10442) = (j('ch3o2h'))
  RCONST(10444) = (j('n_c3h7cho_hco'))
  RCONST(10448) = (j('ch3o2h')*2)
  RCONST(10449) = (j('i_c3h7cho'))
  RCONST(10451) = (j('ch3coch2ono2')*10)
  RCONST(10459) = (j('n_c3h7cho_hco'))
  RCONST(10460) = (j('ch3o2h')*2)
  RCONST(10463) = (j('ch3o2h'))
  RCONST(10468) = (j('ch3o2h'))
  RCONST(10471) = (j('ch3coch2ono2')*0.91)
  RCONST(10472) = (j('ch3o2h'))
  RCONST(10476) = (j('ch3coch2ono2')*10)
  RCONST(10486) = (j('ch3o2h'))
  RCONST(10490) = (j('ch3o2h'))
  RCONST(10491) = (j('mek'))
  RCONST(10494) = (j('i_c3h7cho')+j('ch3o2h'))
  RCONST(10496) = (j('ch3coch2ono2')*10)
  RCONST(10498) = (j('ch3coch2ono2')*1.6)
  RCONST(10501) = (j('i_c3h7cho'))
  RCONST(10513) = (j('ch3o2h'))
  RCONST(10515) = (j('1_c4h9ono2'))
  RCONST(10518) = (j('mvk_mcm_ch2ch'))
  RCONST(10545) = (j('ch3o2h'))
  RCONST(10548) = (j('1_c4h9ono2'))
  RCONST(10552) = (j('n_c3h7cho_hco'))
  RCONST(10553) = (j('biacet'))
  RCONST(10609) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(10611) = (j('2_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(10614) = (j('mek'))
  RCONST(10620) = (j('ch3o2h')+j('biacet'))
  RCONST(10622) = (j('2_c4h9ono2')+j('biacet'))
  RCONST(10625) = (j('biacet'))
  RCONST(10629) = (j('n_c3h7cho_hco'))
  RCONST(10631) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(10635) = (j('ch3o2h')+j('mek'))
  RCONST(10637) = (j('mek'))
  RCONST(10641) = (j('ch3o2h')+j('mek'))
  RCONST(10644) = (j('ch3o2h')+j('mek'))
  RCONST(10647) = (j('mek'))
  RCONST(10649) = (j('ch3o2h')+j('mek'))
  RCONST(10653) = (j('ch3o2h')+j('mek'))
  RCONST(10656) = (j('ch3o2h'))
  RCONST(10661) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(10663) = (j('2_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(10666) = (j('n_c3h7cho_hco'))
  RCONST(10668) = (j('ch3o2h'))
  RCONST(10670) = (j('1_c4h9ono2'))
  RCONST(10675) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(10677) = (j('1_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(10682) = (j('n_c3h7cho_hco'))
  RCONST(10693) = (j('ch3o2h'))
  RCONST(10695) = (j('2_c4h9ono2'))
  RCONST(10705) = (j('ch3o2h'))
  RCONST(10729) = (j('ch3o2h'))
  RCONST(10740) = (j('n_c3h7cho_hco')*2)
  RCONST(10755) = (j('n_c3h7cho_hco'))
  RCONST(10757) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(10764) = (j('ch3o2h'))
  RCONST(10768) = (j('ch3o2h'))
  RCONST(10771) = (j('biacet'))
  RCONST(10774) = (j('ch3o2h'))
  RCONST(10778) = (j('ch3o2h'))
  RCONST(10781) = (j('mek')+j('ch3o2h'))
  RCONST(10785) = (j('ch3o2h'))
  RCONST(10807) = (j('ch3o2h'))
  RCONST(10812) = (j('ch3o2h'))
  RCONST(10816) = (j('ch3o2h'))
  RCONST(10819) = (j('biacet'))
  RCONST(10822) = (j('ch3o2h'))
  RCONST(10826) = (j('ch3o2h'))
  RCONST(10827) = (j('mek'))
  RCONST(10830) = (j('biacet'))
  RCONST(10832) = (j('mek'))
  RCONST(10834) = (j('ch3o2h'))
  RCONST(10835) = (j('mek'))
  RCONST(10838) = (j('ch3cocho'))
  RCONST(10840) = (j('mek'))
  RCONST(10842) = (j('ch3o2h'))
  RCONST(10843) = (j('n_c3h7cho_hco'))
  RCONST(10846) = (j('ch3cocho'))
  RCONST(10848) = (j('n_c3h7cho_hco'))
  RCONST(10850) = (j('ch3o2h'))
  RCONST(10852) = (j('n_c3h7ono2'))
  RCONST(10857) = (j('ch3o2h'))
  RCONST(10863) = (j('ch3o2h'))
  RCONST(10870) = (j('ch3o2h'))
  RCONST(10874) = (j('ch3o2h'))
  RCONST(10877) = (j('biacet'))
  RCONST(10880) = (j('ch3o2h'))
  RCONST(10882) = (j('2_c4h9ono2'))
  RCONST(10886) = (j('ch3o2h'))
  RCONST(10916) = (j('ch3o2h'))
  RCONST(10921) = (j('ch3o2h'))
  RCONST(10923) = (j('n_c3h7ono2'))
  RCONST(10928) = (j('ch3o2h'))
  RCONST(10930) = (j('ch3o2h'))
  RCONST(10932) = (j('2_c4h9ono2'))
  RCONST(10936) = (j('ch3o2h'))
  RCONST(10947) = (j('ch3o2h'))
  RCONST(10952) = (j('ch3o2h'))
  RCONST(10955) = (j('ch3o2h'))
  RCONST(10959) = (j('ch3o2h'))
  RCONST(10963) = (j('n_c3h7cho_hco')*2)
  RCONST(10987) = (j('ch3o2h'))
  RCONST(10992) = (j('ch3o2h'))
  RCONST(11013) = (j('ch3o2h'))
  RCONST(11025) = (j('ch3o2h'))
  RCONST(11029) = (j('ch3o2h')+j('mek'))
  RCONST(11031) = (j('mek'))
  RCONST(11034) = (j('mek'))
  RCONST(11045) = (j('ch3o2h'))
  RCONST(11049) = (j('ch3o2h')+j('mek'))
  RCONST(11052) = (j('mek'))
  RCONST(11067) = (j('ch3o2h'))
  RCONST(11069) = (j('1_c4h9ono2'))
  RCONST(11075) = (j('ch3o2h'))
  RCONST(11079) = (j('ch3o2h'))
  RCONST(11080) = (j('mek'))
  RCONST(11084) = (j('biacet'))
  RCONST(11086) = (j('mek'))
  RCONST(11088) = (j('ch3o2h')+j('mek'))
  RCONST(11093) = (j('ch3o2h'))
  RCONST(11097) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(11099) = (j('n_c3h7cho_hco'))
  RCONST(11102) = (j('n_c3h7cho_hco'))
  RCONST(11105) = (j('n_c3h7cho_hco'))
  RCONST(11107) = (j('ch3o2h')+j('mek'))
  RCONST(11109) = (j('mek'))
  RCONST(11112) = (j('mek'))
  RCONST(11114) = (j('mek')*2)
  RCONST(11125) = (j('ch3o2h'))
  RCONST(11129) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(11131) = (j('n_c3h7cho_hco'))
  RCONST(11134) = (j('n_c3h7cho_hco'))
  RCONST(11136) = (j('ch3o2h')+j('mek'))
  RCONST(11139) = (j('mek'))
  RCONST(11141) = (j('ch3cocho'))
  RCONST(11143) = (j('ch3o2h'))
  RCONST(11144) = (j('mek')*2.0)
  RCONST(11147) = (j('mek')*2.0)
  RCONST(11150) = (j('ch3o2h'))
  RCONST(11154) = (j('ch3o2h'))
  RCONST(11157) = (j('n_c3h7ono2'))
  RCONST(11161) = (j('i_c3h7cho'))
  RCONST(11165) = (j('ch3o2h'))
  RCONST(11170) = (j('ch3o2h'))
  RCONST(11193) = (j('ch3o2h'))
  RCONST(11194) = (j('mek'))
  RCONST(11197) = (j('ch3o2h')+j('mek'))
  RCONST(11200) = (j('ch3o2h')+j('mek'))
  RCONST(11202) = (j('1_c4h9ono2')+j('mek'))
  RCONST(11205) = (j('mek')*2)
  RCONST(11207) = (j('mek'))
  RCONST(11209) = (j('ch3o2h'))
  RCONST(11210) = (j('mek'))
  RCONST(11214) = (j('biacet'))
  RCONST(11216) = (j('mek'))
  RCONST(11235) = (j('ch3o2h')+j('mek'))
  RCONST(11238) = (j('ch3o2h'))
  RCONST(11241) = (j('n_c3h7ono2'))
  RCONST(11245) = (j('n_c3h7cho_hco'))
  RCONST(11249) = (j('ch3o2h'))
  RCONST(11253) = (j('ch3o2h')+j('mek'))
  RCONST(11255) = (j('mek'))
  RCONST(11258) = (j('mek'))
  RCONST(11260) = (j('mek')*2)
  RCONST(11268) = (j('ch3o2h')+j('mek'))
  RCONST(11271) = (j('ch3o2h')+j('mek'))
  RCONST(11273) = (j('mek'))
  RCONST(11276) = (j('mek')*2)
  RCONST(11278) = (j('mek'))
  RCONST(11286) = (j('ch3o2h')+j('mek'))
  RCONST(11289) = (j('ch3o2h'))
  RCONST(11292) = (j('ch3o2h')+j('mek'))
  RCONST(11294) = (j('mek'))
  RCONST(11297) = (j('mek')*2)
  RCONST(11299) = (j('mek'))
  RCONST(11307) = (j('ch3o2h')+j('mek'))
  RCONST(11310) = (j('ch3o2h'))
  RCONST(11313) = (j('ch3o2h')+j('mek'))
  RCONST(11315) = (j('mek'))
  RCONST(11318) = (j('mek')*2)
  RCONST(11320) = (j('mek'))
  RCONST(11328) = (j('ch3o2h')+j('mek'))
  RCONST(11331) = (j('ch3o2h'))
  RCONST(11334) = (j('ch3o2h')+j('mek'))
  RCONST(11336) = (j('mek'))
  RCONST(11339) = (j('mek')*2)
  RCONST(11341) = (j('mek'))
  RCONST(11357) = (j('ch3o2h')+j('mek'))
  RCONST(11361) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(11363) = (j('1_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(11367) = (j('ch3o2h')+j('ch3coch2ono2'))
  RCONST(11371) = (j('ch3cocho'))
  RCONST(11389) = (j('ch3o2h'))
  RCONST(11391) = (j('ch3o2h'))
  RCONST(11394) = (j('ch3o2h'))
  RCONST(11397) = (j('ch3o2h'))
  RCONST(11400) = (j('ch3o2h'))
  RCONST(11405) = (j('ch3o2h'))
  RCONST(11408) = (j('ch3o2h'))
  RCONST(11421) = (j('ch3o2h'))
  RCONST(11423) = (j('ch3o2h'))
  RCONST(11426) = (j('ch3o2h'))
  RCONST(11430) = (j('ch3cocho')+j('biacet')*2)
  RCONST(11433) = (j('n_c3h7cho_hco'))
  RCONST(11435) = (j('ch3o2h'))
  RCONST(11439) = (j('mek'))
  RCONST(11453) = (j('ch3o2h'))
  RCONST(11455) = (j('ch3o2h'))
  RCONST(11458) = (j('ch3o2h'))
  RCONST(11463) = (j('ch3o2h'))
  RCONST(11466) = (j('ch3o2h'))
  RCONST(11469) = (j('biacet'))
  RCONST(11472) = (j('n_c3h7cho_hco'))
  RCONST(11479) = (j('n_c3h7cho_hco'))
  RCONST(11494) = (j('ch3o2h'))
  RCONST(11496) = (j('ch3o2h'))
  RCONST(11499) = (j('ch3o2h'))
  RCONST(11503) = (j('ch3o2h'))
  RCONST(11506) = (j('ch3o2h'))
  RCONST(11522) = (j('ch3o2h'))
  RCONST(11524) = (j('ch3o2h'))
  RCONST(11527) = (j('ch3o2h'))
  RCONST(11531) = (j('ch3o2h'))
  RCONST(11534) = (j('ch3o2h'))
  RCONST(11545) = (j('ch3o2h'))
  RCONST(11547) = (j('ch3o2h'))
  RCONST(11550) = (j('ch3o2h'))
  RCONST(11555) = (j('ch3o2h'))
  RCONST(11558) = (j('ch3o2h'))
  RCONST(11561) = (j('biacet'))
  RCONST(11562) = (j('biacet')*2)
  RCONST(11565) = (j('ch3cocho'))
  RCONST(11568) = (j('mek'))
  RCONST(11569) = (j('ch3o2h'))
  RCONST(11573) = (j('ch3o2h'))
  RCONST(11584) = (j('ch3o2h'))
  RCONST(11586) = (j('ch3o2h'))
  RCONST(11589) = (j('ch3o2h'))
  RCONST(11594) = (j('ch3o2h'))
  RCONST(11597) = (j('ch3o2h'))
  RCONST(11607) = (j('biacet')+j('ch3cocho'))
  RCONST(11610) = (j('ch3cocho'))
  RCONST(11613) = (j('mek'))
  RCONST(11614) = (j('ch3o2h'))
  RCONST(11626) = (j('ch3o2h'))
  RCONST(11628) = (j('ch3o2h'))
  RCONST(11631) = (j('ch3o2h'))
  RCONST(11636) = (j('ch3o2h'))
  RCONST(11639) = (j('ch3o2h'))
  RCONST(11649) = (j('biacet')+j('ch3cocho'))
  RCONST(11652) = (j('ch3cocho'))
  RCONST(11655) = (j('mek'))
  RCONST(11656) = (j('ch3o2h'))
  RCONST(11670) = (j('ch3o2h'))
  RCONST(11672) = (j('ch3o2h'))
  RCONST(11675) = (j('ch3o2h'))
  RCONST(11678) = (j('mek'))
  RCONST(11692) = (j('ch3o2h'))
  RCONST(11694) = (j('ch3o2h'))
  RCONST(11697) = (j('ch3o2h'))
  RCONST(11701) = (j('ch3o2h'))
  RCONST(11704) = (j('ch3o2h'))
  RCONST(11711) = (j('ch3o2h')+j('biacet'))
  RCONST(11722) = (j('ch3o2h'))
  RCONST(11724) = (j('ch3o2h'))
  RCONST(11727) = (j('ch3o2h'))
  RCONST(11732) = (j('ch3o2h'))
  RCONST(11735) = (j('ch3o2h'))
  RCONST(11746) = (j('ch3o2h'))
  RCONST(11748) = (j('ch3o2h'))
  RCONST(11751) = (j('ch3o2h'))
  RCONST(11755) = (j('ch3o2h'))
  RCONST(11758) = (j('ch3o2h'))
  RCONST(11769) = (j('ch3o2h'))
  RCONST(11771) = (j('ch3o2h'))
  RCONST(11774) = (j('ch3o2h'))
  RCONST(11778) = (j('ch3o2h'))
  RCONST(11781) = (j('ch3o2h'))
  RCONST(11785) = (j('n_c3h7cho_hco'))
  RCONST(11792) = (j('ch3o2h')+j('biacet'))
  RCONST(11794) = (j('ch3o2h'))
  RCONST(11807) = (j('ch3o2h'))
  RCONST(11809) = (KBPAN+j('ch3coch2ono2')*10)
  RCONST(11816) = (j('i_c3h7cho'))
  RCONST(11817) = (j('mek'))
  RCONST(11835) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(11836) = (j('ch3o2h'))
  RCONST(11839) = (j('ch3coch2ono2')*10)
  RCONST(11840) = (j('ch3coch2ono2')*0.91)
  RCONST(11842) = (j('ch3coch2ono2')*10)
  RCONST(11844) = (j('ch3coch2ono2')*10)
  RCONST(11847) = (j('ch3cocho'))
  RCONST(11855) = (j('ch3o2h'))
  RCONST(11856) = (j('ch3o2h'))
  RCONST(11857) = (j('n_c3h7cho_hco'))
  RCONST(11873) = (j('ch3coch2ono2')*10)
  RCONST(11884) = (j('ch3coch2ono2')*0.91)
  RCONST(11911) = (j('ch3o2h'))
  RCONST(11945) = (j('ch3o2h'))
  RCONST(11950) = (j('ch3o2h'))
  RCONST(11952) = (j('n_c3h7ono2'))
  RCONST(11956) = (j('ch3o2h'))
  RCONST(11960) = (j('n_c3h7cho_hco'))
  RCONST(11967) = (j('ch3o2h')+j('mek'))
  RCONST(11968) = (j('biacet'))
  RCONST(11970) = (j('ch3o2h'))
  RCONST(11975) = (j('n_c3h7cho_hco'))
  RCONST(11986) = (j('ch3o2h'))
  RCONST(11991) = (j('mek')+j('n_c3h7cho_hco'))
  RCONST(11993) = (j('ch3o2h')+j('mek'))
  RCONST(11997) = (j('ch3o2h')+j('mek')+j('n_c3h7cho_hco'))
  RCONST(12000) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12002) = (j('n_c3h7cho_hco'))
  RCONST(12004) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12009) = (j('ch3o2h')+j('mek')*2+j('n_c3h7cho_hco'))
  RCONST(12012) = (j('ch3o2h')+j('mek'))
  RCONST(12016) = (j('biacet'))
  RCONST(12024) = (j('ch3o2h'))
  RCONST(12043) = (j('n_c3h7cho_hco')*2)
  RCONST(12061) = (j('n_c3h7cho_hco'))
  RCONST(12095) = (j('n_c3h7cho_hco'))
  RCONST(12097) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12114) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12116) = (j('2_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(12119) = (j('n_c3h7cho_hco'))
  RCONST(12121) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(12124) = (j('n_c3h7cho_hco')*2)
  RCONST(12126) = (j('mek')*2+j('ch3o2h'))
  RCONST(12128) = (j('mek')*2)
  RCONST(12132) = (j('mek')*2+j('ch3o2h'))
  RCONST(12134) = (j('mek')*2+j('n_c3h7ono2'))
  RCONST(12138) = (j('mek')*2)
  RCONST(12140) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(12143) = (j('n_c3h7cho_hco')*2)
  RCONST(12165) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(12169) = (j('n_c3h7cho_hco')*2)
  RCONST(12171) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12173) = (j('n_c3h7ono2'))
  RCONST(12181) = (j('n_c3h7cho_hco'))
  RCONST(12210) = (j('ch2cch3cho_hco')+j('ch2cch3cho_h'))
  RCONST(12212) = (j('mek'))
  RCONST(12213) = (j('ch3o2h'))
  RCONST(12216) = (j('biacet'))
  RCONST(12218) = (j('mek'))
  RCONST(12220) = (j('mek'))
  RCONST(12221) = (j('ch3o2h'))
  RCONST(12224) = (j('ch3cocho'))
  RCONST(12226) = (j('mek'))
  RCONST(12274) = (j('ch3o2h'))
  RCONST(12278) = (j('ch3o2h'))
  RCONST(12280) = (j('n_c3h7ono2'))
  RCONST(12285) = (j('ch3o2h'))
  RCONST(12288) = (j('biacet'))
  RCONST(12297) = (j('mek')*3)
  RCONST(12306) = (j('ch3o2h'))
  RCONST(12308) = (j('n_c3h7ono2'))
  RCONST(12313) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12317) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12320) = (j('i_c3h7cho'))
  RCONST(12321) = (j('ch3o2h'))
  RCONST(12324) = (j('ch3o2h')+j('n_c3h7cho_hco')+j('biacet'))
  RCONST(12327) = (j('ch3o2h')+j('mek'))
  RCONST(12332) = (j('ch3o2h'))
  RCONST(12336) = (j('mek'))
  RCONST(12338) = (j('ch3o2h')+j('mek'))
  RCONST(12342) = (j('ch3o2h'))
  RCONST(12343) = (j('i_c3h7cho'))
  RCONST(12346) = (j('ch3o2h'))
  RCONST(12357) = (j('biacet'))
  RCONST(12370) = (j('ch3cocho'))
  RCONST(12373) = (j('ch3o2h')+j('mek'))
  RCONST(12377) = (j('ch3o2h')+j('mek'))
  RCONST(12379) = (j('1_c4h9ono2')+j('mek'))
  RCONST(12382) = (j('mek'))
  RCONST(12384) = (j('mek')*2)
  RCONST(12386) = (j('mek')*2)
  RCONST(12387) = (j('ch3o2h'))
  RCONST(12390) = (j('biacet'))
  RCONST(12392) = (j('mek')*2)
  RCONST(12394) = (j('mek')*2)
  RCONST(12395) = (j('ch3o2h'))
  RCONST(12398) = (j('biacet'))
  RCONST(12400) = (j('mek')*2)
  RCONST(12412) = (j('ch3o2h'))
  RCONST(12413) = (j('mek'))
  RCONST(12415) = (j('mek'))
  RCONST(12418) = (j('mek'))
  RCONST(12420) = (j('ch3o2h'))
  RCONST(12421) = (j('mek')*2)
  RCONST(12424) = (j('mek')*2)
  RCONST(12426) = (j('ch3o2h'))
  RCONST(12427) = (j('mek')*2)
  RCONST(12431) = (j('mek')*2)
  RCONST(12433) = (j('biacet'))
  RCONST(12434) = (j('mek'))
  RCONST(12449) = (j('biacet')+j('mek'))
  RCONST(12451) = (j('mek')*2)
  RCONST(12452) = (j('ch3o2h'))
  RCONST(12455) = (j('mek')*2)
  RCONST(12463) = (j('biacet')+j('mek'))
  RCONST(12465) = (j('mek')*2)
  RCONST(12466) = (j('ch3o2h'))
  RCONST(12469) = (j('mek')*2)
  RCONST(12477) = (j('biacet')+j('mek'))
  RCONST(12479) = (j('ch3o2h'))
  RCONST(12480) = (j('mek')*2)
  RCONST(12483) = (j('mek')*2)
  RCONST(12491) = (j('n_c3h7cho_hco'))
  RCONST(12494) = (j('biacet')+j('mek'))
  RCONST(12496) = (j('ch3o2h'))
  RCONST(12497) = (j('mek')*2)
  RCONST(12500) = (j('mek')*2)
  RCONST(12508) = (j('biacet')+j('mek'))
  RCONST(12511) = (j('ch3o2h'))
  RCONST(12515) = (j('ch3o2h'))
  RCONST(12516) = (j('mek')*2)
  RCONST(12519) = (j('mek')*2)
  RCONST(12528) = (j('ch3o2h'))
  RCONST(12533) = (j('ch3o2h'))
  RCONST(12536) = (j('ch3o2h'))
  RCONST(12540) = (j('ch3cocho')*2)
  RCONST(12548) = (j('ch3cocho')*2)
  RCONST(12556) = (j('ch3o2h'))
  RCONST(12559) = (j('ch3o2h'))
  RCONST(12569) = (j('ch3o2h'))
  RCONST(12572) = (j('ch3o2h'))
  RCONST(12575) = (j('ch3o2h'))
  RCONST(12578) = (j('ch3cocho')*2)
  RCONST(12600) = (j('ch3o2h'))
  RCONST(12601) = (j('mek'))
  RCONST(12612) = (j('ch3o2h'))
  RCONST(12616) = (j('ch3o2h'))
  RCONST(12619) = (j('ch3o2h'))
  RCONST(12622) = (j('ch3cocho')+j('biacet'))
  RCONST(12630) = (j('ch3o2h'))
  RCONST(12633) = (j('ch3o2h'))
  RCONST(12636) = (j('ch3o2h'))
  RCONST(12639) = (j('ch3cocho')+j('biacet'))
  RCONST(12647) = (j('ch3o2h'))
  RCONST(12650) = (j('ch3o2h'))
  RCONST(12653) = (j('ch3cocho')*2)
  RCONST(12668) = (j('ch3o2h'))
  RCONST(12671) = (j('ch3o2h'))
  RCONST(12674) = (j('ch3cocho')*2)
  RCONST(12683) = (j('ch3o2h')+j('biacet')+j('mek'))
  RCONST(12687) = (j('ch3o2h'))
  RCONST(12690) = (j('ch3o2h'))
  RCONST(12693) = (j('ch3cocho')*2)
  RCONST(12702) = (j('ch3o2h')+j('biacet')+j('mek'))
  RCONST(12715) = (j('ch3o2h'))
  RCONST(12718) = (j('ch3o2h'))
  RCONST(12722) = (j('ch3o2h'))
  RCONST(12725) = (j('ch3o2h'))
  RCONST(12728) = (j('ch3o2h'))
  RCONST(12731) = (j('ch3cocho')+j('biacet'))
  RCONST(12739) = (j('ch3o2h'))
  RCONST(12742) = (j('ch3o2h'))
  RCONST(12745) = (j('ch3o2h'))
  RCONST(12748) = (j('ch3cocho')*2)
  RCONST(12756) = (j('ch3o2h'))
  RCONST(12759) = (j('ch3o2h'))
  RCONST(12762) = (j('ch3cocho')+j('biacet'))
  RCONST(12770) = (j('ch3o2h'))
  RCONST(12773) = (j('ch3o2h'))
  RCONST(12776) = (j('ch3cocho')+j('biacet'))
  RCONST(12792) = (j('ch3o2h'))
  RCONST(12799) = (j('ch3o2h'))
  RCONST(12803) = (j('ch3o2h'))
  RCONST(12808) = (j('ch3o2h')+j('mek'))
  RCONST(12811) = (j('mek'))
  RCONST(12842) = (j('ch3o2h'))
  RCONST(12847) = (j('ch3o2h')*3)
  RCONST(12851) = (j('ch3o2h'))
  RCONST(12873) = (j('ch3o2h'))
  RCONST(12882) = (j('ch3o2h'))
  RCONST(12884) = (j('ch3o2h')*2)
  RCONST(12886) = (KBPAN+j('ch3o2h'))
  RCONST(12889) = (j('ch3o2h'))
  RCONST(12902) = (j('ch3o2h'))
  RCONST(12907) = (j('ch3coch2ono2')*10)
  RCONST(12909) = (j('ch3coch2ono2')*10)
  RCONST(12911) = (KBPAN+j('ch3coch2ono2')*10)
  RCONST(12922) = (j('ch3o2h'))
  RCONST(12928) = (j('ch3o2h'))
  RCONST(12933) = (j('ch3o2h'))
  RCONST(12942) = (j('i_c3h7cho'))
  RCONST(12943) = (j('ch3o2h'))
  RCONST(12946) = (j('mek'))
  RCONST(12948) = (j('i_c3h7cho'))
  RCONST(12957) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(12972) = (j('ch3o2h'))
  RCONST(13002) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13004) = (j('2_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(13007) = (j('n_c3h7cho_hco'))
  RCONST(13013) = (j('ch3o2h')+j('biacet'))
  RCONST(13015) = (j('1_c4h9ono2')+j('biacet'))
  RCONST(13018) = (j('biacet'))
  RCONST(13020) = (j('ch3o2h'))
  RCONST(13036) = (j('ch3o2h')+j('mek'))
  RCONST(13039) = (j('ch3o2h')+j('biacet'))
  RCONST(13041) = (j('2_c4h9ono2')+j('biacet'))
  RCONST(13044) = (j('biacet'))
  RCONST(13046) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13063) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(13065) = (j('2_c4h9ono2')+j('n_c3h7cho_hco')*2)
  RCONST(13068) = (j('n_c3h7cho_hco'))
  RCONST(13070) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13073) = (j('n_c3h7cho_hco'))
  RCONST(13076) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(13078) = (j('1_c4h9ono2')+j('n_c3h7cho_hco')*2)
  RCONST(13081) = (j('n_c3h7cho_hco')*2)
  RCONST(13084) = (j('ch3o2h'))
  RCONST(13088) = (j('ch3o2h'))
  RCONST(13093) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13095) = (j('n_c3h7ono2')+j('n_c3h7cho_hco'))
  RCONST(13099) = (j('n_c3h7cho_hco'))
  RCONST(13101) = (j('ch3o2h'))
  RCONST(13112) = (j('n_c3h7cho_hco'))
  RCONST(13126) = (j('n_c3h7cho_hco'))
  RCONST(13128) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13132) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13134) = (j('n_c3h7ono2'))
  RCONST(13139) = (j('n_c3h7cho_hco'))
  RCONST(13141) = (j('ch3o2h'))
  RCONST(13142) = (j('mek')+j('n_c3h7cho_hco')*2)
  RCONST(13145) = (j('mek')+j('n_c3h7cho_hco')*2)
  RCONST(13166) = (j('ch3o2h'))
  RCONST(13168) = (j('n_c3h7ono2'))
  RCONST(13172) = (j('ch3o2h'))
  RCONST(13184) = (j('ch3o2h'))
  RCONST(13188) = (j('ch3o2h'))
  RCONST(13205) = (j('ch3o2h'))
  RCONST(13219) = (j('ch3o2h'))
  RCONST(13223) = (j('ch3o2h'))
  RCONST(13228) = (j('ch3o2h'))
  RCONST(13240) = (j('ch3o2h'))
  RCONST(13257) = (j('ch3o2h'))
  RCONST(13259) = (j('1_c4h9ono2'))
  RCONST(13277) = (j('ch3o2h'))
  RCONST(13279) = (j('2_c4h9ono2'))
  RCONST(13294) = (j('ch3o2h'))
  RCONST(13296) = (j('1_c4h9ono2'))
  RCONST(13313) = (j('ch3o2h'))
  RCONST(13319) = (j('n_c3h7cho_hco'))
  RCONST(13328) = (j('ch3o2h')+j('mek'))
  RCONST(13331) = (j('ch3o2h')+j('mek'))
  RCONST(13343) = (j('ch3o2h'))
  RCONST(13347) = (j('ch3o2h'))
  RCONST(13348) = (j('mek')*2)
  RCONST(13355) = (j('ch3o2h'))
  RCONST(13359) = (j('ch3o2h'))
  RCONST(13364) = (j('mek'))
  RCONST(13370) = (j('ch3o2h'))
  RCONST(13378) = (j('ch3o2h'))
  RCONST(13386) = (j('ch3o2h'))
  RCONST(13394) = (j('ch3o2h'))
  RCONST(13402) = (j('ch3o2h'))
  RCONST(13414) = (j('ch3o2h'))
  RCONST(13424) = (j('ch3o2h'))
  RCONST(13429) = (j('ch3o2h'))
  RCONST(13439) = (j('ch3o2h'))
  RCONST(13443) = (j('ch3o2h')+j('biacet'))
  RCONST(13448) = (j('ch3o2h'))
  RCONST(13453) = (j('ch3o2h'))
  RCONST(13457) = (j('mek')+j('ch3cocho'))
  RCONST(13459) = (j('ch3o2h'))
  RCONST(13469) = (j('ch3o2h'))
  RCONST(13479) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(13484) = (j('ch3o2h')+j('biacet')*2)
  RCONST(13494) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(13505) = (j('ch3o2h')+j('i_c3h7cho')+j('mek'))
  RCONST(13510) = (j('ch3o2h'))
  RCONST(13513) = (j('ch3o2h'))
  RCONST(13517) = (j('ch3o2h'))
  RCONST(13521) = (j('biacet'))
  RCONST(13522) = (j('ch3cocho'))
  RCONST(13530) = (j('ch3o2h'))
  RCONST(13540) = (j('ch3o2h'))
  RCONST(13550) = (j('ch3o2h'))
  RCONST(13555) = (j('ch3o2h'))
  RCONST(13559) = (j('ch3o2h'))
  RCONST(13562) = (j('ch3cocho'))
  RCONST(13574) = (j('ch3coch2ono2')*10)
  RCONST(13576) = (KBPAN+j('ch3coch2ono2')*10)
  RCONST(13579) = (j('ch3o2h'))
  RCONST(13584) = (j('ch3o2h'))
  RCONST(13589) = (j('ch3o2h'))
  RCONST(13593) = (j('ch3coch2ono2')*0.91)
  RCONST(13595) = (j('ch3coch2ono2')*0.91)
  RCONST(13597) = (KBPAN+j('ch3coch2ono2')*0.91)
  RCONST(13599) = (j('ch3o2h')*2)
  RCONST(13601) = (KBPAN+j('ch3o2h'))
  RCONST(13602) = (j('ch3coch2ono2')*1.6)
  RCONST(13604) = (j('ch3coch2ono2')*1.6)
  RCONST(13606) = (j('ch3coch2ono2')*1.6+KBPAN)
  RCONST(13609) = (j('ch3o2h'))
  RCONST(13610) = (j('i_c3h7cho'))
  RCONST(13613) = (j('ch3o2h'))
  RCONST(13614) = (j('n_c3h7cho_hco'))
  RCONST(13617) = (j('ch3coch2ono2')*0.91)
  RCONST(13619) = (j('ch3coch2ono2')*0.91)
  RCONST(13621) = (j('ch3coch2ono2')*1.6)
  RCONST(13623) = (j('ch3coch2ono2')*0.91)
  RCONST(13626) = (j('ch3o2h'))
  RCONST(13629) = (j('ch3o2h'))
  RCONST(13634) = (j('ch3o2h'))
  RCONST(13638) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13642) = (j('ch3o2h')+j('mek')+j('n_c3h7cho_hco'))
  RCONST(13650) = (j('ch3o2h')+j('mek')+j('ch3cocho'))
  RCONST(13654) = (j('ch3o2h')+j('biacet'))
  RCONST(13668) = (j('ch3o2h'))
  RCONST(13672) = (j('ch3o2h'))
  RCONST(13674) = (j('n_c3h7ono2'))
  RCONST(13678) = (j('n_c3h7cho_hco'))
  RCONST(13681) = (j('ch3o2h')+j('mek')+j('n_c3h7cho_hco'))
  RCONST(13688) = (j('mek'))
  RCONST(13701) = (j('mek')*2)
  RCONST(13703) = (j('ch3o2h')+j('mek')*2)
  RCONST(13707) = (j('ch3o2h')+j('mek')*2)
  RCONST(13710) = (j('ch3cocho'))
  RCONST(13713) = (j('mek')*2)
  RCONST(13730) = (j('ch3cocho')+j('n_c3h7cho_hco')+j('biacet'))
  RCONST(13752) = (j('ch3cocho')+j('n_c3h7cho_hco'))
  RCONST(13754) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(13756) = (j('2_c4h9ono2')+j('n_c3h7cho_hco'))
  RCONST(13759) = (j('n_c3h7cho_hco'))
  RCONST(13774) = (j('mek')*2)
  RCONST(13775) = (j('ch3o2h'))
  RCONST(13779) = (j('mek')*2)
  RCONST(13781) = (j('mek')*2+j('ch3o2h'))
  RCONST(13810) = (j('ch3o2h'))
  RCONST(13819) = (j('ch3o2h'))
  RCONST(13824) = (j('ch3o2h'))
  RCONST(13826) = (j('n_c3h7ono2'))
  RCONST(13834) = (j('n_c3h7cho_hco'))
  RCONST(13843) = (j('ch3o2h'))
  RCONST(13845) = (j('n_c3h7ono2'))
  RCONST(13848) = (j('n_c3h7cho_hco'))
  RCONST(13851) = (j('mek')*2+j('ch3o2h'))
  RCONST(13857) = (j('ch3o2h'))
  RCONST(13861) = (j('ch3o2h'))
  RCONST(13863) = (j('1_c4h9ono2'))
  RCONST(13883) = (j('ch3o2h'))
  RCONST(13885) = (j('n_c3h7ono2'))
  RCONST(13888) = (j('n_c3h7cho_hco'))
  RCONST(13891) = (j('ch3o2h'))
  RCONST(13893) = (j('1_c4h9ono2'))
  RCONST(13898) = (j('ch3o2h'))
  RCONST(13900) = (j('2_c4h9ono2'))
  RCONST(13904) = (j('ch3o2h'))
  RCONST(13906) = (j('2_c4h9ono2'))
  RCONST(13911) = (j('ch3o2h'))
  RCONST(13922) = (j('mek'))
  RCONST(13931) = (j('ch3o2h'))
  RCONST(13935) = (j('ch3o2h'))
  RCONST(13937) = (j('2_c4h9ono2'))
  RCONST(13941) = (j('ch3o2h'))
  RCONST(13945) = (j('i_c3h7cho'))
  RCONST(13946) = (j('ch3o2h'))
  RCONST(13949) = (j('n_c3h7cho_hco')+j('biacet')+j('ch3o2h'))
  RCONST(13957) = (j('ch3o2h'))
  RCONST(13961) = (j('ch3o2h')+j('biacet'))
  RCONST(13962) = (j('mek'))
  RCONST(13965) = (j('ch3o2h'))
  RCONST(13966) = (j('biacet'))
  RCONST(13969) = (j('ch3o2h'))
  RCONST(13970) = (j('mek')*2)
  RCONST(13977) = (j('ch3o2h')+j('mek')+j('biacet'))
  RCONST(13980) = (j('ch3o2h')+j('mek')+j('biacet'))
  RCONST(13983) = (j('ch3o2h')+j('mek')+j('biacet'))
  RCONST(13986) = (j('ch3o2h')+j('mek')+j('biacet'))
  RCONST(13989) = (j('ch3o2h')+j('mek')+j('biacet'))
  RCONST(13993) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(13997) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14001) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14006) = (j('mek'))
  RCONST(14008) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14012) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14017) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14022) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14033) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14037) = (j('ch3o2h'))
  RCONST(14041) = (j('ch3o2h'))
  RCONST(14045) = (j('mvk_mcm_ch2ch'))
  RCONST(14047) = (j('ch3o2h'))
  RCONST(14051) = (j('ch3o2h')+j('mek'))
  RCONST(14054) = (j('ch3cocho'))
  RCONST(14057) = (j('n_c3h7cho_hco'))
  RCONST(14058) = (j('ch3cocho'))
  RCONST(14060) = (j('ch3o2h')+j('mek')+j('ch3cocho'))
  RCONST(14063) = (j('ch3o2h')+j('biacet'))
  RCONST(14067) = (j('ch3cocho'))
  RCONST(14069) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14072) = (j('2_c4h9ono2'))
  RCONST(14091) = (j('ch3o2h')+j('mek'))
  RCONST(14094) = (j('ch3o2h')+j('biacet'))
  RCONST(14096) = (j('biacet'))
  RCONST(14099) = (j('biacet'))
  RCONST(14101) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14112) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(14115) = (j('n_c3h7cho_hco')*2)
  RCONST(14116) = (j('biacet'))
  RCONST(14118) = (j('n_c3h7cho_hco')*2)
  RCONST(14120) = (j('n_c3h7cho_hco')*2)
  RCONST(14122) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(14132) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(14136) = (j('n_c3h7cho_hco')*2)
  RCONST(14138) = (j('n_c3h7cho_hco'))
  RCONST(14140) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14151) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14154) = (j('ch3cocho')+j('biacet'))
  RCONST(14156) = (j('n_c3h7cho_hco'))
  RCONST(14165) = (j('mek')*2)
  RCONST(14167) = (j('ch3o2h')+j('mek')*2)
  RCONST(14171) = (j('ch3o2h'))
  RCONST(14172) = (j('mek')*2)
  RCONST(14175) = (j('mek')*2)
  RCONST(14177) = (j('ch3cocho'))
  RCONST(14183) = (j('ch3o2h'))
  RCONST(14186) = (j('biacet'))
  RCONST(14188) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14193) = (j('ch3o2h'))
  RCONST(14197) = (j('ch3o2h'))
  RCONST(14199) = (j('n_c3h7ono2'))
  RCONST(14204) = (j('n_c3h7cho_hco'))
  RCONST(14206) = (j('ch3o2h'))
  RCONST(14207) = (j('mek')+j('n_c3h7cho_hco'))
  RCONST(14210) = (j('mek')+j('n_c3h7cho_hco'))
  RCONST(14232) = (j('ch3o2h'))
  RCONST(14235) = (j('ch3cocho'))
  RCONST(14267) = (j('ch3o2h'))
  RCONST(14278) = (j('ch3o2h')+j('biacet'))
  RCONST(14280) = (j('1_c4h9ono2')+j('biacet'))
  RCONST(14284) = (j('biacet'))
  RCONST(14286) = (j('biacet'))
  RCONST(14301) = (j('ch3cocho'))
  RCONST(14309) = (j('biacet'))
  RCONST(14318) = (j('ch3o2h'))
  RCONST(14320) = (j('1_c4h9ono2'))
  RCONST(14325) = (j('ch3o2h'))
  RCONST(14327) = (j('1_c4h9ono2'))
  RCONST(14339) = (j('ch3cocho'))
  RCONST(14355) = (j('n_c3h7cho_hco'))
  RCONST(14356) = (j('ch3o2h'))
  RCONST(14360) = (j('mek'))
  RCONST(14361) = (j('ch3o2h'))
  RCONST(14380) = (j('ch3o2h'))
  RCONST(14398) = (j('ch3o2h'))
  RCONST(14402) = (j('ch3o2h'))
  RCONST(14407) = (j('ch3o2h'))
  RCONST(14414) = (j('mek'))
  RCONST(14416) = (j('ch3o2h')+j('mek'))
  RCONST(14430) = (j('ch3o2h'))
  RCONST(14433) = (j('ch3cocho')+j('n_c3h7cho_hco')*2)
  RCONST(14437) = (j('ch3cocho')+j('n_c3h7cho_hco'))
  RCONST(14439) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14441) = (j('n_c3h7ono2')+j('n_c3h7cho_hco'))
  RCONST(14447) = (j('n_c3h7cho_hco'))
  RCONST(14448) = (j('n_c3h7cho_hco'))
  RCONST(14450) = (j('n_c3h7cho_hco'))
  RCONST(14452) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(14454) = (j('1_c4h9ono2')+j('n_c3h7cho_hco')*2)
  RCONST(14457) = (j('n_c3h7cho_hco')*2)
  RCONST(14459) = (j('mek')+j('biacet')+j('ch3o2h'))
  RCONST(14474) = (j('mek'))
  RCONST(14475) = (j('n_c3h7cho_hco'))
  RCONST(14478) = (j('ch3o2h'))
  RCONST(14482) = (j('ch3o2h'))
  RCONST(14491) = (j('ch3o2h'))
  RCONST(14510) = (j('ch3o2h'))
  RCONST(14513) = (j('mek'))
  RCONST(14516) = (j('ch3o2h'))
  RCONST(14518) = (j('n_c3h7ono2'))
  RCONST(14522) = (j('ch3o2h'))
  RCONST(14534) = (j('ch3o2h'))
  RCONST(14536) = (j('1_c4h9ono2'))
  RCONST(14542) = (j('ch3o2h'))
  RCONST(14544) = (j('n_c3h7ono2'))
  RCONST(14547) = (j('n_c3h7cho_hco'))
  RCONST(14570) = (j('ch3o2h'))
  RCONST(14572) = (j('2_c4h9ono2'))
  RCONST(14576) = (j('ch3o2h'))
  RCONST(14578) = (j('1_c4h9ono2'))
  RCONST(14592) = (j('ch3o2h'))
  RCONST(14596) = (j('ch3o2h'))
  RCONST(14598) = (j('1_c4h9ono2'))
  RCONST(14610) = (j('ch3o2h'))
  RCONST(14629) = (j('ch3o2h'))
  RCONST(14639) = (j('ch3o2h'))
  RCONST(14641) = (j('1_c4h9ono2'))
  RCONST(14645) = (j('ch3o2h'))
  RCONST(14649) = (j('ch3o2h'))
  RCONST(14653) = (j('ch3o2h'))
  RCONST(14657) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14661) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14664) = (j('ch3o2h'))
  RCONST(14677) = (j('ch3o2h')+j('mek'))
  RCONST(14680) = (j('ch3o2h')+j('biacet'))
  RCONST(14684) = (j('ch3o2h')+j('biacet'))
  RCONST(14722) = (j('biacet')+j('ch3o2h'))
  RCONST(14726) = (j('ch3o2h'))
  RCONST(14730) = (j('n_c3h7cho_hco'))
  RCONST(14731) = (j('ch3o2h'))
  RCONST(14732) = (j('mek'))
  RCONST(14736) = (j('n_c3h7cho_hco'))
  RCONST(14737) = (j('mek'))
  RCONST(14754) = (j('ch3o2h'))
  RCONST(14771) = (j('ch3o2h'))
  RCONST(14773) = (j('n_c3h7ono2'))
  RCONST(14776) = (j('n_c3h7cho_hco'))
  RCONST(14785) = (j('ch3o2h')+j('biacet'))
  RCONST(14787) = (j('2_c4h9ono2')+j('biacet'))
  RCONST(14790) = (j('biacet'))
  RCONST(14792) = (j('ch3o2h')+j('biacet'))
  RCONST(14795) = (j('biacet'))
  RCONST(14797) = (j('biacet'))
  RCONST(14800) = (j('ch3o2h'))
  RCONST(14817) = (j('n_c3h7cho_hco'))
  RCONST(14819) = (j('ch3o2h'))
  RCONST(14824) = (j('ch3o2h'))
  RCONST(14826) = (j('1_c4h9ono2'))
  RCONST(14832) = (j('ch3o2h'))
  RCONST(14834) = (j('n_c3h7ono2'))
  RCONST(14838) = (j('n_c3h7cho_hco'))
  RCONST(14842) = (j('ch3o2h'))
  RCONST(14846) = (j('ch3o2h'))
  RCONST(14848) = (j('2_c4h9ono2'))
  RCONST(14858) = (j('ch3o2h')+j('ch3cocho'))
  RCONST(14860) = (j('2_c4h9ono2')+j('ch3cocho'))
  RCONST(14863) = (j('ch3cocho'))
  RCONST(14865) = (j('ch3o2h'))
  RCONST(14869) = (j('n_c3h7cho_hco'))
  RCONST(14870) = (j('biacet'))
  RCONST(14872) = (j('ch3cocho')+j('biacet'))
  RCONST(14874) = (j('n_c3h7cho_hco')*2)
  RCONST(14876) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(14886) = (j('n_c3h7cho_hco'))
  RCONST(14888) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14892) = (j('n_c3h7cho_hco'))
  RCONST(14894) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14898) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14901) = (j('ch3cocho')+j('n_c3h7cho_hco'))
  RCONST(14903) = (j('n_c3h7cho_hco'))
  RCONST(14905) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(14908) = (j('ch3o2h'))
  RCONST(14925) = (j('ch3o2h'))
  RCONST(14930) = (j('ch3o2h'))
  RCONST(14932) = (j('1_c4h9ono2'))
  RCONST(14936) = (j('mek'))
  RCONST(14939) = (j('ch3o2h'))
  RCONST(14942) = (j('ch3cocho'))
  RCONST(14951) = (j('ch3o2h'))
  RCONST(14953) = (j('2_c4h9ono2'))
  RCONST(14967) = (j('ch3o2h'))
  RCONST(14971) = (j('ch3o2h'))
  RCONST(14973) = (j('2_c4h9ono2'))
  RCONST(14993) = (j('ch3o2h'))
  RCONST(15015) = (j('ch3o2h')+j('n_c3h7cho_hco')*2)
  RCONST(15018) = (j('n_c3h7cho_hco')*2)
  RCONST(15029) = (j('ch3o2h')+j('mek'))
  RCONST(15039) = (j('ch3o2h'))
  RCONST(15040) = (j('n_c3h7cho_hco'))
  RCONST(15041) = (j('mek'))
  RCONST(15045) = (j('n_c3h7cho_hco'))
  RCONST(15046) = (j('mek'))
  RCONST(15053) = (j('ch3o2h'))
  RCONST(15056) = (j('mek'))
  RCONST(15067) = (j('ch3o2h')+j('biacet'))
  RCONST(15070) = (j('biacet'))
  RCONST(15072) = (j('ch3o2h')+j('biacet'))
  RCONST(15075) = (j('ch3o2h'))
  RCONST(15080) = (j('ch3o2h'))
  RCONST(15083) = (j('ch3o2h'))
  RCONST(15086) = (j('biacet'))
  RCONST(15088) = (j('mek')+j('ch3o2h'))
  RCONST(15092) = (j('ch3o2h'))
  RCONST(15095) = (j('ch3o2h')+j('biacet'))
  RCONST(15099) = (j('ch3o2h')+j('biacet'))
  RCONST(15103) = (j('n_c3h7cho_hco')*2)
  RCONST(15105) = (j('n_c3h7cho_hco'))
  RCONST(15107) = (j('ch3o2h')+j('n_c3h7cho_hco'))
  RCONST(15111) = (j('ch3o2h'))
  RCONST(15112) = (j('mek'))
  RCONST(15115) = (j('ch3o2h'))
  RCONST(15116) = (j('mek'))
  RCONST(15119) = (j('mek'))
  RCONST(15121) = (j('ch3o2h'))
  RCONST(15123) = (j('2_c4h9ono2'))
  RCONST(15127) = (j('n_c3h7cho_hco'))
  RCONST(15130) = (j('n_c3h7cho_hco'))
  RCONST(15154) = (j('ch3o2h'))
  RCONST(15159) = (j('ch3o2h'))
  RCONST(15163) = (j('ch3cocho'))
  RCONST(15165) = (j('ch3o2h'))
  RCONST(15169) = (j('ch3o2h'))
  RCONST(15176) = (j('ch3o2h'))
      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE MCMv3_3_Rates

