! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Global Data Module File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : MCMv3_3_Global.f90
! Time                 : Mon Jul 19 14:16:06 2021
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_MCMv3_3_3654_BOXMOX
! Equation file        : MCMv3_3.kpp
! Output root filename : MCMv3_3
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE MCMv3_3_Global

  USE MCMv3_3_Parameters, ONLY: dp, NSPEC, NVAR, NFIX, NREACT, LU_NONZERO
  PUBLIC
  SAVE


! Declaration of global variables

! C - Concentration of all species
  REAL(kind=dp) :: C(NSPEC)
! VAR - Concentrations of variable species (global)
  REAL(kind=dp) :: VAR(NVAR)
! FIX - Concentrations of fixed species (global)
  REAL(kind=dp) :: FIX(NFIX)
! VAR, FIX are chunks of array C
      EQUIVALENCE( C(1),VAR(1) )
      EQUIVALENCE( C(5259),FIX(1) )
! RCONST - Rate constants (global)
  REAL(kind=dp) :: RCONST(NREACT)
! TIME - Current integration time
  REAL(kind=dp) :: TIME
! SUN - Sunlight intensity between [0,1]
  REAL(kind=dp) :: SUN
! TEMP - Temperature
  REAL(kind=dp) :: TEMP
! RTOLS - (scalar) Relative tolerance
  REAL(kind=dp) :: RTOLS
! TSTART - Integration start time
  REAL(kind=dp) :: TSTART
! TEND - Integration end time
  REAL(kind=dp) :: TEND
! DT - Integration step
  REAL(kind=dp) :: DT
! ATOL - Absolute tolerance
  REAL(kind=dp) :: ATOL(NVAR)
! RTOL - Relative tolerance
  REAL(kind=dp) :: RTOL(NVAR)
! STEPMIN - Lower bound for integration step
  REAL(kind=dp) :: STEPMIN
! STEPMAX - Upper bound for integration step
  REAL(kind=dp) :: STEPMAX
! CFACTOR - Conversion factor for concentration units
  REAL(kind=dp) :: CFACTOR

! INLINED global variable declarations


  ! BOXMOX global variables

  ! Parameters
  INTEGER, PARAMETER :: max_species_boxmox = 10000  ! maximum number of species
                                                    ! read in
  INTEGER, PARAMETER :: max_jhash_boxmox   = 10000  ! maximum hash value of
                                                    ! photolysis rate labels

  ! Configuration
  LOGICAL            :: lverbose                    ! verbose output?
  LOGICAL            :: llibrary                    ! library version?


  ! State definition
  REAL(KIND=dp)      :: pres                        ! pressure [Pa]
  ! temperature variable temp [K] defined in KPP already
  REAL(KIND=dp)      :: dxdydz(3), dxdydz_old(3)    ! box dimensions (x,y,z)
                                                    ! [m]

  ! Turbulent mixing
  INTEGER            :: iturb                       ! type of mixing
  INTEGER, PARAMETER :: TURB_OPT_NONE      = 0, &   ! no turbulent mixing
                        TURB_OPT_SPECIFIED = 1, &   ! using specified Kturb
                        TURB_OPT_VOLUME    = 2, &   ! using volume changes
                        TURB_OPT_TRACER    = 3      ! using tracer conc.
  REAL(KIND=dp)      :: Kturb                       ! eddy diffusivity [m2 s-1]

  ! Photolysis rates
  REAL(KIND=dp)      :: jvalues(max_jhash_boxmox)   ! Photolysis rate [s-1]

  ! Aerosol
  REAL(KIND=dp)      :: AER_R,                    & ! particle radius [m]
                        AER_SAD                     ! surface area density
                                                    ! [m^2 m^-3]

  ! Steady-state modeling
  LOGICAL            :: lfix_nox                    ! fix total NOx?
  REAL(kind=dp)      :: initial_total_nox           ! total NOx to fix


 REAL(dp)::M, N2, O2, RO2, H2O
 REAL(dp) :: &
KRO2NO,KRO2HO2,KAPHO2,KAPNO,&
KRO2NO3,KNO3AL,KDEC,KROPRIM,KROSEC,&
KCH3O2,K298CH3O2,K16ISOM1,K15ISOM1,K14ISOM1,&
KD0,KDI,KRD,FCD,NCD,&
FD,KBPAN,KC0,KCI,KRC,&
FCC,NC,FC,KFPAN,K10,&
K1I,KR1,FC1,NC1,F1,&
KMT01,K20,K2I,KR2,FC2,&
NC2,F2xx,KMT02,K30,K3I,&
KR3,FC3,NC3,F3,KMT03,&
K40,K4I,KR4,FC4,NC4,&
F4,KMT04,KMT05,KMT06,K70,&
K7I,KR7,FC7,NC7,F7,&
KMT07,K80,K8I,KR8,FC8,&
NC8,F8,KMT08,K90,K9I,&
KR9,FC9,NC9,F9,KMT09,&
K100,K10I,KR10,FC10,NC10,&
F10,KMT10,K1,K3,K4,&
K2,KMT11,K120,K12I,KR12,&
FC12,NC12,F12,KMT12,K130,&
K13I,KR13,FC13,NC13,F13,&
KMT13,K140,K14I,KR14,FC14,&
NC14,F14,KMT14,K150,K15I,&
KR15,FC15,NC15,F15,KMT15,&
K160,K16I,KR16,FC16,NC16,&
F16,KMT16,K170,K17I,KR17,&
FC17,NC17,F17,KMT17,KMT18,&
KPPN0,KPPNI,KRPPN,FCPPN,NCPPN,FPPN,KBPPN


! INLINED global variable declarations


END MODULE MCMv3_3_Global

