! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Global Data Module File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : HETCHEM_Global.f90
! Time                 : Thu Oct  8 08:22:02 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_HETCHEM_12963_BOXMOX
! Equation file        : HETCHEM.kpp
! Output root filename : HETCHEM
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE HETCHEM_Global

  USE HETCHEM_Parameters, ONLY: dp, NSPEC, NVAR, NFIX, NREACT, LU_NONZERO
  PUBLIC
  SAVE


! Declaration of global variables

! C - Concentration of all species
  REAL(kind=dp) :: C(NSPEC)
! VAR - Concentrations of variable species (global)
  REAL(kind=dp) :: VAR(NVAR)
! FIX - Concentrations of fixed species (global)
  REAL(kind=dp) :: FIX(NFIX)
! VAR, FIX are chunks of array C
      EQUIVALENCE( C(1),VAR(1) )
      EQUIVALENCE( C(6),FIX(1) )
! RCONST - Rate constants (global)
  REAL(kind=dp) :: RCONST(NREACT)
! TIME - Current integration time
  REAL(kind=dp) :: TIME
! SUN - Sunlight intensity between [0,1]
  REAL(kind=dp) :: SUN
! TEMP - Temperature
  REAL(kind=dp) :: TEMP
! RTOLS - (scalar) Relative tolerance
  REAL(kind=dp) :: RTOLS
! TSTART - Integration start time
  REAL(kind=dp) :: TSTART
! TEND - Integration end time
  REAL(kind=dp) :: TEND
! DT - Integration step
  REAL(kind=dp) :: DT
! ATOL - Absolute tolerance
  REAL(kind=dp) :: ATOL(NVAR)
! RTOL - Relative tolerance
  REAL(kind=dp) :: RTOL(NVAR)
! STEPMIN - Lower bound for integration step
  REAL(kind=dp) :: STEPMIN
! STEPMAX - Upper bound for integration step
  REAL(kind=dp) :: STEPMAX
! CFACTOR - Conversion factor for concentration units
  REAL(kind=dp) :: CFACTOR

! INLINED global variable declarations


  ! BOXMOX global variables

  ! Parameters
  INTEGER, PARAMETER :: max_species_boxmox = 10000  ! maximum number of species
                                                    ! read in
  INTEGER, PARAMETER :: max_jhash_boxmox   = 10000  ! maximum hash value of
                                                    ! photolysis rate labels

  ! Configuration
  LOGICAL            :: lverbose                    ! verbose output?
  LOGICAL            :: llibrary                    ! library version?


  ! State definition
  REAL(KIND=dp)      :: pres                        ! pressure [Pa]
  ! temperature variable temp [K] defined in KPP already
  REAL(KIND=dp)      :: dxdydz(3), dxdydz_old(3)    ! box dimensions (x,y,z)
                                                    ! [m]

  ! Turbulent mixing
  INTEGER            :: iturb                       ! type of mixing
  INTEGER, PARAMETER :: TURB_OPT_NONE      = 0, &   ! no turbulent mixing
                        TURB_OPT_SPECIFIED = 1, &   ! using specified Kturb
                        TURB_OPT_VOLUME    = 2, &   ! using volume changes
                        TURB_OPT_TRACER    = 3      ! using tracer conc.
  REAL(KIND=dp)      :: Kturb                       ! eddy diffusivity [m2 s-1]

  ! Photolysis rates
  REAL(KIND=dp)      :: jvalues(max_jhash_boxmox)   ! Photolysis rate [s-1]

  ! Aerosol
  REAL(KIND=dp)      :: AER_R,                    & ! particle radius [m]
                        AER_SAD                     ! surface area density
                                                    ! [m^2 m^-3]

  ! Steady-state modeling
  LOGICAL            :: lfix_nox                    ! fix total NOx?
  REAL(kind=dp)      :: initial_total_nox           ! total NOx to fix



  ! global variables used by special rate constants of this mechanism

  ! air/water concentration (molecules/cm3)
  REAL(KIND=dp)      :: c_m


! INLINED global variable declarations


END MODULE HETCHEM_Global

