! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Sparse Stoichiometric Data Structures File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CBMZ_StoichiomSP.f90
! Time                 : Thu Oct  8 08:21:56 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CBMZ_11803_BOXMOX
! Equation file        : CBMZ.kpp
! Output root filename : CBMZ
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CBMZ_StoichiomSP

  USE CBMZ_Precision
  PUBLIC
  SAVE


! Row-compressed sparse data for the Jacobian of reaction products JVRP

  INTEGER, PARAMETER, DIMENSION(143) :: CROW_JVRP = (/ &
       1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, &
      13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, &
      26, 28, 30, 32, 34, 36, 38, 40, 41, 43, 45, 47, &
      49, 51, 53, 55, 57, 58, 59, 61, 63, 65, 66, 68, &
      70, 72, 73, 75, 76, 77, 79, 81, 83, 85, 87, 89, &
      91, 93, 95, 97, 99,101,103,105,107,109,111,113, &
     115,117,119,121,123,125,127,129,131,133,135,137, &
     139,141,143,145,147,149,151,153,155,157,159,161, &
     163,165,167,168,170,172,174,176,178,180,182,184, &
     186,188,190,192,194,196,198,200,202,204,206,208, &
     210,212,214,216,217,218,219,220,221,222,223,224, &
     225,226,227,228,229,231,233,235,237,239,241 /)

  INTEGER, PARAMETER, DIMENSION(240) :: ICOL_JVRP = (/ &
      59, 60, 32, 38, 27, 21, 64, 64, 19, 47, 47, 31, &
      33, 54, 49, 53, 42, 66, 57, 56, 16, 16, 37, 37, &
      64, 37, 59, 37, 59, 37, 63, 63, 64, 59, 64, 64, &
      67, 64, 65, 67, 63, 67, 59, 67, 60, 67, 32, 67, &
      38, 67, 27, 67, 65, 67, 19, 67, 65, 65, 63, 65, &
      59, 65, 59, 65, 27, 60, 63, 59, 60, 59, 60, 60, &
      60, 65, 21, 21, 39, 67, 15, 67, 23, 67, 28, 67, &
      41, 67, 47, 67, 47, 60, 54, 67, 54, 60, 49, 67, &
      53, 67, 53, 60, 34, 64, 34, 67, 45, 64, 50, 64, &
      45, 67, 50, 67, 45, 60, 50, 60, 20, 67, 22, 67, &
      29, 63, 36, 67, 36, 60, 24, 59, 42, 67, 42, 64, &
      46, 67, 46, 64, 46, 60, 56, 67, 56, 64, 56, 60, &
      43, 63, 40, 63, 44, 63, 43, 65, 40, 65, 44, 65, &
      31, 67, 33, 67, 66, 67, 57, 67, 58, 59, 18, 35, &
      67, 55, 63, 52, 63, 61, 63, 58, 63, 62, 63, 51, &
      63, 48, 63, 55, 60, 52, 60, 60, 61, 58, 60, 60, &
      62, 51, 60, 48, 60, 55, 65, 52, 65, 61, 65, 58, &
      65, 62, 65, 51, 65, 48, 65, 17, 67, 30, 41,  2, &
       3,  1, 55, 52, 61, 58, 62, 51, 43, 40, 44, 48, &
      25, 67, 25, 60, 25, 64, 26, 67, 26, 60, 26, 64 /)

  INTEGER, PARAMETER, DIMENSION(240) :: IROW_JVRP = (/ &
       1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, &
      13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, &
      24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 30, &
      30, 31, 31, 32, 33, 33, 34, 34, 35, 35, 36, 36, &
      37, 37, 38, 38, 39, 39, 40, 40, 41, 42, 43, 43, &
      44, 44, 45, 45, 46, 47, 47, 48, 48, 49, 49, 50, &
      51, 51, 52, 53, 54, 54, 55, 55, 56, 56, 57, 57, &
      58, 58, 59, 59, 60, 60, 61, 61, 62, 62, 63, 63, &
      64, 64, 65, 65, 66, 66, 67, 67, 68, 68, 69, 69, &
      70, 70, 71, 71, 72, 72, 73, 73, 74, 74, 75, 75, &
      76, 76, 77, 77, 78, 78, 79, 79, 80, 80, 81, 81, &
      82, 82, 83, 83, 84, 84, 85, 85, 86, 86, 87, 87, &
      88, 88, 89, 89, 90, 90, 91, 91, 92, 92, 93, 93, &
      94, 94, 95, 95, 96, 96, 97, 97, 98, 98, 99,100, &
     100,101,101,102,102,103,103,104,104,105,105,106, &
     106,107,107,108,108,109,109,110,110,111,111,112, &
     112,113,113,114,114,115,115,116,116,117,117,118, &
     118,119,119,120,120,121,121,122,122,123,123,124, &
     125,126,127,128,129,130,131,132,133,134,135,136, &
     137,137,138,138,139,139,140,140,141,141,142,142 /)



!  Stoichiometric Matrix in Compressed Column Sparse Format


  INTEGER, PARAMETER, DIMENSION(143) :: CCOL_STOICM = (/ &
       1,  4,  8, 11, 14, 17, 20, 22, 24, 26, 29, 31, &
      35, 39, 43, 46, 50, 54, 62, 70, 78, 80, 82, 84, &
      86, 89, 92, 95, 98,101,104,107,109,112,115,119, &
     122,125,128,130,133,135,137,141,144,147,150,153, &
     155,158,160,165,167,170,173,177,180,183,187,191, &
     196,199,203,206,210,215,222,228,247,266,274,282, &
     286,290,298,308,314,322,328,331,338,348,352,363, &
     366,371,384,395,403,411,420,423,427,430,434,438, &
     444,447,450,453,457,462,467,477,481,486,494,497, &
     502,507,516,520,525,533,536,539,542,545,549,552, &
     555,558,562,565,565,565,565,569,573,580,582,587, &
     593,595,599,602,604,608,610,614,618,620,624 /)

  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_0 = (/ &
      37, 59, 63, 37, 59, 60, 63, 32, 63, 67, 38, 59, &
      67, 27, 59, 65, 21, 59, 60, 37, 64, 16, 64, 19, &
      67, 39, 47, 65, 39, 47, 31, 47, 65, 67, 33, 54, &
      65, 67, 39, 54, 55, 65, 49, 55, 58, 39, 53, 58, &
      65, 39, 42, 58, 65, 30, 48, 49, 52, 54, 65, 66, &
      67, 30, 48, 49, 52, 54, 57, 59, 65, 39, 47, 49, &
      54, 55, 56, 58, 65, 16, 37, 16, 67, 37, 64, 37, &
      64, 37, 59, 63, 37, 59, 60, 37, 59, 63, 59, 63, &
      64, 59, 60, 64, 64, 65, 67, 64, 65, 67, 65, 67, &
      32, 63, 67, 38, 59, 67, 59, 60, 65, 67, 32, 59, &
      67, 38, 60, 67, 27, 59, 67, 65, 67, 19, 65, 67, &
      19, 65, 19, 65, 59, 63, 65, 67, 27, 59, 65, 32, &
      59, 65, 27, 59, 65, 59, 60, 63, 60, 63, 21, 59, &
      60, 59, 60, 38, 59, 60, 65, 67, 21, 38, 21, 59, &
      60, 39, 65, 67,  1, 15, 65, 67, 23, 55, 67, 28, &
      52, 67,  8, 41, 61, 67, 39, 47, 65, 67, 38, 39, &
      47, 60, 65, 54, 58, 67, 38, 54, 58, 60, 49, 62, &
      67, 48, 53, 58, 67, 38, 39, 53, 58, 60,  4, 34, &
      39, 47, 64, 65, 67, 34, 47, 48, 54, 65, 67,  4, &
       5,  9, 23, 28, 30, 35, 39, 45, 47, 52, 53, 54, &
      55, 58, 61, 64, 65, 67,  5,  9, 23, 28, 30, 35, &
      39, 49, 50, 52, 53, 54, 55, 58, 61, 62, 64, 65, &
      67,  9, 30, 45, 47, 48, 54, 65, 67,  9, 30, 48, &
      49, 50, 54, 65, 67,  9, 45, 51, 60,  9, 50, 51, &
      60,  6,  7, 20, 29, 36, 48, 65, 67,  6,  7, 22, &
      29, 36, 41, 48, 53, 65, 67, 29, 42, 57, 59, 63, &
      65,  6,  7, 24, 36, 42, 48, 65, 67,  6,  7, 24, &
      36, 38, 60, 24, 57, 59, 39, 42, 47, 48, 58, 65, &
      67, 39, 42, 47, 48, 53, 54, 58, 64, 65, 67, 43, &
      46, 48, 67,  5, 39, 46, 47, 48, 54, 56, 58, 64 /)
  INTEGER, PARAMETER, DIMENSION(263) :: IROW_STOICM_1 = (/ &
      65, 67, 40, 46, 60, 44, 48, 56, 58, 67,  5, 39, &
      47, 48, 49, 53, 54, 55, 56, 58, 64, 65, 67, 38, &
      39, 41, 47, 48, 54, 56, 57, 58, 60, 65, 41, 43, &
      47, 56, 57, 59, 63, 65, 40, 41, 54, 56, 57, 59, &
      63, 65, 39, 44, 47, 49, 53, 54, 59, 63, 65, 43, &
      65, 66, 40, 41, 57, 65, 44, 65, 66, 31, 47, 55, &
      67, 33, 52, 54, 67, 30, 53, 54, 61, 66, 67, 51, &
      57, 67, 18, 58, 59, 18, 58, 59, 35, 47, 65, 67, &
      47, 55, 59, 63, 65, 52, 54, 59, 63, 65, 30, 48, &
      49, 52, 54, 57, 59, 61, 63, 65, 55, 58, 59, 63, &
      47, 58, 59, 62, 63, 30, 47, 51, 54, 57, 59, 63, &
      65, 48, 59, 63, 47, 55, 59, 60, 65, 52, 54, 59, &
      60, 65, 30, 48, 49, 52, 54, 59, 60, 61, 65, 55, &
      58, 59, 60, 47, 58, 59, 60, 62, 30, 47, 51, 54, &
      57, 59, 60, 65, 48, 59, 60, 31, 55, 65, 33, 52, &
      65, 61, 65, 66,  5, 58, 64, 65, 62, 65, 66, 51, &
      57, 65, 14, 48, 65, 17, 54, 65, 67, 14, 30, 41, &
      35, 47, 55, 65, 28, 52, 54, 65, 30, 48, 49, 52, &
      54, 61, 65, 55, 58, 47, 49, 53, 58, 62, 30, 47, &
      51, 54, 57, 59, 43, 56, 40, 41, 54, 57, 44, 49, &
      54, 14, 48, 10, 11, 25, 67, 25, 60, 10, 11, 25, &
      64, 12, 13, 26, 67, 26, 60, 12, 13, 26, 64 /)
  INTEGER, PARAMETER, DIMENSION(623) :: IROW_STOICM = (/&
    IROW_STOICM_0, IROW_STOICM_1 /)

  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_0 = (/ &
       1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  4,  4, &
       4,  5,  5,  5,  6,  6,  6,  7,  7,  8,  8,  9, &
       9, 10, 10, 10, 11, 11, 12, 12, 12, 12, 13, 13, &
      13, 13, 14, 14, 14, 14, 15, 15, 15, 16, 16, 16, &
      16, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, &
      18, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, &
      20, 20, 20, 20, 20, 21, 21, 22, 22, 23, 23, 24, &
      24, 25, 25, 25, 26, 26, 26, 27, 27, 27, 28, 28, &
      28, 29, 29, 29, 30, 30, 30, 31, 31, 31, 32, 32, &
      33, 33, 33, 34, 34, 34, 35, 35, 35, 35, 36, 36, &
      36, 37, 37, 37, 38, 38, 38, 39, 39, 40, 40, 40, &
      41, 41, 42, 42, 43, 43, 43, 43, 44, 44, 44, 45, &
      45, 45, 46, 46, 46, 47, 47, 47, 48, 48, 49, 49, &
      49, 50, 50, 51, 51, 51, 51, 51, 52, 52, 53, 53, &
      53, 54, 54, 54, 55, 55, 55, 55, 56, 56, 56, 57, &
      57, 57, 58, 58, 58, 58, 59, 59, 59, 59, 60, 60, &
      60, 60, 60, 61, 61, 61, 62, 62, 62, 62, 63, 63, &
      63, 64, 64, 64, 64, 65, 65, 65, 65, 65, 66, 66, &
      66, 66, 66, 66, 66, 67, 67, 67, 67, 67, 67, 68, &
      68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, &
      68, 68, 68, 68, 68, 68, 69, 69, 69, 69, 69, 69, &
      69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, &
      69, 70, 70, 70, 70, 70, 70, 70, 70, 71, 71, 71, &
      71, 71, 71, 71, 71, 72, 72, 72, 72, 73, 73, 73, &
      73, 74, 74, 74, 74, 74, 74, 74, 74, 75, 75, 75, &
      75, 75, 75, 75, 75, 75, 75, 76, 76, 76, 76, 76, &
      76, 77, 77, 77, 77, 77, 77, 77, 77, 78, 78, 78, &
      78, 78, 78, 79, 79, 79, 80, 80, 80, 80, 80, 80, &
      80, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 82, &
      82, 82, 82, 83, 83, 83, 83, 83, 83, 83, 83, 83 /)
  INTEGER, PARAMETER, DIMENSION(263) :: ICOL_STOICM_1 = (/ &
      83, 83, 84, 84, 84, 85, 85, 85, 85, 85, 86, 86, &
      86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 87, &
      87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 88, 88, &
      88, 88, 88, 88, 88, 88, 89, 89, 89, 89, 89, 89, &
      89, 89, 90, 90, 90, 90, 90, 90, 90, 90, 90, 91, &
      91, 91, 92, 92, 92, 92, 93, 93, 93, 94, 94, 94, &
      94, 95, 95, 95, 95, 96, 96, 96, 96, 96, 96, 97, &
      97, 97, 98, 98, 98, 99, 99, 99,100,100,100,100, &
     101,101,101,101,101,102,102,102,102,102,103,103, &
     103,103,103,103,103,103,103,103,104,104,104,104, &
     105,105,105,105,105,106,106,106,106,106,106,106, &
     106,107,107,107,108,108,108,108,108,109,109,109, &
     109,109,110,110,110,110,110,110,110,110,110,111, &
     111,111,111,112,112,112,112,112,113,113,113,113, &
     113,113,113,113,114,114,114,115,115,115,116,116, &
     116,117,117,117,118,118,118,118,119,119,119,120, &
     120,120,121,121,121,122,122,122,122,123,123,123, &
     127,127,127,127,128,128,128,128,129,129,129,129, &
     129,129,129,130,130,131,131,131,131,131,132,132, &
     132,132,132,132,133,133,134,134,134,134,135,135, &
     135,136,136,137,137,137,137,138,138,139,139,139, &
     139,140,140,140,140,141,141,142,142,142,142 /)
  INTEGER, PARAMETER, DIMENSION(623) :: ICOL_STOICM = (/&
    ICOL_STOICM_0, ICOL_STOICM_1 /)

  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_0 = (/ &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  8.900000e-01_dp,  8.900000e-01_dp, &
       -1.000000e+00_dp,  1.100000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.980000e+00_dp,  4.000000e-01_dp, &
       7.400000e-01_dp,  1.000000e-01_dp,  3.000000e-01_dp,  9.000000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.980000e+00_dp,  4.100000e-01_dp,  7.400000e-01_dp,  1.000000e-01_dp, &
       3.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  9.000000e-01_dp,  3.300000e-01_dp, &
       2.000000e-01_dp,  3.000000e-02_dp,  7.000000e-02_dp,  7.000000e-01_dp,  -1.000000e+00_dp, &
       9.700000e-01_dp,  3.300000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp, &
       -2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_1 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp,  3.000000e-01_dp, &
       7.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  7.000000e-01_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.200000e-02_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  5.200000e-01_dp, &
       -1.000000e+00_dp,  2.400000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.200000e-01_dp, &
       1.200000e-01_dp,  -1.000000e+00_dp,  1.560000e+00_dp,  1.000000e+00_dp,  2.200000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  2.200000e-01_dp,  9.000000e-02_dp,  8.000000e-03_dp, &
       6.000000e-02_dp,  1.000000e-02_dp,  1.060000e+00_dp,  3.000000e-02_dp,  3.100000e-01_dp, &
       -1.000000e+00_dp,  5.700000e-01_dp,  6.000000e-02_dp,  4.000000e-02_dp,  4.700000e-01_dp, &
       7.000000e-02_dp,  1.300000e-01_dp,  3.000000e-02_dp,  -1.000000e+00_dp,  2.600000e-01_dp, &
       3.300000e-01_dp,  1.600000e-01_dp,  8.000000e-03_dp,  8.000000e-02_dp,  1.000000e-02_dp, &
       2.260000e+00_dp,  4.000000e-02_dp,  3.000000e-01_dp,  7.000000e-02_dp,  -1.000000e+00_dp, &
       5.000000e-02_dp,  7.000000e-02_dp,  1.030000e+00_dp,  1.000000e-01_dp,  1.900000e-01_dp, &
       9.000000e-02_dp,  1.100000e-01_dp,  -1.000000e+00_dp,  2.200000e-01_dp,  6.000000e-01_dp, &
       8.000000e-03_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  8.000000e-03_dp,  2.230000e+00_dp, &
       1.000000e+00_dp,  2.300000e-01_dp,  -1.000000e+00_dp,  1.770000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  8.000000e-03_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       8.000000e-03_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  3.900000e-02_dp, &
       1.080000e-01_dp,  -1.000000e+00_dp,  8.000000e-01_dp,  1.200000e-01_dp,  8.000000e-02_dp, &
       2.000000e-01_dp,  -1.000000e+00_dp,  3.900000e-02_dp,  1.080000e-01_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_2 = (/ &
       4.500000e-01_dp,  5.000000e-02_dp,  1.100000e+00_dp,  5.000000e-01_dp,  8.000000e-01_dp, &
       5.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  9.500000e-01_dp,  5.000000e-02_dp, &
       9.500000e-01_dp,  -1.000000e+00_dp,  9.500000e-01_dp,  3.900000e-02_dp,  1.080000e-01_dp, &
       4.000000e-01_dp,  -1.000000e+00_dp,  3.000000e-01_dp,  6.000000e-01_dp,  6.000000e-01_dp, &
       -1.000000e+00_dp,  3.900000e-02_dp,  1.080000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  6.900000e-01_dp,  -1.000000e+00_dp,  7.000000e-01_dp, &
       3.000000e-02_dp,  2.000000e-01_dp,  3.000000e-02_dp,  6.200000e-01_dp,  -1.000000e+00_dp, &
       7.600000e-01_dp,  8.000000e-02_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  8.000000e-02_dp, &
       -1.000000e+00_dp,  3.900000e-01_dp,  7.000000e-02_dp,  -1.000000e+00_dp,  6.000000e-01_dp, &
       2.000000e-01_dp,  1.500000e-01_dp,  6.500000e-01_dp,  2.000000e-01_dp,  -1.000000e+00_dp, &
       7.000000e-02_dp,  2.700000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  2.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp, &
       4.600000e-01_dp,  1.600000e-01_dp,  1.500000e-01_dp,  7.000000e-02_dp,  9.000000e-02_dp, &
       8.500000e-01_dp,  2.000000e-02_dp,  5.000000e-02_dp,  -1.000000e+00_dp,  1.100000e-01_dp, &
       -1.000000e+00_dp,  1.000000e-01_dp,  2.700000e-01_dp,  7.000000e-02_dp,  6.400000e-01_dp, &
       1.860000e+00_dp,  2.800000e-01_dp,  9.300000e-01_dp,  2.800000e-01_dp,  -1.000000e+00_dp, &
       9.300000e-01_dp,  7.000000e-02_dp,  -1.000000e+00_dp,  9.300000e-01_dp,  1.800000e-01_dp, &
       -1.000000e+00_dp,  6.300000e-01_dp,  9.100000e-01_dp,  9.000000e-02_dp,  9.100000e-01_dp, &
       -1.000000e+00_dp,  9.100000e-01_dp,  -1.000000e+00_dp,  1.600000e+00_dp,  8.000000e-01_dp, &
       2.000000e-01_dp,  8.000000e-01_dp,  1.200000e+00_dp,  -1.000000e+00_dp,  8.000000e-01_dp, &
       5.900000e-01_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  6.300000e-01_dp,  3.400000e-01_dp, &
       5.500000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       3.000000e-01_dp,  7.000000e-01_dp,  -7.000000e-01_dp,  -1.000000e+00_dp,  7.000000e-01_dp, &
       3.000000e-01_dp,  -7.000000e-01_dp,  4.200000e-01_dp,  1.900000e-01_dp,  4.000000e-02_dp, &
       7.700000e-01_dp,  -1.000000e+00_dp,  -7.700000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_3 = (/ &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.680000e+00_dp,  3.400000e-01_dp,  6.200000e-01_dp,  8.000000e-02_dp, &
       2.500000e-01_dp,  1.600000e-01_dp,  8.400000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       7.600000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp, &
       1.500000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.980000e+00_dp,  4.000000e-01_dp,  7.400000e-01_dp,  1.000000e-01_dp, &
       3.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  9.000000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  1.500000e+00_dp, &
       -1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  4.000000e-01_dp, &
       -1.000000e+00_dp,  4.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  3.400000e-01_dp, &
       6.600000e-01_dp,  -1.000000e+00_dp,  3.200000e-01_dp,  2.000000e-01_dp,  -1.000000e+00_dp, &
       8.000000e-01_dp,  6.000000e-01_dp,  1.250000e+00_dp,  2.400000e-01_dp,  5.700000e-01_dp, &
       6.000000e-02_dp,  2.100000e-01_dp,  -1.000000e+00_dp,  5.400000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  7.000000e-01_dp,  1.500000e-01_dp,  1.500000e-01_dp,  7.000000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(23) :: STOICM_4 = (/ &
       5.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  6.400000e-03_dp,  5.500000e-02_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.200000e-02_dp, &
       1.900000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  3.700000e-02_dp,  5.600000e-02_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.300000e-01_dp, &
       1.900000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(623) :: STOICM = (/&
    STOICM_0, STOICM_1, STOICM_2, STOICM_3, STOICM_4 /)


END MODULE CBMZ_StoichiomSP

