! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Stoichiometric Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CBMZ_Stoichiom.f90
! Time                 : Thu Oct  8 08:21:56 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CBMZ_11803_BOXMOX
! Equation file        : CBMZ.kpp
! Output root filename : CBMZ
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CBMZ_Stoichiom

  USE CBMZ_Parameters
  USE CBMZ_StoichiomSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ReactantProd - Reactant Products in each equation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      ARP       - Reactant product in each equation
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ReactantProd ( V, F, ARP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! ARP - Reactant product in each equation
  REAL(kind=dp) :: ARP(NREACT)


! Reactant Products in each equation are useful in the
!     stoichiometric formulation of mass action law
  ARP(1) = V(59)
  ARP(2) = V(60)
  ARP(3) = V(32)
  ARP(4) = V(38)
  ARP(5) = V(27)
  ARP(6) = V(21)
  ARP(7) = V(64)
  ARP(8) = V(64)
  ARP(9) = V(19)
  ARP(10) = V(47)
  ARP(11) = V(47)
  ARP(12) = V(31)
  ARP(13) = V(33)
  ARP(14) = V(54)
  ARP(15) = V(49)
  ARP(16) = V(53)
  ARP(17) = V(42)
  ARP(18) = V(66)
  ARP(19) = V(57)
  ARP(20) = V(56)
  ARP(21) = V(16)*F(2)
  ARP(22) = V(16)*F(1)
  ARP(23) = V(37)*F(2)
  ARP(24) = V(37)*V(64)
  ARP(25) = V(37)*V(59)
  ARP(26) = V(37)*V(59)
  ARP(27) = V(37)*V(63)
  ARP(28) = V(63)*V(64)
  ARP(29) = V(59)*V(64)
  ARP(30) = V(64)*V(67)
  ARP(31) = V(64)*V(65)
  ARP(32) = V(67)*F(2)
  ARP(33) = V(63)*V(67)
  ARP(34) = V(59)*V(67)
  ARP(35) = V(60)*V(67)
  ARP(36) = V(32)*V(67)
  ARP(37) = V(38)*V(67)
  ARP(38) = V(27)*V(67)
  ARP(39) = V(65)*V(67)
  ARP(40) = V(19)*V(67)
  ARP(41) = V(65)*V(65)
  ARP(42) = V(65)*V(65)*F(1)
  ARP(43) = V(63)*V(65)
  ARP(44) = V(59)*V(65)
  ARP(45) = V(59)*V(65)
  ARP(46) = V(27)
  ARP(47) = V(60)*V(63)
  ARP(48) = V(59)*V(60)
  ARP(49) = V(59)*V(60)
  ARP(50) = V(60)*V(60)
  ARP(51) = V(60)*V(65)
  ARP(52) = V(21)*F(1)
  ARP(53) = V(21)
  ARP(54) = V(39)*V(67)
  ARP(55) = V(15)*V(67)
  ARP(56) = V(23)*V(67)
  ARP(57) = V(28)*V(67)
  ARP(58) = V(41)*V(67)
  ARP(59) = V(47)*V(67)
  ARP(60) = V(47)*V(60)
  ARP(61) = V(54)*V(67)
  ARP(62) = V(54)*V(60)
  ARP(63) = V(49)*V(67)
  ARP(64) = V(53)*V(67)
  ARP(65) = V(53)*V(60)
  ARP(66) = V(34)*V(64)
  ARP(67) = V(34)*V(67)
  ARP(68) = V(45)*V(64)
  ARP(69) = V(50)*V(64)
  ARP(70) = V(45)*V(67)
  ARP(71) = V(50)*V(67)
  ARP(72) = V(45)*V(60)
  ARP(73) = V(50)*V(60)
  ARP(74) = V(20)*V(67)
  ARP(75) = V(22)*V(67)
  ARP(76) = V(29)*V(63)
  ARP(77) = V(36)*V(67)
  ARP(78) = V(36)*V(60)
  ARP(79) = V(24)*V(59)
  ARP(80) = V(42)*V(67)
  ARP(81) = V(42)*V(64)
  ARP(82) = V(46)*V(67)
  ARP(83) = V(46)*V(64)
  ARP(84) = V(46)*V(60)
  ARP(85) = V(56)*V(67)
  ARP(86) = V(56)*V(64)
  ARP(87) = V(56)*V(60)
  ARP(88) = V(43)*V(63)
  ARP(89) = V(40)*V(63)
  ARP(90) = V(44)*V(63)
  ARP(91) = V(43)*V(65)
  ARP(92) = V(40)*V(65)
  ARP(93) = V(44)*V(65)
  ARP(94) = V(31)*V(67)
  ARP(95) = V(33)*V(67)
  ARP(96) = V(66)*V(67)
  ARP(97) = V(57)*V(67)
  ARP(98) = V(58)*V(59)
  ARP(99) = V(18)
  ARP(100) = V(35)*V(67)
  ARP(101) = V(55)*V(63)
  ARP(102) = V(52)*V(63)
  ARP(103) = V(61)*V(63)
  ARP(104) = V(58)*V(63)
  ARP(105) = V(62)*V(63)
  ARP(106) = V(51)*V(63)
  ARP(107) = V(48)*V(63)
  ARP(108) = V(55)*V(60)
  ARP(109) = V(52)*V(60)
  ARP(110) = V(60)*V(61)
  ARP(111) = V(58)*V(60)
  ARP(112) = V(60)*V(62)
  ARP(113) = V(51)*V(60)
  ARP(114) = V(48)*V(60)
  ARP(115) = V(55)*V(65)
  ARP(116) = V(52)*V(65)
  ARP(117) = V(61)*V(65)
  ARP(118) = V(58)*V(65)
  ARP(119) = V(62)*V(65)
  ARP(120) = V(51)*V(65)
  ARP(121) = V(48)*V(65)
  ARP(122) = V(17)*V(67)
  ARP(123) = V(30)*V(41)
  ARP(124) = V(2)
  ARP(125) = V(3)
  ARP(126) = V(1)
  ARP(127) = V(55)
  ARP(128) = V(52)
  ARP(129) = V(61)
  ARP(130) = V(58)
  ARP(131) = V(62)
  ARP(132) = V(51)
  ARP(133) = V(43)
  ARP(134) = V(40)
  ARP(135) = V(44)
  ARP(136) = V(48)
  ARP(137) = V(25)*V(67)
  ARP(138) = V(25)*V(60)
  ARP(139) = V(25)*V(64)
  ARP(140) = V(26)*V(67)
  ARP(141) = V(26)*V(60)
  ARP(142) = V(26)*V(64)
      
END SUBROUTINE ReactantProd

! End of ReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacReactantProd - Jacobian of Reactant Products vector
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      JVRP      - d ARP(1:NREACT)/d VAR (1:NVAR)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacReactantProd ( V, F, JVRP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! JVRP - d ARP(1:NREACT)/d VAR (1:NVAR)
  REAL(kind=dp) :: JVRP(NJVRP)


! Reactant Products in each equation are useful in the
!    stoichiometric formulation of mass action law
! Below we compute the Jacobian of the Reactant Products vector
!    w.r.t. variable species: d ARP(1:NREACT) / d Var(1:NVAR)

! JVRP(1) = dARP(1)/dV(59)
  JVRP(1) = 1
! JVRP(2) = dARP(2)/dV(60)
  JVRP(2) = 1
! JVRP(3) = dARP(3)/dV(32)
  JVRP(3) = 1
! JVRP(4) = dARP(4)/dV(38)
  JVRP(4) = 1
! JVRP(5) = dARP(5)/dV(27)
  JVRP(5) = 1
! JVRP(6) = dARP(6)/dV(21)
  JVRP(6) = 1
! JVRP(7) = dARP(7)/dV(64)
  JVRP(7) = 1
! JVRP(8) = dARP(8)/dV(64)
  JVRP(8) = 1
! JVRP(9) = dARP(9)/dV(19)
  JVRP(9) = 1
! JVRP(10) = dARP(10)/dV(47)
  JVRP(10) = 1
! JVRP(11) = dARP(11)/dV(47)
  JVRP(11) = 1
! JVRP(12) = dARP(12)/dV(31)
  JVRP(12) = 1
! JVRP(13) = dARP(13)/dV(33)
  JVRP(13) = 1
! JVRP(14) = dARP(14)/dV(54)
  JVRP(14) = 1
! JVRP(15) = dARP(15)/dV(49)
  JVRP(15) = 1
! JVRP(16) = dARP(16)/dV(53)
  JVRP(16) = 1
! JVRP(17) = dARP(17)/dV(42)
  JVRP(17) = 1
! JVRP(18) = dARP(18)/dV(66)
  JVRP(18) = 1
! JVRP(19) = dARP(19)/dV(57)
  JVRP(19) = 1
! JVRP(20) = dARP(20)/dV(56)
  JVRP(20) = 1
! JVRP(21) = dARP(21)/dV(16)
  JVRP(21) = F(2)
! JVRP(22) = dARP(22)/dV(16)
  JVRP(22) = F(1)
! JVRP(23) = dARP(23)/dV(37)
  JVRP(23) = F(2)
! JVRP(24) = dARP(24)/dV(37)
  JVRP(24) = V(64)
! JVRP(25) = dARP(24)/dV(64)
  JVRP(25) = V(37)
! JVRP(26) = dARP(25)/dV(37)
  JVRP(26) = V(59)
! JVRP(27) = dARP(25)/dV(59)
  JVRP(27) = V(37)
! JVRP(28) = dARP(26)/dV(37)
  JVRP(28) = V(59)
! JVRP(29) = dARP(26)/dV(59)
  JVRP(29) = V(37)
! JVRP(30) = dARP(27)/dV(37)
  JVRP(30) = V(63)
! JVRP(31) = dARP(27)/dV(63)
  JVRP(31) = V(37)
! JVRP(32) = dARP(28)/dV(63)
  JVRP(32) = V(64)
! JVRP(33) = dARP(28)/dV(64)
  JVRP(33) = V(63)
! JVRP(34) = dARP(29)/dV(59)
  JVRP(34) = V(64)
! JVRP(35) = dARP(29)/dV(64)
  JVRP(35) = V(59)
! JVRP(36) = dARP(30)/dV(64)
  JVRP(36) = V(67)
! JVRP(37) = dARP(30)/dV(67)
  JVRP(37) = V(64)
! JVRP(38) = dARP(31)/dV(64)
  JVRP(38) = V(65)
! JVRP(39) = dARP(31)/dV(65)
  JVRP(39) = V(64)
! JVRP(40) = dARP(32)/dV(67)
  JVRP(40) = F(2)
! JVRP(41) = dARP(33)/dV(63)
  JVRP(41) = V(67)
! JVRP(42) = dARP(33)/dV(67)
  JVRP(42) = V(63)
! JVRP(43) = dARP(34)/dV(59)
  JVRP(43) = V(67)
! JVRP(44) = dARP(34)/dV(67)
  JVRP(44) = V(59)
! JVRP(45) = dARP(35)/dV(60)
  JVRP(45) = V(67)
! JVRP(46) = dARP(35)/dV(67)
  JVRP(46) = V(60)
! JVRP(47) = dARP(36)/dV(32)
  JVRP(47) = V(67)
! JVRP(48) = dARP(36)/dV(67)
  JVRP(48) = V(32)
! JVRP(49) = dARP(37)/dV(38)
  JVRP(49) = V(67)
! JVRP(50) = dARP(37)/dV(67)
  JVRP(50) = V(38)
! JVRP(51) = dARP(38)/dV(27)
  JVRP(51) = V(67)
! JVRP(52) = dARP(38)/dV(67)
  JVRP(52) = V(27)
! JVRP(53) = dARP(39)/dV(65)
  JVRP(53) = V(67)
! JVRP(54) = dARP(39)/dV(67)
  JVRP(54) = V(65)
! JVRP(55) = dARP(40)/dV(19)
  JVRP(55) = V(67)
! JVRP(56) = dARP(40)/dV(67)
  JVRP(56) = V(19)
! JVRP(57) = dARP(41)/dV(65)
  JVRP(57) = 2*V(65)
! JVRP(58) = dARP(42)/dV(65)
  JVRP(58) = 2*V(65)*F(1)
! JVRP(59) = dARP(43)/dV(63)
  JVRP(59) = V(65)
! JVRP(60) = dARP(43)/dV(65)
  JVRP(60) = V(63)
! JVRP(61) = dARP(44)/dV(59)
  JVRP(61) = V(65)
! JVRP(62) = dARP(44)/dV(65)
  JVRP(62) = V(59)
! JVRP(63) = dARP(45)/dV(59)
  JVRP(63) = V(65)
! JVRP(64) = dARP(45)/dV(65)
  JVRP(64) = V(59)
! JVRP(65) = dARP(46)/dV(27)
  JVRP(65) = 1
! JVRP(66) = dARP(47)/dV(60)
  JVRP(66) = V(63)
! JVRP(67) = dARP(47)/dV(63)
  JVRP(67) = V(60)
! JVRP(68) = dARP(48)/dV(59)
  JVRP(68) = V(60)
! JVRP(69) = dARP(48)/dV(60)
  JVRP(69) = V(59)
! JVRP(70) = dARP(49)/dV(59)
  JVRP(70) = V(60)
! JVRP(71) = dARP(49)/dV(60)
  JVRP(71) = V(59)
! JVRP(72) = dARP(50)/dV(60)
  JVRP(72) = 2*V(60)
! JVRP(73) = dARP(51)/dV(60)
  JVRP(73) = V(65)
! JVRP(74) = dARP(51)/dV(65)
  JVRP(74) = V(60)
! JVRP(75) = dARP(52)/dV(21)
  JVRP(75) = F(1)
! JVRP(76) = dARP(53)/dV(21)
  JVRP(76) = 1
! JVRP(77) = dARP(54)/dV(39)
  JVRP(77) = V(67)
! JVRP(78) = dARP(54)/dV(67)
  JVRP(78) = V(39)
! JVRP(79) = dARP(55)/dV(15)
  JVRP(79) = V(67)
! JVRP(80) = dARP(55)/dV(67)
  JVRP(80) = V(15)
! JVRP(81) = dARP(56)/dV(23)
  JVRP(81) = V(67)
! JVRP(82) = dARP(56)/dV(67)
  JVRP(82) = V(23)
! JVRP(83) = dARP(57)/dV(28)
  JVRP(83) = V(67)
! JVRP(84) = dARP(57)/dV(67)
  JVRP(84) = V(28)
! JVRP(85) = dARP(58)/dV(41)
  JVRP(85) = V(67)
! JVRP(86) = dARP(58)/dV(67)
  JVRP(86) = V(41)
! JVRP(87) = dARP(59)/dV(47)
  JVRP(87) = V(67)
! JVRP(88) = dARP(59)/dV(67)
  JVRP(88) = V(47)
! JVRP(89) = dARP(60)/dV(47)
  JVRP(89) = V(60)
! JVRP(90) = dARP(60)/dV(60)
  JVRP(90) = V(47)
! JVRP(91) = dARP(61)/dV(54)
  JVRP(91) = V(67)
! JVRP(92) = dARP(61)/dV(67)
  JVRP(92) = V(54)
! JVRP(93) = dARP(62)/dV(54)
  JVRP(93) = V(60)
! JVRP(94) = dARP(62)/dV(60)
  JVRP(94) = V(54)
! JVRP(95) = dARP(63)/dV(49)
  JVRP(95) = V(67)
! JVRP(96) = dARP(63)/dV(67)
  JVRP(96) = V(49)
! JVRP(97) = dARP(64)/dV(53)
  JVRP(97) = V(67)
! JVRP(98) = dARP(64)/dV(67)
  JVRP(98) = V(53)
! JVRP(99) = dARP(65)/dV(53)
  JVRP(99) = V(60)
! JVRP(100) = dARP(65)/dV(60)
  JVRP(100) = V(53)
! JVRP(101) = dARP(66)/dV(34)
  JVRP(101) = V(64)
! JVRP(102) = dARP(66)/dV(64)
  JVRP(102) = V(34)
! JVRP(103) = dARP(67)/dV(34)
  JVRP(103) = V(67)
! JVRP(104) = dARP(67)/dV(67)
  JVRP(104) = V(34)
! JVRP(105) = dARP(68)/dV(45)
  JVRP(105) = V(64)
! JVRP(106) = dARP(68)/dV(64)
  JVRP(106) = V(45)
! JVRP(107) = dARP(69)/dV(50)
  JVRP(107) = V(64)
! JVRP(108) = dARP(69)/dV(64)
  JVRP(108) = V(50)
! JVRP(109) = dARP(70)/dV(45)
  JVRP(109) = V(67)
! JVRP(110) = dARP(70)/dV(67)
  JVRP(110) = V(45)
! JVRP(111) = dARP(71)/dV(50)
  JVRP(111) = V(67)
! JVRP(112) = dARP(71)/dV(67)
  JVRP(112) = V(50)
! JVRP(113) = dARP(72)/dV(45)
  JVRP(113) = V(60)
! JVRP(114) = dARP(72)/dV(60)
  JVRP(114) = V(45)
! JVRP(115) = dARP(73)/dV(50)
  JVRP(115) = V(60)
! JVRP(116) = dARP(73)/dV(60)
  JVRP(116) = V(50)
! JVRP(117) = dARP(74)/dV(20)
  JVRP(117) = V(67)
! JVRP(118) = dARP(74)/dV(67)
  JVRP(118) = V(20)
! JVRP(119) = dARP(75)/dV(22)
  JVRP(119) = V(67)
! JVRP(120) = dARP(75)/dV(67)
  JVRP(120) = V(22)
! JVRP(121) = dARP(76)/dV(29)
  JVRP(121) = V(63)
! JVRP(122) = dARP(76)/dV(63)
  JVRP(122) = V(29)
! JVRP(123) = dARP(77)/dV(36)
  JVRP(123) = V(67)
! JVRP(124) = dARP(77)/dV(67)
  JVRP(124) = V(36)
! JVRP(125) = dARP(78)/dV(36)
  JVRP(125) = V(60)
! JVRP(126) = dARP(78)/dV(60)
  JVRP(126) = V(36)
! JVRP(127) = dARP(79)/dV(24)
  JVRP(127) = V(59)
! JVRP(128) = dARP(79)/dV(59)
  JVRP(128) = V(24)
! JVRP(129) = dARP(80)/dV(42)
  JVRP(129) = V(67)
! JVRP(130) = dARP(80)/dV(67)
  JVRP(130) = V(42)
! JVRP(131) = dARP(81)/dV(42)
  JVRP(131) = V(64)
! JVRP(132) = dARP(81)/dV(64)
  JVRP(132) = V(42)
! JVRP(133) = dARP(82)/dV(46)
  JVRP(133) = V(67)
! JVRP(134) = dARP(82)/dV(67)
  JVRP(134) = V(46)
! JVRP(135) = dARP(83)/dV(46)
  JVRP(135) = V(64)
! JVRP(136) = dARP(83)/dV(64)
  JVRP(136) = V(46)
! JVRP(137) = dARP(84)/dV(46)
  JVRP(137) = V(60)
! JVRP(138) = dARP(84)/dV(60)
  JVRP(138) = V(46)
! JVRP(139) = dARP(85)/dV(56)
  JVRP(139) = V(67)
! JVRP(140) = dARP(85)/dV(67)
  JVRP(140) = V(56)
! JVRP(141) = dARP(86)/dV(56)
  JVRP(141) = V(64)
! JVRP(142) = dARP(86)/dV(64)
  JVRP(142) = V(56)
! JVRP(143) = dARP(87)/dV(56)
  JVRP(143) = V(60)
! JVRP(144) = dARP(87)/dV(60)
  JVRP(144) = V(56)
! JVRP(145) = dARP(88)/dV(43)
  JVRP(145) = V(63)
! JVRP(146) = dARP(88)/dV(63)
  JVRP(146) = V(43)
! JVRP(147) = dARP(89)/dV(40)
  JVRP(147) = V(63)
! JVRP(148) = dARP(89)/dV(63)
  JVRP(148) = V(40)
! JVRP(149) = dARP(90)/dV(44)
  JVRP(149) = V(63)
! JVRP(150) = dARP(90)/dV(63)
  JVRP(150) = V(44)
! JVRP(151) = dARP(91)/dV(43)
  JVRP(151) = V(65)
! JVRP(152) = dARP(91)/dV(65)
  JVRP(152) = V(43)
! JVRP(153) = dARP(92)/dV(40)
  JVRP(153) = V(65)
! JVRP(154) = dARP(92)/dV(65)
  JVRP(154) = V(40)
! JVRP(155) = dARP(93)/dV(44)
  JVRP(155) = V(65)
! JVRP(156) = dARP(93)/dV(65)
  JVRP(156) = V(44)
! JVRP(157) = dARP(94)/dV(31)
  JVRP(157) = V(67)
! JVRP(158) = dARP(94)/dV(67)
  JVRP(158) = V(31)
! JVRP(159) = dARP(95)/dV(33)
  JVRP(159) = V(67)
! JVRP(160) = dARP(95)/dV(67)
  JVRP(160) = V(33)
! JVRP(161) = dARP(96)/dV(66)
  JVRP(161) = V(67)
! JVRP(162) = dARP(96)/dV(67)
  JVRP(162) = V(66)
! JVRP(163) = dARP(97)/dV(57)
  JVRP(163) = V(67)
! JVRP(164) = dARP(97)/dV(67)
  JVRP(164) = V(57)
! JVRP(165) = dARP(98)/dV(58)
  JVRP(165) = V(59)
! JVRP(166) = dARP(98)/dV(59)
  JVRP(166) = V(58)
! JVRP(167) = dARP(99)/dV(18)
  JVRP(167) = 1
! JVRP(168) = dARP(100)/dV(35)
  JVRP(168) = V(67)
! JVRP(169) = dARP(100)/dV(67)
  JVRP(169) = V(35)
! JVRP(170) = dARP(101)/dV(55)
  JVRP(170) = V(63)
! JVRP(171) = dARP(101)/dV(63)
  JVRP(171) = V(55)
! JVRP(172) = dARP(102)/dV(52)
  JVRP(172) = V(63)
! JVRP(173) = dARP(102)/dV(63)
  JVRP(173) = V(52)
! JVRP(174) = dARP(103)/dV(61)
  JVRP(174) = V(63)
! JVRP(175) = dARP(103)/dV(63)
  JVRP(175) = V(61)
! JVRP(176) = dARP(104)/dV(58)
  JVRP(176) = V(63)
! JVRP(177) = dARP(104)/dV(63)
  JVRP(177) = V(58)
! JVRP(178) = dARP(105)/dV(62)
  JVRP(178) = V(63)
! JVRP(179) = dARP(105)/dV(63)
  JVRP(179) = V(62)
! JVRP(180) = dARP(106)/dV(51)
  JVRP(180) = V(63)
! JVRP(181) = dARP(106)/dV(63)
  JVRP(181) = V(51)
! JVRP(182) = dARP(107)/dV(48)
  JVRP(182) = V(63)
! JVRP(183) = dARP(107)/dV(63)
  JVRP(183) = V(48)
! JVRP(184) = dARP(108)/dV(55)
  JVRP(184) = V(60)
! JVRP(185) = dARP(108)/dV(60)
  JVRP(185) = V(55)
! JVRP(186) = dARP(109)/dV(52)
  JVRP(186) = V(60)
! JVRP(187) = dARP(109)/dV(60)
  JVRP(187) = V(52)
! JVRP(188) = dARP(110)/dV(60)
  JVRP(188) = V(61)
! JVRP(189) = dARP(110)/dV(61)
  JVRP(189) = V(60)
! JVRP(190) = dARP(111)/dV(58)
  JVRP(190) = V(60)
! JVRP(191) = dARP(111)/dV(60)
  JVRP(191) = V(58)
! JVRP(192) = dARP(112)/dV(60)
  JVRP(192) = V(62)
! JVRP(193) = dARP(112)/dV(62)
  JVRP(193) = V(60)
! JVRP(194) = dARP(113)/dV(51)
  JVRP(194) = V(60)
! JVRP(195) = dARP(113)/dV(60)
  JVRP(195) = V(51)
! JVRP(196) = dARP(114)/dV(48)
  JVRP(196) = V(60)
! JVRP(197) = dARP(114)/dV(60)
  JVRP(197) = V(48)
! JVRP(198) = dARP(115)/dV(55)
  JVRP(198) = V(65)
! JVRP(199) = dARP(115)/dV(65)
  JVRP(199) = V(55)
! JVRP(200) = dARP(116)/dV(52)
  JVRP(200) = V(65)
! JVRP(201) = dARP(116)/dV(65)
  JVRP(201) = V(52)
! JVRP(202) = dARP(117)/dV(61)
  JVRP(202) = V(65)
! JVRP(203) = dARP(117)/dV(65)
  JVRP(203) = V(61)
! JVRP(204) = dARP(118)/dV(58)
  JVRP(204) = V(65)
! JVRP(205) = dARP(118)/dV(65)
  JVRP(205) = V(58)
! JVRP(206) = dARP(119)/dV(62)
  JVRP(206) = V(65)
! JVRP(207) = dARP(119)/dV(65)
  JVRP(207) = V(62)
! JVRP(208) = dARP(120)/dV(51)
  JVRP(208) = V(65)
! JVRP(209) = dARP(120)/dV(65)
  JVRP(209) = V(51)
! JVRP(210) = dARP(121)/dV(48)
  JVRP(210) = V(65)
! JVRP(211) = dARP(121)/dV(65)
  JVRP(211) = V(48)
! JVRP(212) = dARP(122)/dV(17)
  JVRP(212) = V(67)
! JVRP(213) = dARP(122)/dV(67)
  JVRP(213) = V(17)
! JVRP(214) = dARP(123)/dV(30)
  JVRP(214) = V(41)
! JVRP(215) = dARP(123)/dV(41)
  JVRP(215) = V(30)
! JVRP(216) = dARP(124)/dV(2)
  JVRP(216) = 1
! JVRP(217) = dARP(125)/dV(3)
  JVRP(217) = 1
! JVRP(218) = dARP(126)/dV(1)
  JVRP(218) = 1
! JVRP(219) = dARP(127)/dV(55)
  JVRP(219) = 1
! JVRP(220) = dARP(128)/dV(52)
  JVRP(220) = 1
! JVRP(221) = dARP(129)/dV(61)
  JVRP(221) = 1
! JVRP(222) = dARP(130)/dV(58)
  JVRP(222) = 1
! JVRP(223) = dARP(131)/dV(62)
  JVRP(223) = 1
! JVRP(224) = dARP(132)/dV(51)
  JVRP(224) = 1
! JVRP(225) = dARP(133)/dV(43)
  JVRP(225) = 1
! JVRP(226) = dARP(134)/dV(40)
  JVRP(226) = 1
! JVRP(227) = dARP(135)/dV(44)
  JVRP(227) = 1
! JVRP(228) = dARP(136)/dV(48)
  JVRP(228) = 1
! JVRP(229) = dARP(137)/dV(25)
  JVRP(229) = V(67)
! JVRP(230) = dARP(137)/dV(67)
  JVRP(230) = V(25)
! JVRP(231) = dARP(138)/dV(25)
  JVRP(231) = V(60)
! JVRP(232) = dARP(138)/dV(60)
  JVRP(232) = V(25)
! JVRP(233) = dARP(139)/dV(25)
  JVRP(233) = V(64)
! JVRP(234) = dARP(139)/dV(64)
  JVRP(234) = V(25)
! JVRP(235) = dARP(140)/dV(26)
  JVRP(235) = V(67)
! JVRP(236) = dARP(140)/dV(67)
  JVRP(236) = V(26)
! JVRP(237) = dARP(141)/dV(26)
  JVRP(237) = V(60)
! JVRP(238) = dARP(141)/dV(60)
  JVRP(238) = V(26)
! JVRP(239) = dARP(142)/dV(26)
  JVRP(239) = V(64)
! JVRP(240) = dARP(142)/dV(64)
  JVRP(240) = V(26)
      
END SUBROUTINE JacReactantProd

! End of JacReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



! Begin Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Fun with respect to rate coefficients
! -----------------------------------------------------------------------------

      SUBROUTINE  dFun_dRcoeff( V, F, NCOEFF, JCOEFF, DFDR )
       
      USE CBMZ_Parameters
      USE CBMZ_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/radical/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Fun(1:NVAR) / d RCT( JCOEFF(j) )
!         for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DFDR(NVAR*NCOEFF)

! Local vector with reactant products
      REAL(kind=dp) A_RPROD(NREACT)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the reactant products of all reactions     
      CALL ReactantProd ( V, F, A_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_RPROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DFDR(i+NVAR*(j-1)) = 0.0_dp 
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  reactant product  of the JCOEFF(j)-th reaction      
!                  give the j-th column of the derivative matrix   
         aj = A_RPROD(JCOEFF(j))
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DFDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dFun_dRcoeff

! End Derivative w.r.t. Rate Coefficients


! Begin Jacobian Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Jac with respect to rate coefficients
! Times a user vector
! -----------------------------------------------------------------------------

      SUBROUTINE  dJac_dRcoeff( V, F, U, NCOEFF, JCOEFF, DJDR )
       
      USE CBMZ_Parameters
      USE CBMZ_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! U - User-supplied Vector           
      REAL(kind=dp) U(NVAR)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Jac(1:NVAR) / d RCT( JCOEFF(j) ) * U
!                     for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DJDR(NVAR*NCOEFF)

! Local vector for Jacobian of reactant products
      REAL(kind=dp) JV_RPROD(NJVRP)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the Jacobian of all reactant products   
      CALL JacReactantProd( V, F, JV_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_PROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DJDR(i+NVAR*(j-1)) = 0.0_dp
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  ( Gradient of reactant product of the JCOEFF(j)-th reaction X user vector )    
!                  give the j-th column of the derivative matrix   
!
!          Row JCOEFF(j) of JV_RPROD times the user vector
         aj = 0.0_dp
         DO k=CROW_JVRP(JCOEFF(j)),CROW_JVRP(JCOEFF(j)+1)-1
             aj = aj + JV_RPROD(k)*U(ICOL_JVRP(k))
         END DO
!          Column JCOEFF(j) of Stoichiom. matrix times aj         
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DJDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dJac_dRcoeff

! End Jacobian Derivative w.r.t. Rate Coefficients


END MODULE CBMZ_Stoichiom

