! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Jacobian of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CBMZ_Jacobian.f90
! Time                 : Thu Oct  8 08:21:56 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CBMZ_11803_BOXMOX
! Equation file        : CBMZ.kpp
! Output root filename : CBMZ
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CBMZ_Jacobian

  USE CBMZ_Parameters
  USE CBMZ_JacobianSP

  USE CBMZ_Global

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP - the Jacobian of Variables in sparse matrix representation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      JVS       - sparse Jacobian of variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP ( V, F, RCT, JVS )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)


! Local variables
! B - Temporary array
  REAL(kind=dp) :: B(246)

! B(1) = dA(1)/dV(59)
  B(1) = RCT(1)
! B(2) = dA(2)/dV(60)
  B(2) = RCT(2)
! B(3) = dA(3)/dV(32)
  B(3) = RCT(3)
! B(4) = dA(4)/dV(38)
  B(4) = RCT(4)
! B(5) = dA(5)/dV(27)
  B(5) = RCT(5)
! B(6) = dA(6)/dV(21)
  B(6) = RCT(6)
! B(7) = dA(7)/dV(64)
  B(7) = RCT(7)
! B(8) = dA(8)/dV(64)
  B(8) = RCT(8)
! B(9) = dA(9)/dV(19)
  B(9) = RCT(9)
! B(10) = dA(10)/dV(47)
  B(10) = RCT(10)
! B(11) = dA(11)/dV(47)
  B(11) = RCT(11)
! B(12) = dA(12)/dV(31)
  B(12) = RCT(12)
! B(13) = dA(13)/dV(33)
  B(13) = RCT(13)
! B(14) = dA(14)/dV(54)
  B(14) = RCT(14)
! B(15) = dA(15)/dV(49)
  B(15) = RCT(15)
! B(16) = dA(16)/dV(53)
  B(16) = RCT(16)
! B(17) = dA(17)/dV(42)
  B(17) = RCT(17)
! B(18) = dA(18)/dV(66)
  B(18) = RCT(18)
! B(19) = dA(19)/dV(57)
  B(19) = RCT(19)
! B(20) = dA(20)/dV(56)
  B(20) = RCT(20)
! B(21) = dA(21)/dV(16)
  B(21) = RCT(21)*F(2)
! B(23) = dA(22)/dV(16)
  B(23) = RCT(22)*F(1)
! B(25) = dA(23)/dV(37)
  B(25) = RCT(23)*F(2)
! B(27) = dA(24)/dV(37)
  B(27) = RCT(24)*V(64)
! B(28) = dA(24)/dV(64)
  B(28) = RCT(24)*V(37)
! B(29) = dA(25)/dV(37)
  B(29) = RCT(25)*V(59)
! B(30) = dA(25)/dV(59)
  B(30) = RCT(25)*V(37)
! B(31) = dA(26)/dV(37)
  B(31) = RCT(26)*V(59)
! B(32) = dA(26)/dV(59)
  B(32) = RCT(26)*V(37)
! B(33) = dA(27)/dV(37)
  B(33) = RCT(27)*V(63)
! B(34) = dA(27)/dV(63)
  B(34) = RCT(27)*V(37)
! B(35) = dA(28)/dV(63)
  B(35) = RCT(28)*V(64)
! B(36) = dA(28)/dV(64)
  B(36) = RCT(28)*V(63)
! B(37) = dA(29)/dV(59)
  B(37) = RCT(29)*V(64)
! B(38) = dA(29)/dV(64)
  B(38) = RCT(29)*V(59)
! B(39) = dA(30)/dV(64)
  B(39) = RCT(30)*V(67)
! B(40) = dA(30)/dV(67)
  B(40) = RCT(30)*V(64)
! B(41) = dA(31)/dV(64)
  B(41) = RCT(31)*V(65)
! B(42) = dA(31)/dV(65)
  B(42) = RCT(31)*V(64)
! B(43) = dA(32)/dV(67)
  B(43) = RCT(32)*F(2)
! B(45) = dA(33)/dV(63)
  B(45) = RCT(33)*V(67)
! B(46) = dA(33)/dV(67)
  B(46) = RCT(33)*V(63)
! B(47) = dA(34)/dV(59)
  B(47) = RCT(34)*V(67)
! B(48) = dA(34)/dV(67)
  B(48) = RCT(34)*V(59)
! B(49) = dA(35)/dV(60)
  B(49) = RCT(35)*V(67)
! B(50) = dA(35)/dV(67)
  B(50) = RCT(35)*V(60)
! B(51) = dA(36)/dV(32)
  B(51) = RCT(36)*V(67)
! B(52) = dA(36)/dV(67)
  B(52) = RCT(36)*V(32)
! B(53) = dA(37)/dV(38)
  B(53) = RCT(37)*V(67)
! B(54) = dA(37)/dV(67)
  B(54) = RCT(37)*V(38)
! B(55) = dA(38)/dV(27)
  B(55) = RCT(38)*V(67)
! B(56) = dA(38)/dV(67)
  B(56) = RCT(38)*V(27)
! B(57) = dA(39)/dV(65)
  B(57) = RCT(39)*V(67)
! B(58) = dA(39)/dV(67)
  B(58) = RCT(39)*V(65)
! B(59) = dA(40)/dV(19)
  B(59) = RCT(40)*V(67)
! B(60) = dA(40)/dV(67)
  B(60) = RCT(40)*V(19)
! B(61) = dA(41)/dV(65)
  B(61) = RCT(41)*2*V(65)
! B(62) = dA(42)/dV(65)
  B(62) = RCT(42)*2*V(65)*F(1)
! B(64) = dA(43)/dV(63)
  B(64) = RCT(43)*V(65)
! B(65) = dA(43)/dV(65)
  B(65) = RCT(43)*V(63)
! B(66) = dA(44)/dV(59)
  B(66) = RCT(44)*V(65)
! B(67) = dA(44)/dV(65)
  B(67) = RCT(44)*V(59)
! B(68) = dA(45)/dV(59)
  B(68) = RCT(45)*V(65)
! B(69) = dA(45)/dV(65)
  B(69) = RCT(45)*V(59)
! B(70) = dA(46)/dV(27)
  B(70) = RCT(46)
! B(71) = dA(47)/dV(60)
  B(71) = RCT(47)*V(63)
! B(72) = dA(47)/dV(63)
  B(72) = RCT(47)*V(60)
! B(73) = dA(48)/dV(59)
  B(73) = RCT(48)*V(60)
! B(74) = dA(48)/dV(60)
  B(74) = RCT(48)*V(59)
! B(75) = dA(49)/dV(59)
  B(75) = RCT(49)*V(60)
! B(76) = dA(49)/dV(60)
  B(76) = RCT(49)*V(59)
! B(77) = dA(50)/dV(60)
  B(77) = RCT(50)*2*V(60)
! B(78) = dA(51)/dV(60)
  B(78) = RCT(51)*V(65)
! B(79) = dA(51)/dV(65)
  B(79) = RCT(51)*V(60)
! B(80) = dA(52)/dV(21)
  B(80) = RCT(52)*F(1)
! B(82) = dA(53)/dV(21)
  B(82) = RCT(53)
! B(83) = dA(54)/dV(39)
  B(83) = RCT(54)*V(67)
! B(84) = dA(54)/dV(67)
  B(84) = RCT(54)*V(39)
! B(85) = dA(55)/dV(15)
  B(85) = RCT(55)*V(67)
! B(86) = dA(55)/dV(67)
  B(86) = RCT(55)*V(15)
! B(87) = dA(56)/dV(23)
  B(87) = RCT(56)*V(67)
! B(88) = dA(56)/dV(67)
  B(88) = RCT(56)*V(23)
! B(89) = dA(57)/dV(28)
  B(89) = RCT(57)*V(67)
! B(90) = dA(57)/dV(67)
  B(90) = RCT(57)*V(28)
! B(91) = dA(58)/dV(41)
  B(91) = RCT(58)*V(67)
! B(92) = dA(58)/dV(67)
  B(92) = RCT(58)*V(41)
! B(93) = dA(59)/dV(47)
  B(93) = RCT(59)*V(67)
! B(94) = dA(59)/dV(67)
  B(94) = RCT(59)*V(47)
! B(95) = dA(60)/dV(47)
  B(95) = RCT(60)*V(60)
! B(96) = dA(60)/dV(60)
  B(96) = RCT(60)*V(47)
! B(97) = dA(61)/dV(54)
  B(97) = RCT(61)*V(67)
! B(98) = dA(61)/dV(67)
  B(98) = RCT(61)*V(54)
! B(99) = dA(62)/dV(54)
  B(99) = RCT(62)*V(60)
! B(100) = dA(62)/dV(60)
  B(100) = RCT(62)*V(54)
! B(101) = dA(63)/dV(49)
  B(101) = RCT(63)*V(67)
! B(102) = dA(63)/dV(67)
  B(102) = RCT(63)*V(49)
! B(103) = dA(64)/dV(53)
  B(103) = RCT(64)*V(67)
! B(104) = dA(64)/dV(67)
  B(104) = RCT(64)*V(53)
! B(105) = dA(65)/dV(53)
  B(105) = RCT(65)*V(60)
! B(106) = dA(65)/dV(60)
  B(106) = RCT(65)*V(53)
! B(107) = dA(66)/dV(34)
  B(107) = RCT(66)*V(64)
! B(108) = dA(66)/dV(64)
  B(108) = RCT(66)*V(34)
! B(109) = dA(67)/dV(34)
  B(109) = RCT(67)*V(67)
! B(110) = dA(67)/dV(67)
  B(110) = RCT(67)*V(34)
! B(111) = dA(68)/dV(45)
  B(111) = RCT(68)*V(64)
! B(112) = dA(68)/dV(64)
  B(112) = RCT(68)*V(45)
! B(113) = dA(69)/dV(50)
  B(113) = RCT(69)*V(64)
! B(114) = dA(69)/dV(64)
  B(114) = RCT(69)*V(50)
! B(115) = dA(70)/dV(45)
  B(115) = RCT(70)*V(67)
! B(116) = dA(70)/dV(67)
  B(116) = RCT(70)*V(45)
! B(117) = dA(71)/dV(50)
  B(117) = RCT(71)*V(67)
! B(118) = dA(71)/dV(67)
  B(118) = RCT(71)*V(50)
! B(119) = dA(72)/dV(45)
  B(119) = RCT(72)*V(60)
! B(120) = dA(72)/dV(60)
  B(120) = RCT(72)*V(45)
! B(121) = dA(73)/dV(50)
  B(121) = RCT(73)*V(60)
! B(122) = dA(73)/dV(60)
  B(122) = RCT(73)*V(50)
! B(123) = dA(74)/dV(20)
  B(123) = RCT(74)*V(67)
! B(124) = dA(74)/dV(67)
  B(124) = RCT(74)*V(20)
! B(125) = dA(75)/dV(22)
  B(125) = RCT(75)*V(67)
! B(126) = dA(75)/dV(67)
  B(126) = RCT(75)*V(22)
! B(127) = dA(76)/dV(29)
  B(127) = RCT(76)*V(63)
! B(128) = dA(76)/dV(63)
  B(128) = RCT(76)*V(29)
! B(129) = dA(77)/dV(36)
  B(129) = RCT(77)*V(67)
! B(130) = dA(77)/dV(67)
  B(130) = RCT(77)*V(36)
! B(131) = dA(78)/dV(36)
  B(131) = RCT(78)*V(60)
! B(132) = dA(78)/dV(60)
  B(132) = RCT(78)*V(36)
! B(133) = dA(79)/dV(24)
  B(133) = RCT(79)*V(59)
! B(134) = dA(79)/dV(59)
  B(134) = RCT(79)*V(24)
! B(135) = dA(80)/dV(42)
  B(135) = RCT(80)*V(67)
! B(136) = dA(80)/dV(67)
  B(136) = RCT(80)*V(42)
! B(137) = dA(81)/dV(42)
  B(137) = RCT(81)*V(64)
! B(138) = dA(81)/dV(64)
  B(138) = RCT(81)*V(42)
! B(139) = dA(82)/dV(46)
  B(139) = RCT(82)*V(67)
! B(140) = dA(82)/dV(67)
  B(140) = RCT(82)*V(46)
! B(141) = dA(83)/dV(46)
  B(141) = RCT(83)*V(64)
! B(142) = dA(83)/dV(64)
  B(142) = RCT(83)*V(46)
! B(143) = dA(84)/dV(46)
  B(143) = RCT(84)*V(60)
! B(144) = dA(84)/dV(60)
  B(144) = RCT(84)*V(46)
! B(145) = dA(85)/dV(56)
  B(145) = RCT(85)*V(67)
! B(146) = dA(85)/dV(67)
  B(146) = RCT(85)*V(56)
! B(147) = dA(86)/dV(56)
  B(147) = RCT(86)*V(64)
! B(148) = dA(86)/dV(64)
  B(148) = RCT(86)*V(56)
! B(149) = dA(87)/dV(56)
  B(149) = RCT(87)*V(60)
! B(150) = dA(87)/dV(60)
  B(150) = RCT(87)*V(56)
! B(151) = dA(88)/dV(43)
  B(151) = RCT(88)*V(63)
! B(152) = dA(88)/dV(63)
  B(152) = RCT(88)*V(43)
! B(153) = dA(89)/dV(40)
  B(153) = RCT(89)*V(63)
! B(154) = dA(89)/dV(63)
  B(154) = RCT(89)*V(40)
! B(155) = dA(90)/dV(44)
  B(155) = RCT(90)*V(63)
! B(156) = dA(90)/dV(63)
  B(156) = RCT(90)*V(44)
! B(157) = dA(91)/dV(43)
  B(157) = RCT(91)*V(65)
! B(158) = dA(91)/dV(65)
  B(158) = RCT(91)*V(43)
! B(159) = dA(92)/dV(40)
  B(159) = RCT(92)*V(65)
! B(160) = dA(92)/dV(65)
  B(160) = RCT(92)*V(40)
! B(161) = dA(93)/dV(44)
  B(161) = RCT(93)*V(65)
! B(162) = dA(93)/dV(65)
  B(162) = RCT(93)*V(44)
! B(163) = dA(94)/dV(31)
  B(163) = RCT(94)*V(67)
! B(164) = dA(94)/dV(67)
  B(164) = RCT(94)*V(31)
! B(165) = dA(95)/dV(33)
  B(165) = RCT(95)*V(67)
! B(166) = dA(95)/dV(67)
  B(166) = RCT(95)*V(33)
! B(167) = dA(96)/dV(66)
  B(167) = RCT(96)*V(67)
! B(168) = dA(96)/dV(67)
  B(168) = RCT(96)*V(66)
! B(169) = dA(97)/dV(57)
  B(169) = RCT(97)*V(67)
! B(170) = dA(97)/dV(67)
  B(170) = RCT(97)*V(57)
! B(171) = dA(98)/dV(58)
  B(171) = RCT(98)*V(59)
! B(172) = dA(98)/dV(59)
  B(172) = RCT(98)*V(58)
! B(173) = dA(99)/dV(18)
  B(173) = RCT(99)
! B(174) = dA(100)/dV(35)
  B(174) = RCT(100)*V(67)
! B(175) = dA(100)/dV(67)
  B(175) = RCT(100)*V(35)
! B(176) = dA(101)/dV(55)
  B(176) = RCT(101)*V(63)
! B(177) = dA(101)/dV(63)
  B(177) = RCT(101)*V(55)
! B(178) = dA(102)/dV(52)
  B(178) = RCT(102)*V(63)
! B(179) = dA(102)/dV(63)
  B(179) = RCT(102)*V(52)
! B(180) = dA(103)/dV(61)
  B(180) = RCT(103)*V(63)
! B(181) = dA(103)/dV(63)
  B(181) = RCT(103)*V(61)
! B(182) = dA(104)/dV(58)
  B(182) = RCT(104)*V(63)
! B(183) = dA(104)/dV(63)
  B(183) = RCT(104)*V(58)
! B(184) = dA(105)/dV(62)
  B(184) = RCT(105)*V(63)
! B(185) = dA(105)/dV(63)
  B(185) = RCT(105)*V(62)
! B(186) = dA(106)/dV(51)
  B(186) = RCT(106)*V(63)
! B(187) = dA(106)/dV(63)
  B(187) = RCT(106)*V(51)
! B(188) = dA(107)/dV(48)
  B(188) = RCT(107)*V(63)
! B(189) = dA(107)/dV(63)
  B(189) = RCT(107)*V(48)
! B(190) = dA(108)/dV(55)
  B(190) = RCT(108)*V(60)
! B(191) = dA(108)/dV(60)
  B(191) = RCT(108)*V(55)
! B(192) = dA(109)/dV(52)
  B(192) = RCT(109)*V(60)
! B(193) = dA(109)/dV(60)
  B(193) = RCT(109)*V(52)
! B(194) = dA(110)/dV(60)
  B(194) = RCT(110)*V(61)
! B(195) = dA(110)/dV(61)
  B(195) = RCT(110)*V(60)
! B(196) = dA(111)/dV(58)
  B(196) = RCT(111)*V(60)
! B(197) = dA(111)/dV(60)
  B(197) = RCT(111)*V(58)
! B(198) = dA(112)/dV(60)
  B(198) = RCT(112)*V(62)
! B(199) = dA(112)/dV(62)
  B(199) = RCT(112)*V(60)
! B(200) = dA(113)/dV(51)
  B(200) = RCT(113)*V(60)
! B(201) = dA(113)/dV(60)
  B(201) = RCT(113)*V(51)
! B(202) = dA(114)/dV(48)
  B(202) = RCT(114)*V(60)
! B(203) = dA(114)/dV(60)
  B(203) = RCT(114)*V(48)
! B(204) = dA(115)/dV(55)
  B(204) = RCT(115)*V(65)
! B(205) = dA(115)/dV(65)
  B(205) = RCT(115)*V(55)
! B(206) = dA(116)/dV(52)
  B(206) = RCT(116)*V(65)
! B(207) = dA(116)/dV(65)
  B(207) = RCT(116)*V(52)
! B(208) = dA(117)/dV(61)
  B(208) = RCT(117)*V(65)
! B(209) = dA(117)/dV(65)
  B(209) = RCT(117)*V(61)
! B(210) = dA(118)/dV(58)
  B(210) = RCT(118)*V(65)
! B(211) = dA(118)/dV(65)
  B(211) = RCT(118)*V(58)
! B(212) = dA(119)/dV(62)
  B(212) = RCT(119)*V(65)
! B(213) = dA(119)/dV(65)
  B(213) = RCT(119)*V(62)
! B(214) = dA(120)/dV(51)
  B(214) = RCT(120)*V(65)
! B(215) = dA(120)/dV(65)
  B(215) = RCT(120)*V(51)
! B(216) = dA(121)/dV(48)
  B(216) = RCT(121)*V(65)
! B(217) = dA(121)/dV(65)
  B(217) = RCT(121)*V(48)
! B(218) = dA(122)/dV(17)
  B(218) = RCT(122)*V(67)
! B(219) = dA(122)/dV(67)
  B(219) = RCT(122)*V(17)
! B(220) = dA(123)/dV(30)
  B(220) = RCT(123)*V(41)
! B(221) = dA(123)/dV(41)
  B(221) = RCT(123)*V(30)
! B(222) = dA(124)/dV(2)
  B(222) = 1
! B(223) = dA(125)/dV(3)
  B(223) = 1
! B(224) = dA(126)/dV(1)
  B(224) = 1
! B(225) = dA(127)/dV(55)
  B(225) = RCT(127)
! B(226) = dA(128)/dV(52)
  B(226) = RCT(128)
! B(227) = dA(129)/dV(61)
  B(227) = RCT(129)
! B(228) = dA(130)/dV(58)
  B(228) = RCT(130)
! B(229) = dA(131)/dV(62)
  B(229) = RCT(131)
! B(230) = dA(132)/dV(51)
  B(230) = RCT(132)
! B(231) = dA(133)/dV(43)
  B(231) = RCT(133)
! B(232) = dA(134)/dV(40)
  B(232) = RCT(134)
! B(233) = dA(135)/dV(44)
  B(233) = RCT(135)
! B(234) = dA(136)/dV(48)
  B(234) = RCT(136)
! B(235) = dA(137)/dV(25)
  B(235) = RCT(137)*V(67)
! B(236) = dA(137)/dV(67)
  B(236) = RCT(137)*V(25)
! B(237) = dA(138)/dV(25)
  B(237) = RCT(138)*V(60)
! B(238) = dA(138)/dV(60)
  B(238) = RCT(138)*V(25)
! B(239) = dA(139)/dV(25)
  B(239) = RCT(139)*V(64)
! B(240) = dA(139)/dV(64)
  B(240) = RCT(139)*V(25)
! B(241) = dA(140)/dV(26)
  B(241) = RCT(140)*V(67)
! B(242) = dA(140)/dV(67)
  B(242) = RCT(140)*V(26)
! B(243) = dA(141)/dV(26)
  B(243) = RCT(141)*V(60)
! B(244) = dA(141)/dV(60)
  B(244) = RCT(141)*V(26)
! B(245) = dA(142)/dV(26)
  B(245) = RCT(142)*V(64)
! B(246) = dA(142)/dV(64)
  B(246) = RCT(142)*V(26)

! Construct the Jacobian terms from B's
! JVS(1) = Jac_FULL(1,1)
  JVS(1) = 0
! JVS(2) = Jac_FULL(1,15)
  JVS(2) = B(85)
! JVS(3) = Jac_FULL(1,67)
  JVS(3) = B(86)
! JVS(4) = Jac_FULL(2,2)
  JVS(4) = 0
! JVS(5) = Jac_FULL(3,3)
  JVS(5) = 0
! JVS(6) = Jac_FULL(4,4)
  JVS(6) = 0
! JVS(7) = Jac_FULL(4,34)
  JVS(7) = 0.52*B(107)
! JVS(8) = Jac_FULL(4,45)
  JVS(8) = 0.22*B(111)
! JVS(9) = Jac_FULL(4,64)
  JVS(9) = 0.52*B(108)+0.22*B(112)
! JVS(10) = Jac_FULL(5,5)
  JVS(10) = 0
! JVS(11) = Jac_FULL(5,45)
  JVS(11) = 0.09*B(111)
! JVS(12) = Jac_FULL(5,46)
  JVS(12) = 0.39*B(141)
! JVS(13) = Jac_FULL(5,50)
  JVS(13) = 0.16*B(113)
! JVS(14) = Jac_FULL(5,56)
  JVS(14) = 0.46*B(147)
! JVS(15) = Jac_FULL(5,58)
  JVS(15) = 0.4*B(210)
! JVS(16) = Jac_FULL(5,64)
  JVS(16) = 0.09*B(112)+0.16*B(114)+0.39*B(142)+0.46*B(148)
! JVS(17) = Jac_FULL(5,65)
  JVS(17) = 0.4*B(211)
! JVS(18) = Jac_FULL(6,6)
  JVS(18) = 0
! JVS(19) = Jac_FULL(6,20)
  JVS(19) = 0.039*B(123)
! JVS(20) = Jac_FULL(6,22)
  JVS(20) = 0.039*B(125)
! JVS(21) = Jac_FULL(6,36)
  JVS(21) = 0.039*B(129)+0.039*B(131)
! JVS(22) = Jac_FULL(6,60)
  JVS(22) = 0.039*B(132)
! JVS(23) = Jac_FULL(6,67)
  JVS(23) = 0.039*B(124)+0.039*B(126)+0.039*B(130)
! JVS(24) = Jac_FULL(7,7)
  JVS(24) = 0
! JVS(25) = Jac_FULL(7,20)
  JVS(25) = 0.108*B(123)
! JVS(26) = Jac_FULL(7,22)
  JVS(26) = 0.108*B(125)
! JVS(27) = Jac_FULL(7,36)
  JVS(27) = 0.108*B(129)+0.108*B(131)
! JVS(28) = Jac_FULL(7,60)
  JVS(28) = 0.108*B(132)
! JVS(29) = Jac_FULL(7,67)
  JVS(29) = 0.108*B(124)+0.108*B(126)+0.108*B(130)
! JVS(30) = Jac_FULL(8,8)
  JVS(30) = 0
! JVS(31) = Jac_FULL(8,41)
  JVS(31) = 0.012*B(91)
! JVS(32) = Jac_FULL(8,67)
  JVS(32) = 0.012*B(92)
! JVS(33) = Jac_FULL(9,9)
  JVS(33) = 0
! JVS(34) = Jac_FULL(9,45)
  JVS(34) = 0.008*B(111)+0.008*B(115)+0.008*B(119)
! JVS(35) = Jac_FULL(9,50)
  JVS(35) = 0.008*B(113)+0.008*B(117)+0.008*B(121)
! JVS(36) = Jac_FULL(9,60)
  JVS(36) = 0.008*B(120)+0.008*B(122)
! JVS(37) = Jac_FULL(9,64)
  JVS(37) = 0.008*B(112)+0.008*B(114)
! JVS(38) = Jac_FULL(9,67)
  JVS(38) = 0.008*B(116)+0.008*B(118)
! JVS(39) = Jac_FULL(10,10)
  JVS(39) = 0
! JVS(40) = Jac_FULL(10,25)
  JVS(40) = 0.0064*B(235)+0.022*B(239)
! JVS(41) = Jac_FULL(10,64)
  JVS(41) = 0.022*B(240)
! JVS(42) = Jac_FULL(10,67)
  JVS(42) = 0.0064*B(236)
! JVS(43) = Jac_FULL(11,11)
  JVS(43) = 0
! JVS(44) = Jac_FULL(11,25)
  JVS(44) = 0.055*B(235)+0.19*B(239)
! JVS(45) = Jac_FULL(11,64)
  JVS(45) = 0.19*B(240)
! JVS(46) = Jac_FULL(11,67)
  JVS(46) = 0.055*B(236)
! JVS(47) = Jac_FULL(12,12)
  JVS(47) = 0
! JVS(48) = Jac_FULL(12,26)
  JVS(48) = 0.037*B(241)+0.13*B(245)
! JVS(49) = Jac_FULL(12,64)
  JVS(49) = 0.13*B(246)
! JVS(50) = Jac_FULL(12,67)
  JVS(50) = 0.037*B(242)
! JVS(51) = Jac_FULL(13,13)
  JVS(51) = 0
! JVS(52) = Jac_FULL(13,26)
  JVS(52) = 0.056*B(241)+0.19*B(245)
! JVS(53) = Jac_FULL(13,64)
  JVS(53) = 0.19*B(246)
! JVS(54) = Jac_FULL(13,67)
  JVS(54) = 0.056*B(242)
! JVS(55) = Jac_FULL(14,14)
  JVS(55) = 0
! JVS(56) = Jac_FULL(14,30)
  JVS(56) = B(220)
! JVS(57) = Jac_FULL(14,41)
  JVS(57) = B(221)
! JVS(58) = Jac_FULL(14,48)
  JVS(58) = B(216)+B(234)
! JVS(59) = Jac_FULL(14,65)
  JVS(59) = B(217)
! JVS(60) = Jac_FULL(15,15)
  JVS(60) = -B(85)
! JVS(61) = Jac_FULL(15,67)
  JVS(61) = -B(86)
! JVS(62) = Jac_FULL(16,16)
  JVS(62) = -B(21)-B(23)
! JVS(63) = Jac_FULL(16,64)
  JVS(63) = B(8)
! JVS(64) = Jac_FULL(17,17)
  JVS(64) = -B(218)
! JVS(65) = Jac_FULL(17,67)
  JVS(65) = -B(219)
! JVS(66) = Jac_FULL(18,18)
  JVS(66) = -B(173)
! JVS(67) = Jac_FULL(18,58)
  JVS(67) = B(171)
! JVS(68) = Jac_FULL(18,59)
  JVS(68) = B(172)
! JVS(69) = Jac_FULL(19,19)
  JVS(69) = -B(9)-B(59)
! JVS(70) = Jac_FULL(19,65)
  JVS(70) = B(61)+B(62)
! JVS(71) = Jac_FULL(19,67)
  JVS(71) = -B(60)
! JVS(72) = Jac_FULL(20,20)
  JVS(72) = -B(123)
! JVS(73) = Jac_FULL(20,67)
  JVS(73) = -B(124)
! JVS(74) = Jac_FULL(21,21)
  JVS(74) = -B(6)-B(80)-B(82)
! JVS(75) = Jac_FULL(21,59)
  JVS(75) = B(75)
! JVS(76) = Jac_FULL(21,60)
  JVS(76) = B(76)
! JVS(77) = Jac_FULL(22,22)
  JVS(77) = -B(125)
! JVS(78) = Jac_FULL(22,67)
  JVS(78) = -B(126)
! JVS(79) = Jac_FULL(23,23)
  JVS(79) = -B(87)
! JVS(80) = Jac_FULL(23,45)
  JVS(80) = 0.06*B(111)
! JVS(81) = Jac_FULL(23,50)
  JVS(81) = 0.08*B(113)
! JVS(82) = Jac_FULL(23,64)
  JVS(82) = 0.06*B(112)+0.08*B(114)
! JVS(83) = Jac_FULL(23,67)
  JVS(83) = -B(88)
! JVS(84) = Jac_FULL(24,24)
  JVS(84) = -B(133)
! JVS(85) = Jac_FULL(24,36)
  JVS(85) = 0.4*B(129)+B(131)
! JVS(86) = Jac_FULL(24,59)
  JVS(86) = -B(134)
! JVS(87) = Jac_FULL(24,60)
  JVS(87) = B(132)
! JVS(88) = Jac_FULL(24,67)
  JVS(88) = 0.4*B(130)
! JVS(89) = Jac_FULL(25,25)
  JVS(89) = -B(235)-B(237)-B(239)
! JVS(90) = Jac_FULL(25,60)
  JVS(90) = -B(238)
! JVS(91) = Jac_FULL(25,64)
  JVS(91) = -B(240)
! JVS(92) = Jac_FULL(25,67)
  JVS(92) = -B(236)
! JVS(93) = Jac_FULL(26,26)
  JVS(93) = -B(241)-B(243)-B(245)
! JVS(94) = Jac_FULL(26,60)
  JVS(94) = -B(244)
! JVS(95) = Jac_FULL(26,64)
  JVS(95) = -B(246)
! JVS(96) = Jac_FULL(26,67)
  JVS(96) = -B(242)
! JVS(97) = Jac_FULL(27,27)
  JVS(97) = -B(5)-B(55)-B(70)
! JVS(98) = Jac_FULL(27,59)
  JVS(98) = B(66)
! JVS(99) = Jac_FULL(27,65)
  JVS(99) = B(67)
! JVS(100) = Jac_FULL(27,67)
  JVS(100) = -B(56)
! JVS(101) = Jac_FULL(28,28)
  JVS(101) = -B(89)
! JVS(102) = Jac_FULL(28,45)
  JVS(102) = 0.01*B(111)
! JVS(103) = Jac_FULL(28,50)
  JVS(103) = 0.01*B(113)
! JVS(104) = Jac_FULL(28,52)
  JVS(104) = 0.2*B(226)
! JVS(105) = Jac_FULL(28,64)
  JVS(105) = 0.01*B(112)+0.01*B(114)
! JVS(106) = Jac_FULL(28,67)
  JVS(106) = -B(90)
! JVS(107) = Jac_FULL(29,20)
  JVS(107) = 0.8*B(123)
! JVS(108) = Jac_FULL(29,22)
  JVS(108) = 0.45*B(125)
! JVS(109) = Jac_FULL(29,29)
  JVS(109) = -B(127)
! JVS(110) = Jac_FULL(29,63)
  JVS(110) = -B(128)
! JVS(111) = Jac_FULL(29,67)
  JVS(111) = 0.8*B(124)+0.45*B(126)
! JVS(112) = Jac_FULL(30,30)
  JVS(112) = -B(220)
! JVS(113) = Jac_FULL(30,41)
  JVS(113) = -B(221)
! JVS(114) = Jac_FULL(30,45)
  JVS(114) = 1.06*B(111)+B(115)
! JVS(115) = Jac_FULL(30,50)
  JVS(115) = 2.26*B(113)+2.23*B(117)
! JVS(116) = Jac_FULL(30,51)
  JVS(116) = B(186)+B(200)+B(230)
! JVS(117) = Jac_FULL(30,57)
  JVS(117) = 1.98*B(19)
! JVS(118) = Jac_FULL(30,60)
  JVS(118) = 1.98*B(194)+B(201)
! JVS(119) = Jac_FULL(30,61)
  JVS(119) = 1.68*B(180)+1.98*B(195)+1.25*B(227)
! JVS(120) = Jac_FULL(30,63)
  JVS(120) = 1.68*B(181)+B(187)
! JVS(121) = Jac_FULL(30,64)
  JVS(121) = 1.06*B(112)+2.26*B(114)
! JVS(122) = Jac_FULL(30,66)
  JVS(122) = 1.98*B(18)+0.42*B(167)
! JVS(123) = Jac_FULL(30,67)
  JVS(123) = B(116)+2.23*B(118)+0.42*B(168)
! JVS(124) = Jac_FULL(31,31)
  JVS(124) = -B(12)-B(163)
! JVS(125) = Jac_FULL(31,55)
  JVS(125) = B(204)
! JVS(126) = Jac_FULL(31,65)
  JVS(126) = B(205)
! JVS(127) = Jac_FULL(31,67)
  JVS(127) = -B(164)
! JVS(128) = Jac_FULL(32,32)
  JVS(128) = -B(3)-B(51)
! JVS(129) = Jac_FULL(32,59)
  JVS(129) = B(68)
! JVS(130) = Jac_FULL(32,63)
  JVS(130) = B(45)
! JVS(131) = Jac_FULL(32,65)
  JVS(131) = B(69)
! JVS(132) = Jac_FULL(32,67)
  JVS(132) = B(46)-B(52)
! JVS(133) = Jac_FULL(33,33)
  JVS(133) = -B(13)-B(165)
! JVS(134) = Jac_FULL(33,52)
  JVS(134) = B(206)
! JVS(135) = Jac_FULL(33,65)
  JVS(135) = B(207)
! JVS(136) = Jac_FULL(33,67)
  JVS(136) = -B(166)
! JVS(137) = Jac_FULL(34,34)
  JVS(137) = -B(107)-B(109)
! JVS(138) = Jac_FULL(34,64)
  JVS(138) = -B(108)
! JVS(139) = Jac_FULL(34,67)
  JVS(139) = -B(110)
! JVS(140) = Jac_FULL(35,35)
  JVS(140) = -B(174)
! JVS(141) = Jac_FULL(35,45)
  JVS(141) = 0.03*B(111)
! JVS(142) = Jac_FULL(35,50)
  JVS(142) = 0.04*B(113)
! JVS(143) = Jac_FULL(35,55)
  JVS(143) = 0.34*B(225)
! JVS(144) = Jac_FULL(35,64)
  JVS(144) = 0.03*B(112)+0.04*B(114)
! JVS(145) = Jac_FULL(35,67)
  JVS(145) = -B(175)
! JVS(146) = Jac_FULL(36,20)
  JVS(146) = 0.12*B(123)
! JVS(147) = Jac_FULL(36,22)
  JVS(147) = 0.05*B(125)
! JVS(148) = Jac_FULL(36,36)
  JVS(148) = -B(129)-B(131)
! JVS(149) = Jac_FULL(36,60)
  JVS(149) = -B(132)
! JVS(150) = Jac_FULL(36,67)
  JVS(150) = 0.12*B(124)+0.05*B(126)-B(130)
! JVS(151) = Jac_FULL(37,16)
  JVS(151) = B(21)
! JVS(152) = Jac_FULL(37,37)
  JVS(152) = -B(25)-B(27)-B(29)-B(31)-B(33)
! JVS(153) = Jac_FULL(37,59)
  JVS(153) = B(1)-B(30)-B(32)
! JVS(154) = Jac_FULL(37,60)
  JVS(154) = 0.89*B(2)
! JVS(155) = Jac_FULL(37,63)
  JVS(155) = -B(34)
! JVS(156) = Jac_FULL(37,64)
  JVS(156) = B(7)-B(28)
! JVS(157) = Jac_FULL(38,21)
  JVS(157) = 2*B(80)
! JVS(158) = Jac_FULL(38,36)
  JVS(158) = B(131)
! JVS(159) = Jac_FULL(38,38)
  JVS(159) = -B(4)-B(53)
! JVS(160) = Jac_FULL(38,47)
  JVS(160) = B(95)
! JVS(161) = Jac_FULL(38,53)
  JVS(161) = B(105)
! JVS(162) = Jac_FULL(38,54)
  JVS(162) = B(99)
! JVS(163) = Jac_FULL(38,56)
  JVS(163) = 0.07*B(149)
! JVS(164) = Jac_FULL(38,59)
  JVS(164) = B(47)
! JVS(165) = Jac_FULL(38,60)
  JVS(165) = 0.3*B(78)+B(96)+B(100)+B(106)+B(132)+0.07*B(150)
! JVS(166) = Jac_FULL(38,65)
  JVS(166) = 0.3*B(79)
! JVS(167) = Jac_FULL(38,67)
  JVS(167) = B(48)-B(54)
! JVS(168) = Jac_FULL(39,34)
  JVS(168) = 0.24*B(107)
! JVS(169) = Jac_FULL(39,39)
  JVS(169) = -B(83)
! JVS(170) = Jac_FULL(39,42)
  JVS(170) = B(17)+2*B(135)+0.69*B(137)
! JVS(171) = Jac_FULL(39,44)
  JVS(171) = 0.59*B(155)
! JVS(172) = Jac_FULL(39,45)
  JVS(172) = 0.31*B(111)
! JVS(173) = Jac_FULL(39,46)
  JVS(173) = 0.07*B(141)
! JVS(174) = Jac_FULL(39,47)
  JVS(174) = B(10)+B(11)+B(93)+B(95)
! JVS(175) = Jac_FULL(39,50)
  JVS(175) = 0.3*B(113)
! JVS(176) = Jac_FULL(39,53)
  JVS(176) = B(16)+B(105)
! JVS(177) = Jac_FULL(39,54)
  JVS(177) = B(14)
! JVS(178) = Jac_FULL(39,56)
  JVS(178) = 0.33*B(20)+0.16*B(147)+0.64*B(149)
! JVS(179) = Jac_FULL(39,60)
  JVS(179) = B(96)+B(106)+0.64*B(150)
! JVS(180) = Jac_FULL(39,63)
  JVS(180) = 0.59*B(156)
! JVS(181) = Jac_FULL(39,64)
  JVS(181) = 0.24*B(108)+0.31*B(112)+0.3*B(114)+0.69*B(138)+0.07*B(142)+0.16*B(148)
! JVS(182) = Jac_FULL(39,67)
  JVS(182) = -B(84)+B(94)+2*B(136)
! JVS(183) = Jac_FULL(40,40)
  JVS(183) = -B(153)-B(159)-B(232)
! JVS(184) = Jac_FULL(40,46)
  JVS(184) = B(143)
! JVS(185) = Jac_FULL(40,60)
  JVS(185) = B(144)
! JVS(186) = Jac_FULL(40,63)
  JVS(186) = -B(154)
! JVS(187) = Jac_FULL(40,65)
  JVS(187) = -B(160)
! JVS(188) = Jac_FULL(41,22)
  JVS(188) = 1.1*B(125)
! JVS(189) = Jac_FULL(41,30)
  JVS(189) = -B(220)
! JVS(190) = Jac_FULL(41,40)
  JVS(190) = 1.6*B(153)+2*B(159)+2*B(232)
! JVS(191) = Jac_FULL(41,41)
  JVS(191) = -B(91)-B(221)
! JVS(192) = Jac_FULL(41,43)
  JVS(192) = 0.18*B(151)
! JVS(193) = Jac_FULL(41,45)
  JVS(193) = 0
! JVS(194) = Jac_FULL(41,46)
  JVS(194) = 0
! JVS(195) = Jac_FULL(41,50)
  JVS(195) = 0
! JVS(196) = Jac_FULL(41,51)
  JVS(196) = 0
! JVS(197) = Jac_FULL(41,56)
  JVS(197) = 1.86*B(149)
! JVS(198) = Jac_FULL(41,57)
  JVS(198) = 0
! JVS(199) = Jac_FULL(41,60)
  JVS(199) = 1.86*B(150)
! JVS(200) = Jac_FULL(41,61)
  JVS(200) = 0
! JVS(201) = Jac_FULL(41,63)
  JVS(201) = 0.18*B(152)+1.6*B(154)
! JVS(202) = Jac_FULL(41,64)
  JVS(202) = 0
! JVS(203) = Jac_FULL(41,65)
  JVS(203) = 2*B(160)
! JVS(204) = Jac_FULL(41,66)
  JVS(204) = 0
! JVS(205) = Jac_FULL(41,67)
  JVS(205) = -B(92)+1.1*B(126)
! JVS(206) = Jac_FULL(42,29)
  JVS(206) = 0.95*B(127)
! JVS(207) = Jac_FULL(42,36)
  JVS(207) = 0.3*B(129)
! JVS(208) = Jac_FULL(42,42)
  JVS(208) = -B(17)-B(135)-B(137)
! JVS(209) = Jac_FULL(42,60)
  JVS(209) = 0
! JVS(210) = Jac_FULL(42,63)
  JVS(210) = 0.95*B(128)
! JVS(211) = Jac_FULL(42,64)
  JVS(211) = -B(138)
! JVS(212) = Jac_FULL(42,67)
  JVS(212) = 0.3*B(130)-B(136)
! JVS(213) = Jac_FULL(43,43)
  JVS(213) = -B(151)-B(157)-B(231)
! JVS(214) = Jac_FULL(43,46)
  JVS(214) = B(139)
! JVS(215) = Jac_FULL(43,63)
  JVS(215) = -B(152)
! JVS(216) = Jac_FULL(43,65)
  JVS(216) = -B(158)
! JVS(217) = Jac_FULL(43,67)
  JVS(217) = B(140)
! JVS(218) = Jac_FULL(44,44)
  JVS(218) = -B(155)-B(161)-B(233)
! JVS(219) = Jac_FULL(44,56)
  JVS(219) = 0.5*B(145)
! JVS(220) = Jac_FULL(44,63)
  JVS(220) = -B(156)
! JVS(221) = Jac_FULL(44,65)
  JVS(221) = -B(162)
! JVS(222) = Jac_FULL(44,67)
  JVS(222) = 0.5*B(146)
! JVS(223) = Jac_FULL(45,45)
  JVS(223) = -B(111)-B(115)-B(119)
! JVS(224) = Jac_FULL(45,60)
  JVS(224) = -B(120)
! JVS(225) = Jac_FULL(45,64)
  JVS(225) = -B(112)
! JVS(226) = Jac_FULL(45,67)
  JVS(226) = -B(116)
! JVS(227) = Jac_FULL(46,46)
  JVS(227) = -B(139)-B(141)-B(143)
! JVS(228) = Jac_FULL(46,60)
  JVS(228) = -B(144)
! JVS(229) = Jac_FULL(46,64)
  JVS(229) = -B(142)
! JVS(230) = Jac_FULL(46,67)
  JVS(230) = -B(140)
! JVS(231) = Jac_FULL(47,31)
  JVS(231) = B(12)+0.3*B(163)
! JVS(232) = Jac_FULL(47,34)
  JVS(232) = B(107)+1.56*B(109)
! JVS(233) = Jac_FULL(47,35)
  JVS(233) = B(174)
! JVS(234) = Jac_FULL(47,42)
  JVS(234) = B(135)+0.7*B(137)
! JVS(235) = Jac_FULL(47,43)
  JVS(235) = 0.63*B(151)
! JVS(236) = Jac_FULL(47,44)
  JVS(236) = 0.25*B(155)
! JVS(237) = Jac_FULL(47,45)
  JVS(237) = 0.57*B(111)+B(115)
! JVS(238) = Jac_FULL(47,46)
  JVS(238) = 0.6*B(141)
! JVS(239) = Jac_FULL(47,47)
  JVS(239) = -B(10)-B(11)-B(93)-B(95)
! JVS(240) = Jac_FULL(47,50)
  JVS(240) = 0
! JVS(241) = Jac_FULL(47,51)
  JVS(241) = 0.5*B(186)+0.5*B(200)+0.5*B(230)
! JVS(242) = Jac_FULL(47,55)
  JVS(242) = B(176)+B(190)+0.66*B(225)
! JVS(243) = Jac_FULL(47,56)
  JVS(243) = 0.2*B(20)+0.15*B(147)+0.28*B(149)
! JVS(244) = Jac_FULL(47,60)
  JVS(244) = -B(96)+0.28*B(150)+B(191)+B(198)+0.5*B(201)
! JVS(245) = Jac_FULL(47,62)
  JVS(245) = B(184)+B(199)+0.7*B(229)
! JVS(246) = Jac_FULL(47,63)
  JVS(246) = 0.63*B(152)+0.25*B(156)+B(177)+B(185)+0.5*B(187)
! JVS(247) = Jac_FULL(47,64)
  JVS(247) = B(108)+0.57*B(112)+0.7*B(138)+0.6*B(142)+0.15*B(148)
! JVS(248) = Jac_FULL(47,65)
  JVS(248) = 0
! JVS(249) = Jac_FULL(47,67)
  JVS(249) = -B(94)+1.56*B(110)+B(116)+B(136)+0.3*B(164)+B(175)
! JVS(250) = Jac_FULL(48,20)
  JVS(250) = 0.08*B(123)
! JVS(251) = Jac_FULL(48,22)
  JVS(251) = 0.5*B(125)
! JVS(252) = Jac_FULL(48,34)
  JVS(252) = B(109)
! JVS(253) = Jac_FULL(48,36)
  JVS(253) = 0.6*B(129)
! JVS(254) = Jac_FULL(48,42)
  JVS(254) = B(135)+0.03*B(137)
! JVS(255) = Jac_FULL(48,45)
  JVS(255) = B(115)
! JVS(256) = Jac_FULL(48,46)
  JVS(256) = 0.08*B(139)+0.2*B(141)
! JVS(257) = Jac_FULL(48,48)
  JVS(257) = -B(188)-B(202)-B(216)-B(234)
! JVS(258) = Jac_FULL(48,50)
  JVS(258) = B(117)
! JVS(259) = Jac_FULL(48,53)
  JVS(259) = B(103)
! JVS(260) = Jac_FULL(48,56)
  JVS(260) = 0.2*B(145)+0.07*B(147)+0.93*B(149)
! JVS(261) = Jac_FULL(48,57)
  JVS(261) = 0.41*B(19)
! JVS(262) = Jac_FULL(48,60)
  JVS(262) = 0.93*B(150)+0.4*B(194)-B(203)
! JVS(263) = Jac_FULL(48,61)
  JVS(263) = 0.34*B(180)+0.4*B(195)+0.24*B(227)
! JVS(264) = Jac_FULL(48,63)
  JVS(264) = 0.34*B(181)-B(189)
! JVS(265) = Jac_FULL(48,64)
  JVS(265) = 0.03*B(138)+0.2*B(142)+0.07*B(148)
! JVS(266) = Jac_FULL(48,65)
  JVS(266) = -B(217)
! JVS(267) = Jac_FULL(48,66)
  JVS(267) = 0.4*B(18)
! JVS(268) = Jac_FULL(48,67)
  JVS(268) = B(104)+B(110)+B(116)+B(118)+0.08*B(124)+0.5*B(126)+0.6*B(130)+B(136)+0.08*B(140)+0.2*B(146)
! JVS(269) = Jac_FULL(49,44)
  JVS(269) = 0.63*B(155)+0.5*B(233)
! JVS(270) = Jac_FULL(49,49)
  JVS(270) = -B(15)-B(101)
! JVS(271) = Jac_FULL(49,50)
  JVS(271) = 0.07*B(113)+0.23*B(117)
! JVS(272) = Jac_FULL(49,56)
  JVS(272) = 0.03*B(20)+0.09*B(147)
! JVS(273) = Jac_FULL(49,57)
  JVS(273) = 0.74*B(19)
! JVS(274) = Jac_FULL(49,60)
  JVS(274) = 0.74*B(194)
! JVS(275) = Jac_FULL(49,61)
  JVS(275) = 0.62*B(180)+0.74*B(195)+0.57*B(227)
! JVS(276) = Jac_FULL(49,62)
  JVS(276) = 0.15*B(229)
! JVS(277) = Jac_FULL(49,63)
  JVS(277) = 0.63*B(156)+0.62*B(181)
! JVS(278) = Jac_FULL(49,64)
  JVS(278) = 0.07*B(114)+0.09*B(148)
! JVS(279) = Jac_FULL(49,65)
  JVS(279) = 0
! JVS(280) = Jac_FULL(49,66)
  JVS(280) = 0.74*B(18)
! JVS(281) = Jac_FULL(49,67)
  JVS(281) = -B(102)+0.23*B(118)
! JVS(282) = Jac_FULL(50,50)
  JVS(282) = -B(113)-B(117)-B(121)
! JVS(283) = Jac_FULL(50,60)
  JVS(283) = -B(122)
! JVS(284) = Jac_FULL(50,64)
  JVS(284) = -B(114)
! JVS(285) = Jac_FULL(50,67)
  JVS(285) = -B(118)
! JVS(286) = Jac_FULL(51,45)
  JVS(286) = B(119)
! JVS(287) = Jac_FULL(51,50)
  JVS(287) = B(121)
! JVS(288) = Jac_FULL(51,51)
  JVS(288) = -B(186)-B(200)-B(214)-B(230)
! JVS(289) = Jac_FULL(51,57)
  JVS(289) = B(169)
! JVS(290) = Jac_FULL(51,60)
  JVS(290) = B(120)+B(122)-B(201)
! JVS(291) = Jac_FULL(51,63)
  JVS(291) = -B(187)
! JVS(292) = Jac_FULL(51,64)
  JVS(292) = 0
! JVS(293) = Jac_FULL(51,65)
  JVS(293) = -B(215)
! JVS(294) = Jac_FULL(51,67)
  JVS(294) = B(170)
! JVS(295) = Jac_FULL(52,28)
  JVS(295) = B(89)
! JVS(296) = Jac_FULL(52,33)
  JVS(296) = 0.7*B(165)
! JVS(297) = Jac_FULL(52,45)
  JVS(297) = 0.06*B(111)
! JVS(298) = Jac_FULL(52,50)
  JVS(298) = 0.05*B(113)
! JVS(299) = Jac_FULL(52,52)
  JVS(299) = -B(178)-B(192)-B(206)-B(226)
! JVS(300) = Jac_FULL(52,57)
  JVS(300) = 0.1*B(19)
! JVS(301) = Jac_FULL(52,60)
  JVS(301) = -B(193)+0.1*B(194)
! JVS(302) = Jac_FULL(52,61)
  JVS(302) = 0.08*B(180)+0.1*B(195)+0.06*B(227)
! JVS(303) = Jac_FULL(52,63)
  JVS(303) = -B(179)+0.08*B(181)
! JVS(304) = Jac_FULL(52,64)
  JVS(304) = 0.06*B(112)+0.05*B(114)
! JVS(305) = Jac_FULL(52,65)
  JVS(305) = -B(207)
! JVS(306) = Jac_FULL(52,66)
  JVS(306) = 0.1*B(18)
! JVS(307) = Jac_FULL(52,67)
  JVS(307) = B(90)+0.7*B(166)
! JVS(308) = Jac_FULL(53,22)
  JVS(308) = 0.8*B(125)
! JVS(309) = Jac_FULL(53,42)
  JVS(309) = 0.2*B(137)
! JVS(310) = Jac_FULL(53,44)
  JVS(310) = 0.34*B(155)
! JVS(311) = Jac_FULL(53,45)
  JVS(311) = 0.04*B(111)
! JVS(312) = Jac_FULL(53,50)
  JVS(312) = 0.07*B(113)
! JVS(313) = Jac_FULL(53,53)
  JVS(313) = -B(16)-B(103)-B(105)
! JVS(314) = Jac_FULL(53,56)
  JVS(314) = 0.85*B(147)
! JVS(315) = Jac_FULL(53,60)
  JVS(315) = -B(106)
! JVS(316) = Jac_FULL(53,62)
  JVS(316) = 0.15*B(229)
! JVS(317) = Jac_FULL(53,63)
  JVS(317) = 0.34*B(156)
! JVS(318) = Jac_FULL(53,64)
  JVS(318) = 0.04*B(112)+0.07*B(114)+0.2*B(138)+0.85*B(148)
! JVS(319) = Jac_FULL(53,65)
  JVS(319) = 0
! JVS(320) = Jac_FULL(53,66)
  JVS(320) = 0.19*B(167)
! JVS(321) = Jac_FULL(53,67)
  JVS(321) = -B(104)+0.8*B(126)+0.19*B(168)
! JVS(322) = Jac_FULL(54,17)
  JVS(322) = B(218)
! JVS(323) = Jac_FULL(54,33)
  JVS(323) = B(13)+0.3*B(165)
! JVS(324) = Jac_FULL(54,34)
  JVS(324) = 0.22*B(109)
! JVS(325) = Jac_FULL(54,40)
  JVS(325) = 0.8*B(153)+B(232)
! JVS(326) = Jac_FULL(54,42)
  JVS(326) = 0.03*B(137)
! JVS(327) = Jac_FULL(54,44)
  JVS(327) = 0.55*B(155)+0.5*B(233)
! JVS(328) = Jac_FULL(54,45)
  JVS(328) = 0.47*B(111)+B(115)
! JVS(329) = Jac_FULL(54,46)
  JVS(329) = 0.15*B(141)
! JVS(330) = Jac_FULL(54,50)
  JVS(330) = 1.03*B(113)+1.77*B(117)
! JVS(331) = Jac_FULL(54,51)
  JVS(331) = 0.5*B(186)+0.5*B(200)+0.5*B(230)
! JVS(332) = Jac_FULL(54,52)
  JVS(332) = B(178)+B(192)+0.8*B(226)
! JVS(333) = Jac_FULL(54,54)
  JVS(333) = -B(14)-B(97)-B(99)
! JVS(334) = Jac_FULL(54,56)
  JVS(334) = 0.07*B(20)+0.02*B(147)+0.28*B(149)
! JVS(335) = Jac_FULL(54,57)
  JVS(335) = 0.3*B(19)
! JVS(336) = Jac_FULL(54,60)
  JVS(336) = -B(100)+0.28*B(150)+B(193)+0.3*B(194)+0.5*B(201)
! JVS(337) = Jac_FULL(54,61)
  JVS(337) = 0.25*B(180)+0.3*B(195)+0.21*B(227)
! JVS(338) = Jac_FULL(54,63)
  JVS(338) = 0.8*B(154)+0.55*B(156)+B(179)+0.25*B(181)+0.5*B(187)
! JVS(339) = Jac_FULL(54,64)
  JVS(339) = 0.47*B(112)+1.03*B(114)+0.03*B(138)+0.15*B(142)+0.02*B(148)
! JVS(340) = Jac_FULL(54,65)
  JVS(340) = 0
! JVS(341) = Jac_FULL(54,66)
  JVS(341) = 0.3*B(18)+0.04*B(167)
! JVS(342) = Jac_FULL(54,67)
  JVS(342) = -B(98)+0.22*B(110)+B(116)+1.77*B(118)+0.3*B(166)+0.04*B(168)+B(219)
! JVS(343) = Jac_FULL(55,23)
  JVS(343) = B(87)
! JVS(344) = Jac_FULL(55,31)
  JVS(344) = 0.7*B(163)
! JVS(345) = Jac_FULL(55,45)
  JVS(345) = 0.07*B(111)
! JVS(346) = Jac_FULL(55,49)
  JVS(346) = B(15)
! JVS(347) = Jac_FULL(55,50)
  JVS(347) = 0.1*B(113)
! JVS(348) = Jac_FULL(55,54)
  JVS(348) = B(14)
! JVS(349) = Jac_FULL(55,55)
  JVS(349) = -B(176)-B(190)-B(204)-B(225)
! JVS(350) = Jac_FULL(55,56)
  JVS(350) = 0.7*B(20)+0.05*B(147)
! JVS(351) = Jac_FULL(55,57)
  JVS(351) = 0
! JVS(352) = Jac_FULL(55,58)
  JVS(352) = B(182)+B(196)+B(228)
! JVS(353) = Jac_FULL(55,60)
  JVS(353) = -B(191)+B(197)
! JVS(354) = Jac_FULL(55,61)
  JVS(354) = 0
! JVS(355) = Jac_FULL(55,62)
  JVS(355) = 0
! JVS(356) = Jac_FULL(55,63)
  JVS(356) = -B(177)+B(183)
! JVS(357) = Jac_FULL(55,64)
  JVS(357) = 0.07*B(112)+0.1*B(114)+0.05*B(148)
! JVS(358) = Jac_FULL(55,65)
  JVS(358) = -B(205)
! JVS(359) = Jac_FULL(55,66)
  JVS(359) = 0
! JVS(360) = Jac_FULL(55,67)
  JVS(360) = B(88)+0.7*B(164)
! JVS(361) = Jac_FULL(56,40)
  JVS(361) = 0.2*B(153)
! JVS(362) = Jac_FULL(56,43)
  JVS(362) = 0.91*B(151)+B(231)
! JVS(363) = Jac_FULL(56,46)
  JVS(363) = 0.65*B(141)
! JVS(364) = Jac_FULL(56,56)
  JVS(364) = -B(20)-B(145)-B(147)-B(149)
! JVS(365) = Jac_FULL(56,60)
  JVS(365) = -B(150)
! JVS(366) = Jac_FULL(56,63)
  JVS(366) = 0.91*B(152)+0.2*B(154)
! JVS(367) = Jac_FULL(56,64)
  JVS(367) = 0.65*B(142)-B(148)
! JVS(368) = Jac_FULL(56,65)
  JVS(368) = 0
! JVS(369) = Jac_FULL(56,67)
  JVS(369) = -B(146)
! JVS(370) = Jac_FULL(57,24)
  JVS(370) = B(133)
! JVS(371) = Jac_FULL(57,29)
  JVS(371) = 0.05*B(127)
! JVS(372) = Jac_FULL(57,36)
  JVS(372) = 0
! JVS(373) = Jac_FULL(57,40)
  JVS(373) = 0.8*B(153)+B(159)+B(232)
! JVS(374) = Jac_FULL(57,43)
  JVS(374) = 0.09*B(151)
! JVS(375) = Jac_FULL(57,46)
  JVS(375) = 0
! JVS(376) = Jac_FULL(57,51)
  JVS(376) = 0.5*B(186)+0.5*B(200)+B(214)+0.5*B(230)
! JVS(377) = Jac_FULL(57,56)
  JVS(377) = 0.93*B(149)
! JVS(378) = Jac_FULL(57,57)
  JVS(378) = -B(19)-B(169)
! JVS(379) = Jac_FULL(57,59)
  JVS(379) = B(134)
! JVS(380) = Jac_FULL(57,60)
  JVS(380) = 0.93*B(150)+0.5*B(201)
! JVS(381) = Jac_FULL(57,61)
  JVS(381) = 0.16*B(180)
! JVS(382) = Jac_FULL(57,63)
  JVS(382) = 0.05*B(128)+0.09*B(152)+0.8*B(154)+0.16*B(181)+0.5*B(187)
! JVS(383) = Jac_FULL(57,64)
  JVS(383) = 0
! JVS(384) = Jac_FULL(57,65)
  JVS(384) = B(160)+B(215)
! JVS(385) = Jac_FULL(57,67)
  JVS(385) = -B(170)
! JVS(386) = Jac_FULL(58,18)
  JVS(386) = B(173)
! JVS(387) = Jac_FULL(58,42)
  JVS(387) = B(17)+B(135)+0.62*B(137)
! JVS(388) = Jac_FULL(58,45)
  JVS(388) = 0.13*B(111)
! JVS(389) = Jac_FULL(58,46)
  JVS(389) = 0.2*B(141)
! JVS(390) = Jac_FULL(58,49)
  JVS(390) = B(15)
! JVS(391) = Jac_FULL(58,50)
  JVS(391) = 0.19*B(113)
! JVS(392) = Jac_FULL(58,53)
  JVS(392) = B(16)+B(103)+B(105)
! JVS(393) = Jac_FULL(58,54)
  JVS(393) = B(97)+B(99)
! JVS(394) = Jac_FULL(58,56)
  JVS(394) = 0.97*B(20)+0.5*B(145)+0.11*B(147)+0.07*B(149)
! JVS(395) = Jac_FULL(58,57)
  JVS(395) = 0
! JVS(396) = Jac_FULL(58,58)
  JVS(396) = -B(171)-B(182)-B(196)-B(210)-B(228)
! JVS(397) = Jac_FULL(58,59)
  JVS(397) = -B(172)
! JVS(398) = Jac_FULL(58,60)
  JVS(398) = B(100)+B(106)+0.07*B(150)-B(197)+B(198)
! JVS(399) = Jac_FULL(58,61)
  JVS(399) = 0
! JVS(400) = Jac_FULL(58,62)
  JVS(400) = B(184)+B(199)+0.7*B(229)
! JVS(401) = Jac_FULL(58,63)
  JVS(401) = -B(183)+B(185)
! JVS(402) = Jac_FULL(58,64)
  JVS(402) = 0.13*B(112)+0.19*B(114)+0.62*B(138)+0.2*B(142)+0.11*B(148)
! JVS(403) = Jac_FULL(58,65)
  JVS(403) = -B(211)
! JVS(404) = Jac_FULL(58,66)
  JVS(404) = 0
! JVS(405) = Jac_FULL(58,67)
  JVS(405) = B(98)+B(104)+B(136)+0.5*B(146)
! JVS(406) = Jac_FULL(59,18)
  JVS(406) = B(173)
! JVS(407) = Jac_FULL(59,21)
  JVS(407) = B(6)+B(82)
! JVS(408) = Jac_FULL(59,24)
  JVS(408) = -B(133)
! JVS(409) = Jac_FULL(59,27)
  JVS(409) = B(5)+B(55)+B(70)
! JVS(410) = Jac_FULL(59,29)
  JVS(410) = 0.95*B(127)
! JVS(411) = Jac_FULL(59,32)
  JVS(411) = B(51)
! JVS(412) = Jac_FULL(59,36)
  JVS(412) = 0
! JVS(413) = Jac_FULL(59,37)
  JVS(413) = -B(29)-B(31)+B(33)
! JVS(414) = Jac_FULL(59,38)
  JVS(414) = B(4)
! JVS(415) = Jac_FULL(59,40)
  JVS(415) = 1.2*B(153)
! JVS(416) = Jac_FULL(59,43)
  JVS(416) = 0.91*B(151)
! JVS(417) = Jac_FULL(59,44)
  JVS(417) = B(155)
! JVS(418) = Jac_FULL(59,46)
  JVS(418) = 0
! JVS(419) = Jac_FULL(59,47)
  JVS(419) = 0
! JVS(420) = Jac_FULL(59,48)
  JVS(420) = B(188)+B(202)
! JVS(421) = Jac_FULL(59,50)
  JVS(421) = 0
! JVS(422) = Jac_FULL(59,51)
  JVS(422) = 1.5*B(186)+1.5*B(200)+0.5*B(230)
! JVS(423) = Jac_FULL(59,52)
  JVS(423) = B(178)+B(192)
! JVS(424) = Jac_FULL(59,53)
  JVS(424) = 0
! JVS(425) = Jac_FULL(59,54)
  JVS(425) = 0
! JVS(426) = Jac_FULL(59,55)
  JVS(426) = B(176)+B(190)
! JVS(427) = Jac_FULL(59,56)
  JVS(427) = 0
! JVS(428) = Jac_FULL(59,57)
  JVS(428) = B(19)
! JVS(429) = Jac_FULL(59,58)
  JVS(429) = -B(171)+B(182)+B(196)
! JVS(430) = Jac_FULL(59,59)
  JVS(430) = -B(1)-B(30)-B(32)-B(37)-B(47)-B(66)-B(68)-B(75)-B(134)-B(172)
! JVS(431) = Jac_FULL(59,60)
  JVS(431) = 0.89*B(2)+B(49)+2*B(71)-B(76)+2*B(77)+0.7*B(78)+B(191)+B(193)+B(194)+B(197)+B(198)+1.5*B(201)+B(203)
! JVS(432) = Jac_FULL(59,61)
  JVS(432) = 0.84*B(180)+B(195)
! JVS(433) = Jac_FULL(59,62)
  JVS(433) = B(184)+B(199)
! JVS(434) = Jac_FULL(59,63)
  JVS(434) = B(34)+B(35)+B(64)+2*B(72)+0.95*B(128)+0.91*B(152)+1.2*B(154)+B(156)+B(177)+B(179)+0.84*B(181)+B(183)+B(185)&
               &+1.5*B(187)+B(189)
! JVS(435) = Jac_FULL(59,64)
  JVS(435) = B(36)-B(38)
! JVS(436) = Jac_FULL(59,65)
  JVS(436) = B(65)-B(67)-B(69)+0.7*B(79)
! JVS(437) = Jac_FULL(59,66)
  JVS(437) = 0
! JVS(438) = Jac_FULL(59,67)
  JVS(438) = -B(48)+B(50)+B(52)+B(56)
! JVS(439) = Jac_FULL(60,21)
  JVS(439) = B(6)+B(82)
! JVS(440) = Jac_FULL(60,25)
  JVS(440) = -B(237)
! JVS(441) = Jac_FULL(60,26)
  JVS(441) = -B(243)
! JVS(442) = Jac_FULL(60,36)
  JVS(442) = -B(131)
! JVS(443) = Jac_FULL(60,37)
  JVS(443) = B(31)
! JVS(444) = Jac_FULL(60,38)
  JVS(444) = B(53)
! JVS(445) = Jac_FULL(60,45)
  JVS(445) = -B(119)
! JVS(446) = Jac_FULL(60,46)
  JVS(446) = -B(143)
! JVS(447) = Jac_FULL(60,47)
  JVS(447) = -B(95)
! JVS(448) = Jac_FULL(60,48)
  JVS(448) = -B(202)
! JVS(449) = Jac_FULL(60,50)
  JVS(449) = -B(121)
! JVS(450) = Jac_FULL(60,51)
  JVS(450) = -B(200)
! JVS(451) = Jac_FULL(60,52)
  JVS(451) = -B(192)
! JVS(452) = Jac_FULL(60,53)
  JVS(452) = -B(105)
! JVS(453) = Jac_FULL(60,54)
  JVS(453) = -B(99)
! JVS(454) = Jac_FULL(60,55)
  JVS(454) = -B(190)
! JVS(455) = Jac_FULL(60,56)
  JVS(455) = -B(149)
! JVS(456) = Jac_FULL(60,57)
  JVS(456) = 0
! JVS(457) = Jac_FULL(60,58)
  JVS(457) = -B(196)
! JVS(458) = Jac_FULL(60,59)
  JVS(458) = B(32)+B(37)-B(73)-B(75)
! JVS(459) = Jac_FULL(60,60)
  JVS(459) = -B(2)-B(49)-B(71)-B(74)-B(76)-2*B(77)-B(78)-B(96)-B(100)-B(106)-B(120)-B(122)-B(132)-B(144)-B(150)-B(191)&
               &-B(193)-B(194)-B(197)-B(198)-B(201)-B(203)-B(238)-B(244)
! JVS(460) = Jac_FULL(60,61)
  JVS(460) = -B(195)
! JVS(461) = Jac_FULL(60,62)
  JVS(461) = -B(199)
! JVS(462) = Jac_FULL(60,63)
  JVS(462) = -B(72)
! JVS(463) = Jac_FULL(60,64)
  JVS(463) = B(38)
! JVS(464) = Jac_FULL(60,65)
  JVS(464) = -B(79)
! JVS(465) = Jac_FULL(60,66)
  JVS(465) = 0
! JVS(466) = Jac_FULL(60,67)
  JVS(466) = -B(50)+B(54)
! JVS(467) = Jac_FULL(61,41)
  JVS(467) = B(91)
! JVS(468) = Jac_FULL(61,43)
  JVS(468) = 0
! JVS(469) = Jac_FULL(61,45)
  JVS(469) = 0.03*B(111)
! JVS(470) = Jac_FULL(61,46)
  JVS(470) = 0
! JVS(471) = Jac_FULL(61,50)
  JVS(471) = 0.09*B(113)
! JVS(472) = Jac_FULL(61,51)
  JVS(472) = 0
! JVS(473) = Jac_FULL(61,56)
  JVS(473) = 0
! JVS(474) = Jac_FULL(61,57)
  JVS(474) = 0
! JVS(475) = Jac_FULL(61,59)
  JVS(475) = 0
! JVS(476) = Jac_FULL(61,60)
  JVS(476) = -B(194)
! JVS(477) = Jac_FULL(61,61)
  JVS(477) = -B(180)-B(195)-B(208)-B(227)
! JVS(478) = Jac_FULL(61,62)
  JVS(478) = 0
! JVS(479) = Jac_FULL(61,63)
  JVS(479) = -B(181)
! JVS(480) = Jac_FULL(61,64)
  JVS(480) = 0.03*B(112)+0.09*B(114)
! JVS(481) = Jac_FULL(61,65)
  JVS(481) = -B(209)
! JVS(482) = Jac_FULL(61,66)
  JVS(482) = 0.77*B(167)
! JVS(483) = Jac_FULL(61,67)
  JVS(483) = B(92)+0.77*B(168)
! JVS(484) = Jac_FULL(62,49)
  JVS(484) = B(101)
! JVS(485) = Jac_FULL(62,50)
  JVS(485) = 0.11*B(113)
! JVS(486) = Jac_FULL(62,56)
  JVS(486) = 0
! JVS(487) = Jac_FULL(62,57)
  JVS(487) = 0
! JVS(488) = Jac_FULL(62,59)
  JVS(488) = 0
! JVS(489) = Jac_FULL(62,60)
  JVS(489) = -B(198)
! JVS(490) = Jac_FULL(62,61)
  JVS(490) = 0
! JVS(491) = Jac_FULL(62,62)
  JVS(491) = -B(184)-B(199)-B(212)-B(229)
! JVS(492) = Jac_FULL(62,63)
  JVS(492) = -B(185)
! JVS(493) = Jac_FULL(62,64)
  JVS(493) = 0.11*B(114)
! JVS(494) = Jac_FULL(62,65)
  JVS(494) = -B(213)
! JVS(495) = Jac_FULL(62,66)
  JVS(495) = 0
! JVS(496) = Jac_FULL(62,67)
  JVS(496) = B(102)
! JVS(497) = Jac_FULL(63,29)
  JVS(497) = -B(127)
! JVS(498) = Jac_FULL(63,32)
  JVS(498) = B(3)
! JVS(499) = Jac_FULL(63,37)
  JVS(499) = B(29)-B(33)
! JVS(500) = Jac_FULL(63,40)
  JVS(500) = -B(153)
! JVS(501) = Jac_FULL(63,43)
  JVS(501) = -B(151)
! JVS(502) = Jac_FULL(63,44)
  JVS(502) = -B(155)
! JVS(503) = Jac_FULL(63,46)
  JVS(503) = 0
! JVS(504) = Jac_FULL(63,48)
  JVS(504) = -B(188)
! JVS(505) = Jac_FULL(63,50)
  JVS(505) = 0
! JVS(506) = Jac_FULL(63,51)
  JVS(506) = -B(186)
! JVS(507) = Jac_FULL(63,52)
  JVS(507) = -B(178)
! JVS(508) = Jac_FULL(63,53)
  JVS(508) = 0
! JVS(509) = Jac_FULL(63,55)
  JVS(509) = -B(176)
! JVS(510) = Jac_FULL(63,56)
  JVS(510) = 0
! JVS(511) = Jac_FULL(63,57)
  JVS(511) = 0
! JVS(512) = Jac_FULL(63,58)
  JVS(512) = -B(182)
! JVS(513) = Jac_FULL(63,59)
  JVS(513) = B(1)+B(30)+B(73)
! JVS(514) = Jac_FULL(63,60)
  JVS(514) = 0.11*B(2)-B(71)+B(74)
! JVS(515) = Jac_FULL(63,61)
  JVS(515) = -B(180)
! JVS(516) = Jac_FULL(63,62)
  JVS(516) = -B(184)
! JVS(517) = Jac_FULL(63,63)
  JVS(517) = -B(34)-B(35)-B(45)-B(64)-B(72)-B(128)-B(152)-B(154)-B(156)-B(177)-B(179)-B(181)-B(183)-B(185)-B(187)-B(189)
! JVS(518) = Jac_FULL(63,64)
  JVS(518) = -B(36)
! JVS(519) = Jac_FULL(63,65)
  JVS(519) = -B(65)
! JVS(520) = Jac_FULL(63,66)
  JVS(520) = 0
! JVS(521) = Jac_FULL(63,67)
  JVS(521) = -B(46)
! JVS(522) = Jac_FULL(64,25)
  JVS(522) = -B(239)
! JVS(523) = Jac_FULL(64,26)
  JVS(523) = -B(245)
! JVS(524) = Jac_FULL(64,34)
  JVS(524) = -B(107)
! JVS(525) = Jac_FULL(64,37)
  JVS(525) = B(25)-B(27)
! JVS(526) = Jac_FULL(64,42)
  JVS(526) = -B(137)
! JVS(527) = Jac_FULL(64,45)
  JVS(527) = -B(111)
! JVS(528) = Jac_FULL(64,46)
  JVS(528) = -B(141)
! JVS(529) = Jac_FULL(64,50)
  JVS(529) = -B(113)
! JVS(530) = Jac_FULL(64,56)
  JVS(530) = -B(147)
! JVS(531) = Jac_FULL(64,58)
  JVS(531) = 0.4*B(210)
! JVS(532) = Jac_FULL(64,59)
  JVS(532) = -B(37)
! JVS(533) = Jac_FULL(64,60)
  JVS(533) = 0
! JVS(534) = Jac_FULL(64,61)
  JVS(534) = 0
! JVS(535) = Jac_FULL(64,62)
  JVS(535) = 0
! JVS(536) = Jac_FULL(64,63)
  JVS(536) = -B(35)
! JVS(537) = Jac_FULL(64,64)
  JVS(537) = -B(7)-B(8)-B(28)-B(36)-B(38)-B(39)-B(41)-B(108)-B(112)-B(114)-B(138)-B(142)-B(148)-B(240)-B(246)
! JVS(538) = Jac_FULL(64,65)
  JVS(538) = -B(42)+0.4*B(211)
! JVS(539) = Jac_FULL(64,66)
  JVS(539) = 0
! JVS(540) = Jac_FULL(64,67)
  JVS(540) = -B(40)
! JVS(541) = Jac_FULL(65,15)
  JVS(541) = B(85)
! JVS(542) = Jac_FULL(65,17)
  JVS(542) = B(218)
! JVS(543) = Jac_FULL(65,19)
  JVS(543) = B(59)
! JVS(544) = Jac_FULL(65,20)
  JVS(544) = 0.2*B(123)
! JVS(545) = Jac_FULL(65,22)
  JVS(545) = 0.55*B(125)
! JVS(546) = Jac_FULL(65,27)
  JVS(546) = B(5)+B(70)
! JVS(547) = Jac_FULL(65,29)
  JVS(547) = 0.95*B(127)
! JVS(548) = Jac_FULL(65,31)
  JVS(548) = B(12)
! JVS(549) = Jac_FULL(65,33)
  JVS(549) = B(13)
! JVS(550) = Jac_FULL(65,34)
  JVS(550) = 0.22*B(107)+B(109)
! JVS(551) = Jac_FULL(65,35)
  JVS(551) = B(174)
! JVS(552) = Jac_FULL(65,36)
  JVS(552) = 0.6*B(129)
! JVS(553) = Jac_FULL(65,39)
  JVS(553) = B(83)
! JVS(554) = Jac_FULL(65,40)
  JVS(554) = 0.8*B(153)-B(159)
! JVS(555) = Jac_FULL(65,42)
  JVS(555) = B(17)+2*B(135)+0.76*B(137)
! JVS(556) = Jac_FULL(65,43)
  JVS(556) = 0.91*B(151)-B(157)
! JVS(557) = Jac_FULL(65,44)
  JVS(557) = B(155)-B(161)
! JVS(558) = Jac_FULL(65,45)
  JVS(558) = 0.26*B(111)+B(115)
! JVS(559) = Jac_FULL(65,46)
  JVS(559) = 0.07*B(141)
! JVS(560) = Jac_FULL(65,47)
  JVS(560) = 2*B(10)+B(93)+B(95)
! JVS(561) = Jac_FULL(65,48)
  JVS(561) = -B(216)
! JVS(562) = Jac_FULL(65,50)
  JVS(562) = 0.22*B(113)+B(117)
! JVS(563) = Jac_FULL(65,51)
  JVS(563) = 0.5*B(186)+0.5*B(200)-B(214)
! JVS(564) = Jac_FULL(65,52)
  JVS(564) = B(178)+B(192)-B(206)+0.6*B(226)
! JVS(565) = Jac_FULL(65,53)
  JVS(565) = B(16)
! JVS(566) = Jac_FULL(65,54)
  JVS(566) = B(14)
! JVS(567) = Jac_FULL(65,55)
  JVS(567) = B(176)+B(190)-B(204)+0.32*B(225)
! JVS(568) = Jac_FULL(65,56)
  JVS(568) = 0.33*B(20)+0.1*B(147)+0.93*B(149)
! JVS(569) = Jac_FULL(65,57)
  JVS(569) = 0.9*B(19)
! JVS(570) = Jac_FULL(65,58)
  JVS(570) = -B(210)
! JVS(571) = Jac_FULL(65,59)
  JVS(571) = -B(66)-B(68)
! JVS(572) = Jac_FULL(65,60)
  JVS(572) = B(49)-B(78)+B(96)+0.93*B(150)+B(191)+B(193)+0.9*B(194)+0.5*B(201)
! JVS(573) = Jac_FULL(65,61)
  JVS(573) = 0.76*B(180)+0.9*B(195)-B(208)+0.54*B(227)
! JVS(574) = Jac_FULL(65,62)
  JVS(574) = -B(212)
! JVS(575) = Jac_FULL(65,63)
  JVS(575) = -B(64)+0.95*B(128)+0.91*B(152)+0.8*B(154)+B(156)+B(177)+B(179)+0.76*B(181)+0.5*B(187)
! JVS(576) = Jac_FULL(65,64)
  JVS(576) = B(39)-B(41)+0.22*B(108)+0.26*B(112)+0.22*B(114)+0.76*B(138)+0.07*B(142)+0.1*B(148)
! JVS(577) = Jac_FULL(65,65)
  JVS(577) = -B(42)-B(57)-2*B(61)-2*B(62)-B(65)-B(67)-B(69)-B(79)-B(158)-B(160)-B(162)-B(205)-B(207)-B(209)-B(211)&
               &-B(213)-B(215)-B(217)
! JVS(578) = Jac_FULL(65,66)
  JVS(578) = 0.9*B(18)
! JVS(579) = Jac_FULL(65,67)
  JVS(579) = B(40)+B(43)+B(50)-B(58)+B(60)+B(84)+B(86)+B(94)+B(110)+B(116)+B(118)+0.2*B(124)+0.55*B(126)+0.6*B(130)+2&
               &*B(136)+B(175)+B(219)
! JVS(580) = Jac_FULL(66,43)
  JVS(580) = B(157)
! JVS(581) = Jac_FULL(66,44)
  JVS(581) = B(161)
! JVS(582) = Jac_FULL(66,46)
  JVS(582) = 0
! JVS(583) = Jac_FULL(66,56)
  JVS(583) = 0
! JVS(584) = Jac_FULL(66,60)
  JVS(584) = 0
! JVS(585) = Jac_FULL(66,61)
  JVS(585) = B(208)
! JVS(586) = Jac_FULL(66,62)
  JVS(586) = B(212)
! JVS(587) = Jac_FULL(66,63)
  JVS(587) = 0
! JVS(588) = Jac_FULL(66,64)
  JVS(588) = 0
! JVS(589) = Jac_FULL(66,65)
  JVS(589) = B(158)+B(162)+B(209)+B(213)
! JVS(590) = Jac_FULL(66,66)
  JVS(590) = -B(18)-B(167)
! JVS(591) = Jac_FULL(66,67)
  JVS(591) = -B(168)
! JVS(592) = Jac_FULL(67,15)
  JVS(592) = -B(85)
! JVS(593) = Jac_FULL(67,16)
  JVS(593) = 2*B(23)
! JVS(594) = Jac_FULL(67,17)
  JVS(594) = -B(218)
! JVS(595) = Jac_FULL(67,19)
  JVS(595) = 2*B(9)-B(59)
! JVS(596) = Jac_FULL(67,20)
  JVS(596) = -B(123)
! JVS(597) = Jac_FULL(67,22)
  JVS(597) = -B(125)
! JVS(598) = Jac_FULL(67,23)
  JVS(598) = -B(87)
! JVS(599) = Jac_FULL(67,25)
  JVS(599) = -B(235)
! JVS(600) = Jac_FULL(67,26)
  JVS(600) = -B(241)
! JVS(601) = Jac_FULL(67,27)
  JVS(601) = -B(55)
! JVS(602) = Jac_FULL(67,28)
  JVS(602) = -B(89)
! JVS(603) = Jac_FULL(67,31)
  JVS(603) = B(12)-0.7*B(163)
! JVS(604) = Jac_FULL(67,32)
  JVS(604) = B(3)-B(51)
! JVS(605) = Jac_FULL(67,33)
  JVS(605) = B(13)-0.7*B(165)
! JVS(606) = Jac_FULL(67,34)
  JVS(606) = 0.12*B(107)-B(109)
! JVS(607) = Jac_FULL(67,35)
  JVS(607) = -B(174)
! JVS(608) = Jac_FULL(67,36)
  JVS(608) = -B(129)
! JVS(609) = Jac_FULL(67,38)
  JVS(609) = B(4)-B(53)
! JVS(610) = Jac_FULL(67,39)
  JVS(610) = -B(83)
! JVS(611) = Jac_FULL(67,41)
  JVS(611) = -B(91)
! JVS(612) = Jac_FULL(67,42)
  JVS(612) = -B(135)+0.08*B(137)
! JVS(613) = Jac_FULL(67,43)
  JVS(613) = 0
! JVS(614) = Jac_FULL(67,44)
  JVS(614) = 0
! JVS(615) = Jac_FULL(67,45)
  JVS(615) = 0.33*B(111)-B(115)
! JVS(616) = Jac_FULL(67,46)
  JVS(616) = -B(139)+0.27*B(141)
! JVS(617) = Jac_FULL(67,47)
  JVS(617) = -B(93)
! JVS(618) = Jac_FULL(67,49)
  JVS(618) = -B(101)
! JVS(619) = Jac_FULL(67,50)
  JVS(619) = 0.6*B(113)-B(117)
! JVS(620) = Jac_FULL(67,51)
  JVS(620) = 0
! JVS(621) = Jac_FULL(67,52)
  JVS(621) = 0
! JVS(622) = Jac_FULL(67,53)
  JVS(622) = -B(103)
! JVS(623) = Jac_FULL(67,54)
  JVS(623) = -B(97)
! JVS(624) = Jac_FULL(67,55)
  JVS(624) = 0
! JVS(625) = Jac_FULL(67,56)
  JVS(625) = -B(145)+0.27*B(147)
! JVS(626) = Jac_FULL(67,57)
  JVS(626) = -B(169)
! JVS(627) = Jac_FULL(67,58)
  JVS(627) = 0
! JVS(628) = Jac_FULL(67,59)
  JVS(628) = -B(47)
! JVS(629) = Jac_FULL(67,60)
  JVS(629) = -B(49)+0.7*B(78)
! JVS(630) = Jac_FULL(67,61)
  JVS(630) = 0
! JVS(631) = Jac_FULL(67,62)
  JVS(631) = 0
! JVS(632) = Jac_FULL(67,63)
  JVS(632) = -B(45)+B(64)
! JVS(633) = Jac_FULL(67,64)
  JVS(633) = -B(39)+B(41)+0.12*B(108)+0.33*B(112)+0.6*B(114)+0.08*B(138)+0.27*B(142)+0.27*B(148)
! JVS(634) = Jac_FULL(67,65)
  JVS(634) = B(42)-B(57)+B(65)+0.7*B(79)
! JVS(635) = Jac_FULL(67,66)
  JVS(635) = B(18)-0.77*B(167)
! JVS(636) = Jac_FULL(67,67)
  JVS(636) = -B(40)-B(43)-B(46)-B(48)-B(50)-B(52)-B(54)-B(56)-B(58)-B(60)-B(84)-B(86)-B(88)-B(90)-B(92)-B(94)-B(98)&
               &-B(102)-B(104)-B(110)-B(116)-B(118)-B(124)-B(126)-B(130)-B(136)-B(140)-B(146)-0.7*B(164)-0.7*B(166)-0.77&
               &*B(168)-B(170)-B(175)-B(219)-B(236)-B(242)
      
END SUBROUTINE Jac_SP

! End of Jac_SP function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP_Vec - function for sparse multiplication: sparse Jacobian times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JUV       - Jacobian times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP_Vec ( JVS, UV, JUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JUV - Jacobian times user vector
  REAL(kind=dp) :: JUV(NVAR)

  JUV(1) = JVS(1)*UV(1)+JVS(2)*UV(15)+JVS(3)*UV(67)
  JUV(2) = JVS(4)*UV(2)
  JUV(3) = JVS(5)*UV(3)
  JUV(4) = JVS(6)*UV(4)+JVS(7)*UV(34)+JVS(8)*UV(45)+JVS(9)*UV(64)
  JUV(5) = JVS(10)*UV(5)+JVS(11)*UV(45)+JVS(12)*UV(46)+JVS(13)*UV(50)+JVS(14)*UV(56)+JVS(15)*UV(58)+JVS(16)*UV(64)&
             &+JVS(17)*UV(65)
  JUV(6) = JVS(18)*UV(6)+JVS(19)*UV(20)+JVS(20)*UV(22)+JVS(21)*UV(36)+JVS(22)*UV(60)+JVS(23)*UV(67)
  JUV(7) = JVS(24)*UV(7)+JVS(25)*UV(20)+JVS(26)*UV(22)+JVS(27)*UV(36)+JVS(28)*UV(60)+JVS(29)*UV(67)
  JUV(8) = JVS(30)*UV(8)+JVS(31)*UV(41)+JVS(32)*UV(67)
  JUV(9) = JVS(33)*UV(9)+JVS(34)*UV(45)+JVS(35)*UV(50)+JVS(36)*UV(60)+JVS(37)*UV(64)+JVS(38)*UV(67)
  JUV(10) = JVS(39)*UV(10)+JVS(40)*UV(25)+JVS(41)*UV(64)+JVS(42)*UV(67)
  JUV(11) = JVS(43)*UV(11)+JVS(44)*UV(25)+JVS(45)*UV(64)+JVS(46)*UV(67)
  JUV(12) = JVS(47)*UV(12)+JVS(48)*UV(26)+JVS(49)*UV(64)+JVS(50)*UV(67)
  JUV(13) = JVS(51)*UV(13)+JVS(52)*UV(26)+JVS(53)*UV(64)+JVS(54)*UV(67)
  JUV(14) = JVS(55)*UV(14)+JVS(56)*UV(30)+JVS(57)*UV(41)+JVS(58)*UV(48)+JVS(59)*UV(65)
  JUV(15) = JVS(60)*UV(15)+JVS(61)*UV(67)
  JUV(16) = JVS(62)*UV(16)+JVS(63)*UV(64)
  JUV(17) = JVS(64)*UV(17)+JVS(65)*UV(67)
  JUV(18) = JVS(66)*UV(18)+JVS(67)*UV(58)+JVS(68)*UV(59)
  JUV(19) = JVS(69)*UV(19)+JVS(70)*UV(65)+JVS(71)*UV(67)
  JUV(20) = JVS(72)*UV(20)+JVS(73)*UV(67)
  JUV(21) = JVS(74)*UV(21)+JVS(75)*UV(59)+JVS(76)*UV(60)
  JUV(22) = JVS(77)*UV(22)+JVS(78)*UV(67)
  JUV(23) = JVS(79)*UV(23)+JVS(80)*UV(45)+JVS(81)*UV(50)+JVS(82)*UV(64)+JVS(83)*UV(67)
  JUV(24) = JVS(84)*UV(24)+JVS(85)*UV(36)+JVS(86)*UV(59)+JVS(87)*UV(60)+JVS(88)*UV(67)
  JUV(25) = JVS(89)*UV(25)+JVS(90)*UV(60)+JVS(91)*UV(64)+JVS(92)*UV(67)
  JUV(26) = JVS(93)*UV(26)+JVS(94)*UV(60)+JVS(95)*UV(64)+JVS(96)*UV(67)
  JUV(27) = JVS(97)*UV(27)+JVS(98)*UV(59)+JVS(99)*UV(65)+JVS(100)*UV(67)
  JUV(28) = JVS(101)*UV(28)+JVS(102)*UV(45)+JVS(103)*UV(50)+JVS(104)*UV(52)+JVS(105)*UV(64)+JVS(106)*UV(67)
  JUV(29) = JVS(107)*UV(20)+JVS(108)*UV(22)+JVS(109)*UV(29)+JVS(110)*UV(63)+JVS(111)*UV(67)
  JUV(30) = JVS(112)*UV(30)+JVS(113)*UV(41)+JVS(114)*UV(45)+JVS(115)*UV(50)+JVS(116)*UV(51)+JVS(117)*UV(57)+JVS(118)&
              &*UV(60)+JVS(119)*UV(61)+JVS(120)*UV(63)+JVS(121)*UV(64)+JVS(122)*UV(66)+JVS(123)*UV(67)
  JUV(31) = JVS(124)*UV(31)+JVS(125)*UV(55)+JVS(126)*UV(65)+JVS(127)*UV(67)
  JUV(32) = JVS(128)*UV(32)+JVS(129)*UV(59)+JVS(130)*UV(63)+JVS(131)*UV(65)+JVS(132)*UV(67)
  JUV(33) = JVS(133)*UV(33)+JVS(134)*UV(52)+JVS(135)*UV(65)+JVS(136)*UV(67)
  JUV(34) = JVS(137)*UV(34)+JVS(138)*UV(64)+JVS(139)*UV(67)
  JUV(35) = JVS(140)*UV(35)+JVS(141)*UV(45)+JVS(142)*UV(50)+JVS(143)*UV(55)+JVS(144)*UV(64)+JVS(145)*UV(67)
  JUV(36) = JVS(146)*UV(20)+JVS(147)*UV(22)+JVS(148)*UV(36)+JVS(149)*UV(60)+JVS(150)*UV(67)
  JUV(37) = JVS(151)*UV(16)+JVS(152)*UV(37)+JVS(153)*UV(59)+JVS(154)*UV(60)+JVS(155)*UV(63)+JVS(156)*UV(64)
  JUV(38) = JVS(157)*UV(21)+JVS(158)*UV(36)+JVS(159)*UV(38)+JVS(160)*UV(47)+JVS(161)*UV(53)+JVS(162)*UV(54)+JVS(163)&
              &*UV(56)+JVS(164)*UV(59)+JVS(165)*UV(60)+JVS(166)*UV(65)+JVS(167)*UV(67)
  JUV(39) = JVS(168)*UV(34)+JVS(169)*UV(39)+JVS(170)*UV(42)+JVS(171)*UV(44)+JVS(172)*UV(45)+JVS(173)*UV(46)+JVS(174)&
              &*UV(47)+JVS(175)*UV(50)+JVS(176)*UV(53)+JVS(177)*UV(54)+JVS(178)*UV(56)+JVS(179)*UV(60)+JVS(180)*UV(63)&
              &+JVS(181)*UV(64)+JVS(182)*UV(67)
  JUV(40) = JVS(183)*UV(40)+JVS(184)*UV(46)+JVS(185)*UV(60)+JVS(186)*UV(63)+JVS(187)*UV(65)
  JUV(41) = JVS(188)*UV(22)+JVS(189)*UV(30)+JVS(190)*UV(40)+JVS(191)*UV(41)+JVS(192)*UV(43)+JVS(197)*UV(56)+JVS(199)&
              &*UV(60)+JVS(201)*UV(63)+JVS(203)*UV(65)+JVS(205)*UV(67)
  JUV(42) = JVS(206)*UV(29)+JVS(207)*UV(36)+JVS(208)*UV(42)+JVS(210)*UV(63)+JVS(211)*UV(64)+JVS(212)*UV(67)
  JUV(43) = JVS(213)*UV(43)+JVS(214)*UV(46)+JVS(215)*UV(63)+JVS(216)*UV(65)+JVS(217)*UV(67)
  JUV(44) = JVS(218)*UV(44)+JVS(219)*UV(56)+JVS(220)*UV(63)+JVS(221)*UV(65)+JVS(222)*UV(67)
  JUV(45) = JVS(223)*UV(45)+JVS(224)*UV(60)+JVS(225)*UV(64)+JVS(226)*UV(67)
  JUV(46) = JVS(227)*UV(46)+JVS(228)*UV(60)+JVS(229)*UV(64)+JVS(230)*UV(67)
  JUV(47) = JVS(231)*UV(31)+JVS(232)*UV(34)+JVS(233)*UV(35)+JVS(234)*UV(42)+JVS(235)*UV(43)+JVS(236)*UV(44)+JVS(237)&
              &*UV(45)+JVS(238)*UV(46)+JVS(239)*UV(47)+JVS(241)*UV(51)+JVS(242)*UV(55)+JVS(243)*UV(56)+JVS(244)*UV(60)&
              &+JVS(245)*UV(62)+JVS(246)*UV(63)+JVS(247)*UV(64)+JVS(249)*UV(67)
  JUV(48) = JVS(250)*UV(20)+JVS(251)*UV(22)+JVS(252)*UV(34)+JVS(253)*UV(36)+JVS(254)*UV(42)+JVS(255)*UV(45)+JVS(256)&
              &*UV(46)+JVS(257)*UV(48)+JVS(258)*UV(50)+JVS(259)*UV(53)+JVS(260)*UV(56)+JVS(261)*UV(57)+JVS(262)*UV(60)&
              &+JVS(263)*UV(61)+JVS(264)*UV(63)+JVS(265)*UV(64)+JVS(266)*UV(65)+JVS(267)*UV(66)+JVS(268)*UV(67)
  JUV(49) = JVS(269)*UV(44)+JVS(270)*UV(49)+JVS(271)*UV(50)+JVS(272)*UV(56)+JVS(273)*UV(57)+JVS(274)*UV(60)+JVS(275)&
              &*UV(61)+JVS(276)*UV(62)+JVS(277)*UV(63)+JVS(278)*UV(64)+JVS(280)*UV(66)+JVS(281)*UV(67)
  JUV(50) = JVS(282)*UV(50)+JVS(283)*UV(60)+JVS(284)*UV(64)+JVS(285)*UV(67)
  JUV(51) = JVS(286)*UV(45)+JVS(287)*UV(50)+JVS(288)*UV(51)+JVS(289)*UV(57)+JVS(290)*UV(60)+JVS(291)*UV(63)+JVS(293)&
              &*UV(65)+JVS(294)*UV(67)
  JUV(52) = JVS(295)*UV(28)+JVS(296)*UV(33)+JVS(297)*UV(45)+JVS(298)*UV(50)+JVS(299)*UV(52)+JVS(300)*UV(57)+JVS(301)&
              &*UV(60)+JVS(302)*UV(61)+JVS(303)*UV(63)+JVS(304)*UV(64)+JVS(305)*UV(65)+JVS(306)*UV(66)+JVS(307)*UV(67)
  JUV(53) = JVS(308)*UV(22)+JVS(309)*UV(42)+JVS(310)*UV(44)+JVS(311)*UV(45)+JVS(312)*UV(50)+JVS(313)*UV(53)+JVS(314)&
              &*UV(56)+JVS(315)*UV(60)+JVS(316)*UV(62)+JVS(317)*UV(63)+JVS(318)*UV(64)+JVS(320)*UV(66)+JVS(321)*UV(67)
  JUV(54) = JVS(322)*UV(17)+JVS(323)*UV(33)+JVS(324)*UV(34)+JVS(325)*UV(40)+JVS(326)*UV(42)+JVS(327)*UV(44)+JVS(328)&
              &*UV(45)+JVS(329)*UV(46)+JVS(330)*UV(50)+JVS(331)*UV(51)+JVS(332)*UV(52)+JVS(333)*UV(54)+JVS(334)*UV(56)&
              &+JVS(335)*UV(57)+JVS(336)*UV(60)+JVS(337)*UV(61)+JVS(338)*UV(63)+JVS(339)*UV(64)+JVS(341)*UV(66)+JVS(342)&
              &*UV(67)
  JUV(55) = JVS(343)*UV(23)+JVS(344)*UV(31)+JVS(345)*UV(45)+JVS(346)*UV(49)+JVS(347)*UV(50)+JVS(348)*UV(54)+JVS(349)&
              &*UV(55)+JVS(350)*UV(56)+JVS(352)*UV(58)+JVS(353)*UV(60)+JVS(356)*UV(63)+JVS(357)*UV(64)+JVS(358)*UV(65)&
              &+JVS(360)*UV(67)
  JUV(56) = JVS(361)*UV(40)+JVS(362)*UV(43)+JVS(363)*UV(46)+JVS(364)*UV(56)+JVS(365)*UV(60)+JVS(366)*UV(63)+JVS(367)&
              &*UV(64)+JVS(369)*UV(67)
  JUV(57) = JVS(370)*UV(24)+JVS(371)*UV(29)+JVS(373)*UV(40)+JVS(374)*UV(43)+JVS(376)*UV(51)+JVS(377)*UV(56)+JVS(378)&
              &*UV(57)+JVS(379)*UV(59)+JVS(380)*UV(60)+JVS(381)*UV(61)+JVS(382)*UV(63)+JVS(384)*UV(65)+JVS(385)*UV(67)
  JUV(58) = JVS(386)*UV(18)+JVS(387)*UV(42)+JVS(388)*UV(45)+JVS(389)*UV(46)+JVS(390)*UV(49)+JVS(391)*UV(50)+JVS(392)&
              &*UV(53)+JVS(393)*UV(54)+JVS(394)*UV(56)+JVS(396)*UV(58)+JVS(397)*UV(59)+JVS(398)*UV(60)+JVS(400)*UV(62)&
              &+JVS(401)*UV(63)+JVS(402)*UV(64)+JVS(403)*UV(65)+JVS(405)*UV(67)
  JUV(59) = JVS(406)*UV(18)+JVS(407)*UV(21)+JVS(408)*UV(24)+JVS(409)*UV(27)+JVS(410)*UV(29)+JVS(411)*UV(32)+JVS(413)&
              &*UV(37)+JVS(414)*UV(38)+JVS(415)*UV(40)+JVS(416)*UV(43)+JVS(417)*UV(44)+JVS(420)*UV(48)+JVS(422)*UV(51)&
              &+JVS(423)*UV(52)+JVS(426)*UV(55)+JVS(428)*UV(57)+JVS(429)*UV(58)+JVS(430)*UV(59)+JVS(431)*UV(60)+JVS(432)&
              &*UV(61)+JVS(433)*UV(62)+JVS(434)*UV(63)+JVS(435)*UV(64)+JVS(436)*UV(65)+JVS(438)*UV(67)
  JUV(60) = JVS(439)*UV(21)+JVS(440)*UV(25)+JVS(441)*UV(26)+JVS(442)*UV(36)+JVS(443)*UV(37)+JVS(444)*UV(38)+JVS(445)&
              &*UV(45)+JVS(446)*UV(46)+JVS(447)*UV(47)+JVS(448)*UV(48)+JVS(449)*UV(50)+JVS(450)*UV(51)+JVS(451)*UV(52)&
              &+JVS(452)*UV(53)+JVS(453)*UV(54)+JVS(454)*UV(55)+JVS(455)*UV(56)+JVS(457)*UV(58)+JVS(458)*UV(59)+JVS(459)&
              &*UV(60)+JVS(460)*UV(61)+JVS(461)*UV(62)+JVS(462)*UV(63)+JVS(463)*UV(64)+JVS(464)*UV(65)+JVS(466)*UV(67)
  JUV(61) = JVS(467)*UV(41)+JVS(469)*UV(45)+JVS(471)*UV(50)+JVS(476)*UV(60)+JVS(477)*UV(61)+JVS(479)*UV(63)+JVS(480)&
              &*UV(64)+JVS(481)*UV(65)+JVS(482)*UV(66)+JVS(483)*UV(67)
  JUV(62) = JVS(484)*UV(49)+JVS(485)*UV(50)+JVS(489)*UV(60)+JVS(491)*UV(62)+JVS(492)*UV(63)+JVS(493)*UV(64)+JVS(494)&
              &*UV(65)+JVS(496)*UV(67)
  JUV(63) = JVS(497)*UV(29)+JVS(498)*UV(32)+JVS(499)*UV(37)+JVS(500)*UV(40)+JVS(501)*UV(43)+JVS(502)*UV(44)+JVS(504)&
              &*UV(48)+JVS(506)*UV(51)+JVS(507)*UV(52)+JVS(509)*UV(55)+JVS(512)*UV(58)+JVS(513)*UV(59)+JVS(514)*UV(60)&
              &+JVS(515)*UV(61)+JVS(516)*UV(62)+JVS(517)*UV(63)+JVS(518)*UV(64)+JVS(519)*UV(65)+JVS(521)*UV(67)
  JUV(64) = JVS(522)*UV(25)+JVS(523)*UV(26)+JVS(524)*UV(34)+JVS(525)*UV(37)+JVS(526)*UV(42)+JVS(527)*UV(45)+JVS(528)&
              &*UV(46)+JVS(529)*UV(50)+JVS(530)*UV(56)+JVS(531)*UV(58)+JVS(532)*UV(59)+JVS(536)*UV(63)+JVS(537)*UV(64)&
              &+JVS(538)*UV(65)+JVS(540)*UV(67)
  JUV(65) = JVS(541)*UV(15)+JVS(542)*UV(17)+JVS(543)*UV(19)+JVS(544)*UV(20)+JVS(545)*UV(22)+JVS(546)*UV(27)+JVS(547)&
              &*UV(29)+JVS(548)*UV(31)+JVS(549)*UV(33)+JVS(550)*UV(34)+JVS(551)*UV(35)+JVS(552)*UV(36)+JVS(553)*UV(39)&
              &+JVS(554)*UV(40)+JVS(555)*UV(42)+JVS(556)*UV(43)+JVS(557)*UV(44)+JVS(558)*UV(45)+JVS(559)*UV(46)+JVS(560)&
              &*UV(47)+JVS(561)*UV(48)+JVS(562)*UV(50)+JVS(563)*UV(51)+JVS(564)*UV(52)+JVS(565)*UV(53)+JVS(566)*UV(54)&
              &+JVS(567)*UV(55)+JVS(568)*UV(56)+JVS(569)*UV(57)+JVS(570)*UV(58)+JVS(571)*UV(59)+JVS(572)*UV(60)+JVS(573)&
              &*UV(61)+JVS(574)*UV(62)+JVS(575)*UV(63)+JVS(576)*UV(64)+JVS(577)*UV(65)+JVS(578)*UV(66)+JVS(579)*UV(67)
  JUV(66) = JVS(580)*UV(43)+JVS(581)*UV(44)+JVS(585)*UV(61)+JVS(586)*UV(62)+JVS(589)*UV(65)+JVS(590)*UV(66)+JVS(591)&
              &*UV(67)
  JUV(67) = JVS(592)*UV(15)+JVS(593)*UV(16)+JVS(594)*UV(17)+JVS(595)*UV(19)+JVS(596)*UV(20)+JVS(597)*UV(22)+JVS(598)&
              &*UV(23)+JVS(599)*UV(25)+JVS(600)*UV(26)+JVS(601)*UV(27)+JVS(602)*UV(28)+JVS(603)*UV(31)+JVS(604)*UV(32)&
              &+JVS(605)*UV(33)+JVS(606)*UV(34)+JVS(607)*UV(35)+JVS(608)*UV(36)+JVS(609)*UV(38)+JVS(610)*UV(39)+JVS(611)&
              &*UV(41)+JVS(612)*UV(42)+JVS(615)*UV(45)+JVS(616)*UV(46)+JVS(617)*UV(47)+JVS(618)*UV(49)+JVS(619)*UV(50)&
              &+JVS(622)*UV(53)+JVS(623)*UV(54)+JVS(625)*UV(56)+JVS(626)*UV(57)+JVS(628)*UV(59)+JVS(629)*UV(60)+JVS(632)&
              &*UV(63)+JVS(633)*UV(64)+JVS(634)*UV(65)+JVS(635)*UV(66)+JVS(636)*UV(67)
      
END SUBROUTINE Jac_SP_Vec

! End of Jac_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacTR_SP_Vec - sparse multiplication: sparse Jacobian transposed times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JTUV      - Jacobian transposed times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacTR_SP_Vec ( JVS, UV, JTUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JTUV - Jacobian transposed times user vector
  REAL(kind=dp) :: JTUV(NVAR)

  JTUV(1) = JVS(1)*UV(1)
  JTUV(2) = JVS(4)*UV(2)
  JTUV(3) = JVS(5)*UV(3)
  JTUV(4) = JVS(6)*UV(4)
  JTUV(5) = JVS(10)*UV(5)
  JTUV(6) = JVS(18)*UV(6)
  JTUV(7) = JVS(24)*UV(7)
  JTUV(8) = JVS(30)*UV(8)
  JTUV(9) = JVS(33)*UV(9)
  JTUV(10) = JVS(39)*UV(10)
  JTUV(11) = JVS(43)*UV(11)
  JTUV(12) = JVS(47)*UV(12)
  JTUV(13) = JVS(51)*UV(13)
  JTUV(14) = JVS(55)*UV(14)
  JTUV(15) = JVS(2)*UV(1)+JVS(60)*UV(15)+JVS(541)*UV(65)+JVS(592)*UV(67)
  JTUV(16) = JVS(62)*UV(16)+JVS(151)*UV(37)+JVS(593)*UV(67)
  JTUV(17) = JVS(64)*UV(17)+JVS(322)*UV(54)+JVS(542)*UV(65)+JVS(594)*UV(67)
  JTUV(18) = JVS(66)*UV(18)+JVS(386)*UV(58)+JVS(406)*UV(59)
  JTUV(19) = JVS(69)*UV(19)+JVS(543)*UV(65)+JVS(595)*UV(67)
  JTUV(20) = JVS(19)*UV(6)+JVS(25)*UV(7)+JVS(72)*UV(20)+JVS(107)*UV(29)+JVS(146)*UV(36)+JVS(250)*UV(48)+JVS(544)*UV(65)&
               &+JVS(596)*UV(67)
  JTUV(21) = JVS(74)*UV(21)+JVS(157)*UV(38)+JVS(407)*UV(59)+JVS(439)*UV(60)
  JTUV(22) = JVS(20)*UV(6)+JVS(26)*UV(7)+JVS(77)*UV(22)+JVS(108)*UV(29)+JVS(147)*UV(36)+JVS(188)*UV(41)+JVS(251)*UV(48)&
               &+JVS(308)*UV(53)+JVS(545)*UV(65)+JVS(597)*UV(67)
  JTUV(23) = JVS(79)*UV(23)+JVS(343)*UV(55)+JVS(598)*UV(67)
  JTUV(24) = JVS(84)*UV(24)+JVS(370)*UV(57)+JVS(408)*UV(59)
  JTUV(25) = JVS(40)*UV(10)+JVS(44)*UV(11)+JVS(89)*UV(25)+JVS(440)*UV(60)+JVS(522)*UV(64)+JVS(599)*UV(67)
  JTUV(26) = JVS(48)*UV(12)+JVS(52)*UV(13)+JVS(93)*UV(26)+JVS(441)*UV(60)+JVS(523)*UV(64)+JVS(600)*UV(67)
  JTUV(27) = JVS(97)*UV(27)+JVS(409)*UV(59)+JVS(546)*UV(65)+JVS(601)*UV(67)
  JTUV(28) = JVS(101)*UV(28)+JVS(295)*UV(52)+JVS(602)*UV(67)
  JTUV(29) = JVS(109)*UV(29)+JVS(206)*UV(42)+JVS(371)*UV(57)+JVS(410)*UV(59)+JVS(497)*UV(63)+JVS(547)*UV(65)
  JTUV(30) = JVS(56)*UV(14)+JVS(112)*UV(30)+JVS(189)*UV(41)
  JTUV(31) = JVS(124)*UV(31)+JVS(231)*UV(47)+JVS(344)*UV(55)+JVS(548)*UV(65)+JVS(603)*UV(67)
  JTUV(32) = JVS(128)*UV(32)+JVS(411)*UV(59)+JVS(498)*UV(63)+JVS(604)*UV(67)
  JTUV(33) = JVS(133)*UV(33)+JVS(296)*UV(52)+JVS(323)*UV(54)+JVS(549)*UV(65)+JVS(605)*UV(67)
  JTUV(34) = JVS(7)*UV(4)+JVS(137)*UV(34)+JVS(168)*UV(39)+JVS(232)*UV(47)+JVS(252)*UV(48)+JVS(324)*UV(54)+JVS(524)&
               &*UV(64)+JVS(550)*UV(65)+JVS(606)*UV(67)
  JTUV(35) = JVS(140)*UV(35)+JVS(233)*UV(47)+JVS(551)*UV(65)+JVS(607)*UV(67)
  JTUV(36) = JVS(21)*UV(6)+JVS(27)*UV(7)+JVS(85)*UV(24)+JVS(148)*UV(36)+JVS(158)*UV(38)+JVS(207)*UV(42)+JVS(253)*UV(48)&
               &+JVS(442)*UV(60)+JVS(552)*UV(65)+JVS(608)*UV(67)
  JTUV(37) = JVS(152)*UV(37)+JVS(413)*UV(59)+JVS(443)*UV(60)+JVS(499)*UV(63)+JVS(525)*UV(64)
  JTUV(38) = JVS(159)*UV(38)+JVS(414)*UV(59)+JVS(444)*UV(60)+JVS(609)*UV(67)
  JTUV(39) = JVS(169)*UV(39)+JVS(553)*UV(65)+JVS(610)*UV(67)
  JTUV(40) = JVS(183)*UV(40)+JVS(190)*UV(41)+JVS(325)*UV(54)+JVS(361)*UV(56)+JVS(373)*UV(57)+JVS(415)*UV(59)+JVS(500)&
               &*UV(63)+JVS(554)*UV(65)
  JTUV(41) = JVS(31)*UV(8)+JVS(57)*UV(14)+JVS(113)*UV(30)+JVS(191)*UV(41)+JVS(467)*UV(61)+JVS(611)*UV(67)
  JTUV(42) = JVS(170)*UV(39)+JVS(208)*UV(42)+JVS(234)*UV(47)+JVS(254)*UV(48)+JVS(309)*UV(53)+JVS(326)*UV(54)+JVS(387)&
               &*UV(58)+JVS(526)*UV(64)+JVS(555)*UV(65)+JVS(612)*UV(67)
  JTUV(43) = JVS(192)*UV(41)+JVS(213)*UV(43)+JVS(235)*UV(47)+JVS(362)*UV(56)+JVS(374)*UV(57)+JVS(416)*UV(59)+JVS(501)&
               &*UV(63)+JVS(556)*UV(65)+JVS(580)*UV(66)
  JTUV(44) = JVS(171)*UV(39)+JVS(218)*UV(44)+JVS(236)*UV(47)+JVS(269)*UV(49)+JVS(310)*UV(53)+JVS(327)*UV(54)+JVS(417)&
               &*UV(59)+JVS(502)*UV(63)+JVS(557)*UV(65)+JVS(581)*UV(66)
  JTUV(45) = JVS(8)*UV(4)+JVS(11)*UV(5)+JVS(34)*UV(9)+JVS(80)*UV(23)+JVS(102)*UV(28)+JVS(114)*UV(30)+JVS(141)*UV(35)&
               &+JVS(172)*UV(39)+JVS(223)*UV(45)+JVS(237)*UV(47)+JVS(255)*UV(48)+JVS(286)*UV(51)+JVS(297)*UV(52)+JVS(311)&
               &*UV(53)+JVS(328)*UV(54)+JVS(345)*UV(55)+JVS(388)*UV(58)+JVS(445)*UV(60)+JVS(469)*UV(61)+JVS(527)*UV(64)&
               &+JVS(558)*UV(65)+JVS(615)*UV(67)
  JTUV(46) = JVS(12)*UV(5)+JVS(173)*UV(39)+JVS(184)*UV(40)+JVS(214)*UV(43)+JVS(227)*UV(46)+JVS(238)*UV(47)+JVS(256)&
               &*UV(48)+JVS(329)*UV(54)+JVS(363)*UV(56)+JVS(389)*UV(58)+JVS(446)*UV(60)+JVS(528)*UV(64)+JVS(559)*UV(65)&
               &+JVS(616)*UV(67)
  JTUV(47) = JVS(160)*UV(38)+JVS(174)*UV(39)+JVS(239)*UV(47)+JVS(447)*UV(60)+JVS(560)*UV(65)+JVS(617)*UV(67)
  JTUV(48) = JVS(58)*UV(14)+JVS(257)*UV(48)+JVS(420)*UV(59)+JVS(448)*UV(60)+JVS(504)*UV(63)+JVS(561)*UV(65)
  JTUV(49) = JVS(270)*UV(49)+JVS(346)*UV(55)+JVS(390)*UV(58)+JVS(484)*UV(62)+JVS(618)*UV(67)
  JTUV(50) = JVS(13)*UV(5)+JVS(35)*UV(9)+JVS(81)*UV(23)+JVS(103)*UV(28)+JVS(115)*UV(30)+JVS(142)*UV(35)+JVS(175)*UV(39)&
               &+JVS(258)*UV(48)+JVS(271)*UV(49)+JVS(282)*UV(50)+JVS(287)*UV(51)+JVS(298)*UV(52)+JVS(312)*UV(53)+JVS(330)&
               &*UV(54)+JVS(347)*UV(55)+JVS(391)*UV(58)+JVS(449)*UV(60)+JVS(471)*UV(61)+JVS(485)*UV(62)+JVS(529)*UV(64)&
               &+JVS(562)*UV(65)+JVS(619)*UV(67)
  JTUV(51) = JVS(116)*UV(30)+JVS(241)*UV(47)+JVS(288)*UV(51)+JVS(331)*UV(54)+JVS(376)*UV(57)+JVS(422)*UV(59)+JVS(450)&
               &*UV(60)+JVS(506)*UV(63)+JVS(563)*UV(65)
  JTUV(52) = JVS(104)*UV(28)+JVS(134)*UV(33)+JVS(299)*UV(52)+JVS(332)*UV(54)+JVS(423)*UV(59)+JVS(451)*UV(60)+JVS(507)&
               &*UV(63)+JVS(564)*UV(65)
  JTUV(53) = JVS(161)*UV(38)+JVS(176)*UV(39)+JVS(259)*UV(48)+JVS(313)*UV(53)+JVS(392)*UV(58)+JVS(452)*UV(60)+JVS(565)&
               &*UV(65)+JVS(622)*UV(67)
  JTUV(54) = JVS(162)*UV(38)+JVS(177)*UV(39)+JVS(333)*UV(54)+JVS(348)*UV(55)+JVS(393)*UV(58)+JVS(453)*UV(60)+JVS(566)&
               &*UV(65)+JVS(623)*UV(67)
  JTUV(55) = JVS(125)*UV(31)+JVS(143)*UV(35)+JVS(242)*UV(47)+JVS(349)*UV(55)+JVS(426)*UV(59)+JVS(454)*UV(60)+JVS(509)&
               &*UV(63)+JVS(567)*UV(65)
  JTUV(56) = JVS(14)*UV(5)+JVS(163)*UV(38)+JVS(178)*UV(39)+JVS(197)*UV(41)+JVS(219)*UV(44)+JVS(243)*UV(47)+JVS(260)&
               &*UV(48)+JVS(272)*UV(49)+JVS(314)*UV(53)+JVS(334)*UV(54)+JVS(350)*UV(55)+JVS(364)*UV(56)+JVS(377)*UV(57)&
               &+JVS(394)*UV(58)+JVS(455)*UV(60)+JVS(530)*UV(64)+JVS(568)*UV(65)+JVS(625)*UV(67)
  JTUV(57) = JVS(117)*UV(30)+JVS(261)*UV(48)+JVS(273)*UV(49)+JVS(289)*UV(51)+JVS(300)*UV(52)+JVS(335)*UV(54)+JVS(378)&
               &*UV(57)+JVS(428)*UV(59)+JVS(569)*UV(65)+JVS(626)*UV(67)
  JTUV(58) = JVS(15)*UV(5)+JVS(67)*UV(18)+JVS(352)*UV(55)+JVS(396)*UV(58)+JVS(429)*UV(59)+JVS(457)*UV(60)+JVS(512)&
               &*UV(63)+JVS(531)*UV(64)+JVS(570)*UV(65)
  JTUV(59) = JVS(68)*UV(18)+JVS(75)*UV(21)+JVS(86)*UV(24)+JVS(98)*UV(27)+JVS(129)*UV(32)+JVS(153)*UV(37)+JVS(164)*UV(38)&
               &+JVS(379)*UV(57)+JVS(397)*UV(58)+JVS(430)*UV(59)+JVS(458)*UV(60)+JVS(513)*UV(63)+JVS(532)*UV(64)+JVS(571)&
               &*UV(65)+JVS(628)*UV(67)
  JTUV(60) = JVS(22)*UV(6)+JVS(28)*UV(7)+JVS(36)*UV(9)+JVS(76)*UV(21)+JVS(87)*UV(24)+JVS(90)*UV(25)+JVS(94)*UV(26)&
               &+JVS(118)*UV(30)+JVS(149)*UV(36)+JVS(154)*UV(37)+JVS(165)*UV(38)+JVS(179)*UV(39)+JVS(185)*UV(40)+JVS(199)&
               &*UV(41)+JVS(224)*UV(45)+JVS(228)*UV(46)+JVS(244)*UV(47)+JVS(262)*UV(48)+JVS(274)*UV(49)+JVS(283)*UV(50)&
               &+JVS(290)*UV(51)+JVS(301)*UV(52)+JVS(315)*UV(53)+JVS(336)*UV(54)+JVS(353)*UV(55)+JVS(365)*UV(56)+JVS(380)&
               &*UV(57)+JVS(398)*UV(58)+JVS(431)*UV(59)+JVS(459)*UV(60)+JVS(476)*UV(61)+JVS(489)*UV(62)+JVS(514)*UV(63)&
               &+JVS(572)*UV(65)+JVS(629)*UV(67)
  JTUV(61) = JVS(119)*UV(30)+JVS(263)*UV(48)+JVS(275)*UV(49)+JVS(302)*UV(52)+JVS(337)*UV(54)+JVS(381)*UV(57)+JVS(432)&
               &*UV(59)+JVS(460)*UV(60)+JVS(477)*UV(61)+JVS(515)*UV(63)+JVS(573)*UV(65)+JVS(585)*UV(66)
  JTUV(62) = JVS(245)*UV(47)+JVS(276)*UV(49)+JVS(316)*UV(53)+JVS(400)*UV(58)+JVS(433)*UV(59)+JVS(461)*UV(60)+JVS(491)&
               &*UV(62)+JVS(516)*UV(63)+JVS(574)*UV(65)+JVS(586)*UV(66)
  JTUV(63) = JVS(110)*UV(29)+JVS(120)*UV(30)+JVS(130)*UV(32)+JVS(155)*UV(37)+JVS(180)*UV(39)+JVS(186)*UV(40)+JVS(201)&
               &*UV(41)+JVS(210)*UV(42)+JVS(215)*UV(43)+JVS(220)*UV(44)+JVS(246)*UV(47)+JVS(264)*UV(48)+JVS(277)*UV(49)&
               &+JVS(291)*UV(51)+JVS(303)*UV(52)+JVS(317)*UV(53)+JVS(338)*UV(54)+JVS(356)*UV(55)+JVS(366)*UV(56)+JVS(382)&
               &*UV(57)+JVS(401)*UV(58)+JVS(434)*UV(59)+JVS(462)*UV(60)+JVS(479)*UV(61)+JVS(492)*UV(62)+JVS(517)*UV(63)&
               &+JVS(536)*UV(64)+JVS(575)*UV(65)+JVS(632)*UV(67)
  JTUV(64) = JVS(9)*UV(4)+JVS(16)*UV(5)+JVS(37)*UV(9)+JVS(41)*UV(10)+JVS(45)*UV(11)+JVS(49)*UV(12)+JVS(53)*UV(13)&
               &+JVS(63)*UV(16)+JVS(82)*UV(23)+JVS(91)*UV(25)+JVS(95)*UV(26)+JVS(105)*UV(28)+JVS(121)*UV(30)+JVS(138)*UV(34)&
               &+JVS(144)*UV(35)+JVS(156)*UV(37)+JVS(181)*UV(39)+JVS(211)*UV(42)+JVS(225)*UV(45)+JVS(229)*UV(46)+JVS(247)&
               &*UV(47)+JVS(265)*UV(48)+JVS(278)*UV(49)+JVS(284)*UV(50)+JVS(304)*UV(52)+JVS(318)*UV(53)+JVS(339)*UV(54)&
               &+JVS(357)*UV(55)+JVS(367)*UV(56)+JVS(402)*UV(58)+JVS(435)*UV(59)+JVS(463)*UV(60)+JVS(480)*UV(61)+JVS(493)&
               &*UV(62)+JVS(518)*UV(63)+JVS(537)*UV(64)+JVS(576)*UV(65)+JVS(633)*UV(67)
  JTUV(65) = JVS(17)*UV(5)+JVS(59)*UV(14)+JVS(70)*UV(19)+JVS(99)*UV(27)+JVS(126)*UV(31)+JVS(131)*UV(32)+JVS(135)*UV(33)&
               &+JVS(166)*UV(38)+JVS(187)*UV(40)+JVS(203)*UV(41)+JVS(216)*UV(43)+JVS(221)*UV(44)+JVS(266)*UV(48)+JVS(293)&
               &*UV(51)+JVS(305)*UV(52)+JVS(358)*UV(55)+JVS(384)*UV(57)+JVS(403)*UV(58)+JVS(436)*UV(59)+JVS(464)*UV(60)&
               &+JVS(481)*UV(61)+JVS(494)*UV(62)+JVS(519)*UV(63)+JVS(538)*UV(64)+JVS(577)*UV(65)+JVS(589)*UV(66)+JVS(634)&
               &*UV(67)
  JTUV(66) = JVS(122)*UV(30)+JVS(267)*UV(48)+JVS(280)*UV(49)+JVS(306)*UV(52)+JVS(320)*UV(53)+JVS(341)*UV(54)+JVS(482)&
               &*UV(61)+JVS(578)*UV(65)+JVS(590)*UV(66)+JVS(635)*UV(67)
  JTUV(67) = JVS(3)*UV(1)+JVS(23)*UV(6)+JVS(29)*UV(7)+JVS(32)*UV(8)+JVS(38)*UV(9)+JVS(42)*UV(10)+JVS(46)*UV(11)+JVS(50)&
               &*UV(12)+JVS(54)*UV(13)+JVS(61)*UV(15)+JVS(65)*UV(17)+JVS(71)*UV(19)+JVS(73)*UV(20)+JVS(78)*UV(22)+JVS(83)&
               &*UV(23)+JVS(88)*UV(24)+JVS(92)*UV(25)+JVS(96)*UV(26)+JVS(100)*UV(27)+JVS(106)*UV(28)+JVS(111)*UV(29)&
               &+JVS(123)*UV(30)+JVS(127)*UV(31)+JVS(132)*UV(32)+JVS(136)*UV(33)+JVS(139)*UV(34)+JVS(145)*UV(35)+JVS(150)&
               &*UV(36)+JVS(167)*UV(38)+JVS(182)*UV(39)+JVS(205)*UV(41)+JVS(212)*UV(42)+JVS(217)*UV(43)+JVS(222)*UV(44)&
               &+JVS(226)*UV(45)+JVS(230)*UV(46)+JVS(249)*UV(47)+JVS(268)*UV(48)+JVS(281)*UV(49)+JVS(285)*UV(50)+JVS(294)&
               &*UV(51)+JVS(307)*UV(52)+JVS(321)*UV(53)+JVS(342)*UV(54)+JVS(360)*UV(55)+JVS(369)*UV(56)+JVS(385)*UV(57)&
               &+JVS(405)*UV(58)+JVS(438)*UV(59)+JVS(466)*UV(60)+JVS(483)*UV(61)+JVS(496)*UV(62)+JVS(521)*UV(63)+JVS(540)&
               &*UV(64)+JVS(579)*UV(65)+JVS(591)*UV(66)+JVS(636)*UV(67)
      
END SUBROUTINE JacTR_SP_Vec

! End of JacTR_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE CBMZ_Jacobian

