! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CBMZ_Function.f90
! Time                 : Thu Oct  8 08:21:56 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CBMZ_11803_BOXMOX
! Equation file        : CBMZ.kpp
! Output root filename : CBMZ
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CBMZ_Function

  USE CBMZ_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(59)
  A(2) = RCT(2)*V(60)
  A(3) = RCT(3)*V(32)
  A(4) = RCT(4)*V(38)
  A(5) = RCT(5)*V(27)
  A(6) = RCT(6)*V(21)
  A(7) = RCT(7)*V(64)
  A(8) = RCT(8)*V(64)
  A(9) = RCT(9)*V(19)
  A(10) = RCT(10)*V(47)
  A(11) = RCT(11)*V(47)
  A(12) = RCT(12)*V(31)
  A(13) = RCT(13)*V(33)
  A(14) = RCT(14)*V(54)
  A(15) = RCT(15)*V(49)
  A(16) = RCT(16)*V(53)
  A(17) = RCT(17)*V(42)
  A(18) = RCT(18)*V(66)
  A(19) = RCT(19)*V(57)
  A(20) = RCT(20)*V(56)
  A(21) = RCT(21)*V(16)*F(2)
  A(22) = RCT(22)*V(16)*F(1)
  A(23) = RCT(23)*V(37)*F(2)
  A(24) = RCT(24)*V(37)*V(64)
  A(25) = RCT(25)*V(37)*V(59)
  A(26) = RCT(26)*V(37)*V(59)
  A(27) = RCT(27)*V(37)*V(63)
  A(28) = RCT(28)*V(63)*V(64)
  A(29) = RCT(29)*V(59)*V(64)
  A(30) = RCT(30)*V(64)*V(67)
  A(31) = RCT(31)*V(64)*V(65)
  A(32) = RCT(32)*V(67)*F(2)
  A(33) = RCT(33)*V(63)*V(67)
  A(34) = RCT(34)*V(59)*V(67)
  A(35) = RCT(35)*V(60)*V(67)
  A(36) = RCT(36)*V(32)*V(67)
  A(37) = RCT(37)*V(38)*V(67)
  A(38) = RCT(38)*V(27)*V(67)
  A(39) = RCT(39)*V(65)*V(67)
  A(40) = RCT(40)*V(19)*V(67)
  A(41) = RCT(41)*V(65)*V(65)
  A(42) = RCT(42)*V(65)*V(65)*F(1)
  A(43) = RCT(43)*V(63)*V(65)
  A(44) = RCT(44)*V(59)*V(65)
  A(45) = RCT(45)*V(59)*V(65)
  A(46) = RCT(46)*V(27)
  A(47) = RCT(47)*V(60)*V(63)
  A(48) = RCT(48)*V(59)*V(60)
  A(49) = RCT(49)*V(59)*V(60)
  A(50) = RCT(50)*V(60)*V(60)
  A(51) = RCT(51)*V(60)*V(65)
  A(52) = RCT(52)*V(21)*F(1)
  A(53) = RCT(53)*V(21)
  A(54) = RCT(54)*V(39)*V(67)
  A(55) = RCT(55)*V(15)*V(67)
  A(56) = RCT(56)*V(23)*V(67)
  A(57) = RCT(57)*V(28)*V(67)
  A(58) = RCT(58)*V(41)*V(67)
  A(59) = RCT(59)*V(47)*V(67)
  A(60) = RCT(60)*V(47)*V(60)
  A(61) = RCT(61)*V(54)*V(67)
  A(62) = RCT(62)*V(54)*V(60)
  A(63) = RCT(63)*V(49)*V(67)
  A(64) = RCT(64)*V(53)*V(67)
  A(65) = RCT(65)*V(53)*V(60)
  A(66) = RCT(66)*V(34)*V(64)
  A(67) = RCT(67)*V(34)*V(67)
  A(68) = RCT(68)*V(45)*V(64)
  A(69) = RCT(69)*V(50)*V(64)
  A(70) = RCT(70)*V(45)*V(67)
  A(71) = RCT(71)*V(50)*V(67)
  A(72) = RCT(72)*V(45)*V(60)
  A(73) = RCT(73)*V(50)*V(60)
  A(74) = RCT(74)*V(20)*V(67)
  A(75) = RCT(75)*V(22)*V(67)
  A(76) = RCT(76)*V(29)*V(63)
  A(77) = RCT(77)*V(36)*V(67)
  A(78) = RCT(78)*V(36)*V(60)
  A(79) = RCT(79)*V(24)*V(59)
  A(80) = RCT(80)*V(42)*V(67)
  A(81) = RCT(81)*V(42)*V(64)
  A(82) = RCT(82)*V(46)*V(67)
  A(83) = RCT(83)*V(46)*V(64)
  A(84) = RCT(84)*V(46)*V(60)
  A(85) = RCT(85)*V(56)*V(67)
  A(86) = RCT(86)*V(56)*V(64)
  A(87) = RCT(87)*V(56)*V(60)
  A(88) = RCT(88)*V(43)*V(63)
  A(89) = RCT(89)*V(40)*V(63)
  A(90) = RCT(90)*V(44)*V(63)
  A(91) = RCT(91)*V(43)*V(65)
  A(92) = RCT(92)*V(40)*V(65)
  A(93) = RCT(93)*V(44)*V(65)
  A(94) = RCT(94)*V(31)*V(67)
  A(95) = RCT(95)*V(33)*V(67)
  A(96) = RCT(96)*V(66)*V(67)
  A(97) = RCT(97)*V(57)*V(67)
  A(98) = RCT(98)*V(58)*V(59)
  A(99) = RCT(99)*V(18)
  A(100) = RCT(100)*V(35)*V(67)
  A(101) = RCT(101)*V(55)*V(63)
  A(102) = RCT(102)*V(52)*V(63)
  A(103) = RCT(103)*V(61)*V(63)
  A(104) = RCT(104)*V(58)*V(63)
  A(105) = RCT(105)*V(62)*V(63)
  A(106) = RCT(106)*V(51)*V(63)
  A(107) = RCT(107)*V(48)*V(63)
  A(108) = RCT(108)*V(55)*V(60)
  A(109) = RCT(109)*V(52)*V(60)
  A(110) = RCT(110)*V(60)*V(61)
  A(111) = RCT(111)*V(58)*V(60)
  A(112) = RCT(112)*V(60)*V(62)
  A(113) = RCT(113)*V(51)*V(60)
  A(114) = RCT(114)*V(48)*V(60)
  A(115) = RCT(115)*V(55)*V(65)
  A(116) = RCT(116)*V(52)*V(65)
  A(117) = RCT(117)*V(61)*V(65)
  A(118) = RCT(118)*V(58)*V(65)
  A(119) = RCT(119)*V(62)*V(65)
  A(120) = RCT(120)*V(51)*V(65)
  A(121) = RCT(121)*V(48)*V(65)
  A(122) = RCT(122)*V(17)*V(67)
  A(123) = RCT(123)*V(30)*V(41)
  A(127) = RCT(127)*V(55)
  A(128) = RCT(128)*V(52)
  A(129) = RCT(129)*V(61)
  A(130) = RCT(130)*V(58)
  A(131) = RCT(131)*V(62)
  A(132) = RCT(132)*V(51)
  A(133) = RCT(133)*V(43)
  A(134) = RCT(134)*V(40)
  A(135) = RCT(135)*V(44)
  A(136) = RCT(136)*V(48)
  A(137) = RCT(137)*V(25)*V(67)
  A(138) = RCT(138)*V(25)*V(60)
  A(139) = RCT(139)*V(25)*V(64)
  A(140) = RCT(140)*V(26)*V(67)
  A(141) = RCT(141)*V(26)*V(60)
  A(142) = RCT(142)*V(26)*V(64)

! Aggregate function
  Vdot(1) = A(55)
  Vdot(2) = 0
  Vdot(3) = 0
  Vdot(4) = 0.52*A(66)+0.22*A(68)
  Vdot(5) = 0.09*A(68)+0.16*A(69)+0.39*A(83)+0.46*A(86)+0.4*A(118)
  Vdot(6) = 0.039*A(74)+0.039*A(75)+0.039*A(77)+0.039*A(78)
  Vdot(7) = 0.108*A(74)+0.108*A(75)+0.108*A(77)+0.108*A(78)
  Vdot(8) = 0.012*A(58)
  Vdot(9) = 0.008*A(68)+0.008*A(69)+0.008*A(70)+0.008*A(71)+0.008*A(72)+0.008*A(73)
  Vdot(10) = 0.0064*A(137)+0.022*A(139)
  Vdot(11) = 0.055*A(137)+0.19*A(139)
  Vdot(12) = 0.037*A(140)+0.13*A(142)
  Vdot(13) = 0.056*A(140)+0.19*A(142)
  Vdot(14) = A(121)+A(123)+A(136)
  Vdot(15) = -A(55)
  Vdot(16) = A(8)-A(21)-A(22)
  Vdot(17) = -A(122)
  Vdot(18) = A(98)-A(99)
  Vdot(19) = -A(9)-A(40)+A(41)+A(42)
  Vdot(20) = -A(74)
  Vdot(21) = -A(6)+A(49)-A(52)-A(53)
  Vdot(22) = -A(75)
  Vdot(23) = -A(56)+0.06*A(68)+0.08*A(69)
  Vdot(24) = 0.4*A(77)+A(78)-A(79)
  Vdot(25) = -A(137)-A(138)-A(139)
  Vdot(26) = -A(140)-A(141)-A(142)
  Vdot(27) = -A(5)-A(38)+A(44)-A(46)
  Vdot(28) = -A(57)+0.01*A(68)+0.01*A(69)+0.2*A(128)
  Vdot(29) = 0.8*A(74)+0.45*A(75)-A(76)
  Vdot(30) = 1.98*A(18)+1.98*A(19)+1.06*A(68)+2.26*A(69)+A(70)+2.23*A(71)+0.42*A(96)+1.68*A(103)+A(106)+1.98*A(110)&
               &+A(113)-A(123)+1.25*A(129)+A(132)
  Vdot(31) = -A(12)-A(94)+A(115)
  Vdot(32) = -A(3)+A(33)-A(36)+A(45)
  Vdot(33) = -A(13)-A(95)+A(116)
  Vdot(34) = -A(66)-A(67)
  Vdot(35) = 0.03*A(68)+0.04*A(69)-A(100)+0.34*A(127)
  Vdot(36) = 0.12*A(74)+0.05*A(75)-A(77)-A(78)
  Vdot(37) = A(1)+0.89*A(2)+A(7)+A(21)-A(23)-A(24)-A(25)-A(26)-A(27)
  Vdot(38) = -A(4)+A(34)-A(37)+0.3*A(51)+2*A(52)+A(60)+A(62)+A(65)+A(78)+0.07*A(87)
  Vdot(39) = A(10)+A(11)+A(14)+A(16)+A(17)+0.33*A(20)-A(54)+A(59)+A(60)+A(65)+0.24*A(66)+0.31*A(68)+0.3*A(69)+2*A(80)&
               &+0.69*A(81)+0.07*A(83)+0.16*A(86)+0.64*A(87)+0.59*A(90)
  Vdot(40) = A(84)-A(89)-A(92)-A(134)
  Vdot(41) = -A(58)+1.1*A(75)+1.86*A(87)+0.18*A(88)+1.6*A(89)+2*A(92)-A(123)+2*A(134)
  Vdot(42) = -A(17)+0.95*A(76)+0.3*A(77)-A(80)-A(81)
  Vdot(43) = A(82)-A(88)-A(91)-A(133)
  Vdot(44) = 0.5*A(85)-A(90)-A(93)-A(135)
  Vdot(45) = -A(68)-A(70)-A(72)
  Vdot(46) = -A(82)-A(83)-A(84)
  Vdot(47) = -A(10)-A(11)+A(12)+0.2*A(20)-A(59)-A(60)+A(66)+1.56*A(67)+0.57*A(68)+A(70)+A(80)+0.7*A(81)+0.6*A(83)+0.15&
               &*A(86)+0.28*A(87)+0.63*A(88)+0.25*A(90)+0.3*A(94)+A(100)+A(101)+A(105)+0.5*A(106)+A(108)+A(112)+0.5*A(113)&
               &+0.66*A(127)+0.7*A(131)+0.5*A(132)
  Vdot(48) = 0.4*A(18)+0.41*A(19)+A(64)+A(67)+A(70)+A(71)+0.08*A(74)+0.5*A(75)+0.6*A(77)+A(80)+0.03*A(81)+0.08*A(82)+0.2&
               &*A(83)+0.2*A(85)+0.07*A(86)+0.93*A(87)+0.34*A(103)-A(107)+0.4*A(110)-A(114)-A(121)+0.24*A(129)-A(136)
  Vdot(49) = -A(15)+0.74*A(18)+0.74*A(19)+0.03*A(20)-A(63)+0.07*A(69)+0.23*A(71)+0.09*A(86)+0.63*A(90)+0.62*A(103)+0.74&
               &*A(110)+0.57*A(129)+0.15*A(131)+0.5*A(135)
  Vdot(50) = -A(69)-A(71)-A(73)
  Vdot(51) = A(72)+A(73)+A(97)-A(106)-A(113)-A(120)-A(132)
  Vdot(52) = 0.1*A(18)+0.1*A(19)+A(57)+0.06*A(68)+0.05*A(69)+0.7*A(95)-A(102)+0.08*A(103)-A(109)+0.1*A(110)-A(116)&
               &-A(128)+0.06*A(129)
  Vdot(53) = -A(16)-A(64)-A(65)+0.04*A(68)+0.07*A(69)+0.8*A(75)+0.2*A(81)+0.85*A(86)+0.34*A(90)+0.19*A(96)+0.15*A(131)
  Vdot(54) = A(13)-A(14)+0.3*A(18)+0.3*A(19)+0.07*A(20)-A(61)-A(62)+0.22*A(67)+0.47*A(68)+1.03*A(69)+A(70)+1.77*A(71)&
               &+0.03*A(81)+0.15*A(83)+0.02*A(86)+0.28*A(87)+0.8*A(89)+0.55*A(90)+0.3*A(95)+0.04*A(96)+A(102)+0.25*A(103)&
               &+0.5*A(106)+A(109)+0.3*A(110)+0.5*A(113)+A(122)+0.8*A(128)+0.21*A(129)+0.5*A(132)+A(134)+0.5*A(135)
  Vdot(55) = A(14)+A(15)+0.7*A(20)+A(56)+0.07*A(68)+0.1*A(69)+0.05*A(86)+0.7*A(94)-A(101)+A(104)-A(108)+A(111)-A(115)&
               &-A(127)+A(130)
  Vdot(56) = -A(20)+0.65*A(83)-A(85)-A(86)-A(87)+0.91*A(88)+0.2*A(89)+A(133)
  Vdot(57) = -A(19)+0.05*A(76)+A(79)+0.93*A(87)+0.09*A(88)+0.8*A(89)+A(92)-A(97)+0.16*A(103)+0.5*A(106)+0.5*A(113)&
               &+A(120)+0.5*A(132)+A(134)
  Vdot(58) = A(15)+A(16)+A(17)+0.97*A(20)+A(61)+A(62)+A(64)+A(65)+0.13*A(68)+0.19*A(69)+A(80)+0.62*A(81)+0.2*A(83)+0.5&
               &*A(85)+0.11*A(86)+0.07*A(87)-A(98)+A(99)-A(104)+A(105)-A(111)+A(112)-A(118)-A(130)+0.7*A(131)
  Vdot(59) = -A(1)+0.89*A(2)+A(4)+A(5)+A(6)+A(19)-A(25)-A(26)+A(27)+A(28)-A(29)-A(34)+A(35)+A(36)+A(38)+A(43)-A(44)&
               &-A(45)+A(46)+2*A(47)-A(49)+2*A(50)+0.7*A(51)+A(53)+0.95*A(76)-A(79)+0.91*A(88)+1.2*A(89)+A(90)-A(98)+A(99)&
               &+A(101)+A(102)+0.84*A(103)+A(104)+A(105)+1.5*A(106)+A(107)+A(108)+A(109)+A(110)+A(111)+A(112)+1.5*A(113)&
               &+A(114)+0.5*A(132)
  Vdot(60) = -A(2)+A(6)+A(26)+A(29)-A(35)+A(37)-A(47)-A(48)-A(49)-2*A(50)-A(51)+A(53)-A(60)-A(62)-A(65)-A(72)-A(73)&
               &-A(78)-A(84)-A(87)-A(108)-A(109)-A(110)-A(111)-A(112)-A(113)-A(114)-A(138)-A(141)
  Vdot(61) = A(58)+0.03*A(68)+0.09*A(69)+0.77*A(96)-A(103)-A(110)-A(117)-A(129)
  Vdot(62) = A(63)+0.11*A(69)-A(105)-A(112)-A(119)-A(131)
  Vdot(63) = A(1)+0.11*A(2)+A(3)+A(25)-A(27)-A(28)-A(33)-A(43)-A(47)+A(48)-A(76)-A(88)-A(89)-A(90)-A(101)-A(102)-A(103)&
               &-A(104)-A(105)-A(106)-A(107)
  Vdot(64) = -A(7)-A(8)+A(23)-A(24)-A(28)-A(29)-A(30)-A(31)-A(66)-A(68)-A(69)-A(81)-A(83)-A(86)+0.4*A(118)-A(139)-A(142)
  Vdot(65) = A(5)+2*A(10)+A(12)+A(13)+A(14)+A(16)+A(17)+0.9*A(18)+0.9*A(19)+0.33*A(20)+A(30)-A(31)+A(32)+A(35)-A(39)&
               &+A(40)-2*A(41)-2*A(42)-A(43)-A(44)-A(45)+A(46)-A(51)+A(54)+A(55)+A(59)+A(60)+0.22*A(66)+A(67)+0.26*A(68)&
               &+0.22*A(69)+A(70)+A(71)+0.2*A(74)+0.55*A(75)+0.95*A(76)+0.6*A(77)+2*A(80)+0.76*A(81)+0.07*A(83)+0.1*A(86)&
               &+0.93*A(87)+0.91*A(88)+0.8*A(89)+A(90)-A(91)-A(92)-A(93)+A(100)+A(101)+A(102)+0.76*A(103)+0.5*A(106)+A(108)&
               &+A(109)+0.9*A(110)+0.5*A(113)-A(115)-A(116)-A(117)-A(118)-A(119)-A(120)-A(121)+A(122)+0.32*A(127)+0.6*A(128)&
               &+0.54*A(129)
  Vdot(66) = -A(18)+A(91)+A(93)-A(96)+A(117)+A(119)
  Vdot(67) = A(3)+A(4)+2*A(9)+A(12)+A(13)+A(18)+2*A(22)-A(30)+A(31)-A(32)-A(33)-A(34)-A(35)-A(36)-A(37)-A(38)-A(39)&
               &-A(40)+A(43)+0.7*A(51)-A(54)-A(55)-A(56)-A(57)-A(58)-A(59)-A(61)-A(63)-A(64)+0.12*A(66)-A(67)+0.33*A(68)+0.6&
               &*A(69)-A(70)-A(71)-A(74)-A(75)-A(77)-A(80)+0.08*A(81)-A(82)+0.27*A(83)-A(85)+0.27*A(86)-0.7*A(94)-0.7*A(95)&
               &-0.77*A(96)-A(97)-A(100)-A(122)-A(137)-A(140)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE CBMZ_Function

