! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Sparse Stoichiometric Data Structures File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CB05_CSIRO_StoichiomSP.f90
! Time                 : Thu Oct  8 08:21:51 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CB05_CSIRO_26998_BOXMOX
! Equation file        : CB05_CSIRO.kpp
! Output root filename : CB05_CSIRO
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CB05_CSIRO_StoichiomSP

  USE CB05_CSIRO_Precision
  PUBLIC
  SAVE


! Row-compressed sparse data for the Jacobian of reaction products JVRP

  INTEGER, PARAMETER, DIMENSION(174) :: CROW_JVRP = (/ &
       1,  2,  3,  5,  7,  9, 11, 13, 14, 15, 16, 17, &
      19, 21, 22, 23, 25, 27, 29, 30, 31, 32, 33, 35, &
      37, 38, 40, 41, 43, 45, 47, 49, 50, 52, 53, 54, &
      55, 57, 59, 61, 63, 64, 65, 67, 69, 71, 73, 75, &
      77, 79, 80, 81, 82, 83, 85, 87, 89, 91, 92, 93, &
      95, 97, 98,100,101,103,105,107,109,110,112,113, &
     115,117,118,119,121,123,125,126,128,130,132,134, &
     136,138,139,141,143,144,145,147,149,151,152,154, &
     155,157,159,161,163,164,166,168,169,170,172,174, &
     176,178,179,181,183,184,185,187,189,191,193,195, &
     197,199,201,203,205,207,209,211,213,215,217,219, &
     221,223,225,227,229,231,233,235,237,238,240,241, &
     243,245,247,249,251,253,255,257,259,260,262,264, &
     265,267,269,271,273,275,277,279,280,282,284,286, &
     288,290,292,294,296,297 /)

  INTEGER, PARAMETER, DIMENSION(296) :: ICOL_JVRP = (/ &
      61, 63, 53, 62, 61, 63, 61, 63, 62, 63, 53, 61, &
      53, 53, 14, 14, 53, 60, 53, 54, 56, 56, 56, 62, &
      56, 61, 56, 61, 12, 12, 12, 62, 61, 62, 60, 62, &
      16, 16, 60, 16, 60, 61, 34, 60, 54, 62, 54, 61, &
      23, 23, 60, 54, 54, 17, 17, 60, 13, 14, 13, 60, &
      60, 63, 60, 60, 54, 60, 54, 63, 17, 63, 56, 63, &
      56, 60, 54, 56, 53, 56, 56, 23, 34, 12, 59, 62, &
      48, 62, 54, 59, 48, 54, 59, 48, 48, 59, 51, 60, &
      51, 27, 60, 27, 36, 60,  5, 60, 57, 62, 54, 57, &
      57, 30, 60, 30, 10, 60, 52, 60, 52, 52, 52, 63, &
      52, 56, 52, 54, 26, 26, 62, 26, 54, 19, 60, 50, &
      63, 50, 60, 50, 56, 50, 58, 62, 58, 61,  6,  6, &
      54, 58, 57, 58, 58, 59, 58, 20, 60, 20, 21, 60, &
      49, 63, 49, 60, 49, 56, 49, 55, 62, 55, 61, 22, &
      22, 22, 60, 54, 55, 55, 57, 55, 59, 55, 55, 58, &
      44, 60, 28, 28, 28, 61, 41, 63, 41, 60, 41, 53, &
      41, 56, 38, 63, 38, 60, 38, 53, 38, 56, 40, 63, &
      40, 60, 40, 53, 40, 56,  8, 60, 29, 62, 29, 54, &
      43, 60, 43, 56, 33, 61, 33, 54, 25, 60, 25, 56, &
      39, 61, 39, 53, 32, 62, 32, 54, 18, 18, 60, 45, &
      45, 60, 45, 53, 45, 56, 24, 60, 24, 56, 35, 62, &
      35, 54, 31, 62, 31, 61,  7, 15, 60, 37, 60, 37, &
      46, 63, 46, 60, 46, 53, 46, 56, 47, 60, 47, 53, &
      47, 56, 47, 42, 63, 42, 60, 42, 53, 42, 56,  4, &
      60, 11, 60,  9, 60, 46, 61,  4 /)

  INTEGER, PARAMETER, DIMENSION(296) :: IROW_JVRP = (/ &
       1,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, &
       8,  9, 10, 11, 12, 12, 13, 13, 14, 15, 16, 16, &
      17, 17, 18, 18, 19, 20, 21, 22, 23, 23, 24, 24, &
      25, 26, 26, 27, 28, 28, 29, 29, 30, 30, 31, 31, &
      32, 33, 33, 34, 35, 36, 37, 37, 38, 38, 39, 39, &
      40, 40, 41, 42, 43, 43, 44, 44, 45, 45, 46, 46, &
      47, 47, 48, 48, 49, 49, 50, 51, 52, 53, 54, 54, &
      55, 55, 56, 56, 57, 57, 58, 59, 60, 60, 61, 61, &
      62, 63, 63, 64, 65, 65, 66, 66, 67, 67, 68, 68, &
      69, 70, 70, 71, 72, 72, 73, 73, 74, 75, 76, 76, &
      77, 77, 78, 78, 79, 80, 80, 81, 81, 82, 82, 83, &
      83, 84, 84, 85, 85, 86, 87, 87, 88, 88, 89, 90, &
      91, 91, 92, 92, 93, 93, 94, 95, 95, 96, 97, 97, &
      98, 98, 99, 99,100,100,101,102,102,103,103,104, &
     105,106,106,107,107,108,108,109,109,110,111,111, &
     112,112,113,114,115,115,116,116,117,117,118,118, &
     119,119,120,120,121,121,122,122,123,123,124,124, &
     125,125,126,126,127,127,128,128,129,129,130,130, &
     131,131,132,132,133,133,134,134,135,135,136,136, &
     137,137,138,138,139,139,140,140,141,142,142,143, &
     144,144,145,145,146,146,147,147,148,148,149,149, &
     150,150,151,151,152,152,153,154,154,155,155,156, &
     157,157,158,158,159,159,160,160,161,161,162,162, &
     163,163,164,165,165,166,166,167,167,168,168,169, &
     169,170,170,171,171,172,172,173 /)



!  Stoichiometric Matrix in Compressed Column Sparse Format


  INTEGER, PARAMETER, DIMENSION(174) :: CCOL_STOICM = (/ &
       1,  4,  6,  9, 12, 15, 18, 21, 23, 25, 27, 29, &
      32, 35, 38, 40, 43, 45, 48, 50, 52, 55, 57, 60, &
      63, 66, 69, 72, 75, 78, 82, 85, 88, 91, 93, 95, &
      97,100,104,107,110,112,114,116,119,123,126,130, &
     133,136,138,143,146,149,152,155,158,161,162,163, &
     165,173,180,185,190,193,196,201,204,208,213,217, &
     221,225,228,230,235,240,243,246,251,254,257,261, &
     264,268,272,276,279,282,285,290,295,299,301,304, &
     307,310,314,317,321,325,331,334,337,340,344,349, &
     356,360,364,370,378,385,387,390,401,409,419,428, &
     435,441,448,453,461,467,476,482,488,497,500,510, &
     522,525,528,531,535,538,541,545,548,551,554,558, &
     562,572,576,579,583,590,593,599,602,605,613,617, &
     621,629,636,647,656,668,679,690,698,702,710,721, &
     729,734,741,747,756,758 /)

  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_0 = (/ &
      61, 62, 63, 53, 63, 53, 61, 62, 61, 62, 63, 56, &
      61, 63, 61, 62, 63, 53, 56, 61, 53, 63, 14, 53, &
      14, 63, 14, 60, 53, 54, 60, 53, 54, 60, 56, 61, &
      63, 56, 62, 56, 61, 62, 56, 62, 12, 56, 61, 12, &
      34, 12, 34, 12, 56, 61, 61, 62, 16, 61, 62, 16, &
      60, 62, 16, 60, 62, 16, 60, 61, 16, 61, 62, 34, &
      60, 61, 34, 56, 60, 54, 60, 61, 62, 23, 54, 61, &
      23, 54, 61, 23, 60, 61, 17, 54, 17, 54, 17, 60, &
      17, 54, 60, 13, 14, 54, 60, 13, 54, 60, 54, 60, &
      63, 60, 63, 17, 60, 54, 60, 54, 60, 63, 17, 54, &
      60, 63, 56, 61, 63, 54, 56, 60, 61, 34, 54, 56, &
      53, 56, 61, 56, 61, 23, 54, 56, 60, 61, 34, 60, &
      61, 12, 56, 61, 59, 61, 62, 48, 51, 62, 27, 54, &
      59, 27, 48, 54, 59, 48, 48, 59, 34, 44, 49, 50, &
      51, 52, 54, 60, 44, 49, 50, 51, 52, 54, 61, 27, &
      49, 50, 59, 60, 27, 49, 50, 54, 60, 36, 54, 60, &
       5, 57, 60, 52, 54, 57, 61, 62, 30, 54, 57, 10, &
      52, 54, 57, 30, 54, 57, 59, 60, 30, 52, 54, 60, &
      10, 52, 54, 60, 36, 52, 54, 60, 36, 52, 54, 36, &
      52, 36, 52, 54, 60, 63, 34, 36, 52, 54, 56, 26, &
      52, 54, 26, 52, 54, 19, 26, 54, 61, 62, 26, 30, &
      54, 19, 54, 60, 50, 58, 60, 63, 50, 58, 60, 34, &
      50, 56, 58, 36, 50, 54, 57, 57, 58, 61, 62,  6, &
      58, 61,  6, 58, 61,  6, 58, 61, 20, 21, 53, 54, &
      58, 21, 52, 54, 57, 58, 21, 57, 58, 59, 57, 58, &
      20, 58, 60, 20, 57, 60, 21, 57, 60, 49, 55, 60, &
      63, 49, 55, 60, 34, 49, 55, 56, 36, 49, 54, 57, &
      50, 54, 55, 59, 61, 62, 22, 55, 61, 22, 55, 61, &
      22, 55, 61, 22, 50, 60, 61, 20, 21, 53, 54, 55, &
      21, 50, 52, 54, 55, 57, 59, 21, 50, 55, 59, 50 /)
  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_1 = (/ &
      54, 55, 59, 50, 54, 55, 57, 58, 59, 28, 44, 48, &
      49, 50, 54, 59, 60, 28, 44, 48, 49, 50, 54, 59, &
      28, 54, 28, 51, 61, 36, 41, 44, 48, 49, 50, 52, &
      54, 59, 60, 63, 41, 44, 49, 50, 52, 54, 59, 60, &
      36, 41, 44, 49, 50, 52, 53, 54, 59, 60, 41, 44, &
      48, 49, 50, 52, 56, 59, 61, 36, 38, 52, 54, 59, &
      60, 63, 38, 49, 52, 54, 59, 60, 19, 36, 38, 52, &
      53, 54, 60, 38, 52, 56, 59, 61, 36, 40, 44, 49, &
      50, 54, 59, 63, 40, 49, 50, 54, 59, 60, 36, 40, &
      49, 50, 52, 53, 54, 60, 63, 40, 49, 50, 54, 56, &
      61,  8, 29, 43, 54, 59, 60, 29, 36, 37, 45, 51, &
      52, 54, 61, 62,  3, 29, 54, 24, 33, 36, 43, 45, &
      48, 52, 54, 59, 60, 33, 34, 36, 37, 43, 45, 48, &
      49, 52, 54, 56, 59, 25, 33, 61, 33, 43, 54, 25, &
      39, 60, 25, 34, 39, 56, 39, 51, 61, 32, 39, 53, &
      32, 39, 61, 62, 18, 32, 54, 18, 39, 60, 18, 32, &
      60, 36, 45, 54, 58, 31, 35, 45, 60, 36, 37, 45, &
      49, 52, 53, 54, 58, 59, 60, 31, 34, 45, 56, 24, &
      35, 60, 24, 33, 34, 56, 35, 36, 51, 52, 54, 61, &
      62,  3, 35, 54, 31, 49, 54, 59, 61, 62,  7, 31, &
      61,  7, 31, 61, 15, 29, 37, 43, 44, 54, 59, 60, &
      37, 58, 59, 60, 36, 37, 54, 58, 44, 46, 47, 52, &
      54, 55, 59, 63, 46, 47, 48, 52, 54, 59, 60, 36, &
      44, 46, 47, 49, 52, 53, 54, 55, 59, 60, 44, 46, &
      47, 49, 51, 54, 56, 59, 61, 36, 37, 44, 47, 49, &
      50, 52, 54, 55, 58, 59, 60, 36, 37, 44, 47, 50, &
      52, 53, 54, 58, 59, 60, 34, 36, 44, 47, 49, 51, &
      52, 54, 55, 56, 59, 36, 44, 47, 50, 52, 54, 58, &
      59, 42, 44, 49, 63, 42, 44, 48, 49, 52, 54, 59, &
      60, 36, 42, 44, 48, 49, 52, 53, 54, 55, 59, 60 /)
  INTEGER, PARAMETER, DIMENSION(37) :: IROW_STOICM_2 = (/ &
      42, 48, 49, 51, 54, 56, 59, 61,  1,  2,  4, 54, &
      60, 11, 49, 50, 52, 54, 59, 60,  9, 48, 50, 54, &
      59, 60, 44, 46, 47, 49, 51, 54, 59, 61, 62,  1, &
       4 /)
  INTEGER, PARAMETER, DIMENSION(757) :: IROW_STOICM = (/&
    IROW_STOICM_0, IROW_STOICM_1, IROW_STOICM_2 /)

  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_0 = (/ &
       1,  1,  1,  2,  2,  3,  3,  3,  4,  4,  4,  5, &
       5,  5,  6,  6,  6,  7,  7,  7,  8,  8,  9,  9, &
      10, 10, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, &
      14, 15, 15, 16, 16, 16, 17, 17, 18, 18, 18, 19, &
      19, 20, 20, 21, 21, 21, 22, 22, 23, 23, 23, 24, &
      24, 24, 25, 25, 25, 26, 26, 26, 27, 27, 27, 28, &
      28, 28, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, &
      32, 32, 32, 33, 33, 33, 34, 34, 35, 35, 36, 36, &
      37, 37, 37, 38, 38, 38, 38, 39, 39, 39, 40, 40, &
      40, 41, 41, 42, 42, 43, 43, 44, 44, 44, 45, 45, &
      45, 45, 46, 46, 46, 47, 47, 47, 47, 48, 48, 48, &
      49, 49, 49, 50, 50, 51, 51, 51, 51, 51, 52, 52, &
      52, 53, 53, 53, 54, 54, 54, 55, 55, 55, 56, 56, &
      56, 57, 57, 57, 58, 59, 60, 60, 61, 61, 61, 61, &
      61, 61, 61, 61, 62, 62, 62, 62, 62, 62, 62, 63, &
      63, 63, 63, 63, 64, 64, 64, 64, 64, 65, 65, 65, &
      66, 66, 66, 67, 67, 67, 67, 67, 68, 68, 68, 69, &
      69, 69, 69, 70, 70, 70, 70, 70, 71, 71, 71, 71, &
      72, 72, 72, 72, 73, 73, 73, 73, 74, 74, 74, 75, &
      75, 76, 76, 76, 76, 76, 77, 77, 77, 77, 77, 78, &
      78, 78, 79, 79, 79, 80, 80, 80, 80, 80, 81, 81, &
      81, 82, 82, 82, 83, 83, 83, 83, 84, 84, 84, 85, &
      85, 85, 85, 86, 86, 86, 86, 87, 87, 87, 87, 88, &
      88, 88, 89, 89, 89, 90, 90, 90, 91, 91, 91, 91, &
      91, 92, 92, 92, 92, 92, 93, 93, 93, 93, 94, 94, &
      95, 95, 95, 96, 96, 96, 97, 97, 97, 98, 98, 98, &
      98, 99, 99, 99,100,100,100,100,101,101,101,101, &
     102,102,102,102,102,102,103,103,103,104,104,104, &
     105,105,105,106,106,106,106,107,107,107,107,107, &
     108,108,108,108,108,108,108,109,109,109,109,110 /)
  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_1 = (/ &
     110,110,110,111,111,111,111,111,111,112,112,112, &
     112,112,112,112,112,113,113,113,113,113,113,113, &
     114,114,115,115,115,116,116,116,116,116,116,116, &
     116,116,116,116,117,117,117,117,117,117,117,117, &
     118,118,118,118,118,118,118,118,118,118,119,119, &
     119,119,119,119,119,119,119,120,120,120,120,120, &
     120,120,121,121,121,121,121,121,122,122,122,122, &
     122,122,122,123,123,123,123,123,124,124,124,124, &
     124,124,124,124,125,125,125,125,125,125,126,126, &
     126,126,126,126,126,126,126,127,127,127,127,127, &
     127,128,128,128,128,128,128,129,129,129,129,129, &
     129,129,129,129,130,130,130,131,131,131,131,131, &
     131,131,131,131,131,132,132,132,132,132,132,132, &
     132,132,132,132,132,133,133,133,134,134,134,135, &
     135,135,136,136,136,136,137,137,137,138,138,138, &
     139,139,139,139,140,140,140,141,141,141,142,142, &
     142,143,143,143,143,144,144,144,144,145,145,145, &
     145,145,145,145,145,145,145,146,146,146,146,147, &
     147,147,148,148,148,148,149,149,149,149,149,149, &
     149,150,150,150,151,151,151,151,151,151,152,152, &
     152,153,153,153,154,154,154,154,154,154,154,154, &
     155,155,155,155,156,156,156,156,157,157,157,157, &
     157,157,157,157,158,158,158,158,158,158,158,159, &
     159,159,159,159,159,159,159,159,159,159,160,160, &
     160,160,160,160,160,160,160,161,161,161,161,161, &
     161,161,161,161,161,161,161,162,162,162,162,162, &
     162,162,162,162,162,162,163,163,163,163,163,163, &
     163,163,163,163,163,164,164,164,164,164,164,164, &
     164,165,165,165,165,166,166,166,166,166,166,166, &
     166,167,167,167,167,167,167,167,167,167,167,167 /)
  INTEGER, PARAMETER, DIMENSION(37) :: ICOL_STOICM_2 = (/ &
     168,168,168,168,168,168,168,168,169,169,169,169, &
     169,170,170,170,170,170,170,170,171,171,171,171, &
     171,171,172,172,172,172,172,172,172,172,172,173, &
     173 /)
  INTEGER, PARAMETER, DIMENSION(757) :: ICOL_STOICM = (/&
    ICOL_STOICM_0, ICOL_STOICM_1, ICOL_STOICM_2 /)

  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_0 = (/ &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp, &
       -2.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -2.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -2.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  6.100000e-01_dp,  3.900000e-01_dp, &
       3.900000e-01_dp,  6.100000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_1 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -2.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -6.600000e-01_dp,  3.300000e-01_dp,  3.300000e-01_dp,  -1.000000e+00_dp,  3.300000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -6.600000e-01_dp,  3.300000e-01_dp,  3.300000e-01_dp, &
       -1.000000e+00_dp,  3.300000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  6.300000e-01_dp,  1.370000e+00_dp, &
       7.400000e-01_dp,  -2.000000e+00_dp,  -1.000000e+00_dp,  3.000000e-01_dp,  7.000000e-01_dp, &
       3.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  8.000000e-01_dp, &
       2.000000e-01_dp,  2.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e-01_dp, &
       1.000000e+00_dp,  9.000000e-01_dp,  -1.000000e-01_dp,  -1.000000e+00_dp,  1.000000e-01_dp, &
       9.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_2 = (/ &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  8.000000e-01_dp,  2.000000e-01_dp, &
       2.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e-01_dp,  9.000000e-01_dp, &
       1.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  9.000000e-01_dp, &
       1.000000e-01_dp,  9.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       2.000000e+00_dp,  -2.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  7.600000e-01_dp, &
       -1.110000e+00_dp,  1.300000e-01_dp,  5.000000e-02_dp,  6.000000e-02_dp,  1.100000e-01_dp, &
       8.700000e-01_dp,  -1.000000e+00_dp,  -9.800000e-01_dp,  -2.100000e+00_dp,  4.000000e-02_dp, &
       5.000000e-01_dp,  6.000000e-01_dp,  9.400000e-01_dp,  9.600000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e-01_dp, &
       -1.000000e+00_dp,  2.000000e-01_dp,  1.000000e-02_dp,  3.000000e-01_dp,  2.000000e-01_dp, &
       2.000000e-01_dp,  3.000000e-01_dp,  2.000000e-01_dp,  1.000000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -7.000000e-01_dp,  6.200000e-01_dp,  3.300000e-01_dp,  8.000000e-01_dp, &
       9.500000e-01_dp,  8.000000e-01_dp,  -1.000000e+00_dp,  3.300000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  3.200000e-01_dp,  1.800000e-01_dp,  7.400000e-01_dp,  -1.000000e+00_dp, &
       4.400000e-01_dp,  2.200000e-01_dp,  1.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       9.000000e-02_dp,  5.600000e-01_dp,  3.500000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       9.100000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.700000e+00_dp,  7.000000e-01_dp,  3.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       2.200000e-01_dp,  1.560000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       3.700000e-01_dp,  6.300000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.300000e-01_dp,  1.300000e-01_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_3 = (/ &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e-01_dp,  -1.000000e+00_dp,  1.000000e-01_dp, &
       6.600000e-01_dp,  1.240000e+00_dp,  1.000000e-01_dp,  1.000000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  7.000000e-01_dp,  1.300000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  3.500000e-01_dp,  6.500000e-01_dp, &
       2.500000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  5.000000e-01_dp, &
       -1.000000e+00_dp,  6.400000e-01_dp,  1.180000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  6.500000e-01_dp,  1.800000e-01_dp,  2.800000e-01_dp, &
       1.000000e-01_dp,  -9.280000e-01_dp,  -1.000000e+00_dp,  3.360000e-01_dp,  5.200000e-01_dp, &
       8.600000e-01_dp,  1.400000e-01_dp,  3.360000e-01_dp,  1.200000e+00_dp,  8.600000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  7.320000e-01_dp, &
       6.000000e-02_dp,  6.000000e-02_dp,  -1.000000e+00_dp,  1.300000e-01_dp,  6.000000e-02_dp, &
       6.000000e-02_dp,  1.120000e+00_dp,  1.200000e-01_dp,  -1.000000e+00_dp,  3.000000e-01_dp, &
       1.000000e+00_dp,  2.400000e-01_dp,  2.400000e-01_dp,  -1.000000e+00_dp,  1.200000e-01_dp, &
       1.000000e-01_dp,  4.800000e-01_dp,  2.400000e-01_dp,  3.600000e-01_dp,  -1.000000e+00_dp, &
       6.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  6.000000e-01_dp,  4.000000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  6.900000e-01_dp,  2.000000e-01_dp,  -1.000000e+00_dp,  3.000000e-02_dp, &
       7.000000e-01_dp,  -1.000000e+00_dp,  7.600000e-01_dp,  6.200000e-01_dp,  3.000000e-02_dp, &
       8.000000e-02_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  3.440000e-01_dp,  1.400000e-01_dp, &
       3.440000e-01_dp,  1.200000e+00_dp,  8.600000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_4 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       3.000000e-01_dp,  8.000000e-01_dp,  2.000000e-01_dp,  1.100000e+00_dp,  7.000000e-01_dp, &
       5.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       2.500000e-01_dp,  -1.000000e+00_dp,  7.500000e-01_dp,  5.000000e-01_dp,  2.500000e-01_dp, &
       2.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  9.120000e-01_dp, &
       8.800000e-02_dp,  6.290000e-01_dp,  9.120000e-01_dp,  9.910000e-01_dp,  -1.000000e+00_dp, &
       6.600000e-02_dp,  3.500000e-01_dp,  -1.000000e+00_dp,  6.500000e-01_dp,  1.500000e-01_dp, &
       6.000000e-01_dp,  -1.000000e+00_dp,  6.600000e-02_dp,  2.000000e-01_dp,  2.000000e-01_dp, &
       2.660000e-01_dp,  2.400000e+00_dp,  -1.000000e+00_dp,  2.000000e-01_dp,  8.000000e-01_dp, &
       8.000000e-01_dp,  8.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  2.000000e-01_dp, &
       3.340000e-01_dp,  1.680000e-01_dp,  1.565000e+00_dp,  -1.000000e+00_dp,  1.200000e-01_dp, &
       2.520000e-01_dp,  1.670000e-01_dp,  5.030000e-01_dp,  2.500000e-01_dp,  2.100000e-01_dp, &
       7.130000e-01_dp,  -1.000000e+00_dp,  2.250000e-01_dp,  8.500000e-01_dp,  3.600000e-01_dp, &
       -1.000000e+00_dp,  2.000000e-02_dp,  1.500000e-01_dp,  -1.000000e+00_dp,  1.540000e-01_dp, &
       1.140000e-01_dp,  6.400000e-02_dp,  2.680000e-01_dp,  1.500000e-01_dp,  6.430000e-01_dp, &
       1.282000e+00_dp,  -1.000000e+00_dp,  3.570000e-01_dp,  8.500000e-01_dp,  2.820000e-01_dp, &
       9.250000e-01_dp,  7.500000e-02_dp,  -1.000000e+00_dp,  7.500000e-02_dp,  3.330000e-01_dp, &
       8.320000e-01_dp,  -1.000000e+00_dp,  6.700000e-02_dp,  9.000000e-01_dp,  1.033000e+00_dp, &
       9.670000e-01_dp,  7.000000e-01_dp,  -1.000000e+00_dp,  5.120000e+00_dp,  1.500000e-01_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.660000e+00_dp,  2.500000e-01_dp,  4.700000e-01_dp, &
       2.800000e-01_dp,  7.500000e-01_dp,  1.250000e+00_dp,  -1.000000e+00_dp,  1.000000e-03_dp, &
       -1.000000e+00_dp,  7.000000e+00_dp,  1.800000e-01_dp,  2.100000e-01_dp,  2.400000e-01_dp, &
       -1.000000e+00_dp,  7.000000e-02_dp,  3.900000e-01_dp,  7.600000e-01_dp,  5.700000e-01_dp, &
       -1.000000e+00_dp,  2.500000e-01_dp,  4.700000e-01_dp,  5.300000e-01_dp,  2.800000e-01_dp, &
       -1.000000e+00_dp,  1.030000e+00_dp,  4.700000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  5.000000e-02_dp, &
       9.000000e-01_dp,  1.000000e-01_dp,  1.000000e+00_dp,  1.000000e-01_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  9.000000e-03_dp,  9.910000e-01_dp,  1.000000e+00_dp,  9.910000e-01_dp, &
       -1.000000e+00_dp,  2.400000e+00_dp,  -1.000000e+00_dp,  2.000000e-01_dp,  8.000000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(7) :: STOICM_5 = (/ &
       8.000000e-01_dp,  8.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(757) :: STOICM = (/&
    STOICM_0, STOICM_1, STOICM_2, STOICM_3, STOICM_4, &
    STOICM_5 /)


END MODULE CB05_CSIRO_StoichiomSP

