! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Stoichiometric Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CB05_CSIRO_Stoichiom.f90
! Time                 : Thu Oct  8 08:21:51 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CB05_CSIRO_26998_BOXMOX
! Equation file        : CB05_CSIRO.kpp
! Output root filename : CB05_CSIRO
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CB05_CSIRO_Stoichiom

  USE CB05_CSIRO_Parameters
  USE CB05_CSIRO_StoichiomSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ReactantProd - Reactant Products in each equation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      ARP       - Reactant product in each equation
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ReactantProd ( V, F, ARP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! ARP - Reactant product in each equation
  REAL(kind=dp) :: ARP(NREACT)


! Reactant Products in each equation are useful in the
!     stoichiometric formulation of mass action law
  ARP(1) = V(61)
  ARP(2) = V(63)
  ARP(3) = V(53)*V(62)
  ARP(4) = V(61)*V(63)
  ARP(5) = V(61)*V(63)
  ARP(6) = V(62)*V(63)
  ARP(7) = V(53)*V(61)
  ARP(8) = V(53)
  ARP(9) = V(53)
  ARP(10) = V(14)*F(2)
  ARP(11) = V(14)*F(1)
  ARP(12) = V(53)*V(60)
  ARP(13) = V(53)*V(54)
  ARP(14) = V(56)
  ARP(15) = V(56)
  ARP(16) = V(56)*V(62)
  ARP(17) = V(56)*V(61)
  ARP(18) = V(56)*V(61)
  ARP(19) = V(12)*F(1)
  ARP(20) = V(12)*F(1)*F(1)
  ARP(21) = V(12)
  ARP(22) = V(62)*V(62)
  ARP(23) = V(61)*V(62)*F(1)
  ARP(24) = V(60)*V(62)
  ARP(25) = V(16)
  ARP(26) = V(16)*V(60)
  ARP(27) = V(16)*V(16)
  ARP(28) = V(60)*V(61)
  ARP(29) = V(34)*V(60)
  ARP(30) = V(54)*V(62)
  ARP(31) = V(54)*V(61)
  ARP(32) = V(23)
  ARP(33) = V(23)*V(60)
  ARP(34) = V(54)*V(54)
  ARP(35) = V(54)*V(54)*F(1)
  ARP(36) = V(17)
  ARP(37) = V(17)*V(60)
  ARP(38) = V(13)*V(14)
  ARP(39) = V(13)*V(60)
  ARP(40) = V(60)*V(63)
  ARP(41) = V(60)*V(60)
  ARP(42) = V(60)*V(60)
  ARP(43) = V(54)*V(60)
  ARP(44) = V(54)*V(63)
  ARP(45) = V(17)*V(63)
  ARP(46) = V(56)*V(63)
  ARP(47) = V(56)*V(60)
  ARP(48) = V(54)*V(56)
  ARP(49) = V(53)*V(56)
  ARP(50) = V(56)*V(56)
  ARP(51) = V(23)
  ARP(52) = V(34)
  ARP(53) = V(12)
  ARP(54) = V(59)*V(62)
  ARP(55) = V(48)*V(62)
  ARP(56) = V(54)*V(59)
  ARP(57) = V(48)*V(54)
  ARP(58) = V(59)*V(59)
  ARP(59) = V(48)*V(48)
  ARP(60) = V(48)*V(59)
  ARP(61) = V(51)*V(60)
  ARP(62) = V(51)
  ARP(63) = V(27)*V(60)
  ARP(64) = V(27)
  ARP(65) = V(36)*V(60)
  ARP(66) = V(5)*V(60)
  ARP(67) = V(57)*V(62)
  ARP(68) = V(54)*V(57)
  ARP(69) = V(57)*V(57)
  ARP(70) = V(30)*V(60)
  ARP(71) = V(30)
  ARP(72) = V(10)*V(60)
  ARP(73) = V(52)*V(60)
  ARP(74) = V(52)
  ARP(75) = V(52)
  ARP(76) = V(52)*V(63)
  ARP(77) = V(52)*V(56)
  ARP(78) = V(52)*V(54)
  ARP(79) = V(26)
  ARP(80) = V(26)*V(62)
  ARP(81) = V(26)*V(54)
  ARP(82) = V(19)*V(60)
  ARP(83) = V(50)*V(63)
  ARP(84) = V(50)*V(60)
  ARP(85) = V(50)*V(56)
  ARP(86) = V(50)
  ARP(87) = V(58)*V(62)
  ARP(88) = V(58)*V(61)
  ARP(89) = V(6)
  ARP(90) = V(6)
  ARP(91) = V(54)*V(58)
  ARP(92) = V(57)*V(58)
  ARP(93) = V(58)*V(59)
  ARP(94) = V(58)*V(58)
  ARP(95) = V(20)*V(60)
  ARP(96) = V(20)
  ARP(97) = V(21)*V(60)
  ARP(98) = V(49)*V(63)
  ARP(99) = V(49)*V(60)
  ARP(100) = V(49)*V(56)
  ARP(101) = V(49)
  ARP(102) = V(55)*V(62)
  ARP(103) = V(55)*V(61)
  ARP(104) = V(22)
  ARP(105) = V(22)
  ARP(106) = V(22)*V(60)
  ARP(107) = V(54)*V(55)
  ARP(108) = V(55)*V(57)
  ARP(109) = V(55)*V(59)
  ARP(110) = V(55)*V(55)
  ARP(111) = V(55)*V(58)
  ARP(112) = V(44)*V(60)
  ARP(113) = V(28)
  ARP(114) = V(28)
  ARP(115) = V(28)*V(61)
  ARP(116) = V(41)*V(63)
  ARP(117) = V(41)*V(60)
  ARP(118) = V(41)*V(53)
  ARP(119) = V(41)*V(56)
  ARP(120) = V(38)*V(63)
  ARP(121) = V(38)*V(60)
  ARP(122) = V(38)*V(53)
  ARP(123) = V(38)*V(56)
  ARP(124) = V(40)*V(63)
  ARP(125) = V(40)*V(60)
  ARP(126) = V(40)*V(53)
  ARP(127) = V(40)*V(56)
  ARP(128) = V(8)*V(60)
  ARP(129) = V(29)*V(62)
  ARP(130) = V(29)*V(54)
  ARP(131) = V(43)*V(60)
  ARP(132) = V(43)*V(56)
  ARP(133) = V(33)*V(61)
  ARP(134) = V(33)*V(54)
  ARP(135) = V(25)*V(60)
  ARP(136) = V(25)*V(56)
  ARP(137) = V(39)*V(61)
  ARP(138) = V(39)*V(53)
  ARP(139) = V(32)*V(62)
  ARP(140) = V(32)*V(54)
  ARP(141) = V(18)
  ARP(142) = V(18)*V(60)
  ARP(143) = V(45)
  ARP(144) = V(45)*V(60)
  ARP(145) = V(45)*V(53)
  ARP(146) = V(45)*V(56)
  ARP(147) = V(24)*V(60)
  ARP(148) = V(24)*V(56)
  ARP(149) = V(35)*V(62)
  ARP(150) = V(35)*V(54)
  ARP(151) = V(31)*V(62)
  ARP(152) = V(31)*V(61)
  ARP(153) = V(7)
  ARP(154) = V(15)*V(60)
  ARP(155) = V(37)*V(60)
  ARP(156) = V(37)
  ARP(157) = V(46)*V(63)
  ARP(158) = V(46)*V(60)
  ARP(159) = V(46)*V(53)
  ARP(160) = V(46)*V(56)
  ARP(161) = V(47)*V(60)
  ARP(162) = V(47)*V(53)
  ARP(163) = V(47)*V(56)
  ARP(164) = V(47)
  ARP(165) = V(42)*V(63)
  ARP(166) = V(42)*V(60)
  ARP(167) = V(42)*V(53)
  ARP(168) = V(42)*V(56)
  ARP(169) = V(4)*V(60)
  ARP(170) = V(11)*V(60)
  ARP(171) = V(9)*V(60)
  ARP(172) = V(46)*V(61)
  ARP(173) = V(4)
      
END SUBROUTINE ReactantProd

! End of ReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacReactantProd - Jacobian of Reactant Products vector
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      JVRP      - d ARP(1:NREACT)/d VAR (1:NVAR)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacReactantProd ( V, F, JVRP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! JVRP - d ARP(1:NREACT)/d VAR (1:NVAR)
  REAL(kind=dp) :: JVRP(NJVRP)


! Reactant Products in each equation are useful in the
!    stoichiometric formulation of mass action law
! Below we compute the Jacobian of the Reactant Products vector
!    w.r.t. variable species: d ARP(1:NREACT) / d Var(1:NVAR)

! JVRP(1) = dARP(1)/dV(61)
  JVRP(1) = 1
! JVRP(2) = dARP(2)/dV(63)
  JVRP(2) = 1
! JVRP(3) = dARP(3)/dV(53)
  JVRP(3) = V(62)
! JVRP(4) = dARP(3)/dV(62)
  JVRP(4) = V(53)
! JVRP(5) = dARP(4)/dV(61)
  JVRP(5) = V(63)
! JVRP(6) = dARP(4)/dV(63)
  JVRP(6) = V(61)
! JVRP(7) = dARP(5)/dV(61)
  JVRP(7) = V(63)
! JVRP(8) = dARP(5)/dV(63)
  JVRP(8) = V(61)
! JVRP(9) = dARP(6)/dV(62)
  JVRP(9) = V(63)
! JVRP(10) = dARP(6)/dV(63)
  JVRP(10) = V(62)
! JVRP(11) = dARP(7)/dV(53)
  JVRP(11) = V(61)
! JVRP(12) = dARP(7)/dV(61)
  JVRP(12) = V(53)
! JVRP(13) = dARP(8)/dV(53)
  JVRP(13) = 1
! JVRP(14) = dARP(9)/dV(53)
  JVRP(14) = 1
! JVRP(15) = dARP(10)/dV(14)
  JVRP(15) = F(2)
! JVRP(16) = dARP(11)/dV(14)
  JVRP(16) = F(1)
! JVRP(17) = dARP(12)/dV(53)
  JVRP(17) = V(60)
! JVRP(18) = dARP(12)/dV(60)
  JVRP(18) = V(53)
! JVRP(19) = dARP(13)/dV(53)
  JVRP(19) = V(54)
! JVRP(20) = dARP(13)/dV(54)
  JVRP(20) = V(53)
! JVRP(21) = dARP(14)/dV(56)
  JVRP(21) = 1
! JVRP(22) = dARP(15)/dV(56)
  JVRP(22) = 1
! JVRP(23) = dARP(16)/dV(56)
  JVRP(23) = V(62)
! JVRP(24) = dARP(16)/dV(62)
  JVRP(24) = V(56)
! JVRP(25) = dARP(17)/dV(56)
  JVRP(25) = V(61)
! JVRP(26) = dARP(17)/dV(61)
  JVRP(26) = V(56)
! JVRP(27) = dARP(18)/dV(56)
  JVRP(27) = V(61)
! JVRP(28) = dARP(18)/dV(61)
  JVRP(28) = V(56)
! JVRP(29) = dARP(19)/dV(12)
  JVRP(29) = F(1)
! JVRP(30) = dARP(20)/dV(12)
  JVRP(30) = F(1)*F(1)
! JVRP(31) = dARP(21)/dV(12)
  JVRP(31) = 1
! JVRP(32) = dARP(22)/dV(62)
  JVRP(32) = 2*V(62)
! JVRP(33) = dARP(23)/dV(61)
  JVRP(33) = V(62)*F(1)
! JVRP(34) = dARP(23)/dV(62)
  JVRP(34) = V(61)*F(1)
! JVRP(35) = dARP(24)/dV(60)
  JVRP(35) = V(62)
! JVRP(36) = dARP(24)/dV(62)
  JVRP(36) = V(60)
! JVRP(37) = dARP(25)/dV(16)
  JVRP(37) = 1
! JVRP(38) = dARP(26)/dV(16)
  JVRP(38) = V(60)
! JVRP(39) = dARP(26)/dV(60)
  JVRP(39) = V(16)
! JVRP(40) = dARP(27)/dV(16)
  JVRP(40) = 2*V(16)
! JVRP(41) = dARP(28)/dV(60)
  JVRP(41) = V(61)
! JVRP(42) = dARP(28)/dV(61)
  JVRP(42) = V(60)
! JVRP(43) = dARP(29)/dV(34)
  JVRP(43) = V(60)
! JVRP(44) = dARP(29)/dV(60)
  JVRP(44) = V(34)
! JVRP(45) = dARP(30)/dV(54)
  JVRP(45) = V(62)
! JVRP(46) = dARP(30)/dV(62)
  JVRP(46) = V(54)
! JVRP(47) = dARP(31)/dV(54)
  JVRP(47) = V(61)
! JVRP(48) = dARP(31)/dV(61)
  JVRP(48) = V(54)
! JVRP(49) = dARP(32)/dV(23)
  JVRP(49) = 1
! JVRP(50) = dARP(33)/dV(23)
  JVRP(50) = V(60)
! JVRP(51) = dARP(33)/dV(60)
  JVRP(51) = V(23)
! JVRP(52) = dARP(34)/dV(54)
  JVRP(52) = 2*V(54)
! JVRP(53) = dARP(35)/dV(54)
  JVRP(53) = 2*V(54)*F(1)
! JVRP(54) = dARP(36)/dV(17)
  JVRP(54) = 1
! JVRP(55) = dARP(37)/dV(17)
  JVRP(55) = V(60)
! JVRP(56) = dARP(37)/dV(60)
  JVRP(56) = V(17)
! JVRP(57) = dARP(38)/dV(13)
  JVRP(57) = V(14)
! JVRP(58) = dARP(38)/dV(14)
  JVRP(58) = V(13)
! JVRP(59) = dARP(39)/dV(13)
  JVRP(59) = V(60)
! JVRP(60) = dARP(39)/dV(60)
  JVRP(60) = V(13)
! JVRP(61) = dARP(40)/dV(60)
  JVRP(61) = V(63)
! JVRP(62) = dARP(40)/dV(63)
  JVRP(62) = V(60)
! JVRP(63) = dARP(41)/dV(60)
  JVRP(63) = 2*V(60)
! JVRP(64) = dARP(42)/dV(60)
  JVRP(64) = 2*V(60)
! JVRP(65) = dARP(43)/dV(54)
  JVRP(65) = V(60)
! JVRP(66) = dARP(43)/dV(60)
  JVRP(66) = V(54)
! JVRP(67) = dARP(44)/dV(54)
  JVRP(67) = V(63)
! JVRP(68) = dARP(44)/dV(63)
  JVRP(68) = V(54)
! JVRP(69) = dARP(45)/dV(17)
  JVRP(69) = V(63)
! JVRP(70) = dARP(45)/dV(63)
  JVRP(70) = V(17)
! JVRP(71) = dARP(46)/dV(56)
  JVRP(71) = V(63)
! JVRP(72) = dARP(46)/dV(63)
  JVRP(72) = V(56)
! JVRP(73) = dARP(47)/dV(56)
  JVRP(73) = V(60)
! JVRP(74) = dARP(47)/dV(60)
  JVRP(74) = V(56)
! JVRP(75) = dARP(48)/dV(54)
  JVRP(75) = V(56)
! JVRP(76) = dARP(48)/dV(56)
  JVRP(76) = V(54)
! JVRP(77) = dARP(49)/dV(53)
  JVRP(77) = V(56)
! JVRP(78) = dARP(49)/dV(56)
  JVRP(78) = V(53)
! JVRP(79) = dARP(50)/dV(56)
  JVRP(79) = 2*V(56)
! JVRP(80) = dARP(51)/dV(23)
  JVRP(80) = 1
! JVRP(81) = dARP(52)/dV(34)
  JVRP(81) = 1
! JVRP(82) = dARP(53)/dV(12)
  JVRP(82) = 1
! JVRP(83) = dARP(54)/dV(59)
  JVRP(83) = V(62)
! JVRP(84) = dARP(54)/dV(62)
  JVRP(84) = V(59)
! JVRP(85) = dARP(55)/dV(48)
  JVRP(85) = V(62)
! JVRP(86) = dARP(55)/dV(62)
  JVRP(86) = V(48)
! JVRP(87) = dARP(56)/dV(54)
  JVRP(87) = V(59)
! JVRP(88) = dARP(56)/dV(59)
  JVRP(88) = V(54)
! JVRP(89) = dARP(57)/dV(48)
  JVRP(89) = V(54)
! JVRP(90) = dARP(57)/dV(54)
  JVRP(90) = V(48)
! JVRP(91) = dARP(58)/dV(59)
  JVRP(91) = 2*V(59)
! JVRP(92) = dARP(59)/dV(48)
  JVRP(92) = 2*V(48)
! JVRP(93) = dARP(60)/dV(48)
  JVRP(93) = V(59)
! JVRP(94) = dARP(60)/dV(59)
  JVRP(94) = V(48)
! JVRP(95) = dARP(61)/dV(51)
  JVRP(95) = V(60)
! JVRP(96) = dARP(61)/dV(60)
  JVRP(96) = V(51)
! JVRP(97) = dARP(62)/dV(51)
  JVRP(97) = 1
! JVRP(98) = dARP(63)/dV(27)
  JVRP(98) = V(60)
! JVRP(99) = dARP(63)/dV(60)
  JVRP(99) = V(27)
! JVRP(100) = dARP(64)/dV(27)
  JVRP(100) = 1
! JVRP(101) = dARP(65)/dV(36)
  JVRP(101) = V(60)
! JVRP(102) = dARP(65)/dV(60)
  JVRP(102) = V(36)
! JVRP(103) = dARP(66)/dV(5)
  JVRP(103) = V(60)
! JVRP(104) = dARP(66)/dV(60)
  JVRP(104) = V(5)
! JVRP(105) = dARP(67)/dV(57)
  JVRP(105) = V(62)
! JVRP(106) = dARP(67)/dV(62)
  JVRP(106) = V(57)
! JVRP(107) = dARP(68)/dV(54)
  JVRP(107) = V(57)
! JVRP(108) = dARP(68)/dV(57)
  JVRP(108) = V(54)
! JVRP(109) = dARP(69)/dV(57)
  JVRP(109) = 2*V(57)
! JVRP(110) = dARP(70)/dV(30)
  JVRP(110) = V(60)
! JVRP(111) = dARP(70)/dV(60)
  JVRP(111) = V(30)
! JVRP(112) = dARP(71)/dV(30)
  JVRP(112) = 1
! JVRP(113) = dARP(72)/dV(10)
  JVRP(113) = V(60)
! JVRP(114) = dARP(72)/dV(60)
  JVRP(114) = V(10)
! JVRP(115) = dARP(73)/dV(52)
  JVRP(115) = V(60)
! JVRP(116) = dARP(73)/dV(60)
  JVRP(116) = V(52)
! JVRP(117) = dARP(74)/dV(52)
  JVRP(117) = 1
! JVRP(118) = dARP(75)/dV(52)
  JVRP(118) = 1
! JVRP(119) = dARP(76)/dV(52)
  JVRP(119) = V(63)
! JVRP(120) = dARP(76)/dV(63)
  JVRP(120) = V(52)
! JVRP(121) = dARP(77)/dV(52)
  JVRP(121) = V(56)
! JVRP(122) = dARP(77)/dV(56)
  JVRP(122) = V(52)
! JVRP(123) = dARP(78)/dV(52)
  JVRP(123) = V(54)
! JVRP(124) = dARP(78)/dV(54)
  JVRP(124) = V(52)
! JVRP(125) = dARP(79)/dV(26)
  JVRP(125) = 1
! JVRP(126) = dARP(80)/dV(26)
  JVRP(126) = V(62)
! JVRP(127) = dARP(80)/dV(62)
  JVRP(127) = V(26)
! JVRP(128) = dARP(81)/dV(26)
  JVRP(128) = V(54)
! JVRP(129) = dARP(81)/dV(54)
  JVRP(129) = V(26)
! JVRP(130) = dARP(82)/dV(19)
  JVRP(130) = V(60)
! JVRP(131) = dARP(82)/dV(60)
  JVRP(131) = V(19)
! JVRP(132) = dARP(83)/dV(50)
  JVRP(132) = V(63)
! JVRP(133) = dARP(83)/dV(63)
  JVRP(133) = V(50)
! JVRP(134) = dARP(84)/dV(50)
  JVRP(134) = V(60)
! JVRP(135) = dARP(84)/dV(60)
  JVRP(135) = V(50)
! JVRP(136) = dARP(85)/dV(50)
  JVRP(136) = V(56)
! JVRP(137) = dARP(85)/dV(56)
  JVRP(137) = V(50)
! JVRP(138) = dARP(86)/dV(50)
  JVRP(138) = 1
! JVRP(139) = dARP(87)/dV(58)
  JVRP(139) = V(62)
! JVRP(140) = dARP(87)/dV(62)
  JVRP(140) = V(58)
! JVRP(141) = dARP(88)/dV(58)
  JVRP(141) = V(61)
! JVRP(142) = dARP(88)/dV(61)
  JVRP(142) = V(58)
! JVRP(143) = dARP(89)/dV(6)
  JVRP(143) = 1
! JVRP(144) = dARP(90)/dV(6)
  JVRP(144) = 1
! JVRP(145) = dARP(91)/dV(54)
  JVRP(145) = V(58)
! JVRP(146) = dARP(91)/dV(58)
  JVRP(146) = V(54)
! JVRP(147) = dARP(92)/dV(57)
  JVRP(147) = V(58)
! JVRP(148) = dARP(92)/dV(58)
  JVRP(148) = V(57)
! JVRP(149) = dARP(93)/dV(58)
  JVRP(149) = V(59)
! JVRP(150) = dARP(93)/dV(59)
  JVRP(150) = V(58)
! JVRP(151) = dARP(94)/dV(58)
  JVRP(151) = 2*V(58)
! JVRP(152) = dARP(95)/dV(20)
  JVRP(152) = V(60)
! JVRP(153) = dARP(95)/dV(60)
  JVRP(153) = V(20)
! JVRP(154) = dARP(96)/dV(20)
  JVRP(154) = 1
! JVRP(155) = dARP(97)/dV(21)
  JVRP(155) = V(60)
! JVRP(156) = dARP(97)/dV(60)
  JVRP(156) = V(21)
! JVRP(157) = dARP(98)/dV(49)
  JVRP(157) = V(63)
! JVRP(158) = dARP(98)/dV(63)
  JVRP(158) = V(49)
! JVRP(159) = dARP(99)/dV(49)
  JVRP(159) = V(60)
! JVRP(160) = dARP(99)/dV(60)
  JVRP(160) = V(49)
! JVRP(161) = dARP(100)/dV(49)
  JVRP(161) = V(56)
! JVRP(162) = dARP(100)/dV(56)
  JVRP(162) = V(49)
! JVRP(163) = dARP(101)/dV(49)
  JVRP(163) = 1
! JVRP(164) = dARP(102)/dV(55)
  JVRP(164) = V(62)
! JVRP(165) = dARP(102)/dV(62)
  JVRP(165) = V(55)
! JVRP(166) = dARP(103)/dV(55)
  JVRP(166) = V(61)
! JVRP(167) = dARP(103)/dV(61)
  JVRP(167) = V(55)
! JVRP(168) = dARP(104)/dV(22)
  JVRP(168) = 1
! JVRP(169) = dARP(105)/dV(22)
  JVRP(169) = 1
! JVRP(170) = dARP(106)/dV(22)
  JVRP(170) = V(60)
! JVRP(171) = dARP(106)/dV(60)
  JVRP(171) = V(22)
! JVRP(172) = dARP(107)/dV(54)
  JVRP(172) = V(55)
! JVRP(173) = dARP(107)/dV(55)
  JVRP(173) = V(54)
! JVRP(174) = dARP(108)/dV(55)
  JVRP(174) = V(57)
! JVRP(175) = dARP(108)/dV(57)
  JVRP(175) = V(55)
! JVRP(176) = dARP(109)/dV(55)
  JVRP(176) = V(59)
! JVRP(177) = dARP(109)/dV(59)
  JVRP(177) = V(55)
! JVRP(178) = dARP(110)/dV(55)
  JVRP(178) = 2*V(55)
! JVRP(179) = dARP(111)/dV(55)
  JVRP(179) = V(58)
! JVRP(180) = dARP(111)/dV(58)
  JVRP(180) = V(55)
! JVRP(181) = dARP(112)/dV(44)
  JVRP(181) = V(60)
! JVRP(182) = dARP(112)/dV(60)
  JVRP(182) = V(44)
! JVRP(183) = dARP(113)/dV(28)
  JVRP(183) = 1
! JVRP(184) = dARP(114)/dV(28)
  JVRP(184) = 1
! JVRP(185) = dARP(115)/dV(28)
  JVRP(185) = V(61)
! JVRP(186) = dARP(115)/dV(61)
  JVRP(186) = V(28)
! JVRP(187) = dARP(116)/dV(41)
  JVRP(187) = V(63)
! JVRP(188) = dARP(116)/dV(63)
  JVRP(188) = V(41)
! JVRP(189) = dARP(117)/dV(41)
  JVRP(189) = V(60)
! JVRP(190) = dARP(117)/dV(60)
  JVRP(190) = V(41)
! JVRP(191) = dARP(118)/dV(41)
  JVRP(191) = V(53)
! JVRP(192) = dARP(118)/dV(53)
  JVRP(192) = V(41)
! JVRP(193) = dARP(119)/dV(41)
  JVRP(193) = V(56)
! JVRP(194) = dARP(119)/dV(56)
  JVRP(194) = V(41)
! JVRP(195) = dARP(120)/dV(38)
  JVRP(195) = V(63)
! JVRP(196) = dARP(120)/dV(63)
  JVRP(196) = V(38)
! JVRP(197) = dARP(121)/dV(38)
  JVRP(197) = V(60)
! JVRP(198) = dARP(121)/dV(60)
  JVRP(198) = V(38)
! JVRP(199) = dARP(122)/dV(38)
  JVRP(199) = V(53)
! JVRP(200) = dARP(122)/dV(53)
  JVRP(200) = V(38)
! JVRP(201) = dARP(123)/dV(38)
  JVRP(201) = V(56)
! JVRP(202) = dARP(123)/dV(56)
  JVRP(202) = V(38)
! JVRP(203) = dARP(124)/dV(40)
  JVRP(203) = V(63)
! JVRP(204) = dARP(124)/dV(63)
  JVRP(204) = V(40)
! JVRP(205) = dARP(125)/dV(40)
  JVRP(205) = V(60)
! JVRP(206) = dARP(125)/dV(60)
  JVRP(206) = V(40)
! JVRP(207) = dARP(126)/dV(40)
  JVRP(207) = V(53)
! JVRP(208) = dARP(126)/dV(53)
  JVRP(208) = V(40)
! JVRP(209) = dARP(127)/dV(40)
  JVRP(209) = V(56)
! JVRP(210) = dARP(127)/dV(56)
  JVRP(210) = V(40)
! JVRP(211) = dARP(128)/dV(8)
  JVRP(211) = V(60)
! JVRP(212) = dARP(128)/dV(60)
  JVRP(212) = V(8)
! JVRP(213) = dARP(129)/dV(29)
  JVRP(213) = V(62)
! JVRP(214) = dARP(129)/dV(62)
  JVRP(214) = V(29)
! JVRP(215) = dARP(130)/dV(29)
  JVRP(215) = V(54)
! JVRP(216) = dARP(130)/dV(54)
  JVRP(216) = V(29)
! JVRP(217) = dARP(131)/dV(43)
  JVRP(217) = V(60)
! JVRP(218) = dARP(131)/dV(60)
  JVRP(218) = V(43)
! JVRP(219) = dARP(132)/dV(43)
  JVRP(219) = V(56)
! JVRP(220) = dARP(132)/dV(56)
  JVRP(220) = V(43)
! JVRP(221) = dARP(133)/dV(33)
  JVRP(221) = V(61)
! JVRP(222) = dARP(133)/dV(61)
  JVRP(222) = V(33)
! JVRP(223) = dARP(134)/dV(33)
  JVRP(223) = V(54)
! JVRP(224) = dARP(134)/dV(54)
  JVRP(224) = V(33)
! JVRP(225) = dARP(135)/dV(25)
  JVRP(225) = V(60)
! JVRP(226) = dARP(135)/dV(60)
  JVRP(226) = V(25)
! JVRP(227) = dARP(136)/dV(25)
  JVRP(227) = V(56)
! JVRP(228) = dARP(136)/dV(56)
  JVRP(228) = V(25)
! JVRP(229) = dARP(137)/dV(39)
  JVRP(229) = V(61)
! JVRP(230) = dARP(137)/dV(61)
  JVRP(230) = V(39)
! JVRP(231) = dARP(138)/dV(39)
  JVRP(231) = V(53)
! JVRP(232) = dARP(138)/dV(53)
  JVRP(232) = V(39)
! JVRP(233) = dARP(139)/dV(32)
  JVRP(233) = V(62)
! JVRP(234) = dARP(139)/dV(62)
  JVRP(234) = V(32)
! JVRP(235) = dARP(140)/dV(32)
  JVRP(235) = V(54)
! JVRP(236) = dARP(140)/dV(54)
  JVRP(236) = V(32)
! JVRP(237) = dARP(141)/dV(18)
  JVRP(237) = 1
! JVRP(238) = dARP(142)/dV(18)
  JVRP(238) = V(60)
! JVRP(239) = dARP(142)/dV(60)
  JVRP(239) = V(18)
! JVRP(240) = dARP(143)/dV(45)
  JVRP(240) = 1
! JVRP(241) = dARP(144)/dV(45)
  JVRP(241) = V(60)
! JVRP(242) = dARP(144)/dV(60)
  JVRP(242) = V(45)
! JVRP(243) = dARP(145)/dV(45)
  JVRP(243) = V(53)
! JVRP(244) = dARP(145)/dV(53)
  JVRP(244) = V(45)
! JVRP(245) = dARP(146)/dV(45)
  JVRP(245) = V(56)
! JVRP(246) = dARP(146)/dV(56)
  JVRP(246) = V(45)
! JVRP(247) = dARP(147)/dV(24)
  JVRP(247) = V(60)
! JVRP(248) = dARP(147)/dV(60)
  JVRP(248) = V(24)
! JVRP(249) = dARP(148)/dV(24)
  JVRP(249) = V(56)
! JVRP(250) = dARP(148)/dV(56)
  JVRP(250) = V(24)
! JVRP(251) = dARP(149)/dV(35)
  JVRP(251) = V(62)
! JVRP(252) = dARP(149)/dV(62)
  JVRP(252) = V(35)
! JVRP(253) = dARP(150)/dV(35)
  JVRP(253) = V(54)
! JVRP(254) = dARP(150)/dV(54)
  JVRP(254) = V(35)
! JVRP(255) = dARP(151)/dV(31)
  JVRP(255) = V(62)
! JVRP(256) = dARP(151)/dV(62)
  JVRP(256) = V(31)
! JVRP(257) = dARP(152)/dV(31)
  JVRP(257) = V(61)
! JVRP(258) = dARP(152)/dV(61)
  JVRP(258) = V(31)
! JVRP(259) = dARP(153)/dV(7)
  JVRP(259) = 1
! JVRP(260) = dARP(154)/dV(15)
  JVRP(260) = V(60)
! JVRP(261) = dARP(154)/dV(60)
  JVRP(261) = V(15)
! JVRP(262) = dARP(155)/dV(37)
  JVRP(262) = V(60)
! JVRP(263) = dARP(155)/dV(60)
  JVRP(263) = V(37)
! JVRP(264) = dARP(156)/dV(37)
  JVRP(264) = 1
! JVRP(265) = dARP(157)/dV(46)
  JVRP(265) = V(63)
! JVRP(266) = dARP(157)/dV(63)
  JVRP(266) = V(46)
! JVRP(267) = dARP(158)/dV(46)
  JVRP(267) = V(60)
! JVRP(268) = dARP(158)/dV(60)
  JVRP(268) = V(46)
! JVRP(269) = dARP(159)/dV(46)
  JVRP(269) = V(53)
! JVRP(270) = dARP(159)/dV(53)
  JVRP(270) = V(46)
! JVRP(271) = dARP(160)/dV(46)
  JVRP(271) = V(56)
! JVRP(272) = dARP(160)/dV(56)
  JVRP(272) = V(46)
! JVRP(273) = dARP(161)/dV(47)
  JVRP(273) = V(60)
! JVRP(274) = dARP(161)/dV(60)
  JVRP(274) = V(47)
! JVRP(275) = dARP(162)/dV(47)
  JVRP(275) = V(53)
! JVRP(276) = dARP(162)/dV(53)
  JVRP(276) = V(47)
! JVRP(277) = dARP(163)/dV(47)
  JVRP(277) = V(56)
! JVRP(278) = dARP(163)/dV(56)
  JVRP(278) = V(47)
! JVRP(279) = dARP(164)/dV(47)
  JVRP(279) = 1
! JVRP(280) = dARP(165)/dV(42)
  JVRP(280) = V(63)
! JVRP(281) = dARP(165)/dV(63)
  JVRP(281) = V(42)
! JVRP(282) = dARP(166)/dV(42)
  JVRP(282) = V(60)
! JVRP(283) = dARP(166)/dV(60)
  JVRP(283) = V(42)
! JVRP(284) = dARP(167)/dV(42)
  JVRP(284) = V(53)
! JVRP(285) = dARP(167)/dV(53)
  JVRP(285) = V(42)
! JVRP(286) = dARP(168)/dV(42)
  JVRP(286) = V(56)
! JVRP(287) = dARP(168)/dV(56)
  JVRP(287) = V(42)
! JVRP(288) = dARP(169)/dV(4)
  JVRP(288) = V(60)
! JVRP(289) = dARP(169)/dV(60)
  JVRP(289) = V(4)
! JVRP(290) = dARP(170)/dV(11)
  JVRP(290) = V(60)
! JVRP(291) = dARP(170)/dV(60)
  JVRP(291) = V(11)
! JVRP(292) = dARP(171)/dV(9)
  JVRP(292) = V(60)
! JVRP(293) = dARP(171)/dV(60)
  JVRP(293) = V(9)
! JVRP(294) = dARP(172)/dV(46)
  JVRP(294) = V(61)
! JVRP(295) = dARP(172)/dV(61)
  JVRP(295) = V(46)
! JVRP(296) = dARP(173)/dV(4)
  JVRP(296) = 1
      
END SUBROUTINE JacReactantProd

! End of JacReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



! Begin Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Fun with respect to rate coefficients
! -----------------------------------------------------------------------------

      SUBROUTINE  dFun_dRcoeff( V, F, NCOEFF, JCOEFF, DFDR )
       
      USE CB05_CSIRO_Parameters
      USE CB05_CSIRO_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/radical/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Fun(1:NVAR) / d RCT( JCOEFF(j) )
!         for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DFDR(NVAR*NCOEFF)

! Local vector with reactant products
      REAL(kind=dp) A_RPROD(NREACT)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the reactant products of all reactions     
      CALL ReactantProd ( V, F, A_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_RPROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DFDR(i+NVAR*(j-1)) = 0.0_dp 
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  reactant product  of the JCOEFF(j)-th reaction      
!                  give the j-th column of the derivative matrix   
         aj = A_RPROD(JCOEFF(j))
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DFDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dFun_dRcoeff

! End Derivative w.r.t. Rate Coefficients


! Begin Jacobian Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Jac with respect to rate coefficients
! Times a user vector
! -----------------------------------------------------------------------------

      SUBROUTINE  dJac_dRcoeff( V, F, U, NCOEFF, JCOEFF, DJDR )
       
      USE CB05_CSIRO_Parameters
      USE CB05_CSIRO_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! U - User-supplied Vector           
      REAL(kind=dp) U(NVAR)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Jac(1:NVAR) / d RCT( JCOEFF(j) ) * U
!                     for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DJDR(NVAR*NCOEFF)

! Local vector for Jacobian of reactant products
      REAL(kind=dp) JV_RPROD(NJVRP)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the Jacobian of all reactant products   
      CALL JacReactantProd( V, F, JV_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_PROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DJDR(i+NVAR*(j-1)) = 0.0_dp
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  ( Gradient of reactant product of the JCOEFF(j)-th reaction X user vector )    
!                  give the j-th column of the derivative matrix   
!
!          Row JCOEFF(j) of JV_RPROD times the user vector
         aj = 0.0_dp
         DO k=CROW_JVRP(JCOEFF(j)),CROW_JVRP(JCOEFF(j)+1)-1
             aj = aj + JV_RPROD(k)*U(ICOL_JVRP(k))
         END DO
!          Column JCOEFF(j) of Stoichiom. matrix times aj         
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DJDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dJac_dRcoeff

! End Jacobian Derivative w.r.t. Rate Coefficients


END MODULE CB05_CSIRO_Stoichiom

