! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CB05_CSIRO_Rates.f90
! Time                 : Thu Oct  8 08:21:51 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CB05_CSIRO_26998_BOXMOX
! Equation file        : CB05_CSIRO.kpp
! Output root filename : CB05_CSIRO
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CB05_CSIRO_Rates

  USE CB05_CSIRO_Parameters
  USE CB05_CSIRO_Global
  USE CB05_CSIRO_Util
  IMPLICIT NONE

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!  Note: the default argument type for rate laws, as read from the equations file, is single precision
!        but all the internal calculations are performed in double precision
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!~~~>  Arrhenius
!   REAL(kind=dp) FUNCTION ARR( A0,B0,C0 )
!      REAL A0,B0,C0
!      ARR =  DBLE(A0) * EXP(-DBLE(B0)/TEMP) * (TEMP/300.0_dp)**DBLE(C0)
!   END FUNCTION ARR

! Arrhenius (added by psaide 15-07-2009)
    REAL(kind=dp) FUNCTION ARR( A0,B0,C0, TEMP )
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) A0,B0,C0
      ARR =  A0 * EXP( -B0 /TEMP ) * (TEMP/300._dp)**C0
    END FUNCTION ARR

!~~~> Simplified Arrhenius, with two arguments
!~~~> Note: The argument B0 has a changed sign when compared to ARR
!   REAL(kind=dp) FUNCTION ARR2( A0,B0 )
!      REAL A0,B0
!      ARR2 =  DBLE(A0) * EXP( DBLE(B0)/TEMP )
!   END FUNCTION ARR2
! CK 20140313 WRF-chem uses different kind of Arrhenius function
!             with TEMP as argument...
   REAL(kind=dp) FUNCTION ARR2( A0,B0, TEMP )
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) A0,B0
      ARR2 = A0 * EXP( -B0 /TEMP )
   END FUNCTION ARR2
! CK 20140313 end

!   REAL(kind=dp) FUNCTION EP2(A0,C0,A2,C2,A3,C3)
!      REAL A0,C0,A2,C2,A3,C3
!      REAL(kind=dp) K0,K2,K3
!      K0 = DBLE(A0) * EXP(-DBLE(C0)/TEMP)
!      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
!      K3 = DBLE(A3) * EXP(-DBLE(C3)/TEMP)
!      K3 = K3*CFACTOR*1.0E6_dp
!      EP2 = K0 + K3/(1.0_dp+K3/K2 )
!   END FUNCTION EP2

!   REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2)
!      REAL A1, C1, A2, C2
!      REAL(kind=dp) K1, K2
!      K1 = DBLE(A1) * EXP(-DBLE(C1)/TEMP)
!      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
!      EP3 = K1 + K2*(1.0E6_dp*CFACTOR)
!   END FUNCTION EP3

! EP2 (added by psaide 22-07-2009)
   REAL(kind=dp) FUNCTION EP2( A0,C0,A2,C2,A3,C3,TEMP,cair)
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) :: cair
      REAL(kind=dp) A0,C0,A2,C2,A3,C3
      REAL(kind=dp) K0,K2,K3

      K0 = A0 * EXP(-C0 /TEMP)
      K2 = A2 * EXP(-C2 /TEMP)
      K3 = A3 * EXP(-C3 /TEMP)
!      K3 = K3 * 2.45E13_dp * 1.0E6_dp
      K3 = K3 * cair
      EP2 = K0 + K3/(1._dp+K3/K2 )
   END FUNCTION EP2

! EP3 (added by psaide 15-07-2009)
    REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2,TEMP,cair)
      REAL(kind=dp) :: TEMP
      REAL(kind=dp) :: cair
      REAL(kind=dp) A1, C1, A2, C2
      REAL(kind=dp) K1, K2

      K1 = A1 * EXP(-C1 /TEMP)
      K2 = A2 * EXP(-C2 /TEMP)
!      EP3 = K1 + K2*(1.0E6_dp * 2.45E13_dp)
      EP3 = K1 + K2*cair
    END FUNCTION EP3


!   REAL(kind=dp) FUNCTION FALL ( A0,B0,C0,A1,B1,C1,CF)
!      REAL A0,B0,C0,A1,B1,C1,CF
!      REAL(kind=dp) K0, K1
!      K0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
!      K1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
!      K0 = K0*CFACTOR*1.0E6_dp
!      K1 = K0/K1
!      FALL = (K0/(1.0_dp+K1))*   &
!           DBLE(CF)**(1.0_dp/(1.0_dp+(LOG10(K1))**2))
!   END FUNCTION FALL

! FALL (added by psaide 15-07-2009)
    REAL(kind=dp) FUNCTION FALL( A0,B0,C0,A1,B1,C1,CF,TEMP,cair)

      INTRINSIC LOG10

      REAL(kind=dp) :: TEMP
      REAL(kind=dp) :: cair
      REAL(kind=dp) A0,B0,C0,A1,B1,C1,CF
      REAL(kind=dp) K0, K1

      K0 = A0 * EXP(-B0 /TEMP)* (TEMP/300._dp)**C0
      K1 = A1 * EXP(-B1 /TEMP)* (TEMP/300._dp)**C1
!      K0 = K0 * 2.45E13_dp * 1.0E6_dp
      K0 = K0 * cair
      K1 = K0/K1
      FALL = (K0/(1._dp+K1))*CF**(1._dp/(1._dp+(LOG10(K1))**2))

    END FUNCTION FALL

! FALL2 (added by psaide 28-10-2009)
    REAL(KIND=dp) FUNCTION F2( A0,B0,C0,A1,B1,C1,CF,CN,TEMP,cair)

      INTRINSIC LOG10

      REAL(KIND=dp) :: TEMP
      REAL(KIND=dp) :: cair
      REAL(KIND=dp) A0,B0,C0,A1,B1,C1,CF,CN
      REAL(KIND=dp) K0, K1

      K0 = A0 * EXP(-B0 /TEMP)* (TEMP/300._dp)**C0
      K1 = A1 * EXP(-B1 /TEMP)* (TEMP/300._dp)**C1
!      K0 = K0 * 2.45E13_dp * 1.0E6_dp
      K0 = K0 * cair
      K1 = K0/K1
      F2 = (K0/(1._dp+K1))*CF**(1._dp/(1._dp+(LOG10(K1)/CN)**2))

    END FUNCTION F2


  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_3rd(temp,cair,k0_300K,n,kinf_300K,m,fc)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL, INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL, INTENT(IN) :: n         ! exponent for low pressure limit
    REAL, INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL, INTENT(IN) :: m         ! exponent for high pressure limit
    REAL, INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(kind=dp) :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    k_3rd   = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))

  END FUNCTION k_3rd

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_arr (k_298,tdep,temp)
    ! Arrhenius function

    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(kind=dp), INTENT(IN) :: temp  ! temperature

    INTRINSIC EXP

    k_arr = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) ! 1/298.15=3.3540e-3

  END FUNCTION k_arr

! CK 20140313 in the following some more rate functions needed by
!             WRF-chem packages

!------------------------------------
! Troe reactions (as in Stockwell et al, 1997)

    REAL(kind=dp) FUNCTION TROE(k0_300K,n,kinf_300K,m,temp,cair)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(kind=dp),          INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(kind=dp),          INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(kind=dp),          INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(kind=dp),          INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(kind=dp)             :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    TROE   = k0_T/(1._dp+k_ratio)*0.6_dp**(1._dp/(1._dp+LOG10(k_ratio)**2))

   END FUNCTION TROE



!-------------------------------------------
! Troe equilibrium reactions (as in Stockwell et al, 1997)

    REAL(kind=dp) FUNCTION TROEE(A, B, k0_300K,n,kinf_300K,m,temp,cair)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(kind=dp),     INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(kind=dp),     INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(kind=dp),     INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(kind=dp),     INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(kind=dp),     INTENT(IN) :: A, B
    REAL(kind=dp)             :: zt_help, k0_T, kinf_T, k_ratio, troe


    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    troe   = k0_T/(1._dp+k_ratio)*0.6_dp**(1._dp/(1._dp+LOG10(k_ratio)**2))

    TROEE = A * EXP( - B / temp) * troe



  END FUNCTION TROEE

!------------------------
! k=T^2 C exp (-D/T) reactions

   REAL(kind=dp) FUNCTION THERMAL_T2(c, d ,temp)
    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp),     INTENT(IN) :: c, d


     THERMAL_T2= temp**2._dp * c * EXP(- d  / temp)

   END FUNCTION THERMAL_T2

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions



! ****************************************************************************
! J - the photolysis rate retrieval function
! ****************************************************************************
      REAL(kind=dp) FUNCTION J(name)

      CHARACTER(LEN=*), INTENT(IN)     :: name

      CHARACTER(LEN=15) :: xname

      INTEGER                          :: i

      xname(:)           = " "
      xname(1:LEN(name)) = name

      J                  = jvalues(hash(xname))

      RETURN

      END FUNCTION J
! ****************************************************************************


REAL(KIND=dp) FUNCTION k46( TEMP, C_M )
    REAL(KIND=dp), INTENT(IN) :: temp, c_m
    REAL(KIND=dp) :: k0, k2, k3

   k0=7.2E-15_dp * EXP(785._dp/TEMP)
   k2=4.1E-16_dp * EXP(1440._dp/TEMP)
   k3=1.9E-33_dp * EXP(725._dp/TEMP)

   k46=k0+k3/(1+k3/k2)


END FUNCTION k46



! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
      !USE CB05_CSIRO_Parameters
      !USE CB05_CSIRO_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST


! End INLINED RCONST

  RCONST(1) = (j('no2'))
  RCONST(2) = (0.21*C_M*C_M*ARR(6.0e-34_dp,0.0_dp,-2.4_dp,TEMP))
  RCONST(3) = (ARR2(3.0e-12_dp,1500.0_dp,TEMP))
  RCONST(4) = (ARR2(5.6e-12_dp,-180.0_dp,TEMP))
  RCONST(5) = (TROE(2.5e-31_dp,1.8_dp,2.2e-11,0.7_dp,TEMP,C_M))
  RCONST(6) = (TROE(9.0e-32_dp,1.5_dp,3.0e-11,0.0_dp,TEMP,C_M))
  RCONST(7) = (ARR2(1.2e-13_dp,2450.0_dp,TEMP))
  RCONST(8) = (j('o33p'))
  RCONST(9) = (j('o31d'))
  RCONST(10) = (ARR2(2.1e-11_dp,-102.0_dp,TEMP))
  RCONST(11) = (2.2e-10_dp)
  RCONST(12) = (ARR2(1.7e-12_dp,940.0_dp,TEMP))
  RCONST(13) = (ARR2(1.0e-14_dp,490.0_dp,TEMP))
  RCONST(14) = (j('no3o'))
  RCONST(15) = (j('no3o2'))
  RCONST(16) = (ARR2(1.5e-11_dp,-170.0_dp,TEMP))
  RCONST(17) = (ARR2(4.5e-14_dp,1260.0_dp,TEMP))
  RCONST(18) = (TROE(2.0e-30_dp,4.4_dp,1.4e-12_dp,0.7_dp,TEMP,C_M))
  RCONST(19) = (2.5e-22_dp)
  RCONST(20) = (1.8e-39_dp)
  RCONST(21) = (TROEE(3.70e26_dp,11000.0_dp,2.0e-30_dp,4.4_dp,1.4e-12_dp,0.7_dp,TEMP,C_M))
  RCONST(22) = (ARR2(3.3e-39_dp,-530.0_dp,TEMP)*0.21*C_M)
  RCONST(23) = (5.0e-40_dp)
  RCONST(24) = (TROE(7.0e-31_dp,2.6_dp,3.6e-11_dp,0.1_dp,TEMP,C_M))
  RCONST(25) = (j('hno2'))
  RCONST(26) = (ARR2(1.8e-11_dp,390.0_dp,TEMP))
  RCONST(27) = (1.0e-20_dp)
  RCONST(28) = (TROE(2.0e-30_dp,3.0_dp,2.5e-11_dp,0.0_dp,TEMP,C_M))
  RCONST(29) = (EP2(2.4e-14_dp,-460.0_dp,2.7e-17_dp,-2199.0_dp,6.5e-34_dp,-1335.0_dp,TEMP,C_M))
  RCONST(30) = (ARR2(3.5e-12_dp,-250.0_dp,TEMP))
  RCONST(31) = (TROE(1.8e-31_dp,3.2_dp,4.7e-12_dp,0.0_dp,TEMP,C_M))
  RCONST(32) = (FALL(4.1e-05_dp,10650.0_dp,0.0_dp,4.8e15_dp,11170.0_dp,0.0_dp,0.6_dp,TEMP,C_M))
  RCONST(33) = (ARR2(1.3e-12_dp,-380.0_dp,TEMP))
  RCONST(34) = (EP3(2.3e-13_dp,-600.0_dp,1.7e-33_dp,-1000.0_dp,TEMP,C_M))
  RCONST(35) = (EP3(3.22e-34_dp,-2800.0_dp,2.38e-54_dp,-3200.0_dp,TEMP,C_M))
  RCONST(36) = (j('h2o2'))
  RCONST(37) = (ARR2(2.9e-12_dp,160.0_dp,TEMP))
  RCONST(38) = (1.1e-10_dp)
  RCONST(39) = (ARR2(5.5e-12_dp,2000.0_dp,TEMP))
  RCONST(40) = (ARR2(2.2e-11_dp,-120.0_dp,TEMP))
  RCONST(41) = (ARR2(4.2e-12_dp,240.0_dp,TEMP))
  RCONST(42) = (TROE(6.9e-31_dp,1.0_dp,2.6e-11_dp,0.0_dp,TEMP,C_M))
  RCONST(43) = (ARR2(4.8e-11_dp,-250.0_dp,TEMP))
  RCONST(44) = (ARR2(3.0e-11_dp,-200.0_dp,TEMP))
  RCONST(45) = (ARR2(1.4e-12_dp,2000.0_dp,TEMP))
  RCONST(46) = (1.0e-11_dp)
  RCONST(47) = (2.2e-11_dp)
  RCONST(48) = (3.5e-12_dp)
  RCONST(49) = (1.0e-17_dp)
  RCONST(50) = (ARR2(8.5e-13_dp,2450.0_dp,TEMP))
  RCONST(51) = (j('hno4'))
  RCONST(52) = (j('hno3'))
  RCONST(53) = (j('n2o5'))
  RCONST(54) = (ARR2(2.6e-12_dp,-365.0_dp,TEMP))
  RCONST(55) = (ARR2(2.6e-12_dp,-365.0_dp,TEMP))
  RCONST(56) = (ARR2(7.5e-13_dp,-700.0_dp,TEMP))
  RCONST(57) = (ARR2(7.5e-13_dp,-700.0_dp,TEMP))
  RCONST(58) = (6.8e-14_dp)
  RCONST(59) = (6.8e-14_dp)
  RCONST(60) = (6.8e-14_dp)
  RCONST(61) = (ARR2(5.9e-13_dp,360.0_dp,TEMP))
  RCONST(62) = (1.0e-4*j('no2'))
  RCONST(63) = (ARR2(3.01e-12_dp,-190.0_dp,TEMP))
  RCONST(64) = (0.7*j('h2o2'))
  RCONST(65) = (EP3(1.44e-13_dp,0.0_dp,3.43e-33_dp,0.0_dp,TEMP,C_M))
  RCONST(66) = (ARR2(2.45e-12_dp,1775.0_dp,TEMP))
  RCONST(67) = (ARR2(2.8e-12_dp,-300.0_dp,TEMP))
  RCONST(68) = (ARR2(4.1e-13_dp,-750.0_dp,TEMP))
  RCONST(69) = (ARR2(9.5e-14_dp,-390.0_dp,TEMP))
  RCONST(70) = (ARR2(3.8e-12_dp,-200.0_dp,TEMP))
  RCONST(71) = (0.7*j('h2o2'))
  RCONST(72) = (ARR2(7.3e-12_dp,620.0_dp,TEMP))
  RCONST(73) = (9.0e-12_dp)
  RCONST(74) = (j('ch2or'))
  RCONST(75) = (j('ch2om'))
  RCONST(76) = (ARR2(3.4e-11_dp,1600.0_dp,TEMP))
  RCONST(77) = (5.8e-16_dp)
  RCONST(78) = (ARR2(9.7e-15_dp,-625.0_dp,TEMP))
  RCONST(79) = (ARR2(2.4e+12_dp,7000.0_dp,TEMP))
  RCONST(80) = (5.6e-12_dp)
  RCONST(81) = (ARR2(5.6e-15_dp,-2300.0_dp,TEMP))
  RCONST(82) = (4.0e-13_dp)
  RCONST(83) = (ARR2(1.8e-11_dp,1100.0_dp,TEMP))
  RCONST(84) = (ARR2(5.6e-12_dp,-270.0_dp,TEMP))
  RCONST(85) = (ARR2(1.4e-12_dp,1900.0_dp,TEMP))
  RCONST(86) = (4.6e-4*j('no2'))
  RCONST(87) = (ARR2(8.1e-12_dp,-270.0_dp,TEMP))
  RCONST(88) = (FALL(2.7e-28_dp,0.0_dp,-7.1_dp,1.2e-11_dp,0.0_dp,-0.9_dp,0.3_dp,TEMP,C_M))
  RCONST(89) = (FALL(4.9e-03_dp,12100.0_dp,0.0_dp,5.4e16_dp,13830.0_dp,0.0_dp,0.3_dp,TEMP,C_M))
  RCONST(90) = (j('pan'))
  RCONST(91) = (ARR2(4.3e-13_dp,-1040.0_dp,TEMP))
  RCONST(92) = (ARR2(2.0e-12_dp,-500.0_dp,TEMP))
  RCONST(93) = (ARR2(4.4e-13_dp,-1070.0_dp,TEMP))
  RCONST(94) = (ARR2(2.9e-12_dp,-500.0_dp,TEMP))
  RCONST(95) = (ARR2(4.0e-13_dp,-200.0_dp,TEMP))
  RCONST(96) = (0.0*0.7*j('h2o2'))
  RCONST(97) = (ARR2(4.0e-13_dp,-200.0_dp,TEMP))
  RCONST(98) = (ARR2(1.3e-11_dp,870.0_dp,TEMP))
  RCONST(99) = (ARR2(5.1e-12_dp,-405.0_dp,TEMP))
  RCONST(100) = (6.5e-15_dp)
  RCONST(101) = (j('ch3cho'))
  RCONST(102) = (ARR2(6.7e-12_dp,-340.0_dp,TEMP))
  RCONST(103) = (FALL(2.7e-28_dp,0.0_dp,-7.1_dp,1.2e-11_dp,0.0_dp,-0.9_dp,0.3_dp,TEMP,C_M))
  RCONST(104) = (FALL(4.9e-03_dp,12100.0_dp,0.0_dp,5.4e16_dp,13830.0_dp,0.0_dp,0.3_dp,TEMP,C_M))
  RCONST(105) = (j('pan'))
  RCONST(106) = (3.0e-13_dp)
  RCONST(107) = (ARR2(4.3e-13_dp,-1040.0_dp,TEMP))
  RCONST(108) = (ARR2(2.0e-12_dp,-500.0_dp,TEMP))
  RCONST(109) = (ARR2(4.4e-13_dp,-1070.0_dp,TEMP))
  RCONST(110) = (ARR2(2.9e-12_dp,-500.0_dp,TEMP))
  RCONST(111) = (ARR2(2.9e-12_dp,-500.0_dp,TEMP))
  RCONST(112) = (8.1e-13_dp)
  RCONST(113) = (ARR2(1.0e15_dp,8000.0_dp,TEMP))
  RCONST(114) = (1.6E+03_dp)
  RCONST(115) = (1.5e-11_dp)
  RCONST(116) = (ARR2(1.0e-11_dp,280.0_dp,TEMP))
  RCONST(117) = (3.2e-11_dp)
  RCONST(118) = (ARR2(6.5e-15_dp,1900.0_dp,TEMP))
  RCONST(119) = (ARR2(7.0e-13_dp,2160.0_dp,TEMP))
  RCONST(120) = (ARR2(1.04e-11_dp,792.0_dp,TEMP))
  RCONST(121) = (TROE(1.0e-28_dp,0.8_dp,8.8e-12_dp,0.0_dp,TEMP,C_M))
  RCONST(122) = (ARR2(1.2e-14_dp,2630.0_dp,TEMP))
  RCONST(123) = (ARR2(3.3e-12_dp,2880.0_dp,TEMP))
  RCONST(124) = (2.3e-11_dp)
  RCONST(125) = (ARR2(1.0e-11_dp,-550.0_dp,TEMP))
  RCONST(126) = (ARR2(8.4e-15_dp,1100.0_dp,TEMP))
  RCONST(127) = (ARR2(9.6e-13_dp,270.0_dp,TEMP))
  RCONST(128) = (ARR2(1.8e-12_dp,-355.0_dp,TEMP))
  RCONST(129) = (ARR2(2.7e-12_dp,-360.0_dp,TEMP))
  RCONST(130) = (ARR2(1.9e-13_dp,-1300.0_dp,TEMP))
  RCONST(131) = (ARR2(1.7e-12_dp,-950.0_dp,TEMP))
  RCONST(132) = (1.4e-11_dp)
  RCONST(133) = (2.1e-12_dp)
  RCONST(134) = (5.5e-12_dp)
  RCONST(135) = (1.53e-12_dp)
  RCONST(136) = (3.80e-12_dp)
  RCONST(137) = (2.10e-12_dp)
  RCONST(138) = (2.86e-12_dp)
  RCONST(139) = (ARR2(2.54e-12_dp,-360.0_dp,TEMP))
  RCONST(140) = (ARR2(2.4e-13_dp,-1300.0_dp,TEMP))
  RCONST(141) = (j('no2'))
  RCONST(142) = (ARR2(1.9e-12_dp,-190.0_dp,TEMP))
  RCONST(143) = (j('no2'))
  RCONST(144) = (4.4e-11_dp)
  RCONST(145) = (ARR2(5.4e-17_dp,500.0_dp,TEMP))
  RCONST(146) = (3.8e-12_dp)
  RCONST(147) = (7.0e-11_dp)
  RCONST(148) = (1.7e-10_dp)
  RCONST(149) = (ARR2(2.54e-12_dp,-360.0_dp,TEMP))
  RCONST(150) = (ARR2(2.4e-13_dp,-1300.0_dp,TEMP))
  RCONST(151) = (1.0e-11_dp)
  RCONST(152) = (1.0e-11_dp)
  RCONST(153) = (1.0e-04_dp)
  RCONST(154) = (ARR2(1.7e-11_dp,-116.0_dp,TEMP))
  RCONST(155) = (1.7e-11_dp)
  RCONST(156) = (9.64*j('ch2or'))
  RCONST(157) = (3.6e-11_dp)
  RCONST(158) = (ARR2(2.54e-11_dp,-407.6_dp,TEMP))
  RCONST(159) = (ARR2(7.86e-15_dp,1912.0_dp,TEMP))
  RCONST(160) = (ARR2(3.03e-12_dp,448.0_dp,TEMP))
  RCONST(161) = (3.36e-11_dp)
  RCONST(162) = (7.1e-18_dp)
  RCONST(163) = (1.0e-15_dp)
  RCONST(164) = (0.0036*0.025*j('ch2om'))
  RCONST(165) = (3.6e-11_dp)
  RCONST(166) = (ARR2(1.5e-11_dp,-449.0_dp,TEMP))
  RCONST(167) = (ARR2(1.2e-15_dp,821.0_dp,TEMP))
  RCONST(168) = (ARR2(3.7e-12_dp,-175.0_dp,TEMP))
  RCONST(169) = (TROE(3.3e-31_dp,4.3_dp,1.6e-12_dp,0.0_dp,TEMP,C_M))
  RCONST(170) = (ARR2(6.9e-12_dp,230.0_dp,TEMP))
  RCONST(171) = (ARR2(8.7e-12_dp,1070.0_dp,TEMP))
  RCONST(172) = (1.5e-19_dp)
  RCONST(173) = (rtdat_ae_so2)
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )


   USE CB05_CSIRO_Global

  RCONST(1) = (j('no2'))
  RCONST(8) = (j('o33p'))
  RCONST(9) = (j('o31d'))
  RCONST(14) = (j('no3o'))
  RCONST(15) = (j('no3o2'))
  RCONST(25) = (j('hno2'))
  RCONST(36) = (j('h2o2'))
  RCONST(51) = (j('hno4'))
  RCONST(52) = (j('hno3'))
  RCONST(53) = (j('n2o5'))
  RCONST(62) = (1.0e-4*j('no2'))
  RCONST(64) = (0.7*j('h2o2'))
  RCONST(71) = (0.7*j('h2o2'))
  RCONST(74) = (j('ch2or'))
  RCONST(75) = (j('ch2om'))
  RCONST(86) = (4.6e-4*j('no2'))
  RCONST(90) = (j('pan'))
  RCONST(96) = (0.0*0.7*j('h2o2'))
  RCONST(101) = (j('ch3cho'))
  RCONST(105) = (j('pan'))
  RCONST(143) = (j('no2'))
  RCONST(156) = (9.64*j('ch2or'))
  RCONST(164) = (0.0036*0.025*j('ch2om'))
      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE CB05_CSIRO_Rates

