! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Linear Algebra Data and Routines File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CB05_CSIRO_LinearAlgebra.f90
! Time                 : Thu Oct  8 08:21:51 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CB05_CSIRO_26998_BOXMOX
! Equation file        : CB05_CSIRO.kpp
! Output root filename : CB05_CSIRO
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CB05_CSIRO_LinearAlgebra

  USE CB05_CSIRO_Parameters
  USE CB05_CSIRO_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! SPARSE_UTIL - SPARSE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecomp( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05_CSIRO_Parameters
  USE CB05_CSIRO_JacobianSP

      INTEGER  :: IER
      REAL(kind=dp) :: JVS(LU_NONZERO), W(NVAR), a
      INTEGER  :: k, kk, j, jj

      a = 0. ! mz_rs_20050606
      IER = 0
      DO k=1,NVAR
        ! mz_rs_20050606: don't check if real value == 0
        ! IF ( JVS( LU_DIAG(k) ) .EQ. 0. ) THEN
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(a) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecomp


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplx( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization, complex
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05_CSIRO_Parameters
  USE CB05_CSIRO_JacobianSP

      INTEGER        :: IER
      DOUBLE COMPLEX :: JVS(LU_NONZERO), W(NVAR), a
      REAL(kind=dp)  :: b = 0.0
      INTEGER        :: k, kk, j, jj

      IER = 0
      DO k=1,NVAR
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(b) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecompCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplxR( JVSR, JVSI, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!    Sparse LU factorization, complex
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05_CSIRO_Parameters
  USE CB05_CSIRO_JacobianSP

      INTEGER       :: IER
      REAL(kind=dp) :: JVSR(LU_NONZERO), JVSI(LU_NONZERO) 
      REAL(kind=dp) :: WR(NVAR), WI(NVAR), ar, ai, den
      INTEGER       :: k, kk, j, jj

      IER = 0
      ar  = 0.0
      DO k=1,NVAR
        IF (  ( ABS(JVSR(LU_DIAG(k))) < TINY(ar) ) .AND. &
              ( ABS(JVSI(LU_DIAG(k))) < TINY(ar) ) )  THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              WR( LU_ICOL(kk) ) = JVSR(kk)
              WI( LU_ICOL(kk) ) = JVSI(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            den = JVSR(LU_DIAG(j))**2 + JVSI(LU_DIAG(j))**2
            ar = -(WR(j)*JVSR(LU_DIAG(j)) + WI(j)*JVSI(LU_DIAG(j)))/den
            ai = -(WI(j)*JVSR(LU_DIAG(j)) - WR(j)*JVSI(LU_DIAG(j)))/den
            WR(j) = -ar
            WI(j) = -ai
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               WR( LU_ICOL(jj) ) = WR( LU_ICOL(jj) ) + ar*JVSR(jj) - ai*JVSI(jj)
               WI( LU_ICOL(jj) ) = WI( LU_ICOL(jj) ) + ar*JVSI(jj) + ai*JVSR(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVSR(kk) = WR( LU_ICOL(kk) )
            JVSI(kk) = WI( LU_ICOL(kk) )
         END DO
      END DO

END SUBROUTINE KppDecompCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05_CSIRO_Parameters
  USE CB05_CSIRO_JacobianSP

      INTEGER  :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05_CSIRO_Parameters
  USE CB05_CSIRO_JacobianSP

      INTEGER       :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05_CSIRO_Parameters
  USE CB05_CSIRO_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveCmplx

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05_CSIRO_Parameters
  USE CB05_CSIRO_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), sumr, sumi, den

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             XR(i) = XR(i) - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
             XI(i) = XI(i) - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
         END DO  
      END DO

      DO i=NVAR,1,-1
        sumr = XR(i); sumi = XI(i)
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
            sumr = sumr - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
            sumi = sumi - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
        END DO
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (sumr*JVSR(LU_DIAG(i)) + sumi*JVSI(LU_DIAG(i)))/den
        XI(i) = (sumi*JVSR(LU_DIAG(i)) - sumr*JVSI(LU_DIAG(i)))/den
      END DO
      
END SUBROUTINE KppSolveCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05_CSIRO_Parameters
  USE CB05_CSIRO_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve transpose subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05_CSIRO_Parameters
  USE CB05_CSIRO_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), den

      DO i=1,NVAR
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (XR(i)*JVSR(LU_DIAG(i)) + XI(i)*JVSI(LU_DIAG(i)))/den
        XI(i) = (XI(i)*JVSR(LU_DIAG(i)) - XR(i)*JVSI(LU_DIAG(i)))/den
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplxR


!
! Next few commented subroutines perform sparse big linear algebra
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppDecompBig( JVS, IP, IER )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse LU factorization
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE CB05_CSIRO_Parameters
!  USE CB05_CSIRO_JacobianSP
!
!      INTEGER  :: IP3(3), IER, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), W(3,3,NVAR), a(3,3), E(3,3)
!      INTEGER  :: k, kk, j, jj
!
!      a = 0.0d0
!      IER = 0
!      DO k=1,NVAR
!        DO kk = LU_CROW(k), LU_CROW(k+1)-1
!              W( 1:3,1:3,LU_ICOL(kk) ) = JVS(1:3,1:3,kk)
!        END DO
!        DO kk = LU_CROW(k), LU_DIAG(k)-1
!            j = LU_ICOL(kk)
!            E(1:3,1:3) = JVS( 1:3,1:3,LU_DIAG(j) )
!            ! CALL DGETRF(3,3,E,3,IP3,IER) 
!            CALL FAC3(E,IP3,IER)
!            IF ( IER /= 0 )  RETURN
!            ! a = W(j) / JVS( LU_DIAG(j) )
!            a(1:3,1:3) = W( 1:3,1:3,j )
!            ! CALL DGETRS ('N',3,3,E,3,IP3,a,3,IER) 
!            CALL SOL3('N',E,IP3,a(1,1))
!            CALL SOL3('N',E,IP3,a(1,2))
!            CALL SOL3('N',E,IP3,a(1,3))
!            W(1:3,1:3,j) = a(1:3,1:3)
!            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
!               W( 1:3,1:3,LU_ICOL(jj) ) = W( 1:3,1:3,LU_ICOL(jj) ) &
!                        - MATMUL( a(1:3,1:3) , JVS(1:3,1:3,jj) )
!            END DO
!         END DO
!         DO kk = LU_CROW(k), LU_CROW(k+1)-1
!            JVS(1:3,1:3,kk) = W( 1:3,1:3,LU_ICOL(kk) )
!         END DO
!      END DO
!
!      DO k=1,NVAR
!         ! CALL WGEFA(JVS(1,1,LU_DIAG(k)),3,3,IP(1,k),IER)
!         ! CALL DGETRF(3,3,JVS(1,1,LU_DIAG(k)),3,IP(1,k),IER)
!         CALL FAC3(JVS(1,1,LU_DIAG(k)),IP(1,k),IER)
!         IF ( IER /= 0 )  RETURN
!      END DO 
!      
!END SUBROUTINE KppDecompBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBig( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse solve subroutine using indirect addressing
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE CB05_CSIRO_Parameters
!  USE CB05_CSIRO_JacobianSP
!
!      INTEGER  :: i, j, k, m, IP3(3), IP(3,NVAR), IER
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR), sum(3)
!
!      DO i=1,NVAR
!        DO j = LU_CROW(i), LU_DIAG(i)-1 
!          !X(1:3,i) = X(1:3,i) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       X(k,i) = X(k,i) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO  
!      END DO
!
!      DO i=NVAR,1,-1
!        sum(1:3) = X(1:3,i);
!        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
!          !sum(1:3) = sum(1:3) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       sum(k) = sum(k) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO
!        ! X(i) = sum/JVS(LU_DIAG(i));
!        ! CALL DGETRS ('N',3,1,JVS(1:3,1:3,LU_DIAG(i)),3,IP(1,i),sum,3,0) 
!        ! CALL WGESL('N',JVS(1,1,LU_DIAG(i)),3,3,IP(1,i),sum)
!        CALL SOL3('N',JVS(1,1,LU_DIAG(i)),IP(1,i),sum)
!        X(1:3,i) = sum(1:3)
!      END DO
!      
!END SUBROUTINE KppSolveBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBigTR( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Big sparse transpose solve using indirect addressing
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE CB05_CSIRO_Parameters
!  USE CB05_CSIRO_JacobianSP
!
!      INTEGER       :: i, j, k, m, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR)
!
!      DO i=1,NVAR
!        ! X(i) = X(i)/JVS(LU_DIAG(i))
!        CALL SOL3('T',JVS(1,1,LU_DIAG(i)),IP(1,i),X(1,i))
!        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !    - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!
!      DO i=NVAR, 1, -1
!        DO j=LU_CROW(i),LU_DIAG(i)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !   - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!      
!END SUBROUTINE KppSolveBigTR
!
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE FAC3(A,IPVT,INFO)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     FAC3 FACTORS THE MATRIX A (3,3) BY
!!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!!     LINPACK - LIKE 
!!
!!     Remove comments to perform pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!
!      REAL(kind=dp) :: A(3,3)
!      INTEGER       :: IPVT(3),INFO
!!      INTEGER       :: L
!!      REAL(kind=dp) :: t, dmax, da, TMP(3)
!      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0
!
!      info = 0
!!      t = TINY(da)
!!      
!!      da = ABS(A(1,1)); L = 1
!!      IF ( ABS(A(2,1))>da ) THEN
!!        da = ABS(A(2,1)); L = 2
!!        IF ( ABS(A(3,1))>da ) THEN
!!          L = 3
!!        END IF  
!!      END IF  
!!      IPVT(1)  = L
!!      IF (L /=1 ) THEN
!!         TMP(1:3) = A(L,1:3)
!!         A(L,1:3) = A(1,1:3)
!!         A(1,1:3) = TMP(1:3)
!!      END IF
!!      IF (ABS(A(1,1)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!
!      A(2,1) = A(2,1)/A(1,1)
!      A(2,2) = A(2,2) - A(2,1)*A(1,2)
!      A(2,3) = A(2,3) - A(2,1)*A(1,3)
!      A(3,1) = A(3,1)/A(1,1)
!      A(3,2) = A(3,2) - A(3,1)*A(1,2)
!      A(3,3) = A(3,3) - A(3,1)*A(1,3)
!      
!!      IPVT(2)  = 2
!!      IF (ABS(A(3,2))>ABS(A(2,2))) THEN
!!         IPVT(2)  = 3
!!         TMP(2:3) = A(3,2:3)
!!         A(3,2:3) = A(2,2:3)
!!         A(2,2:3) = TMP(2:3)
!!      END IF
!!      IF (ABS(A(2,2)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!      
!      A(3,2)   = A(3,2)/A(2,2)
!      A(3,3)   = A(3,3) - A(3,2)*A(2,3)
!      IPVT(3)  = 3
!      
!END SUBROUTINE FAC3
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE SOL3(Trans,A,IPVT,b)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     SOL3 solves the system 3x3
!!     A * x = b  or  trans(a) * x = b
!!     using the factors computed by WGEFA.
!!
!!     Trans      = 'N'   to solve  A*x = b ,
!!                = 'T'   to solve  transpose(A)*x = b
!!     LINPACK - LIKE 
!!
!!     Remove comments to use pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!      CHARACTER     :: Trans
!      REAL(kind=dp) :: a(3,3),b(3)
!      INTEGER       :: IPVT(3)
!!      INTEGER       :: L
!!      REAL(kind=dp) :: TMP
!      
!      SELECT CASE (Trans)
!
!      CASE ('n','N')  !  Solve  A * x = b
!
!!     Solve  L*y = b
!!         L = IPVT(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!         b(2) = b(2)-A(2,1)*b(1)
!         b(3) = b(3)-A(3,1)*b(1)
!         
!!         L = IPVT(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(3) = b(3)-A(3,2)*b(2)
!
!!     Solve  U*x = y
!         b(3) = b(3)/A(3,3)
!         b(2) = (b(2)-A(2,3)*b(3))/A(2,2)
!         b(1) = (b(1)-A(1,3)*b(3)-A(1,2)*b(2))/A(1,1)
!      
!      
!      CASE ('t','T')  !  Solve transpose(A) * x = b
!
!!      Solve transpose(U)*y = b
!         b(1) = b(1)/A(1,1)
!         b(2) = (b(2)-A(1,2)*b(1))/A(2,2)
!         b(3) = (b(3)-A(1,3)*b(1)-A(2,3)*b(2))/A(3,3)
!
!!      Solve transpose(L)*x = y
!         b(2) = b(2)-A(3,2)*b(3)
!!         L = ipvt(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(1) = b(1)-A(3,1)*b(3)-A(2,1)*b(2)
!!         L = ipvt(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!   
!      END SELECT
!
!END SUBROUTINE SOL3

! End of SPARSE_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolve - sparse back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolve ( JVS, X )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)

  X(14) = X(14)-JVS(36)*X(13)
  X(29) = X(29)-JVS(102)*X(8)-JVS(103)*X(15)
  X(30) = X(30)-JVS(108)*X(26)
  X(31) = X(31)-JVS(115)*X(7)
  X(32) = X(32)-JVS(122)*X(18)
  X(33) = X(33)-JVS(129)*X(24)
  X(34) = X(34)-JVS(136)*X(12)-JVS(137)*X(24)-JVS(138)*X(25)-JVS(139)*X(33)
  X(35) = X(35)-JVS(152)*X(24)
  X(36) = X(36)-JVS(160)*X(29)-JVS(161)*X(35)
  X(37) = X(37)-JVS(181)*X(15)-JVS(182)*X(29)
  X(39) = X(39)-JVS(197)*X(18)-JVS(198)*X(25)-JVS(199)*X(32)-JVS(200)*X(33)
  X(43) = X(43)-JVS(224)*X(8)-JVS(225)*X(15)-JVS(226)*X(33)
  X(44) = X(44)-JVS(232)*X(15)-JVS(233)*X(28)-JVS(234)*X(40)-JVS(235)*X(41)-JVS(236)*X(42)
  X(45) = X(45)-JVS(246)*X(29)-JVS(247)*X(43)
  X(47) = X(47)-JVS(261)*X(46)
  X(48) = X(48)-JVS(268)*X(9)-JVS(269)*X(28)-JVS(270)*X(41)-JVS(271)*X(42)-JVS(272)*X(43)-JVS(273)*X(44)-JVS(274)*X(46)&
            &-JVS(275)*X(47)
  X(49) = X(49)-JVS(286)*X(11)-JVS(287)*X(27)-JVS(288)*X(28)-JVS(289)*X(31)-JVS(290)*X(38)-JVS(291)*X(40)-JVS(292)*X(41)&
            &-JVS(293)*X(42)-JVS(294)*X(43)-JVS(295)*X(44)-JVS(296)*X(45)-JVS(297)*X(46)-JVS(298)*X(47)-JVS(299)*X(48)
  X(50) = X(50)-JVS(310)*X(9)-JVS(311)*X(11)-JVS(312)*X(22)-JVS(313)*X(27)-JVS(314)*X(28)-JVS(315)*X(40)-JVS(316)*X(41)&
            &-JVS(317)*X(44)-JVS(318)*X(46)-JVS(319)*X(47)-JVS(320)*X(48)
  X(51) = X(51)-JVS(334)*X(28)-JVS(335)*X(29)-JVS(336)*X(35)-JVS(337)*X(39)-JVS(338)*X(42)-JVS(339)*X(43)-JVS(340)*X(44)&
            &-JVS(341)*X(45)-JVS(342)*X(46)-JVS(343)*X(47)-JVS(344)*X(48)
  X(52) = X(52)-JVS(354)*X(10)-JVS(355)*X(11)-JVS(356)*X(26)-JVS(357)*X(29)-JVS(358)*X(30)-JVS(359)*X(35)-JVS(360)*X(38)&
            &-JVS(361)*X(40)-JVS(362)*X(41)-JVS(363)*X(42)-JVS(364)*X(43)-JVS(365)*X(45)-JVS(366)*X(46)-JVS(367)*X(47)&
            &-JVS(368)*X(51)
  X(53) = X(53)-JVS(381)*X(38)-JVS(382)*X(39)-JVS(383)*X(40)-JVS(384)*X(41)-JVS(385)*X(42)-JVS(386)*X(43)-JVS(387)*X(45)&
            &-JVS(388)*X(46)-JVS(389)*X(47)
  X(54) = X(54)-JVS(399)*X(4)-JVS(400)*X(8)-JVS(401)*X(9)-JVS(402)*X(10)-JVS(403)*X(11)-JVS(404)*X(13)-JVS(405)*X(14)&
            &-JVS(406)*X(15)-JVS(407)*X(17)-JVS(408)*X(19)-JVS(409)*X(23)-JVS(410)*X(26)-JVS(411)*X(27)-JVS(412)*X(28)&
            &-JVS(413)*X(29)-JVS(414)*X(30)-JVS(415)*X(31)-JVS(416)*X(32)-JVS(417)*X(33)-JVS(418)*X(35)-JVS(419)*X(36)&
            &-JVS(420)*X(37)-JVS(421)*X(38)-JVS(422)*X(39)-JVS(423)*X(40)-JVS(424)*X(41)-JVS(425)*X(42)-JVS(426)*X(43)&
            &-JVS(427)*X(44)-JVS(428)*X(45)-JVS(429)*X(46)-JVS(430)*X(47)-JVS(431)*X(48)-JVS(432)*X(49)-JVS(433)*X(50)&
            &-JVS(434)*X(51)-JVS(435)*X(52)-JVS(436)*X(53)
  X(55) = X(55)-JVS(447)*X(22)-JVS(448)*X(42)-JVS(449)*X(46)-JVS(450)*X(47)-JVS(451)*X(49)-JVS(452)*X(51)-JVS(453)*X(53)&
            &-JVS(454)*X(54)
  X(56) = X(56)-JVS(464)*X(12)-JVS(465)*X(23)-JVS(466)*X(24)-JVS(467)*X(25)-JVS(468)*X(33)-JVS(469)*X(34)-JVS(470)*X(38)&
            &-JVS(471)*X(40)-JVS(472)*X(41)-JVS(473)*X(42)-JVS(474)*X(43)-JVS(475)*X(45)-JVS(476)*X(46)-JVS(477)*X(47)&
            &-JVS(478)*X(49)-JVS(479)*X(50)-JVS(480)*X(51)-JVS(481)*X(52)-JVS(482)*X(53)-JVS(483)*X(54)-JVS(484)*X(55)
  X(57) = X(57)-JVS(493)*X(5)-JVS(494)*X(20)-JVS(495)*X(21)-JVS(496)*X(30)-JVS(497)*X(49)-JVS(498)*X(50)-JVS(499)*X(51)&
            &-JVS(500)*X(52)-JVS(501)*X(53)-JVS(502)*X(54)-JVS(503)*X(55)-JVS(504)*X(56)
  X(58) = X(58)-JVS(512)*X(6)-JVS(513)*X(20)-JVS(514)*X(37)-JVS(515)*X(43)-JVS(516)*X(45)-JVS(517)*X(47)-JVS(518)*X(50)&
            &-JVS(519)*X(51)-JVS(520)*X(53)-JVS(521)*X(54)-JVS(522)*X(55)-JVS(523)*X(56)-JVS(524)*X(57)
  X(59) = X(59)-JVS(531)*X(8)-JVS(532)*X(9)-JVS(533)*X(11)-JVS(534)*X(15)-JVS(535)*X(27)-JVS(536)*X(28)-JVS(537)*X(30)&
            &-JVS(538)*X(31)-JVS(539)*X(37)-JVS(540)*X(38)-JVS(541)*X(40)-JVS(542)*X(41)-JVS(543)*X(42)-JVS(544)*X(43)&
            &-JVS(545)*X(44)-JVS(546)*X(45)-JVS(547)*X(46)-JVS(548)*X(47)-JVS(549)*X(48)-JVS(550)*X(51)-JVS(551)*X(52)&
            &-JVS(552)*X(53)-JVS(553)*X(54)-JVS(554)*X(55)-JVS(555)*X(56)-JVS(556)*X(57)-JVS(557)*X(58)
  X(60) = X(60)-JVS(563)*X(4)-JVS(564)*X(5)-JVS(565)*X(8)-JVS(566)*X(9)-JVS(567)*X(10)-JVS(568)*X(11)-JVS(569)*X(13)&
            &-JVS(570)*X(14)-JVS(571)*X(15)-JVS(572)*X(16)-JVS(573)*X(17)-JVS(574)*X(18)-JVS(575)*X(19)-JVS(576)*X(20)&
            &-JVS(577)*X(21)-JVS(578)*X(22)-JVS(579)*X(23)-JVS(580)*X(24)-JVS(581)*X(25)-JVS(582)*X(26)-JVS(583)*X(27)&
            &-JVS(584)*X(30)-JVS(585)*X(32)-JVS(586)*X(33)-JVS(587)*X(34)-JVS(588)*X(36)-JVS(589)*X(37)-JVS(590)*X(38)&
            &-JVS(591)*X(39)-JVS(592)*X(40)-JVS(593)*X(41)-JVS(594)*X(42)-JVS(595)*X(43)-JVS(596)*X(44)-JVS(597)*X(45)&
            &-JVS(598)*X(46)-JVS(599)*X(47)-JVS(600)*X(48)-JVS(601)*X(49)-JVS(602)*X(50)-JVS(603)*X(51)-JVS(604)*X(52)&
            &-JVS(605)*X(53)-JVS(606)*X(54)-JVS(607)*X(55)-JVS(608)*X(56)-JVS(609)*X(57)-JVS(610)*X(58)-JVS(611)*X(59)
  X(61) = X(61)-JVS(616)*X(6)-JVS(617)*X(7)-JVS(618)*X(12)-JVS(619)*X(16)-JVS(620)*X(22)-JVS(621)*X(23)-JVS(622)*X(26)&
            &-JVS(623)*X(28)-JVS(624)*X(29)-JVS(625)*X(31)-JVS(626)*X(32)-JVS(627)*X(33)-JVS(628)*X(34)-JVS(629)*X(35)&
            &-JVS(630)*X(38)-JVS(631)*X(39)-JVS(632)*X(40)-JVS(633)*X(41)-JVS(634)*X(42)-JVS(635)*X(43)-JVS(636)*X(44)&
            &-JVS(637)*X(45)-JVS(638)*X(46)-JVS(639)*X(47)-JVS(640)*X(49)-JVS(641)*X(50)-JVS(642)*X(51)-JVS(643)*X(52)&
            &-JVS(644)*X(53)-JVS(645)*X(54)-JVS(646)*X(55)-JVS(647)*X(56)-JVS(648)*X(57)-JVS(649)*X(58)-JVS(650)*X(59)&
            &-JVS(651)*X(60)
  X(62) = X(62)-JVS(655)*X(16)-JVS(656)*X(26)-JVS(657)*X(29)-JVS(658)*X(31)-JVS(659)*X(32)-JVS(660)*X(35)-JVS(661)*X(39)&
            &-JVS(662)*X(43)-JVS(663)*X(45)-JVS(664)*X(46)-JVS(665)*X(48)-JVS(666)*X(51)-JVS(667)*X(52)-JVS(668)*X(53)&
            &-JVS(669)*X(54)-JVS(670)*X(55)-JVS(671)*X(56)-JVS(672)*X(57)-JVS(673)*X(58)-JVS(674)*X(59)-JVS(675)*X(60)&
            &-JVS(676)*X(61)
  X(63) = X(63)-JVS(679)*X(14)-JVS(680)*X(17)-JVS(681)*X(38)-JVS(682)*X(40)-JVS(683)*X(41)-JVS(684)*X(42)-JVS(685)*X(46)&
            &-JVS(686)*X(49)-JVS(687)*X(50)-JVS(688)*X(51)-JVS(689)*X(52)-JVS(690)*X(53)-JVS(691)*X(54)-JVS(692)*X(55)&
            &-JVS(693)*X(56)-JVS(694)*X(57)-JVS(695)*X(58)-JVS(696)*X(59)-JVS(697)*X(60)-JVS(698)*X(61)-JVS(699)*X(62)
  X(63) = X(63)/JVS(700)
  X(62) = (X(62)-JVS(678)*X(63))/(JVS(677))
  X(61) = (X(61)-JVS(653)*X(62)-JVS(654)*X(63))/(JVS(652))
  X(60) = (X(60)-JVS(613)*X(61)-JVS(614)*X(62)-JVS(615)*X(63))/(JVS(612))
  X(59) = (X(59)-JVS(559)*X(60)-JVS(560)*X(61)-JVS(561)*X(62)-JVS(562)*X(63))/(JVS(558))
  X(58) = (X(58)-JVS(526)*X(59)-JVS(527)*X(60)-JVS(528)*X(61)-JVS(529)*X(62)-JVS(530)*X(63))/(JVS(525))
  X(57) = (X(57)-JVS(506)*X(58)-JVS(507)*X(59)-JVS(508)*X(60)-JVS(509)*X(61)-JVS(510)*X(62)-JVS(511)*X(63))/(JVS(505))
  X(56) = (X(56)-JVS(486)*X(57)-JVS(487)*X(58)-JVS(488)*X(59)-JVS(489)*X(60)-JVS(490)*X(61)-JVS(491)*X(62)-JVS(492)&
            &*X(63))/(JVS(485))
  X(55) = (X(55)-JVS(456)*X(56)-JVS(457)*X(57)-JVS(458)*X(58)-JVS(459)*X(59)-JVS(460)*X(60)-JVS(461)*X(61)-JVS(462)&
            &*X(62)-JVS(463)*X(63))/(JVS(455))
  X(54) = (X(54)-JVS(438)*X(55)-JVS(439)*X(56)-JVS(440)*X(57)-JVS(441)*X(58)-JVS(442)*X(59)-JVS(443)*X(60)-JVS(444)&
            &*X(61)-JVS(445)*X(62)-JVS(446)*X(63))/(JVS(437))
  X(53) = (X(53)-JVS(391)*X(54)-JVS(392)*X(55)-JVS(393)*X(56)-JVS(394)*X(58)-JVS(395)*X(60)-JVS(396)*X(61)-JVS(397)&
            &*X(62)-JVS(398)*X(63))/(JVS(390))
  X(52) = (X(52)-JVS(370)*X(53)-JVS(371)*X(54)-JVS(372)*X(55)-JVS(373)*X(56)-JVS(374)*X(57)-JVS(375)*X(58)-JVS(376)&
            &*X(59)-JVS(377)*X(60)-JVS(378)*X(61)-JVS(379)*X(62)-JVS(380)*X(63))/(JVS(369))
  X(51) = (X(51)-JVS(346)*X(53)-JVS(347)*X(54)-JVS(348)*X(56)-JVS(349)*X(59)-JVS(350)*X(60)-JVS(351)*X(61)-JVS(352)&
            &*X(62)-JVS(353)*X(63))/(JVS(345))
  X(50) = (X(50)-JVS(322)*X(51)-JVS(323)*X(53)-JVS(324)*X(54)-JVS(325)*X(55)-JVS(326)*X(56)-JVS(327)*X(57)-JVS(328)&
            &*X(58)-JVS(329)*X(59)-JVS(330)*X(60)-JVS(331)*X(61)-JVS(332)*X(62)-JVS(333)*X(63))/(JVS(321))
  X(49) = (X(49)-JVS(301)*X(51)-JVS(302)*X(53)-JVS(303)*X(54)-JVS(304)*X(56)-JVS(305)*X(59)-JVS(306)*X(60)-JVS(307)&
            &*X(61)-JVS(308)*X(62)-JVS(309)*X(63))/(JVS(300))
  X(48) = (X(48)-JVS(277)*X(51)-JVS(278)*X(53)-JVS(279)*X(54)-JVS(280)*X(56)-JVS(281)*X(59)-JVS(282)*X(60)-JVS(283)&
            &*X(61)-JVS(284)*X(62)-JVS(285)*X(63))/(JVS(276))
  X(47) = (X(47)-JVS(263)*X(53)-JVS(264)*X(56)-JVS(265)*X(60)-JVS(266)*X(61)-JVS(267)*X(63))/(JVS(262))
  X(46) = (X(46)-JVS(256)*X(53)-JVS(257)*X(56)-JVS(258)*X(60)-JVS(259)*X(61)-JVS(260)*X(63))/(JVS(255))
  X(45) = (X(45)-JVS(249)*X(53)-JVS(250)*X(54)-JVS(251)*X(56)-JVS(252)*X(60)-JVS(253)*X(61)-JVS(254)*X(62))/(JVS(248))
  X(44) = (X(44)-JVS(238)*X(46)-JVS(239)*X(47)-JVS(240)*X(51)-JVS(241)*X(53)-JVS(242)*X(56)-JVS(243)*X(60)-JVS(244)&
            &*X(61)-JVS(245)*X(63))/(JVS(237))
  X(43) = (X(43)-JVS(228)*X(54)-JVS(229)*X(56)-JVS(230)*X(60)-JVS(231)*X(61))/(JVS(227))
  X(42) = (X(42)-JVS(220)*X(53)-JVS(221)*X(56)-JVS(222)*X(60)-JVS(223)*X(63))/(JVS(219))
  X(41) = (X(41)-JVS(215)*X(53)-JVS(216)*X(56)-JVS(217)*X(60)-JVS(218)*X(63))/(JVS(214))
  X(40) = (X(40)-JVS(210)*X(53)-JVS(211)*X(56)-JVS(212)*X(60)-JVS(213)*X(63))/(JVS(209))
  X(39) = (X(39)-JVS(202)*X(43)-JVS(203)*X(53)-JVS(204)*X(54)-JVS(205)*X(56)-JVS(206)*X(60)-JVS(207)*X(61)-JVS(208)&
            &*X(62))/(JVS(201))
  X(38) = (X(38)-JVS(193)*X(53)-JVS(194)*X(56)-JVS(195)*X(60)-JVS(196)*X(63))/(JVS(192))
  X(37) = (X(37)-JVS(184)*X(43)-JVS(185)*X(45)-JVS(186)*X(47)-JVS(187)*X(53)-JVS(188)*X(54)-JVS(189)*X(56)-JVS(190)&
            &*X(60)-JVS(191)*X(62))/(JVS(183))
  X(36) = (X(36)-JVS(163)*X(37)-JVS(164)*X(38)-JVS(165)*X(40)-JVS(166)*X(41)-JVS(167)*X(42)-JVS(168)*X(43)-JVS(169)&
            &*X(45)-JVS(170)*X(46)-JVS(171)*X(47)-JVS(172)*X(49)-JVS(173)*X(50)-JVS(174)*X(52)-JVS(175)*X(53)-JVS(176)*X(54)&
            &-JVS(177)*X(56)-JVS(178)*X(60)-JVS(179)*X(62)-JVS(180)*X(63))/(JVS(162))
  X(35) = (X(35)-JVS(154)*X(43)-JVS(155)*X(45)-JVS(156)*X(54)-JVS(157)*X(56)-JVS(158)*X(60)-JVS(159)*X(62))/(JVS(153))
  X(34) = (X(34)-JVS(141)*X(43)-JVS(142)*X(45)-JVS(143)*X(47)-JVS(144)*X(49)-JVS(145)*X(50)-JVS(146)*X(51)-JVS(147)&
            &*X(52)-JVS(148)*X(54)-JVS(149)*X(56)-JVS(150)*X(60)-JVS(151)*X(61))/(JVS(140))
  X(33) = (X(33)-JVS(131)*X(43)-JVS(132)*X(54)-JVS(133)*X(56)-JVS(134)*X(60)-JVS(135)*X(61))/(JVS(130))
  X(32) = (X(32)-JVS(124)*X(39)-JVS(125)*X(53)-JVS(126)*X(54)-JVS(127)*X(60)-JVS(128)*X(62))/(JVS(123))
  X(31) = (X(31)-JVS(117)*X(45)-JVS(118)*X(56)-JVS(119)*X(60)-JVS(120)*X(61)-JVS(121)*X(62))/(JVS(116))
  X(30) = (X(30)-JVS(110)*X(52)-JVS(111)*X(54)-JVS(112)*X(57)-JVS(113)*X(60)-JVS(114)*X(62))/(JVS(109))
  X(29) = (X(29)-JVS(105)*X(54)-JVS(106)*X(60)-JVS(107)*X(62))/(JVS(104))
  X(28) = (X(28)-JVS(99)*X(44)-JVS(100)*X(60)-JVS(101)*X(61))/(JVS(98))
  X(27) = (X(27)-JVS(94)*X(48)-JVS(95)*X(54)-JVS(96)*X(59)-JVS(97)*X(60))/(JVS(93))
  X(26) = (X(26)-JVS(90)*X(52)-JVS(91)*X(54)-JVS(92)*X(62))/(JVS(89))
  X(25) = (X(25)-JVS(85)*X(33)-JVS(86)*X(56)-JVS(87)*X(60)-JVS(88)*X(61))/(JVS(84))
  X(24) = (X(24)-JVS(81)*X(43)-JVS(82)*X(56)-JVS(83)*X(60))/(JVS(80))
  X(23) = (X(23)-JVS(77)*X(54)-JVS(78)*X(60)-JVS(79)*X(61))/(JVS(76))
  X(22) = (X(22)-JVS(73)*X(55)-JVS(74)*X(60)-JVS(75)*X(61))/(JVS(72))
  X(21) = (X(21)-JVS(66)*X(54)-JVS(67)*X(55)-JVS(68)*X(57)-JVS(69)*X(58)-JVS(70)*X(59)-JVS(71)*X(60))/(JVS(65))
  X(20) = (X(20)-JVS(61)*X(54)-JVS(62)*X(55)-JVS(63)*X(58)-JVS(64)*X(60))/(JVS(60))
  X(19) = (X(19)-JVS(55)*X(26)-JVS(56)*X(38)-JVS(57)*X(53)-JVS(58)*X(60)-JVS(59)*X(62))/(JVS(54))
  X(18) = (X(18)-JVS(51)*X(32)-JVS(52)*X(54)-JVS(53)*X(60))/(JVS(50))
  X(17) = (X(17)-JVS(47)*X(54)-JVS(48)*X(60)-JVS(49)*X(63))/(JVS(46))
  X(16) = (X(16)-JVS(43)*X(60)-JVS(44)*X(61)-JVS(45)*X(62))/(JVS(42))
  X(15) = (X(15)-JVS(41)*X(60))/(JVS(40))
  X(14) = (X(14)-JVS(38)*X(53)-JVS(39)*X(60))/(JVS(37))
  X(13) = (X(13)-JVS(34)*X(14)-JVS(35)*X(60))/(JVS(33))
  X(12) = (X(12)-JVS(31)*X(56)-JVS(32)*X(61))/(JVS(30))
  X(11) = (X(11)-JVS(29)*X(60))/(JVS(28))
  X(10) = (X(10)-JVS(26)*X(57)-JVS(27)*X(60))/(JVS(25))
  X(9) = (X(9)-JVS(24)*X(60))/(JVS(23))
  X(8) = (X(8)-JVS(22)*X(60))/(JVS(21))
  X(7) = (X(7)-JVS(19)*X(31)-JVS(20)*X(61))/(JVS(18))
  X(6) = (X(6)-JVS(16)*X(58)-JVS(17)*X(61))/(JVS(15))
  X(5) = (X(5)-JVS(14)*X(60))/(JVS(13))
  X(4) = (X(4)-JVS(12)*X(60))/(JVS(11))
  X(3) = (X(3)-JVS(8)*X(29)-JVS(9)*X(35)-JVS(10)*X(54))/(JVS(7))
  X(2) = (X(2)-JVS(5)*X(4)-JVS(6)*X(60))/(JVS(4))
  X(1) = (X(1)-JVS(2)*X(4)-JVS(3)*X(60))/(JVS(1))
      
END SUBROUTINE KppSolve

! End of KppSolve function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolveTR - sparse, transposed back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
!      XX        - Vector for output variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolveTR ( JVS, X, XX )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)
! XX - Vector for output variables
  REAL(kind=dp) :: XX(NVAR)

  XX(1) = X(1)/JVS(1)
  XX(2) = X(2)/JVS(4)
  XX(3) = X(3)/JVS(7)
  XX(4) = (X(4)-JVS(2)*XX(1)-JVS(5)*XX(2))/(JVS(11))
  XX(5) = X(5)/JVS(13)
  XX(6) = X(6)/JVS(15)
  XX(7) = X(7)/JVS(18)
  XX(8) = X(8)/JVS(21)
  XX(9) = X(9)/JVS(23)
  XX(10) = X(10)/JVS(25)
  XX(11) = X(11)/JVS(28)
  XX(12) = X(12)/JVS(30)
  XX(13) = X(13)/JVS(33)
  XX(14) = (X(14)-JVS(34)*XX(13))/(JVS(37))
  XX(15) = X(15)/JVS(40)
  XX(16) = X(16)/JVS(42)
  XX(17) = X(17)/JVS(46)
  XX(18) = X(18)/JVS(50)
  XX(19) = X(19)/JVS(54)
  XX(20) = X(20)/JVS(60)
  XX(21) = X(21)/JVS(65)
  XX(22) = X(22)/JVS(72)
  XX(23) = X(23)/JVS(76)
  XX(24) = X(24)/JVS(80)
  XX(25) = X(25)/JVS(84)
  XX(26) = (X(26)-JVS(55)*XX(19))/(JVS(89))
  XX(27) = X(27)/JVS(93)
  XX(28) = X(28)/JVS(98)
  XX(29) = (X(29)-JVS(8)*XX(3))/(JVS(104))
  XX(30) = X(30)/JVS(109)
  XX(31) = (X(31)-JVS(19)*XX(7))/(JVS(116))
  XX(32) = (X(32)-JVS(51)*XX(18))/(JVS(123))
  XX(33) = (X(33)-JVS(85)*XX(25))/(JVS(130))
  XX(34) = X(34)/JVS(140)
  XX(35) = (X(35)-JVS(9)*XX(3))/(JVS(153))
  XX(36) = X(36)/JVS(162)
  XX(37) = (X(37)-JVS(163)*XX(36))/(JVS(183))
  XX(38) = (X(38)-JVS(56)*XX(19)-JVS(164)*XX(36))/(JVS(192))
  XX(39) = (X(39)-JVS(124)*XX(32))/(JVS(201))
  XX(40) = (X(40)-JVS(165)*XX(36))/(JVS(209))
  XX(41) = (X(41)-JVS(166)*XX(36))/(JVS(214))
  XX(42) = (X(42)-JVS(167)*XX(36))/(JVS(219))
  XX(43) = (X(43)-JVS(81)*XX(24)-JVS(131)*XX(33)-JVS(141)*XX(34)-JVS(154)*XX(35)-JVS(168)*XX(36)-JVS(184)*XX(37)&
             &-JVS(202)*XX(39))/(JVS(227))
  XX(44) = (X(44)-JVS(99)*XX(28))/(JVS(237))
  XX(45) = (X(45)-JVS(117)*XX(31)-JVS(142)*XX(34)-JVS(155)*XX(35)-JVS(169)*XX(36)-JVS(185)*XX(37))/(JVS(248))
  XX(46) = (X(46)-JVS(170)*XX(36)-JVS(238)*XX(44))/(JVS(255))
  XX(47) = (X(47)-JVS(143)*XX(34)-JVS(171)*XX(36)-JVS(186)*XX(37)-JVS(239)*XX(44))/(JVS(262))
  XX(48) = (X(48)-JVS(94)*XX(27))/(JVS(276))
  XX(49) = (X(49)-JVS(144)*XX(34)-JVS(172)*XX(36))/(JVS(300))
  XX(50) = (X(50)-JVS(145)*XX(34)-JVS(173)*XX(36))/(JVS(321))
  XX(51) = (X(51)-JVS(146)*XX(34)-JVS(240)*XX(44)-JVS(277)*XX(48)-JVS(301)*XX(49)-JVS(322)*XX(50))/(JVS(345))
  XX(52) = (X(52)-JVS(90)*XX(26)-JVS(110)*XX(30)-JVS(147)*XX(34)-JVS(174)*XX(36))/(JVS(369))
  XX(53) = (X(53)-JVS(38)*XX(14)-JVS(57)*XX(19)-JVS(125)*XX(32)-JVS(175)*XX(36)-JVS(187)*XX(37)-JVS(193)*XX(38)-JVS(203)&
             &*XX(39)-JVS(210)*XX(40)-JVS(215)*XX(41)-JVS(220)*XX(42)-JVS(241)*XX(44)-JVS(249)*XX(45)-JVS(256)*XX(46)&
             &-JVS(263)*XX(47)-JVS(278)*XX(48)-JVS(302)*XX(49)-JVS(323)*XX(50)-JVS(346)*XX(51)-JVS(370)*XX(52))/(JVS(390))
  XX(54) = (X(54)-JVS(10)*XX(3)-JVS(47)*XX(17)-JVS(52)*XX(18)-JVS(61)*XX(20)-JVS(66)*XX(21)-JVS(77)*XX(23)-JVS(91)&
             &*XX(26)-JVS(95)*XX(27)-JVS(105)*XX(29)-JVS(111)*XX(30)-JVS(126)*XX(32)-JVS(132)*XX(33)-JVS(148)*XX(34)&
             &-JVS(156)*XX(35)-JVS(176)*XX(36)-JVS(188)*XX(37)-JVS(204)*XX(39)-JVS(228)*XX(43)-JVS(250)*XX(45)-JVS(279)&
             &*XX(48)-JVS(303)*XX(49)-JVS(324)*XX(50)-JVS(347)*XX(51)-JVS(371)*XX(52)-JVS(391)*XX(53))/(JVS(437))
  XX(55) = (X(55)-JVS(62)*XX(20)-JVS(67)*XX(21)-JVS(73)*XX(22)-JVS(325)*XX(50)-JVS(372)*XX(52)-JVS(392)*XX(53)-JVS(438)&
             &*XX(54))/(JVS(455))
  XX(56) = (X(56)-JVS(31)*XX(12)-JVS(82)*XX(24)-JVS(86)*XX(25)-JVS(118)*XX(31)-JVS(133)*XX(33)-JVS(149)*XX(34)-JVS(157)&
             &*XX(35)-JVS(177)*XX(36)-JVS(189)*XX(37)-JVS(194)*XX(38)-JVS(205)*XX(39)-JVS(211)*XX(40)-JVS(216)*XX(41)&
             &-JVS(221)*XX(42)-JVS(229)*XX(43)-JVS(242)*XX(44)-JVS(251)*XX(45)-JVS(257)*XX(46)-JVS(264)*XX(47)-JVS(280)&
             &*XX(48)-JVS(304)*XX(49)-JVS(326)*XX(50)-JVS(348)*XX(51)-JVS(373)*XX(52)-JVS(393)*XX(53)-JVS(439)*XX(54)&
             &-JVS(456)*XX(55))/(JVS(485))
  XX(57) = (X(57)-JVS(26)*XX(10)-JVS(68)*XX(21)-JVS(112)*XX(30)-JVS(327)*XX(50)-JVS(374)*XX(52)-JVS(440)*XX(54)-JVS(457)&
             &*XX(55)-JVS(486)*XX(56))/(JVS(505))
  XX(58) = (X(58)-JVS(16)*XX(6)-JVS(63)*XX(20)-JVS(69)*XX(21)-JVS(328)*XX(50)-JVS(375)*XX(52)-JVS(394)*XX(53)-JVS(441)&
             &*XX(54)-JVS(458)*XX(55)-JVS(487)*XX(56)-JVS(506)*XX(57))/(JVS(525))
  XX(59) = (X(59)-JVS(70)*XX(21)-JVS(96)*XX(27)-JVS(281)*XX(48)-JVS(305)*XX(49)-JVS(329)*XX(50)-JVS(349)*XX(51)-JVS(376)&
             &*XX(52)-JVS(442)*XX(54)-JVS(459)*XX(55)-JVS(488)*XX(56)-JVS(507)*XX(57)-JVS(526)*XX(58))/(JVS(558))
  XX(60) = (X(60)-JVS(3)*XX(1)-JVS(6)*XX(2)-JVS(12)*XX(4)-JVS(14)*XX(5)-JVS(22)*XX(8)-JVS(24)*XX(9)-JVS(27)*XX(10)&
             &-JVS(29)*XX(11)-JVS(35)*XX(13)-JVS(39)*XX(14)-JVS(41)*XX(15)-JVS(43)*XX(16)-JVS(48)*XX(17)-JVS(53)*XX(18)&
             &-JVS(58)*XX(19)-JVS(64)*XX(20)-JVS(71)*XX(21)-JVS(74)*XX(22)-JVS(78)*XX(23)-JVS(83)*XX(24)-JVS(87)*XX(25)&
             &-JVS(97)*XX(27)-JVS(100)*XX(28)-JVS(106)*XX(29)-JVS(113)*XX(30)-JVS(119)*XX(31)-JVS(127)*XX(32)-JVS(134)&
             &*XX(33)-JVS(150)*XX(34)-JVS(158)*XX(35)-JVS(178)*XX(36)-JVS(190)*XX(37)-JVS(195)*XX(38)-JVS(206)*XX(39)&
             &-JVS(212)*XX(40)-JVS(217)*XX(41)-JVS(222)*XX(42)-JVS(230)*XX(43)-JVS(243)*XX(44)-JVS(252)*XX(45)-JVS(258)&
             &*XX(46)-JVS(265)*XX(47)-JVS(282)*XX(48)-JVS(306)*XX(49)-JVS(330)*XX(50)-JVS(350)*XX(51)-JVS(377)*XX(52)&
             &-JVS(395)*XX(53)-JVS(443)*XX(54)-JVS(460)*XX(55)-JVS(489)*XX(56)-JVS(508)*XX(57)-JVS(527)*XX(58)-JVS(559)&
             &*XX(59))/(JVS(612))
  XX(61) = (X(61)-JVS(17)*XX(6)-JVS(20)*XX(7)-JVS(32)*XX(12)-JVS(44)*XX(16)-JVS(75)*XX(22)-JVS(79)*XX(23)-JVS(88)*XX(25)&
             &-JVS(101)*XX(28)-JVS(120)*XX(31)-JVS(135)*XX(33)-JVS(151)*XX(34)-JVS(207)*XX(39)-JVS(231)*XX(43)-JVS(244)&
             &*XX(44)-JVS(253)*XX(45)-JVS(259)*XX(46)-JVS(266)*XX(47)-JVS(283)*XX(48)-JVS(307)*XX(49)-JVS(331)*XX(50)&
             &-JVS(351)*XX(51)-JVS(378)*XX(52)-JVS(396)*XX(53)-JVS(444)*XX(54)-JVS(461)*XX(55)-JVS(490)*XX(56)-JVS(509)&
             &*XX(57)-JVS(528)*XX(58)-JVS(560)*XX(59)-JVS(613)*XX(60))/(JVS(652))
  XX(62) = (X(62)-JVS(45)*XX(16)-JVS(59)*XX(19)-JVS(92)*XX(26)-JVS(107)*XX(29)-JVS(114)*XX(30)-JVS(121)*XX(31)-JVS(128)&
             &*XX(32)-JVS(159)*XX(35)-JVS(179)*XX(36)-JVS(191)*XX(37)-JVS(208)*XX(39)-JVS(254)*XX(45)-JVS(284)*XX(48)&
             &-JVS(308)*XX(49)-JVS(332)*XX(50)-JVS(352)*XX(51)-JVS(379)*XX(52)-JVS(397)*XX(53)-JVS(445)*XX(54)-JVS(462)&
             &*XX(55)-JVS(491)*XX(56)-JVS(510)*XX(57)-JVS(529)*XX(58)-JVS(561)*XX(59)-JVS(614)*XX(60)-JVS(653)*XX(61))&
             &/(JVS(677))
  XX(63) = (X(63)-JVS(49)*XX(17)-JVS(180)*XX(36)-JVS(196)*XX(38)-JVS(213)*XX(40)-JVS(218)*XX(41)-JVS(223)*XX(42)&
             &-JVS(245)*XX(44)-JVS(260)*XX(46)-JVS(267)*XX(47)-JVS(285)*XX(48)-JVS(309)*XX(49)-JVS(333)*XX(50)-JVS(353)&
             &*XX(51)-JVS(380)*XX(52)-JVS(398)*XX(53)-JVS(446)*XX(54)-JVS(463)*XX(55)-JVS(492)*XX(56)-JVS(511)*XX(57)&
             &-JVS(530)*XX(58)-JVS(562)*XX(59)-JVS(615)*XX(60)-JVS(654)*XX(61)-JVS(678)*XX(62))/(JVS(700))
  XX(63) = XX(63)
  XX(62) = XX(62)-JVS(699)*XX(63)
  XX(61) = XX(61)-JVS(676)*XX(62)-JVS(698)*XX(63)
  XX(60) = XX(60)-JVS(651)*XX(61)-JVS(675)*XX(62)-JVS(697)*XX(63)
  XX(59) = XX(59)-JVS(611)*XX(60)-JVS(650)*XX(61)-JVS(674)*XX(62)-JVS(696)*XX(63)
  XX(58) = XX(58)-JVS(557)*XX(59)-JVS(610)*XX(60)-JVS(649)*XX(61)-JVS(673)*XX(62)-JVS(695)*XX(63)
  XX(57) = XX(57)-JVS(524)*XX(58)-JVS(556)*XX(59)-JVS(609)*XX(60)-JVS(648)*XX(61)-JVS(672)*XX(62)-JVS(694)*XX(63)
  XX(56) = XX(56)-JVS(504)*XX(57)-JVS(523)*XX(58)-JVS(555)*XX(59)-JVS(608)*XX(60)-JVS(647)*XX(61)-JVS(671)*XX(62)&
             &-JVS(693)*XX(63)
  XX(55) = XX(55)-JVS(484)*XX(56)-JVS(503)*XX(57)-JVS(522)*XX(58)-JVS(554)*XX(59)-JVS(607)*XX(60)-JVS(646)*XX(61)&
             &-JVS(670)*XX(62)-JVS(692)*XX(63)
  XX(54) = XX(54)-JVS(454)*XX(55)-JVS(483)*XX(56)-JVS(502)*XX(57)-JVS(521)*XX(58)-JVS(553)*XX(59)-JVS(606)*XX(60)&
             &-JVS(645)*XX(61)-JVS(669)*XX(62)-JVS(691)*XX(63)
  XX(53) = XX(53)-JVS(436)*XX(54)-JVS(453)*XX(55)-JVS(482)*XX(56)-JVS(501)*XX(57)-JVS(520)*XX(58)-JVS(552)*XX(59)&
             &-JVS(605)*XX(60)-JVS(644)*XX(61)-JVS(668)*XX(62)-JVS(690)*XX(63)
  XX(52) = XX(52)-JVS(435)*XX(54)-JVS(481)*XX(56)-JVS(500)*XX(57)-JVS(551)*XX(59)-JVS(604)*XX(60)-JVS(643)*XX(61)&
             &-JVS(667)*XX(62)-JVS(689)*XX(63)
  XX(51) = XX(51)-JVS(368)*XX(52)-JVS(434)*XX(54)-JVS(452)*XX(55)-JVS(480)*XX(56)-JVS(499)*XX(57)-JVS(519)*XX(58)&
             &-JVS(550)*XX(59)-JVS(603)*XX(60)-JVS(642)*XX(61)-JVS(666)*XX(62)-JVS(688)*XX(63)
  XX(50) = XX(50)-JVS(433)*XX(54)-JVS(479)*XX(56)-JVS(498)*XX(57)-JVS(518)*XX(58)-JVS(602)*XX(60)-JVS(641)*XX(61)&
             &-JVS(687)*XX(63)
  XX(49) = XX(49)-JVS(432)*XX(54)-JVS(451)*XX(55)-JVS(478)*XX(56)-JVS(497)*XX(57)-JVS(601)*XX(60)-JVS(640)*XX(61)&
             &-JVS(686)*XX(63)
  XX(48) = XX(48)-JVS(299)*XX(49)-JVS(320)*XX(50)-JVS(344)*XX(51)-JVS(431)*XX(54)-JVS(549)*XX(59)-JVS(600)*XX(60)&
             &-JVS(665)*XX(62)
  XX(47) = XX(47)-JVS(275)*XX(48)-JVS(298)*XX(49)-JVS(319)*XX(50)-JVS(343)*XX(51)-JVS(367)*XX(52)-JVS(389)*XX(53)&
             &-JVS(430)*XX(54)-JVS(450)*XX(55)-JVS(477)*XX(56)-JVS(517)*XX(58)-JVS(548)*XX(59)-JVS(599)*XX(60)-JVS(639)&
             &*XX(61)
  XX(46) = XX(46)-JVS(261)*XX(47)-JVS(274)*XX(48)-JVS(297)*XX(49)-JVS(318)*XX(50)-JVS(342)*XX(51)-JVS(366)*XX(52)&
             &-JVS(388)*XX(53)-JVS(429)*XX(54)-JVS(449)*XX(55)-JVS(476)*XX(56)-JVS(547)*XX(59)-JVS(598)*XX(60)-JVS(638)&
             &*XX(61)-JVS(664)*XX(62)-JVS(685)*XX(63)
  XX(45) = XX(45)-JVS(296)*XX(49)-JVS(341)*XX(51)-JVS(365)*XX(52)-JVS(387)*XX(53)-JVS(428)*XX(54)-JVS(475)*XX(56)&
             &-JVS(516)*XX(58)-JVS(546)*XX(59)-JVS(597)*XX(60)-JVS(637)*XX(61)-JVS(663)*XX(62)
  XX(44) = XX(44)-JVS(273)*XX(48)-JVS(295)*XX(49)-JVS(317)*XX(50)-JVS(340)*XX(51)-JVS(427)*XX(54)-JVS(545)*XX(59)&
             &-JVS(596)*XX(60)-JVS(636)*XX(61)
  XX(43) = XX(43)-JVS(247)*XX(45)-JVS(272)*XX(48)-JVS(294)*XX(49)-JVS(339)*XX(51)-JVS(364)*XX(52)-JVS(386)*XX(53)&
             &-JVS(426)*XX(54)-JVS(474)*XX(56)-JVS(515)*XX(58)-JVS(544)*XX(59)-JVS(595)*XX(60)-JVS(635)*XX(61)-JVS(662)&
             &*XX(62)
  XX(42) = XX(42)-JVS(236)*XX(44)-JVS(271)*XX(48)-JVS(293)*XX(49)-JVS(338)*XX(51)-JVS(363)*XX(52)-JVS(385)*XX(53)&
             &-JVS(425)*XX(54)-JVS(448)*XX(55)-JVS(473)*XX(56)-JVS(543)*XX(59)-JVS(594)*XX(60)-JVS(634)*XX(61)-JVS(684)&
             &*XX(63)
  XX(41) = XX(41)-JVS(235)*XX(44)-JVS(270)*XX(48)-JVS(292)*XX(49)-JVS(316)*XX(50)-JVS(362)*XX(52)-JVS(384)*XX(53)&
             &-JVS(424)*XX(54)-JVS(472)*XX(56)-JVS(542)*XX(59)-JVS(593)*XX(60)-JVS(633)*XX(61)-JVS(683)*XX(63)
  XX(40) = XX(40)-JVS(234)*XX(44)-JVS(291)*XX(49)-JVS(315)*XX(50)-JVS(361)*XX(52)-JVS(383)*XX(53)-JVS(423)*XX(54)&
             &-JVS(471)*XX(56)-JVS(541)*XX(59)-JVS(592)*XX(60)-JVS(632)*XX(61)-JVS(682)*XX(63)
  XX(39) = XX(39)-JVS(337)*XX(51)-JVS(382)*XX(53)-JVS(422)*XX(54)-JVS(591)*XX(60)-JVS(631)*XX(61)-JVS(661)*XX(62)
  XX(38) = XX(38)-JVS(290)*XX(49)-JVS(360)*XX(52)-JVS(381)*XX(53)-JVS(421)*XX(54)-JVS(470)*XX(56)-JVS(540)*XX(59)&
             &-JVS(590)*XX(60)-JVS(630)*XX(61)-JVS(681)*XX(63)
  XX(37) = XX(37)-JVS(420)*XX(54)-JVS(514)*XX(58)-JVS(539)*XX(59)-JVS(589)*XX(60)
  XX(36) = XX(36)-JVS(419)*XX(54)-JVS(588)*XX(60)
  XX(35) = XX(35)-JVS(161)*XX(36)-JVS(336)*XX(51)-JVS(359)*XX(52)-JVS(418)*XX(54)-JVS(629)*XX(61)-JVS(660)*XX(62)
  XX(34) = XX(34)-JVS(469)*XX(56)-JVS(587)*XX(60)-JVS(628)*XX(61)
  XX(33) = XX(33)-JVS(139)*XX(34)-JVS(200)*XX(39)-JVS(226)*XX(43)-JVS(417)*XX(54)-JVS(468)*XX(56)-JVS(586)*XX(60)&
             &-JVS(627)*XX(61)
  XX(32) = XX(32)-JVS(199)*XX(39)-JVS(416)*XX(54)-JVS(585)*XX(60)-JVS(626)*XX(61)-JVS(659)*XX(62)
  XX(31) = XX(31)-JVS(289)*XX(49)-JVS(415)*XX(54)-JVS(538)*XX(59)-JVS(625)*XX(61)-JVS(658)*XX(62)
  XX(30) = XX(30)-JVS(358)*XX(52)-JVS(414)*XX(54)-JVS(496)*XX(57)-JVS(537)*XX(59)-JVS(584)*XX(60)
  XX(29) = XX(29)-JVS(160)*XX(36)-JVS(182)*XX(37)-JVS(246)*XX(45)-JVS(335)*XX(51)-JVS(357)*XX(52)-JVS(413)*XX(54)&
             &-JVS(624)*XX(61)-JVS(657)*XX(62)
  XX(28) = XX(28)-JVS(233)*XX(44)-JVS(269)*XX(48)-JVS(288)*XX(49)-JVS(314)*XX(50)-JVS(334)*XX(51)-JVS(412)*XX(54)&
             &-JVS(536)*XX(59)-JVS(623)*XX(61)
  XX(27) = XX(27)-JVS(287)*XX(49)-JVS(313)*XX(50)-JVS(411)*XX(54)-JVS(535)*XX(59)-JVS(583)*XX(60)
  XX(26) = XX(26)-JVS(108)*XX(30)-JVS(356)*XX(52)-JVS(410)*XX(54)-JVS(582)*XX(60)-JVS(622)*XX(61)-JVS(656)*XX(62)
  XX(25) = XX(25)-JVS(138)*XX(34)-JVS(198)*XX(39)-JVS(467)*XX(56)-JVS(581)*XX(60)
  XX(24) = XX(24)-JVS(129)*XX(33)-JVS(137)*XX(34)-JVS(152)*XX(35)-JVS(466)*XX(56)-JVS(580)*XX(60)
  XX(23) = XX(23)-JVS(409)*XX(54)-JVS(465)*XX(56)-JVS(579)*XX(60)-JVS(621)*XX(61)
  XX(22) = XX(22)-JVS(312)*XX(50)-JVS(447)*XX(55)-JVS(578)*XX(60)-JVS(620)*XX(61)
  XX(21) = XX(21)-JVS(495)*XX(57)-JVS(577)*XX(60)
  XX(20) = XX(20)-JVS(494)*XX(57)-JVS(513)*XX(58)-JVS(576)*XX(60)
  XX(19) = XX(19)-JVS(408)*XX(54)-JVS(575)*XX(60)
  XX(18) = XX(18)-JVS(122)*XX(32)-JVS(197)*XX(39)-JVS(574)*XX(60)
  XX(17) = XX(17)-JVS(407)*XX(54)-JVS(573)*XX(60)-JVS(680)*XX(63)
  XX(16) = XX(16)-JVS(572)*XX(60)-JVS(619)*XX(61)-JVS(655)*XX(62)
  XX(15) = XX(15)-JVS(103)*XX(29)-JVS(181)*XX(37)-JVS(225)*XX(43)-JVS(232)*XX(44)-JVS(406)*XX(54)-JVS(534)*XX(59)&
             &-JVS(571)*XX(60)
  XX(14) = XX(14)-JVS(405)*XX(54)-JVS(570)*XX(60)-JVS(679)*XX(63)
  XX(13) = XX(13)-JVS(36)*XX(14)-JVS(404)*XX(54)-JVS(569)*XX(60)
  XX(12) = XX(12)-JVS(136)*XX(34)-JVS(464)*XX(56)-JVS(618)*XX(61)
  XX(11) = XX(11)-JVS(286)*XX(49)-JVS(311)*XX(50)-JVS(355)*XX(52)-JVS(403)*XX(54)-JVS(533)*XX(59)-JVS(568)*XX(60)
  XX(10) = XX(10)-JVS(354)*XX(52)-JVS(402)*XX(54)-JVS(567)*XX(60)
  XX(9) = XX(9)-JVS(268)*XX(48)-JVS(310)*XX(50)-JVS(401)*XX(54)-JVS(532)*XX(59)-JVS(566)*XX(60)
  XX(8) = XX(8)-JVS(102)*XX(29)-JVS(224)*XX(43)-JVS(400)*XX(54)-JVS(531)*XX(59)-JVS(565)*XX(60)
  XX(7) = XX(7)-JVS(115)*XX(31)-JVS(617)*XX(61)
  XX(6) = XX(6)-JVS(512)*XX(58)-JVS(616)*XX(61)
  XX(5) = XX(5)-JVS(493)*XX(57)-JVS(564)*XX(60)
  XX(4) = XX(4)-JVS(399)*XX(54)-JVS(563)*XX(60)
  XX(3) = XX(3)
  XX(2) = XX(2)
  XX(1) = XX(1)
      
END SUBROUTINE KppSolveTR

! End of KppSolveTR function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! BLAS_UTIL - BLAS-LIKE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!--------------------------------------------------------------
!
! BLAS/LAPACK-like subroutines used by the integration algorithms
! It is recommended to replace them by calls to the optimized
!      BLAS/LAPACK library for your machine
!
!  (C) Adrian Sandu, Aug. 2004
!      Virginia Polytechnic Institute and State University
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE WCOPY(N,X,incX,Y,incY)
!--------------------------------------------------------------
!     copies a vector, x, to a vector, y:  y <- x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL  SCOPY(N,X,1,Y,1)   or   CALL  DCOPY(N,X,1,Y,1)
!--------------------------------------------------------------
!     USE CB05_CSIRO_Precision
      
      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N)

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = X(i)
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i) = X(i)
        Y(i + 1) = X(i + 1)
        Y(i + 2) = X(i + 2)
        Y(i + 3) = X(i + 3)
        Y(i + 4) = X(i + 4)
        Y(i + 5) = X(i + 5)
        Y(i + 6) = X(i + 6)
        Y(i + 7) = X(i + 7)
      END DO

      END SUBROUTINE WCOPY


!--------------------------------------------------------------
      SUBROUTINE WAXPY(N,Alpha,X,incX,Y,incY)
!--------------------------------------------------------------
!     constant times a vector plus a vector: y <- y + Alpha*x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SAXPY(N,Alpha,X,1,Y,1) or  CALL DAXPY(N,Alpha,X,1,Y,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N),Alpha
      REAL(kind=dp), PARAMETER :: ZERO = 0.0_dp

      IF (Alpha .EQ. ZERO) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,4)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = Y(i) + Alpha*X(i)
        END DO
        IF( N .LT. 4 ) RETURN
      END IF
      MP1 = M + 1
      DO i = MP1,N,4
        Y(i) = Y(i) + Alpha*X(i)
        Y(i + 1) = Y(i + 1) + Alpha*X(i + 1)
        Y(i + 2) = Y(i + 2) + Alpha*X(i + 2)
        Y(i + 3) = Y(i + 3) + Alpha*X(i + 3)
      END DO
      
      END SUBROUTINE WAXPY



!--------------------------------------------------------------
      SUBROUTINE WSCAL(N,Alpha,X,incX)
!--------------------------------------------------------------
!     constant times a vector: x(1:N) <- Alpha*x(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SSCAL(N,Alpha,X,1) or  CALL DSCAL(N,Alpha,X,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,M,MP1,N
      REAL(kind=dp)  :: X(N),Alpha
      REAL(kind=dp), PARAMETER  :: ZERO=0.0_dp, ONE=1.0_dp

      IF (Alpha .EQ. ONE) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,5)
      IF( M .NE. 0 ) THEN
        IF (Alpha .EQ. (-ONE)) THEN
          DO i = 1,M
            X(i) = -X(i)
          END DO
        ELSEIF (Alpha .EQ. ZERO) THEN
          DO i = 1,M
            X(i) = ZERO
          END DO
        ELSE
          DO i = 1,M
            X(i) = Alpha*X(i)
          END DO
        END IF
        IF( N .LT. 5 ) RETURN
      END IF
      MP1 = M + 1
      IF (Alpha .EQ. (-ONE)) THEN
        DO i = MP1,N,5
          X(i)     = -X(i)
          X(i + 1) = -X(i + 1)
          X(i + 2) = -X(i + 2)
          X(i + 3) = -X(i + 3)
          X(i + 4) = -X(i + 4)
        END DO
      ELSEIF (Alpha .EQ. ZERO) THEN
        DO i = MP1,N,5
          X(i)     = ZERO
          X(i + 1) = ZERO
          X(i + 2) = ZERO
          X(i + 3) = ZERO
          X(i + 4) = ZERO
        END DO
      ELSE
        DO i = MP1,N,5
          X(i)     = Alpha*X(i)
          X(i + 1) = Alpha*X(i + 1)
          X(i + 2) = Alpha*X(i + 2)
          X(i + 3) = Alpha*X(i + 3)
          X(i + 4) = Alpha*X(i + 4)
        END DO
      END IF

      END SUBROUTINE WSCAL

!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WLAMCH( C )
!--------------------------------------------------------------
!     returns epsilon machine
!     after LAPACK
!     replace this by the function from the optimized LAPACK implementation:
!          CALL SLAMCH('E') or CALL DLAMCH('E')
!--------------------------------------------------------------
!      USE CB05_CSIRO_Precision

      CHARACTER ::  C
      INTEGER    :: i
      REAL(kind=dp), SAVE  ::  Eps
      REAL(kind=dp)  ::  Suma
      REAL(kind=dp), PARAMETER  ::  ONE=1.0_dp, HALF=0.5_dp
      LOGICAL, SAVE   ::  First=.TRUE.
      
      IF (First) THEN
        First = .FALSE.
        Eps = HALF**(16)
        DO i = 17, 80
          Eps = Eps*HALF
          CALL WLAMCH_ADD(ONE,Eps,Suma)
          IF (Suma.LE.ONE) GOTO 10
        END DO
        PRINT*,'ERROR IN WLAMCH. EPS < ',Eps
        RETURN
10      Eps = Eps*2
        i = i-1      
      END IF

      WLAMCH = Eps

      END FUNCTION WLAMCH
     
      SUBROUTINE WLAMCH_ADD( A, B, Suma )
!      USE CB05_CSIRO_Precision
      
      REAL(kind=dp) A, B, Suma
      Suma = A + B

      END SUBROUTINE WLAMCH_ADD
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE SET2ZERO(N,Y)
!--------------------------------------------------------------
!     copies zeros into the vector y:  y <- 0
!     after BLAS
!--------------------------------------------------------------
      
      INTEGER ::  i,M,MP1,N
      REAL(kind=dp) ::  Y(N)
      REAL(kind=dp), PARAMETER :: ZERO = 0.0d0

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = ZERO
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i)     = ZERO
        Y(i + 1) = ZERO
        Y(i + 2) = ZERO
        Y(i + 3) = ZERO
        Y(i + 4) = ZERO
        Y(i + 5) = ZERO
        Y(i + 6) = ZERO
        Y(i + 7) = ZERO
      END DO

      END SUBROUTINE SET2ZERO


!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WDOT (N, DX, incX, DY, incY) 
!--------------------------------------------------------------
!     dot produce: wdot = x(1:N)*y(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SDOT(N,X,1,Y,1) or  CALL DDOT(N,X,1,Y,1)
!--------------------------------------------------------------
!      USE messy_mecca_kpp_Precision
!--------------------------------------------------------------
      IMPLICIT NONE
      INTEGER :: N, incX, incY
      REAL(kind=dp) :: DX(N), DY(N) 

      INTEGER :: i, IX, IY, M, MP1, NS
                                 
      WDOT = 0.0D0 
      IF (N .LE. 0) RETURN 
      IF (incX .EQ. incY) IF (incX-1) 5,20,60 
!                                                                       
!     Code for unequal or nonpositive increments.                       
!                                                                       
    5 IX = 1 
      IY = 1 
      IF (incX .LT. 0) IX = (-N+1)*incX + 1 
      IF (incY .LT. 0) IY = (-N+1)*incY + 1 
      DO i = 1,N 
        WDOT = WDOT + DX(IX)*DY(IY) 
        IX = IX + incX 
        IY = IY + incY 
      END DO 
      RETURN 
!                                                                       
!     Code for both increments equal to 1.                              
!                                                                       
!     Clean-up loop so remaining vector length is a multiple of 5.      
!                                                                       
   20 M = MOD(N,5) 
      IF (M .EQ. 0) GO TO 40 
      DO i = 1,M 
         WDOT = WDOT + DX(i)*DY(i) 
      END DO 
      IF (N .LT. 5) RETURN 
   40 MP1 = M + 1 
      DO i = MP1,N,5 
          WDOT = WDOT + DX(i)*DY(i) + DX(i+1)*DY(i+1) + DX(i+2)*DY(i+2) +  &
                   DX(i+3)*DY(i+3) + DX(i+4)*DY(i+4)                   
      END DO 
      RETURN 
!                                                                       
!     Code for equal, positive, non-unit increments.                    
!                                                                       
   60 NS = N*incX 
      DO i = 1,NS,incX 
        WDOT = WDOT + DX(i)*DY(i) 
      END DO 

      END FUNCTION WDOT                                          


!--------------------------------------------------------------
      SUBROUTINE WADD(N,X,Y,Z)
!--------------------------------------------------------------
!     adds two vectors: z <- x + y
!     BLAS - like
!--------------------------------------------------------------
!     USE CB05_CSIRO_Precision
      
      INTEGER :: i, M, MP1, N
      REAL(kind=dp) :: X(N),Y(N),Z(N)

      IF (N.LE.0) RETURN

      M = MOD(N,5)
      IF( M /= 0 ) THEN
         DO i = 1,M
            Z(i) = X(i) + Y(i)
         END DO
         IF( N < 5 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,5
         Z(i)     = X(i)     + Y(i)
         Z(i + 1) = X(i + 1) + Y(i + 1)
         Z(i + 2) = X(i + 2) + Y(i + 2)
         Z(i + 3) = X(i + 3) + Y(i + 3)
         Z(i + 4) = X(i + 4) + Y(i + 4)
      END DO

      END SUBROUTINE WADD
      
      
      
!--------------------------------------------------------------
      SUBROUTINE WGEFA(N,A,Ipvt,info)
!--------------------------------------------------------------
!     WGEFA FACTORS THE MATRIX A (N,N) BY
!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!     LINPACK - LIKE 
!--------------------------------------------------------------
!
      INTEGER       :: N,Ipvt(N),info
      REAL(kind=dp) :: A(N,N)
      REAL(kind=dp) :: t, dmax, da
      INTEGER       :: j,k,l
      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0

      info = 0

size: IF (n > 1) THEN
      
col:  DO k = 1, n-1

!        find l = pivot index
!        l = idamax(n-k+1,A(k,k),1) + k - 1
         l = k; dmax = abs(A(k,k))
         DO j = k+1,n
            da = ABS(A(j,k))
            IF (da > dmax) THEN
              l = j; dmax = da
            END IF
         END DO
         Ipvt(k) = l

!        zero pivot implies this column already triangularized
         IF (ABS(A(l,k)) < TINY(ZERO)) THEN
            info = k
            return
         ELSE   
            IF (l /= k) THEN
               t = A(l,k); A(l,k) = A(k,k); A(k,k) = t
            END IF
            t = -ONE/A(k,k)
            CALL WSCAL(n-k,t,A(k+1,k),1)
            DO j = k+1, n
               t = A(l,j)
               IF (l /= k) THEN
                  A(l,j) = A(k,j); A(k,j) = t
               END IF
               CALL WAXPY(n-k,t,A(k+1,k),1,A(k+1,j),1)
            END DO         
         END IF
         
       END DO col
       
      END IF size
      
      Ipvt(N) = N
      IF (ABS(A(N,N)) == ZERO) info = N
      
      END SUBROUTINE WGEFA


!--------------------------------------------------------------
      SUBROUTINE WGESL(Trans,N,A,Ipvt,b)
!--------------------------------------------------------------
!     WGESL solves the system
!     a * x = b  or  trans(a) * x = b
!     using the factors computed by WGEFA.
!
!     Trans      = 'N'   to solve  A*x = b ,
!                = 'T'   to solve  transpose(A)*x = b
!     LINPACK - LIKE 
!--------------------------------------------------------------

      INTEGER       :: N,Ipvt(N)
      CHARACTER     :: trans
      REAL(kind=dp) :: A(N,N),b(N)
      REAL(kind=dp) :: t
      INTEGER       :: k,kb,l

      
      SELECT CASE (Trans)

      CASE ('n','N')  !  Solve  A * x = b

!        first solve  L*y = b
         IF (n >= 2) THEN
          DO k = 1, n-1
            l = Ipvt(k)
            t = b(l)
            IF (l /= k) THEN
               b(l) = b(k)
               b(k) = t
            END IF
            CALL WAXPY(n-k,t,a(k+1,k),1,b(k+1),1)
          END DO
         END IF
!        now solve  U*x = y
         DO kb = 1, n
            k = n + 1 - kb
            b(k) = b(k)/a(k,k)
            t = -b(k)
            CALL WAXPY(k-1,t,a(1,k),1,b(1),1)
         END DO
      
      CASE ('t','T')  !  Solve transpose(A) * x = b

!        first solve  trans(U)*y = b
         DO k = 1, n
            t = WDOT(k-1,a(1,k),1,b(1),1)
            b(k) = (b(k) - t)/a(k,k)
         END DO
!        now solve trans(L)*x = y
         IF (n >= 2) THEN
         DO kb = 1, n-1
            k = n - kb
            b(k) = b(k) + WDOT(n-k,a(k+1,k),1,b(k+1),1)
            l = Ipvt(k)
            IF (l /= k) THEN
               t = b(l); b(l) = b(k); b(k) = t
            END IF
         END DO
         END IF
   
      END SELECT

      END SUBROUTINE WGESL
! End of BLAS_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE CB05_CSIRO_LinearAlgebra

