! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Sparse Stoichiometric Data Structures File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CB05TUCl_NCSU_StoichiomSP.f90
! Time                 : Thu Oct  8 08:21:46 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CB05TUCl_NCSU_13059_BOXMOX
! Equation file        : CB05TUCl_NCSU.kpp
! Output root filename : CB05TUCl_NCSU
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CB05TUCl_NCSU_StoichiomSP

  USE CB05TUCl_NCSU_Precision
  PUBLIC
  SAVE


! Row-compressed sparse data for the Jacobian of reaction products JVRP

  INTEGER, PARAMETER, DIMENSION(199) :: CROW_JVRP = (/ &
       1,  2,  3,  5,  7,  9, 11, 13, 14, 15, 16, 17, &
      19, 21, 22, 23, 25, 27, 29, 30, 31, 32, 33, 35, &
      37, 38, 40, 41, 43, 45, 47, 49, 50, 52, 53, 54, &
      55, 57, 59, 61, 63, 64, 65, 67, 69, 71, 73, 75, &
      77, 79, 80, 81, 82, 83, 85, 87, 89, 91, 92, 93, &
      95, 97, 98,100,101,103,105,107,109,110,112,113, &
     115,117,118,119,121,123,125,126,128,130,132,134, &
     136,138,139,141,143,144,145,147,149,151,152,154, &
     155,157,159,161,163,164,166,168,169,170,172,174, &
     176,178,179,181,183,184,185,187,189,191,193,195, &
     197,199,201,203,205,207,209,211,213,215,216,218, &
     220,222,224,225,227,229,231,233,234,236,238,240, &
     242,244,246,248,249,251,253,255,257,259,261,263, &
     265,266,267,269,270,272,274,276,277,279,281,283, &
     285,287,289,291,293,295,297,299,301,303,305,307, &
     309,311,313,315,317,319,321,323,325,327,329,331, &
     333,335,337,339,341,343,344 /)

  INTEGER, PARAMETER, DIMENSION(343) :: ICOL_JVRP = (/ &
     101,105, 96,100,101,105,101,105,100,105, 96,101, &
      96, 96, 55, 55, 96, 98, 96,106,103,103,100,103, &
     101,103,101,103, 56, 56, 56,100,100,101, 98,100, &
      60, 60, 98, 60, 98,101, 79, 98,100,106,101,106, &
      63, 63, 98,106,106, 69, 69, 98, 54, 55, 54, 98, &
      98,105, 98, 98, 98,106,105,106, 69,105,103,105, &
      98,103,103,106, 96,103,103, 63, 79, 56,100,104, &
      88,100,104,106, 88,106,104, 88, 88,104, 94, 98, &
      94, 73, 98, 73, 80, 98, 58, 98,100,107,106,107, &
     107, 78, 98, 78, 68, 98, 95, 98, 95, 95, 95,105, &
      95,103, 95,106, 71, 71,100, 71,106, 61, 98, 93, &
     105, 93, 98, 93,103, 93, 97,100, 97,101, 51, 51, &
      97,106, 97,107, 97,104, 97, 64, 98, 64, 65, 98, &
      92,105, 92, 98, 92,103, 92, 99,100, 99,101, 66, &
      66, 66, 98, 99,106, 99,107, 99,104, 99, 97, 99, &
      89, 98, 82, 82, 82,101, 87,105, 87, 98, 87, 96, &
      87,103, 83,105, 83, 98, 83, 96, 83,103, 86,105, &
      86, 98, 86, 96, 86,103, 53, 98, 62,100, 62, 84, &
      98, 84,103, 74,101, 74,106, 81, 81, 98, 81, 96, &
      57, 98, 76, 98, 76, 90,105, 90, 98, 90, 96, 90, &
     103, 91, 98, 91, 96, 91,103, 91, 85,105, 85, 98, &
      85, 96, 85,103, 50, 98, 70, 98, 67, 98, 90,101, &
      49, 52, 96,102, 75, 75,100, 75,106, 77, 98, 77, &
      58,102, 89,102, 67,102, 83,102, 87,102, 86,102, &
      90,102, 95,102, 93,102, 92,102, 68,102, 70,102, &
      72, 98, 59, 96, 59, 98, 59, 69, 12, 98, 15, 98, &
      18, 98, 23, 98, 23, 96, 29, 98, 29, 96, 29,103, &
      32, 98, 34, 98, 37, 98, 42, 98, 41, 98, 40, 98, &
      46, 98, 45, 98, 44, 98, 50 /)

  INTEGER, PARAMETER, DIMENSION(343) :: IROW_JVRP = (/ &
       1,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, &
       8,  9, 10, 11, 12, 12, 13, 13, 14, 15, 16, 16, &
      17, 17, 18, 18, 19, 20, 21, 22, 23, 23, 24, 24, &
      25, 26, 26, 27, 28, 28, 29, 29, 30, 30, 31, 31, &
      32, 33, 33, 34, 35, 36, 37, 37, 38, 38, 39, 39, &
      40, 40, 41, 42, 43, 43, 44, 44, 45, 45, 46, 46, &
      47, 47, 48, 48, 49, 49, 50, 51, 52, 53, 54, 54, &
      55, 55, 56, 56, 57, 57, 58, 59, 60, 60, 61, 61, &
      62, 63, 63, 64, 65, 65, 66, 66, 67, 67, 68, 68, &
      69, 70, 70, 71, 72, 72, 73, 73, 74, 75, 76, 76, &
      77, 77, 78, 78, 79, 80, 80, 81, 81, 82, 82, 83, &
      83, 84, 84, 85, 85, 86, 87, 87, 88, 88, 89, 90, &
      91, 91, 92, 92, 93, 93, 94, 95, 95, 96, 97, 97, &
      98, 98, 99, 99,100,100,101,102,102,103,103,104, &
     105,106,106,107,107,108,108,109,109,110,111,111, &
     112,112,113,114,115,115,116,116,117,117,118,118, &
     119,119,120,120,121,121,122,122,123,123,124,124, &
     125,125,126,126,127,127,128,128,129,129,130,131, &
     131,132,132,133,133,134,134,135,136,136,137,137, &
     138,138,139,139,140,141,141,142,142,143,143,144, &
     144,145,145,146,146,147,147,148,149,149,150,150, &
     151,151,152,152,153,153,154,154,155,155,156,156, &
     157,158,159,159,160,161,161,162,162,163,163,164, &
     165,165,166,166,167,167,168,168,169,169,170,170, &
     171,171,172,172,173,173,174,174,175,175,176,176, &
     177,177,178,178,179,179,180,180,181,181,182,182, &
     183,183,184,184,185,185,186,186,187,187,188,188, &
     189,189,190,190,191,191,192,192,193,193,194,194, &
     195,195,196,196,197,197,198 /)



!  Stoichiometric Matrix in Compressed Column Sparse Format


  INTEGER, PARAMETER, DIMENSION(199) :: CCOL_STOICM = (/ &
       1,  4,  6,  9, 12, 15, 18, 21, 23, 25, 27, 29, &
      32, 35, 38, 40, 43, 45, 48, 50, 52, 55, 57, 60, &
      63, 66, 69, 72, 75, 78, 82, 85, 88, 91, 93, 95, &
      97,100,104,107,110,112,114,116,119,123,126,130, &
     133,136,138,143,146,149,152,155,158,161,162,163, &
     165,173,180,185,190,194,197,202,205,209,215,219, &
     224,229,232,234,239,244,247,250,255,258,262,266, &
     270,274,278,282,285,288,291,296,301,305,307,311, &
     314,318,322,326,330,334,340,343,346,349,353,358, &
     365,369,373,379,388,395,397,400,411,420,430,439, &
     446,453,460,465,473,480,489,495,504,510,513,521, &
     526,529,532,536,544,554,565,570,574,583,593,606, &
     616,629,640,651,659,664,674,686,695,700,708,715, &
     724,726,729,732,735,739,742,746,750,754,763,770, &
     776,784,794,801,806,810,814,819,824,827,830,833, &
     836,838,841,844,847,850,853,856,858,861,863,866, &
     868,870,872,874,876,878,880 /)

  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_0 = (/ &
     100,101,105, 96,105, 96,100,101,100,101,105,101, &
     103,105,100,101,105, 96,101,103, 96,105, 55, 96, &
      55,105, 55, 98, 96, 98,106, 96, 98,106,101,103, &
     105,100,103,100,101,103,100,103, 56,101,103, 56, &
      79, 56, 79, 56,101,103,100,101, 60,100,101, 60, &
      98,100, 60, 98,100, 60, 98,101, 60,100,101, 79, &
      98,101, 79, 98,103, 98,100,101,106, 63,101,106, &
      63,101,106, 63, 98,101, 69,106, 69,106, 69, 98, &
      69, 98,106, 54, 55, 98,106, 54, 98,106, 98,105, &
     106, 98,105, 69, 98, 98,106, 98,105,106, 69, 98, &
     105,106,101,103,105, 98,101,103,106, 79,103,106, &
      96,101,103,101,103, 63, 98,101,103,106, 79, 98, &
     101, 56,101,103,100,101,104, 88, 94,100, 73,104, &
     106, 73, 88,106,104, 88, 88,104, 79, 89, 92, 93, &
      94, 95, 98,106, 89, 92, 93, 94, 95,101,106, 73, &
      92, 93, 98,104, 73, 92, 93, 98,106, 47, 80, 98, &
     106, 58, 98,107, 95,100,101,106,107, 78,106,107, &
      68, 95,106,107, 48, 78, 98,104,106,107, 78, 95, &
      98,106, 48, 68, 95, 98,106, 48, 80, 95, 98,106, &
      80, 95,106, 80, 95, 80, 95, 98,105,106, 79, 80, &
      95,103,106, 71, 95,106, 71, 95,106, 61, 71,100, &
     101,106, 71, 78,106, 48, 61, 98,106, 93, 97, 98, &
     105, 48, 93, 97, 98, 79, 93, 97,103, 80, 93,106, &
     107, 97,100,101,107, 51, 97,101, 51, 97,101, 51, &
      97,101, 64, 65, 96, 97,106, 65, 95, 97,106,107, &
      65, 97,104,107, 97,107, 48, 64, 97, 98, 64, 98, &
     107, 48, 65, 98,107, 92, 98, 99,105, 48, 92, 98, &
      99, 79, 92, 99,103, 80, 92,106,107, 93, 99,100, &
     101,104,106, 66, 99,101, 66, 99,101, 66, 99,101, &
      66, 93, 98,101, 64, 65, 96, 99,106, 65, 93, 95 /)
  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_1 = (/ &
      99,104,106,107, 65, 93, 99,104, 93, 99,104,106, &
      93, 97, 99,104,106,107, 48, 82, 88, 89, 92, 93, &
      98,104,106, 82, 88, 89, 92, 93,104,106, 82,106, &
      82, 94,101, 80, 87, 88, 89, 92, 93, 95, 98,104, &
     105,106, 48, 87, 89, 92, 93, 95, 98,104,106, 80, &
      87, 89, 92, 93, 95, 96, 98,104,106, 87, 88, 89, &
      92, 93, 95,101,103,104, 80, 83, 95, 98,104,105, &
     106, 48, 83, 92, 95, 98,104,106, 61, 80, 83, 95, &
      96, 98,106, 83, 95,101,103,104, 80, 86, 89, 92, &
      93,104,105,106, 48, 86, 92, 93, 98,104,106, 80, &
      86, 92, 93, 95, 96, 98,105,106, 86, 92, 93,101, &
     103,106,  1,  2, 48, 53, 62, 84, 98,104,106, 62, &
      81, 94,100,101,106, 62, 84,106,  3, 48, 74, 81, &
      84, 98,104,106,  3, 74, 79, 84,103, 74, 94,101, &
      74, 84,106, 80, 81, 97,106, 48, 80, 81, 95, 97, &
      98,104,106, 76, 80, 81, 92, 95, 96, 97, 98,104, &
     106,  4,  5, 48, 57, 62, 76, 84, 89, 98,104,106, &
      48, 76, 97, 98,104, 76, 80, 97,106,  6,  7, 90, &
      91, 95, 99,104,105,106,  6,  7, 48, 88, 90, 91, &
      95, 98,104,106,  6,  7, 80, 89, 90, 91, 92, 95, &
      96, 98, 99,104,106,  6,  7, 90, 91, 92, 94,101, &
     103,104,106, 48, 76, 80, 89, 91, 92, 93, 95, 97, &
      98, 99,104,106, 76, 80, 89, 91, 93, 95, 96, 97, &
      98,104,106, 79, 80, 89, 91, 92, 94, 95, 99,103, &
     104,106, 80, 89, 91, 93, 95, 97,104,106, 10, 85, &
      89, 98,105, 10, 48, 85, 88, 89, 92, 95, 98,104, &
     106, 10, 80, 85, 88, 89, 92, 95, 96, 98, 99,104, &
     106, 10, 85, 88, 92, 94,101,103,104,106,  8,  9, &
      50, 98,106, 48, 70, 92, 93, 95, 98,104,106, 48, &
      67, 88, 93, 98,104,106, 89, 90, 91, 92, 94,100 /)
  INTEGER, PARAMETER, DIMENSION(159) :: IROW_STOICM_2 = (/ &
     101,104,106, 49,102, 52, 98,102, 75, 96,102, 49, &
      75,102, 75,100,101,102, 52, 75,106, 77, 80, 98, &
     102, 77, 80,102,106, 58, 72,102,107, 72, 82, 88, &
      89, 92, 93,102,104,106, 67, 72, 88, 93,102,104, &
     106, 77, 83, 95,102,104,106, 77, 87, 89, 92, 93, &
     102,104,106, 72, 77, 86, 87, 89, 92, 93,102,104, &
     106, 72, 77, 90, 91,102,104,106, 72, 80, 95,102, &
     106, 72, 93, 97,102, 72, 92, 99,102, 68, 72, 95, &
     102,106, 70, 72, 93,102,106, 72, 98,102, 38, 59, &
      96, 38, 59, 98, 38, 59, 69, 11, 12, 13, 14, 15, &
      16, 17, 18, 19, 20, 23, 21, 22, 23, 24, 25, 29, &
      26, 27, 29, 28, 29, 30, 31, 32, 33, 34, 35, 36, &
      37, 41, 42, 40, 41, 39, 40, 45, 46, 44, 45, 43, &
      44,  8, 50 /)
  INTEGER, PARAMETER, DIMENSION(879) :: IROW_STOICM = (/&
    IROW_STOICM_0, IROW_STOICM_1, IROW_STOICM_2 /)

  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_0 = (/ &
       1,  1,  1,  2,  2,  3,  3,  3,  4,  4,  4,  5, &
       5,  5,  6,  6,  6,  7,  7,  7,  8,  8,  9,  9, &
      10, 10, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, &
      14, 15, 15, 16, 16, 16, 17, 17, 18, 18, 18, 19, &
      19, 20, 20, 21, 21, 21, 22, 22, 23, 23, 23, 24, &
      24, 24, 25, 25, 25, 26, 26, 26, 27, 27, 27, 28, &
      28, 28, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, &
      32, 32, 32, 33, 33, 33, 34, 34, 35, 35, 36, 36, &
      37, 37, 37, 38, 38, 38, 38, 39, 39, 39, 40, 40, &
      40, 41, 41, 42, 42, 43, 43, 44, 44, 44, 45, 45, &
      45, 45, 46, 46, 46, 47, 47, 47, 47, 48, 48, 48, &
      49, 49, 49, 50, 50, 51, 51, 51, 51, 51, 52, 52, &
      52, 53, 53, 53, 54, 54, 54, 55, 55, 55, 56, 56, &
      56, 57, 57, 57, 58, 59, 60, 60, 61, 61, 61, 61, &
      61, 61, 61, 61, 62, 62, 62, 62, 62, 62, 62, 63, &
      63, 63, 63, 63, 64, 64, 64, 64, 64, 65, 65, 65, &
      65, 66, 66, 66, 67, 67, 67, 67, 67, 68, 68, 68, &
      69, 69, 69, 69, 70, 70, 70, 70, 70, 70, 71, 71, &
      71, 71, 72, 72, 72, 72, 72, 73, 73, 73, 73, 73, &
      74, 74, 74, 75, 75, 76, 76, 76, 76, 76, 77, 77, &
      77, 77, 77, 78, 78, 78, 79, 79, 79, 80, 80, 80, &
      80, 80, 81, 81, 81, 82, 82, 82, 82, 83, 83, 83, &
      83, 84, 84, 84, 84, 85, 85, 85, 85, 86, 86, 86, &
      86, 87, 87, 87, 87, 88, 88, 88, 89, 89, 89, 90, &
      90, 90, 91, 91, 91, 91, 91, 92, 92, 92, 92, 92, &
      93, 93, 93, 93, 94, 94, 95, 95, 95, 95, 96, 96, &
      96, 97, 97, 97, 97, 98, 98, 98, 98, 99, 99, 99, &
      99,100,100,100,100,101,101,101,101,102,102,102, &
     102,102,102,103,103,103,104,104,104,105,105,105, &
     106,106,106,106,107,107,107,107,107,108,108,108 /)
  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_1 = (/ &
     108,108,108,108,109,109,109,109,110,110,110,110, &
     111,111,111,111,111,111,112,112,112,112,112,112, &
     112,112,112,113,113,113,113,113,113,113,114,114, &
     115,115,115,116,116,116,116,116,116,116,116,116, &
     116,116,117,117,117,117,117,117,117,117,117,118, &
     118,118,118,118,118,118,118,118,118,119,119,119, &
     119,119,119,119,119,119,120,120,120,120,120,120, &
     120,121,121,121,121,121,121,121,122,122,122,122, &
     122,122,122,123,123,123,123,123,124,124,124,124, &
     124,124,124,124,125,125,125,125,125,125,125,126, &
     126,126,126,126,126,126,126,126,127,127,127,127, &
     127,127,128,128,128,128,128,128,128,128,128,129, &
     129,129,129,129,129,130,130,130,131,131,131,131, &
     131,131,131,131,132,132,132,132,132,133,133,133, &
     134,134,134,135,135,135,135,136,136,136,136,136, &
     136,136,136,137,137,137,137,137,137,137,137,137, &
     137,138,138,138,138,138,138,138,138,138,138,138, &
     139,139,139,139,139,140,140,140,140,141,141,141, &
     141,141,141,141,141,141,142,142,142,142,142,142, &
     142,142,142,142,143,143,143,143,143,143,143,143, &
     143,143,143,143,143,144,144,144,144,144,144,144, &
     144,144,144,145,145,145,145,145,145,145,145,145, &
     145,145,145,145,146,146,146,146,146,146,146,146, &
     146,146,146,147,147,147,147,147,147,147,147,147, &
     147,147,148,148,148,148,148,148,148,148,149,149, &
     149,149,149,150,150,150,150,150,150,150,150,150, &
     150,151,151,151,151,151,151,151,151,151,151,151, &
     151,152,152,152,152,152,152,152,152,152,153,153, &
     153,153,153,154,154,154,154,154,154,154,154,155, &
     155,155,155,155,155,155,156,156,156,156,156,156 /)
  INTEGER, PARAMETER, DIMENSION(159) :: ICOL_STOICM_2 = (/ &
     156,156,156,157,157,158,158,158,159,159,159,160, &
     160,160,161,161,161,161,162,162,162,163,163,163, &
     163,164,164,164,164,165,165,165,165,166,166,166, &
     166,166,166,166,166,166,167,167,167,167,167,167, &
     167,168,168,168,168,168,168,169,169,169,169,169, &
     169,169,169,170,170,170,170,170,170,170,170,170, &
     170,171,171,171,171,171,171,171,172,172,172,172, &
     172,173,173,173,173,174,174,174,174,175,175,175, &
     175,175,176,176,176,176,176,177,177,177,178,178, &
     178,179,179,179,180,180,180,181,181,182,182,182, &
     183,183,183,184,184,184,185,185,185,186,186,186, &
     187,187,187,188,188,189,189,189,190,190,191,191, &
     191,192,192,193,193,194,194,195,195,196,196,197, &
     197,198,198 /)
  INTEGER, PARAMETER, DIMENSION(879) :: ICOL_STOICM = (/&
    ICOL_STOICM_0, ICOL_STOICM_1, ICOL_STOICM_2 /)

  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_0 = (/ &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp, &
       2.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp,  3.900000e-01_dp,  6.100000e-01_dp, &
       3.900000e-01_dp,  6.100000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_1 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -2.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -6.600000e-01_dp,  3.300000e-01_dp,  3.300000e-01_dp,  -1.000000e+00_dp,  3.300000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -6.600000e-01_dp,  3.300000e-01_dp,  3.300000e-01_dp, &
       -1.000000e+00_dp,  3.300000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  6.300000e-01_dp, &
       1.370000e+00_dp,  7.400000e-01_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  3.000000e-01_dp,  3.000000e-01_dp,  7.000000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       8.000000e-01_dp,  2.000000e-01_dp,  2.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  9.000000e-01_dp,  -1.000000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_2 = (/ &
       1.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  9.000000e-01_dp,  -2.000000e+00_dp, &
       2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  8.000000e-01_dp,  2.000000e-01_dp,  2.000000e-01_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e-01_dp,  9.000000e-01_dp,  1.000000e-01_dp, &
       -1.000000e+00_dp,  9.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e-01_dp, &
       9.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp, &
       2.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  7.600000e-01_dp, &
       1.300000e-01_dp,  -1.110000e+00_dp,  5.000000e-02_dp,  6.000000e-02_dp,  -1.000000e+00_dp, &
       8.700000e-01_dp,  1.100000e-01_dp,  -9.800000e-01_dp,  4.000000e-02_dp,  -2.100000e+00_dp, &
       5.000000e-01_dp,  6.000000e-01_dp,  9.600000e-01_dp,  9.400000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e-01_dp, &
       -1.000000e+00_dp,  1.000000e-02_dp,  2.000000e-01_dp,  3.000000e-01_dp,  2.000000e-01_dp, &
       2.000000e-01_dp,  1.000000e-01_dp,  2.000000e-01_dp,  -1.000000e+00_dp,  3.000000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -7.000000e-01_dp,  6.200000e-01_dp,  3.300000e-01_dp, &
       8.000000e-01_dp,  -1.000000e+00_dp,  8.000000e-01_dp,  9.500000e-01_dp,  3.300000e-01_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  3.200000e-01_dp,  1.800000e-01_dp,  7.400000e-01_dp, &
       -1.000000e+00_dp,  1.000000e-01_dp,  2.200000e-01_dp,  4.400000e-01_dp,  -1.000000e+00_dp, &
       9.000000e-02_dp,  -1.000000e+00_dp,  5.600000e-01_dp,  3.500000e-01_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  9.100000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  3.000000e-01_dp,  7.000000e-01_dp,  -1.000000e+00_dp,  1.700000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  2.200000e-01_dp,  1.560000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_3 = (/ &
       1.000000e+00_dp,  1.000000e+00_dp,  3.700000e-01_dp,  6.300000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.300000e-01_dp,  1.300000e-01_dp,  -1.000000e+00_dp, &
       2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e-01_dp, &
       -1.000000e+00_dp,  1.000000e-01_dp,  6.600000e-01_dp,  1.240000e+00_dp,  1.000000e-01_dp, &
       -1.000000e+00_dp,  1.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  7.000000e-01_dp, &
       1.300000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  2.500000e-01_dp, &
       -1.000000e+00_dp,  3.500000e-01_dp,  6.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp, &
       5.000000e-01_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  6.400000e-01_dp, &
       1.180000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  7.100000e-02_dp, &
       1.380000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  5.600000e-01_dp,  3.600000e-01_dp, &
       -1.000000e+00_dp,  8.000000e-02_dp,  4.400000e-01_dp,  -1.000000e+00_dp,  9.000000e-01_dp, &
       1.000000e-01_dp,  -1.000000e+00_dp,  9.000000e-01_dp,  9.000000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  4.000000e-01_dp, &
       3.000000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  6.000000e-01_dp,  6.000000e-01_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp,  2.000000e-01_dp,  6.900000e-01_dp, &
       -1.000000e+00_dp,  3.000000e-02_dp,  7.000000e-01_dp,  -1.000000e+00_dp,  6.200000e-01_dp, &
       8.000000e-02_dp,  3.000000e-02_dp,  7.600000e-01_dp,  3.800000e-02_dp,  1.670000e-01_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  3.000000e-01_dp,  8.000000e-01_dp,  2.000000e-01_dp, &
       1.100000e+00_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  7.000000e-01_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  2.320000e-01_dp,  2.280000e-02_dp, &
       -1.000000e+00_dp,  7.500000e-01_dp,  5.000000e-01_dp,  2.500000e-01_dp,  2.500000e-01_dp, &
       -1.000000e+00_dp,  2.500000e-01_dp,  2.320000e-01_dp,  2.880000e-02_dp,  1.000000e+00_dp, &
       8.800000e-02_dp,  -1.000000e+00_dp,  9.120000e-01_dp,  6.290000e-01_dp,  -1.000000e+00_dp, &
       9.910000e-01_dp,  9.120000e-01_dp,  2.320000e-01_dp,  2.880000e-02_dp,  6.600000e-02_dp, &
       3.500000e-01_dp,  -1.000000e+00_dp,  6.500000e-01_dp,  1.500000e-01_dp,  6.000000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_4 = (/ &
       -1.000000e+00_dp,  2.660000e-01_dp,  2.000000e-01_dp,  2.000000e-01_dp,  6.600000e-02_dp, &
       2.320000e-01_dp,  2.880000e-02_dp,  -1.000000e+00_dp,  2.000000e-01_dp,  8.000000e-01_dp, &
       8.000000e-01_dp,  2.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  8.000000e-01_dp, &
       1.000000e+00_dp,  1.680000e-01_dp,  3.340000e-01_dp,  1.565000e+00_dp,  -1.000000e+00_dp, &
       1.200000e-01_dp,  2.520000e-01_dp,  1.670000e-01_dp,  2.100000e-01_dp,  -1.000000e+00_dp, &
       2.500000e-01_dp,  7.130000e-01_dp,  5.030000e-01_dp,  8.500000e-01_dp,  2.250000e-01_dp, &
       3.600000e-01_dp,  -1.000000e+00_dp,  2.000000e-02_dp,  1.500000e-01_dp,  -1.000000e+00_dp, &
       1.140000e-01_dp,  2.680000e-01_dp,  6.400000e-02_dp,  1.540000e-01_dp,  1.500000e-01_dp, &
       6.430000e-01_dp,  1.282000e+00_dp,  -1.000000e+00_dp,  3.570000e-01_dp,  8.500000e-01_dp, &
       2.820000e-01_dp,  7.500000e-02_dp,  -1.000000e+00_dp,  7.500000e-02_dp,  9.250000e-01_dp, &
       3.330000e-01_dp,  8.320000e-01_dp,  -1.000000e+00_dp,  6.700000e-02_dp,  9.000000e-01_dp, &
       9.670000e-01_dp,  7.000000e-01_dp,  1.033000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       5.120000e+00_dp,  1.500000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  2.500000e-01_dp,  1.660000e+00_dp,  4.700000e-01_dp,  2.800000e-01_dp, &
       -1.000000e+00_dp,  1.250000e+00_dp,  7.500000e-01_dp,  1.000000e+00_dp,  1.000000e-03_dp, &
       -1.000000e+00_dp,  1.800000e-01_dp,  7.000000e+00_dp,  2.100000e-01_dp,  2.400000e-01_dp, &
       -1.000000e+00_dp,  5.700000e-01_dp,  3.900000e-01_dp,  7.600000e-01_dp,  7.000000e-02_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  4.700000e-01_dp,  5.300000e-01_dp, &
       4.700000e-01_dp,  -1.000000e+00_dp,  1.030000e+00_dp,  2.800000e-01_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  5.000000e-02_dp,  9.000000e-01_dp,  1.000000e-01_dp,  -1.000000e+00_dp, &
       1.000000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  9.000000e-03_dp, &
       9.910000e-01_dp,  -1.000000e+00_dp,  9.910000e-01_dp,  1.000000e+00_dp,  2.400000e+00_dp, &
       -1.000000e+00_dp,  2.000000e-01_dp,  8.000000e-01_dp,  8.000000e-01_dp,  2.000000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  8.000000e-01_dp,  -1.000000e+00_dp,  2.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  3.000000e-01_dp,  -2.000000e+00_dp,  1.400000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(129) :: STOICM_5 = (/ &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  7.600000e-01_dp, &
       1.300000e-01_dp,  -1.110000e+00_dp,  5.000000e-02_dp,  6.000000e-02_dp,  -1.000000e+00_dp, &
       8.700000e-01_dp,  1.100000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  9.000000e-03_dp, &
       9.910000e-01_dp,  -1.000000e+00_dp,  9.910000e-01_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  6.700000e-01_dp,  3.300000e-01_dp, &
       -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  3.000000e-01_dp,  7.000000e-01_dp, &
       -1.000000e+00_dp,  3.000000e-01_dp,  3.000000e-01_dp,  5.500000e-01_dp,  4.500000e-01_dp, &
       -1.000000e+00_dp,  1.700000e+00_dp,  1.000000e+00_dp,  1.500000e-01_dp,  8.500000e-01_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  2.390000e-01_dp,  3.630000e-01_dp,  -1.000000e+00_dp, &
       4.500000e-02_dp,  1.490000e-01_dp,  -1.000000e+00_dp,  3.800000e-02_dp,  3.260000e-01_dp, &
       -1.000000e+00_dp,  1.250000e-01_dp,  1.020000e-01_dp,  -1.000000e+00_dp,  1.300000e-01_dp, &
       4.060000e-02_dp,  -1.000000e+00_dp,  2.600000e-02_dp,  4.850000e-01_dp,  -1.000000e+00_dp, &
       1.000000e+00_dp,  -1.000000e+00_dp,  9.100000e-02_dp,  3.670000e-01_dp,  -1.000000e+00_dp, &
       1.173000e+00_dp,  -1.000000e+00_dp,  1.560000e-01_dp,  7.770000e-01_dp,  -1.000000e+00_dp, &
       1.075000e+00_dp,  -1.000000e+00_dp,  1.075000e+00_dp,  -1.000000e+00_dp,  1.075000e+00_dp, &
       -1.000000e+00_dp,  1.075000e+00_dp,  -1.000000e+00_dp,  1.075000e+00_dp,  -1.000000e+00_dp, &
       1.075000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(879) :: STOICM = (/&
    STOICM_0, STOICM_1, STOICM_2, STOICM_3, STOICM_4, &
    STOICM_5 /)


END MODULE CB05TUCl_NCSU_StoichiomSP

