! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Stoichiometric Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CB05TUCl_NCSU_Stoichiom.f90
! Time                 : Thu Oct  8 08:21:46 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CB05TUCl_NCSU_13059_BOXMOX
! Equation file        : CB05TUCl_NCSU.kpp
! Output root filename : CB05TUCl_NCSU
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CB05TUCl_NCSU_Stoichiom

  USE CB05TUCl_NCSU_Parameters
  USE CB05TUCl_NCSU_StoichiomSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ReactantProd - Reactant Products in each equation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      ARP       - Reactant product in each equation
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ReactantProd ( V, F, ARP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! ARP - Reactant product in each equation
  REAL(kind=dp) :: ARP(NREACT)


! Reactant Products in each equation are useful in the
!     stoichiometric formulation of mass action law
  ARP(1) = V(101)
  ARP(2) = V(105)
  ARP(3) = V(96)*V(100)
  ARP(4) = V(101)*V(105)
  ARP(5) = V(101)*V(105)
  ARP(6) = V(100)*V(105)
  ARP(7) = V(96)*V(101)
  ARP(8) = V(96)
  ARP(9) = V(96)
  ARP(10) = V(55)*F(2)
  ARP(11) = V(55)*F(1)
  ARP(12) = V(96)*V(98)
  ARP(13) = V(96)*V(106)
  ARP(14) = V(103)
  ARP(15) = V(103)
  ARP(16) = V(100)*V(103)
  ARP(17) = V(101)*V(103)
  ARP(18) = V(101)*V(103)
  ARP(19) = V(56)*F(1)
  ARP(20) = V(56)*F(1)*F(1)
  ARP(21) = V(56)
  ARP(22) = V(100)*V(100)
  ARP(23) = V(100)*V(101)*F(1)
  ARP(24) = V(98)*V(100)
  ARP(25) = V(60)
  ARP(26) = V(60)*V(98)
  ARP(27) = V(60)*V(60)
  ARP(28) = V(98)*V(101)
  ARP(29) = V(79)*V(98)
  ARP(30) = V(100)*V(106)
  ARP(31) = V(101)*V(106)
  ARP(32) = V(63)
  ARP(33) = V(63)*V(98)
  ARP(34) = V(106)*V(106)
  ARP(35) = V(106)*V(106)*F(1)
  ARP(36) = V(69)
  ARP(37) = V(69)*V(98)
  ARP(38) = V(54)*V(55)
  ARP(39) = V(54)*V(98)
  ARP(40) = V(98)*V(105)
  ARP(41) = V(98)*V(98)
  ARP(42) = V(98)*V(98)
  ARP(43) = V(98)*V(106)
  ARP(44) = V(105)*V(106)
  ARP(45) = V(69)*V(105)
  ARP(46) = V(103)*V(105)
  ARP(47) = V(98)*V(103)
  ARP(48) = V(103)*V(106)
  ARP(49) = V(96)*V(103)
  ARP(50) = V(103)*V(103)
  ARP(51) = V(63)
  ARP(52) = V(79)
  ARP(53) = V(56)
  ARP(54) = V(100)*V(104)
  ARP(55) = V(88)*V(100)
  ARP(56) = V(104)*V(106)
  ARP(57) = V(88)*V(106)
  ARP(58) = V(104)*V(104)
  ARP(59) = V(88)*V(88)
  ARP(60) = V(88)*V(104)
  ARP(61) = V(94)*V(98)
  ARP(62) = V(94)
  ARP(63) = V(73)*V(98)
  ARP(64) = V(73)
  ARP(65) = V(80)*V(98)
  ARP(66) = V(58)*V(98)
  ARP(67) = V(100)*V(107)
  ARP(68) = V(106)*V(107)
  ARP(69) = V(107)*V(107)
  ARP(70) = V(78)*V(98)
  ARP(71) = V(78)
  ARP(72) = V(68)*V(98)
  ARP(73) = V(95)*V(98)
  ARP(74) = V(95)
  ARP(75) = V(95)
  ARP(76) = V(95)*V(105)
  ARP(77) = V(95)*V(103)
  ARP(78) = V(95)*V(106)
  ARP(79) = V(71)
  ARP(80) = V(71)*V(100)
  ARP(81) = V(71)*V(106)
  ARP(82) = V(61)*V(98)
  ARP(83) = V(93)*V(105)
  ARP(84) = V(93)*V(98)
  ARP(85) = V(93)*V(103)
  ARP(86) = V(93)
  ARP(87) = V(97)*V(100)
  ARP(88) = V(97)*V(101)
  ARP(89) = V(51)
  ARP(90) = V(51)
  ARP(91) = V(97)*V(106)
  ARP(92) = V(97)*V(107)
  ARP(93) = V(97)*V(104)
  ARP(94) = V(97)*V(97)
  ARP(95) = V(64)*V(98)
  ARP(96) = V(64)
  ARP(97) = V(65)*V(98)
  ARP(98) = V(92)*V(105)
  ARP(99) = V(92)*V(98)
  ARP(100) = V(92)*V(103)
  ARP(101) = V(92)
  ARP(102) = V(99)*V(100)
  ARP(103) = V(99)*V(101)
  ARP(104) = V(66)
  ARP(105) = V(66)
  ARP(106) = V(66)*V(98)
  ARP(107) = V(99)*V(106)
  ARP(108) = V(99)*V(107)
  ARP(109) = V(99)*V(104)
  ARP(110) = V(99)*V(99)
  ARP(111) = V(97)*V(99)
  ARP(112) = V(89)*V(98)
  ARP(113) = V(82)
  ARP(114) = V(82)
  ARP(115) = V(82)*V(101)
  ARP(116) = V(87)*V(105)
  ARP(117) = V(87)*V(98)
  ARP(118) = V(87)*V(96)
  ARP(119) = V(87)*V(103)
  ARP(120) = V(83)*V(105)
  ARP(121) = V(83)*V(98)
  ARP(122) = V(83)*V(96)
  ARP(123) = V(83)*V(103)
  ARP(124) = V(86)*V(105)
  ARP(125) = V(86)*V(98)
  ARP(126) = V(86)*V(96)
  ARP(127) = V(86)*V(103)
  ARP(128) = V(53)*V(98)
  ARP(129) = V(62)*V(100)
  ARP(130) = V(62)
  ARP(131) = V(84)*V(98)
  ARP(132) = V(84)*V(103)
  ARP(133) = V(74)*V(101)
  ARP(134) = V(74)*V(106)
  ARP(135) = V(81)
  ARP(136) = V(81)*V(98)
  ARP(137) = V(81)*V(96)
  ARP(138) = V(57)*V(98)
  ARP(139) = V(76)*V(98)
  ARP(140) = V(76)
  ARP(141) = V(90)*V(105)
  ARP(142) = V(90)*V(98)
  ARP(143) = V(90)*V(96)
  ARP(144) = V(90)*V(103)
  ARP(145) = V(91)*V(98)
  ARP(146) = V(91)*V(96)
  ARP(147) = V(91)*V(103)
  ARP(148) = V(91)
  ARP(149) = V(85)*V(105)
  ARP(150) = V(85)*V(98)
  ARP(151) = V(85)*V(96)
  ARP(152) = V(85)*V(103)
  ARP(153) = V(50)*V(98)
  ARP(154) = V(70)*V(98)
  ARP(155) = V(67)*V(98)
  ARP(156) = V(90)*V(101)
  ARP(157) = V(49)
  ARP(158) = V(52)
  ARP(159) = V(96)*V(102)
  ARP(160) = V(75)*V(75)
  ARP(161) = V(75)*V(100)
  ARP(162) = V(75)*V(106)
  ARP(163) = V(77)*V(98)
  ARP(164) = V(77)
  ARP(165) = V(58)*V(102)
  ARP(166) = V(89)*V(102)
  ARP(167) = V(67)*V(102)
  ARP(168) = V(83)*V(102)
  ARP(169) = V(87)*V(102)
  ARP(170) = V(86)*V(102)
  ARP(171) = V(90)*V(102)
  ARP(172) = V(95)*V(102)
  ARP(173) = V(93)*V(102)
  ARP(174) = V(92)*V(102)
  ARP(175) = V(68)*V(102)
  ARP(176) = V(70)*V(102)
  ARP(177) = V(72)*V(98)
  ARP(178) = V(59)*V(96)
  ARP(179) = V(59)*V(98)
  ARP(180) = V(59)*V(69)
  ARP(181) = V(12)*V(98)
  ARP(182) = V(15)*V(98)
  ARP(183) = V(18)*V(98)
  ARP(184) = V(23)*V(98)
  ARP(185) = V(23)*V(96)
  ARP(186) = V(29)*V(98)
  ARP(187) = V(29)*V(96)
  ARP(188) = V(29)*V(103)
  ARP(189) = V(32)*V(98)
  ARP(190) = V(34)*V(98)
  ARP(191) = V(37)*V(98)
  ARP(192) = V(42)*V(98)
  ARP(193) = V(41)*V(98)
  ARP(194) = V(40)*V(98)
  ARP(195) = V(46)*V(98)
  ARP(196) = V(45)*V(98)
  ARP(197) = V(44)*V(98)
  ARP(198) = V(50)
      
END SUBROUTINE ReactantProd

! End of ReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacReactantProd - Jacobian of Reactant Products vector
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      JVRP      - d ARP(1:NREACT)/d VAR (1:NVAR)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacReactantProd ( V, F, JVRP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! JVRP - d ARP(1:NREACT)/d VAR (1:NVAR)
  REAL(kind=dp) :: JVRP(NJVRP)


! Reactant Products in each equation are useful in the
!    stoichiometric formulation of mass action law
! Below we compute the Jacobian of the Reactant Products vector
!    w.r.t. variable species: d ARP(1:NREACT) / d Var(1:NVAR)

! JVRP(1) = dARP(1)/dV(101)
  JVRP(1) = 1
! JVRP(2) = dARP(2)/dV(105)
  JVRP(2) = 1
! JVRP(3) = dARP(3)/dV(96)
  JVRP(3) = V(100)
! JVRP(4) = dARP(3)/dV(100)
  JVRP(4) = V(96)
! JVRP(5) = dARP(4)/dV(101)
  JVRP(5) = V(105)
! JVRP(6) = dARP(4)/dV(105)
  JVRP(6) = V(101)
! JVRP(7) = dARP(5)/dV(101)
  JVRP(7) = V(105)
! JVRP(8) = dARP(5)/dV(105)
  JVRP(8) = V(101)
! JVRP(9) = dARP(6)/dV(100)
  JVRP(9) = V(105)
! JVRP(10) = dARP(6)/dV(105)
  JVRP(10) = V(100)
! JVRP(11) = dARP(7)/dV(96)
  JVRP(11) = V(101)
! JVRP(12) = dARP(7)/dV(101)
  JVRP(12) = V(96)
! JVRP(13) = dARP(8)/dV(96)
  JVRP(13) = 1
! JVRP(14) = dARP(9)/dV(96)
  JVRP(14) = 1
! JVRP(15) = dARP(10)/dV(55)
  JVRP(15) = F(2)
! JVRP(16) = dARP(11)/dV(55)
  JVRP(16) = F(1)
! JVRP(17) = dARP(12)/dV(96)
  JVRP(17) = V(98)
! JVRP(18) = dARP(12)/dV(98)
  JVRP(18) = V(96)
! JVRP(19) = dARP(13)/dV(96)
  JVRP(19) = V(106)
! JVRP(20) = dARP(13)/dV(106)
  JVRP(20) = V(96)
! JVRP(21) = dARP(14)/dV(103)
  JVRP(21) = 1
! JVRP(22) = dARP(15)/dV(103)
  JVRP(22) = 1
! JVRP(23) = dARP(16)/dV(100)
  JVRP(23) = V(103)
! JVRP(24) = dARP(16)/dV(103)
  JVRP(24) = V(100)
! JVRP(25) = dARP(17)/dV(101)
  JVRP(25) = V(103)
! JVRP(26) = dARP(17)/dV(103)
  JVRP(26) = V(101)
! JVRP(27) = dARP(18)/dV(101)
  JVRP(27) = V(103)
! JVRP(28) = dARP(18)/dV(103)
  JVRP(28) = V(101)
! JVRP(29) = dARP(19)/dV(56)
  JVRP(29) = F(1)
! JVRP(30) = dARP(20)/dV(56)
  JVRP(30) = F(1)*F(1)
! JVRP(31) = dARP(21)/dV(56)
  JVRP(31) = 1
! JVRP(32) = dARP(22)/dV(100)
  JVRP(32) = 2*V(100)
! JVRP(33) = dARP(23)/dV(100)
  JVRP(33) = V(101)*F(1)
! JVRP(34) = dARP(23)/dV(101)
  JVRP(34) = V(100)*F(1)
! JVRP(35) = dARP(24)/dV(98)
  JVRP(35) = V(100)
! JVRP(36) = dARP(24)/dV(100)
  JVRP(36) = V(98)
! JVRP(37) = dARP(25)/dV(60)
  JVRP(37) = 1
! JVRP(38) = dARP(26)/dV(60)
  JVRP(38) = V(98)
! JVRP(39) = dARP(26)/dV(98)
  JVRP(39) = V(60)
! JVRP(40) = dARP(27)/dV(60)
  JVRP(40) = 2*V(60)
! JVRP(41) = dARP(28)/dV(98)
  JVRP(41) = V(101)
! JVRP(42) = dARP(28)/dV(101)
  JVRP(42) = V(98)
! JVRP(43) = dARP(29)/dV(79)
  JVRP(43) = V(98)
! JVRP(44) = dARP(29)/dV(98)
  JVRP(44) = V(79)
! JVRP(45) = dARP(30)/dV(100)
  JVRP(45) = V(106)
! JVRP(46) = dARP(30)/dV(106)
  JVRP(46) = V(100)
! JVRP(47) = dARP(31)/dV(101)
  JVRP(47) = V(106)
! JVRP(48) = dARP(31)/dV(106)
  JVRP(48) = V(101)
! JVRP(49) = dARP(32)/dV(63)
  JVRP(49) = 1
! JVRP(50) = dARP(33)/dV(63)
  JVRP(50) = V(98)
! JVRP(51) = dARP(33)/dV(98)
  JVRP(51) = V(63)
! JVRP(52) = dARP(34)/dV(106)
  JVRP(52) = 2*V(106)
! JVRP(53) = dARP(35)/dV(106)
  JVRP(53) = 2*V(106)*F(1)
! JVRP(54) = dARP(36)/dV(69)
  JVRP(54) = 1
! JVRP(55) = dARP(37)/dV(69)
  JVRP(55) = V(98)
! JVRP(56) = dARP(37)/dV(98)
  JVRP(56) = V(69)
! JVRP(57) = dARP(38)/dV(54)
  JVRP(57) = V(55)
! JVRP(58) = dARP(38)/dV(55)
  JVRP(58) = V(54)
! JVRP(59) = dARP(39)/dV(54)
  JVRP(59) = V(98)
! JVRP(60) = dARP(39)/dV(98)
  JVRP(60) = V(54)
! JVRP(61) = dARP(40)/dV(98)
  JVRP(61) = V(105)
! JVRP(62) = dARP(40)/dV(105)
  JVRP(62) = V(98)
! JVRP(63) = dARP(41)/dV(98)
  JVRP(63) = 2*V(98)
! JVRP(64) = dARP(42)/dV(98)
  JVRP(64) = 2*V(98)
! JVRP(65) = dARP(43)/dV(98)
  JVRP(65) = V(106)
! JVRP(66) = dARP(43)/dV(106)
  JVRP(66) = V(98)
! JVRP(67) = dARP(44)/dV(105)
  JVRP(67) = V(106)
! JVRP(68) = dARP(44)/dV(106)
  JVRP(68) = V(105)
! JVRP(69) = dARP(45)/dV(69)
  JVRP(69) = V(105)
! JVRP(70) = dARP(45)/dV(105)
  JVRP(70) = V(69)
! JVRP(71) = dARP(46)/dV(103)
  JVRP(71) = V(105)
! JVRP(72) = dARP(46)/dV(105)
  JVRP(72) = V(103)
! JVRP(73) = dARP(47)/dV(98)
  JVRP(73) = V(103)
! JVRP(74) = dARP(47)/dV(103)
  JVRP(74) = V(98)
! JVRP(75) = dARP(48)/dV(103)
  JVRP(75) = V(106)
! JVRP(76) = dARP(48)/dV(106)
  JVRP(76) = V(103)
! JVRP(77) = dARP(49)/dV(96)
  JVRP(77) = V(103)
! JVRP(78) = dARP(49)/dV(103)
  JVRP(78) = V(96)
! JVRP(79) = dARP(50)/dV(103)
  JVRP(79) = 2*V(103)
! JVRP(80) = dARP(51)/dV(63)
  JVRP(80) = 1
! JVRP(81) = dARP(52)/dV(79)
  JVRP(81) = 1
! JVRP(82) = dARP(53)/dV(56)
  JVRP(82) = 1
! JVRP(83) = dARP(54)/dV(100)
  JVRP(83) = V(104)
! JVRP(84) = dARP(54)/dV(104)
  JVRP(84) = V(100)
! JVRP(85) = dARP(55)/dV(88)
  JVRP(85) = V(100)
! JVRP(86) = dARP(55)/dV(100)
  JVRP(86) = V(88)
! JVRP(87) = dARP(56)/dV(104)
  JVRP(87) = V(106)
! JVRP(88) = dARP(56)/dV(106)
  JVRP(88) = V(104)
! JVRP(89) = dARP(57)/dV(88)
  JVRP(89) = V(106)
! JVRP(90) = dARP(57)/dV(106)
  JVRP(90) = V(88)
! JVRP(91) = dARP(58)/dV(104)
  JVRP(91) = 2*V(104)
! JVRP(92) = dARP(59)/dV(88)
  JVRP(92) = 2*V(88)
! JVRP(93) = dARP(60)/dV(88)
  JVRP(93) = V(104)
! JVRP(94) = dARP(60)/dV(104)
  JVRP(94) = V(88)
! JVRP(95) = dARP(61)/dV(94)
  JVRP(95) = V(98)
! JVRP(96) = dARP(61)/dV(98)
  JVRP(96) = V(94)
! JVRP(97) = dARP(62)/dV(94)
  JVRP(97) = 1
! JVRP(98) = dARP(63)/dV(73)
  JVRP(98) = V(98)
! JVRP(99) = dARP(63)/dV(98)
  JVRP(99) = V(73)
! JVRP(100) = dARP(64)/dV(73)
  JVRP(100) = 1
! JVRP(101) = dARP(65)/dV(80)
  JVRP(101) = V(98)
! JVRP(102) = dARP(65)/dV(98)
  JVRP(102) = V(80)
! JVRP(103) = dARP(66)/dV(58)
  JVRP(103) = V(98)
! JVRP(104) = dARP(66)/dV(98)
  JVRP(104) = V(58)
! JVRP(105) = dARP(67)/dV(100)
  JVRP(105) = V(107)
! JVRP(106) = dARP(67)/dV(107)
  JVRP(106) = V(100)
! JVRP(107) = dARP(68)/dV(106)
  JVRP(107) = V(107)
! JVRP(108) = dARP(68)/dV(107)
  JVRP(108) = V(106)
! JVRP(109) = dARP(69)/dV(107)
  JVRP(109) = 2*V(107)
! JVRP(110) = dARP(70)/dV(78)
  JVRP(110) = V(98)
! JVRP(111) = dARP(70)/dV(98)
  JVRP(111) = V(78)
! JVRP(112) = dARP(71)/dV(78)
  JVRP(112) = 1
! JVRP(113) = dARP(72)/dV(68)
  JVRP(113) = V(98)
! JVRP(114) = dARP(72)/dV(98)
  JVRP(114) = V(68)
! JVRP(115) = dARP(73)/dV(95)
  JVRP(115) = V(98)
! JVRP(116) = dARP(73)/dV(98)
  JVRP(116) = V(95)
! JVRP(117) = dARP(74)/dV(95)
  JVRP(117) = 1
! JVRP(118) = dARP(75)/dV(95)
  JVRP(118) = 1
! JVRP(119) = dARP(76)/dV(95)
  JVRP(119) = V(105)
! JVRP(120) = dARP(76)/dV(105)
  JVRP(120) = V(95)
! JVRP(121) = dARP(77)/dV(95)
  JVRP(121) = V(103)
! JVRP(122) = dARP(77)/dV(103)
  JVRP(122) = V(95)
! JVRP(123) = dARP(78)/dV(95)
  JVRP(123) = V(106)
! JVRP(124) = dARP(78)/dV(106)
  JVRP(124) = V(95)
! JVRP(125) = dARP(79)/dV(71)
  JVRP(125) = 1
! JVRP(126) = dARP(80)/dV(71)
  JVRP(126) = V(100)
! JVRP(127) = dARP(80)/dV(100)
  JVRP(127) = V(71)
! JVRP(128) = dARP(81)/dV(71)
  JVRP(128) = V(106)
! JVRP(129) = dARP(81)/dV(106)
  JVRP(129) = V(71)
! JVRP(130) = dARP(82)/dV(61)
  JVRP(130) = V(98)
! JVRP(131) = dARP(82)/dV(98)
  JVRP(131) = V(61)
! JVRP(132) = dARP(83)/dV(93)
  JVRP(132) = V(105)
! JVRP(133) = dARP(83)/dV(105)
  JVRP(133) = V(93)
! JVRP(134) = dARP(84)/dV(93)
  JVRP(134) = V(98)
! JVRP(135) = dARP(84)/dV(98)
  JVRP(135) = V(93)
! JVRP(136) = dARP(85)/dV(93)
  JVRP(136) = V(103)
! JVRP(137) = dARP(85)/dV(103)
  JVRP(137) = V(93)
! JVRP(138) = dARP(86)/dV(93)
  JVRP(138) = 1
! JVRP(139) = dARP(87)/dV(97)
  JVRP(139) = V(100)
! JVRP(140) = dARP(87)/dV(100)
  JVRP(140) = V(97)
! JVRP(141) = dARP(88)/dV(97)
  JVRP(141) = V(101)
! JVRP(142) = dARP(88)/dV(101)
  JVRP(142) = V(97)
! JVRP(143) = dARP(89)/dV(51)
  JVRP(143) = 1
! JVRP(144) = dARP(90)/dV(51)
  JVRP(144) = 1
! JVRP(145) = dARP(91)/dV(97)
  JVRP(145) = V(106)
! JVRP(146) = dARP(91)/dV(106)
  JVRP(146) = V(97)
! JVRP(147) = dARP(92)/dV(97)
  JVRP(147) = V(107)
! JVRP(148) = dARP(92)/dV(107)
  JVRP(148) = V(97)
! JVRP(149) = dARP(93)/dV(97)
  JVRP(149) = V(104)
! JVRP(150) = dARP(93)/dV(104)
  JVRP(150) = V(97)
! JVRP(151) = dARP(94)/dV(97)
  JVRP(151) = 2*V(97)
! JVRP(152) = dARP(95)/dV(64)
  JVRP(152) = V(98)
! JVRP(153) = dARP(95)/dV(98)
  JVRP(153) = V(64)
! JVRP(154) = dARP(96)/dV(64)
  JVRP(154) = 1
! JVRP(155) = dARP(97)/dV(65)
  JVRP(155) = V(98)
! JVRP(156) = dARP(97)/dV(98)
  JVRP(156) = V(65)
! JVRP(157) = dARP(98)/dV(92)
  JVRP(157) = V(105)
! JVRP(158) = dARP(98)/dV(105)
  JVRP(158) = V(92)
! JVRP(159) = dARP(99)/dV(92)
  JVRP(159) = V(98)
! JVRP(160) = dARP(99)/dV(98)
  JVRP(160) = V(92)
! JVRP(161) = dARP(100)/dV(92)
  JVRP(161) = V(103)
! JVRP(162) = dARP(100)/dV(103)
  JVRP(162) = V(92)
! JVRP(163) = dARP(101)/dV(92)
  JVRP(163) = 1
! JVRP(164) = dARP(102)/dV(99)
  JVRP(164) = V(100)
! JVRP(165) = dARP(102)/dV(100)
  JVRP(165) = V(99)
! JVRP(166) = dARP(103)/dV(99)
  JVRP(166) = V(101)
! JVRP(167) = dARP(103)/dV(101)
  JVRP(167) = V(99)
! JVRP(168) = dARP(104)/dV(66)
  JVRP(168) = 1
! JVRP(169) = dARP(105)/dV(66)
  JVRP(169) = 1
! JVRP(170) = dARP(106)/dV(66)
  JVRP(170) = V(98)
! JVRP(171) = dARP(106)/dV(98)
  JVRP(171) = V(66)
! JVRP(172) = dARP(107)/dV(99)
  JVRP(172) = V(106)
! JVRP(173) = dARP(107)/dV(106)
  JVRP(173) = V(99)
! JVRP(174) = dARP(108)/dV(99)
  JVRP(174) = V(107)
! JVRP(175) = dARP(108)/dV(107)
  JVRP(175) = V(99)
! JVRP(176) = dARP(109)/dV(99)
  JVRP(176) = V(104)
! JVRP(177) = dARP(109)/dV(104)
  JVRP(177) = V(99)
! JVRP(178) = dARP(110)/dV(99)
  JVRP(178) = 2*V(99)
! JVRP(179) = dARP(111)/dV(97)
  JVRP(179) = V(99)
! JVRP(180) = dARP(111)/dV(99)
  JVRP(180) = V(97)
! JVRP(181) = dARP(112)/dV(89)
  JVRP(181) = V(98)
! JVRP(182) = dARP(112)/dV(98)
  JVRP(182) = V(89)
! JVRP(183) = dARP(113)/dV(82)
  JVRP(183) = 1
! JVRP(184) = dARP(114)/dV(82)
  JVRP(184) = 1
! JVRP(185) = dARP(115)/dV(82)
  JVRP(185) = V(101)
! JVRP(186) = dARP(115)/dV(101)
  JVRP(186) = V(82)
! JVRP(187) = dARP(116)/dV(87)
  JVRP(187) = V(105)
! JVRP(188) = dARP(116)/dV(105)
  JVRP(188) = V(87)
! JVRP(189) = dARP(117)/dV(87)
  JVRP(189) = V(98)
! JVRP(190) = dARP(117)/dV(98)
  JVRP(190) = V(87)
! JVRP(191) = dARP(118)/dV(87)
  JVRP(191) = V(96)
! JVRP(192) = dARP(118)/dV(96)
  JVRP(192) = V(87)
! JVRP(193) = dARP(119)/dV(87)
  JVRP(193) = V(103)
! JVRP(194) = dARP(119)/dV(103)
  JVRP(194) = V(87)
! JVRP(195) = dARP(120)/dV(83)
  JVRP(195) = V(105)
! JVRP(196) = dARP(120)/dV(105)
  JVRP(196) = V(83)
! JVRP(197) = dARP(121)/dV(83)
  JVRP(197) = V(98)
! JVRP(198) = dARP(121)/dV(98)
  JVRP(198) = V(83)
! JVRP(199) = dARP(122)/dV(83)
  JVRP(199) = V(96)
! JVRP(200) = dARP(122)/dV(96)
  JVRP(200) = V(83)
! JVRP(201) = dARP(123)/dV(83)
  JVRP(201) = V(103)
! JVRP(202) = dARP(123)/dV(103)
  JVRP(202) = V(83)
! JVRP(203) = dARP(124)/dV(86)
  JVRP(203) = V(105)
! JVRP(204) = dARP(124)/dV(105)
  JVRP(204) = V(86)
! JVRP(205) = dARP(125)/dV(86)
  JVRP(205) = V(98)
! JVRP(206) = dARP(125)/dV(98)
  JVRP(206) = V(86)
! JVRP(207) = dARP(126)/dV(86)
  JVRP(207) = V(96)
! JVRP(208) = dARP(126)/dV(96)
  JVRP(208) = V(86)
! JVRP(209) = dARP(127)/dV(86)
  JVRP(209) = V(103)
! JVRP(210) = dARP(127)/dV(103)
  JVRP(210) = V(86)
! JVRP(211) = dARP(128)/dV(53)
  JVRP(211) = V(98)
! JVRP(212) = dARP(128)/dV(98)
  JVRP(212) = V(53)
! JVRP(213) = dARP(129)/dV(62)
  JVRP(213) = V(100)
! JVRP(214) = dARP(129)/dV(100)
  JVRP(214) = V(62)
! JVRP(215) = dARP(130)/dV(62)
  JVRP(215) = 1
! JVRP(216) = dARP(131)/dV(84)
  JVRP(216) = V(98)
! JVRP(217) = dARP(131)/dV(98)
  JVRP(217) = V(84)
! JVRP(218) = dARP(132)/dV(84)
  JVRP(218) = V(103)
! JVRP(219) = dARP(132)/dV(103)
  JVRP(219) = V(84)
! JVRP(220) = dARP(133)/dV(74)
  JVRP(220) = V(101)
! JVRP(221) = dARP(133)/dV(101)
  JVRP(221) = V(74)
! JVRP(222) = dARP(134)/dV(74)
  JVRP(222) = V(106)
! JVRP(223) = dARP(134)/dV(106)
  JVRP(223) = V(74)
! JVRP(224) = dARP(135)/dV(81)
  JVRP(224) = 1
! JVRP(225) = dARP(136)/dV(81)
  JVRP(225) = V(98)
! JVRP(226) = dARP(136)/dV(98)
  JVRP(226) = V(81)
! JVRP(227) = dARP(137)/dV(81)
  JVRP(227) = V(96)
! JVRP(228) = dARP(137)/dV(96)
  JVRP(228) = V(81)
! JVRP(229) = dARP(138)/dV(57)
  JVRP(229) = V(98)
! JVRP(230) = dARP(138)/dV(98)
  JVRP(230) = V(57)
! JVRP(231) = dARP(139)/dV(76)
  JVRP(231) = V(98)
! JVRP(232) = dARP(139)/dV(98)
  JVRP(232) = V(76)
! JVRP(233) = dARP(140)/dV(76)
  JVRP(233) = 1
! JVRP(234) = dARP(141)/dV(90)
  JVRP(234) = V(105)
! JVRP(235) = dARP(141)/dV(105)
  JVRP(235) = V(90)
! JVRP(236) = dARP(142)/dV(90)
  JVRP(236) = V(98)
! JVRP(237) = dARP(142)/dV(98)
  JVRP(237) = V(90)
! JVRP(238) = dARP(143)/dV(90)
  JVRP(238) = V(96)
! JVRP(239) = dARP(143)/dV(96)
  JVRP(239) = V(90)
! JVRP(240) = dARP(144)/dV(90)
  JVRP(240) = V(103)
! JVRP(241) = dARP(144)/dV(103)
  JVRP(241) = V(90)
! JVRP(242) = dARP(145)/dV(91)
  JVRP(242) = V(98)
! JVRP(243) = dARP(145)/dV(98)
  JVRP(243) = V(91)
! JVRP(244) = dARP(146)/dV(91)
  JVRP(244) = V(96)
! JVRP(245) = dARP(146)/dV(96)
  JVRP(245) = V(91)
! JVRP(246) = dARP(147)/dV(91)
  JVRP(246) = V(103)
! JVRP(247) = dARP(147)/dV(103)
  JVRP(247) = V(91)
! JVRP(248) = dARP(148)/dV(91)
  JVRP(248) = 1
! JVRP(249) = dARP(149)/dV(85)
  JVRP(249) = V(105)
! JVRP(250) = dARP(149)/dV(105)
  JVRP(250) = V(85)
! JVRP(251) = dARP(150)/dV(85)
  JVRP(251) = V(98)
! JVRP(252) = dARP(150)/dV(98)
  JVRP(252) = V(85)
! JVRP(253) = dARP(151)/dV(85)
  JVRP(253) = V(96)
! JVRP(254) = dARP(151)/dV(96)
  JVRP(254) = V(85)
! JVRP(255) = dARP(152)/dV(85)
  JVRP(255) = V(103)
! JVRP(256) = dARP(152)/dV(103)
  JVRP(256) = V(85)
! JVRP(257) = dARP(153)/dV(50)
  JVRP(257) = V(98)
! JVRP(258) = dARP(153)/dV(98)
  JVRP(258) = V(50)
! JVRP(259) = dARP(154)/dV(70)
  JVRP(259) = V(98)
! JVRP(260) = dARP(154)/dV(98)
  JVRP(260) = V(70)
! JVRP(261) = dARP(155)/dV(67)
  JVRP(261) = V(98)
! JVRP(262) = dARP(155)/dV(98)
  JVRP(262) = V(67)
! JVRP(263) = dARP(156)/dV(90)
  JVRP(263) = V(101)
! JVRP(264) = dARP(156)/dV(101)
  JVRP(264) = V(90)
! JVRP(265) = dARP(157)/dV(49)
  JVRP(265) = 1
! JVRP(266) = dARP(158)/dV(52)
  JVRP(266) = 1
! JVRP(267) = dARP(159)/dV(96)
  JVRP(267) = V(102)
! JVRP(268) = dARP(159)/dV(102)
  JVRP(268) = V(96)
! JVRP(269) = dARP(160)/dV(75)
  JVRP(269) = 2*V(75)
! JVRP(270) = dARP(161)/dV(75)
  JVRP(270) = V(100)
! JVRP(271) = dARP(161)/dV(100)
  JVRP(271) = V(75)
! JVRP(272) = dARP(162)/dV(75)
  JVRP(272) = V(106)
! JVRP(273) = dARP(162)/dV(106)
  JVRP(273) = V(75)
! JVRP(274) = dARP(163)/dV(77)
  JVRP(274) = V(98)
! JVRP(275) = dARP(163)/dV(98)
  JVRP(275) = V(77)
! JVRP(276) = dARP(164)/dV(77)
  JVRP(276) = 1
! JVRP(277) = dARP(165)/dV(58)
  JVRP(277) = V(102)
! JVRP(278) = dARP(165)/dV(102)
  JVRP(278) = V(58)
! JVRP(279) = dARP(166)/dV(89)
  JVRP(279) = V(102)
! JVRP(280) = dARP(166)/dV(102)
  JVRP(280) = V(89)
! JVRP(281) = dARP(167)/dV(67)
  JVRP(281) = V(102)
! JVRP(282) = dARP(167)/dV(102)
  JVRP(282) = V(67)
! JVRP(283) = dARP(168)/dV(83)
  JVRP(283) = V(102)
! JVRP(284) = dARP(168)/dV(102)
  JVRP(284) = V(83)
! JVRP(285) = dARP(169)/dV(87)
  JVRP(285) = V(102)
! JVRP(286) = dARP(169)/dV(102)
  JVRP(286) = V(87)
! JVRP(287) = dARP(170)/dV(86)
  JVRP(287) = V(102)
! JVRP(288) = dARP(170)/dV(102)
  JVRP(288) = V(86)
! JVRP(289) = dARP(171)/dV(90)
  JVRP(289) = V(102)
! JVRP(290) = dARP(171)/dV(102)
  JVRP(290) = V(90)
! JVRP(291) = dARP(172)/dV(95)
  JVRP(291) = V(102)
! JVRP(292) = dARP(172)/dV(102)
  JVRP(292) = V(95)
! JVRP(293) = dARP(173)/dV(93)
  JVRP(293) = V(102)
! JVRP(294) = dARP(173)/dV(102)
  JVRP(294) = V(93)
! JVRP(295) = dARP(174)/dV(92)
  JVRP(295) = V(102)
! JVRP(296) = dARP(174)/dV(102)
  JVRP(296) = V(92)
! JVRP(297) = dARP(175)/dV(68)
  JVRP(297) = V(102)
! JVRP(298) = dARP(175)/dV(102)
  JVRP(298) = V(68)
! JVRP(299) = dARP(176)/dV(70)
  JVRP(299) = V(102)
! JVRP(300) = dARP(176)/dV(102)
  JVRP(300) = V(70)
! JVRP(301) = dARP(177)/dV(72)
  JVRP(301) = V(98)
! JVRP(302) = dARP(177)/dV(98)
  JVRP(302) = V(72)
! JVRP(303) = dARP(178)/dV(59)
  JVRP(303) = V(96)
! JVRP(304) = dARP(178)/dV(96)
  JVRP(304) = V(59)
! JVRP(305) = dARP(179)/dV(59)
  JVRP(305) = V(98)
! JVRP(306) = dARP(179)/dV(98)
  JVRP(306) = V(59)
! JVRP(307) = dARP(180)/dV(59)
  JVRP(307) = V(69)
! JVRP(308) = dARP(180)/dV(69)
  JVRP(308) = V(59)
! JVRP(309) = dARP(181)/dV(12)
  JVRP(309) = V(98)
! JVRP(310) = dARP(181)/dV(98)
  JVRP(310) = V(12)
! JVRP(311) = dARP(182)/dV(15)
  JVRP(311) = V(98)
! JVRP(312) = dARP(182)/dV(98)
  JVRP(312) = V(15)
! JVRP(313) = dARP(183)/dV(18)
  JVRP(313) = V(98)
! JVRP(314) = dARP(183)/dV(98)
  JVRP(314) = V(18)
! JVRP(315) = dARP(184)/dV(23)
  JVRP(315) = V(98)
! JVRP(316) = dARP(184)/dV(98)
  JVRP(316) = V(23)
! JVRP(317) = dARP(185)/dV(23)
  JVRP(317) = V(96)
! JVRP(318) = dARP(185)/dV(96)
  JVRP(318) = V(23)
! JVRP(319) = dARP(186)/dV(29)
  JVRP(319) = V(98)
! JVRP(320) = dARP(186)/dV(98)
  JVRP(320) = V(29)
! JVRP(321) = dARP(187)/dV(29)
  JVRP(321) = V(96)
! JVRP(322) = dARP(187)/dV(96)
  JVRP(322) = V(29)
! JVRP(323) = dARP(188)/dV(29)
  JVRP(323) = V(103)
! JVRP(324) = dARP(188)/dV(103)
  JVRP(324) = V(29)
! JVRP(325) = dARP(189)/dV(32)
  JVRP(325) = V(98)
! JVRP(326) = dARP(189)/dV(98)
  JVRP(326) = V(32)
! JVRP(327) = dARP(190)/dV(34)
  JVRP(327) = V(98)
! JVRP(328) = dARP(190)/dV(98)
  JVRP(328) = V(34)
! JVRP(329) = dARP(191)/dV(37)
  JVRP(329) = V(98)
! JVRP(330) = dARP(191)/dV(98)
  JVRP(330) = V(37)
! JVRP(331) = dARP(192)/dV(42)
  JVRP(331) = V(98)
! JVRP(332) = dARP(192)/dV(98)
  JVRP(332) = V(42)
! JVRP(333) = dARP(193)/dV(41)
  JVRP(333) = V(98)
! JVRP(334) = dARP(193)/dV(98)
  JVRP(334) = V(41)
! JVRP(335) = dARP(194)/dV(40)
  JVRP(335) = V(98)
! JVRP(336) = dARP(194)/dV(98)
  JVRP(336) = V(40)
! JVRP(337) = dARP(195)/dV(46)
  JVRP(337) = V(98)
! JVRP(338) = dARP(195)/dV(98)
  JVRP(338) = V(46)
! JVRP(339) = dARP(196)/dV(45)
  JVRP(339) = V(98)
! JVRP(340) = dARP(196)/dV(98)
  JVRP(340) = V(45)
! JVRP(341) = dARP(197)/dV(44)
  JVRP(341) = V(98)
! JVRP(342) = dARP(197)/dV(98)
  JVRP(342) = V(44)
! JVRP(343) = dARP(198)/dV(50)
  JVRP(343) = 1
      
END SUBROUTINE JacReactantProd

! End of JacReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



! Begin Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Fun with respect to rate coefficients
! -----------------------------------------------------------------------------

      SUBROUTINE  dFun_dRcoeff( V, F, NCOEFF, JCOEFF, DFDR )
       
      USE CB05TUCl_NCSU_Parameters
      USE CB05TUCl_NCSU_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/radical/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Fun(1:NVAR) / d RCT( JCOEFF(j) )
!         for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DFDR(NVAR*NCOEFF)

! Local vector with reactant products
      REAL(kind=dp) A_RPROD(NREACT)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the reactant products of all reactions     
      CALL ReactantProd ( V, F, A_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_RPROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DFDR(i+NVAR*(j-1)) = 0.0_dp 
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  reactant product  of the JCOEFF(j)-th reaction      
!                  give the j-th column of the derivative matrix   
         aj = A_RPROD(JCOEFF(j))
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DFDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dFun_dRcoeff

! End Derivative w.r.t. Rate Coefficients


! Begin Jacobian Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Jac with respect to rate coefficients
! Times a user vector
! -----------------------------------------------------------------------------

      SUBROUTINE  dJac_dRcoeff( V, F, U, NCOEFF, JCOEFF, DJDR )
       
      USE CB05TUCl_NCSU_Parameters
      USE CB05TUCl_NCSU_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! U - User-supplied Vector           
      REAL(kind=dp) U(NVAR)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Jac(1:NVAR) / d RCT( JCOEFF(j) ) * U
!                     for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DJDR(NVAR*NCOEFF)

! Local vector for Jacobian of reactant products
      REAL(kind=dp) JV_RPROD(NJVRP)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the Jacobian of all reactant products   
      CALL JacReactantProd( V, F, JV_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_PROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DJDR(i+NVAR*(j-1)) = 0.0_dp
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  ( Gradient of reactant product of the JCOEFF(j)-th reaction X user vector )    
!                  give the j-th column of the derivative matrix   
!
!          Row JCOEFF(j) of JV_RPROD times the user vector
         aj = 0.0_dp
         DO k=CROW_JVRP(JCOEFF(j)),CROW_JVRP(JCOEFF(j)+1)-1
             aj = aj + JV_RPROD(k)*U(ICOL_JVRP(k))
         END DO
!          Column JCOEFF(j) of Stoichiom. matrix times aj         
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DJDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dJac_dRcoeff

! End Jacobian Derivative w.r.t. Rate Coefficients


END MODULE CB05TUCl_NCSU_Stoichiom

