! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Linear Algebra Data and Routines File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CB05TUCl_NCSU_LinearAlgebra.f90
! Time                 : Thu Oct  8 08:21:46 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CB05TUCl_NCSU_13059_BOXMOX
! Equation file        : CB05TUCl_NCSU.kpp
! Output root filename : CB05TUCl_NCSU
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CB05TUCl_NCSU_LinearAlgebra

  USE CB05TUCl_NCSU_Parameters
  USE CB05TUCl_NCSU_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! SPARSE_UTIL - SPARSE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecomp( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05TUCl_NCSU_Parameters
  USE CB05TUCl_NCSU_JacobianSP

      INTEGER  :: IER
      REAL(kind=dp) :: JVS(LU_NONZERO), W(NVAR), a
      INTEGER  :: k, kk, j, jj

      a = 0. ! mz_rs_20050606
      IER = 0
      DO k=1,NVAR
        ! mz_rs_20050606: don't check if real value == 0
        ! IF ( JVS( LU_DIAG(k) ) .EQ. 0. ) THEN
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(a) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecomp


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplx( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization, complex
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05TUCl_NCSU_Parameters
  USE CB05TUCl_NCSU_JacobianSP

      INTEGER        :: IER
      DOUBLE COMPLEX :: JVS(LU_NONZERO), W(NVAR), a
      REAL(kind=dp)  :: b = 0.0
      INTEGER        :: k, kk, j, jj

      IER = 0
      DO k=1,NVAR
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(b) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecompCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplxR( JVSR, JVSI, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!    Sparse LU factorization, complex
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05TUCl_NCSU_Parameters
  USE CB05TUCl_NCSU_JacobianSP

      INTEGER       :: IER
      REAL(kind=dp) :: JVSR(LU_NONZERO), JVSI(LU_NONZERO) 
      REAL(kind=dp) :: WR(NVAR), WI(NVAR), ar, ai, den
      INTEGER       :: k, kk, j, jj

      IER = 0
      ar  = 0.0
      DO k=1,NVAR
        IF (  ( ABS(JVSR(LU_DIAG(k))) < TINY(ar) ) .AND. &
              ( ABS(JVSI(LU_DIAG(k))) < TINY(ar) ) )  THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              WR( LU_ICOL(kk) ) = JVSR(kk)
              WI( LU_ICOL(kk) ) = JVSI(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            den = JVSR(LU_DIAG(j))**2 + JVSI(LU_DIAG(j))**2
            ar = -(WR(j)*JVSR(LU_DIAG(j)) + WI(j)*JVSI(LU_DIAG(j)))/den
            ai = -(WI(j)*JVSR(LU_DIAG(j)) - WR(j)*JVSI(LU_DIAG(j)))/den
            WR(j) = -ar
            WI(j) = -ai
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               WR( LU_ICOL(jj) ) = WR( LU_ICOL(jj) ) + ar*JVSR(jj) - ai*JVSI(jj)
               WI( LU_ICOL(jj) ) = WI( LU_ICOL(jj) ) + ar*JVSI(jj) + ai*JVSR(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVSR(kk) = WR( LU_ICOL(kk) )
            JVSI(kk) = WI( LU_ICOL(kk) )
         END DO
      END DO

END SUBROUTINE KppDecompCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05TUCl_NCSU_Parameters
  USE CB05TUCl_NCSU_JacobianSP

      INTEGER  :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05TUCl_NCSU_Parameters
  USE CB05TUCl_NCSU_JacobianSP

      INTEGER       :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05TUCl_NCSU_Parameters
  USE CB05TUCl_NCSU_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveCmplx

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05TUCl_NCSU_Parameters
  USE CB05TUCl_NCSU_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), sumr, sumi, den

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             XR(i) = XR(i) - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
             XI(i) = XI(i) - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
         END DO  
      END DO

      DO i=NVAR,1,-1
        sumr = XR(i); sumi = XI(i)
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
            sumr = sumr - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
            sumi = sumi - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
        END DO
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (sumr*JVSR(LU_DIAG(i)) + sumi*JVSI(LU_DIAG(i)))/den
        XI(i) = (sumi*JVSR(LU_DIAG(i)) - sumr*JVSI(LU_DIAG(i)))/den
      END DO
      
END SUBROUTINE KppSolveCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05TUCl_NCSU_Parameters
  USE CB05TUCl_NCSU_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve transpose subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE CB05TUCl_NCSU_Parameters
  USE CB05TUCl_NCSU_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), den

      DO i=1,NVAR
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (XR(i)*JVSR(LU_DIAG(i)) + XI(i)*JVSI(LU_DIAG(i)))/den
        XI(i) = (XI(i)*JVSR(LU_DIAG(i)) - XR(i)*JVSI(LU_DIAG(i)))/den
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplxR


!
! Next few commented subroutines perform sparse big linear algebra
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppDecompBig( JVS, IP, IER )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse LU factorization
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE CB05TUCl_NCSU_Parameters
!  USE CB05TUCl_NCSU_JacobianSP
!
!      INTEGER  :: IP3(3), IER, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), W(3,3,NVAR), a(3,3), E(3,3)
!      INTEGER  :: k, kk, j, jj
!
!      a = 0.0d0
!      IER = 0
!      DO k=1,NVAR
!        DO kk = LU_CROW(k), LU_CROW(k+1)-1
!              W( 1:3,1:3,LU_ICOL(kk) ) = JVS(1:3,1:3,kk)
!        END DO
!        DO kk = LU_CROW(k), LU_DIAG(k)-1
!            j = LU_ICOL(kk)
!            E(1:3,1:3) = JVS( 1:3,1:3,LU_DIAG(j) )
!            ! CALL DGETRF(3,3,E,3,IP3,IER) 
!            CALL FAC3(E,IP3,IER)
!            IF ( IER /= 0 )  RETURN
!            ! a = W(j) / JVS( LU_DIAG(j) )
!            a(1:3,1:3) = W( 1:3,1:3,j )
!            ! CALL DGETRS ('N',3,3,E,3,IP3,a,3,IER) 
!            CALL SOL3('N',E,IP3,a(1,1))
!            CALL SOL3('N',E,IP3,a(1,2))
!            CALL SOL3('N',E,IP3,a(1,3))
!            W(1:3,1:3,j) = a(1:3,1:3)
!            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
!               W( 1:3,1:3,LU_ICOL(jj) ) = W( 1:3,1:3,LU_ICOL(jj) ) &
!                        - MATMUL( a(1:3,1:3) , JVS(1:3,1:3,jj) )
!            END DO
!         END DO
!         DO kk = LU_CROW(k), LU_CROW(k+1)-1
!            JVS(1:3,1:3,kk) = W( 1:3,1:3,LU_ICOL(kk) )
!         END DO
!      END DO
!
!      DO k=1,NVAR
!         ! CALL WGEFA(JVS(1,1,LU_DIAG(k)),3,3,IP(1,k),IER)
!         ! CALL DGETRF(3,3,JVS(1,1,LU_DIAG(k)),3,IP(1,k),IER)
!         CALL FAC3(JVS(1,1,LU_DIAG(k)),IP(1,k),IER)
!         IF ( IER /= 0 )  RETURN
!      END DO 
!      
!END SUBROUTINE KppDecompBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBig( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse solve subroutine using indirect addressing
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE CB05TUCl_NCSU_Parameters
!  USE CB05TUCl_NCSU_JacobianSP
!
!      INTEGER  :: i, j, k, m, IP3(3), IP(3,NVAR), IER
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR), sum(3)
!
!      DO i=1,NVAR
!        DO j = LU_CROW(i), LU_DIAG(i)-1 
!          !X(1:3,i) = X(1:3,i) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       X(k,i) = X(k,i) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO  
!      END DO
!
!      DO i=NVAR,1,-1
!        sum(1:3) = X(1:3,i);
!        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
!          !sum(1:3) = sum(1:3) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       sum(k) = sum(k) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO
!        ! X(i) = sum/JVS(LU_DIAG(i));
!        ! CALL DGETRS ('N',3,1,JVS(1:3,1:3,LU_DIAG(i)),3,IP(1,i),sum,3,0) 
!        ! CALL WGESL('N',JVS(1,1,LU_DIAG(i)),3,3,IP(1,i),sum)
!        CALL SOL3('N',JVS(1,1,LU_DIAG(i)),IP(1,i),sum)
!        X(1:3,i) = sum(1:3)
!      END DO
!      
!END SUBROUTINE KppSolveBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBigTR( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Big sparse transpose solve using indirect addressing
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE CB05TUCl_NCSU_Parameters
!  USE CB05TUCl_NCSU_JacobianSP
!
!      INTEGER       :: i, j, k, m, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR)
!
!      DO i=1,NVAR
!        ! X(i) = X(i)/JVS(LU_DIAG(i))
!        CALL SOL3('T',JVS(1,1,LU_DIAG(i)),IP(1,i),X(1,i))
!        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !    - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!
!      DO i=NVAR, 1, -1
!        DO j=LU_CROW(i),LU_DIAG(i)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !   - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!      
!END SUBROUTINE KppSolveBigTR
!
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE FAC3(A,IPVT,INFO)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     FAC3 FACTORS THE MATRIX A (3,3) BY
!!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!!     LINPACK - LIKE 
!!
!!     Remove comments to perform pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!
!      REAL(kind=dp) :: A(3,3)
!      INTEGER       :: IPVT(3),INFO
!!      INTEGER       :: L
!!      REAL(kind=dp) :: t, dmax, da, TMP(3)
!      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0
!
!      info = 0
!!      t = TINY(da)
!!      
!!      da = ABS(A(1,1)); L = 1
!!      IF ( ABS(A(2,1))>da ) THEN
!!        da = ABS(A(2,1)); L = 2
!!        IF ( ABS(A(3,1))>da ) THEN
!!          L = 3
!!        END IF  
!!      END IF  
!!      IPVT(1)  = L
!!      IF (L /=1 ) THEN
!!         TMP(1:3) = A(L,1:3)
!!         A(L,1:3) = A(1,1:3)
!!         A(1,1:3) = TMP(1:3)
!!      END IF
!!      IF (ABS(A(1,1)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!
!      A(2,1) = A(2,1)/A(1,1)
!      A(2,2) = A(2,2) - A(2,1)*A(1,2)
!      A(2,3) = A(2,3) - A(2,1)*A(1,3)
!      A(3,1) = A(3,1)/A(1,1)
!      A(3,2) = A(3,2) - A(3,1)*A(1,2)
!      A(3,3) = A(3,3) - A(3,1)*A(1,3)
!      
!!      IPVT(2)  = 2
!!      IF (ABS(A(3,2))>ABS(A(2,2))) THEN
!!         IPVT(2)  = 3
!!         TMP(2:3) = A(3,2:3)
!!         A(3,2:3) = A(2,2:3)
!!         A(2,2:3) = TMP(2:3)
!!      END IF
!!      IF (ABS(A(2,2)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!      
!      A(3,2)   = A(3,2)/A(2,2)
!      A(3,3)   = A(3,3) - A(3,2)*A(2,3)
!      IPVT(3)  = 3
!      
!END SUBROUTINE FAC3
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE SOL3(Trans,A,IPVT,b)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     SOL3 solves the system 3x3
!!     A * x = b  or  trans(a) * x = b
!!     using the factors computed by WGEFA.
!!
!!     Trans      = 'N'   to solve  A*x = b ,
!!                = 'T'   to solve  transpose(A)*x = b
!!     LINPACK - LIKE 
!!
!!     Remove comments to use pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!      CHARACTER     :: Trans
!      REAL(kind=dp) :: a(3,3),b(3)
!      INTEGER       :: IPVT(3)
!!      INTEGER       :: L
!!      REAL(kind=dp) :: TMP
!      
!      SELECT CASE (Trans)
!
!      CASE ('n','N')  !  Solve  A * x = b
!
!!     Solve  L*y = b
!!         L = IPVT(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!         b(2) = b(2)-A(2,1)*b(1)
!         b(3) = b(3)-A(3,1)*b(1)
!         
!!         L = IPVT(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(3) = b(3)-A(3,2)*b(2)
!
!!     Solve  U*x = y
!         b(3) = b(3)/A(3,3)
!         b(2) = (b(2)-A(2,3)*b(3))/A(2,2)
!         b(1) = (b(1)-A(1,3)*b(3)-A(1,2)*b(2))/A(1,1)
!      
!      
!      CASE ('t','T')  !  Solve transpose(A) * x = b
!
!!      Solve transpose(U)*y = b
!         b(1) = b(1)/A(1,1)
!         b(2) = (b(2)-A(1,2)*b(1))/A(2,2)
!         b(3) = (b(3)-A(1,3)*b(1)-A(2,3)*b(2))/A(3,3)
!
!!      Solve transpose(L)*x = y
!         b(2) = b(2)-A(3,2)*b(3)
!!         L = ipvt(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(1) = b(1)-A(3,1)*b(3)-A(2,1)*b(2)
!!         L = ipvt(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!   
!      END SELECT
!
!END SUBROUTINE SOL3

! End of SPARSE_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolve - sparse back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolve ( JVS, X )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)

  X(55) = X(55)-JVS(186)*X(54)
  X(62) = X(62)-JVS(212)*X(53)-JVS(213)*X(57)
  X(69) = X(69)-JVS(244)*X(59)
  X(72) = X(72)-JVS(257)*X(58)-JVS(258)*X(67)-JVS(259)*X(68)-JVS(260)*X(70)
  X(76) = X(76)-JVS(287)*X(57)
  X(78) = X(78)-JVS(300)*X(71)
  X(79) = X(79)-JVS(307)*X(56)
  X(80) = X(80)-JVS(319)*X(76)-JVS(320)*X(77)
  X(81) = X(81)-JVS(337)*X(62)
  X(84) = X(84)-JVS(354)*X(53)-JVS(355)*X(57)-JVS(356)*X(62)-JVS(357)*X(74)
  X(87) = X(87)-JVS(375)*X(86)
  X(88) = X(88)-JVS(382)*X(67)-JVS(383)*X(82)-JVS(384)*X(85)-JVS(385)*X(87)
  X(89) = X(89)-JVS(398)*X(57)-JVS(399)*X(82)-JVS(400)*X(85)-JVS(401)*X(86)-JVS(402)*X(87)
  X(91) = X(91)-JVS(420)*X(90)
  X(92) = X(92)-JVS(428)*X(70)-JVS(429)*X(73)-JVS(430)*X(81)-JVS(431)*X(82)-JVS(432)*X(83)-JVS(433)*X(84)-JVS(434)*X(85)&
            &-JVS(435)*X(86)-JVS(436)*X(87)-JVS(437)*X(88)-JVS(438)*X(89)-JVS(439)*X(90)-JVS(440)*X(91)
  X(93) = X(93)-JVS(452)*X(66)-JVS(453)*X(67)-JVS(454)*X(70)-JVS(455)*X(73)-JVS(456)*X(82)-JVS(457)*X(86)-JVS(458)*X(87)&
            &-JVS(459)*X(88)-JVS(460)*X(89)-JVS(461)*X(90)-JVS(462)*X(91)
  X(94) = X(94)-JVS(477)*X(62)-JVS(478)*X(74)-JVS(479)*X(82)-JVS(480)*X(84)-JVS(481)*X(85)-JVS(482)*X(88)-JVS(483)*X(89)&
            &-JVS(484)*X(90)-JVS(485)*X(91)
  X(95) = X(95)-JVS(496)*X(68)-JVS(497)*X(70)-JVS(498)*X(71)-JVS(499)*X(78)-JVS(500)*X(81)-JVS(501)*X(83)-JVS(502)*X(84)&
            &-JVS(503)*X(85)-JVS(504)*X(86)-JVS(505)*X(87)-JVS(506)*X(90)-JVS(507)*X(91)-JVS(508)*X(94)
  X(96) = X(96)-JVS(522)*X(59)-JVS(523)*X(69)-JVS(524)*X(81)-JVS(525)*X(83)-JVS(526)*X(84)-JVS(527)*X(85)-JVS(528)*X(86)&
            &-JVS(529)*X(87)-JVS(530)*X(90)-JVS(531)*X(91)
  X(97) = X(97)-JVS(542)*X(51)-JVS(543)*X(64)-JVS(544)*X(76)-JVS(545)*X(81)-JVS(546)*X(84)-JVS(547)*X(91)-JVS(548)*X(93)&
            &-JVS(549)*X(94)-JVS(550)*X(96)
  X(98) = X(98)-JVS(562)*X(50)-JVS(563)*X(52)-JVS(564)*X(53)-JVS(565)*X(54)-JVS(566)*X(55)-JVS(567)*X(57)-JVS(568)*X(58)&
            &-JVS(569)*X(59)-JVS(570)*X(60)-JVS(571)*X(61)-JVS(572)*X(63)-JVS(573)*X(64)-JVS(574)*X(65)-JVS(575)*X(66)&
            &-JVS(576)*X(67)-JVS(577)*X(68)-JVS(578)*X(69)-JVS(579)*X(70)-JVS(580)*X(71)-JVS(581)*X(72)-JVS(582)*X(73)&
            &-JVS(583)*X(75)-JVS(584)*X(76)-JVS(585)*X(77)-JVS(586)*X(78)-JVS(587)*X(79)-JVS(588)*X(80)-JVS(589)*X(81)&
            &-JVS(590)*X(83)-JVS(591)*X(84)-JVS(592)*X(85)-JVS(593)*X(86)-JVS(594)*X(87)-JVS(595)*X(88)-JVS(596)*X(89)&
            &-JVS(597)*X(90)-JVS(598)*X(91)-JVS(599)*X(92)-JVS(600)*X(93)-JVS(601)*X(94)-JVS(602)*X(95)-JVS(603)*X(96)&
            &-JVS(604)*X(97)
  X(99) = X(99)-JVS(615)*X(66)-JVS(616)*X(85)-JVS(617)*X(90)-JVS(618)*X(91)-JVS(619)*X(92)-JVS(620)*X(94)-JVS(621)*X(96)&
            &-JVS(622)*X(97)-JVS(623)*X(98)
  X(100) = X(100)-JVS(633)*X(60)-JVS(634)*X(62)-JVS(635)*X(71)-JVS(636)*X(75)-JVS(637)*X(88)-JVS(638)*X(89)-JVS(639)&
             &*X(90)-JVS(640)*X(91)-JVS(641)*X(94)-JVS(642)*X(95)-JVS(643)*X(96)-JVS(644)*X(97)-JVS(645)*X(98)-JVS(646)&
             &*X(99)
  X(101) = X(101)-JVS(655)*X(51)-JVS(656)*X(56)-JVS(657)*X(60)-JVS(658)*X(62)-JVS(659)*X(63)-JVS(660)*X(66)-JVS(661)&
             &*X(71)-JVS(662)*X(74)-JVS(663)*X(75)-JVS(664)*X(79)-JVS(665)*X(82)-JVS(666)*X(83)-JVS(667)*X(84)-JVS(668)&
             &*X(85)-JVS(669)*X(86)-JVS(670)*X(87)-JVS(671)*X(89)-JVS(672)*X(90)-JVS(673)*X(91)-JVS(674)*X(92)-JVS(675)&
             &*X(93)-JVS(676)*X(94)-JVS(677)*X(95)-JVS(678)*X(96)-JVS(679)*X(97)-JVS(680)*X(98)-JVS(681)*X(99)-JVS(682)&
             &*X(100)
  X(102) = X(102)-JVS(690)*X(49)-JVS(691)*X(52)-JVS(692)*X(58)-JVS(693)*X(67)-JVS(694)*X(68)-JVS(695)*X(70)-JVS(696)&
             &*X(72)-JVS(697)*X(75)-JVS(698)*X(77)-JVS(699)*X(83)-JVS(700)*X(86)-JVS(701)*X(87)-JVS(702)*X(89)-JVS(703)&
             &*X(90)-JVS(704)*X(91)-JVS(705)*X(92)-JVS(706)*X(93)-JVS(707)*X(94)-JVS(708)*X(95)-JVS(709)*X(96)-JVS(710)&
             &*X(97)-JVS(711)*X(98)-JVS(712)*X(99)-JVS(713)*X(100)-JVS(714)*X(101)
  X(103) = X(103)-JVS(721)*X(56)-JVS(722)*X(63)-JVS(723)*X(79)-JVS(724)*X(83)-JVS(725)*X(84)-JVS(726)*X(85)-JVS(727)&
             &*X(86)-JVS(728)*X(87)-JVS(729)*X(90)-JVS(730)*X(91)-JVS(731)*X(92)-JVS(732)*X(93)-JVS(733)*X(94)-JVS(734)&
             &*X(95)-JVS(735)*X(96)-JVS(736)*X(97)-JVS(737)*X(98)-JVS(738)*X(99)-JVS(739)*X(100)-JVS(740)*X(101)-JVS(741)&
             &*X(102)
  X(104) = X(104)-JVS(747)*X(53)-JVS(748)*X(57)-JVS(749)*X(67)-JVS(750)*X(70)-JVS(751)*X(73)-JVS(752)*X(76)-JVS(753)&
             &*X(78)-JVS(754)*X(81)-JVS(755)*X(82)-JVS(756)*X(83)-JVS(757)*X(84)-JVS(758)*X(85)-JVS(759)*X(86)-JVS(760)&
             &*X(87)-JVS(761)*X(88)-JVS(762)*X(89)-JVS(763)*X(90)-JVS(764)*X(91)-JVS(765)*X(94)-JVS(766)*X(95)-JVS(767)&
             &*X(96)-JVS(768)*X(97)-JVS(769)*X(98)-JVS(770)*X(99)-JVS(771)*X(100)-JVS(772)*X(101)-JVS(773)*X(102)-JVS(774)&
             &*X(103)
  X(105) = X(105)-JVS(779)*X(55)-JVS(780)*X(69)-JVS(781)*X(83)-JVS(782)*X(85)-JVS(783)*X(86)-JVS(784)*X(87)-JVS(785)&
             &*X(90)-JVS(786)*X(92)-JVS(787)*X(93)-JVS(788)*X(94)-JVS(789)*X(95)-JVS(790)*X(96)-JVS(791)*X(97)-JVS(792)&
             &*X(98)-JVS(793)*X(99)-JVS(794)*X(100)-JVS(795)*X(101)-JVS(796)*X(102)-JVS(797)*X(103)-JVS(798)*X(104)
  X(106) = X(106)-JVS(802)*X(50)-JVS(803)*X(53)-JVS(804)*X(54)-JVS(805)*X(55)-JVS(806)*X(57)-JVS(807)*X(61)-JVS(808)&
             &*X(62)-JVS(809)*X(63)-JVS(810)*X(67)-JVS(811)*X(68)-JVS(812)*X(69)-JVS(813)*X(70)-JVS(814)*X(71)-JVS(815)&
             &*X(73)-JVS(816)*X(74)-JVS(817)*X(75)-JVS(818)*X(76)-JVS(819)*X(77)-JVS(820)*X(78)-JVS(821)*X(80)-JVS(822)&
             &*X(81)-JVS(823)*X(82)-JVS(824)*X(83)-JVS(825)*X(84)-JVS(826)*X(85)-JVS(827)*X(86)-JVS(828)*X(87)-JVS(829)&
             &*X(88)-JVS(830)*X(89)-JVS(831)*X(90)-JVS(832)*X(91)-JVS(833)*X(92)-JVS(834)*X(93)-JVS(835)*X(94)-JVS(836)&
             &*X(95)-JVS(837)*X(96)-JVS(838)*X(97)-JVS(839)*X(98)-JVS(840)*X(99)-JVS(841)*X(100)-JVS(842)*X(101)-JVS(843)&
             &*X(102)-JVS(844)*X(103)-JVS(845)*X(104)-JVS(846)*X(105)
  X(107) = X(107)-JVS(849)*X(58)-JVS(850)*X(64)-JVS(851)*X(65)-JVS(852)*X(78)-JVS(853)*X(92)-JVS(854)*X(93)-JVS(855)&
             &*X(94)-JVS(856)*X(95)-JVS(857)*X(96)-JVS(858)*X(97)-JVS(859)*X(98)-JVS(860)*X(99)-JVS(861)*X(100)-JVS(862)&
             &*X(101)-JVS(863)*X(102)-JVS(864)*X(103)-JVS(865)*X(104)-JVS(866)*X(105)-JVS(867)*X(106)
  X(107) = X(107)/JVS(868)
  X(106) = (X(106)-JVS(848)*X(107))/(JVS(847))
  X(105) = (X(105)-JVS(800)*X(106)-JVS(801)*X(107))/(JVS(799))
  X(104) = (X(104)-JVS(776)*X(105)-JVS(777)*X(106)-JVS(778)*X(107))/(JVS(775))
  X(103) = (X(103)-JVS(743)*X(104)-JVS(744)*X(105)-JVS(745)*X(106)-JVS(746)*X(107))/(JVS(742))
  X(102) = (X(102)-JVS(716)*X(103)-JVS(717)*X(104)-JVS(718)*X(105)-JVS(719)*X(106)-JVS(720)*X(107))/(JVS(715))
  X(101) = (X(101)-JVS(684)*X(102)-JVS(685)*X(103)-JVS(686)*X(104)-JVS(687)*X(105)-JVS(688)*X(106)-JVS(689)*X(107))&
             &/(JVS(683))
  X(100) = (X(100)-JVS(648)*X(101)-JVS(649)*X(102)-JVS(650)*X(103)-JVS(651)*X(104)-JVS(652)*X(105)-JVS(653)*X(106)&
             &-JVS(654)*X(107))/(JVS(647))
  X(99) = (X(99)-JVS(625)*X(100)-JVS(626)*X(101)-JVS(627)*X(102)-JVS(628)*X(103)-JVS(629)*X(104)-JVS(630)*X(105)&
            &-JVS(631)*X(106)-JVS(632)*X(107))/(JVS(624))
  X(98) = (X(98)-JVS(606)*X(99)-JVS(607)*X(100)-JVS(608)*X(101)-JVS(609)*X(102)-JVS(610)*X(103)-JVS(611)*X(104)-JVS(612)&
            &*X(105)-JVS(613)*X(106)-JVS(614)*X(107))/(JVS(605))
  X(97) = (X(97)-JVS(552)*X(98)-JVS(553)*X(99)-JVS(554)*X(100)-JVS(555)*X(101)-JVS(556)*X(102)-JVS(557)*X(103)-JVS(558)&
            &*X(104)-JVS(559)*X(105)-JVS(560)*X(106)-JVS(561)*X(107))/(JVS(551))
  X(96) = (X(96)-JVS(533)*X(97)-JVS(534)*X(98)-JVS(535)*X(99)-JVS(536)*X(100)-JVS(537)*X(101)-JVS(538)*X(102)-JVS(539)&
            &*X(103)-JVS(540)*X(105)-JVS(541)*X(106))/(JVS(532))
  X(95) = (X(95)-JVS(510)*X(96)-JVS(511)*X(97)-JVS(512)*X(98)-JVS(513)*X(99)-JVS(514)*X(100)-JVS(515)*X(101)-JVS(516)&
            &*X(102)-JVS(517)*X(103)-JVS(518)*X(104)-JVS(519)*X(105)-JVS(520)*X(106)-JVS(521)*X(107))/(JVS(509))
  X(94) = (X(94)-JVS(487)*X(96)-JVS(488)*X(98)-JVS(489)*X(100)-JVS(490)*X(101)-JVS(491)*X(102)-JVS(492)*X(103)-JVS(493)&
            &*X(104)-JVS(494)*X(105)-JVS(495)*X(106))/(JVS(486))
  X(93) = (X(93)-JVS(464)*X(94)-JVS(465)*X(96)-JVS(466)*X(97)-JVS(467)*X(98)-JVS(468)*X(99)-JVS(469)*X(100)-JVS(470)&
            &*X(101)-JVS(471)*X(102)-JVS(472)*X(103)-JVS(473)*X(104)-JVS(474)*X(105)-JVS(475)*X(106)-JVS(476)*X(107))&
            &/(JVS(463))
  X(92) = (X(92)-JVS(442)*X(94)-JVS(443)*X(96)-JVS(444)*X(98)-JVS(445)*X(100)-JVS(446)*X(101)-JVS(447)*X(102)-JVS(448)&
            &*X(103)-JVS(449)*X(104)-JVS(450)*X(105)-JVS(451)*X(106))/(JVS(441))
  X(91) = (X(91)-JVS(422)*X(96)-JVS(423)*X(98)-JVS(424)*X(101)-JVS(425)*X(102)-JVS(426)*X(103)-JVS(427)*X(105))&
            &/(JVS(421))
  X(90) = (X(90)-JVS(414)*X(96)-JVS(415)*X(98)-JVS(416)*X(101)-JVS(417)*X(102)-JVS(418)*X(103)-JVS(419)*X(105))&
            &/(JVS(413))
  X(89) = (X(89)-JVS(404)*X(90)-JVS(405)*X(91)-JVS(406)*X(94)-JVS(407)*X(96)-JVS(408)*X(98)-JVS(409)*X(101)-JVS(410)&
            &*X(102)-JVS(411)*X(103)-JVS(412)*X(105))/(JVS(403))
  X(88) = (X(88)-JVS(387)*X(89)-JVS(388)*X(90)-JVS(389)*X(96)-JVS(390)*X(98)-JVS(391)*X(100)-JVS(392)*X(101)-JVS(393)&
            &*X(102)-JVS(394)*X(103)-JVS(395)*X(104)-JVS(396)*X(105)-JVS(397)*X(106))/(JVS(386))
  X(87) = (X(87)-JVS(377)*X(96)-JVS(378)*X(98)-JVS(379)*X(102)-JVS(380)*X(103)-JVS(381)*X(105))/(JVS(376))
  X(86) = (X(86)-JVS(370)*X(96)-JVS(371)*X(98)-JVS(372)*X(102)-JVS(373)*X(103)-JVS(374)*X(105))/(JVS(369))
  X(85) = (X(85)-JVS(365)*X(96)-JVS(366)*X(98)-JVS(367)*X(103)-JVS(368)*X(105))/(JVS(364))
  X(84) = (X(84)-JVS(359)*X(98)-JVS(360)*X(100)-JVS(361)*X(101)-JVS(362)*X(103)-JVS(363)*X(106))/(JVS(358))
  X(83) = (X(83)-JVS(349)*X(96)-JVS(350)*X(98)-JVS(351)*X(102)-JVS(352)*X(103)-JVS(353)*X(105))/(JVS(348))
  X(82) = (X(82)-JVS(344)*X(89)-JVS(345)*X(98)-JVS(346)*X(101)-JVS(347)*X(102))/(JVS(343))
  X(81) = (X(81)-JVS(339)*X(84)-JVS(340)*X(96)-JVS(341)*X(98)-JVS(342)*X(100))/(JVS(338))
  X(80) = (X(80)-JVS(322)*X(81)-JVS(323)*X(83)-JVS(324)*X(85)-JVS(325)*X(86)-JVS(326)*X(87)-JVS(327)*X(90)-JVS(328)&
            &*X(91)-JVS(329)*X(92)-JVS(330)*X(93)-JVS(331)*X(95)-JVS(332)*X(96)-JVS(333)*X(98)-JVS(334)*X(102)-JVS(335)&
            &*X(103)-JVS(336)*X(105))/(JVS(321))
  X(79) = (X(79)-JVS(309)*X(84)-JVS(310)*X(91)-JVS(311)*X(92)-JVS(312)*X(93)-JVS(313)*X(94)-JVS(314)*X(95)-JVS(315)&
            &*X(98)-JVS(316)*X(101)-JVS(317)*X(103)-JVS(318)*X(106))/(JVS(308))
  X(78) = (X(78)-JVS(302)*X(95)-JVS(303)*X(98)-JVS(304)*X(100)-JVS(305)*X(106)-JVS(306)*X(107))/(JVS(301))
  X(77) = (X(77)-JVS(294)*X(83)-JVS(295)*X(86)-JVS(296)*X(87)-JVS(297)*X(90)-JVS(298)*X(98)-JVS(299)*X(102))/(JVS(293))
  X(76) = (X(76)-JVS(289)*X(81)-JVS(290)*X(91)-JVS(291)*X(96)-JVS(292)*X(98))/(JVS(288))
  X(75) = (X(75)-JVS(283)*X(96)-JVS(284)*X(100)-JVS(285)*X(102)-JVS(286)*X(106))/(JVS(282))
  X(74) = (X(74)-JVS(277)*X(84)-JVS(278)*X(98)-JVS(279)*X(101)-JVS(280)*X(103)-JVS(281)*X(106))/(JVS(276))
  X(73) = (X(73)-JVS(272)*X(88)-JVS(273)*X(98)-JVS(274)*X(104)-JVS(275)*X(106))/(JVS(271))
  X(72) = (X(72)-JVS(262)*X(86)-JVS(263)*X(89)-JVS(264)*X(90)-JVS(265)*X(92)-JVS(266)*X(93)-JVS(267)*X(95)-JVS(268)&
            &*X(98)-JVS(269)*X(102)-JVS(270)*X(107))/(JVS(261))
  X(71) = (X(71)-JVS(254)*X(95)-JVS(255)*X(100)-JVS(256)*X(106))/(JVS(253))
  X(70) = (X(70)-JVS(251)*X(98)-JVS(252)*X(102))/(JVS(250))
  X(69) = (X(69)-JVS(246)*X(96)-JVS(247)*X(98)-JVS(248)*X(105)-JVS(249)*X(106))/(JVS(245))
  X(68) = (X(68)-JVS(241)*X(98)-JVS(242)*X(102)-JVS(243)*X(107))/(JVS(240))
  X(67) = (X(67)-JVS(238)*X(98)-JVS(239)*X(102))/(JVS(237))
  X(66) = (X(66)-JVS(234)*X(98)-JVS(235)*X(99)-JVS(236)*X(101))/(JVS(233))
  X(65) = (X(65)-JVS(227)*X(97)-JVS(228)*X(98)-JVS(229)*X(99)-JVS(230)*X(104)-JVS(231)*X(106)-JVS(232)*X(107))&
            &/(JVS(226))
  X(64) = (X(64)-JVS(222)*X(97)-JVS(223)*X(98)-JVS(224)*X(99)-JVS(225)*X(106))/(JVS(221))
  X(63) = (X(63)-JVS(218)*X(98)-JVS(219)*X(101)-JVS(220)*X(106))/(JVS(217))
  X(62) = (X(62)-JVS(215)*X(98)-JVS(216)*X(100))/(JVS(214))
  X(61) = (X(61)-JVS(207)*X(71)-JVS(208)*X(83)-JVS(209)*X(96)-JVS(210)*X(98)-JVS(211)*X(100))/(JVS(206))
  X(60) = (X(60)-JVS(203)*X(98)-JVS(204)*X(100)-JVS(205)*X(101))/(JVS(202))
  X(59) = (X(59)-JVS(199)*X(69)-JVS(200)*X(96)-JVS(201)*X(98))/(JVS(198))
  X(58) = (X(58)-JVS(196)*X(98)-JVS(197)*X(102))/(JVS(195))
  X(57) = (X(57)-JVS(194)*X(98))/(JVS(193))
  X(56) = (X(56)-JVS(191)*X(101)-JVS(192)*X(103))/(JVS(190))
  X(55) = (X(55)-JVS(188)*X(96)-JVS(189)*X(98))/(JVS(187))
  X(54) = (X(54)-JVS(184)*X(55)-JVS(185)*X(98))/(JVS(183))
  X(53) = (X(53)-JVS(182)*X(98))/(JVS(181))
  X(52) = (X(52)-JVS(179)*X(75)-JVS(180)*X(106))/(JVS(178))
  X(51) = (X(51)-JVS(176)*X(97)-JVS(177)*X(101))/(JVS(175))
  X(50) = (X(50)-JVS(174)*X(98))/(JVS(173))
  X(49) = (X(49)-JVS(172)*X(75))/(JVS(171))
  X(48) = (X(48)-JVS(148)*X(53)-JVS(149)*X(57)-JVS(150)*X(61)-JVS(151)*X(64)-JVS(152)*X(65)-JVS(153)*X(67)-JVS(154)&
            &*X(68)-JVS(155)*X(70)-JVS(156)*X(76)-JVS(157)*X(78)-JVS(158)*X(81)-JVS(159)*X(83)-JVS(160)*X(84)-JVS(161)*X(85)&
            &-JVS(162)*X(86)-JVS(163)*X(87)-JVS(164)*X(89)-JVS(165)*X(90)-JVS(166)*X(91)-JVS(167)*X(92)-JVS(168)*X(93)&
            &-JVS(169)*X(95)-JVS(170)*X(98))/(JVS(147))
  X(47) = (X(47)-JVS(145)*X(80)-JVS(146)*X(98))/(JVS(144))
  X(46) = (X(46)-JVS(143)*X(98))/(JVS(142))
  X(45) = (X(45)-JVS(140)*X(46)-JVS(141)*X(98))/(JVS(139))
  X(44) = (X(44)-JVS(137)*X(45)-JVS(138)*X(98))/(JVS(136))
  X(43) = (X(43)-JVS(134)*X(44)-JVS(135)*X(98))/(JVS(133))
  X(42) = (X(42)-JVS(132)*X(98))/(JVS(131))
  X(41) = (X(41)-JVS(129)*X(42)-JVS(130)*X(98))/(JVS(128))
  X(40) = (X(40)-JVS(126)*X(41)-JVS(127)*X(98))/(JVS(125))
  X(39) = (X(39)-JVS(123)*X(40)-JVS(124)*X(98))/(JVS(122))
  X(38) = (X(38)-JVS(118)*X(59)-JVS(119)*X(69)-JVS(120)*X(96)-JVS(121)*X(98))/(JVS(117))
  X(37) = (X(37)-JVS(116)*X(98))/(JVS(115))
  X(36) = (X(36)-JVS(113)*X(37)-JVS(114)*X(98))/(JVS(112))
  X(35) = (X(35)-JVS(110)*X(37)-JVS(111)*X(98))/(JVS(109))
  X(34) = (X(34)-JVS(108)*X(98))/(JVS(107))
  X(33) = (X(33)-JVS(105)*X(34)-JVS(106)*X(98))/(JVS(104))
  X(32) = (X(32)-JVS(103)*X(98))/(JVS(102))
  X(31) = (X(31)-JVS(100)*X(32)-JVS(101)*X(98))/(JVS(99))
  X(30) = (X(30)-JVS(97)*X(32)-JVS(98)*X(98))/(JVS(96))
  X(29) = (X(29)-JVS(93)*X(96)-JVS(94)*X(98)-JVS(95)*X(103))/(JVS(92))
  X(28) = (X(28)-JVS(90)*X(29)-JVS(91)*X(103))/(JVS(89))
  X(27) = (X(27)-JVS(87)*X(29)-JVS(88)*X(96))/(JVS(86))
  X(26) = (X(26)-JVS(84)*X(29)-JVS(85)*X(96))/(JVS(83))
  X(25) = (X(25)-JVS(81)*X(29)-JVS(82)*X(98))/(JVS(80))
  X(24) = (X(24)-JVS(78)*X(29)-JVS(79)*X(98))/(JVS(77))
  X(23) = (X(23)-JVS(75)*X(96)-JVS(76)*X(98))/(JVS(74))
  X(22) = (X(22)-JVS(72)*X(23)-JVS(73)*X(96))/(JVS(71))
  X(21) = (X(21)-JVS(69)*X(23)-JVS(70)*X(96))/(JVS(68))
  X(20) = (X(20)-JVS(66)*X(23)-JVS(67)*X(98))/(JVS(65))
  X(19) = (X(19)-JVS(63)*X(23)-JVS(64)*X(98))/(JVS(62))
  X(18) = (X(18)-JVS(61)*X(98))/(JVS(60))
  X(17) = (X(17)-JVS(58)*X(18)-JVS(59)*X(98))/(JVS(57))
  X(16) = (X(16)-JVS(55)*X(18)-JVS(56)*X(98))/(JVS(54))
  X(15) = (X(15)-JVS(53)*X(98))/(JVS(52))
  X(14) = (X(14)-JVS(50)*X(15)-JVS(51)*X(98))/(JVS(49))
  X(13) = (X(13)-JVS(47)*X(15)-JVS(48)*X(98))/(JVS(46))
  X(12) = (X(12)-JVS(45)*X(98))/(JVS(44))
  X(11) = (X(11)-JVS(42)*X(12)-JVS(43)*X(98))/(JVS(41))
  X(10) = (X(10)-JVS(36)*X(85)-JVS(37)*X(96)-JVS(38)*X(98)-JVS(39)*X(103)-JVS(40)*X(105))/(JVS(35))
  X(9) = (X(9)-JVS(33)*X(50)-JVS(34)*X(98))/(JVS(32))
  X(8) = (X(8)-JVS(30)*X(50)-JVS(31)*X(98))/(JVS(29))
  X(7) = (X(7)-JVS(24)*X(90)-JVS(25)*X(96)-JVS(26)*X(98)-JVS(27)*X(103)-JVS(28)*X(105))/(JVS(23))
  X(6) = (X(6)-JVS(18)*X(90)-JVS(19)*X(96)-JVS(20)*X(98)-JVS(21)*X(103)-JVS(22)*X(105))/(JVS(17))
  X(5) = (X(5)-JVS(15)*X(57)-JVS(16)*X(98))/(JVS(14))
  X(4) = (X(4)-JVS(12)*X(57)-JVS(13)*X(98))/(JVS(11))
  X(3) = (X(3)-JVS(8)*X(84)-JVS(9)*X(98)-JVS(10)*X(103))/(JVS(7))
  X(2) = (X(2)-JVS(5)*X(53)-JVS(6)*X(98))/(JVS(4))
  X(1) = (X(1)-JVS(2)*X(53)-JVS(3)*X(98))/(JVS(1))
      
END SUBROUTINE KppSolve

! End of KppSolve function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolveTR - sparse, transposed back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
!      XX        - Vector for output variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolveTR ( JVS, X, XX )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)
! XX - Vector for output variables
  REAL(kind=dp) :: XX(NVAR)

  XX(1) = X(1)/JVS(1)
  XX(2) = X(2)/JVS(4)
  XX(3) = X(3)/JVS(7)
  XX(4) = X(4)/JVS(11)
  XX(5) = X(5)/JVS(14)
  XX(6) = X(6)/JVS(17)
  XX(7) = X(7)/JVS(23)
  XX(8) = X(8)/JVS(29)
  XX(9) = X(9)/JVS(32)
  XX(10) = X(10)/JVS(35)
  XX(11) = X(11)/JVS(41)
  XX(12) = (X(12)-JVS(42)*XX(11))/(JVS(44))
  XX(13) = X(13)/JVS(46)
  XX(14) = X(14)/JVS(49)
  XX(15) = (X(15)-JVS(47)*XX(13)-JVS(50)*XX(14))/(JVS(52))
  XX(16) = X(16)/JVS(54)
  XX(17) = X(17)/JVS(57)
  XX(18) = (X(18)-JVS(55)*XX(16)-JVS(58)*XX(17))/(JVS(60))
  XX(19) = X(19)/JVS(62)
  XX(20) = X(20)/JVS(65)
  XX(21) = X(21)/JVS(68)
  XX(22) = X(22)/JVS(71)
  XX(23) = (X(23)-JVS(63)*XX(19)-JVS(66)*XX(20)-JVS(69)*XX(21)-JVS(72)*XX(22))/(JVS(74))
  XX(24) = X(24)/JVS(77)
  XX(25) = X(25)/JVS(80)
  XX(26) = X(26)/JVS(83)
  XX(27) = X(27)/JVS(86)
  XX(28) = X(28)/JVS(89)
  XX(29) = (X(29)-JVS(78)*XX(24)-JVS(81)*XX(25)-JVS(84)*XX(26)-JVS(87)*XX(27)-JVS(90)*XX(28))/(JVS(92))
  XX(30) = X(30)/JVS(96)
  XX(31) = X(31)/JVS(99)
  XX(32) = (X(32)-JVS(97)*XX(30)-JVS(100)*XX(31))/(JVS(102))
  XX(33) = X(33)/JVS(104)
  XX(34) = (X(34)-JVS(105)*XX(33))/(JVS(107))
  XX(35) = X(35)/JVS(109)
  XX(36) = X(36)/JVS(112)
  XX(37) = (X(37)-JVS(110)*XX(35)-JVS(113)*XX(36))/(JVS(115))
  XX(38) = X(38)/JVS(117)
  XX(39) = X(39)/JVS(122)
  XX(40) = (X(40)-JVS(123)*XX(39))/(JVS(125))
  XX(41) = (X(41)-JVS(126)*XX(40))/(JVS(128))
  XX(42) = (X(42)-JVS(129)*XX(41))/(JVS(131))
  XX(43) = X(43)/JVS(133)
  XX(44) = (X(44)-JVS(134)*XX(43))/(JVS(136))
  XX(45) = (X(45)-JVS(137)*XX(44))/(JVS(139))
  XX(46) = (X(46)-JVS(140)*XX(45))/(JVS(142))
  XX(47) = X(47)/JVS(144)
  XX(48) = X(48)/JVS(147)
  XX(49) = X(49)/JVS(171)
  XX(50) = (X(50)-JVS(30)*XX(8)-JVS(33)*XX(9))/(JVS(173))
  XX(51) = X(51)/JVS(175)
  XX(52) = X(52)/JVS(178)
  XX(53) = (X(53)-JVS(2)*XX(1)-JVS(5)*XX(2)-JVS(148)*XX(48))/(JVS(181))
  XX(54) = X(54)/JVS(183)
  XX(55) = (X(55)-JVS(184)*XX(54))/(JVS(187))
  XX(56) = X(56)/JVS(190)
  XX(57) = (X(57)-JVS(12)*XX(4)-JVS(15)*XX(5)-JVS(149)*XX(48))/(JVS(193))
  XX(58) = X(58)/JVS(195)
  XX(59) = (X(59)-JVS(118)*XX(38))/(JVS(198))
  XX(60) = X(60)/JVS(202)
  XX(61) = (X(61)-JVS(150)*XX(48))/(JVS(206))
  XX(62) = X(62)/JVS(214)
  XX(63) = X(63)/JVS(217)
  XX(64) = (X(64)-JVS(151)*XX(48))/(JVS(221))
  XX(65) = (X(65)-JVS(152)*XX(48))/(JVS(226))
  XX(66) = X(66)/JVS(233)
  XX(67) = (X(67)-JVS(153)*XX(48))/(JVS(237))
  XX(68) = (X(68)-JVS(154)*XX(48))/(JVS(240))
  XX(69) = (X(69)-JVS(119)*XX(38)-JVS(199)*XX(59))/(JVS(245))
  XX(70) = (X(70)-JVS(155)*XX(48))/(JVS(250))
  XX(71) = (X(71)-JVS(207)*XX(61))/(JVS(253))
  XX(72) = X(72)/JVS(261)
  XX(73) = X(73)/JVS(271)
  XX(74) = X(74)/JVS(276)
  XX(75) = (X(75)-JVS(172)*XX(49)-JVS(179)*XX(52))/(JVS(282))
  XX(76) = (X(76)-JVS(156)*XX(48))/(JVS(288))
  XX(77) = X(77)/JVS(293)
  XX(78) = (X(78)-JVS(157)*XX(48))/(JVS(301))
  XX(79) = X(79)/JVS(308)
  XX(80) = (X(80)-JVS(145)*XX(47))/(JVS(321))
  XX(81) = (X(81)-JVS(158)*XX(48)-JVS(289)*XX(76)-JVS(322)*XX(80))/(JVS(338))
  XX(82) = X(82)/JVS(343)
  XX(83) = (X(83)-JVS(159)*XX(48)-JVS(208)*XX(61)-JVS(294)*XX(77)-JVS(323)*XX(80))/(JVS(348))
  XX(84) = (X(84)-JVS(8)*XX(3)-JVS(160)*XX(48)-JVS(277)*XX(74)-JVS(309)*XX(79)-JVS(339)*XX(81))/(JVS(358))
  XX(85) = (X(85)-JVS(36)*XX(10)-JVS(161)*XX(48)-JVS(324)*XX(80))/(JVS(364))
  XX(86) = (X(86)-JVS(162)*XX(48)-JVS(262)*XX(72)-JVS(295)*XX(77)-JVS(325)*XX(80))/(JVS(369))
  XX(87) = (X(87)-JVS(163)*XX(48)-JVS(296)*XX(77)-JVS(326)*XX(80))/(JVS(376))
  XX(88) = (X(88)-JVS(272)*XX(73))/(JVS(386))
  XX(89) = (X(89)-JVS(164)*XX(48)-JVS(263)*XX(72)-JVS(344)*XX(82)-JVS(387)*XX(88))/(JVS(403))
  XX(90) = (X(90)-JVS(18)*XX(6)-JVS(24)*XX(7)-JVS(165)*XX(48)-JVS(264)*XX(72)-JVS(297)*XX(77)-JVS(327)*XX(80)-JVS(388)&
             &*XX(88)-JVS(404)*XX(89))/(JVS(413))
  XX(91) = (X(91)-JVS(166)*XX(48)-JVS(290)*XX(76)-JVS(310)*XX(79)-JVS(328)*XX(80)-JVS(405)*XX(89))/(JVS(421))
  XX(92) = (X(92)-JVS(167)*XX(48)-JVS(265)*XX(72)-JVS(311)*XX(79)-JVS(329)*XX(80))/(JVS(441))
  XX(93) = (X(93)-JVS(168)*XX(48)-JVS(266)*XX(72)-JVS(312)*XX(79)-JVS(330)*XX(80))/(JVS(463))
  XX(94) = (X(94)-JVS(313)*XX(79)-JVS(406)*XX(89)-JVS(442)*XX(92)-JVS(464)*XX(93))/(JVS(486))
  XX(95) = (X(95)-JVS(169)*XX(48)-JVS(254)*XX(71)-JVS(267)*XX(72)-JVS(302)*XX(78)-JVS(314)*XX(79)-JVS(331)*XX(80))&
             &/(JVS(509))
  XX(96) = (X(96)-JVS(19)*XX(6)-JVS(25)*XX(7)-JVS(37)*XX(10)-JVS(70)*XX(21)-JVS(73)*XX(22)-JVS(75)*XX(23)-JVS(85)*XX(26)&
             &-JVS(88)*XX(27)-JVS(93)*XX(29)-JVS(120)*XX(38)-JVS(188)*XX(55)-JVS(200)*XX(59)-JVS(209)*XX(61)-JVS(246)*XX(69)&
             &-JVS(283)*XX(75)-JVS(291)*XX(76)-JVS(332)*XX(80)-JVS(340)*XX(81)-JVS(349)*XX(83)-JVS(365)*XX(85)-JVS(370)&
             &*XX(86)-JVS(377)*XX(87)-JVS(389)*XX(88)-JVS(407)*XX(89)-JVS(414)*XX(90)-JVS(422)*XX(91)-JVS(443)*XX(92)&
             &-JVS(465)*XX(93)-JVS(487)*XX(94)-JVS(510)*XX(95))/(JVS(532))
  XX(97) = (X(97)-JVS(176)*XX(51)-JVS(222)*XX(64)-JVS(227)*XX(65)-JVS(466)*XX(93)-JVS(511)*XX(95)-JVS(533)*XX(96))&
             &/(JVS(551))
  XX(98) = (X(98)-JVS(3)*XX(1)-JVS(6)*XX(2)-JVS(9)*XX(3)-JVS(13)*XX(4)-JVS(16)*XX(5)-JVS(20)*XX(6)-JVS(26)*XX(7)-JVS(31)&
             &*XX(8)-JVS(34)*XX(9)-JVS(38)*XX(10)-JVS(43)*XX(11)-JVS(45)*XX(12)-JVS(48)*XX(13)-JVS(51)*XX(14)-JVS(53)*XX(15)&
             &-JVS(56)*XX(16)-JVS(59)*XX(17)-JVS(61)*XX(18)-JVS(64)*XX(19)-JVS(67)*XX(20)-JVS(76)*XX(23)-JVS(79)*XX(24)&
             &-JVS(82)*XX(25)-JVS(94)*XX(29)-JVS(98)*XX(30)-JVS(101)*XX(31)-JVS(103)*XX(32)-JVS(106)*XX(33)-JVS(108)*XX(34)&
             &-JVS(111)*XX(35)-JVS(114)*XX(36)-JVS(116)*XX(37)-JVS(121)*XX(38)-JVS(124)*XX(39)-JVS(127)*XX(40)-JVS(130)&
             &*XX(41)-JVS(132)*XX(42)-JVS(135)*XX(43)-JVS(138)*XX(44)-JVS(141)*XX(45)-JVS(143)*XX(46)-JVS(146)*XX(47)&
             &-JVS(170)*XX(48)-JVS(174)*XX(50)-JVS(182)*XX(53)-JVS(185)*XX(54)-JVS(189)*XX(55)-JVS(194)*XX(57)-JVS(196)&
             &*XX(58)-JVS(201)*XX(59)-JVS(203)*XX(60)-JVS(210)*XX(61)-JVS(215)*XX(62)-JVS(218)*XX(63)-JVS(223)*XX(64)&
             &-JVS(228)*XX(65)-JVS(234)*XX(66)-JVS(238)*XX(67)-JVS(241)*XX(68)-JVS(247)*XX(69)-JVS(251)*XX(70)-JVS(268)&
             &*XX(72)-JVS(273)*XX(73)-JVS(278)*XX(74)-JVS(292)*XX(76)-JVS(298)*XX(77)-JVS(303)*XX(78)-JVS(315)*XX(79)&
             &-JVS(333)*XX(80)-JVS(341)*XX(81)-JVS(345)*XX(82)-JVS(350)*XX(83)-JVS(359)*XX(84)-JVS(366)*XX(85)-JVS(371)&
             &*XX(86)-JVS(378)*XX(87)-JVS(390)*XX(88)-JVS(408)*XX(89)-JVS(415)*XX(90)-JVS(423)*XX(91)-JVS(444)*XX(92)&
             &-JVS(467)*XX(93)-JVS(488)*XX(94)-JVS(512)*XX(95)-JVS(534)*XX(96)-JVS(552)*XX(97))/(JVS(605))
  XX(99) = (X(99)-JVS(224)*XX(64)-JVS(229)*XX(65)-JVS(235)*XX(66)-JVS(468)*XX(93)-JVS(513)*XX(95)-JVS(535)*XX(96)&
             &-JVS(553)*XX(97)-JVS(606)*XX(98))/(JVS(624))
  XX(100) = (X(100)-JVS(204)*XX(60)-JVS(211)*XX(61)-JVS(216)*XX(62)-JVS(255)*XX(71)-JVS(284)*XX(75)-JVS(304)*XX(78)&
              &-JVS(342)*XX(81)-JVS(360)*XX(84)-JVS(391)*XX(88)-JVS(445)*XX(92)-JVS(469)*XX(93)-JVS(489)*XX(94)-JVS(514)&
              &*XX(95)-JVS(536)*XX(96)-JVS(554)*XX(97)-JVS(607)*XX(98)-JVS(625)*XX(99))/(JVS(647))
  XX(101) = (X(101)-JVS(177)*XX(51)-JVS(191)*XX(56)-JVS(205)*XX(60)-JVS(219)*XX(63)-JVS(236)*XX(66)-JVS(279)*XX(74)&
              &-JVS(316)*XX(79)-JVS(346)*XX(82)-JVS(361)*XX(84)-JVS(392)*XX(88)-JVS(409)*XX(89)-JVS(416)*XX(90)-JVS(424)&
              &*XX(91)-JVS(446)*XX(92)-JVS(470)*XX(93)-JVS(490)*XX(94)-JVS(515)*XX(95)-JVS(537)*XX(96)-JVS(555)*XX(97)&
              &-JVS(608)*XX(98)-JVS(626)*XX(99)-JVS(648)*XX(100))/(JVS(683))
  XX(102) = (X(102)-JVS(197)*XX(58)-JVS(239)*XX(67)-JVS(242)*XX(68)-JVS(252)*XX(70)-JVS(269)*XX(72)-JVS(285)*XX(75)&
              &-JVS(299)*XX(77)-JVS(334)*XX(80)-JVS(347)*XX(82)-JVS(351)*XX(83)-JVS(372)*XX(86)-JVS(379)*XX(87)-JVS(393)&
              &*XX(88)-JVS(410)*XX(89)-JVS(417)*XX(90)-JVS(425)*XX(91)-JVS(447)*XX(92)-JVS(471)*XX(93)-JVS(491)*XX(94)&
              &-JVS(516)*XX(95)-JVS(538)*XX(96)-JVS(556)*XX(97)-JVS(609)*XX(98)-JVS(627)*XX(99)-JVS(649)*XX(100)-JVS(684)&
              &*XX(101))/(JVS(715))
  XX(103) = (X(103)-JVS(10)*XX(3)-JVS(21)*XX(6)-JVS(27)*XX(7)-JVS(39)*XX(10)-JVS(91)*XX(28)-JVS(95)*XX(29)-JVS(192)&
              &*XX(56)-JVS(280)*XX(74)-JVS(317)*XX(79)-JVS(335)*XX(80)-JVS(352)*XX(83)-JVS(362)*XX(84)-JVS(367)*XX(85)&
              &-JVS(373)*XX(86)-JVS(380)*XX(87)-JVS(394)*XX(88)-JVS(411)*XX(89)-JVS(418)*XX(90)-JVS(426)*XX(91)-JVS(448)&
              &*XX(92)-JVS(472)*XX(93)-JVS(492)*XX(94)-JVS(517)*XX(95)-JVS(539)*XX(96)-JVS(557)*XX(97)-JVS(610)*XX(98)&
              &-JVS(628)*XX(99)-JVS(650)*XX(100)-JVS(685)*XX(101)-JVS(716)*XX(102))/(JVS(742))
  XX(104) = (X(104)-JVS(230)*XX(65)-JVS(274)*XX(73)-JVS(395)*XX(88)-JVS(449)*XX(92)-JVS(473)*XX(93)-JVS(493)*XX(94)&
              &-JVS(518)*XX(95)-JVS(558)*XX(97)-JVS(611)*XX(98)-JVS(629)*XX(99)-JVS(651)*XX(100)-JVS(686)*XX(101)-JVS(717)&
              &*XX(102)-JVS(743)*XX(103))/(JVS(775))
  XX(105) = (X(105)-JVS(22)*XX(6)-JVS(28)*XX(7)-JVS(40)*XX(10)-JVS(248)*XX(69)-JVS(336)*XX(80)-JVS(353)*XX(83)-JVS(368)&
              &*XX(85)-JVS(374)*XX(86)-JVS(381)*XX(87)-JVS(396)*XX(88)-JVS(412)*XX(89)-JVS(419)*XX(90)-JVS(427)*XX(91)&
              &-JVS(450)*XX(92)-JVS(474)*XX(93)-JVS(494)*XX(94)-JVS(519)*XX(95)-JVS(540)*XX(96)-JVS(559)*XX(97)-JVS(612)&
              &*XX(98)-JVS(630)*XX(99)-JVS(652)*XX(100)-JVS(687)*XX(101)-JVS(718)*XX(102)-JVS(744)*XX(103)-JVS(776)*XX(104))&
              &/(JVS(799))
  XX(106) = (X(106)-JVS(180)*XX(52)-JVS(220)*XX(63)-JVS(225)*XX(64)-JVS(231)*XX(65)-JVS(249)*XX(69)-JVS(256)*XX(71)&
              &-JVS(275)*XX(73)-JVS(281)*XX(74)-JVS(286)*XX(75)-JVS(305)*XX(78)-JVS(318)*XX(79)-JVS(363)*XX(84)-JVS(397)&
              &*XX(88)-JVS(451)*XX(92)-JVS(475)*XX(93)-JVS(495)*XX(94)-JVS(520)*XX(95)-JVS(541)*XX(96)-JVS(560)*XX(97)&
              &-JVS(613)*XX(98)-JVS(631)*XX(99)-JVS(653)*XX(100)-JVS(688)*XX(101)-JVS(719)*XX(102)-JVS(745)*XX(103)-JVS(777)&
              &*XX(104)-JVS(800)*XX(105))/(JVS(847))
  XX(107) = (X(107)-JVS(232)*XX(65)-JVS(243)*XX(68)-JVS(270)*XX(72)-JVS(306)*XX(78)-JVS(476)*XX(93)-JVS(521)*XX(95)&
              &-JVS(561)*XX(97)-JVS(614)*XX(98)-JVS(632)*XX(99)-JVS(654)*XX(100)-JVS(689)*XX(101)-JVS(720)*XX(102)-JVS(746)&
              &*XX(103)-JVS(778)*XX(104)-JVS(801)*XX(105)-JVS(848)*XX(106))/(JVS(868))
  XX(107) = XX(107)
  XX(106) = XX(106)-JVS(867)*XX(107)
  XX(105) = XX(105)-JVS(846)*XX(106)-JVS(866)*XX(107)
  XX(104) = XX(104)-JVS(798)*XX(105)-JVS(845)*XX(106)-JVS(865)*XX(107)
  XX(103) = XX(103)-JVS(774)*XX(104)-JVS(797)*XX(105)-JVS(844)*XX(106)-JVS(864)*XX(107)
  XX(102) = XX(102)-JVS(741)*XX(103)-JVS(773)*XX(104)-JVS(796)*XX(105)-JVS(843)*XX(106)-JVS(863)*XX(107)
  XX(101) = XX(101)-JVS(714)*XX(102)-JVS(740)*XX(103)-JVS(772)*XX(104)-JVS(795)*XX(105)-JVS(842)*XX(106)-JVS(862)&
              &*XX(107)
  XX(100) = XX(100)-JVS(682)*XX(101)-JVS(713)*XX(102)-JVS(739)*XX(103)-JVS(771)*XX(104)-JVS(794)*XX(105)-JVS(841)&
              &*XX(106)-JVS(861)*XX(107)
  XX(99) = XX(99)-JVS(646)*XX(100)-JVS(681)*XX(101)-JVS(712)*XX(102)-JVS(738)*XX(103)-JVS(770)*XX(104)-JVS(793)*XX(105)&
             &-JVS(840)*XX(106)-JVS(860)*XX(107)
  XX(98) = XX(98)-JVS(623)*XX(99)-JVS(645)*XX(100)-JVS(680)*XX(101)-JVS(711)*XX(102)-JVS(737)*XX(103)-JVS(769)*XX(104)&
             &-JVS(792)*XX(105)-JVS(839)*XX(106)-JVS(859)*XX(107)
  XX(97) = XX(97)-JVS(604)*XX(98)-JVS(622)*XX(99)-JVS(644)*XX(100)-JVS(679)*XX(101)-JVS(710)*XX(102)-JVS(736)*XX(103)&
             &-JVS(768)*XX(104)-JVS(791)*XX(105)-JVS(838)*XX(106)-JVS(858)*XX(107)
  XX(96) = XX(96)-JVS(550)*XX(97)-JVS(603)*XX(98)-JVS(621)*XX(99)-JVS(643)*XX(100)-JVS(678)*XX(101)-JVS(709)*XX(102)&
             &-JVS(735)*XX(103)-JVS(767)*XX(104)-JVS(790)*XX(105)-JVS(837)*XX(106)-JVS(857)*XX(107)
  XX(95) = XX(95)-JVS(602)*XX(98)-JVS(642)*XX(100)-JVS(677)*XX(101)-JVS(708)*XX(102)-JVS(734)*XX(103)-JVS(766)*XX(104)&
             &-JVS(789)*XX(105)-JVS(836)*XX(106)-JVS(856)*XX(107)
  XX(94) = XX(94)-JVS(508)*XX(95)-JVS(549)*XX(97)-JVS(601)*XX(98)-JVS(620)*XX(99)-JVS(641)*XX(100)-JVS(676)*XX(101)&
             &-JVS(707)*XX(102)-JVS(733)*XX(103)-JVS(765)*XX(104)-JVS(788)*XX(105)-JVS(835)*XX(106)-JVS(855)*XX(107)
  XX(93) = XX(93)-JVS(548)*XX(97)-JVS(600)*XX(98)-JVS(675)*XX(101)-JVS(706)*XX(102)-JVS(732)*XX(103)-JVS(787)*XX(105)&
             &-JVS(834)*XX(106)-JVS(854)*XX(107)
  XX(92) = XX(92)-JVS(599)*XX(98)-JVS(619)*XX(99)-JVS(674)*XX(101)-JVS(705)*XX(102)-JVS(731)*XX(103)-JVS(786)*XX(105)&
             &-JVS(833)*XX(106)-JVS(853)*XX(107)
  XX(91) = XX(91)-JVS(440)*XX(92)-JVS(462)*XX(93)-JVS(485)*XX(94)-JVS(507)*XX(95)-JVS(531)*XX(96)-JVS(547)*XX(97)&
             &-JVS(598)*XX(98)-JVS(618)*XX(99)-JVS(640)*XX(100)-JVS(673)*XX(101)-JVS(704)*XX(102)-JVS(730)*XX(103)-JVS(764)&
             &*XX(104)-JVS(832)*XX(106)
  XX(90) = XX(90)-JVS(420)*XX(91)-JVS(439)*XX(92)-JVS(461)*XX(93)-JVS(484)*XX(94)-JVS(506)*XX(95)-JVS(530)*XX(96)&
             &-JVS(597)*XX(98)-JVS(617)*XX(99)-JVS(639)*XX(100)-JVS(672)*XX(101)-JVS(703)*XX(102)-JVS(729)*XX(103)-JVS(763)&
             &*XX(104)-JVS(785)*XX(105)-JVS(831)*XX(106)
  XX(89) = XX(89)-JVS(438)*XX(92)-JVS(460)*XX(93)-JVS(483)*XX(94)-JVS(596)*XX(98)-JVS(638)*XX(100)-JVS(671)*XX(101)&
             &-JVS(702)*XX(102)-JVS(762)*XX(104)-JVS(830)*XX(106)
  XX(88) = XX(88)-JVS(437)*XX(92)-JVS(459)*XX(93)-JVS(482)*XX(94)-JVS(595)*XX(98)-JVS(637)*XX(100)-JVS(761)*XX(104)&
             &-JVS(829)*XX(106)
  XX(87) = XX(87)-JVS(385)*XX(88)-JVS(402)*XX(89)-JVS(436)*XX(92)-JVS(458)*XX(93)-JVS(505)*XX(95)-JVS(529)*XX(96)&
             &-JVS(594)*XX(98)-JVS(670)*XX(101)-JVS(701)*XX(102)-JVS(728)*XX(103)-JVS(760)*XX(104)-JVS(784)*XX(105)-JVS(828)&
             &*XX(106)
  XX(86) = XX(86)-JVS(375)*XX(87)-JVS(401)*XX(89)-JVS(435)*XX(92)-JVS(457)*XX(93)-JVS(504)*XX(95)-JVS(528)*XX(96)&
             &-JVS(593)*XX(98)-JVS(669)*XX(101)-JVS(700)*XX(102)-JVS(727)*XX(103)-JVS(759)*XX(104)-JVS(783)*XX(105)-JVS(827)&
             &*XX(106)
  XX(85) = XX(85)-JVS(384)*XX(88)-JVS(400)*XX(89)-JVS(434)*XX(92)-JVS(481)*XX(94)-JVS(503)*XX(95)-JVS(527)*XX(96)&
             &-JVS(592)*XX(98)-JVS(616)*XX(99)-JVS(668)*XX(101)-JVS(726)*XX(103)-JVS(758)*XX(104)-JVS(782)*XX(105)-JVS(826)&
             &*XX(106)
  XX(84) = XX(84)-JVS(433)*XX(92)-JVS(480)*XX(94)-JVS(502)*XX(95)-JVS(526)*XX(96)-JVS(546)*XX(97)-JVS(591)*XX(98)&
             &-JVS(667)*XX(101)-JVS(725)*XX(103)-JVS(757)*XX(104)-JVS(825)*XX(106)
  XX(83) = XX(83)-JVS(432)*XX(92)-JVS(501)*XX(95)-JVS(525)*XX(96)-JVS(590)*XX(98)-JVS(666)*XX(101)-JVS(699)*XX(102)&
             &-JVS(724)*XX(103)-JVS(756)*XX(104)-JVS(781)*XX(105)-JVS(824)*XX(106)
  XX(82) = XX(82)-JVS(383)*XX(88)-JVS(399)*XX(89)-JVS(431)*XX(92)-JVS(456)*XX(93)-JVS(479)*XX(94)-JVS(665)*XX(101)&
             &-JVS(755)*XX(104)-JVS(823)*XX(106)
  XX(81) = XX(81)-JVS(430)*XX(92)-JVS(500)*XX(95)-JVS(524)*XX(96)-JVS(545)*XX(97)-JVS(589)*XX(98)-JVS(754)*XX(104)&
             &-JVS(822)*XX(106)
  XX(80) = XX(80)-JVS(588)*XX(98)-JVS(821)*XX(106)
  XX(79) = XX(79)-JVS(587)*XX(98)-JVS(664)*XX(101)-JVS(723)*XX(103)
  XX(78) = XX(78)-JVS(499)*XX(95)-JVS(586)*XX(98)-JVS(753)*XX(104)-JVS(820)*XX(106)-JVS(852)*XX(107)
  XX(77) = XX(77)-JVS(320)*XX(80)-JVS(585)*XX(98)-JVS(698)*XX(102)-JVS(819)*XX(106)
  XX(76) = XX(76)-JVS(319)*XX(80)-JVS(544)*XX(97)-JVS(584)*XX(98)-JVS(752)*XX(104)-JVS(818)*XX(106)
  XX(75) = XX(75)-JVS(583)*XX(98)-JVS(636)*XX(100)-JVS(663)*XX(101)-JVS(697)*XX(102)-JVS(817)*XX(106)
  XX(74) = XX(74)-JVS(357)*XX(84)-JVS(478)*XX(94)-JVS(662)*XX(101)-JVS(816)*XX(106)
  XX(73) = XX(73)-JVS(429)*XX(92)-JVS(455)*XX(93)-JVS(582)*XX(98)-JVS(751)*XX(104)-JVS(815)*XX(106)
  XX(72) = XX(72)-JVS(581)*XX(98)-JVS(696)*XX(102)
  XX(71) = XX(71)-JVS(300)*XX(78)-JVS(498)*XX(95)-JVS(580)*XX(98)-JVS(635)*XX(100)-JVS(661)*XX(101)-JVS(814)*XX(106)
  XX(70) = XX(70)-JVS(260)*XX(72)-JVS(428)*XX(92)-JVS(454)*XX(93)-JVS(497)*XX(95)-JVS(579)*XX(98)-JVS(695)*XX(102)&
             &-JVS(750)*XX(104)-JVS(813)*XX(106)
  XX(69) = XX(69)-JVS(523)*XX(96)-JVS(578)*XX(98)-JVS(780)*XX(105)-JVS(812)*XX(106)
  XX(68) = XX(68)-JVS(259)*XX(72)-JVS(496)*XX(95)-JVS(577)*XX(98)-JVS(694)*XX(102)-JVS(811)*XX(106)
  XX(67) = XX(67)-JVS(258)*XX(72)-JVS(382)*XX(88)-JVS(453)*XX(93)-JVS(576)*XX(98)-JVS(693)*XX(102)-JVS(749)*XX(104)&
             &-JVS(810)*XX(106)
  XX(66) = XX(66)-JVS(452)*XX(93)-JVS(575)*XX(98)-JVS(615)*XX(99)-JVS(660)*XX(101)
  XX(65) = XX(65)-JVS(574)*XX(98)-JVS(851)*XX(107)
  XX(64) = XX(64)-JVS(543)*XX(97)-JVS(573)*XX(98)-JVS(850)*XX(107)
  XX(63) = XX(63)-JVS(572)*XX(98)-JVS(659)*XX(101)-JVS(722)*XX(103)-JVS(809)*XX(106)
  XX(62) = XX(62)-JVS(337)*XX(81)-JVS(356)*XX(84)-JVS(477)*XX(94)-JVS(634)*XX(100)-JVS(658)*XX(101)-JVS(808)*XX(106)
  XX(61) = XX(61)-JVS(571)*XX(98)-JVS(807)*XX(106)
  XX(60) = XX(60)-JVS(570)*XX(98)-JVS(633)*XX(100)-JVS(657)*XX(101)
  XX(59) = XX(59)-JVS(244)*XX(69)-JVS(522)*XX(96)-JVS(569)*XX(98)
  XX(58) = XX(58)-JVS(257)*XX(72)-JVS(568)*XX(98)-JVS(692)*XX(102)-JVS(849)*XX(107)
  XX(57) = XX(57)-JVS(213)*XX(62)-JVS(287)*XX(76)-JVS(355)*XX(84)-JVS(398)*XX(89)-JVS(567)*XX(98)-JVS(748)*XX(104)&
             &-JVS(806)*XX(106)
  XX(56) = XX(56)-JVS(307)*XX(79)-JVS(656)*XX(101)-JVS(721)*XX(103)
  XX(55) = XX(55)-JVS(566)*XX(98)-JVS(779)*XX(105)-JVS(805)*XX(106)
  XX(54) = XX(54)-JVS(186)*XX(55)-JVS(565)*XX(98)-JVS(804)*XX(106)
  XX(53) = XX(53)-JVS(212)*XX(62)-JVS(354)*XX(84)-JVS(564)*XX(98)-JVS(747)*XX(104)-JVS(803)*XX(106)
  XX(52) = XX(52)-JVS(563)*XX(98)-JVS(691)*XX(102)
  XX(51) = XX(51)-JVS(542)*XX(97)-JVS(655)*XX(101)
  XX(50) = XX(50)-JVS(562)*XX(98)-JVS(802)*XX(106)
  XX(49) = XX(49)-JVS(690)*XX(102)
  XX(48) = XX(48)
  XX(47) = XX(47)
  XX(46) = XX(46)
  XX(45) = XX(45)
  XX(44) = XX(44)
  XX(43) = XX(43)
  XX(42) = XX(42)
  XX(41) = XX(41)
  XX(40) = XX(40)
  XX(39) = XX(39)
  XX(38) = XX(38)
  XX(37) = XX(37)
  XX(36) = XX(36)
  XX(35) = XX(35)
  XX(34) = XX(34)
  XX(33) = XX(33)
  XX(32) = XX(32)
  XX(31) = XX(31)
  XX(30) = XX(30)
  XX(29) = XX(29)
  XX(28) = XX(28)
  XX(27) = XX(27)
  XX(26) = XX(26)
  XX(25) = XX(25)
  XX(24) = XX(24)
  XX(23) = XX(23)
  XX(22) = XX(22)
  XX(21) = XX(21)
  XX(20) = XX(20)
  XX(19) = XX(19)
  XX(18) = XX(18)
  XX(17) = XX(17)
  XX(16) = XX(16)
  XX(15) = XX(15)
  XX(14) = XX(14)
  XX(13) = XX(13)
  XX(12) = XX(12)
  XX(11) = XX(11)
  XX(10) = XX(10)
  XX(9) = XX(9)
  XX(8) = XX(8)
  XX(7) = XX(7)
  XX(6) = XX(6)
  XX(5) = XX(5)
  XX(4) = XX(4)
  XX(3) = XX(3)
  XX(2) = XX(2)
  XX(1) = XX(1)
      
END SUBROUTINE KppSolveTR

! End of KppSolveTR function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! BLAS_UTIL - BLAS-LIKE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!--------------------------------------------------------------
!
! BLAS/LAPACK-like subroutines used by the integration algorithms
! It is recommended to replace them by calls to the optimized
!      BLAS/LAPACK library for your machine
!
!  (C) Adrian Sandu, Aug. 2004
!      Virginia Polytechnic Institute and State University
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE WCOPY(N,X,incX,Y,incY)
!--------------------------------------------------------------
!     copies a vector, x, to a vector, y:  y <- x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL  SCOPY(N,X,1,Y,1)   or   CALL  DCOPY(N,X,1,Y,1)
!--------------------------------------------------------------
!     USE CB05TUCl_NCSU_Precision
      
      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N)

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = X(i)
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i) = X(i)
        Y(i + 1) = X(i + 1)
        Y(i + 2) = X(i + 2)
        Y(i + 3) = X(i + 3)
        Y(i + 4) = X(i + 4)
        Y(i + 5) = X(i + 5)
        Y(i + 6) = X(i + 6)
        Y(i + 7) = X(i + 7)
      END DO

      END SUBROUTINE WCOPY


!--------------------------------------------------------------
      SUBROUTINE WAXPY(N,Alpha,X,incX,Y,incY)
!--------------------------------------------------------------
!     constant times a vector plus a vector: y <- y + Alpha*x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SAXPY(N,Alpha,X,1,Y,1) or  CALL DAXPY(N,Alpha,X,1,Y,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N),Alpha
      REAL(kind=dp), PARAMETER :: ZERO = 0.0_dp

      IF (Alpha .EQ. ZERO) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,4)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = Y(i) + Alpha*X(i)
        END DO
        IF( N .LT. 4 ) RETURN
      END IF
      MP1 = M + 1
      DO i = MP1,N,4
        Y(i) = Y(i) + Alpha*X(i)
        Y(i + 1) = Y(i + 1) + Alpha*X(i + 1)
        Y(i + 2) = Y(i + 2) + Alpha*X(i + 2)
        Y(i + 3) = Y(i + 3) + Alpha*X(i + 3)
      END DO
      
      END SUBROUTINE WAXPY



!--------------------------------------------------------------
      SUBROUTINE WSCAL(N,Alpha,X,incX)
!--------------------------------------------------------------
!     constant times a vector: x(1:N) <- Alpha*x(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SSCAL(N,Alpha,X,1) or  CALL DSCAL(N,Alpha,X,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,M,MP1,N
      REAL(kind=dp)  :: X(N),Alpha
      REAL(kind=dp), PARAMETER  :: ZERO=0.0_dp, ONE=1.0_dp

      IF (Alpha .EQ. ONE) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,5)
      IF( M .NE. 0 ) THEN
        IF (Alpha .EQ. (-ONE)) THEN
          DO i = 1,M
            X(i) = -X(i)
          END DO
        ELSEIF (Alpha .EQ. ZERO) THEN
          DO i = 1,M
            X(i) = ZERO
          END DO
        ELSE
          DO i = 1,M
            X(i) = Alpha*X(i)
          END DO
        END IF
        IF( N .LT. 5 ) RETURN
      END IF
      MP1 = M + 1
      IF (Alpha .EQ. (-ONE)) THEN
        DO i = MP1,N,5
          X(i)     = -X(i)
          X(i + 1) = -X(i + 1)
          X(i + 2) = -X(i + 2)
          X(i + 3) = -X(i + 3)
          X(i + 4) = -X(i + 4)
        END DO
      ELSEIF (Alpha .EQ. ZERO) THEN
        DO i = MP1,N,5
          X(i)     = ZERO
          X(i + 1) = ZERO
          X(i + 2) = ZERO
          X(i + 3) = ZERO
          X(i + 4) = ZERO
        END DO
      ELSE
        DO i = MP1,N,5
          X(i)     = Alpha*X(i)
          X(i + 1) = Alpha*X(i + 1)
          X(i + 2) = Alpha*X(i + 2)
          X(i + 3) = Alpha*X(i + 3)
          X(i + 4) = Alpha*X(i + 4)
        END DO
      END IF

      END SUBROUTINE WSCAL

!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WLAMCH( C )
!--------------------------------------------------------------
!     returns epsilon machine
!     after LAPACK
!     replace this by the function from the optimized LAPACK implementation:
!          CALL SLAMCH('E') or CALL DLAMCH('E')
!--------------------------------------------------------------
!      USE CB05TUCl_NCSU_Precision

      CHARACTER ::  C
      INTEGER    :: i
      REAL(kind=dp), SAVE  ::  Eps
      REAL(kind=dp)  ::  Suma
      REAL(kind=dp), PARAMETER  ::  ONE=1.0_dp, HALF=0.5_dp
      LOGICAL, SAVE   ::  First=.TRUE.
      
      IF (First) THEN
        First = .FALSE.
        Eps = HALF**(16)
        DO i = 17, 80
          Eps = Eps*HALF
          CALL WLAMCH_ADD(ONE,Eps,Suma)
          IF (Suma.LE.ONE) GOTO 10
        END DO
        PRINT*,'ERROR IN WLAMCH. EPS < ',Eps
        RETURN
10      Eps = Eps*2
        i = i-1      
      END IF

      WLAMCH = Eps

      END FUNCTION WLAMCH
     
      SUBROUTINE WLAMCH_ADD( A, B, Suma )
!      USE CB05TUCl_NCSU_Precision
      
      REAL(kind=dp) A, B, Suma
      Suma = A + B

      END SUBROUTINE WLAMCH_ADD
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE SET2ZERO(N,Y)
!--------------------------------------------------------------
!     copies zeros into the vector y:  y <- 0
!     after BLAS
!--------------------------------------------------------------
      
      INTEGER ::  i,M,MP1,N
      REAL(kind=dp) ::  Y(N)
      REAL(kind=dp), PARAMETER :: ZERO = 0.0d0

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = ZERO
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i)     = ZERO
        Y(i + 1) = ZERO
        Y(i + 2) = ZERO
        Y(i + 3) = ZERO
        Y(i + 4) = ZERO
        Y(i + 5) = ZERO
        Y(i + 6) = ZERO
        Y(i + 7) = ZERO
      END DO

      END SUBROUTINE SET2ZERO


!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WDOT (N, DX, incX, DY, incY) 
!--------------------------------------------------------------
!     dot produce: wdot = x(1:N)*y(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SDOT(N,X,1,Y,1) or  CALL DDOT(N,X,1,Y,1)
!--------------------------------------------------------------
!      USE messy_mecca_kpp_Precision
!--------------------------------------------------------------
      IMPLICIT NONE
      INTEGER :: N, incX, incY
      REAL(kind=dp) :: DX(N), DY(N) 

      INTEGER :: i, IX, IY, M, MP1, NS
                                 
      WDOT = 0.0D0 
      IF (N .LE. 0) RETURN 
      IF (incX .EQ. incY) IF (incX-1) 5,20,60 
!                                                                       
!     Code for unequal or nonpositive increments.                       
!                                                                       
    5 IX = 1 
      IY = 1 
      IF (incX .LT. 0) IX = (-N+1)*incX + 1 
      IF (incY .LT. 0) IY = (-N+1)*incY + 1 
      DO i = 1,N 
        WDOT = WDOT + DX(IX)*DY(IY) 
        IX = IX + incX 
        IY = IY + incY 
      END DO 
      RETURN 
!                                                                       
!     Code for both increments equal to 1.                              
!                                                                       
!     Clean-up loop so remaining vector length is a multiple of 5.      
!                                                                       
   20 M = MOD(N,5) 
      IF (M .EQ. 0) GO TO 40 
      DO i = 1,M 
         WDOT = WDOT + DX(i)*DY(i) 
      END DO 
      IF (N .LT. 5) RETURN 
   40 MP1 = M + 1 
      DO i = MP1,N,5 
          WDOT = WDOT + DX(i)*DY(i) + DX(i+1)*DY(i+1) + DX(i+2)*DY(i+2) +  &
                   DX(i+3)*DY(i+3) + DX(i+4)*DY(i+4)                   
      END DO 
      RETURN 
!                                                                       
!     Code for equal, positive, non-unit increments.                    
!                                                                       
   60 NS = N*incX 
      DO i = 1,NS,incX 
        WDOT = WDOT + DX(i)*DY(i) 
      END DO 

      END FUNCTION WDOT                                          


!--------------------------------------------------------------
      SUBROUTINE WADD(N,X,Y,Z)
!--------------------------------------------------------------
!     adds two vectors: z <- x + y
!     BLAS - like
!--------------------------------------------------------------
!     USE CB05TUCl_NCSU_Precision
      
      INTEGER :: i, M, MP1, N
      REAL(kind=dp) :: X(N),Y(N),Z(N)

      IF (N.LE.0) RETURN

      M = MOD(N,5)
      IF( M /= 0 ) THEN
         DO i = 1,M
            Z(i) = X(i) + Y(i)
         END DO
         IF( N < 5 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,5
         Z(i)     = X(i)     + Y(i)
         Z(i + 1) = X(i + 1) + Y(i + 1)
         Z(i + 2) = X(i + 2) + Y(i + 2)
         Z(i + 3) = X(i + 3) + Y(i + 3)
         Z(i + 4) = X(i + 4) + Y(i + 4)
      END DO

      END SUBROUTINE WADD
      
      
      
!--------------------------------------------------------------
      SUBROUTINE WGEFA(N,A,Ipvt,info)
!--------------------------------------------------------------
!     WGEFA FACTORS THE MATRIX A (N,N) BY
!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!     LINPACK - LIKE 
!--------------------------------------------------------------
!
      INTEGER       :: N,Ipvt(N),info
      REAL(kind=dp) :: A(N,N)
      REAL(kind=dp) :: t, dmax, da
      INTEGER       :: j,k,l
      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0

      info = 0

size: IF (n > 1) THEN
      
col:  DO k = 1, n-1

!        find l = pivot index
!        l = idamax(n-k+1,A(k,k),1) + k - 1
         l = k; dmax = abs(A(k,k))
         DO j = k+1,n
            da = ABS(A(j,k))
            IF (da > dmax) THEN
              l = j; dmax = da
            END IF
         END DO
         Ipvt(k) = l

!        zero pivot implies this column already triangularized
         IF (ABS(A(l,k)) < TINY(ZERO)) THEN
            info = k
            return
         ELSE   
            IF (l /= k) THEN
               t = A(l,k); A(l,k) = A(k,k); A(k,k) = t
            END IF
            t = -ONE/A(k,k)
            CALL WSCAL(n-k,t,A(k+1,k),1)
            DO j = k+1, n
               t = A(l,j)
               IF (l /= k) THEN
                  A(l,j) = A(k,j); A(k,j) = t
               END IF
               CALL WAXPY(n-k,t,A(k+1,k),1,A(k+1,j),1)
            END DO         
         END IF
         
       END DO col
       
      END IF size
      
      Ipvt(N) = N
      IF (ABS(A(N,N)) == ZERO) info = N
      
      END SUBROUTINE WGEFA


!--------------------------------------------------------------
      SUBROUTINE WGESL(Trans,N,A,Ipvt,b)
!--------------------------------------------------------------
!     WGESL solves the system
!     a * x = b  or  trans(a) * x = b
!     using the factors computed by WGEFA.
!
!     Trans      = 'N'   to solve  A*x = b ,
!                = 'T'   to solve  transpose(A)*x = b
!     LINPACK - LIKE 
!--------------------------------------------------------------

      INTEGER       :: N,Ipvt(N)
      CHARACTER     :: trans
      REAL(kind=dp) :: A(N,N),b(N)
      REAL(kind=dp) :: t
      INTEGER       :: k,kb,l

      
      SELECT CASE (Trans)

      CASE ('n','N')  !  Solve  A * x = b

!        first solve  L*y = b
         IF (n >= 2) THEN
          DO k = 1, n-1
            l = Ipvt(k)
            t = b(l)
            IF (l /= k) THEN
               b(l) = b(k)
               b(k) = t
            END IF
            CALL WAXPY(n-k,t,a(k+1,k),1,b(k+1),1)
          END DO
         END IF
!        now solve  U*x = y
         DO kb = 1, n
            k = n + 1 - kb
            b(k) = b(k)/a(k,k)
            t = -b(k)
            CALL WAXPY(k-1,t,a(1,k),1,b(1),1)
         END DO
      
      CASE ('t','T')  !  Solve transpose(A) * x = b

!        first solve  trans(U)*y = b
         DO k = 1, n
            t = WDOT(k-1,a(1,k),1,b(1),1)
            b(k) = (b(k) - t)/a(k,k)
         END DO
!        now solve trans(L)*x = y
         IF (n >= 2) THEN
         DO kb = 1, n-1
            k = n - kb
            b(k) = b(k) + WDOT(n-k,a(k+1,k),1,b(k+1),1)
            l = Ipvt(k)
            IF (l /= k) THEN
               t = b(l); b(l) = b(k); b(k) = t
            END IF
         END DO
         END IF
   
      END SELECT

      END SUBROUTINE WGESL
! End of BLAS_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE CB05TUCl_NCSU_LinearAlgebra

