! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Jacobian of Chemical Model File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CB05TUCl_NCSU_Jacobian.f90
! Time                 : Thu Oct  8 08:21:46 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CB05TUCl_NCSU_13059_BOXMOX
! Equation file        : CB05TUCl_NCSU.kpp
! Output root filename : CB05TUCl_NCSU
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CB05TUCl_NCSU_Jacobian

  USE CB05TUCl_NCSU_Parameters
  USE CB05TUCl_NCSU_JacobianSP

  USE CB05TUCl_NCSU_Global

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP - the Jacobian of Variables in sparse matrix representation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      JVS       - sparse Jacobian of variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP ( V, F, RCT, JVS )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)


! Local variables
! B - Temporary array
  REAL(kind=dp) :: B(349)

! B(1) = dA(1)/dV(101)
  B(1) = RCT(1)
! B(2) = dA(2)/dV(105)
  B(2) = RCT(2)
! B(3) = dA(3)/dV(96)
  B(3) = RCT(3)*V(100)
! B(4) = dA(3)/dV(100)
  B(4) = RCT(3)*V(96)
! B(5) = dA(4)/dV(101)
  B(5) = RCT(4)*V(105)
! B(6) = dA(4)/dV(105)
  B(6) = RCT(4)*V(101)
! B(7) = dA(5)/dV(101)
  B(7) = RCT(5)*V(105)
! B(8) = dA(5)/dV(105)
  B(8) = RCT(5)*V(101)
! B(9) = dA(6)/dV(100)
  B(9) = RCT(6)*V(105)
! B(10) = dA(6)/dV(105)
  B(10) = RCT(6)*V(100)
! B(11) = dA(7)/dV(96)
  B(11) = RCT(7)*V(101)
! B(12) = dA(7)/dV(101)
  B(12) = RCT(7)*V(96)
! B(13) = dA(8)/dV(96)
  B(13) = RCT(8)
! B(14) = dA(9)/dV(96)
  B(14) = RCT(9)
! B(15) = dA(10)/dV(55)
  B(15) = RCT(10)*F(2)
! B(17) = dA(11)/dV(55)
  B(17) = RCT(11)*F(1)
! B(19) = dA(12)/dV(96)
  B(19) = RCT(12)*V(98)
! B(20) = dA(12)/dV(98)
  B(20) = RCT(12)*V(96)
! B(21) = dA(13)/dV(96)
  B(21) = RCT(13)*V(106)
! B(22) = dA(13)/dV(106)
  B(22) = RCT(13)*V(96)
! B(23) = dA(14)/dV(103)
  B(23) = RCT(14)
! B(24) = dA(15)/dV(103)
  B(24) = RCT(15)
! B(25) = dA(16)/dV(100)
  B(25) = RCT(16)*V(103)
! B(26) = dA(16)/dV(103)
  B(26) = RCT(16)*V(100)
! B(27) = dA(17)/dV(101)
  B(27) = RCT(17)*V(103)
! B(28) = dA(17)/dV(103)
  B(28) = RCT(17)*V(101)
! B(29) = dA(18)/dV(101)
  B(29) = RCT(18)*V(103)
! B(30) = dA(18)/dV(103)
  B(30) = RCT(18)*V(101)
! B(31) = dA(19)/dV(56)
  B(31) = RCT(19)*F(1)
! B(33) = dA(20)/dV(56)
  B(33) = RCT(20)*F(1)*F(1)
! B(35) = dA(21)/dV(56)
  B(35) = RCT(21)
! B(36) = dA(22)/dV(100)
  B(36) = RCT(22)*2*V(100)
! B(37) = dA(23)/dV(100)
  B(37) = RCT(23)*V(101)*F(1)
! B(38) = dA(23)/dV(101)
  B(38) = RCT(23)*V(100)*F(1)
! B(40) = dA(24)/dV(98)
  B(40) = RCT(24)*V(100)
! B(41) = dA(24)/dV(100)
  B(41) = RCT(24)*V(98)
! B(42) = dA(25)/dV(60)
  B(42) = RCT(25)
! B(43) = dA(26)/dV(60)
  B(43) = RCT(26)*V(98)
! B(44) = dA(26)/dV(98)
  B(44) = RCT(26)*V(60)
! B(45) = dA(27)/dV(60)
  B(45) = RCT(27)*2*V(60)
! B(46) = dA(28)/dV(98)
  B(46) = RCT(28)*V(101)
! B(47) = dA(28)/dV(101)
  B(47) = RCT(28)*V(98)
! B(48) = dA(29)/dV(79)
  B(48) = RCT(29)*V(98)
! B(49) = dA(29)/dV(98)
  B(49) = RCT(29)*V(79)
! B(50) = dA(30)/dV(100)
  B(50) = RCT(30)*V(106)
! B(51) = dA(30)/dV(106)
  B(51) = RCT(30)*V(100)
! B(52) = dA(31)/dV(101)
  B(52) = RCT(31)*V(106)
! B(53) = dA(31)/dV(106)
  B(53) = RCT(31)*V(101)
! B(54) = dA(32)/dV(63)
  B(54) = RCT(32)
! B(55) = dA(33)/dV(63)
  B(55) = RCT(33)*V(98)
! B(56) = dA(33)/dV(98)
  B(56) = RCT(33)*V(63)
! B(57) = dA(34)/dV(106)
  B(57) = RCT(34)*2*V(106)
! B(58) = dA(35)/dV(106)
  B(58) = RCT(35)*2*V(106)*F(1)
! B(60) = dA(36)/dV(69)
  B(60) = RCT(36)
! B(61) = dA(37)/dV(69)
  B(61) = RCT(37)*V(98)
! B(62) = dA(37)/dV(98)
  B(62) = RCT(37)*V(69)
! B(63) = dA(38)/dV(54)
  B(63) = RCT(38)*V(55)
! B(64) = dA(38)/dV(55)
  B(64) = RCT(38)*V(54)
! B(65) = dA(39)/dV(54)
  B(65) = RCT(39)*V(98)
! B(66) = dA(39)/dV(98)
  B(66) = RCT(39)*V(54)
! B(67) = dA(40)/dV(98)
  B(67) = RCT(40)*V(105)
! B(68) = dA(40)/dV(105)
  B(68) = RCT(40)*V(98)
! B(69) = dA(41)/dV(98)
  B(69) = RCT(41)*2*V(98)
! B(70) = dA(42)/dV(98)
  B(70) = RCT(42)*2*V(98)
! B(71) = dA(43)/dV(98)
  B(71) = RCT(43)*V(106)
! B(72) = dA(43)/dV(106)
  B(72) = RCT(43)*V(98)
! B(73) = dA(44)/dV(105)
  B(73) = RCT(44)*V(106)
! B(74) = dA(44)/dV(106)
  B(74) = RCT(44)*V(105)
! B(75) = dA(45)/dV(69)
  B(75) = RCT(45)*V(105)
! B(76) = dA(45)/dV(105)
  B(76) = RCT(45)*V(69)
! B(77) = dA(46)/dV(103)
  B(77) = RCT(46)*V(105)
! B(78) = dA(46)/dV(105)
  B(78) = RCT(46)*V(103)
! B(79) = dA(47)/dV(98)
  B(79) = RCT(47)*V(103)
! B(80) = dA(47)/dV(103)
  B(80) = RCT(47)*V(98)
! B(81) = dA(48)/dV(103)
  B(81) = RCT(48)*V(106)
! B(82) = dA(48)/dV(106)
  B(82) = RCT(48)*V(103)
! B(83) = dA(49)/dV(96)
  B(83) = RCT(49)*V(103)
! B(84) = dA(49)/dV(103)
  B(84) = RCT(49)*V(96)
! B(85) = dA(50)/dV(103)
  B(85) = RCT(50)*2*V(103)
! B(86) = dA(51)/dV(63)
  B(86) = RCT(51)
! B(87) = dA(52)/dV(79)
  B(87) = RCT(52)
! B(88) = dA(53)/dV(56)
  B(88) = RCT(53)
! B(89) = dA(54)/dV(100)
  B(89) = RCT(54)*V(104)
! B(90) = dA(54)/dV(104)
  B(90) = RCT(54)*V(100)
! B(91) = dA(55)/dV(88)
  B(91) = RCT(55)*V(100)
! B(92) = dA(55)/dV(100)
  B(92) = RCT(55)*V(88)
! B(93) = dA(56)/dV(104)
  B(93) = RCT(56)*V(106)
! B(94) = dA(56)/dV(106)
  B(94) = RCT(56)*V(104)
! B(95) = dA(57)/dV(88)
  B(95) = RCT(57)*V(106)
! B(96) = dA(57)/dV(106)
  B(96) = RCT(57)*V(88)
! B(97) = dA(58)/dV(104)
  B(97) = RCT(58)*2*V(104)
! B(98) = dA(59)/dV(88)
  B(98) = RCT(59)*2*V(88)
! B(99) = dA(60)/dV(88)
  B(99) = RCT(60)*V(104)
! B(100) = dA(60)/dV(104)
  B(100) = RCT(60)*V(88)
! B(101) = dA(61)/dV(94)
  B(101) = RCT(61)*V(98)
! B(102) = dA(61)/dV(98)
  B(102) = RCT(61)*V(94)
! B(103) = dA(62)/dV(94)
  B(103) = RCT(62)
! B(104) = dA(63)/dV(73)
  B(104) = RCT(63)*V(98)
! B(105) = dA(63)/dV(98)
  B(105) = RCT(63)*V(73)
! B(106) = dA(64)/dV(73)
  B(106) = RCT(64)
! B(107) = dA(65)/dV(80)
  B(107) = RCT(65)*V(98)
! B(108) = dA(65)/dV(98)
  B(108) = RCT(65)*V(80)
! B(109) = dA(66)/dV(58)
  B(109) = RCT(66)*V(98)
! B(110) = dA(66)/dV(98)
  B(110) = RCT(66)*V(58)
! B(111) = dA(67)/dV(100)
  B(111) = RCT(67)*V(107)
! B(112) = dA(67)/dV(107)
  B(112) = RCT(67)*V(100)
! B(113) = dA(68)/dV(106)
  B(113) = RCT(68)*V(107)
! B(114) = dA(68)/dV(107)
  B(114) = RCT(68)*V(106)
! B(115) = dA(69)/dV(107)
  B(115) = RCT(69)*2*V(107)
! B(116) = dA(70)/dV(78)
  B(116) = RCT(70)*V(98)
! B(117) = dA(70)/dV(98)
  B(117) = RCT(70)*V(78)
! B(118) = dA(71)/dV(78)
  B(118) = RCT(71)
! B(119) = dA(72)/dV(68)
  B(119) = RCT(72)*V(98)
! B(120) = dA(72)/dV(98)
  B(120) = RCT(72)*V(68)
! B(121) = dA(73)/dV(95)
  B(121) = RCT(73)*V(98)
! B(122) = dA(73)/dV(98)
  B(122) = RCT(73)*V(95)
! B(123) = dA(74)/dV(95)
  B(123) = RCT(74)
! B(124) = dA(75)/dV(95)
  B(124) = RCT(75)
! B(125) = dA(76)/dV(95)
  B(125) = RCT(76)*V(105)
! B(126) = dA(76)/dV(105)
  B(126) = RCT(76)*V(95)
! B(127) = dA(77)/dV(95)
  B(127) = RCT(77)*V(103)
! B(128) = dA(77)/dV(103)
  B(128) = RCT(77)*V(95)
! B(129) = dA(78)/dV(95)
  B(129) = RCT(78)*V(106)
! B(130) = dA(78)/dV(106)
  B(130) = RCT(78)*V(95)
! B(131) = dA(79)/dV(71)
  B(131) = RCT(79)
! B(132) = dA(80)/dV(71)
  B(132) = RCT(80)*V(100)
! B(133) = dA(80)/dV(100)
  B(133) = RCT(80)*V(71)
! B(134) = dA(81)/dV(71)
  B(134) = RCT(81)*V(106)
! B(135) = dA(81)/dV(106)
  B(135) = RCT(81)*V(71)
! B(136) = dA(82)/dV(61)
  B(136) = RCT(82)*V(98)
! B(137) = dA(82)/dV(98)
  B(137) = RCT(82)*V(61)
! B(138) = dA(83)/dV(93)
  B(138) = RCT(83)*V(105)
! B(139) = dA(83)/dV(105)
  B(139) = RCT(83)*V(93)
! B(140) = dA(84)/dV(93)
  B(140) = RCT(84)*V(98)
! B(141) = dA(84)/dV(98)
  B(141) = RCT(84)*V(93)
! B(142) = dA(85)/dV(93)
  B(142) = RCT(85)*V(103)
! B(143) = dA(85)/dV(103)
  B(143) = RCT(85)*V(93)
! B(144) = dA(86)/dV(93)
  B(144) = RCT(86)
! B(145) = dA(87)/dV(97)
  B(145) = RCT(87)*V(100)
! B(146) = dA(87)/dV(100)
  B(146) = RCT(87)*V(97)
! B(147) = dA(88)/dV(97)
  B(147) = RCT(88)*V(101)
! B(148) = dA(88)/dV(101)
  B(148) = RCT(88)*V(97)
! B(149) = dA(89)/dV(51)
  B(149) = RCT(89)
! B(150) = dA(90)/dV(51)
  B(150) = RCT(90)
! B(151) = dA(91)/dV(97)
  B(151) = RCT(91)*V(106)
! B(152) = dA(91)/dV(106)
  B(152) = RCT(91)*V(97)
! B(153) = dA(92)/dV(97)
  B(153) = RCT(92)*V(107)
! B(154) = dA(92)/dV(107)
  B(154) = RCT(92)*V(97)
! B(155) = dA(93)/dV(97)
  B(155) = RCT(93)*V(104)
! B(156) = dA(93)/dV(104)
  B(156) = RCT(93)*V(97)
! B(157) = dA(94)/dV(97)
  B(157) = RCT(94)*2*V(97)
! B(158) = dA(95)/dV(64)
  B(158) = RCT(95)*V(98)
! B(159) = dA(95)/dV(98)
  B(159) = RCT(95)*V(64)
! B(160) = dA(96)/dV(64)
  B(160) = RCT(96)
! B(161) = dA(97)/dV(65)
  B(161) = RCT(97)*V(98)
! B(162) = dA(97)/dV(98)
  B(162) = RCT(97)*V(65)
! B(163) = dA(98)/dV(92)
  B(163) = RCT(98)*V(105)
! B(164) = dA(98)/dV(105)
  B(164) = RCT(98)*V(92)
! B(165) = dA(99)/dV(92)
  B(165) = RCT(99)*V(98)
! B(166) = dA(99)/dV(98)
  B(166) = RCT(99)*V(92)
! B(167) = dA(100)/dV(92)
  B(167) = RCT(100)*V(103)
! B(168) = dA(100)/dV(103)
  B(168) = RCT(100)*V(92)
! B(169) = dA(101)/dV(92)
  B(169) = RCT(101)
! B(170) = dA(102)/dV(99)
  B(170) = RCT(102)*V(100)
! B(171) = dA(102)/dV(100)
  B(171) = RCT(102)*V(99)
! B(172) = dA(103)/dV(99)
  B(172) = RCT(103)*V(101)
! B(173) = dA(103)/dV(101)
  B(173) = RCT(103)*V(99)
! B(174) = dA(104)/dV(66)
  B(174) = RCT(104)
! B(175) = dA(105)/dV(66)
  B(175) = RCT(105)
! B(176) = dA(106)/dV(66)
  B(176) = RCT(106)*V(98)
! B(177) = dA(106)/dV(98)
  B(177) = RCT(106)*V(66)
! B(178) = dA(107)/dV(99)
  B(178) = RCT(107)*V(106)
! B(179) = dA(107)/dV(106)
  B(179) = RCT(107)*V(99)
! B(180) = dA(108)/dV(99)
  B(180) = RCT(108)*V(107)
! B(181) = dA(108)/dV(107)
  B(181) = RCT(108)*V(99)
! B(182) = dA(109)/dV(99)
  B(182) = RCT(109)*V(104)
! B(183) = dA(109)/dV(104)
  B(183) = RCT(109)*V(99)
! B(184) = dA(110)/dV(99)
  B(184) = RCT(110)*2*V(99)
! B(185) = dA(111)/dV(97)
  B(185) = RCT(111)*V(99)
! B(186) = dA(111)/dV(99)
  B(186) = RCT(111)*V(97)
! B(187) = dA(112)/dV(89)
  B(187) = RCT(112)*V(98)
! B(188) = dA(112)/dV(98)
  B(188) = RCT(112)*V(89)
! B(189) = dA(113)/dV(82)
  B(189) = RCT(113)
! B(190) = dA(114)/dV(82)
  B(190) = 1600
! B(191) = dA(115)/dV(82)
  B(191) = RCT(115)*V(101)
! B(192) = dA(115)/dV(101)
  B(192) = RCT(115)*V(82)
! B(193) = dA(116)/dV(87)
  B(193) = RCT(116)*V(105)
! B(194) = dA(116)/dV(105)
  B(194) = RCT(116)*V(87)
! B(195) = dA(117)/dV(87)
  B(195) = RCT(117)*V(98)
! B(196) = dA(117)/dV(98)
  B(196) = RCT(117)*V(87)
! B(197) = dA(118)/dV(87)
  B(197) = RCT(118)*V(96)
! B(198) = dA(118)/dV(96)
  B(198) = RCT(118)*V(87)
! B(199) = dA(119)/dV(87)
  B(199) = RCT(119)*V(103)
! B(200) = dA(119)/dV(103)
  B(200) = RCT(119)*V(87)
! B(201) = dA(120)/dV(83)
  B(201) = RCT(120)*V(105)
! B(202) = dA(120)/dV(105)
  B(202) = RCT(120)*V(83)
! B(203) = dA(121)/dV(83)
  B(203) = RCT(121)*V(98)
! B(204) = dA(121)/dV(98)
  B(204) = RCT(121)*V(83)
! B(205) = dA(122)/dV(83)
  B(205) = RCT(122)*V(96)
! B(206) = dA(122)/dV(96)
  B(206) = RCT(122)*V(83)
! B(207) = dA(123)/dV(83)
  B(207) = RCT(123)*V(103)
! B(208) = dA(123)/dV(103)
  B(208) = RCT(123)*V(83)
! B(209) = dA(124)/dV(86)
  B(209) = RCT(124)*V(105)
! B(210) = dA(124)/dV(105)
  B(210) = RCT(124)*V(86)
! B(211) = dA(125)/dV(86)
  B(211) = RCT(125)*V(98)
! B(212) = dA(125)/dV(98)
  B(212) = RCT(125)*V(86)
! B(213) = dA(126)/dV(86)
  B(213) = RCT(126)*V(96)
! B(214) = dA(126)/dV(96)
  B(214) = RCT(126)*V(86)
! B(215) = dA(127)/dV(86)
  B(215) = RCT(127)*V(103)
! B(216) = dA(127)/dV(103)
  B(216) = RCT(127)*V(86)
! B(217) = dA(128)/dV(53)
  B(217) = RCT(128)*V(98)
! B(218) = dA(128)/dV(98)
  B(218) = RCT(128)*V(53)
! B(219) = dA(129)/dV(62)
  B(219) = RCT(129)*V(100)
! B(220) = dA(129)/dV(100)
  B(220) = RCT(129)*V(62)
! B(221) = dA(130)/dV(62)
  B(221) = 4.2
! B(222) = dA(131)/dV(84)
  B(222) = RCT(131)*V(98)
! B(223) = dA(131)/dV(98)
  B(223) = RCT(131)*V(84)
! B(224) = dA(132)/dV(84)
  B(224) = RCT(132)*V(103)
! B(225) = dA(132)/dV(103)
  B(225) = RCT(132)*V(84)
! B(226) = dA(133)/dV(74)
  B(226) = RCT(133)*V(101)
! B(227) = dA(133)/dV(101)
  B(227) = RCT(133)*V(74)
! B(228) = dA(134)/dV(74)
  B(228) = RCT(134)*V(106)
! B(229) = dA(134)/dV(106)
  B(229) = RCT(134)*V(74)
! B(230) = dA(135)/dV(81)
  B(230) = RCT(135)
! B(231) = dA(136)/dV(81)
  B(231) = RCT(136)*V(98)
! B(232) = dA(136)/dV(98)
  B(232) = RCT(136)*V(81)
! B(233) = dA(137)/dV(81)
  B(233) = RCT(137)*V(96)
! B(234) = dA(137)/dV(96)
  B(234) = RCT(137)*V(81)
! B(235) = dA(138)/dV(57)
  B(235) = RCT(138)*V(98)
! B(236) = dA(138)/dV(98)
  B(236) = RCT(138)*V(57)
! B(237) = dA(139)/dV(76)
  B(237) = RCT(139)*V(98)
! B(238) = dA(139)/dV(98)
  B(238) = RCT(139)*V(76)
! B(239) = dA(140)/dV(76)
  B(239) = RCT(140)
! B(240) = dA(141)/dV(90)
  B(240) = RCT(141)*V(105)
! B(241) = dA(141)/dV(105)
  B(241) = RCT(141)*V(90)
! B(242) = dA(142)/dV(90)
  B(242) = RCT(142)*V(98)
! B(243) = dA(142)/dV(98)
  B(243) = RCT(142)*V(90)
! B(244) = dA(143)/dV(90)
  B(244) = RCT(143)*V(96)
! B(245) = dA(143)/dV(96)
  B(245) = RCT(143)*V(90)
! B(246) = dA(144)/dV(90)
  B(246) = RCT(144)*V(103)
! B(247) = dA(144)/dV(103)
  B(247) = RCT(144)*V(90)
! B(248) = dA(145)/dV(91)
  B(248) = RCT(145)*V(98)
! B(249) = dA(145)/dV(98)
  B(249) = RCT(145)*V(91)
! B(250) = dA(146)/dV(91)
  B(250) = RCT(146)*V(96)
! B(251) = dA(146)/dV(96)
  B(251) = RCT(146)*V(91)
! B(252) = dA(147)/dV(91)
  B(252) = RCT(147)*V(103)
! B(253) = dA(147)/dV(103)
  B(253) = RCT(147)*V(91)
! B(254) = dA(148)/dV(91)
  B(254) = RCT(148)
! B(255) = dA(149)/dV(85)
  B(255) = RCT(149)*V(105)
! B(256) = dA(149)/dV(105)
  B(256) = RCT(149)*V(85)
! B(257) = dA(150)/dV(85)
  B(257) = RCT(150)*V(98)
! B(258) = dA(150)/dV(98)
  B(258) = RCT(150)*V(85)
! B(259) = dA(151)/dV(85)
  B(259) = RCT(151)*V(96)
! B(260) = dA(151)/dV(96)
  B(260) = RCT(151)*V(85)
! B(261) = dA(152)/dV(85)
  B(261) = RCT(152)*V(103)
! B(262) = dA(152)/dV(103)
  B(262) = RCT(152)*V(85)
! B(263) = dA(153)/dV(50)
  B(263) = RCT(153)*V(98)
! B(264) = dA(153)/dV(98)
  B(264) = RCT(153)*V(50)
! B(265) = dA(154)/dV(70)
  B(265) = RCT(154)*V(98)
! B(266) = dA(154)/dV(98)
  B(266) = RCT(154)*V(70)
! B(267) = dA(155)/dV(67)
  B(267) = RCT(155)*V(98)
! B(268) = dA(155)/dV(98)
  B(268) = RCT(155)*V(67)
! B(269) = dA(156)/dV(90)
  B(269) = RCT(156)*V(101)
! B(270) = dA(156)/dV(101)
  B(270) = RCT(156)*V(90)
! B(271) = dA(157)/dV(49)
  B(271) = RCT(157)
! B(272) = dA(158)/dV(52)
  B(272) = RCT(158)
! B(273) = dA(159)/dV(96)
  B(273) = RCT(159)*V(102)
! B(274) = dA(159)/dV(102)
  B(274) = RCT(159)*V(96)
! B(275) = dA(160)/dV(75)
  B(275) = RCT(160)*2*V(75)
! B(276) = dA(161)/dV(75)
  B(276) = RCT(161)*V(100)
! B(277) = dA(161)/dV(100)
  B(277) = RCT(161)*V(75)
! B(278) = dA(162)/dV(75)
  B(278) = RCT(162)*V(106)
! B(279) = dA(162)/dV(106)
  B(279) = RCT(162)*V(75)
! B(280) = dA(163)/dV(77)
  B(280) = RCT(163)*V(98)
! B(281) = dA(163)/dV(98)
  B(281) = RCT(163)*V(77)
! B(282) = dA(164)/dV(77)
  B(282) = RCT(164)
! B(283) = dA(165)/dV(58)
  B(283) = RCT(165)*V(102)
! B(284) = dA(165)/dV(102)
  B(284) = RCT(165)*V(58)
! B(285) = dA(166)/dV(89)
  B(285) = RCT(166)*V(102)
! B(286) = dA(166)/dV(102)
  B(286) = RCT(166)*V(89)
! B(287) = dA(167)/dV(67)
  B(287) = RCT(167)*V(102)
! B(288) = dA(167)/dV(102)
  B(288) = RCT(167)*V(67)
! B(289) = dA(168)/dV(83)
  B(289) = RCT(168)*V(102)
! B(290) = dA(168)/dV(102)
  B(290) = RCT(168)*V(83)
! B(291) = dA(169)/dV(87)
  B(291) = RCT(169)*V(102)
! B(292) = dA(169)/dV(102)
  B(292) = RCT(169)*V(87)
! B(293) = dA(170)/dV(86)
  B(293) = RCT(170)*V(102)
! B(294) = dA(170)/dV(102)
  B(294) = RCT(170)*V(86)
! B(295) = dA(171)/dV(90)
  B(295) = RCT(171)*V(102)
! B(296) = dA(171)/dV(102)
  B(296) = RCT(171)*V(90)
! B(297) = dA(172)/dV(95)
  B(297) = RCT(172)*V(102)
! B(298) = dA(172)/dV(102)
  B(298) = RCT(172)*V(95)
! B(299) = dA(173)/dV(93)
  B(299) = RCT(173)*V(102)
! B(300) = dA(173)/dV(102)
  B(300) = RCT(173)*V(93)
! B(301) = dA(174)/dV(92)
  B(301) = RCT(174)*V(102)
! B(302) = dA(174)/dV(102)
  B(302) = RCT(174)*V(92)
! B(303) = dA(175)/dV(68)
  B(303) = RCT(175)*V(102)
! B(304) = dA(175)/dV(102)
  B(304) = RCT(175)*V(68)
! B(305) = dA(176)/dV(70)
  B(305) = RCT(176)*V(102)
! B(306) = dA(176)/dV(102)
  B(306) = RCT(176)*V(70)
! B(307) = dA(177)/dV(72)
  B(307) = RCT(177)*V(98)
! B(308) = dA(177)/dV(98)
  B(308) = RCT(177)*V(72)
! B(309) = dA(178)/dV(59)
  B(309) = RCT(178)*V(96)
! B(310) = dA(178)/dV(96)
  B(310) = RCT(178)*V(59)
! B(311) = dA(179)/dV(59)
  B(311) = RCT(179)*V(98)
! B(312) = dA(179)/dV(98)
  B(312) = RCT(179)*V(59)
! B(313) = dA(180)/dV(59)
  B(313) = RCT(180)*V(69)
! B(314) = dA(180)/dV(69)
  B(314) = RCT(180)*V(59)
! B(315) = dA(181)/dV(12)
  B(315) = RCT(181)*V(98)
! B(316) = dA(181)/dV(98)
  B(316) = RCT(181)*V(12)
! B(317) = dA(182)/dV(15)
  B(317) = RCT(182)*V(98)
! B(318) = dA(182)/dV(98)
  B(318) = RCT(182)*V(15)
! B(319) = dA(183)/dV(18)
  B(319) = RCT(183)*V(98)
! B(320) = dA(183)/dV(98)
  B(320) = RCT(183)*V(18)
! B(321) = dA(184)/dV(23)
  B(321) = RCT(184)*V(98)
! B(322) = dA(184)/dV(98)
  B(322) = RCT(184)*V(23)
! B(323) = dA(185)/dV(23)
  B(323) = RCT(185)*V(96)
! B(324) = dA(185)/dV(96)
  B(324) = RCT(185)*V(23)
! B(325) = dA(186)/dV(29)
  B(325) = RCT(186)*V(98)
! B(326) = dA(186)/dV(98)
  B(326) = RCT(186)*V(29)
! B(327) = dA(187)/dV(29)
  B(327) = RCT(187)*V(96)
! B(328) = dA(187)/dV(96)
  B(328) = RCT(187)*V(29)
! B(329) = dA(188)/dV(29)
  B(329) = RCT(188)*V(103)
! B(330) = dA(188)/dV(103)
  B(330) = RCT(188)*V(29)
! B(331) = dA(189)/dV(32)
  B(331) = RCT(189)*V(98)
! B(332) = dA(189)/dV(98)
  B(332) = RCT(189)*V(32)
! B(333) = dA(190)/dV(34)
  B(333) = RCT(190)*V(98)
! B(334) = dA(190)/dV(98)
  B(334) = RCT(190)*V(34)
! B(335) = dA(191)/dV(37)
  B(335) = RCT(191)*V(98)
! B(336) = dA(191)/dV(98)
  B(336) = RCT(191)*V(37)
! B(337) = dA(192)/dV(42)
  B(337) = RCT(192)*V(98)
! B(338) = dA(192)/dV(98)
  B(338) = RCT(192)*V(42)
! B(339) = dA(193)/dV(41)
  B(339) = RCT(193)*V(98)
! B(340) = dA(193)/dV(98)
  B(340) = RCT(193)*V(41)
! B(341) = dA(194)/dV(40)
  B(341) = RCT(194)*V(98)
! B(342) = dA(194)/dV(98)
  B(342) = RCT(194)*V(40)
! B(343) = dA(195)/dV(46)
  B(343) = RCT(195)*V(98)
! B(344) = dA(195)/dV(98)
  B(344) = RCT(195)*V(46)
! B(345) = dA(196)/dV(45)
  B(345) = RCT(196)*V(98)
! B(346) = dA(196)/dV(98)
  B(346) = RCT(196)*V(45)
! B(347) = dA(197)/dV(44)
  B(347) = RCT(197)*V(98)
! B(348) = dA(197)/dV(98)
  B(348) = RCT(197)*V(44)
! B(349) = dA(198)/dV(50)
  B(349) = RCT(198)

! Construct the Jacobian terms from B's
! JVS(1) = Jac_FULL(1,1)
  JVS(1) = 0
! JVS(2) = Jac_FULL(1,53)
  JVS(2) = 0.071*B(217)
! JVS(3) = Jac_FULL(1,98)
  JVS(3) = 0.071*B(218)
! JVS(4) = Jac_FULL(2,2)
  JVS(4) = 0
! JVS(5) = Jac_FULL(2,53)
  JVS(5) = 0.138*B(217)
! JVS(6) = Jac_FULL(2,98)
  JVS(6) = 0.138*B(218)
! JVS(7) = Jac_FULL(3,3)
  JVS(7) = 0
! JVS(8) = Jac_FULL(3,84)
  JVS(8) = B(222)+B(224)
! JVS(9) = Jac_FULL(3,98)
  JVS(9) = B(223)
! JVS(10) = Jac_FULL(3,103)
  JVS(10) = B(225)
! JVS(11) = Jac_FULL(4,4)
  JVS(11) = 0
! JVS(12) = Jac_FULL(4,57)
  JVS(12) = 0.038*B(235)
! JVS(13) = Jac_FULL(4,98)
  JVS(13) = 0.038*B(236)
! JVS(14) = Jac_FULL(5,5)
  JVS(14) = 0
! JVS(15) = Jac_FULL(5,57)
  JVS(15) = 0.167*B(235)
! JVS(16) = Jac_FULL(5,98)
  JVS(16) = 0.167*B(236)
! JVS(17) = Jac_FULL(6,6)
  JVS(17) = 0
! JVS(18) = Jac_FULL(6,90)
  JVS(18) = 0.232*B(240)+0.232*B(242)+0.232*B(244)+0.232*B(246)
! JVS(19) = Jac_FULL(6,96)
  JVS(19) = 0.232*B(245)
! JVS(20) = Jac_FULL(6,98)
  JVS(20) = 0.232*B(243)
! JVS(21) = Jac_FULL(6,103)
  JVS(21) = 0.232*B(247)
! JVS(22) = Jac_FULL(6,105)
  JVS(22) = 0.232*B(241)
! JVS(23) = Jac_FULL(7,7)
  JVS(23) = 0
! JVS(24) = Jac_FULL(7,90)
  JVS(24) = 0.0228*B(240)+0.0288*B(242)+0.0288*B(244)+0.0288*B(246)
! JVS(25) = Jac_FULL(7,96)
  JVS(25) = 0.0288*B(245)
! JVS(26) = Jac_FULL(7,98)
  JVS(26) = 0.0288*B(243)
! JVS(27) = Jac_FULL(7,103)
  JVS(27) = 0.0288*B(247)
! JVS(28) = Jac_FULL(7,105)
  JVS(28) = 0.0228*B(241)
! JVS(29) = Jac_FULL(8,8)
  JVS(29) = 0
! JVS(30) = Jac_FULL(8,50)
  JVS(30) = B(263)+B(349)
! JVS(31) = Jac_FULL(8,98)
  JVS(31) = B(264)
! JVS(32) = Jac_FULL(9,9)
  JVS(32) = 0
! JVS(33) = Jac_FULL(9,50)
  JVS(33) = B(263)
! JVS(34) = Jac_FULL(9,98)
  JVS(34) = B(264)
! JVS(35) = Jac_FULL(10,10)
  JVS(35) = 0
! JVS(36) = Jac_FULL(10,85)
  JVS(36) = B(255)+B(257)+B(259)+B(261)
! JVS(37) = Jac_FULL(10,96)
  JVS(37) = B(260)
! JVS(38) = Jac_FULL(10,98)
  JVS(38) = B(258)
! JVS(39) = Jac_FULL(10,103)
  JVS(39) = B(262)
! JVS(40) = Jac_FULL(10,105)
  JVS(40) = B(256)
! JVS(41) = Jac_FULL(11,11)
  JVS(41) = 0
! JVS(42) = Jac_FULL(11,12)
  JVS(42) = B(315)
! JVS(43) = Jac_FULL(11,98)
  JVS(43) = B(316)
! JVS(44) = Jac_FULL(12,12)
  JVS(44) = -B(315)
! JVS(45) = Jac_FULL(12,98)
  JVS(45) = -B(316)
! JVS(46) = Jac_FULL(13,13)
  JVS(46) = 0
! JVS(47) = Jac_FULL(13,15)
  JVS(47) = 0.239*B(317)
! JVS(48) = Jac_FULL(13,98)
  JVS(48) = 0.239*B(318)
! JVS(49) = Jac_FULL(14,14)
  JVS(49) = 0
! JVS(50) = Jac_FULL(14,15)
  JVS(50) = 0.363*B(317)
! JVS(51) = Jac_FULL(14,98)
  JVS(51) = 0.363*B(318)
! JVS(52) = Jac_FULL(15,15)
  JVS(52) = -B(317)
! JVS(53) = Jac_FULL(15,98)
  JVS(53) = -B(318)
! JVS(54) = Jac_FULL(16,16)
  JVS(54) = 0
! JVS(55) = Jac_FULL(16,18)
  JVS(55) = 0.045*B(319)
! JVS(56) = Jac_FULL(16,98)
  JVS(56) = 0.045*B(320)
! JVS(57) = Jac_FULL(17,17)
  JVS(57) = 0
! JVS(58) = Jac_FULL(17,18)
  JVS(58) = 0.149*B(319)
! JVS(59) = Jac_FULL(17,98)
  JVS(59) = 0.149*B(320)
! JVS(60) = Jac_FULL(18,18)
  JVS(60) = -B(319)
! JVS(61) = Jac_FULL(18,98)
  JVS(61) = -B(320)
! JVS(62) = Jac_FULL(19,19)
  JVS(62) = 0
! JVS(63) = Jac_FULL(19,23)
  JVS(63) = 0.038*B(321)
! JVS(64) = Jac_FULL(19,98)
  JVS(64) = 0.038*B(322)
! JVS(65) = Jac_FULL(20,20)
  JVS(65) = 0
! JVS(66) = Jac_FULL(20,23)
  JVS(66) = 0.326*B(321)
! JVS(67) = Jac_FULL(20,98)
  JVS(67) = 0.326*B(322)
! JVS(68) = Jac_FULL(21,21)
  JVS(68) = 0
! JVS(69) = Jac_FULL(21,23)
  JVS(69) = 0.125*B(323)
! JVS(70) = Jac_FULL(21,96)
  JVS(70) = 0.125*B(324)
! JVS(71) = Jac_FULL(22,22)
  JVS(71) = 0
! JVS(72) = Jac_FULL(22,23)
  JVS(72) = 0.102*B(323)
! JVS(73) = Jac_FULL(22,96)
  JVS(73) = 0.102*B(324)
! JVS(74) = Jac_FULL(23,23)
  JVS(74) = -B(321)-B(323)
! JVS(75) = Jac_FULL(23,96)
  JVS(75) = -B(324)
! JVS(76) = Jac_FULL(23,98)
  JVS(76) = -B(322)
! JVS(77) = Jac_FULL(24,24)
  JVS(77) = 0
! JVS(78) = Jac_FULL(24,29)
  JVS(78) = 0.13*B(325)
! JVS(79) = Jac_FULL(24,98)
  JVS(79) = 0.13*B(326)
! JVS(80) = Jac_FULL(25,25)
  JVS(80) = 0
! JVS(81) = Jac_FULL(25,29)
  JVS(81) = 0.0406*B(325)
! JVS(82) = Jac_FULL(25,98)
  JVS(82) = 0.0406*B(326)
! JVS(83) = Jac_FULL(26,26)
  JVS(83) = 0
! JVS(84) = Jac_FULL(26,29)
  JVS(84) = 0.026*B(327)
! JVS(85) = Jac_FULL(26,96)
  JVS(85) = 0.026*B(328)
! JVS(86) = Jac_FULL(27,27)
  JVS(86) = 0
! JVS(87) = Jac_FULL(27,29)
  JVS(87) = 0.485*B(327)
! JVS(88) = Jac_FULL(27,96)
  JVS(88) = 0.485*B(328)
! JVS(89) = Jac_FULL(28,28)
  JVS(89) = 0
! JVS(90) = Jac_FULL(28,29)
  JVS(90) = B(329)
! JVS(91) = Jac_FULL(28,103)
  JVS(91) = B(330)
! JVS(92) = Jac_FULL(29,29)
  JVS(92) = -B(325)-B(327)-B(329)
! JVS(93) = Jac_FULL(29,96)
  JVS(93) = -B(328)
! JVS(94) = Jac_FULL(29,98)
  JVS(94) = -B(326)
! JVS(95) = Jac_FULL(29,103)
  JVS(95) = -B(330)
! JVS(96) = Jac_FULL(30,30)
  JVS(96) = 0
! JVS(97) = Jac_FULL(30,32)
  JVS(97) = 0.091*B(331)
! JVS(98) = Jac_FULL(30,98)
  JVS(98) = 0.091*B(332)
! JVS(99) = Jac_FULL(31,31)
  JVS(99) = 0
! JVS(100) = Jac_FULL(31,32)
  JVS(100) = 0.367*B(331)
! JVS(101) = Jac_FULL(31,98)
  JVS(101) = 0.367*B(332)
! JVS(102) = Jac_FULL(32,32)
  JVS(102) = -B(331)
! JVS(103) = Jac_FULL(32,98)
  JVS(103) = -B(332)
! JVS(104) = Jac_FULL(33,33)
  JVS(104) = 0
! JVS(105) = Jac_FULL(33,34)
  JVS(105) = 1.173*B(333)
! JVS(106) = Jac_FULL(33,98)
  JVS(106) = 1.173*B(334)
! JVS(107) = Jac_FULL(34,34)
  JVS(107) = -B(333)
! JVS(108) = Jac_FULL(34,98)
  JVS(108) = -B(334)
! JVS(109) = Jac_FULL(35,35)
  JVS(109) = 0
! JVS(110) = Jac_FULL(35,37)
  JVS(110) = 0.156*B(335)
! JVS(111) = Jac_FULL(35,98)
  JVS(111) = 0.156*B(336)
! JVS(112) = Jac_FULL(36,36)
  JVS(112) = 0
! JVS(113) = Jac_FULL(36,37)
  JVS(113) = 0.777*B(335)
! JVS(114) = Jac_FULL(36,98)
  JVS(114) = 0.777*B(336)
! JVS(115) = Jac_FULL(37,37)
  JVS(115) = -B(335)
! JVS(116) = Jac_FULL(37,98)
  JVS(116) = -B(336)
! JVS(117) = Jac_FULL(38,38)
  JVS(117) = 0
! JVS(118) = Jac_FULL(38,59)
  JVS(118) = B(309)+B(311)+B(313)
! JVS(119) = Jac_FULL(38,69)
  JVS(119) = B(314)
! JVS(120) = Jac_FULL(38,96)
  JVS(120) = B(310)
! JVS(121) = Jac_FULL(38,98)
  JVS(121) = B(312)
! JVS(122) = Jac_FULL(39,39)
  JVS(122) = 0
! JVS(123) = Jac_FULL(39,40)
  JVS(123) = 1.075*B(341)
! JVS(124) = Jac_FULL(39,98)
  JVS(124) = 1.075*B(342)
! JVS(125) = Jac_FULL(40,40)
  JVS(125) = -B(341)
! JVS(126) = Jac_FULL(40,41)
  JVS(126) = 1.075*B(339)
! JVS(127) = Jac_FULL(40,98)
  JVS(127) = 1.075*B(340)-B(342)
! JVS(128) = Jac_FULL(41,41)
  JVS(128) = -B(339)
! JVS(129) = Jac_FULL(41,42)
  JVS(129) = 1.075*B(337)
! JVS(130) = Jac_FULL(41,98)
  JVS(130) = 1.075*B(338)-B(340)
! JVS(131) = Jac_FULL(42,42)
  JVS(131) = -B(337)
! JVS(132) = Jac_FULL(42,98)
  JVS(132) = -B(338)
! JVS(133) = Jac_FULL(43,43)
  JVS(133) = 0
! JVS(134) = Jac_FULL(43,44)
  JVS(134) = 1.075*B(347)
! JVS(135) = Jac_FULL(43,98)
  JVS(135) = 1.075*B(348)
! JVS(136) = Jac_FULL(44,44)
  JVS(136) = -B(347)
! JVS(137) = Jac_FULL(44,45)
  JVS(137) = 1.075*B(345)
! JVS(138) = Jac_FULL(44,98)
  JVS(138) = 1.075*B(346)-B(348)
! JVS(139) = Jac_FULL(45,45)
  JVS(139) = -B(345)
! JVS(140) = Jac_FULL(45,46)
  JVS(140) = 1.075*B(343)
! JVS(141) = Jac_FULL(45,98)
  JVS(141) = 1.075*B(344)-B(346)
! JVS(142) = Jac_FULL(46,46)
  JVS(142) = -B(343)
! JVS(143) = Jac_FULL(46,98)
  JVS(143) = -B(344)
! JVS(144) = Jac_FULL(47,47)
  JVS(144) = 0
! JVS(145) = Jac_FULL(47,80)
  JVS(145) = B(107)
! JVS(146) = Jac_FULL(47,98)
  JVS(146) = B(108)
! JVS(147) = Jac_FULL(48,48)
  JVS(147) = 0
! JVS(148) = Jac_FULL(48,53)
  JVS(148) = B(217)
! JVS(149) = Jac_FULL(48,57)
  JVS(149) = B(235)
! JVS(150) = Jac_FULL(48,61)
  JVS(150) = B(136)
! JVS(151) = Jac_FULL(48,64)
  JVS(151) = B(158)
! JVS(152) = Jac_FULL(48,65)
  JVS(152) = B(161)
! JVS(153) = Jac_FULL(48,67)
  JVS(153) = B(267)
! JVS(154) = Jac_FULL(48,68)
  JVS(154) = B(119)
! JVS(155) = Jac_FULL(48,70)
  JVS(155) = B(265)
! JVS(156) = Jac_FULL(48,76)
  JVS(156) = B(237)
! JVS(157) = Jac_FULL(48,78)
  JVS(157) = B(116)
! JVS(158) = Jac_FULL(48,81)
  JVS(158) = B(231)
! JVS(159) = Jac_FULL(48,83)
  JVS(159) = B(203)
! JVS(160) = Jac_FULL(48,84)
  JVS(160) = B(222)
! JVS(161) = Jac_FULL(48,85)
  JVS(161) = B(257)
! JVS(162) = Jac_FULL(48,86)
  JVS(162) = B(211)
! JVS(163) = Jac_FULL(48,87)
  JVS(163) = B(195)
! JVS(164) = Jac_FULL(48,89)
  JVS(164) = B(187)
! JVS(165) = Jac_FULL(48,90)
  JVS(165) = B(242)
! JVS(166) = Jac_FULL(48,91)
  JVS(166) = B(248)
! JVS(167) = Jac_FULL(48,92)
  JVS(167) = B(165)
! JVS(168) = Jac_FULL(48,93)
  JVS(168) = B(140)
! JVS(169) = Jac_FULL(48,95)
  JVS(169) = B(121)
! JVS(170) = Jac_FULL(48,98)
  JVS(170) = B(117)+B(120)+B(122)+B(137)+B(141)+B(159)+B(162)+B(166)+B(188)+B(196)+B(204)+B(212)+B(218)+B(223)+B(232)&
               &+B(236)+B(238)+B(243)+B(249)+B(258)+B(266)+B(268)
! JVS(171) = Jac_FULL(49,49)
  JVS(171) = -B(271)
! JVS(172) = Jac_FULL(49,75)
  JVS(172) = 0.3*B(275)
! JVS(173) = Jac_FULL(50,50)
  JVS(173) = -B(263)-B(349)
! JVS(174) = Jac_FULL(50,98)
  JVS(174) = -B(264)
! JVS(175) = Jac_FULL(51,51)
  JVS(175) = -B(149)-B(150)
! JVS(176) = Jac_FULL(51,97)
  JVS(176) = B(147)
! JVS(177) = Jac_FULL(51,101)
  JVS(177) = B(148)
! JVS(178) = Jac_FULL(52,52)
  JVS(178) = -B(272)
! JVS(179) = Jac_FULL(52,75)
  JVS(179) = B(278)
! JVS(180) = Jac_FULL(52,106)
  JVS(180) = B(279)
! JVS(181) = Jac_FULL(53,53)
  JVS(181) = -B(217)
! JVS(182) = Jac_FULL(53,98)
  JVS(182) = -B(218)
! JVS(183) = Jac_FULL(54,54)
  JVS(183) = -B(63)-B(65)
! JVS(184) = Jac_FULL(54,55)
  JVS(184) = -B(64)
! JVS(185) = Jac_FULL(54,98)
  JVS(185) = -B(66)
! JVS(186) = Jac_FULL(55,54)
  JVS(186) = -B(63)
! JVS(187) = Jac_FULL(55,55)
  JVS(187) = -B(15)-B(17)-B(64)
! JVS(188) = Jac_FULL(55,96)
  JVS(188) = B(14)
! JVS(189) = Jac_FULL(55,98)
  JVS(189) = 0
! JVS(190) = Jac_FULL(56,56)
  JVS(190) = -B(31)-B(33)-B(35)-B(88)
! JVS(191) = Jac_FULL(56,101)
  JVS(191) = B(29)
! JVS(192) = Jac_FULL(56,103)
  JVS(192) = B(30)
! JVS(193) = Jac_FULL(57,57)
  JVS(193) = -B(235)
! JVS(194) = Jac_FULL(57,98)
  JVS(194) = -B(236)
! JVS(195) = Jac_FULL(58,58)
  JVS(195) = -B(109)-B(283)
! JVS(196) = Jac_FULL(58,98)
  JVS(196) = -B(110)
! JVS(197) = Jac_FULL(58,102)
  JVS(197) = -B(284)
! JVS(198) = Jac_FULL(59,59)
  JVS(198) = -B(309)-B(311)-B(313)
! JVS(199) = Jac_FULL(59,69)
  JVS(199) = -B(314)
! JVS(200) = Jac_FULL(59,96)
  JVS(200) = -B(310)
! JVS(201) = Jac_FULL(59,98)
  JVS(201) = -B(312)
! JVS(202) = Jac_FULL(60,60)
  JVS(202) = -B(42)-B(43)-2*B(45)
! JVS(203) = Jac_FULL(60,98)
  JVS(203) = B(40)-B(44)
! JVS(204) = Jac_FULL(60,100)
  JVS(204) = 2*B(37)+B(41)
! JVS(205) = Jac_FULL(60,101)
  JVS(205) = 2*B(38)
! JVS(206) = Jac_FULL(61,61)
  JVS(206) = -B(136)
! JVS(207) = Jac_FULL(61,71)
  JVS(207) = B(132)
! JVS(208) = Jac_FULL(61,83)
  JVS(208) = 0.37*B(205)
! JVS(209) = Jac_FULL(61,96)
  JVS(209) = 0.37*B(206)
! JVS(210) = Jac_FULL(61,98)
  JVS(210) = -B(137)
! JVS(211) = Jac_FULL(61,100)
  JVS(211) = B(133)
! JVS(212) = Jac_FULL(62,53)
  JVS(212) = 0.56*B(217)
! JVS(213) = Jac_FULL(62,57)
  JVS(213) = 0.3*B(235)
! JVS(214) = Jac_FULL(62,62)
  JVS(214) = -B(219)-B(221)
! JVS(215) = Jac_FULL(62,98)
  JVS(215) = 0.56*B(218)+0.3*B(236)
! JVS(216) = Jac_FULL(62,100)
  JVS(216) = -B(220)
! JVS(217) = Jac_FULL(63,63)
  JVS(217) = -B(54)-B(55)-B(86)
! JVS(218) = Jac_FULL(63,98)
  JVS(218) = -B(56)
! JVS(219) = Jac_FULL(63,101)
  JVS(219) = B(52)
! JVS(220) = Jac_FULL(63,106)
  JVS(220) = B(53)
! JVS(221) = Jac_FULL(64,64)
  JVS(221) = -B(158)-B(160)
! JVS(222) = Jac_FULL(64,97)
  JVS(222) = 0.8*B(151)
! JVS(223) = Jac_FULL(64,98)
  JVS(223) = -B(159)
! JVS(224) = Jac_FULL(64,99)
  JVS(224) = 0.8*B(178)
! JVS(225) = Jac_FULL(64,106)
  JVS(225) = 0.8*B(152)+0.8*B(179)
! JVS(226) = Jac_FULL(65,65)
  JVS(226) = -B(161)
! JVS(227) = Jac_FULL(65,97)
  JVS(227) = 0.2*B(151)+0.1*B(153)+0.1*B(155)
! JVS(228) = Jac_FULL(65,98)
  JVS(228) = -B(162)
! JVS(229) = Jac_FULL(65,99)
  JVS(229) = 0.2*B(178)+0.1*B(180)+0.1*B(182)
! JVS(230) = Jac_FULL(65,104)
  JVS(230) = 0.1*B(156)+0.1*B(183)
! JVS(231) = Jac_FULL(65,106)
  JVS(231) = 0.2*B(152)+0.2*B(179)
! JVS(232) = Jac_FULL(65,107)
  JVS(232) = 0.1*B(154)+0.1*B(181)
! JVS(233) = Jac_FULL(66,66)
  JVS(233) = -B(174)-B(175)-B(176)
! JVS(234) = Jac_FULL(66,98)
  JVS(234) = -B(177)
! JVS(235) = Jac_FULL(66,99)
  JVS(235) = B(172)
! JVS(236) = Jac_FULL(66,101)
  JVS(236) = B(173)
! JVS(237) = Jac_FULL(67,67)
  JVS(237) = -B(267)-B(287)
! JVS(238) = Jac_FULL(67,98)
  JVS(238) = -B(268)
! JVS(239) = Jac_FULL(67,102)
  JVS(239) = -B(288)
! JVS(240) = Jac_FULL(68,68)
  JVS(240) = -B(119)-B(303)
! JVS(241) = Jac_FULL(68,98)
  JVS(241) = -B(120)
! JVS(242) = Jac_FULL(68,102)
  JVS(242) = -B(304)
! JVS(243) = Jac_FULL(68,107)
  JVS(243) = 0.63*B(115)
! JVS(244) = Jac_FULL(69,59)
  JVS(244) = -B(313)
! JVS(245) = Jac_FULL(69,69)
  JVS(245) = -B(60)-B(61)-B(75)-B(314)
! JVS(246) = Jac_FULL(69,96)
  JVS(246) = 0
! JVS(247) = Jac_FULL(69,98)
  JVS(247) = -B(62)+B(70)
! JVS(248) = Jac_FULL(69,105)
  JVS(248) = -B(76)
! JVS(249) = Jac_FULL(69,106)
  JVS(249) = B(57)+B(58)
! JVS(250) = Jac_FULL(70,70)
  JVS(250) = -B(265)-B(305)
! JVS(251) = Jac_FULL(70,98)
  JVS(251) = -B(266)
! JVS(252) = Jac_FULL(70,102)
  JVS(252) = -B(306)
! JVS(253) = Jac_FULL(71,71)
  JVS(253) = -B(131)-B(132)-B(134)
! JVS(254) = Jac_FULL(71,95)
  JVS(254) = B(129)
! JVS(255) = Jac_FULL(71,100)
  JVS(255) = -B(133)
! JVS(256) = Jac_FULL(71,106)
  JVS(256) = B(130)-B(135)
! JVS(257) = Jac_FULL(72,58)
  JVS(257) = B(283)
! JVS(258) = Jac_FULL(72,67)
  JVS(258) = B(287)
! JVS(259) = Jac_FULL(72,68)
  JVS(259) = B(303)
! JVS(260) = Jac_FULL(72,70)
  JVS(260) = B(305)
! JVS(261) = Jac_FULL(72,72)
  JVS(261) = -B(307)
! JVS(262) = Jac_FULL(72,86)
  JVS(262) = 0.3*B(293)
! JVS(263) = Jac_FULL(72,89)
  JVS(263) = B(285)
! JVS(264) = Jac_FULL(72,90)
  JVS(264) = 0.15*B(295)
! JVS(265) = Jac_FULL(72,92)
  JVS(265) = B(301)
! JVS(266) = Jac_FULL(72,93)
  JVS(266) = B(299)
! JVS(267) = Jac_FULL(72,95)
  JVS(267) = B(297)
! JVS(268) = Jac_FULL(72,98)
  JVS(268) = -B(308)
! JVS(269) = Jac_FULL(72,102)
  JVS(269) = B(284)+B(286)+B(288)+0.3*B(294)+0.15*B(296)+B(298)+B(300)+B(302)+B(304)+B(306)
! JVS(270) = Jac_FULL(72,107)
  JVS(270) = 0
! JVS(271) = Jac_FULL(73,73)
  JVS(271) = -B(104)-B(106)
! JVS(272) = Jac_FULL(73,88)
  JVS(272) = B(95)
! JVS(273) = Jac_FULL(73,98)
  JVS(273) = -B(105)
! JVS(274) = Jac_FULL(73,104)
  JVS(274) = B(93)
! JVS(275) = Jac_FULL(73,106)
  JVS(275) = B(94)+B(96)
! JVS(276) = Jac_FULL(74,74)
  JVS(276) = -B(226)-B(228)
! JVS(277) = Jac_FULL(74,84)
  JVS(277) = 0.4*B(222)+B(224)
! JVS(278) = Jac_FULL(74,98)
  JVS(278) = 0.4*B(223)
! JVS(279) = Jac_FULL(74,101)
  JVS(279) = -B(227)
! JVS(280) = Jac_FULL(74,103)
  JVS(280) = B(225)
! JVS(281) = Jac_FULL(74,106)
  JVS(281) = -B(229)
! JVS(282) = Jac_FULL(75,75)
  JVS(282) = -2*B(275)-B(276)-B(278)
! JVS(283) = Jac_FULL(75,96)
  JVS(283) = B(273)
! JVS(284) = Jac_FULL(75,100)
  JVS(284) = -B(277)
! JVS(285) = Jac_FULL(75,102)
  JVS(285) = B(274)
! JVS(286) = Jac_FULL(75,106)
  JVS(286) = -B(279)
! JVS(287) = Jac_FULL(76,57)
  JVS(287) = 0.8*B(235)
! JVS(288) = Jac_FULL(76,76)
  JVS(288) = -B(237)-B(239)
! JVS(289) = Jac_FULL(76,81)
  JVS(289) = 0.2*B(233)
! JVS(290) = Jac_FULL(76,91)
  JVS(290) = 0.168*B(248)+0.85*B(250)
! JVS(291) = Jac_FULL(76,96)
  JVS(291) = 0.2*B(234)+0.85*B(251)
! JVS(292) = Jac_FULL(76,98)
  JVS(292) = 0.8*B(236)-B(238)+0.168*B(249)
! JVS(293) = Jac_FULL(77,77)
  JVS(293) = -B(280)-B(282)
! JVS(294) = Jac_FULL(77,83)
  JVS(294) = B(289)
! JVS(295) = Jac_FULL(77,86)
  JVS(295) = 0.7*B(293)
! JVS(296) = Jac_FULL(77,87)
  JVS(296) = B(291)
! JVS(297) = Jac_FULL(77,90)
  JVS(297) = 0.85*B(295)
! JVS(298) = Jac_FULL(77,98)
  JVS(298) = -B(281)
! JVS(299) = Jac_FULL(77,102)
  JVS(299) = B(290)+B(292)+0.7*B(294)+0.85*B(296)
! JVS(300) = Jac_FULL(78,71)
  JVS(300) = B(134)
! JVS(301) = Jac_FULL(78,78)
  JVS(301) = -B(116)-B(118)
! JVS(302) = Jac_FULL(78,95)
  JVS(302) = 0
! JVS(303) = Jac_FULL(78,98)
  JVS(303) = -B(117)
! JVS(304) = Jac_FULL(78,100)
  JVS(304) = 0
! JVS(305) = Jac_FULL(78,106)
  JVS(305) = B(113)+B(135)
! JVS(306) = Jac_FULL(78,107)
  JVS(306) = B(114)
! JVS(307) = Jac_FULL(79,56)
  JVS(307) = 2*B(31)+2*B(33)
! JVS(308) = Jac_FULL(79,79)
  JVS(308) = -B(48)-B(87)
! JVS(309) = Jac_FULL(79,84)
  JVS(309) = B(224)
! JVS(310) = Jac_FULL(79,91)
  JVS(310) = 0.15*B(252)
! JVS(311) = Jac_FULL(79,92)
  JVS(311) = B(167)
! JVS(312) = Jac_FULL(79,93)
  JVS(312) = B(142)
! JVS(313) = Jac_FULL(79,94)
  JVS(313) = B(101)
! JVS(314) = Jac_FULL(79,95)
  JVS(314) = B(127)
! JVS(315) = Jac_FULL(79,98)
  JVS(315) = B(46)-B(49)+B(102)
! JVS(316) = Jac_FULL(79,101)
  JVS(316) = B(47)
! JVS(317) = Jac_FULL(79,103)
  JVS(317) = B(81)+B(128)+B(143)+B(168)+B(225)+0.15*B(253)
! JVS(318) = Jac_FULL(79,106)
  JVS(318) = B(82)
! JVS(319) = Jac_FULL(80,76)
  JVS(319) = B(239)
! JVS(320) = Jac_FULL(80,77)
  JVS(320) = B(280)+B(282)
! JVS(321) = Jac_FULL(80,80)
  JVS(321) = -B(107)
! JVS(322) = Jac_FULL(80,81)
  JVS(322) = B(230)+2*B(231)+0.69*B(233)
! JVS(323) = Jac_FULL(80,83)
  JVS(323) = B(201)+0.63*B(205)
! JVS(324) = Jac_FULL(80,85)
  JVS(324) = 0.001*B(259)
! JVS(325) = Jac_FULL(80,86)
  JVS(325) = 0.1*B(209)+0.25*B(213)
! JVS(326) = Jac_FULL(80,87)
  JVS(326) = 0.2*B(193)+0.33*B(197)
! JVS(327) = Jac_FULL(80,90)
  JVS(327) = 0.066*B(244)
! JVS(328) = Jac_FULL(80,91)
  JVS(328) = 0.334*B(248)+0.225*B(250)+0.643*B(252)+0.333*B(254)
! JVS(329) = Jac_FULL(80,92)
  JVS(329) = B(169)
! JVS(330) = Jac_FULL(80,93)
  JVS(330) = B(144)
! JVS(331) = Jac_FULL(80,95)
  JVS(331) = B(121)+B(123)+B(124)+B(125)+B(127)+B(297)
! JVS(332) = Jac_FULL(80,96)
  JVS(332) = 0.33*B(198)+0.63*B(206)+0.25*B(214)+0.69*B(234)+0.066*B(245)+0.225*B(251)+0.001*B(260)
! JVS(333) = Jac_FULL(80,98)
  JVS(333) = -B(108)+B(122)+2*B(232)+0.334*B(249)+B(281)
! JVS(334) = Jac_FULL(80,102)
  JVS(334) = B(298)
! JVS(335) = Jac_FULL(80,103)
  JVS(335) = B(128)+0.643*B(253)
! JVS(336) = Jac_FULL(80,105)
  JVS(336) = B(126)+0.2*B(194)+B(202)+0.1*B(210)
! JVS(337) = Jac_FULL(81,62)
  JVS(337) = 0.9*B(219)
! JVS(338) = Jac_FULL(81,81)
  JVS(338) = -B(230)-B(231)-B(233)
! JVS(339) = Jac_FULL(81,84)
  JVS(339) = 0.3*B(222)
! JVS(340) = Jac_FULL(81,96)
  JVS(340) = -B(234)
! JVS(341) = Jac_FULL(81,98)
  JVS(341) = 0.3*B(223)-B(232)
! JVS(342) = Jac_FULL(81,100)
  JVS(342) = 0.9*B(220)
! JVS(343) = Jac_FULL(82,82)
  JVS(343) = -0.98*B(189)-B(190)-B(191)
! JVS(344) = Jac_FULL(82,89)
  JVS(344) = 0.76*B(187)+0.76*B(285)
! JVS(345) = Jac_FULL(82,98)
  JVS(345) = 0.76*B(188)
! JVS(346) = Jac_FULL(82,101)
  JVS(346) = -B(192)
! JVS(347) = Jac_FULL(82,102)
  JVS(347) = 0.76*B(286)
! JVS(348) = Jac_FULL(83,83)
  JVS(348) = -B(201)-B(203)-B(205)-B(207)-B(289)
! JVS(349) = Jac_FULL(83,96)
  JVS(349) = -B(206)
! JVS(350) = Jac_FULL(83,98)
  JVS(350) = -B(204)
! JVS(351) = Jac_FULL(83,102)
  JVS(351) = -B(290)
! JVS(352) = Jac_FULL(83,103)
  JVS(352) = -B(208)
! JVS(353) = Jac_FULL(83,105)
  JVS(353) = -B(202)
! JVS(354) = Jac_FULL(84,53)
  JVS(354) = 0.36*B(217)
! JVS(355) = Jac_FULL(84,57)
  JVS(355) = 0.2*B(235)
! JVS(356) = Jac_FULL(84,62)
  JVS(356) = B(221)
! JVS(357) = Jac_FULL(84,74)
  JVS(357) = B(228)
! JVS(358) = Jac_FULL(84,84)
  JVS(358) = -B(222)-B(224)
! JVS(359) = Jac_FULL(84,98)
  JVS(359) = 0.36*B(218)-B(223)+0.2*B(236)
! JVS(360) = Jac_FULL(84,100)
  JVS(360) = 0
! JVS(361) = Jac_FULL(84,101)
  JVS(361) = 0
! JVS(362) = Jac_FULL(84,103)
  JVS(362) = -B(225)
! JVS(363) = Jac_FULL(84,106)
  JVS(363) = B(229)
! JVS(364) = Jac_FULL(85,85)
  JVS(364) = -B(255)-B(257)-B(259)-B(261)
! JVS(365) = Jac_FULL(85,96)
  JVS(365) = -B(260)
! JVS(366) = Jac_FULL(85,98)
  JVS(366) = -B(258)
! JVS(367) = Jac_FULL(85,103)
  JVS(367) = -B(262)
! JVS(368) = Jac_FULL(85,105)
  JVS(368) = -B(256)
! JVS(369) = Jac_FULL(86,86)
  JVS(369) = -B(209)-B(211)-B(213)-B(215)-B(293)
! JVS(370) = Jac_FULL(86,96)
  JVS(370) = -B(214)
! JVS(371) = Jac_FULL(86,98)
  JVS(371) = -B(212)
! JVS(372) = Jac_FULL(86,102)
  JVS(372) = -B(294)
! JVS(373) = Jac_FULL(86,103)
  JVS(373) = -B(216)
! JVS(374) = Jac_FULL(86,105)
  JVS(374) = -B(210)
! JVS(375) = Jac_FULL(87,86)
  JVS(375) = 0.3*B(293)
! JVS(376) = Jac_FULL(87,87)
  JVS(376) = -B(193)-B(195)-B(197)-B(199)-B(291)
! JVS(377) = Jac_FULL(87,96)
  JVS(377) = -B(198)
! JVS(378) = Jac_FULL(87,98)
  JVS(378) = -B(196)
! JVS(379) = Jac_FULL(87,102)
  JVS(379) = -B(292)+0.3*B(294)
! JVS(380) = Jac_FULL(87,103)
  JVS(380) = -B(200)
! JVS(381) = Jac_FULL(87,105)
  JVS(381) = -B(194)
! JVS(382) = Jac_FULL(88,67)
  JVS(382) = 0.009*B(267)+0.009*B(287)
! JVS(383) = Jac_FULL(88,82)
  JVS(383) = 0.04*B(189)
! JVS(384) = Jac_FULL(88,85)
  JVS(384) = 0.25*B(257)+0.18*B(259)+0.25*B(261)
! JVS(385) = Jac_FULL(88,87)
  JVS(385) = 0.01*B(193)+0.09*B(199)
! JVS(386) = Jac_FULL(88,88)
  JVS(386) = -B(91)-B(95)-2*B(98)-B(99)
! JVS(387) = Jac_FULL(88,89)
  JVS(387) = 0.13*B(187)+0.13*B(285)
! JVS(388) = Jac_FULL(88,90)
  JVS(388) = 0.088*B(242)
! JVS(389) = Jac_FULL(88,96)
  JVS(389) = 0.18*B(260)
! JVS(390) = Jac_FULL(88,98)
  JVS(390) = 0.13*B(188)+0.088*B(243)+0.25*B(258)+0.009*B(268)
! JVS(391) = Jac_FULL(88,100)
  JVS(391) = -B(92)
! JVS(392) = Jac_FULL(88,101)
  JVS(392) = 0
! JVS(393) = Jac_FULL(88,102)
  JVS(393) = 0.13*B(286)+0.009*B(288)
! JVS(394) = Jac_FULL(88,103)
  JVS(394) = 0.09*B(200)+0.25*B(262)
! JVS(395) = Jac_FULL(88,104)
  JVS(395) = -B(100)
! JVS(396) = Jac_FULL(88,105)
  JVS(396) = 0.01*B(194)
! JVS(397) = Jac_FULL(88,106)
  JVS(397) = -B(96)
! JVS(398) = Jac_FULL(89,57)
  JVS(398) = 1.1*B(235)
! JVS(399) = Jac_FULL(89,82)
  JVS(399) = -2.1*B(189)
! JVS(400) = Jac_FULL(89,85)
  JVS(400) = 5.12*B(255)+1.66*B(257)+7*B(259)
! JVS(401) = Jac_FULL(89,86)
  JVS(401) = 0.1*B(209)+0.3*B(293)
! JVS(402) = Jac_FULL(89,87)
  JVS(402) = 0.2*B(193)-0.7*B(195)-B(197)-B(199)-B(291)
! JVS(403) = Jac_FULL(89,89)
  JVS(403) = -1.11*B(187)-1.11*B(285)
! JVS(404) = Jac_FULL(89,90)
  JVS(404) = 0.35*B(244)+2.4*B(269)
! JVS(405) = Jac_FULL(89,91)
  JVS(405) = 1.565*B(248)+0.36*B(250)+1.282*B(252)+0.832*B(254)
! JVS(406) = Jac_FULL(89,94)
  JVS(406) = -0.66*B(101)-0.66*B(103)
! JVS(407) = Jac_FULL(89,96)
  JVS(407) = -B(198)+0.35*B(245)+0.36*B(251)+7*B(260)
! JVS(408) = Jac_FULL(89,98)
  JVS(408) = -0.66*B(102)-1.11*B(188)-0.7*B(196)+1.1*B(236)+1.565*B(249)+1.66*B(258)
! JVS(409) = Jac_FULL(89,101)
  JVS(409) = 2.4*B(270)
! JVS(410) = Jac_FULL(89,102)
  JVS(410) = -1.11*B(286)-B(292)+0.3*B(294)
! JVS(411) = Jac_FULL(89,103)
  JVS(411) = -B(200)+1.282*B(253)
! JVS(412) = Jac_FULL(89,105)
  JVS(412) = 0.2*B(194)+0.1*B(210)+5.12*B(256)
! JVS(413) = Jac_FULL(90,90)
  JVS(413) = -B(240)-B(242)-B(244)-B(246)-B(269)-B(295)
! JVS(414) = Jac_FULL(90,96)
  JVS(414) = -B(245)
! JVS(415) = Jac_FULL(90,98)
  JVS(415) = -B(243)
! JVS(416) = Jac_FULL(90,101)
  JVS(416) = -B(270)
! JVS(417) = Jac_FULL(90,102)
  JVS(417) = -B(296)
! JVS(418) = Jac_FULL(90,103)
  JVS(418) = -B(247)
! JVS(419) = Jac_FULL(90,105)
  JVS(419) = -B(241)
! JVS(420) = Jac_FULL(91,90)
  JVS(420) = 0.75*B(240)+0.912*B(242)+0.65*B(244)+0.2*B(246)+0.2*B(269)+B(295)
! JVS(421) = Jac_FULL(91,91)
  JVS(421) = -B(248)-B(250)-B(252)-B(254)
! JVS(422) = Jac_FULL(91,96)
  JVS(422) = 0.65*B(245)-B(251)
! JVS(423) = Jac_FULL(91,98)
  JVS(423) = 0.912*B(243)-B(249)
! JVS(424) = Jac_FULL(91,101)
  JVS(424) = 0.2*B(270)
! JVS(425) = Jac_FULL(91,102)
  JVS(425) = B(296)
! JVS(426) = Jac_FULL(91,103)
  JVS(426) = 0.2*B(247)-B(253)
! JVS(427) = Jac_FULL(91,105)
  JVS(427) = 0.75*B(241)
! JVS(428) = Jac_FULL(92,70)
  JVS(428) = 0.05*B(265)
! JVS(429) = Jac_FULL(92,73)
  JVS(429) = 0.5*B(104)+0.5*B(106)
! JVS(430) = Jac_FULL(92,81)
  JVS(430) = 0.03*B(233)
! JVS(431) = Jac_FULL(92,82)
  JVS(431) = 0.5*B(189)
! JVS(432) = Jac_FULL(92,83)
  JVS(432) = 0.22*B(203)
! JVS(433) = Jac_FULL(92,84)
  JVS(433) = 0
! JVS(434) = Jac_FULL(92,85)
  JVS(434) = 0.47*B(257)+0.21*B(259)+0.47*B(261)
! JVS(435) = Jac_FULL(92,86)
  JVS(435) = 0.66*B(209)+0.7*B(211)+0.35*B(213)+0.64*B(215)+0.55*B(293)
! JVS(436) = Jac_FULL(92,87)
  JVS(436) = 0.3*B(193)+0.62*B(195)+0.32*B(197)+0.56*B(199)+0.67*B(291)
! JVS(437) = Jac_FULL(92,88)
  JVS(437) = 0
! JVS(438) = Jac_FULL(92,89)
  JVS(438) = 0.05*B(187)+0.05*B(285)
! JVS(439) = Jac_FULL(92,90)
  JVS(439) = 0.15*B(244)+0.8*B(246)+0.8*B(269)
! JVS(440) = Jac_FULL(92,91)
  JVS(440) = 0.12*B(248)+0.357*B(252)
! JVS(441) = Jac_FULL(92,92)
  JVS(441) = -B(163)-B(165)-B(167)-B(169)-B(301)
! JVS(442) = Jac_FULL(92,94)
  JVS(442) = 0.33*B(101)+0.33*B(103)
! JVS(443) = Jac_FULL(92,96)
  JVS(443) = 0.32*B(198)+0.35*B(214)+0.03*B(234)+0.15*B(245)+0.21*B(260)
! JVS(444) = Jac_FULL(92,98)
  JVS(444) = 0.33*B(102)+0.5*B(105)-B(166)+0.05*B(188)+0.62*B(196)+0.22*B(204)+0.7*B(212)+0.12*B(249)+0.47*B(258)+0.05&
               &*B(266)
! JVS(445) = Jac_FULL(92,100)
  JVS(445) = 0
! JVS(446) = Jac_FULL(92,101)
  JVS(446) = 0.8*B(270)
! JVS(447) = Jac_FULL(92,102)
  JVS(447) = 0.05*B(286)+0.67*B(292)+0.55*B(294)-B(302)
! JVS(448) = Jac_FULL(92,103)
  JVS(448) = -B(168)+0.56*B(200)+0.64*B(216)+0.8*B(247)+0.357*B(253)+0.47*B(262)
! JVS(449) = Jac_FULL(92,104)
  JVS(449) = 0
! JVS(450) = Jac_FULL(92,105)
  JVS(450) = -B(164)+0.3*B(194)+0.66*B(210)
! JVS(451) = Jac_FULL(92,106)
  JVS(451) = 0
! JVS(452) = Jac_FULL(93,66)
  JVS(452) = B(176)
! JVS(453) = Jac_FULL(93,67)
  JVS(453) = 0.991*B(267)+0.991*B(287)
! JVS(454) = Jac_FULL(93,70)
  JVS(454) = 0.9*B(265)+B(305)
! JVS(455) = Jac_FULL(93,73)
  JVS(455) = 0.5*B(104)+0.5*B(106)
! JVS(456) = Jac_FULL(93,82)
  JVS(456) = 0.6*B(189)
! JVS(457) = Jac_FULL(93,86)
  JVS(457) = 1.24*B(209)+1.3*B(211)+0.65*B(213)+1.18*B(215)+0.45*B(293)
! JVS(458) = Jac_FULL(93,87)
  JVS(458) = 0.2*B(193)+0.33*B(195)+0.18*B(197)+0.35*B(199)+0.33*B(291)
! JVS(459) = Jac_FULL(93,88)
  JVS(459) = 0
! JVS(460) = Jac_FULL(93,89)
  JVS(460) = 0.06*B(187)+0.06*B(285)
! JVS(461) = Jac_FULL(93,90)
  JVS(461) = 0
! JVS(462) = Jac_FULL(93,91)
  JVS(462) = 0.252*B(248)+0.02*B(250)+0.067*B(254)
! JVS(463) = Jac_FULL(93,93)
  JVS(463) = -B(138)-B(140)-B(142)-B(144)-B(299)
! JVS(464) = Jac_FULL(93,94)
  JVS(464) = 0.33*B(101)+0.33*B(103)
! JVS(465) = Jac_FULL(93,96)
  JVS(465) = 0.18*B(198)+0.65*B(214)+0.02*B(251)
! JVS(466) = Jac_FULL(93,97)
  JVS(466) = B(185)
! JVS(467) = Jac_FULL(93,98)
  JVS(467) = 0.33*B(102)+0.5*B(105)-B(141)+B(177)+0.06*B(188)+0.33*B(196)+1.3*B(212)+0.252*B(249)+0.9*B(266)+0.991&
               &*B(268)
! JVS(468) = Jac_FULL(93,99)
  JVS(468) = B(170)+0.9*B(180)+0.9*B(182)+2*B(184)+B(186)
! JVS(469) = Jac_FULL(93,100)
  JVS(469) = B(171)
! JVS(470) = Jac_FULL(93,101)
  JVS(470) = 0
! JVS(471) = Jac_FULL(93,102)
  JVS(471) = 0.06*B(286)+0.991*B(288)+0.33*B(292)+0.45*B(294)-B(300)+B(306)
! JVS(472) = Jac_FULL(93,103)
  JVS(472) = -B(143)+0.35*B(200)+1.18*B(216)
! JVS(473) = Jac_FULL(93,104)
  JVS(473) = 0.9*B(183)
! JVS(474) = Jac_FULL(93,105)
  JVS(474) = -B(139)+0.2*B(194)+1.24*B(210)
! JVS(475) = Jac_FULL(93,106)
  JVS(475) = 0
! JVS(476) = Jac_FULL(93,107)
  JVS(476) = 0.9*B(181)
! JVS(477) = Jac_FULL(94,62)
  JVS(477) = 0.1*B(219)
! JVS(478) = Jac_FULL(94,74)
  JVS(478) = B(226)
! JVS(479) = Jac_FULL(94,82)
  JVS(479) = B(191)
! JVS(480) = Jac_FULL(94,84)
  JVS(480) = 0
! JVS(481) = Jac_FULL(94,85)
  JVS(481) = 0.53*B(261)
! JVS(482) = Jac_FULL(94,88)
  JVS(482) = B(91)
! JVS(483) = Jac_FULL(94,89)
  JVS(483) = 0
! JVS(484) = Jac_FULL(94,90)
  JVS(484) = 0.8*B(246)+0.8*B(269)
! JVS(485) = Jac_FULL(94,91)
  JVS(485) = 0.85*B(252)
! JVS(486) = Jac_FULL(94,94)
  JVS(486) = -B(101)-B(103)
! JVS(487) = Jac_FULL(94,96)
  JVS(487) = 0
! JVS(488) = Jac_FULL(94,98)
  JVS(488) = -B(102)
! JVS(489) = Jac_FULL(94,100)
  JVS(489) = B(92)+0.1*B(220)
! JVS(490) = Jac_FULL(94,101)
  JVS(490) = B(192)+B(227)+0.8*B(270)
! JVS(491) = Jac_FULL(94,102)
  JVS(491) = 0
! JVS(492) = Jac_FULL(94,103)
  JVS(492) = 0.8*B(247)+0.85*B(253)+0.53*B(262)
! JVS(493) = Jac_FULL(94,104)
  JVS(493) = 0
! JVS(494) = Jac_FULL(94,105)
  JVS(494) = 0
! JVS(495) = Jac_FULL(94,106)
  JVS(495) = 0
! JVS(496) = Jac_FULL(95,68)
  JVS(496) = B(119)+B(303)
! JVS(497) = Jac_FULL(95,70)
  JVS(497) = 0.1*B(265)
! JVS(498) = Jac_FULL(95,71)
  JVS(498) = B(131)
! JVS(499) = Jac_FULL(95,78)
  JVS(499) = B(118)
! JVS(500) = Jac_FULL(95,81)
  JVS(500) = B(231)+0.7*B(233)
! JVS(501) = Jac_FULL(95,83)
  JVS(501) = B(201)+1.56*B(203)+B(205)+2*B(207)+B(289)
! JVS(502) = Jac_FULL(95,84)
  JVS(502) = 0
! JVS(503) = Jac_FULL(95,85)
  JVS(503) = 0.28*B(257)+0.24*B(259)
! JVS(504) = Jac_FULL(95,86)
  JVS(504) = 0.25*B(213)
! JVS(505) = Jac_FULL(95,87)
  JVS(505) = 0.2*B(193)+0.8*B(195)+0.74*B(197)+B(199)
! JVS(506) = Jac_FULL(95,90)
  JVS(506) = 0.5*B(240)+0.629*B(242)+0.6*B(244)
! JVS(507) = Jac_FULL(95,91)
  JVS(507) = 0.167*B(248)+0.15*B(250)+0.282*B(252)+0.9*B(254)
! JVS(508) = Jac_FULL(95,94)
  JVS(508) = 0.33*B(101)+0.33*B(103)
! JVS(509) = Jac_FULL(95,95)
  JVS(509) = -B(121)-B(123)-B(124)-B(125)-B(127)-B(129)-B(297)
! JVS(510) = Jac_FULL(95,96)
  JVS(510) = 0.74*B(198)+B(206)+0.25*B(214)+0.7*B(234)+0.6*B(245)+0.15*B(251)+0.24*B(260)
! JVS(511) = Jac_FULL(95,97)
  JVS(511) = B(153)
! JVS(512) = Jac_FULL(95,98)
  JVS(512) = 0.33*B(102)+B(120)-B(122)+0.8*B(196)+1.56*B(204)+B(232)+0.629*B(243)+0.167*B(249)+0.28*B(258)+0.1*B(266)
! JVS(513) = Jac_FULL(95,99)
  JVS(513) = 0.1*B(180)
! JVS(514) = Jac_FULL(95,100)
  JVS(514) = B(111)
! JVS(515) = Jac_FULL(95,101)
  JVS(515) = 0
! JVS(516) = Jac_FULL(95,102)
  JVS(516) = B(290)-B(298)+B(304)
! JVS(517) = Jac_FULL(95,103)
  JVS(517) = -B(128)+B(200)+2*B(208)+0.282*B(253)
! JVS(518) = Jac_FULL(95,104)
  JVS(518) = 0
! JVS(519) = Jac_FULL(95,105)
  JVS(519) = -B(126)+0.2*B(194)+B(202)+0.5*B(241)
! JVS(520) = Jac_FULL(95,106)
  JVS(520) = -B(130)
! JVS(521) = Jac_FULL(95,107)
  JVS(521) = B(112)+1.37*B(115)+B(154)+0.1*B(181)
! JVS(522) = Jac_FULL(96,59)
  JVS(522) = -B(309)
! JVS(523) = Jac_FULL(96,69)
  JVS(523) = 0
! JVS(524) = Jac_FULL(96,81)
  JVS(524) = -B(233)
! JVS(525) = Jac_FULL(96,83)
  JVS(525) = -B(205)
! JVS(526) = Jac_FULL(96,84)
  JVS(526) = 0
! JVS(527) = Jac_FULL(96,85)
  JVS(527) = -B(259)
! JVS(528) = Jac_FULL(96,86)
  JVS(528) = -B(213)
! JVS(529) = Jac_FULL(96,87)
  JVS(529) = -B(197)
! JVS(530) = Jac_FULL(96,90)
  JVS(530) = -B(244)
! JVS(531) = Jac_FULL(96,91)
  JVS(531) = -B(250)
! JVS(532) = Jac_FULL(96,96)
  JVS(532) = -B(3)-B(11)-B(13)-B(14)-B(19)-B(21)-B(83)-B(198)-B(206)-B(214)-B(234)-B(245)-B(251)-B(260)-B(273)-B(310)
! JVS(533) = Jac_FULL(96,97)
  JVS(533) = 0.2*B(151)
! JVS(534) = Jac_FULL(96,98)
  JVS(534) = -B(20)
! JVS(535) = Jac_FULL(96,99)
  JVS(535) = 0.2*B(178)
! JVS(536) = Jac_FULL(96,100)
  JVS(536) = -B(4)
! JVS(537) = Jac_FULL(96,101)
  JVS(537) = -B(12)
! JVS(538) = Jac_FULL(96,102)
  JVS(538) = -B(274)
! JVS(539) = Jac_FULL(96,103)
  JVS(539) = -B(84)
! JVS(540) = Jac_FULL(96,105)
  JVS(540) = B(2)
! JVS(541) = Jac_FULL(96,106)
  JVS(541) = -B(22)+0.2*B(152)+0.2*B(179)
! JVS(542) = Jac_FULL(97,51)
  JVS(542) = B(149)+B(150)
! JVS(543) = Jac_FULL(97,64)
  JVS(543) = B(158)
! JVS(544) = Jac_FULL(97,76)
  JVS(544) = B(237)+B(239)
! JVS(545) = Jac_FULL(97,81)
  JVS(545) = B(230)+B(231)+0.62*B(233)
! JVS(546) = Jac_FULL(97,84)
  JVS(546) = 0
! JVS(547) = Jac_FULL(97,91)
  JVS(547) = 0.21*B(248)+0.114*B(250)+0.967*B(254)
! JVS(548) = Jac_FULL(97,93)
  JVS(548) = B(138)+B(140)+B(142)+B(299)
! JVS(549) = Jac_FULL(97,94)
  JVS(549) = 0
! JVS(550) = Jac_FULL(97,96)
  JVS(550) = 0.62*B(234)+0.114*B(251)
! JVS(551) = Jac_FULL(97,97)
  JVS(551) = -B(145)-B(147)-B(151)-B(153)-B(155)-2*B(157)-B(185)
! JVS(552) = Jac_FULL(97,98)
  JVS(552) = B(141)+B(159)+B(232)+B(238)+0.21*B(249)
! JVS(553) = Jac_FULL(97,99)
  JVS(553) = -B(186)
! JVS(554) = Jac_FULL(97,100)
  JVS(554) = -B(146)
! JVS(555) = Jac_FULL(97,101)
  JVS(555) = -B(148)
! JVS(556) = Jac_FULL(97,102)
  JVS(556) = B(300)
! JVS(557) = Jac_FULL(97,103)
  JVS(557) = B(143)
! JVS(558) = Jac_FULL(97,104)
  JVS(558) = -B(156)
! JVS(559) = Jac_FULL(97,105)
  JVS(559) = B(139)
! JVS(560) = Jac_FULL(97,106)
  JVS(560) = -B(152)
! JVS(561) = Jac_FULL(97,107)
  JVS(561) = -B(154)
! JVS(562) = Jac_FULL(98,50)
  JVS(562) = -B(263)
! JVS(563) = Jac_FULL(98,52)
  JVS(563) = B(272)
! JVS(564) = Jac_FULL(98,53)
  JVS(564) = -B(217)
! JVS(565) = Jac_FULL(98,54)
  JVS(565) = B(63)-B(65)
! JVS(566) = Jac_FULL(98,55)
  JVS(566) = 2*B(17)+B(64)
! JVS(567) = Jac_FULL(98,57)
  JVS(567) = -B(235)
! JVS(568) = Jac_FULL(98,58)
  JVS(568) = -B(109)
! JVS(569) = Jac_FULL(98,59)
  JVS(569) = -B(311)
! JVS(570) = Jac_FULL(98,60)
  JVS(570) = B(42)-B(43)
! JVS(571) = Jac_FULL(98,61)
  JVS(571) = -B(136)
! JVS(572) = Jac_FULL(98,63)
  JVS(572) = -B(55)+0.39*B(86)
! JVS(573) = Jac_FULL(98,64)
  JVS(573) = -B(158)+B(160)
! JVS(574) = Jac_FULL(98,65)
  JVS(574) = -B(161)
! JVS(575) = Jac_FULL(98,66)
  JVS(575) = -B(176)
! JVS(576) = Jac_FULL(98,67)
  JVS(576) = -B(267)
! JVS(577) = Jac_FULL(98,68)
  JVS(577) = -B(119)
! JVS(578) = Jac_FULL(98,69)
  JVS(578) = 2*B(60)-B(61)+B(75)
! JVS(579) = Jac_FULL(98,70)
  JVS(579) = -B(265)
! JVS(580) = Jac_FULL(98,71)
  JVS(580) = 0
! JVS(581) = Jac_FULL(98,72)
  JVS(581) = -B(307)
! JVS(582) = Jac_FULL(98,73)
  JVS(582) = -B(104)+B(106)
! JVS(583) = Jac_FULL(98,75)
  JVS(583) = 0
! JVS(584) = Jac_FULL(98,76)
  JVS(584) = -B(237)
! JVS(585) = Jac_FULL(98,77)
  JVS(585) = -B(280)
! JVS(586) = Jac_FULL(98,78)
  JVS(586) = -B(116)+B(118)
! JVS(587) = Jac_FULL(98,79)
  JVS(587) = -B(48)+B(87)
! JVS(588) = Jac_FULL(98,80)
  JVS(588) = -B(107)
! JVS(589) = Jac_FULL(98,81)
  JVS(589) = -B(231)+0.08*B(233)
! JVS(590) = Jac_FULL(98,83)
  JVS(590) = 0.3*B(201)-B(203)+0.13*B(205)
! JVS(591) = Jac_FULL(98,84)
  JVS(591) = -B(222)
! JVS(592) = Jac_FULL(98,85)
  JVS(592) = 0.15*B(255)-B(257)+0.57*B(259)
! JVS(593) = Jac_FULL(98,86)
  JVS(593) = -B(211)+0.5*B(213)
! JVS(594) = Jac_FULL(98,87)
  JVS(594) = 0.1*B(193)-B(195)+0.1*B(197)
! JVS(595) = Jac_FULL(98,88)
  JVS(595) = 0
! JVS(596) = Jac_FULL(98,89)
  JVS(596) = -B(187)
! JVS(597) = Jac_FULL(98,90)
  JVS(597) = -B(242)+0.266*B(244)
! JVS(598) = Jac_FULL(98,91)
  JVS(598) = -B(248)+0.268*B(250)
! JVS(599) = Jac_FULL(98,92)
  JVS(599) = B(163)-B(165)
! JVS(600) = Jac_FULL(98,93)
  JVS(600) = B(138)-B(140)
! JVS(601) = Jac_FULL(98,94)
  JVS(601) = -B(101)
! JVS(602) = Jac_FULL(98,95)
  JVS(602) = -B(121)+B(125)
! JVS(603) = Jac_FULL(98,96)
  JVS(603) = -B(19)+B(21)+0.1*B(198)+0.13*B(206)+0.5*B(214)+0.08*B(234)+0.266*B(245)+0.268*B(251)+0.57*B(260)
! JVS(604) = Jac_FULL(98,97)
  JVS(604) = 0
! JVS(605) = Jac_FULL(98,98)
  JVS(605) = -B(20)-B(40)-B(44)-B(46)-B(49)-B(56)-B(62)-B(66)-B(67)-2*B(69)-2*B(70)-B(71)-B(79)-B(102)-B(105)-B(108)&
               &-B(110)-B(117)-B(120)-B(122)-B(137)-B(141)-B(159)-B(162)-B(166)-B(177)-B(188)-B(196)-B(204)-B(212)-B(218)&
               &-B(223)-B(232)-B(236)-B(238)-B(243)-B(249)-B(258)-B(264)-B(266)-B(268)-B(281)-B(308)-B(312)
! JVS(606) = Jac_FULL(98,99)
  JVS(606) = 0
! JVS(607) = Jac_FULL(98,100)
  JVS(607) = -B(41)+B(50)
! JVS(608) = Jac_FULL(98,101)
  JVS(608) = -B(47)
! JVS(609) = Jac_FULL(98,102)
  JVS(609) = 0
! JVS(610) = Jac_FULL(98,103)
  JVS(610) = -B(80)
! JVS(611) = Jac_FULL(98,104)
  JVS(611) = 0
! JVS(612) = Jac_FULL(98,105)
  JVS(612) = -B(68)+B(73)+B(76)+B(126)+B(139)+B(164)+0.1*B(194)+0.3*B(202)+0.15*B(256)
! JVS(613) = Jac_FULL(98,106)
  JVS(613) = B(22)+B(51)-B(72)+B(74)
! JVS(614) = Jac_FULL(98,107)
  JVS(614) = 0
! JVS(615) = Jac_FULL(99,66)
  JVS(615) = B(174)+B(175)
! JVS(616) = Jac_FULL(99,85)
  JVS(616) = 0.39*B(259)
! JVS(617) = Jac_FULL(99,90)
  JVS(617) = 0.25*B(240)+0.2*B(244)
! JVS(618) = Jac_FULL(99,91)
  JVS(618) = 0.25*B(248)+0.075*B(252)
! JVS(619) = Jac_FULL(99,92)
  JVS(619) = B(163)+B(165)+B(167)+B(301)
! JVS(620) = Jac_FULL(99,94)
  JVS(620) = 0
! JVS(621) = Jac_FULL(99,96)
  JVS(621) = 0.2*B(245)+0.39*B(260)
! JVS(622) = Jac_FULL(99,97)
  JVS(622) = -B(185)
! JVS(623) = Jac_FULL(99,98)
  JVS(623) = B(166)+0.25*B(249)
! JVS(624) = Jac_FULL(99,99)
  JVS(624) = -B(170)-B(172)-B(178)-B(180)-B(182)-2*B(184)-B(186)
! JVS(625) = Jac_FULL(99,100)
  JVS(625) = -B(171)
! JVS(626) = Jac_FULL(99,101)
  JVS(626) = -B(173)
! JVS(627) = Jac_FULL(99,102)
  JVS(627) = B(302)
! JVS(628) = Jac_FULL(99,103)
  JVS(628) = B(168)+0.075*B(253)
! JVS(629) = Jac_FULL(99,104)
  JVS(629) = -B(183)
! JVS(630) = Jac_FULL(99,105)
  JVS(630) = B(164)+0.25*B(241)
! JVS(631) = Jac_FULL(99,106)
  JVS(631) = -B(179)
! JVS(632) = Jac_FULL(99,107)
  JVS(632) = -B(181)
! JVS(633) = Jac_FULL(100,60)
  JVS(633) = B(42)+B(45)
! JVS(634) = Jac_FULL(100,62)
  JVS(634) = -B(219)
! JVS(635) = Jac_FULL(100,71)
  JVS(635) = -B(132)
! JVS(636) = Jac_FULL(100,75)
  JVS(636) = -B(276)
! JVS(637) = Jac_FULL(100,88)
  JVS(637) = -B(91)
! JVS(638) = Jac_FULL(100,89)
  JVS(638) = 0
! JVS(639) = Jac_FULL(100,90)
  JVS(639) = 0.2*B(269)
! JVS(640) = Jac_FULL(100,91)
  JVS(640) = 0
! JVS(641) = Jac_FULL(100,94)
  JVS(641) = 0
! JVS(642) = Jac_FULL(100,95)
  JVS(642) = 0
! JVS(643) = Jac_FULL(100,96)
  JVS(643) = -B(3)
! JVS(644) = Jac_FULL(100,97)
  JVS(644) = -B(145)
! JVS(645) = Jac_FULL(100,98)
  JVS(645) = -B(40)
! JVS(646) = Jac_FULL(100,99)
  JVS(646) = -B(170)
! JVS(647) = Jac_FULL(100,100)
  JVS(647) = -B(4)-B(9)-B(25)-2*B(36)-B(37)-B(41)-B(50)-B(89)-B(92)-B(111)-B(133)-B(146)-B(171)-B(220)-B(277)
! JVS(648) = Jac_FULL(100,101)
  JVS(648) = B(1)+B(5)+B(27)-B(38)+0.2*B(270)
! JVS(649) = Jac_FULL(100,102)
  JVS(649) = 0
! JVS(650) = Jac_FULL(100,103)
  JVS(650) = B(24)-B(26)+B(28)
! JVS(651) = Jac_FULL(100,104)
  JVS(651) = -B(90)
! JVS(652) = Jac_FULL(100,105)
  JVS(652) = B(6)-B(10)
! JVS(653) = Jac_FULL(100,106)
  JVS(653) = -B(51)
! JVS(654) = Jac_FULL(100,107)
  JVS(654) = -B(112)
! JVS(655) = Jac_FULL(101,51)
  JVS(655) = B(149)+B(150)
! JVS(656) = Jac_FULL(101,56)
  JVS(656) = B(35)+B(88)
! JVS(657) = Jac_FULL(101,60)
  JVS(657) = B(43)+B(45)
! JVS(658) = Jac_FULL(101,62)
  JVS(658) = 0.9*B(219)
! JVS(659) = Jac_FULL(101,63)
  JVS(659) = B(54)+B(55)+0.61*B(86)
! JVS(660) = Jac_FULL(101,66)
  JVS(660) = B(174)+B(175)+B(176)
! JVS(661) = Jac_FULL(101,71)
  JVS(661) = B(132)
! JVS(662) = Jac_FULL(101,74)
  JVS(662) = -B(226)
! JVS(663) = Jac_FULL(101,75)
  JVS(663) = B(276)
! JVS(664) = Jac_FULL(101,79)
  JVS(664) = B(87)
! JVS(665) = Jac_FULL(101,82)
  JVS(665) = -B(191)
! JVS(666) = Jac_FULL(101,83)
  JVS(666) = B(207)
! JVS(667) = Jac_FULL(101,84)
  JVS(667) = 0
! JVS(668) = Jac_FULL(101,85)
  JVS(668) = 0.47*B(261)
! JVS(669) = Jac_FULL(101,86)
  JVS(669) = B(215)
! JVS(670) = Jac_FULL(101,87)
  JVS(670) = B(199)
! JVS(671) = Jac_FULL(101,89)
  JVS(671) = 0
! JVS(672) = Jac_FULL(101,90)
  JVS(672) = 0.2*B(246)-B(269)
! JVS(673) = Jac_FULL(101,91)
  JVS(673) = 0
! JVS(674) = Jac_FULL(101,92)
  JVS(674) = 0
! JVS(675) = Jac_FULL(101,93)
  JVS(675) = 0
! JVS(676) = Jac_FULL(101,94)
  JVS(676) = B(103)
! JVS(677) = Jac_FULL(101,95)
  JVS(677) = 0
! JVS(678) = Jac_FULL(101,96)
  JVS(678) = B(3)-B(11)+B(83)
! JVS(679) = Jac_FULL(101,97)
  JVS(679) = B(145)-B(147)
! JVS(680) = Jac_FULL(101,98)
  JVS(680) = B(44)-B(46)+B(56)+B(79)+B(177)
! JVS(681) = Jac_FULL(101,99)
  JVS(681) = B(170)-B(172)
! JVS(682) = Jac_FULL(101,100)
  JVS(682) = B(4)+B(9)+2*B(25)+2*B(36)-B(37)+B(50)+B(89)+B(111)+B(133)+B(146)+B(171)+0.9*B(220)+B(277)
! JVS(683) = Jac_FULL(101,101)
  JVS(683) = -B(1)-B(5)-B(7)-B(12)-B(29)-B(38)-B(47)-B(52)-B(148)-B(173)-B(192)-B(227)-B(270)
! JVS(684) = Jac_FULL(101,102)
  JVS(684) = 0
! JVS(685) = Jac_FULL(101,103)
  JVS(685) = B(23)+2*B(26)-B(30)+B(77)+B(80)+B(84)+2*B(85)+B(200)+B(208)+B(216)+0.2*B(247)+0.47*B(262)
! JVS(686) = Jac_FULL(101,104)
  JVS(686) = B(90)
! JVS(687) = Jac_FULL(101,105)
  JVS(687) = -B(6)-B(8)+B(10)+B(78)
! JVS(688) = Jac_FULL(101,106)
  JVS(688) = B(51)-B(53)
! JVS(689) = Jac_FULL(101,107)
  JVS(689) = B(112)
! JVS(690) = Jac_FULL(102,49)
  JVS(690) = 2*B(271)
! JVS(691) = Jac_FULL(102,52)
  JVS(691) = B(272)
! JVS(692) = Jac_FULL(102,58)
  JVS(692) = -B(283)
! JVS(693) = Jac_FULL(102,67)
  JVS(693) = -B(287)
! JVS(694) = Jac_FULL(102,68)
  JVS(694) = -B(303)
! JVS(695) = Jac_FULL(102,70)
  JVS(695) = -B(305)
! JVS(696) = Jac_FULL(102,72)
  JVS(696) = B(307)
! JVS(697) = Jac_FULL(102,75)
  JVS(697) = 1.4*B(275)+B(276)
! JVS(698) = Jac_FULL(102,77)
  JVS(698) = B(280)+B(282)
! JVS(699) = Jac_FULL(102,83)
  JVS(699) = -B(289)
! JVS(700) = Jac_FULL(102,86)
  JVS(700) = -B(293)
! JVS(701) = Jac_FULL(102,87)
  JVS(701) = -B(291)
! JVS(702) = Jac_FULL(102,89)
  JVS(702) = -B(285)
! JVS(703) = Jac_FULL(102,90)
  JVS(703) = -B(295)
! JVS(704) = Jac_FULL(102,91)
  JVS(704) = 0
! JVS(705) = Jac_FULL(102,92)
  JVS(705) = -B(301)
! JVS(706) = Jac_FULL(102,93)
  JVS(706) = -B(299)
! JVS(707) = Jac_FULL(102,94)
  JVS(707) = 0
! JVS(708) = Jac_FULL(102,95)
  JVS(708) = -B(297)
! JVS(709) = Jac_FULL(102,96)
  JVS(709) = -B(273)
! JVS(710) = Jac_FULL(102,97)
  JVS(710) = 0
! JVS(711) = Jac_FULL(102,98)
  JVS(711) = B(281)+B(308)
! JVS(712) = Jac_FULL(102,99)
  JVS(712) = 0
! JVS(713) = Jac_FULL(102,100)
  JVS(713) = B(277)
! JVS(714) = Jac_FULL(102,101)
  JVS(714) = 0
! JVS(715) = Jac_FULL(102,102)
  JVS(715) = -B(274)-B(284)-B(286)-B(288)-B(290)-B(292)-B(294)-B(296)-B(298)-B(300)-B(302)-B(304)-B(306)
! JVS(716) = Jac_FULL(102,103)
  JVS(716) = 0
! JVS(717) = Jac_FULL(102,104)
  JVS(717) = 0
! JVS(718) = Jac_FULL(102,105)
  JVS(718) = 0
! JVS(719) = Jac_FULL(102,106)
  JVS(719) = 0
! JVS(720) = Jac_FULL(102,107)
  JVS(720) = 0
! JVS(721) = Jac_FULL(103,56)
  JVS(721) = B(35)+B(88)
! JVS(722) = Jac_FULL(103,63)
  JVS(722) = 0.39*B(86)
! JVS(723) = Jac_FULL(103,79)
  JVS(723) = B(48)
! JVS(724) = Jac_FULL(103,83)
  JVS(724) = -B(207)
! JVS(725) = Jac_FULL(103,84)
  JVS(725) = -B(224)
! JVS(726) = Jac_FULL(103,85)
  JVS(726) = -B(261)
! JVS(727) = Jac_FULL(103,86)
  JVS(727) = -B(215)
! JVS(728) = Jac_FULL(103,87)
  JVS(728) = -B(199)
! JVS(729) = Jac_FULL(103,90)
  JVS(729) = -B(246)
! JVS(730) = Jac_FULL(103,91)
  JVS(730) = -B(252)
! JVS(731) = Jac_FULL(103,92)
  JVS(731) = -B(167)
! JVS(732) = Jac_FULL(103,93)
  JVS(732) = -B(142)
! JVS(733) = Jac_FULL(103,94)
  JVS(733) = 0
! JVS(734) = Jac_FULL(103,95)
  JVS(734) = -B(127)
! JVS(735) = Jac_FULL(103,96)
  JVS(735) = B(11)-B(83)
! JVS(736) = Jac_FULL(103,97)
  JVS(736) = 0
! JVS(737) = Jac_FULL(103,98)
  JVS(737) = B(49)-B(79)
! JVS(738) = Jac_FULL(103,99)
  JVS(738) = 0
! JVS(739) = Jac_FULL(103,100)
  JVS(739) = -B(25)
! JVS(740) = Jac_FULL(103,101)
  JVS(740) = B(7)+B(12)-B(27)-B(29)
! JVS(741) = Jac_FULL(103,102)
  JVS(741) = 0
! JVS(742) = Jac_FULL(103,103)
  JVS(742) = -B(23)-B(24)-B(26)-B(28)-B(30)-B(77)-B(80)-B(81)-B(84)-2*B(85)-B(128)-B(143)-B(168)-B(200)-B(208)-B(216)&
               &-B(225)-B(247)-B(253)-B(262)
! JVS(743) = Jac_FULL(103,104)
  JVS(743) = 0
! JVS(744) = Jac_FULL(103,105)
  JVS(744) = B(8)-B(78)
! JVS(745) = Jac_FULL(103,106)
  JVS(745) = -B(82)
! JVS(746) = Jac_FULL(103,107)
  JVS(746) = 0
! JVS(747) = Jac_FULL(104,53)
  JVS(747) = 0.08*B(217)
! JVS(748) = Jac_FULL(104,57)
  JVS(748) = 0.5*B(235)
! JVS(749) = Jac_FULL(104,67)
  JVS(749) = 0.991*B(267)+0.991*B(287)
! JVS(750) = Jac_FULL(104,70)
  JVS(750) = 0.1*B(265)
! JVS(751) = Jac_FULL(104,73)
  JVS(751) = B(104)
! JVS(752) = Jac_FULL(104,76)
  JVS(752) = B(237)
! JVS(753) = Jac_FULL(104,78)
  JVS(753) = 0.3*B(116)
! JVS(754) = Jac_FULL(104,81)
  JVS(754) = B(231)+0.03*B(233)
! JVS(755) = Jac_FULL(104,82)
  JVS(755) = 0.96*B(189)
! JVS(756) = Jac_FULL(104,83)
  JVS(756) = 0.7*B(201)+B(203)+B(207)+2*B(289)
! JVS(757) = Jac_FULL(104,84)
  JVS(757) = 0.6*B(222)
! JVS(758) = Jac_FULL(104,85)
  JVS(758) = 1.25*B(257)+0.76*B(259)+1.03*B(261)
! JVS(759) = Jac_FULL(104,86)
  JVS(759) = 0.1*B(209)+B(211)+1.7*B(293)
! JVS(760) = Jac_FULL(104,87)
  JVS(760) = 0.2*B(193)+0.8*B(195)+0.22*B(197)+0.91*B(199)+2*B(291)
! JVS(761) = Jac_FULL(104,88)
  JVS(761) = -B(99)
! JVS(762) = Jac_FULL(104,89)
  JVS(762) = 0.87*B(187)+0.87*B(285)
! JVS(763) = Jac_FULL(104,90)
  JVS(763) = 0.25*B(240)+0.991*B(242)+0.2*B(244)+B(246)+B(269)+B(295)
! JVS(764) = Jac_FULL(104,91)
  JVS(764) = 0.713*B(248)+0.064*B(250)+0.075*B(252)+0.7*B(254)
! JVS(765) = Jac_FULL(104,94)
  JVS(765) = 0
! JVS(766) = Jac_FULL(104,95)
  JVS(766) = 0
! JVS(767) = Jac_FULL(104,96)
  JVS(767) = 0.22*B(198)+0.03*B(234)+0.2*B(245)+0.064*B(251)+0.76*B(260)
! JVS(768) = Jac_FULL(104,97)
  JVS(768) = -B(155)+B(185)
! JVS(769) = Jac_FULL(104,98)
  JVS(769) = B(105)+0.3*B(117)+0.87*B(188)+0.8*B(196)+B(204)+B(212)+0.08*B(218)+0.6*B(223)+B(232)+0.5*B(236)+B(238)&
               &+0.991*B(243)+0.713*B(249)+1.25*B(258)+0.1*B(266)+0.991*B(268)
! JVS(770) = Jac_FULL(104,99)
  JVS(770) = B(170)+0.9*B(180)-B(182)+2*B(184)+B(186)
! JVS(771) = Jac_FULL(104,100)
  JVS(771) = -B(89)+B(171)
! JVS(772) = Jac_FULL(104,101)
  JVS(772) = B(270)
! JVS(773) = Jac_FULL(104,102)
  JVS(773) = 0.87*B(286)+0.991*B(288)+2*B(290)+2*B(292)+1.7*B(294)+B(296)
! JVS(774) = Jac_FULL(104,103)
  JVS(774) = 0.91*B(200)+B(208)+B(247)+0.075*B(253)+1.03*B(262)
! JVS(775) = Jac_FULL(104,104)
  JVS(775) = -B(90)-B(93)-2*B(97)-B(100)-B(156)-B(183)
! JVS(776) = Jac_FULL(104,105)
  JVS(776) = 0.2*B(194)+0.7*B(202)+0.1*B(210)+0.25*B(241)
! JVS(777) = Jac_FULL(104,106)
  JVS(777) = -B(94)
! JVS(778) = Jac_FULL(104,107)
  JVS(778) = 0.9*B(181)
! JVS(779) = Jac_FULL(105,55)
  JVS(779) = B(15)
! JVS(780) = Jac_FULL(105,69)
  JVS(780) = -B(75)
! JVS(781) = Jac_FULL(105,83)
  JVS(781) = -B(201)
! JVS(782) = Jac_FULL(105,85)
  JVS(782) = -B(255)
! JVS(783) = Jac_FULL(105,86)
  JVS(783) = -B(209)+0.5*B(213)
! JVS(784) = Jac_FULL(105,87)
  JVS(784) = -B(193)
! JVS(785) = Jac_FULL(105,90)
  JVS(785) = -B(240)
! JVS(786) = Jac_FULL(105,92)
  JVS(786) = -B(163)
! JVS(787) = Jac_FULL(105,93)
  JVS(787) = -B(138)
! JVS(788) = Jac_FULL(105,94)
  JVS(788) = 0
! JVS(789) = Jac_FULL(105,95)
  JVS(789) = -B(125)
! JVS(790) = Jac_FULL(105,96)
  JVS(790) = B(13)+0.5*B(214)
! JVS(791) = Jac_FULL(105,97)
  JVS(791) = 0
! JVS(792) = Jac_FULL(105,98)
  JVS(792) = -B(67)+B(69)
! JVS(793) = Jac_FULL(105,99)
  JVS(793) = 0
! JVS(794) = Jac_FULL(105,100)
  JVS(794) = -B(9)
! JVS(795) = Jac_FULL(105,101)
  JVS(795) = B(1)-B(5)-B(7)
! JVS(796) = Jac_FULL(105,102)
  JVS(796) = 0
! JVS(797) = Jac_FULL(105,103)
  JVS(797) = B(23)-B(77)
! JVS(798) = Jac_FULL(105,104)
  JVS(798) = 0
! JVS(799) = Jac_FULL(105,105)
  JVS(799) = -B(2)-B(6)-B(8)-B(10)-B(68)-B(73)-B(76)-B(78)-B(126)-B(139)-B(164)-B(194)-B(202)-B(210)-B(241)-B(256)
! JVS(800) = Jac_FULL(105,106)
  JVS(800) = -B(74)
! JVS(801) = Jac_FULL(105,107)
  JVS(801) = 0
! JVS(802) = Jac_FULL(106,50)
  JVS(802) = B(263)
! JVS(803) = Jac_FULL(106,53)
  JVS(803) = 0.44*B(217)
! JVS(804) = Jac_FULL(106,54)
  JVS(804) = B(63)+B(65)
! JVS(805) = Jac_FULL(106,55)
  JVS(805) = B(64)
! JVS(806) = Jac_FULL(106,57)
  JVS(806) = 0.7*B(235)
! JVS(807) = Jac_FULL(106,61)
  JVS(807) = B(136)
! JVS(808) = Jac_FULL(106,62)
  JVS(808) = 0.9*B(219)+B(221)
! JVS(809) = Jac_FULL(106,63)
  JVS(809) = B(54)+0.61*B(86)
! JVS(810) = Jac_FULL(106,67)
  JVS(810) = B(267)+B(287)
! JVS(811) = Jac_FULL(106,68)
  JVS(811) = B(119)+B(303)
! JVS(812) = Jac_FULL(106,69)
  JVS(812) = B(61)+B(75)
! JVS(813) = Jac_FULL(106,70)
  JVS(813) = B(265)+B(305)
! JVS(814) = Jac_FULL(106,71)
  JVS(814) = B(131)+B(132)-B(134)
! JVS(815) = Jac_FULL(106,73)
  JVS(815) = B(106)
! JVS(816) = Jac_FULL(106,74)
  JVS(816) = -B(228)
! JVS(817) = Jac_FULL(106,75)
  JVS(817) = -B(278)
! JVS(818) = Jac_FULL(106,76)
  JVS(818) = B(239)
! JVS(819) = Jac_FULL(106,77)
  JVS(819) = B(282)
! JVS(820) = Jac_FULL(106,78)
  JVS(820) = 0.3*B(116)+B(118)
! JVS(821) = Jac_FULL(106,80)
  JVS(821) = B(107)
! JVS(822) = Jac_FULL(106,81)
  JVS(822) = B(230)+2*B(231)+0.76*B(233)
! JVS(823) = Jac_FULL(106,82)
  JVS(823) = 0.94*B(189)+B(190)
! JVS(824) = Jac_FULL(106,83)
  JVS(824) = 1.7*B(201)+B(203)+0.13*B(205)+B(289)
! JVS(825) = Jac_FULL(106,84)
  JVS(825) = 0.6*B(222)
! JVS(826) = Jac_FULL(106,85)
  JVS(826) = 0.75*B(257)+0.07*B(259)+0.28*B(261)
! JVS(827) = Jac_FULL(106,86)
  JVS(827) = 0.1*B(209)+B(211)+0.5*B(213)+B(215)+B(293)
! JVS(828) = Jac_FULL(106,87)
  JVS(828) = 0.3*B(193)+0.95*B(195)+0.44*B(197)+B(291)
! JVS(829) = Jac_FULL(106,88)
  JVS(829) = -B(95)
! JVS(830) = Jac_FULL(106,89)
  JVS(830) = 0.11*B(187)+0.11*B(285)
! JVS(831) = Jac_FULL(106,90)
  JVS(831) = 0.25*B(240)+0.912*B(242)+0.066*B(244)+0.8*B(246)+0.8*B(269)+B(295)
! JVS(832) = Jac_FULL(106,91)
  JVS(832) = 0.503*B(248)+0.154*B(250)+0.925*B(252)+1.033*B(254)
! JVS(833) = Jac_FULL(106,92)
  JVS(833) = B(169)
! JVS(834) = Jac_FULL(106,93)
  JVS(834) = B(144)
! JVS(835) = Jac_FULL(106,94)
  JVS(835) = B(101)+B(103)
! JVS(836) = Jac_FULL(106,95)
  JVS(836) = B(121)+2*B(123)+B(125)+B(127)-B(129)+B(297)
! JVS(837) = Jac_FULL(106,96)
  JVS(837) = B(19)-B(21)+0.44*B(198)+0.13*B(206)+0.5*B(214)+0.76*B(234)+0.066*B(245)+0.154*B(251)+0.07*B(260)
! JVS(838) = Jac_FULL(106,97)
  JVS(838) = -B(151)+0.9*B(153)+B(185)
! JVS(839) = Jac_FULL(106,98)
  JVS(839) = B(20)+B(62)+B(66)+B(67)-B(71)+B(79)+B(102)+B(108)+0.3*B(117)+B(120)+B(122)+B(137)+0.11*B(188)+0.95*B(196)&
               &+B(204)+B(212)+0.44*B(218)+0.6*B(223)+2*B(232)+0.7*B(236)+0.912*B(243)+0.503*B(249)+0.75*B(258)+B(264)&
               &+B(266)+B(268)
! JVS(840) = Jac_FULL(106,99)
  JVS(840) = B(170)-B(178)+B(180)+2*B(184)+B(186)
! JVS(841) = Jac_FULL(106,100)
  JVS(841) = -B(50)+B(111)+B(133)+B(171)+0.9*B(220)
! JVS(842) = Jac_FULL(106,101)
  JVS(842) = -B(52)+0.8*B(270)
! JVS(843) = Jac_FULL(106,102)
  JVS(843) = 0.11*B(286)+B(288)+B(290)+B(292)+B(294)+B(296)+B(298)+B(304)+B(306)
! JVS(844) = Jac_FULL(106,103)
  JVS(844) = B(80)-B(81)+B(128)+B(216)+0.8*B(247)+0.925*B(253)+0.28*B(262)
! JVS(845) = Jac_FULL(106,104)
  JVS(845) = -B(93)
! JVS(846) = Jac_FULL(106,105)
  JVS(846) = B(68)-B(73)+B(76)+B(126)+0.3*B(194)+1.7*B(202)+0.1*B(210)+0.25*B(241)
! JVS(847) = Jac_FULL(106,106)
  JVS(847) = -B(22)-B(51)-B(53)-2*B(57)-2*B(58)-B(72)-B(74)-B(82)-B(94)-B(96)-B(113)-B(130)-B(135)-B(152)-B(179)-B(229)&
               &-B(279)
! JVS(848) = Jac_FULL(106,107)
  JVS(848) = B(112)-B(114)+0.74*B(115)+0.9*B(154)+B(181)
! JVS(849) = Jac_FULL(107,58)
  JVS(849) = B(109)+B(283)
! JVS(850) = Jac_FULL(107,64)
  JVS(850) = B(160)
! JVS(851) = Jac_FULL(107,65)
  JVS(851) = B(161)
! JVS(852) = Jac_FULL(107,78)
  JVS(852) = 0.7*B(116)
! JVS(853) = Jac_FULL(107,92)
  JVS(853) = B(169)
! JVS(854) = Jac_FULL(107,93)
  JVS(854) = B(144)
! JVS(855) = Jac_FULL(107,94)
  JVS(855) = 0
! JVS(856) = Jac_FULL(107,95)
  JVS(856) = 0
! JVS(857) = Jac_FULL(107,96)
  JVS(857) = 0
! JVS(858) = Jac_FULL(107,97)
  JVS(858) = B(145)-0.1*B(153)+0.9*B(155)+2*B(157)+B(185)
! JVS(859) = Jac_FULL(107,98)
  JVS(859) = B(110)+0.7*B(117)+B(162)
! JVS(860) = Jac_FULL(107,99)
  JVS(860) = -B(180)+B(186)
! JVS(861) = Jac_FULL(107,100)
  JVS(861) = -B(111)+B(146)
! JVS(862) = Jac_FULL(107,101)
  JVS(862) = 0
! JVS(863) = Jac_FULL(107,102)
  JVS(863) = B(284)
! JVS(864) = Jac_FULL(107,103)
  JVS(864) = 0
! JVS(865) = Jac_FULL(107,104)
  JVS(865) = 0.9*B(156)
! JVS(866) = Jac_FULL(107,105)
  JVS(866) = 0
! JVS(867) = Jac_FULL(107,106)
  JVS(867) = -B(113)
! JVS(868) = Jac_FULL(107,107)
  JVS(868) = -B(112)-B(114)-2*B(115)-0.1*B(154)-B(181)
      
END SUBROUTINE Jac_SP

! End of Jac_SP function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Jac_SP_Vec - function for sparse multiplication: sparse Jacobian times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JUV       - Jacobian times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Jac_SP_Vec ( JVS, UV, JUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JUV - Jacobian times user vector
  REAL(kind=dp) :: JUV(NVAR)

  JUV(1) = JVS(1)*UV(1)+JVS(2)*UV(53)+JVS(3)*UV(98)
  JUV(2) = JVS(4)*UV(2)+JVS(5)*UV(53)+JVS(6)*UV(98)
  JUV(3) = JVS(7)*UV(3)+JVS(8)*UV(84)+JVS(9)*UV(98)+JVS(10)*UV(103)
  JUV(4) = JVS(11)*UV(4)+JVS(12)*UV(57)+JVS(13)*UV(98)
  JUV(5) = JVS(14)*UV(5)+JVS(15)*UV(57)+JVS(16)*UV(98)
  JUV(6) = JVS(17)*UV(6)+JVS(18)*UV(90)+JVS(19)*UV(96)+JVS(20)*UV(98)+JVS(21)*UV(103)+JVS(22)*UV(105)
  JUV(7) = JVS(23)*UV(7)+JVS(24)*UV(90)+JVS(25)*UV(96)+JVS(26)*UV(98)+JVS(27)*UV(103)+JVS(28)*UV(105)
  JUV(8) = JVS(29)*UV(8)+JVS(30)*UV(50)+JVS(31)*UV(98)
  JUV(9) = JVS(32)*UV(9)+JVS(33)*UV(50)+JVS(34)*UV(98)
  JUV(10) = JVS(35)*UV(10)+JVS(36)*UV(85)+JVS(37)*UV(96)+JVS(38)*UV(98)+JVS(39)*UV(103)+JVS(40)*UV(105)
  JUV(11) = JVS(41)*UV(11)+JVS(42)*UV(12)+JVS(43)*UV(98)
  JUV(12) = JVS(44)*UV(12)+JVS(45)*UV(98)
  JUV(13) = JVS(46)*UV(13)+JVS(47)*UV(15)+JVS(48)*UV(98)
  JUV(14) = JVS(49)*UV(14)+JVS(50)*UV(15)+JVS(51)*UV(98)
  JUV(15) = JVS(52)*UV(15)+JVS(53)*UV(98)
  JUV(16) = JVS(54)*UV(16)+JVS(55)*UV(18)+JVS(56)*UV(98)
  JUV(17) = JVS(57)*UV(17)+JVS(58)*UV(18)+JVS(59)*UV(98)
  JUV(18) = JVS(60)*UV(18)+JVS(61)*UV(98)
  JUV(19) = JVS(62)*UV(19)+JVS(63)*UV(23)+JVS(64)*UV(98)
  JUV(20) = JVS(65)*UV(20)+JVS(66)*UV(23)+JVS(67)*UV(98)
  JUV(21) = JVS(68)*UV(21)+JVS(69)*UV(23)+JVS(70)*UV(96)
  JUV(22) = JVS(71)*UV(22)+JVS(72)*UV(23)+JVS(73)*UV(96)
  JUV(23) = JVS(74)*UV(23)+JVS(75)*UV(96)+JVS(76)*UV(98)
  JUV(24) = JVS(77)*UV(24)+JVS(78)*UV(29)+JVS(79)*UV(98)
  JUV(25) = JVS(80)*UV(25)+JVS(81)*UV(29)+JVS(82)*UV(98)
  JUV(26) = JVS(83)*UV(26)+JVS(84)*UV(29)+JVS(85)*UV(96)
  JUV(27) = JVS(86)*UV(27)+JVS(87)*UV(29)+JVS(88)*UV(96)
  JUV(28) = JVS(89)*UV(28)+JVS(90)*UV(29)+JVS(91)*UV(103)
  JUV(29) = JVS(92)*UV(29)+JVS(93)*UV(96)+JVS(94)*UV(98)+JVS(95)*UV(103)
  JUV(30) = JVS(96)*UV(30)+JVS(97)*UV(32)+JVS(98)*UV(98)
  JUV(31) = JVS(99)*UV(31)+JVS(100)*UV(32)+JVS(101)*UV(98)
  JUV(32) = JVS(102)*UV(32)+JVS(103)*UV(98)
  JUV(33) = JVS(104)*UV(33)+JVS(105)*UV(34)+JVS(106)*UV(98)
  JUV(34) = JVS(107)*UV(34)+JVS(108)*UV(98)
  JUV(35) = JVS(109)*UV(35)+JVS(110)*UV(37)+JVS(111)*UV(98)
  JUV(36) = JVS(112)*UV(36)+JVS(113)*UV(37)+JVS(114)*UV(98)
  JUV(37) = JVS(115)*UV(37)+JVS(116)*UV(98)
  JUV(38) = JVS(117)*UV(38)+JVS(118)*UV(59)+JVS(119)*UV(69)+JVS(120)*UV(96)+JVS(121)*UV(98)
  JUV(39) = JVS(122)*UV(39)+JVS(123)*UV(40)+JVS(124)*UV(98)
  JUV(40) = JVS(125)*UV(40)+JVS(126)*UV(41)+JVS(127)*UV(98)
  JUV(41) = JVS(128)*UV(41)+JVS(129)*UV(42)+JVS(130)*UV(98)
  JUV(42) = JVS(131)*UV(42)+JVS(132)*UV(98)
  JUV(43) = JVS(133)*UV(43)+JVS(134)*UV(44)+JVS(135)*UV(98)
  JUV(44) = JVS(136)*UV(44)+JVS(137)*UV(45)+JVS(138)*UV(98)
  JUV(45) = JVS(139)*UV(45)+JVS(140)*UV(46)+JVS(141)*UV(98)
  JUV(46) = JVS(142)*UV(46)+JVS(143)*UV(98)
  JUV(47) = JVS(144)*UV(47)+JVS(145)*UV(80)+JVS(146)*UV(98)
  JUV(48) = JVS(147)*UV(48)+JVS(148)*UV(53)+JVS(149)*UV(57)+JVS(150)*UV(61)+JVS(151)*UV(64)+JVS(152)*UV(65)+JVS(153)&
              &*UV(67)+JVS(154)*UV(68)+JVS(155)*UV(70)+JVS(156)*UV(76)+JVS(157)*UV(78)+JVS(158)*UV(81)+JVS(159)*UV(83)&
              &+JVS(160)*UV(84)+JVS(161)*UV(85)+JVS(162)*UV(86)+JVS(163)*UV(87)+JVS(164)*UV(89)+JVS(165)*UV(90)+JVS(166)&
              &*UV(91)+JVS(167)*UV(92)+JVS(168)*UV(93)+JVS(169)*UV(95)+JVS(170)*UV(98)
  JUV(49) = JVS(171)*UV(49)+JVS(172)*UV(75)
  JUV(50) = JVS(173)*UV(50)+JVS(174)*UV(98)
  JUV(51) = JVS(175)*UV(51)+JVS(176)*UV(97)+JVS(177)*UV(101)
  JUV(52) = JVS(178)*UV(52)+JVS(179)*UV(75)+JVS(180)*UV(106)
  JUV(53) = JVS(181)*UV(53)+JVS(182)*UV(98)
  JUV(54) = JVS(183)*UV(54)+JVS(184)*UV(55)+JVS(185)*UV(98)
  JUV(55) = JVS(186)*UV(54)+JVS(187)*UV(55)+JVS(188)*UV(96)
  JUV(56) = JVS(190)*UV(56)+JVS(191)*UV(101)+JVS(192)*UV(103)
  JUV(57) = JVS(193)*UV(57)+JVS(194)*UV(98)
  JUV(58) = JVS(195)*UV(58)+JVS(196)*UV(98)+JVS(197)*UV(102)
  JUV(59) = JVS(198)*UV(59)+JVS(199)*UV(69)+JVS(200)*UV(96)+JVS(201)*UV(98)
  JUV(60) = JVS(202)*UV(60)+JVS(203)*UV(98)+JVS(204)*UV(100)+JVS(205)*UV(101)
  JUV(61) = JVS(206)*UV(61)+JVS(207)*UV(71)+JVS(208)*UV(83)+JVS(209)*UV(96)+JVS(210)*UV(98)+JVS(211)*UV(100)
  JUV(62) = JVS(212)*UV(53)+JVS(213)*UV(57)+JVS(214)*UV(62)+JVS(215)*UV(98)+JVS(216)*UV(100)
  JUV(63) = JVS(217)*UV(63)+JVS(218)*UV(98)+JVS(219)*UV(101)+JVS(220)*UV(106)
  JUV(64) = JVS(221)*UV(64)+JVS(222)*UV(97)+JVS(223)*UV(98)+JVS(224)*UV(99)+JVS(225)*UV(106)
  JUV(65) = JVS(226)*UV(65)+JVS(227)*UV(97)+JVS(228)*UV(98)+JVS(229)*UV(99)+JVS(230)*UV(104)+JVS(231)*UV(106)+JVS(232)&
              &*UV(107)
  JUV(66) = JVS(233)*UV(66)+JVS(234)*UV(98)+JVS(235)*UV(99)+JVS(236)*UV(101)
  JUV(67) = JVS(237)*UV(67)+JVS(238)*UV(98)+JVS(239)*UV(102)
  JUV(68) = JVS(240)*UV(68)+JVS(241)*UV(98)+JVS(242)*UV(102)+JVS(243)*UV(107)
  JUV(69) = JVS(244)*UV(59)+JVS(245)*UV(69)+JVS(247)*UV(98)+JVS(248)*UV(105)+JVS(249)*UV(106)
  JUV(70) = JVS(250)*UV(70)+JVS(251)*UV(98)+JVS(252)*UV(102)
  JUV(71) = JVS(253)*UV(71)+JVS(254)*UV(95)+JVS(255)*UV(100)+JVS(256)*UV(106)
  JUV(72) = JVS(257)*UV(58)+JVS(258)*UV(67)+JVS(259)*UV(68)+JVS(260)*UV(70)+JVS(261)*UV(72)+JVS(262)*UV(86)+JVS(263)&
              &*UV(89)+JVS(264)*UV(90)+JVS(265)*UV(92)+JVS(266)*UV(93)+JVS(267)*UV(95)+JVS(268)*UV(98)+JVS(269)*UV(102)
  JUV(73) = JVS(271)*UV(73)+JVS(272)*UV(88)+JVS(273)*UV(98)+JVS(274)*UV(104)+JVS(275)*UV(106)
  JUV(74) = JVS(276)*UV(74)+JVS(277)*UV(84)+JVS(278)*UV(98)+JVS(279)*UV(101)+JVS(280)*UV(103)+JVS(281)*UV(106)
  JUV(75) = JVS(282)*UV(75)+JVS(283)*UV(96)+JVS(284)*UV(100)+JVS(285)*UV(102)+JVS(286)*UV(106)
  JUV(76) = JVS(287)*UV(57)+JVS(288)*UV(76)+JVS(289)*UV(81)+JVS(290)*UV(91)+JVS(291)*UV(96)+JVS(292)*UV(98)
  JUV(77) = JVS(293)*UV(77)+JVS(294)*UV(83)+JVS(295)*UV(86)+JVS(296)*UV(87)+JVS(297)*UV(90)+JVS(298)*UV(98)+JVS(299)&
              &*UV(102)
  JUV(78) = JVS(300)*UV(71)+JVS(301)*UV(78)+JVS(303)*UV(98)+JVS(305)*UV(106)+JVS(306)*UV(107)
  JUV(79) = JVS(307)*UV(56)+JVS(308)*UV(79)+JVS(309)*UV(84)+JVS(310)*UV(91)+JVS(311)*UV(92)+JVS(312)*UV(93)+JVS(313)&
              &*UV(94)+JVS(314)*UV(95)+JVS(315)*UV(98)+JVS(316)*UV(101)+JVS(317)*UV(103)+JVS(318)*UV(106)
  JUV(80) = JVS(319)*UV(76)+JVS(320)*UV(77)+JVS(321)*UV(80)+JVS(322)*UV(81)+JVS(323)*UV(83)+JVS(324)*UV(85)+JVS(325)&
              &*UV(86)+JVS(326)*UV(87)+JVS(327)*UV(90)+JVS(328)*UV(91)+JVS(329)*UV(92)+JVS(330)*UV(93)+JVS(331)*UV(95)&
              &+JVS(332)*UV(96)+JVS(333)*UV(98)+JVS(334)*UV(102)+JVS(335)*UV(103)+JVS(336)*UV(105)
  JUV(81) = JVS(337)*UV(62)+JVS(338)*UV(81)+JVS(339)*UV(84)+JVS(340)*UV(96)+JVS(341)*UV(98)+JVS(342)*UV(100)
  JUV(82) = JVS(343)*UV(82)+JVS(344)*UV(89)+JVS(345)*UV(98)+JVS(346)*UV(101)+JVS(347)*UV(102)
  JUV(83) = JVS(348)*UV(83)+JVS(349)*UV(96)+JVS(350)*UV(98)+JVS(351)*UV(102)+JVS(352)*UV(103)+JVS(353)*UV(105)
  JUV(84) = JVS(354)*UV(53)+JVS(355)*UV(57)+JVS(356)*UV(62)+JVS(357)*UV(74)+JVS(358)*UV(84)+JVS(359)*UV(98)+JVS(362)&
              &*UV(103)+JVS(363)*UV(106)
  JUV(85) = JVS(364)*UV(85)+JVS(365)*UV(96)+JVS(366)*UV(98)+JVS(367)*UV(103)+JVS(368)*UV(105)
  JUV(86) = JVS(369)*UV(86)+JVS(370)*UV(96)+JVS(371)*UV(98)+JVS(372)*UV(102)+JVS(373)*UV(103)+JVS(374)*UV(105)
  JUV(87) = JVS(375)*UV(86)+JVS(376)*UV(87)+JVS(377)*UV(96)+JVS(378)*UV(98)+JVS(379)*UV(102)+JVS(380)*UV(103)+JVS(381)&
              &*UV(105)
  JUV(88) = JVS(382)*UV(67)+JVS(383)*UV(82)+JVS(384)*UV(85)+JVS(385)*UV(87)+JVS(386)*UV(88)+JVS(387)*UV(89)+JVS(388)&
              &*UV(90)+JVS(389)*UV(96)+JVS(390)*UV(98)+JVS(391)*UV(100)+JVS(393)*UV(102)+JVS(394)*UV(103)+JVS(395)*UV(104)&
              &+JVS(396)*UV(105)+JVS(397)*UV(106)
  JUV(89) = JVS(398)*UV(57)+JVS(399)*UV(82)+JVS(400)*UV(85)+JVS(401)*UV(86)+JVS(402)*UV(87)+JVS(403)*UV(89)+JVS(404)&
              &*UV(90)+JVS(405)*UV(91)+JVS(406)*UV(94)+JVS(407)*UV(96)+JVS(408)*UV(98)+JVS(409)*UV(101)+JVS(410)*UV(102)&
              &+JVS(411)*UV(103)+JVS(412)*UV(105)
  JUV(90) = JVS(413)*UV(90)+JVS(414)*UV(96)+JVS(415)*UV(98)+JVS(416)*UV(101)+JVS(417)*UV(102)+JVS(418)*UV(103)+JVS(419)&
              &*UV(105)
  JUV(91) = JVS(420)*UV(90)+JVS(421)*UV(91)+JVS(422)*UV(96)+JVS(423)*UV(98)+JVS(424)*UV(101)+JVS(425)*UV(102)+JVS(426)&
              &*UV(103)+JVS(427)*UV(105)
  JUV(92) = JVS(428)*UV(70)+JVS(429)*UV(73)+JVS(430)*UV(81)+JVS(431)*UV(82)+JVS(432)*UV(83)+JVS(434)*UV(85)+JVS(435)&
              &*UV(86)+JVS(436)*UV(87)+JVS(438)*UV(89)+JVS(439)*UV(90)+JVS(440)*UV(91)+JVS(441)*UV(92)+JVS(442)*UV(94)&
              &+JVS(443)*UV(96)+JVS(444)*UV(98)+JVS(446)*UV(101)+JVS(447)*UV(102)+JVS(448)*UV(103)+JVS(450)*UV(105)
  JUV(93) = JVS(452)*UV(66)+JVS(453)*UV(67)+JVS(454)*UV(70)+JVS(455)*UV(73)+JVS(456)*UV(82)+JVS(457)*UV(86)+JVS(458)&
              &*UV(87)+JVS(460)*UV(89)+JVS(462)*UV(91)+JVS(463)*UV(93)+JVS(464)*UV(94)+JVS(465)*UV(96)+JVS(466)*UV(97)&
              &+JVS(467)*UV(98)+JVS(468)*UV(99)+JVS(469)*UV(100)+JVS(471)*UV(102)+JVS(472)*UV(103)+JVS(473)*UV(104)+JVS(474)&
              &*UV(105)+JVS(476)*UV(107)
  JUV(94) = JVS(477)*UV(62)+JVS(478)*UV(74)+JVS(479)*UV(82)+JVS(481)*UV(85)+JVS(482)*UV(88)+JVS(484)*UV(90)+JVS(485)&
              &*UV(91)+JVS(486)*UV(94)+JVS(488)*UV(98)+JVS(489)*UV(100)+JVS(490)*UV(101)+JVS(492)*UV(103)
  JUV(95) = JVS(496)*UV(68)+JVS(497)*UV(70)+JVS(498)*UV(71)+JVS(499)*UV(78)+JVS(500)*UV(81)+JVS(501)*UV(83)+JVS(503)&
              &*UV(85)+JVS(504)*UV(86)+JVS(505)*UV(87)+JVS(506)*UV(90)+JVS(507)*UV(91)+JVS(508)*UV(94)+JVS(509)*UV(95)&
              &+JVS(510)*UV(96)+JVS(511)*UV(97)+JVS(512)*UV(98)+JVS(513)*UV(99)+JVS(514)*UV(100)+JVS(516)*UV(102)+JVS(517)&
              &*UV(103)+JVS(519)*UV(105)+JVS(520)*UV(106)+JVS(521)*UV(107)
  JUV(96) = JVS(522)*UV(59)+JVS(524)*UV(81)+JVS(525)*UV(83)+JVS(527)*UV(85)+JVS(528)*UV(86)+JVS(529)*UV(87)+JVS(530)&
              &*UV(90)+JVS(531)*UV(91)+JVS(532)*UV(96)+JVS(533)*UV(97)+JVS(534)*UV(98)+JVS(535)*UV(99)+JVS(536)*UV(100)&
              &+JVS(537)*UV(101)+JVS(538)*UV(102)+JVS(539)*UV(103)+JVS(540)*UV(105)+JVS(541)*UV(106)
  JUV(97) = JVS(542)*UV(51)+JVS(543)*UV(64)+JVS(544)*UV(76)+JVS(545)*UV(81)+JVS(547)*UV(91)+JVS(548)*UV(93)+JVS(550)&
              &*UV(96)+JVS(551)*UV(97)+JVS(552)*UV(98)+JVS(553)*UV(99)+JVS(554)*UV(100)+JVS(555)*UV(101)+JVS(556)*UV(102)&
              &+JVS(557)*UV(103)+JVS(558)*UV(104)+JVS(559)*UV(105)+JVS(560)*UV(106)+JVS(561)*UV(107)
  JUV(98) = JVS(562)*UV(50)+JVS(563)*UV(52)+JVS(564)*UV(53)+JVS(565)*UV(54)+JVS(566)*UV(55)+JVS(567)*UV(57)+JVS(568)&
              &*UV(58)+JVS(569)*UV(59)+JVS(570)*UV(60)+JVS(571)*UV(61)+JVS(572)*UV(63)+JVS(573)*UV(64)+JVS(574)*UV(65)&
              &+JVS(575)*UV(66)+JVS(576)*UV(67)+JVS(577)*UV(68)+JVS(578)*UV(69)+JVS(579)*UV(70)+JVS(581)*UV(72)+JVS(582)&
              &*UV(73)+JVS(584)*UV(76)+JVS(585)*UV(77)+JVS(586)*UV(78)+JVS(587)*UV(79)+JVS(588)*UV(80)+JVS(589)*UV(81)&
              &+JVS(590)*UV(83)+JVS(591)*UV(84)+JVS(592)*UV(85)+JVS(593)*UV(86)+JVS(594)*UV(87)+JVS(596)*UV(89)+JVS(597)&
              &*UV(90)+JVS(598)*UV(91)+JVS(599)*UV(92)+JVS(600)*UV(93)+JVS(601)*UV(94)+JVS(602)*UV(95)+JVS(603)*UV(96)&
              &+JVS(605)*UV(98)+JVS(607)*UV(100)+JVS(608)*UV(101)+JVS(610)*UV(103)+JVS(612)*UV(105)+JVS(613)*UV(106)
  JUV(99) = JVS(615)*UV(66)+JVS(616)*UV(85)+JVS(617)*UV(90)+JVS(618)*UV(91)+JVS(619)*UV(92)+JVS(621)*UV(96)+JVS(622)&
              &*UV(97)+JVS(623)*UV(98)+JVS(624)*UV(99)+JVS(625)*UV(100)+JVS(626)*UV(101)+JVS(627)*UV(102)+JVS(628)*UV(103)&
              &+JVS(629)*UV(104)+JVS(630)*UV(105)+JVS(631)*UV(106)+JVS(632)*UV(107)
  JUV(100) = JVS(633)*UV(60)+JVS(634)*UV(62)+JVS(635)*UV(71)+JVS(636)*UV(75)+JVS(637)*UV(88)+JVS(639)*UV(90)+JVS(643)&
               &*UV(96)+JVS(644)*UV(97)+JVS(645)*UV(98)+JVS(646)*UV(99)+JVS(647)*UV(100)+JVS(648)*UV(101)+JVS(650)*UV(103)&
               &+JVS(651)*UV(104)+JVS(652)*UV(105)+JVS(653)*UV(106)+JVS(654)*UV(107)
  JUV(101) = JVS(655)*UV(51)+JVS(656)*UV(56)+JVS(657)*UV(60)+JVS(658)*UV(62)+JVS(659)*UV(63)+JVS(660)*UV(66)+JVS(661)&
               &*UV(71)+JVS(662)*UV(74)+JVS(663)*UV(75)+JVS(664)*UV(79)+JVS(665)*UV(82)+JVS(666)*UV(83)+JVS(668)*UV(85)&
               &+JVS(669)*UV(86)+JVS(670)*UV(87)+JVS(672)*UV(90)+JVS(676)*UV(94)+JVS(678)*UV(96)+JVS(679)*UV(97)+JVS(680)&
               &*UV(98)+JVS(681)*UV(99)+JVS(682)*UV(100)+JVS(683)*UV(101)+JVS(685)*UV(103)+JVS(686)*UV(104)+JVS(687)*UV(105)&
               &+JVS(688)*UV(106)+JVS(689)*UV(107)
  JUV(102) = JVS(690)*UV(49)+JVS(691)*UV(52)+JVS(692)*UV(58)+JVS(693)*UV(67)+JVS(694)*UV(68)+JVS(695)*UV(70)+JVS(696)&
               &*UV(72)+JVS(697)*UV(75)+JVS(698)*UV(77)+JVS(699)*UV(83)+JVS(700)*UV(86)+JVS(701)*UV(87)+JVS(702)*UV(89)&
               &+JVS(703)*UV(90)+JVS(705)*UV(92)+JVS(706)*UV(93)+JVS(708)*UV(95)+JVS(709)*UV(96)+JVS(711)*UV(98)+JVS(713)&
               &*UV(100)+JVS(715)*UV(102)
  JUV(103) = JVS(721)*UV(56)+JVS(722)*UV(63)+JVS(723)*UV(79)+JVS(724)*UV(83)+JVS(725)*UV(84)+JVS(726)*UV(85)+JVS(727)&
               &*UV(86)+JVS(728)*UV(87)+JVS(729)*UV(90)+JVS(730)*UV(91)+JVS(731)*UV(92)+JVS(732)*UV(93)+JVS(734)*UV(95)&
               &+JVS(735)*UV(96)+JVS(737)*UV(98)+JVS(739)*UV(100)+JVS(740)*UV(101)+JVS(742)*UV(103)+JVS(744)*UV(105)&
               &+JVS(745)*UV(106)
  JUV(104) = JVS(747)*UV(53)+JVS(748)*UV(57)+JVS(749)*UV(67)+JVS(750)*UV(70)+JVS(751)*UV(73)+JVS(752)*UV(76)+JVS(753)&
               &*UV(78)+JVS(754)*UV(81)+JVS(755)*UV(82)+JVS(756)*UV(83)+JVS(757)*UV(84)+JVS(758)*UV(85)+JVS(759)*UV(86)&
               &+JVS(760)*UV(87)+JVS(761)*UV(88)+JVS(762)*UV(89)+JVS(763)*UV(90)+JVS(764)*UV(91)+JVS(767)*UV(96)+JVS(768)&
               &*UV(97)+JVS(769)*UV(98)+JVS(770)*UV(99)+JVS(771)*UV(100)+JVS(772)*UV(101)+JVS(773)*UV(102)+JVS(774)*UV(103)&
               &+JVS(775)*UV(104)+JVS(776)*UV(105)+JVS(777)*UV(106)+JVS(778)*UV(107)
  JUV(105) = JVS(779)*UV(55)+JVS(780)*UV(69)+JVS(781)*UV(83)+JVS(782)*UV(85)+JVS(783)*UV(86)+JVS(784)*UV(87)+JVS(785)&
               &*UV(90)+JVS(786)*UV(92)+JVS(787)*UV(93)+JVS(789)*UV(95)+JVS(790)*UV(96)+JVS(792)*UV(98)+JVS(794)*UV(100)&
               &+JVS(795)*UV(101)+JVS(797)*UV(103)+JVS(799)*UV(105)+JVS(800)*UV(106)
  JUV(106) = JVS(802)*UV(50)+JVS(803)*UV(53)+JVS(804)*UV(54)+JVS(805)*UV(55)+JVS(806)*UV(57)+JVS(807)*UV(61)+JVS(808)&
               &*UV(62)+JVS(809)*UV(63)+JVS(810)*UV(67)+JVS(811)*UV(68)+JVS(812)*UV(69)+JVS(813)*UV(70)+JVS(814)*UV(71)&
               &+JVS(815)*UV(73)+JVS(816)*UV(74)+JVS(817)*UV(75)+JVS(818)*UV(76)+JVS(819)*UV(77)+JVS(820)*UV(78)+JVS(821)&
               &*UV(80)+JVS(822)*UV(81)+JVS(823)*UV(82)+JVS(824)*UV(83)+JVS(825)*UV(84)+JVS(826)*UV(85)+JVS(827)*UV(86)&
               &+JVS(828)*UV(87)+JVS(829)*UV(88)+JVS(830)*UV(89)+JVS(831)*UV(90)+JVS(832)*UV(91)+JVS(833)*UV(92)+JVS(834)&
               &*UV(93)+JVS(835)*UV(94)+JVS(836)*UV(95)+JVS(837)*UV(96)+JVS(838)*UV(97)+JVS(839)*UV(98)+JVS(840)*UV(99)&
               &+JVS(841)*UV(100)+JVS(842)*UV(101)+JVS(843)*UV(102)+JVS(844)*UV(103)+JVS(845)*UV(104)+JVS(846)*UV(105)&
               &+JVS(847)*UV(106)+JVS(848)*UV(107)
  JUV(107) = JVS(849)*UV(58)+JVS(850)*UV(64)+JVS(851)*UV(65)+JVS(852)*UV(78)+JVS(853)*UV(92)+JVS(854)*UV(93)+JVS(858)&
               &*UV(97)+JVS(859)*UV(98)+JVS(860)*UV(99)+JVS(861)*UV(100)+JVS(863)*UV(102)+JVS(865)*UV(104)+JVS(867)*UV(106)&
               &+JVS(868)*UV(107)
      
END SUBROUTINE Jac_SP_Vec

! End of Jac_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacTR_SP_Vec - sparse multiplication: sparse Jacobian transposed times vector
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      UV        - User vector for variables
!      JTUV      - Jacobian transposed times user vector
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacTR_SP_Vec ( JVS, UV, JTUV )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! UV - User vector for variables
  REAL(kind=dp) :: UV(NVAR)
! JTUV - Jacobian transposed times user vector
  REAL(kind=dp) :: JTUV(NVAR)

  JTUV(1) = JVS(1)*UV(1)
  JTUV(2) = JVS(4)*UV(2)
  JTUV(3) = JVS(7)*UV(3)
  JTUV(4) = JVS(11)*UV(4)
  JTUV(5) = JVS(14)*UV(5)
  JTUV(6) = JVS(17)*UV(6)
  JTUV(7) = JVS(23)*UV(7)
  JTUV(8) = JVS(29)*UV(8)
  JTUV(9) = JVS(32)*UV(9)
  JTUV(10) = JVS(35)*UV(10)
  JTUV(11) = JVS(41)*UV(11)
  JTUV(12) = JVS(42)*UV(11)+JVS(44)*UV(12)
  JTUV(13) = JVS(46)*UV(13)
  JTUV(14) = JVS(49)*UV(14)
  JTUV(15) = JVS(47)*UV(13)+JVS(50)*UV(14)+JVS(52)*UV(15)
  JTUV(16) = JVS(54)*UV(16)
  JTUV(17) = JVS(57)*UV(17)
  JTUV(18) = JVS(55)*UV(16)+JVS(58)*UV(17)+JVS(60)*UV(18)
  JTUV(19) = JVS(62)*UV(19)
  JTUV(20) = JVS(65)*UV(20)
  JTUV(21) = JVS(68)*UV(21)
  JTUV(22) = JVS(71)*UV(22)
  JTUV(23) = JVS(63)*UV(19)+JVS(66)*UV(20)+JVS(69)*UV(21)+JVS(72)*UV(22)+JVS(74)*UV(23)
  JTUV(24) = JVS(77)*UV(24)
  JTUV(25) = JVS(80)*UV(25)
  JTUV(26) = JVS(83)*UV(26)
  JTUV(27) = JVS(86)*UV(27)
  JTUV(28) = JVS(89)*UV(28)
  JTUV(29) = JVS(78)*UV(24)+JVS(81)*UV(25)+JVS(84)*UV(26)+JVS(87)*UV(27)+JVS(90)*UV(28)+JVS(92)*UV(29)
  JTUV(30) = JVS(96)*UV(30)
  JTUV(31) = JVS(99)*UV(31)
  JTUV(32) = JVS(97)*UV(30)+JVS(100)*UV(31)+JVS(102)*UV(32)
  JTUV(33) = JVS(104)*UV(33)
  JTUV(34) = JVS(105)*UV(33)+JVS(107)*UV(34)
  JTUV(35) = JVS(109)*UV(35)
  JTUV(36) = JVS(112)*UV(36)
  JTUV(37) = JVS(110)*UV(35)+JVS(113)*UV(36)+JVS(115)*UV(37)
  JTUV(38) = JVS(117)*UV(38)
  JTUV(39) = JVS(122)*UV(39)
  JTUV(40) = JVS(123)*UV(39)+JVS(125)*UV(40)
  JTUV(41) = JVS(126)*UV(40)+JVS(128)*UV(41)
  JTUV(42) = JVS(129)*UV(41)+JVS(131)*UV(42)
  JTUV(43) = JVS(133)*UV(43)
  JTUV(44) = JVS(134)*UV(43)+JVS(136)*UV(44)
  JTUV(45) = JVS(137)*UV(44)+JVS(139)*UV(45)
  JTUV(46) = JVS(140)*UV(45)+JVS(142)*UV(46)
  JTUV(47) = JVS(144)*UV(47)
  JTUV(48) = JVS(147)*UV(48)
  JTUV(49) = JVS(171)*UV(49)+JVS(690)*UV(102)
  JTUV(50) = JVS(30)*UV(8)+JVS(33)*UV(9)+JVS(173)*UV(50)+JVS(562)*UV(98)+JVS(802)*UV(106)
  JTUV(51) = JVS(175)*UV(51)+JVS(542)*UV(97)+JVS(655)*UV(101)
  JTUV(52) = JVS(178)*UV(52)+JVS(563)*UV(98)+JVS(691)*UV(102)
  JTUV(53) = JVS(2)*UV(1)+JVS(5)*UV(2)+JVS(148)*UV(48)+JVS(181)*UV(53)+JVS(212)*UV(62)+JVS(354)*UV(84)+JVS(564)*UV(98)&
               &+JVS(747)*UV(104)+JVS(803)*UV(106)
  JTUV(54) = JVS(183)*UV(54)+JVS(186)*UV(55)+JVS(565)*UV(98)+JVS(804)*UV(106)
  JTUV(55) = JVS(184)*UV(54)+JVS(187)*UV(55)+JVS(566)*UV(98)+JVS(779)*UV(105)+JVS(805)*UV(106)
  JTUV(56) = JVS(190)*UV(56)+JVS(307)*UV(79)+JVS(656)*UV(101)+JVS(721)*UV(103)
  JTUV(57) = JVS(12)*UV(4)+JVS(15)*UV(5)+JVS(149)*UV(48)+JVS(193)*UV(57)+JVS(213)*UV(62)+JVS(287)*UV(76)+JVS(355)*UV(84)&
               &+JVS(398)*UV(89)+JVS(567)*UV(98)+JVS(748)*UV(104)+JVS(806)*UV(106)
  JTUV(58) = JVS(195)*UV(58)+JVS(257)*UV(72)+JVS(568)*UV(98)+JVS(692)*UV(102)+JVS(849)*UV(107)
  JTUV(59) = JVS(118)*UV(38)+JVS(198)*UV(59)+JVS(244)*UV(69)+JVS(522)*UV(96)+JVS(569)*UV(98)
  JTUV(60) = JVS(202)*UV(60)+JVS(570)*UV(98)+JVS(633)*UV(100)+JVS(657)*UV(101)
  JTUV(61) = JVS(150)*UV(48)+JVS(206)*UV(61)+JVS(571)*UV(98)+JVS(807)*UV(106)
  JTUV(62) = JVS(214)*UV(62)+JVS(337)*UV(81)+JVS(356)*UV(84)+JVS(477)*UV(94)+JVS(634)*UV(100)+JVS(658)*UV(101)+JVS(808)&
               &*UV(106)
  JTUV(63) = JVS(217)*UV(63)+JVS(572)*UV(98)+JVS(659)*UV(101)+JVS(722)*UV(103)+JVS(809)*UV(106)
  JTUV(64) = JVS(151)*UV(48)+JVS(221)*UV(64)+JVS(543)*UV(97)+JVS(573)*UV(98)+JVS(850)*UV(107)
  JTUV(65) = JVS(152)*UV(48)+JVS(226)*UV(65)+JVS(574)*UV(98)+JVS(851)*UV(107)
  JTUV(66) = JVS(233)*UV(66)+JVS(452)*UV(93)+JVS(575)*UV(98)+JVS(615)*UV(99)+JVS(660)*UV(101)
  JTUV(67) = JVS(153)*UV(48)+JVS(237)*UV(67)+JVS(258)*UV(72)+JVS(382)*UV(88)+JVS(453)*UV(93)+JVS(576)*UV(98)+JVS(693)&
               &*UV(102)+JVS(749)*UV(104)+JVS(810)*UV(106)
  JTUV(68) = JVS(154)*UV(48)+JVS(240)*UV(68)+JVS(259)*UV(72)+JVS(496)*UV(95)+JVS(577)*UV(98)+JVS(694)*UV(102)+JVS(811)&
               &*UV(106)
  JTUV(69) = JVS(119)*UV(38)+JVS(199)*UV(59)+JVS(245)*UV(69)+JVS(578)*UV(98)+JVS(780)*UV(105)+JVS(812)*UV(106)
  JTUV(70) = JVS(155)*UV(48)+JVS(250)*UV(70)+JVS(260)*UV(72)+JVS(428)*UV(92)+JVS(454)*UV(93)+JVS(497)*UV(95)+JVS(579)&
               &*UV(98)+JVS(695)*UV(102)+JVS(750)*UV(104)+JVS(813)*UV(106)
  JTUV(71) = JVS(207)*UV(61)+JVS(253)*UV(71)+JVS(300)*UV(78)+JVS(498)*UV(95)+JVS(635)*UV(100)+JVS(661)*UV(101)+JVS(814)&
               &*UV(106)
  JTUV(72) = JVS(261)*UV(72)+JVS(581)*UV(98)+JVS(696)*UV(102)
  JTUV(73) = JVS(271)*UV(73)+JVS(429)*UV(92)+JVS(455)*UV(93)+JVS(582)*UV(98)+JVS(751)*UV(104)+JVS(815)*UV(106)
  JTUV(74) = JVS(276)*UV(74)+JVS(357)*UV(84)+JVS(478)*UV(94)+JVS(662)*UV(101)+JVS(816)*UV(106)
  JTUV(75) = JVS(172)*UV(49)+JVS(179)*UV(52)+JVS(282)*UV(75)+JVS(636)*UV(100)+JVS(663)*UV(101)+JVS(697)*UV(102)+JVS(817)&
               &*UV(106)
  JTUV(76) = JVS(156)*UV(48)+JVS(288)*UV(76)+JVS(319)*UV(80)+JVS(544)*UV(97)+JVS(584)*UV(98)+JVS(752)*UV(104)+JVS(818)&
               &*UV(106)
  JTUV(77) = JVS(293)*UV(77)+JVS(320)*UV(80)+JVS(585)*UV(98)+JVS(698)*UV(102)+JVS(819)*UV(106)
  JTUV(78) = JVS(157)*UV(48)+JVS(301)*UV(78)+JVS(499)*UV(95)+JVS(586)*UV(98)+JVS(753)*UV(104)+JVS(820)*UV(106)+JVS(852)&
               &*UV(107)
  JTUV(79) = JVS(308)*UV(79)+JVS(587)*UV(98)+JVS(664)*UV(101)+JVS(723)*UV(103)
  JTUV(80) = JVS(145)*UV(47)+JVS(321)*UV(80)+JVS(588)*UV(98)+JVS(821)*UV(106)
  JTUV(81) = JVS(158)*UV(48)+JVS(289)*UV(76)+JVS(322)*UV(80)+JVS(338)*UV(81)+JVS(430)*UV(92)+JVS(500)*UV(95)+JVS(524)&
               &*UV(96)+JVS(545)*UV(97)+JVS(589)*UV(98)+JVS(754)*UV(104)+JVS(822)*UV(106)
  JTUV(82) = JVS(343)*UV(82)+JVS(383)*UV(88)+JVS(399)*UV(89)+JVS(431)*UV(92)+JVS(456)*UV(93)+JVS(479)*UV(94)+JVS(665)&
               &*UV(101)+JVS(755)*UV(104)+JVS(823)*UV(106)
  JTUV(83) = JVS(159)*UV(48)+JVS(208)*UV(61)+JVS(294)*UV(77)+JVS(323)*UV(80)+JVS(348)*UV(83)+JVS(432)*UV(92)+JVS(501)&
               &*UV(95)+JVS(525)*UV(96)+JVS(590)*UV(98)+JVS(666)*UV(101)+JVS(699)*UV(102)+JVS(724)*UV(103)+JVS(756)*UV(104)&
               &+JVS(781)*UV(105)+JVS(824)*UV(106)
  JTUV(84) = JVS(8)*UV(3)+JVS(160)*UV(48)+JVS(277)*UV(74)+JVS(309)*UV(79)+JVS(339)*UV(81)+JVS(358)*UV(84)+JVS(591)&
               &*UV(98)+JVS(725)*UV(103)+JVS(757)*UV(104)+JVS(825)*UV(106)
  JTUV(85) = JVS(36)*UV(10)+JVS(161)*UV(48)+JVS(324)*UV(80)+JVS(364)*UV(85)+JVS(384)*UV(88)+JVS(400)*UV(89)+JVS(434)&
               &*UV(92)+JVS(481)*UV(94)+JVS(503)*UV(95)+JVS(527)*UV(96)+JVS(592)*UV(98)+JVS(616)*UV(99)+JVS(668)*UV(101)&
               &+JVS(726)*UV(103)+JVS(758)*UV(104)+JVS(782)*UV(105)+JVS(826)*UV(106)
  JTUV(86) = JVS(162)*UV(48)+JVS(262)*UV(72)+JVS(295)*UV(77)+JVS(325)*UV(80)+JVS(369)*UV(86)+JVS(375)*UV(87)+JVS(401)&
               &*UV(89)+JVS(435)*UV(92)+JVS(457)*UV(93)+JVS(504)*UV(95)+JVS(528)*UV(96)+JVS(593)*UV(98)+JVS(669)*UV(101)&
               &+JVS(700)*UV(102)+JVS(727)*UV(103)+JVS(759)*UV(104)+JVS(783)*UV(105)+JVS(827)*UV(106)
  JTUV(87) = JVS(163)*UV(48)+JVS(296)*UV(77)+JVS(326)*UV(80)+JVS(376)*UV(87)+JVS(385)*UV(88)+JVS(402)*UV(89)+JVS(436)&
               &*UV(92)+JVS(458)*UV(93)+JVS(505)*UV(95)+JVS(529)*UV(96)+JVS(594)*UV(98)+JVS(670)*UV(101)+JVS(701)*UV(102)&
               &+JVS(728)*UV(103)+JVS(760)*UV(104)+JVS(784)*UV(105)+JVS(828)*UV(106)
  JTUV(88) = JVS(272)*UV(73)+JVS(386)*UV(88)+JVS(482)*UV(94)+JVS(637)*UV(100)+JVS(761)*UV(104)+JVS(829)*UV(106)
  JTUV(89) = JVS(164)*UV(48)+JVS(263)*UV(72)+JVS(344)*UV(82)+JVS(387)*UV(88)+JVS(403)*UV(89)+JVS(438)*UV(92)+JVS(460)&
               &*UV(93)+JVS(596)*UV(98)+JVS(702)*UV(102)+JVS(762)*UV(104)+JVS(830)*UV(106)
  JTUV(90) = JVS(18)*UV(6)+JVS(24)*UV(7)+JVS(165)*UV(48)+JVS(264)*UV(72)+JVS(297)*UV(77)+JVS(327)*UV(80)+JVS(388)*UV(88)&
               &+JVS(404)*UV(89)+JVS(413)*UV(90)+JVS(420)*UV(91)+JVS(439)*UV(92)+JVS(484)*UV(94)+JVS(506)*UV(95)+JVS(530)&
               &*UV(96)+JVS(597)*UV(98)+JVS(617)*UV(99)+JVS(639)*UV(100)+JVS(672)*UV(101)+JVS(703)*UV(102)+JVS(729)*UV(103)&
               &+JVS(763)*UV(104)+JVS(785)*UV(105)+JVS(831)*UV(106)
  JTUV(91) = JVS(166)*UV(48)+JVS(290)*UV(76)+JVS(310)*UV(79)+JVS(328)*UV(80)+JVS(405)*UV(89)+JVS(421)*UV(91)+JVS(440)&
               &*UV(92)+JVS(462)*UV(93)+JVS(485)*UV(94)+JVS(507)*UV(95)+JVS(531)*UV(96)+JVS(547)*UV(97)+JVS(598)*UV(98)&
               &+JVS(618)*UV(99)+JVS(730)*UV(103)+JVS(764)*UV(104)+JVS(832)*UV(106)
  JTUV(92) = JVS(167)*UV(48)+JVS(265)*UV(72)+JVS(311)*UV(79)+JVS(329)*UV(80)+JVS(441)*UV(92)+JVS(599)*UV(98)+JVS(619)&
               &*UV(99)+JVS(705)*UV(102)+JVS(731)*UV(103)+JVS(786)*UV(105)+JVS(833)*UV(106)+JVS(853)*UV(107)
  JTUV(93) = JVS(168)*UV(48)+JVS(266)*UV(72)+JVS(312)*UV(79)+JVS(330)*UV(80)+JVS(463)*UV(93)+JVS(548)*UV(97)+JVS(600)&
               &*UV(98)+JVS(706)*UV(102)+JVS(732)*UV(103)+JVS(787)*UV(105)+JVS(834)*UV(106)+JVS(854)*UV(107)
  JTUV(94) = JVS(313)*UV(79)+JVS(406)*UV(89)+JVS(442)*UV(92)+JVS(464)*UV(93)+JVS(486)*UV(94)+JVS(508)*UV(95)+JVS(601)&
               &*UV(98)+JVS(676)*UV(101)+JVS(835)*UV(106)
  JTUV(95) = JVS(169)*UV(48)+JVS(254)*UV(71)+JVS(267)*UV(72)+JVS(314)*UV(79)+JVS(331)*UV(80)+JVS(509)*UV(95)+JVS(602)&
               &*UV(98)+JVS(708)*UV(102)+JVS(734)*UV(103)+JVS(789)*UV(105)+JVS(836)*UV(106)
  JTUV(96) = JVS(19)*UV(6)+JVS(25)*UV(7)+JVS(37)*UV(10)+JVS(70)*UV(21)+JVS(73)*UV(22)+JVS(75)*UV(23)+JVS(85)*UV(26)&
               &+JVS(88)*UV(27)+JVS(93)*UV(29)+JVS(120)*UV(38)+JVS(188)*UV(55)+JVS(200)*UV(59)+JVS(209)*UV(61)+JVS(283)&
               &*UV(75)+JVS(291)*UV(76)+JVS(332)*UV(80)+JVS(340)*UV(81)+JVS(349)*UV(83)+JVS(365)*UV(85)+JVS(370)*UV(86)&
               &+JVS(377)*UV(87)+JVS(389)*UV(88)+JVS(407)*UV(89)+JVS(414)*UV(90)+JVS(422)*UV(91)+JVS(443)*UV(92)+JVS(465)&
               &*UV(93)+JVS(510)*UV(95)+JVS(532)*UV(96)+JVS(550)*UV(97)+JVS(603)*UV(98)+JVS(621)*UV(99)+JVS(643)*UV(100)&
               &+JVS(678)*UV(101)+JVS(709)*UV(102)+JVS(735)*UV(103)+JVS(767)*UV(104)+JVS(790)*UV(105)+JVS(837)*UV(106)
  JTUV(97) = JVS(176)*UV(51)+JVS(222)*UV(64)+JVS(227)*UV(65)+JVS(466)*UV(93)+JVS(511)*UV(95)+JVS(533)*UV(96)+JVS(551)&
               &*UV(97)+JVS(622)*UV(99)+JVS(644)*UV(100)+JVS(679)*UV(101)+JVS(768)*UV(104)+JVS(838)*UV(106)+JVS(858)*UV(107)
  JTUV(98) = JVS(3)*UV(1)+JVS(6)*UV(2)+JVS(9)*UV(3)+JVS(13)*UV(4)+JVS(16)*UV(5)+JVS(20)*UV(6)+JVS(26)*UV(7)+JVS(31)&
               &*UV(8)+JVS(34)*UV(9)+JVS(38)*UV(10)+JVS(43)*UV(11)+JVS(45)*UV(12)+JVS(48)*UV(13)+JVS(51)*UV(14)+JVS(53)&
               &*UV(15)+JVS(56)*UV(16)+JVS(59)*UV(17)+JVS(61)*UV(18)+JVS(64)*UV(19)+JVS(67)*UV(20)+JVS(76)*UV(23)+JVS(79)&
               &*UV(24)+JVS(82)*UV(25)+JVS(94)*UV(29)+JVS(98)*UV(30)+JVS(101)*UV(31)+JVS(103)*UV(32)+JVS(106)*UV(33)&
               &+JVS(108)*UV(34)+JVS(111)*UV(35)+JVS(114)*UV(36)+JVS(116)*UV(37)+JVS(121)*UV(38)+JVS(124)*UV(39)+JVS(127)&
               &*UV(40)+JVS(130)*UV(41)+JVS(132)*UV(42)+JVS(135)*UV(43)+JVS(138)*UV(44)+JVS(141)*UV(45)+JVS(143)*UV(46)&
               &+JVS(146)*UV(47)+JVS(170)*UV(48)+JVS(174)*UV(50)+JVS(182)*UV(53)+JVS(185)*UV(54)+JVS(194)*UV(57)+JVS(196)&
               &*UV(58)+JVS(201)*UV(59)+JVS(203)*UV(60)+JVS(210)*UV(61)+JVS(215)*UV(62)+JVS(218)*UV(63)+JVS(223)*UV(64)&
               &+JVS(228)*UV(65)+JVS(234)*UV(66)+JVS(238)*UV(67)+JVS(241)*UV(68)+JVS(247)*UV(69)+JVS(251)*UV(70)+JVS(268)&
               &*UV(72)+JVS(273)*UV(73)+JVS(278)*UV(74)+JVS(292)*UV(76)+JVS(298)*UV(77)+JVS(303)*UV(78)+JVS(315)*UV(79)&
               &+JVS(333)*UV(80)+JVS(341)*UV(81)+JVS(345)*UV(82)+JVS(350)*UV(83)+JVS(359)*UV(84)+JVS(366)*UV(85)+JVS(371)&
               &*UV(86)+JVS(378)*UV(87)+JVS(390)*UV(88)+JVS(408)*UV(89)+JVS(415)*UV(90)+JVS(423)*UV(91)+JVS(444)*UV(92)&
               &+JVS(467)*UV(93)+JVS(488)*UV(94)+JVS(512)*UV(95)+JVS(534)*UV(96)+JVS(552)*UV(97)+JVS(605)*UV(98)+JVS(623)&
               &*UV(99)+JVS(645)*UV(100)+JVS(680)*UV(101)+JVS(711)*UV(102)+JVS(737)*UV(103)+JVS(769)*UV(104)+JVS(792)&
               &*UV(105)+JVS(839)*UV(106)+JVS(859)*UV(107)
  JTUV(99) = JVS(224)*UV(64)+JVS(229)*UV(65)+JVS(235)*UV(66)+JVS(468)*UV(93)+JVS(513)*UV(95)+JVS(535)*UV(96)+JVS(553)&
               &*UV(97)+JVS(624)*UV(99)+JVS(646)*UV(100)+JVS(681)*UV(101)+JVS(770)*UV(104)+JVS(840)*UV(106)+JVS(860)*UV(107)
  JTUV(100) = JVS(204)*UV(60)+JVS(211)*UV(61)+JVS(216)*UV(62)+JVS(255)*UV(71)+JVS(284)*UV(75)+JVS(342)*UV(81)+JVS(391)&
                &*UV(88)+JVS(469)*UV(93)+JVS(489)*UV(94)+JVS(514)*UV(95)+JVS(536)*UV(96)+JVS(554)*UV(97)+JVS(607)*UV(98)&
                &+JVS(625)*UV(99)+JVS(647)*UV(100)+JVS(682)*UV(101)+JVS(713)*UV(102)+JVS(739)*UV(103)+JVS(771)*UV(104)&
                &+JVS(794)*UV(105)+JVS(841)*UV(106)+JVS(861)*UV(107)
  JTUV(101) = JVS(177)*UV(51)+JVS(191)*UV(56)+JVS(205)*UV(60)+JVS(219)*UV(63)+JVS(236)*UV(66)+JVS(279)*UV(74)+JVS(316)&
                &*UV(79)+JVS(346)*UV(82)+JVS(409)*UV(89)+JVS(416)*UV(90)+JVS(424)*UV(91)+JVS(446)*UV(92)+JVS(490)*UV(94)&
                &+JVS(537)*UV(96)+JVS(555)*UV(97)+JVS(608)*UV(98)+JVS(626)*UV(99)+JVS(648)*UV(100)+JVS(683)*UV(101)+JVS(740)&
                &*UV(103)+JVS(772)*UV(104)+JVS(795)*UV(105)+JVS(842)*UV(106)
  JTUV(102) = JVS(197)*UV(58)+JVS(239)*UV(67)+JVS(242)*UV(68)+JVS(252)*UV(70)+JVS(269)*UV(72)+JVS(285)*UV(75)+JVS(299)&
                &*UV(77)+JVS(334)*UV(80)+JVS(347)*UV(82)+JVS(351)*UV(83)+JVS(372)*UV(86)+JVS(379)*UV(87)+JVS(393)*UV(88)&
                &+JVS(410)*UV(89)+JVS(417)*UV(90)+JVS(425)*UV(91)+JVS(447)*UV(92)+JVS(471)*UV(93)+JVS(516)*UV(95)+JVS(538)&
                &*UV(96)+JVS(556)*UV(97)+JVS(627)*UV(99)+JVS(715)*UV(102)+JVS(773)*UV(104)+JVS(843)*UV(106)+JVS(863)*UV(107)
  JTUV(103) = JVS(10)*UV(3)+JVS(21)*UV(6)+JVS(27)*UV(7)+JVS(39)*UV(10)+JVS(91)*UV(28)+JVS(95)*UV(29)+JVS(192)*UV(56)&
                &+JVS(280)*UV(74)+JVS(317)*UV(79)+JVS(335)*UV(80)+JVS(352)*UV(83)+JVS(362)*UV(84)+JVS(367)*UV(85)+JVS(373)&
                &*UV(86)+JVS(380)*UV(87)+JVS(394)*UV(88)+JVS(411)*UV(89)+JVS(418)*UV(90)+JVS(426)*UV(91)+JVS(448)*UV(92)&
                &+JVS(472)*UV(93)+JVS(492)*UV(94)+JVS(517)*UV(95)+JVS(539)*UV(96)+JVS(557)*UV(97)+JVS(610)*UV(98)+JVS(628)&
                &*UV(99)+JVS(650)*UV(100)+JVS(685)*UV(101)+JVS(742)*UV(103)+JVS(774)*UV(104)+JVS(797)*UV(105)+JVS(844)&
                &*UV(106)
  JTUV(104) = JVS(230)*UV(65)+JVS(274)*UV(73)+JVS(395)*UV(88)+JVS(473)*UV(93)+JVS(558)*UV(97)+JVS(629)*UV(99)+JVS(651)&
                &*UV(100)+JVS(686)*UV(101)+JVS(775)*UV(104)+JVS(845)*UV(106)+JVS(865)*UV(107)
  JTUV(105) = JVS(22)*UV(6)+JVS(28)*UV(7)+JVS(40)*UV(10)+JVS(248)*UV(69)+JVS(336)*UV(80)+JVS(353)*UV(83)+JVS(368)*UV(85)&
                &+JVS(374)*UV(86)+JVS(381)*UV(87)+JVS(396)*UV(88)+JVS(412)*UV(89)+JVS(419)*UV(90)+JVS(427)*UV(91)+JVS(450)&
                &*UV(92)+JVS(474)*UV(93)+JVS(519)*UV(95)+JVS(540)*UV(96)+JVS(559)*UV(97)+JVS(612)*UV(98)+JVS(630)*UV(99)&
                &+JVS(652)*UV(100)+JVS(687)*UV(101)+JVS(744)*UV(103)+JVS(776)*UV(104)+JVS(799)*UV(105)+JVS(846)*UV(106)
  JTUV(106) = JVS(180)*UV(52)+JVS(220)*UV(63)+JVS(225)*UV(64)+JVS(231)*UV(65)+JVS(249)*UV(69)+JVS(256)*UV(71)+JVS(275)&
                &*UV(73)+JVS(281)*UV(74)+JVS(286)*UV(75)+JVS(305)*UV(78)+JVS(318)*UV(79)+JVS(363)*UV(84)+JVS(397)*UV(88)&
                &+JVS(520)*UV(95)+JVS(541)*UV(96)+JVS(560)*UV(97)+JVS(613)*UV(98)+JVS(631)*UV(99)+JVS(653)*UV(100)+JVS(688)&
                &*UV(101)+JVS(745)*UV(103)+JVS(777)*UV(104)+JVS(800)*UV(105)+JVS(847)*UV(106)+JVS(867)*UV(107)
  JTUV(107) = JVS(232)*UV(65)+JVS(243)*UV(68)+JVS(306)*UV(78)+JVS(476)*UV(93)+JVS(521)*UV(95)+JVS(561)*UV(97)+JVS(632)&
                &*UV(99)+JVS(654)*UV(100)+JVS(689)*UV(101)+JVS(778)*UV(104)+JVS(848)*UV(106)+JVS(868)*UV(107)
      
END SUBROUTINE JacTR_SP_Vec

! End of JacTR_SP_Vec function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE CB05TUCl_NCSU_Jacobian

