! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Initialization File
! 
! Generated by KPP-2.2.3 symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : CB05TUCl_NCSU_Initialize.f90
! Time                 : Thu Oct  8 08:21:46 2020
! Working directory    : /Users/lechriso/git/boxmox/boxmox/tmp_CB05TUCl_NCSU_13059_BOXMOX
! Equation file        : CB05TUCl_NCSU.kpp
! Output root filename : CB05TUCl_NCSU
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE CB05TUCl_NCSU_Initialize

  USE CB05TUCl_NCSU_Parameters, ONLY: dp, NVAR, NFIX
  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Initialize - function to initialize concentrations
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Initialize ( )


  USE CB05TUCl_NCSU_Global

  USE CB05TUCl_NCSU_Util

  INTEGER :: i
  REAL(kind=dp) :: x

  CFACTOR = 1.000000e+00_dp

  x = (1.0E-9)*CFACTOR
  DO i = 1, NVAR
    VAR(i) = x
  END DO

  x = (1.0E-9)*CFACTOR
  DO i = 1, NFIX
    FIX(i) = x
  END DO

! constant rate coefficients
  RCONST(114) = 1600
  RCONST(130) = 4.2
! END constant rate coefficients

! INLINED initializations


  IF (.NOT. llibrary) THEN

    ! Write version number to VERSION file
    CALL writeVersion()

    ! Initialization (time step, run length, etc.) happening
    ! in namelist BOXMOX.nml. Read it!
    CALL readConfig()

  ENDIF

  ! Check configuration values
  CALL checkConfig()



  ! BOXMOX defaults for global variables

  ! Environment.csv
  temp         =         293.15   ! K
  pres         =      101325.0    ! Pa
  dxdydz(:)    =           1.0    ! m

  ! Aerosol.csv
  AER_SAD      =           0.0    ! m^2 m^-3
  AER_R        =           1.0e-6 ! m

  ! Turbulent mixing
  Kturb        =           0.0    ! m2 s-1



  ! 1E-03 * (1.0/28.97) * 6.022e23 * air density
  c_m    = 2.078702e+19 * 1.25

  ! 1E-03 * (1.0/18.02) * 6.022e23 * air density, then times kg(water)/kg(air)
  c_h2o  = 3.341842e+19 * 1.25 * 0.010

  ! SO2 to sulfate conversion
  rtdat_ae_so2 = 1.0e-17


! End INLINED initializations

      
END SUBROUTINE Initialize

! End of Initialize function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE CB05TUCl_NCSU_Initialize

