# BOXMOX

**Box modeling extensions to KPP**

Documentation, user downloads, online tools and further information can be found [here](https://mbees.med.uni-augsburg.de/boxmodeling/).

This is the development repository. BOXMOX is an extension to KPP, hence it lives as part of KPP. For distribution, a patch against standard KPP is created, KPP is downloaded from the original location, and the code is patched. For testing, each commit creates a [downloadable distribution](https://git.rz.uni-augsburg.de/knotechr/boxmox/-/jobs/artifacts/master/download?job=boxmox_latest) which can used directly for testing.

Feel free to push merge requests and add issues if you should encounter any.

Please cite our work when BOXMOX use constituted a relevant contribution to your scientific work. The citation for BOXMOX is [Knote et al., Atm. Env., 2015](http://dx.doi.org/10.1016/j.atmosenv.2014.11.066).

## Code structure

`boxmox/`

Main KPP directory, patched and extended for BOXMOX.

`boxmox/boxmox/`

Additional data and code for BOXMOX.

`boxmox/boxmox/wrapper`

Main BOXMOX user code file.

`boxmox/boxmox/boxmox(_adjoint).f90`

KPP (adjoint) driver for BOXMOX.

`boxmox/boxmox/examples`

Test cases for BOXMOX usage.

[Christoph Knote](mailto:christoph.knote@med.uni-augsburg.de), [MBEES, Faculty of Medicine, University of Augsburg](https://mbees.med.uni-augsburg.de), Germany

## License statement

BOXMOX is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BOXMOX is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

