#!/bin/bash

boxmoxVersion=1.8
kppVersion=2.2.3
kppFile=kpp-2.2.3_Nov.2012.tar.gz

boxmoxDir=boxmox
kppDir=kpp-$kppVersion
wrkDir=patch_wrk_dir

prepScript=$(pwd)/prep_BOXMOX_src_directory.bash

patchName=$(pwd)/boxmox_${boxmoxVersion}_${kppVersion}.patch

tar xvzf $kppFile

# copy both directories here to have relative paths
rm -rf $wrkDir
mkdir -p $wrkDir

cp -r $boxmoxDir $wrkDir/boxmox
mv $kppDir $wrkDir/kpp

cd $wrkDir

bash ${prepScript} boxmox ${boxmoxVersion}

diff -rupwN kpp boxmox > ${patchName}

exit 0
