MODULE nml
  USE KPP_ROOT_Global

  !f2py real*8               :: TSTART, TEND, DT

  !f2py integer*8            :: iturb

  !f2py integer*8, parameter :: TURB_OPT_NONE, TURB_OPT_SPECIFIED
  !f2py integer*8, parameter :: TURB_OPT_VOLUME, TURB_OPT_TRACER

END MODULE nml

SUBROUTINE run

  USE KPP_ROOT_Model
  USE KPP_ROOT_Initialize, ONLY: Initialize

  KPP_REAL :: T, DVAL(NSPEC)
  KPP_REAL :: RSTATE(20)
  INTEGER :: IERR
  INTEGER :: i, tcount, ttot

  !~~~> Initialization

  STEPMIN = 0.0d0
  STEPMAX = 0.0d0

  DO i=1,NVAR
    RTOL(i) = 1.0d-4
    ATOL(i) = 1.0d-3
  END DO

  llibrary = .TRUE.

  CALL Initialize()

!  CALL UpdateEnvironment()

!  CALL readInput('InitialConditions.csv', NSPEC, SPC_NAMES, C, &
!                  InitialCondition)

  !~~~> Time loop
  T = TSTART
  tcount = 1
  ttot   = NINT((TEND - TSTART) / DT)
  kron: DO WHILE (T < TEND)

    TIME = T
    CALL GetMass( C, DVAL )

    WRITE(*,*) T, DT, TSTART, TEND

!    CALL UpdateEnvironment()
!    CALL UpdateAerosol()
!    CALL UpdatePhotolysisRates()

!    CALL UpdateKturb()

!    CALL readInput('Background.csv', NSPEC, SPC_NAMES, C, Mix, lzero=.TRUE.)
!    CALL readInput('Emissions.csv', NSPEC, SPC_NAMES, C, Emission)
!    CALL readInput('Deposition.csv', NSPEC, SPC_NAMES, C, Deposition)

    CALL Update_SUN()
    CALL Update_RCONST()

    CALL INTEGRATE( TIN = T, TOUT = T+DT, RSTATUS_U = RSTATE, &
      ICNTRL_U = (/ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 /), &
      IERR_U = IERR )
    T = RSTATE(1)

    tcount = tcount + 1

    IF (IERR < 0) THEN
      STOP 1
    ENDIF

  END DO kron
  !~~~> End Time loop

  CALL GetMass( C, DVAL )
  TIME = T

END SUBROUTINE run

PROGRAM dummy
END PROGRAM dummy
