import icartt
import pathlib

# load a new dataset from an existing file
wd = pathlib.Path(__file__).parent
ict = icartt.Dataset(
    wd / ".." / "example_data" / "expect_warn" / "AR_DC8_20050203_R0.ict"
)

# list variable names
[x for x in ict.variables]

# independent, independent bounded, dependent, auxiliary variables?
print(f"Independent variable: {ict.independentVariable.shortname}")
print(f"Independent bounded variable: {ict.independentBoundedVariable.shortname}")
print(f"Auxiliary variables: {', '.join([ x for x in ict.auxiliaryVariables])}")
print(f"Dependent variables: {', '.join([ x for x in ict.dependentVariables])}")

# some info on a variable
print(f"Units of variable Latitude are {ict.variables['Latitude'].units}")
print(f"... and its missing value is {ict.variables['Latitude'].miss}")

# get steps for which data is available:
tsteps = [x for x in ict.data]

# let's look at the first time step data
print("First time step data:")
print(ict.data[tsteps[0]])

# auxiliary data at this time step:
print("First time step auxiliary data:")
print(ict.data[tsteps[0]]["AUX"][:])

# dependent data at this time step:
tstepdata = ict.data[tsteps[0]]["DEP"][:]

# get the ozone mixing ratio for those data where Altitude < 10000.0:
print(f"Ozone mixing ratio for altitudes < 10000 at time step {tsteps[0]}")
print(tstepdata[tstepdata["Altitude[]"] < 10000.0]["O3_MR[]"])
