import datetime

import numpy as np

import icartt

# ------------------------------------------------------
# Phase 1: define file format, properties and variables
# ------------------------------------------------------

ict = icartt.Dataset(format=icartt.Formats.FFI2110)

ict.PIName = "Knote, Christoph"
ict.PIAffiliation = "Faculty of Medicine, University Augsburg, Germany"
ict.dataSourceDescription = "Example data"
ict.missionName = "MBEES"
ict.dateOfCollection = datetime.datetime.utcnow().timetuple()[:3]
ict.dateOfRevision = datetime.datetime.utcnow().timetuple()[:3]

ict.dataIntervalCode = [0]

ict.independentVariable = icartt.Variable(
    "Time_Start",
    "seconds_from_0_hours_on_valid_date",
    "Time_Start",
    "Time_Start",
    vartype=icartt.VariableType.IndependentVariable,
    scale=1.0,
    miss=-9999999,
)

ict.independentBoundedVariable = icartt.Variable(
    "Altitude",
    "altitude_above_ground_in_meters",
    "Altitude",
    "Altitude",
    vartype=icartt.VariableType.IndependentBoundedVariable,
    scale=1.0,
    miss=-9999999,
)

# ICARTT convention: first aux variable contains number of dependent elements
ict.auxiliaryVariables["nAltitudes"] = icartt.Variable(
    "nAltitudes",
    "number_of_dependent_variable_items",
    "variable",
    "nAltitudes",
    scale=1.0,
    miss=-9999999,
)

ict.auxiliaryVariables["Time_Stop"] = icartt.Variable(
    "Time_Stop",
    "seconds_from_0_hours_on_valid_date",
    "Time_Stop",
    "Time_Stop",
    scale=1.0,
    miss=-9999999,
)

ict.auxiliaryVariables["Longitude"] = icartt.Variable(
    "Longitude",
    "longitude_in_degrees",
    "Longitude",
    "Longitude",
    scale=1.0,
    miss=-9999999,
)

ict.auxiliaryVariables["Latitude"] = icartt.Variable(
    "Latitude", "latitude_in_degrees", "Latitude", "Latitude", scale=1.0, miss=-9999999
)

ict.dependentVariables["Payload1"] = icartt.Variable(
    "Payload1", "some_units", "Payload1", "Payload1", scale=1.0, miss=-9999999
)

ict.dependentVariables["Payload2"] = icartt.Variable(
    "Payload2", "some_units", "Payload2", "Payload2", scale=1.0, miss=-9999999
)

ict.specialComments.append("Some comments on this dataset:")
ict.specialComments.append("They are just examples!")
ict.specialComments.append("Adapt as needed.")

ict.endDefineMode()

# ------------------------------------------------------
# Phase 2: after ending define mode, add data
# ------------------------------------------------------

import numpy as np

# same as for 1001, but data needs to be added in chunks for each ivar value

# note, the second variable ('4') is the number of dependent lines to follow
#                   ivar, ndepvar, auxvar1, auxvar2, auxvar3
auxData = np.array([(12.3, 4, 12.5, 48.21, 10.3)])
#                   ibvar,  dvar1,  dvar2  ... (repeat ndepvar times)
depData = np.array(
    [(0, 123, 8.4e4), (100, 122, 9.1e4), (250, 115, 9.3e4), (500, 106, 9.8e4)]
)

ict.data.add(auxData, depData)

# ... and so forth for the next chunk:

auxData = np.array([(12.4, 2, 12.8, 48.41, 12.1)])
#                   ibvar,  dvar1,  dvar2
depData = np.array([(0, 153, 7.3e4), (270, 172, 8.9e4)])

ict.data.add(auxData, depData)

# Now, look at it in ICARTT form:
ict.write()

# And you could simply write to file:
# with open('output.ict', 'w') as f:
#    ict.write(f=f)
